<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductionPartnerView2Search extends ProductionPartnerView2
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductionPartnerView2Search";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "productionpartnerview2search";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->name->setVisibility();
        $this->code->setVisibility();
        $this->category->setVisibility();
        $this->country->setVisibility();
        $this->region->setVisibility();
        $this->city->setVisibility();
        $this->address->setVisibility();
        $this->mobile->setVisibility();
        $this->_email->setVisibility();
        $this->tax_registration->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->reports_to->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'production_partner_view2';
        $this->TableName = 'production_partner_view';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (production_partner_view2)
        if (!isset($GLOBALS["production_partner_view2"]) || $GLOBALS["production_partner_view2"]::class == PROJECT_NAMESPACE . "production_partner_view2") {
            $GLOBALS["production_partner_view2"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'production_partner_view');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "productionpartnerview2view"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->country);
        $this->setupLookupOptions($this->region);
        $this->setupLookupOptions($this->city);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->reports_to);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "productionpartnerview2list" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->name); // name
        $this->buildSearchUrl($srchUrl, $this->code); // code
        $this->buildSearchUrl($srchUrl, $this->category); // category
        $this->buildSearchUrl($srchUrl, $this->country); // country
        $this->buildSearchUrl($srchUrl, $this->region); // region
        $this->buildSearchUrl($srchUrl, $this->city); // city
        $this->buildSearchUrl($srchUrl, $this->address); // address
        $this->buildSearchUrl($srchUrl, $this->mobile); // mobile
        $this->buildSearchUrl($srchUrl, $this->_email); // email
        $this->buildSearchUrl($srchUrl, $this->tax_registration); // tax_registration
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->reports_to); // reports_to
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // name
        if ($this->name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // code
        if ($this->code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // country
        if ($this->country->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // region
        if ($this->region->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // city
        if ($this->city->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // address
        if ($this->address->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // mobile
        if ($this->mobile->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // email
        if ($this->_email->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // tax_registration
        if ($this->tax_registration->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // reports_to
        if ($this->reports_to->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // country
        $this->country->RowCssClass = "row";

        // region
        $this->region->RowCssClass = "row";

        // city
        $this->city->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // tax_registration
        $this->tax_registration->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // code
            $this->code->ViewValue = $this->code->CurrentValue;

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // country
            $curVal = strval($this->country->CurrentValue);
            if ($curVal != "") {
                $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
                if ($this->country->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->country->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->country->Lookup->renderViewRow($rswrk[0]);
                        $this->country->ViewValue = $this->country->displayValue($arwrk);
                    } else {
                        $this->country->ViewValue = FormatNumber($this->country->CurrentValue, $this->country->formatPattern());
                    }
                }
            } else {
                $this->country->ViewValue = null;
            }

            // region
            $curVal = strval($this->region->CurrentValue);
            if ($curVal != "") {
                $this->region->ViewValue = $this->region->lookupCacheOption($curVal);
                if ($this->region->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->region->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->region->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->region->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->region->Lookup->renderViewRow($rswrk[0]);
                        $this->region->ViewValue = $this->region->displayValue($arwrk);
                    } else {
                        $this->region->ViewValue = FormatNumber($this->region->CurrentValue, $this->region->formatPattern());
                    }
                }
            } else {
                $this->region->ViewValue = null;
            }

            // city
            if ($this->city->VirtualValue != "") {
                $this->city->ViewValue = $this->city->VirtualValue;
            } else {
                $this->city->ViewValue = $this->city->CurrentValue;
                $curVal = strval($this->city->CurrentValue);
                if ($curVal != "") {
                    $this->city->ViewValue = $this->city->lookupCacheOption($curVal);
                    if ($this->city->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->city->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->city->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->city->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->city->Lookup->renderViewRow($rswrk[0]);
                            $this->city->ViewValue = $this->city->displayValue($arwrk);
                        } else {
                            $this->city->ViewValue = FormatNumber($this->city->CurrentValue, $this->city->formatPattern());
                        }
                    }
                } else {
                    $this->city->ViewValue = null;
                }
            }

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // tax_registration
            $this->tax_registration->ViewValue = $this->tax_registration->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                        $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                    } else {
                        $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // name
            $this->name->HrefValue = "";
            $this->name->TooltipValue = "";

            // code
            $this->code->HrefValue = "";
            $this->code->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // country
            $this->country->HrefValue = "";
            $this->country->TooltipValue = "";

            // region
            $this->region->HrefValue = "";
            $this->region->TooltipValue = "";

            // city
            $this->city->HrefValue = "";
            $this->city->TooltipValue = "";

            // address
            $this->address->HrefValue = "";
            $this->address->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // email
            $this->_email->HrefValue = "";
            $this->_email->TooltipValue = "";

            // tax_registration
            $this->tax_registration->HrefValue = "";
            $this->tax_registration->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";
            $this->reports_to->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->AdvancedSearch->SearchValue = HtmlDecode($this->name->AdvancedSearch->SearchValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->AdvancedSearch->SearchValue);
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // code
            $this->code->setupEditAttributes();
            if (!$this->code->Raw) {
                $this->code->AdvancedSearch->SearchValue = HtmlDecode($this->code->AdvancedSearch->SearchValue);
            }
            $this->code->EditValue = HtmlEncode($this->code->AdvancedSearch->SearchValue);
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());

            // category
            $this->category->setupEditAttributes();
            $curVal = trim(strval($this->category->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->category->AdvancedSearch->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->AdvancedSearch->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->category->AdvancedSearch->SearchValue, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // country
            $this->country->setupEditAttributes();
            $curVal = trim(strval($this->country->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->country->AdvancedSearch->ViewValue = $this->country->lookupCacheOption($curVal);
            } else {
                $this->country->AdvancedSearch->ViewValue = $this->country->Lookup !== null && is_array($this->country->lookupOptions()) && count($this->country->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->country->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->country->EditValue = array_values($this->country->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->country->AdvancedSearch->SearchValue, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->country->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->country->EditValue = $arwrk;
            }
            $this->country->PlaceHolder = RemoveHtml($this->country->caption());

            // region
            $this->region->setupEditAttributes();
            $curVal = trim(strval($this->region->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->region->AdvancedSearch->ViewValue = $this->region->lookupCacheOption($curVal);
            } else {
                $this->region->AdvancedSearch->ViewValue = $this->region->Lookup !== null && is_array($this->region->lookupOptions()) && count($this->region->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->region->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->region->EditValue = array_values($this->region->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->region->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->region->AdvancedSearch->SearchValue, $this->region->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->region->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->region->EditValue = $arwrk;
            }
            $this->region->PlaceHolder = RemoveHtml($this->region->caption());

            // city
            $this->city->setupEditAttributes();
            $this->city->EditValue = $this->city->AdvancedSearch->SearchValue;
            $this->city->PlaceHolder = RemoveHtml($this->city->caption());

            // address
            $this->address->setupEditAttributes();
            $this->address->EditValue = HtmlEncode($this->address->AdvancedSearch->SearchValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            if (!$this->mobile->Raw) {
                $this->mobile->AdvancedSearch->SearchValue = HtmlDecode($this->mobile->AdvancedSearch->SearchValue);
            }
            $this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->AdvancedSearch->SearchValue = HtmlDecode($this->_email->AdvancedSearch->SearchValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->AdvancedSearch->SearchValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // tax_registration
            $this->tax_registration->setupEditAttributes();
            if (!$this->tax_registration->Raw) {
                $this->tax_registration->AdvancedSearch->SearchValue = HtmlDecode($this->tax_registration->AdvancedSearch->SearchValue);
            }
            $this->tax_registration->EditValue = HtmlEncode($this->tax_registration->AdvancedSearch->SearchValue);
            $this->tax_registration->PlaceHolder = RemoveHtml($this->tax_registration->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // reports_to
            $this->reports_to->setupEditAttributes();
            $curVal = trim(strval($this->reports_to->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            } else {
                $this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->Lookup !== null && is_array($this->reports_to->lookupOptions()) && count($this->reports_to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->reports_to->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->reports_to->EditValue = array_values($this->reports_to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->reports_to->AdvancedSearch->SearchValue, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->reports_to->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->reports_to->EditValue = $arwrk;
            }
            $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->name->AdvancedSearch->load();
        $this->code->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->country->AdvancedSearch->load();
        $this->region->AdvancedSearch->load();
        $this->city->AdvancedSearch->load();
        $this->address->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->_email->AdvancedSearch->load();
        $this->tax_registration->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->reports_to->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("productionpartnerview2list"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_country":
                    break;
                case "x_region":
                    break;
                case "x_city":
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                case "x_reports_to":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'production_partner_view');		
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
