<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductionPartnerSearch extends ProductionPartner
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductionPartnerSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "productionpartnersearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->name->setVisibility();
        $this->code->setVisibility();
        $this->country->setVisibility();
        $this->region->setVisibility();
        $this->city->Visible = false;
        $this->city_name->setVisibility();
        $this->address->setVisibility();
        $this->mobile->setVisibility();
        $this->_email->setVisibility();
        $this->url->setVisibility();
        $this->bank_name->setVisibility();
        $this->bank_account_no->setVisibility();
        $this->bank_code->setVisibility();
        $this->grp->setVisibility();
        $this->category->setVisibility();
        $this->reports_to->setVisibility();
        $this->status->setVisibility();
        $this->performance->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->type->Visible = false;
        $this->tax_registration->setVisibility();
        $this->cin->setVisibility();
        $this->pan->setVisibility();
        $this->tan->setVisibility();
        $this->msme->setVisibility();
        $this->incoterm->Visible = false;
        $this->port_air->Visible = false;
        $this->port_sea->Visible = false;
        $this->iec->setVisibility();
        $this->rex->setVisibility();
        $this->rcmc->setVisibility();
        $this->delivery_terms->setVisibility();
        $this->shipping_terms->setVisibility();
        $this->payment_terms->setVisibility();
        $this->export_type->setVisibility();
        $this->lead_time_ss->setVisibility();
        $this->lead_time_cs->setVisibility();
        $this->cha->setVisibility();
        $this->cha_email->setVisibility();
        $this->cha_phone->setVisibility();
        $this->forwarder->setVisibility();
        $this->forwarder_email->setVisibility();
        $this->forwarder_phone->setVisibility();
        $this->merchant->setVisibility();
        $this->merchant_email->setVisibility();
        $this->merchant_phone->setVisibility();
        $this->shipping_incharge->setVisibility();
        $this->shipping_email->setVisibility();
        $this->shipping_phone->setVisibility();
        $this->account_incharge->setVisibility();
        $this->accounts_email->setVisibility();
        $this->accounts_phone->setVisibility();
        $this->warehouse_incharge->setVisibility();
        $this->warehouse_email->setVisibility();
        $this->warehouse_phone->setVisibility();
        $this->production_incharge->setVisibility();
        $this->production_email->setVisibility();
        $this->production_phone->setVisibility();
        $this->qc_incharge->setVisibility();
        $this->qc_email->setVisibility();
        $this->qc_phone->setVisibility();
        $this->uid->Visible = false;
        $this->r_text->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'production_partner';
        $this->TableName = 'production_partner';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (production_partner)
        if (!isset($GLOBALS["production_partner"]) || $GLOBALS["production_partner"]::class == PROJECT_NAMESPACE . "production_partner") {
            $GLOBALS["production_partner"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'production_partner');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "productionpartnerview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->country);
        $this->setupLookupOptions($this->region);
        $this->setupLookupOptions($this->city);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->type);
        $this->setupLookupOptions($this->incoterm);
        $this->setupLookupOptions($this->port_air);
        $this->setupLookupOptions($this->port_sea);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "productionpartnerlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->name); // name
        $this->buildSearchUrl($srchUrl, $this->code); // code
        $this->buildSearchUrl($srchUrl, $this->country); // country
        $this->buildSearchUrl($srchUrl, $this->region); // region
        $this->buildSearchUrl($srchUrl, $this->city_name); // city_name
        $this->buildSearchUrl($srchUrl, $this->address); // address
        $this->buildSearchUrl($srchUrl, $this->mobile); // mobile
        $this->buildSearchUrl($srchUrl, $this->_email); // email
        $this->buildSearchUrl($srchUrl, $this->url); // url
        $this->buildSearchUrl($srchUrl, $this->bank_name); // bank_name
        $this->buildSearchUrl($srchUrl, $this->bank_account_no); // bank_account_no
        $this->buildSearchUrl($srchUrl, $this->bank_code); // bank_code
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->category); // category
        $this->buildSearchUrl($srchUrl, $this->reports_to); // reports_to
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->performance); // performance
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->tax_registration); // tax_registration
        $this->buildSearchUrl($srchUrl, $this->cin); // cin
        $this->buildSearchUrl($srchUrl, $this->pan); // pan
        $this->buildSearchUrl($srchUrl, $this->tan); // tan
        $this->buildSearchUrl($srchUrl, $this->msme); // msme
        $this->buildSearchUrl($srchUrl, $this->iec); // iec
        $this->buildSearchUrl($srchUrl, $this->rex); // rex
        $this->buildSearchUrl($srchUrl, $this->rcmc); // rcmc
        $this->buildSearchUrl($srchUrl, $this->delivery_terms); // delivery_terms
        $this->buildSearchUrl($srchUrl, $this->shipping_terms); // shipping_terms
        $this->buildSearchUrl($srchUrl, $this->payment_terms); // payment_terms
        $this->buildSearchUrl($srchUrl, $this->export_type); // export_type
        $this->buildSearchUrl($srchUrl, $this->lead_time_ss); // lead_time_ss
        $this->buildSearchUrl($srchUrl, $this->lead_time_cs); // lead_time_cs
        $this->buildSearchUrl($srchUrl, $this->cha); // cha
        $this->buildSearchUrl($srchUrl, $this->cha_email); // cha_email
        $this->buildSearchUrl($srchUrl, $this->cha_phone); // cha_phone
        $this->buildSearchUrl($srchUrl, $this->forwarder); // forwarder
        $this->buildSearchUrl($srchUrl, $this->forwarder_email); // forwarder_email
        $this->buildSearchUrl($srchUrl, $this->forwarder_phone); // forwarder_phone
        $this->buildSearchUrl($srchUrl, $this->merchant); // merchant
        $this->buildSearchUrl($srchUrl, $this->merchant_email); // merchant_email
        $this->buildSearchUrl($srchUrl, $this->merchant_phone); // merchant_phone
        $this->buildSearchUrl($srchUrl, $this->shipping_incharge); // shipping_incharge
        $this->buildSearchUrl($srchUrl, $this->shipping_email); // shipping_email
        $this->buildSearchUrl($srchUrl, $this->shipping_phone); // shipping_phone
        $this->buildSearchUrl($srchUrl, $this->account_incharge); // account_incharge
        $this->buildSearchUrl($srchUrl, $this->accounts_email); // accounts_email
        $this->buildSearchUrl($srchUrl, $this->accounts_phone); // accounts_phone
        $this->buildSearchUrl($srchUrl, $this->warehouse_incharge); // warehouse_incharge
        $this->buildSearchUrl($srchUrl, $this->warehouse_email); // warehouse_email
        $this->buildSearchUrl($srchUrl, $this->warehouse_phone); // warehouse_phone
        $this->buildSearchUrl($srchUrl, $this->production_incharge); // production_incharge
        $this->buildSearchUrl($srchUrl, $this->production_email); // production_email
        $this->buildSearchUrl($srchUrl, $this->production_phone); // production_phone
        $this->buildSearchUrl($srchUrl, $this->qc_incharge); // qc_incharge
        $this->buildSearchUrl($srchUrl, $this->qc_email); // qc_email
        $this->buildSearchUrl($srchUrl, $this->qc_phone); // qc_phone
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // name
        if ($this->name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // code
        if ($this->code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // country
        if ($this->country->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // region
        if ($this->region->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // city_name
        if ($this->city_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // address
        if ($this->address->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // mobile
        if ($this->mobile->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // email
        if ($this->_email->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // url
        if ($this->url->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // bank_name
        if ($this->bank_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // bank_account_no
        if ($this->bank_account_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // bank_code
        if ($this->bank_code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->grp->AdvancedSearch->SearchValue)) {
            $this->grp->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->grp->AdvancedSearch->SearchValue);
        }
        if (is_array($this->grp->AdvancedSearch->SearchValue2)) {
            $this->grp->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->grp->AdvancedSearch->SearchValue2);
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // reports_to
        if ($this->reports_to->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // performance
        if ($this->performance->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // tax_registration
        if ($this->tax_registration->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cin
        if ($this->cin->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pan
        if ($this->pan->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // tan
        if ($this->tan->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // msme
        if ($this->msme->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // iec
        if ($this->iec->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // rex
        if ($this->rex->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // rcmc
        if ($this->rcmc->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // delivery_terms
        if ($this->delivery_terms->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // shipping_terms
        if ($this->shipping_terms->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // payment_terms
        if ($this->payment_terms->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // export_type
        if ($this->export_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // lead_time_ss
        if ($this->lead_time_ss->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // lead_time_cs
        if ($this->lead_time_cs->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cha
        if ($this->cha->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cha_email
        if ($this->cha_email->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cha_phone
        if ($this->cha_phone->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // forwarder
        if ($this->forwarder->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // forwarder_email
        if ($this->forwarder_email->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // forwarder_phone
        if ($this->forwarder_phone->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // merchant
        if ($this->merchant->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // merchant_email
        if ($this->merchant_email->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // merchant_phone
        if ($this->merchant_phone->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // shipping_incharge
        if ($this->shipping_incharge->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // shipping_email
        if ($this->shipping_email->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // shipping_phone
        if ($this->shipping_phone->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // account_incharge
        if ($this->account_incharge->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // accounts_email
        if ($this->accounts_email->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // accounts_phone
        if ($this->accounts_phone->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // warehouse_incharge
        if ($this->warehouse_incharge->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // warehouse_email
        if ($this->warehouse_email->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // warehouse_phone
        if ($this->warehouse_phone->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // production_incharge
        if ($this->production_incharge->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // production_email
        if ($this->production_email->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // production_phone
        if ($this->production_phone->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qc_incharge
        if ($this->qc_incharge->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qc_email
        if ($this->qc_email->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qc_phone
        if ($this->qc_phone->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // country
        $this->country->RowCssClass = "row";

        // region
        $this->region->RowCssClass = "row";

        // city
        $this->city->RowCssClass = "row";

        // city_name
        $this->city_name->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // url
        $this->url->RowCssClass = "row";

        // bank_name
        $this->bank_name->RowCssClass = "row";

        // bank_account_no
        $this->bank_account_no->RowCssClass = "row";

        // bank_code
        $this->bank_code->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // performance
        $this->performance->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // tax_registration
        $this->tax_registration->RowCssClass = "row";

        // cin
        $this->cin->RowCssClass = "row";

        // pan
        $this->pan->RowCssClass = "row";

        // tan
        $this->tan->RowCssClass = "row";

        // msme
        $this->msme->RowCssClass = "row";

        // incoterm
        $this->incoterm->RowCssClass = "row";

        // port_air
        $this->port_air->RowCssClass = "row";

        // port_sea
        $this->port_sea->RowCssClass = "row";

        // iec
        $this->iec->RowCssClass = "row";

        // rex
        $this->rex->RowCssClass = "row";

        // rcmc
        $this->rcmc->RowCssClass = "row";

        // delivery_terms
        $this->delivery_terms->RowCssClass = "row";

        // shipping_terms
        $this->shipping_terms->RowCssClass = "row";

        // payment_terms
        $this->payment_terms->RowCssClass = "row";

        // export_type
        $this->export_type->RowCssClass = "row";

        // lead_time_ss
        $this->lead_time_ss->RowCssClass = "row";

        // lead_time_cs
        $this->lead_time_cs->RowCssClass = "row";

        // cha
        $this->cha->RowCssClass = "row";

        // cha_email
        $this->cha_email->RowCssClass = "row";

        // cha_phone
        $this->cha_phone->RowCssClass = "row";

        // forwarder
        $this->forwarder->RowCssClass = "row";

        // forwarder_email
        $this->forwarder_email->RowCssClass = "row";

        // forwarder_phone
        $this->forwarder_phone->RowCssClass = "row";

        // merchant
        $this->merchant->RowCssClass = "row";

        // merchant_email
        $this->merchant_email->RowCssClass = "row";

        // merchant_phone
        $this->merchant_phone->RowCssClass = "row";

        // shipping_incharge
        $this->shipping_incharge->RowCssClass = "row";

        // shipping_email
        $this->shipping_email->RowCssClass = "row";

        // shipping_phone
        $this->shipping_phone->RowCssClass = "row";

        // account_incharge
        $this->account_incharge->RowCssClass = "row";

        // accounts_email
        $this->accounts_email->RowCssClass = "row";

        // accounts_phone
        $this->accounts_phone->RowCssClass = "row";

        // warehouse_incharge
        $this->warehouse_incharge->RowCssClass = "row";

        // warehouse_email
        $this->warehouse_email->RowCssClass = "row";

        // warehouse_phone
        $this->warehouse_phone->RowCssClass = "row";

        // production_incharge
        $this->production_incharge->RowCssClass = "row";

        // production_email
        $this->production_email->RowCssClass = "row";

        // production_phone
        $this->production_phone->RowCssClass = "row";

        // qc_incharge
        $this->qc_incharge->RowCssClass = "row";

        // qc_email
        $this->qc_email->RowCssClass = "row";

        // qc_phone
        $this->qc_phone->RowCssClass = "row";

        // uid
        $this->uid->RowCssClass = "row";

        // r_text
        $this->r_text->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // code
            $this->code->ViewValue = $this->code->CurrentValue;

            // country
            $curVal = strval($this->country->CurrentValue);
            if ($curVal != "") {
                $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
                if ($this->country->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->country->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->country->Lookup->renderViewRow($rswrk[0]);
                        $this->country->ViewValue = $this->country->displayValue($arwrk);
                    } else {
                        $this->country->ViewValue = FormatNumber($this->country->CurrentValue, $this->country->formatPattern());
                    }
                }
            } else {
                $this->country->ViewValue = null;
            }

            // region
            $curVal = strval($this->region->CurrentValue);
            if ($curVal != "") {
                $this->region->ViewValue = $this->region->lookupCacheOption($curVal);
                if ($this->region->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->region->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->region->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->region->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->region->Lookup->renderViewRow($rswrk[0]);
                        $this->region->ViewValue = $this->region->displayValue($arwrk);
                    } else {
                        $this->region->ViewValue = FormatNumber($this->region->CurrentValue, $this->region->formatPattern());
                    }
                }
            } else {
                $this->region->ViewValue = null;
            }

            // city_name
            $this->city_name->ViewValue = $this->city_name->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // url
            $this->url->ViewValue = $this->url->CurrentValue;

            // bank_name
            $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

            // bank_account_no
            $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

            // bank_code
            $this->bank_code->ViewValue = $this->bank_code->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->grp->Lookup->renderViewRow($row);
                            $this->grp->ViewValue->add($this->grp->displayValue($arwrk));
                        }
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                        $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                    } else {
                        $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // performance
            $this->performance->ViewValue = $this->performance->CurrentValue;
            $this->performance->ViewValue = FormatNumber($this->performance->ViewValue, $this->performance->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // type
            if (strval($this->type->CurrentValue) != "") {
                $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
            } else {
                $this->type->ViewValue = null;
            }

            // tax_registration
            $this->tax_registration->ViewValue = $this->tax_registration->CurrentValue;

            // cin
            $this->cin->ViewValue = $this->cin->CurrentValue;

            // pan
            $this->pan->ViewValue = $this->pan->CurrentValue;

            // tan
            $this->tan->ViewValue = $this->tan->CurrentValue;

            // msme
            $this->msme->ViewValue = $this->msme->CurrentValue;

            // port_air
            $curVal = strval($this->port_air->CurrentValue);
            if ($curVal != "") {
                $this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
                if ($this->port_air->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->port_air->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->port_air->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->port_air->getSelectFilter($this); // PHP
                    $sqlWrk = $this->port_air->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->port_air->Lookup->renderViewRow($rswrk[0]);
                        $this->port_air->ViewValue = $this->port_air->displayValue($arwrk);
                    } else {
                        $this->port_air->ViewValue = $this->port_air->CurrentValue;
                    }
                }
            } else {
                $this->port_air->ViewValue = null;
            }

            // port_sea
            $curVal = strval($this->port_sea->CurrentValue);
            if ($curVal != "") {
                $this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
                if ($this->port_sea->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->port_sea->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->port_sea->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->port_sea->getSelectFilter($this); // PHP
                    $sqlWrk = $this->port_sea->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->port_sea->Lookup->renderViewRow($rswrk[0]);
                        $this->port_sea->ViewValue = $this->port_sea->displayValue($arwrk);
                    } else {
                        $this->port_sea->ViewValue = $this->port_sea->CurrentValue;
                    }
                }
            } else {
                $this->port_sea->ViewValue = null;
            }

            // iec
            $this->iec->ViewValue = $this->iec->CurrentValue;

            // rex
            $this->rex->ViewValue = $this->rex->CurrentValue;

            // rcmc
            $this->rcmc->ViewValue = $this->rcmc->CurrentValue;

            // delivery_terms
            $this->delivery_terms->ViewValue = $this->delivery_terms->CurrentValue;

            // shipping_terms
            $this->shipping_terms->ViewValue = $this->shipping_terms->CurrentValue;

            // payment_terms
            $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;

            // export_type
            $this->export_type->ViewValue = $this->export_type->CurrentValue;

            // lead_time_ss
            $this->lead_time_ss->ViewValue = $this->lead_time_ss->CurrentValue;

            // lead_time_cs
            $this->lead_time_cs->ViewValue = $this->lead_time_cs->CurrentValue;

            // cha
            $this->cha->ViewValue = $this->cha->CurrentValue;

            // cha_email
            $this->cha_email->ViewValue = $this->cha_email->CurrentValue;

            // cha_phone
            $this->cha_phone->ViewValue = $this->cha_phone->CurrentValue;

            // forwarder
            $this->forwarder->ViewValue = $this->forwarder->CurrentValue;

            // forwarder_email
            $this->forwarder_email->ViewValue = $this->forwarder_email->CurrentValue;

            // forwarder_phone
            $this->forwarder_phone->ViewValue = $this->forwarder_phone->CurrentValue;

            // merchant
            $this->merchant->ViewValue = $this->merchant->CurrentValue;

            // merchant_email
            $this->merchant_email->ViewValue = $this->merchant_email->CurrentValue;

            // merchant_phone
            $this->merchant_phone->ViewValue = $this->merchant_phone->CurrentValue;

            // shipping_incharge
            $this->shipping_incharge->ViewValue = $this->shipping_incharge->CurrentValue;

            // shipping_email
            $this->shipping_email->ViewValue = $this->shipping_email->CurrentValue;

            // shipping_phone
            $this->shipping_phone->ViewValue = $this->shipping_phone->CurrentValue;

            // account_incharge
            $this->account_incharge->ViewValue = $this->account_incharge->CurrentValue;

            // accounts_email
            $this->accounts_email->ViewValue = $this->accounts_email->CurrentValue;

            // accounts_phone
            $this->accounts_phone->ViewValue = $this->accounts_phone->CurrentValue;

            // warehouse_incharge
            $this->warehouse_incharge->ViewValue = $this->warehouse_incharge->CurrentValue;

            // warehouse_email
            $this->warehouse_email->ViewValue = $this->warehouse_email->CurrentValue;

            // warehouse_phone
            $this->warehouse_phone->ViewValue = $this->warehouse_phone->CurrentValue;

            // production_incharge
            $this->production_incharge->ViewValue = $this->production_incharge->CurrentValue;

            // production_email
            $this->production_email->ViewValue = $this->production_email->CurrentValue;

            // production_phone
            $this->production_phone->ViewValue = $this->production_phone->CurrentValue;

            // qc_incharge
            $this->qc_incharge->ViewValue = $this->qc_incharge->CurrentValue;

            // qc_email
            $this->qc_email->ViewValue = $this->qc_email->CurrentValue;

            // qc_phone
            $this->qc_phone->ViewValue = $this->qc_phone->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // name
            $this->name->HrefValue = "";
            $this->name->TooltipValue = "";

            // code
            $this->code->HrefValue = "";
            $this->code->TooltipValue = "";

            // country
            $this->country->HrefValue = "";
            $this->country->TooltipValue = "";

            // region
            $this->region->HrefValue = "";
            $this->region->TooltipValue = "";

            // city_name
            $this->city_name->HrefValue = "";
            $this->city_name->TooltipValue = "";

            // address
            $this->address->HrefValue = "";
            $this->address->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // email
            $this->_email->HrefValue = "";
            $this->_email->TooltipValue = "";

            // url
            $this->url->HrefValue = "";
            $this->url->TooltipValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";
            $this->bank_name->TooltipValue = "";

            // bank_account_no
            $this->bank_account_no->HrefValue = "";
            $this->bank_account_no->TooltipValue = "";

            // bank_code
            $this->bank_code->HrefValue = "";
            $this->bank_code->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";
            $this->reports_to->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // performance
            $this->performance->HrefValue = "";
            $this->performance->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // tax_registration
            $this->tax_registration->HrefValue = "";
            $this->tax_registration->TooltipValue = "";

            // cin
            $this->cin->HrefValue = "";
            $this->cin->TooltipValue = "";

            // pan
            $this->pan->HrefValue = "";
            $this->pan->TooltipValue = "";

            // tan
            $this->tan->HrefValue = "";
            $this->tan->TooltipValue = "";

            // msme
            $this->msme->HrefValue = "";
            $this->msme->TooltipValue = "";

            // iec
            $this->iec->HrefValue = "";
            $this->iec->TooltipValue = "";

            // rex
            $this->rex->HrefValue = "";
            $this->rex->TooltipValue = "";

            // rcmc
            $this->rcmc->HrefValue = "";
            $this->rcmc->TooltipValue = "";

            // delivery_terms
            $this->delivery_terms->HrefValue = "";
            $this->delivery_terms->TooltipValue = "";

            // shipping_terms
            $this->shipping_terms->HrefValue = "";
            $this->shipping_terms->TooltipValue = "";

            // payment_terms
            $this->payment_terms->HrefValue = "";
            $this->payment_terms->TooltipValue = "";

            // export_type
            $this->export_type->HrefValue = "";
            $this->export_type->TooltipValue = "";

            // lead_time_ss
            $this->lead_time_ss->HrefValue = "";
            $this->lead_time_ss->TooltipValue = "";

            // lead_time_cs
            $this->lead_time_cs->HrefValue = "";
            $this->lead_time_cs->TooltipValue = "";

            // cha
            $this->cha->HrefValue = "";
            $this->cha->TooltipValue = "";

            // cha_email
            $this->cha_email->HrefValue = "";
            $this->cha_email->TooltipValue = "";

            // cha_phone
            $this->cha_phone->HrefValue = "";
            $this->cha_phone->TooltipValue = "";

            // forwarder
            $this->forwarder->HrefValue = "";
            $this->forwarder->TooltipValue = "";

            // forwarder_email
            $this->forwarder_email->HrefValue = "";
            $this->forwarder_email->TooltipValue = "";

            // forwarder_phone
            $this->forwarder_phone->HrefValue = "";
            $this->forwarder_phone->TooltipValue = "";

            // merchant
            $this->merchant->HrefValue = "";
            $this->merchant->TooltipValue = "";

            // merchant_email
            $this->merchant_email->HrefValue = "";
            $this->merchant_email->TooltipValue = "";

            // merchant_phone
            $this->merchant_phone->HrefValue = "";
            $this->merchant_phone->TooltipValue = "";

            // shipping_incharge
            $this->shipping_incharge->HrefValue = "";
            $this->shipping_incharge->TooltipValue = "";

            // shipping_email
            $this->shipping_email->HrefValue = "";
            $this->shipping_email->TooltipValue = "";

            // shipping_phone
            $this->shipping_phone->HrefValue = "";
            $this->shipping_phone->TooltipValue = "";

            // account_incharge
            $this->account_incharge->HrefValue = "";
            $this->account_incharge->TooltipValue = "";

            // accounts_email
            $this->accounts_email->HrefValue = "";
            $this->accounts_email->TooltipValue = "";

            // accounts_phone
            $this->accounts_phone->HrefValue = "";
            $this->accounts_phone->TooltipValue = "";

            // warehouse_incharge
            $this->warehouse_incharge->HrefValue = "";
            $this->warehouse_incharge->TooltipValue = "";

            // warehouse_email
            $this->warehouse_email->HrefValue = "";
            $this->warehouse_email->TooltipValue = "";

            // warehouse_phone
            $this->warehouse_phone->HrefValue = "";
            $this->warehouse_phone->TooltipValue = "";

            // production_incharge
            $this->production_incharge->HrefValue = "";
            $this->production_incharge->TooltipValue = "";

            // production_email
            $this->production_email->HrefValue = "";
            $this->production_email->TooltipValue = "";

            // production_phone
            $this->production_phone->HrefValue = "";
            $this->production_phone->TooltipValue = "";

            // qc_incharge
            $this->qc_incharge->HrefValue = "";
            $this->qc_incharge->TooltipValue = "";

            // qc_email
            $this->qc_email->HrefValue = "";
            $this->qc_email->TooltipValue = "";

            // qc_phone
            $this->qc_phone->HrefValue = "";
            $this->qc_phone->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->AdvancedSearch->SearchValue = HtmlDecode($this->name->AdvancedSearch->SearchValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->AdvancedSearch->SearchValue);
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // code
            $this->code->setupEditAttributes();
            if (!$this->code->Raw) {
                $this->code->AdvancedSearch->SearchValue = HtmlDecode($this->code->AdvancedSearch->SearchValue);
            }
            $this->code->EditValue = HtmlEncode($this->code->AdvancedSearch->SearchValue);
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());

            // country
            $this->country->setupEditAttributes();
            $curVal = trim(strval($this->country->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->country->AdvancedSearch->ViewValue = $this->country->lookupCacheOption($curVal);
            } else {
                $this->country->AdvancedSearch->ViewValue = $this->country->Lookup !== null && is_array($this->country->lookupOptions()) && count($this->country->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->country->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->country->EditValue = array_values($this->country->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->country->AdvancedSearch->SearchValue, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->country->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->country->EditValue = $arwrk;
            }
            $this->country->PlaceHolder = RemoveHtml($this->country->caption());

            // region
            $this->region->setupEditAttributes();
            $curVal = trim(strval($this->region->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->region->AdvancedSearch->ViewValue = $this->region->lookupCacheOption($curVal);
            } else {
                $this->region->AdvancedSearch->ViewValue = $this->region->Lookup !== null && is_array($this->region->lookupOptions()) && count($this->region->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->region->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->region->EditValue = array_values($this->region->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->region->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->region->AdvancedSearch->SearchValue, $this->region->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->region->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->region->EditValue = $arwrk;
            }
            $this->region->PlaceHolder = RemoveHtml($this->region->caption());

            // city_name
            $this->city_name->setupEditAttributes();
            if (!$this->city_name->Raw) {
                $this->city_name->AdvancedSearch->SearchValue = HtmlDecode($this->city_name->AdvancedSearch->SearchValue);
            }
            $this->city_name->EditValue = HtmlEncode($this->city_name->AdvancedSearch->SearchValue);
            $this->city_name->PlaceHolder = RemoveHtml($this->city_name->caption());

            // address
            $this->address->setupEditAttributes();
            $this->address->EditValue = HtmlEncode($this->address->AdvancedSearch->SearchValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            if (!$this->mobile->Raw) {
                $this->mobile->AdvancedSearch->SearchValue = HtmlDecode($this->mobile->AdvancedSearch->SearchValue);
            }
            $this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->AdvancedSearch->SearchValue = HtmlDecode($this->_email->AdvancedSearch->SearchValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->AdvancedSearch->SearchValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // url
            $this->url->setupEditAttributes();
            if (!$this->url->Raw) {
                $this->url->AdvancedSearch->SearchValue = HtmlDecode($this->url->AdvancedSearch->SearchValue);
            }
            $this->url->EditValue = HtmlEncode($this->url->AdvancedSearch->SearchValue);
            $this->url->PlaceHolder = RemoveHtml($this->url->caption());

            // bank_name
            $this->bank_name->setupEditAttributes();
            if (!$this->bank_name->Raw) {
                $this->bank_name->AdvancedSearch->SearchValue = HtmlDecode($this->bank_name->AdvancedSearch->SearchValue);
            }
            $this->bank_name->EditValue = HtmlEncode($this->bank_name->AdvancedSearch->SearchValue);
            $this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

            // bank_account_no
            $this->bank_account_no->setupEditAttributes();
            if (!$this->bank_account_no->Raw) {
                $this->bank_account_no->AdvancedSearch->SearchValue = HtmlDecode($this->bank_account_no->AdvancedSearch->SearchValue);
            }
            $this->bank_account_no->EditValue = HtmlEncode($this->bank_account_no->AdvancedSearch->SearchValue);
            $this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

            // bank_code
            $this->bank_code->setupEditAttributes();
            if (!$this->bank_code->Raw) {
                $this->bank_code->AdvancedSearch->SearchValue = HtmlDecode($this->bank_code->AdvancedSearch->SearchValue);
            }
            $this->bank_code->EditValue = HtmlEncode($this->bank_code->AdvancedSearch->SearchValue);
            $this->bank_code->PlaceHolder = RemoveHtml($this->bank_code->caption());

            // grp
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // category
            $this->category->setupEditAttributes();
            $curVal = trim(strval($this->category->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->category->AdvancedSearch->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->AdvancedSearch->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->category->AdvancedSearch->SearchValue, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // reports_to
            $this->reports_to->setupEditAttributes();
            $curVal = trim(strval($this->reports_to->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            } else {
                $this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->Lookup !== null && is_array($this->reports_to->lookupOptions()) && count($this->reports_to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->reports_to->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->reports_to->EditValue = array_values($this->reports_to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->reports_to->AdvancedSearch->SearchValue, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->reports_to->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->reports_to->EditValue = $arwrk;
            }
            $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // performance
            $this->performance->setupEditAttributes();
            $this->performance->EditValue = $this->performance->AdvancedSearch->SearchValue;
            $this->performance->PlaceHolder = RemoveHtml($this->performance->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // tax_registration
            $this->tax_registration->setupEditAttributes();
            if (!$this->tax_registration->Raw) {
                $this->tax_registration->AdvancedSearch->SearchValue = HtmlDecode($this->tax_registration->AdvancedSearch->SearchValue);
            }
            $this->tax_registration->EditValue = HtmlEncode($this->tax_registration->AdvancedSearch->SearchValue);
            $this->tax_registration->PlaceHolder = RemoveHtml($this->tax_registration->caption());

            // cin
            $this->cin->setupEditAttributes();
            if (!$this->cin->Raw) {
                $this->cin->AdvancedSearch->SearchValue = HtmlDecode($this->cin->AdvancedSearch->SearchValue);
            }
            $this->cin->EditValue = HtmlEncode($this->cin->AdvancedSearch->SearchValue);
            $this->cin->PlaceHolder = RemoveHtml($this->cin->caption());

            // pan
            $this->pan->setupEditAttributes();
            if (!$this->pan->Raw) {
                $this->pan->AdvancedSearch->SearchValue = HtmlDecode($this->pan->AdvancedSearch->SearchValue);
            }
            $this->pan->EditValue = HtmlEncode($this->pan->AdvancedSearch->SearchValue);
            $this->pan->PlaceHolder = RemoveHtml($this->pan->caption());

            // tan
            $this->tan->setupEditAttributes();
            if (!$this->tan->Raw) {
                $this->tan->AdvancedSearch->SearchValue = HtmlDecode($this->tan->AdvancedSearch->SearchValue);
            }
            $this->tan->EditValue = HtmlEncode($this->tan->AdvancedSearch->SearchValue);
            $this->tan->PlaceHolder = RemoveHtml($this->tan->caption());

            // msme
            $this->msme->setupEditAttributes();
            if (!$this->msme->Raw) {
                $this->msme->AdvancedSearch->SearchValue = HtmlDecode($this->msme->AdvancedSearch->SearchValue);
            }
            $this->msme->EditValue = HtmlEncode($this->msme->AdvancedSearch->SearchValue);
            $this->msme->PlaceHolder = RemoveHtml($this->msme->caption());

            // iec
            $this->iec->setupEditAttributes();
            if (!$this->iec->Raw) {
                $this->iec->AdvancedSearch->SearchValue = HtmlDecode($this->iec->AdvancedSearch->SearchValue);
            }
            $this->iec->EditValue = HtmlEncode($this->iec->AdvancedSearch->SearchValue);
            $this->iec->PlaceHolder = RemoveHtml($this->iec->caption());

            // rex
            $this->rex->setupEditAttributes();
            if (!$this->rex->Raw) {
                $this->rex->AdvancedSearch->SearchValue = HtmlDecode($this->rex->AdvancedSearch->SearchValue);
            }
            $this->rex->EditValue = HtmlEncode($this->rex->AdvancedSearch->SearchValue);
            $this->rex->PlaceHolder = RemoveHtml($this->rex->caption());

            // rcmc
            $this->rcmc->setupEditAttributes();
            if (!$this->rcmc->Raw) {
                $this->rcmc->AdvancedSearch->SearchValue = HtmlDecode($this->rcmc->AdvancedSearch->SearchValue);
            }
            $this->rcmc->EditValue = HtmlEncode($this->rcmc->AdvancedSearch->SearchValue);
            $this->rcmc->PlaceHolder = RemoveHtml($this->rcmc->caption());

            // delivery_terms
            $this->delivery_terms->setupEditAttributes();
            if (!$this->delivery_terms->Raw) {
                $this->delivery_terms->AdvancedSearch->SearchValue = HtmlDecode($this->delivery_terms->AdvancedSearch->SearchValue);
            }
            $this->delivery_terms->EditValue = HtmlEncode($this->delivery_terms->AdvancedSearch->SearchValue);
            $this->delivery_terms->PlaceHolder = RemoveHtml($this->delivery_terms->caption());

            // shipping_terms
            $this->shipping_terms->setupEditAttributes();
            if (!$this->shipping_terms->Raw) {
                $this->shipping_terms->AdvancedSearch->SearchValue = HtmlDecode($this->shipping_terms->AdvancedSearch->SearchValue);
            }
            $this->shipping_terms->EditValue = HtmlEncode($this->shipping_terms->AdvancedSearch->SearchValue);
            $this->shipping_terms->PlaceHolder = RemoveHtml($this->shipping_terms->caption());

            // payment_terms
            $this->payment_terms->setupEditAttributes();
            if (!$this->payment_terms->Raw) {
                $this->payment_terms->AdvancedSearch->SearchValue = HtmlDecode($this->payment_terms->AdvancedSearch->SearchValue);
            }
            $this->payment_terms->EditValue = HtmlEncode($this->payment_terms->AdvancedSearch->SearchValue);
            $this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

            // export_type
            $this->export_type->setupEditAttributes();
            if (!$this->export_type->Raw) {
                $this->export_type->AdvancedSearch->SearchValue = HtmlDecode($this->export_type->AdvancedSearch->SearchValue);
            }
            $this->export_type->EditValue = HtmlEncode($this->export_type->AdvancedSearch->SearchValue);
            $this->export_type->PlaceHolder = RemoveHtml($this->export_type->caption());

            // lead_time_ss
            $this->lead_time_ss->setupEditAttributes();
            if (!$this->lead_time_ss->Raw) {
                $this->lead_time_ss->AdvancedSearch->SearchValue = HtmlDecode($this->lead_time_ss->AdvancedSearch->SearchValue);
            }
            $this->lead_time_ss->EditValue = HtmlEncode($this->lead_time_ss->AdvancedSearch->SearchValue);
            $this->lead_time_ss->PlaceHolder = RemoveHtml($this->lead_time_ss->caption());

            // lead_time_cs
            $this->lead_time_cs->setupEditAttributes();
            if (!$this->lead_time_cs->Raw) {
                $this->lead_time_cs->AdvancedSearch->SearchValue = HtmlDecode($this->lead_time_cs->AdvancedSearch->SearchValue);
            }
            $this->lead_time_cs->EditValue = HtmlEncode($this->lead_time_cs->AdvancedSearch->SearchValue);
            $this->lead_time_cs->PlaceHolder = RemoveHtml($this->lead_time_cs->caption());

            // cha
            $this->cha->setupEditAttributes();
            $this->cha->EditValue = HtmlEncode($this->cha->AdvancedSearch->SearchValue);
            $this->cha->PlaceHolder = RemoveHtml($this->cha->caption());

            // cha_email
            $this->cha_email->setupEditAttributes();
            $this->cha_email->EditValue = HtmlEncode($this->cha_email->AdvancedSearch->SearchValue);
            $this->cha_email->PlaceHolder = RemoveHtml($this->cha_email->caption());

            // cha_phone
            $this->cha_phone->setupEditAttributes();
            $this->cha_phone->EditValue = HtmlEncode($this->cha_phone->AdvancedSearch->SearchValue);
            $this->cha_phone->PlaceHolder = RemoveHtml($this->cha_phone->caption());

            // forwarder
            $this->forwarder->setupEditAttributes();
            $this->forwarder->EditValue = HtmlEncode($this->forwarder->AdvancedSearch->SearchValue);
            $this->forwarder->PlaceHolder = RemoveHtml($this->forwarder->caption());

            // forwarder_email
            $this->forwarder_email->setupEditAttributes();
            $this->forwarder_email->EditValue = HtmlEncode($this->forwarder_email->AdvancedSearch->SearchValue);
            $this->forwarder_email->PlaceHolder = RemoveHtml($this->forwarder_email->caption());

            // forwarder_phone
            $this->forwarder_phone->setupEditAttributes();
            $this->forwarder_phone->EditValue = HtmlEncode($this->forwarder_phone->AdvancedSearch->SearchValue);
            $this->forwarder_phone->PlaceHolder = RemoveHtml($this->forwarder_phone->caption());

            // merchant
            $this->merchant->setupEditAttributes();
            $this->merchant->EditValue = HtmlEncode($this->merchant->AdvancedSearch->SearchValue);
            $this->merchant->PlaceHolder = RemoveHtml($this->merchant->caption());

            // merchant_email
            $this->merchant_email->setupEditAttributes();
            $this->merchant_email->EditValue = HtmlEncode($this->merchant_email->AdvancedSearch->SearchValue);
            $this->merchant_email->PlaceHolder = RemoveHtml($this->merchant_email->caption());

            // merchant_phone
            $this->merchant_phone->setupEditAttributes();
            $this->merchant_phone->EditValue = HtmlEncode($this->merchant_phone->AdvancedSearch->SearchValue);
            $this->merchant_phone->PlaceHolder = RemoveHtml($this->merchant_phone->caption());

            // shipping_incharge
            $this->shipping_incharge->setupEditAttributes();
            $this->shipping_incharge->EditValue = HtmlEncode($this->shipping_incharge->AdvancedSearch->SearchValue);
            $this->shipping_incharge->PlaceHolder = RemoveHtml($this->shipping_incharge->caption());

            // shipping_email
            $this->shipping_email->setupEditAttributes();
            $this->shipping_email->EditValue = HtmlEncode($this->shipping_email->AdvancedSearch->SearchValue);
            $this->shipping_email->PlaceHolder = RemoveHtml($this->shipping_email->caption());

            // shipping_phone
            $this->shipping_phone->setupEditAttributes();
            $this->shipping_phone->EditValue = HtmlEncode($this->shipping_phone->AdvancedSearch->SearchValue);
            $this->shipping_phone->PlaceHolder = RemoveHtml($this->shipping_phone->caption());

            // account_incharge
            $this->account_incharge->setupEditAttributes();
            $this->account_incharge->EditValue = HtmlEncode($this->account_incharge->AdvancedSearch->SearchValue);
            $this->account_incharge->PlaceHolder = RemoveHtml($this->account_incharge->caption());

            // accounts_email
            $this->accounts_email->setupEditAttributes();
            $this->accounts_email->EditValue = HtmlEncode($this->accounts_email->AdvancedSearch->SearchValue);
            $this->accounts_email->PlaceHolder = RemoveHtml($this->accounts_email->caption());

            // accounts_phone
            $this->accounts_phone->setupEditAttributes();
            $this->accounts_phone->EditValue = HtmlEncode($this->accounts_phone->AdvancedSearch->SearchValue);
            $this->accounts_phone->PlaceHolder = RemoveHtml($this->accounts_phone->caption());

            // warehouse_incharge
            $this->warehouse_incharge->setupEditAttributes();
            $this->warehouse_incharge->EditValue = HtmlEncode($this->warehouse_incharge->AdvancedSearch->SearchValue);
            $this->warehouse_incharge->PlaceHolder = RemoveHtml($this->warehouse_incharge->caption());

            // warehouse_email
            $this->warehouse_email->setupEditAttributes();
            $this->warehouse_email->EditValue = HtmlEncode($this->warehouse_email->AdvancedSearch->SearchValue);
            $this->warehouse_email->PlaceHolder = RemoveHtml($this->warehouse_email->caption());

            // warehouse_phone
            $this->warehouse_phone->setupEditAttributes();
            $this->warehouse_phone->EditValue = HtmlEncode($this->warehouse_phone->AdvancedSearch->SearchValue);
            $this->warehouse_phone->PlaceHolder = RemoveHtml($this->warehouse_phone->caption());

            // production_incharge
            $this->production_incharge->setupEditAttributes();
            $this->production_incharge->EditValue = HtmlEncode($this->production_incharge->AdvancedSearch->SearchValue);
            $this->production_incharge->PlaceHolder = RemoveHtml($this->production_incharge->caption());

            // production_email
            $this->production_email->setupEditAttributes();
            $this->production_email->EditValue = HtmlEncode($this->production_email->AdvancedSearch->SearchValue);
            $this->production_email->PlaceHolder = RemoveHtml($this->production_email->caption());

            // production_phone
            $this->production_phone->setupEditAttributes();
            $this->production_phone->EditValue = HtmlEncode($this->production_phone->AdvancedSearch->SearchValue);
            $this->production_phone->PlaceHolder = RemoveHtml($this->production_phone->caption());

            // qc_incharge
            $this->qc_incharge->setupEditAttributes();
            $this->qc_incharge->EditValue = HtmlEncode($this->qc_incharge->AdvancedSearch->SearchValue);
            $this->qc_incharge->PlaceHolder = RemoveHtml($this->qc_incharge->caption());

            // qc_email
            $this->qc_email->setupEditAttributes();
            $this->qc_email->EditValue = HtmlEncode($this->qc_email->AdvancedSearch->SearchValue);
            $this->qc_email->PlaceHolder = RemoveHtml($this->qc_email->caption());

            // qc_phone
            $this->qc_phone->setupEditAttributes();
            $this->qc_phone->EditValue = HtmlEncode($this->qc_phone->AdvancedSearch->SearchValue);
            $this->qc_phone->PlaceHolder = RemoveHtml($this->qc_phone->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->performance->AdvancedSearch->SearchValue)) {
            $this->performance->addErrorMessage($this->performance->getErrorMessage(false));
        }
        if (!CheckNumber($this->lead_time_ss->AdvancedSearch->SearchValue)) {
            $this->lead_time_ss->addErrorMessage($this->lead_time_ss->getErrorMessage(false));
        }
        if (!CheckNumber($this->lead_time_cs->AdvancedSearch->SearchValue)) {
            $this->lead_time_cs->addErrorMessage($this->lead_time_cs->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->name->AdvancedSearch->load();
        $this->code->AdvancedSearch->load();
        $this->country->AdvancedSearch->load();
        $this->region->AdvancedSearch->load();
        $this->city_name->AdvancedSearch->load();
        $this->address->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->_email->AdvancedSearch->load();
        $this->url->AdvancedSearch->load();
        $this->bank_name->AdvancedSearch->load();
        $this->bank_account_no->AdvancedSearch->load();
        $this->bank_code->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->reports_to->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->performance->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->tax_registration->AdvancedSearch->load();
        $this->cin->AdvancedSearch->load();
        $this->pan->AdvancedSearch->load();
        $this->tan->AdvancedSearch->load();
        $this->msme->AdvancedSearch->load();
        $this->iec->AdvancedSearch->load();
        $this->rex->AdvancedSearch->load();
        $this->rcmc->AdvancedSearch->load();
        $this->delivery_terms->AdvancedSearch->load();
        $this->shipping_terms->AdvancedSearch->load();
        $this->payment_terms->AdvancedSearch->load();
        $this->export_type->AdvancedSearch->load();
        $this->lead_time_ss->AdvancedSearch->load();
        $this->lead_time_cs->AdvancedSearch->load();
        $this->cha->AdvancedSearch->load();
        $this->cha_email->AdvancedSearch->load();
        $this->cha_phone->AdvancedSearch->load();
        $this->forwarder->AdvancedSearch->load();
        $this->forwarder_email->AdvancedSearch->load();
        $this->forwarder_phone->AdvancedSearch->load();
        $this->merchant->AdvancedSearch->load();
        $this->merchant_email->AdvancedSearch->load();
        $this->merchant_phone->AdvancedSearch->load();
        $this->shipping_incharge->AdvancedSearch->load();
        $this->shipping_email->AdvancedSearch->load();
        $this->shipping_phone->AdvancedSearch->load();
        $this->account_incharge->AdvancedSearch->load();
        $this->accounts_email->AdvancedSearch->load();
        $this->accounts_phone->AdvancedSearch->load();
        $this->warehouse_incharge->AdvancedSearch->load();
        $this->warehouse_email->AdvancedSearch->load();
        $this->warehouse_phone->AdvancedSearch->load();
        $this->production_incharge->AdvancedSearch->load();
        $this->production_email->AdvancedSearch->load();
        $this->production_phone->AdvancedSearch->load();
        $this->qc_incharge->AdvancedSearch->load();
        $this->qc_email->AdvancedSearch->load();
        $this->qc_phone->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("productionpartnerlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $pages->add(6);
        $pages->add(7);
        $pages->add(8);
        $pages->add(9);
        $pages->add(10);
        $pages->add(11);
        $pages->add(12);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_country":
                    break;
                case "x_region":
                    break;
                case "x_city":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_reports_to":
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                case "x_type":
                    break;
                case "x_incoterm":
                    break;
                case "x_port_air":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_port_sea":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'production_partner');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
