<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductionPartnerList extends ProductionPartner
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductionPartnerList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fproduction_partnerlist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "productionpartnerlist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->name->setVisibility();
        $this->code->setVisibility();
        $this->country->setVisibility();
        $this->region->setVisibility();
        $this->city->Visible = false;
        $this->city_name->setVisibility();
        $this->address->setVisibility();
        $this->mobile->setVisibility();
        $this->_email->setVisibility();
        $this->url->setVisibility();
        $this->bank_name->setVisibility();
        $this->bank_account_no->setVisibility();
        $this->bank_code->setVisibility();
        $this->grp->setVisibility();
        $this->category->setVisibility();
        $this->reports_to->setVisibility();
        $this->status->setVisibility();
        $this->performance->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->type->setVisibility();
        $this->tax_registration->setVisibility();
        $this->cin->setVisibility();
        $this->pan->setVisibility();
        $this->tan->setVisibility();
        $this->msme->setVisibility();
        $this->incoterm->Visible = false;
        $this->port_air->setVisibility();
        $this->port_sea->setVisibility();
        $this->iec->setVisibility();
        $this->rex->setVisibility();
        $this->rcmc->setVisibility();
        $this->delivery_terms->setVisibility();
        $this->shipping_terms->setVisibility();
        $this->payment_terms->setVisibility();
        $this->export_type->setVisibility();
        $this->lead_time_ss->setVisibility();
        $this->lead_time_cs->setVisibility();
        $this->cha->setVisibility();
        $this->cha_email->setVisibility();
        $this->cha_phone->setVisibility();
        $this->forwarder->setVisibility();
        $this->forwarder_email->setVisibility();
        $this->forwarder_phone->setVisibility();
        $this->merchant->setVisibility();
        $this->merchant_email->setVisibility();
        $this->merchant_phone->setVisibility();
        $this->shipping_incharge->setVisibility();
        $this->shipping_email->setVisibility();
        $this->shipping_phone->setVisibility();
        $this->account_incharge->setVisibility();
        $this->accounts_email->setVisibility();
        $this->accounts_phone->setVisibility();
        $this->warehouse_incharge->setVisibility();
        $this->warehouse_email->setVisibility();
        $this->warehouse_phone->setVisibility();
        $this->production_incharge->setVisibility();
        $this->production_email->setVisibility();
        $this->production_phone->setVisibility();
        $this->qc_incharge->setVisibility();
        $this->qc_email->setVisibility();
        $this->qc_phone->setVisibility();
        $this->uid->Visible = false;
        $this->r_text->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'production_partner';
        $this->TableName = 'production_partner';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (production_partner)
        if (!isset($GLOBALS["production_partner"]) || $GLOBALS["production_partner"]::class == PROJECT_NAMESPACE . "production_partner") {
            $GLOBALS["production_partner"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "productionpartneradd?" . Config("TABLE_SHOW_DETAIL") . "=";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "productionpartnerdelete";
        $this->MultiUpdateUrl = "productionpartnerupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'production_partner');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "productionpartnerview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->country);
        $this->setupLookupOptions($this->region);
        $this->setupLookupOptions($this->city);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->type);
        $this->setupLookupOptions($this->incoterm);
        $this->setupLookupOptions($this->port_air);
        $this->setupLookupOptions($this->port_sea);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fproduction_partnergrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fproduction_partnersrch");
        }
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->name->AdvancedSearch->toJson(), ","); // Field name
        $filterList = Concat($filterList, $this->code->AdvancedSearch->toJson(), ","); // Field code
        $filterList = Concat($filterList, $this->country->AdvancedSearch->toJson(), ","); // Field country
        $filterList = Concat($filterList, $this->region->AdvancedSearch->toJson(), ","); // Field region
        $filterList = Concat($filterList, $this->city_name->AdvancedSearch->toJson(), ","); // Field city_name
        $filterList = Concat($filterList, $this->address->AdvancedSearch->toJson(), ","); // Field address
        $filterList = Concat($filterList, $this->mobile->AdvancedSearch->toJson(), ","); // Field mobile
        $filterList = Concat($filterList, $this->_email->AdvancedSearch->toJson(), ","); // Field email
        $filterList = Concat($filterList, $this->url->AdvancedSearch->toJson(), ","); // Field url
        $filterList = Concat($filterList, $this->bank_name->AdvancedSearch->toJson(), ","); // Field bank_name
        $filterList = Concat($filterList, $this->bank_account_no->AdvancedSearch->toJson(), ","); // Field bank_account_no
        $filterList = Concat($filterList, $this->bank_code->AdvancedSearch->toJson(), ","); // Field bank_code
        $filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
        $filterList = Concat($filterList, $this->category->AdvancedSearch->toJson(), ","); // Field category
        $filterList = Concat($filterList, $this->reports_to->AdvancedSearch->toJson(), ","); // Field reports_to
        $filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
        $filterList = Concat($filterList, $this->performance->AdvancedSearch->toJson(), ","); // Field performance
        $filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
        $filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
        $filterList = Concat($filterList, $this->tax_registration->AdvancedSearch->toJson(), ","); // Field tax_registration
        $filterList = Concat($filterList, $this->cin->AdvancedSearch->toJson(), ","); // Field cin
        $filterList = Concat($filterList, $this->pan->AdvancedSearch->toJson(), ","); // Field pan
        $filterList = Concat($filterList, $this->tan->AdvancedSearch->toJson(), ","); // Field tan
        $filterList = Concat($filterList, $this->msme->AdvancedSearch->toJson(), ","); // Field msme
        $filterList = Concat($filterList, $this->iec->AdvancedSearch->toJson(), ","); // Field iec
        $filterList = Concat($filterList, $this->rex->AdvancedSearch->toJson(), ","); // Field rex
        $filterList = Concat($filterList, $this->rcmc->AdvancedSearch->toJson(), ","); // Field rcmc
        $filterList = Concat($filterList, $this->delivery_terms->AdvancedSearch->toJson(), ","); // Field delivery_terms
        $filterList = Concat($filterList, $this->shipping_terms->AdvancedSearch->toJson(), ","); // Field shipping_terms
        $filterList = Concat($filterList, $this->payment_terms->AdvancedSearch->toJson(), ","); // Field payment_terms
        $filterList = Concat($filterList, $this->export_type->AdvancedSearch->toJson(), ","); // Field export_type
        $filterList = Concat($filterList, $this->lead_time_ss->AdvancedSearch->toJson(), ","); // Field lead_time_ss
        $filterList = Concat($filterList, $this->lead_time_cs->AdvancedSearch->toJson(), ","); // Field lead_time_cs
        $filterList = Concat($filterList, $this->cha->AdvancedSearch->toJson(), ","); // Field cha
        $filterList = Concat($filterList, $this->cha_email->AdvancedSearch->toJson(), ","); // Field cha_email
        $filterList = Concat($filterList, $this->cha_phone->AdvancedSearch->toJson(), ","); // Field cha_phone
        $filterList = Concat($filterList, $this->forwarder->AdvancedSearch->toJson(), ","); // Field forwarder
        $filterList = Concat($filterList, $this->forwarder_email->AdvancedSearch->toJson(), ","); // Field forwarder_email
        $filterList = Concat($filterList, $this->forwarder_phone->AdvancedSearch->toJson(), ","); // Field forwarder_phone
        $filterList = Concat($filterList, $this->merchant->AdvancedSearch->toJson(), ","); // Field merchant
        $filterList = Concat($filterList, $this->merchant_email->AdvancedSearch->toJson(), ","); // Field merchant_email
        $filterList = Concat($filterList, $this->merchant_phone->AdvancedSearch->toJson(), ","); // Field merchant_phone
        $filterList = Concat($filterList, $this->shipping_incharge->AdvancedSearch->toJson(), ","); // Field shipping_incharge
        $filterList = Concat($filterList, $this->shipping_email->AdvancedSearch->toJson(), ","); // Field shipping_email
        $filterList = Concat($filterList, $this->shipping_phone->AdvancedSearch->toJson(), ","); // Field shipping_phone
        $filterList = Concat($filterList, $this->account_incharge->AdvancedSearch->toJson(), ","); // Field account_incharge
        $filterList = Concat($filterList, $this->accounts_email->AdvancedSearch->toJson(), ","); // Field accounts_email
        $filterList = Concat($filterList, $this->accounts_phone->AdvancedSearch->toJson(), ","); // Field accounts_phone
        $filterList = Concat($filterList, $this->warehouse_incharge->AdvancedSearch->toJson(), ","); // Field warehouse_incharge
        $filterList = Concat($filterList, $this->warehouse_email->AdvancedSearch->toJson(), ","); // Field warehouse_email
        $filterList = Concat($filterList, $this->warehouse_phone->AdvancedSearch->toJson(), ","); // Field warehouse_phone
        $filterList = Concat($filterList, $this->production_incharge->AdvancedSearch->toJson(), ","); // Field production_incharge
        $filterList = Concat($filterList, $this->production_email->AdvancedSearch->toJson(), ","); // Field production_email
        $filterList = Concat($filterList, $this->production_phone->AdvancedSearch->toJson(), ","); // Field production_phone
        $filterList = Concat($filterList, $this->qc_incharge->AdvancedSearch->toJson(), ","); // Field qc_incharge
        $filterList = Concat($filterList, $this->qc_email->AdvancedSearch->toJson(), ","); // Field qc_email
        $filterList = Concat($filterList, $this->qc_phone->AdvancedSearch->toJson(), ","); // Field qc_phone
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fproduction_partnersrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field name
        $this->name->AdvancedSearch->SearchValue = @$filter["x_name"];
        $this->name->AdvancedSearch->SearchOperator = @$filter["z_name"];
        $this->name->AdvancedSearch->SearchCondition = @$filter["v_name"];
        $this->name->AdvancedSearch->SearchValue2 = @$filter["y_name"];
        $this->name->AdvancedSearch->SearchOperator2 = @$filter["w_name"];
        $this->name->AdvancedSearch->save();

        // Field code
        $this->code->AdvancedSearch->SearchValue = @$filter["x_code"];
        $this->code->AdvancedSearch->SearchOperator = @$filter["z_code"];
        $this->code->AdvancedSearch->SearchCondition = @$filter["v_code"];
        $this->code->AdvancedSearch->SearchValue2 = @$filter["y_code"];
        $this->code->AdvancedSearch->SearchOperator2 = @$filter["w_code"];
        $this->code->AdvancedSearch->save();

        // Field country
        $this->country->AdvancedSearch->SearchValue = @$filter["x_country"];
        $this->country->AdvancedSearch->SearchOperator = @$filter["z_country"];
        $this->country->AdvancedSearch->SearchCondition = @$filter["v_country"];
        $this->country->AdvancedSearch->SearchValue2 = @$filter["y_country"];
        $this->country->AdvancedSearch->SearchOperator2 = @$filter["w_country"];
        $this->country->AdvancedSearch->save();

        // Field region
        $this->region->AdvancedSearch->SearchValue = @$filter["x_region"];
        $this->region->AdvancedSearch->SearchOperator = @$filter["z_region"];
        $this->region->AdvancedSearch->SearchCondition = @$filter["v_region"];
        $this->region->AdvancedSearch->SearchValue2 = @$filter["y_region"];
        $this->region->AdvancedSearch->SearchOperator2 = @$filter["w_region"];
        $this->region->AdvancedSearch->save();

        // Field city_name
        $this->city_name->AdvancedSearch->SearchValue = @$filter["x_city_name"];
        $this->city_name->AdvancedSearch->SearchOperator = @$filter["z_city_name"];
        $this->city_name->AdvancedSearch->SearchCondition = @$filter["v_city_name"];
        $this->city_name->AdvancedSearch->SearchValue2 = @$filter["y_city_name"];
        $this->city_name->AdvancedSearch->SearchOperator2 = @$filter["w_city_name"];
        $this->city_name->AdvancedSearch->save();

        // Field address
        $this->address->AdvancedSearch->SearchValue = @$filter["x_address"];
        $this->address->AdvancedSearch->SearchOperator = @$filter["z_address"];
        $this->address->AdvancedSearch->SearchCondition = @$filter["v_address"];
        $this->address->AdvancedSearch->SearchValue2 = @$filter["y_address"];
        $this->address->AdvancedSearch->SearchOperator2 = @$filter["w_address"];
        $this->address->AdvancedSearch->save();

        // Field mobile
        $this->mobile->AdvancedSearch->SearchValue = @$filter["x_mobile"];
        $this->mobile->AdvancedSearch->SearchOperator = @$filter["z_mobile"];
        $this->mobile->AdvancedSearch->SearchCondition = @$filter["v_mobile"];
        $this->mobile->AdvancedSearch->SearchValue2 = @$filter["y_mobile"];
        $this->mobile->AdvancedSearch->SearchOperator2 = @$filter["w_mobile"];
        $this->mobile->AdvancedSearch->save();

        // Field email
        $this->_email->AdvancedSearch->SearchValue = @$filter["x__email"];
        $this->_email->AdvancedSearch->SearchOperator = @$filter["z__email"];
        $this->_email->AdvancedSearch->SearchCondition = @$filter["v__email"];
        $this->_email->AdvancedSearch->SearchValue2 = @$filter["y__email"];
        $this->_email->AdvancedSearch->SearchOperator2 = @$filter["w__email"];
        $this->_email->AdvancedSearch->save();

        // Field url
        $this->url->AdvancedSearch->SearchValue = @$filter["x_url"];
        $this->url->AdvancedSearch->SearchOperator = @$filter["z_url"];
        $this->url->AdvancedSearch->SearchCondition = @$filter["v_url"];
        $this->url->AdvancedSearch->SearchValue2 = @$filter["y_url"];
        $this->url->AdvancedSearch->SearchOperator2 = @$filter["w_url"];
        $this->url->AdvancedSearch->save();

        // Field bank_name
        $this->bank_name->AdvancedSearch->SearchValue = @$filter["x_bank_name"];
        $this->bank_name->AdvancedSearch->SearchOperator = @$filter["z_bank_name"];
        $this->bank_name->AdvancedSearch->SearchCondition = @$filter["v_bank_name"];
        $this->bank_name->AdvancedSearch->SearchValue2 = @$filter["y_bank_name"];
        $this->bank_name->AdvancedSearch->SearchOperator2 = @$filter["w_bank_name"];
        $this->bank_name->AdvancedSearch->save();

        // Field bank_account_no
        $this->bank_account_no->AdvancedSearch->SearchValue = @$filter["x_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->SearchOperator = @$filter["z_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->SearchCondition = @$filter["v_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->SearchValue2 = @$filter["y_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->SearchOperator2 = @$filter["w_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->save();

        // Field bank_code
        $this->bank_code->AdvancedSearch->SearchValue = @$filter["x_bank_code"];
        $this->bank_code->AdvancedSearch->SearchOperator = @$filter["z_bank_code"];
        $this->bank_code->AdvancedSearch->SearchCondition = @$filter["v_bank_code"];
        $this->bank_code->AdvancedSearch->SearchValue2 = @$filter["y_bank_code"];
        $this->bank_code->AdvancedSearch->SearchOperator2 = @$filter["w_bank_code"];
        $this->bank_code->AdvancedSearch->save();

        // Field grp
        $this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
        $this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
        $this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
        $this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
        $this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
        $this->grp->AdvancedSearch->save();

        // Field category
        $this->category->AdvancedSearch->SearchValue = @$filter["x_category"];
        $this->category->AdvancedSearch->SearchOperator = @$filter["z_category"];
        $this->category->AdvancedSearch->SearchCondition = @$filter["v_category"];
        $this->category->AdvancedSearch->SearchValue2 = @$filter["y_category"];
        $this->category->AdvancedSearch->SearchOperator2 = @$filter["w_category"];
        $this->category->AdvancedSearch->save();

        // Field reports_to
        $this->reports_to->AdvancedSearch->SearchValue = @$filter["x_reports_to"];
        $this->reports_to->AdvancedSearch->SearchOperator = @$filter["z_reports_to"];
        $this->reports_to->AdvancedSearch->SearchCondition = @$filter["v_reports_to"];
        $this->reports_to->AdvancedSearch->SearchValue2 = @$filter["y_reports_to"];
        $this->reports_to->AdvancedSearch->SearchOperator2 = @$filter["w_reports_to"];
        $this->reports_to->AdvancedSearch->save();

        // Field status
        $this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
        $this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
        $this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
        $this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
        $this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
        $this->status->AdvancedSearch->save();

        // Field performance
        $this->performance->AdvancedSearch->SearchValue = @$filter["x_performance"];
        $this->performance->AdvancedSearch->SearchOperator = @$filter["z_performance"];
        $this->performance->AdvancedSearch->SearchCondition = @$filter["v_performance"];
        $this->performance->AdvancedSearch->SearchValue2 = @$filter["y_performance"];
        $this->performance->AdvancedSearch->SearchOperator2 = @$filter["w_performance"];
        $this->performance->AdvancedSearch->save();

        // Field operator
        $this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
        $this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
        $this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
        $this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
        $this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
        $this->operator->AdvancedSearch->save();

        // Field datetime
        $this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
        $this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
        $this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
        $this->datetime->AdvancedSearch->save();

        // Field tax_registration
        $this->tax_registration->AdvancedSearch->SearchValue = @$filter["x_tax_registration"];
        $this->tax_registration->AdvancedSearch->SearchOperator = @$filter["z_tax_registration"];
        $this->tax_registration->AdvancedSearch->SearchCondition = @$filter["v_tax_registration"];
        $this->tax_registration->AdvancedSearch->SearchValue2 = @$filter["y_tax_registration"];
        $this->tax_registration->AdvancedSearch->SearchOperator2 = @$filter["w_tax_registration"];
        $this->tax_registration->AdvancedSearch->save();

        // Field cin
        $this->cin->AdvancedSearch->SearchValue = @$filter["x_cin"];
        $this->cin->AdvancedSearch->SearchOperator = @$filter["z_cin"];
        $this->cin->AdvancedSearch->SearchCondition = @$filter["v_cin"];
        $this->cin->AdvancedSearch->SearchValue2 = @$filter["y_cin"];
        $this->cin->AdvancedSearch->SearchOperator2 = @$filter["w_cin"];
        $this->cin->AdvancedSearch->save();

        // Field pan
        $this->pan->AdvancedSearch->SearchValue = @$filter["x_pan"];
        $this->pan->AdvancedSearch->SearchOperator = @$filter["z_pan"];
        $this->pan->AdvancedSearch->SearchCondition = @$filter["v_pan"];
        $this->pan->AdvancedSearch->SearchValue2 = @$filter["y_pan"];
        $this->pan->AdvancedSearch->SearchOperator2 = @$filter["w_pan"];
        $this->pan->AdvancedSearch->save();

        // Field tan
        $this->tan->AdvancedSearch->SearchValue = @$filter["x_tan"];
        $this->tan->AdvancedSearch->SearchOperator = @$filter["z_tan"];
        $this->tan->AdvancedSearch->SearchCondition = @$filter["v_tan"];
        $this->tan->AdvancedSearch->SearchValue2 = @$filter["y_tan"];
        $this->tan->AdvancedSearch->SearchOperator2 = @$filter["w_tan"];
        $this->tan->AdvancedSearch->save();

        // Field msme
        $this->msme->AdvancedSearch->SearchValue = @$filter["x_msme"];
        $this->msme->AdvancedSearch->SearchOperator = @$filter["z_msme"];
        $this->msme->AdvancedSearch->SearchCondition = @$filter["v_msme"];
        $this->msme->AdvancedSearch->SearchValue2 = @$filter["y_msme"];
        $this->msme->AdvancedSearch->SearchOperator2 = @$filter["w_msme"];
        $this->msme->AdvancedSearch->save();

        // Field iec
        $this->iec->AdvancedSearch->SearchValue = @$filter["x_iec"];
        $this->iec->AdvancedSearch->SearchOperator = @$filter["z_iec"];
        $this->iec->AdvancedSearch->SearchCondition = @$filter["v_iec"];
        $this->iec->AdvancedSearch->SearchValue2 = @$filter["y_iec"];
        $this->iec->AdvancedSearch->SearchOperator2 = @$filter["w_iec"];
        $this->iec->AdvancedSearch->save();

        // Field rex
        $this->rex->AdvancedSearch->SearchValue = @$filter["x_rex"];
        $this->rex->AdvancedSearch->SearchOperator = @$filter["z_rex"];
        $this->rex->AdvancedSearch->SearchCondition = @$filter["v_rex"];
        $this->rex->AdvancedSearch->SearchValue2 = @$filter["y_rex"];
        $this->rex->AdvancedSearch->SearchOperator2 = @$filter["w_rex"];
        $this->rex->AdvancedSearch->save();

        // Field rcmc
        $this->rcmc->AdvancedSearch->SearchValue = @$filter["x_rcmc"];
        $this->rcmc->AdvancedSearch->SearchOperator = @$filter["z_rcmc"];
        $this->rcmc->AdvancedSearch->SearchCondition = @$filter["v_rcmc"];
        $this->rcmc->AdvancedSearch->SearchValue2 = @$filter["y_rcmc"];
        $this->rcmc->AdvancedSearch->SearchOperator2 = @$filter["w_rcmc"];
        $this->rcmc->AdvancedSearch->save();

        // Field delivery_terms
        $this->delivery_terms->AdvancedSearch->SearchValue = @$filter["x_delivery_terms"];
        $this->delivery_terms->AdvancedSearch->SearchOperator = @$filter["z_delivery_terms"];
        $this->delivery_terms->AdvancedSearch->SearchCondition = @$filter["v_delivery_terms"];
        $this->delivery_terms->AdvancedSearch->SearchValue2 = @$filter["y_delivery_terms"];
        $this->delivery_terms->AdvancedSearch->SearchOperator2 = @$filter["w_delivery_terms"];
        $this->delivery_terms->AdvancedSearch->save();

        // Field shipping_terms
        $this->shipping_terms->AdvancedSearch->SearchValue = @$filter["x_shipping_terms"];
        $this->shipping_terms->AdvancedSearch->SearchOperator = @$filter["z_shipping_terms"];
        $this->shipping_terms->AdvancedSearch->SearchCondition = @$filter["v_shipping_terms"];
        $this->shipping_terms->AdvancedSearch->SearchValue2 = @$filter["y_shipping_terms"];
        $this->shipping_terms->AdvancedSearch->SearchOperator2 = @$filter["w_shipping_terms"];
        $this->shipping_terms->AdvancedSearch->save();

        // Field payment_terms
        $this->payment_terms->AdvancedSearch->SearchValue = @$filter["x_payment_terms"];
        $this->payment_terms->AdvancedSearch->SearchOperator = @$filter["z_payment_terms"];
        $this->payment_terms->AdvancedSearch->SearchCondition = @$filter["v_payment_terms"];
        $this->payment_terms->AdvancedSearch->SearchValue2 = @$filter["y_payment_terms"];
        $this->payment_terms->AdvancedSearch->SearchOperator2 = @$filter["w_payment_terms"];
        $this->payment_terms->AdvancedSearch->save();

        // Field export_type
        $this->export_type->AdvancedSearch->SearchValue = @$filter["x_export_type"];
        $this->export_type->AdvancedSearch->SearchOperator = @$filter["z_export_type"];
        $this->export_type->AdvancedSearch->SearchCondition = @$filter["v_export_type"];
        $this->export_type->AdvancedSearch->SearchValue2 = @$filter["y_export_type"];
        $this->export_type->AdvancedSearch->SearchOperator2 = @$filter["w_export_type"];
        $this->export_type->AdvancedSearch->save();

        // Field lead_time_ss
        $this->lead_time_ss->AdvancedSearch->SearchValue = @$filter["x_lead_time_ss"];
        $this->lead_time_ss->AdvancedSearch->SearchOperator = @$filter["z_lead_time_ss"];
        $this->lead_time_ss->AdvancedSearch->SearchCondition = @$filter["v_lead_time_ss"];
        $this->lead_time_ss->AdvancedSearch->SearchValue2 = @$filter["y_lead_time_ss"];
        $this->lead_time_ss->AdvancedSearch->SearchOperator2 = @$filter["w_lead_time_ss"];
        $this->lead_time_ss->AdvancedSearch->save();

        // Field lead_time_cs
        $this->lead_time_cs->AdvancedSearch->SearchValue = @$filter["x_lead_time_cs"];
        $this->lead_time_cs->AdvancedSearch->SearchOperator = @$filter["z_lead_time_cs"];
        $this->lead_time_cs->AdvancedSearch->SearchCondition = @$filter["v_lead_time_cs"];
        $this->lead_time_cs->AdvancedSearch->SearchValue2 = @$filter["y_lead_time_cs"];
        $this->lead_time_cs->AdvancedSearch->SearchOperator2 = @$filter["w_lead_time_cs"];
        $this->lead_time_cs->AdvancedSearch->save();

        // Field cha
        $this->cha->AdvancedSearch->SearchValue = @$filter["x_cha"];
        $this->cha->AdvancedSearch->SearchOperator = @$filter["z_cha"];
        $this->cha->AdvancedSearch->SearchCondition = @$filter["v_cha"];
        $this->cha->AdvancedSearch->SearchValue2 = @$filter["y_cha"];
        $this->cha->AdvancedSearch->SearchOperator2 = @$filter["w_cha"];
        $this->cha->AdvancedSearch->save();

        // Field cha_email
        $this->cha_email->AdvancedSearch->SearchValue = @$filter["x_cha_email"];
        $this->cha_email->AdvancedSearch->SearchOperator = @$filter["z_cha_email"];
        $this->cha_email->AdvancedSearch->SearchCondition = @$filter["v_cha_email"];
        $this->cha_email->AdvancedSearch->SearchValue2 = @$filter["y_cha_email"];
        $this->cha_email->AdvancedSearch->SearchOperator2 = @$filter["w_cha_email"];
        $this->cha_email->AdvancedSearch->save();

        // Field cha_phone
        $this->cha_phone->AdvancedSearch->SearchValue = @$filter["x_cha_phone"];
        $this->cha_phone->AdvancedSearch->SearchOperator = @$filter["z_cha_phone"];
        $this->cha_phone->AdvancedSearch->SearchCondition = @$filter["v_cha_phone"];
        $this->cha_phone->AdvancedSearch->SearchValue2 = @$filter["y_cha_phone"];
        $this->cha_phone->AdvancedSearch->SearchOperator2 = @$filter["w_cha_phone"];
        $this->cha_phone->AdvancedSearch->save();

        // Field forwarder
        $this->forwarder->AdvancedSearch->SearchValue = @$filter["x_forwarder"];
        $this->forwarder->AdvancedSearch->SearchOperator = @$filter["z_forwarder"];
        $this->forwarder->AdvancedSearch->SearchCondition = @$filter["v_forwarder"];
        $this->forwarder->AdvancedSearch->SearchValue2 = @$filter["y_forwarder"];
        $this->forwarder->AdvancedSearch->SearchOperator2 = @$filter["w_forwarder"];
        $this->forwarder->AdvancedSearch->save();

        // Field forwarder_email
        $this->forwarder_email->AdvancedSearch->SearchValue = @$filter["x_forwarder_email"];
        $this->forwarder_email->AdvancedSearch->SearchOperator = @$filter["z_forwarder_email"];
        $this->forwarder_email->AdvancedSearch->SearchCondition = @$filter["v_forwarder_email"];
        $this->forwarder_email->AdvancedSearch->SearchValue2 = @$filter["y_forwarder_email"];
        $this->forwarder_email->AdvancedSearch->SearchOperator2 = @$filter["w_forwarder_email"];
        $this->forwarder_email->AdvancedSearch->save();

        // Field forwarder_phone
        $this->forwarder_phone->AdvancedSearch->SearchValue = @$filter["x_forwarder_phone"];
        $this->forwarder_phone->AdvancedSearch->SearchOperator = @$filter["z_forwarder_phone"];
        $this->forwarder_phone->AdvancedSearch->SearchCondition = @$filter["v_forwarder_phone"];
        $this->forwarder_phone->AdvancedSearch->SearchValue2 = @$filter["y_forwarder_phone"];
        $this->forwarder_phone->AdvancedSearch->SearchOperator2 = @$filter["w_forwarder_phone"];
        $this->forwarder_phone->AdvancedSearch->save();

        // Field merchant
        $this->merchant->AdvancedSearch->SearchValue = @$filter["x_merchant"];
        $this->merchant->AdvancedSearch->SearchOperator = @$filter["z_merchant"];
        $this->merchant->AdvancedSearch->SearchCondition = @$filter["v_merchant"];
        $this->merchant->AdvancedSearch->SearchValue2 = @$filter["y_merchant"];
        $this->merchant->AdvancedSearch->SearchOperator2 = @$filter["w_merchant"];
        $this->merchant->AdvancedSearch->save();

        // Field merchant_email
        $this->merchant_email->AdvancedSearch->SearchValue = @$filter["x_merchant_email"];
        $this->merchant_email->AdvancedSearch->SearchOperator = @$filter["z_merchant_email"];
        $this->merchant_email->AdvancedSearch->SearchCondition = @$filter["v_merchant_email"];
        $this->merchant_email->AdvancedSearch->SearchValue2 = @$filter["y_merchant_email"];
        $this->merchant_email->AdvancedSearch->SearchOperator2 = @$filter["w_merchant_email"];
        $this->merchant_email->AdvancedSearch->save();

        // Field merchant_phone
        $this->merchant_phone->AdvancedSearch->SearchValue = @$filter["x_merchant_phone"];
        $this->merchant_phone->AdvancedSearch->SearchOperator = @$filter["z_merchant_phone"];
        $this->merchant_phone->AdvancedSearch->SearchCondition = @$filter["v_merchant_phone"];
        $this->merchant_phone->AdvancedSearch->SearchValue2 = @$filter["y_merchant_phone"];
        $this->merchant_phone->AdvancedSearch->SearchOperator2 = @$filter["w_merchant_phone"];
        $this->merchant_phone->AdvancedSearch->save();

        // Field shipping_incharge
        $this->shipping_incharge->AdvancedSearch->SearchValue = @$filter["x_shipping_incharge"];
        $this->shipping_incharge->AdvancedSearch->SearchOperator = @$filter["z_shipping_incharge"];
        $this->shipping_incharge->AdvancedSearch->SearchCondition = @$filter["v_shipping_incharge"];
        $this->shipping_incharge->AdvancedSearch->SearchValue2 = @$filter["y_shipping_incharge"];
        $this->shipping_incharge->AdvancedSearch->SearchOperator2 = @$filter["w_shipping_incharge"];
        $this->shipping_incharge->AdvancedSearch->save();

        // Field shipping_email
        $this->shipping_email->AdvancedSearch->SearchValue = @$filter["x_shipping_email"];
        $this->shipping_email->AdvancedSearch->SearchOperator = @$filter["z_shipping_email"];
        $this->shipping_email->AdvancedSearch->SearchCondition = @$filter["v_shipping_email"];
        $this->shipping_email->AdvancedSearch->SearchValue2 = @$filter["y_shipping_email"];
        $this->shipping_email->AdvancedSearch->SearchOperator2 = @$filter["w_shipping_email"];
        $this->shipping_email->AdvancedSearch->save();

        // Field shipping_phone
        $this->shipping_phone->AdvancedSearch->SearchValue = @$filter["x_shipping_phone"];
        $this->shipping_phone->AdvancedSearch->SearchOperator = @$filter["z_shipping_phone"];
        $this->shipping_phone->AdvancedSearch->SearchCondition = @$filter["v_shipping_phone"];
        $this->shipping_phone->AdvancedSearch->SearchValue2 = @$filter["y_shipping_phone"];
        $this->shipping_phone->AdvancedSearch->SearchOperator2 = @$filter["w_shipping_phone"];
        $this->shipping_phone->AdvancedSearch->save();

        // Field account_incharge
        $this->account_incharge->AdvancedSearch->SearchValue = @$filter["x_account_incharge"];
        $this->account_incharge->AdvancedSearch->SearchOperator = @$filter["z_account_incharge"];
        $this->account_incharge->AdvancedSearch->SearchCondition = @$filter["v_account_incharge"];
        $this->account_incharge->AdvancedSearch->SearchValue2 = @$filter["y_account_incharge"];
        $this->account_incharge->AdvancedSearch->SearchOperator2 = @$filter["w_account_incharge"];
        $this->account_incharge->AdvancedSearch->save();

        // Field accounts_email
        $this->accounts_email->AdvancedSearch->SearchValue = @$filter["x_accounts_email"];
        $this->accounts_email->AdvancedSearch->SearchOperator = @$filter["z_accounts_email"];
        $this->accounts_email->AdvancedSearch->SearchCondition = @$filter["v_accounts_email"];
        $this->accounts_email->AdvancedSearch->SearchValue2 = @$filter["y_accounts_email"];
        $this->accounts_email->AdvancedSearch->SearchOperator2 = @$filter["w_accounts_email"];
        $this->accounts_email->AdvancedSearch->save();

        // Field accounts_phone
        $this->accounts_phone->AdvancedSearch->SearchValue = @$filter["x_accounts_phone"];
        $this->accounts_phone->AdvancedSearch->SearchOperator = @$filter["z_accounts_phone"];
        $this->accounts_phone->AdvancedSearch->SearchCondition = @$filter["v_accounts_phone"];
        $this->accounts_phone->AdvancedSearch->SearchValue2 = @$filter["y_accounts_phone"];
        $this->accounts_phone->AdvancedSearch->SearchOperator2 = @$filter["w_accounts_phone"];
        $this->accounts_phone->AdvancedSearch->save();

        // Field warehouse_incharge
        $this->warehouse_incharge->AdvancedSearch->SearchValue = @$filter["x_warehouse_incharge"];
        $this->warehouse_incharge->AdvancedSearch->SearchOperator = @$filter["z_warehouse_incharge"];
        $this->warehouse_incharge->AdvancedSearch->SearchCondition = @$filter["v_warehouse_incharge"];
        $this->warehouse_incharge->AdvancedSearch->SearchValue2 = @$filter["y_warehouse_incharge"];
        $this->warehouse_incharge->AdvancedSearch->SearchOperator2 = @$filter["w_warehouse_incharge"];
        $this->warehouse_incharge->AdvancedSearch->save();

        // Field warehouse_email
        $this->warehouse_email->AdvancedSearch->SearchValue = @$filter["x_warehouse_email"];
        $this->warehouse_email->AdvancedSearch->SearchOperator = @$filter["z_warehouse_email"];
        $this->warehouse_email->AdvancedSearch->SearchCondition = @$filter["v_warehouse_email"];
        $this->warehouse_email->AdvancedSearch->SearchValue2 = @$filter["y_warehouse_email"];
        $this->warehouse_email->AdvancedSearch->SearchOperator2 = @$filter["w_warehouse_email"];
        $this->warehouse_email->AdvancedSearch->save();

        // Field warehouse_phone
        $this->warehouse_phone->AdvancedSearch->SearchValue = @$filter["x_warehouse_phone"];
        $this->warehouse_phone->AdvancedSearch->SearchOperator = @$filter["z_warehouse_phone"];
        $this->warehouse_phone->AdvancedSearch->SearchCondition = @$filter["v_warehouse_phone"];
        $this->warehouse_phone->AdvancedSearch->SearchValue2 = @$filter["y_warehouse_phone"];
        $this->warehouse_phone->AdvancedSearch->SearchOperator2 = @$filter["w_warehouse_phone"];
        $this->warehouse_phone->AdvancedSearch->save();

        // Field production_incharge
        $this->production_incharge->AdvancedSearch->SearchValue = @$filter["x_production_incharge"];
        $this->production_incharge->AdvancedSearch->SearchOperator = @$filter["z_production_incharge"];
        $this->production_incharge->AdvancedSearch->SearchCondition = @$filter["v_production_incharge"];
        $this->production_incharge->AdvancedSearch->SearchValue2 = @$filter["y_production_incharge"];
        $this->production_incharge->AdvancedSearch->SearchOperator2 = @$filter["w_production_incharge"];
        $this->production_incharge->AdvancedSearch->save();

        // Field production_email
        $this->production_email->AdvancedSearch->SearchValue = @$filter["x_production_email"];
        $this->production_email->AdvancedSearch->SearchOperator = @$filter["z_production_email"];
        $this->production_email->AdvancedSearch->SearchCondition = @$filter["v_production_email"];
        $this->production_email->AdvancedSearch->SearchValue2 = @$filter["y_production_email"];
        $this->production_email->AdvancedSearch->SearchOperator2 = @$filter["w_production_email"];
        $this->production_email->AdvancedSearch->save();

        // Field production_phone
        $this->production_phone->AdvancedSearch->SearchValue = @$filter["x_production_phone"];
        $this->production_phone->AdvancedSearch->SearchOperator = @$filter["z_production_phone"];
        $this->production_phone->AdvancedSearch->SearchCondition = @$filter["v_production_phone"];
        $this->production_phone->AdvancedSearch->SearchValue2 = @$filter["y_production_phone"];
        $this->production_phone->AdvancedSearch->SearchOperator2 = @$filter["w_production_phone"];
        $this->production_phone->AdvancedSearch->save();

        // Field qc_incharge
        $this->qc_incharge->AdvancedSearch->SearchValue = @$filter["x_qc_incharge"];
        $this->qc_incharge->AdvancedSearch->SearchOperator = @$filter["z_qc_incharge"];
        $this->qc_incharge->AdvancedSearch->SearchCondition = @$filter["v_qc_incharge"];
        $this->qc_incharge->AdvancedSearch->SearchValue2 = @$filter["y_qc_incharge"];
        $this->qc_incharge->AdvancedSearch->SearchOperator2 = @$filter["w_qc_incharge"];
        $this->qc_incharge->AdvancedSearch->save();

        // Field qc_email
        $this->qc_email->AdvancedSearch->SearchValue = @$filter["x_qc_email"];
        $this->qc_email->AdvancedSearch->SearchOperator = @$filter["z_qc_email"];
        $this->qc_email->AdvancedSearch->SearchCondition = @$filter["v_qc_email"];
        $this->qc_email->AdvancedSearch->SearchValue2 = @$filter["y_qc_email"];
        $this->qc_email->AdvancedSearch->SearchOperator2 = @$filter["w_qc_email"];
        $this->qc_email->AdvancedSearch->save();

        // Field qc_phone
        $this->qc_phone->AdvancedSearch->SearchValue = @$filter["x_qc_phone"];
        $this->qc_phone->AdvancedSearch->SearchOperator = @$filter["z_qc_phone"];
        $this->qc_phone->AdvancedSearch->SearchCondition = @$filter["v_qc_phone"];
        $this->qc_phone->AdvancedSearch->SearchValue2 = @$filter["y_qc_phone"];
        $this->qc_phone->AdvancedSearch->SearchOperator2 = @$filter["w_qc_phone"];
        $this->qc_phone->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->name, $default, false); // name
        $this->buildSearchSql($where, $this->code, $default, false); // code
        $this->buildSearchSql($where, $this->country, $default, false); // country
        $this->buildSearchSql($where, $this->region, $default, false); // region
        $this->buildSearchSql($where, $this->city_name, $default, false); // city_name
        $this->buildSearchSql($where, $this->address, $default, false); // address
        $this->buildSearchSql($where, $this->mobile, $default, false); // mobile
        $this->buildSearchSql($where, $this->_email, $default, false); // email
        $this->buildSearchSql($where, $this->url, $default, false); // url
        $this->buildSearchSql($where, $this->bank_name, $default, false); // bank_name
        $this->buildSearchSql($where, $this->bank_account_no, $default, false); // bank_account_no
        $this->buildSearchSql($where, $this->bank_code, $default, false); // bank_code
        $this->buildSearchSql($where, $this->grp, $default, true); // grp
        $this->buildSearchSql($where, $this->category, $default, false); // category
        $this->buildSearchSql($where, $this->reports_to, $default, false); // reports_to
        $this->buildSearchSql($where, $this->status, $default, false); // status
        $this->buildSearchSql($where, $this->performance, $default, false); // performance
        $this->buildSearchSql($where, $this->operator, $default, false); // operator
        $this->buildSearchSql($where, $this->datetime, $default, false); // datetime
        $this->buildSearchSql($where, $this->tax_registration, $default, false); // tax_registration
        $this->buildSearchSql($where, $this->cin, $default, false); // cin
        $this->buildSearchSql($where, $this->pan, $default, false); // pan
        $this->buildSearchSql($where, $this->tan, $default, false); // tan
        $this->buildSearchSql($where, $this->msme, $default, false); // msme
        $this->buildSearchSql($where, $this->iec, $default, false); // iec
        $this->buildSearchSql($where, $this->rex, $default, false); // rex
        $this->buildSearchSql($where, $this->rcmc, $default, false); // rcmc
        $this->buildSearchSql($where, $this->delivery_terms, $default, false); // delivery_terms
        $this->buildSearchSql($where, $this->shipping_terms, $default, false); // shipping_terms
        $this->buildSearchSql($where, $this->payment_terms, $default, false); // payment_terms
        $this->buildSearchSql($where, $this->export_type, $default, false); // export_type
        $this->buildSearchSql($where, $this->lead_time_ss, $default, false); // lead_time_ss
        $this->buildSearchSql($where, $this->lead_time_cs, $default, false); // lead_time_cs
        $this->buildSearchSql($where, $this->cha, $default, false); // cha
        $this->buildSearchSql($where, $this->cha_email, $default, false); // cha_email
        $this->buildSearchSql($where, $this->cha_phone, $default, false); // cha_phone
        $this->buildSearchSql($where, $this->forwarder, $default, false); // forwarder
        $this->buildSearchSql($where, $this->forwarder_email, $default, false); // forwarder_email
        $this->buildSearchSql($where, $this->forwarder_phone, $default, false); // forwarder_phone
        $this->buildSearchSql($where, $this->merchant, $default, false); // merchant
        $this->buildSearchSql($where, $this->merchant_email, $default, false); // merchant_email
        $this->buildSearchSql($where, $this->merchant_phone, $default, false); // merchant_phone
        $this->buildSearchSql($where, $this->shipping_incharge, $default, false); // shipping_incharge
        $this->buildSearchSql($where, $this->shipping_email, $default, false); // shipping_email
        $this->buildSearchSql($where, $this->shipping_phone, $default, false); // shipping_phone
        $this->buildSearchSql($where, $this->account_incharge, $default, false); // account_incharge
        $this->buildSearchSql($where, $this->accounts_email, $default, false); // accounts_email
        $this->buildSearchSql($where, $this->accounts_phone, $default, false); // accounts_phone
        $this->buildSearchSql($where, $this->warehouse_incharge, $default, false); // warehouse_incharge
        $this->buildSearchSql($where, $this->warehouse_email, $default, false); // warehouse_email
        $this->buildSearchSql($where, $this->warehouse_phone, $default, false); // warehouse_phone
        $this->buildSearchSql($where, $this->production_incharge, $default, false); // production_incharge
        $this->buildSearchSql($where, $this->production_email, $default, false); // production_email
        $this->buildSearchSql($where, $this->production_phone, $default, false); // production_phone
        $this->buildSearchSql($where, $this->qc_incharge, $default, false); // qc_incharge
        $this->buildSearchSql($where, $this->qc_email, $default, false); // qc_email
        $this->buildSearchSql($where, $this->qc_phone, $default, false); // qc_phone

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->id->AdvancedSearch->save(); // id
            $this->name->AdvancedSearch->save(); // name
            $this->code->AdvancedSearch->save(); // code
            $this->country->AdvancedSearch->save(); // country
            $this->region->AdvancedSearch->save(); // region
            $this->city_name->AdvancedSearch->save(); // city_name
            $this->address->AdvancedSearch->save(); // address
            $this->mobile->AdvancedSearch->save(); // mobile
            $this->_email->AdvancedSearch->save(); // email
            $this->url->AdvancedSearch->save(); // url
            $this->bank_name->AdvancedSearch->save(); // bank_name
            $this->bank_account_no->AdvancedSearch->save(); // bank_account_no
            $this->bank_code->AdvancedSearch->save(); // bank_code
            $this->grp->AdvancedSearch->save(); // grp
            $this->category->AdvancedSearch->save(); // category
            $this->reports_to->AdvancedSearch->save(); // reports_to
            $this->status->AdvancedSearch->save(); // status
            $this->performance->AdvancedSearch->save(); // performance
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->tax_registration->AdvancedSearch->save(); // tax_registration
            $this->cin->AdvancedSearch->save(); // cin
            $this->pan->AdvancedSearch->save(); // pan
            $this->tan->AdvancedSearch->save(); // tan
            $this->msme->AdvancedSearch->save(); // msme
            $this->iec->AdvancedSearch->save(); // iec
            $this->rex->AdvancedSearch->save(); // rex
            $this->rcmc->AdvancedSearch->save(); // rcmc
            $this->delivery_terms->AdvancedSearch->save(); // delivery_terms
            $this->shipping_terms->AdvancedSearch->save(); // shipping_terms
            $this->payment_terms->AdvancedSearch->save(); // payment_terms
            $this->export_type->AdvancedSearch->save(); // export_type
            $this->lead_time_ss->AdvancedSearch->save(); // lead_time_ss
            $this->lead_time_cs->AdvancedSearch->save(); // lead_time_cs
            $this->cha->AdvancedSearch->save(); // cha
            $this->cha_email->AdvancedSearch->save(); // cha_email
            $this->cha_phone->AdvancedSearch->save(); // cha_phone
            $this->forwarder->AdvancedSearch->save(); // forwarder
            $this->forwarder_email->AdvancedSearch->save(); // forwarder_email
            $this->forwarder_phone->AdvancedSearch->save(); // forwarder_phone
            $this->merchant->AdvancedSearch->save(); // merchant
            $this->merchant_email->AdvancedSearch->save(); // merchant_email
            $this->merchant_phone->AdvancedSearch->save(); // merchant_phone
            $this->shipping_incharge->AdvancedSearch->save(); // shipping_incharge
            $this->shipping_email->AdvancedSearch->save(); // shipping_email
            $this->shipping_phone->AdvancedSearch->save(); // shipping_phone
            $this->account_incharge->AdvancedSearch->save(); // account_incharge
            $this->accounts_email->AdvancedSearch->save(); // accounts_email
            $this->accounts_phone->AdvancedSearch->save(); // accounts_phone
            $this->warehouse_incharge->AdvancedSearch->save(); // warehouse_incharge
            $this->warehouse_email->AdvancedSearch->save(); // warehouse_email
            $this->warehouse_phone->AdvancedSearch->save(); // warehouse_phone
            $this->production_incharge->AdvancedSearch->save(); // production_incharge
            $this->production_email->AdvancedSearch->save(); // production_email
            $this->production_phone->AdvancedSearch->save(); // production_phone
            $this->qc_incharge->AdvancedSearch->save(); // qc_incharge
            $this->qc_email->AdvancedSearch->save(); // qc_email
            $this->qc_phone->AdvancedSearch->save(); // qc_phone

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->id->AdvancedSearch->save(); // id
            $this->name->AdvancedSearch->save(); // name
            $this->code->AdvancedSearch->save(); // code
            $this->country->AdvancedSearch->save(); // country
            $this->region->AdvancedSearch->save(); // region
            $this->city_name->AdvancedSearch->save(); // city_name
            $this->address->AdvancedSearch->save(); // address
            $this->mobile->AdvancedSearch->save(); // mobile
            $this->_email->AdvancedSearch->save(); // email
            $this->url->AdvancedSearch->save(); // url
            $this->bank_name->AdvancedSearch->save(); // bank_name
            $this->bank_account_no->AdvancedSearch->save(); // bank_account_no
            $this->bank_code->AdvancedSearch->save(); // bank_code
            $this->grp->AdvancedSearch->save(); // grp
            $this->category->AdvancedSearch->save(); // category
            $this->reports_to->AdvancedSearch->save(); // reports_to
            $this->status->AdvancedSearch->save(); // status
            $this->performance->AdvancedSearch->save(); // performance
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->tax_registration->AdvancedSearch->save(); // tax_registration
            $this->cin->AdvancedSearch->save(); // cin
            $this->pan->AdvancedSearch->save(); // pan
            $this->tan->AdvancedSearch->save(); // tan
            $this->msme->AdvancedSearch->save(); // msme
            $this->iec->AdvancedSearch->save(); // iec
            $this->rex->AdvancedSearch->save(); // rex
            $this->rcmc->AdvancedSearch->save(); // rcmc
            $this->delivery_terms->AdvancedSearch->save(); // delivery_terms
            $this->shipping_terms->AdvancedSearch->save(); // shipping_terms
            $this->payment_terms->AdvancedSearch->save(); // payment_terms
            $this->export_type->AdvancedSearch->save(); // export_type
            $this->lead_time_ss->AdvancedSearch->save(); // lead_time_ss
            $this->lead_time_cs->AdvancedSearch->save(); // lead_time_cs
            $this->cha->AdvancedSearch->save(); // cha
            $this->cha_email->AdvancedSearch->save(); // cha_email
            $this->cha_phone->AdvancedSearch->save(); // cha_phone
            $this->forwarder->AdvancedSearch->save(); // forwarder
            $this->forwarder_email->AdvancedSearch->save(); // forwarder_email
            $this->forwarder_phone->AdvancedSearch->save(); // forwarder_phone
            $this->merchant->AdvancedSearch->save(); // merchant
            $this->merchant_email->AdvancedSearch->save(); // merchant_email
            $this->merchant_phone->AdvancedSearch->save(); // merchant_phone
            $this->shipping_incharge->AdvancedSearch->save(); // shipping_incharge
            $this->shipping_email->AdvancedSearch->save(); // shipping_email
            $this->shipping_phone->AdvancedSearch->save(); // shipping_phone
            $this->account_incharge->AdvancedSearch->save(); // account_incharge
            $this->accounts_email->AdvancedSearch->save(); // accounts_email
            $this->accounts_phone->AdvancedSearch->save(); // accounts_phone
            $this->warehouse_incharge->AdvancedSearch->save(); // warehouse_incharge
            $this->warehouse_email->AdvancedSearch->save(); // warehouse_email
            $this->warehouse_phone->AdvancedSearch->save(); // warehouse_phone
            $this->production_incharge->AdvancedSearch->save(); // production_incharge
            $this->production_email->AdvancedSearch->save(); // production_email
            $this->production_phone->AdvancedSearch->save(); // production_phone
            $this->qc_incharge->AdvancedSearch->save(); // qc_incharge
            $this->qc_email->AdvancedSearch->save(); // qc_email
            $this->qc_phone->AdvancedSearch->save(); // qc_phone
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field id
        $filter = $this->queryBuilderWhere("id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field name
        $filter = $this->queryBuilderWhere("name");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->name, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->name->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field code
        $filter = $this->queryBuilderWhere("code");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->code, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->code->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field country
        $filter = $this->queryBuilderWhere("country");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->country, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->country->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field region
        $filter = $this->queryBuilderWhere("region");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->region, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->region->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field city_name
        $filter = $this->queryBuilderWhere("city_name");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->city_name, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->city_name->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field address
        $filter = $this->queryBuilderWhere("address");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->address, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->address->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field mobile
        $filter = $this->queryBuilderWhere("mobile");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->mobile, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->mobile->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field email
        $filter = $this->queryBuilderWhere("email");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_email, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_email->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field url
        $filter = $this->queryBuilderWhere("url");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->url, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->url->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field bank_name
        $filter = $this->queryBuilderWhere("bank_name");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->bank_name, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->bank_name->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field bank_account_no
        $filter = $this->queryBuilderWhere("bank_account_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->bank_account_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->bank_account_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field bank_code
        $filter = $this->queryBuilderWhere("bank_code");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->bank_code, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->bank_code->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field grp
        $filter = $this->queryBuilderWhere("grp");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->grp, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->grp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field category
        $filter = $this->queryBuilderWhere("category");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->category, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->category->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field reports_to
        $filter = $this->queryBuilderWhere("reports_to");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->reports_to, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->reports_to->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field status
        $filter = $this->queryBuilderWhere("status");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->status, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->status->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field performance
        $filter = $this->queryBuilderWhere("performance");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->performance, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->performance->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field operator
        $filter = $this->queryBuilderWhere("operator");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->operator, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->operator->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field datetime
        $filter = $this->queryBuilderWhere("datetime");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->datetime, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->datetime->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field tax_registration
        $filter = $this->queryBuilderWhere("tax_registration");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->tax_registration, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->tax_registration->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field cin
        $filter = $this->queryBuilderWhere("cin");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->cin, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->cin->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pan
        $filter = $this->queryBuilderWhere("pan");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pan, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pan->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field tan
        $filter = $this->queryBuilderWhere("tan");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->tan, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->tan->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field msme
        $filter = $this->queryBuilderWhere("msme");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->msme, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->msme->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field iec
        $filter = $this->queryBuilderWhere("iec");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->iec, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->iec->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field rex
        $filter = $this->queryBuilderWhere("rex");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->rex, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->rex->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field rcmc
        $filter = $this->queryBuilderWhere("rcmc");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->rcmc, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->rcmc->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field delivery_terms
        $filter = $this->queryBuilderWhere("delivery_terms");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->delivery_terms, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->delivery_terms->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field shipping_terms
        $filter = $this->queryBuilderWhere("shipping_terms");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->shipping_terms, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->shipping_terms->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field payment_terms
        $filter = $this->queryBuilderWhere("payment_terms");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->payment_terms, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->payment_terms->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field export_type
        $filter = $this->queryBuilderWhere("export_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->export_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->export_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field lead_time_ss
        $filter = $this->queryBuilderWhere("lead_time_ss");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->lead_time_ss, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->lead_time_ss->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field lead_time_cs
        $filter = $this->queryBuilderWhere("lead_time_cs");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->lead_time_cs, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->lead_time_cs->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field cha
        $filter = $this->queryBuilderWhere("cha");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->cha, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->cha->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field cha_email
        $filter = $this->queryBuilderWhere("cha_email");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->cha_email, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->cha_email->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field cha_phone
        $filter = $this->queryBuilderWhere("cha_phone");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->cha_phone, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->cha_phone->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field forwarder
        $filter = $this->queryBuilderWhere("forwarder");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->forwarder, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->forwarder->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field forwarder_email
        $filter = $this->queryBuilderWhere("forwarder_email");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->forwarder_email, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->forwarder_email->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field forwarder_phone
        $filter = $this->queryBuilderWhere("forwarder_phone");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->forwarder_phone, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->forwarder_phone->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field merchant
        $filter = $this->queryBuilderWhere("merchant");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->merchant, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->merchant->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field merchant_email
        $filter = $this->queryBuilderWhere("merchant_email");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->merchant_email, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->merchant_email->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field merchant_phone
        $filter = $this->queryBuilderWhere("merchant_phone");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->merchant_phone, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->merchant_phone->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field shipping_incharge
        $filter = $this->queryBuilderWhere("shipping_incharge");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->shipping_incharge, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->shipping_incharge->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field shipping_email
        $filter = $this->queryBuilderWhere("shipping_email");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->shipping_email, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->shipping_email->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field shipping_phone
        $filter = $this->queryBuilderWhere("shipping_phone");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->shipping_phone, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->shipping_phone->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field account_incharge
        $filter = $this->queryBuilderWhere("account_incharge");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->account_incharge, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->account_incharge->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field accounts_email
        $filter = $this->queryBuilderWhere("accounts_email");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->accounts_email, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->accounts_email->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field accounts_phone
        $filter = $this->queryBuilderWhere("accounts_phone");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->accounts_phone, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->accounts_phone->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field warehouse_incharge
        $filter = $this->queryBuilderWhere("warehouse_incharge");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->warehouse_incharge, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->warehouse_incharge->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field warehouse_email
        $filter = $this->queryBuilderWhere("warehouse_email");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->warehouse_email, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->warehouse_email->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field warehouse_phone
        $filter = $this->queryBuilderWhere("warehouse_phone");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->warehouse_phone, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->warehouse_phone->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field production_incharge
        $filter = $this->queryBuilderWhere("production_incharge");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->production_incharge, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->production_incharge->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field production_email
        $filter = $this->queryBuilderWhere("production_email");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->production_email, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->production_email->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field production_phone
        $filter = $this->queryBuilderWhere("production_phone");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->production_phone, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->production_phone->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qc_incharge
        $filter = $this->queryBuilderWhere("qc_incharge");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qc_incharge, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qc_incharge->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qc_email
        $filter = $this->queryBuilderWhere("qc_email");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qc_email, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qc_email->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qc_phone
        $filter = $this->queryBuilderWhere("qc_phone");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qc_phone, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qc_phone->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->name;
        $searchFlds[] = &$this->code;
        $searchFlds[] = &$this->city_name;
        $searchFlds[] = &$this->address;
        $searchFlds[] = &$this->mobile;
        $searchFlds[] = &$this->_email;
        $searchFlds[] = &$this->url;
        $searchFlds[] = &$this->bank_name;
        $searchFlds[] = &$this->bank_account_no;
        $searchFlds[] = &$this->bank_code;
        $searchFlds[] = &$this->tax_registration;
        $searchFlds[] = &$this->cha_email;
        $searchFlds[] = &$this->cha_phone;
        $searchFlds[] = &$this->forwarder_email;
        $searchFlds[] = &$this->forwarder_phone;
        $searchFlds[] = &$this->merchant;
        $searchFlds[] = &$this->merchant_email;
        $searchFlds[] = &$this->merchant_phone;
        $searchFlds[] = &$this->shipping_incharge;
        $searchFlds[] = &$this->shipping_email;
        $searchFlds[] = &$this->shipping_phone;
        $searchFlds[] = &$this->account_incharge;
        $searchFlds[] = &$this->accounts_email;
        $searchFlds[] = &$this->accounts_phone;
        $searchFlds[] = &$this->warehouse_incharge;
        $searchFlds[] = &$this->warehouse_email;
        $searchFlds[] = &$this->warehouse_phone;
        $searchFlds[] = &$this->production_incharge;
        $searchFlds[] = &$this->production_email;
        $searchFlds[] = &$this->production_phone;
        $searchFlds[] = &$this->qc_incharge;
        $searchFlds[] = &$this->qc_email;
        $searchFlds[] = &$this->qc_phone;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->name->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->code->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->country->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->region->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->city_name->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->address->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->mobile->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_email->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->url->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->bank_name->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->bank_account_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->bank_code->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->category->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->reports_to->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->performance->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->tax_registration->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cin->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pan->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->tan->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->msme->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->iec->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->rex->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->rcmc->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->delivery_terms->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->shipping_terms->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->payment_terms->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->export_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->lead_time_ss->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->lead_time_cs->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cha->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cha_email->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cha_phone->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->forwarder->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->forwarder_email->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->forwarder_phone->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->merchant->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->merchant_email->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->merchant_phone->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->shipping_incharge->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->shipping_email->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->shipping_phone->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->account_incharge->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->accounts_email->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->accounts_phone->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->warehouse_incharge->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->warehouse_email->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->warehouse_phone->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->production_incharge->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->production_email->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->production_phone->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qc_incharge->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qc_email->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qc_phone->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->id->AdvancedSearch->unsetSession();
        $this->name->AdvancedSearch->unsetSession();
        $this->code->AdvancedSearch->unsetSession();
        $this->country->AdvancedSearch->unsetSession();
        $this->region->AdvancedSearch->unsetSession();
        $this->city_name->AdvancedSearch->unsetSession();
        $this->address->AdvancedSearch->unsetSession();
        $this->mobile->AdvancedSearch->unsetSession();
        $this->_email->AdvancedSearch->unsetSession();
        $this->url->AdvancedSearch->unsetSession();
        $this->bank_name->AdvancedSearch->unsetSession();
        $this->bank_account_no->AdvancedSearch->unsetSession();
        $this->bank_code->AdvancedSearch->unsetSession();
        $this->grp->AdvancedSearch->unsetSession();
        $this->category->AdvancedSearch->unsetSession();
        $this->reports_to->AdvancedSearch->unsetSession();
        $this->status->AdvancedSearch->unsetSession();
        $this->performance->AdvancedSearch->unsetSession();
        $this->operator->AdvancedSearch->unsetSession();
        $this->datetime->AdvancedSearch->unsetSession();
        $this->tax_registration->AdvancedSearch->unsetSession();
        $this->cin->AdvancedSearch->unsetSession();
        $this->pan->AdvancedSearch->unsetSession();
        $this->tan->AdvancedSearch->unsetSession();
        $this->msme->AdvancedSearch->unsetSession();
        $this->iec->AdvancedSearch->unsetSession();
        $this->rex->AdvancedSearch->unsetSession();
        $this->rcmc->AdvancedSearch->unsetSession();
        $this->delivery_terms->AdvancedSearch->unsetSession();
        $this->shipping_terms->AdvancedSearch->unsetSession();
        $this->payment_terms->AdvancedSearch->unsetSession();
        $this->export_type->AdvancedSearch->unsetSession();
        $this->lead_time_ss->AdvancedSearch->unsetSession();
        $this->lead_time_cs->AdvancedSearch->unsetSession();
        $this->cha->AdvancedSearch->unsetSession();
        $this->cha_email->AdvancedSearch->unsetSession();
        $this->cha_phone->AdvancedSearch->unsetSession();
        $this->forwarder->AdvancedSearch->unsetSession();
        $this->forwarder_email->AdvancedSearch->unsetSession();
        $this->forwarder_phone->AdvancedSearch->unsetSession();
        $this->merchant->AdvancedSearch->unsetSession();
        $this->merchant_email->AdvancedSearch->unsetSession();
        $this->merchant_phone->AdvancedSearch->unsetSession();
        $this->shipping_incharge->AdvancedSearch->unsetSession();
        $this->shipping_email->AdvancedSearch->unsetSession();
        $this->shipping_phone->AdvancedSearch->unsetSession();
        $this->account_incharge->AdvancedSearch->unsetSession();
        $this->accounts_email->AdvancedSearch->unsetSession();
        $this->accounts_phone->AdvancedSearch->unsetSession();
        $this->warehouse_incharge->AdvancedSearch->unsetSession();
        $this->warehouse_email->AdvancedSearch->unsetSession();
        $this->warehouse_phone->AdvancedSearch->unsetSession();
        $this->production_incharge->AdvancedSearch->unsetSession();
        $this->production_email->AdvancedSearch->unsetSession();
        $this->production_phone->AdvancedSearch->unsetSession();
        $this->qc_incharge->AdvancedSearch->unsetSession();
        $this->qc_email->AdvancedSearch->unsetSession();
        $this->qc_phone->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->id->AdvancedSearch->load();
        $this->name->AdvancedSearch->load();
        $this->code->AdvancedSearch->load();
        $this->country->AdvancedSearch->load();
        $this->region->AdvancedSearch->load();
        $this->city_name->AdvancedSearch->load();
        $this->address->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->_email->AdvancedSearch->load();
        $this->url->AdvancedSearch->load();
        $this->bank_name->AdvancedSearch->load();
        $this->bank_account_no->AdvancedSearch->load();
        $this->bank_code->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->reports_to->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->performance->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->tax_registration->AdvancedSearch->load();
        $this->cin->AdvancedSearch->load();
        $this->pan->AdvancedSearch->load();
        $this->tan->AdvancedSearch->load();
        $this->msme->AdvancedSearch->load();
        $this->iec->AdvancedSearch->load();
        $this->rex->AdvancedSearch->load();
        $this->rcmc->AdvancedSearch->load();
        $this->delivery_terms->AdvancedSearch->load();
        $this->shipping_terms->AdvancedSearch->load();
        $this->payment_terms->AdvancedSearch->load();
        $this->export_type->AdvancedSearch->load();
        $this->lead_time_ss->AdvancedSearch->load();
        $this->lead_time_cs->AdvancedSearch->load();
        $this->cha->AdvancedSearch->load();
        $this->cha_email->AdvancedSearch->load();
        $this->cha_phone->AdvancedSearch->load();
        $this->forwarder->AdvancedSearch->load();
        $this->forwarder_email->AdvancedSearch->load();
        $this->forwarder_phone->AdvancedSearch->load();
        $this->merchant->AdvancedSearch->load();
        $this->merchant_email->AdvancedSearch->load();
        $this->merchant_phone->AdvancedSearch->load();
        $this->shipping_incharge->AdvancedSearch->load();
        $this->shipping_email->AdvancedSearch->load();
        $this->shipping_phone->AdvancedSearch->load();
        $this->account_incharge->AdvancedSearch->load();
        $this->accounts_email->AdvancedSearch->load();
        $this->accounts_phone->AdvancedSearch->load();
        $this->warehouse_incharge->AdvancedSearch->load();
        $this->warehouse_email->AdvancedSearch->load();
        $this->warehouse_phone->AdvancedSearch->load();
        $this->production_incharge->AdvancedSearch->load();
        $this->production_email->AdvancedSearch->load();
        $this->production_phone->AdvancedSearch->load();
        $this->qc_incharge->AdvancedSearch->load();
        $this->qc_email->AdvancedSearch->load();
        $this->qc_phone->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->name->Expression . " ASC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for Ctrl pressed
        $ctrl = Get("ctrl") !== null;

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id, $ctrl); // id
            $this->updateSort($this->name, $ctrl); // name
            $this->updateSort($this->code, $ctrl); // code
            $this->updateSort($this->country, $ctrl); // country
            $this->updateSort($this->region, $ctrl); // region
            $this->updateSort($this->city_name, $ctrl); // city_name
            $this->updateSort($this->address, $ctrl); // address
            $this->updateSort($this->mobile, $ctrl); // mobile
            $this->updateSort($this->_email, $ctrl); // email
            $this->updateSort($this->url, $ctrl); // url
            $this->updateSort($this->bank_name, $ctrl); // bank_name
            $this->updateSort($this->bank_account_no, $ctrl); // bank_account_no
            $this->updateSort($this->bank_code, $ctrl); // bank_code
            $this->updateSort($this->grp, $ctrl); // grp
            $this->updateSort($this->category, $ctrl); // category
            $this->updateSort($this->reports_to, $ctrl); // reports_to
            $this->updateSort($this->status, $ctrl); // status
            $this->updateSort($this->performance, $ctrl); // performance
            $this->updateSort($this->operator, $ctrl); // operator
            $this->updateSort($this->datetime, $ctrl); // datetime
            $this->updateSort($this->type, $ctrl); // type
            $this->updateSort($this->tax_registration, $ctrl); // tax_registration
            $this->updateSort($this->cin, $ctrl); // cin
            $this->updateSort($this->pan, $ctrl); // pan
            $this->updateSort($this->tan, $ctrl); // tan
            $this->updateSort($this->msme, $ctrl); // msme
            $this->updateSort($this->port_air, $ctrl); // port_air
            $this->updateSort($this->port_sea, $ctrl); // port_sea
            $this->updateSort($this->iec, $ctrl); // iec
            $this->updateSort($this->rex, $ctrl); // rex
            $this->updateSort($this->rcmc, $ctrl); // rcmc
            $this->updateSort($this->delivery_terms, $ctrl); // delivery_terms
            $this->updateSort($this->shipping_terms, $ctrl); // shipping_terms
            $this->updateSort($this->payment_terms, $ctrl); // payment_terms
            $this->updateSort($this->export_type, $ctrl); // export_type
            $this->updateSort($this->lead_time_ss, $ctrl); // lead_time_ss
            $this->updateSort($this->lead_time_cs, $ctrl); // lead_time_cs
            $this->updateSort($this->cha, $ctrl); // cha
            $this->updateSort($this->cha_email, $ctrl); // cha_email
            $this->updateSort($this->cha_phone, $ctrl); // cha_phone
            $this->updateSort($this->forwarder, $ctrl); // forwarder
            $this->updateSort($this->forwarder_email, $ctrl); // forwarder_email
            $this->updateSort($this->forwarder_phone, $ctrl); // forwarder_phone
            $this->updateSort($this->merchant, $ctrl); // merchant
            $this->updateSort($this->merchant_email, $ctrl); // merchant_email
            $this->updateSort($this->merchant_phone, $ctrl); // merchant_phone
            $this->updateSort($this->shipping_incharge, $ctrl); // shipping_incharge
            $this->updateSort($this->shipping_email, $ctrl); // shipping_email
            $this->updateSort($this->shipping_phone, $ctrl); // shipping_phone
            $this->updateSort($this->account_incharge, $ctrl); // account_incharge
            $this->updateSort($this->accounts_email, $ctrl); // accounts_email
            $this->updateSort($this->accounts_phone, $ctrl); // accounts_phone
            $this->updateSort($this->warehouse_incharge, $ctrl); // warehouse_incharge
            $this->updateSort($this->warehouse_email, $ctrl); // warehouse_email
            $this->updateSort($this->warehouse_phone, $ctrl); // warehouse_phone
            $this->updateSort($this->production_incharge, $ctrl); // production_incharge
            $this->updateSort($this->production_email, $ctrl); // production_email
            $this->updateSort($this->production_phone, $ctrl); // production_phone
            $this->updateSort($this->qc_incharge, $ctrl); // qc_incharge
            $this->updateSort($this->qc_email, $ctrl); // qc_email
            $this->updateSort($this->qc_phone, $ctrl); // qc_phone
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->id->setSort("");
                $this->name->setSort("");
                $this->code->setSort("");
                $this->country->setSort("");
                $this->region->setSort("");
                $this->city->setSort("");
                $this->city_name->setSort("");
                $this->address->setSort("");
                $this->mobile->setSort("");
                $this->_email->setSort("");
                $this->url->setSort("");
                $this->bank_name->setSort("");
                $this->bank_account_no->setSort("");
                $this->bank_code->setSort("");
                $this->grp->setSort("");
                $this->category->setSort("");
                $this->reports_to->setSort("");
                $this->status->setSort("");
                $this->performance->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
                $this->type->setSort("");
                $this->tax_registration->setSort("");
                $this->cin->setSort("");
                $this->pan->setSort("");
                $this->tan->setSort("");
                $this->msme->setSort("");
                $this->incoterm->setSort("");
                $this->port_air->setSort("");
                $this->port_sea->setSort("");
                $this->iec->setSort("");
                $this->rex->setSort("");
                $this->rcmc->setSort("");
                $this->delivery_terms->setSort("");
                $this->shipping_terms->setSort("");
                $this->payment_terms->setSort("");
                $this->export_type->setSort("");
                $this->lead_time_ss->setSort("");
                $this->lead_time_cs->setSort("");
                $this->cha->setSort("");
                $this->cha_email->setSort("");
                $this->cha_phone->setSort("");
                $this->forwarder->setSort("");
                $this->forwarder_email->setSort("");
                $this->forwarder_phone->setSort("");
                $this->merchant->setSort("");
                $this->merchant_email->setSort("");
                $this->merchant_phone->setSort("");
                $this->shipping_incharge->setSort("");
                $this->shipping_email->setSort("");
                $this->shipping_phone->setSort("");
                $this->account_incharge->setSort("");
                $this->accounts_email->setSort("");
                $this->accounts_phone->setSort("");
                $this->warehouse_incharge->setSort("");
                $this->warehouse_email->setSort("");
                $this->warehouse_phone->setSort("");
                $this->production_incharge->setSort("");
                $this->production_email->setSort("");
                $this->production_phone->setSort("");
                $this->qc_incharge->setSort("");
                $this->qc_email->setSort("");
                $this->qc_phone->setSort("");
                $this->uid->setSort("");
                $this->r_text->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "delete"
        $item = &$this->ListOptions->add("delete");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;

        // "detail_shipping_address"
        $item = &$this->ListOptions->add("detail_shipping_address");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'shipping_address');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // "detail_bank_info"
        $item = &$this->ListOptions->add("detail_bank_info");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'bank_info');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // "detail_capacity_plan"
        $item = &$this->ListOptions->add("detail_capacity_plan");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'capacity_plan');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // Multiple details
        if ($this->ShowMultipleDetails) {
            $item = &$this->ListOptions->add("details");
            $item->CssClass = "text-nowrap";
            $item->Visible = $this->ShowMultipleDetails && $this->ListOptions->detailVisible();
            $item->OnLeft = true;
            $item->ShowInButtonGroup = false;
            $this->ListOptions->hideDetailItems();
        }

        // Set up detail pages
        $pages = new SubPages();
        $pages->add("shipping_address");
        $pages->add("bank_info");
        $pages->add("capacity_plan");
        $this->DetailPages = $pages;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"production_partner\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"production_partner\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"production_partner\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "delete"
            $opt = $this->ListOptions["delete"];
            if ($Security->canDelete()) {
                $deleteCaption = $Language->phrase("DeleteLink");
                $deleteTitle = HtmlTitle($deleteCaption);
                if ($this->UseAjaxActions) {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\" data-ew-action=\"inline\" data-action=\"delete\" title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" data-key= \"" . HtmlEncode($this->getKey(true)) . "\" data-url=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\"" .
                        ($this->InlineDelete ? " data-ew-action=\"inline-delete\"" : "") .
                        " title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fproduction_partnerlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fproduction_partnerlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }
        $detailViewTblVar = "";
        $detailCopyTblVar = "";
        $detailEditTblVar = "";

        // "detail_shipping_address"
        $opt = $this->ListOptions["detail_shipping_address"];
        if ($Security->allowList(CurrentProjectID() . 'shipping_address')) {
            $body = $Language->phrase("DetailLink") . $Language->tablePhrase("shipping_address", "TblCaption");
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("shippingaddresslist?" . Config("TABLE_SHOW_MASTER") . "=production_partner&" . GetForeignKeyUrl("fk_id", $this->id->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("ShippingAddressGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=shipping_address");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "shipping_address";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=shipping_address");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "shipping_address";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=shipping_address");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "shipping_address";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }

        // "detail_bank_info"
        $opt = $this->ListOptions["detail_bank_info"];
        if ($Security->allowList(CurrentProjectID() . 'bank_info')) {
            $body = $Language->phrase("DetailLink") . $Language->tablePhrase("bank_info", "TblCaption");
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("bankinfolist?" . Config("TABLE_SHOW_MASTER") . "=production_partner&" . GetForeignKeyUrl("fk_id", $this->id->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("BankInfoGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=bank_info");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "bank_info";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=bank_info");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "bank_info";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=bank_info");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "bank_info";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }

        // "detail_capacity_plan"
        $opt = $this->ListOptions["detail_capacity_plan"];
        if ($Security->allowList(CurrentProjectID() . 'capacity_plan')) {
            $body = $Language->phrase("DetailLink") . $Language->tablePhrase("capacity_plan", "TblCaption");
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("capacityplanlist?" . Config("TABLE_SHOW_MASTER") . "=production_partner&" . GetForeignKeyUrl("fk_id", $this->id->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("CapacityPlanGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=capacity_plan");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "capacity_plan";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=capacity_plan");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "capacity_plan";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=capacity_plan");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "capacity_plan";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }
        if ($this->ShowMultipleDetails) {
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
            $links = "";
            if ($detailViewTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailViewLink", true)) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailViewTblVar)) . "\">" . $Language->phrase("MasterDetailViewLink", null) . "</a></li>";
            }
            if ($detailEditTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailEditLink", true)) . "\" href=\"" . HtmlEncode($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailEditTblVar)) . "\">" . $Language->phrase("MasterDetailEditLink", null) . "</a></li>";
            }
            if ($detailCopyTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailCopyLink", true)) . "\" href=\"" . HtmlEncode($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailCopyTblVar)) . "\">" . $Language->phrase("MasterDetailCopyLink", null) . "</a></li>";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlEncode($Language->phrase("MultipleMasterDetails", true)) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
                $body .= "<ul class=\"dropdown-menu ew-dropdown-menu\">" . $links . "</ul>";
            }
            $body .= "</div>";
            // Multiple details
            $opt = $this->ListOptions["details"];
            $opt->Body = $body;
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;

        // Preview extension
        $links = "";
        $detailFilters = [];
        $masterKeys = []; // Reset
        $masterKeys["id"] = strval($this->id->DbValue);

        // Column "detail_shipping_address"
        if ($this->DetailPages?->getItem("shipping_address")?->Visible && $Security->allowList(CurrentProjectID() . 'shipping_address')) {
            $link = "";
            $option = $this->ListOptions["detail_shipping_address"];
            $detailTbl = Container("shipping_address");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "shippingaddresspreview?t=production_partner&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"shipping_address\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'production_partner')) {
                $label = $Language->tablePhrase("shipping_address", "TblCaption");
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"shipping_address\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("shippingaddresslist?" . Config("TABLE_SHOW_MASTER") . "=production_partner");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("shipping_address", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . $title . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("ShippingAddressGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailViewLink");
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=shipping_address"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailEditLink");
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=shipping_address"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailCopyLink");
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=shipping_address"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }
        $masterKeys = []; // Reset
        $masterKeys["id"] = strval($this->id->DbValue);

        // Column "detail_bank_info"
        if ($this->DetailPages?->getItem("bank_info")?->Visible && $Security->allowList(CurrentProjectID() . 'bank_info')) {
            $link = "";
            $option = $this->ListOptions["detail_bank_info"];
            $detailTbl = Container("bank_info");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "bankinfopreview?t=production_partner&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"bank_info\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'production_partner')) {
                $label = $Language->tablePhrase("bank_info", "TblCaption");
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"bank_info\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("bankinfolist?" . Config("TABLE_SHOW_MASTER") . "=production_partner");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("bank_info", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . $title . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("BankInfoGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailViewLink");
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=bank_info"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailEditLink");
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=bank_info"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailCopyLink");
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=bank_info"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }
        $masterKeys = []; // Reset
        $masterKeys["id"] = strval($this->id->DbValue);

        // Column "detail_capacity_plan"
        if ($this->DetailPages?->getItem("capacity_plan")?->Visible && $Security->allowList(CurrentProjectID() . 'capacity_plan')) {
            $link = "";
            $option = $this->ListOptions["detail_capacity_plan"];
            $detailTbl = Container("capacity_plan");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "capacityplanpreview?t=production_partner&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"capacity_plan\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'production_partner')) {
                $label = $Language->tablePhrase("capacity_plan", "TblCaption");
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"capacity_plan\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("capacityplanlist?" . Config("TABLE_SHOW_MASTER") . "=production_partner");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("capacity_plan", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . $title . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("CapacityPlanGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailViewLink");
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=capacity_plan"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailEditLink");
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=capacity_plan"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'production_partner')) {
                $caption = $Language->phrase("MasterDetailCopyLink");
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=capacity_plan"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }

        // Add row attributes for expandable row
        if ($this->RowType == RowType::VIEW) {
            $this->RowAttrs["data-widget"] = "expandable-table";
            $this->RowAttrs["aria-expanded"] = "false";
        }

        // Column "preview"
        $option = $this->ListOptions["preview"];
        if (!$option) { // Add preview column
            $option = &$this->ListOptions->add("preview");
            $option->OnLeft = true;
            $checkboxPos = $this->ListOptions->itemPos("checkbox");
            $pos = $checkboxPos === false
                ? ($option->OnLeft ? 0 : -1)
                : ($option->OnLeft ? $checkboxPos + 1 : $checkboxPos);
            $option->moveTo($pos);
            $option->Visible = !($this->isExport() || $this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit());
            $option->ShowInDropDown = false;
            $option->ShowInButtonGroup = false;
        }
        if ($option) {
            $icon = "fa-solid fa-caret-right fa-fw"; // Right
            if (property_exists($this, "MultiColumnLayout") && $this->MultiColumnLayout == "table") {
                $option->CssStyle = "width: 1%;";
                if (!$option->OnLeft) {
                    $icon = preg_replace('/\\bright\\b/', "left", $icon);
                }
            }
            if (IsRTL()) { // Reverse
                if (preg_match('/\\bleft\\b/', $icon)) {
                    $icon = preg_replace('/\\bleft\\b/', "right", $icon);
                } elseif (preg_match('/\\bright\\b/', $icon)) {
                    $icon = preg_replace('/\\bright\\b/', "left", $icon);
                }
            }
            $option->Body = "<i role=\"button\" class=\"ew-preview-btn expandable-table-caret ew-icon " . $icon . "\"></i>" .
                "<div class=\"ew-preview d-none\">" . $links . "</div>";
            if ($option->Visible) {
                $option->Visible = $links != "";
            }
        }

        // Column "details" (Multiple details)
        $option = $this->ListOptions["details"];
        if ($option) {
            $option->Body .= "<div class=\"ew-preview d-none\">" . $links . "</div>";
            if ($option->Visible) {
                $option->Visible = $links != "";
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"production_partner\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["detail"];
        $detailTableLink = "";
        $item = &$option->add("detailadd_shipping_address");
        $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=shipping_address");
        $detailPage = Container("ShippingAddressGrid");
        $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
        $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
        $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'production_partner') && $Security->canAdd());
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "shipping_address";
        }
        $item = &$option->add("detailadd_bank_info");
        $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=bank_info");
        $detailPage = Container("BankInfoGrid");
        $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
        $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
        $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'production_partner') && $Security->canAdd());
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "bank_info";
        }
        $item = &$option->add("detailadd_capacity_plan");
        $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=capacity_plan");
        $detailPage = Container("CapacityPlanGrid");
        $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
        $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
        $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'production_partner') && $Security->canAdd());
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "capacity_plan";
        }

        // Add multiple details
        if ($this->ShowMultipleDetails) {
            $item = &$option->add("detailsadd");
            $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailTableLink);
            $caption = $Language->phrase("AddMasterDetailLink");
            $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
            $item->Visible = $detailTableLink != "" && $Security->canAdd();
            // Hide single master/detail items
            $ar = explode(",", $detailTableLink);
            $cnt = count($ar);
            for ($i = 0; $i < $cnt; $i++) {
                if ($item = $option["detailadd_" . $ar[$i]]) {
                    $item->Visible = false;
                }
            }
        }
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "name");
            $this->createColumnOption($option, "code");
            $this->createColumnOption($option, "country");
            $this->createColumnOption($option, "region");
            $this->createColumnOption($option, "city_name");
            $this->createColumnOption($option, "address");
            $this->createColumnOption($option, "mobile");
            $this->createColumnOption($option, "email");
            $this->createColumnOption($option, "url");
            $this->createColumnOption($option, "bank_name");
            $this->createColumnOption($option, "bank_account_no");
            $this->createColumnOption($option, "bank_code");
            $this->createColumnOption($option, "grp");
            $this->createColumnOption($option, "category");
            $this->createColumnOption($option, "reports_to");
            $this->createColumnOption($option, "status");
            $this->createColumnOption($option, "performance");
            $this->createColumnOption($option, "operator");
            $this->createColumnOption($option, "datetime");
            $this->createColumnOption($option, "type");
            $this->createColumnOption($option, "tax_registration");
            $this->createColumnOption($option, "cin");
            $this->createColumnOption($option, "pan");
            $this->createColumnOption($option, "tan");
            $this->createColumnOption($option, "msme");
            $this->createColumnOption($option, "port_air");
            $this->createColumnOption($option, "port_sea");
            $this->createColumnOption($option, "iec");
            $this->createColumnOption($option, "rex");
            $this->createColumnOption($option, "rcmc");
            $this->createColumnOption($option, "delivery_terms");
            $this->createColumnOption($option, "shipping_terms");
            $this->createColumnOption($option, "payment_terms");
            $this->createColumnOption($option, "export_type");
            $this->createColumnOption($option, "lead_time_ss");
            $this->createColumnOption($option, "lead_time_cs");
            $this->createColumnOption($option, "cha");
            $this->createColumnOption($option, "cha_email");
            $this->createColumnOption($option, "cha_phone");
            $this->createColumnOption($option, "forwarder");
            $this->createColumnOption($option, "forwarder_email");
            $this->createColumnOption($option, "forwarder_phone");
            $this->createColumnOption($option, "merchant");
            $this->createColumnOption($option, "merchant_email");
            $this->createColumnOption($option, "merchant_phone");
            $this->createColumnOption($option, "shipping_incharge");
            $this->createColumnOption($option, "shipping_email");
            $this->createColumnOption($option, "shipping_phone");
            $this->createColumnOption($option, "account_incharge");
            $this->createColumnOption($option, "accounts_email");
            $this->createColumnOption($option, "accounts_phone");
            $this->createColumnOption($option, "warehouse_incharge");
            $this->createColumnOption($option, "warehouse_email");
            $this->createColumnOption($option, "warehouse_phone");
            $this->createColumnOption($option, "production_incharge");
            $this->createColumnOption($option, "production_email");
            $this->createColumnOption($option, "production_phone");
            $this->createColumnOption($option, "qc_incharge");
            $this->createColumnOption($option, "qc_email");
            $this->createColumnOption($option, "qc_phone");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fproduction_partnersrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fproduction_partnersrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fproduction_partnerlist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_production_partner", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_production_partner",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // name
        if ($this->name->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->name->AdvancedSearch->SearchValue != "" || $this->name->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // code
        if ($this->code->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->code->AdvancedSearch->SearchValue != "" || $this->code->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // country
        if ($this->country->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->country->AdvancedSearch->SearchValue != "" || $this->country->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // region
        if ($this->region->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->region->AdvancedSearch->SearchValue != "" || $this->region->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // city_name
        if ($this->city_name->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->city_name->AdvancedSearch->SearchValue != "" || $this->city_name->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // address
        if ($this->address->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->address->AdvancedSearch->SearchValue != "" || $this->address->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // mobile
        if ($this->mobile->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->mobile->AdvancedSearch->SearchValue != "" || $this->mobile->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // email
        if ($this->_email->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_email->AdvancedSearch->SearchValue != "" || $this->_email->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // url
        if ($this->url->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->url->AdvancedSearch->SearchValue != "" || $this->url->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // bank_name
        if ($this->bank_name->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->bank_name->AdvancedSearch->SearchValue != "" || $this->bank_name->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // bank_account_no
        if ($this->bank_account_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->bank_account_no->AdvancedSearch->SearchValue != "" || $this->bank_account_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // bank_code
        if ($this->bank_code->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->bank_code->AdvancedSearch->SearchValue != "" || $this->bank_code->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->grp->AdvancedSearch->SearchValue != "" || $this->grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->grp->AdvancedSearch->SearchValue)) {
            $this->grp->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->grp->AdvancedSearch->SearchValue);
        }
        if (is_array($this->grp->AdvancedSearch->SearchValue2)) {
            $this->grp->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->grp->AdvancedSearch->SearchValue2);
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->category->AdvancedSearch->SearchValue != "" || $this->category->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // reports_to
        if ($this->reports_to->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->reports_to->AdvancedSearch->SearchValue != "" || $this->reports_to->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->status->AdvancedSearch->SearchValue != "" || $this->status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // performance
        if ($this->performance->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->performance->AdvancedSearch->SearchValue != "" || $this->performance->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator->AdvancedSearch->SearchValue != "" || $this->operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime->AdvancedSearch->SearchValue != "" || $this->datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // tax_registration
        if ($this->tax_registration->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->tax_registration->AdvancedSearch->SearchValue != "" || $this->tax_registration->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cin
        if ($this->cin->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cin->AdvancedSearch->SearchValue != "" || $this->cin->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pan
        if ($this->pan->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pan->AdvancedSearch->SearchValue != "" || $this->pan->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // tan
        if ($this->tan->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->tan->AdvancedSearch->SearchValue != "" || $this->tan->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // msme
        if ($this->msme->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->msme->AdvancedSearch->SearchValue != "" || $this->msme->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // iec
        if ($this->iec->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->iec->AdvancedSearch->SearchValue != "" || $this->iec->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // rex
        if ($this->rex->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->rex->AdvancedSearch->SearchValue != "" || $this->rex->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // rcmc
        if ($this->rcmc->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->rcmc->AdvancedSearch->SearchValue != "" || $this->rcmc->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // delivery_terms
        if ($this->delivery_terms->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->delivery_terms->AdvancedSearch->SearchValue != "" || $this->delivery_terms->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // shipping_terms
        if ($this->shipping_terms->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->shipping_terms->AdvancedSearch->SearchValue != "" || $this->shipping_terms->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // payment_terms
        if ($this->payment_terms->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->payment_terms->AdvancedSearch->SearchValue != "" || $this->payment_terms->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // export_type
        if ($this->export_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->export_type->AdvancedSearch->SearchValue != "" || $this->export_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // lead_time_ss
        if ($this->lead_time_ss->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->lead_time_ss->AdvancedSearch->SearchValue != "" || $this->lead_time_ss->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // lead_time_cs
        if ($this->lead_time_cs->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->lead_time_cs->AdvancedSearch->SearchValue != "" || $this->lead_time_cs->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cha
        if ($this->cha->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cha->AdvancedSearch->SearchValue != "" || $this->cha->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cha_email
        if ($this->cha_email->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cha_email->AdvancedSearch->SearchValue != "" || $this->cha_email->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cha_phone
        if ($this->cha_phone->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cha_phone->AdvancedSearch->SearchValue != "" || $this->cha_phone->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // forwarder
        if ($this->forwarder->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->forwarder->AdvancedSearch->SearchValue != "" || $this->forwarder->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // forwarder_email
        if ($this->forwarder_email->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->forwarder_email->AdvancedSearch->SearchValue != "" || $this->forwarder_email->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // forwarder_phone
        if ($this->forwarder_phone->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->forwarder_phone->AdvancedSearch->SearchValue != "" || $this->forwarder_phone->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // merchant
        if ($this->merchant->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->merchant->AdvancedSearch->SearchValue != "" || $this->merchant->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // merchant_email
        if ($this->merchant_email->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->merchant_email->AdvancedSearch->SearchValue != "" || $this->merchant_email->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // merchant_phone
        if ($this->merchant_phone->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->merchant_phone->AdvancedSearch->SearchValue != "" || $this->merchant_phone->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // shipping_incharge
        if ($this->shipping_incharge->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->shipping_incharge->AdvancedSearch->SearchValue != "" || $this->shipping_incharge->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // shipping_email
        if ($this->shipping_email->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->shipping_email->AdvancedSearch->SearchValue != "" || $this->shipping_email->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // shipping_phone
        if ($this->shipping_phone->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->shipping_phone->AdvancedSearch->SearchValue != "" || $this->shipping_phone->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // account_incharge
        if ($this->account_incharge->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->account_incharge->AdvancedSearch->SearchValue != "" || $this->account_incharge->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // accounts_email
        if ($this->accounts_email->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->accounts_email->AdvancedSearch->SearchValue != "" || $this->accounts_email->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // accounts_phone
        if ($this->accounts_phone->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->accounts_phone->AdvancedSearch->SearchValue != "" || $this->accounts_phone->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // warehouse_incharge
        if ($this->warehouse_incharge->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->warehouse_incharge->AdvancedSearch->SearchValue != "" || $this->warehouse_incharge->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // warehouse_email
        if ($this->warehouse_email->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->warehouse_email->AdvancedSearch->SearchValue != "" || $this->warehouse_email->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // warehouse_phone
        if ($this->warehouse_phone->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->warehouse_phone->AdvancedSearch->SearchValue != "" || $this->warehouse_phone->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // production_incharge
        if ($this->production_incharge->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->production_incharge->AdvancedSearch->SearchValue != "" || $this->production_incharge->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // production_email
        if ($this->production_email->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->production_email->AdvancedSearch->SearchValue != "" || $this->production_email->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // production_phone
        if ($this->production_phone->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->production_phone->AdvancedSearch->SearchValue != "" || $this->production_phone->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qc_incharge
        if ($this->qc_incharge->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qc_incharge->AdvancedSearch->SearchValue != "" || $this->qc_incharge->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qc_email
        if ($this->qc_email->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qc_email->AdvancedSearch->SearchValue != "" || $this->qc_email->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qc_phone
        if ($this->qc_phone->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qc_phone->AdvancedSearch->SearchValue != "" || $this->qc_phone->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->name->setDbValue($row['name']);
        $this->code->setDbValue($row['code']);
        $this->country->setDbValue($row['country']);
        $this->region->setDbValue($row['region']);
        $this->city->setDbValue($row['city']);
        if (array_key_exists('EV__city', $row)) {
            $this->city->VirtualValue = $row['EV__city']; // Set up virtual field value
        } else {
            $this->city->VirtualValue = ""; // Clear value
        }
        $this->city_name->setDbValue($row['city_name']);
        $this->address->setDbValue($row['address']);
        $this->mobile->setDbValue($row['mobile']);
        $this->_email->setDbValue($row['email']);
        $this->url->setDbValue($row['url']);
        $this->bank_name->setDbValue($row['bank_name']);
        $this->bank_account_no->setDbValue($row['bank_account_no']);
        $this->bank_code->setDbValue($row['bank_code']);
        $this->grp->setDbValue($row['grp']);
        $this->category->setDbValue($row['category']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->status->setDbValue($row['status']);
        $this->performance->setDbValue($row['performance']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->type->setDbValue($row['type']);
        $this->tax_registration->setDbValue($row['tax_registration']);
        $this->cin->setDbValue($row['cin']);
        $this->pan->setDbValue($row['pan']);
        $this->tan->setDbValue($row['tan']);
        $this->msme->setDbValue($row['msme']);
        $this->incoterm->setDbValue($row['incoterm']);
        $this->port_air->setDbValue($row['port_air']);
        $this->port_sea->setDbValue($row['port_sea']);
        $this->iec->setDbValue($row['iec']);
        $this->rex->setDbValue($row['rex']);
        $this->rcmc->setDbValue($row['rcmc']);
        $this->delivery_terms->setDbValue($row['delivery_terms']);
        $this->shipping_terms->setDbValue($row['shipping_terms']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->export_type->setDbValue($row['export_type']);
        $this->lead_time_ss->setDbValue($row['lead_time_ss']);
        $this->lead_time_cs->setDbValue($row['lead_time_cs']);
        $this->cha->setDbValue($row['cha']);
        $this->cha_email->setDbValue($row['cha_email']);
        $this->cha_phone->setDbValue($row['cha_phone']);
        $this->forwarder->setDbValue($row['forwarder']);
        $this->forwarder_email->setDbValue($row['forwarder_email']);
        $this->forwarder_phone->setDbValue($row['forwarder_phone']);
        $this->merchant->setDbValue($row['merchant']);
        $this->merchant_email->setDbValue($row['merchant_email']);
        $this->merchant_phone->setDbValue($row['merchant_phone']);
        $this->shipping_incharge->setDbValue($row['shipping_incharge']);
        $this->shipping_email->setDbValue($row['shipping_email']);
        $this->shipping_phone->setDbValue($row['shipping_phone']);
        $this->account_incharge->setDbValue($row['account_incharge']);
        $this->accounts_email->setDbValue($row['accounts_email']);
        $this->accounts_phone->setDbValue($row['accounts_phone']);
        $this->warehouse_incharge->setDbValue($row['warehouse_incharge']);
        $this->warehouse_email->setDbValue($row['warehouse_email']);
        $this->warehouse_phone->setDbValue($row['warehouse_phone']);
        $this->production_incharge->setDbValue($row['production_incharge']);
        $this->production_email->setDbValue($row['production_email']);
        $this->production_phone->setDbValue($row['production_phone']);
        $this->qc_incharge->setDbValue($row['qc_incharge']);
        $this->qc_email->setDbValue($row['qc_email']);
        $this->qc_phone->setDbValue($row['qc_phone']);
        $this->uid->setDbValue($row['uid']);
        $this->r_text->setDbValue($row['r_text']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['name'] = $this->name->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['country'] = $this->country->DefaultValue;
        $row['region'] = $this->region->DefaultValue;
        $row['city'] = $this->city->DefaultValue;
        $row['city_name'] = $this->city_name->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['url'] = $this->url->DefaultValue;
        $row['bank_name'] = $this->bank_name->DefaultValue;
        $row['bank_account_no'] = $this->bank_account_no->DefaultValue;
        $row['bank_code'] = $this->bank_code->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['performance'] = $this->performance->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['tax_registration'] = $this->tax_registration->DefaultValue;
        $row['cin'] = $this->cin->DefaultValue;
        $row['pan'] = $this->pan->DefaultValue;
        $row['tan'] = $this->tan->DefaultValue;
        $row['msme'] = $this->msme->DefaultValue;
        $row['incoterm'] = $this->incoterm->DefaultValue;
        $row['port_air'] = $this->port_air->DefaultValue;
        $row['port_sea'] = $this->port_sea->DefaultValue;
        $row['iec'] = $this->iec->DefaultValue;
        $row['rex'] = $this->rex->DefaultValue;
        $row['rcmc'] = $this->rcmc->DefaultValue;
        $row['delivery_terms'] = $this->delivery_terms->DefaultValue;
        $row['shipping_terms'] = $this->shipping_terms->DefaultValue;
        $row['payment_terms'] = $this->payment_terms->DefaultValue;
        $row['export_type'] = $this->export_type->DefaultValue;
        $row['lead_time_ss'] = $this->lead_time_ss->DefaultValue;
        $row['lead_time_cs'] = $this->lead_time_cs->DefaultValue;
        $row['cha'] = $this->cha->DefaultValue;
        $row['cha_email'] = $this->cha_email->DefaultValue;
        $row['cha_phone'] = $this->cha_phone->DefaultValue;
        $row['forwarder'] = $this->forwarder->DefaultValue;
        $row['forwarder_email'] = $this->forwarder_email->DefaultValue;
        $row['forwarder_phone'] = $this->forwarder_phone->DefaultValue;
        $row['merchant'] = $this->merchant->DefaultValue;
        $row['merchant_email'] = $this->merchant_email->DefaultValue;
        $row['merchant_phone'] = $this->merchant_phone->DefaultValue;
        $row['shipping_incharge'] = $this->shipping_incharge->DefaultValue;
        $row['shipping_email'] = $this->shipping_email->DefaultValue;
        $row['shipping_phone'] = $this->shipping_phone->DefaultValue;
        $row['account_incharge'] = $this->account_incharge->DefaultValue;
        $row['accounts_email'] = $this->accounts_email->DefaultValue;
        $row['accounts_phone'] = $this->accounts_phone->DefaultValue;
        $row['warehouse_incharge'] = $this->warehouse_incharge->DefaultValue;
        $row['warehouse_email'] = $this->warehouse_email->DefaultValue;
        $row['warehouse_phone'] = $this->warehouse_phone->DefaultValue;
        $row['production_incharge'] = $this->production_incharge->DefaultValue;
        $row['production_email'] = $this->production_email->DefaultValue;
        $row['production_phone'] = $this->production_phone->DefaultValue;
        $row['qc_incharge'] = $this->qc_incharge->DefaultValue;
        $row['qc_email'] = $this->qc_email->DefaultValue;
        $row['qc_phone'] = $this->qc_phone->DefaultValue;
        $row['uid'] = $this->uid->DefaultValue;
        $row['r_text'] = $this->r_text->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // name

        // code

        // country

        // region

        // city
        $this->city->CellCssStyle = "white-space: nowrap;";

        // city_name

        // address

        // mobile

        // email

        // url

        // bank_name

        // bank_account_no

        // bank_code

        // grp

        // category

        // reports_to

        // status

        // performance

        // operator

        // datetime

        // type

        // tax_registration

        // cin

        // pan

        // tan

        // msme

        // incoterm
        $this->incoterm->CellCssStyle = "white-space: nowrap;";

        // port_air

        // port_sea

        // iec

        // rex

        // rcmc

        // delivery_terms

        // shipping_terms

        // payment_terms

        // export_type

        // lead_time_ss

        // lead_time_cs

        // cha

        // cha_email

        // cha_phone

        // forwarder

        // forwarder_email

        // forwarder_phone

        // merchant

        // merchant_email

        // merchant_phone

        // shipping_incharge

        // shipping_email

        // shipping_phone

        // account_incharge

        // accounts_email

        // accounts_phone

        // warehouse_incharge

        // warehouse_email

        // warehouse_phone

        // production_incharge

        // production_email

        // production_phone

        // qc_incharge

        // qc_email

        // qc_phone

        // uid
        $this->uid->CellCssStyle = "white-space: nowrap;";

        // r_text
        $this->r_text->CellCssStyle = "white-space: nowrap;";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // code
            $this->code->ViewValue = $this->code->CurrentValue;

            // country
            $curVal = strval($this->country->CurrentValue);
            if ($curVal != "") {
                $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
                if ($this->country->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->country->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->country->Lookup->renderViewRow($rswrk[0]);
                        $this->country->ViewValue = $this->country->displayValue($arwrk);
                    } else {
                        $this->country->ViewValue = FormatNumber($this->country->CurrentValue, $this->country->formatPattern());
                    }
                }
            } else {
                $this->country->ViewValue = null;
            }

            // region
            $curVal = strval($this->region->CurrentValue);
            if ($curVal != "") {
                $this->region->ViewValue = $this->region->lookupCacheOption($curVal);
                if ($this->region->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->region->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->region->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->region->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->region->Lookup->renderViewRow($rswrk[0]);
                        $this->region->ViewValue = $this->region->displayValue($arwrk);
                    } else {
                        $this->region->ViewValue = FormatNumber($this->region->CurrentValue, $this->region->formatPattern());
                    }
                }
            } else {
                $this->region->ViewValue = null;
            }

            // city_name
            $this->city_name->ViewValue = $this->city_name->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // url
            $this->url->ViewValue = $this->url->CurrentValue;

            // bank_name
            $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

            // bank_account_no
            $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

            // bank_code
            $this->bank_code->ViewValue = $this->bank_code->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->grp->Lookup->renderViewRow($row);
                            $this->grp->ViewValue->add($this->grp->displayValue($arwrk));
                        }
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                        $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                    } else {
                        $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // performance
            $this->performance->ViewValue = $this->performance->CurrentValue;
            $this->performance->ViewValue = FormatNumber($this->performance->ViewValue, $this->performance->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // type
            if (strval($this->type->CurrentValue) != "") {
                $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
            } else {
                $this->type->ViewValue = null;
            }

            // tax_registration
            $this->tax_registration->ViewValue = $this->tax_registration->CurrentValue;

            // cin
            $this->cin->ViewValue = $this->cin->CurrentValue;

            // pan
            $this->pan->ViewValue = $this->pan->CurrentValue;

            // tan
            $this->tan->ViewValue = $this->tan->CurrentValue;

            // msme
            $this->msme->ViewValue = $this->msme->CurrentValue;

            // port_air
            $curVal = strval($this->port_air->CurrentValue);
            if ($curVal != "") {
                $this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
                if ($this->port_air->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->port_air->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->port_air->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->port_air->getSelectFilter($this); // PHP
                    $sqlWrk = $this->port_air->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->port_air->Lookup->renderViewRow($rswrk[0]);
                        $this->port_air->ViewValue = $this->port_air->displayValue($arwrk);
                    } else {
                        $this->port_air->ViewValue = $this->port_air->CurrentValue;
                    }
                }
            } else {
                $this->port_air->ViewValue = null;
            }

            // port_sea
            $curVal = strval($this->port_sea->CurrentValue);
            if ($curVal != "") {
                $this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
                if ($this->port_sea->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->port_sea->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->port_sea->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->port_sea->getSelectFilter($this); // PHP
                    $sqlWrk = $this->port_sea->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->port_sea->Lookup->renderViewRow($rswrk[0]);
                        $this->port_sea->ViewValue = $this->port_sea->displayValue($arwrk);
                    } else {
                        $this->port_sea->ViewValue = $this->port_sea->CurrentValue;
                    }
                }
            } else {
                $this->port_sea->ViewValue = null;
            }

            // iec
            $this->iec->ViewValue = $this->iec->CurrentValue;

            // rex
            $this->rex->ViewValue = $this->rex->CurrentValue;

            // rcmc
            $this->rcmc->ViewValue = $this->rcmc->CurrentValue;

            // delivery_terms
            $this->delivery_terms->ViewValue = $this->delivery_terms->CurrentValue;

            // shipping_terms
            $this->shipping_terms->ViewValue = $this->shipping_terms->CurrentValue;

            // payment_terms
            $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;

            // export_type
            $this->export_type->ViewValue = $this->export_type->CurrentValue;

            // lead_time_ss
            $this->lead_time_ss->ViewValue = $this->lead_time_ss->CurrentValue;

            // lead_time_cs
            $this->lead_time_cs->ViewValue = $this->lead_time_cs->CurrentValue;

            // cha
            $this->cha->ViewValue = $this->cha->CurrentValue;

            // cha_email
            $this->cha_email->ViewValue = $this->cha_email->CurrentValue;

            // cha_phone
            $this->cha_phone->ViewValue = $this->cha_phone->CurrentValue;

            // forwarder
            $this->forwarder->ViewValue = $this->forwarder->CurrentValue;

            // forwarder_email
            $this->forwarder_email->ViewValue = $this->forwarder_email->CurrentValue;

            // forwarder_phone
            $this->forwarder_phone->ViewValue = $this->forwarder_phone->CurrentValue;

            // merchant
            $this->merchant->ViewValue = $this->merchant->CurrentValue;

            // merchant_email
            $this->merchant_email->ViewValue = $this->merchant_email->CurrentValue;

            // merchant_phone
            $this->merchant_phone->ViewValue = $this->merchant_phone->CurrentValue;

            // shipping_incharge
            $this->shipping_incharge->ViewValue = $this->shipping_incharge->CurrentValue;

            // shipping_email
            $this->shipping_email->ViewValue = $this->shipping_email->CurrentValue;

            // shipping_phone
            $this->shipping_phone->ViewValue = $this->shipping_phone->CurrentValue;

            // account_incharge
            $this->account_incharge->ViewValue = $this->account_incharge->CurrentValue;

            // accounts_email
            $this->accounts_email->ViewValue = $this->accounts_email->CurrentValue;

            // accounts_phone
            $this->accounts_phone->ViewValue = $this->accounts_phone->CurrentValue;

            // warehouse_incharge
            $this->warehouse_incharge->ViewValue = $this->warehouse_incharge->CurrentValue;

            // warehouse_email
            $this->warehouse_email->ViewValue = $this->warehouse_email->CurrentValue;

            // warehouse_phone
            $this->warehouse_phone->ViewValue = $this->warehouse_phone->CurrentValue;

            // production_incharge
            $this->production_incharge->ViewValue = $this->production_incharge->CurrentValue;

            // production_email
            $this->production_email->ViewValue = $this->production_email->CurrentValue;

            // production_phone
            $this->production_phone->ViewValue = $this->production_phone->CurrentValue;

            // qc_incharge
            $this->qc_incharge->ViewValue = $this->qc_incharge->CurrentValue;

            // qc_email
            $this->qc_email->ViewValue = $this->qc_email->CurrentValue;

            // qc_phone
            $this->qc_phone->ViewValue = $this->qc_phone->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->id->ViewValue = $this->highlightValue($this->id);
            }

            // name
            $this->name->HrefValue = "";
            $this->name->TooltipValue = "";
            if (!$this->isExport()) {
                $this->name->ViewValue = $this->highlightValue($this->name);
            }

            // code
            $this->code->HrefValue = "";
            $this->code->TooltipValue = "";
            if (!$this->isExport()) {
                $this->code->ViewValue = $this->highlightValue($this->code);
            }

            // country
            $this->country->HrefValue = "";
            $this->country->TooltipValue = "";

            // region
            $this->region->HrefValue = "";
            $this->region->TooltipValue = "";

            // city_name
            $this->city_name->HrefValue = "";
            $this->city_name->TooltipValue = "";
            if (!$this->isExport()) {
                $this->city_name->ViewValue = $this->highlightValue($this->city_name);
            }

            // address
            $this->address->HrefValue = "";
            $this->address->TooltipValue = "";
            if (!$this->isExport()) {
                $this->address->ViewValue = $this->highlightValue($this->address);
            }

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";
            if (!$this->isExport()) {
                $this->mobile->ViewValue = $this->highlightValue($this->mobile);
            }

            // email
            $this->_email->HrefValue = "";
            $this->_email->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_email->ViewValue = $this->highlightValue($this->_email);
            }

            // url
            $this->url->HrefValue = "";
            $this->url->TooltipValue = "";
            if (!$this->isExport()) {
                $this->url->ViewValue = $this->highlightValue($this->url);
            }

            // bank_name
            $this->bank_name->HrefValue = "";
            $this->bank_name->TooltipValue = "";
            if (!$this->isExport()) {
                $this->bank_name->ViewValue = $this->highlightValue($this->bank_name);
            }

            // bank_account_no
            $this->bank_account_no->HrefValue = "";
            $this->bank_account_no->TooltipValue = "";
            if (!$this->isExport()) {
                $this->bank_account_no->ViewValue = $this->highlightValue($this->bank_account_no);
            }

            // bank_code
            $this->bank_code->HrefValue = "";
            $this->bank_code->TooltipValue = "";
            if (!$this->isExport()) {
                $this->bank_code->ViewValue = $this->highlightValue($this->bank_code);
            }

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";
            $this->reports_to->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // performance
            $this->performance->HrefValue = "";
            $this->performance->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
            if (!$this->isExport()) {
                $this->datetime->ViewValue = $this->highlightValue($this->datetime);
            }

            // type
            $this->type->HrefValue = "";
            $this->type->TooltipValue = "";

            // tax_registration
            $this->tax_registration->HrefValue = "";
            $this->tax_registration->TooltipValue = "";
            if (!$this->isExport()) {
                $this->tax_registration->ViewValue = $this->highlightValue($this->tax_registration);
            }

            // cin
            $this->cin->HrefValue = "";
            $this->cin->TooltipValue = "";
            if (!$this->isExport()) {
                $this->cin->ViewValue = $this->highlightValue($this->cin);
            }

            // pan
            $this->pan->HrefValue = "";
            $this->pan->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pan->ViewValue = $this->highlightValue($this->pan);
            }

            // tan
            $this->tan->HrefValue = "";
            $this->tan->TooltipValue = "";
            if (!$this->isExport()) {
                $this->tan->ViewValue = $this->highlightValue($this->tan);
            }

            // msme
            $this->msme->HrefValue = "";
            $this->msme->TooltipValue = "";
            if (!$this->isExport()) {
                $this->msme->ViewValue = $this->highlightValue($this->msme);
            }

            // port_air
            $this->port_air->HrefValue = "";
            $this->port_air->TooltipValue = "";

            // port_sea
            $this->port_sea->HrefValue = "";
            $this->port_sea->TooltipValue = "";

            // iec
            $this->iec->HrefValue = "";
            $this->iec->TooltipValue = "";
            if (!$this->isExport()) {
                $this->iec->ViewValue = $this->highlightValue($this->iec);
            }

            // rex
            $this->rex->HrefValue = "";
            $this->rex->TooltipValue = "";
            if (!$this->isExport()) {
                $this->rex->ViewValue = $this->highlightValue($this->rex);
            }

            // rcmc
            $this->rcmc->HrefValue = "";
            $this->rcmc->TooltipValue = "";
            if (!$this->isExport()) {
                $this->rcmc->ViewValue = $this->highlightValue($this->rcmc);
            }

            // delivery_terms
            $this->delivery_terms->HrefValue = "";
            $this->delivery_terms->TooltipValue = "";
            if (!$this->isExport()) {
                $this->delivery_terms->ViewValue = $this->highlightValue($this->delivery_terms);
            }

            // shipping_terms
            $this->shipping_terms->HrefValue = "";
            $this->shipping_terms->TooltipValue = "";
            if (!$this->isExport()) {
                $this->shipping_terms->ViewValue = $this->highlightValue($this->shipping_terms);
            }

            // payment_terms
            $this->payment_terms->HrefValue = "";
            $this->payment_terms->TooltipValue = "";
            if (!$this->isExport()) {
                $this->payment_terms->ViewValue = $this->highlightValue($this->payment_terms);
            }

            // export_type
            $this->export_type->HrefValue = "";
            $this->export_type->TooltipValue = "";
            if (!$this->isExport()) {
                $this->export_type->ViewValue = $this->highlightValue($this->export_type);
            }

            // lead_time_ss
            $this->lead_time_ss->HrefValue = "";
            $this->lead_time_ss->TooltipValue = "";

            // lead_time_cs
            $this->lead_time_cs->HrefValue = "";
            $this->lead_time_cs->TooltipValue = "";

            // cha
            $this->cha->HrefValue = "";
            $this->cha->TooltipValue = "";

            // cha_email
            $this->cha_email->HrefValue = "";
            $this->cha_email->TooltipValue = "";
            if (!$this->isExport()) {
                $this->cha_email->ViewValue = $this->highlightValue($this->cha_email);
            }

            // cha_phone
            $this->cha_phone->HrefValue = "";
            $this->cha_phone->TooltipValue = "";
            if (!$this->isExport()) {
                $this->cha_phone->ViewValue = $this->highlightValue($this->cha_phone);
            }

            // forwarder
            $this->forwarder->HrefValue = "";
            $this->forwarder->TooltipValue = "";

            // forwarder_email
            $this->forwarder_email->HrefValue = "";
            $this->forwarder_email->TooltipValue = "";
            if (!$this->isExport()) {
                $this->forwarder_email->ViewValue = $this->highlightValue($this->forwarder_email);
            }

            // forwarder_phone
            $this->forwarder_phone->HrefValue = "";
            $this->forwarder_phone->TooltipValue = "";
            if (!$this->isExport()) {
                $this->forwarder_phone->ViewValue = $this->highlightValue($this->forwarder_phone);
            }

            // merchant
            $this->merchant->HrefValue = "";
            $this->merchant->TooltipValue = "";
            if (!$this->isExport()) {
                $this->merchant->ViewValue = $this->highlightValue($this->merchant);
            }

            // merchant_email
            $this->merchant_email->HrefValue = "";
            $this->merchant_email->TooltipValue = "";
            if (!$this->isExport()) {
                $this->merchant_email->ViewValue = $this->highlightValue($this->merchant_email);
            }

            // merchant_phone
            $this->merchant_phone->HrefValue = "";
            $this->merchant_phone->TooltipValue = "";
            if (!$this->isExport()) {
                $this->merchant_phone->ViewValue = $this->highlightValue($this->merchant_phone);
            }

            // shipping_incharge
            $this->shipping_incharge->HrefValue = "";
            $this->shipping_incharge->TooltipValue = "";
            if (!$this->isExport()) {
                $this->shipping_incharge->ViewValue = $this->highlightValue($this->shipping_incharge);
            }

            // shipping_email
            $this->shipping_email->HrefValue = "";
            $this->shipping_email->TooltipValue = "";
            if (!$this->isExport()) {
                $this->shipping_email->ViewValue = $this->highlightValue($this->shipping_email);
            }

            // shipping_phone
            $this->shipping_phone->HrefValue = "";
            $this->shipping_phone->TooltipValue = "";
            if (!$this->isExport()) {
                $this->shipping_phone->ViewValue = $this->highlightValue($this->shipping_phone);
            }

            // account_incharge
            $this->account_incharge->HrefValue = "";
            $this->account_incharge->TooltipValue = "";
            if (!$this->isExport()) {
                $this->account_incharge->ViewValue = $this->highlightValue($this->account_incharge);
            }

            // accounts_email
            $this->accounts_email->HrefValue = "";
            $this->accounts_email->TooltipValue = "";
            if (!$this->isExport()) {
                $this->accounts_email->ViewValue = $this->highlightValue($this->accounts_email);
            }

            // accounts_phone
            $this->accounts_phone->HrefValue = "";
            $this->accounts_phone->TooltipValue = "";
            if (!$this->isExport()) {
                $this->accounts_phone->ViewValue = $this->highlightValue($this->accounts_phone);
            }

            // warehouse_incharge
            $this->warehouse_incharge->HrefValue = "";
            $this->warehouse_incharge->TooltipValue = "";
            if (!$this->isExport()) {
                $this->warehouse_incharge->ViewValue = $this->highlightValue($this->warehouse_incharge);
            }

            // warehouse_email
            $this->warehouse_email->HrefValue = "";
            $this->warehouse_email->TooltipValue = "";
            if (!$this->isExport()) {
                $this->warehouse_email->ViewValue = $this->highlightValue($this->warehouse_email);
            }

            // warehouse_phone
            $this->warehouse_phone->HrefValue = "";
            $this->warehouse_phone->TooltipValue = "";
            if (!$this->isExport()) {
                $this->warehouse_phone->ViewValue = $this->highlightValue($this->warehouse_phone);
            }

            // production_incharge
            $this->production_incharge->HrefValue = "";
            $this->production_incharge->TooltipValue = "";
            if (!$this->isExport()) {
                $this->production_incharge->ViewValue = $this->highlightValue($this->production_incharge);
            }

            // production_email
            $this->production_email->HrefValue = "";
            $this->production_email->TooltipValue = "";
            if (!$this->isExport()) {
                $this->production_email->ViewValue = $this->highlightValue($this->production_email);
            }

            // production_phone
            $this->production_phone->HrefValue = "";
            $this->production_phone->TooltipValue = "";
            if (!$this->isExport()) {
                $this->production_phone->ViewValue = $this->highlightValue($this->production_phone);
            }

            // qc_incharge
            $this->qc_incharge->HrefValue = "";
            $this->qc_incharge->TooltipValue = "";
            if (!$this->isExport()) {
                $this->qc_incharge->ViewValue = $this->highlightValue($this->qc_incharge);
            }

            // qc_email
            $this->qc_email->HrefValue = "";
            $this->qc_email->TooltipValue = "";
            if (!$this->isExport()) {
                $this->qc_email->ViewValue = $this->highlightValue($this->qc_email);
            }

            // qc_phone
            $this->qc_phone->HrefValue = "";
            $this->qc_phone->TooltipValue = "";
            if (!$this->isExport()) {
                $this->qc_phone->ViewValue = $this->highlightValue($this->qc_phone);
            }
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->name->AdvancedSearch->load();
        $this->code->AdvancedSearch->load();
        $this->country->AdvancedSearch->load();
        $this->region->AdvancedSearch->load();
        $this->city_name->AdvancedSearch->load();
        $this->address->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->_email->AdvancedSearch->load();
        $this->url->AdvancedSearch->load();
        $this->bank_name->AdvancedSearch->load();
        $this->bank_account_no->AdvancedSearch->load();
        $this->bank_code->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->reports_to->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->performance->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->tax_registration->AdvancedSearch->load();
        $this->cin->AdvancedSearch->load();
        $this->pan->AdvancedSearch->load();
        $this->tan->AdvancedSearch->load();
        $this->msme->AdvancedSearch->load();
        $this->iec->AdvancedSearch->load();
        $this->rex->AdvancedSearch->load();
        $this->rcmc->AdvancedSearch->load();
        $this->delivery_terms->AdvancedSearch->load();
        $this->shipping_terms->AdvancedSearch->load();
        $this->payment_terms->AdvancedSearch->load();
        $this->export_type->AdvancedSearch->load();
        $this->lead_time_ss->AdvancedSearch->load();
        $this->lead_time_cs->AdvancedSearch->load();
        $this->cha->AdvancedSearch->load();
        $this->cha_email->AdvancedSearch->load();
        $this->cha_phone->AdvancedSearch->load();
        $this->forwarder->AdvancedSearch->load();
        $this->forwarder_email->AdvancedSearch->load();
        $this->forwarder_phone->AdvancedSearch->load();
        $this->merchant->AdvancedSearch->load();
        $this->merchant_email->AdvancedSearch->load();
        $this->merchant_phone->AdvancedSearch->load();
        $this->shipping_incharge->AdvancedSearch->load();
        $this->shipping_email->AdvancedSearch->load();
        $this->shipping_phone->AdvancedSearch->load();
        $this->account_incharge->AdvancedSearch->load();
        $this->accounts_email->AdvancedSearch->load();
        $this->accounts_phone->AdvancedSearch->load();
        $this->warehouse_incharge->AdvancedSearch->load();
        $this->warehouse_email->AdvancedSearch->load();
        $this->warehouse_phone->AdvancedSearch->load();
        $this->production_incharge->AdvancedSearch->load();
        $this->production_email->AdvancedSearch->load();
        $this->production_phone->AdvancedSearch->load();
        $this->qc_incharge->AdvancedSearch->load();
        $this->qc_email->AdvancedSearch->load();
        $this->qc_phone->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fproduction_partnerlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fproduction_partnerlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fproduction_partnerlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fproduction_partnerlist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = false;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"production_partner\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"productionpartnersearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"productionpartnersearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"fproduction_partnersrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_country":
                    break;
                case "x_region":
                    break;
                case "x_city":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_reports_to":
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                case "x_type":
                    break;
                case "x_incoterm":
                    break;
                case "x_port_air":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_port_sea":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'production_partner');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
