<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductionPartnerDelete extends ProductionPartner
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductionPartnerDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "productionpartnerdelete";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->name->setVisibility();
        $this->code->setVisibility();
        $this->country->setVisibility();
        $this->region->setVisibility();
        $this->city->Visible = false;
        $this->city_name->setVisibility();
        $this->address->setVisibility();
        $this->mobile->setVisibility();
        $this->_email->setVisibility();
        $this->url->setVisibility();
        $this->bank_name->setVisibility();
        $this->bank_account_no->setVisibility();
        $this->bank_code->setVisibility();
        $this->grp->setVisibility();
        $this->category->setVisibility();
        $this->reports_to->setVisibility();
        $this->status->setVisibility();
        $this->performance->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->type->setVisibility();
        $this->tax_registration->setVisibility();
        $this->cin->setVisibility();
        $this->pan->setVisibility();
        $this->tan->setVisibility();
        $this->msme->setVisibility();
        $this->incoterm->Visible = false;
        $this->port_air->setVisibility();
        $this->port_sea->setVisibility();
        $this->iec->setVisibility();
        $this->rex->setVisibility();
        $this->rcmc->setVisibility();
        $this->delivery_terms->setVisibility();
        $this->shipping_terms->setVisibility();
        $this->payment_terms->setVisibility();
        $this->export_type->setVisibility();
        $this->lead_time_ss->setVisibility();
        $this->lead_time_cs->setVisibility();
        $this->cha->setVisibility();
        $this->cha_email->setVisibility();
        $this->cha_phone->setVisibility();
        $this->forwarder->setVisibility();
        $this->forwarder_email->setVisibility();
        $this->forwarder_phone->setVisibility();
        $this->merchant->setVisibility();
        $this->merchant_email->setVisibility();
        $this->merchant_phone->setVisibility();
        $this->shipping_incharge->setVisibility();
        $this->shipping_email->setVisibility();
        $this->shipping_phone->setVisibility();
        $this->account_incharge->setVisibility();
        $this->accounts_email->setVisibility();
        $this->accounts_phone->setVisibility();
        $this->warehouse_incharge->setVisibility();
        $this->warehouse_email->setVisibility();
        $this->warehouse_phone->setVisibility();
        $this->production_incharge->setVisibility();
        $this->production_email->setVisibility();
        $this->production_phone->setVisibility();
        $this->qc_incharge->setVisibility();
        $this->qc_email->setVisibility();
        $this->qc_phone->setVisibility();
        $this->uid->Visible = false;
        $this->r_text->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'production_partner';
        $this->TableName = 'production_partner';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (production_partner)
        if (!isset($GLOBALS["production_partner"]) || $GLOBALS["production_partner"]::class == PROJECT_NAMESPACE . "production_partner") {
            $GLOBALS["production_partner"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'production_partner');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->country);
        $this->setupLookupOptions($this->region);
        $this->setupLookupOptions($this->city);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->type);
        $this->setupLookupOptions($this->incoterm);
        $this->setupLookupOptions($this->port_air);
        $this->setupLookupOptions($this->port_sea);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("productionpartnerlist"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson(["success" => false, "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            $this->Recordset = $this->loadRecordset();
            if ($this->TotalRecords <= 0) { // No record found, exit
                $this->Recordset?->free();
                $this->terminate("productionpartnerlist"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->name->setDbValue($row['name']);
        $this->code->setDbValue($row['code']);
        $this->country->setDbValue($row['country']);
        $this->region->setDbValue($row['region']);
        $this->city->setDbValue($row['city']);
        if (array_key_exists('EV__city', $row)) {
            $this->city->VirtualValue = $row['EV__city']; // Set up virtual field value
        } else {
            $this->city->VirtualValue = ""; // Clear value
        }
        $this->city_name->setDbValue($row['city_name']);
        $this->address->setDbValue($row['address']);
        $this->mobile->setDbValue($row['mobile']);
        $this->_email->setDbValue($row['email']);
        $this->url->setDbValue($row['url']);
        $this->bank_name->setDbValue($row['bank_name']);
        $this->bank_account_no->setDbValue($row['bank_account_no']);
        $this->bank_code->setDbValue($row['bank_code']);
        $this->grp->setDbValue($row['grp']);
        $this->category->setDbValue($row['category']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->status->setDbValue($row['status']);
        $this->performance->setDbValue($row['performance']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->type->setDbValue($row['type']);
        $this->tax_registration->setDbValue($row['tax_registration']);
        $this->cin->setDbValue($row['cin']);
        $this->pan->setDbValue($row['pan']);
        $this->tan->setDbValue($row['tan']);
        $this->msme->setDbValue($row['msme']);
        $this->incoterm->setDbValue($row['incoterm']);
        $this->port_air->setDbValue($row['port_air']);
        $this->port_sea->setDbValue($row['port_sea']);
        $this->iec->setDbValue($row['iec']);
        $this->rex->setDbValue($row['rex']);
        $this->rcmc->setDbValue($row['rcmc']);
        $this->delivery_terms->setDbValue($row['delivery_terms']);
        $this->shipping_terms->setDbValue($row['shipping_terms']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->export_type->setDbValue($row['export_type']);
        $this->lead_time_ss->setDbValue($row['lead_time_ss']);
        $this->lead_time_cs->setDbValue($row['lead_time_cs']);
        $this->cha->setDbValue($row['cha']);
        $this->cha_email->setDbValue($row['cha_email']);
        $this->cha_phone->setDbValue($row['cha_phone']);
        $this->forwarder->setDbValue($row['forwarder']);
        $this->forwarder_email->setDbValue($row['forwarder_email']);
        $this->forwarder_phone->setDbValue($row['forwarder_phone']);
        $this->merchant->setDbValue($row['merchant']);
        $this->merchant_email->setDbValue($row['merchant_email']);
        $this->merchant_phone->setDbValue($row['merchant_phone']);
        $this->shipping_incharge->setDbValue($row['shipping_incharge']);
        $this->shipping_email->setDbValue($row['shipping_email']);
        $this->shipping_phone->setDbValue($row['shipping_phone']);
        $this->account_incharge->setDbValue($row['account_incharge']);
        $this->accounts_email->setDbValue($row['accounts_email']);
        $this->accounts_phone->setDbValue($row['accounts_phone']);
        $this->warehouse_incharge->setDbValue($row['warehouse_incharge']);
        $this->warehouse_email->setDbValue($row['warehouse_email']);
        $this->warehouse_phone->setDbValue($row['warehouse_phone']);
        $this->production_incharge->setDbValue($row['production_incharge']);
        $this->production_email->setDbValue($row['production_email']);
        $this->production_phone->setDbValue($row['production_phone']);
        $this->qc_incharge->setDbValue($row['qc_incharge']);
        $this->qc_email->setDbValue($row['qc_email']);
        $this->qc_phone->setDbValue($row['qc_phone']);
        $this->uid->setDbValue($row['uid']);
        $this->r_text->setDbValue($row['r_text']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['name'] = $this->name->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['country'] = $this->country->DefaultValue;
        $row['region'] = $this->region->DefaultValue;
        $row['city'] = $this->city->DefaultValue;
        $row['city_name'] = $this->city_name->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['url'] = $this->url->DefaultValue;
        $row['bank_name'] = $this->bank_name->DefaultValue;
        $row['bank_account_no'] = $this->bank_account_no->DefaultValue;
        $row['bank_code'] = $this->bank_code->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['performance'] = $this->performance->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['tax_registration'] = $this->tax_registration->DefaultValue;
        $row['cin'] = $this->cin->DefaultValue;
        $row['pan'] = $this->pan->DefaultValue;
        $row['tan'] = $this->tan->DefaultValue;
        $row['msme'] = $this->msme->DefaultValue;
        $row['incoterm'] = $this->incoterm->DefaultValue;
        $row['port_air'] = $this->port_air->DefaultValue;
        $row['port_sea'] = $this->port_sea->DefaultValue;
        $row['iec'] = $this->iec->DefaultValue;
        $row['rex'] = $this->rex->DefaultValue;
        $row['rcmc'] = $this->rcmc->DefaultValue;
        $row['delivery_terms'] = $this->delivery_terms->DefaultValue;
        $row['shipping_terms'] = $this->shipping_terms->DefaultValue;
        $row['payment_terms'] = $this->payment_terms->DefaultValue;
        $row['export_type'] = $this->export_type->DefaultValue;
        $row['lead_time_ss'] = $this->lead_time_ss->DefaultValue;
        $row['lead_time_cs'] = $this->lead_time_cs->DefaultValue;
        $row['cha'] = $this->cha->DefaultValue;
        $row['cha_email'] = $this->cha_email->DefaultValue;
        $row['cha_phone'] = $this->cha_phone->DefaultValue;
        $row['forwarder'] = $this->forwarder->DefaultValue;
        $row['forwarder_email'] = $this->forwarder_email->DefaultValue;
        $row['forwarder_phone'] = $this->forwarder_phone->DefaultValue;
        $row['merchant'] = $this->merchant->DefaultValue;
        $row['merchant_email'] = $this->merchant_email->DefaultValue;
        $row['merchant_phone'] = $this->merchant_phone->DefaultValue;
        $row['shipping_incharge'] = $this->shipping_incharge->DefaultValue;
        $row['shipping_email'] = $this->shipping_email->DefaultValue;
        $row['shipping_phone'] = $this->shipping_phone->DefaultValue;
        $row['account_incharge'] = $this->account_incharge->DefaultValue;
        $row['accounts_email'] = $this->accounts_email->DefaultValue;
        $row['accounts_phone'] = $this->accounts_phone->DefaultValue;
        $row['warehouse_incharge'] = $this->warehouse_incharge->DefaultValue;
        $row['warehouse_email'] = $this->warehouse_email->DefaultValue;
        $row['warehouse_phone'] = $this->warehouse_phone->DefaultValue;
        $row['production_incharge'] = $this->production_incharge->DefaultValue;
        $row['production_email'] = $this->production_email->DefaultValue;
        $row['production_phone'] = $this->production_phone->DefaultValue;
        $row['qc_incharge'] = $this->qc_incharge->DefaultValue;
        $row['qc_email'] = $this->qc_email->DefaultValue;
        $row['qc_phone'] = $this->qc_phone->DefaultValue;
        $row['uid'] = $this->uid->DefaultValue;
        $row['r_text'] = $this->r_text->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // name

        // code

        // country

        // region

        // city
        $this->city->CellCssStyle = "white-space: nowrap;";

        // city_name

        // address

        // mobile

        // email

        // url

        // bank_name

        // bank_account_no

        // bank_code

        // grp

        // category

        // reports_to

        // status

        // performance

        // operator

        // datetime

        // type

        // tax_registration

        // cin

        // pan

        // tan

        // msme

        // incoterm
        $this->incoterm->CellCssStyle = "white-space: nowrap;";

        // port_air

        // port_sea

        // iec

        // rex

        // rcmc

        // delivery_terms

        // shipping_terms

        // payment_terms

        // export_type

        // lead_time_ss

        // lead_time_cs

        // cha

        // cha_email

        // cha_phone

        // forwarder

        // forwarder_email

        // forwarder_phone

        // merchant

        // merchant_email

        // merchant_phone

        // shipping_incharge

        // shipping_email

        // shipping_phone

        // account_incharge

        // accounts_email

        // accounts_phone

        // warehouse_incharge

        // warehouse_email

        // warehouse_phone

        // production_incharge

        // production_email

        // production_phone

        // qc_incharge

        // qc_email

        // qc_phone

        // uid
        $this->uid->CellCssStyle = "white-space: nowrap;";

        // r_text
        $this->r_text->CellCssStyle = "white-space: nowrap;";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // code
            $this->code->ViewValue = $this->code->CurrentValue;

            // country
            $curVal = strval($this->country->CurrentValue);
            if ($curVal != "") {
                $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
                if ($this->country->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->country->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->country->Lookup->renderViewRow($rswrk[0]);
                        $this->country->ViewValue = $this->country->displayValue($arwrk);
                    } else {
                        $this->country->ViewValue = FormatNumber($this->country->CurrentValue, $this->country->formatPattern());
                    }
                }
            } else {
                $this->country->ViewValue = null;
            }

            // region
            $curVal = strval($this->region->CurrentValue);
            if ($curVal != "") {
                $this->region->ViewValue = $this->region->lookupCacheOption($curVal);
                if ($this->region->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->region->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->region->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->region->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->region->Lookup->renderViewRow($rswrk[0]);
                        $this->region->ViewValue = $this->region->displayValue($arwrk);
                    } else {
                        $this->region->ViewValue = FormatNumber($this->region->CurrentValue, $this->region->formatPattern());
                    }
                }
            } else {
                $this->region->ViewValue = null;
            }

            // city_name
            $this->city_name->ViewValue = $this->city_name->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // url
            $this->url->ViewValue = $this->url->CurrentValue;

            // bank_name
            $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

            // bank_account_no
            $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

            // bank_code
            $this->bank_code->ViewValue = $this->bank_code->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->grp->Lookup->renderViewRow($row);
                            $this->grp->ViewValue->add($this->grp->displayValue($arwrk));
                        }
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                        $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                    } else {
                        $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // performance
            $this->performance->ViewValue = $this->performance->CurrentValue;
            $this->performance->ViewValue = FormatNumber($this->performance->ViewValue, $this->performance->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // type
            if (strval($this->type->CurrentValue) != "") {
                $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
            } else {
                $this->type->ViewValue = null;
            }

            // tax_registration
            $this->tax_registration->ViewValue = $this->tax_registration->CurrentValue;

            // cin
            $this->cin->ViewValue = $this->cin->CurrentValue;

            // pan
            $this->pan->ViewValue = $this->pan->CurrentValue;

            // tan
            $this->tan->ViewValue = $this->tan->CurrentValue;

            // msme
            $this->msme->ViewValue = $this->msme->CurrentValue;

            // port_air
            $curVal = strval($this->port_air->CurrentValue);
            if ($curVal != "") {
                $this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
                if ($this->port_air->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->port_air->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->port_air->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->port_air->getSelectFilter($this); // PHP
                    $sqlWrk = $this->port_air->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->port_air->Lookup->renderViewRow($rswrk[0]);
                        $this->port_air->ViewValue = $this->port_air->displayValue($arwrk);
                    } else {
                        $this->port_air->ViewValue = $this->port_air->CurrentValue;
                    }
                }
            } else {
                $this->port_air->ViewValue = null;
            }

            // port_sea
            $curVal = strval($this->port_sea->CurrentValue);
            if ($curVal != "") {
                $this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
                if ($this->port_sea->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->port_sea->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->port_sea->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->port_sea->getSelectFilter($this); // PHP
                    $sqlWrk = $this->port_sea->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->port_sea->Lookup->renderViewRow($rswrk[0]);
                        $this->port_sea->ViewValue = $this->port_sea->displayValue($arwrk);
                    } else {
                        $this->port_sea->ViewValue = $this->port_sea->CurrentValue;
                    }
                }
            } else {
                $this->port_sea->ViewValue = null;
            }

            // iec
            $this->iec->ViewValue = $this->iec->CurrentValue;

            // rex
            $this->rex->ViewValue = $this->rex->CurrentValue;

            // rcmc
            $this->rcmc->ViewValue = $this->rcmc->CurrentValue;

            // delivery_terms
            $this->delivery_terms->ViewValue = $this->delivery_terms->CurrentValue;

            // shipping_terms
            $this->shipping_terms->ViewValue = $this->shipping_terms->CurrentValue;

            // payment_terms
            $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;

            // export_type
            $this->export_type->ViewValue = $this->export_type->CurrentValue;

            // lead_time_ss
            $this->lead_time_ss->ViewValue = $this->lead_time_ss->CurrentValue;

            // lead_time_cs
            $this->lead_time_cs->ViewValue = $this->lead_time_cs->CurrentValue;

            // cha
            $this->cha->ViewValue = $this->cha->CurrentValue;

            // cha_email
            $this->cha_email->ViewValue = $this->cha_email->CurrentValue;

            // cha_phone
            $this->cha_phone->ViewValue = $this->cha_phone->CurrentValue;

            // forwarder
            $this->forwarder->ViewValue = $this->forwarder->CurrentValue;

            // forwarder_email
            $this->forwarder_email->ViewValue = $this->forwarder_email->CurrentValue;

            // forwarder_phone
            $this->forwarder_phone->ViewValue = $this->forwarder_phone->CurrentValue;

            // merchant
            $this->merchant->ViewValue = $this->merchant->CurrentValue;

            // merchant_email
            $this->merchant_email->ViewValue = $this->merchant_email->CurrentValue;

            // merchant_phone
            $this->merchant_phone->ViewValue = $this->merchant_phone->CurrentValue;

            // shipping_incharge
            $this->shipping_incharge->ViewValue = $this->shipping_incharge->CurrentValue;

            // shipping_email
            $this->shipping_email->ViewValue = $this->shipping_email->CurrentValue;

            // shipping_phone
            $this->shipping_phone->ViewValue = $this->shipping_phone->CurrentValue;

            // account_incharge
            $this->account_incharge->ViewValue = $this->account_incharge->CurrentValue;

            // accounts_email
            $this->accounts_email->ViewValue = $this->accounts_email->CurrentValue;

            // accounts_phone
            $this->accounts_phone->ViewValue = $this->accounts_phone->CurrentValue;

            // warehouse_incharge
            $this->warehouse_incharge->ViewValue = $this->warehouse_incharge->CurrentValue;

            // warehouse_email
            $this->warehouse_email->ViewValue = $this->warehouse_email->CurrentValue;

            // warehouse_phone
            $this->warehouse_phone->ViewValue = $this->warehouse_phone->CurrentValue;

            // production_incharge
            $this->production_incharge->ViewValue = $this->production_incharge->CurrentValue;

            // production_email
            $this->production_email->ViewValue = $this->production_email->CurrentValue;

            // production_phone
            $this->production_phone->ViewValue = $this->production_phone->CurrentValue;

            // qc_incharge
            $this->qc_incharge->ViewValue = $this->qc_incharge->CurrentValue;

            // qc_email
            $this->qc_email->ViewValue = $this->qc_email->CurrentValue;

            // qc_phone
            $this->qc_phone->ViewValue = $this->qc_phone->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // name
            $this->name->HrefValue = "";
            $this->name->TooltipValue = "";

            // code
            $this->code->HrefValue = "";
            $this->code->TooltipValue = "";

            // country
            $this->country->HrefValue = "";
            $this->country->TooltipValue = "";

            // region
            $this->region->HrefValue = "";
            $this->region->TooltipValue = "";

            // city_name
            $this->city_name->HrefValue = "";
            $this->city_name->TooltipValue = "";

            // address
            $this->address->HrefValue = "";
            $this->address->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // email
            $this->_email->HrefValue = "";
            $this->_email->TooltipValue = "";

            // url
            $this->url->HrefValue = "";
            $this->url->TooltipValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";
            $this->bank_name->TooltipValue = "";

            // bank_account_no
            $this->bank_account_no->HrefValue = "";
            $this->bank_account_no->TooltipValue = "";

            // bank_code
            $this->bank_code->HrefValue = "";
            $this->bank_code->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";
            $this->reports_to->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // performance
            $this->performance->HrefValue = "";
            $this->performance->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // type
            $this->type->HrefValue = "";
            $this->type->TooltipValue = "";

            // tax_registration
            $this->tax_registration->HrefValue = "";
            $this->tax_registration->TooltipValue = "";

            // cin
            $this->cin->HrefValue = "";
            $this->cin->TooltipValue = "";

            // pan
            $this->pan->HrefValue = "";
            $this->pan->TooltipValue = "";

            // tan
            $this->tan->HrefValue = "";
            $this->tan->TooltipValue = "";

            // msme
            $this->msme->HrefValue = "";
            $this->msme->TooltipValue = "";

            // port_air
            $this->port_air->HrefValue = "";
            $this->port_air->TooltipValue = "";

            // port_sea
            $this->port_sea->HrefValue = "";
            $this->port_sea->TooltipValue = "";

            // iec
            $this->iec->HrefValue = "";
            $this->iec->TooltipValue = "";

            // rex
            $this->rex->HrefValue = "";
            $this->rex->TooltipValue = "";

            // rcmc
            $this->rcmc->HrefValue = "";
            $this->rcmc->TooltipValue = "";

            // delivery_terms
            $this->delivery_terms->HrefValue = "";
            $this->delivery_terms->TooltipValue = "";

            // shipping_terms
            $this->shipping_terms->HrefValue = "";
            $this->shipping_terms->TooltipValue = "";

            // payment_terms
            $this->payment_terms->HrefValue = "";
            $this->payment_terms->TooltipValue = "";

            // export_type
            $this->export_type->HrefValue = "";
            $this->export_type->TooltipValue = "";

            // lead_time_ss
            $this->lead_time_ss->HrefValue = "";
            $this->lead_time_ss->TooltipValue = "";

            // lead_time_cs
            $this->lead_time_cs->HrefValue = "";
            $this->lead_time_cs->TooltipValue = "";

            // cha
            $this->cha->HrefValue = "";
            $this->cha->TooltipValue = "";

            // cha_email
            $this->cha_email->HrefValue = "";
            $this->cha_email->TooltipValue = "";

            // cha_phone
            $this->cha_phone->HrefValue = "";
            $this->cha_phone->TooltipValue = "";

            // forwarder
            $this->forwarder->HrefValue = "";
            $this->forwarder->TooltipValue = "";

            // forwarder_email
            $this->forwarder_email->HrefValue = "";
            $this->forwarder_email->TooltipValue = "";

            // forwarder_phone
            $this->forwarder_phone->HrefValue = "";
            $this->forwarder_phone->TooltipValue = "";

            // merchant
            $this->merchant->HrefValue = "";
            $this->merchant->TooltipValue = "";

            // merchant_email
            $this->merchant_email->HrefValue = "";
            $this->merchant_email->TooltipValue = "";

            // merchant_phone
            $this->merchant_phone->HrefValue = "";
            $this->merchant_phone->TooltipValue = "";

            // shipping_incharge
            $this->shipping_incharge->HrefValue = "";
            $this->shipping_incharge->TooltipValue = "";

            // shipping_email
            $this->shipping_email->HrefValue = "";
            $this->shipping_email->TooltipValue = "";

            // shipping_phone
            $this->shipping_phone->HrefValue = "";
            $this->shipping_phone->TooltipValue = "";

            // account_incharge
            $this->account_incharge->HrefValue = "";
            $this->account_incharge->TooltipValue = "";

            // accounts_email
            $this->accounts_email->HrefValue = "";
            $this->accounts_email->TooltipValue = "";

            // accounts_phone
            $this->accounts_phone->HrefValue = "";
            $this->accounts_phone->TooltipValue = "";

            // warehouse_incharge
            $this->warehouse_incharge->HrefValue = "";
            $this->warehouse_incharge->TooltipValue = "";

            // warehouse_email
            $this->warehouse_email->HrefValue = "";
            $this->warehouse_email->TooltipValue = "";

            // warehouse_phone
            $this->warehouse_phone->HrefValue = "";
            $this->warehouse_phone->TooltipValue = "";

            // production_incharge
            $this->production_incharge->HrefValue = "";
            $this->production_incharge->TooltipValue = "";

            // production_email
            $this->production_email->HrefValue = "";
            $this->production_email->TooltipValue = "";

            // production_phone
            $this->production_phone->HrefValue = "";
            $this->production_phone->TooltipValue = "";

            // qc_incharge
            $this->qc_incharge->HrefValue = "";
            $this->qc_incharge->TooltipValue = "";

            // qc_email
            $this->qc_email->HrefValue = "";
            $this->qc_email->TooltipValue = "";

            // qc_phone
            $this->qc_phone->HrefValue = "";
            $this->qc_phone->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Param("key_m") === null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("productionpartnerlist"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_country":
                    break;
                case "x_region":
                    break;
                case "x_city":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_reports_to":
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                case "x_type":
                    break;
                case "x_incoterm":
                    break;
                case "x_port_air":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_port_sea":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'production_partner');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
