<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductionPartnerAdd extends ProductionPartner
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductionPartnerAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "productionpartneradd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->name->setVisibility();
        $this->code->setVisibility();
        $this->country->setVisibility();
        $this->region->setVisibility();
        $this->city->setVisibility();
        $this->city_name->Visible = false;
        $this->address->setVisibility();
        $this->mobile->setVisibility();
        $this->_email->setVisibility();
        $this->url->setVisibility();
        $this->bank_name->setVisibility();
        $this->bank_account_no->setVisibility();
        $this->bank_code->setVisibility();
        $this->grp->setVisibility();
        $this->category->setVisibility();
        $this->reports_to->setVisibility();
        $this->status->setVisibility();
        $this->performance->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->type->setVisibility();
        $this->tax_registration->setVisibility();
        $this->cin->setVisibility();
        $this->pan->setVisibility();
        $this->tan->setVisibility();
        $this->msme->setVisibility();
        $this->incoterm->Visible = false;
        $this->port_air->setVisibility();
        $this->port_sea->setVisibility();
        $this->iec->setVisibility();
        $this->rex->setVisibility();
        $this->rcmc->setVisibility();
        $this->delivery_terms->setVisibility();
        $this->shipping_terms->setVisibility();
        $this->payment_terms->setVisibility();
        $this->export_type->setVisibility();
        $this->lead_time_ss->setVisibility();
        $this->lead_time_cs->setVisibility();
        $this->cha->setVisibility();
        $this->cha_email->setVisibility();
        $this->cha_phone->setVisibility();
        $this->forwarder->setVisibility();
        $this->forwarder_email->setVisibility();
        $this->forwarder_phone->setVisibility();
        $this->merchant->setVisibility();
        $this->merchant_email->setVisibility();
        $this->merchant_phone->setVisibility();
        $this->shipping_incharge->setVisibility();
        $this->shipping_email->setVisibility();
        $this->shipping_phone->setVisibility();
        $this->account_incharge->setVisibility();
        $this->accounts_email->setVisibility();
        $this->accounts_phone->setVisibility();
        $this->warehouse_incharge->setVisibility();
        $this->warehouse_email->setVisibility();
        $this->warehouse_phone->setVisibility();
        $this->production_incharge->setVisibility();
        $this->production_email->setVisibility();
        $this->production_phone->setVisibility();
        $this->qc_incharge->setVisibility();
        $this->qc_email->setVisibility();
        $this->qc_phone->setVisibility();
        $this->uid->Visible = false;
        $this->r_text->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'production_partner';
        $this->TableName = 'production_partner';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (production_partner)
        if (!isset($GLOBALS["production_partner"]) || $GLOBALS["production_partner"]::class == PROJECT_NAMESPACE . "production_partner") {
            $GLOBALS["production_partner"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'production_partner');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "productionpartnerview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->country);
        $this->setupLookupOptions($this->region);
        $this->setupLookupOptions($this->city);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->type);
        $this->setupLookupOptions($this->incoterm);
        $this->setupLookupOptions($this->port_air);
        $this->setupLookupOptions($this->port_sea);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Set up detail parameters
        $this->setupDetailParms();

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("productionpartnerlist"); // No matching record, return to list
                    return;
                }

                // Set up detail parameters
                $this->setupDetailParms();
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    if ($this->getCurrentDetailTable() != "") { // Master/detail add
                        $returnUrl = $this->getDetailUrl();
                    } else {
                        $returnUrl = $this->getReturnUrl();
                    }
                    if (GetPageName($returnUrl) == "productionpartnerlist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "productionpartnerview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "productionpartnerlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "productionpartnerlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values

                    // Set up detail parameters
                    $this->setupDetailParms();
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'name' first before field var 'x_name'
        $val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
        if (!$this->name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->name->Visible = false; // Disable update for API request
            } else {
                $this->name->setFormValue($val);
            }
        }

        // Check field name 'code' first before field var 'x_code'
        $val = $CurrentForm->hasValue("code") ? $CurrentForm->getValue("code") : $CurrentForm->getValue("x_code");
        if (!$this->code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->code->Visible = false; // Disable update for API request
            } else {
                $this->code->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'country' first before field var 'x_country'
        $val = $CurrentForm->hasValue("country") ? $CurrentForm->getValue("country") : $CurrentForm->getValue("x_country");
        if (!$this->country->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->country->Visible = false; // Disable update for API request
            } else {
                $this->country->setFormValue($val);
            }
        }

        // Check field name 'region' first before field var 'x_region'
        $val = $CurrentForm->hasValue("region") ? $CurrentForm->getValue("region") : $CurrentForm->getValue("x_region");
        if (!$this->region->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->region->Visible = false; // Disable update for API request
            } else {
                $this->region->setFormValue($val);
            }
        }

        // Check field name 'city' first before field var 'x_city'
        $val = $CurrentForm->hasValue("city") ? $CurrentForm->getValue("city") : $CurrentForm->getValue("x_city");
        if (!$this->city->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->city->Visible = false; // Disable update for API request
            } else {
                $this->city->setFormValue($val);
            }
        }

        // Check field name 'address' first before field var 'x_address'
        $val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
        if (!$this->address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->address->Visible = false; // Disable update for API request
            } else {
                $this->address->setFormValue($val);
            }
        }

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile->Visible = false; // Disable update for API request
            } else {
                $this->mobile->setFormValue($val);
            }
        }

        // Check field name 'email' first before field var 'x__email'
        $val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
        if (!$this->_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_email->Visible = false; // Disable update for API request
            } else {
                $this->_email->setFormValue($val);
            }
        }

        // Check field name 'url' first before field var 'x_url'
        $val = $CurrentForm->hasValue("url") ? $CurrentForm->getValue("url") : $CurrentForm->getValue("x_url");
        if (!$this->url->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->url->Visible = false; // Disable update for API request
            } else {
                $this->url->setFormValue($val);
            }
        }

        // Check field name 'bank_name' first before field var 'x_bank_name'
        $val = $CurrentForm->hasValue("bank_name") ? $CurrentForm->getValue("bank_name") : $CurrentForm->getValue("x_bank_name");
        if (!$this->bank_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bank_name->Visible = false; // Disable update for API request
            } else {
                $this->bank_name->setFormValue($val);
            }
        }

        // Check field name 'bank_account_no' first before field var 'x_bank_account_no'
        $val = $CurrentForm->hasValue("bank_account_no") ? $CurrentForm->getValue("bank_account_no") : $CurrentForm->getValue("x_bank_account_no");
        if (!$this->bank_account_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bank_account_no->Visible = false; // Disable update for API request
            } else {
                $this->bank_account_no->setFormValue($val);
            }
        }

        // Check field name 'bank_code' first before field var 'x_bank_code'
        $val = $CurrentForm->hasValue("bank_code") ? $CurrentForm->getValue("bank_code") : $CurrentForm->getValue("x_bank_code");
        if (!$this->bank_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bank_code->Visible = false; // Disable update for API request
            } else {
                $this->bank_code->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 'category' first before field var 'x_category'
        $val = $CurrentForm->hasValue("category") ? $CurrentForm->getValue("category") : $CurrentForm->getValue("x_category");
        if (!$this->category->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->category->Visible = false; // Disable update for API request
            } else {
                $this->category->setFormValue($val);
            }
        }

        // Check field name 'reports_to' first before field var 'x_reports_to'
        $val = $CurrentForm->hasValue("reports_to") ? $CurrentForm->getValue("reports_to") : $CurrentForm->getValue("x_reports_to");
        if (!$this->reports_to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reports_to->Visible = false; // Disable update for API request
            } else {
                $this->reports_to->setFormValue($val);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'type' first before field var 'x_type'
        $val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
        if (!$this->type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->type->Visible = false; // Disable update for API request
            } else {
                $this->type->setFormValue($val);
            }
        }

        // Check field name 'tax_registration' first before field var 'x_tax_registration'
        $val = $CurrentForm->hasValue("tax_registration") ? $CurrentForm->getValue("tax_registration") : $CurrentForm->getValue("x_tax_registration");
        if (!$this->tax_registration->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->tax_registration->Visible = false; // Disable update for API request
            } else {
                $this->tax_registration->setFormValue($val);
            }
        }

        // Check field name 'cin' first before field var 'x_cin'
        $val = $CurrentForm->hasValue("cin") ? $CurrentForm->getValue("cin") : $CurrentForm->getValue("x_cin");
        if (!$this->cin->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cin->Visible = false; // Disable update for API request
            } else {
                $this->cin->setFormValue($val);
            }
        }

        // Check field name 'pan' first before field var 'x_pan'
        $val = $CurrentForm->hasValue("pan") ? $CurrentForm->getValue("pan") : $CurrentForm->getValue("x_pan");
        if (!$this->pan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pan->Visible = false; // Disable update for API request
            } else {
                $this->pan->setFormValue($val);
            }
        }

        // Check field name 'tan' first before field var 'x_tan'
        $val = $CurrentForm->hasValue("tan") ? $CurrentForm->getValue("tan") : $CurrentForm->getValue("x_tan");
        if (!$this->tan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->tan->Visible = false; // Disable update for API request
            } else {
                $this->tan->setFormValue($val);
            }
        }

        // Check field name 'msme' first before field var 'x_msme'
        $val = $CurrentForm->hasValue("msme") ? $CurrentForm->getValue("msme") : $CurrentForm->getValue("x_msme");
        if (!$this->msme->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->msme->Visible = false; // Disable update for API request
            } else {
                $this->msme->setFormValue($val);
            }
        }

        // Check field name 'port_air' first before field var 'x_port_air'
        $val = $CurrentForm->hasValue("port_air") ? $CurrentForm->getValue("port_air") : $CurrentForm->getValue("x_port_air");
        if (!$this->port_air->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->port_air->Visible = false; // Disable update for API request
            } else {
                $this->port_air->setFormValue($val);
            }
        }

        // Check field name 'port_sea' first before field var 'x_port_sea'
        $val = $CurrentForm->hasValue("port_sea") ? $CurrentForm->getValue("port_sea") : $CurrentForm->getValue("x_port_sea");
        if (!$this->port_sea->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->port_sea->Visible = false; // Disable update for API request
            } else {
                $this->port_sea->setFormValue($val);
            }
        }

        // Check field name 'iec' first before field var 'x_iec'
        $val = $CurrentForm->hasValue("iec") ? $CurrentForm->getValue("iec") : $CurrentForm->getValue("x_iec");
        if (!$this->iec->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->iec->Visible = false; // Disable update for API request
            } else {
                $this->iec->setFormValue($val);
            }
        }

        // Check field name 'rex' first before field var 'x_rex'
        $val = $CurrentForm->hasValue("rex") ? $CurrentForm->getValue("rex") : $CurrentForm->getValue("x_rex");
        if (!$this->rex->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rex->Visible = false; // Disable update for API request
            } else {
                $this->rex->setFormValue($val);
            }
        }

        // Check field name 'rcmc' first before field var 'x_rcmc'
        $val = $CurrentForm->hasValue("rcmc") ? $CurrentForm->getValue("rcmc") : $CurrentForm->getValue("x_rcmc");
        if (!$this->rcmc->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rcmc->Visible = false; // Disable update for API request
            } else {
                $this->rcmc->setFormValue($val);
            }
        }

        // Check field name 'delivery_terms' first before field var 'x_delivery_terms'
        $val = $CurrentForm->hasValue("delivery_terms") ? $CurrentForm->getValue("delivery_terms") : $CurrentForm->getValue("x_delivery_terms");
        if (!$this->delivery_terms->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->delivery_terms->Visible = false; // Disable update for API request
            } else {
                $this->delivery_terms->setFormValue($val);
            }
        }

        // Check field name 'shipping_terms' first before field var 'x_shipping_terms'
        $val = $CurrentForm->hasValue("shipping_terms") ? $CurrentForm->getValue("shipping_terms") : $CurrentForm->getValue("x_shipping_terms");
        if (!$this->shipping_terms->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shipping_terms->Visible = false; // Disable update for API request
            } else {
                $this->shipping_terms->setFormValue($val);
            }
        }

        // Check field name 'payment_terms' first before field var 'x_payment_terms'
        $val = $CurrentForm->hasValue("payment_terms") ? $CurrentForm->getValue("payment_terms") : $CurrentForm->getValue("x_payment_terms");
        if (!$this->payment_terms->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->payment_terms->Visible = false; // Disable update for API request
            } else {
                $this->payment_terms->setFormValue($val);
            }
        }

        // Check field name 'export_type' first before field var 'x_export_type'
        $val = $CurrentForm->hasValue("export_type") ? $CurrentForm->getValue("export_type") : $CurrentForm->getValue("x_export_type");
        if (!$this->export_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->export_type->Visible = false; // Disable update for API request
            } else {
                $this->export_type->setFormValue($val);
            }
        }

        // Check field name 'lead_time_ss' first before field var 'x_lead_time_ss'
        $val = $CurrentForm->hasValue("lead_time_ss") ? $CurrentForm->getValue("lead_time_ss") : $CurrentForm->getValue("x_lead_time_ss");
        if (!$this->lead_time_ss->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lead_time_ss->Visible = false; // Disable update for API request
            } else {
                $this->lead_time_ss->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'lead_time_cs' first before field var 'x_lead_time_cs'
        $val = $CurrentForm->hasValue("lead_time_cs") ? $CurrentForm->getValue("lead_time_cs") : $CurrentForm->getValue("x_lead_time_cs");
        if (!$this->lead_time_cs->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lead_time_cs->Visible = false; // Disable update for API request
            } else {
                $this->lead_time_cs->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'cha' first before field var 'x_cha'
        $val = $CurrentForm->hasValue("cha") ? $CurrentForm->getValue("cha") : $CurrentForm->getValue("x_cha");
        if (!$this->cha->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cha->Visible = false; // Disable update for API request
            } else {
                $this->cha->setFormValue($val);
            }
        }

        // Check field name 'cha_email' first before field var 'x_cha_email'
        $val = $CurrentForm->hasValue("cha_email") ? $CurrentForm->getValue("cha_email") : $CurrentForm->getValue("x_cha_email");
        if (!$this->cha_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cha_email->Visible = false; // Disable update for API request
            } else {
                $this->cha_email->setFormValue($val);
            }
        }

        // Check field name 'cha_phone' first before field var 'x_cha_phone'
        $val = $CurrentForm->hasValue("cha_phone") ? $CurrentForm->getValue("cha_phone") : $CurrentForm->getValue("x_cha_phone");
        if (!$this->cha_phone->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cha_phone->Visible = false; // Disable update for API request
            } else {
                $this->cha_phone->setFormValue($val);
            }
        }

        // Check field name 'forwarder' first before field var 'x_forwarder'
        $val = $CurrentForm->hasValue("forwarder") ? $CurrentForm->getValue("forwarder") : $CurrentForm->getValue("x_forwarder");
        if (!$this->forwarder->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->forwarder->Visible = false; // Disable update for API request
            } else {
                $this->forwarder->setFormValue($val);
            }
        }

        // Check field name 'forwarder_email' first before field var 'x_forwarder_email'
        $val = $CurrentForm->hasValue("forwarder_email") ? $CurrentForm->getValue("forwarder_email") : $CurrentForm->getValue("x_forwarder_email");
        if (!$this->forwarder_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->forwarder_email->Visible = false; // Disable update for API request
            } else {
                $this->forwarder_email->setFormValue($val);
            }
        }

        // Check field name 'forwarder_phone' first before field var 'x_forwarder_phone'
        $val = $CurrentForm->hasValue("forwarder_phone") ? $CurrentForm->getValue("forwarder_phone") : $CurrentForm->getValue("x_forwarder_phone");
        if (!$this->forwarder_phone->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->forwarder_phone->Visible = false; // Disable update for API request
            } else {
                $this->forwarder_phone->setFormValue($val);
            }
        }

        // Check field name 'merchant' first before field var 'x_merchant'
        $val = $CurrentForm->hasValue("merchant") ? $CurrentForm->getValue("merchant") : $CurrentForm->getValue("x_merchant");
        if (!$this->merchant->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->merchant->Visible = false; // Disable update for API request
            } else {
                $this->merchant->setFormValue($val);
            }
        }

        // Check field name 'merchant_email' first before field var 'x_merchant_email'
        $val = $CurrentForm->hasValue("merchant_email") ? $CurrentForm->getValue("merchant_email") : $CurrentForm->getValue("x_merchant_email");
        if (!$this->merchant_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->merchant_email->Visible = false; // Disable update for API request
            } else {
                $this->merchant_email->setFormValue($val);
            }
        }

        // Check field name 'merchant_phone' first before field var 'x_merchant_phone'
        $val = $CurrentForm->hasValue("merchant_phone") ? $CurrentForm->getValue("merchant_phone") : $CurrentForm->getValue("x_merchant_phone");
        if (!$this->merchant_phone->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->merchant_phone->Visible = false; // Disable update for API request
            } else {
                $this->merchant_phone->setFormValue($val);
            }
        }

        // Check field name 'shipping_incharge' first before field var 'x_shipping_incharge'
        $val = $CurrentForm->hasValue("shipping_incharge") ? $CurrentForm->getValue("shipping_incharge") : $CurrentForm->getValue("x_shipping_incharge");
        if (!$this->shipping_incharge->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shipping_incharge->Visible = false; // Disable update for API request
            } else {
                $this->shipping_incharge->setFormValue($val);
            }
        }

        // Check field name 'shipping_email' first before field var 'x_shipping_email'
        $val = $CurrentForm->hasValue("shipping_email") ? $CurrentForm->getValue("shipping_email") : $CurrentForm->getValue("x_shipping_email");
        if (!$this->shipping_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shipping_email->Visible = false; // Disable update for API request
            } else {
                $this->shipping_email->setFormValue($val);
            }
        }

        // Check field name 'shipping_phone' first before field var 'x_shipping_phone'
        $val = $CurrentForm->hasValue("shipping_phone") ? $CurrentForm->getValue("shipping_phone") : $CurrentForm->getValue("x_shipping_phone");
        if (!$this->shipping_phone->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shipping_phone->Visible = false; // Disable update for API request
            } else {
                $this->shipping_phone->setFormValue($val);
            }
        }

        // Check field name 'account_incharge' first before field var 'x_account_incharge'
        $val = $CurrentForm->hasValue("account_incharge") ? $CurrentForm->getValue("account_incharge") : $CurrentForm->getValue("x_account_incharge");
        if (!$this->account_incharge->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->account_incharge->Visible = false; // Disable update for API request
            } else {
                $this->account_incharge->setFormValue($val);
            }
        }

        // Check field name 'accounts_email' first before field var 'x_accounts_email'
        $val = $CurrentForm->hasValue("accounts_email") ? $CurrentForm->getValue("accounts_email") : $CurrentForm->getValue("x_accounts_email");
        if (!$this->accounts_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->accounts_email->Visible = false; // Disable update for API request
            } else {
                $this->accounts_email->setFormValue($val);
            }
        }

        // Check field name 'accounts_phone' first before field var 'x_accounts_phone'
        $val = $CurrentForm->hasValue("accounts_phone") ? $CurrentForm->getValue("accounts_phone") : $CurrentForm->getValue("x_accounts_phone");
        if (!$this->accounts_phone->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->accounts_phone->Visible = false; // Disable update for API request
            } else {
                $this->accounts_phone->setFormValue($val);
            }
        }

        // Check field name 'warehouse_incharge' first before field var 'x_warehouse_incharge'
        $val = $CurrentForm->hasValue("warehouse_incharge") ? $CurrentForm->getValue("warehouse_incharge") : $CurrentForm->getValue("x_warehouse_incharge");
        if (!$this->warehouse_incharge->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->warehouse_incharge->Visible = false; // Disable update for API request
            } else {
                $this->warehouse_incharge->setFormValue($val);
            }
        }

        // Check field name 'warehouse_email' first before field var 'x_warehouse_email'
        $val = $CurrentForm->hasValue("warehouse_email") ? $CurrentForm->getValue("warehouse_email") : $CurrentForm->getValue("x_warehouse_email");
        if (!$this->warehouse_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->warehouse_email->Visible = false; // Disable update for API request
            } else {
                $this->warehouse_email->setFormValue($val);
            }
        }

        // Check field name 'warehouse_phone' first before field var 'x_warehouse_phone'
        $val = $CurrentForm->hasValue("warehouse_phone") ? $CurrentForm->getValue("warehouse_phone") : $CurrentForm->getValue("x_warehouse_phone");
        if (!$this->warehouse_phone->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->warehouse_phone->Visible = false; // Disable update for API request
            } else {
                $this->warehouse_phone->setFormValue($val);
            }
        }

        // Check field name 'production_incharge' first before field var 'x_production_incharge'
        $val = $CurrentForm->hasValue("production_incharge") ? $CurrentForm->getValue("production_incharge") : $CurrentForm->getValue("x_production_incharge");
        if (!$this->production_incharge->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->production_incharge->Visible = false; // Disable update for API request
            } else {
                $this->production_incharge->setFormValue($val);
            }
        }

        // Check field name 'production_email' first before field var 'x_production_email'
        $val = $CurrentForm->hasValue("production_email") ? $CurrentForm->getValue("production_email") : $CurrentForm->getValue("x_production_email");
        if (!$this->production_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->production_email->Visible = false; // Disable update for API request
            } else {
                $this->production_email->setFormValue($val);
            }
        }

        // Check field name 'production_phone' first before field var 'x_production_phone'
        $val = $CurrentForm->hasValue("production_phone") ? $CurrentForm->getValue("production_phone") : $CurrentForm->getValue("x_production_phone");
        if (!$this->production_phone->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->production_phone->Visible = false; // Disable update for API request
            } else {
                $this->production_phone->setFormValue($val);
            }
        }

        // Check field name 'qc_incharge' first before field var 'x_qc_incharge'
        $val = $CurrentForm->hasValue("qc_incharge") ? $CurrentForm->getValue("qc_incharge") : $CurrentForm->getValue("x_qc_incharge");
        if (!$this->qc_incharge->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qc_incharge->Visible = false; // Disable update for API request
            } else {
                $this->qc_incharge->setFormValue($val);
            }
        }

        // Check field name 'qc_email' first before field var 'x_qc_email'
        $val = $CurrentForm->hasValue("qc_email") ? $CurrentForm->getValue("qc_email") : $CurrentForm->getValue("x_qc_email");
        if (!$this->qc_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qc_email->Visible = false; // Disable update for API request
            } else {
                $this->qc_email->setFormValue($val);
            }
        }

        // Check field name 'qc_phone' first before field var 'x_qc_phone'
        $val = $CurrentForm->hasValue("qc_phone") ? $CurrentForm->getValue("qc_phone") : $CurrentForm->getValue("x_qc_phone");
        if (!$this->qc_phone->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qc_phone->Visible = false; // Disable update for API request
            } else {
                $this->qc_phone->setFormValue($val);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->name->CurrentValue = $this->name->FormValue;
        $this->code->CurrentValue = $this->code->FormValue;
        $this->country->CurrentValue = $this->country->FormValue;
        $this->region->CurrentValue = $this->region->FormValue;
        $this->city->CurrentValue = $this->city->FormValue;
        $this->address->CurrentValue = $this->address->FormValue;
        $this->mobile->CurrentValue = $this->mobile->FormValue;
        $this->_email->CurrentValue = $this->_email->FormValue;
        $this->url->CurrentValue = $this->url->FormValue;
        $this->bank_name->CurrentValue = $this->bank_name->FormValue;
        $this->bank_account_no->CurrentValue = $this->bank_account_no->FormValue;
        $this->bank_code->CurrentValue = $this->bank_code->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->category->CurrentValue = $this->category->FormValue;
        $this->reports_to->CurrentValue = $this->reports_to->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->type->CurrentValue = $this->type->FormValue;
        $this->tax_registration->CurrentValue = $this->tax_registration->FormValue;
        $this->cin->CurrentValue = $this->cin->FormValue;
        $this->pan->CurrentValue = $this->pan->FormValue;
        $this->tan->CurrentValue = $this->tan->FormValue;
        $this->msme->CurrentValue = $this->msme->FormValue;
        $this->port_air->CurrentValue = $this->port_air->FormValue;
        $this->port_sea->CurrentValue = $this->port_sea->FormValue;
        $this->iec->CurrentValue = $this->iec->FormValue;
        $this->rex->CurrentValue = $this->rex->FormValue;
        $this->rcmc->CurrentValue = $this->rcmc->FormValue;
        $this->delivery_terms->CurrentValue = $this->delivery_terms->FormValue;
        $this->shipping_terms->CurrentValue = $this->shipping_terms->FormValue;
        $this->payment_terms->CurrentValue = $this->payment_terms->FormValue;
        $this->export_type->CurrentValue = $this->export_type->FormValue;
        $this->lead_time_ss->CurrentValue = $this->lead_time_ss->FormValue;
        $this->lead_time_cs->CurrentValue = $this->lead_time_cs->FormValue;
        $this->cha->CurrentValue = $this->cha->FormValue;
        $this->cha_email->CurrentValue = $this->cha_email->FormValue;
        $this->cha_phone->CurrentValue = $this->cha_phone->FormValue;
        $this->forwarder->CurrentValue = $this->forwarder->FormValue;
        $this->forwarder_email->CurrentValue = $this->forwarder_email->FormValue;
        $this->forwarder_phone->CurrentValue = $this->forwarder_phone->FormValue;
        $this->merchant->CurrentValue = $this->merchant->FormValue;
        $this->merchant_email->CurrentValue = $this->merchant_email->FormValue;
        $this->merchant_phone->CurrentValue = $this->merchant_phone->FormValue;
        $this->shipping_incharge->CurrentValue = $this->shipping_incharge->FormValue;
        $this->shipping_email->CurrentValue = $this->shipping_email->FormValue;
        $this->shipping_phone->CurrentValue = $this->shipping_phone->FormValue;
        $this->account_incharge->CurrentValue = $this->account_incharge->FormValue;
        $this->accounts_email->CurrentValue = $this->accounts_email->FormValue;
        $this->accounts_phone->CurrentValue = $this->accounts_phone->FormValue;
        $this->warehouse_incharge->CurrentValue = $this->warehouse_incharge->FormValue;
        $this->warehouse_email->CurrentValue = $this->warehouse_email->FormValue;
        $this->warehouse_phone->CurrentValue = $this->warehouse_phone->FormValue;
        $this->production_incharge->CurrentValue = $this->production_incharge->FormValue;
        $this->production_email->CurrentValue = $this->production_email->FormValue;
        $this->production_phone->CurrentValue = $this->production_phone->FormValue;
        $this->qc_incharge->CurrentValue = $this->qc_incharge->FormValue;
        $this->qc_email->CurrentValue = $this->qc_email->FormValue;
        $this->qc_phone->CurrentValue = $this->qc_phone->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->name->setDbValue($row['name']);
        $this->code->setDbValue($row['code']);
        $this->country->setDbValue($row['country']);
        $this->region->setDbValue($row['region']);
        $this->city->setDbValue($row['city']);
        if (array_key_exists('EV__city', $row)) {
            $this->city->VirtualValue = $row['EV__city']; // Set up virtual field value
        } else {
            $this->city->VirtualValue = ""; // Clear value
        }
        $this->city_name->setDbValue($row['city_name']);
        $this->address->setDbValue($row['address']);
        $this->mobile->setDbValue($row['mobile']);
        $this->_email->setDbValue($row['email']);
        $this->url->setDbValue($row['url']);
        $this->bank_name->setDbValue($row['bank_name']);
        $this->bank_account_no->setDbValue($row['bank_account_no']);
        $this->bank_code->setDbValue($row['bank_code']);
        $this->grp->setDbValue($row['grp']);
        $this->category->setDbValue($row['category']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->status->setDbValue($row['status']);
        $this->performance->setDbValue($row['performance']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->type->setDbValue($row['type']);
        $this->tax_registration->setDbValue($row['tax_registration']);
        $this->cin->setDbValue($row['cin']);
        $this->pan->setDbValue($row['pan']);
        $this->tan->setDbValue($row['tan']);
        $this->msme->setDbValue($row['msme']);
        $this->incoterm->setDbValue($row['incoterm']);
        $this->port_air->setDbValue($row['port_air']);
        $this->port_sea->setDbValue($row['port_sea']);
        $this->iec->setDbValue($row['iec']);
        $this->rex->setDbValue($row['rex']);
        $this->rcmc->setDbValue($row['rcmc']);
        $this->delivery_terms->setDbValue($row['delivery_terms']);
        $this->shipping_terms->setDbValue($row['shipping_terms']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->export_type->setDbValue($row['export_type']);
        $this->lead_time_ss->setDbValue($row['lead_time_ss']);
        $this->lead_time_cs->setDbValue($row['lead_time_cs']);
        $this->cha->setDbValue($row['cha']);
        $this->cha_email->setDbValue($row['cha_email']);
        $this->cha_phone->setDbValue($row['cha_phone']);
        $this->forwarder->setDbValue($row['forwarder']);
        $this->forwarder_email->setDbValue($row['forwarder_email']);
        $this->forwarder_phone->setDbValue($row['forwarder_phone']);
        $this->merchant->setDbValue($row['merchant']);
        $this->merchant_email->setDbValue($row['merchant_email']);
        $this->merchant_phone->setDbValue($row['merchant_phone']);
        $this->shipping_incharge->setDbValue($row['shipping_incharge']);
        $this->shipping_email->setDbValue($row['shipping_email']);
        $this->shipping_phone->setDbValue($row['shipping_phone']);
        $this->account_incharge->setDbValue($row['account_incharge']);
        $this->accounts_email->setDbValue($row['accounts_email']);
        $this->accounts_phone->setDbValue($row['accounts_phone']);
        $this->warehouse_incharge->setDbValue($row['warehouse_incharge']);
        $this->warehouse_email->setDbValue($row['warehouse_email']);
        $this->warehouse_phone->setDbValue($row['warehouse_phone']);
        $this->production_incharge->setDbValue($row['production_incharge']);
        $this->production_email->setDbValue($row['production_email']);
        $this->production_phone->setDbValue($row['production_phone']);
        $this->qc_incharge->setDbValue($row['qc_incharge']);
        $this->qc_email->setDbValue($row['qc_email']);
        $this->qc_phone->setDbValue($row['qc_phone']);
        $this->uid->setDbValue($row['uid']);
        $this->r_text->setDbValue($row['r_text']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['name'] = $this->name->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['country'] = $this->country->DefaultValue;
        $row['region'] = $this->region->DefaultValue;
        $row['city'] = $this->city->DefaultValue;
        $row['city_name'] = $this->city_name->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['url'] = $this->url->DefaultValue;
        $row['bank_name'] = $this->bank_name->DefaultValue;
        $row['bank_account_no'] = $this->bank_account_no->DefaultValue;
        $row['bank_code'] = $this->bank_code->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['performance'] = $this->performance->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['tax_registration'] = $this->tax_registration->DefaultValue;
        $row['cin'] = $this->cin->DefaultValue;
        $row['pan'] = $this->pan->DefaultValue;
        $row['tan'] = $this->tan->DefaultValue;
        $row['msme'] = $this->msme->DefaultValue;
        $row['incoterm'] = $this->incoterm->DefaultValue;
        $row['port_air'] = $this->port_air->DefaultValue;
        $row['port_sea'] = $this->port_sea->DefaultValue;
        $row['iec'] = $this->iec->DefaultValue;
        $row['rex'] = $this->rex->DefaultValue;
        $row['rcmc'] = $this->rcmc->DefaultValue;
        $row['delivery_terms'] = $this->delivery_terms->DefaultValue;
        $row['shipping_terms'] = $this->shipping_terms->DefaultValue;
        $row['payment_terms'] = $this->payment_terms->DefaultValue;
        $row['export_type'] = $this->export_type->DefaultValue;
        $row['lead_time_ss'] = $this->lead_time_ss->DefaultValue;
        $row['lead_time_cs'] = $this->lead_time_cs->DefaultValue;
        $row['cha'] = $this->cha->DefaultValue;
        $row['cha_email'] = $this->cha_email->DefaultValue;
        $row['cha_phone'] = $this->cha_phone->DefaultValue;
        $row['forwarder'] = $this->forwarder->DefaultValue;
        $row['forwarder_email'] = $this->forwarder_email->DefaultValue;
        $row['forwarder_phone'] = $this->forwarder_phone->DefaultValue;
        $row['merchant'] = $this->merchant->DefaultValue;
        $row['merchant_email'] = $this->merchant_email->DefaultValue;
        $row['merchant_phone'] = $this->merchant_phone->DefaultValue;
        $row['shipping_incharge'] = $this->shipping_incharge->DefaultValue;
        $row['shipping_email'] = $this->shipping_email->DefaultValue;
        $row['shipping_phone'] = $this->shipping_phone->DefaultValue;
        $row['account_incharge'] = $this->account_incharge->DefaultValue;
        $row['accounts_email'] = $this->accounts_email->DefaultValue;
        $row['accounts_phone'] = $this->accounts_phone->DefaultValue;
        $row['warehouse_incharge'] = $this->warehouse_incharge->DefaultValue;
        $row['warehouse_email'] = $this->warehouse_email->DefaultValue;
        $row['warehouse_phone'] = $this->warehouse_phone->DefaultValue;
        $row['production_incharge'] = $this->production_incharge->DefaultValue;
        $row['production_email'] = $this->production_email->DefaultValue;
        $row['production_phone'] = $this->production_phone->DefaultValue;
        $row['qc_incharge'] = $this->qc_incharge->DefaultValue;
        $row['qc_email'] = $this->qc_email->DefaultValue;
        $row['qc_phone'] = $this->qc_phone->DefaultValue;
        $row['uid'] = $this->uid->DefaultValue;
        $row['r_text'] = $this->r_text->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // country
        $this->country->RowCssClass = "row";

        // region
        $this->region->RowCssClass = "row";

        // city
        $this->city->RowCssClass = "row";

        // city_name
        $this->city_name->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // url
        $this->url->RowCssClass = "row";

        // bank_name
        $this->bank_name->RowCssClass = "row";

        // bank_account_no
        $this->bank_account_no->RowCssClass = "row";

        // bank_code
        $this->bank_code->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // performance
        $this->performance->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // tax_registration
        $this->tax_registration->RowCssClass = "row";

        // cin
        $this->cin->RowCssClass = "row";

        // pan
        $this->pan->RowCssClass = "row";

        // tan
        $this->tan->RowCssClass = "row";

        // msme
        $this->msme->RowCssClass = "row";

        // incoterm
        $this->incoterm->RowCssClass = "row";

        // port_air
        $this->port_air->RowCssClass = "row";

        // port_sea
        $this->port_sea->RowCssClass = "row";

        // iec
        $this->iec->RowCssClass = "row";

        // rex
        $this->rex->RowCssClass = "row";

        // rcmc
        $this->rcmc->RowCssClass = "row";

        // delivery_terms
        $this->delivery_terms->RowCssClass = "row";

        // shipping_terms
        $this->shipping_terms->RowCssClass = "row";

        // payment_terms
        $this->payment_terms->RowCssClass = "row";

        // export_type
        $this->export_type->RowCssClass = "row";

        // lead_time_ss
        $this->lead_time_ss->RowCssClass = "row";

        // lead_time_cs
        $this->lead_time_cs->RowCssClass = "row";

        // cha
        $this->cha->RowCssClass = "row";

        // cha_email
        $this->cha_email->RowCssClass = "row";

        // cha_phone
        $this->cha_phone->RowCssClass = "row";

        // forwarder
        $this->forwarder->RowCssClass = "row";

        // forwarder_email
        $this->forwarder_email->RowCssClass = "row";

        // forwarder_phone
        $this->forwarder_phone->RowCssClass = "row";

        // merchant
        $this->merchant->RowCssClass = "row";

        // merchant_email
        $this->merchant_email->RowCssClass = "row";

        // merchant_phone
        $this->merchant_phone->RowCssClass = "row";

        // shipping_incharge
        $this->shipping_incharge->RowCssClass = "row";

        // shipping_email
        $this->shipping_email->RowCssClass = "row";

        // shipping_phone
        $this->shipping_phone->RowCssClass = "row";

        // account_incharge
        $this->account_incharge->RowCssClass = "row";

        // accounts_email
        $this->accounts_email->RowCssClass = "row";

        // accounts_phone
        $this->accounts_phone->RowCssClass = "row";

        // warehouse_incharge
        $this->warehouse_incharge->RowCssClass = "row";

        // warehouse_email
        $this->warehouse_email->RowCssClass = "row";

        // warehouse_phone
        $this->warehouse_phone->RowCssClass = "row";

        // production_incharge
        $this->production_incharge->RowCssClass = "row";

        // production_email
        $this->production_email->RowCssClass = "row";

        // production_phone
        $this->production_phone->RowCssClass = "row";

        // qc_incharge
        $this->qc_incharge->RowCssClass = "row";

        // qc_email
        $this->qc_email->RowCssClass = "row";

        // qc_phone
        $this->qc_phone->RowCssClass = "row";

        // uid
        $this->uid->RowCssClass = "row";

        // r_text
        $this->r_text->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // code
            $this->code->ViewValue = $this->code->CurrentValue;

            // country
            $curVal = strval($this->country->CurrentValue);
            if ($curVal != "") {
                $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
                if ($this->country->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->country->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->country->Lookup->renderViewRow($rswrk[0]);
                        $this->country->ViewValue = $this->country->displayValue($arwrk);
                    } else {
                        $this->country->ViewValue = FormatNumber($this->country->CurrentValue, $this->country->formatPattern());
                    }
                }
            } else {
                $this->country->ViewValue = null;
            }

            // region
            $curVal = strval($this->region->CurrentValue);
            if ($curVal != "") {
                $this->region->ViewValue = $this->region->lookupCacheOption($curVal);
                if ($this->region->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->region->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->region->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->region->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->region->Lookup->renderViewRow($rswrk[0]);
                        $this->region->ViewValue = $this->region->displayValue($arwrk);
                    } else {
                        $this->region->ViewValue = FormatNumber($this->region->CurrentValue, $this->region->formatPattern());
                    }
                }
            } else {
                $this->region->ViewValue = null;
            }

            // city
            if ($this->city->VirtualValue != "") {
                $this->city->ViewValue = $this->city->VirtualValue;
            } else {
                $this->city->ViewValue = $this->city->CurrentValue;
                $curVal = strval($this->city->CurrentValue);
                if ($curVal != "") {
                    $this->city->ViewValue = $this->city->lookupCacheOption($curVal);
                    if ($this->city->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->city->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->city->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->city->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->city->Lookup->renderViewRow($rswrk[0]);
                            $this->city->ViewValue = $this->city->displayValue($arwrk);
                        } else {
                            $this->city->ViewValue = FormatNumber($this->city->CurrentValue, $this->city->formatPattern());
                        }
                    }
                } else {
                    $this->city->ViewValue = null;
                }
            }

            // city_name
            $this->city_name->ViewValue = $this->city_name->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // url
            $this->url->ViewValue = $this->url->CurrentValue;

            // bank_name
            $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

            // bank_account_no
            $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

            // bank_code
            $this->bank_code->ViewValue = $this->bank_code->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->grp->Lookup->renderViewRow($row);
                            $this->grp->ViewValue->add($this->grp->displayValue($arwrk));
                        }
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                        $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                    } else {
                        $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // performance
            $this->performance->ViewValue = $this->performance->CurrentValue;
            $this->performance->ViewValue = FormatNumber($this->performance->ViewValue, $this->performance->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // type
            if (strval($this->type->CurrentValue) != "") {
                $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
            } else {
                $this->type->ViewValue = null;
            }

            // tax_registration
            $this->tax_registration->ViewValue = $this->tax_registration->CurrentValue;

            // cin
            $this->cin->ViewValue = $this->cin->CurrentValue;

            // pan
            $this->pan->ViewValue = $this->pan->CurrentValue;

            // tan
            $this->tan->ViewValue = $this->tan->CurrentValue;

            // msme
            $this->msme->ViewValue = $this->msme->CurrentValue;

            // port_air
            $curVal = strval($this->port_air->CurrentValue);
            if ($curVal != "") {
                $this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
                if ($this->port_air->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->port_air->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->port_air->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->port_air->getSelectFilter($this); // PHP
                    $sqlWrk = $this->port_air->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->port_air->Lookup->renderViewRow($rswrk[0]);
                        $this->port_air->ViewValue = $this->port_air->displayValue($arwrk);
                    } else {
                        $this->port_air->ViewValue = $this->port_air->CurrentValue;
                    }
                }
            } else {
                $this->port_air->ViewValue = null;
            }

            // port_sea
            $curVal = strval($this->port_sea->CurrentValue);
            if ($curVal != "") {
                $this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
                if ($this->port_sea->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->port_sea->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->port_sea->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->port_sea->getSelectFilter($this); // PHP
                    $sqlWrk = $this->port_sea->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->port_sea->Lookup->renderViewRow($rswrk[0]);
                        $this->port_sea->ViewValue = $this->port_sea->displayValue($arwrk);
                    } else {
                        $this->port_sea->ViewValue = $this->port_sea->CurrentValue;
                    }
                }
            } else {
                $this->port_sea->ViewValue = null;
            }

            // iec
            $this->iec->ViewValue = $this->iec->CurrentValue;

            // rex
            $this->rex->ViewValue = $this->rex->CurrentValue;

            // rcmc
            $this->rcmc->ViewValue = $this->rcmc->CurrentValue;

            // delivery_terms
            $this->delivery_terms->ViewValue = $this->delivery_terms->CurrentValue;

            // shipping_terms
            $this->shipping_terms->ViewValue = $this->shipping_terms->CurrentValue;

            // payment_terms
            $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;

            // export_type
            $this->export_type->ViewValue = $this->export_type->CurrentValue;

            // lead_time_ss
            $this->lead_time_ss->ViewValue = $this->lead_time_ss->CurrentValue;

            // lead_time_cs
            $this->lead_time_cs->ViewValue = $this->lead_time_cs->CurrentValue;

            // cha
            $this->cha->ViewValue = $this->cha->CurrentValue;

            // cha_email
            $this->cha_email->ViewValue = $this->cha_email->CurrentValue;

            // cha_phone
            $this->cha_phone->ViewValue = $this->cha_phone->CurrentValue;

            // forwarder
            $this->forwarder->ViewValue = $this->forwarder->CurrentValue;

            // forwarder_email
            $this->forwarder_email->ViewValue = $this->forwarder_email->CurrentValue;

            // forwarder_phone
            $this->forwarder_phone->ViewValue = $this->forwarder_phone->CurrentValue;

            // merchant
            $this->merchant->ViewValue = $this->merchant->CurrentValue;

            // merchant_email
            $this->merchant_email->ViewValue = $this->merchant_email->CurrentValue;

            // merchant_phone
            $this->merchant_phone->ViewValue = $this->merchant_phone->CurrentValue;

            // shipping_incharge
            $this->shipping_incharge->ViewValue = $this->shipping_incharge->CurrentValue;

            // shipping_email
            $this->shipping_email->ViewValue = $this->shipping_email->CurrentValue;

            // shipping_phone
            $this->shipping_phone->ViewValue = $this->shipping_phone->CurrentValue;

            // account_incharge
            $this->account_incharge->ViewValue = $this->account_incharge->CurrentValue;

            // accounts_email
            $this->accounts_email->ViewValue = $this->accounts_email->CurrentValue;

            // accounts_phone
            $this->accounts_phone->ViewValue = $this->accounts_phone->CurrentValue;

            // warehouse_incharge
            $this->warehouse_incharge->ViewValue = $this->warehouse_incharge->CurrentValue;

            // warehouse_email
            $this->warehouse_email->ViewValue = $this->warehouse_email->CurrentValue;

            // warehouse_phone
            $this->warehouse_phone->ViewValue = $this->warehouse_phone->CurrentValue;

            // production_incharge
            $this->production_incharge->ViewValue = $this->production_incharge->CurrentValue;

            // production_email
            $this->production_email->ViewValue = $this->production_email->CurrentValue;

            // production_phone
            $this->production_phone->ViewValue = $this->production_phone->CurrentValue;

            // qc_incharge
            $this->qc_incharge->ViewValue = $this->qc_incharge->CurrentValue;

            // qc_email
            $this->qc_email->ViewValue = $this->qc_email->CurrentValue;

            // qc_phone
            $this->qc_phone->ViewValue = $this->qc_phone->CurrentValue;

            // name
            $this->name->HrefValue = "";

            // code
            $this->code->HrefValue = "";

            // country
            $this->country->HrefValue = "";

            // region
            $this->region->HrefValue = "";

            // city
            $this->city->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // url
            $this->url->HrefValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";

            // bank_account_no
            $this->bank_account_no->HrefValue = "";

            // bank_code
            $this->bank_code->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // type
            $this->type->HrefValue = "";

            // tax_registration
            $this->tax_registration->HrefValue = "";

            // cin
            $this->cin->HrefValue = "";

            // pan
            $this->pan->HrefValue = "";

            // tan
            $this->tan->HrefValue = "";

            // msme
            $this->msme->HrefValue = "";

            // port_air
            $this->port_air->HrefValue = "";

            // port_sea
            $this->port_sea->HrefValue = "";

            // iec
            $this->iec->HrefValue = "";

            // rex
            $this->rex->HrefValue = "";

            // rcmc
            $this->rcmc->HrefValue = "";

            // delivery_terms
            $this->delivery_terms->HrefValue = "";

            // shipping_terms
            $this->shipping_terms->HrefValue = "";

            // payment_terms
            $this->payment_terms->HrefValue = "";

            // export_type
            $this->export_type->HrefValue = "";

            // lead_time_ss
            $this->lead_time_ss->HrefValue = "";

            // lead_time_cs
            $this->lead_time_cs->HrefValue = "";

            // cha
            $this->cha->HrefValue = "";

            // cha_email
            $this->cha_email->HrefValue = "";

            // cha_phone
            $this->cha_phone->HrefValue = "";

            // forwarder
            $this->forwarder->HrefValue = "";

            // forwarder_email
            $this->forwarder_email->HrefValue = "";

            // forwarder_phone
            $this->forwarder_phone->HrefValue = "";

            // merchant
            $this->merchant->HrefValue = "";

            // merchant_email
            $this->merchant_email->HrefValue = "";

            // merchant_phone
            $this->merchant_phone->HrefValue = "";

            // shipping_incharge
            $this->shipping_incharge->HrefValue = "";

            // shipping_email
            $this->shipping_email->HrefValue = "";

            // shipping_phone
            $this->shipping_phone->HrefValue = "";

            // account_incharge
            $this->account_incharge->HrefValue = "";

            // accounts_email
            $this->accounts_email->HrefValue = "";

            // accounts_phone
            $this->accounts_phone->HrefValue = "";

            // warehouse_incharge
            $this->warehouse_incharge->HrefValue = "";

            // warehouse_email
            $this->warehouse_email->HrefValue = "";

            // warehouse_phone
            $this->warehouse_phone->HrefValue = "";

            // production_incharge
            $this->production_incharge->HrefValue = "";

            // production_email
            $this->production_email->HrefValue = "";

            // production_phone
            $this->production_phone->HrefValue = "";

            // qc_incharge
            $this->qc_incharge->HrefValue = "";

            // qc_email
            $this->qc_email->HrefValue = "";

            // qc_phone
            $this->qc_phone->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->CurrentValue);
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // code
            $this->code->setupEditAttributes();
            if (!$this->code->Raw) {
                $this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
            }
            $this->code->EditValue = HtmlEncode($this->code->CurrentValue);
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());

            // country
            $this->country->setupEditAttributes();
            $curVal = trim(strval($this->country->CurrentValue));
            if ($curVal != "") {
                $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
            } else {
                $this->country->ViewValue = $this->country->Lookup !== null && is_array($this->country->lookupOptions()) && count($this->country->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->country->ViewValue !== null) { // Load from cache
                $this->country->EditValue = array_values($this->country->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->country->CurrentValue, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->country->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->country->EditValue = $arwrk;
            }
            $this->country->PlaceHolder = RemoveHtml($this->country->caption());

            // region
            $this->region->setupEditAttributes();
            $curVal = trim(strval($this->region->CurrentValue));
            if ($curVal != "") {
                $this->region->ViewValue = $this->region->lookupCacheOption($curVal);
            } else {
                $this->region->ViewValue = $this->region->Lookup !== null && is_array($this->region->lookupOptions()) && count($this->region->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->region->ViewValue !== null) { // Load from cache
                $this->region->EditValue = array_values($this->region->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->region->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->region->CurrentValue, $this->region->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->region->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->region->EditValue = $arwrk;
            }
            $this->region->PlaceHolder = RemoveHtml($this->region->caption());

            // city
            $this->city->setupEditAttributes();
            $this->city->EditValue = $this->city->CurrentValue;
            $curVal = strval($this->city->CurrentValue);
            if ($curVal != "") {
                $this->city->EditValue = $this->city->lookupCacheOption($curVal);
                if ($this->city->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->city->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->city->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->city->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->city->Lookup->renderViewRow($rswrk[0]);
                        $this->city->EditValue = $this->city->displayValue($arwrk);
                    } else {
                        $this->city->EditValue = HtmlEncode(FormatNumber($this->city->CurrentValue, $this->city->formatPattern()));
                    }
                }
            } else {
                $this->city->EditValue = null;
            }
            $this->city->PlaceHolder = RemoveHtml($this->city->caption());

            // address
            $this->address->setupEditAttributes();
            $this->address->EditValue = HtmlEncode($this->address->CurrentValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            if (!$this->mobile->Raw) {
                $this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
            }
            $this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // url
            $this->url->setupEditAttributes();
            if (!$this->url->Raw) {
                $this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
            }
            $this->url->EditValue = HtmlEncode($this->url->CurrentValue);
            $this->url->PlaceHolder = RemoveHtml($this->url->caption());

            // bank_name
            $this->bank_name->setupEditAttributes();
            if (!$this->bank_name->Raw) {
                $this->bank_name->CurrentValue = HtmlDecode($this->bank_name->CurrentValue);
            }
            $this->bank_name->EditValue = HtmlEncode($this->bank_name->CurrentValue);
            $this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

            // bank_account_no
            $this->bank_account_no->setupEditAttributes();
            if (!$this->bank_account_no->Raw) {
                $this->bank_account_no->CurrentValue = HtmlDecode($this->bank_account_no->CurrentValue);
            }
            $this->bank_account_no->EditValue = HtmlEncode($this->bank_account_no->CurrentValue);
            $this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

            // bank_code
            $this->bank_code->setupEditAttributes();
            if (!$this->bank_code->Raw) {
                $this->bank_code->CurrentValue = HtmlDecode($this->bank_code->CurrentValue);
            }
            $this->bank_code->EditValue = HtmlEncode($this->bank_code->CurrentValue);
            $this->bank_code->PlaceHolder = RemoveHtml($this->bank_code->caption());

            // grp
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // category
            $this->category->setupEditAttributes();
            $curVal = trim(strval($this->category->CurrentValue));
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->category->CurrentValue, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // reports_to
            $this->reports_to->setupEditAttributes();
            $curVal = trim(strval($this->reports_to->CurrentValue));
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            } else {
                $this->reports_to->ViewValue = $this->reports_to->Lookup !== null && is_array($this->reports_to->lookupOptions()) && count($this->reports_to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->reports_to->ViewValue !== null) { // Load from cache
                $this->reports_to->EditValue = array_values($this->reports_to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->reports_to->CurrentValue, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->reports_to->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->reports_to->EditValue = $arwrk;
            }
            $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator

            // datetime

            // type
            $this->type->setupEditAttributes();
            $this->type->EditValue = $this->type->options(true);
            $this->type->PlaceHolder = RemoveHtml($this->type->caption());

            // tax_registration
            $this->tax_registration->setupEditAttributes();
            if (!$this->tax_registration->Raw) {
                $this->tax_registration->CurrentValue = HtmlDecode($this->tax_registration->CurrentValue);
            }
            $this->tax_registration->EditValue = HtmlEncode($this->tax_registration->CurrentValue);
            $this->tax_registration->PlaceHolder = RemoveHtml($this->tax_registration->caption());

            // cin
            $this->cin->setupEditAttributes();
            if (!$this->cin->Raw) {
                $this->cin->CurrentValue = HtmlDecode($this->cin->CurrentValue);
            }
            $this->cin->EditValue = HtmlEncode($this->cin->CurrentValue);
            $this->cin->PlaceHolder = RemoveHtml($this->cin->caption());

            // pan
            $this->pan->setupEditAttributes();
            if (!$this->pan->Raw) {
                $this->pan->CurrentValue = HtmlDecode($this->pan->CurrentValue);
            }
            $this->pan->EditValue = HtmlEncode($this->pan->CurrentValue);
            $this->pan->PlaceHolder = RemoveHtml($this->pan->caption());

            // tan
            $this->tan->setupEditAttributes();
            if (!$this->tan->Raw) {
                $this->tan->CurrentValue = HtmlDecode($this->tan->CurrentValue);
            }
            $this->tan->EditValue = HtmlEncode($this->tan->CurrentValue);
            $this->tan->PlaceHolder = RemoveHtml($this->tan->caption());

            // msme
            $this->msme->setupEditAttributes();
            if (!$this->msme->Raw) {
                $this->msme->CurrentValue = HtmlDecode($this->msme->CurrentValue);
            }
            $this->msme->EditValue = HtmlEncode($this->msme->CurrentValue);
            $this->msme->PlaceHolder = RemoveHtml($this->msme->caption());

            // port_air
            $this->port_air->setupEditAttributes();
            $curVal = trim(strval($this->port_air->CurrentValue));
            if ($curVal != "") {
                $this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
            } else {
                $this->port_air->ViewValue = $this->port_air->Lookup !== null && is_array($this->port_air->lookupOptions()) && count($this->port_air->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->port_air->ViewValue !== null) { // Load from cache
                $this->port_air->EditValue = array_values($this->port_air->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->port_air->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->port_air->CurrentValue, $this->port_air->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->port_air->getSelectFilter($this); // PHP
                $sqlWrk = $this->port_air->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->port_air->EditValue = $arwrk;
            }
            $this->port_air->PlaceHolder = RemoveHtml($this->port_air->caption());

            // port_sea
            $this->port_sea->setupEditAttributes();
            $curVal = trim(strval($this->port_sea->CurrentValue));
            if ($curVal != "") {
                $this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
            } else {
                $this->port_sea->ViewValue = $this->port_sea->Lookup !== null && is_array($this->port_sea->lookupOptions()) && count($this->port_sea->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->port_sea->ViewValue !== null) { // Load from cache
                $this->port_sea->EditValue = array_values($this->port_sea->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->port_sea->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->port_sea->CurrentValue, $this->port_sea->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->port_sea->getSelectFilter($this); // PHP
                $sqlWrk = $this->port_sea->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->port_sea->EditValue = $arwrk;
            }
            $this->port_sea->PlaceHolder = RemoveHtml($this->port_sea->caption());

            // iec
            $this->iec->setupEditAttributes();
            if (!$this->iec->Raw) {
                $this->iec->CurrentValue = HtmlDecode($this->iec->CurrentValue);
            }
            $this->iec->EditValue = HtmlEncode($this->iec->CurrentValue);
            $this->iec->PlaceHolder = RemoveHtml($this->iec->caption());

            // rex
            $this->rex->setupEditAttributes();
            if (!$this->rex->Raw) {
                $this->rex->CurrentValue = HtmlDecode($this->rex->CurrentValue);
            }
            $this->rex->EditValue = HtmlEncode($this->rex->CurrentValue);
            $this->rex->PlaceHolder = RemoveHtml($this->rex->caption());

            // rcmc
            $this->rcmc->setupEditAttributes();
            if (!$this->rcmc->Raw) {
                $this->rcmc->CurrentValue = HtmlDecode($this->rcmc->CurrentValue);
            }
            $this->rcmc->EditValue = HtmlEncode($this->rcmc->CurrentValue);
            $this->rcmc->PlaceHolder = RemoveHtml($this->rcmc->caption());

            // delivery_terms
            $this->delivery_terms->setupEditAttributes();
            if (!$this->delivery_terms->Raw) {
                $this->delivery_terms->CurrentValue = HtmlDecode($this->delivery_terms->CurrentValue);
            }
            $this->delivery_terms->EditValue = HtmlEncode($this->delivery_terms->CurrentValue);
            $this->delivery_terms->PlaceHolder = RemoveHtml($this->delivery_terms->caption());

            // shipping_terms
            $this->shipping_terms->setupEditAttributes();
            if (!$this->shipping_terms->Raw) {
                $this->shipping_terms->CurrentValue = HtmlDecode($this->shipping_terms->CurrentValue);
            }
            $this->shipping_terms->EditValue = HtmlEncode($this->shipping_terms->CurrentValue);
            $this->shipping_terms->PlaceHolder = RemoveHtml($this->shipping_terms->caption());

            // payment_terms
            $this->payment_terms->setupEditAttributes();
            if (!$this->payment_terms->Raw) {
                $this->payment_terms->CurrentValue = HtmlDecode($this->payment_terms->CurrentValue);
            }
            $this->payment_terms->EditValue = HtmlEncode($this->payment_terms->CurrentValue);
            $this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

            // export_type
            $this->export_type->setupEditAttributes();
            if (!$this->export_type->Raw) {
                $this->export_type->CurrentValue = HtmlDecode($this->export_type->CurrentValue);
            }
            $this->export_type->EditValue = HtmlEncode($this->export_type->CurrentValue);
            $this->export_type->PlaceHolder = RemoveHtml($this->export_type->caption());

            // lead_time_ss
            $this->lead_time_ss->setupEditAttributes();
            if (!$this->lead_time_ss->Raw) {
                $this->lead_time_ss->CurrentValue = HtmlDecode($this->lead_time_ss->CurrentValue);
            }
            $this->lead_time_ss->EditValue = HtmlEncode($this->lead_time_ss->CurrentValue);
            $this->lead_time_ss->PlaceHolder = RemoveHtml($this->lead_time_ss->caption());

            // lead_time_cs
            $this->lead_time_cs->setupEditAttributes();
            if (!$this->lead_time_cs->Raw) {
                $this->lead_time_cs->CurrentValue = HtmlDecode($this->lead_time_cs->CurrentValue);
            }
            $this->lead_time_cs->EditValue = HtmlEncode($this->lead_time_cs->CurrentValue);
            $this->lead_time_cs->PlaceHolder = RemoveHtml($this->lead_time_cs->caption());

            // cha
            $this->cha->setupEditAttributes();
            $this->cha->EditValue = HtmlEncode($this->cha->CurrentValue);
            $this->cha->PlaceHolder = RemoveHtml($this->cha->caption());

            // cha_email
            $this->cha_email->setupEditAttributes();
            $this->cha_email->EditValue = HtmlEncode($this->cha_email->CurrentValue);
            $this->cha_email->PlaceHolder = RemoveHtml($this->cha_email->caption());

            // cha_phone
            $this->cha_phone->setupEditAttributes();
            $this->cha_phone->EditValue = HtmlEncode($this->cha_phone->CurrentValue);
            $this->cha_phone->PlaceHolder = RemoveHtml($this->cha_phone->caption());

            // forwarder
            $this->forwarder->setupEditAttributes();
            $this->forwarder->EditValue = HtmlEncode($this->forwarder->CurrentValue);
            $this->forwarder->PlaceHolder = RemoveHtml($this->forwarder->caption());

            // forwarder_email
            $this->forwarder_email->setupEditAttributes();
            $this->forwarder_email->EditValue = HtmlEncode($this->forwarder_email->CurrentValue);
            $this->forwarder_email->PlaceHolder = RemoveHtml($this->forwarder_email->caption());

            // forwarder_phone
            $this->forwarder_phone->setupEditAttributes();
            $this->forwarder_phone->EditValue = HtmlEncode($this->forwarder_phone->CurrentValue);
            $this->forwarder_phone->PlaceHolder = RemoveHtml($this->forwarder_phone->caption());

            // merchant
            $this->merchant->setupEditAttributes();
            $this->merchant->EditValue = HtmlEncode($this->merchant->CurrentValue);
            $this->merchant->PlaceHolder = RemoveHtml($this->merchant->caption());

            // merchant_email
            $this->merchant_email->setupEditAttributes();
            $this->merchant_email->EditValue = HtmlEncode($this->merchant_email->CurrentValue);
            $this->merchant_email->PlaceHolder = RemoveHtml($this->merchant_email->caption());

            // merchant_phone
            $this->merchant_phone->setupEditAttributes();
            $this->merchant_phone->EditValue = HtmlEncode($this->merchant_phone->CurrentValue);
            $this->merchant_phone->PlaceHolder = RemoveHtml($this->merchant_phone->caption());

            // shipping_incharge
            $this->shipping_incharge->setupEditAttributes();
            $this->shipping_incharge->EditValue = HtmlEncode($this->shipping_incharge->CurrentValue);
            $this->shipping_incharge->PlaceHolder = RemoveHtml($this->shipping_incharge->caption());

            // shipping_email
            $this->shipping_email->setupEditAttributes();
            $this->shipping_email->EditValue = HtmlEncode($this->shipping_email->CurrentValue);
            $this->shipping_email->PlaceHolder = RemoveHtml($this->shipping_email->caption());

            // shipping_phone
            $this->shipping_phone->setupEditAttributes();
            $this->shipping_phone->EditValue = HtmlEncode($this->shipping_phone->CurrentValue);
            $this->shipping_phone->PlaceHolder = RemoveHtml($this->shipping_phone->caption());

            // account_incharge
            $this->account_incharge->setupEditAttributes();
            $this->account_incharge->EditValue = HtmlEncode($this->account_incharge->CurrentValue);
            $this->account_incharge->PlaceHolder = RemoveHtml($this->account_incharge->caption());

            // accounts_email
            $this->accounts_email->setupEditAttributes();
            $this->accounts_email->EditValue = HtmlEncode($this->accounts_email->CurrentValue);
            $this->accounts_email->PlaceHolder = RemoveHtml($this->accounts_email->caption());

            // accounts_phone
            $this->accounts_phone->setupEditAttributes();
            $this->accounts_phone->EditValue = HtmlEncode($this->accounts_phone->CurrentValue);
            $this->accounts_phone->PlaceHolder = RemoveHtml($this->accounts_phone->caption());

            // warehouse_incharge
            $this->warehouse_incharge->setupEditAttributes();
            $this->warehouse_incharge->EditValue = HtmlEncode($this->warehouse_incharge->CurrentValue);
            $this->warehouse_incharge->PlaceHolder = RemoveHtml($this->warehouse_incharge->caption());

            // warehouse_email
            $this->warehouse_email->setupEditAttributes();
            $this->warehouse_email->EditValue = HtmlEncode($this->warehouse_email->CurrentValue);
            $this->warehouse_email->PlaceHolder = RemoveHtml($this->warehouse_email->caption());

            // warehouse_phone
            $this->warehouse_phone->setupEditAttributes();
            $this->warehouse_phone->EditValue = HtmlEncode($this->warehouse_phone->CurrentValue);
            $this->warehouse_phone->PlaceHolder = RemoveHtml($this->warehouse_phone->caption());

            // production_incharge
            $this->production_incharge->setupEditAttributes();
            $this->production_incharge->EditValue = HtmlEncode($this->production_incharge->CurrentValue);
            $this->production_incharge->PlaceHolder = RemoveHtml($this->production_incharge->caption());

            // production_email
            $this->production_email->setupEditAttributes();
            $this->production_email->EditValue = HtmlEncode($this->production_email->CurrentValue);
            $this->production_email->PlaceHolder = RemoveHtml($this->production_email->caption());

            // production_phone
            $this->production_phone->setupEditAttributes();
            $this->production_phone->EditValue = HtmlEncode($this->production_phone->CurrentValue);
            $this->production_phone->PlaceHolder = RemoveHtml($this->production_phone->caption());

            // qc_incharge
            $this->qc_incharge->setupEditAttributes();
            $this->qc_incharge->EditValue = HtmlEncode($this->qc_incharge->CurrentValue);
            $this->qc_incharge->PlaceHolder = RemoveHtml($this->qc_incharge->caption());

            // qc_email
            $this->qc_email->setupEditAttributes();
            $this->qc_email->EditValue = HtmlEncode($this->qc_email->CurrentValue);
            $this->qc_email->PlaceHolder = RemoveHtml($this->qc_email->caption());

            // qc_phone
            $this->qc_phone->setupEditAttributes();
            $this->qc_phone->EditValue = HtmlEncode($this->qc_phone->CurrentValue);
            $this->qc_phone->PlaceHolder = RemoveHtml($this->qc_phone->caption());

            // Add refer script

            // name
            $this->name->HrefValue = "";

            // code
            $this->code->HrefValue = "";

            // country
            $this->country->HrefValue = "";

            // region
            $this->region->HrefValue = "";

            // city
            $this->city->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // url
            $this->url->HrefValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";

            // bank_account_no
            $this->bank_account_no->HrefValue = "";

            // bank_code
            $this->bank_code->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // type
            $this->type->HrefValue = "";

            // tax_registration
            $this->tax_registration->HrefValue = "";

            // cin
            $this->cin->HrefValue = "";

            // pan
            $this->pan->HrefValue = "";

            // tan
            $this->tan->HrefValue = "";

            // msme
            $this->msme->HrefValue = "";

            // port_air
            $this->port_air->HrefValue = "";

            // port_sea
            $this->port_sea->HrefValue = "";

            // iec
            $this->iec->HrefValue = "";

            // rex
            $this->rex->HrefValue = "";

            // rcmc
            $this->rcmc->HrefValue = "";

            // delivery_terms
            $this->delivery_terms->HrefValue = "";

            // shipping_terms
            $this->shipping_terms->HrefValue = "";

            // payment_terms
            $this->payment_terms->HrefValue = "";

            // export_type
            $this->export_type->HrefValue = "";

            // lead_time_ss
            $this->lead_time_ss->HrefValue = "";

            // lead_time_cs
            $this->lead_time_cs->HrefValue = "";

            // cha
            $this->cha->HrefValue = "";

            // cha_email
            $this->cha_email->HrefValue = "";

            // cha_phone
            $this->cha_phone->HrefValue = "";

            // forwarder
            $this->forwarder->HrefValue = "";

            // forwarder_email
            $this->forwarder_email->HrefValue = "";

            // forwarder_phone
            $this->forwarder_phone->HrefValue = "";

            // merchant
            $this->merchant->HrefValue = "";

            // merchant_email
            $this->merchant_email->HrefValue = "";

            // merchant_phone
            $this->merchant_phone->HrefValue = "";

            // shipping_incharge
            $this->shipping_incharge->HrefValue = "";

            // shipping_email
            $this->shipping_email->HrefValue = "";

            // shipping_phone
            $this->shipping_phone->HrefValue = "";

            // account_incharge
            $this->account_incharge->HrefValue = "";

            // accounts_email
            $this->accounts_email->HrefValue = "";

            // accounts_phone
            $this->accounts_phone->HrefValue = "";

            // warehouse_incharge
            $this->warehouse_incharge->HrefValue = "";

            // warehouse_email
            $this->warehouse_email->HrefValue = "";

            // warehouse_phone
            $this->warehouse_phone->HrefValue = "";

            // production_incharge
            $this->production_incharge->HrefValue = "";

            // production_email
            $this->production_email->HrefValue = "";

            // production_phone
            $this->production_phone->HrefValue = "";

            // qc_incharge
            $this->qc_incharge->HrefValue = "";

            // qc_email
            $this->qc_email->HrefValue = "";

            // qc_phone
            $this->qc_phone->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Render add option
    public function renderAddOpt($row)
    {
        global $Security, $Language, $CurrentLanguage;

        // Set up CurrentValue
        $this->name->CurrentValue = $row["name"] ?? null;
        $this->code->CurrentValue = $row["code"] ?? null;
        $this->country->CurrentValue = $row["country"] ?? null;
        $this->region->CurrentValue = $row["region"] ?? null;
        $this->city->CurrentValue = $row["city"] ?? null;
        $this->address->CurrentValue = $row["address"] ?? null;
        $this->mobile->CurrentValue = $row["mobile"] ?? null;
        $this->_email->CurrentValue = $row["email"] ?? null;
        $this->url->CurrentValue = $row["url"] ?? null;
        $this->bank_name->CurrentValue = $row["bank_name"] ?? null;
        $this->bank_account_no->CurrentValue = $row["bank_account_no"] ?? null;
        $this->bank_code->CurrentValue = $row["bank_code"] ?? null;
        $this->grp->CurrentValue = $row["grp"] ?? null;
        $this->category->CurrentValue = $row["category"] ?? null;
        $this->reports_to->CurrentValue = $row["reports_to"] ?? null;
        $this->status->CurrentValue = $row["status"] ?? null;
        $this->operator->CurrentValue = $row["operator"] ?? null;
        $this->datetime->CurrentValue = $row["datetime"] ?? null;
        $this->type->CurrentValue = $row["type"] ?? null;
        $this->tax_registration->CurrentValue = $row["tax_registration"] ?? null;
        $this->cin->CurrentValue = $row["cin"] ?? null;
        $this->pan->CurrentValue = $row["pan"] ?? null;
        $this->tan->CurrentValue = $row["tan"] ?? null;
        $this->msme->CurrentValue = $row["msme"] ?? null;
        $this->port_air->CurrentValue = $row["port_air"] ?? null;
        $this->port_sea->CurrentValue = $row["port_sea"] ?? null;
        $this->iec->CurrentValue = $row["iec"] ?? null;
        $this->rex->CurrentValue = $row["rex"] ?? null;
        $this->rcmc->CurrentValue = $row["rcmc"] ?? null;
        $this->delivery_terms->CurrentValue = $row["delivery_terms"] ?? null;
        $this->shipping_terms->CurrentValue = $row["shipping_terms"] ?? null;
        $this->payment_terms->CurrentValue = $row["payment_terms"] ?? null;
        $this->export_type->CurrentValue = $row["export_type"] ?? null;
        $this->lead_time_ss->CurrentValue = $row["lead_time_ss"] ?? null;
        $this->lead_time_cs->CurrentValue = $row["lead_time_cs"] ?? null;
        $this->cha->CurrentValue = $row["cha"] ?? null;
        $this->cha_email->CurrentValue = $row["cha_email"] ?? null;
        $this->cha_phone->CurrentValue = $row["cha_phone"] ?? null;
        $this->forwarder->CurrentValue = $row["forwarder"] ?? null;
        $this->forwarder_email->CurrentValue = $row["forwarder_email"] ?? null;
        $this->forwarder_phone->CurrentValue = $row["forwarder_phone"] ?? null;
        $this->merchant->CurrentValue = $row["merchant"] ?? null;
        $this->merchant_email->CurrentValue = $row["merchant_email"] ?? null;
        $this->merchant_phone->CurrentValue = $row["merchant_phone"] ?? null;
        $this->shipping_incharge->CurrentValue = $row["shipping_incharge"] ?? null;
        $this->shipping_email->CurrentValue = $row["shipping_email"] ?? null;
        $this->shipping_phone->CurrentValue = $row["shipping_phone"] ?? null;
        $this->account_incharge->CurrentValue = $row["account_incharge"] ?? null;
        $this->accounts_email->CurrentValue = $row["accounts_email"] ?? null;
        $this->accounts_phone->CurrentValue = $row["accounts_phone"] ?? null;
        $this->warehouse_incharge->CurrentValue = $row["warehouse_incharge"] ?? null;
        $this->warehouse_email->CurrentValue = $row["warehouse_email"] ?? null;
        $this->warehouse_phone->CurrentValue = $row["warehouse_phone"] ?? null;
        $this->production_incharge->CurrentValue = $row["production_incharge"] ?? null;
        $this->production_email->CurrentValue = $row["production_email"] ?? null;
        $this->production_phone->CurrentValue = $row["production_phone"] ?? null;
        $this->qc_incharge->CurrentValue = $row["qc_incharge"] ?? null;
        $this->qc_email->CurrentValue = $row["qc_email"] ?? null;
        $this->qc_phone->CurrentValue = $row["qc_phone"] ?? null;

        // name
        $this->name->ViewValue = $this->name->CurrentValue;

        // code
        $this->code->ViewValue = $this->code->CurrentValue;

        // country
        $curVal = strval($this->country->CurrentValue);
        if ($curVal != "") {
            $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
            if ($this->country->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->country->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->country->Lookup->renderViewRow($rswrk[0]);
                    $this->country->ViewValue = $this->country->displayValue($arwrk);
                } else {
                    $this->country->ViewValue = FormatNumber($this->country->CurrentValue, $this->country->formatPattern());
                }
            }
        } else {
            $this->country->ViewValue = null;
        }

        // region
        $curVal = strval($this->region->CurrentValue);
        if ($curVal != "") {
            $this->region->ViewValue = $this->region->lookupCacheOption($curVal);
            if ($this->region->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->region->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->region->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->region->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->region->Lookup->renderViewRow($rswrk[0]);
                    $this->region->ViewValue = $this->region->displayValue($arwrk);
                } else {
                    $this->region->ViewValue = FormatNumber($this->region->CurrentValue, $this->region->formatPattern());
                }
            }
        } else {
            $this->region->ViewValue = null;
        }

        // city
        if ($this->city->VirtualValue != "") {
            $this->city->ViewValue = $this->city->VirtualValue;
        } else {
            $this->city->ViewValue = $this->city->CurrentValue;
            $curVal = strval($this->city->CurrentValue);
            if ($curVal != "") {
                $this->city->ViewValue = $this->city->lookupCacheOption($curVal);
                if ($this->city->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->city->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->city->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->city->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->city->Lookup->renderViewRow($rswrk[0]);
                        $this->city->ViewValue = $this->city->displayValue($arwrk);
                    } else {
                        $this->city->ViewValue = FormatNumber($this->city->CurrentValue, $this->city->formatPattern());
                    }
                }
            } else {
                $this->city->ViewValue = null;
            }
        }

        // address
        $this->address->ViewValue = $this->address->CurrentValue;

        // mobile
        $this->mobile->ViewValue = $this->mobile->CurrentValue;

        // email
        $this->_email->ViewValue = $this->_email->CurrentValue;

        // url
        $this->url->ViewValue = $this->url->CurrentValue;

        // bank_name
        $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

        // bank_account_no
        $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

        // bank_code
        $this->bank_code->ViewValue = $this->bank_code->CurrentValue;

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->grp->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->grp->Lookup->renderViewRow($row);
                        $this->grp->ViewValue->add($this->grp->displayValue($arwrk));
                    }
                } else {
                    $this->grp->ViewValue = $this->grp->CurrentValue;
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // category
        $curVal = strval($this->category->CurrentValue);
        if ($curVal != "") {
            $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            if ($this->category->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                    $this->category->ViewValue = $this->category->displayValue($arwrk);
                } else {
                    $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                }
            }
        } else {
            $this->category->ViewValue = null;
        }

        // reports_to
        $curVal = strval($this->reports_to->CurrentValue);
        if ($curVal != "") {
            $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            if ($this->reports_to->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                    $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                } else {
                    $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                }
            }
        } else {
            $this->reports_to->ViewValue = null;
        }

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = $this->operator->CurrentValue;
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // type
        if (strval($this->type->CurrentValue) != "") {
            $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
        } else {
            $this->type->ViewValue = null;
        }

        // tax_registration
        $this->tax_registration->ViewValue = $this->tax_registration->CurrentValue;

        // cin
        $this->cin->ViewValue = $this->cin->CurrentValue;

        // pan
        $this->pan->ViewValue = $this->pan->CurrentValue;

        // tan
        $this->tan->ViewValue = $this->tan->CurrentValue;

        // msme
        $this->msme->ViewValue = $this->msme->CurrentValue;

        // port_air
        $curVal = strval($this->port_air->CurrentValue);
        if ($curVal != "") {
            $this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
            if ($this->port_air->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->port_air->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->port_air->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->port_air->getSelectFilter($this); // PHP
                $sqlWrk = $this->port_air->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->port_air->Lookup->renderViewRow($rswrk[0]);
                    $this->port_air->ViewValue = $this->port_air->displayValue($arwrk);
                } else {
                    $this->port_air->ViewValue = $this->port_air->CurrentValue;
                }
            }
        } else {
            $this->port_air->ViewValue = null;
        }

        // port_sea
        $curVal = strval($this->port_sea->CurrentValue);
        if ($curVal != "") {
            $this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
            if ($this->port_sea->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->port_sea->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->port_sea->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->port_sea->getSelectFilter($this); // PHP
                $sqlWrk = $this->port_sea->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->port_sea->Lookup->renderViewRow($rswrk[0]);
                    $this->port_sea->ViewValue = $this->port_sea->displayValue($arwrk);
                } else {
                    $this->port_sea->ViewValue = $this->port_sea->CurrentValue;
                }
            }
        } else {
            $this->port_sea->ViewValue = null;
        }

        // iec
        $this->iec->ViewValue = $this->iec->CurrentValue;

        // rex
        $this->rex->ViewValue = $this->rex->CurrentValue;

        // rcmc
        $this->rcmc->ViewValue = $this->rcmc->CurrentValue;

        // delivery_terms
        $this->delivery_terms->ViewValue = $this->delivery_terms->CurrentValue;

        // shipping_terms
        $this->shipping_terms->ViewValue = $this->shipping_terms->CurrentValue;

        // payment_terms
        $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;

        // export_type
        $this->export_type->ViewValue = $this->export_type->CurrentValue;

        // lead_time_ss
        $this->lead_time_ss->ViewValue = $this->lead_time_ss->CurrentValue;

        // lead_time_cs
        $this->lead_time_cs->ViewValue = $this->lead_time_cs->CurrentValue;

        // cha
        $this->cha->ViewValue = $this->cha->CurrentValue;

        // cha_email
        $this->cha_email->ViewValue = $this->cha_email->CurrentValue;

        // cha_phone
        $this->cha_phone->ViewValue = $this->cha_phone->CurrentValue;

        // forwarder
        $this->forwarder->ViewValue = $this->forwarder->CurrentValue;

        // forwarder_email
        $this->forwarder_email->ViewValue = $this->forwarder_email->CurrentValue;

        // forwarder_phone
        $this->forwarder_phone->ViewValue = $this->forwarder_phone->CurrentValue;

        // merchant
        $this->merchant->ViewValue = $this->merchant->CurrentValue;

        // merchant_email
        $this->merchant_email->ViewValue = $this->merchant_email->CurrentValue;

        // merchant_phone
        $this->merchant_phone->ViewValue = $this->merchant_phone->CurrentValue;

        // shipping_incharge
        $this->shipping_incharge->ViewValue = $this->shipping_incharge->CurrentValue;

        // shipping_email
        $this->shipping_email->ViewValue = $this->shipping_email->CurrentValue;

        // shipping_phone
        $this->shipping_phone->ViewValue = $this->shipping_phone->CurrentValue;

        // account_incharge
        $this->account_incharge->ViewValue = $this->account_incharge->CurrentValue;

        // accounts_email
        $this->accounts_email->ViewValue = $this->accounts_email->CurrentValue;

        // accounts_phone
        $this->accounts_phone->ViewValue = $this->accounts_phone->CurrentValue;

        // warehouse_incharge
        $this->warehouse_incharge->ViewValue = $this->warehouse_incharge->CurrentValue;

        // warehouse_email
        $this->warehouse_email->ViewValue = $this->warehouse_email->CurrentValue;

        // warehouse_phone
        $this->warehouse_phone->ViewValue = $this->warehouse_phone->CurrentValue;

        // production_incharge
        $this->production_incharge->ViewValue = $this->production_incharge->CurrentValue;

        // production_email
        $this->production_email->ViewValue = $this->production_email->CurrentValue;

        // production_phone
        $this->production_phone->ViewValue = $this->production_phone->CurrentValue;

        // qc_incharge
        $this->qc_incharge->ViewValue = $this->qc_incharge->CurrentValue;

        // qc_email
        $this->qc_email->ViewValue = $this->qc_email->CurrentValue;

        // qc_phone
        $this->qc_phone->ViewValue = $this->qc_phone->CurrentValue;

        // Set up $row
        $row["name"] = $this->name->ViewValue;
        $row["code"] = $this->code->ViewValue;
        $row["country"] = $this->country->ViewValue;
        $row["region"] = $this->region->ViewValue;
        $row["city"] = $this->city->ViewValue;
        $row["address"] = $this->address->ViewValue;
        $row["mobile"] = $this->mobile->ViewValue;
        $row["email"] = $this->_email->ViewValue;
        $row["url"] = $this->url->ViewValue;
        $row["bank_name"] = $this->bank_name->ViewValue;
        $row["bank_account_no"] = $this->bank_account_no->ViewValue;
        $row["bank_code"] = $this->bank_code->ViewValue;
        $row["grp"] = $this->grp->ViewValue;
        $row["category"] = $this->category->ViewValue;
        $row["reports_to"] = $this->reports_to->ViewValue;
        $row["status"] = $this->status->ViewValue;
        $row["operator"] = $this->operator->ViewValue;
        $row["datetime"] = $this->datetime->ViewValue;
        $row["type"] = $this->type->ViewValue;
        $row["tax_registration"] = $this->tax_registration->ViewValue;
        $row["cin"] = $this->cin->ViewValue;
        $row["pan"] = $this->pan->ViewValue;
        $row["tan"] = $this->tan->ViewValue;
        $row["msme"] = $this->msme->ViewValue;
        $row["port_air"] = $this->port_air->ViewValue;
        $row["port_sea"] = $this->port_sea->ViewValue;
        $row["iec"] = $this->iec->ViewValue;
        $row["rex"] = $this->rex->ViewValue;
        $row["rcmc"] = $this->rcmc->ViewValue;
        $row["delivery_terms"] = $this->delivery_terms->ViewValue;
        $row["shipping_terms"] = $this->shipping_terms->ViewValue;
        $row["payment_terms"] = $this->payment_terms->ViewValue;
        $row["export_type"] = $this->export_type->ViewValue;
        $row["lead_time_ss"] = $this->lead_time_ss->ViewValue;
        $row["lead_time_cs"] = $this->lead_time_cs->ViewValue;
        $row["cha"] = $this->cha->ViewValue;
        $row["cha_email"] = $this->cha_email->ViewValue;
        $row["cha_phone"] = $this->cha_phone->ViewValue;
        $row["forwarder"] = $this->forwarder->ViewValue;
        $row["forwarder_email"] = $this->forwarder_email->ViewValue;
        $row["forwarder_phone"] = $this->forwarder_phone->ViewValue;
        $row["merchant"] = $this->merchant->ViewValue;
        $row["merchant_email"] = $this->merchant_email->ViewValue;
        $row["merchant_phone"] = $this->merchant_phone->ViewValue;
        $row["shipping_incharge"] = $this->shipping_incharge->ViewValue;
        $row["shipping_email"] = $this->shipping_email->ViewValue;
        $row["shipping_phone"] = $this->shipping_phone->ViewValue;
        $row["account_incharge"] = $this->account_incharge->ViewValue;
        $row["accounts_email"] = $this->accounts_email->ViewValue;
        $row["accounts_phone"] = $this->accounts_phone->ViewValue;
        $row["warehouse_incharge"] = $this->warehouse_incharge->ViewValue;
        $row["warehouse_email"] = $this->warehouse_email->ViewValue;
        $row["warehouse_phone"] = $this->warehouse_phone->ViewValue;
        $row["production_incharge"] = $this->production_incharge->ViewValue;
        $row["production_email"] = $this->production_email->ViewValue;
        $row["production_phone"] = $this->production_phone->ViewValue;
        $row["qc_incharge"] = $this->qc_incharge->ViewValue;
        $row["qc_email"] = $this->qc_email->ViewValue;
        $row["qc_phone"] = $this->qc_phone->ViewValue;
        return $row;
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->name->Visible && $this->name->Required) {
                if (!$this->name->IsDetailKey && EmptyValue($this->name->FormValue)) {
                    $this->name->addErrorMessage(str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
                }
            }
            if ($this->code->Visible && $this->code->Required) {
                if (!$this->code->IsDetailKey && EmptyValue($this->code->FormValue)) {
                    $this->code->addErrorMessage(str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
                }
            }
            if ($this->country->Visible && $this->country->Required) {
                if (!$this->country->IsDetailKey && EmptyValue($this->country->FormValue)) {
                    $this->country->addErrorMessage(str_replace("%s", $this->country->caption(), $this->country->RequiredErrorMessage));
                }
            }
            if ($this->region->Visible && $this->region->Required) {
                if (!$this->region->IsDetailKey && EmptyValue($this->region->FormValue)) {
                    $this->region->addErrorMessage(str_replace("%s", $this->region->caption(), $this->region->RequiredErrorMessage));
                }
            }
            if ($this->city->Visible && $this->city->Required) {
                if (!$this->city->IsDetailKey && EmptyValue($this->city->FormValue)) {
                    $this->city->addErrorMessage(str_replace("%s", $this->city->caption(), $this->city->RequiredErrorMessage));
                }
            }
            if ($this->address->Visible && $this->address->Required) {
                if (!$this->address->IsDetailKey && EmptyValue($this->address->FormValue)) {
                    $this->address->addErrorMessage(str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
                }
            }
            if ($this->mobile->Visible && $this->mobile->Required) {
                if (!$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if ($this->_email->Visible && $this->_email->Required) {
                if (!$this->_email->IsDetailKey && EmptyValue($this->_email->FormValue)) {
                    $this->_email->addErrorMessage(str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
                }
            }
            if ($this->url->Visible && $this->url->Required) {
                if (!$this->url->IsDetailKey && EmptyValue($this->url->FormValue)) {
                    $this->url->addErrorMessage(str_replace("%s", $this->url->caption(), $this->url->RequiredErrorMessage));
                }
            }
            if ($this->bank_name->Visible && $this->bank_name->Required) {
                if (!$this->bank_name->IsDetailKey && EmptyValue($this->bank_name->FormValue)) {
                    $this->bank_name->addErrorMessage(str_replace("%s", $this->bank_name->caption(), $this->bank_name->RequiredErrorMessage));
                }
            }
            if ($this->bank_account_no->Visible && $this->bank_account_no->Required) {
                if (!$this->bank_account_no->IsDetailKey && EmptyValue($this->bank_account_no->FormValue)) {
                    $this->bank_account_no->addErrorMessage(str_replace("%s", $this->bank_account_no->caption(), $this->bank_account_no->RequiredErrorMessage));
                }
            }
            if ($this->bank_code->Visible && $this->bank_code->Required) {
                if (!$this->bank_code->IsDetailKey && EmptyValue($this->bank_code->FormValue)) {
                    $this->bank_code->addErrorMessage(str_replace("%s", $this->bank_code->caption(), $this->bank_code->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if ($this->grp->FormValue == "") {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->category->Visible && $this->category->Required) {
                if (!$this->category->IsDetailKey && EmptyValue($this->category->FormValue)) {
                    $this->category->addErrorMessage(str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
                }
            }
            if ($this->reports_to->Visible && $this->reports_to->Required) {
                if (!$this->reports_to->IsDetailKey && EmptyValue($this->reports_to->FormValue)) {
                    $this->reports_to->addErrorMessage(str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->type->Visible && $this->type->Required) {
                if (!$this->type->IsDetailKey && EmptyValue($this->type->FormValue)) {
                    $this->type->addErrorMessage(str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
                }
            }
            if ($this->tax_registration->Visible && $this->tax_registration->Required) {
                if (!$this->tax_registration->IsDetailKey && EmptyValue($this->tax_registration->FormValue)) {
                    $this->tax_registration->addErrorMessage(str_replace("%s", $this->tax_registration->caption(), $this->tax_registration->RequiredErrorMessage));
                }
            }
            if ($this->cin->Visible && $this->cin->Required) {
                if (!$this->cin->IsDetailKey && EmptyValue($this->cin->FormValue)) {
                    $this->cin->addErrorMessage(str_replace("%s", $this->cin->caption(), $this->cin->RequiredErrorMessage));
                }
            }
            if ($this->pan->Visible && $this->pan->Required) {
                if (!$this->pan->IsDetailKey && EmptyValue($this->pan->FormValue)) {
                    $this->pan->addErrorMessage(str_replace("%s", $this->pan->caption(), $this->pan->RequiredErrorMessage));
                }
            }
            if ($this->tan->Visible && $this->tan->Required) {
                if (!$this->tan->IsDetailKey && EmptyValue($this->tan->FormValue)) {
                    $this->tan->addErrorMessage(str_replace("%s", $this->tan->caption(), $this->tan->RequiredErrorMessage));
                }
            }
            if ($this->msme->Visible && $this->msme->Required) {
                if (!$this->msme->IsDetailKey && EmptyValue($this->msme->FormValue)) {
                    $this->msme->addErrorMessage(str_replace("%s", $this->msme->caption(), $this->msme->RequiredErrorMessage));
                }
            }
            if ($this->port_air->Visible && $this->port_air->Required) {
                if (!$this->port_air->IsDetailKey && EmptyValue($this->port_air->FormValue)) {
                    $this->port_air->addErrorMessage(str_replace("%s", $this->port_air->caption(), $this->port_air->RequiredErrorMessage));
                }
            }
            if ($this->port_sea->Visible && $this->port_sea->Required) {
                if (!$this->port_sea->IsDetailKey && EmptyValue($this->port_sea->FormValue)) {
                    $this->port_sea->addErrorMessage(str_replace("%s", $this->port_sea->caption(), $this->port_sea->RequiredErrorMessage));
                }
            }
            if ($this->iec->Visible && $this->iec->Required) {
                if (!$this->iec->IsDetailKey && EmptyValue($this->iec->FormValue)) {
                    $this->iec->addErrorMessage(str_replace("%s", $this->iec->caption(), $this->iec->RequiredErrorMessage));
                }
            }
            if ($this->rex->Visible && $this->rex->Required) {
                if (!$this->rex->IsDetailKey && EmptyValue($this->rex->FormValue)) {
                    $this->rex->addErrorMessage(str_replace("%s", $this->rex->caption(), $this->rex->RequiredErrorMessage));
                }
            }
            if ($this->rcmc->Visible && $this->rcmc->Required) {
                if (!$this->rcmc->IsDetailKey && EmptyValue($this->rcmc->FormValue)) {
                    $this->rcmc->addErrorMessage(str_replace("%s", $this->rcmc->caption(), $this->rcmc->RequiredErrorMessage));
                }
            }
            if ($this->delivery_terms->Visible && $this->delivery_terms->Required) {
                if (!$this->delivery_terms->IsDetailKey && EmptyValue($this->delivery_terms->FormValue)) {
                    $this->delivery_terms->addErrorMessage(str_replace("%s", $this->delivery_terms->caption(), $this->delivery_terms->RequiredErrorMessage));
                }
            }
            if ($this->shipping_terms->Visible && $this->shipping_terms->Required) {
                if (!$this->shipping_terms->IsDetailKey && EmptyValue($this->shipping_terms->FormValue)) {
                    $this->shipping_terms->addErrorMessage(str_replace("%s", $this->shipping_terms->caption(), $this->shipping_terms->RequiredErrorMessage));
                }
            }
            if ($this->payment_terms->Visible && $this->payment_terms->Required) {
                if (!$this->payment_terms->IsDetailKey && EmptyValue($this->payment_terms->FormValue)) {
                    $this->payment_terms->addErrorMessage(str_replace("%s", $this->payment_terms->caption(), $this->payment_terms->RequiredErrorMessage));
                }
            }
            if ($this->export_type->Visible && $this->export_type->Required) {
                if (!$this->export_type->IsDetailKey && EmptyValue($this->export_type->FormValue)) {
                    $this->export_type->addErrorMessage(str_replace("%s", $this->export_type->caption(), $this->export_type->RequiredErrorMessage));
                }
            }
            if ($this->lead_time_ss->Visible && $this->lead_time_ss->Required) {
                if (!$this->lead_time_ss->IsDetailKey && EmptyValue($this->lead_time_ss->FormValue)) {
                    $this->lead_time_ss->addErrorMessage(str_replace("%s", $this->lead_time_ss->caption(), $this->lead_time_ss->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->lead_time_ss->FormValue)) {
                $this->lead_time_ss->addErrorMessage($this->lead_time_ss->getErrorMessage(false));
            }
            if ($this->lead_time_cs->Visible && $this->lead_time_cs->Required) {
                if (!$this->lead_time_cs->IsDetailKey && EmptyValue($this->lead_time_cs->FormValue)) {
                    $this->lead_time_cs->addErrorMessage(str_replace("%s", $this->lead_time_cs->caption(), $this->lead_time_cs->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->lead_time_cs->FormValue)) {
                $this->lead_time_cs->addErrorMessage($this->lead_time_cs->getErrorMessage(false));
            }
            if ($this->cha->Visible && $this->cha->Required) {
                if (!$this->cha->IsDetailKey && EmptyValue($this->cha->FormValue)) {
                    $this->cha->addErrorMessage(str_replace("%s", $this->cha->caption(), $this->cha->RequiredErrorMessage));
                }
            }
            if ($this->cha_email->Visible && $this->cha_email->Required) {
                if (!$this->cha_email->IsDetailKey && EmptyValue($this->cha_email->FormValue)) {
                    $this->cha_email->addErrorMessage(str_replace("%s", $this->cha_email->caption(), $this->cha_email->RequiredErrorMessage));
                }
            }
            if ($this->cha_phone->Visible && $this->cha_phone->Required) {
                if (!$this->cha_phone->IsDetailKey && EmptyValue($this->cha_phone->FormValue)) {
                    $this->cha_phone->addErrorMessage(str_replace("%s", $this->cha_phone->caption(), $this->cha_phone->RequiredErrorMessage));
                }
            }
            if ($this->forwarder->Visible && $this->forwarder->Required) {
                if (!$this->forwarder->IsDetailKey && EmptyValue($this->forwarder->FormValue)) {
                    $this->forwarder->addErrorMessage(str_replace("%s", $this->forwarder->caption(), $this->forwarder->RequiredErrorMessage));
                }
            }
            if ($this->forwarder_email->Visible && $this->forwarder_email->Required) {
                if (!$this->forwarder_email->IsDetailKey && EmptyValue($this->forwarder_email->FormValue)) {
                    $this->forwarder_email->addErrorMessage(str_replace("%s", $this->forwarder_email->caption(), $this->forwarder_email->RequiredErrorMessage));
                }
            }
            if ($this->forwarder_phone->Visible && $this->forwarder_phone->Required) {
                if (!$this->forwarder_phone->IsDetailKey && EmptyValue($this->forwarder_phone->FormValue)) {
                    $this->forwarder_phone->addErrorMessage(str_replace("%s", $this->forwarder_phone->caption(), $this->forwarder_phone->RequiredErrorMessage));
                }
            }
            if ($this->merchant->Visible && $this->merchant->Required) {
                if (!$this->merchant->IsDetailKey && EmptyValue($this->merchant->FormValue)) {
                    $this->merchant->addErrorMessage(str_replace("%s", $this->merchant->caption(), $this->merchant->RequiredErrorMessage));
                }
            }
            if ($this->merchant_email->Visible && $this->merchant_email->Required) {
                if (!$this->merchant_email->IsDetailKey && EmptyValue($this->merchant_email->FormValue)) {
                    $this->merchant_email->addErrorMessage(str_replace("%s", $this->merchant_email->caption(), $this->merchant_email->RequiredErrorMessage));
                }
            }
            if ($this->merchant_phone->Visible && $this->merchant_phone->Required) {
                if (!$this->merchant_phone->IsDetailKey && EmptyValue($this->merchant_phone->FormValue)) {
                    $this->merchant_phone->addErrorMessage(str_replace("%s", $this->merchant_phone->caption(), $this->merchant_phone->RequiredErrorMessage));
                }
            }
            if ($this->shipping_incharge->Visible && $this->shipping_incharge->Required) {
                if (!$this->shipping_incharge->IsDetailKey && EmptyValue($this->shipping_incharge->FormValue)) {
                    $this->shipping_incharge->addErrorMessage(str_replace("%s", $this->shipping_incharge->caption(), $this->shipping_incharge->RequiredErrorMessage));
                }
            }
            if ($this->shipping_email->Visible && $this->shipping_email->Required) {
                if (!$this->shipping_email->IsDetailKey && EmptyValue($this->shipping_email->FormValue)) {
                    $this->shipping_email->addErrorMessage(str_replace("%s", $this->shipping_email->caption(), $this->shipping_email->RequiredErrorMessage));
                }
            }
            if ($this->shipping_phone->Visible && $this->shipping_phone->Required) {
                if (!$this->shipping_phone->IsDetailKey && EmptyValue($this->shipping_phone->FormValue)) {
                    $this->shipping_phone->addErrorMessage(str_replace("%s", $this->shipping_phone->caption(), $this->shipping_phone->RequiredErrorMessage));
                }
            }
            if ($this->account_incharge->Visible && $this->account_incharge->Required) {
                if (!$this->account_incharge->IsDetailKey && EmptyValue($this->account_incharge->FormValue)) {
                    $this->account_incharge->addErrorMessage(str_replace("%s", $this->account_incharge->caption(), $this->account_incharge->RequiredErrorMessage));
                }
            }
            if ($this->accounts_email->Visible && $this->accounts_email->Required) {
                if (!$this->accounts_email->IsDetailKey && EmptyValue($this->accounts_email->FormValue)) {
                    $this->accounts_email->addErrorMessage(str_replace("%s", $this->accounts_email->caption(), $this->accounts_email->RequiredErrorMessage));
                }
            }
            if ($this->accounts_phone->Visible && $this->accounts_phone->Required) {
                if (!$this->accounts_phone->IsDetailKey && EmptyValue($this->accounts_phone->FormValue)) {
                    $this->accounts_phone->addErrorMessage(str_replace("%s", $this->accounts_phone->caption(), $this->accounts_phone->RequiredErrorMessage));
                }
            }
            if ($this->warehouse_incharge->Visible && $this->warehouse_incharge->Required) {
                if (!$this->warehouse_incharge->IsDetailKey && EmptyValue($this->warehouse_incharge->FormValue)) {
                    $this->warehouse_incharge->addErrorMessage(str_replace("%s", $this->warehouse_incharge->caption(), $this->warehouse_incharge->RequiredErrorMessage));
                }
            }
            if ($this->warehouse_email->Visible && $this->warehouse_email->Required) {
                if (!$this->warehouse_email->IsDetailKey && EmptyValue($this->warehouse_email->FormValue)) {
                    $this->warehouse_email->addErrorMessage(str_replace("%s", $this->warehouse_email->caption(), $this->warehouse_email->RequiredErrorMessage));
                }
            }
            if ($this->warehouse_phone->Visible && $this->warehouse_phone->Required) {
                if (!$this->warehouse_phone->IsDetailKey && EmptyValue($this->warehouse_phone->FormValue)) {
                    $this->warehouse_phone->addErrorMessage(str_replace("%s", $this->warehouse_phone->caption(), $this->warehouse_phone->RequiredErrorMessage));
                }
            }
            if ($this->production_incharge->Visible && $this->production_incharge->Required) {
                if (!$this->production_incharge->IsDetailKey && EmptyValue($this->production_incharge->FormValue)) {
                    $this->production_incharge->addErrorMessage(str_replace("%s", $this->production_incharge->caption(), $this->production_incharge->RequiredErrorMessage));
                }
            }
            if ($this->production_email->Visible && $this->production_email->Required) {
                if (!$this->production_email->IsDetailKey && EmptyValue($this->production_email->FormValue)) {
                    $this->production_email->addErrorMessage(str_replace("%s", $this->production_email->caption(), $this->production_email->RequiredErrorMessage));
                }
            }
            if ($this->production_phone->Visible && $this->production_phone->Required) {
                if (!$this->production_phone->IsDetailKey && EmptyValue($this->production_phone->FormValue)) {
                    $this->production_phone->addErrorMessage(str_replace("%s", $this->production_phone->caption(), $this->production_phone->RequiredErrorMessage));
                }
            }
            if ($this->qc_incharge->Visible && $this->qc_incharge->Required) {
                if (!$this->qc_incharge->IsDetailKey && EmptyValue($this->qc_incharge->FormValue)) {
                    $this->qc_incharge->addErrorMessage(str_replace("%s", $this->qc_incharge->caption(), $this->qc_incharge->RequiredErrorMessage));
                }
            }
            if ($this->qc_email->Visible && $this->qc_email->Required) {
                if (!$this->qc_email->IsDetailKey && EmptyValue($this->qc_email->FormValue)) {
                    $this->qc_email->addErrorMessage(str_replace("%s", $this->qc_email->caption(), $this->qc_email->RequiredErrorMessage));
                }
            }
            if ($this->qc_phone->Visible && $this->qc_phone->Required) {
                if (!$this->qc_phone->IsDetailKey && EmptyValue($this->qc_phone->FormValue)) {
                    $this->qc_phone->addErrorMessage(str_replace("%s", $this->qc_phone->caption(), $this->qc_phone->RequiredErrorMessage));
                }
            }

        // Validate detail grid
        $detailTblVar = explode(",", $this->getCurrentDetailTable());
        $detailPage = Container("ShippingAddressGrid");
        if (in_array("shipping_address", $detailTblVar) && $detailPage->DetailAdd) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }
        $detailPage = Container("BankInfoGrid");
        if (in_array("bank_info", $detailTblVar) && $detailPage->DetailAdd) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }
        $detailPage = Container("CapacityPlanGrid");
        if (in_array("capacity_plan", $detailTblVar) && $detailPage->DetailAdd) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->code->CurrentValue != "") { // Check field with unique index
            $filter = "(`code` = '" . AdjustSql($this->code->CurrentValue, $this->Dbid) . "')";
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $idxErrMsg = str_replace("%f", $this->code->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->code->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Begin transaction
        if ($this->getCurrentDetailTable() != "" && $this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }

        // Add detail records
        if ($addRow) {
            $detailTblVar = explode(",", $this->getCurrentDetailTable());
            $detailPage = Container("ShippingAddressGrid");
            if (in_array("shipping_address", $detailTblVar) && $detailPage->DetailAdd && $addRow) {
                $detailPage->_userid->setSessionValue($this->id->CurrentValue); // Set master key
                $Security->loadCurrentUserLevel($this->ProjectID . "shipping_address"); // Load user level of detail table
                $addRow = $detailPage->gridInsert();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
                if (!$addRow) {
                $detailPage->_userid->setSessionValue(""); // Clear master key if insert failed
                }
            }
            $detailPage = Container("BankInfoGrid");
            if (in_array("bank_info", $detailTblVar) && $detailPage->DetailAdd && $addRow) {
                $detailPage->user_id->setSessionValue($this->id->CurrentValue); // Set master key
                $Security->loadCurrentUserLevel($this->ProjectID . "bank_info"); // Load user level of detail table
                $addRow = $detailPage->gridInsert();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
                if (!$addRow) {
                $detailPage->user_id->setSessionValue(""); // Clear master key if insert failed
                }
            }
            $detailPage = Container("CapacityPlanGrid");
            if (in_array("capacity_plan", $detailTblVar) && $detailPage->DetailAdd && $addRow) {
                $detailPage->user_id->setSessionValue($this->id->CurrentValue); // Set master key
                $Security->loadCurrentUserLevel($this->ProjectID . "capacity_plan"); // Load user level of detail table
                $addRow = $detailPage->gridInsert();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
                if (!$addRow) {
                $detailPage->user_id->setSessionValue(""); // Clear master key if insert failed
                }
            }
        }

        // Commit/Rollback transaction
        if ($this->getCurrentDetailTable() != "") {
            if ($addRow) {
                if ($this->UseTransaction) { // Commit transaction
                    if ($conn->isTransactionActive()) {
                        $conn->commit();
                    }
                }
            } else {
                if ($this->UseTransaction) { // Rollback transaction
                    if ($conn->isTransactionActive()) {
                        $conn->rollback();
                    }
                }
            }
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            if (Post("addopt") == "1") { // Render for add option response
                $row = $this->renderAddOpt($row);
            }
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // name
        $this->name->setDbValueDef($rsnew, $this->name->CurrentValue, false);

        // code
        $this->code->setDbValueDef($rsnew, $this->code->CurrentValue, false);

        // country
        $this->country->setDbValueDef($rsnew, $this->country->CurrentValue, false);

        // region
        $this->region->setDbValueDef($rsnew, $this->region->CurrentValue, false);

        // city
        $this->city->setDbValueDef($rsnew, $this->city->CurrentValue, false);

        // address
        $this->address->setDbValueDef($rsnew, $this->address->CurrentValue, false);

        // mobile
        $this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, false);

        // email
        $this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, false);

        // url
        $this->url->setDbValueDef($rsnew, $this->url->CurrentValue, false);

        // bank_name
        $this->bank_name->setDbValueDef($rsnew, $this->bank_name->CurrentValue, false);

        // bank_account_no
        $this->bank_account_no->setDbValueDef($rsnew, $this->bank_account_no->CurrentValue, false);

        // bank_code
        $this->bank_code->setDbValueDef($rsnew, $this->bank_code->CurrentValue, false);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // category
        $this->category->setDbValueDef($rsnew, $this->category->CurrentValue, false);

        // reports_to
        $this->reports_to->setDbValueDef($rsnew, $this->reports_to->CurrentValue, false);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // type
        $this->type->setDbValueDef($rsnew, $this->type->CurrentValue, false);

        // tax_registration
        $this->tax_registration->setDbValueDef($rsnew, $this->tax_registration->CurrentValue, false);

        // cin
        $this->cin->setDbValueDef($rsnew, $this->cin->CurrentValue, false);

        // pan
        $this->pan->setDbValueDef($rsnew, $this->pan->CurrentValue, false);

        // tan
        $this->tan->setDbValueDef($rsnew, $this->tan->CurrentValue, false);

        // msme
        $this->msme->setDbValueDef($rsnew, $this->msme->CurrentValue, false);

        // port_air
        $this->port_air->setDbValueDef($rsnew, $this->port_air->CurrentValue, false);

        // port_sea
        $this->port_sea->setDbValueDef($rsnew, $this->port_sea->CurrentValue, false);

        // iec
        $this->iec->setDbValueDef($rsnew, $this->iec->CurrentValue, false);

        // rex
        $this->rex->setDbValueDef($rsnew, $this->rex->CurrentValue, false);

        // rcmc
        $this->rcmc->setDbValueDef($rsnew, $this->rcmc->CurrentValue, false);

        // delivery_terms
        $this->delivery_terms->setDbValueDef($rsnew, $this->delivery_terms->CurrentValue, false);

        // shipping_terms
        $this->shipping_terms->setDbValueDef($rsnew, $this->shipping_terms->CurrentValue, false);

        // payment_terms
        $this->payment_terms->setDbValueDef($rsnew, $this->payment_terms->CurrentValue, false);

        // export_type
        $this->export_type->setDbValueDef($rsnew, $this->export_type->CurrentValue, false);

        // lead_time_ss
        $this->lead_time_ss->setDbValueDef($rsnew, $this->lead_time_ss->CurrentValue, false);

        // lead_time_cs
        $this->lead_time_cs->setDbValueDef($rsnew, $this->lead_time_cs->CurrentValue, false);

        // cha
        $this->cha->setDbValueDef($rsnew, $this->cha->CurrentValue, false);

        // cha_email
        $this->cha_email->setDbValueDef($rsnew, $this->cha_email->CurrentValue, false);

        // cha_phone
        $this->cha_phone->setDbValueDef($rsnew, $this->cha_phone->CurrentValue, false);

        // forwarder
        $this->forwarder->setDbValueDef($rsnew, $this->forwarder->CurrentValue, false);

        // forwarder_email
        $this->forwarder_email->setDbValueDef($rsnew, $this->forwarder_email->CurrentValue, false);

        // forwarder_phone
        $this->forwarder_phone->setDbValueDef($rsnew, $this->forwarder_phone->CurrentValue, false);

        // merchant
        $this->merchant->setDbValueDef($rsnew, $this->merchant->CurrentValue, false);

        // merchant_email
        $this->merchant_email->setDbValueDef($rsnew, $this->merchant_email->CurrentValue, false);

        // merchant_phone
        $this->merchant_phone->setDbValueDef($rsnew, $this->merchant_phone->CurrentValue, false);

        // shipping_incharge
        $this->shipping_incharge->setDbValueDef($rsnew, $this->shipping_incharge->CurrentValue, false);

        // shipping_email
        $this->shipping_email->setDbValueDef($rsnew, $this->shipping_email->CurrentValue, false);

        // shipping_phone
        $this->shipping_phone->setDbValueDef($rsnew, $this->shipping_phone->CurrentValue, false);

        // account_incharge
        $this->account_incharge->setDbValueDef($rsnew, $this->account_incharge->CurrentValue, false);

        // accounts_email
        $this->accounts_email->setDbValueDef($rsnew, $this->accounts_email->CurrentValue, false);

        // accounts_phone
        $this->accounts_phone->setDbValueDef($rsnew, $this->accounts_phone->CurrentValue, false);

        // warehouse_incharge
        $this->warehouse_incharge->setDbValueDef($rsnew, $this->warehouse_incharge->CurrentValue, false);

        // warehouse_email
        $this->warehouse_email->setDbValueDef($rsnew, $this->warehouse_email->CurrentValue, false);

        // warehouse_phone
        $this->warehouse_phone->setDbValueDef($rsnew, $this->warehouse_phone->CurrentValue, false);

        // production_incharge
        $this->production_incharge->setDbValueDef($rsnew, $this->production_incharge->CurrentValue, false);

        // production_email
        $this->production_email->setDbValueDef($rsnew, $this->production_email->CurrentValue, false);

        // production_phone
        $this->production_phone->setDbValueDef($rsnew, $this->production_phone->CurrentValue, false);

        // qc_incharge
        $this->qc_incharge->setDbValueDef($rsnew, $this->qc_incharge->CurrentValue, false);

        // qc_email
        $this->qc_email->setDbValueDef($rsnew, $this->qc_email->CurrentValue, false);

        // qc_phone
        $this->qc_phone->setDbValueDef($rsnew, $this->qc_phone->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['name'])) { // name
            $this->name->setFormValue($row['name']);
        }
        if (isset($row['code'])) { // code
            $this->code->setFormValue($row['code']);
        }
        if (isset($row['country'])) { // country
            $this->country->setFormValue($row['country']);
        }
        if (isset($row['region'])) { // region
            $this->region->setFormValue($row['region']);
        }
        if (isset($row['city'])) { // city
            $this->city->setFormValue($row['city']);
        }
        if (isset($row['address'])) { // address
            $this->address->setFormValue($row['address']);
        }
        if (isset($row['mobile'])) { // mobile
            $this->mobile->setFormValue($row['mobile']);
        }
        if (isset($row['email'])) { // email
            $this->_email->setFormValue($row['email']);
        }
        if (isset($row['url'])) { // url
            $this->url->setFormValue($row['url']);
        }
        if (isset($row['bank_name'])) { // bank_name
            $this->bank_name->setFormValue($row['bank_name']);
        }
        if (isset($row['bank_account_no'])) { // bank_account_no
            $this->bank_account_no->setFormValue($row['bank_account_no']);
        }
        if (isset($row['bank_code'])) { // bank_code
            $this->bank_code->setFormValue($row['bank_code']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['category'])) { // category
            $this->category->setFormValue($row['category']);
        }
        if (isset($row['reports_to'])) { // reports_to
            $this->reports_to->setFormValue($row['reports_to']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['type'])) { // type
            $this->type->setFormValue($row['type']);
        }
        if (isset($row['tax_registration'])) { // tax_registration
            $this->tax_registration->setFormValue($row['tax_registration']);
        }
        if (isset($row['cin'])) { // cin
            $this->cin->setFormValue($row['cin']);
        }
        if (isset($row['pan'])) { // pan
            $this->pan->setFormValue($row['pan']);
        }
        if (isset($row['tan'])) { // tan
            $this->tan->setFormValue($row['tan']);
        }
        if (isset($row['msme'])) { // msme
            $this->msme->setFormValue($row['msme']);
        }
        if (isset($row['port_air'])) { // port_air
            $this->port_air->setFormValue($row['port_air']);
        }
        if (isset($row['port_sea'])) { // port_sea
            $this->port_sea->setFormValue($row['port_sea']);
        }
        if (isset($row['iec'])) { // iec
            $this->iec->setFormValue($row['iec']);
        }
        if (isset($row['rex'])) { // rex
            $this->rex->setFormValue($row['rex']);
        }
        if (isset($row['rcmc'])) { // rcmc
            $this->rcmc->setFormValue($row['rcmc']);
        }
        if (isset($row['delivery_terms'])) { // delivery_terms
            $this->delivery_terms->setFormValue($row['delivery_terms']);
        }
        if (isset($row['shipping_terms'])) { // shipping_terms
            $this->shipping_terms->setFormValue($row['shipping_terms']);
        }
        if (isset($row['payment_terms'])) { // payment_terms
            $this->payment_terms->setFormValue($row['payment_terms']);
        }
        if (isset($row['export_type'])) { // export_type
            $this->export_type->setFormValue($row['export_type']);
        }
        if (isset($row['lead_time_ss'])) { // lead_time_ss
            $this->lead_time_ss->setFormValue($row['lead_time_ss']);
        }
        if (isset($row['lead_time_cs'])) { // lead_time_cs
            $this->lead_time_cs->setFormValue($row['lead_time_cs']);
        }
        if (isset($row['cha'])) { // cha
            $this->cha->setFormValue($row['cha']);
        }
        if (isset($row['cha_email'])) { // cha_email
            $this->cha_email->setFormValue($row['cha_email']);
        }
        if (isset($row['cha_phone'])) { // cha_phone
            $this->cha_phone->setFormValue($row['cha_phone']);
        }
        if (isset($row['forwarder'])) { // forwarder
            $this->forwarder->setFormValue($row['forwarder']);
        }
        if (isset($row['forwarder_email'])) { // forwarder_email
            $this->forwarder_email->setFormValue($row['forwarder_email']);
        }
        if (isset($row['forwarder_phone'])) { // forwarder_phone
            $this->forwarder_phone->setFormValue($row['forwarder_phone']);
        }
        if (isset($row['merchant'])) { // merchant
            $this->merchant->setFormValue($row['merchant']);
        }
        if (isset($row['merchant_email'])) { // merchant_email
            $this->merchant_email->setFormValue($row['merchant_email']);
        }
        if (isset($row['merchant_phone'])) { // merchant_phone
            $this->merchant_phone->setFormValue($row['merchant_phone']);
        }
        if (isset($row['shipping_incharge'])) { // shipping_incharge
            $this->shipping_incharge->setFormValue($row['shipping_incharge']);
        }
        if (isset($row['shipping_email'])) { // shipping_email
            $this->shipping_email->setFormValue($row['shipping_email']);
        }
        if (isset($row['shipping_phone'])) { // shipping_phone
            $this->shipping_phone->setFormValue($row['shipping_phone']);
        }
        if (isset($row['account_incharge'])) { // account_incharge
            $this->account_incharge->setFormValue($row['account_incharge']);
        }
        if (isset($row['accounts_email'])) { // accounts_email
            $this->accounts_email->setFormValue($row['accounts_email']);
        }
        if (isset($row['accounts_phone'])) { // accounts_phone
            $this->accounts_phone->setFormValue($row['accounts_phone']);
        }
        if (isset($row['warehouse_incharge'])) { // warehouse_incharge
            $this->warehouse_incharge->setFormValue($row['warehouse_incharge']);
        }
        if (isset($row['warehouse_email'])) { // warehouse_email
            $this->warehouse_email->setFormValue($row['warehouse_email']);
        }
        if (isset($row['warehouse_phone'])) { // warehouse_phone
            $this->warehouse_phone->setFormValue($row['warehouse_phone']);
        }
        if (isset($row['production_incharge'])) { // production_incharge
            $this->production_incharge->setFormValue($row['production_incharge']);
        }
        if (isset($row['production_email'])) { // production_email
            $this->production_email->setFormValue($row['production_email']);
        }
        if (isset($row['production_phone'])) { // production_phone
            $this->production_phone->setFormValue($row['production_phone']);
        }
        if (isset($row['qc_incharge'])) { // qc_incharge
            $this->qc_incharge->setFormValue($row['qc_incharge']);
        }
        if (isset($row['qc_email'])) { // qc_email
            $this->qc_email->setFormValue($row['qc_email']);
        }
        if (isset($row['qc_phone'])) { // qc_phone
            $this->qc_phone->setFormValue($row['qc_phone']);
        }
    }

    // Set up detail parms based on QueryString
    protected function setupDetailParms()
    {
        // Get the keys for master table
        $detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
        if ($detailTblVar !== null) {
            $this->setCurrentDetailTable($detailTblVar);
        } else {
            $detailTblVar = $this->getCurrentDetailTable();
        }
        if ($detailTblVar != "") {
            $detailTblVar = explode(",", $detailTblVar);
            if (in_array("shipping_address", $detailTblVar)) {
                $detailPageObj = Container("ShippingAddressGrid");
                if ($detailPageObj->DetailAdd) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    if ($this->CopyRecord) {
                        $detailPageObj->CurrentMode = "copy";
                    } else {
                        $detailPageObj->CurrentMode = "add";
                    }
                    $detailPageObj->CurrentAction = "gridadd";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->_userid->IsDetailKey = true;
                    $detailPageObj->_userid->CurrentValue = $this->id->CurrentValue;
                    $detailPageObj->_userid->setSessionValue($detailPageObj->_userid->CurrentValue);
                }
            }
            if (in_array("bank_info", $detailTblVar)) {
                $detailPageObj = Container("BankInfoGrid");
                if ($detailPageObj->DetailAdd) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    if ($this->CopyRecord) {
                        $detailPageObj->CurrentMode = "copy";
                    } else {
                        $detailPageObj->CurrentMode = "add";
                    }
                    $detailPageObj->CurrentAction = "gridadd";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->user_id->IsDetailKey = true;
                    $detailPageObj->user_id->CurrentValue = $this->id->CurrentValue;
                    $detailPageObj->user_id->setSessionValue($detailPageObj->user_id->CurrentValue);
                }
            }
            if (in_array("capacity_plan", $detailTblVar)) {
                $detailPageObj = Container("CapacityPlanGrid");
                if ($detailPageObj->DetailAdd) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    if ($this->CopyRecord) {
                        $detailPageObj->CurrentMode = "copy";
                    } else {
                        $detailPageObj->CurrentMode = "add";
                    }
                    $detailPageObj->CurrentAction = "gridadd";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->user_id->IsDetailKey = true;
                    $detailPageObj->user_id->CurrentValue = $this->id->CurrentValue;
                    $detailPageObj->user_id->setSessionValue($detailPageObj->user_id->CurrentValue);
                }
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("productionpartnerlist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $pages->add(6);
        $pages->add(7);
        $pages->add(8);
        $pages->add(9);
        $pages->add(10);
        $pages->add(11);
        $pages->add(12);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_country":
                    break;
                case "x_region":
                    break;
                case "x_city":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_reports_to":
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                case "x_type":
                    break;
                case "x_incoterm":
                    break;
                case "x_port_air":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_port_sea":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'production_partner');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
