<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for production_partner
 */
class ProductionPartner extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $name;
    public $code;
    public $country;
    public $region;
    public $city;
    public $city_name;
    public $address;
    public $mobile;
    public $_email;
    public $url;
    public $bank_name;
    public $bank_account_no;
    public $bank_code;
    public $grp;
    public $category;
    public $reports_to;
    public $status;
    public $performance;
    public $operator;
    public $datetime;
    public $type;
    public $tax_registration;
    public $cin;
    public $pan;
    public $tan;
    public $msme;
    public $incoterm;
    public $port_air;
    public $port_sea;
    public $iec;
    public $rex;
    public $rcmc;
    public $delivery_terms;
    public $shipping_terms;
    public $payment_terms;
    public $export_type;
    public $lead_time_ss;
    public $lead_time_cs;
    public $cha;
    public $cha_email;
    public $cha_phone;
    public $forwarder;
    public $forwarder_email;
    public $forwarder_phone;
    public $merchant;
    public $merchant_email;
    public $merchant_phone;
    public $shipping_incharge;
    public $shipping_email;
    public $shipping_phone;
    public $account_incharge;
    public $accounts_email;
    public $accounts_phone;
    public $warehouse_incharge;
    public $warehouse_email;
    public $warehouse_phone;
    public $production_incharge;
    public $production_email;
    public $production_phone;
    public $qc_incharge;
    public $qc_email;
    public $qc_phone;
    public $uid;
    public $r_text;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "production_partner";
        $this->TableName = 'production_partner';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "production_partner";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->IsForeignKey = true; // Foreign key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // name
        $this->name = new DbField(
            $this, // Table
            'x_name', // Variable name
            'name', // Name
            '`name`', // Expression
            '`name`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->name->InputTextType = "text";
        $this->name->Nullable = false; // NOT NULL field
        $this->name->Required = true; // Required field
        $this->name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['name'] = &$this->name;

        // code
        $this->code = new DbField(
            $this, // Table
            'x_code', // Variable name
            'code', // Name
            '`code`', // Expression
            '`code`', // Basic search expression
            200, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->code->InputTextType = "text";
        $this->code->Required = true; // Required field
        $this->code->DefaultErrorMessage = $Language->phrase("IncorrectField");
        $this->code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['code'] = &$this->code;

        // country
        $this->country = new DbField(
            $this, // Table
            'x_country', // Variable name
            'country', // Name
            '`country`', // Expression
            '`country`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`country`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->country->InputTextType = "text";
        $this->country->Raw = true;
        $this->country->setSelectMultiple(false); // Select one
        $this->country->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->country->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->country->Lookup = new Lookup($this->country, 'world_country', false, 'id', ["name","","",""], '', '', [], ["x_region"], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->country->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->country->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['country'] = &$this->country;

        // region
        $this->region = new DbField(
            $this, // Table
            'x_region', // Variable name
            'region', // Name
            '`region`', // Expression
            '`region`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`region`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->region->InputTextType = "text";
        $this->region->Raw = true;
        $this->region->setSelectMultiple(false); // Select one
        $this->region->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->region->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->region->Lookup = new Lookup($this->region, 'world_state', false, 'id', ["name","","",""], '', '', ["x_country"], ["x_city"], ["country_id"], ["x_country_id"], [], [], false, '`name` ASC', '', "`name`");
        $this->region->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->region->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['region'] = &$this->region;

        // city
        $this->city = new DbField(
            $this, // Table
            'x_city', // Variable name
            'city', // Name
            '`city`', // Expression
            '`city`', // Basic search expression
            21, // Type
            19, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__city', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->city->InputTextType = "text";
        $this->city->Raw = true;
        $this->city->Sortable = false; // Allow sort
        $this->city->Lookup = new Lookup($this->city, 'world_city', false, 'id', ["name","","",""], '', '', ["x_region"], [], ["state_id"], ["x_state_id"], [], [], false, '`name` ASC', '', "`name`");
        $this->city->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->city->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['city'] = &$this->city;

        // city_name
        $this->city_name = new DbField(
            $this, // Table
            'x_city_name', // Variable name
            'city_name', // Name
            '`city_name`', // Expression
            '`city_name`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`city_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->city_name->InputTextType = "text";
        $this->city_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['city_name'] = &$this->city_name;

        // address
        $this->address = new DbField(
            $this, // Table
            'x_address', // Variable name
            'address', // Name
            '`address`', // Expression
            '`address`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`address`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->address->InputTextType = "text";
        $this->address->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['address'] = &$this->address;

        // mobile
        $this->mobile = new DbField(
            $this, // Table
            'x_mobile', // Variable name
            'mobile', // Name
            '`mobile`', // Expression
            '`mobile`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`mobile`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->mobile->InputTextType = "text";
        $this->mobile->Sortable = false; // Allow sort
        $this->mobile->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['mobile'] = &$this->mobile;

        // email
        $this->_email = new DbField(
            $this, // Table
            'x__email', // Variable name
            'email', // Name
            '`email`', // Expression
            '`email`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`email`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_email->InputTextType = "text";
        $this->_email->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['email'] = &$this->_email;

        // url
        $this->url = new DbField(
            $this, // Table
            'x_url', // Variable name
            'url', // Name
            '`url`', // Expression
            '`url`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`url`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->url->InputTextType = "text";
        $this->url->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['url'] = &$this->url;

        // bank_name
        $this->bank_name = new DbField(
            $this, // Table
            'x_bank_name', // Variable name
            'bank_name', // Name
            '`bank_name`', // Expression
            '`bank_name`', // Basic search expression
            200, // Type
            196, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bank_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->bank_name->InputTextType = "text";
        $this->bank_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['bank_name'] = &$this->bank_name;

        // bank_account_no
        $this->bank_account_no = new DbField(
            $this, // Table
            'x_bank_account_no', // Variable name
            'bank_account_no', // Name
            '`bank_account_no`', // Expression
            '`bank_account_no`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bank_account_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->bank_account_no->InputTextType = "text";
        $this->bank_account_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['bank_account_no'] = &$this->bank_account_no;

        // bank_code
        $this->bank_code = new DbField(
            $this, // Table
            'x_bank_code', // Variable name
            'bank_code', // Name
            '`bank_code`', // Expression
            '`bank_code`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bank_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->bank_code->InputTextType = "text";
        $this->bank_code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['bank_code'] = &$this->bank_code;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->grp->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->grp->InputTextType = "text";
        $this->grp->Lookup = new Lookup($this->grp, 'grp', false, 'id', ["grp","","",""], '', '', [], [], [], [], [], [], false, '`grp` ASC', '', "`grp`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['grp'] = &$this->grp;

        // category
        $this->category = new DbField(
            $this, // Table
            'x_category', // Variable name
            'category', // Name
            '`category`', // Expression
            '`category`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->category->addMethod("getSelectFilter", fn() => "`status`=1 and FIND_IN_SET('1', `partner_type`)");
        $this->category->InputTextType = "text";
        $this->category->Raw = true;
        $this->category->Nullable = false; // NOT NULL field
        $this->category->Required = true; // Required field
        $this->category->setSelectMultiple(false); // Select one
        $this->category->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->category->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->category->Lookup = new Lookup($this->category, 'pp_category', false, 'id', ["category","","",""], '', '', [], [], [], [], [], [], false, '`category` ASC', '', "`category`");
        $this->category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->category->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['category'] = &$this->category;

        // reports_to
        $this->reports_to = new DbField(
            $this, // Table
            'x_reports_to', // Variable name
            'reports_to', // Name
            '`reports_to`', // Expression
            '`reports_to`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`reports_to`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->reports_to->InputTextType = "text";
        $this->reports_to->Raw = true;
        $this->reports_to->Nullable = false; // NOT NULL field
        $this->reports_to->Required = true; // Required field
        $this->reports_to->setSelectMultiple(false); // Select one
        $this->reports_to->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->reports_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->reports_to->Lookup = new Lookup($this->reports_to, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->reports_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->reports_to->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['reports_to'] = &$this->reports_to;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getDefault", fn() => 1);
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->Required = true; // Required field
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'production_partner', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 2;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['status'] = &$this->status;

        // performance
        $this->performance = new DbField(
            $this, // Table
            'x_performance', // Variable name
            'performance', // Name
            '`performance`', // Expression
            '`performance`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`performance`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->performance->InputTextType = "text";
        $this->performance->Raw = true;
        $this->performance->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->performance->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['performance'] = &$this->performance;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // type
        $this->type = new DbField(
            $this, // Table
            'x_type', // Variable name
            'type', // Name
            '`type`', // Expression
            '`type`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->type->InputTextType = "text";
        $this->type->Raw = true;
        $this->type->Nullable = false; // NOT NULL field
        $this->type->Required = true; // Required field
        $this->type->setSelectMultiple(false); // Select one
        $this->type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->type->Lookup = new Lookup($this->type, 'production_partner', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->type->OptionCount = 5;
        $this->type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['type'] = &$this->type;

        // tax_registration
        $this->tax_registration = new DbField(
            $this, // Table
            'x_tax_registration', // Variable name
            'tax_registration', // Name
            '`tax_registration`', // Expression
            '`tax_registration`', // Basic search expression
            200, // Type
            15, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`tax_registration`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tax_registration->InputTextType = "text";
        $this->tax_registration->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['tax_registration'] = &$this->tax_registration;

        // cin
        $this->cin = new DbField(
            $this, // Table
            'x_cin', // Variable name
            'cin', // Name
            '`cin`', // Expression
            '`cin`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cin`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cin->InputTextType = "text";
        $this->cin->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['cin'] = &$this->cin;

        // pan
        $this->pan = new DbField(
            $this, // Table
            'x_pan', // Variable name
            'pan', // Name
            '`pan`', // Expression
            '`pan`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pan->InputTextType = "text";
        $this->pan->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pan'] = &$this->pan;

        // tan
        $this->tan = new DbField(
            $this, // Table
            'x_tan', // Variable name
            'tan', // Name
            '`tan`', // Expression
            '`tan`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`tan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tan->InputTextType = "text";
        $this->tan->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['tan'] = &$this->tan;

        // msme
        $this->msme = new DbField(
            $this, // Table
            'x_msme', // Variable name
            'msme', // Name
            '`msme`', // Expression
            '`msme`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`msme`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->msme->InputTextType = "text";
        $this->msme->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['msme'] = &$this->msme;

        // incoterm
        $this->incoterm = new DbField(
            $this, // Table
            'x_incoterm', // Variable name
            'incoterm', // Name
            '`incoterm`', // Expression
            '`incoterm`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`incoterm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->incoterm->InputTextType = "text";
        $this->incoterm->Sortable = false; // Allow sort
        $this->incoterm->setSelectMultiple(true); // Select multiple
        $this->incoterm->Lookup = new Lookup($this->incoterm, 'incoterm', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->incoterm->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['incoterm'] = &$this->incoterm;

        // port_air
        $this->port_air = new DbField(
            $this, // Table
            'x_port_air', // Variable name
            'port_air', // Name
            '`port_air`', // Expression
            '`port_air`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`port_air`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->port_air->addMethod("getSelectFilter", fn() => "`mode`=1 and status =1");
        $this->port_air->InputTextType = "text";
        $this->port_air->Raw = true;
        $this->port_air->setSelectMultiple(false); // Select one
        $this->port_air->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->port_air->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->port_air->Lookup = new Lookup($this->port_air, 'port', false, 'id', ["port","code","",""], '', '', [], [], [], [], [], [], false, '`port` ASC', '', "CONCAT(COALESCE(`port`, ''),'" . ValueSeparator(1, $this->port_air) . "',COALESCE(`code`,''))");
        $this->port_air->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['port_air'] = &$this->port_air;

        // port_sea
        $this->port_sea = new DbField(
            $this, // Table
            'x_port_sea', // Variable name
            'port_sea', // Name
            '`port_sea`', // Expression
            '`port_sea`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`port_sea`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->port_sea->addMethod("getSelectFilter", fn() => "`mode`=0 and status =1");
        $this->port_sea->InputTextType = "text";
        $this->port_sea->Raw = true;
        $this->port_sea->setSelectMultiple(false); // Select one
        $this->port_sea->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->port_sea->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->port_sea->Lookup = new Lookup($this->port_sea, 'port', false, 'id', ["port","code","",""], '', '', [], [], [], [], [], [], false, '`port` ASC', '', "CONCAT(COALESCE(`port`, ''),'" . ValueSeparator(1, $this->port_sea) . "',COALESCE(`code`,''))");
        $this->port_sea->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['port_sea'] = &$this->port_sea;

        // iec
        $this->iec = new DbField(
            $this, // Table
            'x_iec', // Variable name
            'iec', // Name
            '`iec`', // Expression
            '`iec`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`iec`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->iec->InputTextType = "text";
        $this->iec->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['iec'] = &$this->iec;

        // rex
        $this->rex = new DbField(
            $this, // Table
            'x_rex', // Variable name
            'rex', // Name
            '`rex`', // Expression
            '`rex`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rex`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rex->InputTextType = "text";
        $this->rex->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['rex'] = &$this->rex;

        // rcmc
        $this->rcmc = new DbField(
            $this, // Table
            'x_rcmc', // Variable name
            'rcmc', // Name
            '`rcmc`', // Expression
            '`rcmc`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rcmc`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rcmc->InputTextType = "text";
        $this->rcmc->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['rcmc'] = &$this->rcmc;

        // delivery_terms
        $this->delivery_terms = new DbField(
            $this, // Table
            'x_delivery_terms', // Variable name
            'delivery_terms', // Name
            '`delivery_terms`', // Expression
            '`delivery_terms`', // Basic search expression
            200, // Type
            196, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`delivery_terms`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->delivery_terms->InputTextType = "text";
        $this->delivery_terms->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['delivery_terms'] = &$this->delivery_terms;

        // shipping_terms
        $this->shipping_terms = new DbField(
            $this, // Table
            'x_shipping_terms', // Variable name
            'shipping_terms', // Name
            '`shipping_terms`', // Expression
            '`shipping_terms`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shipping_terms`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->shipping_terms->InputTextType = "text";
        $this->shipping_terms->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['shipping_terms'] = &$this->shipping_terms;

        // payment_terms
        $this->payment_terms = new DbField(
            $this, // Table
            'x_payment_terms', // Variable name
            'payment_terms', // Name
            '`payment_terms`', // Expression
            '`payment_terms`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment_terms`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->payment_terms->InputTextType = "text";
        $this->payment_terms->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['payment_terms'] = &$this->payment_terms;

        // export_type
        $this->export_type = new DbField(
            $this, // Table
            'x_export_type', // Variable name
            'export_type', // Name
            '`export_type`', // Expression
            '`export_type`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`export_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->export_type->InputTextType = "text";
        $this->export_type->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['export_type'] = &$this->export_type;

        // lead_time_ss
        $this->lead_time_ss = new DbField(
            $this, // Table
            'x_lead_time_ss', // Variable name
            'lead_time_ss', // Name
            '`lead_time_ss`', // Expression
            '`lead_time_ss`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lead_time_ss`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lead_time_ss->InputTextType = "text";
        $this->lead_time_ss->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->lead_time_ss->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['lead_time_ss'] = &$this->lead_time_ss;

        // lead_time_cs
        $this->lead_time_cs = new DbField(
            $this, // Table
            'x_lead_time_cs', // Variable name
            'lead_time_cs', // Name
            '`lead_time_cs`', // Expression
            '`lead_time_cs`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lead_time_cs`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lead_time_cs->InputTextType = "text";
        $this->lead_time_cs->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->lead_time_cs->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['lead_time_cs'] = &$this->lead_time_cs;

        // cha
        $this->cha = new DbField(
            $this, // Table
            'x_cha', // Variable name
            'cha', // Name
            '`cha`', // Expression
            '`cha`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cha`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->cha->InputTextType = "text";
        $this->cha->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->cha->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['cha'] = &$this->cha;

        // cha_email
        $this->cha_email = new DbField(
            $this, // Table
            'x_cha_email', // Variable name
            'cha_email', // Name
            '`cha_email`', // Expression
            '`cha_email`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cha_email`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->cha_email->InputTextType = "text";
        $this->cha_email->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['cha_email'] = &$this->cha_email;

        // cha_phone
        $this->cha_phone = new DbField(
            $this, // Table
            'x_cha_phone', // Variable name
            'cha_phone', // Name
            '`cha_phone`', // Expression
            '`cha_phone`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cha_phone`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->cha_phone->InputTextType = "text";
        $this->cha_phone->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['cha_phone'] = &$this->cha_phone;

        // forwarder
        $this->forwarder = new DbField(
            $this, // Table
            'x_forwarder', // Variable name
            'forwarder', // Name
            '`forwarder`', // Expression
            '`forwarder`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`forwarder`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->forwarder->InputTextType = "text";
        $this->forwarder->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->forwarder->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['forwarder'] = &$this->forwarder;

        // forwarder_email
        $this->forwarder_email = new DbField(
            $this, // Table
            'x_forwarder_email', // Variable name
            'forwarder_email', // Name
            '`forwarder_email`', // Expression
            '`forwarder_email`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`forwarder_email`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->forwarder_email->InputTextType = "text";
        $this->forwarder_email->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['forwarder_email'] = &$this->forwarder_email;

        // forwarder_phone
        $this->forwarder_phone = new DbField(
            $this, // Table
            'x_forwarder_phone', // Variable name
            'forwarder_phone', // Name
            '`forwarder_phone`', // Expression
            '`forwarder_phone`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`forwarder_phone`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->forwarder_phone->InputTextType = "text";
        $this->forwarder_phone->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['forwarder_phone'] = &$this->forwarder_phone;

        // merchant
        $this->merchant = new DbField(
            $this, // Table
            'x_merchant', // Variable name
            'merchant', // Name
            '`merchant`', // Expression
            '`merchant`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`merchant`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->merchant->InputTextType = "text";
        $this->merchant->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['merchant'] = &$this->merchant;

        // merchant_email
        $this->merchant_email = new DbField(
            $this, // Table
            'x_merchant_email', // Variable name
            'merchant_email', // Name
            '`merchant_email`', // Expression
            '`merchant_email`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`merchant_email`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->merchant_email->InputTextType = "text";
        $this->merchant_email->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['merchant_email'] = &$this->merchant_email;

        // merchant_phone
        $this->merchant_phone = new DbField(
            $this, // Table
            'x_merchant_phone', // Variable name
            'merchant_phone', // Name
            '`merchant_phone`', // Expression
            '`merchant_phone`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`merchant_phone`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->merchant_phone->InputTextType = "text";
        $this->merchant_phone->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['merchant_phone'] = &$this->merchant_phone;

        // shipping_incharge
        $this->shipping_incharge = new DbField(
            $this, // Table
            'x_shipping_incharge', // Variable name
            'shipping_incharge', // Name
            '`shipping_incharge`', // Expression
            '`shipping_incharge`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shipping_incharge`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->shipping_incharge->InputTextType = "text";
        $this->shipping_incharge->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['shipping_incharge'] = &$this->shipping_incharge;

        // shipping_email
        $this->shipping_email = new DbField(
            $this, // Table
            'x_shipping_email', // Variable name
            'shipping_email', // Name
            '`shipping_email`', // Expression
            '`shipping_email`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shipping_email`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->shipping_email->InputTextType = "text";
        $this->shipping_email->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['shipping_email'] = &$this->shipping_email;

        // shipping_phone
        $this->shipping_phone = new DbField(
            $this, // Table
            'x_shipping_phone', // Variable name
            'shipping_phone', // Name
            '`shipping_phone`', // Expression
            '`shipping_phone`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shipping_phone`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->shipping_phone->InputTextType = "text";
        $this->shipping_phone->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['shipping_phone'] = &$this->shipping_phone;

        // account_incharge
        $this->account_incharge = new DbField(
            $this, // Table
            'x_account_incharge', // Variable name
            'account_incharge', // Name
            '`account_incharge`', // Expression
            '`account_incharge`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`account_incharge`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->account_incharge->InputTextType = "text";
        $this->account_incharge->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['account_incharge'] = &$this->account_incharge;

        // accounts_email
        $this->accounts_email = new DbField(
            $this, // Table
            'x_accounts_email', // Variable name
            'accounts_email', // Name
            '`accounts_email`', // Expression
            '`accounts_email`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`accounts_email`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->accounts_email->InputTextType = "text";
        $this->accounts_email->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['accounts_email'] = &$this->accounts_email;

        // accounts_phone
        $this->accounts_phone = new DbField(
            $this, // Table
            'x_accounts_phone', // Variable name
            'accounts_phone', // Name
            '`accounts_phone`', // Expression
            '`accounts_phone`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`accounts_phone`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->accounts_phone->InputTextType = "text";
        $this->accounts_phone->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['accounts_phone'] = &$this->accounts_phone;

        // warehouse_incharge
        $this->warehouse_incharge = new DbField(
            $this, // Table
            'x_warehouse_incharge', // Variable name
            'warehouse_incharge', // Name
            '`warehouse_incharge`', // Expression
            '`warehouse_incharge`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`warehouse_incharge`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->warehouse_incharge->InputTextType = "text";
        $this->warehouse_incharge->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['warehouse_incharge'] = &$this->warehouse_incharge;

        // warehouse_email
        $this->warehouse_email = new DbField(
            $this, // Table
            'x_warehouse_email', // Variable name
            'warehouse_email', // Name
            '`warehouse_email`', // Expression
            '`warehouse_email`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`warehouse_email`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->warehouse_email->InputTextType = "text";
        $this->warehouse_email->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['warehouse_email'] = &$this->warehouse_email;

        // warehouse_phone
        $this->warehouse_phone = new DbField(
            $this, // Table
            'x_warehouse_phone', // Variable name
            'warehouse_phone', // Name
            '`warehouse_phone`', // Expression
            '`warehouse_phone`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`warehouse_phone`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->warehouse_phone->InputTextType = "text";
        $this->warehouse_phone->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['warehouse_phone'] = &$this->warehouse_phone;

        // production_incharge
        $this->production_incharge = new DbField(
            $this, // Table
            'x_production_incharge', // Variable name
            'production_incharge', // Name
            '`production_incharge`', // Expression
            '`production_incharge`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`production_incharge`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->production_incharge->InputTextType = "text";
        $this->production_incharge->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['production_incharge'] = &$this->production_incharge;

        // production_email
        $this->production_email = new DbField(
            $this, // Table
            'x_production_email', // Variable name
            'production_email', // Name
            '`production_email`', // Expression
            '`production_email`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`production_email`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->production_email->InputTextType = "text";
        $this->production_email->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['production_email'] = &$this->production_email;

        // production_phone
        $this->production_phone = new DbField(
            $this, // Table
            'x_production_phone', // Variable name
            'production_phone', // Name
            '`production_phone`', // Expression
            '`production_phone`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`production_phone`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->production_phone->InputTextType = "text";
        $this->production_phone->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['production_phone'] = &$this->production_phone;

        // qc_incharge
        $this->qc_incharge = new DbField(
            $this, // Table
            'x_qc_incharge', // Variable name
            'qc_incharge', // Name
            '`qc_incharge`', // Expression
            '`qc_incharge`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qc_incharge`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->qc_incharge->InputTextType = "text";
        $this->qc_incharge->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['qc_incharge'] = &$this->qc_incharge;

        // qc_email
        $this->qc_email = new DbField(
            $this, // Table
            'x_qc_email', // Variable name
            'qc_email', // Name
            '`qc_email`', // Expression
            '`qc_email`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qc_email`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->qc_email->InputTextType = "text";
        $this->qc_email->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['qc_email'] = &$this->qc_email;

        // qc_phone
        $this->qc_phone = new DbField(
            $this, // Table
            'x_qc_phone', // Variable name
            'qc_phone', // Name
            '`qc_phone`', // Expression
            '`qc_phone`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qc_phone`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->qc_phone->InputTextType = "text";
        $this->qc_phone->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['qc_phone'] = &$this->qc_phone;

        // uid
        $this->uid = new DbField(
            $this, // Table
            'x_uid', // Variable name
            'uid', // Name
            '`uid`', // Expression
            '`uid`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`uid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->uid->InputTextType = "text";
        $this->uid->Sortable = false; // Allow sort
        $this->uid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->uid->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['uid'] = &$this->uid;

        // r_text
        $this->r_text = new DbField(
            $this, // Table
            'x_r_text', // Variable name
            'r_text', // Name
            '`r_text`', // Expression
            '`r_text`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`r_text`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->r_text->InputTextType = "text";
        $this->r_text->Sortable = false; // Allow sort
        $this->r_text->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['r_text'] = &$this->r_text;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            if ($ctrl) {
                $orderByList = $this->getSessionOrderByList();
                $arOrderBy = !empty($orderByList) ? explode(", ", $orderByList) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderByList = implode(", ", $arOrderBy);
                $this->setSessionOrderByList($orderByList); // Save to Session
            } else {
                $this->setSessionOrderByList($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Current detail table name
    public function getCurrentDetailTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")) ?? "";
    }

    public function setCurrentDetailTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
    }

    // Get detail url
    public function getDetailUrl()
    {
        // Detail url
        $detailUrl = "";
        if ($this->getCurrentDetailTable() == "shipping_address") {
            $detailUrl = Container("shipping_address")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_id", $this->id->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "bank_info") {
            $detailUrl = Container("bank_info")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_id", $this->id->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "capacity_plan") {
            $detailUrl = Container("capacity_plan")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_id", $this->id->CurrentValue);
        }
        if ($detailUrl == "") {
            $detailUrl = "productionpartnerlist";
        }
        return $detailUrl;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "production_partner";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ",  FROM production_partner)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = User_Company_ID() == 0 ? "" : "`id` = " . User_Company_ID();
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if (
            $this->city->AdvancedSearch->SearchValue != "" ||
            $this->city->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->city->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->city->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->name->DbValue = $row['name'];
        $this->code->DbValue = $row['code'];
        $this->country->DbValue = $row['country'];
        $this->region->DbValue = $row['region'];
        $this->city->DbValue = $row['city'];
        $this->city_name->DbValue = $row['city_name'];
        $this->address->DbValue = $row['address'];
        $this->mobile->DbValue = $row['mobile'];
        $this->_email->DbValue = $row['email'];
        $this->url->DbValue = $row['url'];
        $this->bank_name->DbValue = $row['bank_name'];
        $this->bank_account_no->DbValue = $row['bank_account_no'];
        $this->bank_code->DbValue = $row['bank_code'];
        $this->grp->DbValue = $row['grp'];
        $this->category->DbValue = $row['category'];
        $this->reports_to->DbValue = $row['reports_to'];
        $this->status->DbValue = $row['status'];
        $this->performance->DbValue = $row['performance'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->type->DbValue = $row['type'];
        $this->tax_registration->DbValue = $row['tax_registration'];
        $this->cin->DbValue = $row['cin'];
        $this->pan->DbValue = $row['pan'];
        $this->tan->DbValue = $row['tan'];
        $this->msme->DbValue = $row['msme'];
        $this->incoterm->DbValue = $row['incoterm'];
        $this->port_air->DbValue = $row['port_air'];
        $this->port_sea->DbValue = $row['port_sea'];
        $this->iec->DbValue = $row['iec'];
        $this->rex->DbValue = $row['rex'];
        $this->rcmc->DbValue = $row['rcmc'];
        $this->delivery_terms->DbValue = $row['delivery_terms'];
        $this->shipping_terms->DbValue = $row['shipping_terms'];
        $this->payment_terms->DbValue = $row['payment_terms'];
        $this->export_type->DbValue = $row['export_type'];
        $this->lead_time_ss->DbValue = $row['lead_time_ss'];
        $this->lead_time_cs->DbValue = $row['lead_time_cs'];
        $this->cha->DbValue = $row['cha'];
        $this->cha_email->DbValue = $row['cha_email'];
        $this->cha_phone->DbValue = $row['cha_phone'];
        $this->forwarder->DbValue = $row['forwarder'];
        $this->forwarder_email->DbValue = $row['forwarder_email'];
        $this->forwarder_phone->DbValue = $row['forwarder_phone'];
        $this->merchant->DbValue = $row['merchant'];
        $this->merchant_email->DbValue = $row['merchant_email'];
        $this->merchant_phone->DbValue = $row['merchant_phone'];
        $this->shipping_incharge->DbValue = $row['shipping_incharge'];
        $this->shipping_email->DbValue = $row['shipping_email'];
        $this->shipping_phone->DbValue = $row['shipping_phone'];
        $this->account_incharge->DbValue = $row['account_incharge'];
        $this->accounts_email->DbValue = $row['accounts_email'];
        $this->accounts_phone->DbValue = $row['accounts_phone'];
        $this->warehouse_incharge->DbValue = $row['warehouse_incharge'];
        $this->warehouse_email->DbValue = $row['warehouse_email'];
        $this->warehouse_phone->DbValue = $row['warehouse_phone'];
        $this->production_incharge->DbValue = $row['production_incharge'];
        $this->production_email->DbValue = $row['production_email'];
        $this->production_phone->DbValue = $row['production_phone'];
        $this->qc_incharge->DbValue = $row['qc_incharge'];
        $this->qc_email->DbValue = $row['qc_email'];
        $this->qc_phone->DbValue = $row['qc_phone'];
        $this->uid->DbValue = $row['uid'];
        $this->r_text->DbValue = $row['r_text'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("productionpartnerlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "productionpartnerview" => $Language->phrase("View"),
            "productionpartneredit" => $Language->phrase("Edit"),
            "productionpartneradd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "productionpartnerlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "ProductionPartnerView",
            Config("API_ADD_ACTION") => "ProductionPartnerAdd",
            Config("API_EDIT_ACTION") => "ProductionPartnerEdit",
            Config("API_DELETE_ACTION") => "ProductionPartnerDelete",
            Config("API_LIST_ACTION") => "ProductionPartnerList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "productionpartnerlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("productionpartnerview", $parm);
        } else {
            $url = $this->keyUrl("productionpartnerview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "productionpartneradd?" . $parm;
        } else {
            $url = "productionpartneradd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("productionpartneredit", $parm);
        } else {
            $url = $this->keyUrl("productionpartneredit", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("productionpartnerlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("productionpartneradd", $parm);
        } else {
            $url = $this->keyUrl("productionpartneradd", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("productionpartnerlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("productionpartnerdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->name->setDbValue($row['name']);
        $this->code->setDbValue($row['code']);
        $this->country->setDbValue($row['country']);
        $this->region->setDbValue($row['region']);
        $this->city->setDbValue($row['city']);
        $this->city_name->setDbValue($row['city_name']);
        $this->address->setDbValue($row['address']);
        $this->mobile->setDbValue($row['mobile']);
        $this->_email->setDbValue($row['email']);
        $this->url->setDbValue($row['url']);
        $this->bank_name->setDbValue($row['bank_name']);
        $this->bank_account_no->setDbValue($row['bank_account_no']);
        $this->bank_code->setDbValue($row['bank_code']);
        $this->grp->setDbValue($row['grp']);
        $this->category->setDbValue($row['category']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->status->setDbValue($row['status']);
        $this->performance->setDbValue($row['performance']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->type->setDbValue($row['type']);
        $this->tax_registration->setDbValue($row['tax_registration']);
        $this->cin->setDbValue($row['cin']);
        $this->pan->setDbValue($row['pan']);
        $this->tan->setDbValue($row['tan']);
        $this->msme->setDbValue($row['msme']);
        $this->incoterm->setDbValue($row['incoterm']);
        $this->port_air->setDbValue($row['port_air']);
        $this->port_sea->setDbValue($row['port_sea']);
        $this->iec->setDbValue($row['iec']);
        $this->rex->setDbValue($row['rex']);
        $this->rcmc->setDbValue($row['rcmc']);
        $this->delivery_terms->setDbValue($row['delivery_terms']);
        $this->shipping_terms->setDbValue($row['shipping_terms']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->export_type->setDbValue($row['export_type']);
        $this->lead_time_ss->setDbValue($row['lead_time_ss']);
        $this->lead_time_cs->setDbValue($row['lead_time_cs']);
        $this->cha->setDbValue($row['cha']);
        $this->cha_email->setDbValue($row['cha_email']);
        $this->cha_phone->setDbValue($row['cha_phone']);
        $this->forwarder->setDbValue($row['forwarder']);
        $this->forwarder_email->setDbValue($row['forwarder_email']);
        $this->forwarder_phone->setDbValue($row['forwarder_phone']);
        $this->merchant->setDbValue($row['merchant']);
        $this->merchant_email->setDbValue($row['merchant_email']);
        $this->merchant_phone->setDbValue($row['merchant_phone']);
        $this->shipping_incharge->setDbValue($row['shipping_incharge']);
        $this->shipping_email->setDbValue($row['shipping_email']);
        $this->shipping_phone->setDbValue($row['shipping_phone']);
        $this->account_incharge->setDbValue($row['account_incharge']);
        $this->accounts_email->setDbValue($row['accounts_email']);
        $this->accounts_phone->setDbValue($row['accounts_phone']);
        $this->warehouse_incharge->setDbValue($row['warehouse_incharge']);
        $this->warehouse_email->setDbValue($row['warehouse_email']);
        $this->warehouse_phone->setDbValue($row['warehouse_phone']);
        $this->production_incharge->setDbValue($row['production_incharge']);
        $this->production_email->setDbValue($row['production_email']);
        $this->production_phone->setDbValue($row['production_phone']);
        $this->qc_incharge->setDbValue($row['qc_incharge']);
        $this->qc_email->setDbValue($row['qc_email']);
        $this->qc_phone->setDbValue($row['qc_phone']);
        $this->uid->setDbValue($row['uid']);
        $this->r_text->setDbValue($row['r_text']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "ProductionPartnerList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // name

        // code

        // country

        // region

        // city
        $this->city->CellCssStyle = "white-space: nowrap;";

        // city_name

        // address

        // mobile

        // email

        // url

        // bank_name

        // bank_account_no

        // bank_code

        // grp

        // category

        // reports_to

        // status

        // performance

        // operator

        // datetime

        // type

        // tax_registration

        // cin

        // pan

        // tan

        // msme

        // incoterm
        $this->incoterm->CellCssStyle = "white-space: nowrap;";

        // port_air

        // port_sea

        // iec

        // rex

        // rcmc

        // delivery_terms

        // shipping_terms

        // payment_terms

        // export_type

        // lead_time_ss

        // lead_time_cs

        // cha

        // cha_email

        // cha_phone

        // forwarder

        // forwarder_email

        // forwarder_phone

        // merchant

        // merchant_email

        // merchant_phone

        // shipping_incharge

        // shipping_email

        // shipping_phone

        // account_incharge

        // accounts_email

        // accounts_phone

        // warehouse_incharge

        // warehouse_email

        // warehouse_phone

        // production_incharge

        // production_email

        // production_phone

        // qc_incharge

        // qc_email

        // qc_phone

        // uid
        $this->uid->CellCssStyle = "white-space: nowrap;";

        // r_text
        $this->r_text->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // name
        $this->name->ViewValue = $this->name->CurrentValue;

        // code
        $this->code->ViewValue = $this->code->CurrentValue;

        // country
        $curVal = strval($this->country->CurrentValue);
        if ($curVal != "") {
            $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
            if ($this->country->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->country->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->country->Lookup->renderViewRow($rswrk[0]);
                    $this->country->ViewValue = $this->country->displayValue($arwrk);
                } else {
                    $this->country->ViewValue = FormatNumber($this->country->CurrentValue, $this->country->formatPattern());
                }
            }
        } else {
            $this->country->ViewValue = null;
        }

        // region
        $curVal = strval($this->region->CurrentValue);
        if ($curVal != "") {
            $this->region->ViewValue = $this->region->lookupCacheOption($curVal);
            if ($this->region->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->region->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->region->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->region->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->region->Lookup->renderViewRow($rswrk[0]);
                    $this->region->ViewValue = $this->region->displayValue($arwrk);
                } else {
                    $this->region->ViewValue = FormatNumber($this->region->CurrentValue, $this->region->formatPattern());
                }
            }
        } else {
            $this->region->ViewValue = null;
        }

        // city
        if ($this->city->VirtualValue != "") {
            $this->city->ViewValue = $this->city->VirtualValue;
        } else {
            $this->city->ViewValue = $this->city->CurrentValue;
            $curVal = strval($this->city->CurrentValue);
            if ($curVal != "") {
                $this->city->ViewValue = $this->city->lookupCacheOption($curVal);
                if ($this->city->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->city->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->city->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->city->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->city->Lookup->renderViewRow($rswrk[0]);
                        $this->city->ViewValue = $this->city->displayValue($arwrk);
                    } else {
                        $this->city->ViewValue = FormatNumber($this->city->CurrentValue, $this->city->formatPattern());
                    }
                }
            } else {
                $this->city->ViewValue = null;
            }
        }

        // city_name
        $this->city_name->ViewValue = $this->city_name->CurrentValue;

        // address
        $this->address->ViewValue = $this->address->CurrentValue;

        // mobile
        $this->mobile->ViewValue = $this->mobile->CurrentValue;

        // email
        $this->_email->ViewValue = $this->_email->CurrentValue;

        // url
        $this->url->ViewValue = $this->url->CurrentValue;

        // bank_name
        $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

        // bank_account_no
        $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

        // bank_code
        $this->bank_code->ViewValue = $this->bank_code->CurrentValue;

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->grp->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->grp->Lookup->renderViewRow($row);
                        $this->grp->ViewValue->add($this->grp->displayValue($arwrk));
                    }
                } else {
                    $this->grp->ViewValue = $this->grp->CurrentValue;
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // category
        $curVal = strval($this->category->CurrentValue);
        if ($curVal != "") {
            $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            if ($this->category->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                    $this->category->ViewValue = $this->category->displayValue($arwrk);
                } else {
                    $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                }
            }
        } else {
            $this->category->ViewValue = null;
        }

        // reports_to
        $curVal = strval($this->reports_to->CurrentValue);
        if ($curVal != "") {
            $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            if ($this->reports_to->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                    $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                } else {
                    $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                }
            }
        } else {
            $this->reports_to->ViewValue = null;
        }

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // performance
        $this->performance->ViewValue = $this->performance->CurrentValue;
        $this->performance->ViewValue = FormatNumber($this->performance->ViewValue, $this->performance->formatPattern());

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = $this->operator->CurrentValue;
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // type
        if (strval($this->type->CurrentValue) != "") {
            $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
        } else {
            $this->type->ViewValue = null;
        }

        // tax_registration
        $this->tax_registration->ViewValue = $this->tax_registration->CurrentValue;

        // cin
        $this->cin->ViewValue = $this->cin->CurrentValue;

        // pan
        $this->pan->ViewValue = $this->pan->CurrentValue;

        // tan
        $this->tan->ViewValue = $this->tan->CurrentValue;

        // msme
        $this->msme->ViewValue = $this->msme->CurrentValue;

        // incoterm
        $curVal = strval($this->incoterm->CurrentValue);
        if ($curVal != "") {
            $this->incoterm->ViewValue = $this->incoterm->lookupCacheOption($curVal);
            if ($this->incoterm->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->incoterm->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->incoterm->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $sqlWrk = $this->incoterm->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->incoterm->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->incoterm->Lookup->renderViewRow($row);
                        $this->incoterm->ViewValue->add($this->incoterm->displayValue($arwrk));
                    }
                } else {
                    $this->incoterm->ViewValue = $this->incoterm->CurrentValue;
                }
            }
        } else {
            $this->incoterm->ViewValue = null;
        }

        // port_air
        $curVal = strval($this->port_air->CurrentValue);
        if ($curVal != "") {
            $this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
            if ($this->port_air->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->port_air->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->port_air->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->port_air->getSelectFilter($this); // PHP
                $sqlWrk = $this->port_air->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->port_air->Lookup->renderViewRow($rswrk[0]);
                    $this->port_air->ViewValue = $this->port_air->displayValue($arwrk);
                } else {
                    $this->port_air->ViewValue = $this->port_air->CurrentValue;
                }
            }
        } else {
            $this->port_air->ViewValue = null;
        }

        // port_sea
        $curVal = strval($this->port_sea->CurrentValue);
        if ($curVal != "") {
            $this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
            if ($this->port_sea->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->port_sea->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->port_sea->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->port_sea->getSelectFilter($this); // PHP
                $sqlWrk = $this->port_sea->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->port_sea->Lookup->renderViewRow($rswrk[0]);
                    $this->port_sea->ViewValue = $this->port_sea->displayValue($arwrk);
                } else {
                    $this->port_sea->ViewValue = $this->port_sea->CurrentValue;
                }
            }
        } else {
            $this->port_sea->ViewValue = null;
        }

        // iec
        $this->iec->ViewValue = $this->iec->CurrentValue;

        // rex
        $this->rex->ViewValue = $this->rex->CurrentValue;

        // rcmc
        $this->rcmc->ViewValue = $this->rcmc->CurrentValue;

        // delivery_terms
        $this->delivery_terms->ViewValue = $this->delivery_terms->CurrentValue;

        // shipping_terms
        $this->shipping_terms->ViewValue = $this->shipping_terms->CurrentValue;

        // payment_terms
        $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;

        // export_type
        $this->export_type->ViewValue = $this->export_type->CurrentValue;

        // lead_time_ss
        $this->lead_time_ss->ViewValue = $this->lead_time_ss->CurrentValue;

        // lead_time_cs
        $this->lead_time_cs->ViewValue = $this->lead_time_cs->CurrentValue;

        // cha
        $this->cha->ViewValue = $this->cha->CurrentValue;

        // cha_email
        $this->cha_email->ViewValue = $this->cha_email->CurrentValue;

        // cha_phone
        $this->cha_phone->ViewValue = $this->cha_phone->CurrentValue;

        // forwarder
        $this->forwarder->ViewValue = $this->forwarder->CurrentValue;

        // forwarder_email
        $this->forwarder_email->ViewValue = $this->forwarder_email->CurrentValue;

        // forwarder_phone
        $this->forwarder_phone->ViewValue = $this->forwarder_phone->CurrentValue;

        // merchant
        $this->merchant->ViewValue = $this->merchant->CurrentValue;

        // merchant_email
        $this->merchant_email->ViewValue = $this->merchant_email->CurrentValue;

        // merchant_phone
        $this->merchant_phone->ViewValue = $this->merchant_phone->CurrentValue;

        // shipping_incharge
        $this->shipping_incharge->ViewValue = $this->shipping_incharge->CurrentValue;

        // shipping_email
        $this->shipping_email->ViewValue = $this->shipping_email->CurrentValue;

        // shipping_phone
        $this->shipping_phone->ViewValue = $this->shipping_phone->CurrentValue;

        // account_incharge
        $this->account_incharge->ViewValue = $this->account_incharge->CurrentValue;

        // accounts_email
        $this->accounts_email->ViewValue = $this->accounts_email->CurrentValue;

        // accounts_phone
        $this->accounts_phone->ViewValue = $this->accounts_phone->CurrentValue;

        // warehouse_incharge
        $this->warehouse_incharge->ViewValue = $this->warehouse_incharge->CurrentValue;

        // warehouse_email
        $this->warehouse_email->ViewValue = $this->warehouse_email->CurrentValue;

        // warehouse_phone
        $this->warehouse_phone->ViewValue = $this->warehouse_phone->CurrentValue;

        // production_incharge
        $this->production_incharge->ViewValue = $this->production_incharge->CurrentValue;

        // production_email
        $this->production_email->ViewValue = $this->production_email->CurrentValue;

        // production_phone
        $this->production_phone->ViewValue = $this->production_phone->CurrentValue;

        // qc_incharge
        $this->qc_incharge->ViewValue = $this->qc_incharge->CurrentValue;

        // qc_email
        $this->qc_email->ViewValue = $this->qc_email->CurrentValue;

        // qc_phone
        $this->qc_phone->ViewValue = $this->qc_phone->CurrentValue;

        // uid
        $this->uid->ViewValue = $this->uid->CurrentValue;

        // r_text
        $this->r_text->ViewValue = $this->r_text->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // name
        $this->name->HrefValue = "";
        $this->name->TooltipValue = "";

        // code
        $this->code->HrefValue = "";
        $this->code->TooltipValue = "";

        // country
        $this->country->HrefValue = "";
        $this->country->TooltipValue = "";

        // region
        $this->region->HrefValue = "";
        $this->region->TooltipValue = "";

        // city
        $this->city->HrefValue = "";
        $this->city->TooltipValue = "";

        // city_name
        $this->city_name->HrefValue = "";
        $this->city_name->TooltipValue = "";

        // address
        $this->address->HrefValue = "";
        $this->address->TooltipValue = "";

        // mobile
        $this->mobile->HrefValue = "";
        $this->mobile->TooltipValue = "";

        // email
        $this->_email->HrefValue = "";
        $this->_email->TooltipValue = "";

        // url
        $this->url->HrefValue = "";
        $this->url->TooltipValue = "";

        // bank_name
        $this->bank_name->HrefValue = "";
        $this->bank_name->TooltipValue = "";

        // bank_account_no
        $this->bank_account_no->HrefValue = "";
        $this->bank_account_no->TooltipValue = "";

        // bank_code
        $this->bank_code->HrefValue = "";
        $this->bank_code->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // category
        $this->category->HrefValue = "";
        $this->category->TooltipValue = "";

        // reports_to
        $this->reports_to->HrefValue = "";
        $this->reports_to->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // performance
        $this->performance->HrefValue = "";
        $this->performance->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // type
        $this->type->HrefValue = "";
        $this->type->TooltipValue = "";

        // tax_registration
        $this->tax_registration->HrefValue = "";
        $this->tax_registration->TooltipValue = "";

        // cin
        $this->cin->HrefValue = "";
        $this->cin->TooltipValue = "";

        // pan
        $this->pan->HrefValue = "";
        $this->pan->TooltipValue = "";

        // tan
        $this->tan->HrefValue = "";
        $this->tan->TooltipValue = "";

        // msme
        $this->msme->HrefValue = "";
        $this->msme->TooltipValue = "";

        // incoterm
        $this->incoterm->HrefValue = "";
        $this->incoterm->TooltipValue = "";

        // port_air
        $this->port_air->HrefValue = "";
        $this->port_air->TooltipValue = "";

        // port_sea
        $this->port_sea->HrefValue = "";
        $this->port_sea->TooltipValue = "";

        // iec
        $this->iec->HrefValue = "";
        $this->iec->TooltipValue = "";

        // rex
        $this->rex->HrefValue = "";
        $this->rex->TooltipValue = "";

        // rcmc
        $this->rcmc->HrefValue = "";
        $this->rcmc->TooltipValue = "";

        // delivery_terms
        $this->delivery_terms->HrefValue = "";
        $this->delivery_terms->TooltipValue = "";

        // shipping_terms
        $this->shipping_terms->HrefValue = "";
        $this->shipping_terms->TooltipValue = "";

        // payment_terms
        $this->payment_terms->HrefValue = "";
        $this->payment_terms->TooltipValue = "";

        // export_type
        $this->export_type->HrefValue = "";
        $this->export_type->TooltipValue = "";

        // lead_time_ss
        $this->lead_time_ss->HrefValue = "";
        $this->lead_time_ss->TooltipValue = "";

        // lead_time_cs
        $this->lead_time_cs->HrefValue = "";
        $this->lead_time_cs->TooltipValue = "";

        // cha
        $this->cha->HrefValue = "";
        $this->cha->TooltipValue = "";

        // cha_email
        $this->cha_email->HrefValue = "";
        $this->cha_email->TooltipValue = "";

        // cha_phone
        $this->cha_phone->HrefValue = "";
        $this->cha_phone->TooltipValue = "";

        // forwarder
        $this->forwarder->HrefValue = "";
        $this->forwarder->TooltipValue = "";

        // forwarder_email
        $this->forwarder_email->HrefValue = "";
        $this->forwarder_email->TooltipValue = "";

        // forwarder_phone
        $this->forwarder_phone->HrefValue = "";
        $this->forwarder_phone->TooltipValue = "";

        // merchant
        $this->merchant->HrefValue = "";
        $this->merchant->TooltipValue = "";

        // merchant_email
        $this->merchant_email->HrefValue = "";
        $this->merchant_email->TooltipValue = "";

        // merchant_phone
        $this->merchant_phone->HrefValue = "";
        $this->merchant_phone->TooltipValue = "";

        // shipping_incharge
        $this->shipping_incharge->HrefValue = "";
        $this->shipping_incharge->TooltipValue = "";

        // shipping_email
        $this->shipping_email->HrefValue = "";
        $this->shipping_email->TooltipValue = "";

        // shipping_phone
        $this->shipping_phone->HrefValue = "";
        $this->shipping_phone->TooltipValue = "";

        // account_incharge
        $this->account_incharge->HrefValue = "";
        $this->account_incharge->TooltipValue = "";

        // accounts_email
        $this->accounts_email->HrefValue = "";
        $this->accounts_email->TooltipValue = "";

        // accounts_phone
        $this->accounts_phone->HrefValue = "";
        $this->accounts_phone->TooltipValue = "";

        // warehouse_incharge
        $this->warehouse_incharge->HrefValue = "";
        $this->warehouse_incharge->TooltipValue = "";

        // warehouse_email
        $this->warehouse_email->HrefValue = "";
        $this->warehouse_email->TooltipValue = "";

        // warehouse_phone
        $this->warehouse_phone->HrefValue = "";
        $this->warehouse_phone->TooltipValue = "";

        // production_incharge
        $this->production_incharge->HrefValue = "";
        $this->production_incharge->TooltipValue = "";

        // production_email
        $this->production_email->HrefValue = "";
        $this->production_email->TooltipValue = "";

        // production_phone
        $this->production_phone->HrefValue = "";
        $this->production_phone->TooltipValue = "";

        // qc_incharge
        $this->qc_incharge->HrefValue = "";
        $this->qc_incharge->TooltipValue = "";

        // qc_email
        $this->qc_email->HrefValue = "";
        $this->qc_email->TooltipValue = "";

        // qc_phone
        $this->qc_phone->HrefValue = "";
        $this->qc_phone->TooltipValue = "";

        // uid
        $this->uid->HrefValue = "";
        $this->uid->TooltipValue = "";

        // r_text
        $this->r_text->HrefValue = "";
        $this->r_text->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // name
        $this->name->setupEditAttributes();
        if (!$this->name->Raw) {
            $this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
        }
        $this->name->EditValue = $this->name->CurrentValue;
        $this->name->PlaceHolder = RemoveHtml($this->name->caption());

        // code
        $this->code->setupEditAttributes();
        if (!$this->code->Raw) {
            $this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
        }
        $this->code->EditValue = $this->code->CurrentValue;
        $this->code->PlaceHolder = RemoveHtml($this->code->caption());

        // country
        $this->country->setupEditAttributes();
        $this->country->PlaceHolder = RemoveHtml($this->country->caption());

        // region
        $this->region->setupEditAttributes();
        $this->region->PlaceHolder = RemoveHtml($this->region->caption());

        // city
        $this->city->setupEditAttributes();
        $this->city->EditValue = $this->city->CurrentValue;
        $this->city->PlaceHolder = RemoveHtml($this->city->caption());

        // city_name
        $this->city_name->setupEditAttributes();
        if (!$this->city_name->Raw) {
            $this->city_name->CurrentValue = HtmlDecode($this->city_name->CurrentValue);
        }
        $this->city_name->EditValue = $this->city_name->CurrentValue;
        $this->city_name->PlaceHolder = RemoveHtml($this->city_name->caption());

        // address
        $this->address->setupEditAttributes();
        $this->address->EditValue = $this->address->CurrentValue;
        $this->address->PlaceHolder = RemoveHtml($this->address->caption());

        // mobile
        $this->mobile->setupEditAttributes();
        if (!$this->mobile->Raw) {
            $this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
        }
        $this->mobile->EditValue = $this->mobile->CurrentValue;
        $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

        // email
        $this->_email->setupEditAttributes();
        if (!$this->_email->Raw) {
            $this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
        }
        $this->_email->EditValue = $this->_email->CurrentValue;
        $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

        // url
        $this->url->setupEditAttributes();
        if (!$this->url->Raw) {
            $this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
        }
        $this->url->EditValue = $this->url->CurrentValue;
        $this->url->PlaceHolder = RemoveHtml($this->url->caption());

        // bank_name
        $this->bank_name->setupEditAttributes();
        if (!$this->bank_name->Raw) {
            $this->bank_name->CurrentValue = HtmlDecode($this->bank_name->CurrentValue);
        }
        $this->bank_name->EditValue = $this->bank_name->CurrentValue;
        $this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

        // bank_account_no
        $this->bank_account_no->setupEditAttributes();
        if (!$this->bank_account_no->Raw) {
            $this->bank_account_no->CurrentValue = HtmlDecode($this->bank_account_no->CurrentValue);
        }
        $this->bank_account_no->EditValue = $this->bank_account_no->CurrentValue;
        $this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

        // bank_code
        $this->bank_code->setupEditAttributes();
        if (!$this->bank_code->Raw) {
            $this->bank_code->CurrentValue = HtmlDecode($this->bank_code->CurrentValue);
        }
        $this->bank_code->EditValue = $this->bank_code->CurrentValue;
        $this->bank_code->PlaceHolder = RemoveHtml($this->bank_code->caption());

        // grp
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

        // category
        $this->category->setupEditAttributes();
        $this->category->PlaceHolder = RemoveHtml($this->category->caption());

        // reports_to
        $this->reports_to->setupEditAttributes();
        $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

        // status
        $this->status->setupEditAttributes();
        $this->status->EditValue = $this->status->options(true);
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // performance
        $this->performance->setupEditAttributes();
        $this->performance->EditValue = $this->performance->CurrentValue;
        $this->performance->PlaceHolder = RemoveHtml($this->performance->caption());
        if (strval($this->performance->EditValue) != "" && is_numeric($this->performance->EditValue)) {
            $this->performance->EditValue = FormatNumber($this->performance->EditValue, null);
        }

        // operator

        // datetime

        // type
        $this->type->setupEditAttributes();
        $this->type->EditValue = $this->type->options(true);
        $this->type->PlaceHolder = RemoveHtml($this->type->caption());

        // tax_registration
        $this->tax_registration->setupEditAttributes();
        if (!$this->tax_registration->Raw) {
            $this->tax_registration->CurrentValue = HtmlDecode($this->tax_registration->CurrentValue);
        }
        $this->tax_registration->EditValue = $this->tax_registration->CurrentValue;
        $this->tax_registration->PlaceHolder = RemoveHtml($this->tax_registration->caption());

        // cin
        $this->cin->setupEditAttributes();
        if (!$this->cin->Raw) {
            $this->cin->CurrentValue = HtmlDecode($this->cin->CurrentValue);
        }
        $this->cin->EditValue = $this->cin->CurrentValue;
        $this->cin->PlaceHolder = RemoveHtml($this->cin->caption());

        // pan
        $this->pan->setupEditAttributes();
        if (!$this->pan->Raw) {
            $this->pan->CurrentValue = HtmlDecode($this->pan->CurrentValue);
        }
        $this->pan->EditValue = $this->pan->CurrentValue;
        $this->pan->PlaceHolder = RemoveHtml($this->pan->caption());

        // tan
        $this->tan->setupEditAttributes();
        if (!$this->tan->Raw) {
            $this->tan->CurrentValue = HtmlDecode($this->tan->CurrentValue);
        }
        $this->tan->EditValue = $this->tan->CurrentValue;
        $this->tan->PlaceHolder = RemoveHtml($this->tan->caption());

        // msme
        $this->msme->setupEditAttributes();
        if (!$this->msme->Raw) {
            $this->msme->CurrentValue = HtmlDecode($this->msme->CurrentValue);
        }
        $this->msme->EditValue = $this->msme->CurrentValue;
        $this->msme->PlaceHolder = RemoveHtml($this->msme->caption());

        // incoterm
        $this->incoterm->setupEditAttributes();
        $this->incoterm->PlaceHolder = RemoveHtml($this->incoterm->caption());

        // port_air
        $this->port_air->setupEditAttributes();
        $this->port_air->PlaceHolder = RemoveHtml($this->port_air->caption());

        // port_sea
        $this->port_sea->setupEditAttributes();
        $this->port_sea->PlaceHolder = RemoveHtml($this->port_sea->caption());

        // iec
        $this->iec->setupEditAttributes();
        if (!$this->iec->Raw) {
            $this->iec->CurrentValue = HtmlDecode($this->iec->CurrentValue);
        }
        $this->iec->EditValue = $this->iec->CurrentValue;
        $this->iec->PlaceHolder = RemoveHtml($this->iec->caption());

        // rex
        $this->rex->setupEditAttributes();
        if (!$this->rex->Raw) {
            $this->rex->CurrentValue = HtmlDecode($this->rex->CurrentValue);
        }
        $this->rex->EditValue = $this->rex->CurrentValue;
        $this->rex->PlaceHolder = RemoveHtml($this->rex->caption());

        // rcmc
        $this->rcmc->setupEditAttributes();
        if (!$this->rcmc->Raw) {
            $this->rcmc->CurrentValue = HtmlDecode($this->rcmc->CurrentValue);
        }
        $this->rcmc->EditValue = $this->rcmc->CurrentValue;
        $this->rcmc->PlaceHolder = RemoveHtml($this->rcmc->caption());

        // delivery_terms
        $this->delivery_terms->setupEditAttributes();
        if (!$this->delivery_terms->Raw) {
            $this->delivery_terms->CurrentValue = HtmlDecode($this->delivery_terms->CurrentValue);
        }
        $this->delivery_terms->EditValue = $this->delivery_terms->CurrentValue;
        $this->delivery_terms->PlaceHolder = RemoveHtml($this->delivery_terms->caption());

        // shipping_terms
        $this->shipping_terms->setupEditAttributes();
        if (!$this->shipping_terms->Raw) {
            $this->shipping_terms->CurrentValue = HtmlDecode($this->shipping_terms->CurrentValue);
        }
        $this->shipping_terms->EditValue = $this->shipping_terms->CurrentValue;
        $this->shipping_terms->PlaceHolder = RemoveHtml($this->shipping_terms->caption());

        // payment_terms
        $this->payment_terms->setupEditAttributes();
        if (!$this->payment_terms->Raw) {
            $this->payment_terms->CurrentValue = HtmlDecode($this->payment_terms->CurrentValue);
        }
        $this->payment_terms->EditValue = $this->payment_terms->CurrentValue;
        $this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

        // export_type
        $this->export_type->setupEditAttributes();
        if (!$this->export_type->Raw) {
            $this->export_type->CurrentValue = HtmlDecode($this->export_type->CurrentValue);
        }
        $this->export_type->EditValue = $this->export_type->CurrentValue;
        $this->export_type->PlaceHolder = RemoveHtml($this->export_type->caption());

        // lead_time_ss
        $this->lead_time_ss->setupEditAttributes();
        if (!$this->lead_time_ss->Raw) {
            $this->lead_time_ss->CurrentValue = HtmlDecode($this->lead_time_ss->CurrentValue);
        }
        $this->lead_time_ss->EditValue = $this->lead_time_ss->CurrentValue;
        $this->lead_time_ss->PlaceHolder = RemoveHtml($this->lead_time_ss->caption());

        // lead_time_cs
        $this->lead_time_cs->setupEditAttributes();
        if (!$this->lead_time_cs->Raw) {
            $this->lead_time_cs->CurrentValue = HtmlDecode($this->lead_time_cs->CurrentValue);
        }
        $this->lead_time_cs->EditValue = $this->lead_time_cs->CurrentValue;
        $this->lead_time_cs->PlaceHolder = RemoveHtml($this->lead_time_cs->caption());

        // cha
        $this->cha->setupEditAttributes();
        $this->cha->EditValue = $this->cha->CurrentValue;
        $this->cha->PlaceHolder = RemoveHtml($this->cha->caption());

        // cha_email
        $this->cha_email->setupEditAttributes();
        $this->cha_email->EditValue = $this->cha_email->CurrentValue;
        $this->cha_email->PlaceHolder = RemoveHtml($this->cha_email->caption());

        // cha_phone
        $this->cha_phone->setupEditAttributes();
        $this->cha_phone->EditValue = $this->cha_phone->CurrentValue;
        $this->cha_phone->PlaceHolder = RemoveHtml($this->cha_phone->caption());

        // forwarder
        $this->forwarder->setupEditAttributes();
        $this->forwarder->EditValue = $this->forwarder->CurrentValue;
        $this->forwarder->PlaceHolder = RemoveHtml($this->forwarder->caption());

        // forwarder_email
        $this->forwarder_email->setupEditAttributes();
        $this->forwarder_email->EditValue = $this->forwarder_email->CurrentValue;
        $this->forwarder_email->PlaceHolder = RemoveHtml($this->forwarder_email->caption());

        // forwarder_phone
        $this->forwarder_phone->setupEditAttributes();
        $this->forwarder_phone->EditValue = $this->forwarder_phone->CurrentValue;
        $this->forwarder_phone->PlaceHolder = RemoveHtml($this->forwarder_phone->caption());

        // merchant
        $this->merchant->setupEditAttributes();
        $this->merchant->EditValue = $this->merchant->CurrentValue;
        $this->merchant->PlaceHolder = RemoveHtml($this->merchant->caption());

        // merchant_email
        $this->merchant_email->setupEditAttributes();
        $this->merchant_email->EditValue = $this->merchant_email->CurrentValue;
        $this->merchant_email->PlaceHolder = RemoveHtml($this->merchant_email->caption());

        // merchant_phone
        $this->merchant_phone->setupEditAttributes();
        $this->merchant_phone->EditValue = $this->merchant_phone->CurrentValue;
        $this->merchant_phone->PlaceHolder = RemoveHtml($this->merchant_phone->caption());

        // shipping_incharge
        $this->shipping_incharge->setupEditAttributes();
        $this->shipping_incharge->EditValue = $this->shipping_incharge->CurrentValue;
        $this->shipping_incharge->PlaceHolder = RemoveHtml($this->shipping_incharge->caption());

        // shipping_email
        $this->shipping_email->setupEditAttributes();
        $this->shipping_email->EditValue = $this->shipping_email->CurrentValue;
        $this->shipping_email->PlaceHolder = RemoveHtml($this->shipping_email->caption());

        // shipping_phone
        $this->shipping_phone->setupEditAttributes();
        $this->shipping_phone->EditValue = $this->shipping_phone->CurrentValue;
        $this->shipping_phone->PlaceHolder = RemoveHtml($this->shipping_phone->caption());

        // account_incharge
        $this->account_incharge->setupEditAttributes();
        $this->account_incharge->EditValue = $this->account_incharge->CurrentValue;
        $this->account_incharge->PlaceHolder = RemoveHtml($this->account_incharge->caption());

        // accounts_email
        $this->accounts_email->setupEditAttributes();
        $this->accounts_email->EditValue = $this->accounts_email->CurrentValue;
        $this->accounts_email->PlaceHolder = RemoveHtml($this->accounts_email->caption());

        // accounts_phone
        $this->accounts_phone->setupEditAttributes();
        $this->accounts_phone->EditValue = $this->accounts_phone->CurrentValue;
        $this->accounts_phone->PlaceHolder = RemoveHtml($this->accounts_phone->caption());

        // warehouse_incharge
        $this->warehouse_incharge->setupEditAttributes();
        $this->warehouse_incharge->EditValue = $this->warehouse_incharge->CurrentValue;
        $this->warehouse_incharge->PlaceHolder = RemoveHtml($this->warehouse_incharge->caption());

        // warehouse_email
        $this->warehouse_email->setupEditAttributes();
        $this->warehouse_email->EditValue = $this->warehouse_email->CurrentValue;
        $this->warehouse_email->PlaceHolder = RemoveHtml($this->warehouse_email->caption());

        // warehouse_phone
        $this->warehouse_phone->setupEditAttributes();
        $this->warehouse_phone->EditValue = $this->warehouse_phone->CurrentValue;
        $this->warehouse_phone->PlaceHolder = RemoveHtml($this->warehouse_phone->caption());

        // production_incharge
        $this->production_incharge->setupEditAttributes();
        $this->production_incharge->EditValue = $this->production_incharge->CurrentValue;
        $this->production_incharge->PlaceHolder = RemoveHtml($this->production_incharge->caption());

        // production_email
        $this->production_email->setupEditAttributes();
        $this->production_email->EditValue = $this->production_email->CurrentValue;
        $this->production_email->PlaceHolder = RemoveHtml($this->production_email->caption());

        // production_phone
        $this->production_phone->setupEditAttributes();
        $this->production_phone->EditValue = $this->production_phone->CurrentValue;
        $this->production_phone->PlaceHolder = RemoveHtml($this->production_phone->caption());

        // qc_incharge
        $this->qc_incharge->setupEditAttributes();
        $this->qc_incharge->EditValue = $this->qc_incharge->CurrentValue;
        $this->qc_incharge->PlaceHolder = RemoveHtml($this->qc_incharge->caption());

        // qc_email
        $this->qc_email->setupEditAttributes();
        $this->qc_email->EditValue = $this->qc_email->CurrentValue;
        $this->qc_email->PlaceHolder = RemoveHtml($this->qc_email->caption());

        // qc_phone
        $this->qc_phone->setupEditAttributes();
        $this->qc_phone->EditValue = $this->qc_phone->CurrentValue;
        $this->qc_phone->PlaceHolder = RemoveHtml($this->qc_phone->caption());

        // uid
        $this->uid->setupEditAttributes();
        if (!$this->uid->Raw) {
            $this->uid->CurrentValue = HtmlDecode($this->uid->CurrentValue);
        }
        $this->uid->EditValue = $this->uid->CurrentValue;
        $this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

        // r_text
        $this->r_text->setupEditAttributes();
        $this->r_text->EditValue = $this->r_text->CurrentValue;
        $this->r_text->PlaceHolder = RemoveHtml($this->r_text->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->name);
                    $doc->exportCaption($this->code);
                    $doc->exportCaption($this->country);
                    $doc->exportCaption($this->region);
                    $doc->exportCaption($this->city_name);
                    $doc->exportCaption($this->address);
                    $doc->exportCaption($this->mobile);
                    $doc->exportCaption($this->_email);
                    $doc->exportCaption($this->url);
                    $doc->exportCaption($this->bank_name);
                    $doc->exportCaption($this->bank_account_no);
                    $doc->exportCaption($this->bank_code);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->category);
                    $doc->exportCaption($this->reports_to);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->performance);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->type);
                    $doc->exportCaption($this->tax_registration);
                    $doc->exportCaption($this->cin);
                    $doc->exportCaption($this->pan);
                    $doc->exportCaption($this->tan);
                    $doc->exportCaption($this->msme);
                    $doc->exportCaption($this->port_air);
                    $doc->exportCaption($this->port_sea);
                    $doc->exportCaption($this->iec);
                    $doc->exportCaption($this->rex);
                    $doc->exportCaption($this->rcmc);
                    $doc->exportCaption($this->delivery_terms);
                    $doc->exportCaption($this->shipping_terms);
                    $doc->exportCaption($this->payment_terms);
                    $doc->exportCaption($this->export_type);
                    $doc->exportCaption($this->lead_time_ss);
                    $doc->exportCaption($this->lead_time_cs);
                    $doc->exportCaption($this->cha);
                    $doc->exportCaption($this->cha_email);
                    $doc->exportCaption($this->cha_phone);
                    $doc->exportCaption($this->forwarder);
                    $doc->exportCaption($this->forwarder_email);
                    $doc->exportCaption($this->forwarder_phone);
                    $doc->exportCaption($this->merchant);
                    $doc->exportCaption($this->merchant_email);
                    $doc->exportCaption($this->merchant_phone);
                    $doc->exportCaption($this->shipping_incharge);
                    $doc->exportCaption($this->shipping_email);
                    $doc->exportCaption($this->shipping_phone);
                    $doc->exportCaption($this->account_incharge);
                    $doc->exportCaption($this->accounts_email);
                    $doc->exportCaption($this->accounts_phone);
                    $doc->exportCaption($this->warehouse_incharge);
                    $doc->exportCaption($this->warehouse_email);
                    $doc->exportCaption($this->warehouse_phone);
                    $doc->exportCaption($this->production_incharge);
                    $doc->exportCaption($this->production_email);
                    $doc->exportCaption($this->production_phone);
                    $doc->exportCaption($this->qc_incharge);
                    $doc->exportCaption($this->qc_email);
                    $doc->exportCaption($this->qc_phone);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->name);
                    $doc->exportCaption($this->code);
                    $doc->exportCaption($this->country);
                    $doc->exportCaption($this->region);
                    $doc->exportCaption($this->city_name);
                    $doc->exportCaption($this->address);
                    $doc->exportCaption($this->mobile);
                    $doc->exportCaption($this->_email);
                    $doc->exportCaption($this->url);
                    $doc->exportCaption($this->bank_name);
                    $doc->exportCaption($this->bank_account_no);
                    $doc->exportCaption($this->bank_code);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->category);
                    $doc->exportCaption($this->reports_to);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->performance);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->type);
                    $doc->exportCaption($this->tax_registration);
                    $doc->exportCaption($this->cin);
                    $doc->exportCaption($this->pan);
                    $doc->exportCaption($this->tan);
                    $doc->exportCaption($this->msme);
                    $doc->exportCaption($this->port_air);
                    $doc->exportCaption($this->port_sea);
                    $doc->exportCaption($this->iec);
                    $doc->exportCaption($this->rex);
                    $doc->exportCaption($this->rcmc);
                    $doc->exportCaption($this->delivery_terms);
                    $doc->exportCaption($this->shipping_terms);
                    $doc->exportCaption($this->payment_terms);
                    $doc->exportCaption($this->export_type);
                    $doc->exportCaption($this->lead_time_ss);
                    $doc->exportCaption($this->lead_time_cs);
                    $doc->exportCaption($this->cha);
                    $doc->exportCaption($this->cha_email);
                    $doc->exportCaption($this->cha_phone);
                    $doc->exportCaption($this->forwarder);
                    $doc->exportCaption($this->forwarder_email);
                    $doc->exportCaption($this->forwarder_phone);
                    $doc->exportCaption($this->merchant);
                    $doc->exportCaption($this->merchant_email);
                    $doc->exportCaption($this->merchant_phone);
                    $doc->exportCaption($this->shipping_incharge);
                    $doc->exportCaption($this->shipping_email);
                    $doc->exportCaption($this->shipping_phone);
                    $doc->exportCaption($this->account_incharge);
                    $doc->exportCaption($this->accounts_email);
                    $doc->exportCaption($this->accounts_phone);
                    $doc->exportCaption($this->warehouse_incharge);
                    $doc->exportCaption($this->warehouse_email);
                    $doc->exportCaption($this->warehouse_phone);
                    $doc->exportCaption($this->production_incharge);
                    $doc->exportCaption($this->production_email);
                    $doc->exportCaption($this->production_phone);
                    $doc->exportCaption($this->qc_incharge);
                    $doc->exportCaption($this->qc_email);
                    $doc->exportCaption($this->qc_phone);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->name);
                        $doc->exportField($this->code);
                        $doc->exportField($this->country);
                        $doc->exportField($this->region);
                        $doc->exportField($this->city_name);
                        $doc->exportField($this->address);
                        $doc->exportField($this->mobile);
                        $doc->exportField($this->_email);
                        $doc->exportField($this->url);
                        $doc->exportField($this->bank_name);
                        $doc->exportField($this->bank_account_no);
                        $doc->exportField($this->bank_code);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->category);
                        $doc->exportField($this->reports_to);
                        $doc->exportField($this->status);
                        $doc->exportField($this->performance);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->type);
                        $doc->exportField($this->tax_registration);
                        $doc->exportField($this->cin);
                        $doc->exportField($this->pan);
                        $doc->exportField($this->tan);
                        $doc->exportField($this->msme);
                        $doc->exportField($this->port_air);
                        $doc->exportField($this->port_sea);
                        $doc->exportField($this->iec);
                        $doc->exportField($this->rex);
                        $doc->exportField($this->rcmc);
                        $doc->exportField($this->delivery_terms);
                        $doc->exportField($this->shipping_terms);
                        $doc->exportField($this->payment_terms);
                        $doc->exportField($this->export_type);
                        $doc->exportField($this->lead_time_ss);
                        $doc->exportField($this->lead_time_cs);
                        $doc->exportField($this->cha);
                        $doc->exportField($this->cha_email);
                        $doc->exportField($this->cha_phone);
                        $doc->exportField($this->forwarder);
                        $doc->exportField($this->forwarder_email);
                        $doc->exportField($this->forwarder_phone);
                        $doc->exportField($this->merchant);
                        $doc->exportField($this->merchant_email);
                        $doc->exportField($this->merchant_phone);
                        $doc->exportField($this->shipping_incharge);
                        $doc->exportField($this->shipping_email);
                        $doc->exportField($this->shipping_phone);
                        $doc->exportField($this->account_incharge);
                        $doc->exportField($this->accounts_email);
                        $doc->exportField($this->accounts_phone);
                        $doc->exportField($this->warehouse_incharge);
                        $doc->exportField($this->warehouse_email);
                        $doc->exportField($this->warehouse_phone);
                        $doc->exportField($this->production_incharge);
                        $doc->exportField($this->production_email);
                        $doc->exportField($this->production_phone);
                        $doc->exportField($this->qc_incharge);
                        $doc->exportField($this->qc_email);
                        $doc->exportField($this->qc_phone);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->name);
                        $doc->exportField($this->code);
                        $doc->exportField($this->country);
                        $doc->exportField($this->region);
                        $doc->exportField($this->city_name);
                        $doc->exportField($this->address);
                        $doc->exportField($this->mobile);
                        $doc->exportField($this->_email);
                        $doc->exportField($this->url);
                        $doc->exportField($this->bank_name);
                        $doc->exportField($this->bank_account_no);
                        $doc->exportField($this->bank_code);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->category);
                        $doc->exportField($this->reports_to);
                        $doc->exportField($this->status);
                        $doc->exportField($this->performance);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->type);
                        $doc->exportField($this->tax_registration);
                        $doc->exportField($this->cin);
                        $doc->exportField($this->pan);
                        $doc->exportField($this->tan);
                        $doc->exportField($this->msme);
                        $doc->exportField($this->port_air);
                        $doc->exportField($this->port_sea);
                        $doc->exportField($this->iec);
                        $doc->exportField($this->rex);
                        $doc->exportField($this->rcmc);
                        $doc->exportField($this->delivery_terms);
                        $doc->exportField($this->shipping_terms);
                        $doc->exportField($this->payment_terms);
                        $doc->exportField($this->export_type);
                        $doc->exportField($this->lead_time_ss);
                        $doc->exportField($this->lead_time_cs);
                        $doc->exportField($this->cha);
                        $doc->exportField($this->cha_email);
                        $doc->exportField($this->cha_phone);
                        $doc->exportField($this->forwarder);
                        $doc->exportField($this->forwarder_email);
                        $doc->exportField($this->forwarder_phone);
                        $doc->exportField($this->merchant);
                        $doc->exportField($this->merchant_email);
                        $doc->exportField($this->merchant_phone);
                        $doc->exportField($this->shipping_incharge);
                        $doc->exportField($this->shipping_email);
                        $doc->exportField($this->shipping_phone);
                        $doc->exportField($this->account_incharge);
                        $doc->exportField($this->accounts_email);
                        $doc->exportField($this->accounts_phone);
                        $doc->exportField($this->warehouse_incharge);
                        $doc->exportField($this->warehouse_email);
                        $doc->exportField($this->warehouse_phone);
                        $doc->exportField($this->production_incharge);
                        $doc->exportField($this->production_email);
                        $doc->exportField($this->production_phone);
                        $doc->exportField($this->qc_incharge);
                        $doc->exportField($this->qc_email);
                        $doc->exportField($this->qc_phone);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
