<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductionEmployeeSearch extends ProductionEmployee
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductionEmployeeSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "productionemployeesearch";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->uid->Visible = false;
        $this->grp->setVisibility();
        $this->site->setVisibility();
        $this->id->Visible = false;
        $this->user_name->setVisibility();
        $this->salary->setVisibility();
        $this->contractor->setVisibility();
        $this->address->setVisibility();
        $this->mobile->setVisibility();
        $this->category->setVisibility();
        $this->process->setVisibility();
        $this->status->setVisibility();
        $this->employee_name->setVisibility();
        $this->gender->setVisibility();
        $this->father_name->setVisibility();
        $this->designation->setVisibility();
        $this->permanent_address->setVisibility();
        $this->city->setVisibility();
        $this->dob->setVisibility();
        $this->dom->setVisibility();
        $this->mobile_other->setVisibility();
        $this->mobile_family->setVisibility();
        $this->marital_status->setVisibility();
        $this->spouse_details->setVisibility();
        $this->emergency_details->setVisibility();
        $this->pan_no->setVisibility();
        $this->aadhaar_no->setVisibility();
        $this->id_proof->setVisibility();
        $this->reference_details->setVisibility();
        $this->other_details->setVisibility();
        $this->doj->setVisibility();
        $this->doc->Visible = false;
        $this->dol->setVisibility();
        $this->image->setVisibility();
        $this->payment_details->setVisibility();
        $this->bank_name->setVisibility();
        $this->bank_ifsc_code->setVisibility();
        $this->bank_account_no->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->d_operator->setVisibility();
        $this->d_datetime->setVisibility();
        $this->am_id->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'production_employee';
        $this->TableName = 'production_employee';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (production_employee)
        if (!isset($GLOBALS["production_employee"]) || $GLOBALS["production_employee"]::class == PROJECT_NAMESPACE . "production_employee") {
            $GLOBALS["production_employee"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'production_employee');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "productionemployeeview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
                $this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['uid'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->uid->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->site);
        $this->setupLookupOptions($this->contractor);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->gender);
        $this->setupLookupOptions($this->marital_status);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "productionemployeelist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->site); // site
        $this->buildSearchUrl($srchUrl, $this->user_name); // user_name
        $this->buildSearchUrl($srchUrl, $this->salary); // salary
        $this->buildSearchUrl($srchUrl, $this->contractor); // contractor
        $this->buildSearchUrl($srchUrl, $this->address); // address
        $this->buildSearchUrl($srchUrl, $this->mobile); // mobile
        $this->buildSearchUrl($srchUrl, $this->category); // category
        $this->buildSearchUrl($srchUrl, $this->process); // process
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->employee_name); // employee_name
        $this->buildSearchUrl($srchUrl, $this->gender); // gender
        $this->buildSearchUrl($srchUrl, $this->father_name); // father_name
        $this->buildSearchUrl($srchUrl, $this->designation); // designation
        $this->buildSearchUrl($srchUrl, $this->permanent_address); // permanent_address
        $this->buildSearchUrl($srchUrl, $this->city); // city
        $this->buildSearchUrl($srchUrl, $this->dob); // dob
        $this->buildSearchUrl($srchUrl, $this->dom); // dom
        $this->buildSearchUrl($srchUrl, $this->mobile_other); // mobile_other
        $this->buildSearchUrl($srchUrl, $this->mobile_family); // mobile_family
        $this->buildSearchUrl($srchUrl, $this->marital_status); // marital_status
        $this->buildSearchUrl($srchUrl, $this->spouse_details); // spouse_details
        $this->buildSearchUrl($srchUrl, $this->emergency_details); // emergency_details
        $this->buildSearchUrl($srchUrl, $this->pan_no); // pan_no
        $this->buildSearchUrl($srchUrl, $this->aadhaar_no); // aadhaar_no
        $this->buildSearchUrl($srchUrl, $this->id_proof); // id_proof
        $this->buildSearchUrl($srchUrl, $this->reference_details); // reference_details
        $this->buildSearchUrl($srchUrl, $this->other_details); // other_details
        $this->buildSearchUrl($srchUrl, $this->doj); // doj
        $this->buildSearchUrl($srchUrl, $this->dol); // dol
        $this->buildSearchUrl($srchUrl, $this->image); // image
        $this->buildSearchUrl($srchUrl, $this->payment_details); // payment_details
        $this->buildSearchUrl($srchUrl, $this->bank_name); // bank_name
        $this->buildSearchUrl($srchUrl, $this->bank_ifsc_code); // bank_ifsc_code
        $this->buildSearchUrl($srchUrl, $this->bank_account_no); // bank_account_no
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->d_operator); // d_operator
        $this->buildSearchUrl($srchUrl, $this->d_datetime); // d_datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // uid
        if ($this->uid->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->grp->AdvancedSearch->SearchValue)) {
            $this->grp->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->grp->AdvancedSearch->SearchValue);
        }
        if (is_array($this->grp->AdvancedSearch->SearchValue2)) {
            $this->grp->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->grp->AdvancedSearch->SearchValue2);
        }

        // site
        if ($this->site->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->site->AdvancedSearch->SearchValue)) {
            $this->site->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->site->AdvancedSearch->SearchValue);
        }
        if (is_array($this->site->AdvancedSearch->SearchValue2)) {
            $this->site->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->site->AdvancedSearch->SearchValue2);
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // user_name
        if ($this->user_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // salary
        if ($this->salary->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // contractor
        if ($this->contractor->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // address
        if ($this->address->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // mobile
        if ($this->mobile->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // process
        if ($this->process->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->process->AdvancedSearch->SearchValue)) {
            $this->process->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->process->AdvancedSearch->SearchValue);
        }
        if (is_array($this->process->AdvancedSearch->SearchValue2)) {
            $this->process->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->process->AdvancedSearch->SearchValue2);
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // employee_name
        if ($this->employee_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // gender
        if ($this->gender->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // father_name
        if ($this->father_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // designation
        if ($this->designation->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // permanent_address
        if ($this->permanent_address->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // city
        if ($this->city->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // dob
        if ($this->dob->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // dom
        if ($this->dom->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // mobile_other
        if ($this->mobile_other->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // mobile_family
        if ($this->mobile_family->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // marital_status
        if ($this->marital_status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // spouse_details
        if ($this->spouse_details->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // emergency_details
        if ($this->emergency_details->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pan_no
        if ($this->pan_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // aadhaar_no
        if ($this->aadhaar_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // id_proof
        if ($this->id_proof->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // reference_details
        if ($this->reference_details->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // other_details
        if ($this->other_details->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // doj
        if ($this->doj->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // dol
        if ($this->dol->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // image
        if ($this->image->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // payment_details
        if ($this->payment_details->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // bank_name
        if ($this->bank_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // bank_ifsc_code
        if ($this->bank_ifsc_code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // bank_account_no
        if ($this->bank_account_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_operator
        if ($this->d_operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_datetime
        if ($this->d_datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // uid
        $this->uid->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // site
        $this->site->RowCssClass = "row";

        // id
        $this->id->RowCssClass = "row";

        // user_name
        $this->user_name->RowCssClass = "row";

        // salary
        $this->salary->RowCssClass = "row";

        // contractor
        $this->contractor->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // employee_name
        $this->employee_name->RowCssClass = "row";

        // gender
        $this->gender->RowCssClass = "row";

        // father_name
        $this->father_name->RowCssClass = "row";

        // designation
        $this->designation->RowCssClass = "row";

        // permanent_address
        $this->permanent_address->RowCssClass = "row";

        // city
        $this->city->RowCssClass = "row";

        // dob
        $this->dob->RowCssClass = "row";

        // dom
        $this->dom->RowCssClass = "row";

        // mobile_other
        $this->mobile_other->RowCssClass = "row";

        // mobile_family
        $this->mobile_family->RowCssClass = "row";

        // marital_status
        $this->marital_status->RowCssClass = "row";

        // spouse_details
        $this->spouse_details->RowCssClass = "row";

        // emergency_details
        $this->emergency_details->RowCssClass = "row";

        // pan_no
        $this->pan_no->RowCssClass = "row";

        // aadhaar_no
        $this->aadhaar_no->RowCssClass = "row";

        // id_proof
        $this->id_proof->RowCssClass = "row";

        // reference_details
        $this->reference_details->RowCssClass = "row";

        // other_details
        $this->other_details->RowCssClass = "row";

        // doj
        $this->doj->RowCssClass = "row";

        // doc
        $this->doc->RowCssClass = "row";

        // dol
        $this->dol->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // payment_details
        $this->payment_details->RowCssClass = "row";

        // bank_name
        $this->bank_name->RowCssClass = "row";

        // bank_ifsc_code
        $this->bank_ifsc_code->RowCssClass = "row";

        // bank_account_no
        $this->bank_account_no->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // d_operator
        $this->d_operator->RowCssClass = "row";

        // d_datetime
        $this->d_datetime->RowCssClass = "row";

        // am_id
        $this->am_id->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // uid
            $this->uid->ViewValue = $this->uid->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->grp->Lookup->renderViewRow($row);
                            $this->grp->ViewValue->add($this->grp->displayValue($arwrk));
                        }
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // site
            $curVal = strval($this->site->CurrentValue);
            if ($curVal != "") {
                $this->site->ViewValue = $this->site->lookupCacheOption($curVal);
                if ($this->site->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->site->getSelectFilter($this); // PHP
                    $sqlWrk = $this->site->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->site->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->site->Lookup->renderViewRow($row);
                            $this->site->ViewValue->add($this->site->displayValue($arwrk));
                        }
                    } else {
                        $this->site->ViewValue = $this->site->CurrentValue;
                    }
                }
            } else {
                $this->site->ViewValue = null;
            }

            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // user_name
            $this->user_name->ViewValue = $this->user_name->CurrentValue;

            // salary
            $this->salary->ViewValue = $this->salary->CurrentValue;
            $this->salary->ViewValue = FormatNumber($this->salary->ViewValue, $this->salary->formatPattern());

            // contractor
            $curVal = strval($this->contractor->CurrentValue);
            if ($curVal != "") {
                $this->contractor->ViewValue = $this->contractor->lookupCacheOption($curVal);
                if ($this->contractor->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->contractor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->contractor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->contractor->getSelectFilter($this); // PHP
                    $sqlWrk = $this->contractor->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->contractor->Lookup->renderViewRow($rswrk[0]);
                        $this->contractor->ViewValue = $this->contractor->displayValue($arwrk);
                    } else {
                        $this->contractor->ViewValue = FormatNumber($this->contractor->CurrentValue, $this->contractor->formatPattern());
                    }
                }
            } else {
                $this->contractor->ViewValue = null;
            }

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, $this->mobile->formatPattern());

            // category
            if (strval($this->category->CurrentValue) != "") {
                $this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
            } else {
                $this->category->ViewValue = null;
            }

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process->Lookup->renderViewRow($row);
                            $this->process->ViewValue->add($this->process->displayValue($arwrk));
                        }
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // employee_name
            $this->employee_name->ViewValue = $this->employee_name->CurrentValue;

            // gender
            if (strval($this->gender->CurrentValue) != "") {
                $this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
            } else {
                $this->gender->ViewValue = null;
            }

            // father_name
            $this->father_name->ViewValue = $this->father_name->CurrentValue;

            // designation
            $this->designation->ViewValue = $this->designation->CurrentValue;

            // permanent_address
            $this->permanent_address->ViewValue = $this->permanent_address->CurrentValue;

            // city
            $this->city->ViewValue = $this->city->CurrentValue;

            // dob
            $this->dob->ViewValue = $this->dob->CurrentValue;
            $this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, $this->dob->formatPattern());

            // dom
            $this->dom->ViewValue = $this->dom->CurrentValue;
            $this->dom->ViewValue = FormatDateTime($this->dom->ViewValue, $this->dom->formatPattern());

            // mobile_other
            $this->mobile_other->ViewValue = $this->mobile_other->CurrentValue;

            // mobile_family
            $this->mobile_family->ViewValue = $this->mobile_family->CurrentValue;

            // marital_status
            if (strval($this->marital_status->CurrentValue) != "") {
                $this->marital_status->ViewValue = $this->marital_status->optionCaption($this->marital_status->CurrentValue);
            } else {
                $this->marital_status->ViewValue = null;
            }

            // spouse_details
            $this->spouse_details->ViewValue = $this->spouse_details->CurrentValue;

            // emergency_details
            $this->emergency_details->ViewValue = $this->emergency_details->CurrentValue;

            // pan_no
            $this->pan_no->ViewValue = $this->pan_no->CurrentValue;

            // aadhaar_no
            $this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;

            // id_proof
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
            } else {
                $this->id_proof->ViewValue = "";
            }

            // reference_details
            $this->reference_details->ViewValue = $this->reference_details->CurrentValue;

            // other_details
            $this->other_details->ViewValue = $this->other_details->CurrentValue;

            // doj
            $this->doj->ViewValue = $this->doj->CurrentValue;
            $this->doj->ViewValue = FormatDateTime($this->doj->ViewValue, $this->doj->formatPattern());

            // dol
            $this->dol->ViewValue = $this->dol->CurrentValue;
            $this->dol->ViewValue = FormatDateTime($this->dol->ViewValue, $this->dol->formatPattern());

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // payment_details
            $this->payment_details->ViewValue = $this->payment_details->CurrentValue;

            // bank_name
            $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

            // bank_ifsc_code
            $this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;

            // bank_account_no
            $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // d_operator
            $this->d_operator->ViewValue = $this->d_operator->CurrentValue;
            $this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, $this->d_operator->formatPattern());

            // d_datetime
            $this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
            $this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, $this->d_datetime->formatPattern());

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // site
            if (!EmptyValue($this->site->CurrentValue)) {
                $this->site->HrefValue = $this->site->getLinkPrefix() . $this->site->CurrentValue; // Add prefix/suffix
                $this->site->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->site->HrefValue = FullUrl($this->site->HrefValue, "href");
                }
            } else {
                $this->site->HrefValue = "";
            }
            $this->site->TooltipValue = "";

            // user_name
            $this->user_name->HrefValue = "";
            $this->user_name->TooltipValue = "";

            // salary
            $this->salary->HrefValue = "";
            $this->salary->TooltipValue = "";

            // contractor
            $this->contractor->HrefValue = "";
            $this->contractor->TooltipValue = "";

            // address
            $this->address->HrefValue = "";
            $this->address->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // process
            $this->process->HrefValue = "";
            $this->process->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // employee_name
            $this->employee_name->HrefValue = "";
            $this->employee_name->TooltipValue = "";

            // gender
            $this->gender->HrefValue = "";
            $this->gender->TooltipValue = "";

            // father_name
            $this->father_name->HrefValue = "";
            $this->father_name->TooltipValue = "";

            // designation
            $this->designation->HrefValue = "";
            $this->designation->TooltipValue = "";

            // permanent_address
            $this->permanent_address->HrefValue = "";
            $this->permanent_address->TooltipValue = "";

            // city
            $this->city->HrefValue = "";
            $this->city->TooltipValue = "";

            // dob
            $this->dob->HrefValue = "";
            $this->dob->TooltipValue = "";

            // dom
            $this->dom->HrefValue = "";
            $this->dom->TooltipValue = "";

            // mobile_other
            $this->mobile_other->HrefValue = "";
            $this->mobile_other->TooltipValue = "";

            // mobile_family
            $this->mobile_family->HrefValue = "";
            $this->mobile_family->TooltipValue = "";

            // marital_status
            $this->marital_status->HrefValue = "";
            $this->marital_status->TooltipValue = "";

            // spouse_details
            $this->spouse_details->HrefValue = "";
            $this->spouse_details->TooltipValue = "";

            // emergency_details
            $this->emergency_details->HrefValue = "";
            $this->emergency_details->TooltipValue = "";

            // pan_no
            $this->pan_no->HrefValue = "";
            $this->pan_no->TooltipValue = "";

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";
            $this->aadhaar_no->TooltipValue = "";

            // id_proof
            $this->id_proof->HrefValue = "";
            $this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;
            $this->id_proof->TooltipValue = "";

            // reference_details
            $this->reference_details->HrefValue = "";
            $this->reference_details->TooltipValue = "";

            // other_details
            $this->other_details->HrefValue = "";
            $this->other_details->TooltipValue = "";

            // doj
            $this->doj->HrefValue = "";
            $this->doj->TooltipValue = "";

            // dol
            $this->dol->HrefValue = "";
            $this->dol->TooltipValue = "";

            // image
            $this->image->HrefValue = "";
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
            $this->image->TooltipValue = "";

            // payment_details
            $this->payment_details->HrefValue = "";
            $this->payment_details->TooltipValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";
            $this->bank_name->TooltipValue = "";

            // bank_ifsc_code
            $this->bank_ifsc_code->HrefValue = "";
            $this->bank_ifsc_code->TooltipValue = "";

            // bank_account_no
            $this->bank_account_no->HrefValue = "";
            $this->bank_account_no->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // d_operator
            $this->d_operator->HrefValue = "";
            $this->d_operator->TooltipValue = "";

            // d_datetime
            $this->d_datetime->HrefValue = "";
            $this->d_datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // grp
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // site
            $this->site->setupEditAttributes();
            $curVal = trim(strval($this->site->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->site->AdvancedSearch->ViewValue = $this->site->lookupCacheOption($curVal);
            } else {
                $this->site->AdvancedSearch->ViewValue = $this->site->Lookup !== null && is_array($this->site->lookupOptions()) && count($this->site->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->site->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->site->EditValue = array_values($this->site->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->site->getSelectFilter($this); // PHP
                $sqlWrk = $this->site->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->site->EditValue = $arwrk;
            }
            $this->site->PlaceHolder = RemoveHtml($this->site->caption());

            // user_name
            $this->user_name->setupEditAttributes();
            if (!$this->user_name->Raw) {
                $this->user_name->AdvancedSearch->SearchValue = HtmlDecode($this->user_name->AdvancedSearch->SearchValue);
            }
            $this->user_name->EditValue = HtmlEncode($this->user_name->AdvancedSearch->SearchValue);
            $this->user_name->PlaceHolder = RemoveHtml($this->user_name->caption());

            // salary
            $this->salary->setupEditAttributes();
            $this->salary->EditValue = $this->salary->AdvancedSearch->SearchValue;
            $this->salary->PlaceHolder = RemoveHtml($this->salary->caption());

            // contractor
            $this->contractor->setupEditAttributes();
            $curVal = trim(strval($this->contractor->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->contractor->AdvancedSearch->ViewValue = $this->contractor->lookupCacheOption($curVal);
            } else {
                $this->contractor->AdvancedSearch->ViewValue = $this->contractor->Lookup !== null && is_array($this->contractor->lookupOptions()) && count($this->contractor->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->contractor->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->contractor->EditValue = array_values($this->contractor->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->contractor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->contractor->AdvancedSearch->SearchValue, $this->contractor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->contractor->getSelectFilter($this); // PHP
                $sqlWrk = $this->contractor->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->contractor->Lookup->renderViewRow($row);
                }
                $this->contractor->EditValue = $arwrk;
            }
            $this->contractor->PlaceHolder = RemoveHtml($this->contractor->caption());

            // address
            $this->address->setupEditAttributes();
            if (!$this->address->Raw) {
                $this->address->AdvancedSearch->SearchValue = HtmlDecode($this->address->AdvancedSearch->SearchValue);
            }
            $this->address->EditValue = HtmlEncode($this->address->AdvancedSearch->SearchValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            $this->mobile->EditValue = $this->mobile->AdvancedSearch->SearchValue;
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // category
            $this->category->setupEditAttributes();
            $this->category->EditValue = $this->category->options(true);
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // process
            $curVal = trim(strval($this->process->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->process->AdvancedSearch->ViewValue = $this->process->lookupCacheOption($curVal);
            } else {
                $this->process->AdvancedSearch->ViewValue = $this->process->Lookup !== null && is_array($this->process->lookupOptions()) && count($this->process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->process->EditValue = array_values($this->process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process->EditValue = $arwrk;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // employee_name
            $this->employee_name->setupEditAttributes();
            if (!$this->employee_name->Raw) {
                $this->employee_name->AdvancedSearch->SearchValue = HtmlDecode($this->employee_name->AdvancedSearch->SearchValue);
            }
            $this->employee_name->EditValue = HtmlEncode($this->employee_name->AdvancedSearch->SearchValue);
            $this->employee_name->PlaceHolder = RemoveHtml($this->employee_name->caption());

            // gender
            $this->gender->setupEditAttributes();
            $this->gender->EditValue = $this->gender->options(true);
            $this->gender->PlaceHolder = RemoveHtml($this->gender->caption());

            // father_name
            $this->father_name->setupEditAttributes();
            if (!$this->father_name->Raw) {
                $this->father_name->AdvancedSearch->SearchValue = HtmlDecode($this->father_name->AdvancedSearch->SearchValue);
            }
            $this->father_name->EditValue = HtmlEncode($this->father_name->AdvancedSearch->SearchValue);
            $this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

            // designation
            $this->designation->setupEditAttributes();
            if (!$this->designation->Raw) {
                $this->designation->AdvancedSearch->SearchValue = HtmlDecode($this->designation->AdvancedSearch->SearchValue);
            }
            $this->designation->EditValue = HtmlEncode($this->designation->AdvancedSearch->SearchValue);
            $this->designation->PlaceHolder = RemoveHtml($this->designation->caption());

            // permanent_address
            $this->permanent_address->setupEditAttributes();
            $this->permanent_address->EditValue = HtmlEncode($this->permanent_address->AdvancedSearch->SearchValue);
            $this->permanent_address->PlaceHolder = RemoveHtml($this->permanent_address->caption());

            // city
            $this->city->setupEditAttributes();
            if (!$this->city->Raw) {
                $this->city->AdvancedSearch->SearchValue = HtmlDecode($this->city->AdvancedSearch->SearchValue);
            }
            $this->city->EditValue = HtmlEncode($this->city->AdvancedSearch->SearchValue);
            $this->city->PlaceHolder = RemoveHtml($this->city->caption());

            // dob
            $this->dob->setupEditAttributes();
            $this->dob->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dob->AdvancedSearch->SearchValue, $this->dob->formatPattern()), $this->dob->formatPattern()));
            $this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

            // dom
            $this->dom->setupEditAttributes();
            $this->dom->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dom->AdvancedSearch->SearchValue, $this->dom->formatPattern()), $this->dom->formatPattern()));
            $this->dom->PlaceHolder = RemoveHtml($this->dom->caption());

            // mobile_other
            $this->mobile_other->setupEditAttributes();
            if (!$this->mobile_other->Raw) {
                $this->mobile_other->AdvancedSearch->SearchValue = HtmlDecode($this->mobile_other->AdvancedSearch->SearchValue);
            }
            $this->mobile_other->EditValue = HtmlEncode($this->mobile_other->AdvancedSearch->SearchValue);
            $this->mobile_other->PlaceHolder = RemoveHtml($this->mobile_other->caption());

            // mobile_family
            $this->mobile_family->setupEditAttributes();
            if (!$this->mobile_family->Raw) {
                $this->mobile_family->AdvancedSearch->SearchValue = HtmlDecode($this->mobile_family->AdvancedSearch->SearchValue);
            }
            $this->mobile_family->EditValue = HtmlEncode($this->mobile_family->AdvancedSearch->SearchValue);
            $this->mobile_family->PlaceHolder = RemoveHtml($this->mobile_family->caption());

            // marital_status
            $this->marital_status->setupEditAttributes();
            $this->marital_status->EditValue = $this->marital_status->options(true);
            $this->marital_status->PlaceHolder = RemoveHtml($this->marital_status->caption());

            // spouse_details
            $this->spouse_details->setupEditAttributes();
            if (!$this->spouse_details->Raw) {
                $this->spouse_details->AdvancedSearch->SearchValue = HtmlDecode($this->spouse_details->AdvancedSearch->SearchValue);
            }
            $this->spouse_details->EditValue = HtmlEncode($this->spouse_details->AdvancedSearch->SearchValue);
            $this->spouse_details->PlaceHolder = RemoveHtml($this->spouse_details->caption());

            // emergency_details
            $this->emergency_details->setupEditAttributes();
            if (!$this->emergency_details->Raw) {
                $this->emergency_details->AdvancedSearch->SearchValue = HtmlDecode($this->emergency_details->AdvancedSearch->SearchValue);
            }
            $this->emergency_details->EditValue = HtmlEncode($this->emergency_details->AdvancedSearch->SearchValue);
            $this->emergency_details->PlaceHolder = RemoveHtml($this->emergency_details->caption());

            // pan_no
            $this->pan_no->setupEditAttributes();
            if (!$this->pan_no->Raw) {
                $this->pan_no->AdvancedSearch->SearchValue = HtmlDecode($this->pan_no->AdvancedSearch->SearchValue);
            }
            $this->pan_no->EditValue = HtmlEncode($this->pan_no->AdvancedSearch->SearchValue);
            $this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

            // aadhaar_no
            $this->aadhaar_no->setupEditAttributes();
            if (!$this->aadhaar_no->Raw) {
                $this->aadhaar_no->AdvancedSearch->SearchValue = HtmlDecode($this->aadhaar_no->AdvancedSearch->SearchValue);
            }
            $this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->AdvancedSearch->SearchValue);
            $this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

            // id_proof
            $this->id_proof->setupEditAttributes();
            if (!$this->id_proof->Raw) {
                $this->id_proof->AdvancedSearch->SearchValue = HtmlDecode($this->id_proof->AdvancedSearch->SearchValue);
            }
            $this->id_proof->EditValue = HtmlEncode($this->id_proof->AdvancedSearch->SearchValue);
            $this->id_proof->PlaceHolder = RemoveHtml($this->id_proof->caption());

            // reference_details
            $this->reference_details->setupEditAttributes();
            if (!$this->reference_details->Raw) {
                $this->reference_details->AdvancedSearch->SearchValue = HtmlDecode($this->reference_details->AdvancedSearch->SearchValue);
            }
            $this->reference_details->EditValue = HtmlEncode($this->reference_details->AdvancedSearch->SearchValue);
            $this->reference_details->PlaceHolder = RemoveHtml($this->reference_details->caption());

            // other_details
            $this->other_details->setupEditAttributes();
            $this->other_details->EditValue = HtmlEncode($this->other_details->AdvancedSearch->SearchValue);
            $this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

            // doj
            $this->doj->setupEditAttributes();
            $this->doj->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->doj->AdvancedSearch->SearchValue, $this->doj->formatPattern()), $this->doj->formatPattern()));
            $this->doj->PlaceHolder = RemoveHtml($this->doj->caption());

            // dol
            $this->dol->setupEditAttributes();
            $this->dol->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dol->AdvancedSearch->SearchValue, $this->dol->formatPattern()), $this->dol->formatPattern()));
            $this->dol->PlaceHolder = RemoveHtml($this->dol->caption());

            // image
            $this->image->setupEditAttributes();
            if (!$this->image->Raw) {
                $this->image->AdvancedSearch->SearchValue = HtmlDecode($this->image->AdvancedSearch->SearchValue);
            }
            $this->image->EditValue = HtmlEncode($this->image->AdvancedSearch->SearchValue);
            $this->image->PlaceHolder = RemoveHtml($this->image->caption());

            // payment_details
            $this->payment_details->setupEditAttributes();
            $this->payment_details->EditValue = HtmlEncode($this->payment_details->AdvancedSearch->SearchValue);
            $this->payment_details->PlaceHolder = RemoveHtml($this->payment_details->caption());

            // bank_name
            $this->bank_name->setupEditAttributes();
            if (!$this->bank_name->Raw) {
                $this->bank_name->AdvancedSearch->SearchValue = HtmlDecode($this->bank_name->AdvancedSearch->SearchValue);
            }
            $this->bank_name->EditValue = HtmlEncode($this->bank_name->AdvancedSearch->SearchValue);
            $this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

            // bank_ifsc_code
            $this->bank_ifsc_code->setupEditAttributes();
            if (!$this->bank_ifsc_code->Raw) {
                $this->bank_ifsc_code->AdvancedSearch->SearchValue = HtmlDecode($this->bank_ifsc_code->AdvancedSearch->SearchValue);
            }
            $this->bank_ifsc_code->EditValue = HtmlEncode($this->bank_ifsc_code->AdvancedSearch->SearchValue);
            $this->bank_ifsc_code->PlaceHolder = RemoveHtml($this->bank_ifsc_code->caption());

            // bank_account_no
            $this->bank_account_no->setupEditAttributes();
            if (!$this->bank_account_no->Raw) {
                $this->bank_account_no->AdvancedSearch->SearchValue = HtmlDecode($this->bank_account_no->AdvancedSearch->SearchValue);
            }
            $this->bank_account_no->EditValue = HtmlEncode($this->bank_account_no->AdvancedSearch->SearchValue);
            $this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // d_operator
            $this->d_operator->setupEditAttributes();
            $this->d_operator->EditValue = $this->d_operator->AdvancedSearch->SearchValue;
            $this->d_operator->PlaceHolder = RemoveHtml($this->d_operator->caption());

            // d_datetime
            $this->d_datetime->setupEditAttributes();
            $this->d_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->d_datetime->AdvancedSearch->SearchValue, $this->d_datetime->formatPattern()), $this->d_datetime->formatPattern()));
            $this->d_datetime->PlaceHolder = RemoveHtml($this->d_datetime->caption());
            $this->d_datetime->setupEditAttributes();
            $this->d_datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->d_datetime->AdvancedSearch->SearchValue2, $this->d_datetime->formatPattern()), $this->d_datetime->formatPattern()));
            $this->d_datetime->PlaceHolder = RemoveHtml($this->d_datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->uid->AdvancedSearch->SearchValue)) {
            $this->uid->addErrorMessage($this->uid->getErrorMessage(false));
        }
        if (!CheckInteger($this->uid->AdvancedSearch->SearchValue2)) {
            $this->uid->addErrorMessage($this->uid->getErrorMessage(false));
        }
        if (!CheckInteger($this->salary->AdvancedSearch->SearchValue)) {
            $this->salary->addErrorMessage($this->salary->getErrorMessage(false));
        }
        if (!CheckInteger($this->mobile->AdvancedSearch->SearchValue)) {
            $this->mobile->addErrorMessage($this->mobile->getErrorMessage(false));
        }
        if (!CheckDate($this->dob->AdvancedSearch->SearchValue, $this->dob->formatPattern())) {
            $this->dob->addErrorMessage($this->dob->getErrorMessage(false));
        }
        if (!CheckDate($this->dom->AdvancedSearch->SearchValue, $this->dom->formatPattern())) {
            $this->dom->addErrorMessage($this->dom->getErrorMessage(false));
        }
        if (!CheckDate($this->doj->AdvancedSearch->SearchValue, $this->doj->formatPattern())) {
            $this->doj->addErrorMessage($this->doj->getErrorMessage(false));
        }
        if (!CheckDate($this->dol->AdvancedSearch->SearchValue, $this->dol->formatPattern())) {
            $this->dol->addErrorMessage($this->dol->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->d_operator->AdvancedSearch->SearchValue)) {
            $this->d_operator->addErrorMessage($this->d_operator->getErrorMessage(false));
        }
        if (!CheckDate($this->d_datetime->AdvancedSearch->SearchValue, $this->d_datetime->formatPattern())) {
            $this->d_datetime->addErrorMessage($this->d_datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->d_datetime->AdvancedSearch->SearchValue2, $this->d_datetime->formatPattern())) {
            $this->d_datetime->addErrorMessage($this->d_datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->uid->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->site->AdvancedSearch->load();
        $this->id->AdvancedSearch->load();
        $this->user_name->AdvancedSearch->load();
        $this->salary->AdvancedSearch->load();
        $this->contractor->AdvancedSearch->load();
        $this->address->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->process->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->employee_name->AdvancedSearch->load();
        $this->gender->AdvancedSearch->load();
        $this->father_name->AdvancedSearch->load();
        $this->designation->AdvancedSearch->load();
        $this->permanent_address->AdvancedSearch->load();
        $this->city->AdvancedSearch->load();
        $this->dob->AdvancedSearch->load();
        $this->dom->AdvancedSearch->load();
        $this->mobile_other->AdvancedSearch->load();
        $this->mobile_family->AdvancedSearch->load();
        $this->marital_status->AdvancedSearch->load();
        $this->spouse_details->AdvancedSearch->load();
        $this->emergency_details->AdvancedSearch->load();
        $this->pan_no->AdvancedSearch->load();
        $this->aadhaar_no->AdvancedSearch->load();
        $this->id_proof->AdvancedSearch->load();
        $this->reference_details->AdvancedSearch->load();
        $this->other_details->AdvancedSearch->load();
        $this->doj->AdvancedSearch->load();
        $this->dol->AdvancedSearch->load();
        $this->image->AdvancedSearch->load();
        $this->payment_details->AdvancedSearch->load();
        $this->bank_name->AdvancedSearch->load();
        $this->bank_ifsc_code->AdvancedSearch->load();
        $this->bank_account_no->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->d_operator->AdvancedSearch->load();
        $this->d_datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("productionemployeelist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_site":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_contractor":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_gender":
                    break;
                case "x_marital_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
