<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductionEmployeeList extends ProductionEmployee
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductionEmployeeList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fproduction_employeelist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "productionemployeelist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->uid->setVisibility();
        $this->grp->setVisibility();
        $this->site->setVisibility();
        $this->id->setVisibility();
        $this->user_name->setVisibility();
        $this->salary->setVisibility();
        $this->contractor->setVisibility();
        $this->address->Visible = false;
        $this->mobile->setVisibility();
        $this->category->Visible = false;
        $this->process->setVisibility();
        $this->status->setVisibility();
        $this->employee_name->setVisibility();
        $this->gender->setVisibility();
        $this->father_name->setVisibility();
        $this->designation->setVisibility();
        $this->permanent_address->setVisibility();
        $this->city->setVisibility();
        $this->dob->setVisibility();
        $this->dom->setVisibility();
        $this->mobile_other->setVisibility();
        $this->mobile_family->setVisibility();
        $this->marital_status->setVisibility();
        $this->spouse_details->setVisibility();
        $this->emergency_details->setVisibility();
        $this->pan_no->setVisibility();
        $this->aadhaar_no->setVisibility();
        $this->id_proof->setVisibility();
        $this->reference_details->setVisibility();
        $this->other_details->Visible = false;
        $this->doj->setVisibility();
        $this->doc->Visible = false;
        $this->dol->setVisibility();
        $this->image->setVisibility();
        $this->payment_details->Visible = false;
        $this->bank_name->setVisibility();
        $this->bank_ifsc_code->setVisibility();
        $this->bank_account_no->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->d_operator->setVisibility();
        $this->d_datetime->setVisibility();
        $this->am_id->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'production_employee';
        $this->TableName = 'production_employee';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (production_employee)
        if (!isset($GLOBALS["production_employee"]) || $GLOBALS["production_employee"]::class == PROJECT_NAMESPACE . "production_employee") {
            $GLOBALS["production_employee"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "productionemployeeadd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "productionemployeedelete";
        $this->MultiUpdateUrl = "productionemployeeupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'production_employee');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "productionemployeeview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
                $this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['uid'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->uid->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->d_operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->d_datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "20,50,100,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->site);
        $this->setupLookupOptions($this->contractor);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->gender);
        $this->setupLookupOptions($this->marital_status);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fproduction_employeegrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);

        // Export selected records
        if ($this->isExport()) {
            $this->CurrentFilter = $this->buildExportSelectedFilter();
        }
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }

            // Audit trail on search
            if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
                $searchParm = ServerVar("QUERY_STRING");
                $searchSql = $this->getSessionWhere();
                $this->writeAuditTrailOnSearch($searchParm, $searchSql);
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fproduction_employeesrch");
        }
        $filterList = Concat($filterList, $this->uid->AdvancedSearch->toJson(), ","); // Field uid
        $filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
        $filterList = Concat($filterList, $this->site->AdvancedSearch->toJson(), ","); // Field site
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->user_name->AdvancedSearch->toJson(), ","); // Field user_name
        $filterList = Concat($filterList, $this->salary->AdvancedSearch->toJson(), ","); // Field salary
        $filterList = Concat($filterList, $this->contractor->AdvancedSearch->toJson(), ","); // Field contractor
        $filterList = Concat($filterList, $this->address->AdvancedSearch->toJson(), ","); // Field address
        $filterList = Concat($filterList, $this->mobile->AdvancedSearch->toJson(), ","); // Field mobile
        $filterList = Concat($filterList, $this->category->AdvancedSearch->toJson(), ","); // Field category
        $filterList = Concat($filterList, $this->process->AdvancedSearch->toJson(), ","); // Field process
        $filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
        $filterList = Concat($filterList, $this->employee_name->AdvancedSearch->toJson(), ","); // Field employee_name
        $filterList = Concat($filterList, $this->gender->AdvancedSearch->toJson(), ","); // Field gender
        $filterList = Concat($filterList, $this->father_name->AdvancedSearch->toJson(), ","); // Field father_name
        $filterList = Concat($filterList, $this->designation->AdvancedSearch->toJson(), ","); // Field designation
        $filterList = Concat($filterList, $this->permanent_address->AdvancedSearch->toJson(), ","); // Field permanent_address
        $filterList = Concat($filterList, $this->city->AdvancedSearch->toJson(), ","); // Field city
        $filterList = Concat($filterList, $this->dob->AdvancedSearch->toJson(), ","); // Field dob
        $filterList = Concat($filterList, $this->dom->AdvancedSearch->toJson(), ","); // Field dom
        $filterList = Concat($filterList, $this->mobile_other->AdvancedSearch->toJson(), ","); // Field mobile_other
        $filterList = Concat($filterList, $this->mobile_family->AdvancedSearch->toJson(), ","); // Field mobile_family
        $filterList = Concat($filterList, $this->marital_status->AdvancedSearch->toJson(), ","); // Field marital_status
        $filterList = Concat($filterList, $this->spouse_details->AdvancedSearch->toJson(), ","); // Field spouse_details
        $filterList = Concat($filterList, $this->emergency_details->AdvancedSearch->toJson(), ","); // Field emergency_details
        $filterList = Concat($filterList, $this->pan_no->AdvancedSearch->toJson(), ","); // Field pan_no
        $filterList = Concat($filterList, $this->aadhaar_no->AdvancedSearch->toJson(), ","); // Field aadhaar_no
        $filterList = Concat($filterList, $this->id_proof->AdvancedSearch->toJson(), ","); // Field id_proof
        $filterList = Concat($filterList, $this->reference_details->AdvancedSearch->toJson(), ","); // Field reference_details
        $filterList = Concat($filterList, $this->other_details->AdvancedSearch->toJson(), ","); // Field other_details
        $filterList = Concat($filterList, $this->doj->AdvancedSearch->toJson(), ","); // Field doj
        $filterList = Concat($filterList, $this->dol->AdvancedSearch->toJson(), ","); // Field dol
        $filterList = Concat($filterList, $this->image->AdvancedSearch->toJson(), ","); // Field image
        $filterList = Concat($filterList, $this->payment_details->AdvancedSearch->toJson(), ","); // Field payment_details
        $filterList = Concat($filterList, $this->bank_name->AdvancedSearch->toJson(), ","); // Field bank_name
        $filterList = Concat($filterList, $this->bank_ifsc_code->AdvancedSearch->toJson(), ","); // Field bank_ifsc_code
        $filterList = Concat($filterList, $this->bank_account_no->AdvancedSearch->toJson(), ","); // Field bank_account_no
        $filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
        $filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
        $filterList = Concat($filterList, $this->d_operator->AdvancedSearch->toJson(), ","); // Field d_operator
        $filterList = Concat($filterList, $this->d_datetime->AdvancedSearch->toJson(), ","); // Field d_datetime
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fproduction_employeesrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field uid
        $this->uid->AdvancedSearch->SearchValue = @$filter["x_uid"];
        $this->uid->AdvancedSearch->SearchOperator = @$filter["z_uid"];
        $this->uid->AdvancedSearch->SearchCondition = @$filter["v_uid"];
        $this->uid->AdvancedSearch->SearchValue2 = @$filter["y_uid"];
        $this->uid->AdvancedSearch->SearchOperator2 = @$filter["w_uid"];
        $this->uid->AdvancedSearch->save();

        // Field grp
        $this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
        $this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
        $this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
        $this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
        $this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
        $this->grp->AdvancedSearch->save();

        // Field site
        $this->site->AdvancedSearch->SearchValue = @$filter["x_site"];
        $this->site->AdvancedSearch->SearchOperator = @$filter["z_site"];
        $this->site->AdvancedSearch->SearchCondition = @$filter["v_site"];
        $this->site->AdvancedSearch->SearchValue2 = @$filter["y_site"];
        $this->site->AdvancedSearch->SearchOperator2 = @$filter["w_site"];
        $this->site->AdvancedSearch->save();

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field user_name
        $this->user_name->AdvancedSearch->SearchValue = @$filter["x_user_name"];
        $this->user_name->AdvancedSearch->SearchOperator = @$filter["z_user_name"];
        $this->user_name->AdvancedSearch->SearchCondition = @$filter["v_user_name"];
        $this->user_name->AdvancedSearch->SearchValue2 = @$filter["y_user_name"];
        $this->user_name->AdvancedSearch->SearchOperator2 = @$filter["w_user_name"];
        $this->user_name->AdvancedSearch->save();

        // Field salary
        $this->salary->AdvancedSearch->SearchValue = @$filter["x_salary"];
        $this->salary->AdvancedSearch->SearchOperator = @$filter["z_salary"];
        $this->salary->AdvancedSearch->SearchCondition = @$filter["v_salary"];
        $this->salary->AdvancedSearch->SearchValue2 = @$filter["y_salary"];
        $this->salary->AdvancedSearch->SearchOperator2 = @$filter["w_salary"];
        $this->salary->AdvancedSearch->save();

        // Field contractor
        $this->contractor->AdvancedSearch->SearchValue = @$filter["x_contractor"];
        $this->contractor->AdvancedSearch->SearchOperator = @$filter["z_contractor"];
        $this->contractor->AdvancedSearch->SearchCondition = @$filter["v_contractor"];
        $this->contractor->AdvancedSearch->SearchValue2 = @$filter["y_contractor"];
        $this->contractor->AdvancedSearch->SearchOperator2 = @$filter["w_contractor"];
        $this->contractor->AdvancedSearch->save();

        // Field address
        $this->address->AdvancedSearch->SearchValue = @$filter["x_address"];
        $this->address->AdvancedSearch->SearchOperator = @$filter["z_address"];
        $this->address->AdvancedSearch->SearchCondition = @$filter["v_address"];
        $this->address->AdvancedSearch->SearchValue2 = @$filter["y_address"];
        $this->address->AdvancedSearch->SearchOperator2 = @$filter["w_address"];
        $this->address->AdvancedSearch->save();

        // Field mobile
        $this->mobile->AdvancedSearch->SearchValue = @$filter["x_mobile"];
        $this->mobile->AdvancedSearch->SearchOperator = @$filter["z_mobile"];
        $this->mobile->AdvancedSearch->SearchCondition = @$filter["v_mobile"];
        $this->mobile->AdvancedSearch->SearchValue2 = @$filter["y_mobile"];
        $this->mobile->AdvancedSearch->SearchOperator2 = @$filter["w_mobile"];
        $this->mobile->AdvancedSearch->save();

        // Field category
        $this->category->AdvancedSearch->SearchValue = @$filter["x_category"];
        $this->category->AdvancedSearch->SearchOperator = @$filter["z_category"];
        $this->category->AdvancedSearch->SearchCondition = @$filter["v_category"];
        $this->category->AdvancedSearch->SearchValue2 = @$filter["y_category"];
        $this->category->AdvancedSearch->SearchOperator2 = @$filter["w_category"];
        $this->category->AdvancedSearch->save();

        // Field process
        $this->process->AdvancedSearch->SearchValue = @$filter["x_process"];
        $this->process->AdvancedSearch->SearchOperator = @$filter["z_process"];
        $this->process->AdvancedSearch->SearchCondition = @$filter["v_process"];
        $this->process->AdvancedSearch->SearchValue2 = @$filter["y_process"];
        $this->process->AdvancedSearch->SearchOperator2 = @$filter["w_process"];
        $this->process->AdvancedSearch->save();

        // Field status
        $this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
        $this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
        $this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
        $this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
        $this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
        $this->status->AdvancedSearch->save();

        // Field employee_name
        $this->employee_name->AdvancedSearch->SearchValue = @$filter["x_employee_name"];
        $this->employee_name->AdvancedSearch->SearchOperator = @$filter["z_employee_name"];
        $this->employee_name->AdvancedSearch->SearchCondition = @$filter["v_employee_name"];
        $this->employee_name->AdvancedSearch->SearchValue2 = @$filter["y_employee_name"];
        $this->employee_name->AdvancedSearch->SearchOperator2 = @$filter["w_employee_name"];
        $this->employee_name->AdvancedSearch->save();

        // Field gender
        $this->gender->AdvancedSearch->SearchValue = @$filter["x_gender"];
        $this->gender->AdvancedSearch->SearchOperator = @$filter["z_gender"];
        $this->gender->AdvancedSearch->SearchCondition = @$filter["v_gender"];
        $this->gender->AdvancedSearch->SearchValue2 = @$filter["y_gender"];
        $this->gender->AdvancedSearch->SearchOperator2 = @$filter["w_gender"];
        $this->gender->AdvancedSearch->save();

        // Field father_name
        $this->father_name->AdvancedSearch->SearchValue = @$filter["x_father_name"];
        $this->father_name->AdvancedSearch->SearchOperator = @$filter["z_father_name"];
        $this->father_name->AdvancedSearch->SearchCondition = @$filter["v_father_name"];
        $this->father_name->AdvancedSearch->SearchValue2 = @$filter["y_father_name"];
        $this->father_name->AdvancedSearch->SearchOperator2 = @$filter["w_father_name"];
        $this->father_name->AdvancedSearch->save();

        // Field designation
        $this->designation->AdvancedSearch->SearchValue = @$filter["x_designation"];
        $this->designation->AdvancedSearch->SearchOperator = @$filter["z_designation"];
        $this->designation->AdvancedSearch->SearchCondition = @$filter["v_designation"];
        $this->designation->AdvancedSearch->SearchValue2 = @$filter["y_designation"];
        $this->designation->AdvancedSearch->SearchOperator2 = @$filter["w_designation"];
        $this->designation->AdvancedSearch->save();

        // Field permanent_address
        $this->permanent_address->AdvancedSearch->SearchValue = @$filter["x_permanent_address"];
        $this->permanent_address->AdvancedSearch->SearchOperator = @$filter["z_permanent_address"];
        $this->permanent_address->AdvancedSearch->SearchCondition = @$filter["v_permanent_address"];
        $this->permanent_address->AdvancedSearch->SearchValue2 = @$filter["y_permanent_address"];
        $this->permanent_address->AdvancedSearch->SearchOperator2 = @$filter["w_permanent_address"];
        $this->permanent_address->AdvancedSearch->save();

        // Field city
        $this->city->AdvancedSearch->SearchValue = @$filter["x_city"];
        $this->city->AdvancedSearch->SearchOperator = @$filter["z_city"];
        $this->city->AdvancedSearch->SearchCondition = @$filter["v_city"];
        $this->city->AdvancedSearch->SearchValue2 = @$filter["y_city"];
        $this->city->AdvancedSearch->SearchOperator2 = @$filter["w_city"];
        $this->city->AdvancedSearch->save();

        // Field dob
        $this->dob->AdvancedSearch->SearchValue = @$filter["x_dob"];
        $this->dob->AdvancedSearch->SearchOperator = @$filter["z_dob"];
        $this->dob->AdvancedSearch->SearchCondition = @$filter["v_dob"];
        $this->dob->AdvancedSearch->SearchValue2 = @$filter["y_dob"];
        $this->dob->AdvancedSearch->SearchOperator2 = @$filter["w_dob"];
        $this->dob->AdvancedSearch->save();

        // Field dom
        $this->dom->AdvancedSearch->SearchValue = @$filter["x_dom"];
        $this->dom->AdvancedSearch->SearchOperator = @$filter["z_dom"];
        $this->dom->AdvancedSearch->SearchCondition = @$filter["v_dom"];
        $this->dom->AdvancedSearch->SearchValue2 = @$filter["y_dom"];
        $this->dom->AdvancedSearch->SearchOperator2 = @$filter["w_dom"];
        $this->dom->AdvancedSearch->save();

        // Field mobile_other
        $this->mobile_other->AdvancedSearch->SearchValue = @$filter["x_mobile_other"];
        $this->mobile_other->AdvancedSearch->SearchOperator = @$filter["z_mobile_other"];
        $this->mobile_other->AdvancedSearch->SearchCondition = @$filter["v_mobile_other"];
        $this->mobile_other->AdvancedSearch->SearchValue2 = @$filter["y_mobile_other"];
        $this->mobile_other->AdvancedSearch->SearchOperator2 = @$filter["w_mobile_other"];
        $this->mobile_other->AdvancedSearch->save();

        // Field mobile_family
        $this->mobile_family->AdvancedSearch->SearchValue = @$filter["x_mobile_family"];
        $this->mobile_family->AdvancedSearch->SearchOperator = @$filter["z_mobile_family"];
        $this->mobile_family->AdvancedSearch->SearchCondition = @$filter["v_mobile_family"];
        $this->mobile_family->AdvancedSearch->SearchValue2 = @$filter["y_mobile_family"];
        $this->mobile_family->AdvancedSearch->SearchOperator2 = @$filter["w_mobile_family"];
        $this->mobile_family->AdvancedSearch->save();

        // Field marital_status
        $this->marital_status->AdvancedSearch->SearchValue = @$filter["x_marital_status"];
        $this->marital_status->AdvancedSearch->SearchOperator = @$filter["z_marital_status"];
        $this->marital_status->AdvancedSearch->SearchCondition = @$filter["v_marital_status"];
        $this->marital_status->AdvancedSearch->SearchValue2 = @$filter["y_marital_status"];
        $this->marital_status->AdvancedSearch->SearchOperator2 = @$filter["w_marital_status"];
        $this->marital_status->AdvancedSearch->save();

        // Field spouse_details
        $this->spouse_details->AdvancedSearch->SearchValue = @$filter["x_spouse_details"];
        $this->spouse_details->AdvancedSearch->SearchOperator = @$filter["z_spouse_details"];
        $this->spouse_details->AdvancedSearch->SearchCondition = @$filter["v_spouse_details"];
        $this->spouse_details->AdvancedSearch->SearchValue2 = @$filter["y_spouse_details"];
        $this->spouse_details->AdvancedSearch->SearchOperator2 = @$filter["w_spouse_details"];
        $this->spouse_details->AdvancedSearch->save();

        // Field emergency_details
        $this->emergency_details->AdvancedSearch->SearchValue = @$filter["x_emergency_details"];
        $this->emergency_details->AdvancedSearch->SearchOperator = @$filter["z_emergency_details"];
        $this->emergency_details->AdvancedSearch->SearchCondition = @$filter["v_emergency_details"];
        $this->emergency_details->AdvancedSearch->SearchValue2 = @$filter["y_emergency_details"];
        $this->emergency_details->AdvancedSearch->SearchOperator2 = @$filter["w_emergency_details"];
        $this->emergency_details->AdvancedSearch->save();

        // Field pan_no
        $this->pan_no->AdvancedSearch->SearchValue = @$filter["x_pan_no"];
        $this->pan_no->AdvancedSearch->SearchOperator = @$filter["z_pan_no"];
        $this->pan_no->AdvancedSearch->SearchCondition = @$filter["v_pan_no"];
        $this->pan_no->AdvancedSearch->SearchValue2 = @$filter["y_pan_no"];
        $this->pan_no->AdvancedSearch->SearchOperator2 = @$filter["w_pan_no"];
        $this->pan_no->AdvancedSearch->save();

        // Field aadhaar_no
        $this->aadhaar_no->AdvancedSearch->SearchValue = @$filter["x_aadhaar_no"];
        $this->aadhaar_no->AdvancedSearch->SearchOperator = @$filter["z_aadhaar_no"];
        $this->aadhaar_no->AdvancedSearch->SearchCondition = @$filter["v_aadhaar_no"];
        $this->aadhaar_no->AdvancedSearch->SearchValue2 = @$filter["y_aadhaar_no"];
        $this->aadhaar_no->AdvancedSearch->SearchOperator2 = @$filter["w_aadhaar_no"];
        $this->aadhaar_no->AdvancedSearch->save();

        // Field id_proof
        $this->id_proof->AdvancedSearch->SearchValue = @$filter["x_id_proof"];
        $this->id_proof->AdvancedSearch->SearchOperator = @$filter["z_id_proof"];
        $this->id_proof->AdvancedSearch->SearchCondition = @$filter["v_id_proof"];
        $this->id_proof->AdvancedSearch->SearchValue2 = @$filter["y_id_proof"];
        $this->id_proof->AdvancedSearch->SearchOperator2 = @$filter["w_id_proof"];
        $this->id_proof->AdvancedSearch->save();

        // Field reference_details
        $this->reference_details->AdvancedSearch->SearchValue = @$filter["x_reference_details"];
        $this->reference_details->AdvancedSearch->SearchOperator = @$filter["z_reference_details"];
        $this->reference_details->AdvancedSearch->SearchCondition = @$filter["v_reference_details"];
        $this->reference_details->AdvancedSearch->SearchValue2 = @$filter["y_reference_details"];
        $this->reference_details->AdvancedSearch->SearchOperator2 = @$filter["w_reference_details"];
        $this->reference_details->AdvancedSearch->save();

        // Field other_details
        $this->other_details->AdvancedSearch->SearchValue = @$filter["x_other_details"];
        $this->other_details->AdvancedSearch->SearchOperator = @$filter["z_other_details"];
        $this->other_details->AdvancedSearch->SearchCondition = @$filter["v_other_details"];
        $this->other_details->AdvancedSearch->SearchValue2 = @$filter["y_other_details"];
        $this->other_details->AdvancedSearch->SearchOperator2 = @$filter["w_other_details"];
        $this->other_details->AdvancedSearch->save();

        // Field doj
        $this->doj->AdvancedSearch->SearchValue = @$filter["x_doj"];
        $this->doj->AdvancedSearch->SearchOperator = @$filter["z_doj"];
        $this->doj->AdvancedSearch->SearchCondition = @$filter["v_doj"];
        $this->doj->AdvancedSearch->SearchValue2 = @$filter["y_doj"];
        $this->doj->AdvancedSearch->SearchOperator2 = @$filter["w_doj"];
        $this->doj->AdvancedSearch->save();

        // Field dol
        $this->dol->AdvancedSearch->SearchValue = @$filter["x_dol"];
        $this->dol->AdvancedSearch->SearchOperator = @$filter["z_dol"];
        $this->dol->AdvancedSearch->SearchCondition = @$filter["v_dol"];
        $this->dol->AdvancedSearch->SearchValue2 = @$filter["y_dol"];
        $this->dol->AdvancedSearch->SearchOperator2 = @$filter["w_dol"];
        $this->dol->AdvancedSearch->save();

        // Field image
        $this->image->AdvancedSearch->SearchValue = @$filter["x_image"];
        $this->image->AdvancedSearch->SearchOperator = @$filter["z_image"];
        $this->image->AdvancedSearch->SearchCondition = @$filter["v_image"];
        $this->image->AdvancedSearch->SearchValue2 = @$filter["y_image"];
        $this->image->AdvancedSearch->SearchOperator2 = @$filter["w_image"];
        $this->image->AdvancedSearch->save();

        // Field payment_details
        $this->payment_details->AdvancedSearch->SearchValue = @$filter["x_payment_details"];
        $this->payment_details->AdvancedSearch->SearchOperator = @$filter["z_payment_details"];
        $this->payment_details->AdvancedSearch->SearchCondition = @$filter["v_payment_details"];
        $this->payment_details->AdvancedSearch->SearchValue2 = @$filter["y_payment_details"];
        $this->payment_details->AdvancedSearch->SearchOperator2 = @$filter["w_payment_details"];
        $this->payment_details->AdvancedSearch->save();

        // Field bank_name
        $this->bank_name->AdvancedSearch->SearchValue = @$filter["x_bank_name"];
        $this->bank_name->AdvancedSearch->SearchOperator = @$filter["z_bank_name"];
        $this->bank_name->AdvancedSearch->SearchCondition = @$filter["v_bank_name"];
        $this->bank_name->AdvancedSearch->SearchValue2 = @$filter["y_bank_name"];
        $this->bank_name->AdvancedSearch->SearchOperator2 = @$filter["w_bank_name"];
        $this->bank_name->AdvancedSearch->save();

        // Field bank_ifsc_code
        $this->bank_ifsc_code->AdvancedSearch->SearchValue = @$filter["x_bank_ifsc_code"];
        $this->bank_ifsc_code->AdvancedSearch->SearchOperator = @$filter["z_bank_ifsc_code"];
        $this->bank_ifsc_code->AdvancedSearch->SearchCondition = @$filter["v_bank_ifsc_code"];
        $this->bank_ifsc_code->AdvancedSearch->SearchValue2 = @$filter["y_bank_ifsc_code"];
        $this->bank_ifsc_code->AdvancedSearch->SearchOperator2 = @$filter["w_bank_ifsc_code"];
        $this->bank_ifsc_code->AdvancedSearch->save();

        // Field bank_account_no
        $this->bank_account_no->AdvancedSearch->SearchValue = @$filter["x_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->SearchOperator = @$filter["z_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->SearchCondition = @$filter["v_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->SearchValue2 = @$filter["y_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->SearchOperator2 = @$filter["w_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->save();

        // Field operator
        $this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
        $this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
        $this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
        $this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
        $this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
        $this->operator->AdvancedSearch->save();

        // Field datetime
        $this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
        $this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
        $this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
        $this->datetime->AdvancedSearch->save();

        // Field d_operator
        $this->d_operator->AdvancedSearch->SearchValue = @$filter["x_d_operator"];
        $this->d_operator->AdvancedSearch->SearchOperator = @$filter["z_d_operator"];
        $this->d_operator->AdvancedSearch->SearchCondition = @$filter["v_d_operator"];
        $this->d_operator->AdvancedSearch->SearchValue2 = @$filter["y_d_operator"];
        $this->d_operator->AdvancedSearch->SearchOperator2 = @$filter["w_d_operator"];
        $this->d_operator->AdvancedSearch->save();

        // Field d_datetime
        $this->d_datetime->AdvancedSearch->SearchValue = @$filter["x_d_datetime"];
        $this->d_datetime->AdvancedSearch->SearchOperator = @$filter["z_d_datetime"];
        $this->d_datetime->AdvancedSearch->SearchCondition = @$filter["v_d_datetime"];
        $this->d_datetime->AdvancedSearch->SearchValue2 = @$filter["y_d_datetime"];
        $this->d_datetime->AdvancedSearch->SearchOperator2 = @$filter["w_d_datetime"];
        $this->d_datetime->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->uid, $default, false); // uid
        $this->buildSearchSql($where, $this->grp, $default, true); // grp
        $this->buildSearchSql($where, $this->site, $default, true); // site
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->user_name, $default, false); // user_name
        $this->buildSearchSql($where, $this->salary, $default, false); // salary
        $this->buildSearchSql($where, $this->contractor, $default, false); // contractor
        $this->buildSearchSql($where, $this->address, $default, false); // address
        $this->buildSearchSql($where, $this->mobile, $default, false); // mobile
        $this->buildSearchSql($where, $this->category, $default, false); // category
        $this->buildSearchSql($where, $this->process, $default, true); // process
        $this->buildSearchSql($where, $this->status, $default, false); // status
        $this->buildSearchSql($where, $this->employee_name, $default, false); // employee_name
        $this->buildSearchSql($where, $this->gender, $default, false); // gender
        $this->buildSearchSql($where, $this->father_name, $default, false); // father_name
        $this->buildSearchSql($where, $this->designation, $default, false); // designation
        $this->buildSearchSql($where, $this->permanent_address, $default, false); // permanent_address
        $this->buildSearchSql($where, $this->city, $default, false); // city
        $this->buildSearchSql($where, $this->dob, $default, false); // dob
        $this->buildSearchSql($where, $this->dom, $default, false); // dom
        $this->buildSearchSql($where, $this->mobile_other, $default, false); // mobile_other
        $this->buildSearchSql($where, $this->mobile_family, $default, false); // mobile_family
        $this->buildSearchSql($where, $this->marital_status, $default, false); // marital_status
        $this->buildSearchSql($where, $this->spouse_details, $default, false); // spouse_details
        $this->buildSearchSql($where, $this->emergency_details, $default, false); // emergency_details
        $this->buildSearchSql($where, $this->pan_no, $default, false); // pan_no
        $this->buildSearchSql($where, $this->aadhaar_no, $default, false); // aadhaar_no
        $this->buildSearchSql($where, $this->id_proof, $default, false); // id_proof
        $this->buildSearchSql($where, $this->reference_details, $default, false); // reference_details
        $this->buildSearchSql($where, $this->other_details, $default, false); // other_details
        $this->buildSearchSql($where, $this->doj, $default, false); // doj
        $this->buildSearchSql($where, $this->dol, $default, false); // dol
        $this->buildSearchSql($where, $this->image, $default, false); // image
        $this->buildSearchSql($where, $this->payment_details, $default, false); // payment_details
        $this->buildSearchSql($where, $this->bank_name, $default, false); // bank_name
        $this->buildSearchSql($where, $this->bank_ifsc_code, $default, false); // bank_ifsc_code
        $this->buildSearchSql($where, $this->bank_account_no, $default, false); // bank_account_no
        $this->buildSearchSql($where, $this->operator, $default, false); // operator
        $this->buildSearchSql($where, $this->datetime, $default, false); // datetime
        $this->buildSearchSql($where, $this->d_operator, $default, false); // d_operator
        $this->buildSearchSql($where, $this->d_datetime, $default, false); // d_datetime

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->uid->AdvancedSearch->save(); // uid
            $this->grp->AdvancedSearch->save(); // grp
            $this->site->AdvancedSearch->save(); // site
            $this->id->AdvancedSearch->save(); // id
            $this->user_name->AdvancedSearch->save(); // user_name
            $this->salary->AdvancedSearch->save(); // salary
            $this->contractor->AdvancedSearch->save(); // contractor
            $this->address->AdvancedSearch->save(); // address
            $this->mobile->AdvancedSearch->save(); // mobile
            $this->category->AdvancedSearch->save(); // category
            $this->process->AdvancedSearch->save(); // process
            $this->status->AdvancedSearch->save(); // status
            $this->employee_name->AdvancedSearch->save(); // employee_name
            $this->gender->AdvancedSearch->save(); // gender
            $this->father_name->AdvancedSearch->save(); // father_name
            $this->designation->AdvancedSearch->save(); // designation
            $this->permanent_address->AdvancedSearch->save(); // permanent_address
            $this->city->AdvancedSearch->save(); // city
            $this->dob->AdvancedSearch->save(); // dob
            $this->dom->AdvancedSearch->save(); // dom
            $this->mobile_other->AdvancedSearch->save(); // mobile_other
            $this->mobile_family->AdvancedSearch->save(); // mobile_family
            $this->marital_status->AdvancedSearch->save(); // marital_status
            $this->spouse_details->AdvancedSearch->save(); // spouse_details
            $this->emergency_details->AdvancedSearch->save(); // emergency_details
            $this->pan_no->AdvancedSearch->save(); // pan_no
            $this->aadhaar_no->AdvancedSearch->save(); // aadhaar_no
            $this->id_proof->AdvancedSearch->save(); // id_proof
            $this->reference_details->AdvancedSearch->save(); // reference_details
            $this->other_details->AdvancedSearch->save(); // other_details
            $this->doj->AdvancedSearch->save(); // doj
            $this->dol->AdvancedSearch->save(); // dol
            $this->image->AdvancedSearch->save(); // image
            $this->payment_details->AdvancedSearch->save(); // payment_details
            $this->bank_name->AdvancedSearch->save(); // bank_name
            $this->bank_ifsc_code->AdvancedSearch->save(); // bank_ifsc_code
            $this->bank_account_no->AdvancedSearch->save(); // bank_account_no
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->d_operator->AdvancedSearch->save(); // d_operator
            $this->d_datetime->AdvancedSearch->save(); // d_datetime

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->uid->AdvancedSearch->save(); // uid
            $this->grp->AdvancedSearch->save(); // grp
            $this->site->AdvancedSearch->save(); // site
            $this->id->AdvancedSearch->save(); // id
            $this->user_name->AdvancedSearch->save(); // user_name
            $this->salary->AdvancedSearch->save(); // salary
            $this->contractor->AdvancedSearch->save(); // contractor
            $this->address->AdvancedSearch->save(); // address
            $this->mobile->AdvancedSearch->save(); // mobile
            $this->category->AdvancedSearch->save(); // category
            $this->process->AdvancedSearch->save(); // process
            $this->status->AdvancedSearch->save(); // status
            $this->employee_name->AdvancedSearch->save(); // employee_name
            $this->gender->AdvancedSearch->save(); // gender
            $this->father_name->AdvancedSearch->save(); // father_name
            $this->designation->AdvancedSearch->save(); // designation
            $this->permanent_address->AdvancedSearch->save(); // permanent_address
            $this->city->AdvancedSearch->save(); // city
            $this->dob->AdvancedSearch->save(); // dob
            $this->dom->AdvancedSearch->save(); // dom
            $this->mobile_other->AdvancedSearch->save(); // mobile_other
            $this->mobile_family->AdvancedSearch->save(); // mobile_family
            $this->marital_status->AdvancedSearch->save(); // marital_status
            $this->spouse_details->AdvancedSearch->save(); // spouse_details
            $this->emergency_details->AdvancedSearch->save(); // emergency_details
            $this->pan_no->AdvancedSearch->save(); // pan_no
            $this->aadhaar_no->AdvancedSearch->save(); // aadhaar_no
            $this->id_proof->AdvancedSearch->save(); // id_proof
            $this->reference_details->AdvancedSearch->save(); // reference_details
            $this->other_details->AdvancedSearch->save(); // other_details
            $this->doj->AdvancedSearch->save(); // doj
            $this->dol->AdvancedSearch->save(); // dol
            $this->image->AdvancedSearch->save(); // image
            $this->payment_details->AdvancedSearch->save(); // payment_details
            $this->bank_name->AdvancedSearch->save(); // bank_name
            $this->bank_ifsc_code->AdvancedSearch->save(); // bank_ifsc_code
            $this->bank_account_no->AdvancedSearch->save(); // bank_account_no
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->d_operator->AdvancedSearch->save(); // d_operator
            $this->d_datetime->AdvancedSearch->save(); // d_datetime
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field uid
        $filter = $this->queryBuilderWhere("uid");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->uid, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->uid->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field grp
        $filter = $this->queryBuilderWhere("grp");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->grp, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->grp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field site
        $filter = $this->queryBuilderWhere("site");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->site, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->site->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field id
        $filter = $this->queryBuilderWhere("id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field user_name
        $filter = $this->queryBuilderWhere("user_name");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->user_name, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->user_name->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field salary
        $filter = $this->queryBuilderWhere("salary");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->salary, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->salary->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field contractor
        $filter = $this->queryBuilderWhere("contractor");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->contractor, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->contractor->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field mobile
        $filter = $this->queryBuilderWhere("mobile");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->mobile, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->mobile->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field process
        $filter = $this->queryBuilderWhere("process");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->process, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->process->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field status
        $filter = $this->queryBuilderWhere("status");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->status, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->status->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field employee_name
        $filter = $this->queryBuilderWhere("employee_name");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->employee_name, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->employee_name->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field gender
        $filter = $this->queryBuilderWhere("gender");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->gender, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->gender->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field father_name
        $filter = $this->queryBuilderWhere("father_name");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->father_name, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->father_name->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field designation
        $filter = $this->queryBuilderWhere("designation");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->designation, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->designation->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field permanent_address
        $filter = $this->queryBuilderWhere("permanent_address");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->permanent_address, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->permanent_address->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field city
        $filter = $this->queryBuilderWhere("city");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->city, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->city->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field dob
        $filter = $this->queryBuilderWhere("dob");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->dob, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->dob->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field dom
        $filter = $this->queryBuilderWhere("dom");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->dom, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->dom->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field mobile_other
        $filter = $this->queryBuilderWhere("mobile_other");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->mobile_other, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->mobile_other->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field mobile_family
        $filter = $this->queryBuilderWhere("mobile_family");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->mobile_family, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->mobile_family->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field marital_status
        $filter = $this->queryBuilderWhere("marital_status");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->marital_status, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->marital_status->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field spouse_details
        $filter = $this->queryBuilderWhere("spouse_details");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->spouse_details, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->spouse_details->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field emergency_details
        $filter = $this->queryBuilderWhere("emergency_details");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->emergency_details, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->emergency_details->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pan_no
        $filter = $this->queryBuilderWhere("pan_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pan_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pan_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field aadhaar_no
        $filter = $this->queryBuilderWhere("aadhaar_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->aadhaar_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->aadhaar_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field id_proof
        $filter = $this->queryBuilderWhere("id_proof");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id_proof, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id_proof->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field reference_details
        $filter = $this->queryBuilderWhere("reference_details");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->reference_details, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->reference_details->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field doj
        $filter = $this->queryBuilderWhere("doj");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->doj, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->doj->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field dol
        $filter = $this->queryBuilderWhere("dol");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->dol, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->dol->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field image
        $filter = $this->queryBuilderWhere("image");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->image, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->image->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field bank_name
        $filter = $this->queryBuilderWhere("bank_name");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->bank_name, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->bank_name->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field bank_ifsc_code
        $filter = $this->queryBuilderWhere("bank_ifsc_code");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->bank_ifsc_code, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->bank_ifsc_code->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field bank_account_no
        $filter = $this->queryBuilderWhere("bank_account_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->bank_account_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->bank_account_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field d_operator
        $filter = $this->queryBuilderWhere("d_operator");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->d_operator, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->d_operator->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field d_datetime
        $filter = $this->queryBuilderWhere("d_datetime");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->d_datetime, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->d_datetime->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->site;
        $searchFlds[] = &$this->id;
        $searchFlds[] = &$this->user_name;
        $searchFlds[] = &$this->address;
        $searchFlds[] = &$this->category;
        $searchFlds[] = &$this->process;
        $searchFlds[] = &$this->employee_name;
        $searchFlds[] = &$this->father_name;
        $searchFlds[] = &$this->permanent_address;
        $searchFlds[] = &$this->city;
        $searchFlds[] = &$this->mobile_other;
        $searchFlds[] = &$this->mobile_family;
        $searchFlds[] = &$this->spouse_details;
        $searchFlds[] = &$this->emergency_details;
        $searchFlds[] = &$this->pan_no;
        $searchFlds[] = &$this->aadhaar_no;
        $searchFlds[] = &$this->id_proof;
        $searchFlds[] = &$this->reference_details;
        $searchFlds[] = &$this->other_details;
        $searchFlds[] = &$this->image;
        $searchFlds[] = &$this->payment_details;
        $searchFlds[] = &$this->bank_name;
        $searchFlds[] = &$this->bank_ifsc_code;
        $searchFlds[] = &$this->bank_account_no;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->uid->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->site->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->user_name->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->salary->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->contractor->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->address->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->mobile->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->category->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->process->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->employee_name->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->gender->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->father_name->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->designation->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->permanent_address->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->city->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->dob->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->dom->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->mobile_other->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->mobile_family->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->marital_status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->spouse_details->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->emergency_details->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pan_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->aadhaar_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->id_proof->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->reference_details->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->other_details->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->doj->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->dol->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->image->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->payment_details->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->bank_name->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->bank_ifsc_code->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->bank_account_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->d_operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->d_datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->uid->AdvancedSearch->unsetSession();
        $this->grp->AdvancedSearch->unsetSession();
        $this->site->AdvancedSearch->unsetSession();
        $this->id->AdvancedSearch->unsetSession();
        $this->user_name->AdvancedSearch->unsetSession();
        $this->salary->AdvancedSearch->unsetSession();
        $this->contractor->AdvancedSearch->unsetSession();
        $this->address->AdvancedSearch->unsetSession();
        $this->mobile->AdvancedSearch->unsetSession();
        $this->category->AdvancedSearch->unsetSession();
        $this->process->AdvancedSearch->unsetSession();
        $this->status->AdvancedSearch->unsetSession();
        $this->employee_name->AdvancedSearch->unsetSession();
        $this->gender->AdvancedSearch->unsetSession();
        $this->father_name->AdvancedSearch->unsetSession();
        $this->designation->AdvancedSearch->unsetSession();
        $this->permanent_address->AdvancedSearch->unsetSession();
        $this->city->AdvancedSearch->unsetSession();
        $this->dob->AdvancedSearch->unsetSession();
        $this->dom->AdvancedSearch->unsetSession();
        $this->mobile_other->AdvancedSearch->unsetSession();
        $this->mobile_family->AdvancedSearch->unsetSession();
        $this->marital_status->AdvancedSearch->unsetSession();
        $this->spouse_details->AdvancedSearch->unsetSession();
        $this->emergency_details->AdvancedSearch->unsetSession();
        $this->pan_no->AdvancedSearch->unsetSession();
        $this->aadhaar_no->AdvancedSearch->unsetSession();
        $this->id_proof->AdvancedSearch->unsetSession();
        $this->reference_details->AdvancedSearch->unsetSession();
        $this->other_details->AdvancedSearch->unsetSession();
        $this->doj->AdvancedSearch->unsetSession();
        $this->dol->AdvancedSearch->unsetSession();
        $this->image->AdvancedSearch->unsetSession();
        $this->payment_details->AdvancedSearch->unsetSession();
        $this->bank_name->AdvancedSearch->unsetSession();
        $this->bank_ifsc_code->AdvancedSearch->unsetSession();
        $this->bank_account_no->AdvancedSearch->unsetSession();
        $this->operator->AdvancedSearch->unsetSession();
        $this->datetime->AdvancedSearch->unsetSession();
        $this->d_operator->AdvancedSearch->unsetSession();
        $this->d_datetime->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->uid->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->site->AdvancedSearch->load();
        $this->id->AdvancedSearch->load();
        $this->user_name->AdvancedSearch->load();
        $this->salary->AdvancedSearch->load();
        $this->contractor->AdvancedSearch->load();
        $this->address->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->process->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->employee_name->AdvancedSearch->load();
        $this->gender->AdvancedSearch->load();
        $this->father_name->AdvancedSearch->load();
        $this->designation->AdvancedSearch->load();
        $this->permanent_address->AdvancedSearch->load();
        $this->city->AdvancedSearch->load();
        $this->dob->AdvancedSearch->load();
        $this->dom->AdvancedSearch->load();
        $this->mobile_other->AdvancedSearch->load();
        $this->mobile_family->AdvancedSearch->load();
        $this->marital_status->AdvancedSearch->load();
        $this->spouse_details->AdvancedSearch->load();
        $this->emergency_details->AdvancedSearch->load();
        $this->pan_no->AdvancedSearch->load();
        $this->aadhaar_no->AdvancedSearch->load();
        $this->id_proof->AdvancedSearch->load();
        $this->reference_details->AdvancedSearch->load();
        $this->other_details->AdvancedSearch->load();
        $this->doj->AdvancedSearch->load();
        $this->dol->AdvancedSearch->load();
        $this->image->AdvancedSearch->load();
        $this->payment_details->AdvancedSearch->load();
        $this->bank_name->AdvancedSearch->load();
        $this->bank_ifsc_code->AdvancedSearch->load();
        $this->bank_account_no->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->d_operator->AdvancedSearch->load();
        $this->d_datetime->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = ""; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->uid); // uid
            $this->updateSort($this->grp); // grp
            $this->updateSort($this->site); // site
            $this->updateSort($this->id); // id
            $this->updateSort($this->user_name); // user_name
            $this->updateSort($this->salary); // salary
            $this->updateSort($this->contractor); // contractor
            $this->updateSort($this->mobile); // mobile
            $this->updateSort($this->process); // process
            $this->updateSort($this->status); // status
            $this->updateSort($this->employee_name); // employee_name
            $this->updateSort($this->gender); // gender
            $this->updateSort($this->father_name); // father_name
            $this->updateSort($this->designation); // designation
            $this->updateSort($this->permanent_address); // permanent_address
            $this->updateSort($this->city); // city
            $this->updateSort($this->dob); // dob
            $this->updateSort($this->dom); // dom
            $this->updateSort($this->mobile_other); // mobile_other
            $this->updateSort($this->mobile_family); // mobile_family
            $this->updateSort($this->marital_status); // marital_status
            $this->updateSort($this->spouse_details); // spouse_details
            $this->updateSort($this->emergency_details); // emergency_details
            $this->updateSort($this->pan_no); // pan_no
            $this->updateSort($this->aadhaar_no); // aadhaar_no
            $this->updateSort($this->id_proof); // id_proof
            $this->updateSort($this->reference_details); // reference_details
            $this->updateSort($this->doj); // doj
            $this->updateSort($this->dol); // dol
            $this->updateSort($this->image); // image
            $this->updateSort($this->bank_name); // bank_name
            $this->updateSort($this->bank_ifsc_code); // bank_ifsc_code
            $this->updateSort($this->bank_account_no); // bank_account_no
            $this->updateSort($this->d_operator); // d_operator
            $this->updateSort($this->d_datetime); // d_datetime
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->uid->setSort("");
                $this->grp->setSort("");
                $this->site->setSort("");
                $this->id->setSort("");
                $this->user_name->setSort("");
                $this->salary->setSort("");
                $this->contractor->setSort("");
                $this->address->setSort("");
                $this->mobile->setSort("");
                $this->category->setSort("");
                $this->process->setSort("");
                $this->status->setSort("");
                $this->employee_name->setSort("");
                $this->gender->setSort("");
                $this->father_name->setSort("");
                $this->designation->setSort("");
                $this->permanent_address->setSort("");
                $this->city->setSort("");
                $this->dob->setSort("");
                $this->dom->setSort("");
                $this->mobile_other->setSort("");
                $this->mobile_family->setSort("");
                $this->marital_status->setSort("");
                $this->spouse_details->setSort("");
                $this->emergency_details->setSort("");
                $this->pan_no->setSort("");
                $this->aadhaar_no->setSort("");
                $this->id_proof->setSort("");
                $this->reference_details->setSort("");
                $this->other_details->setSort("");
                $this->doj->setSort("");
                $this->doc->setSort("");
                $this->dol->setSort("");
                $this->image->setSort("");
                $this->payment_details->setSort("");
                $this->bank_name->setSort("");
                $this->bank_ifsc_code->setSort("");
                $this->bank_account_no->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
                $this->d_operator->setSort("");
                $this->d_datetime->setSort("");
                $this->am_id->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = true;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"production_employee\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"production_employee\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fproduction_employeelist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fproduction_employeelist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->uid->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"production_employee\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["action"];

        // Add multi update
        $item = &$option->add("multiupdate");
        $item->Body = "<button type=\"button\" class=\"ew-action ew-multi-update\" title=\"" .
            $Language->phrase("UpdateSelectedLink", true) . "\" data-table=\"production_employee\" data-caption=\"" .
            $Language->phrase("UpdateSelectedLink", true) . "\" form=\"fproduction_employeelist\" data-ew-action=\"" .
            ($this->ModalUpdate && !IsMobile() ? "modal" : "submit") . "\"" .
            ($this->ModalUpdate && !IsMobile() ? " data-action=\"update\"" : "") .
            ($this->UseAjaxActions ? " data-ajax=\"true\"" : "") .
            " data-url=\"" . GetUrl($this->MultiUpdateUrl) . "\">" . $Language->phrase("UpdateSelectedLink") . "</button>";
        $item->Visible = $Security->canEdit();

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "uid");
            $this->createColumnOption($option, "grp");
            $this->createColumnOption($option, "site");
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "user_name");
            $this->createColumnOption($option, "salary");
            $this->createColumnOption($option, "contractor");
            $this->createColumnOption($option, "mobile");
            $this->createColumnOption($option, "process");
            $this->createColumnOption($option, "status");
            $this->createColumnOption($option, "employee_name");
            $this->createColumnOption($option, "gender");
            $this->createColumnOption($option, "father_name");
            $this->createColumnOption($option, "designation");
            $this->createColumnOption($option, "permanent_address");
            $this->createColumnOption($option, "city");
            $this->createColumnOption($option, "dob");
            $this->createColumnOption($option, "dom");
            $this->createColumnOption($option, "mobile_other");
            $this->createColumnOption($option, "mobile_family");
            $this->createColumnOption($option, "marital_status");
            $this->createColumnOption($option, "spouse_details");
            $this->createColumnOption($option, "emergency_details");
            $this->createColumnOption($option, "pan_no");
            $this->createColumnOption($option, "aadhaar_no");
            $this->createColumnOption($option, "id_proof");
            $this->createColumnOption($option, "reference_details");
            $this->createColumnOption($option, "doj");
            $this->createColumnOption($option, "dol");
            $this->createColumnOption($option, "image");
            $this->createColumnOption($option, "bank_name");
            $this->createColumnOption($option, "bank_ifsc_code");
            $this->createColumnOption($option, "bank_account_no");
            $this->createColumnOption($option, "d_operator");
            $this->createColumnOption($option, "d_datetime");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fproduction_employeesrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fproduction_employeesrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fproduction_employeelist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_production_employee", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_production_employee",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // uid
        if ($this->uid->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->uid->AdvancedSearch->SearchValue != "" || $this->uid->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->grp->AdvancedSearch->SearchValue != "" || $this->grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->grp->AdvancedSearch->SearchValue)) {
            $this->grp->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->grp->AdvancedSearch->SearchValue);
        }
        if (is_array($this->grp->AdvancedSearch->SearchValue2)) {
            $this->grp->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->grp->AdvancedSearch->SearchValue2);
        }

        // site
        if ($this->site->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->site->AdvancedSearch->SearchValue != "" || $this->site->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->site->AdvancedSearch->SearchValue)) {
            $this->site->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->site->AdvancedSearch->SearchValue);
        }
        if (is_array($this->site->AdvancedSearch->SearchValue2)) {
            $this->site->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->site->AdvancedSearch->SearchValue2);
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // user_name
        if ($this->user_name->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->user_name->AdvancedSearch->SearchValue != "" || $this->user_name->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // salary
        if ($this->salary->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->salary->AdvancedSearch->SearchValue != "" || $this->salary->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // contractor
        if ($this->contractor->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->contractor->AdvancedSearch->SearchValue != "" || $this->contractor->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // address
        if ($this->address->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->address->AdvancedSearch->SearchValue != "" || $this->address->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // mobile
        if ($this->mobile->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->mobile->AdvancedSearch->SearchValue != "" || $this->mobile->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->category->AdvancedSearch->SearchValue != "" || $this->category->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // process
        if ($this->process->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->process->AdvancedSearch->SearchValue != "" || $this->process->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->process->AdvancedSearch->SearchValue)) {
            $this->process->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->process->AdvancedSearch->SearchValue);
        }
        if (is_array($this->process->AdvancedSearch->SearchValue2)) {
            $this->process->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->process->AdvancedSearch->SearchValue2);
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->status->AdvancedSearch->SearchValue != "" || $this->status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // employee_name
        if ($this->employee_name->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->employee_name->AdvancedSearch->SearchValue != "" || $this->employee_name->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // gender
        if ($this->gender->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->gender->AdvancedSearch->SearchValue != "" || $this->gender->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // father_name
        if ($this->father_name->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->father_name->AdvancedSearch->SearchValue != "" || $this->father_name->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // designation
        if ($this->designation->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->designation->AdvancedSearch->SearchValue != "" || $this->designation->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // permanent_address
        if ($this->permanent_address->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->permanent_address->AdvancedSearch->SearchValue != "" || $this->permanent_address->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // city
        if ($this->city->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->city->AdvancedSearch->SearchValue != "" || $this->city->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // dob
        if ($this->dob->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->dob->AdvancedSearch->SearchValue != "" || $this->dob->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // dom
        if ($this->dom->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->dom->AdvancedSearch->SearchValue != "" || $this->dom->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // mobile_other
        if ($this->mobile_other->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->mobile_other->AdvancedSearch->SearchValue != "" || $this->mobile_other->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // mobile_family
        if ($this->mobile_family->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->mobile_family->AdvancedSearch->SearchValue != "" || $this->mobile_family->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // marital_status
        if ($this->marital_status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->marital_status->AdvancedSearch->SearchValue != "" || $this->marital_status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // spouse_details
        if ($this->spouse_details->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->spouse_details->AdvancedSearch->SearchValue != "" || $this->spouse_details->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // emergency_details
        if ($this->emergency_details->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->emergency_details->AdvancedSearch->SearchValue != "" || $this->emergency_details->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pan_no
        if ($this->pan_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pan_no->AdvancedSearch->SearchValue != "" || $this->pan_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // aadhaar_no
        if ($this->aadhaar_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->aadhaar_no->AdvancedSearch->SearchValue != "" || $this->aadhaar_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // id_proof
        if ($this->id_proof->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id_proof->AdvancedSearch->SearchValue != "" || $this->id_proof->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // reference_details
        if ($this->reference_details->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->reference_details->AdvancedSearch->SearchValue != "" || $this->reference_details->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // other_details
        if ($this->other_details->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->other_details->AdvancedSearch->SearchValue != "" || $this->other_details->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // doj
        if ($this->doj->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->doj->AdvancedSearch->SearchValue != "" || $this->doj->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // dol
        if ($this->dol->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->dol->AdvancedSearch->SearchValue != "" || $this->dol->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // image
        if ($this->image->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->image->AdvancedSearch->SearchValue != "" || $this->image->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // payment_details
        if ($this->payment_details->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->payment_details->AdvancedSearch->SearchValue != "" || $this->payment_details->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // bank_name
        if ($this->bank_name->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->bank_name->AdvancedSearch->SearchValue != "" || $this->bank_name->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // bank_ifsc_code
        if ($this->bank_ifsc_code->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->bank_ifsc_code->AdvancedSearch->SearchValue != "" || $this->bank_ifsc_code->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // bank_account_no
        if ($this->bank_account_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->bank_account_no->AdvancedSearch->SearchValue != "" || $this->bank_account_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator->AdvancedSearch->SearchValue != "" || $this->operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime->AdvancedSearch->SearchValue != "" || $this->datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // d_operator
        if ($this->d_operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->d_operator->AdvancedSearch->SearchValue != "" || $this->d_operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // d_datetime
        if ($this->d_datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->d_datetime->AdvancedSearch->SearchValue != "" || $this->d_datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->uid->setDbValue($row['uid']);
        $this->grp->setDbValue($row['grp']);
        $this->site->setDbValue($row['site']);
        $this->id->setDbValue($row['id']);
        $this->user_name->setDbValue($row['user_name']);
        $this->salary->setDbValue($row['salary']);
        $this->contractor->setDbValue($row['contractor']);
        $this->address->setDbValue($row['address']);
        $this->mobile->setDbValue($row['mobile']);
        $this->category->setDbValue($row['category']);
        $this->process->setDbValue($row['process']);
        $this->status->setDbValue($row['status']);
        $this->employee_name->setDbValue($row['employee_name']);
        $this->gender->setDbValue($row['gender']);
        $this->father_name->setDbValue($row['father_name']);
        $this->designation->setDbValue($row['designation']);
        $this->permanent_address->setDbValue($row['permanent_address']);
        $this->city->setDbValue($row['city']);
        $this->dob->setDbValue($row['dob']);
        $this->dom->setDbValue($row['dom']);
        $this->mobile_other->setDbValue($row['mobile_other']);
        $this->mobile_family->setDbValue($row['mobile_family']);
        $this->marital_status->setDbValue($row['marital_status']);
        $this->spouse_details->setDbValue($row['spouse_details']);
        $this->emergency_details->setDbValue($row['emergency_details']);
        $this->pan_no->setDbValue($row['pan_no']);
        $this->aadhaar_no->setDbValue($row['aadhaar_no']);
        $this->id_proof->Upload->DbValue = $row['id_proof'];
        $this->id_proof->setDbValue($this->id_proof->Upload->DbValue);
        $this->reference_details->setDbValue($row['reference_details']);
        $this->other_details->setDbValue($row['other_details']);
        $this->doj->setDbValue($row['doj']);
        $this->doc->setDbValue($row['doc']);
        $this->dol->setDbValue($row['dol']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->payment_details->setDbValue($row['payment_details']);
        $this->bank_name->setDbValue($row['bank_name']);
        $this->bank_ifsc_code->setDbValue($row['bank_ifsc_code']);
        $this->bank_account_no->setDbValue($row['bank_account_no']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->d_operator->setDbValue($row['d_operator']);
        $this->d_datetime->setDbValue($row['d_datetime']);
        $this->am_id->setDbValue($row['am_id']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['uid'] = $this->uid->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['site'] = $this->site->DefaultValue;
        $row['id'] = $this->id->DefaultValue;
        $row['user_name'] = $this->user_name->DefaultValue;
        $row['salary'] = $this->salary->DefaultValue;
        $row['contractor'] = $this->contractor->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['employee_name'] = $this->employee_name->DefaultValue;
        $row['gender'] = $this->gender->DefaultValue;
        $row['father_name'] = $this->father_name->DefaultValue;
        $row['designation'] = $this->designation->DefaultValue;
        $row['permanent_address'] = $this->permanent_address->DefaultValue;
        $row['city'] = $this->city->DefaultValue;
        $row['dob'] = $this->dob->DefaultValue;
        $row['dom'] = $this->dom->DefaultValue;
        $row['mobile_other'] = $this->mobile_other->DefaultValue;
        $row['mobile_family'] = $this->mobile_family->DefaultValue;
        $row['marital_status'] = $this->marital_status->DefaultValue;
        $row['spouse_details'] = $this->spouse_details->DefaultValue;
        $row['emergency_details'] = $this->emergency_details->DefaultValue;
        $row['pan_no'] = $this->pan_no->DefaultValue;
        $row['aadhaar_no'] = $this->aadhaar_no->DefaultValue;
        $row['id_proof'] = $this->id_proof->DefaultValue;
        $row['reference_details'] = $this->reference_details->DefaultValue;
        $row['other_details'] = $this->other_details->DefaultValue;
        $row['doj'] = $this->doj->DefaultValue;
        $row['doc'] = $this->doc->DefaultValue;
        $row['dol'] = $this->dol->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['payment_details'] = $this->payment_details->DefaultValue;
        $row['bank_name'] = $this->bank_name->DefaultValue;
        $row['bank_ifsc_code'] = $this->bank_ifsc_code->DefaultValue;
        $row['bank_account_no'] = $this->bank_account_no->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['d_operator'] = $this->d_operator->DefaultValue;
        $row['d_datetime'] = $this->d_datetime->DefaultValue;
        $row['am_id'] = $this->am_id->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // uid
        $this->uid->CellCssStyle = "white-space: nowrap;";

        // grp

        // site

        // id

        // user_name

        // salary

        // contractor

        // address

        // mobile

        // category

        // process

        // status

        // employee_name

        // gender

        // father_name

        // designation

        // permanent_address

        // city

        // dob

        // dom

        // mobile_other

        // mobile_family

        // marital_status

        // spouse_details

        // emergency_details

        // pan_no

        // aadhaar_no

        // id_proof

        // reference_details

        // other_details

        // doj

        // doc
        $this->doc->CellCssStyle = "white-space: nowrap;";

        // dol

        // image

        // payment_details

        // bank_name

        // bank_ifsc_code

        // bank_account_no

        // operator

        // datetime

        // d_operator

        // d_datetime

        // am_id
        $this->am_id->CellCssStyle = "white-space: nowrap;";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // uid
            $this->uid->ViewValue = $this->uid->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->grp->Lookup->renderViewRow($row);
                            $this->grp->ViewValue->add($this->grp->displayValue($arwrk));
                        }
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // site
            $curVal = strval($this->site->CurrentValue);
            if ($curVal != "") {
                $this->site->ViewValue = $this->site->lookupCacheOption($curVal);
                if ($this->site->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->site->getSelectFilter($this); // PHP
                    $sqlWrk = $this->site->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->site->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->site->Lookup->renderViewRow($row);
                            $this->site->ViewValue->add($this->site->displayValue($arwrk));
                        }
                    } else {
                        $this->site->ViewValue = $this->site->CurrentValue;
                    }
                }
            } else {
                $this->site->ViewValue = null;
            }

            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // user_name
            $this->user_name->ViewValue = $this->user_name->CurrentValue;

            // salary
            $this->salary->ViewValue = $this->salary->CurrentValue;
            $this->salary->ViewValue = FormatNumber($this->salary->ViewValue, $this->salary->formatPattern());

            // contractor
            $curVal = strval($this->contractor->CurrentValue);
            if ($curVal != "") {
                $this->contractor->ViewValue = $this->contractor->lookupCacheOption($curVal);
                if ($this->contractor->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->contractor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->contractor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->contractor->getSelectFilter($this); // PHP
                    $sqlWrk = $this->contractor->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->contractor->Lookup->renderViewRow($rswrk[0]);
                        $this->contractor->ViewValue = $this->contractor->displayValue($arwrk);
                    } else {
                        $this->contractor->ViewValue = FormatNumber($this->contractor->CurrentValue, $this->contractor->formatPattern());
                    }
                }
            } else {
                $this->contractor->ViewValue = null;
            }

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, $this->mobile->formatPattern());

            // category
            if (strval($this->category->CurrentValue) != "") {
                $this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
            } else {
                $this->category->ViewValue = null;
            }

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process->Lookup->renderViewRow($row);
                            $this->process->ViewValue->add($this->process->displayValue($arwrk));
                        }
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // employee_name
            $this->employee_name->ViewValue = $this->employee_name->CurrentValue;

            // gender
            if (strval($this->gender->CurrentValue) != "") {
                $this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
            } else {
                $this->gender->ViewValue = null;
            }

            // father_name
            $this->father_name->ViewValue = $this->father_name->CurrentValue;

            // designation
            $this->designation->ViewValue = $this->designation->CurrentValue;

            // permanent_address
            $this->permanent_address->ViewValue = $this->permanent_address->CurrentValue;

            // city
            $this->city->ViewValue = $this->city->CurrentValue;

            // dob
            $this->dob->ViewValue = $this->dob->CurrentValue;
            $this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, $this->dob->formatPattern());

            // dom
            $this->dom->ViewValue = $this->dom->CurrentValue;
            $this->dom->ViewValue = FormatDateTime($this->dom->ViewValue, $this->dom->formatPattern());

            // mobile_other
            $this->mobile_other->ViewValue = $this->mobile_other->CurrentValue;

            // mobile_family
            $this->mobile_family->ViewValue = $this->mobile_family->CurrentValue;

            // marital_status
            if (strval($this->marital_status->CurrentValue) != "") {
                $this->marital_status->ViewValue = $this->marital_status->optionCaption($this->marital_status->CurrentValue);
            } else {
                $this->marital_status->ViewValue = null;
            }

            // spouse_details
            $this->spouse_details->ViewValue = $this->spouse_details->CurrentValue;

            // emergency_details
            $this->emergency_details->ViewValue = $this->emergency_details->CurrentValue;

            // pan_no
            $this->pan_no->ViewValue = $this->pan_no->CurrentValue;

            // aadhaar_no
            $this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;

            // id_proof
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
            } else {
                $this->id_proof->ViewValue = "";
            }

            // reference_details
            $this->reference_details->ViewValue = $this->reference_details->CurrentValue;

            // doj
            $this->doj->ViewValue = $this->doj->CurrentValue;
            $this->doj->ViewValue = FormatDateTime($this->doj->ViewValue, $this->doj->formatPattern());

            // dol
            $this->dol->ViewValue = $this->dol->CurrentValue;
            $this->dol->ViewValue = FormatDateTime($this->dol->ViewValue, $this->dol->formatPattern());

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // bank_name
            $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

            // bank_ifsc_code
            $this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;

            // bank_account_no
            $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // d_operator
            $this->d_operator->ViewValue = $this->d_operator->CurrentValue;
            $this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, $this->d_operator->formatPattern());

            // d_datetime
            $this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
            $this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, $this->d_datetime->formatPattern());

            // uid
            $this->uid->HrefValue = "";
            $this->uid->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // site
            if (!EmptyValue($this->site->CurrentValue)) {
                $this->site->HrefValue = $this->site->getLinkPrefix() . $this->site->CurrentValue; // Add prefix/suffix
                $this->site->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->site->HrefValue = FullUrl($this->site->HrefValue, "href");
                }
            } else {
                $this->site->HrefValue = "";
            }
            $this->site->TooltipValue = "";

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // user_name
            $this->user_name->HrefValue = "";
            $this->user_name->TooltipValue = "";

            // salary
            $this->salary->HrefValue = "";
            $this->salary->TooltipValue = "";

            // contractor
            $this->contractor->HrefValue = "";
            $this->contractor->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // process
            $this->process->HrefValue = "";
            $this->process->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // employee_name
            $this->employee_name->HrefValue = "";
            $this->employee_name->TooltipValue = "";

            // gender
            $this->gender->HrefValue = "";
            $this->gender->TooltipValue = "";

            // father_name
            $this->father_name->HrefValue = "";
            $this->father_name->TooltipValue = "";

            // designation
            $this->designation->HrefValue = "";
            $this->designation->TooltipValue = "";

            // permanent_address
            $this->permanent_address->HrefValue = "";
            $this->permanent_address->TooltipValue = "";

            // city
            $this->city->HrefValue = "";
            $this->city->TooltipValue = "";

            // dob
            $this->dob->HrefValue = "";
            $this->dob->TooltipValue = "";

            // dom
            $this->dom->HrefValue = "";
            $this->dom->TooltipValue = "";

            // mobile_other
            $this->mobile_other->HrefValue = "";
            $this->mobile_other->TooltipValue = "";

            // mobile_family
            $this->mobile_family->HrefValue = "";
            $this->mobile_family->TooltipValue = "";

            // marital_status
            $this->marital_status->HrefValue = "";
            $this->marital_status->TooltipValue = "";

            // spouse_details
            $this->spouse_details->HrefValue = "";
            $this->spouse_details->TooltipValue = "";

            // emergency_details
            $this->emergency_details->HrefValue = "";
            $this->emergency_details->TooltipValue = "";

            // pan_no
            $this->pan_no->HrefValue = "";
            $this->pan_no->TooltipValue = "";

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";
            $this->aadhaar_no->TooltipValue = "";

            // id_proof
            $this->id_proof->HrefValue = "";
            $this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;
            $this->id_proof->TooltipValue = "";

            // reference_details
            $this->reference_details->HrefValue = "";
            $this->reference_details->TooltipValue = "";

            // doj
            $this->doj->HrefValue = "";
            $this->doj->TooltipValue = "";

            // dol
            $this->dol->HrefValue = "";
            $this->dol->TooltipValue = "";

            // image
            $this->image->HrefValue = "";
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
            $this->image->TooltipValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";
            $this->bank_name->TooltipValue = "";

            // bank_ifsc_code
            $this->bank_ifsc_code->HrefValue = "";
            $this->bank_ifsc_code->TooltipValue = "";

            // bank_account_no
            $this->bank_account_no->HrefValue = "";
            $this->bank_account_no->TooltipValue = "";

            // d_operator
            $this->d_operator->HrefValue = "";
            $this->d_operator->TooltipValue = "";

            // d_datetime
            $this->d_datetime->HrefValue = "";
            $this->d_datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // uid
            $this->uid->setupEditAttributes();
            $this->uid->EditValue = $this->uid->AdvancedSearch->SearchValue;
            $this->uid->PlaceHolder = RemoveHtml($this->uid->caption());
            $this->uid->setupEditAttributes();
            $this->uid->EditValue2 = $this->uid->AdvancedSearch->SearchValue2;
            $this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

            // grp
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // site
            $this->site->setupEditAttributes();
            $curVal = trim(strval($this->site->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->site->AdvancedSearch->ViewValue = $this->site->lookupCacheOption($curVal);
            } else {
                $this->site->AdvancedSearch->ViewValue = $this->site->Lookup !== null && is_array($this->site->lookupOptions()) && count($this->site->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->site->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->site->EditValue = array_values($this->site->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->site->getSelectFilter($this); // PHP
                $sqlWrk = $this->site->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->site->EditValue = $arwrk;
            }
            $this->site->PlaceHolder = RemoveHtml($this->site->caption());

            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // user_name
            $this->user_name->setupEditAttributes();
            if (!$this->user_name->Raw) {
                $this->user_name->AdvancedSearch->SearchValue = HtmlDecode($this->user_name->AdvancedSearch->SearchValue);
            }
            $this->user_name->EditValue = HtmlEncode($this->user_name->AdvancedSearch->SearchValue);
            $this->user_name->PlaceHolder = RemoveHtml($this->user_name->caption());

            // salary
            $this->salary->setupEditAttributes();
            $this->salary->EditValue = $this->salary->AdvancedSearch->SearchValue;
            $this->salary->PlaceHolder = RemoveHtml($this->salary->caption());

            // contractor
            $this->contractor->setupEditAttributes();
            $curVal = trim(strval($this->contractor->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->contractor->AdvancedSearch->ViewValue = $this->contractor->lookupCacheOption($curVal);
            } else {
                $this->contractor->AdvancedSearch->ViewValue = $this->contractor->Lookup !== null && is_array($this->contractor->lookupOptions()) && count($this->contractor->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->contractor->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->contractor->EditValue = array_values($this->contractor->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->contractor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->contractor->AdvancedSearch->SearchValue, $this->contractor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->contractor->getSelectFilter($this); // PHP
                $sqlWrk = $this->contractor->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->contractor->Lookup->renderViewRow($row);
                }
                $this->contractor->EditValue = $arwrk;
            }
            $this->contractor->PlaceHolder = RemoveHtml($this->contractor->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            $this->mobile->EditValue = $this->mobile->AdvancedSearch->SearchValue;
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // process
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // employee_name
            $this->employee_name->setupEditAttributes();
            if (!$this->employee_name->Raw) {
                $this->employee_name->AdvancedSearch->SearchValue = HtmlDecode($this->employee_name->AdvancedSearch->SearchValue);
            }
            $this->employee_name->EditValue = HtmlEncode($this->employee_name->AdvancedSearch->SearchValue);
            $this->employee_name->PlaceHolder = RemoveHtml($this->employee_name->caption());

            // gender
            $this->gender->setupEditAttributes();
            $this->gender->EditValue = $this->gender->options(true);
            $this->gender->PlaceHolder = RemoveHtml($this->gender->caption());

            // father_name
            $this->father_name->setupEditAttributes();
            if (!$this->father_name->Raw) {
                $this->father_name->AdvancedSearch->SearchValue = HtmlDecode($this->father_name->AdvancedSearch->SearchValue);
            }
            $this->father_name->EditValue = HtmlEncode($this->father_name->AdvancedSearch->SearchValue);
            $this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

            // designation
            $this->designation->setupEditAttributes();
            if (!$this->designation->Raw) {
                $this->designation->AdvancedSearch->SearchValue = HtmlDecode($this->designation->AdvancedSearch->SearchValue);
            }
            $this->designation->EditValue = HtmlEncode($this->designation->AdvancedSearch->SearchValue);
            $this->designation->PlaceHolder = RemoveHtml($this->designation->caption());

            // permanent_address
            $this->permanent_address->setupEditAttributes();
            $this->permanent_address->EditValue = HtmlEncode($this->permanent_address->AdvancedSearch->SearchValue);
            $this->permanent_address->PlaceHolder = RemoveHtml($this->permanent_address->caption());

            // city
            $this->city->setupEditAttributes();
            if (!$this->city->Raw) {
                $this->city->AdvancedSearch->SearchValue = HtmlDecode($this->city->AdvancedSearch->SearchValue);
            }
            $this->city->EditValue = HtmlEncode($this->city->AdvancedSearch->SearchValue);
            $this->city->PlaceHolder = RemoveHtml($this->city->caption());

            // dob
            $this->dob->setupEditAttributes();
            $this->dob->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dob->AdvancedSearch->SearchValue, $this->dob->formatPattern()), $this->dob->formatPattern()));
            $this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

            // dom
            $this->dom->setupEditAttributes();
            $this->dom->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dom->AdvancedSearch->SearchValue, $this->dom->formatPattern()), $this->dom->formatPattern()));
            $this->dom->PlaceHolder = RemoveHtml($this->dom->caption());

            // mobile_other
            $this->mobile_other->setupEditAttributes();
            if (!$this->mobile_other->Raw) {
                $this->mobile_other->AdvancedSearch->SearchValue = HtmlDecode($this->mobile_other->AdvancedSearch->SearchValue);
            }
            $this->mobile_other->EditValue = HtmlEncode($this->mobile_other->AdvancedSearch->SearchValue);
            $this->mobile_other->PlaceHolder = RemoveHtml($this->mobile_other->caption());

            // mobile_family
            $this->mobile_family->setupEditAttributes();
            if (!$this->mobile_family->Raw) {
                $this->mobile_family->AdvancedSearch->SearchValue = HtmlDecode($this->mobile_family->AdvancedSearch->SearchValue);
            }
            $this->mobile_family->EditValue = HtmlEncode($this->mobile_family->AdvancedSearch->SearchValue);
            $this->mobile_family->PlaceHolder = RemoveHtml($this->mobile_family->caption());

            // marital_status
            $this->marital_status->setupEditAttributes();
            $this->marital_status->EditValue = $this->marital_status->options(true);
            $this->marital_status->PlaceHolder = RemoveHtml($this->marital_status->caption());

            // spouse_details
            $this->spouse_details->setupEditAttributes();
            if (!$this->spouse_details->Raw) {
                $this->spouse_details->AdvancedSearch->SearchValue = HtmlDecode($this->spouse_details->AdvancedSearch->SearchValue);
            }
            $this->spouse_details->EditValue = HtmlEncode($this->spouse_details->AdvancedSearch->SearchValue);
            $this->spouse_details->PlaceHolder = RemoveHtml($this->spouse_details->caption());

            // emergency_details
            $this->emergency_details->setupEditAttributes();
            if (!$this->emergency_details->Raw) {
                $this->emergency_details->AdvancedSearch->SearchValue = HtmlDecode($this->emergency_details->AdvancedSearch->SearchValue);
            }
            $this->emergency_details->EditValue = HtmlEncode($this->emergency_details->AdvancedSearch->SearchValue);
            $this->emergency_details->PlaceHolder = RemoveHtml($this->emergency_details->caption());

            // pan_no
            $this->pan_no->setupEditAttributes();
            if (!$this->pan_no->Raw) {
                $this->pan_no->AdvancedSearch->SearchValue = HtmlDecode($this->pan_no->AdvancedSearch->SearchValue);
            }
            $this->pan_no->EditValue = HtmlEncode($this->pan_no->AdvancedSearch->SearchValue);
            $this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

            // aadhaar_no
            $this->aadhaar_no->setupEditAttributes();
            if (!$this->aadhaar_no->Raw) {
                $this->aadhaar_no->AdvancedSearch->SearchValue = HtmlDecode($this->aadhaar_no->AdvancedSearch->SearchValue);
            }
            $this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->AdvancedSearch->SearchValue);
            $this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

            // id_proof
            $this->id_proof->setupEditAttributes();
            if (!$this->id_proof->Raw) {
                $this->id_proof->AdvancedSearch->SearchValue = HtmlDecode($this->id_proof->AdvancedSearch->SearchValue);
            }
            $this->id_proof->EditValue = HtmlEncode($this->id_proof->AdvancedSearch->SearchValue);
            $this->id_proof->PlaceHolder = RemoveHtml($this->id_proof->caption());

            // reference_details
            $this->reference_details->setupEditAttributes();
            if (!$this->reference_details->Raw) {
                $this->reference_details->AdvancedSearch->SearchValue = HtmlDecode($this->reference_details->AdvancedSearch->SearchValue);
            }
            $this->reference_details->EditValue = HtmlEncode($this->reference_details->AdvancedSearch->SearchValue);
            $this->reference_details->PlaceHolder = RemoveHtml($this->reference_details->caption());

            // doj
            $this->doj->setupEditAttributes();
            $this->doj->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->doj->AdvancedSearch->SearchValue, $this->doj->formatPattern()), $this->doj->formatPattern()));
            $this->doj->PlaceHolder = RemoveHtml($this->doj->caption());

            // dol
            $this->dol->setupEditAttributes();
            $this->dol->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dol->AdvancedSearch->SearchValue, $this->dol->formatPattern()), $this->dol->formatPattern()));
            $this->dol->PlaceHolder = RemoveHtml($this->dol->caption());

            // image
            $this->image->setupEditAttributes();
            if (!$this->image->Raw) {
                $this->image->AdvancedSearch->SearchValue = HtmlDecode($this->image->AdvancedSearch->SearchValue);
            }
            $this->image->EditValue = HtmlEncode($this->image->AdvancedSearch->SearchValue);
            $this->image->PlaceHolder = RemoveHtml($this->image->caption());

            // bank_name
            $this->bank_name->setupEditAttributes();
            if (!$this->bank_name->Raw) {
                $this->bank_name->AdvancedSearch->SearchValue = HtmlDecode($this->bank_name->AdvancedSearch->SearchValue);
            }
            $this->bank_name->EditValue = HtmlEncode($this->bank_name->AdvancedSearch->SearchValue);
            $this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

            // bank_ifsc_code
            $this->bank_ifsc_code->setupEditAttributes();
            if (!$this->bank_ifsc_code->Raw) {
                $this->bank_ifsc_code->AdvancedSearch->SearchValue = HtmlDecode($this->bank_ifsc_code->AdvancedSearch->SearchValue);
            }
            $this->bank_ifsc_code->EditValue = HtmlEncode($this->bank_ifsc_code->AdvancedSearch->SearchValue);
            $this->bank_ifsc_code->PlaceHolder = RemoveHtml($this->bank_ifsc_code->caption());

            // bank_account_no
            $this->bank_account_no->setupEditAttributes();
            if (!$this->bank_account_no->Raw) {
                $this->bank_account_no->AdvancedSearch->SearchValue = HtmlDecode($this->bank_account_no->AdvancedSearch->SearchValue);
            }
            $this->bank_account_no->EditValue = HtmlEncode($this->bank_account_no->AdvancedSearch->SearchValue);
            $this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

            // d_operator
            $this->d_operator->setupEditAttributes();
            $this->d_operator->EditValue = $this->d_operator->AdvancedSearch->SearchValue;
            $this->d_operator->PlaceHolder = RemoveHtml($this->d_operator->caption());

            // d_datetime
            $this->d_datetime->setupEditAttributes();
            $this->d_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->d_datetime->AdvancedSearch->SearchValue, $this->d_datetime->formatPattern()), $this->d_datetime->formatPattern()));
            $this->d_datetime->PlaceHolder = RemoveHtml($this->d_datetime->caption());
            $this->d_datetime->setupEditAttributes();
            $this->d_datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->d_datetime->AdvancedSearch->SearchValue2, $this->d_datetime->formatPattern()), $this->d_datetime->formatPattern()));
            $this->d_datetime->PlaceHolder = RemoveHtml($this->d_datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->uid->AdvancedSearch->SearchValue)) {
            $this->uid->addErrorMessage($this->uid->getErrorMessage(false));
        }
        if (!CheckInteger($this->uid->AdvancedSearch->SearchValue2)) {
            $this->uid->addErrorMessage($this->uid->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->uid->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->site->AdvancedSearch->load();
        $this->id->AdvancedSearch->load();
        $this->user_name->AdvancedSearch->load();
        $this->salary->AdvancedSearch->load();
        $this->contractor->AdvancedSearch->load();
        $this->address->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->process->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->employee_name->AdvancedSearch->load();
        $this->gender->AdvancedSearch->load();
        $this->father_name->AdvancedSearch->load();
        $this->designation->AdvancedSearch->load();
        $this->permanent_address->AdvancedSearch->load();
        $this->city->AdvancedSearch->load();
        $this->dob->AdvancedSearch->load();
        $this->dom->AdvancedSearch->load();
        $this->mobile_other->AdvancedSearch->load();
        $this->mobile_family->AdvancedSearch->load();
        $this->marital_status->AdvancedSearch->load();
        $this->spouse_details->AdvancedSearch->load();
        $this->emergency_details->AdvancedSearch->load();
        $this->pan_no->AdvancedSearch->load();
        $this->aadhaar_no->AdvancedSearch->load();
        $this->id_proof->AdvancedSearch->load();
        $this->reference_details->AdvancedSearch->load();
        $this->other_details->AdvancedSearch->load();
        $this->doj->AdvancedSearch->load();
        $this->dol->AdvancedSearch->load();
        $this->image->AdvancedSearch->load();
        $this->payment_details->AdvancedSearch->load();
        $this->bank_name->AdvancedSearch->load();
        $this->bank_ifsc_code->AdvancedSearch->load();
        $this->bank_account_no->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->d_operator->AdvancedSearch->load();
        $this->d_datetime->AdvancedSearch->load();
    }

    // Build export filter for selected records
    protected function buildExportSelectedFilter()
    {
        global $Language;
        $wrkFilter = "";
        if ($this->isExport()) {
            $wrkFilter = $this->getFilterFromRecordKeys();
        }
        return $wrkFilter;
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fproduction_employeelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fproduction_employeelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToExcel") . "</button>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fproduction_employeelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fproduction_employeelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToWord") . "</button>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fproduction_employeelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fproduction_employeelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToPdf") . "</button>";
            }
        } elseif (SameText($type, "html")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" form=\"fproduction_employeelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"html\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToHtml") . "</button>";
        } elseif (SameText($type, "xml")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" form=\"fproduction_employeelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"xml\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToXml") . "</button>";
        } elseif (SameText($type, "csv")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" form=\"fproduction_employeelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"csv\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToCsv") . "</button>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fproduction_employeelist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="true"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" form=\"fproduction_employeelist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"print\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("PrinterFriendly") . "</button>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fproduction_employeesrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"production_employee\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"productionemployeesearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"productionemployeesearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_site":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_contractor":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_gender":
                    break;
                case "x_marital_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
    	//echo "Page Render";
    	$item = &$this->OtherOptions['action']->Add("Print Employee Card");
    	$item->Body = "<button class=\"btn btn-danger ew-action\" onclick=\"javascript:PrintECard()\">Print Employee Card</button>";
    	$item->Visible = True;
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered() {
    	// Example:
    	//$this->ListOptions->Items["new"]->Body = "xxx";
    	$this->ListOptions->Add("Print Employee Card"); 
    	$this->ListOptions->Items["Print Employee Card"]->Body = '<a href="employeecard?id=' . $this->uid->CurrentValue .'" data-bs-original-title ="Print Employee Card" target="_blank"><i data-phrase="Print Employee Card"  class="fa fa-id-card fa-2x ew-icon" ></i></a>';
    	}

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
