<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductionEmployeeHsAdd extends ProductionEmployeeHs
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductionEmployeeHsAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "productionemployeehsadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->uid->Visible = false;
        $this->id->setVisibility();
        $this->grp->setVisibility();
        $this->site->setVisibility();
        $this->user_name->setVisibility();
        $this->address->setVisibility();
        $this->mobile->setVisibility();
        $this->category->Visible = false;
        $this->process->setVisibility();
        $this->employee_name->setVisibility();
        $this->gender->setVisibility();
        $this->father_name->setVisibility();
        $this->designation->setVisibility();
        $this->permanent_address->setVisibility();
        $this->city->setVisibility();
        $this->dob->setVisibility();
        $this->dom->setVisibility();
        $this->mobile_other->setVisibility();
        $this->mobile_family->setVisibility();
        $this->marital_status->setVisibility();
        $this->spouse_details->setVisibility();
        $this->emergency_details->setVisibility();
        $this->aadhaar_no->setVisibility();
        $this->id_proof->setVisibility();
        $this->reference_details->setVisibility();
        $this->other_details->setVisibility();
        $this->doj->setVisibility();
        $this->doc->setVisibility();
        $this->dol->setVisibility();
        $this->image->setVisibility();
        $this->payment_details->setVisibility();
        $this->bank_name->setVisibility();
        $this->bank_ifsc_code->setVisibility();
        $this->bank_account_no->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->d_operator->Visible = false;
        $this->d_datetime->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'production_employee_hs';
        $this->TableName = 'production_employee_hs';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (production_employee_hs)
        if (!isset($GLOBALS["production_employee_hs"]) || $GLOBALS["production_employee_hs"]::class == PROJECT_NAMESPACE . "production_employee_hs") {
            $GLOBALS["production_employee_hs"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'production_employee_hs');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "productionemployeehsview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['uid'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->uid->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->site);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->gender);
        $this->setupLookupOptions($this->marital_status);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("uid") ?? Route("uid")) !== null) {
                $this->uid->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("productionemployeehslist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "productionemployeehslist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "productionemployeehsview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "productionemployeehslist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "productionemployeehslist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->image->Upload->Index = $CurrentForm->Index;
        $this->image->Upload->uploadFile();
        $this->image->CurrentValue = $this->image->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->grp->DefaultValue = $this->grp->getDefault(); // PHP
        $this->grp->OldValue = $this->grp->DefaultValue;
        $this->site->DefaultValue = $this->site->getDefault(); // PHP
        $this->site->OldValue = $this->site->DefaultValue;
        $this->process->DefaultValue = $this->process->getDefault(); // PHP
        $this->process->OldValue = $this->process->DefaultValue;
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->id->Visible = false; // Disable update for API request
            } else {
                $this->id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 'site' first before field var 'x_site'
        $val = $CurrentForm->hasValue("site") ? $CurrentForm->getValue("site") : $CurrentForm->getValue("x_site");
        if (!$this->site->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->site->Visible = false; // Disable update for API request
            } else {
                $this->site->setFormValue($val);
            }
        }

        // Check field name 'user_name' first before field var 'x_user_name'
        $val = $CurrentForm->hasValue("user_name") ? $CurrentForm->getValue("user_name") : $CurrentForm->getValue("x_user_name");
        if (!$this->user_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->user_name->Visible = false; // Disable update for API request
            } else {
                $this->user_name->setFormValue($val);
            }
        }

        // Check field name 'address' first before field var 'x_address'
        $val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
        if (!$this->address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->address->Visible = false; // Disable update for API request
            } else {
                $this->address->setFormValue($val);
            }
        }

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile->Visible = false; // Disable update for API request
            } else {
                $this->mobile->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'process' first before field var 'x_process'
        $val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
        if (!$this->process->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->process->Visible = false; // Disable update for API request
            } else {
                $this->process->setFormValue($val);
            }
        }

        // Check field name 'employee_name' first before field var 'x_employee_name'
        $val = $CurrentForm->hasValue("employee_name") ? $CurrentForm->getValue("employee_name") : $CurrentForm->getValue("x_employee_name");
        if (!$this->employee_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employee_name->Visible = false; // Disable update for API request
            } else {
                $this->employee_name->setFormValue($val);
            }
        }

        // Check field name 'gender' first before field var 'x_gender'
        $val = $CurrentForm->hasValue("gender") ? $CurrentForm->getValue("gender") : $CurrentForm->getValue("x_gender");
        if (!$this->gender->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gender->Visible = false; // Disable update for API request
            } else {
                $this->gender->setFormValue($val);
            }
        }

        // Check field name 'father_name' first before field var 'x_father_name'
        $val = $CurrentForm->hasValue("father_name") ? $CurrentForm->getValue("father_name") : $CurrentForm->getValue("x_father_name");
        if (!$this->father_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->father_name->Visible = false; // Disable update for API request
            } else {
                $this->father_name->setFormValue($val);
            }
        }

        // Check field name 'designation' first before field var 'x_designation'
        $val = $CurrentForm->hasValue("designation") ? $CurrentForm->getValue("designation") : $CurrentForm->getValue("x_designation");
        if (!$this->designation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->designation->Visible = false; // Disable update for API request
            } else {
                $this->designation->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'permanent_address' first before field var 'x_permanent_address'
        $val = $CurrentForm->hasValue("permanent_address") ? $CurrentForm->getValue("permanent_address") : $CurrentForm->getValue("x_permanent_address");
        if (!$this->permanent_address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->permanent_address->Visible = false; // Disable update for API request
            } else {
                $this->permanent_address->setFormValue($val);
            }
        }

        // Check field name 'city' first before field var 'x_city'
        $val = $CurrentForm->hasValue("city") ? $CurrentForm->getValue("city") : $CurrentForm->getValue("x_city");
        if (!$this->city->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->city->Visible = false; // Disable update for API request
            } else {
                $this->city->setFormValue($val);
            }
        }

        // Check field name 'dob' first before field var 'x_dob'
        $val = $CurrentForm->hasValue("dob") ? $CurrentForm->getValue("dob") : $CurrentForm->getValue("x_dob");
        if (!$this->dob->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dob->Visible = false; // Disable update for API request
            } else {
                $this->dob->setFormValue($val, true, $validate);
            }
            $this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern());
        }

        // Check field name 'dom' first before field var 'x_dom'
        $val = $CurrentForm->hasValue("dom") ? $CurrentForm->getValue("dom") : $CurrentForm->getValue("x_dom");
        if (!$this->dom->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dom->Visible = false; // Disable update for API request
            } else {
                $this->dom->setFormValue($val, true, $validate);
            }
            $this->dom->CurrentValue = UnFormatDateTime($this->dom->CurrentValue, $this->dom->formatPattern());
        }

        // Check field name 'mobile_other' first before field var 'x_mobile_other'
        $val = $CurrentForm->hasValue("mobile_other") ? $CurrentForm->getValue("mobile_other") : $CurrentForm->getValue("x_mobile_other");
        if (!$this->mobile_other->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile_other->Visible = false; // Disable update for API request
            } else {
                $this->mobile_other->setFormValue($val);
            }
        }

        // Check field name 'mobile_family' first before field var 'x_mobile_family'
        $val = $CurrentForm->hasValue("mobile_family") ? $CurrentForm->getValue("mobile_family") : $CurrentForm->getValue("x_mobile_family");
        if (!$this->mobile_family->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile_family->Visible = false; // Disable update for API request
            } else {
                $this->mobile_family->setFormValue($val);
            }
        }

        // Check field name 'marital_status' first before field var 'x_marital_status'
        $val = $CurrentForm->hasValue("marital_status") ? $CurrentForm->getValue("marital_status") : $CurrentForm->getValue("x_marital_status");
        if (!$this->marital_status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->marital_status->Visible = false; // Disable update for API request
            } else {
                $this->marital_status->setFormValue($val);
            }
        }

        // Check field name 'spouse_details' first before field var 'x_spouse_details'
        $val = $CurrentForm->hasValue("spouse_details") ? $CurrentForm->getValue("spouse_details") : $CurrentForm->getValue("x_spouse_details");
        if (!$this->spouse_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->spouse_details->Visible = false; // Disable update for API request
            } else {
                $this->spouse_details->setFormValue($val);
            }
        }

        // Check field name 'emergency_details' first before field var 'x_emergency_details'
        $val = $CurrentForm->hasValue("emergency_details") ? $CurrentForm->getValue("emergency_details") : $CurrentForm->getValue("x_emergency_details");
        if (!$this->emergency_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->emergency_details->Visible = false; // Disable update for API request
            } else {
                $this->emergency_details->setFormValue($val);
            }
        }

        // Check field name 'aadhaar_no' first before field var 'x_aadhaar_no'
        $val = $CurrentForm->hasValue("aadhaar_no") ? $CurrentForm->getValue("aadhaar_no") : $CurrentForm->getValue("x_aadhaar_no");
        if (!$this->aadhaar_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->aadhaar_no->Visible = false; // Disable update for API request
            } else {
                $this->aadhaar_no->setFormValue($val);
            }
        }

        // Check field name 'id_proof' first before field var 'x_id_proof'
        $val = $CurrentForm->hasValue("id_proof") ? $CurrentForm->getValue("id_proof") : $CurrentForm->getValue("x_id_proof");
        if (!$this->id_proof->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->id_proof->Visible = false; // Disable update for API request
            } else {
                $this->id_proof->setFormValue($val);
            }
        }

        // Check field name 'reference_details' first before field var 'x_reference_details'
        $val = $CurrentForm->hasValue("reference_details") ? $CurrentForm->getValue("reference_details") : $CurrentForm->getValue("x_reference_details");
        if (!$this->reference_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reference_details->Visible = false; // Disable update for API request
            } else {
                $this->reference_details->setFormValue($val);
            }
        }

        // Check field name 'other_details' first before field var 'x_other_details'
        $val = $CurrentForm->hasValue("other_details") ? $CurrentForm->getValue("other_details") : $CurrentForm->getValue("x_other_details");
        if (!$this->other_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->other_details->Visible = false; // Disable update for API request
            } else {
                $this->other_details->setFormValue($val);
            }
        }

        // Check field name 'doj' first before field var 'x_doj'
        $val = $CurrentForm->hasValue("doj") ? $CurrentForm->getValue("doj") : $CurrentForm->getValue("x_doj");
        if (!$this->doj->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->doj->Visible = false; // Disable update for API request
            } else {
                $this->doj->setFormValue($val, true, $validate);
            }
            $this->doj->CurrentValue = UnFormatDateTime($this->doj->CurrentValue, $this->doj->formatPattern());
        }

        // Check field name 'doc' first before field var 'x_doc'
        $val = $CurrentForm->hasValue("doc") ? $CurrentForm->getValue("doc") : $CurrentForm->getValue("x_doc");
        if (!$this->doc->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->doc->Visible = false; // Disable update for API request
            } else {
                $this->doc->setFormValue($val, true, $validate);
            }
            $this->doc->CurrentValue = UnFormatDateTime($this->doc->CurrentValue, $this->doc->formatPattern());
        }

        // Check field name 'dol' first before field var 'x_dol'
        $val = $CurrentForm->hasValue("dol") ? $CurrentForm->getValue("dol") : $CurrentForm->getValue("x_dol");
        if (!$this->dol->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dol->Visible = false; // Disable update for API request
            } else {
                $this->dol->setFormValue($val, true, $validate);
            }
            $this->dol->CurrentValue = UnFormatDateTime($this->dol->CurrentValue, $this->dol->formatPattern());
        }

        // Check field name 'payment_details' first before field var 'x_payment_details'
        $val = $CurrentForm->hasValue("payment_details") ? $CurrentForm->getValue("payment_details") : $CurrentForm->getValue("x_payment_details");
        if (!$this->payment_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->payment_details->Visible = false; // Disable update for API request
            } else {
                $this->payment_details->setFormValue($val);
            }
        }

        // Check field name 'bank_name' first before field var 'x_bank_name'
        $val = $CurrentForm->hasValue("bank_name") ? $CurrentForm->getValue("bank_name") : $CurrentForm->getValue("x_bank_name");
        if (!$this->bank_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bank_name->Visible = false; // Disable update for API request
            } else {
                $this->bank_name->setFormValue($val);
            }
        }

        // Check field name 'bank_ifsc_code' first before field var 'x_bank_ifsc_code'
        $val = $CurrentForm->hasValue("bank_ifsc_code") ? $CurrentForm->getValue("bank_ifsc_code") : $CurrentForm->getValue("x_bank_ifsc_code");
        if (!$this->bank_ifsc_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bank_ifsc_code->Visible = false; // Disable update for API request
            } else {
                $this->bank_ifsc_code->setFormValue($val);
            }
        }

        // Check field name 'bank_account_no' first before field var 'x_bank_account_no'
        $val = $CurrentForm->hasValue("bank_account_no") ? $CurrentForm->getValue("bank_account_no") : $CurrentForm->getValue("x_bank_account_no");
        if (!$this->bank_account_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bank_account_no->Visible = false; // Disable update for API request
            } else {
                $this->bank_account_no->setFormValue($val);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'uid' first before field var 'x_uid'
        $val = $CurrentForm->hasValue("uid") ? $CurrentForm->getValue("uid") : $CurrentForm->getValue("x_uid");
		$this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
		$this->image->UploadPath = $this->image->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->site->CurrentValue = $this->site->FormValue;
        $this->user_name->CurrentValue = $this->user_name->FormValue;
        $this->address->CurrentValue = $this->address->FormValue;
        $this->mobile->CurrentValue = $this->mobile->FormValue;
        $this->process->CurrentValue = $this->process->FormValue;
        $this->employee_name->CurrentValue = $this->employee_name->FormValue;
        $this->gender->CurrentValue = $this->gender->FormValue;
        $this->father_name->CurrentValue = $this->father_name->FormValue;
        $this->designation->CurrentValue = $this->designation->FormValue;
        $this->permanent_address->CurrentValue = $this->permanent_address->FormValue;
        $this->city->CurrentValue = $this->city->FormValue;
        $this->dob->CurrentValue = $this->dob->FormValue;
        $this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern());
        $this->dom->CurrentValue = $this->dom->FormValue;
        $this->dom->CurrentValue = UnFormatDateTime($this->dom->CurrentValue, $this->dom->formatPattern());
        $this->mobile_other->CurrentValue = $this->mobile_other->FormValue;
        $this->mobile_family->CurrentValue = $this->mobile_family->FormValue;
        $this->marital_status->CurrentValue = $this->marital_status->FormValue;
        $this->spouse_details->CurrentValue = $this->spouse_details->FormValue;
        $this->emergency_details->CurrentValue = $this->emergency_details->FormValue;
        $this->aadhaar_no->CurrentValue = $this->aadhaar_no->FormValue;
        $this->id_proof->CurrentValue = $this->id_proof->FormValue;
        $this->reference_details->CurrentValue = $this->reference_details->FormValue;
        $this->other_details->CurrentValue = $this->other_details->FormValue;
        $this->doj->CurrentValue = $this->doj->FormValue;
        $this->doj->CurrentValue = UnFormatDateTime($this->doj->CurrentValue, $this->doj->formatPattern());
        $this->doc->CurrentValue = $this->doc->FormValue;
        $this->doc->CurrentValue = UnFormatDateTime($this->doc->CurrentValue, $this->doc->formatPattern());
        $this->dol->CurrentValue = $this->dol->FormValue;
        $this->dol->CurrentValue = UnFormatDateTime($this->dol->CurrentValue, $this->dol->formatPattern());
        $this->payment_details->CurrentValue = $this->payment_details->FormValue;
        $this->bank_name->CurrentValue = $this->bank_name->FormValue;
        $this->bank_ifsc_code->CurrentValue = $this->bank_ifsc_code->FormValue;
        $this->bank_account_no->CurrentValue = $this->bank_account_no->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->uid->setDbValue($row['uid']);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->site->setDbValue($row['site']);
        $this->user_name->setDbValue($row['user_name']);
        $this->address->setDbValue($row['address']);
        $this->mobile->setDbValue($row['mobile']);
        $this->category->setDbValue($row['category']);
        $this->process->setDbValue($row['process']);
        $this->employee_name->setDbValue($row['employee_name']);
        $this->gender->setDbValue($row['gender']);
        $this->father_name->setDbValue($row['father_name']);
        $this->designation->setDbValue($row['designation']);
        $this->permanent_address->setDbValue($row['permanent_address']);
        $this->city->setDbValue($row['city']);
        $this->dob->setDbValue($row['dob']);
        $this->dom->setDbValue($row['dom']);
        $this->mobile_other->setDbValue($row['mobile_other']);
        $this->mobile_family->setDbValue($row['mobile_family']);
        $this->marital_status->setDbValue($row['marital_status']);
        $this->spouse_details->setDbValue($row['spouse_details']);
        $this->emergency_details->setDbValue($row['emergency_details']);
        $this->aadhaar_no->setDbValue($row['aadhaar_no']);
        $this->id_proof->setDbValue($row['id_proof']);
        $this->reference_details->setDbValue($row['reference_details']);
        $this->other_details->setDbValue($row['other_details']);
        $this->doj->setDbValue($row['doj']);
        $this->doc->setDbValue($row['doc']);
        $this->dol->setDbValue($row['dol']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->payment_details->setDbValue($row['payment_details']);
        $this->bank_name->setDbValue($row['bank_name']);
        $this->bank_ifsc_code->setDbValue($row['bank_ifsc_code']);
        $this->bank_account_no->setDbValue($row['bank_account_no']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->d_operator->setDbValue($row['d_operator']);
        $this->d_datetime->setDbValue($row['d_datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['uid'] = $this->uid->DefaultValue;
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['site'] = $this->site->DefaultValue;
        $row['user_name'] = $this->user_name->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['employee_name'] = $this->employee_name->DefaultValue;
        $row['gender'] = $this->gender->DefaultValue;
        $row['father_name'] = $this->father_name->DefaultValue;
        $row['designation'] = $this->designation->DefaultValue;
        $row['permanent_address'] = $this->permanent_address->DefaultValue;
        $row['city'] = $this->city->DefaultValue;
        $row['dob'] = $this->dob->DefaultValue;
        $row['dom'] = $this->dom->DefaultValue;
        $row['mobile_other'] = $this->mobile_other->DefaultValue;
        $row['mobile_family'] = $this->mobile_family->DefaultValue;
        $row['marital_status'] = $this->marital_status->DefaultValue;
        $row['spouse_details'] = $this->spouse_details->DefaultValue;
        $row['emergency_details'] = $this->emergency_details->DefaultValue;
        $row['aadhaar_no'] = $this->aadhaar_no->DefaultValue;
        $row['id_proof'] = $this->id_proof->DefaultValue;
        $row['reference_details'] = $this->reference_details->DefaultValue;
        $row['other_details'] = $this->other_details->DefaultValue;
        $row['doj'] = $this->doj->DefaultValue;
        $row['doc'] = $this->doc->DefaultValue;
        $row['dol'] = $this->dol->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['payment_details'] = $this->payment_details->DefaultValue;
        $row['bank_name'] = $this->bank_name->DefaultValue;
        $row['bank_ifsc_code'] = $this->bank_ifsc_code->DefaultValue;
        $row['bank_account_no'] = $this->bank_account_no->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['d_operator'] = $this->d_operator->DefaultValue;
        $row['d_datetime'] = $this->d_datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // uid
        $this->uid->RowCssClass = "row";

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // site
        $this->site->RowCssClass = "row";

        // user_name
        $this->user_name->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // employee_name
        $this->employee_name->RowCssClass = "row";

        // gender
        $this->gender->RowCssClass = "row";

        // father_name
        $this->father_name->RowCssClass = "row";

        // designation
        $this->designation->RowCssClass = "row";

        // permanent_address
        $this->permanent_address->RowCssClass = "row";

        // city
        $this->city->RowCssClass = "row";

        // dob
        $this->dob->RowCssClass = "row";

        // dom
        $this->dom->RowCssClass = "row";

        // mobile_other
        $this->mobile_other->RowCssClass = "row";

        // mobile_family
        $this->mobile_family->RowCssClass = "row";

        // marital_status
        $this->marital_status->RowCssClass = "row";

        // spouse_details
        $this->spouse_details->RowCssClass = "row";

        // emergency_details
        $this->emergency_details->RowCssClass = "row";

        // aadhaar_no
        $this->aadhaar_no->RowCssClass = "row";

        // id_proof
        $this->id_proof->RowCssClass = "row";

        // reference_details
        $this->reference_details->RowCssClass = "row";

        // other_details
        $this->other_details->RowCssClass = "row";

        // doj
        $this->doj->RowCssClass = "row";

        // doc
        $this->doc->RowCssClass = "row";

        // dol
        $this->dol->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // payment_details
        $this->payment_details->RowCssClass = "row";

        // bank_name
        $this->bank_name->RowCssClass = "row";

        // bank_ifsc_code
        $this->bank_ifsc_code->RowCssClass = "row";

        // bank_account_no
        $this->bank_account_no->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // d_operator
        $this->d_operator->RowCssClass = "row";

        // d_datetime
        $this->d_datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // uid
            $this->uid->ViewValue = $this->uid->CurrentValue;

            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // grp
            if (strval($this->grp->CurrentValue) != "") {
                $this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
            } else {
                $this->grp->ViewValue = null;
            }

            // site
            $curVal = strval($this->site->CurrentValue);
            if ($curVal != "") {
                $this->site->ViewValue = $this->site->lookupCacheOption($curVal);
                if ($this->site->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->site->getSelectFilter($this); // PHP
                    $sqlWrk = $this->site->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->site->Lookup->renderViewRow($rswrk[0]);
                        $this->site->ViewValue = $this->site->displayValue($arwrk);
                    } else {
                        $this->site->ViewValue = $this->site->CurrentValue;
                    }
                }
            } else {
                $this->site->ViewValue = null;
            }

            // user_name
            $this->user_name->ViewValue = $this->user_name->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, $this->mobile->formatPattern());

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process->Lookup->renderViewRow($row);
                            $this->process->ViewValue->add($this->process->displayValue($arwrk));
                        }
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // employee_name
            $this->employee_name->ViewValue = $this->employee_name->CurrentValue;

            // gender
            if (strval($this->gender->CurrentValue) != "") {
                $this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
            } else {
                $this->gender->ViewValue = null;
            }

            // father_name
            $this->father_name->ViewValue = $this->father_name->CurrentValue;

            // designation
            $this->designation->ViewValue = $this->designation->CurrentValue;
            $this->designation->ViewValue = FormatNumber($this->designation->ViewValue, $this->designation->formatPattern());

            // permanent_address
            $this->permanent_address->ViewValue = $this->permanent_address->CurrentValue;

            // city
            $this->city->ViewValue = $this->city->CurrentValue;

            // dob
            $this->dob->ViewValue = $this->dob->CurrentValue;
            $this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, $this->dob->formatPattern());

            // dom
            $this->dom->ViewValue = $this->dom->CurrentValue;
            $this->dom->ViewValue = FormatDateTime($this->dom->ViewValue, $this->dom->formatPattern());

            // mobile_other
            $this->mobile_other->ViewValue = $this->mobile_other->CurrentValue;

            // mobile_family
            $this->mobile_family->ViewValue = $this->mobile_family->CurrentValue;

            // marital_status
            if (strval($this->marital_status->CurrentValue) != "") {
                $this->marital_status->ViewValue = $this->marital_status->optionCaption($this->marital_status->CurrentValue);
            } else {
                $this->marital_status->ViewValue = null;
            }

            // spouse_details
            $this->spouse_details->ViewValue = $this->spouse_details->CurrentValue;

            // emergency_details
            $this->emergency_details->ViewValue = $this->emergency_details->CurrentValue;

            // aadhaar_no
            $this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;

            // id_proof
            $this->id_proof->ViewValue = $this->id_proof->CurrentValue;

            // reference_details
            $this->reference_details->ViewValue = $this->reference_details->CurrentValue;

            // other_details
            $this->other_details->ViewValue = $this->other_details->CurrentValue;

            // doj
            $this->doj->ViewValue = $this->doj->CurrentValue;
            $this->doj->ViewValue = FormatDateTime($this->doj->ViewValue, $this->doj->formatPattern());

            // doc
            $this->doc->ViewValue = $this->doc->CurrentValue;
            $this->doc->ViewValue = FormatDateTime($this->doc->ViewValue, $this->doc->formatPattern());

            // dol
            $this->dol->ViewValue = $this->dol->CurrentValue;
            $this->dol->ViewValue = FormatDateTime($this->dol->ViewValue, $this->dol->formatPattern());

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // payment_details
            $this->payment_details->ViewValue = $this->payment_details->CurrentValue;

            // bank_name
            $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

            // bank_ifsc_code
            $this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;

            // bank_account_no
            $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // d_operator
            $this->d_operator->ViewValue = $this->d_operator->CurrentValue;
            $this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, $this->d_operator->formatPattern());

            // d_datetime
            $this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
            $this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, $this->d_datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // site
            if (!EmptyValue($this->site->CurrentValue)) {
                $this->site->HrefValue = $this->site->getLinkPrefix() . $this->site->CurrentValue; // Add prefix/suffix
                $this->site->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->site->HrefValue = FullUrl($this->site->HrefValue, "href");
                }
            } else {
                $this->site->HrefValue = "";
            }

            // user_name
            if (!EmptyValue($this->user_name->CurrentValue)) {
                $this->user_name->HrefValue = $this->user_name->getLinkPrefix() . $this->user_name->CurrentValue; // Add prefix/suffix
                $this->user_name->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->user_name->HrefValue = FullUrl($this->user_name->HrefValue, "href");
                }
            } else {
                $this->user_name->HrefValue = "";
            }

            // address
            $this->address->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }

            // employee_name
            if (!EmptyValue($this->employee_name->CurrentValue)) {
                $this->employee_name->HrefValue = $this->employee_name->getLinkPrefix() . $this->employee_name->CurrentValue; // Add prefix/suffix
                $this->employee_name->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->employee_name->HrefValue = FullUrl($this->employee_name->HrefValue, "href");
                }
            } else {
                $this->employee_name->HrefValue = "";
            }

            // gender
            $this->gender->HrefValue = "";

            // father_name
            $this->father_name->HrefValue = "";

            // designation
            if (!EmptyValue($this->designation->CurrentValue)) {
                $this->designation->HrefValue = $this->designation->getLinkPrefix() . $this->designation->CurrentValue; // Add prefix/suffix
                $this->designation->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->designation->HrefValue = FullUrl($this->designation->HrefValue, "href");
                }
            } else {
                $this->designation->HrefValue = "";
            }

            // permanent_address
            $this->permanent_address->HrefValue = "";

            // city
            $this->city->HrefValue = "";

            // dob
            $this->dob->HrefValue = "";

            // dom
            $this->dom->HrefValue = "";

            // mobile_other
            $this->mobile_other->HrefValue = "";

            // mobile_family
            $this->mobile_family->HrefValue = "";

            // marital_status
            $this->marital_status->HrefValue = "";

            // spouse_details
            $this->spouse_details->HrefValue = "";

            // emergency_details
            $this->emergency_details->HrefValue = "";

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";

            // id_proof
            $this->id_proof->HrefValue = "";

            // reference_details
            $this->reference_details->HrefValue = "";

            // other_details
            $this->other_details->HrefValue = "";

            // doj
            $this->doj->HrefValue = "";

            // doc
            $this->doc->HrefValue = "";

            // dol
            $this->dol->HrefValue = "";

            // image
            $this->image->HrefValue = "";
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

            // payment_details
            $this->payment_details->HrefValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";

            // bank_ifsc_code
            $this->bank_ifsc_code->HrefValue = "";

            // bank_account_no
            $this->bank_account_no->HrefValue = "";

            // status
            if (!EmptyValue($this->status->CurrentValue)) {
                $this->status->HrefValue = $this->status->getLinkPrefix() . $this->status->CurrentValue; // Add prefix/suffix
                $this->status->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
                }
            } else {
                $this->status->HrefValue = "";
            }

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());
            if (strval($this->id->EditValue) != "" && is_numeric($this->id->EditValue)) {
                $this->id->EditValue = FormatNumber($this->id->EditValue, null);
            }

            // grp
            $this->grp->setupEditAttributes();
            $this->grp->EditValue = $this->grp->options(true);
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // site
            $this->site->setupEditAttributes();
            $curVal = trim(strval($this->site->CurrentValue));
            if ($curVal != "") {
                $this->site->ViewValue = $this->site->lookupCacheOption($curVal);
            } else {
                $this->site->ViewValue = $this->site->Lookup !== null && is_array($this->site->lookupOptions()) && count($this->site->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->site->ViewValue !== null) { // Load from cache
                $this->site->EditValue = array_values($this->site->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->site->CurrentValue, $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->site->getSelectFilter($this); // PHP
                $sqlWrk = $this->site->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->site->EditValue = $arwrk;
            }
            $this->site->PlaceHolder = RemoveHtml($this->site->caption());

            // user_name
            $this->user_name->setupEditAttributes();
            if (!$this->user_name->Raw) {
                $this->user_name->CurrentValue = HtmlDecode($this->user_name->CurrentValue);
            }
            $this->user_name->EditValue = HtmlEncode($this->user_name->CurrentValue);
            $this->user_name->PlaceHolder = RemoveHtml($this->user_name->caption());

            // address
            $this->address->setupEditAttributes();
            $this->address->EditValue = HtmlEncode($this->address->CurrentValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            $this->mobile->EditValue = $this->mobile->CurrentValue;
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());
            if (strval($this->mobile->EditValue) != "" && is_numeric($this->mobile->EditValue)) {
                $this->mobile->EditValue = FormatNumber($this->mobile->EditValue, null);
            }

            // process
            $curVal = trim(strval($this->process->CurrentValue));
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            } else {
                $this->process->ViewValue = $this->process->Lookup !== null && is_array($this->process->lookupOptions()) && count($this->process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process->ViewValue !== null) { // Load from cache
                $this->process->EditValue = array_values($this->process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process->EditValue = $arwrk;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // employee_name
            $this->employee_name->setupEditAttributes();
            if (!$this->employee_name->Raw) {
                $this->employee_name->CurrentValue = HtmlDecode($this->employee_name->CurrentValue);
            }
            $this->employee_name->EditValue = HtmlEncode($this->employee_name->CurrentValue);
            $this->employee_name->PlaceHolder = RemoveHtml($this->employee_name->caption());

            // gender
            $this->gender->EditValue = $this->gender->options(false);
            $this->gender->PlaceHolder = RemoveHtml($this->gender->caption());

            // father_name
            $this->father_name->setupEditAttributes();
            if (!$this->father_name->Raw) {
                $this->father_name->CurrentValue = HtmlDecode($this->father_name->CurrentValue);
            }
            $this->father_name->EditValue = HtmlEncode($this->father_name->CurrentValue);
            $this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

            // designation
            $this->designation->setupEditAttributes();
            $this->designation->EditValue = $this->designation->CurrentValue;
            $this->designation->PlaceHolder = RemoveHtml($this->designation->caption());
            if (strval($this->designation->EditValue) != "" && is_numeric($this->designation->EditValue)) {
                $this->designation->EditValue = FormatNumber($this->designation->EditValue, null);
            }

            // permanent_address
            $this->permanent_address->setupEditAttributes();
            $this->permanent_address->EditValue = HtmlEncode($this->permanent_address->CurrentValue);
            $this->permanent_address->PlaceHolder = RemoveHtml($this->permanent_address->caption());

            // city
            $this->city->setupEditAttributes();
            if (!$this->city->Raw) {
                $this->city->CurrentValue = HtmlDecode($this->city->CurrentValue);
            }
            $this->city->EditValue = HtmlEncode($this->city->CurrentValue);
            $this->city->PlaceHolder = RemoveHtml($this->city->caption());

            // dob
            $this->dob->setupEditAttributes();
            $this->dob->EditValue = HtmlEncode(FormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern()));
            $this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

            // dom
            $this->dom->setupEditAttributes();
            $this->dom->EditValue = HtmlEncode(FormatDateTime($this->dom->CurrentValue, $this->dom->formatPattern()));
            $this->dom->PlaceHolder = RemoveHtml($this->dom->caption());

            // mobile_other
            $this->mobile_other->setupEditAttributes();
            if (!$this->mobile_other->Raw) {
                $this->mobile_other->CurrentValue = HtmlDecode($this->mobile_other->CurrentValue);
            }
            $this->mobile_other->EditValue = HtmlEncode($this->mobile_other->CurrentValue);
            $this->mobile_other->PlaceHolder = RemoveHtml($this->mobile_other->caption());

            // mobile_family
            $this->mobile_family->setupEditAttributes();
            if (!$this->mobile_family->Raw) {
                $this->mobile_family->CurrentValue = HtmlDecode($this->mobile_family->CurrentValue);
            }
            $this->mobile_family->EditValue = HtmlEncode($this->mobile_family->CurrentValue);
            $this->mobile_family->PlaceHolder = RemoveHtml($this->mobile_family->caption());

            // marital_status
            $this->marital_status->EditValue = $this->marital_status->options(false);
            $this->marital_status->PlaceHolder = RemoveHtml($this->marital_status->caption());

            // spouse_details
            $this->spouse_details->setupEditAttributes();
            if (!$this->spouse_details->Raw) {
                $this->spouse_details->CurrentValue = HtmlDecode($this->spouse_details->CurrentValue);
            }
            $this->spouse_details->EditValue = HtmlEncode($this->spouse_details->CurrentValue);
            $this->spouse_details->PlaceHolder = RemoveHtml($this->spouse_details->caption());

            // emergency_details
            $this->emergency_details->setupEditAttributes();
            if (!$this->emergency_details->Raw) {
                $this->emergency_details->CurrentValue = HtmlDecode($this->emergency_details->CurrentValue);
            }
            $this->emergency_details->EditValue = HtmlEncode($this->emergency_details->CurrentValue);
            $this->emergency_details->PlaceHolder = RemoveHtml($this->emergency_details->caption());

            // aadhaar_no
            $this->aadhaar_no->setupEditAttributes();
            if (!$this->aadhaar_no->Raw) {
                $this->aadhaar_no->CurrentValue = HtmlDecode($this->aadhaar_no->CurrentValue);
            }
            $this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->CurrentValue);
            $this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

            // id_proof
            $this->id_proof->setupEditAttributes();
            if (!$this->id_proof->Raw) {
                $this->id_proof->CurrentValue = HtmlDecode($this->id_proof->CurrentValue);
            }
            $this->id_proof->EditValue = HtmlEncode($this->id_proof->CurrentValue);
            $this->id_proof->PlaceHolder = RemoveHtml($this->id_proof->caption());

            // reference_details
            $this->reference_details->setupEditAttributes();
            if (!$this->reference_details->Raw) {
                $this->reference_details->CurrentValue = HtmlDecode($this->reference_details->CurrentValue);
            }
            $this->reference_details->EditValue = HtmlEncode($this->reference_details->CurrentValue);
            $this->reference_details->PlaceHolder = RemoveHtml($this->reference_details->caption());

            // other_details
            $this->other_details->setupEditAttributes();
            $this->other_details->EditValue = HtmlEncode($this->other_details->CurrentValue);
            $this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

            // doj
            $this->doj->setupEditAttributes();
            $this->doj->EditValue = HtmlEncode(FormatDateTime($this->doj->CurrentValue, $this->doj->formatPattern()));
            $this->doj->PlaceHolder = RemoveHtml($this->doj->caption());

            // doc
            $this->doc->setupEditAttributes();
            $this->doc->EditValue = HtmlEncode(FormatDateTime($this->doc->CurrentValue, $this->doc->formatPattern()));
            $this->doc->PlaceHolder = RemoveHtml($this->doc->caption());

            // dol
            $this->dol->setupEditAttributes();
            $this->dol->EditValue = HtmlEncode(FormatDateTime($this->dol->CurrentValue, $this->dol->formatPattern()));
            $this->dol->PlaceHolder = RemoveHtml($this->dol->caption());

            // image
            $this->image->setupEditAttributes();
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->EditValue = $this->image->Upload->DbValue;
            } else {
                $this->image->EditValue = "";
            }
            if (!EmptyValue($this->image->CurrentValue)) {
                $this->image->Upload->FileName = $this->image->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->image->Upload->DbValue = null;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->image);
            }

            // payment_details
            $this->payment_details->setupEditAttributes();
            $this->payment_details->EditValue = HtmlEncode($this->payment_details->CurrentValue);
            $this->payment_details->PlaceHolder = RemoveHtml($this->payment_details->caption());

            // bank_name
            $this->bank_name->setupEditAttributes();
            if (!$this->bank_name->Raw) {
                $this->bank_name->CurrentValue = HtmlDecode($this->bank_name->CurrentValue);
            }
            $this->bank_name->EditValue = HtmlEncode($this->bank_name->CurrentValue);
            $this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

            // bank_ifsc_code
            $this->bank_ifsc_code->setupEditAttributes();
            if (!$this->bank_ifsc_code->Raw) {
                $this->bank_ifsc_code->CurrentValue = HtmlDecode($this->bank_ifsc_code->CurrentValue);
            }
            $this->bank_ifsc_code->EditValue = HtmlEncode($this->bank_ifsc_code->CurrentValue);
            $this->bank_ifsc_code->PlaceHolder = RemoveHtml($this->bank_ifsc_code->caption());

            // bank_account_no
            $this->bank_account_no->setupEditAttributes();
            if (!$this->bank_account_no->Raw) {
                $this->bank_account_no->CurrentValue = HtmlDecode($this->bank_account_no->CurrentValue);
            }
            $this->bank_account_no->EditValue = HtmlEncode($this->bank_account_no->CurrentValue);
            $this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator

            // datetime

            // Add refer script

            // id
            $this->id->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // site
            if (!EmptyValue($this->site->CurrentValue)) {
                $this->site->HrefValue = $this->site->getLinkPrefix() . $this->site->CurrentValue; // Add prefix/suffix
                $this->site->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->site->HrefValue = FullUrl($this->site->HrefValue, "href");
                }
            } else {
                $this->site->HrefValue = "";
            }

            // user_name
            if (!EmptyValue($this->user_name->CurrentValue)) {
                $this->user_name->HrefValue = $this->user_name->getLinkPrefix() . $this->user_name->CurrentValue; // Add prefix/suffix
                $this->user_name->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->user_name->HrefValue = FullUrl($this->user_name->HrefValue, "href");
                }
            } else {
                $this->user_name->HrefValue = "";
            }

            // address
            $this->address->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }

            // employee_name
            if (!EmptyValue($this->employee_name->CurrentValue)) {
                $this->employee_name->HrefValue = $this->employee_name->getLinkPrefix() . $this->employee_name->CurrentValue; // Add prefix/suffix
                $this->employee_name->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->employee_name->HrefValue = FullUrl($this->employee_name->HrefValue, "href");
                }
            } else {
                $this->employee_name->HrefValue = "";
            }

            // gender
            $this->gender->HrefValue = "";

            // father_name
            $this->father_name->HrefValue = "";

            // designation
            if (!EmptyValue($this->designation->CurrentValue)) {
                $this->designation->HrefValue = $this->designation->getLinkPrefix() . $this->designation->CurrentValue; // Add prefix/suffix
                $this->designation->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->designation->HrefValue = FullUrl($this->designation->HrefValue, "href");
                }
            } else {
                $this->designation->HrefValue = "";
            }

            // permanent_address
            $this->permanent_address->HrefValue = "";

            // city
            $this->city->HrefValue = "";

            // dob
            $this->dob->HrefValue = "";

            // dom
            $this->dom->HrefValue = "";

            // mobile_other
            $this->mobile_other->HrefValue = "";

            // mobile_family
            $this->mobile_family->HrefValue = "";

            // marital_status
            $this->marital_status->HrefValue = "";

            // spouse_details
            $this->spouse_details->HrefValue = "";

            // emergency_details
            $this->emergency_details->HrefValue = "";

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";

            // id_proof
            $this->id_proof->HrefValue = "";

            // reference_details
            $this->reference_details->HrefValue = "";

            // other_details
            $this->other_details->HrefValue = "";

            // doj
            $this->doj->HrefValue = "";

            // doc
            $this->doc->HrefValue = "";

            // dol
            $this->dol->HrefValue = "";

            // image
            $this->image->HrefValue = "";
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

            // payment_details
            $this->payment_details->HrefValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";

            // bank_ifsc_code
            $this->bank_ifsc_code->HrefValue = "";

            // bank_account_no
            $this->bank_account_no->HrefValue = "";

            // status
            if (!EmptyValue($this->status->CurrentValue)) {
                $this->status->HrefValue = $this->status->getLinkPrefix() . $this->status->CurrentValue; // Add prefix/suffix
                $this->status->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
                }
            } else {
                $this->status->HrefValue = "";
            }

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Render add option
    public function renderAddOpt($row)
    {
        global $Security, $Language, $CurrentLanguage;

        // Set up CurrentValue
        $this->id->CurrentValue = $row["id"] ?? null;
        $this->grp->CurrentValue = $row["grp"] ?? null;
        $this->site->CurrentValue = $row["site"] ?? null;
        $this->user_name->CurrentValue = $row["user_name"] ?? null;
        $this->address->CurrentValue = $row["address"] ?? null;
        $this->mobile->CurrentValue = $row["mobile"] ?? null;
        $this->process->CurrentValue = $row["process"] ?? null;
        $this->employee_name->CurrentValue = $row["employee_name"] ?? null;
        $this->gender->CurrentValue = $row["gender"] ?? null;
        $this->father_name->CurrentValue = $row["father_name"] ?? null;
        $this->designation->CurrentValue = $row["designation"] ?? null;
        $this->permanent_address->CurrentValue = $row["permanent_address"] ?? null;
        $this->city->CurrentValue = $row["city"] ?? null;
        $this->dob->CurrentValue = $row["dob"] ?? null;
        $this->dom->CurrentValue = $row["dom"] ?? null;
        $this->mobile_other->CurrentValue = $row["mobile_other"] ?? null;
        $this->mobile_family->CurrentValue = $row["mobile_family"] ?? null;
        $this->marital_status->CurrentValue = $row["marital_status"] ?? null;
        $this->spouse_details->CurrentValue = $row["spouse_details"] ?? null;
        $this->emergency_details->CurrentValue = $row["emergency_details"] ?? null;
        $this->aadhaar_no->CurrentValue = $row["aadhaar_no"] ?? null;
        $this->id_proof->CurrentValue = $row["id_proof"] ?? null;
        $this->reference_details->CurrentValue = $row["reference_details"] ?? null;
        $this->other_details->CurrentValue = $row["other_details"] ?? null;
        $this->doj->CurrentValue = $row["doj"] ?? null;
        $this->doc->CurrentValue = $row["doc"] ?? null;
        $this->dol->CurrentValue = $row["dol"] ?? null;
        $this->image->CurrentValue = $row["image"] ?? null;
        $this->payment_details->CurrentValue = $row["payment_details"] ?? null;
        $this->bank_name->CurrentValue = $row["bank_name"] ?? null;
        $this->bank_ifsc_code->CurrentValue = $row["bank_ifsc_code"] ?? null;
        $this->bank_account_no->CurrentValue = $row["bank_account_no"] ?? null;
        $this->status->CurrentValue = $row["status"] ?? null;
        $this->operator->CurrentValue = $row["operator"] ?? null;
        $this->datetime->CurrentValue = $row["datetime"] ?? null;

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

        // grp
        if (strval($this->grp->CurrentValue) != "") {
            $this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
        } else {
            $this->grp->ViewValue = null;
        }

        // site
        $curVal = strval($this->site->CurrentValue);
        if ($curVal != "") {
            $this->site->ViewValue = $this->site->lookupCacheOption($curVal);
            if ($this->site->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->site->getSelectFilter($this); // PHP
                $sqlWrk = $this->site->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->site->Lookup->renderViewRow($rswrk[0]);
                    $this->site->ViewValue = $this->site->displayValue($arwrk);
                } else {
                    $this->site->ViewValue = $this->site->CurrentValue;
                }
            }
        } else {
            $this->site->ViewValue = null;
        }

        // user_name
        $this->user_name->ViewValue = $this->user_name->CurrentValue;

        // address
        $this->address->ViewValue = $this->address->CurrentValue;

        // mobile
        $this->mobile->ViewValue = $this->mobile->CurrentValue;
        $this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, $this->mobile->formatPattern());

        // process
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->process->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->process->Lookup->renderViewRow($row);
                        $this->process->ViewValue->add($this->process->displayValue($arwrk));
                    }
                } else {
                    $this->process->ViewValue = $this->process->CurrentValue;
                }
            }
        } else {
            $this->process->ViewValue = null;
        }

        // employee_name
        $this->employee_name->ViewValue = $this->employee_name->CurrentValue;

        // gender
        if (strval($this->gender->CurrentValue) != "") {
            $this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
        } else {
            $this->gender->ViewValue = null;
        }

        // father_name
        $this->father_name->ViewValue = $this->father_name->CurrentValue;

        // designation
        $this->designation->ViewValue = $this->designation->CurrentValue;
        $this->designation->ViewValue = FormatNumber($this->designation->ViewValue, $this->designation->formatPattern());

        // permanent_address
        $this->permanent_address->ViewValue = $this->permanent_address->CurrentValue;

        // city
        $this->city->ViewValue = $this->city->CurrentValue;

        // dob
        $this->dob->ViewValue = $this->dob->CurrentValue;
        $this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, $this->dob->formatPattern());

        // dom
        $this->dom->ViewValue = $this->dom->CurrentValue;
        $this->dom->ViewValue = FormatDateTime($this->dom->ViewValue, $this->dom->formatPattern());

        // mobile_other
        $this->mobile_other->ViewValue = $this->mobile_other->CurrentValue;

        // mobile_family
        $this->mobile_family->ViewValue = $this->mobile_family->CurrentValue;

        // marital_status
        if (strval($this->marital_status->CurrentValue) != "") {
            $this->marital_status->ViewValue = $this->marital_status->optionCaption($this->marital_status->CurrentValue);
        } else {
            $this->marital_status->ViewValue = null;
        }

        // spouse_details
        $this->spouse_details->ViewValue = $this->spouse_details->CurrentValue;

        // emergency_details
        $this->emergency_details->ViewValue = $this->emergency_details->CurrentValue;

        // aadhaar_no
        $this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;

        // id_proof
        $this->id_proof->ViewValue = $this->id_proof->CurrentValue;

        // reference_details
        $this->reference_details->ViewValue = $this->reference_details->CurrentValue;

        // other_details
        $this->other_details->ViewValue = $this->other_details->CurrentValue;

        // doj
        $this->doj->ViewValue = $this->doj->CurrentValue;
        $this->doj->ViewValue = FormatDateTime($this->doj->ViewValue, $this->doj->formatPattern());

        // doc
        $this->doc->ViewValue = $this->doc->CurrentValue;
        $this->doc->ViewValue = FormatDateTime($this->doc->ViewValue, $this->doc->formatPattern());

        // dol
        $this->dol->ViewValue = $this->dol->CurrentValue;
        $this->dol->ViewValue = FormatDateTime($this->dol->ViewValue, $this->dol->formatPattern());

        // image
        $this->image->UploadPath = $this->image->getUploadPath(); // PHP
        if (!EmptyValue($this->image->Upload->DbValue)) {
            $this->image->ViewValue = $this->image->Upload->DbValue;
        } else {
            $this->image->ViewValue = "";
        }

        // payment_details
        $this->payment_details->ViewValue = $this->payment_details->CurrentValue;

        // bank_name
        $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

        // bank_ifsc_code
        $this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;

        // bank_account_no
        $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // Set up $row
        $row["id"] = $this->id->ViewValue;
        $row["grp"] = $this->grp->ViewValue;
        $row["site"] = $this->site->ViewValue;
        $row["user_name"] = $this->user_name->ViewValue;
        $row["address"] = $this->address->ViewValue;
        $row["mobile"] = $this->mobile->ViewValue;
        $row["process"] = $this->process->ViewValue;
        $row["employee_name"] = $this->employee_name->ViewValue;
        $row["gender"] = $this->gender->ViewValue;
        $row["father_name"] = $this->father_name->ViewValue;
        $row["designation"] = $this->designation->ViewValue;
        $row["permanent_address"] = $this->permanent_address->ViewValue;
        $row["city"] = $this->city->ViewValue;
        $row["dob"] = $this->dob->ViewValue;
        $row["dom"] = $this->dom->ViewValue;
        $row["mobile_other"] = $this->mobile_other->ViewValue;
        $row["mobile_family"] = $this->mobile_family->ViewValue;
        $row["marital_status"] = $this->marital_status->ViewValue;
        $row["spouse_details"] = $this->spouse_details->ViewValue;
        $row["emergency_details"] = $this->emergency_details->ViewValue;
        $row["aadhaar_no"] = $this->aadhaar_no->ViewValue;
        $row["id_proof"] = $this->id_proof->ViewValue;
        $row["reference_details"] = $this->reference_details->ViewValue;
        $row["other_details"] = $this->other_details->ViewValue;
        $row["doj"] = $this->doj->ViewValue;
        $row["doc"] = $this->doc->ViewValue;
        $row["dol"] = $this->dol->ViewValue;
        $row["image"] = $this->image->ViewValue;
        $row["payment_details"] = $this->payment_details->ViewValue;
        $row["bank_name"] = $this->bank_name->ViewValue;
        $row["bank_ifsc_code"] = $this->bank_ifsc_code->ViewValue;
        $row["bank_account_no"] = $this->bank_account_no->ViewValue;
        $row["status"] = $this->status->ViewValue;
        $row["operator"] = $this->operator->ViewValue;
        $row["datetime"] = $this->datetime->ViewValue;
        return $row;
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->id->FormValue)) {
                $this->id->addErrorMessage($this->id->getErrorMessage(false));
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->site->Visible && $this->site->Required) {
                if (!$this->site->IsDetailKey && EmptyValue($this->site->FormValue)) {
                    $this->site->addErrorMessage(str_replace("%s", $this->site->caption(), $this->site->RequiredErrorMessage));
                }
            }
            if ($this->user_name->Visible && $this->user_name->Required) {
                if (!$this->user_name->IsDetailKey && EmptyValue($this->user_name->FormValue)) {
                    $this->user_name->addErrorMessage(str_replace("%s", $this->user_name->caption(), $this->user_name->RequiredErrorMessage));
                }
            }
            if ($this->address->Visible && $this->address->Required) {
                if (!$this->address->IsDetailKey && EmptyValue($this->address->FormValue)) {
                    $this->address->addErrorMessage(str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
                }
            }
            if ($this->mobile->Visible && $this->mobile->Required) {
                if (!$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->mobile->FormValue)) {
                $this->mobile->addErrorMessage($this->mobile->getErrorMessage(false));
            }
            if ($this->process->Visible && $this->process->Required) {
                if ($this->process->FormValue == "") {
                    $this->process->addErrorMessage(str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
                }
            }
            if ($this->employee_name->Visible && $this->employee_name->Required) {
                if (!$this->employee_name->IsDetailKey && EmptyValue($this->employee_name->FormValue)) {
                    $this->employee_name->addErrorMessage(str_replace("%s", $this->employee_name->caption(), $this->employee_name->RequiredErrorMessage));
                }
            }
            if ($this->gender->Visible && $this->gender->Required) {
                if ($this->gender->FormValue == "") {
                    $this->gender->addErrorMessage(str_replace("%s", $this->gender->caption(), $this->gender->RequiredErrorMessage));
                }
            }
            if ($this->father_name->Visible && $this->father_name->Required) {
                if (!$this->father_name->IsDetailKey && EmptyValue($this->father_name->FormValue)) {
                    $this->father_name->addErrorMessage(str_replace("%s", $this->father_name->caption(), $this->father_name->RequiredErrorMessage));
                }
            }
            if ($this->designation->Visible && $this->designation->Required) {
                if (!$this->designation->IsDetailKey && EmptyValue($this->designation->FormValue)) {
                    $this->designation->addErrorMessage(str_replace("%s", $this->designation->caption(), $this->designation->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->designation->FormValue)) {
                $this->designation->addErrorMessage($this->designation->getErrorMessage(false));
            }
            if ($this->permanent_address->Visible && $this->permanent_address->Required) {
                if (!$this->permanent_address->IsDetailKey && EmptyValue($this->permanent_address->FormValue)) {
                    $this->permanent_address->addErrorMessage(str_replace("%s", $this->permanent_address->caption(), $this->permanent_address->RequiredErrorMessage));
                }
            }
            if ($this->city->Visible && $this->city->Required) {
                if (!$this->city->IsDetailKey && EmptyValue($this->city->FormValue)) {
                    $this->city->addErrorMessage(str_replace("%s", $this->city->caption(), $this->city->RequiredErrorMessage));
                }
            }
            if ($this->dob->Visible && $this->dob->Required) {
                if (!$this->dob->IsDetailKey && EmptyValue($this->dob->FormValue)) {
                    $this->dob->addErrorMessage(str_replace("%s", $this->dob->caption(), $this->dob->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dob->FormValue, $this->dob->formatPattern())) {
                $this->dob->addErrorMessage($this->dob->getErrorMessage(false));
            }
            if ($this->dom->Visible && $this->dom->Required) {
                if (!$this->dom->IsDetailKey && EmptyValue($this->dom->FormValue)) {
                    $this->dom->addErrorMessage(str_replace("%s", $this->dom->caption(), $this->dom->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dom->FormValue, $this->dom->formatPattern())) {
                $this->dom->addErrorMessage($this->dom->getErrorMessage(false));
            }
            if ($this->mobile_other->Visible && $this->mobile_other->Required) {
                if (!$this->mobile_other->IsDetailKey && EmptyValue($this->mobile_other->FormValue)) {
                    $this->mobile_other->addErrorMessage(str_replace("%s", $this->mobile_other->caption(), $this->mobile_other->RequiredErrorMessage));
                }
            }
            if ($this->mobile_family->Visible && $this->mobile_family->Required) {
                if (!$this->mobile_family->IsDetailKey && EmptyValue($this->mobile_family->FormValue)) {
                    $this->mobile_family->addErrorMessage(str_replace("%s", $this->mobile_family->caption(), $this->mobile_family->RequiredErrorMessage));
                }
            }
            if ($this->marital_status->Visible && $this->marital_status->Required) {
                if ($this->marital_status->FormValue == "") {
                    $this->marital_status->addErrorMessage(str_replace("%s", $this->marital_status->caption(), $this->marital_status->RequiredErrorMessage));
                }
            }
            if ($this->spouse_details->Visible && $this->spouse_details->Required) {
                if (!$this->spouse_details->IsDetailKey && EmptyValue($this->spouse_details->FormValue)) {
                    $this->spouse_details->addErrorMessage(str_replace("%s", $this->spouse_details->caption(), $this->spouse_details->RequiredErrorMessage));
                }
            }
            if ($this->emergency_details->Visible && $this->emergency_details->Required) {
                if (!$this->emergency_details->IsDetailKey && EmptyValue($this->emergency_details->FormValue)) {
                    $this->emergency_details->addErrorMessage(str_replace("%s", $this->emergency_details->caption(), $this->emergency_details->RequiredErrorMessage));
                }
            }
            if ($this->aadhaar_no->Visible && $this->aadhaar_no->Required) {
                if (!$this->aadhaar_no->IsDetailKey && EmptyValue($this->aadhaar_no->FormValue)) {
                    $this->aadhaar_no->addErrorMessage(str_replace("%s", $this->aadhaar_no->caption(), $this->aadhaar_no->RequiredErrorMessage));
                }
            }
            if ($this->id_proof->Visible && $this->id_proof->Required) {
                if (!$this->id_proof->IsDetailKey && EmptyValue($this->id_proof->FormValue)) {
                    $this->id_proof->addErrorMessage(str_replace("%s", $this->id_proof->caption(), $this->id_proof->RequiredErrorMessage));
                }
            }
            if ($this->reference_details->Visible && $this->reference_details->Required) {
                if (!$this->reference_details->IsDetailKey && EmptyValue($this->reference_details->FormValue)) {
                    $this->reference_details->addErrorMessage(str_replace("%s", $this->reference_details->caption(), $this->reference_details->RequiredErrorMessage));
                }
            }
            if ($this->other_details->Visible && $this->other_details->Required) {
                if (!$this->other_details->IsDetailKey && EmptyValue($this->other_details->FormValue)) {
                    $this->other_details->addErrorMessage(str_replace("%s", $this->other_details->caption(), $this->other_details->RequiredErrorMessage));
                }
            }
            if ($this->doj->Visible && $this->doj->Required) {
                if (!$this->doj->IsDetailKey && EmptyValue($this->doj->FormValue)) {
                    $this->doj->addErrorMessage(str_replace("%s", $this->doj->caption(), $this->doj->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->doj->FormValue, $this->doj->formatPattern())) {
                $this->doj->addErrorMessage($this->doj->getErrorMessage(false));
            }
            if ($this->doc->Visible && $this->doc->Required) {
                if (!$this->doc->IsDetailKey && EmptyValue($this->doc->FormValue)) {
                    $this->doc->addErrorMessage(str_replace("%s", $this->doc->caption(), $this->doc->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->doc->FormValue, $this->doc->formatPattern())) {
                $this->doc->addErrorMessage($this->doc->getErrorMessage(false));
            }
            if ($this->dol->Visible && $this->dol->Required) {
                if (!$this->dol->IsDetailKey && EmptyValue($this->dol->FormValue)) {
                    $this->dol->addErrorMessage(str_replace("%s", $this->dol->caption(), $this->dol->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dol->FormValue, $this->dol->formatPattern())) {
                $this->dol->addErrorMessage($this->dol->getErrorMessage(false));
            }
            if ($this->image->Visible && $this->image->Required) {
                if ($this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
                    $this->image->addErrorMessage(str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
                }
            }
            if ($this->payment_details->Visible && $this->payment_details->Required) {
                if (!$this->payment_details->IsDetailKey && EmptyValue($this->payment_details->FormValue)) {
                    $this->payment_details->addErrorMessage(str_replace("%s", $this->payment_details->caption(), $this->payment_details->RequiredErrorMessage));
                }
            }
            if ($this->bank_name->Visible && $this->bank_name->Required) {
                if (!$this->bank_name->IsDetailKey && EmptyValue($this->bank_name->FormValue)) {
                    $this->bank_name->addErrorMessage(str_replace("%s", $this->bank_name->caption(), $this->bank_name->RequiredErrorMessage));
                }
            }
            if ($this->bank_ifsc_code->Visible && $this->bank_ifsc_code->Required) {
                if (!$this->bank_ifsc_code->IsDetailKey && EmptyValue($this->bank_ifsc_code->FormValue)) {
                    $this->bank_ifsc_code->addErrorMessage(str_replace("%s", $this->bank_ifsc_code->caption(), $this->bank_ifsc_code->RequiredErrorMessage));
                }
            }
            if ($this->bank_account_no->Visible && $this->bank_account_no->Required) {
                if (!$this->bank_account_no->IsDetailKey && EmptyValue($this->bank_account_no->FormValue)) {
                    $this->bank_account_no->addErrorMessage(str_replace("%s", $this->bank_account_no->caption(), $this->bank_account_no->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();
        if ($this->image->Visible && !$this->image->Upload->KeepFile) {
            $this->image->UploadPath = $this->image->getUploadPath();
            if (!EmptyValue($this->image->Upload->FileName)) {
                $this->image->Upload->DbValue = null;
                FixUploadFileNames($this->image);
                $this->image->setDbValueDef($rsnew, $this->image->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $this->image->UploadPath = $this->image->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->image->Visible && !$this->image->Upload->KeepFile) {
                    $this->image->Upload->DbValue = null;
                    if (!SaveUploadFiles($this->image, $rsnew['image'], false)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            if (Post("addopt") == "1") { // Render for add option response
                $row = $this->renderAddOpt($row);
            }
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // id
        $this->id->setDbValueDef($rsnew, $this->id->CurrentValue, false);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // site
        $this->site->setDbValueDef($rsnew, $this->site->CurrentValue, false);

        // user_name
        $this->user_name->setDbValueDef($rsnew, $this->user_name->CurrentValue, false);

        // address
        $this->address->setDbValueDef($rsnew, $this->address->CurrentValue, false);

        // mobile
        $this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, false);

        // process
        $this->process->setDbValueDef($rsnew, $this->process->CurrentValue, false);

        // employee_name
        $this->employee_name->setDbValueDef($rsnew, $this->employee_name->CurrentValue, false);

        // gender
        $this->gender->setDbValueDef($rsnew, $this->gender->CurrentValue, false);

        // father_name
        $this->father_name->setDbValueDef($rsnew, $this->father_name->CurrentValue, false);

        // designation
        $this->designation->setDbValueDef($rsnew, $this->designation->CurrentValue, false);

        // permanent_address
        $this->permanent_address->setDbValueDef($rsnew, $this->permanent_address->CurrentValue, false);

        // city
        $this->city->setDbValueDef($rsnew, $this->city->CurrentValue, false);

        // dob
        $this->dob->setDbValueDef($rsnew, UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern()), false);

        // dom
        $this->dom->setDbValueDef($rsnew, UnFormatDateTime($this->dom->CurrentValue, $this->dom->formatPattern()), false);

        // mobile_other
        $this->mobile_other->setDbValueDef($rsnew, $this->mobile_other->CurrentValue, false);

        // mobile_family
        $this->mobile_family->setDbValueDef($rsnew, $this->mobile_family->CurrentValue, false);

        // marital_status
        $this->marital_status->setDbValueDef($rsnew, $this->marital_status->CurrentValue, false);

        // spouse_details
        $this->spouse_details->setDbValueDef($rsnew, $this->spouse_details->CurrentValue, false);

        // emergency_details
        $this->emergency_details->setDbValueDef($rsnew, $this->emergency_details->CurrentValue, false);

        // aadhaar_no
        $this->aadhaar_no->setDbValueDef($rsnew, $this->aadhaar_no->CurrentValue, false);

        // id_proof
        $this->id_proof->setDbValueDef($rsnew, $this->id_proof->CurrentValue, false);

        // reference_details
        $this->reference_details->setDbValueDef($rsnew, $this->reference_details->CurrentValue, false);

        // other_details
        $this->other_details->setDbValueDef($rsnew, $this->other_details->CurrentValue, false);

        // doj
        $this->doj->setDbValueDef($rsnew, UnFormatDateTime($this->doj->CurrentValue, $this->doj->formatPattern()), false);

        // doc
        $this->doc->setDbValueDef($rsnew, UnFormatDateTime($this->doc->CurrentValue, $this->doc->formatPattern()), false);

        // dol
        $this->dol->setDbValueDef($rsnew, UnFormatDateTime($this->dol->CurrentValue, $this->dol->formatPattern()), false);

        // image
        if ($this->image->Visible && !$this->image->Upload->KeepFile) {
            if ($this->image->Upload->FileName == "") {
                $rsnew['image'] = null;
            } else {
                FixUploadTempFileNames($this->image);
                $rsnew['image'] = $this->image->Upload->FileName;
            }
        }

        // payment_details
        $this->payment_details->setDbValueDef($rsnew, $this->payment_details->CurrentValue, false);

        // bank_name
        $this->bank_name->setDbValueDef($rsnew, $this->bank_name->CurrentValue, false);

        // bank_ifsc_code
        $this->bank_ifsc_code->setDbValueDef($rsnew, $this->bank_ifsc_code->CurrentValue, false);

        // bank_account_no
        $this->bank_account_no->setDbValueDef($rsnew, $this->bank_account_no->CurrentValue, false);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['id'])) { // id
            $this->id->setFormValue($row['id']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['site'])) { // site
            $this->site->setFormValue($row['site']);
        }
        if (isset($row['user_name'])) { // user_name
            $this->user_name->setFormValue($row['user_name']);
        }
        if (isset($row['address'])) { // address
            $this->address->setFormValue($row['address']);
        }
        if (isset($row['mobile'])) { // mobile
            $this->mobile->setFormValue($row['mobile']);
        }
        if (isset($row['process'])) { // process
            $this->process->setFormValue($row['process']);
        }
        if (isset($row['employee_name'])) { // employee_name
            $this->employee_name->setFormValue($row['employee_name']);
        }
        if (isset($row['gender'])) { // gender
            $this->gender->setFormValue($row['gender']);
        }
        if (isset($row['father_name'])) { // father_name
            $this->father_name->setFormValue($row['father_name']);
        }
        if (isset($row['designation'])) { // designation
            $this->designation->setFormValue($row['designation']);
        }
        if (isset($row['permanent_address'])) { // permanent_address
            $this->permanent_address->setFormValue($row['permanent_address']);
        }
        if (isset($row['city'])) { // city
            $this->city->setFormValue($row['city']);
        }
        if (isset($row['dob'])) { // dob
            $this->dob->setFormValue($row['dob']);
        }
        if (isset($row['dom'])) { // dom
            $this->dom->setFormValue($row['dom']);
        }
        if (isset($row['mobile_other'])) { // mobile_other
            $this->mobile_other->setFormValue($row['mobile_other']);
        }
        if (isset($row['mobile_family'])) { // mobile_family
            $this->mobile_family->setFormValue($row['mobile_family']);
        }
        if (isset($row['marital_status'])) { // marital_status
            $this->marital_status->setFormValue($row['marital_status']);
        }
        if (isset($row['spouse_details'])) { // spouse_details
            $this->spouse_details->setFormValue($row['spouse_details']);
        }
        if (isset($row['emergency_details'])) { // emergency_details
            $this->emergency_details->setFormValue($row['emergency_details']);
        }
        if (isset($row['aadhaar_no'])) { // aadhaar_no
            $this->aadhaar_no->setFormValue($row['aadhaar_no']);
        }
        if (isset($row['id_proof'])) { // id_proof
            $this->id_proof->setFormValue($row['id_proof']);
        }
        if (isset($row['reference_details'])) { // reference_details
            $this->reference_details->setFormValue($row['reference_details']);
        }
        if (isset($row['other_details'])) { // other_details
            $this->other_details->setFormValue($row['other_details']);
        }
        if (isset($row['doj'])) { // doj
            $this->doj->setFormValue($row['doj']);
        }
        if (isset($row['doc'])) { // doc
            $this->doc->setFormValue($row['doc']);
        }
        if (isset($row['dol'])) { // dol
            $this->dol->setFormValue($row['dol']);
        }
        if (isset($row['image'])) { // image
            $this->image->setFormValue($row['image']);
        }
        if (isset($row['payment_details'])) { // payment_details
            $this->payment_details->setFormValue($row['payment_details']);
        }
        if (isset($row['bank_name'])) { // bank_name
            $this->bank_name->setFormValue($row['bank_name']);
        }
        if (isset($row['bank_ifsc_code'])) { // bank_ifsc_code
            $this->bank_ifsc_code->setFormValue($row['bank_ifsc_code']);
        }
        if (isset($row['bank_account_no'])) { // bank_account_no
            $this->bank_account_no->setFormValue($row['bank_account_no']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("productionemployeehslist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    break;
                case "x_site":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_gender":
                    break;
                case "x_marital_status":
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
