<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for production_employee_hs
 */
class ProductionEmployeeHs extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $uid;
    public $id;
    public $grp;
    public $site;
    public $user_name;
    public $address;
    public $mobile;
    public $category;
    public $process;
    public $employee_name;
    public $gender;
    public $father_name;
    public $designation;
    public $permanent_address;
    public $city;
    public $dob;
    public $dom;
    public $mobile_other;
    public $mobile_family;
    public $marital_status;
    public $spouse_details;
    public $emergency_details;
    public $aadhaar_no;
    public $id_proof;
    public $reference_details;
    public $other_details;
    public $doj;
    public $doc;
    public $dol;
    public $image;
    public $payment_details;
    public $bank_name;
    public $bank_ifsc_code;
    public $bank_account_no;
    public $status;
    public $operator;
    public $datetime;
    public $d_operator;
    public $d_datetime;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "production_employee_hs";
        $this->TableName = 'production_employee_hs';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "production_employee_hs";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // uid
        $this->uid = new DbField(
            $this, // Table
            'x_uid', // Variable name
            'uid', // Name
            '`uid`', // Expression
            '`uid`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`uid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->uid->InputTextType = "text";
        $this->uid->Raw = true;
        $this->uid->IsAutoIncrement = true; // Autoincrement field
        $this->uid->IsPrimaryKey = true; // Primary key field
        $this->uid->Nullable = false; // NOT NULL field
        $this->uid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->uid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['uid'] = &$this->uid;

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->Nullable = false; // NOT NULL field
        $this->id->Required = true; // Required field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getDefault", fn() => 23);
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Nullable = false; // NOT NULL field
        $this->grp->Required = true; // Required field
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'production_employee_hs', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->grp->OptionCount = 1;
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['grp'] = &$this->grp;

        // site
        $this->site = new DbField(
            $this, // Table
            'x_site', // Variable name
            'site', // Name
            '`site`', // Expression
            '`site`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`site`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->site->addMethod("getSelectFilter", fn() => (!empty(User_Site())) ? "`id` IN (".User_Site().")" : "id = 0");
        $this->site->addMethod("getDefault", fn() => 9);
        $this->site->addMethod("getLinkPrefix", fn() => "productionemployeehslist?x_site=");
        $this->site->InputTextType = "text";
        $this->site->Nullable = false; // NOT NULL field
        $this->site->Required = true; // Required field
        $this->site->setSelectMultiple(false); // Select one
        $this->site->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->site->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->site->Lookup = new Lookup($this->site, 'godown_table', false, 'id', ["name","code","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->site) . "',COALESCE(`code`,''))");
        $this->site->SearchOperators = ["=", "<>"];
        $this->Fields['site'] = &$this->site;

        // user_name
        $this->user_name = new DbField(
            $this, // Table
            'x_user_name', // Variable name
            'user_name', // Name
            '`user_name`', // Expression
            '`user_name`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`user_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->user_name->addMethod("getLinkPrefix", fn() => "productionemployeehslist?x_user_name=");
        $this->user_name->InputTextType = "text";
        $this->user_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['user_name'] = &$this->user_name;

        // address
        $this->address = new DbField(
            $this, // Table
            'x_address', // Variable name
            'address', // Name
            '`address`', // Expression
            '`address`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`address`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->address->InputTextType = "text";
        $this->address->Required = true; // Required field
        $this->address->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['address'] = &$this->address;

        // mobile
        $this->mobile = new DbField(
            $this, // Table
            'x_mobile', // Variable name
            'mobile', // Name
            '`mobile`', // Expression
            '`mobile`', // Basic search expression
            21, // Type
            19, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`mobile`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->mobile->InputTextType = "text";
        $this->mobile->Raw = true;
        $this->mobile->Required = true; // Required field
        $this->mobile->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->mobile->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['mobile'] = &$this->mobile;

        // category
        $this->category = new DbField(
            $this, // Table
            'x_category', // Variable name
            'category', // Name
            '`category`', // Expression
            '`category`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->category->InputTextType = "text";
        $this->category->Raw = true;
        $this->category->Nullable = false; // NOT NULL field
        $this->category->Required = true; // Required field
        $this->category->Sortable = false; // Allow sort
        $this->category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->category->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['category'] = &$this->category;

        // process
        $this->process = new DbField(
            $this, // Table
            'x_process', // Variable name
            'process', // Name
            '`process`', // Expression
            '`process`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->process->addMethod("getSelectFilter", fn() => "`grp` = 2 AND `id` = 23");
        $this->process->addMethod("getDefault", fn() => 23);
        $this->process->addMethod("getLinkPrefix", fn() => "productionemployeehslist?x_process=");
        $this->process->InputTextType = "text";
        $this->process->Required = true; // Required field
        $this->process->Lookup = new Lookup($this->process, 'process', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['process'] = &$this->process;

        // employee_name
        $this->employee_name = new DbField(
            $this, // Table
            'x_employee_name', // Variable name
            'employee_name', // Name
            '`employee_name`', // Expression
            '`employee_name`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`employee_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->employee_name->addMethod("getLinkPrefix", fn() => "productionemployeehslist?x_employee_name=");
        $this->employee_name->InputTextType = "text";
        $this->employee_name->Required = true; // Required field
        $this->employee_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['employee_name'] = &$this->employee_name;

        // gender
        $this->gender = new DbField(
            $this, // Table
            'x_gender', // Variable name
            'gender', // Name
            '`gender`', // Expression
            '`gender`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gender`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->gender->InputTextType = "text";
        $this->gender->Raw = true;
        $this->gender->Lookup = new Lookup($this->gender, 'production_employee_hs', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->gender->OptionCount = 2;
        $this->gender->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->gender->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['gender'] = &$this->gender;

        // father_name
        $this->father_name = new DbField(
            $this, // Table
            'x_father_name', // Variable name
            'father_name', // Name
            '`father_name`', // Expression
            '`father_name`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`father_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->father_name->InputTextType = "text";
        $this->father_name->Required = true; // Required field
        $this->father_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['father_name'] = &$this->father_name;

        // designation
        $this->designation = new DbField(
            $this, // Table
            'x_designation', // Variable name
            'designation', // Name
            '`designation`', // Expression
            '`designation`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`designation`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->designation->addMethod("getLinkPrefix", fn() => "productionemployeehslist?x_designation=");
        $this->designation->InputTextType = "text";
        $this->designation->Raw = true;
        $this->designation->Required = true; // Required field
        $this->designation->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->designation->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['designation'] = &$this->designation;

        // permanent_address
        $this->permanent_address = new DbField(
            $this, // Table
            'x_permanent_address', // Variable name
            'permanent_address', // Name
            '`permanent_address`', // Expression
            '`permanent_address`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`permanent_address`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->permanent_address->InputTextType = "text";
        $this->permanent_address->Required = true; // Required field
        $this->permanent_address->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['permanent_address'] = &$this->permanent_address;

        // city
        $this->city = new DbField(
            $this, // Table
            'x_city', // Variable name
            'city', // Name
            '`city`', // Expression
            '`city`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`city`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->city->InputTextType = "text";
        $this->city->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['city'] = &$this->city;

        // dob
        $this->dob = new DbField(
            $this, // Table
            'x_dob', // Variable name
            'dob', // Name
            '`dob`', // Expression
            CastDateFieldForLike("`dob`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`dob`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->dob->InputTextType = "text";
        $this->dob->Raw = true;
        $this->dob->Required = true; // Required field
        $this->dob->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->dob->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['dob'] = &$this->dob;

        // dom
        $this->dom = new DbField(
            $this, // Table
            'x_dom', // Variable name
            'dom', // Name
            '`dom`', // Expression
            CastDateFieldForLike("`dom`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`dom`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->dom->InputTextType = "text";
        $this->dom->Raw = true;
        $this->dom->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->dom->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['dom'] = &$this->dom;

        // mobile_other
        $this->mobile_other = new DbField(
            $this, // Table
            'x_mobile_other', // Variable name
            'mobile_other', // Name
            '`mobile_other`', // Expression
            '`mobile_other`', // Basic search expression
            200, // Type
            60, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`mobile_other`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->mobile_other->InputTextType = "text";
        $this->mobile_other->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['mobile_other'] = &$this->mobile_other;

        // mobile_family
        $this->mobile_family = new DbField(
            $this, // Table
            'x_mobile_family', // Variable name
            'mobile_family', // Name
            '`mobile_family`', // Expression
            '`mobile_family`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`mobile_family`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->mobile_family->InputTextType = "text";
        $this->mobile_family->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['mobile_family'] = &$this->mobile_family;

        // marital_status
        $this->marital_status = new DbField(
            $this, // Table
            'x_marital_status', // Variable name
            'marital_status', // Name
            '`marital_status`', // Expression
            '`marital_status`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`marital_status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->marital_status->InputTextType = "text";
        $this->marital_status->Raw = true;
        $this->marital_status->Lookup = new Lookup($this->marital_status, 'production_employee_hs', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->marital_status->OptionCount = 2;
        $this->marital_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->marital_status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['marital_status'] = &$this->marital_status;

        // spouse_details
        $this->spouse_details = new DbField(
            $this, // Table
            'x_spouse_details', // Variable name
            'spouse_details', // Name
            '`spouse_details`', // Expression
            '`spouse_details`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`spouse_details`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->spouse_details->InputTextType = "text";
        $this->spouse_details->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['spouse_details'] = &$this->spouse_details;

        // emergency_details
        $this->emergency_details = new DbField(
            $this, // Table
            'x_emergency_details', // Variable name
            'emergency_details', // Name
            '`emergency_details`', // Expression
            '`emergency_details`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`emergency_details`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->emergency_details->InputTextType = "text";
        $this->emergency_details->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['emergency_details'] = &$this->emergency_details;

        // aadhaar_no
        $this->aadhaar_no = new DbField(
            $this, // Table
            'x_aadhaar_no', // Variable name
            'aadhaar_no', // Name
            '`aadhaar_no`', // Expression
            '`aadhaar_no`', // Basic search expression
            200, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`aadhaar_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->aadhaar_no->InputTextType = "text";
        $this->aadhaar_no->Required = true; // Required field
        $this->aadhaar_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['aadhaar_no'] = &$this->aadhaar_no;

        // id_proof
        $this->id_proof = new DbField(
            $this, // Table
            'x_id_proof', // Variable name
            'id_proof', // Name
            '`id_proof`', // Expression
            '`id_proof`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id_proof`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id_proof->InputTextType = "text";
        $this->id_proof->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['id_proof'] = &$this->id_proof;

        // reference_details
        $this->reference_details = new DbField(
            $this, // Table
            'x_reference_details', // Variable name
            'reference_details', // Name
            '`reference_details`', // Expression
            '`reference_details`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`reference_details`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->reference_details->InputTextType = "text";
        $this->reference_details->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['reference_details'] = &$this->reference_details;

        // other_details
        $this->other_details = new DbField(
            $this, // Table
            'x_other_details', // Variable name
            'other_details', // Name
            '`other_details`', // Expression
            '`other_details`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`other_details`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->other_details->InputTextType = "text";
        $this->other_details->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['other_details'] = &$this->other_details;

        // doj
        $this->doj = new DbField(
            $this, // Table
            'x_doj', // Variable name
            'doj', // Name
            '`doj`', // Expression
            CastDateFieldForLike("`doj`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`doj`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->doj->InputTextType = "text";
        $this->doj->Raw = true;
        $this->doj->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->doj->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['doj'] = &$this->doj;

        // doc
        $this->doc = new DbField(
            $this, // Table
            'x_doc', // Variable name
            'doc', // Name
            '`doc`', // Expression
            CastDateFieldForLike("`doc`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`doc`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->doc->InputTextType = "text";
        $this->doc->Raw = true;
        $this->doc->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->doc->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['doc'] = &$this->doc;

        // dol
        $this->dol = new DbField(
            $this, // Table
            'x_dol', // Variable name
            'dol', // Name
            '`dol`', // Expression
            CastDateFieldForLike("`dol`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`dol`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->dol->InputTextType = "text";
        $this->dol->Raw = true;
        $this->dol->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->dol->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['dol'] = &$this->dol;

        // image
        $this->image = new DbField(
            $this, // Table
            'x_image', // Variable name
            'image', // Name
            '`image`', // Expression
            '`image`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`image`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'FILE' // Edit Tag
        );
        $this->image->addMethod("getUploadPath", fn() => '/uploads/');
        $this->image->InputTextType = "text";
        $this->image->UploadMultiple = true;
        $this->image->Upload->UploadMultiple = true;
        $this->image->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['image'] = &$this->image;

        // payment_details
        $this->payment_details = new DbField(
            $this, // Table
            'x_payment_details', // Variable name
            'payment_details', // Name
            '`payment_details`', // Expression
            '`payment_details`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment_details`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->payment_details->InputTextType = "text";
        $this->payment_details->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['payment_details'] = &$this->payment_details;

        // bank_name
        $this->bank_name = new DbField(
            $this, // Table
            'x_bank_name', // Variable name
            'bank_name', // Name
            '`bank_name`', // Expression
            '`bank_name`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bank_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->bank_name->InputTextType = "text";
        $this->bank_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['bank_name'] = &$this->bank_name;

        // bank_ifsc_code
        $this->bank_ifsc_code = new DbField(
            $this, // Table
            'x_bank_ifsc_code', // Variable name
            'bank_ifsc_code', // Name
            '`bank_ifsc_code`', // Expression
            '`bank_ifsc_code`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bank_ifsc_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->bank_ifsc_code->InputTextType = "text";
        $this->bank_ifsc_code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['bank_ifsc_code'] = &$this->bank_ifsc_code;

        // bank_account_no
        $this->bank_account_no = new DbField(
            $this, // Table
            'x_bank_account_no', // Variable name
            'bank_account_no', // Name
            '`bank_account_no`', // Expression
            '`bank_account_no`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bank_account_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->bank_account_no->InputTextType = "text";
        $this->bank_account_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['bank_account_no'] = &$this->bank_account_no;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getDefault", fn() => 1);
        $this->status->addMethod("getLinkPrefix", fn() => "productionemployeehslist?x_status=");
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->Required = true; // Required field
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'production_employee_hs', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 2;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['status'] = &$this->status;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // d_operator
        $this->d_operator = new DbField(
            $this, // Table
            'x_d_operator', // Variable name
            'd_operator', // Name
            '`d_operator`', // Expression
            '`d_operator`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->d_operator->addMethod("getLinkPrefix", fn() => "productionemployeehslist?x_d_operator=");
        $this->d_operator->InputTextType = "text";
        $this->d_operator->Raw = true;
        $this->d_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->d_operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_operator'] = &$this->d_operator;

        // d_datetime
        $this->d_datetime = new DbField(
            $this, // Table
            'x_d_datetime', // Variable name
            'd_datetime', // Name
            '`d_datetime`', // Expression
            CastDateFieldForLike("`d_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`d_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->d_datetime->InputTextType = "text";
        $this->d_datetime->Raw = true;
        $this->d_datetime->Nullable = false; // NOT NULL field
        $this->d_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->d_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_datetime'] = &$this->d_datetime;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "production_employee_hs";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->uid->setDbValue($conn->lastInsertId());
            $rs['uid'] = $this->uid->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['uid']) && !EmptyValue($this->uid->CurrentValue)) {
                $rs['uid'] = $this->uid->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('uid', $rs)) {
                AddFilter($where, QuotedName('uid', $this->Dbid) . '=' . QuotedValue($rs['uid'], $this->uid->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->uid->DbValue = $row['uid'];
        $this->id->DbValue = $row['id'];
        $this->grp->DbValue = $row['grp'];
        $this->site->DbValue = $row['site'];
        $this->user_name->DbValue = $row['user_name'];
        $this->address->DbValue = $row['address'];
        $this->mobile->DbValue = $row['mobile'];
        $this->category->DbValue = $row['category'];
        $this->process->DbValue = $row['process'];
        $this->employee_name->DbValue = $row['employee_name'];
        $this->gender->DbValue = $row['gender'];
        $this->father_name->DbValue = $row['father_name'];
        $this->designation->DbValue = $row['designation'];
        $this->permanent_address->DbValue = $row['permanent_address'];
        $this->city->DbValue = $row['city'];
        $this->dob->DbValue = $row['dob'];
        $this->dom->DbValue = $row['dom'];
        $this->mobile_other->DbValue = $row['mobile_other'];
        $this->mobile_family->DbValue = $row['mobile_family'];
        $this->marital_status->DbValue = $row['marital_status'];
        $this->spouse_details->DbValue = $row['spouse_details'];
        $this->emergency_details->DbValue = $row['emergency_details'];
        $this->aadhaar_no->DbValue = $row['aadhaar_no'];
        $this->id_proof->DbValue = $row['id_proof'];
        $this->reference_details->DbValue = $row['reference_details'];
        $this->other_details->DbValue = $row['other_details'];
        $this->doj->DbValue = $row['doj'];
        $this->doc->DbValue = $row['doc'];
        $this->dol->DbValue = $row['dol'];
        $this->image->Upload->DbValue = $row['image'];
        $this->payment_details->DbValue = $row['payment_details'];
        $this->bank_name->DbValue = $row['bank_name'];
        $this->bank_ifsc_code->DbValue = $row['bank_ifsc_code'];
        $this->bank_account_no->DbValue = $row['bank_account_no'];
        $this->status->DbValue = $row['status'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->d_operator->DbValue = $row['d_operator'];
        $this->d_datetime->DbValue = $row['d_datetime'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['image']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['image']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->image->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->image->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`uid` = @uid@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->uid->CurrentValue : $this->uid->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->uid->CurrentValue = $keys[0];
            } else {
                $this->uid->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('uid', $row) ? $row['uid'] : null;
        } else {
            $val = !EmptyValue($this->uid->OldValue) && !$current ? $this->uid->OldValue : $this->uid->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@uid@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("productionemployeehslist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "productionemployeehsview" => $Language->phrase("View"),
            "productionemployeehsedit" => $Language->phrase("Edit"),
            "productionemployeehsadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "productionemployeehslist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "ProductionEmployeeHsView",
            Config("API_ADD_ACTION") => "ProductionEmployeeHsAdd",
            Config("API_EDIT_ACTION") => "ProductionEmployeeHsEdit",
            Config("API_DELETE_ACTION") => "ProductionEmployeeHsDelete",
            Config("API_LIST_ACTION") => "ProductionEmployeeHsList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "productionemployeehslist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("productionemployeehsview", $parm);
        } else {
            $url = $this->keyUrl("productionemployeehsview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "productionemployeehsadd?" . $parm;
        } else {
            $url = "productionemployeehsadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("productionemployeehsedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("productionemployeehslist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("productionemployeehsadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("productionemployeehslist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("productionemployeehsdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"uid\":" . VarToJson($this->uid->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->uid->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->uid->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("uid") ?? Route("uid")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->uid->CurrentValue = $key;
            } else {
                $this->uid->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->uid->setDbValue($row['uid']);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->site->setDbValue($row['site']);
        $this->user_name->setDbValue($row['user_name']);
        $this->address->setDbValue($row['address']);
        $this->mobile->setDbValue($row['mobile']);
        $this->category->setDbValue($row['category']);
        $this->process->setDbValue($row['process']);
        $this->employee_name->setDbValue($row['employee_name']);
        $this->gender->setDbValue($row['gender']);
        $this->father_name->setDbValue($row['father_name']);
        $this->designation->setDbValue($row['designation']);
        $this->permanent_address->setDbValue($row['permanent_address']);
        $this->city->setDbValue($row['city']);
        $this->dob->setDbValue($row['dob']);
        $this->dom->setDbValue($row['dom']);
        $this->mobile_other->setDbValue($row['mobile_other']);
        $this->mobile_family->setDbValue($row['mobile_family']);
        $this->marital_status->setDbValue($row['marital_status']);
        $this->spouse_details->setDbValue($row['spouse_details']);
        $this->emergency_details->setDbValue($row['emergency_details']);
        $this->aadhaar_no->setDbValue($row['aadhaar_no']);
        $this->id_proof->setDbValue($row['id_proof']);
        $this->reference_details->setDbValue($row['reference_details']);
        $this->other_details->setDbValue($row['other_details']);
        $this->doj->setDbValue($row['doj']);
        $this->doc->setDbValue($row['doc']);
        $this->dol->setDbValue($row['dol']);
        $this->image->Upload->DbValue = $row['image'];
        $this->payment_details->setDbValue($row['payment_details']);
        $this->bank_name->setDbValue($row['bank_name']);
        $this->bank_ifsc_code->setDbValue($row['bank_ifsc_code']);
        $this->bank_account_no->setDbValue($row['bank_account_no']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->d_operator->setDbValue($row['d_operator']);
        $this->d_datetime->setDbValue($row['d_datetime']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "ProductionEmployeeHsList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // uid

        // id

        // grp

        // site

        // user_name

        // address

        // mobile

        // category
        $this->category->CellCssStyle = "white-space: nowrap;";

        // process

        // employee_name

        // gender

        // father_name

        // designation

        // permanent_address

        // city

        // dob

        // dom

        // mobile_other

        // mobile_family

        // marital_status

        // spouse_details

        // emergency_details

        // aadhaar_no

        // id_proof

        // reference_details

        // other_details

        // doj

        // doc

        // dol

        // image

        // payment_details

        // bank_name

        // bank_ifsc_code

        // bank_account_no

        // status

        // operator

        // datetime

        // d_operator

        // d_datetime

        // uid
        $this->uid->ViewValue = $this->uid->CurrentValue;

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

        // grp
        if (strval($this->grp->CurrentValue) != "") {
            $this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
        } else {
            $this->grp->ViewValue = null;
        }

        // site
        $curVal = strval($this->site->CurrentValue);
        if ($curVal != "") {
            $this->site->ViewValue = $this->site->lookupCacheOption($curVal);
            if ($this->site->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->site->getSelectFilter($this); // PHP
                $sqlWrk = $this->site->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->site->Lookup->renderViewRow($rswrk[0]);
                    $this->site->ViewValue = $this->site->displayValue($arwrk);
                } else {
                    $this->site->ViewValue = $this->site->CurrentValue;
                }
            }
        } else {
            $this->site->ViewValue = null;
        }

        // user_name
        $this->user_name->ViewValue = $this->user_name->CurrentValue;

        // address
        $this->address->ViewValue = $this->address->CurrentValue;

        // mobile
        $this->mobile->ViewValue = $this->mobile->CurrentValue;
        $this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, $this->mobile->formatPattern());

        // category
        $this->category->ViewValue = $this->category->CurrentValue;
        $this->category->ViewValue = FormatNumber($this->category->ViewValue, $this->category->formatPattern());

        // process
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->process->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->process->Lookup->renderViewRow($row);
                        $this->process->ViewValue->add($this->process->displayValue($arwrk));
                    }
                } else {
                    $this->process->ViewValue = $this->process->CurrentValue;
                }
            }
        } else {
            $this->process->ViewValue = null;
        }

        // employee_name
        $this->employee_name->ViewValue = $this->employee_name->CurrentValue;

        // gender
        if (strval($this->gender->CurrentValue) != "") {
            $this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
        } else {
            $this->gender->ViewValue = null;
        }

        // father_name
        $this->father_name->ViewValue = $this->father_name->CurrentValue;

        // designation
        $this->designation->ViewValue = $this->designation->CurrentValue;
        $this->designation->ViewValue = FormatNumber($this->designation->ViewValue, $this->designation->formatPattern());

        // permanent_address
        $this->permanent_address->ViewValue = $this->permanent_address->CurrentValue;

        // city
        $this->city->ViewValue = $this->city->CurrentValue;

        // dob
        $this->dob->ViewValue = $this->dob->CurrentValue;
        $this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, $this->dob->formatPattern());

        // dom
        $this->dom->ViewValue = $this->dom->CurrentValue;
        $this->dom->ViewValue = FormatDateTime($this->dom->ViewValue, $this->dom->formatPattern());

        // mobile_other
        $this->mobile_other->ViewValue = $this->mobile_other->CurrentValue;

        // mobile_family
        $this->mobile_family->ViewValue = $this->mobile_family->CurrentValue;

        // marital_status
        if (strval($this->marital_status->CurrentValue) != "") {
            $this->marital_status->ViewValue = $this->marital_status->optionCaption($this->marital_status->CurrentValue);
        } else {
            $this->marital_status->ViewValue = null;
        }

        // spouse_details
        $this->spouse_details->ViewValue = $this->spouse_details->CurrentValue;

        // emergency_details
        $this->emergency_details->ViewValue = $this->emergency_details->CurrentValue;

        // aadhaar_no
        $this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;

        // id_proof
        $this->id_proof->ViewValue = $this->id_proof->CurrentValue;

        // reference_details
        $this->reference_details->ViewValue = $this->reference_details->CurrentValue;

        // other_details
        $this->other_details->ViewValue = $this->other_details->CurrentValue;

        // doj
        $this->doj->ViewValue = $this->doj->CurrentValue;
        $this->doj->ViewValue = FormatDateTime($this->doj->ViewValue, $this->doj->formatPattern());

        // doc
        $this->doc->ViewValue = $this->doc->CurrentValue;
        $this->doc->ViewValue = FormatDateTime($this->doc->ViewValue, $this->doc->formatPattern());

        // dol
        $this->dol->ViewValue = $this->dol->CurrentValue;
        $this->dol->ViewValue = FormatDateTime($this->dol->ViewValue, $this->dol->formatPattern());

        // image
        $this->image->UploadPath = $this->image->getUploadPath(); // PHP
        if (!EmptyValue($this->image->Upload->DbValue)) {
            $this->image->ViewValue = $this->image->Upload->DbValue;
        } else {
            $this->image->ViewValue = "";
        }

        // payment_details
        $this->payment_details->ViewValue = $this->payment_details->CurrentValue;

        // bank_name
        $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

        // bank_ifsc_code
        $this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;

        // bank_account_no
        $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // d_operator
        $this->d_operator->ViewValue = $this->d_operator->CurrentValue;
        $this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, $this->d_operator->formatPattern());

        // d_datetime
        $this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
        $this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, $this->d_datetime->formatPattern());

        // uid
        $this->uid->HrefValue = "";
        $this->uid->TooltipValue = "";

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // site
        if (!EmptyValue($this->site->CurrentValue)) {
            $this->site->HrefValue = $this->site->getLinkPrefix() . $this->site->CurrentValue; // Add prefix/suffix
            $this->site->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->site->HrefValue = FullUrl($this->site->HrefValue, "href");
            }
        } else {
            $this->site->HrefValue = "";
        }
        $this->site->TooltipValue = "";

        // user_name
        if (!EmptyValue($this->user_name->CurrentValue)) {
            $this->user_name->HrefValue = $this->user_name->getLinkPrefix() . $this->user_name->CurrentValue; // Add prefix/suffix
            $this->user_name->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->user_name->HrefValue = FullUrl($this->user_name->HrefValue, "href");
            }
        } else {
            $this->user_name->HrefValue = "";
        }
        $this->user_name->TooltipValue = "";

        // address
        $this->address->HrefValue = "";
        $this->address->TooltipValue = "";

        // mobile
        $this->mobile->HrefValue = "";
        $this->mobile->TooltipValue = "";

        // category
        $this->category->HrefValue = "";
        $this->category->TooltipValue = "";

        // process
        if (!EmptyValue($this->process->CurrentValue)) {
            $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
            $this->process->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
            }
        } else {
            $this->process->HrefValue = "";
        }
        $this->process->TooltipValue = "";

        // employee_name
        if (!EmptyValue($this->employee_name->CurrentValue)) {
            $this->employee_name->HrefValue = $this->employee_name->getLinkPrefix() . $this->employee_name->CurrentValue; // Add prefix/suffix
            $this->employee_name->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->employee_name->HrefValue = FullUrl($this->employee_name->HrefValue, "href");
            }
        } else {
            $this->employee_name->HrefValue = "";
        }
        $this->employee_name->TooltipValue = "";

        // gender
        $this->gender->HrefValue = "";
        $this->gender->TooltipValue = "";

        // father_name
        $this->father_name->HrefValue = "";
        $this->father_name->TooltipValue = "";

        // designation
        if (!EmptyValue($this->designation->CurrentValue)) {
            $this->designation->HrefValue = $this->designation->getLinkPrefix() . $this->designation->CurrentValue; // Add prefix/suffix
            $this->designation->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->designation->HrefValue = FullUrl($this->designation->HrefValue, "href");
            }
        } else {
            $this->designation->HrefValue = "";
        }
        $this->designation->TooltipValue = "";

        // permanent_address
        $this->permanent_address->HrefValue = "";
        $this->permanent_address->TooltipValue = "";

        // city
        $this->city->HrefValue = "";
        $this->city->TooltipValue = "";

        // dob
        $this->dob->HrefValue = "";
        $this->dob->TooltipValue = "";

        // dom
        $this->dom->HrefValue = "";
        $this->dom->TooltipValue = "";

        // mobile_other
        $this->mobile_other->HrefValue = "";
        $this->mobile_other->TooltipValue = "";

        // mobile_family
        $this->mobile_family->HrefValue = "";
        $this->mobile_family->TooltipValue = "";

        // marital_status
        $this->marital_status->HrefValue = "";
        $this->marital_status->TooltipValue = "";

        // spouse_details
        $this->spouse_details->HrefValue = "";
        $this->spouse_details->TooltipValue = "";

        // emergency_details
        $this->emergency_details->HrefValue = "";
        $this->emergency_details->TooltipValue = "";

        // aadhaar_no
        $this->aadhaar_no->HrefValue = "";
        $this->aadhaar_no->TooltipValue = "";

        // id_proof
        $this->id_proof->HrefValue = "";
        $this->id_proof->TooltipValue = "";

        // reference_details
        $this->reference_details->HrefValue = "";
        $this->reference_details->TooltipValue = "";

        // other_details
        $this->other_details->HrefValue = "";
        $this->other_details->TooltipValue = "";

        // doj
        $this->doj->HrefValue = "";
        $this->doj->TooltipValue = "";

        // doc
        $this->doc->HrefValue = "";
        $this->doc->TooltipValue = "";

        // dol
        $this->dol->HrefValue = "";
        $this->dol->TooltipValue = "";

        // image
        $this->image->HrefValue = "";
        $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
        $this->image->TooltipValue = "";

        // payment_details
        $this->payment_details->HrefValue = "";
        $this->payment_details->TooltipValue = "";

        // bank_name
        $this->bank_name->HrefValue = "";
        $this->bank_name->TooltipValue = "";

        // bank_ifsc_code
        $this->bank_ifsc_code->HrefValue = "";
        $this->bank_ifsc_code->TooltipValue = "";

        // bank_account_no
        $this->bank_account_no->HrefValue = "";
        $this->bank_account_no->TooltipValue = "";

        // status
        if (!EmptyValue($this->status->CurrentValue)) {
            $this->status->HrefValue = $this->status->getLinkPrefix() . $this->status->CurrentValue; // Add prefix/suffix
            $this->status->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
            }
        } else {
            $this->status->HrefValue = "";
        }
        $this->status->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // d_operator
        if (!EmptyValue($this->d_operator->CurrentValue)) {
            $this->d_operator->HrefValue = $this->d_operator->getLinkPrefix() . $this->d_operator->CurrentValue; // Add prefix/suffix
            $this->d_operator->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->d_operator->HrefValue = FullUrl($this->d_operator->HrefValue, "href");
            }
        } else {
            $this->d_operator->HrefValue = "";
        }
        $this->d_operator->TooltipValue = "";

        // d_datetime
        $this->d_datetime->HrefValue = "";
        $this->d_datetime->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // uid
        $this->uid->setupEditAttributes();
        $this->uid->EditValue = $this->uid->CurrentValue;

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->PlaceHolder = RemoveHtml($this->id->caption());
        if (strval($this->id->EditValue) != "" && is_numeric($this->id->EditValue)) {
            $this->id->EditValue = FormatNumber($this->id->EditValue, null);
        }

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->EditValue = $this->grp->options(true);
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

        // site
        $this->site->setupEditAttributes();
        $this->site->PlaceHolder = RemoveHtml($this->site->caption());

        // user_name
        $this->user_name->setupEditAttributes();
        if (!$this->user_name->Raw) {
            $this->user_name->CurrentValue = HtmlDecode($this->user_name->CurrentValue);
        }
        $this->user_name->EditValue = $this->user_name->CurrentValue;
        $this->user_name->PlaceHolder = RemoveHtml($this->user_name->caption());

        // address
        $this->address->setupEditAttributes();
        $this->address->EditValue = $this->address->CurrentValue;
        $this->address->PlaceHolder = RemoveHtml($this->address->caption());

        // mobile
        $this->mobile->setupEditAttributes();
        $this->mobile->EditValue = $this->mobile->CurrentValue;
        $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());
        if (strval($this->mobile->EditValue) != "" && is_numeric($this->mobile->EditValue)) {
            $this->mobile->EditValue = FormatNumber($this->mobile->EditValue, null);
        }

        // category
        $this->category->setupEditAttributes();
        $this->category->EditValue = $this->category->CurrentValue;
        $this->category->PlaceHolder = RemoveHtml($this->category->caption());
        if (strval($this->category->EditValue) != "" && is_numeric($this->category->EditValue)) {
            $this->category->EditValue = FormatNumber($this->category->EditValue, null);
        }

        // process
        $this->process->PlaceHolder = RemoveHtml($this->process->caption());

        // employee_name
        $this->employee_name->setupEditAttributes();
        if (!$this->employee_name->Raw) {
            $this->employee_name->CurrentValue = HtmlDecode($this->employee_name->CurrentValue);
        }
        $this->employee_name->EditValue = $this->employee_name->CurrentValue;
        $this->employee_name->PlaceHolder = RemoveHtml($this->employee_name->caption());

        // gender
        $this->gender->EditValue = $this->gender->options(false);
        $this->gender->PlaceHolder = RemoveHtml($this->gender->caption());

        // father_name
        $this->father_name->setupEditAttributes();
        if (!$this->father_name->Raw) {
            $this->father_name->CurrentValue = HtmlDecode($this->father_name->CurrentValue);
        }
        $this->father_name->EditValue = $this->father_name->CurrentValue;
        $this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

        // designation
        $this->designation->setupEditAttributes();
        $this->designation->EditValue = $this->designation->CurrentValue;
        $this->designation->PlaceHolder = RemoveHtml($this->designation->caption());
        if (strval($this->designation->EditValue) != "" && is_numeric($this->designation->EditValue)) {
            $this->designation->EditValue = FormatNumber($this->designation->EditValue, null);
        }

        // permanent_address
        $this->permanent_address->setupEditAttributes();
        $this->permanent_address->EditValue = $this->permanent_address->CurrentValue;
        $this->permanent_address->PlaceHolder = RemoveHtml($this->permanent_address->caption());

        // city
        $this->city->setupEditAttributes();
        if (!$this->city->Raw) {
            $this->city->CurrentValue = HtmlDecode($this->city->CurrentValue);
        }
        $this->city->EditValue = $this->city->CurrentValue;
        $this->city->PlaceHolder = RemoveHtml($this->city->caption());

        // dob
        $this->dob->setupEditAttributes();
        $this->dob->EditValue = FormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern());
        $this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

        // dom
        $this->dom->setupEditAttributes();
        $this->dom->EditValue = FormatDateTime($this->dom->CurrentValue, $this->dom->formatPattern());
        $this->dom->PlaceHolder = RemoveHtml($this->dom->caption());

        // mobile_other
        $this->mobile_other->setupEditAttributes();
        if (!$this->mobile_other->Raw) {
            $this->mobile_other->CurrentValue = HtmlDecode($this->mobile_other->CurrentValue);
        }
        $this->mobile_other->EditValue = $this->mobile_other->CurrentValue;
        $this->mobile_other->PlaceHolder = RemoveHtml($this->mobile_other->caption());

        // mobile_family
        $this->mobile_family->setupEditAttributes();
        if (!$this->mobile_family->Raw) {
            $this->mobile_family->CurrentValue = HtmlDecode($this->mobile_family->CurrentValue);
        }
        $this->mobile_family->EditValue = $this->mobile_family->CurrentValue;
        $this->mobile_family->PlaceHolder = RemoveHtml($this->mobile_family->caption());

        // marital_status
        $this->marital_status->EditValue = $this->marital_status->options(false);
        $this->marital_status->PlaceHolder = RemoveHtml($this->marital_status->caption());

        // spouse_details
        $this->spouse_details->setupEditAttributes();
        if (!$this->spouse_details->Raw) {
            $this->spouse_details->CurrentValue = HtmlDecode($this->spouse_details->CurrentValue);
        }
        $this->spouse_details->EditValue = $this->spouse_details->CurrentValue;
        $this->spouse_details->PlaceHolder = RemoveHtml($this->spouse_details->caption());

        // emergency_details
        $this->emergency_details->setupEditAttributes();
        if (!$this->emergency_details->Raw) {
            $this->emergency_details->CurrentValue = HtmlDecode($this->emergency_details->CurrentValue);
        }
        $this->emergency_details->EditValue = $this->emergency_details->CurrentValue;
        $this->emergency_details->PlaceHolder = RemoveHtml($this->emergency_details->caption());

        // aadhaar_no
        $this->aadhaar_no->setupEditAttributes();
        if (!$this->aadhaar_no->Raw) {
            $this->aadhaar_no->CurrentValue = HtmlDecode($this->aadhaar_no->CurrentValue);
        }
        $this->aadhaar_no->EditValue = $this->aadhaar_no->CurrentValue;
        $this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

        // id_proof
        $this->id_proof->setupEditAttributes();
        if (!$this->id_proof->Raw) {
            $this->id_proof->CurrentValue = HtmlDecode($this->id_proof->CurrentValue);
        }
        $this->id_proof->EditValue = $this->id_proof->CurrentValue;
        $this->id_proof->PlaceHolder = RemoveHtml($this->id_proof->caption());

        // reference_details
        $this->reference_details->setupEditAttributes();
        if (!$this->reference_details->Raw) {
            $this->reference_details->CurrentValue = HtmlDecode($this->reference_details->CurrentValue);
        }
        $this->reference_details->EditValue = $this->reference_details->CurrentValue;
        $this->reference_details->PlaceHolder = RemoveHtml($this->reference_details->caption());

        // other_details
        $this->other_details->setupEditAttributes();
        $this->other_details->EditValue = $this->other_details->CurrentValue;
        $this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

        // doj
        $this->doj->setupEditAttributes();
        $this->doj->EditValue = FormatDateTime($this->doj->CurrentValue, $this->doj->formatPattern());
        $this->doj->PlaceHolder = RemoveHtml($this->doj->caption());

        // doc
        $this->doc->setupEditAttributes();
        $this->doc->EditValue = FormatDateTime($this->doc->CurrentValue, $this->doc->formatPattern());
        $this->doc->PlaceHolder = RemoveHtml($this->doc->caption());

        // dol
        $this->dol->setupEditAttributes();
        $this->dol->EditValue = FormatDateTime($this->dol->CurrentValue, $this->dol->formatPattern());
        $this->dol->PlaceHolder = RemoveHtml($this->dol->caption());

        // image
        $this->image->setupEditAttributes();
        $this->image->UploadPath = $this->image->getUploadPath(); // PHP
        if (!EmptyValue($this->image->Upload->DbValue)) {
            $this->image->EditValue = $this->image->Upload->DbValue;
        } else {
            $this->image->EditValue = "";
        }
        if (!EmptyValue($this->image->CurrentValue)) {
            $this->image->Upload->FileName = $this->image->CurrentValue;
        }

        // payment_details
        $this->payment_details->setupEditAttributes();
        $this->payment_details->EditValue = $this->payment_details->CurrentValue;
        $this->payment_details->PlaceHolder = RemoveHtml($this->payment_details->caption());

        // bank_name
        $this->bank_name->setupEditAttributes();
        if (!$this->bank_name->Raw) {
            $this->bank_name->CurrentValue = HtmlDecode($this->bank_name->CurrentValue);
        }
        $this->bank_name->EditValue = $this->bank_name->CurrentValue;
        $this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

        // bank_ifsc_code
        $this->bank_ifsc_code->setupEditAttributes();
        if (!$this->bank_ifsc_code->Raw) {
            $this->bank_ifsc_code->CurrentValue = HtmlDecode($this->bank_ifsc_code->CurrentValue);
        }
        $this->bank_ifsc_code->EditValue = $this->bank_ifsc_code->CurrentValue;
        $this->bank_ifsc_code->PlaceHolder = RemoveHtml($this->bank_ifsc_code->caption());

        // bank_account_no
        $this->bank_account_no->setupEditAttributes();
        if (!$this->bank_account_no->Raw) {
            $this->bank_account_no->CurrentValue = HtmlDecode($this->bank_account_no->CurrentValue);
        }
        $this->bank_account_no->EditValue = $this->bank_account_no->CurrentValue;
        $this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

        // status
        $this->status->setupEditAttributes();
        $this->status->EditValue = $this->status->options(true);
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // operator

        // datetime

        // d_operator

        // d_datetime

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->uid);
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->site);
                    $doc->exportCaption($this->user_name);
                    $doc->exportCaption($this->address);
                    $doc->exportCaption($this->mobile);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->employee_name);
                    $doc->exportCaption($this->gender);
                    $doc->exportCaption($this->father_name);
                    $doc->exportCaption($this->designation);
                    $doc->exportCaption($this->permanent_address);
                    $doc->exportCaption($this->city);
                    $doc->exportCaption($this->dob);
                    $doc->exportCaption($this->dom);
                    $doc->exportCaption($this->mobile_other);
                    $doc->exportCaption($this->mobile_family);
                    $doc->exportCaption($this->marital_status);
                    $doc->exportCaption($this->spouse_details);
                    $doc->exportCaption($this->emergency_details);
                    $doc->exportCaption($this->aadhaar_no);
                    $doc->exportCaption($this->id_proof);
                    $doc->exportCaption($this->reference_details);
                    $doc->exportCaption($this->other_details);
                    $doc->exportCaption($this->doj);
                    $doc->exportCaption($this->doc);
                    $doc->exportCaption($this->dol);
                    $doc->exportCaption($this->image);
                    $doc->exportCaption($this->payment_details);
                    $doc->exportCaption($this->bank_name);
                    $doc->exportCaption($this->bank_ifsc_code);
                    $doc->exportCaption($this->bank_account_no);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->d_operator);
                    $doc->exportCaption($this->d_datetime);
                } else {
                    $doc->exportCaption($this->uid);
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->site);
                    $doc->exportCaption($this->user_name);
                    $doc->exportCaption($this->address);
                    $doc->exportCaption($this->mobile);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->employee_name);
                    $doc->exportCaption($this->gender);
                    $doc->exportCaption($this->father_name);
                    $doc->exportCaption($this->designation);
                    $doc->exportCaption($this->permanent_address);
                    $doc->exportCaption($this->city);
                    $doc->exportCaption($this->dob);
                    $doc->exportCaption($this->dom);
                    $doc->exportCaption($this->mobile_other);
                    $doc->exportCaption($this->mobile_family);
                    $doc->exportCaption($this->marital_status);
                    $doc->exportCaption($this->spouse_details);
                    $doc->exportCaption($this->emergency_details);
                    $doc->exportCaption($this->aadhaar_no);
                    $doc->exportCaption($this->id_proof);
                    $doc->exportCaption($this->reference_details);
                    $doc->exportCaption($this->doj);
                    $doc->exportCaption($this->doc);
                    $doc->exportCaption($this->dol);
                    $doc->exportCaption($this->image);
                    $doc->exportCaption($this->bank_name);
                    $doc->exportCaption($this->bank_ifsc_code);
                    $doc->exportCaption($this->bank_account_no);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->d_operator);
                    $doc->exportCaption($this->d_datetime);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->uid);
                        $doc->exportField($this->id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->site);
                        $doc->exportField($this->user_name);
                        $doc->exportField($this->address);
                        $doc->exportField($this->mobile);
                        $doc->exportField($this->process);
                        $doc->exportField($this->employee_name);
                        $doc->exportField($this->gender);
                        $doc->exportField($this->father_name);
                        $doc->exportField($this->designation);
                        $doc->exportField($this->permanent_address);
                        $doc->exportField($this->city);
                        $doc->exportField($this->dob);
                        $doc->exportField($this->dom);
                        $doc->exportField($this->mobile_other);
                        $doc->exportField($this->mobile_family);
                        $doc->exportField($this->marital_status);
                        $doc->exportField($this->spouse_details);
                        $doc->exportField($this->emergency_details);
                        $doc->exportField($this->aadhaar_no);
                        $doc->exportField($this->id_proof);
                        $doc->exportField($this->reference_details);
                        $doc->exportField($this->other_details);
                        $doc->exportField($this->doj);
                        $doc->exportField($this->doc);
                        $doc->exportField($this->dol);
                        $doc->exportField($this->image);
                        $doc->exportField($this->payment_details);
                        $doc->exportField($this->bank_name);
                        $doc->exportField($this->bank_ifsc_code);
                        $doc->exportField($this->bank_account_no);
                        $doc->exportField($this->status);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->d_operator);
                        $doc->exportField($this->d_datetime);
                    } else {
                        $doc->exportField($this->uid);
                        $doc->exportField($this->id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->site);
                        $doc->exportField($this->user_name);
                        $doc->exportField($this->address);
                        $doc->exportField($this->mobile);
                        $doc->exportField($this->process);
                        $doc->exportField($this->employee_name);
                        $doc->exportField($this->gender);
                        $doc->exportField($this->father_name);
                        $doc->exportField($this->designation);
                        $doc->exportField($this->permanent_address);
                        $doc->exportField($this->city);
                        $doc->exportField($this->dob);
                        $doc->exportField($this->dom);
                        $doc->exportField($this->mobile_other);
                        $doc->exportField($this->mobile_family);
                        $doc->exportField($this->marital_status);
                        $doc->exportField($this->spouse_details);
                        $doc->exportField($this->emergency_details);
                        $doc->exportField($this->aadhaar_no);
                        $doc->exportField($this->id_proof);
                        $doc->exportField($this->reference_details);
                        $doc->exportField($this->doj);
                        $doc->exportField($this->doc);
                        $doc->exportField($this->dol);
                        $doc->exportField($this->image);
                        $doc->exportField($this->bank_name);
                        $doc->exportField($this->bank_ifsc_code);
                        $doc->exportField($this->bank_account_no);
                        $doc->exportField($this->status);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->d_operator);
                        $doc->exportField($this->d_datetime);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'image') {
            $fldName = "image";
            $fileNameFld = "image";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->uid->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
