<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductionEmployeeAddopt extends ProductionEmployee
{
    use MessagesTrait;

    // Page ID
    public $PageID = "addopt";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductionEmployeeAddopt";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "productionemployeeaddopt";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->uid->Visible = false;
        $this->grp->setVisibility();
        $this->site->setVisibility();
        $this->id->Visible = false;
        $this->user_name->setVisibility();
        $this->salary->setVisibility();
        $this->contractor->setVisibility();
        $this->address->Visible = false;
        $this->mobile->setVisibility();
        $this->category->Visible = false;
        $this->process->setVisibility();
        $this->status->setVisibility();
        $this->employee_name->setVisibility();
        $this->gender->setVisibility();
        $this->father_name->setVisibility();
        $this->designation->setVisibility();
        $this->permanent_address->setVisibility();
        $this->city->setVisibility();
        $this->dob->setVisibility();
        $this->dom->setVisibility();
        $this->mobile_other->setVisibility();
        $this->mobile_family->setVisibility();
        $this->marital_status->setVisibility();
        $this->spouse_details->setVisibility();
        $this->emergency_details->setVisibility();
        $this->pan_no->setVisibility();
        $this->aadhaar_no->setVisibility();
        $this->id_proof->setVisibility();
        $this->reference_details->setVisibility();
        $this->other_details->setVisibility();
        $this->doj->setVisibility();
        $this->doc->setVisibility();
        $this->dol->setVisibility();
        $this->image->setVisibility();
        $this->payment_details->setVisibility();
        $this->bank_name->setVisibility();
        $this->bank_ifsc_code->setVisibility();
        $this->bank_account_no->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->d_operator->setVisibility();
        $this->d_datetime->setVisibility();
        $this->am_id->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'production_employee';
        $this->TableName = 'production_employee';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-view-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (production_employee)
        if (!isset($GLOBALS["production_employee"]) || $GLOBALS["production_employee"]::class == PROJECT_NAMESPACE . "production_employee") {
            $GLOBALS["production_employee"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'production_employee');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
                $this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['uid'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->uid->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $IsModal = false;
    public $IsMobileOrModal = true; // Add option page is always modal

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->site);
        $this->setupLookupOptions($this->contractor);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->gender);
        $this->setupLookupOptions($this->marital_status);

        // Load default values for add
        $this->loadDefaultValues();

        // Set up Breadcrumb
        // $this->setupBreadcrumb(); // Not used
        $this->loadRowValues(); // Load default values

        // Render row
        $this->RowType = RowType::ADD; // Render add type
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->id_proof->Upload->Index = $CurrentForm->Index;
        $this->id_proof->Upload->uploadFile();
        $this->id_proof->CurrentValue = $this->id_proof->Upload->FileName;
        $this->image->Upload->Index = $CurrentForm->Index;
        $this->image->Upload->uploadFile();
        $this->image->CurrentValue = $this->image->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->grp->DefaultValue = $this->grp->getDefault(); // PHP
        $this->grp->OldValue = $this->grp->DefaultValue;
        $this->site->DefaultValue = $this->site->getDefault(); // PHP
        $this->site->OldValue = $this->site->DefaultValue;
        $this->id->DefaultValue = $this->id->getDefault(); // PHP
        $this->id->OldValue = $this->id->DefaultValue;
        $this->salary->DefaultValue = $this->salary->getDefault(); // PHP
        $this->salary->OldValue = $this->salary->DefaultValue;
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            $this->grp->setFormValue($val);
        }

        // Check field name 'site' first before field var 'x_site'
        $val = $CurrentForm->hasValue("site") ? $CurrentForm->getValue("site") : $CurrentForm->getValue("x_site");
        if (!$this->site->IsDetailKey) {
            $this->site->setFormValue($val);
        }

        // Check field name 'user_name' first before field var 'x_user_name'
        $val = $CurrentForm->hasValue("user_name") ? $CurrentForm->getValue("user_name") : $CurrentForm->getValue("x_user_name");
        if (!$this->user_name->IsDetailKey) {
            $this->user_name->setFormValue($val);
        }

        // Check field name 'salary' first before field var 'x_salary'
        $val = $CurrentForm->hasValue("salary") ? $CurrentForm->getValue("salary") : $CurrentForm->getValue("x_salary");
        if (!$this->salary->IsDetailKey) {
            $this->salary->setFormValue($val, true, $validate);
        }

        // Check field name 'contractor' first before field var 'x_contractor'
        $val = $CurrentForm->hasValue("contractor") ? $CurrentForm->getValue("contractor") : $CurrentForm->getValue("x_contractor");
        if (!$this->contractor->IsDetailKey) {
            $this->contractor->setFormValue($val);
        }

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            $this->mobile->setFormValue($val, true, $validate);
        }

        // Check field name 'process' first before field var 'x_process'
        $val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
        if (!$this->process->IsDetailKey) {
            $this->process->setFormValue($val);
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            $this->status->setFormValue($val);
        }

        // Check field name 'employee_name' first before field var 'x_employee_name'
        $val = $CurrentForm->hasValue("employee_name") ? $CurrentForm->getValue("employee_name") : $CurrentForm->getValue("x_employee_name");
        if (!$this->employee_name->IsDetailKey) {
            $this->employee_name->setFormValue($val);
        }

        // Check field name 'gender' first before field var 'x_gender'
        $val = $CurrentForm->hasValue("gender") ? $CurrentForm->getValue("gender") : $CurrentForm->getValue("x_gender");
        if (!$this->gender->IsDetailKey) {
            $this->gender->setFormValue($val);
        }

        // Check field name 'father_name' first before field var 'x_father_name'
        $val = $CurrentForm->hasValue("father_name") ? $CurrentForm->getValue("father_name") : $CurrentForm->getValue("x_father_name");
        if (!$this->father_name->IsDetailKey) {
            $this->father_name->setFormValue($val);
        }

        // Check field name 'designation' first before field var 'x_designation'
        $val = $CurrentForm->hasValue("designation") ? $CurrentForm->getValue("designation") : $CurrentForm->getValue("x_designation");
        if (!$this->designation->IsDetailKey) {
            $this->designation->setFormValue($val);
        }

        // Check field name 'permanent_address' first before field var 'x_permanent_address'
        $val = $CurrentForm->hasValue("permanent_address") ? $CurrentForm->getValue("permanent_address") : $CurrentForm->getValue("x_permanent_address");
        if (!$this->permanent_address->IsDetailKey) {
            $this->permanent_address->setFormValue($val);
        }

        // Check field name 'city' first before field var 'x_city'
        $val = $CurrentForm->hasValue("city") ? $CurrentForm->getValue("city") : $CurrentForm->getValue("x_city");
        if (!$this->city->IsDetailKey) {
            $this->city->setFormValue($val);
        }

        // Check field name 'dob' first before field var 'x_dob'
        $val = $CurrentForm->hasValue("dob") ? $CurrentForm->getValue("dob") : $CurrentForm->getValue("x_dob");
        if (!$this->dob->IsDetailKey) {
            $this->dob->setFormValue($val, true, $validate);
            $this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern());
        }

        // Check field name 'dom' first before field var 'x_dom'
        $val = $CurrentForm->hasValue("dom") ? $CurrentForm->getValue("dom") : $CurrentForm->getValue("x_dom");
        if (!$this->dom->IsDetailKey) {
            $this->dom->setFormValue($val, true, $validate);
            $this->dom->CurrentValue = UnFormatDateTime($this->dom->CurrentValue, $this->dom->formatPattern());
        }

        // Check field name 'mobile_other' first before field var 'x_mobile_other'
        $val = $CurrentForm->hasValue("mobile_other") ? $CurrentForm->getValue("mobile_other") : $CurrentForm->getValue("x_mobile_other");
        if (!$this->mobile_other->IsDetailKey) {
            $this->mobile_other->setFormValue($val);
        }

        // Check field name 'mobile_family' first before field var 'x_mobile_family'
        $val = $CurrentForm->hasValue("mobile_family") ? $CurrentForm->getValue("mobile_family") : $CurrentForm->getValue("x_mobile_family");
        if (!$this->mobile_family->IsDetailKey) {
            $this->mobile_family->setFormValue($val);
        }

        // Check field name 'marital_status' first before field var 'x_marital_status'
        $val = $CurrentForm->hasValue("marital_status") ? $CurrentForm->getValue("marital_status") : $CurrentForm->getValue("x_marital_status");
        if (!$this->marital_status->IsDetailKey) {
            $this->marital_status->setFormValue($val);
        }

        // Check field name 'spouse_details' first before field var 'x_spouse_details'
        $val = $CurrentForm->hasValue("spouse_details") ? $CurrentForm->getValue("spouse_details") : $CurrentForm->getValue("x_spouse_details");
        if (!$this->spouse_details->IsDetailKey) {
            $this->spouse_details->setFormValue($val);
        }

        // Check field name 'emergency_details' first before field var 'x_emergency_details'
        $val = $CurrentForm->hasValue("emergency_details") ? $CurrentForm->getValue("emergency_details") : $CurrentForm->getValue("x_emergency_details");
        if (!$this->emergency_details->IsDetailKey) {
            $this->emergency_details->setFormValue($val);
        }

        // Check field name 'pan_no' first before field var 'x_pan_no'
        $val = $CurrentForm->hasValue("pan_no") ? $CurrentForm->getValue("pan_no") : $CurrentForm->getValue("x_pan_no");
        if (!$this->pan_no->IsDetailKey) {
            $this->pan_no->setFormValue($val);
        }

        // Check field name 'aadhaar_no' first before field var 'x_aadhaar_no'
        $val = $CurrentForm->hasValue("aadhaar_no") ? $CurrentForm->getValue("aadhaar_no") : $CurrentForm->getValue("x_aadhaar_no");
        if (!$this->aadhaar_no->IsDetailKey) {
            $this->aadhaar_no->setFormValue($val, true, $validate);
        }

        // Check field name 'reference_details' first before field var 'x_reference_details'
        $val = $CurrentForm->hasValue("reference_details") ? $CurrentForm->getValue("reference_details") : $CurrentForm->getValue("x_reference_details");
        if (!$this->reference_details->IsDetailKey) {
            $this->reference_details->setFormValue($val);
        }

        // Check field name 'other_details' first before field var 'x_other_details'
        $val = $CurrentForm->hasValue("other_details") ? $CurrentForm->getValue("other_details") : $CurrentForm->getValue("x_other_details");
        if (!$this->other_details->IsDetailKey) {
            $this->other_details->setFormValue($val);
        }

        // Check field name 'doj' first before field var 'x_doj'
        $val = $CurrentForm->hasValue("doj") ? $CurrentForm->getValue("doj") : $CurrentForm->getValue("x_doj");
        if (!$this->doj->IsDetailKey) {
            $this->doj->setFormValue($val, true, $validate);
            $this->doj->CurrentValue = UnFormatDateTime($this->doj->CurrentValue, $this->doj->formatPattern());
        }

        // Check field name 'doc' first before field var 'x_doc'
        $val = $CurrentForm->hasValue("doc") ? $CurrentForm->getValue("doc") : $CurrentForm->getValue("x_doc");
        if (!$this->doc->IsDetailKey) {
            $this->doc->setFormValue($val, true, $validate);
            $this->doc->CurrentValue = UnFormatDateTime($this->doc->CurrentValue, $this->doc->formatPattern());
        }

        // Check field name 'dol' first before field var 'x_dol'
        $val = $CurrentForm->hasValue("dol") ? $CurrentForm->getValue("dol") : $CurrentForm->getValue("x_dol");
        if (!$this->dol->IsDetailKey) {
            $this->dol->setFormValue($val, true, $validate);
            $this->dol->CurrentValue = UnFormatDateTime($this->dol->CurrentValue, $this->dol->formatPattern());
        }

        // Check field name 'payment_details' first before field var 'x_payment_details'
        $val = $CurrentForm->hasValue("payment_details") ? $CurrentForm->getValue("payment_details") : $CurrentForm->getValue("x_payment_details");
        if (!$this->payment_details->IsDetailKey) {
            $this->payment_details->setFormValue($val);
        }

        // Check field name 'bank_name' first before field var 'x_bank_name'
        $val = $CurrentForm->hasValue("bank_name") ? $CurrentForm->getValue("bank_name") : $CurrentForm->getValue("x_bank_name");
        if (!$this->bank_name->IsDetailKey) {
            $this->bank_name->setFormValue($val);
        }

        // Check field name 'bank_ifsc_code' first before field var 'x_bank_ifsc_code'
        $val = $CurrentForm->hasValue("bank_ifsc_code") ? $CurrentForm->getValue("bank_ifsc_code") : $CurrentForm->getValue("x_bank_ifsc_code");
        if (!$this->bank_ifsc_code->IsDetailKey) {
            $this->bank_ifsc_code->setFormValue($val);
        }

        // Check field name 'bank_account_no' first before field var 'x_bank_account_no'
        $val = $CurrentForm->hasValue("bank_account_no") ? $CurrentForm->getValue("bank_account_no") : $CurrentForm->getValue("x_bank_account_no");
        if (!$this->bank_account_no->IsDetailKey) {
            $this->bank_account_no->setFormValue($val);
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            $this->operator->setFormValue($val, true, $validate);
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            $this->datetime->setFormValue($val, true, $validate);
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'd_operator' first before field var 'x_d_operator'
        $val = $CurrentForm->hasValue("d_operator") ? $CurrentForm->getValue("d_operator") : $CurrentForm->getValue("x_d_operator");
        if (!$this->d_operator->IsDetailKey) {
            $this->d_operator->setFormValue($val);
        }

        // Check field name 'd_datetime' first before field var 'x_d_datetime'
        $val = $CurrentForm->hasValue("d_datetime") ? $CurrentForm->getValue("d_datetime") : $CurrentForm->getValue("x_d_datetime");
        if (!$this->d_datetime->IsDetailKey) {
            $this->d_datetime->setFormValue($val);
            $this->d_datetime->CurrentValue = UnFormatDateTime($this->d_datetime->CurrentValue, $this->d_datetime->formatPattern());
        }

        // Check field name 'am_id' first before field var 'x_am_id'
        $val = $CurrentForm->hasValue("am_id") ? $CurrentForm->getValue("am_id") : $CurrentForm->getValue("x_am_id");
        if (!$this->am_id->IsDetailKey) {
            $this->am_id->setFormValue($val, true, $validate);
        }

        // Check field name 'uid' first before field var 'x_uid'
        $val = $CurrentForm->hasValue("uid") ? $CurrentForm->getValue("uid") : $CurrentForm->getValue("x_uid");
		$this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
		$this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
		$this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
		$this->image->UploadPath = $this->image->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->grp->CurrentValue = ConvertToUtf8($this->grp->FormValue);
        $this->site->CurrentValue = ConvertToUtf8($this->site->FormValue);
        $this->user_name->CurrentValue = ConvertToUtf8($this->user_name->FormValue);
        $this->salary->CurrentValue = ConvertToUtf8($this->salary->FormValue);
        $this->contractor->CurrentValue = ConvertToUtf8($this->contractor->FormValue);
        $this->mobile->CurrentValue = ConvertToUtf8($this->mobile->FormValue);
        $this->process->CurrentValue = ConvertToUtf8($this->process->FormValue);
        $this->status->CurrentValue = ConvertToUtf8($this->status->FormValue);
        $this->employee_name->CurrentValue = ConvertToUtf8($this->employee_name->FormValue);
        $this->gender->CurrentValue = ConvertToUtf8($this->gender->FormValue);
        $this->father_name->CurrentValue = ConvertToUtf8($this->father_name->FormValue);
        $this->designation->CurrentValue = ConvertToUtf8($this->designation->FormValue);
        $this->permanent_address->CurrentValue = ConvertToUtf8($this->permanent_address->FormValue);
        $this->city->CurrentValue = ConvertToUtf8($this->city->FormValue);
        $this->dob->CurrentValue = ConvertToUtf8($this->dob->FormValue);
        $this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern());
        $this->dom->CurrentValue = ConvertToUtf8($this->dom->FormValue);
        $this->dom->CurrentValue = UnFormatDateTime($this->dom->CurrentValue, $this->dom->formatPattern());
        $this->mobile_other->CurrentValue = ConvertToUtf8($this->mobile_other->FormValue);
        $this->mobile_family->CurrentValue = ConvertToUtf8($this->mobile_family->FormValue);
        $this->marital_status->CurrentValue = ConvertToUtf8($this->marital_status->FormValue);
        $this->spouse_details->CurrentValue = ConvertToUtf8($this->spouse_details->FormValue);
        $this->emergency_details->CurrentValue = ConvertToUtf8($this->emergency_details->FormValue);
        $this->pan_no->CurrentValue = ConvertToUtf8($this->pan_no->FormValue);
        $this->aadhaar_no->CurrentValue = ConvertToUtf8($this->aadhaar_no->FormValue);
        $this->reference_details->CurrentValue = ConvertToUtf8($this->reference_details->FormValue);
        $this->other_details->CurrentValue = ConvertToUtf8($this->other_details->FormValue);
        $this->doj->CurrentValue = ConvertToUtf8($this->doj->FormValue);
        $this->doj->CurrentValue = UnFormatDateTime($this->doj->CurrentValue, $this->doj->formatPattern());
        $this->doc->CurrentValue = ConvertToUtf8($this->doc->FormValue);
        $this->doc->CurrentValue = UnFormatDateTime($this->doc->CurrentValue, $this->doc->formatPattern());
        $this->dol->CurrentValue = ConvertToUtf8($this->dol->FormValue);
        $this->dol->CurrentValue = UnFormatDateTime($this->dol->CurrentValue, $this->dol->formatPattern());
        $this->payment_details->CurrentValue = ConvertToUtf8($this->payment_details->FormValue);
        $this->bank_name->CurrentValue = ConvertToUtf8($this->bank_name->FormValue);
        $this->bank_ifsc_code->CurrentValue = ConvertToUtf8($this->bank_ifsc_code->FormValue);
        $this->bank_account_no->CurrentValue = ConvertToUtf8($this->bank_account_no->FormValue);
        $this->operator->CurrentValue = ConvertToUtf8($this->operator->FormValue);
        $this->datetime->CurrentValue = ConvertToUtf8($this->datetime->FormValue);
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->d_operator->CurrentValue = ConvertToUtf8($this->d_operator->FormValue);
        $this->d_datetime->CurrentValue = ConvertToUtf8($this->d_datetime->FormValue);
        $this->d_datetime->CurrentValue = UnFormatDateTime($this->d_datetime->CurrentValue, $this->d_datetime->formatPattern());
        $this->am_id->CurrentValue = ConvertToUtf8($this->am_id->FormValue);
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->uid->setDbValue($row['uid']);
        $this->grp->setDbValue($row['grp']);
        $this->site->setDbValue($row['site']);
        $this->id->setDbValue($row['id']);
        $this->user_name->setDbValue($row['user_name']);
        $this->salary->setDbValue($row['salary']);
        $this->contractor->setDbValue($row['contractor']);
        $this->address->setDbValue($row['address']);
        $this->mobile->setDbValue($row['mobile']);
        $this->category->setDbValue($row['category']);
        $this->process->setDbValue($row['process']);
        $this->status->setDbValue($row['status']);
        $this->employee_name->setDbValue($row['employee_name']);
        $this->gender->setDbValue($row['gender']);
        $this->father_name->setDbValue($row['father_name']);
        $this->designation->setDbValue($row['designation']);
        $this->permanent_address->setDbValue($row['permanent_address']);
        $this->city->setDbValue($row['city']);
        $this->dob->setDbValue($row['dob']);
        $this->dom->setDbValue($row['dom']);
        $this->mobile_other->setDbValue($row['mobile_other']);
        $this->mobile_family->setDbValue($row['mobile_family']);
        $this->marital_status->setDbValue($row['marital_status']);
        $this->spouse_details->setDbValue($row['spouse_details']);
        $this->emergency_details->setDbValue($row['emergency_details']);
        $this->pan_no->setDbValue($row['pan_no']);
        $this->aadhaar_no->setDbValue($row['aadhaar_no']);
        $this->id_proof->Upload->DbValue = $row['id_proof'];
        $this->id_proof->setDbValue($this->id_proof->Upload->DbValue);
        $this->reference_details->setDbValue($row['reference_details']);
        $this->other_details->setDbValue($row['other_details']);
        $this->doj->setDbValue($row['doj']);
        $this->doc->setDbValue($row['doc']);
        $this->dol->setDbValue($row['dol']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->payment_details->setDbValue($row['payment_details']);
        $this->bank_name->setDbValue($row['bank_name']);
        $this->bank_ifsc_code->setDbValue($row['bank_ifsc_code']);
        $this->bank_account_no->setDbValue($row['bank_account_no']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->d_operator->setDbValue($row['d_operator']);
        $this->d_datetime->setDbValue($row['d_datetime']);
        $this->am_id->setDbValue($row['am_id']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['uid'] = $this->uid->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['site'] = $this->site->DefaultValue;
        $row['id'] = $this->id->DefaultValue;
        $row['user_name'] = $this->user_name->DefaultValue;
        $row['salary'] = $this->salary->DefaultValue;
        $row['contractor'] = $this->contractor->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['employee_name'] = $this->employee_name->DefaultValue;
        $row['gender'] = $this->gender->DefaultValue;
        $row['father_name'] = $this->father_name->DefaultValue;
        $row['designation'] = $this->designation->DefaultValue;
        $row['permanent_address'] = $this->permanent_address->DefaultValue;
        $row['city'] = $this->city->DefaultValue;
        $row['dob'] = $this->dob->DefaultValue;
        $row['dom'] = $this->dom->DefaultValue;
        $row['mobile_other'] = $this->mobile_other->DefaultValue;
        $row['mobile_family'] = $this->mobile_family->DefaultValue;
        $row['marital_status'] = $this->marital_status->DefaultValue;
        $row['spouse_details'] = $this->spouse_details->DefaultValue;
        $row['emergency_details'] = $this->emergency_details->DefaultValue;
        $row['pan_no'] = $this->pan_no->DefaultValue;
        $row['aadhaar_no'] = $this->aadhaar_no->DefaultValue;
        $row['id_proof'] = $this->id_proof->DefaultValue;
        $row['reference_details'] = $this->reference_details->DefaultValue;
        $row['other_details'] = $this->other_details->DefaultValue;
        $row['doj'] = $this->doj->DefaultValue;
        $row['doc'] = $this->doc->DefaultValue;
        $row['dol'] = $this->dol->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['payment_details'] = $this->payment_details->DefaultValue;
        $row['bank_name'] = $this->bank_name->DefaultValue;
        $row['bank_ifsc_code'] = $this->bank_ifsc_code->DefaultValue;
        $row['bank_account_no'] = $this->bank_account_no->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['d_operator'] = $this->d_operator->DefaultValue;
        $row['d_datetime'] = $this->d_datetime->DefaultValue;
        $row['am_id'] = $this->am_id->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // uid
        $this->uid->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // site
        $this->site->RowCssClass = "row";

        // id
        $this->id->RowCssClass = "row";

        // user_name
        $this->user_name->RowCssClass = "row";

        // salary
        $this->salary->RowCssClass = "row";

        // contractor
        $this->contractor->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // employee_name
        $this->employee_name->RowCssClass = "row";

        // gender
        $this->gender->RowCssClass = "row";

        // father_name
        $this->father_name->RowCssClass = "row";

        // designation
        $this->designation->RowCssClass = "row";

        // permanent_address
        $this->permanent_address->RowCssClass = "row";

        // city
        $this->city->RowCssClass = "row";

        // dob
        $this->dob->RowCssClass = "row";

        // dom
        $this->dom->RowCssClass = "row";

        // mobile_other
        $this->mobile_other->RowCssClass = "row";

        // mobile_family
        $this->mobile_family->RowCssClass = "row";

        // marital_status
        $this->marital_status->RowCssClass = "row";

        // spouse_details
        $this->spouse_details->RowCssClass = "row";

        // emergency_details
        $this->emergency_details->RowCssClass = "row";

        // pan_no
        $this->pan_no->RowCssClass = "row";

        // aadhaar_no
        $this->aadhaar_no->RowCssClass = "row";

        // id_proof
        $this->id_proof->RowCssClass = "row";

        // reference_details
        $this->reference_details->RowCssClass = "row";

        // other_details
        $this->other_details->RowCssClass = "row";

        // doj
        $this->doj->RowCssClass = "row";

        // doc
        $this->doc->RowCssClass = "row";

        // dol
        $this->dol->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // payment_details
        $this->payment_details->RowCssClass = "row";

        // bank_name
        $this->bank_name->RowCssClass = "row";

        // bank_ifsc_code
        $this->bank_ifsc_code->RowCssClass = "row";

        // bank_account_no
        $this->bank_account_no->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // d_operator
        $this->d_operator->RowCssClass = "row";

        // d_datetime
        $this->d_datetime->RowCssClass = "row";

        // am_id
        $this->am_id->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // uid
            $this->uid->ViewValue = $this->uid->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->grp->Lookup->renderViewRow($row);
                            $this->grp->ViewValue->add($this->grp->displayValue($arwrk));
                        }
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // site
            $curVal = strval($this->site->CurrentValue);
            if ($curVal != "") {
                $this->site->ViewValue = $this->site->lookupCacheOption($curVal);
                if ($this->site->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->site->getSelectFilter($this); // PHP
                    $sqlWrk = $this->site->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->site->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->site->Lookup->renderViewRow($row);
                            $this->site->ViewValue->add($this->site->displayValue($arwrk));
                        }
                    } else {
                        $this->site->ViewValue = $this->site->CurrentValue;
                    }
                }
            } else {
                $this->site->ViewValue = null;
            }

            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // user_name
            $this->user_name->ViewValue = $this->user_name->CurrentValue;

            // salary
            $this->salary->ViewValue = $this->salary->CurrentValue;
            $this->salary->ViewValue = FormatNumber($this->salary->ViewValue, $this->salary->formatPattern());

            // contractor
            $curVal = strval($this->contractor->CurrentValue);
            if ($curVal != "") {
                $this->contractor->ViewValue = $this->contractor->lookupCacheOption($curVal);
                if ($this->contractor->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->contractor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->contractor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->contractor->getSelectFilter($this); // PHP
                    $sqlWrk = $this->contractor->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->contractor->Lookup->renderViewRow($rswrk[0]);
                        $this->contractor->ViewValue = $this->contractor->displayValue($arwrk);
                    } else {
                        $this->contractor->ViewValue = FormatNumber($this->contractor->CurrentValue, $this->contractor->formatPattern());
                    }
                }
            } else {
                $this->contractor->ViewValue = null;
            }

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, $this->mobile->formatPattern());

            // category
            if (strval($this->category->CurrentValue) != "") {
                $this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
            } else {
                $this->category->ViewValue = null;
            }

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process->Lookup->renderViewRow($row);
                            $this->process->ViewValue->add($this->process->displayValue($arwrk));
                        }
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // employee_name
            $this->employee_name->ViewValue = $this->employee_name->CurrentValue;

            // gender
            if (strval($this->gender->CurrentValue) != "") {
                $this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
            } else {
                $this->gender->ViewValue = null;
            }

            // father_name
            $this->father_name->ViewValue = $this->father_name->CurrentValue;

            // designation
            $this->designation->ViewValue = $this->designation->CurrentValue;

            // permanent_address
            $this->permanent_address->ViewValue = $this->permanent_address->CurrentValue;

            // city
            $this->city->ViewValue = $this->city->CurrentValue;

            // dob
            $this->dob->ViewValue = $this->dob->CurrentValue;
            $this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, $this->dob->formatPattern());

            // dom
            $this->dom->ViewValue = $this->dom->CurrentValue;
            $this->dom->ViewValue = FormatDateTime($this->dom->ViewValue, $this->dom->formatPattern());

            // mobile_other
            $this->mobile_other->ViewValue = $this->mobile_other->CurrentValue;

            // mobile_family
            $this->mobile_family->ViewValue = $this->mobile_family->CurrentValue;

            // marital_status
            if (strval($this->marital_status->CurrentValue) != "") {
                $this->marital_status->ViewValue = $this->marital_status->optionCaption($this->marital_status->CurrentValue);
            } else {
                $this->marital_status->ViewValue = null;
            }

            // spouse_details
            $this->spouse_details->ViewValue = $this->spouse_details->CurrentValue;

            // emergency_details
            $this->emergency_details->ViewValue = $this->emergency_details->CurrentValue;

            // pan_no
            $this->pan_no->ViewValue = $this->pan_no->CurrentValue;

            // aadhaar_no
            $this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;

            // id_proof
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
            } else {
                $this->id_proof->ViewValue = "";
            }

            // reference_details
            $this->reference_details->ViewValue = $this->reference_details->CurrentValue;

            // other_details
            $this->other_details->ViewValue = $this->other_details->CurrentValue;

            // doj
            $this->doj->ViewValue = $this->doj->CurrentValue;
            $this->doj->ViewValue = FormatDateTime($this->doj->ViewValue, $this->doj->formatPattern());

            // doc
            $this->doc->ViewValue = $this->doc->CurrentValue;
            $this->doc->ViewValue = FormatDateTime($this->doc->ViewValue, $this->doc->formatPattern());

            // dol
            $this->dol->ViewValue = $this->dol->CurrentValue;
            $this->dol->ViewValue = FormatDateTime($this->dol->ViewValue, $this->dol->formatPattern());

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // payment_details
            $this->payment_details->ViewValue = $this->payment_details->CurrentValue;

            // bank_name
            $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

            // bank_ifsc_code
            $this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;

            // bank_account_no
            $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // d_operator
            $this->d_operator->ViewValue = $this->d_operator->CurrentValue;
            $this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, $this->d_operator->formatPattern());

            // d_datetime
            $this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
            $this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, $this->d_datetime->formatPattern());

            // am_id
            $this->am_id->ViewValue = $this->am_id->CurrentValue;
            $this->am_id->ViewValue = FormatNumber($this->am_id->ViewValue, $this->am_id->formatPattern());

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // site
            if (!EmptyValue($this->site->CurrentValue)) {
                $this->site->HrefValue = $this->site->getLinkPrefix() . $this->site->CurrentValue; // Add prefix/suffix
                $this->site->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->site->HrefValue = FullUrl($this->site->HrefValue, "href");
                }
            } else {
                $this->site->HrefValue = "";
            }
            $this->site->TooltipValue = "";

            // user_name
            $this->user_name->HrefValue = "";
            $this->user_name->TooltipValue = "";

            // salary
            $this->salary->HrefValue = "";
            $this->salary->TooltipValue = "";

            // contractor
            $this->contractor->HrefValue = "";
            $this->contractor->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // process
            $this->process->HrefValue = "";
            $this->process->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // employee_name
            $this->employee_name->HrefValue = "";
            $this->employee_name->TooltipValue = "";

            // gender
            $this->gender->HrefValue = "";
            $this->gender->TooltipValue = "";

            // father_name
            $this->father_name->HrefValue = "";
            $this->father_name->TooltipValue = "";

            // designation
            $this->designation->HrefValue = "";
            $this->designation->TooltipValue = "";

            // permanent_address
            $this->permanent_address->HrefValue = "";
            $this->permanent_address->TooltipValue = "";

            // city
            $this->city->HrefValue = "";
            $this->city->TooltipValue = "";

            // dob
            $this->dob->HrefValue = "";
            $this->dob->TooltipValue = "";

            // dom
            $this->dom->HrefValue = "";
            $this->dom->TooltipValue = "";

            // mobile_other
            $this->mobile_other->HrefValue = "";
            $this->mobile_other->TooltipValue = "";

            // mobile_family
            $this->mobile_family->HrefValue = "";
            $this->mobile_family->TooltipValue = "";

            // marital_status
            $this->marital_status->HrefValue = "";
            $this->marital_status->TooltipValue = "";

            // spouse_details
            $this->spouse_details->HrefValue = "";
            $this->spouse_details->TooltipValue = "";

            // emergency_details
            $this->emergency_details->HrefValue = "";
            $this->emergency_details->TooltipValue = "";

            // pan_no
            $this->pan_no->HrefValue = "";
            $this->pan_no->TooltipValue = "";

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";
            $this->aadhaar_no->TooltipValue = "";

            // id_proof
            $this->id_proof->HrefValue = "";
            $this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;
            $this->id_proof->TooltipValue = "";

            // reference_details
            $this->reference_details->HrefValue = "";
            $this->reference_details->TooltipValue = "";

            // other_details
            $this->other_details->HrefValue = "";
            $this->other_details->TooltipValue = "";

            // doj
            $this->doj->HrefValue = "";
            $this->doj->TooltipValue = "";

            // doc
            $this->doc->HrefValue = "";
            $this->doc->TooltipValue = "";

            // dol
            $this->dol->HrefValue = "";
            $this->dol->TooltipValue = "";

            // image
            $this->image->HrefValue = "";
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
            $this->image->TooltipValue = "";

            // payment_details
            $this->payment_details->HrefValue = "";
            $this->payment_details->TooltipValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";
            $this->bank_name->TooltipValue = "";

            // bank_ifsc_code
            $this->bank_ifsc_code->HrefValue = "";
            $this->bank_ifsc_code->TooltipValue = "";

            // bank_account_no
            $this->bank_account_no->HrefValue = "";
            $this->bank_account_no->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // d_operator
            $this->d_operator->HrefValue = "";
            $this->d_operator->TooltipValue = "";

            // d_datetime
            $this->d_datetime->HrefValue = "";
            $this->d_datetime->TooltipValue = "";

            // am_id
            $this->am_id->HrefValue = "";
            $this->am_id->TooltipValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // grp
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // site
            $this->site->setupEditAttributes();
            $curVal = trim(strval($this->site->CurrentValue));
            if ($curVal != "") {
                $this->site->ViewValue = $this->site->lookupCacheOption($curVal);
            } else {
                $this->site->ViewValue = $this->site->Lookup !== null && is_array($this->site->lookupOptions()) && count($this->site->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->site->ViewValue !== null) { // Load from cache
                $this->site->EditValue = array_values($this->site->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->site->getSelectFilter($this); // PHP
                $sqlWrk = $this->site->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->site->EditValue = $arwrk;
            }
            $this->site->PlaceHolder = RemoveHtml($this->site->caption());

            // user_name
            $this->user_name->setupEditAttributes();
            if (!$this->user_name->Raw) {
                $this->user_name->CurrentValue = HtmlDecode($this->user_name->CurrentValue);
            }
            $this->user_name->EditValue = HtmlEncode($this->user_name->CurrentValue);
            $this->user_name->PlaceHolder = RemoveHtml($this->user_name->caption());

            // salary
            $this->salary->setupEditAttributes();
            $this->salary->EditValue = $this->salary->CurrentValue;
            $this->salary->PlaceHolder = RemoveHtml($this->salary->caption());
            if (strval($this->salary->EditValue) != "" && is_numeric($this->salary->EditValue)) {
                $this->salary->EditValue = FormatNumber($this->salary->EditValue, null);
            }

            // contractor
            $this->contractor->setupEditAttributes();
            $curVal = trim(strval($this->contractor->CurrentValue));
            if ($curVal != "") {
                $this->contractor->ViewValue = $this->contractor->lookupCacheOption($curVal);
            } else {
                $this->contractor->ViewValue = $this->contractor->Lookup !== null && is_array($this->contractor->lookupOptions()) && count($this->contractor->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->contractor->ViewValue !== null) { // Load from cache
                $this->contractor->EditValue = array_values($this->contractor->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->contractor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->contractor->CurrentValue, $this->contractor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->contractor->getSelectFilter($this); // PHP
                $sqlWrk = $this->contractor->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->contractor->Lookup->renderViewRow($row);
                }
                $this->contractor->EditValue = $arwrk;
            }
            $this->contractor->PlaceHolder = RemoveHtml($this->contractor->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            $this->mobile->EditValue = $this->mobile->CurrentValue;
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());
            if (strval($this->mobile->EditValue) != "" && is_numeric($this->mobile->EditValue)) {
                $this->mobile->EditValue = FormatNumber($this->mobile->EditValue, null);
            }

            // process
            $curVal = trim(strval($this->process->CurrentValue));
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            } else {
                $this->process->ViewValue = $this->process->Lookup !== null && is_array($this->process->lookupOptions()) && count($this->process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process->ViewValue !== null) { // Load from cache
                $this->process->EditValue = array_values($this->process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process->EditValue = $arwrk;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // employee_name
            $this->employee_name->setupEditAttributes();
            if (!$this->employee_name->Raw) {
                $this->employee_name->CurrentValue = HtmlDecode($this->employee_name->CurrentValue);
            }
            $this->employee_name->EditValue = HtmlEncode($this->employee_name->CurrentValue);
            $this->employee_name->PlaceHolder = RemoveHtml($this->employee_name->caption());

            // gender
            $this->gender->setupEditAttributes();
            $this->gender->EditValue = $this->gender->options(true);
            $this->gender->PlaceHolder = RemoveHtml($this->gender->caption());

            // father_name
            $this->father_name->setupEditAttributes();
            if (!$this->father_name->Raw) {
                $this->father_name->CurrentValue = HtmlDecode($this->father_name->CurrentValue);
            }
            $this->father_name->EditValue = HtmlEncode($this->father_name->CurrentValue);
            $this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

            // designation
            $this->designation->setupEditAttributes();
            if (!$this->designation->Raw) {
                $this->designation->CurrentValue = HtmlDecode($this->designation->CurrentValue);
            }
            $this->designation->EditValue = HtmlEncode($this->designation->CurrentValue);
            $this->designation->PlaceHolder = RemoveHtml($this->designation->caption());

            // permanent_address
            $this->permanent_address->setupEditAttributes();
            $this->permanent_address->EditValue = HtmlEncode($this->permanent_address->CurrentValue);
            $this->permanent_address->PlaceHolder = RemoveHtml($this->permanent_address->caption());

            // city
            $this->city->setupEditAttributes();
            if (!$this->city->Raw) {
                $this->city->CurrentValue = HtmlDecode($this->city->CurrentValue);
            }
            $this->city->EditValue = HtmlEncode($this->city->CurrentValue);
            $this->city->PlaceHolder = RemoveHtml($this->city->caption());

            // dob
            $this->dob->setupEditAttributes();
            $this->dob->EditValue = HtmlEncode(FormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern()));
            $this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

            // dom
            $this->dom->setupEditAttributes();
            $this->dom->EditValue = HtmlEncode(FormatDateTime($this->dom->CurrentValue, $this->dom->formatPattern()));
            $this->dom->PlaceHolder = RemoveHtml($this->dom->caption());

            // mobile_other
            $this->mobile_other->setupEditAttributes();
            if (!$this->mobile_other->Raw) {
                $this->mobile_other->CurrentValue = HtmlDecode($this->mobile_other->CurrentValue);
            }
            $this->mobile_other->EditValue = HtmlEncode($this->mobile_other->CurrentValue);
            $this->mobile_other->PlaceHolder = RemoveHtml($this->mobile_other->caption());

            // mobile_family
            $this->mobile_family->setupEditAttributes();
            if (!$this->mobile_family->Raw) {
                $this->mobile_family->CurrentValue = HtmlDecode($this->mobile_family->CurrentValue);
            }
            $this->mobile_family->EditValue = HtmlEncode($this->mobile_family->CurrentValue);
            $this->mobile_family->PlaceHolder = RemoveHtml($this->mobile_family->caption());

            // marital_status
            $this->marital_status->setupEditAttributes();
            $this->marital_status->EditValue = $this->marital_status->options(true);
            $this->marital_status->PlaceHolder = RemoveHtml($this->marital_status->caption());

            // spouse_details
            $this->spouse_details->setupEditAttributes();
            if (!$this->spouse_details->Raw) {
                $this->spouse_details->CurrentValue = HtmlDecode($this->spouse_details->CurrentValue);
            }
            $this->spouse_details->EditValue = HtmlEncode($this->spouse_details->CurrentValue);
            $this->spouse_details->PlaceHolder = RemoveHtml($this->spouse_details->caption());

            // emergency_details
            $this->emergency_details->setupEditAttributes();
            if (!$this->emergency_details->Raw) {
                $this->emergency_details->CurrentValue = HtmlDecode($this->emergency_details->CurrentValue);
            }
            $this->emergency_details->EditValue = HtmlEncode($this->emergency_details->CurrentValue);
            $this->emergency_details->PlaceHolder = RemoveHtml($this->emergency_details->caption());

            // pan_no
            $this->pan_no->setupEditAttributes();
            if (!$this->pan_no->Raw) {
                $this->pan_no->CurrentValue = HtmlDecode($this->pan_no->CurrentValue);
            }
            $this->pan_no->EditValue = HtmlEncode($this->pan_no->CurrentValue);
            $this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

            // aadhaar_no
            $this->aadhaar_no->setupEditAttributes();
            if (!$this->aadhaar_no->Raw) {
                $this->aadhaar_no->CurrentValue = HtmlDecode($this->aadhaar_no->CurrentValue);
            }
            $this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->CurrentValue);
            $this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

            // id_proof
            $this->id_proof->setupEditAttributes();
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->EditValue = $this->id_proof->Upload->DbValue;
            } else {
                $this->id_proof->EditValue = "";
            }
            if (!EmptyValue($this->id_proof->CurrentValue)) {
                $this->id_proof->Upload->FileName = $this->id_proof->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->id_proof->Upload->DbValue = null;
            }
            if ($this->isShow()) {
                RenderUploadField($this->id_proof);
            }

            // reference_details
            $this->reference_details->setupEditAttributes();
            if (!$this->reference_details->Raw) {
                $this->reference_details->CurrentValue = HtmlDecode($this->reference_details->CurrentValue);
            }
            $this->reference_details->EditValue = HtmlEncode($this->reference_details->CurrentValue);
            $this->reference_details->PlaceHolder = RemoveHtml($this->reference_details->caption());

            // other_details
            $this->other_details->setupEditAttributes();
            $this->other_details->EditValue = HtmlEncode($this->other_details->CurrentValue);
            $this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

            // doj
            $this->doj->setupEditAttributes();
            $this->doj->EditValue = HtmlEncode(FormatDateTime($this->doj->CurrentValue, $this->doj->formatPattern()));
            $this->doj->PlaceHolder = RemoveHtml($this->doj->caption());

            // doc
            $this->doc->setupEditAttributes();
            $this->doc->EditValue = HtmlEncode(FormatDateTime($this->doc->CurrentValue, $this->doc->formatPattern()));
            $this->doc->PlaceHolder = RemoveHtml($this->doc->caption());

            // dol
            $this->dol->setupEditAttributes();
            $this->dol->EditValue = HtmlEncode(FormatDateTime($this->dol->CurrentValue, $this->dol->formatPattern()));
            $this->dol->PlaceHolder = RemoveHtml($this->dol->caption());

            // image
            $this->image->setupEditAttributes();
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->EditValue = $this->image->Upload->DbValue;
            } else {
                $this->image->EditValue = "";
            }
            if (!EmptyValue($this->image->CurrentValue)) {
                $this->image->Upload->FileName = $this->image->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->image->Upload->DbValue = null;
            }
            if ($this->isShow()) {
                RenderUploadField($this->image);
            }

            // payment_details
            $this->payment_details->setupEditAttributes();
            $this->payment_details->EditValue = HtmlEncode($this->payment_details->CurrentValue);
            $this->payment_details->PlaceHolder = RemoveHtml($this->payment_details->caption());

            // bank_name
            $this->bank_name->setupEditAttributes();
            if (!$this->bank_name->Raw) {
                $this->bank_name->CurrentValue = HtmlDecode($this->bank_name->CurrentValue);
            }
            $this->bank_name->EditValue = HtmlEncode($this->bank_name->CurrentValue);
            $this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

            // bank_ifsc_code
            $this->bank_ifsc_code->setupEditAttributes();
            if (!$this->bank_ifsc_code->Raw) {
                $this->bank_ifsc_code->CurrentValue = HtmlDecode($this->bank_ifsc_code->CurrentValue);
            }
            $this->bank_ifsc_code->EditValue = HtmlEncode($this->bank_ifsc_code->CurrentValue);
            $this->bank_ifsc_code->PlaceHolder = RemoveHtml($this->bank_ifsc_code->caption());

            // bank_account_no
            $this->bank_account_no->setupEditAttributes();
            if (!$this->bank_account_no->Raw) {
                $this->bank_account_no->CurrentValue = HtmlDecode($this->bank_account_no->CurrentValue);
            }
            $this->bank_account_no->EditValue = HtmlEncode($this->bank_account_no->CurrentValue);
            $this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->CurrentValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());
            if (strval($this->operator->EditValue) != "" && is_numeric($this->operator->EditValue)) {
                $this->operator->EditValue = FormatNumber($this->operator->EditValue, null);
            }

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // d_operator
            $this->d_operator->setupEditAttributes();
            $this->d_operator->CurrentValue = FormatNumber(CurrentUserID(), $this->d_operator->formatPattern());
            if (strval($this->d_operator->EditValue) != "" && is_numeric($this->d_operator->EditValue)) {
                $this->d_operator->EditValue = FormatNumber($this->d_operator->EditValue, null);
            }

            // d_datetime
            $this->d_datetime->setupEditAttributes();
            $this->d_datetime->CurrentValue = FormatDateTime(CurrentDateTime(), $this->d_datetime->formatPattern());

            // am_id
            $this->am_id->setupEditAttributes();
            $this->am_id->EditValue = $this->am_id->CurrentValue;
            $this->am_id->PlaceHolder = RemoveHtml($this->am_id->caption());
            if (strval($this->am_id->EditValue) != "" && is_numeric($this->am_id->EditValue)) {
                $this->am_id->EditValue = FormatNumber($this->am_id->EditValue, null);
            }

            // Add refer script

            // grp
            $this->grp->HrefValue = "";

            // site
            if (!EmptyValue($this->site->CurrentValue)) {
                $this->site->HrefValue = $this->site->getLinkPrefix() . $this->site->CurrentValue; // Add prefix/suffix
                $this->site->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->site->HrefValue = FullUrl($this->site->HrefValue, "href");
                }
            } else {
                $this->site->HrefValue = "";
            }

            // user_name
            $this->user_name->HrefValue = "";

            // salary
            $this->salary->HrefValue = "";

            // contractor
            $this->contractor->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // process
            $this->process->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // employee_name
            $this->employee_name->HrefValue = "";

            // gender
            $this->gender->HrefValue = "";

            // father_name
            $this->father_name->HrefValue = "";

            // designation
            $this->designation->HrefValue = "";

            // permanent_address
            $this->permanent_address->HrefValue = "";

            // city
            $this->city->HrefValue = "";

            // dob
            $this->dob->HrefValue = "";

            // dom
            $this->dom->HrefValue = "";

            // mobile_other
            $this->mobile_other->HrefValue = "";

            // mobile_family
            $this->mobile_family->HrefValue = "";

            // marital_status
            $this->marital_status->HrefValue = "";

            // spouse_details
            $this->spouse_details->HrefValue = "";

            // emergency_details
            $this->emergency_details->HrefValue = "";

            // pan_no
            $this->pan_no->HrefValue = "";

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";

            // id_proof
            $this->id_proof->HrefValue = "";
            $this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;

            // reference_details
            $this->reference_details->HrefValue = "";

            // other_details
            $this->other_details->HrefValue = "";

            // doj
            $this->doj->HrefValue = "";

            // doc
            $this->doc->HrefValue = "";

            // dol
            $this->dol->HrefValue = "";

            // image
            $this->image->HrefValue = "";
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

            // payment_details
            $this->payment_details->HrefValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";

            // bank_ifsc_code
            $this->bank_ifsc_code->HrefValue = "";

            // bank_account_no
            $this->bank_account_no->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // d_operator
            $this->d_operator->HrefValue = "";

            // d_datetime
            $this->d_datetime->HrefValue = "";

            // am_id
            $this->am_id->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->grp->Visible && $this->grp->Required) {
                if ($this->grp->FormValue == "") {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->site->Visible && $this->site->Required) {
                if ($this->site->FormValue == "") {
                    $this->site->addErrorMessage(str_replace("%s", $this->site->caption(), $this->site->RequiredErrorMessage));
                }
            }
            if ($this->user_name->Visible && $this->user_name->Required) {
                if (!$this->user_name->IsDetailKey && EmptyValue($this->user_name->FormValue)) {
                    $this->user_name->addErrorMessage(str_replace("%s", $this->user_name->caption(), $this->user_name->RequiredErrorMessage));
                }
            }
            if ($this->salary->Visible && $this->salary->Required) {
                if (!$this->salary->IsDetailKey && EmptyValue($this->salary->FormValue)) {
                    $this->salary->addErrorMessage(str_replace("%s", $this->salary->caption(), $this->salary->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->salary->FormValue)) {
                $this->salary->addErrorMessage($this->salary->getErrorMessage(false));
            }
            if ($this->contractor->Visible && $this->contractor->Required) {
                if (!$this->contractor->IsDetailKey && EmptyValue($this->contractor->FormValue)) {
                    $this->contractor->addErrorMessage(str_replace("%s", $this->contractor->caption(), $this->contractor->RequiredErrorMessage));
                }
            }
            if ($this->mobile->Visible && $this->mobile->Required) {
                if (!$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->mobile->FormValue)) {
                $this->mobile->addErrorMessage($this->mobile->getErrorMessage(false));
            }
            if ($this->process->Visible && $this->process->Required) {
                if ($this->process->FormValue == "") {
                    $this->process->addErrorMessage(str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->employee_name->Visible && $this->employee_name->Required) {
                if (!$this->employee_name->IsDetailKey && EmptyValue($this->employee_name->FormValue)) {
                    $this->employee_name->addErrorMessage(str_replace("%s", $this->employee_name->caption(), $this->employee_name->RequiredErrorMessage));
                }
            }
            if ($this->gender->Visible && $this->gender->Required) {
                if (!$this->gender->IsDetailKey && EmptyValue($this->gender->FormValue)) {
                    $this->gender->addErrorMessage(str_replace("%s", $this->gender->caption(), $this->gender->RequiredErrorMessage));
                }
            }
            if ($this->father_name->Visible && $this->father_name->Required) {
                if (!$this->father_name->IsDetailKey && EmptyValue($this->father_name->FormValue)) {
                    $this->father_name->addErrorMessage(str_replace("%s", $this->father_name->caption(), $this->father_name->RequiredErrorMessage));
                }
            }
            if ($this->designation->Visible && $this->designation->Required) {
                if (!$this->designation->IsDetailKey && EmptyValue($this->designation->FormValue)) {
                    $this->designation->addErrorMessage(str_replace("%s", $this->designation->caption(), $this->designation->RequiredErrorMessage));
                }
            }
            if ($this->permanent_address->Visible && $this->permanent_address->Required) {
                if (!$this->permanent_address->IsDetailKey && EmptyValue($this->permanent_address->FormValue)) {
                    $this->permanent_address->addErrorMessage(str_replace("%s", $this->permanent_address->caption(), $this->permanent_address->RequiredErrorMessage));
                }
            }
            if ($this->city->Visible && $this->city->Required) {
                if (!$this->city->IsDetailKey && EmptyValue($this->city->FormValue)) {
                    $this->city->addErrorMessage(str_replace("%s", $this->city->caption(), $this->city->RequiredErrorMessage));
                }
            }
            if ($this->dob->Visible && $this->dob->Required) {
                if (!$this->dob->IsDetailKey && EmptyValue($this->dob->FormValue)) {
                    $this->dob->addErrorMessage(str_replace("%s", $this->dob->caption(), $this->dob->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dob->FormValue, $this->dob->formatPattern())) {
                $this->dob->addErrorMessage($this->dob->getErrorMessage(false));
            }
            if ($this->dom->Visible && $this->dom->Required) {
                if (!$this->dom->IsDetailKey && EmptyValue($this->dom->FormValue)) {
                    $this->dom->addErrorMessage(str_replace("%s", $this->dom->caption(), $this->dom->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dom->FormValue, $this->dom->formatPattern())) {
                $this->dom->addErrorMessage($this->dom->getErrorMessage(false));
            }
            if ($this->mobile_other->Visible && $this->mobile_other->Required) {
                if (!$this->mobile_other->IsDetailKey && EmptyValue($this->mobile_other->FormValue)) {
                    $this->mobile_other->addErrorMessage(str_replace("%s", $this->mobile_other->caption(), $this->mobile_other->RequiredErrorMessage));
                }
            }
            if ($this->mobile_family->Visible && $this->mobile_family->Required) {
                if (!$this->mobile_family->IsDetailKey && EmptyValue($this->mobile_family->FormValue)) {
                    $this->mobile_family->addErrorMessage(str_replace("%s", $this->mobile_family->caption(), $this->mobile_family->RequiredErrorMessage));
                }
            }
            if ($this->marital_status->Visible && $this->marital_status->Required) {
                if (!$this->marital_status->IsDetailKey && EmptyValue($this->marital_status->FormValue)) {
                    $this->marital_status->addErrorMessage(str_replace("%s", $this->marital_status->caption(), $this->marital_status->RequiredErrorMessage));
                }
            }
            if ($this->spouse_details->Visible && $this->spouse_details->Required) {
                if (!$this->spouse_details->IsDetailKey && EmptyValue($this->spouse_details->FormValue)) {
                    $this->spouse_details->addErrorMessage(str_replace("%s", $this->spouse_details->caption(), $this->spouse_details->RequiredErrorMessage));
                }
            }
            if ($this->emergency_details->Visible && $this->emergency_details->Required) {
                if (!$this->emergency_details->IsDetailKey && EmptyValue($this->emergency_details->FormValue)) {
                    $this->emergency_details->addErrorMessage(str_replace("%s", $this->emergency_details->caption(), $this->emergency_details->RequiredErrorMessage));
                }
            }
            if ($this->pan_no->Visible && $this->pan_no->Required) {
                if (!$this->pan_no->IsDetailKey && EmptyValue($this->pan_no->FormValue)) {
                    $this->pan_no->addErrorMessage(str_replace("%s", $this->pan_no->caption(), $this->pan_no->RequiredErrorMessage));
                }
            }
            if ($this->aadhaar_no->Visible && $this->aadhaar_no->Required) {
                if (!$this->aadhaar_no->IsDetailKey && EmptyValue($this->aadhaar_no->FormValue)) {
                    $this->aadhaar_no->addErrorMessage(str_replace("%s", $this->aadhaar_no->caption(), $this->aadhaar_no->RequiredErrorMessage));
                }
            }
            if ($this->id_proof->Visible && $this->id_proof->Required) {
                if ($this->id_proof->Upload->FileName == "" && !$this->id_proof->Upload->KeepFile) {
                    $this->id_proof->addErrorMessage(str_replace("%s", $this->id_proof->caption(), $this->id_proof->RequiredErrorMessage));
                }
            }
            if ($this->reference_details->Visible && $this->reference_details->Required) {
                if (!$this->reference_details->IsDetailKey && EmptyValue($this->reference_details->FormValue)) {
                    $this->reference_details->addErrorMessage(str_replace("%s", $this->reference_details->caption(), $this->reference_details->RequiredErrorMessage));
                }
            }
            if ($this->other_details->Visible && $this->other_details->Required) {
                if (!$this->other_details->IsDetailKey && EmptyValue($this->other_details->FormValue)) {
                    $this->other_details->addErrorMessage(str_replace("%s", $this->other_details->caption(), $this->other_details->RequiredErrorMessage));
                }
            }
            if ($this->doj->Visible && $this->doj->Required) {
                if (!$this->doj->IsDetailKey && EmptyValue($this->doj->FormValue)) {
                    $this->doj->addErrorMessage(str_replace("%s", $this->doj->caption(), $this->doj->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->doj->FormValue, $this->doj->formatPattern())) {
                $this->doj->addErrorMessage($this->doj->getErrorMessage(false));
            }
            if ($this->doc->Visible && $this->doc->Required) {
                if (!$this->doc->IsDetailKey && EmptyValue($this->doc->FormValue)) {
                    $this->doc->addErrorMessage(str_replace("%s", $this->doc->caption(), $this->doc->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->doc->FormValue, $this->doc->formatPattern())) {
                $this->doc->addErrorMessage($this->doc->getErrorMessage(false));
            }
            if ($this->dol->Visible && $this->dol->Required) {
                if (!$this->dol->IsDetailKey && EmptyValue($this->dol->FormValue)) {
                    $this->dol->addErrorMessage(str_replace("%s", $this->dol->caption(), $this->dol->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dol->FormValue, $this->dol->formatPattern())) {
                $this->dol->addErrorMessage($this->dol->getErrorMessage(false));
            }
            if ($this->image->Visible && $this->image->Required) {
                if ($this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
                    $this->image->addErrorMessage(str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
                }
            }
            if ($this->payment_details->Visible && $this->payment_details->Required) {
                if (!$this->payment_details->IsDetailKey && EmptyValue($this->payment_details->FormValue)) {
                    $this->payment_details->addErrorMessage(str_replace("%s", $this->payment_details->caption(), $this->payment_details->RequiredErrorMessage));
                }
            }
            if ($this->bank_name->Visible && $this->bank_name->Required) {
                if (!$this->bank_name->IsDetailKey && EmptyValue($this->bank_name->FormValue)) {
                    $this->bank_name->addErrorMessage(str_replace("%s", $this->bank_name->caption(), $this->bank_name->RequiredErrorMessage));
                }
            }
            if ($this->bank_ifsc_code->Visible && $this->bank_ifsc_code->Required) {
                if (!$this->bank_ifsc_code->IsDetailKey && EmptyValue($this->bank_ifsc_code->FormValue)) {
                    $this->bank_ifsc_code->addErrorMessage(str_replace("%s", $this->bank_ifsc_code->caption(), $this->bank_ifsc_code->RequiredErrorMessage));
                }
            }
            if ($this->bank_account_no->Visible && $this->bank_account_no->Required) {
                if (!$this->bank_account_no->IsDetailKey && EmptyValue($this->bank_account_no->FormValue)) {
                    $this->bank_account_no->addErrorMessage(str_replace("%s", $this->bank_account_no->caption(), $this->bank_account_no->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->operator->FormValue)) {
                $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->datetime->FormValue, $this->datetime->formatPattern())) {
                $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
            }
            if ($this->d_operator->Visible && $this->d_operator->Required) {
                if (!$this->d_operator->IsDetailKey && EmptyValue($this->d_operator->FormValue)) {
                    $this->d_operator->addErrorMessage(str_replace("%s", $this->d_operator->caption(), $this->d_operator->RequiredErrorMessage));
                }
            }
            if ($this->d_datetime->Visible && $this->d_datetime->Required) {
                if (!$this->d_datetime->IsDetailKey && EmptyValue($this->d_datetime->FormValue)) {
                    $this->d_datetime->addErrorMessage(str_replace("%s", $this->d_datetime->caption(), $this->d_datetime->RequiredErrorMessage));
                }
            }
            if ($this->am_id->Visible && $this->am_id->Required) {
                if (!$this->am_id->IsDetailKey && EmptyValue($this->am_id->FormValue)) {
                    $this->am_id->addErrorMessage(str_replace("%s", $this->am_id->caption(), $this->am_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->am_id->FormValue)) {
                $this->am_id->addErrorMessage($this->am_id->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("productionemployeelist"), "", $this->TableVar, true);
        $pageId = "addopt";
        $Breadcrumb->add("addopt", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_site":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_contractor":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_gender":
                    break;
                case "x_marital_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
