<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductGroupView extends ProductGroup
{
    use MessagesTrait;

    // Page ID
    public $PageID = "view";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductGroupView";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "productgroupview";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->grp->setVisibility();
        $this->product_group->setVisibility();
        $this->calculation_method->setVisibility();
        $this->shape->setVisibility();
        $this->sqm->setVisibility();
        $this->cbm->setVisibility();
        $this->process->setVisibility();
        $this->status->setVisibility();
        $this->v_00->setVisibility();
        $this->v_01->setVisibility();
        $this->v_01_validation->setVisibility();
        $this->v_02->setVisibility();
        $this->v_02_validation->setVisibility();
        $this->v_03->setVisibility();
        $this->v_03_validation->setVisibility();
        $this->v_04->setVisibility();
        $this->v_04_validation->setVisibility();
        $this->v_05->setVisibility();
        $this->v_05_validation->setVisibility();
        $this->v_06->setVisibility();
        $this->v_06_validation->setVisibility();
        $this->v_07->setVisibility();
        $this->v_07_validation->setVisibility();
        $this->v_08->setVisibility();
        $this->v_08_validation->setVisibility();
        $this->v_09->setVisibility();
        $this->v_09_validation->setVisibility();
        $this->v_10->setVisibility();
        $this->v_10_validation->setVisibility();
        $this->b_01_head->setVisibility();
        $this->b_02_head->setVisibility();
        $this->b_03_head->setVisibility();
        $this->b_04_head->setVisibility();
        $this->b_05_head->setVisibility();
        $this->b_06_head->setVisibility();
        $this->b_07_head->setVisibility();
        $this->b_08_head->setVisibility();
        $this->b_09_head->setVisibility();
        $this->b_10_head->setVisibility();
        $this->b_11_head->setVisibility();
        $this->b_12_head->setVisibility();
        $this->b_13_head->setVisibility();
        $this->b_14_head->setVisibility();
        $this->b_15_head->setVisibility();
        $this->q_sku->setVisibility();
        $this->t_01_head->setVisibility();
        $this->t_02_head->setVisibility();
        $this->t_03_head->setVisibility();
        $this->t_04_head->setVisibility();
        $this->t_05_head->setVisibility();
        $this->t_06_head->setVisibility();
        $this->t_07_head->setVisibility();
        $this->t_08_head->setVisibility();
        $this->t_09_head->setVisibility();
        $this->t_10_head->setVisibility();
        $this->t_11_head->setVisibility();
        $this->t_12_head->setVisibility();
        $this->t_13_head->setVisibility();
        $this->t_14_head->setVisibility();
        $this->t_15_head->setVisibility();
        $this->po_01_head->setVisibility();
        $this->po_02_head->setVisibility();
        $this->po_03_head->setVisibility();
        $this->po_04_head->setVisibility();
        $this->po_05_head->setVisibility();
        $this->po_06_head->setVisibility();
        $this->po_07_head->setVisibility();
        $this->po_08_head->setVisibility();
        $this->po_17_head->setVisibility();
        $this->po_18_head->setVisibility();
        $this->po_19_head->setVisibility();
        $this->po_20_head->setVisibility();
        $this->jc_01_head->setVisibility();
        $this->jc_02_head->setVisibility();
        $this->jc_03_head->setVisibility();
        $this->jc_04_head->setVisibility();
        $this->jc_05_head->setVisibility();
        $this->jc_06_head->setVisibility();
        $this->jc_07_head->setVisibility();
        $this->jc_08_head->setVisibility();
        $this->jc_09_head->setVisibility();
        $this->jc_10_head->setVisibility();
        $this->pc_shape->setVisibility();
        $this->pc_unit->setVisibility();
        $this->pc_w->setVisibility();
        $this->pc_l->setVisibility();
        $this->pc_h->setVisibility();
        $this->pc_partner_size->setVisibility();
        $this->pc_sqm->setVisibility();
        $this->pc_01_head->setVisibility();
        $this->pc_02_head->setVisibility();
        $this->pc_03_head->setVisibility();
        $this->pc_04_head->setVisibility();
        $this->pc_05_head->setVisibility();
        $this->pc_06_head->setVisibility();
        $this->pc_07_head->setVisibility();
        $this->pc_08_head->setVisibility();
        $this->pc_09_head->setVisibility();
        $this->pc_10_head->setVisibility();
        $this->pc_11_head->setVisibility();
        $this->pc_12_head->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->image->setVisibility();
        $this->pa_process_size_w->setVisibility();
        $this->pa_process_size_l->setVisibility();
        $this->pa_head_01->setVisibility();
        $this->pa_process_01->setVisibility();
        $this->pa_head_02->setVisibility();
        $this->pa_process_02->setVisibility();
        $this->pa_head_03->setVisibility();
        $this->pa_process_03->setVisibility();
        $this->pa_head_04->setVisibility();
        $this->pa_process_04->setVisibility();
        $this->pa_head_05->setVisibility();
        $this->pa_process_05->setVisibility();
        $this->pa_head_06->setVisibility();
        $this->pa_process_06->setVisibility();
        $this->pa_head_07->setVisibility();
        $this->pa_process_07->setVisibility();
        $this->pa_head_08->setVisibility();
        $this->pa_process_08->setVisibility();
        $this->pa_head_09->setVisibility();
        $this->pa_process_09->setVisibility();
        $this->pa_head_10->setVisibility();
        $this->pa_process_10->setVisibility();
        $this->publish->setVisibility();
        $this->ppr_01->setVisibility();
        $this->ppr_02->setVisibility();
        $this->ppr_03->setVisibility();
        $this->ppr_04->setVisibility();
        $this->ppr_05->setVisibility();
        $this->ppr_06->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'product_group';
        $this->TableName = 'product_group';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-view-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (product_group)
        if (!isset($GLOBALS["product_group"]) || $GLOBALS["product_group"]::class == PROJECT_NAMESPACE . "product_group") {
            $GLOBALS["product_group"] = &$this;
        }

        // Set up record key
        if (($keyValue = Get("id") ?? Route("id")) !== null) {
            $this->RecKey["id"] = $keyValue;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_group');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "productgroupview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $ExportOptions; // Export options
    public $OtherOptions; // Other options
    public $DisplayRecords = 1;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecKey = [];
    public $IsModal = false;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->calculation_method);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->v_01_validation);
        $this->setupLookupOptions($this->pa_process_01);
        $this->setupLookupOptions($this->pa_process_02);
        $this->setupLookupOptions($this->pa_process_03);
        $this->setupLookupOptions($this->pa_process_04);
        $this->setupLookupOptions($this->pa_process_05);
        $this->setupLookupOptions($this->pa_process_06);
        $this->setupLookupOptions($this->pa_process_07);
        $this->setupLookupOptions($this->pa_process_08);
        $this->setupLookupOptions($this->pa_process_09);
        $this->setupLookupOptions($this->pa_process_10);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }

        // Load current record
        $loadCurrentRecord = false;
        $returnUrl = "";
        $matchRecord = false;
        if (($keyValue = Get("id") ?? Route("id")) !== null) {
            $this->id->setQueryStringValue($keyValue);
            $this->RecKey["id"] = $this->id->QueryStringValue;
        } elseif (Post("id") !== null) {
            $this->id->setFormValue(Post("id"));
            $this->RecKey["id"] = $this->id->FormValue;
        } elseif (IsApi() && ($keyValue = Key(0) ?? Route(2)) !== null) {
            $this->id->setQueryStringValue($keyValue);
            $this->RecKey["id"] = $this->id->QueryStringValue;
        } elseif (!$loadCurrentRecord) {
            $returnUrl = "productgrouplist"; // Return to list
        }

        // Get action
        $this->CurrentAction = "show"; // Display
        switch ($this->CurrentAction) {
            case "show": // Get a record to display

                    // Load record based on key
                    if (IsApi()) {
                        $filter = $this->getRecordFilter();
                        $this->CurrentFilter = $filter;
                        $sql = $this->getCurrentSql();
                        $conn = $this->getConnection();
                        $res = ($this->Recordset = ExecuteQuery($sql, $conn));
                    } else {
                        $res = $this->loadRow();
                    }
                    if (!$res) { // Load record based on key
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $returnUrl = "productgrouplist"; // No matching record, return to list
                    }
                break;
        }
        if ($returnUrl != "") {
            $this->terminate($returnUrl);
            return;
        }

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Render row
        $this->RowType = RowType::VIEW;
        $this->resetAttributes();
        $this->renderRow();

        // Normal return
        if (IsApi()) {
            if (!$this->isExport()) {
                $row = $this->getRecordsFromRecordset($this->Recordset, true); // Get current record only
                $this->Recordset?->free();
                WriteJson(["success" => true, "action" => Config("API_VIEW_ACTION"), $this->TableVar => $row]);
                $this->terminate(true);
            }
            return;
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;

        // Disable Add/Edit/Copy/Delete for Modal and UseAjaxActions
        /*
        if ($this->IsModal && $this->UseAjaxActions) {
            $this->AddUrl = "";
            $this->EditUrl = "";
            $this->CopyUrl = "";
            $this->DeleteUrl = "";
        }
        */
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();

        // Edit
        $item = &$option->add("edit");
        $editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
        }
        $item->Visible = $this->EditUrl != "" && $Security->canEdit();

        // Copy
        $item = &$option->add("copy");
        $copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
        }
        $item->Visible = $this->CopyUrl != "" && $Security->canAdd();

        // Set up action default
        $option = $options["action"];
        $option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
        $option->UseDropDownButton = !IsJsonResponse() && false;
        $option->UseButtonGroup = true;
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->product_group->setDbValue($row['product_group']);
        $this->calculation_method->setDbValue($row['calculation_method']);
        $this->shape->setDbValue($row['shape']);
        $this->sqm->setDbValue($row['sqm']);
        $this->cbm->setDbValue($row['cbm']);
        $this->process->setDbValue($row['process']);
        $this->status->setDbValue($row['status']);
        $this->v_00->setDbValue($row['v_00']);
        $this->v_01->setDbValue($row['v_01']);
        $this->v_01_validation->setDbValue($row['v_01_validation']);
        $this->v_02->setDbValue($row['v_02']);
        $this->v_02_validation->setDbValue($row['v_02_validation']);
        $this->v_03->setDbValue($row['v_03']);
        $this->v_03_validation->setDbValue($row['v_03_validation']);
        $this->v_04->setDbValue($row['v_04']);
        $this->v_04_validation->setDbValue($row['v_04_validation']);
        $this->v_05->setDbValue($row['v_05']);
        $this->v_05_validation->setDbValue($row['v_05_validation']);
        $this->v_06->setDbValue($row['v_06']);
        $this->v_06_validation->setDbValue($row['v_06_validation']);
        $this->v_07->setDbValue($row['v_07']);
        $this->v_07_validation->setDbValue($row['v_07_validation']);
        $this->v_08->setDbValue($row['v_08']);
        $this->v_08_validation->setDbValue($row['v_08_validation']);
        $this->v_09->setDbValue($row['v_09']);
        $this->v_09_validation->setDbValue($row['v_09_validation']);
        $this->v_10->setDbValue($row['v_10']);
        $this->v_10_validation->setDbValue($row['v_10_validation']);
        $this->b_01_head->setDbValue($row['b_01_head']);
        $this->b_02_head->setDbValue($row['b_02_head']);
        $this->b_03_head->setDbValue($row['b_03_head']);
        $this->b_04_head->setDbValue($row['b_04_head']);
        $this->b_05_head->setDbValue($row['b_05_head']);
        $this->b_06_head->setDbValue($row['b_06_head']);
        $this->b_07_head->setDbValue($row['b_07_head']);
        $this->b_08_head->setDbValue($row['b_08_head']);
        $this->b_09_head->setDbValue($row['b_09_head']);
        $this->b_10_head->setDbValue($row['b_10_head']);
        $this->b_11_head->setDbValue($row['b_11_head']);
        $this->b_12_head->setDbValue($row['b_12_head']);
        $this->b_13_head->setDbValue($row['b_13_head']);
        $this->b_14_head->setDbValue($row['b_14_head']);
        $this->b_15_head->setDbValue($row['b_15_head']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->t_01_head->setDbValue($row['t_01_head']);
        $this->t_02_head->setDbValue($row['t_02_head']);
        $this->t_03_head->setDbValue($row['t_03_head']);
        $this->t_04_head->setDbValue($row['t_04_head']);
        $this->t_05_head->setDbValue($row['t_05_head']);
        $this->t_06_head->setDbValue($row['t_06_head']);
        $this->t_07_head->setDbValue($row['t_07_head']);
        $this->t_08_head->setDbValue($row['t_08_head']);
        $this->t_09_head->setDbValue($row['t_09_head']);
        $this->t_10_head->setDbValue($row['t_10_head']);
        $this->t_11_head->setDbValue($row['t_11_head']);
        $this->t_12_head->setDbValue($row['t_12_head']);
        $this->t_13_head->setDbValue($row['t_13_head']);
        $this->t_14_head->setDbValue($row['t_14_head']);
        $this->t_15_head->setDbValue($row['t_15_head']);
        $this->po_01_head->setDbValue($row['po_01_head']);
        $this->po_02_head->setDbValue($row['po_02_head']);
        $this->po_03_head->setDbValue($row['po_03_head']);
        $this->po_04_head->setDbValue($row['po_04_head']);
        $this->po_05_head->setDbValue($row['po_05_head']);
        $this->po_06_head->setDbValue($row['po_06_head']);
        $this->po_07_head->setDbValue($row['po_07_head']);
        $this->po_08_head->setDbValue($row['po_08_head']);
        $this->po_17_head->setDbValue($row['po_17_head']);
        $this->po_18_head->setDbValue($row['po_18_head']);
        $this->po_19_head->setDbValue($row['po_19_head']);
        $this->po_20_head->setDbValue($row['po_20_head']);
        $this->jc_01_head->setDbValue($row['jc_01_head']);
        $this->jc_02_head->setDbValue($row['jc_02_head']);
        $this->jc_03_head->setDbValue($row['jc_03_head']);
        $this->jc_04_head->setDbValue($row['jc_04_head']);
        $this->jc_05_head->setDbValue($row['jc_05_head']);
        $this->jc_06_head->setDbValue($row['jc_06_head']);
        $this->jc_07_head->setDbValue($row['jc_07_head']);
        $this->jc_08_head->setDbValue($row['jc_08_head']);
        $this->jc_09_head->setDbValue($row['jc_09_head']);
        $this->jc_10_head->setDbValue($row['jc_10_head']);
        $this->pc_shape->setDbValue($row['pc_shape']);
        $this->pc_unit->setDbValue($row['pc_unit']);
        $this->pc_w->setDbValue($row['pc_w']);
        $this->pc_l->setDbValue($row['pc_l']);
        $this->pc_h->setDbValue($row['pc_h']);
        $this->pc_partner_size->setDbValue($row['pc_partner_size']);
        $this->pc_sqm->setDbValue($row['pc_sqm']);
        $this->pc_01_head->setDbValue($row['pc_01_head']);
        $this->pc_02_head->setDbValue($row['pc_02_head']);
        $this->pc_03_head->setDbValue($row['pc_03_head']);
        $this->pc_04_head->setDbValue($row['pc_04_head']);
        $this->pc_05_head->setDbValue($row['pc_05_head']);
        $this->pc_06_head->setDbValue($row['pc_06_head']);
        $this->pc_07_head->setDbValue($row['pc_07_head']);
        $this->pc_08_head->setDbValue($row['pc_08_head']);
        $this->pc_09_head->setDbValue($row['pc_09_head']);
        $this->pc_10_head->setDbValue($row['pc_10_head']);
        $this->pc_11_head->setDbValue($row['pc_11_head']);
        $this->pc_12_head->setDbValue($row['pc_12_head']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->pa_process_size_w->setDbValue($row['pa_process_size_w']);
        $this->pa_process_size_l->setDbValue($row['pa_process_size_l']);
        $this->pa_head_01->setDbValue($row['pa_head_01']);
        $this->pa_process_01->setDbValue($row['pa_process_01']);
        $this->pa_head_02->setDbValue($row['pa_head_02']);
        $this->pa_process_02->setDbValue($row['pa_process_02']);
        $this->pa_head_03->setDbValue($row['pa_head_03']);
        $this->pa_process_03->setDbValue($row['pa_process_03']);
        $this->pa_head_04->setDbValue($row['pa_head_04']);
        $this->pa_process_04->setDbValue($row['pa_process_04']);
        $this->pa_head_05->setDbValue($row['pa_head_05']);
        $this->pa_process_05->setDbValue($row['pa_process_05']);
        $this->pa_head_06->setDbValue($row['pa_head_06']);
        $this->pa_process_06->setDbValue($row['pa_process_06']);
        $this->pa_head_07->setDbValue($row['pa_head_07']);
        $this->pa_process_07->setDbValue($row['pa_process_07']);
        $this->pa_head_08->setDbValue($row['pa_head_08']);
        $this->pa_process_08->setDbValue($row['pa_process_08']);
        $this->pa_head_09->setDbValue($row['pa_head_09']);
        $this->pa_process_09->setDbValue($row['pa_process_09']);
        $this->pa_head_10->setDbValue($row['pa_head_10']);
        $this->pa_process_10->setDbValue($row['pa_process_10']);
        $this->publish->setDbValue($row['publish']);
        $this->ppr_01->setDbValue($row['ppr_01']);
        $this->ppr_02->setDbValue($row['ppr_02']);
        $this->ppr_03->setDbValue($row['ppr_03']);
        $this->ppr_04->setDbValue($row['ppr_04']);
        $this->ppr_05->setDbValue($row['ppr_05']);
        $this->ppr_06->setDbValue($row['ppr_06']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['product_group'] = $this->product_group->DefaultValue;
        $row['calculation_method'] = $this->calculation_method->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['v_00'] = $this->v_00->DefaultValue;
        $row['v_01'] = $this->v_01->DefaultValue;
        $row['v_01_validation'] = $this->v_01_validation->DefaultValue;
        $row['v_02'] = $this->v_02->DefaultValue;
        $row['v_02_validation'] = $this->v_02_validation->DefaultValue;
        $row['v_03'] = $this->v_03->DefaultValue;
        $row['v_03_validation'] = $this->v_03_validation->DefaultValue;
        $row['v_04'] = $this->v_04->DefaultValue;
        $row['v_04_validation'] = $this->v_04_validation->DefaultValue;
        $row['v_05'] = $this->v_05->DefaultValue;
        $row['v_05_validation'] = $this->v_05_validation->DefaultValue;
        $row['v_06'] = $this->v_06->DefaultValue;
        $row['v_06_validation'] = $this->v_06_validation->DefaultValue;
        $row['v_07'] = $this->v_07->DefaultValue;
        $row['v_07_validation'] = $this->v_07_validation->DefaultValue;
        $row['v_08'] = $this->v_08->DefaultValue;
        $row['v_08_validation'] = $this->v_08_validation->DefaultValue;
        $row['v_09'] = $this->v_09->DefaultValue;
        $row['v_09_validation'] = $this->v_09_validation->DefaultValue;
        $row['v_10'] = $this->v_10->DefaultValue;
        $row['v_10_validation'] = $this->v_10_validation->DefaultValue;
        $row['b_01_head'] = $this->b_01_head->DefaultValue;
        $row['b_02_head'] = $this->b_02_head->DefaultValue;
        $row['b_03_head'] = $this->b_03_head->DefaultValue;
        $row['b_04_head'] = $this->b_04_head->DefaultValue;
        $row['b_05_head'] = $this->b_05_head->DefaultValue;
        $row['b_06_head'] = $this->b_06_head->DefaultValue;
        $row['b_07_head'] = $this->b_07_head->DefaultValue;
        $row['b_08_head'] = $this->b_08_head->DefaultValue;
        $row['b_09_head'] = $this->b_09_head->DefaultValue;
        $row['b_10_head'] = $this->b_10_head->DefaultValue;
        $row['b_11_head'] = $this->b_11_head->DefaultValue;
        $row['b_12_head'] = $this->b_12_head->DefaultValue;
        $row['b_13_head'] = $this->b_13_head->DefaultValue;
        $row['b_14_head'] = $this->b_14_head->DefaultValue;
        $row['b_15_head'] = $this->b_15_head->DefaultValue;
        $row['q_sku'] = $this->q_sku->DefaultValue;
        $row['t_01_head'] = $this->t_01_head->DefaultValue;
        $row['t_02_head'] = $this->t_02_head->DefaultValue;
        $row['t_03_head'] = $this->t_03_head->DefaultValue;
        $row['t_04_head'] = $this->t_04_head->DefaultValue;
        $row['t_05_head'] = $this->t_05_head->DefaultValue;
        $row['t_06_head'] = $this->t_06_head->DefaultValue;
        $row['t_07_head'] = $this->t_07_head->DefaultValue;
        $row['t_08_head'] = $this->t_08_head->DefaultValue;
        $row['t_09_head'] = $this->t_09_head->DefaultValue;
        $row['t_10_head'] = $this->t_10_head->DefaultValue;
        $row['t_11_head'] = $this->t_11_head->DefaultValue;
        $row['t_12_head'] = $this->t_12_head->DefaultValue;
        $row['t_13_head'] = $this->t_13_head->DefaultValue;
        $row['t_14_head'] = $this->t_14_head->DefaultValue;
        $row['t_15_head'] = $this->t_15_head->DefaultValue;
        $row['po_01_head'] = $this->po_01_head->DefaultValue;
        $row['po_02_head'] = $this->po_02_head->DefaultValue;
        $row['po_03_head'] = $this->po_03_head->DefaultValue;
        $row['po_04_head'] = $this->po_04_head->DefaultValue;
        $row['po_05_head'] = $this->po_05_head->DefaultValue;
        $row['po_06_head'] = $this->po_06_head->DefaultValue;
        $row['po_07_head'] = $this->po_07_head->DefaultValue;
        $row['po_08_head'] = $this->po_08_head->DefaultValue;
        $row['po_17_head'] = $this->po_17_head->DefaultValue;
        $row['po_18_head'] = $this->po_18_head->DefaultValue;
        $row['po_19_head'] = $this->po_19_head->DefaultValue;
        $row['po_20_head'] = $this->po_20_head->DefaultValue;
        $row['jc_01_head'] = $this->jc_01_head->DefaultValue;
        $row['jc_02_head'] = $this->jc_02_head->DefaultValue;
        $row['jc_03_head'] = $this->jc_03_head->DefaultValue;
        $row['jc_04_head'] = $this->jc_04_head->DefaultValue;
        $row['jc_05_head'] = $this->jc_05_head->DefaultValue;
        $row['jc_06_head'] = $this->jc_06_head->DefaultValue;
        $row['jc_07_head'] = $this->jc_07_head->DefaultValue;
        $row['jc_08_head'] = $this->jc_08_head->DefaultValue;
        $row['jc_09_head'] = $this->jc_09_head->DefaultValue;
        $row['jc_10_head'] = $this->jc_10_head->DefaultValue;
        $row['pc_shape'] = $this->pc_shape->DefaultValue;
        $row['pc_unit'] = $this->pc_unit->DefaultValue;
        $row['pc_w'] = $this->pc_w->DefaultValue;
        $row['pc_l'] = $this->pc_l->DefaultValue;
        $row['pc_h'] = $this->pc_h->DefaultValue;
        $row['pc_partner_size'] = $this->pc_partner_size->DefaultValue;
        $row['pc_sqm'] = $this->pc_sqm->DefaultValue;
        $row['pc_01_head'] = $this->pc_01_head->DefaultValue;
        $row['pc_02_head'] = $this->pc_02_head->DefaultValue;
        $row['pc_03_head'] = $this->pc_03_head->DefaultValue;
        $row['pc_04_head'] = $this->pc_04_head->DefaultValue;
        $row['pc_05_head'] = $this->pc_05_head->DefaultValue;
        $row['pc_06_head'] = $this->pc_06_head->DefaultValue;
        $row['pc_07_head'] = $this->pc_07_head->DefaultValue;
        $row['pc_08_head'] = $this->pc_08_head->DefaultValue;
        $row['pc_09_head'] = $this->pc_09_head->DefaultValue;
        $row['pc_10_head'] = $this->pc_10_head->DefaultValue;
        $row['pc_11_head'] = $this->pc_11_head->DefaultValue;
        $row['pc_12_head'] = $this->pc_12_head->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['pa_process_size_w'] = $this->pa_process_size_w->DefaultValue;
        $row['pa_process_size_l'] = $this->pa_process_size_l->DefaultValue;
        $row['pa_head_01'] = $this->pa_head_01->DefaultValue;
        $row['pa_process_01'] = $this->pa_process_01->DefaultValue;
        $row['pa_head_02'] = $this->pa_head_02->DefaultValue;
        $row['pa_process_02'] = $this->pa_process_02->DefaultValue;
        $row['pa_head_03'] = $this->pa_head_03->DefaultValue;
        $row['pa_process_03'] = $this->pa_process_03->DefaultValue;
        $row['pa_head_04'] = $this->pa_head_04->DefaultValue;
        $row['pa_process_04'] = $this->pa_process_04->DefaultValue;
        $row['pa_head_05'] = $this->pa_head_05->DefaultValue;
        $row['pa_process_05'] = $this->pa_process_05->DefaultValue;
        $row['pa_head_06'] = $this->pa_head_06->DefaultValue;
        $row['pa_process_06'] = $this->pa_process_06->DefaultValue;
        $row['pa_head_07'] = $this->pa_head_07->DefaultValue;
        $row['pa_process_07'] = $this->pa_process_07->DefaultValue;
        $row['pa_head_08'] = $this->pa_head_08->DefaultValue;
        $row['pa_process_08'] = $this->pa_process_08->DefaultValue;
        $row['pa_head_09'] = $this->pa_head_09->DefaultValue;
        $row['pa_process_09'] = $this->pa_process_09->DefaultValue;
        $row['pa_head_10'] = $this->pa_head_10->DefaultValue;
        $row['pa_process_10'] = $this->pa_process_10->DefaultValue;
        $row['publish'] = $this->publish->DefaultValue;
        $row['ppr_01'] = $this->ppr_01->DefaultValue;
        $row['ppr_02'] = $this->ppr_02->DefaultValue;
        $row['ppr_03'] = $this->ppr_03->DefaultValue;
        $row['ppr_04'] = $this->ppr_04->DefaultValue;
        $row['ppr_05'] = $this->ppr_05->DefaultValue;
        $row['ppr_06'] = $this->ppr_06->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->AddUrl = $this->getAddUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();
        $this->ListUrl = $this->getListUrl();
        $this->setupOtherOptions();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // grp

        // product_group

        // calculation_method

        // shape

        // sqm

        // cbm

        // process

        // status

        // v_00

        // v_01

        // v_01_validation

        // v_02

        // v_02_validation

        // v_03

        // v_03_validation

        // v_04

        // v_04_validation

        // v_05

        // v_05_validation

        // v_06

        // v_06_validation

        // v_07

        // v_07_validation

        // v_08

        // v_08_validation

        // v_09

        // v_09_validation

        // v_10

        // v_10_validation

        // b_01_head

        // b_02_head

        // b_03_head

        // b_04_head

        // b_05_head

        // b_06_head

        // b_07_head

        // b_08_head

        // b_09_head

        // b_10_head

        // b_11_head

        // b_12_head

        // b_13_head

        // b_14_head

        // b_15_head

        // q_sku

        // t_01_head

        // t_02_head

        // t_03_head

        // t_04_head

        // t_05_head

        // t_06_head

        // t_07_head

        // t_08_head

        // t_09_head

        // t_10_head

        // t_11_head

        // t_12_head

        // t_13_head

        // t_14_head

        // t_15_head

        // po_01_head

        // po_02_head

        // po_03_head

        // po_04_head

        // po_05_head

        // po_06_head

        // po_07_head

        // po_08_head

        // po_17_head

        // po_18_head

        // po_19_head

        // po_20_head

        // jc_01_head

        // jc_02_head

        // jc_03_head

        // jc_04_head

        // jc_05_head

        // jc_06_head

        // jc_07_head

        // jc_08_head

        // jc_09_head

        // jc_10_head

        // pc_shape

        // pc_unit

        // pc_w

        // pc_l

        // pc_h

        // pc_partner_size

        // pc_sqm

        // pc_01_head

        // pc_02_head

        // pc_03_head

        // pc_04_head

        // pc_05_head

        // pc_06_head

        // pc_07_head

        // pc_08_head

        // pc_09_head

        // pc_10_head

        // pc_11_head

        // pc_12_head

        // operator

        // datetime

        // image

        // pa_process_size_w

        // pa_process_size_l

        // pa_head_01

        // pa_process_01

        // pa_head_02

        // pa_process_02

        // pa_head_03

        // pa_process_03

        // pa_head_04

        // pa_process_04

        // pa_head_05

        // pa_process_05

        // pa_head_06

        // pa_process_06

        // pa_head_07

        // pa_process_07

        // pa_head_08

        // pa_process_08

        // pa_head_09

        // pa_process_09

        // pa_head_10

        // pa_process_10

        // publish

        // ppr_01

        // ppr_02

        // ppr_03

        // ppr_04

        // ppr_05

        // ppr_06

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // product_group
            $this->product_group->ViewValue = $this->product_group->CurrentValue;

            // calculation_method
            $curVal = strval($this->calculation_method->CurrentValue);
            if ($curVal != "") {
                $this->calculation_method->ViewValue = $this->calculation_method->lookupCacheOption($curVal);
                if ($this->calculation_method->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->calculation_method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->calculation_method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->calculation_method->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->calculation_method->Lookup->renderViewRow($rswrk[0]);
                        $this->calculation_method->ViewValue = $this->calculation_method->displayValue($arwrk);
                    } else {
                        $this->calculation_method->ViewValue = FormatNumber($this->calculation_method->CurrentValue, $this->calculation_method->formatPattern());
                    }
                }
            } else {
                $this->calculation_method->ViewValue = null;
            }

            // shape
            $this->shape->ViewValue = $this->shape->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // v_00
            $this->v_00->ViewValue = $this->v_00->CurrentValue;

            // v_01
            $this->v_01->ViewValue = $this->v_01->CurrentValue;

            // v_01_validation
            $this->v_01_validation->ViewValue = $this->v_01_validation->CurrentValue;

            // v_02
            $this->v_02->ViewValue = $this->v_02->CurrentValue;

            // v_02_validation
            $this->v_02_validation->ViewValue = $this->v_02_validation->CurrentValue;

            // v_03
            $this->v_03->ViewValue = $this->v_03->CurrentValue;

            // v_03_validation
            $this->v_03_validation->ViewValue = $this->v_03_validation->CurrentValue;

            // v_04
            $this->v_04->ViewValue = $this->v_04->CurrentValue;

            // v_04_validation
            $this->v_04_validation->ViewValue = $this->v_04_validation->CurrentValue;

            // v_05
            $this->v_05->ViewValue = $this->v_05->CurrentValue;

            // v_05_validation
            $this->v_05_validation->ViewValue = $this->v_05_validation->CurrentValue;

            // v_06
            $this->v_06->ViewValue = $this->v_06->CurrentValue;

            // v_06_validation
            $this->v_06_validation->ViewValue = $this->v_06_validation->CurrentValue;

            // v_07
            $this->v_07->ViewValue = $this->v_07->CurrentValue;

            // v_07_validation
            $this->v_07_validation->ViewValue = $this->v_07_validation->CurrentValue;

            // v_08
            $this->v_08->ViewValue = $this->v_08->CurrentValue;

            // v_08_validation
            $this->v_08_validation->ViewValue = $this->v_08_validation->CurrentValue;

            // v_09
            $this->v_09->ViewValue = $this->v_09->CurrentValue;

            // v_09_validation
            $this->v_09_validation->ViewValue = $this->v_09_validation->CurrentValue;

            // v_10
            $this->v_10->ViewValue = $this->v_10->CurrentValue;

            // v_10_validation
            $this->v_10_validation->ViewValue = $this->v_10_validation->CurrentValue;

            // b_01_head
            $this->b_01_head->ViewValue = $this->b_01_head->CurrentValue;

            // b_02_head
            $this->b_02_head->ViewValue = $this->b_02_head->CurrentValue;

            // b_03_head
            $this->b_03_head->ViewValue = $this->b_03_head->CurrentValue;

            // b_04_head
            $this->b_04_head->ViewValue = $this->b_04_head->CurrentValue;

            // b_05_head
            $this->b_05_head->ViewValue = $this->b_05_head->CurrentValue;

            // b_06_head
            $this->b_06_head->ViewValue = $this->b_06_head->CurrentValue;

            // b_07_head
            $this->b_07_head->ViewValue = $this->b_07_head->CurrentValue;

            // b_08_head
            $this->b_08_head->ViewValue = $this->b_08_head->CurrentValue;

            // b_09_head
            $this->b_09_head->ViewValue = $this->b_09_head->CurrentValue;

            // b_10_head
            $this->b_10_head->ViewValue = $this->b_10_head->CurrentValue;

            // b_11_head
            $this->b_11_head->ViewValue = $this->b_11_head->CurrentValue;

            // b_12_head
            $this->b_12_head->ViewValue = $this->b_12_head->CurrentValue;

            // b_13_head
            $this->b_13_head->ViewValue = $this->b_13_head->CurrentValue;

            // b_14_head
            $this->b_14_head->ViewValue = $this->b_14_head->CurrentValue;

            // b_15_head
            $this->b_15_head->ViewValue = $this->b_15_head->CurrentValue;

            // q_sku
            $this->q_sku->ViewValue = $this->q_sku->CurrentValue;

            // t_01_head
            $this->t_01_head->ViewValue = $this->t_01_head->CurrentValue;

            // t_02_head
            $this->t_02_head->ViewValue = $this->t_02_head->CurrentValue;

            // t_03_head
            $this->t_03_head->ViewValue = $this->t_03_head->CurrentValue;

            // t_04_head
            $this->t_04_head->ViewValue = $this->t_04_head->CurrentValue;

            // t_05_head
            $this->t_05_head->ViewValue = $this->t_05_head->CurrentValue;

            // t_06_head
            $this->t_06_head->ViewValue = $this->t_06_head->CurrentValue;

            // t_07_head
            $this->t_07_head->ViewValue = $this->t_07_head->CurrentValue;

            // t_08_head
            $this->t_08_head->ViewValue = $this->t_08_head->CurrentValue;

            // t_09_head
            $this->t_09_head->ViewValue = $this->t_09_head->CurrentValue;

            // t_10_head
            $this->t_10_head->ViewValue = $this->t_10_head->CurrentValue;

            // t_11_head
            $this->t_11_head->ViewValue = $this->t_11_head->CurrentValue;

            // t_12_head
            $this->t_12_head->ViewValue = $this->t_12_head->CurrentValue;

            // t_13_head
            $this->t_13_head->ViewValue = $this->t_13_head->CurrentValue;

            // t_14_head
            $this->t_14_head->ViewValue = $this->t_14_head->CurrentValue;

            // t_15_head
            $this->t_15_head->ViewValue = $this->t_15_head->CurrentValue;

            // po_01_head
            $this->po_01_head->ViewValue = $this->po_01_head->CurrentValue;

            // po_02_head
            $this->po_02_head->ViewValue = $this->po_02_head->CurrentValue;

            // po_03_head
            $this->po_03_head->ViewValue = $this->po_03_head->CurrentValue;

            // po_04_head
            $this->po_04_head->ViewValue = $this->po_04_head->CurrentValue;

            // po_05_head
            $this->po_05_head->ViewValue = $this->po_05_head->CurrentValue;

            // po_06_head
            $this->po_06_head->ViewValue = $this->po_06_head->CurrentValue;

            // po_07_head
            $this->po_07_head->ViewValue = $this->po_07_head->CurrentValue;

            // po_08_head
            $this->po_08_head->ViewValue = $this->po_08_head->CurrentValue;

            // po_17_head
            $this->po_17_head->ViewValue = $this->po_17_head->CurrentValue;

            // po_18_head
            $this->po_18_head->ViewValue = $this->po_18_head->CurrentValue;

            // po_19_head
            $this->po_19_head->ViewValue = $this->po_19_head->CurrentValue;

            // po_20_head
            $this->po_20_head->ViewValue = $this->po_20_head->CurrentValue;

            // jc_01_head
            $this->jc_01_head->ViewValue = $this->jc_01_head->CurrentValue;

            // jc_02_head
            $this->jc_02_head->ViewValue = $this->jc_02_head->CurrentValue;

            // jc_03_head
            $this->jc_03_head->ViewValue = $this->jc_03_head->CurrentValue;

            // jc_04_head
            $this->jc_04_head->ViewValue = $this->jc_04_head->CurrentValue;

            // jc_05_head
            $this->jc_05_head->ViewValue = $this->jc_05_head->CurrentValue;

            // jc_06_head
            $this->jc_06_head->ViewValue = $this->jc_06_head->CurrentValue;

            // jc_07_head
            $this->jc_07_head->ViewValue = $this->jc_07_head->CurrentValue;

            // jc_08_head
            $this->jc_08_head->ViewValue = $this->jc_08_head->CurrentValue;

            // jc_09_head
            $this->jc_09_head->ViewValue = $this->jc_09_head->CurrentValue;

            // jc_10_head
            $this->jc_10_head->ViewValue = $this->jc_10_head->CurrentValue;

            // pc_shape
            $this->pc_shape->ViewValue = $this->pc_shape->CurrentValue;

            // pc_unit
            $this->pc_unit->ViewValue = $this->pc_unit->CurrentValue;

            // pc_w
            $this->pc_w->ViewValue = $this->pc_w->CurrentValue;

            // pc_l
            $this->pc_l->ViewValue = $this->pc_l->CurrentValue;

            // pc_h
            $this->pc_h->ViewValue = $this->pc_h->CurrentValue;

            // pc_partner_size
            $this->pc_partner_size->ViewValue = $this->pc_partner_size->CurrentValue;

            // pc_sqm
            $this->pc_sqm->ViewValue = $this->pc_sqm->CurrentValue;

            // pc_01_head
            $this->pc_01_head->ViewValue = $this->pc_01_head->CurrentValue;

            // pc_02_head
            $this->pc_02_head->ViewValue = $this->pc_02_head->CurrentValue;

            // pc_03_head
            $this->pc_03_head->ViewValue = $this->pc_03_head->CurrentValue;

            // pc_04_head
            $this->pc_04_head->ViewValue = $this->pc_04_head->CurrentValue;

            // pc_05_head
            $this->pc_05_head->ViewValue = $this->pc_05_head->CurrentValue;

            // pc_06_head
            $this->pc_06_head->ViewValue = $this->pc_06_head->CurrentValue;

            // pc_07_head
            $this->pc_07_head->ViewValue = $this->pc_07_head->CurrentValue;

            // pc_08_head
            $this->pc_08_head->ViewValue = $this->pc_08_head->CurrentValue;

            // pc_09_head
            $this->pc_09_head->ViewValue = $this->pc_09_head->CurrentValue;

            // pc_10_head
            $this->pc_10_head->ViewValue = $this->pc_10_head->CurrentValue;

            // pc_11_head
            $this->pc_11_head->ViewValue = $this->pc_11_head->CurrentValue;

            // pc_12_head
            $this->pc_12_head->ViewValue = $this->pc_12_head->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ImageWidth = 0;
                $this->image->ImageHeight = 50;
                $this->image->ImageAlt = $this->image->alt();
                $this->image->ImageCssClass = "ew-image";
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // pa_process_size_w
            $this->pa_process_size_w->ViewValue = $this->pa_process_size_w->CurrentValue;

            // pa_process_size_l
            $this->pa_process_size_l->ViewValue = $this->pa_process_size_l->CurrentValue;

            // pa_head_01
            $this->pa_head_01->ViewValue = $this->pa_head_01->CurrentValue;

            // pa_process_01
            $curVal = strval($this->pa_process_01->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_01->ViewValue = $this->pa_process_01->lookupCacheOption($curVal);
                if ($this->pa_process_01->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_01->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_01->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_01->Lookup->renderViewRow($row);
                            $this->pa_process_01->ViewValue->add($this->pa_process_01->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_01->ViewValue = $this->pa_process_01->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_01->ViewValue = null;
            }

            // pa_head_02
            $this->pa_head_02->ViewValue = $this->pa_head_02->CurrentValue;

            // pa_process_02
            $curVal = strval($this->pa_process_02->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_02->ViewValue = $this->pa_process_02->lookupCacheOption($curVal);
                if ($this->pa_process_02->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_02->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_02->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_02->Lookup->renderViewRow($row);
                            $this->pa_process_02->ViewValue->add($this->pa_process_02->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_02->ViewValue = $this->pa_process_02->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_02->ViewValue = null;
            }

            // pa_head_03
            $this->pa_head_03->ViewValue = $this->pa_head_03->CurrentValue;

            // pa_process_03
            $curVal = strval($this->pa_process_03->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_03->ViewValue = $this->pa_process_03->lookupCacheOption($curVal);
                if ($this->pa_process_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_03->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_03->Lookup->renderViewRow($row);
                            $this->pa_process_03->ViewValue->add($this->pa_process_03->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_03->ViewValue = $this->pa_process_03->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_03->ViewValue = null;
            }

            // pa_head_04
            $this->pa_head_04->ViewValue = $this->pa_head_04->CurrentValue;

            // pa_process_04
            $curVal = strval($this->pa_process_04->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_04->ViewValue = $this->pa_process_04->lookupCacheOption($curVal);
                if ($this->pa_process_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_04->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_04->Lookup->renderViewRow($row);
                            $this->pa_process_04->ViewValue->add($this->pa_process_04->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_04->ViewValue = $this->pa_process_04->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_04->ViewValue = null;
            }

            // pa_head_05
            $this->pa_head_05->ViewValue = $this->pa_head_05->CurrentValue;

            // pa_process_05
            $curVal = strval($this->pa_process_05->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_05->ViewValue = $this->pa_process_05->lookupCacheOption($curVal);
                if ($this->pa_process_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_05->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_05->Lookup->renderViewRow($row);
                            $this->pa_process_05->ViewValue->add($this->pa_process_05->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_05->ViewValue = $this->pa_process_05->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_05->ViewValue = null;
            }

            // pa_head_06
            $this->pa_head_06->ViewValue = $this->pa_head_06->CurrentValue;

            // pa_process_06
            $curVal = strval($this->pa_process_06->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_06->ViewValue = $this->pa_process_06->lookupCacheOption($curVal);
                if ($this->pa_process_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_06->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_06->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_06->Lookup->renderViewRow($row);
                            $this->pa_process_06->ViewValue->add($this->pa_process_06->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_06->ViewValue = $this->pa_process_06->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_06->ViewValue = null;
            }

            // pa_head_07
            $this->pa_head_07->ViewValue = $this->pa_head_07->CurrentValue;

            // pa_process_07
            $curVal = strval($this->pa_process_07->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_07->ViewValue = $this->pa_process_07->lookupCacheOption($curVal);
                if ($this->pa_process_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_07->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_07->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_07->Lookup->renderViewRow($row);
                            $this->pa_process_07->ViewValue->add($this->pa_process_07->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_07->ViewValue = $this->pa_process_07->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_07->ViewValue = null;
            }

            // pa_head_08
            $this->pa_head_08->ViewValue = $this->pa_head_08->CurrentValue;

            // pa_process_08
            $curVal = strval($this->pa_process_08->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_08->ViewValue = $this->pa_process_08->lookupCacheOption($curVal);
                if ($this->pa_process_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_08->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_08->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_08->Lookup->renderViewRow($row);
                            $this->pa_process_08->ViewValue->add($this->pa_process_08->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_08->ViewValue = $this->pa_process_08->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_08->ViewValue = null;
            }

            // pa_head_09
            $this->pa_head_09->ViewValue = $this->pa_head_09->CurrentValue;

            // pa_process_09
            $curVal = strval($this->pa_process_09->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_09->ViewValue = $this->pa_process_09->lookupCacheOption($curVal);
                if ($this->pa_process_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_09->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_09->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_09->Lookup->renderViewRow($row);
                            $this->pa_process_09->ViewValue->add($this->pa_process_09->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_09->ViewValue = $this->pa_process_09->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_09->ViewValue = null;
            }

            // pa_head_10
            $this->pa_head_10->ViewValue = $this->pa_head_10->CurrentValue;

            // pa_process_10
            $curVal = strval($this->pa_process_10->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_10->ViewValue = $this->pa_process_10->lookupCacheOption($curVal);
                if ($this->pa_process_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_10->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_10->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_10->Lookup->renderViewRow($row);
                            $this->pa_process_10->ViewValue->add($this->pa_process_10->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_10->ViewValue = $this->pa_process_10->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_10->ViewValue = null;
            }

            // publish
            $this->publish->ViewValue = $this->publish->CurrentValue;
            $this->publish->ViewValue = FormatNumber($this->publish->ViewValue, $this->publish->formatPattern());

            // ppr_01
            $this->ppr_01->ViewValue = $this->ppr_01->CurrentValue;

            // ppr_02
            $this->ppr_02->ViewValue = $this->ppr_02->CurrentValue;

            // ppr_03
            $this->ppr_03->ViewValue = $this->ppr_03->CurrentValue;

            // ppr_04
            $this->ppr_04->ViewValue = $this->ppr_04->CurrentValue;

            // ppr_05
            $this->ppr_05->ViewValue = $this->ppr_05->CurrentValue;

            // ppr_06
            $this->ppr_06->ViewValue = $this->ppr_06->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // product_group
            $this->product_group->HrefValue = "";
            $this->product_group->TooltipValue = "";

            // calculation_method
            $this->calculation_method->HrefValue = "";
            $this->calculation_method->TooltipValue = "";

            // shape
            $this->shape->HrefValue = "";
            $this->shape->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";

            // process
            $this->process->HrefValue = "";
            $this->process->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // v_00
            $this->v_00->HrefValue = "";
            $this->v_00->TooltipValue = "";

            // v_01
            $this->v_01->HrefValue = "";
            $this->v_01->TooltipValue = "";

            // v_01_validation
            $this->v_01_validation->HrefValue = "";
            $this->v_01_validation->TooltipValue = "";

            // v_02
            $this->v_02->HrefValue = "";
            $this->v_02->TooltipValue = "";

            // v_02_validation
            $this->v_02_validation->HrefValue = "";
            $this->v_02_validation->TooltipValue = "";

            // v_03
            $this->v_03->HrefValue = "";
            $this->v_03->TooltipValue = "";

            // v_03_validation
            $this->v_03_validation->HrefValue = "";
            $this->v_03_validation->TooltipValue = "";

            // v_04
            $this->v_04->HrefValue = "";
            $this->v_04->TooltipValue = "";

            // v_04_validation
            $this->v_04_validation->HrefValue = "";
            $this->v_04_validation->TooltipValue = "";

            // v_05
            $this->v_05->HrefValue = "";
            $this->v_05->TooltipValue = "";

            // v_05_validation
            $this->v_05_validation->HrefValue = "";
            $this->v_05_validation->TooltipValue = "";

            // v_06
            $this->v_06->HrefValue = "";
            $this->v_06->TooltipValue = "";

            // v_06_validation
            $this->v_06_validation->HrefValue = "";
            $this->v_06_validation->TooltipValue = "";

            // v_07
            $this->v_07->HrefValue = "";
            $this->v_07->TooltipValue = "";

            // v_07_validation
            $this->v_07_validation->HrefValue = "";
            $this->v_07_validation->TooltipValue = "";

            // v_08
            $this->v_08->HrefValue = "";
            $this->v_08->TooltipValue = "";

            // v_08_validation
            $this->v_08_validation->HrefValue = "";
            $this->v_08_validation->TooltipValue = "";

            // v_09
            $this->v_09->HrefValue = "";
            $this->v_09->TooltipValue = "";

            // v_09_validation
            $this->v_09_validation->HrefValue = "";
            $this->v_09_validation->TooltipValue = "";

            // v_10
            $this->v_10->HrefValue = "";
            $this->v_10->TooltipValue = "";

            // v_10_validation
            $this->v_10_validation->HrefValue = "";
            $this->v_10_validation->TooltipValue = "";

            // b_01_head
            $this->b_01_head->HrefValue = "";
            $this->b_01_head->TooltipValue = "";

            // b_02_head
            $this->b_02_head->HrefValue = "";
            $this->b_02_head->TooltipValue = "";

            // b_03_head
            $this->b_03_head->HrefValue = "";
            $this->b_03_head->TooltipValue = "";

            // b_04_head
            $this->b_04_head->HrefValue = "";
            $this->b_04_head->TooltipValue = "";

            // b_05_head
            $this->b_05_head->HrefValue = "";
            $this->b_05_head->TooltipValue = "";

            // b_06_head
            $this->b_06_head->HrefValue = "";
            $this->b_06_head->TooltipValue = "";

            // b_07_head
            $this->b_07_head->HrefValue = "";
            $this->b_07_head->TooltipValue = "";

            // b_08_head
            $this->b_08_head->HrefValue = "";
            $this->b_08_head->TooltipValue = "";

            // b_09_head
            $this->b_09_head->HrefValue = "";
            $this->b_09_head->TooltipValue = "";

            // b_10_head
            $this->b_10_head->HrefValue = "";
            $this->b_10_head->TooltipValue = "";

            // b_11_head
            $this->b_11_head->HrefValue = "";
            $this->b_11_head->TooltipValue = "";

            // b_12_head
            $this->b_12_head->HrefValue = "";
            $this->b_12_head->TooltipValue = "";

            // b_13_head
            $this->b_13_head->HrefValue = "";
            $this->b_13_head->TooltipValue = "";

            // b_14_head
            $this->b_14_head->HrefValue = "";
            $this->b_14_head->TooltipValue = "";

            // b_15_head
            $this->b_15_head->HrefValue = "";
            $this->b_15_head->TooltipValue = "";

            // q_sku
            $this->q_sku->HrefValue = "";
            $this->q_sku->TooltipValue = "";

            // t_01_head
            $this->t_01_head->HrefValue = "";
            $this->t_01_head->TooltipValue = "";

            // t_02_head
            $this->t_02_head->HrefValue = "";
            $this->t_02_head->TooltipValue = "";

            // t_03_head
            $this->t_03_head->HrefValue = "";
            $this->t_03_head->TooltipValue = "";

            // t_04_head
            $this->t_04_head->HrefValue = "";
            $this->t_04_head->TooltipValue = "";

            // t_05_head
            $this->t_05_head->HrefValue = "";
            $this->t_05_head->TooltipValue = "";

            // t_06_head
            $this->t_06_head->HrefValue = "";
            $this->t_06_head->TooltipValue = "";

            // t_07_head
            $this->t_07_head->HrefValue = "";
            $this->t_07_head->TooltipValue = "";

            // t_08_head
            $this->t_08_head->HrefValue = "";
            $this->t_08_head->TooltipValue = "";

            // t_09_head
            $this->t_09_head->HrefValue = "";
            $this->t_09_head->TooltipValue = "";

            // t_10_head
            $this->t_10_head->HrefValue = "";
            $this->t_10_head->TooltipValue = "";

            // t_11_head
            $this->t_11_head->HrefValue = "";
            $this->t_11_head->TooltipValue = "";

            // t_12_head
            $this->t_12_head->HrefValue = "";
            $this->t_12_head->TooltipValue = "";

            // t_13_head
            $this->t_13_head->HrefValue = "";
            $this->t_13_head->TooltipValue = "";

            // t_14_head
            $this->t_14_head->HrefValue = "";
            $this->t_14_head->TooltipValue = "";

            // t_15_head
            $this->t_15_head->HrefValue = "";
            $this->t_15_head->TooltipValue = "";

            // po_01_head
            $this->po_01_head->HrefValue = "";
            $this->po_01_head->TooltipValue = "";

            // po_02_head
            $this->po_02_head->HrefValue = "";
            $this->po_02_head->TooltipValue = "";

            // po_03_head
            $this->po_03_head->HrefValue = "";
            $this->po_03_head->TooltipValue = "";

            // po_04_head
            $this->po_04_head->HrefValue = "";
            $this->po_04_head->TooltipValue = "";

            // po_05_head
            $this->po_05_head->HrefValue = "";
            $this->po_05_head->TooltipValue = "";

            // po_06_head
            $this->po_06_head->HrefValue = "";
            $this->po_06_head->TooltipValue = "";

            // po_07_head
            $this->po_07_head->HrefValue = "";
            $this->po_07_head->TooltipValue = "";

            // po_08_head
            $this->po_08_head->HrefValue = "";
            $this->po_08_head->TooltipValue = "";

            // po_17_head
            $this->po_17_head->HrefValue = "";
            $this->po_17_head->TooltipValue = "";

            // po_18_head
            $this->po_18_head->HrefValue = "";
            $this->po_18_head->TooltipValue = "";

            // po_19_head
            $this->po_19_head->HrefValue = "";
            $this->po_19_head->TooltipValue = "";

            // po_20_head
            $this->po_20_head->HrefValue = "";
            $this->po_20_head->TooltipValue = "";

            // jc_01_head
            $this->jc_01_head->HrefValue = "";
            $this->jc_01_head->TooltipValue = "";

            // jc_02_head
            $this->jc_02_head->HrefValue = "";
            $this->jc_02_head->TooltipValue = "";

            // jc_03_head
            $this->jc_03_head->HrefValue = "";
            $this->jc_03_head->TooltipValue = "";

            // jc_04_head
            $this->jc_04_head->HrefValue = "";
            $this->jc_04_head->TooltipValue = "";

            // jc_05_head
            $this->jc_05_head->HrefValue = "";
            $this->jc_05_head->TooltipValue = "";

            // jc_06_head
            $this->jc_06_head->HrefValue = "";
            $this->jc_06_head->TooltipValue = "";

            // jc_07_head
            $this->jc_07_head->HrefValue = "";
            $this->jc_07_head->TooltipValue = "";

            // jc_08_head
            $this->jc_08_head->HrefValue = "";
            $this->jc_08_head->TooltipValue = "";

            // jc_09_head
            $this->jc_09_head->HrefValue = "";
            $this->jc_09_head->TooltipValue = "";

            // jc_10_head
            $this->jc_10_head->HrefValue = "";
            $this->jc_10_head->TooltipValue = "";

            // pc_shape
            $this->pc_shape->HrefValue = "";
            $this->pc_shape->TooltipValue = "";

            // pc_unit
            $this->pc_unit->HrefValue = "";
            $this->pc_unit->TooltipValue = "";

            // pc_w
            $this->pc_w->HrefValue = "";
            $this->pc_w->TooltipValue = "";

            // pc_l
            $this->pc_l->HrefValue = "";
            $this->pc_l->TooltipValue = "";

            // pc_h
            $this->pc_h->HrefValue = "";
            $this->pc_h->TooltipValue = "";

            // pc_partner_size
            $this->pc_partner_size->HrefValue = "";
            $this->pc_partner_size->TooltipValue = "";

            // pc_sqm
            $this->pc_sqm->HrefValue = "";
            $this->pc_sqm->TooltipValue = "";

            // pc_01_head
            $this->pc_01_head->HrefValue = "";
            $this->pc_01_head->TooltipValue = "";

            // pc_02_head
            $this->pc_02_head->HrefValue = "";
            $this->pc_02_head->TooltipValue = "";

            // pc_03_head
            $this->pc_03_head->HrefValue = "";
            $this->pc_03_head->TooltipValue = "";

            // pc_04_head
            $this->pc_04_head->HrefValue = "";
            $this->pc_04_head->TooltipValue = "";

            // pc_05_head
            $this->pc_05_head->HrefValue = "";
            $this->pc_05_head->TooltipValue = "";

            // pc_06_head
            $this->pc_06_head->HrefValue = "";
            $this->pc_06_head->TooltipValue = "";

            // pc_07_head
            $this->pc_07_head->HrefValue = "";
            $this->pc_07_head->TooltipValue = "";

            // pc_08_head
            $this->pc_08_head->HrefValue = "";
            $this->pc_08_head->TooltipValue = "";

            // pc_09_head
            $this->pc_09_head->HrefValue = "";
            $this->pc_09_head->TooltipValue = "";

            // pc_10_head
            $this->pc_10_head->HrefValue = "";
            $this->pc_10_head->TooltipValue = "";

            // pc_11_head
            $this->pc_11_head->HrefValue = "";
            $this->pc_11_head->TooltipValue = "";

            // pc_12_head
            $this->pc_12_head->HrefValue = "";
            $this->pc_12_head->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->htmlDecode($this->image->Upload->DbValue)); // Add prefix/suffix
                $this->image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
                }
            } else {
                $this->image->HrefValue = "";
            }
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
            $this->image->TooltipValue = "";
            if ($this->image->UseColorbox) {
                if (EmptyValue($this->image->TooltipValue)) {
                    $this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->image->LinkAttrs["data-rel"] = "product_group_x_image";
                $this->image->LinkAttrs->appendClass("ew-lightbox");
            }

            // pa_process_size_w
            $this->pa_process_size_w->HrefValue = "";
            $this->pa_process_size_w->TooltipValue = "";

            // pa_process_size_l
            $this->pa_process_size_l->HrefValue = "";
            $this->pa_process_size_l->TooltipValue = "";

            // pa_head_01
            $this->pa_head_01->HrefValue = "";
            $this->pa_head_01->TooltipValue = "";

            // pa_process_01
            $this->pa_process_01->HrefValue = "";
            $this->pa_process_01->TooltipValue = "";

            // pa_head_02
            $this->pa_head_02->HrefValue = "";
            $this->pa_head_02->TooltipValue = "";

            // pa_process_02
            $this->pa_process_02->HrefValue = "";
            $this->pa_process_02->TooltipValue = "";

            // pa_head_03
            $this->pa_head_03->HrefValue = "";
            $this->pa_head_03->TooltipValue = "";

            // pa_process_03
            $this->pa_process_03->HrefValue = "";
            $this->pa_process_03->TooltipValue = "";

            // pa_head_04
            $this->pa_head_04->HrefValue = "";
            $this->pa_head_04->TooltipValue = "";

            // pa_process_04
            $this->pa_process_04->HrefValue = "";
            $this->pa_process_04->TooltipValue = "";

            // pa_head_05
            $this->pa_head_05->HrefValue = "";
            $this->pa_head_05->TooltipValue = "";

            // pa_process_05
            $this->pa_process_05->HrefValue = "";
            $this->pa_process_05->TooltipValue = "";

            // pa_head_06
            $this->pa_head_06->HrefValue = "";
            $this->pa_head_06->TooltipValue = "";

            // pa_process_06
            $this->pa_process_06->HrefValue = "";
            $this->pa_process_06->TooltipValue = "";

            // pa_head_07
            $this->pa_head_07->HrefValue = "";
            $this->pa_head_07->TooltipValue = "";

            // pa_process_07
            $this->pa_process_07->HrefValue = "";
            $this->pa_process_07->TooltipValue = "";

            // pa_head_08
            $this->pa_head_08->HrefValue = "";
            $this->pa_head_08->TooltipValue = "";

            // pa_process_08
            $this->pa_process_08->HrefValue = "";
            $this->pa_process_08->TooltipValue = "";

            // pa_head_09
            $this->pa_head_09->HrefValue = "";
            $this->pa_head_09->TooltipValue = "";

            // pa_process_09
            $this->pa_process_09->HrefValue = "";
            $this->pa_process_09->TooltipValue = "";

            // pa_head_10
            $this->pa_head_10->HrefValue = "";
            $this->pa_head_10->TooltipValue = "";

            // pa_process_10
            $this->pa_process_10->HrefValue = "";
            $this->pa_process_10->TooltipValue = "";

            // publish
            $this->publish->HrefValue = "";
            $this->publish->TooltipValue = "";

            // ppr_01
            $this->ppr_01->HrefValue = "";
            $this->ppr_01->TooltipValue = "";

            // ppr_02
            $this->ppr_02->HrefValue = "";
            $this->ppr_02->TooltipValue = "";

            // ppr_03
            $this->ppr_03->HrefValue = "";
            $this->ppr_03->TooltipValue = "";

            // ppr_04
            $this->ppr_04->HrefValue = "";
            $this->ppr_04->TooltipValue = "";

            // ppr_05
            $this->ppr_05->HrefValue = "";
            $this->ppr_05->TooltipValue = "";

            // ppr_06
            $this->ppr_06->HrefValue = "";
            $this->ppr_06->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("productgrouplist"), "", $this->TableVar, true);
        $pageId = "view";
        $Breadcrumb->add("view", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "tabs";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $pages->add(6);
        $pages->add(7);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_calculation_method":
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_v_01_validation":
                    break;
                case "x_pa_process_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }
}
