<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductGroupSearch extends ProductGroup
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductGroupSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "productgroupsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->grp->setVisibility();
        $this->product_group->setVisibility();
        $this->calculation_method->setVisibility();
        $this->shape->setVisibility();
        $this->sqm->setVisibility();
        $this->cbm->setVisibility();
        $this->process->setVisibility();
        $this->status->setVisibility();
        $this->v_00->setVisibility();
        $this->v_01->setVisibility();
        $this->v_01_validation->setVisibility();
        $this->v_02->setVisibility();
        $this->v_02_validation->setVisibility();
        $this->v_03->setVisibility();
        $this->v_03_validation->setVisibility();
        $this->v_04->setVisibility();
        $this->v_04_validation->setVisibility();
        $this->v_05->setVisibility();
        $this->v_05_validation->setVisibility();
        $this->v_06->setVisibility();
        $this->v_06_validation->setVisibility();
        $this->v_07->setVisibility();
        $this->v_07_validation->setVisibility();
        $this->v_08->setVisibility();
        $this->v_08_validation->setVisibility();
        $this->v_09->setVisibility();
        $this->v_09_validation->setVisibility();
        $this->v_10->setVisibility();
        $this->v_10_validation->setVisibility();
        $this->b_01_head->setVisibility();
        $this->b_02_head->setVisibility();
        $this->b_03_head->setVisibility();
        $this->b_04_head->setVisibility();
        $this->b_05_head->setVisibility();
        $this->b_06_head->setVisibility();
        $this->b_07_head->setVisibility();
        $this->b_08_head->setVisibility();
        $this->b_09_head->setVisibility();
        $this->b_10_head->setVisibility();
        $this->b_11_head->setVisibility();
        $this->b_12_head->setVisibility();
        $this->b_13_head->setVisibility();
        $this->b_14_head->setVisibility();
        $this->b_15_head->setVisibility();
        $this->q_sku->setVisibility();
        $this->t_01_head->setVisibility();
        $this->t_02_head->setVisibility();
        $this->t_03_head->setVisibility();
        $this->t_04_head->setVisibility();
        $this->t_05_head->setVisibility();
        $this->t_06_head->setVisibility();
        $this->t_07_head->setVisibility();
        $this->t_08_head->setVisibility();
        $this->t_09_head->setVisibility();
        $this->t_10_head->setVisibility();
        $this->t_11_head->setVisibility();
        $this->t_12_head->setVisibility();
        $this->t_13_head->setVisibility();
        $this->t_14_head->setVisibility();
        $this->t_15_head->setVisibility();
        $this->po_01_head->setVisibility();
        $this->po_02_head->setVisibility();
        $this->po_03_head->setVisibility();
        $this->po_04_head->setVisibility();
        $this->po_05_head->setVisibility();
        $this->po_06_head->setVisibility();
        $this->po_07_head->setVisibility();
        $this->po_08_head->setVisibility();
        $this->po_17_head->setVisibility();
        $this->po_18_head->setVisibility();
        $this->po_19_head->setVisibility();
        $this->po_20_head->setVisibility();
        $this->jc_01_head->setVisibility();
        $this->jc_02_head->setVisibility();
        $this->jc_03_head->setVisibility();
        $this->jc_04_head->setVisibility();
        $this->jc_05_head->setVisibility();
        $this->jc_06_head->setVisibility();
        $this->jc_07_head->setVisibility();
        $this->jc_08_head->setVisibility();
        $this->jc_09_head->setVisibility();
        $this->jc_10_head->setVisibility();
        $this->pc_shape->setVisibility();
        $this->pc_unit->setVisibility();
        $this->pc_w->setVisibility();
        $this->pc_l->setVisibility();
        $this->pc_h->setVisibility();
        $this->pc_partner_size->setVisibility();
        $this->pc_sqm->setVisibility();
        $this->pc_01_head->setVisibility();
        $this->pc_02_head->setVisibility();
        $this->pc_03_head->setVisibility();
        $this->pc_04_head->setVisibility();
        $this->pc_05_head->setVisibility();
        $this->pc_06_head->setVisibility();
        $this->pc_07_head->setVisibility();
        $this->pc_08_head->setVisibility();
        $this->pc_09_head->setVisibility();
        $this->pc_10_head->setVisibility();
        $this->pc_11_head->setVisibility();
        $this->pc_12_head->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->image->setVisibility();
        $this->pa_process_size_w->setVisibility();
        $this->pa_process_size_l->setVisibility();
        $this->pa_head_01->setVisibility();
        $this->pa_process_01->setVisibility();
        $this->pa_head_02->setVisibility();
        $this->pa_process_02->setVisibility();
        $this->pa_head_03->setVisibility();
        $this->pa_process_03->setVisibility();
        $this->pa_head_04->setVisibility();
        $this->pa_process_04->setVisibility();
        $this->pa_head_05->setVisibility();
        $this->pa_process_05->setVisibility();
        $this->pa_head_06->setVisibility();
        $this->pa_process_06->setVisibility();
        $this->pa_head_07->setVisibility();
        $this->pa_process_07->setVisibility();
        $this->pa_head_08->setVisibility();
        $this->pa_process_08->setVisibility();
        $this->pa_head_09->setVisibility();
        $this->pa_process_09->setVisibility();
        $this->pa_head_10->setVisibility();
        $this->pa_process_10->setVisibility();
        $this->publish->setVisibility();
        $this->ppr_01->setVisibility();
        $this->ppr_02->setVisibility();
        $this->ppr_03->setVisibility();
        $this->ppr_04->setVisibility();
        $this->ppr_05->setVisibility();
        $this->ppr_06->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'product_group';
        $this->TableName = 'product_group';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (product_group)
        if (!isset($GLOBALS["product_group"]) || $GLOBALS["product_group"]::class == PROJECT_NAMESPACE . "product_group") {
            $GLOBALS["product_group"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_group');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "productgroupview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->calculation_method);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->v_01_validation);
        $this->setupLookupOptions($this->pa_process_01);
        $this->setupLookupOptions($this->pa_process_02);
        $this->setupLookupOptions($this->pa_process_03);
        $this->setupLookupOptions($this->pa_process_04);
        $this->setupLookupOptions($this->pa_process_05);
        $this->setupLookupOptions($this->pa_process_06);
        $this->setupLookupOptions($this->pa_process_07);
        $this->setupLookupOptions($this->pa_process_08);
        $this->setupLookupOptions($this->pa_process_09);
        $this->setupLookupOptions($this->pa_process_10);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "productgrouplist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->product_group); // product_group
        $this->buildSearchUrl($srchUrl, $this->calculation_method); // calculation_method
        $this->buildSearchUrl($srchUrl, $this->shape); // shape
        $this->buildSearchUrl($srchUrl, $this->sqm); // sqm
        $this->buildSearchUrl($srchUrl, $this->cbm); // cbm
        $this->buildSearchUrl($srchUrl, $this->process); // process
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->v_00); // v_00
        $this->buildSearchUrl($srchUrl, $this->v_01); // v_01
        $this->buildSearchUrl($srchUrl, $this->v_01_validation); // v_01_validation
        $this->buildSearchUrl($srchUrl, $this->v_02); // v_02
        $this->buildSearchUrl($srchUrl, $this->v_02_validation); // v_02_validation
        $this->buildSearchUrl($srchUrl, $this->v_03); // v_03
        $this->buildSearchUrl($srchUrl, $this->v_03_validation); // v_03_validation
        $this->buildSearchUrl($srchUrl, $this->v_04); // v_04
        $this->buildSearchUrl($srchUrl, $this->v_04_validation); // v_04_validation
        $this->buildSearchUrl($srchUrl, $this->v_05); // v_05
        $this->buildSearchUrl($srchUrl, $this->v_05_validation); // v_05_validation
        $this->buildSearchUrl($srchUrl, $this->v_06); // v_06
        $this->buildSearchUrl($srchUrl, $this->v_06_validation); // v_06_validation
        $this->buildSearchUrl($srchUrl, $this->v_07); // v_07
        $this->buildSearchUrl($srchUrl, $this->v_07_validation); // v_07_validation
        $this->buildSearchUrl($srchUrl, $this->v_08); // v_08
        $this->buildSearchUrl($srchUrl, $this->v_08_validation); // v_08_validation
        $this->buildSearchUrl($srchUrl, $this->v_09); // v_09
        $this->buildSearchUrl($srchUrl, $this->v_09_validation); // v_09_validation
        $this->buildSearchUrl($srchUrl, $this->v_10); // v_10
        $this->buildSearchUrl($srchUrl, $this->v_10_validation); // v_10_validation
        $this->buildSearchUrl($srchUrl, $this->b_01_head); // b_01_head
        $this->buildSearchUrl($srchUrl, $this->b_02_head); // b_02_head
        $this->buildSearchUrl($srchUrl, $this->b_03_head); // b_03_head
        $this->buildSearchUrl($srchUrl, $this->b_04_head); // b_04_head
        $this->buildSearchUrl($srchUrl, $this->b_05_head); // b_05_head
        $this->buildSearchUrl($srchUrl, $this->b_06_head); // b_06_head
        $this->buildSearchUrl($srchUrl, $this->b_07_head); // b_07_head
        $this->buildSearchUrl($srchUrl, $this->b_08_head); // b_08_head
        $this->buildSearchUrl($srchUrl, $this->b_09_head); // b_09_head
        $this->buildSearchUrl($srchUrl, $this->b_10_head); // b_10_head
        $this->buildSearchUrl($srchUrl, $this->b_11_head); // b_11_head
        $this->buildSearchUrl($srchUrl, $this->b_12_head); // b_12_head
        $this->buildSearchUrl($srchUrl, $this->b_13_head); // b_13_head
        $this->buildSearchUrl($srchUrl, $this->b_14_head); // b_14_head
        $this->buildSearchUrl($srchUrl, $this->b_15_head); // b_15_head
        $this->buildSearchUrl($srchUrl, $this->q_sku); // q_sku
        $this->buildSearchUrl($srchUrl, $this->t_01_head); // t_01_head
        $this->buildSearchUrl($srchUrl, $this->t_02_head); // t_02_head
        $this->buildSearchUrl($srchUrl, $this->t_03_head); // t_03_head
        $this->buildSearchUrl($srchUrl, $this->t_04_head); // t_04_head
        $this->buildSearchUrl($srchUrl, $this->t_05_head); // t_05_head
        $this->buildSearchUrl($srchUrl, $this->t_06_head); // t_06_head
        $this->buildSearchUrl($srchUrl, $this->t_07_head); // t_07_head
        $this->buildSearchUrl($srchUrl, $this->t_08_head); // t_08_head
        $this->buildSearchUrl($srchUrl, $this->t_09_head); // t_09_head
        $this->buildSearchUrl($srchUrl, $this->t_10_head); // t_10_head
        $this->buildSearchUrl($srchUrl, $this->t_11_head); // t_11_head
        $this->buildSearchUrl($srchUrl, $this->t_12_head); // t_12_head
        $this->buildSearchUrl($srchUrl, $this->t_13_head); // t_13_head
        $this->buildSearchUrl($srchUrl, $this->t_14_head); // t_14_head
        $this->buildSearchUrl($srchUrl, $this->t_15_head); // t_15_head
        $this->buildSearchUrl($srchUrl, $this->po_01_head); // po_01_head
        $this->buildSearchUrl($srchUrl, $this->po_02_head); // po_02_head
        $this->buildSearchUrl($srchUrl, $this->po_03_head); // po_03_head
        $this->buildSearchUrl($srchUrl, $this->po_04_head); // po_04_head
        $this->buildSearchUrl($srchUrl, $this->po_05_head); // po_05_head
        $this->buildSearchUrl($srchUrl, $this->po_06_head); // po_06_head
        $this->buildSearchUrl($srchUrl, $this->po_07_head); // po_07_head
        $this->buildSearchUrl($srchUrl, $this->po_08_head); // po_08_head
        $this->buildSearchUrl($srchUrl, $this->po_17_head); // po_17_head
        $this->buildSearchUrl($srchUrl, $this->po_18_head); // po_18_head
        $this->buildSearchUrl($srchUrl, $this->po_19_head); // po_19_head
        $this->buildSearchUrl($srchUrl, $this->po_20_head); // po_20_head
        $this->buildSearchUrl($srchUrl, $this->jc_01_head); // jc_01_head
        $this->buildSearchUrl($srchUrl, $this->jc_02_head); // jc_02_head
        $this->buildSearchUrl($srchUrl, $this->jc_03_head); // jc_03_head
        $this->buildSearchUrl($srchUrl, $this->jc_04_head); // jc_04_head
        $this->buildSearchUrl($srchUrl, $this->jc_05_head); // jc_05_head
        $this->buildSearchUrl($srchUrl, $this->jc_06_head); // jc_06_head
        $this->buildSearchUrl($srchUrl, $this->jc_07_head); // jc_07_head
        $this->buildSearchUrl($srchUrl, $this->jc_08_head); // jc_08_head
        $this->buildSearchUrl($srchUrl, $this->jc_09_head); // jc_09_head
        $this->buildSearchUrl($srchUrl, $this->jc_10_head); // jc_10_head
        $this->buildSearchUrl($srchUrl, $this->pc_shape); // pc_shape
        $this->buildSearchUrl($srchUrl, $this->pc_unit); // pc_unit
        $this->buildSearchUrl($srchUrl, $this->pc_w); // pc_w
        $this->buildSearchUrl($srchUrl, $this->pc_l); // pc_l
        $this->buildSearchUrl($srchUrl, $this->pc_h); // pc_h
        $this->buildSearchUrl($srchUrl, $this->pc_partner_size); // pc_partner_size
        $this->buildSearchUrl($srchUrl, $this->pc_sqm); // pc_sqm
        $this->buildSearchUrl($srchUrl, $this->pc_01_head); // pc_01_head
        $this->buildSearchUrl($srchUrl, $this->pc_02_head); // pc_02_head
        $this->buildSearchUrl($srchUrl, $this->pc_03_head); // pc_03_head
        $this->buildSearchUrl($srchUrl, $this->pc_04_head); // pc_04_head
        $this->buildSearchUrl($srchUrl, $this->pc_05_head); // pc_05_head
        $this->buildSearchUrl($srchUrl, $this->pc_06_head); // pc_06_head
        $this->buildSearchUrl($srchUrl, $this->pc_07_head); // pc_07_head
        $this->buildSearchUrl($srchUrl, $this->pc_08_head); // pc_08_head
        $this->buildSearchUrl($srchUrl, $this->pc_09_head); // pc_09_head
        $this->buildSearchUrl($srchUrl, $this->pc_10_head); // pc_10_head
        $this->buildSearchUrl($srchUrl, $this->pc_11_head); // pc_11_head
        $this->buildSearchUrl($srchUrl, $this->pc_12_head); // pc_12_head
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->image); // image
        $this->buildSearchUrl($srchUrl, $this->pa_process_size_w); // pa_process_size_w
        $this->buildSearchUrl($srchUrl, $this->pa_process_size_l); // pa_process_size_l
        $this->buildSearchUrl($srchUrl, $this->pa_head_01); // pa_head_01
        $this->buildSearchUrl($srchUrl, $this->pa_process_01); // pa_process_01
        $this->buildSearchUrl($srchUrl, $this->pa_head_02); // pa_head_02
        $this->buildSearchUrl($srchUrl, $this->pa_process_02); // pa_process_02
        $this->buildSearchUrl($srchUrl, $this->pa_head_03); // pa_head_03
        $this->buildSearchUrl($srchUrl, $this->pa_process_03); // pa_process_03
        $this->buildSearchUrl($srchUrl, $this->pa_head_04); // pa_head_04
        $this->buildSearchUrl($srchUrl, $this->pa_process_04); // pa_process_04
        $this->buildSearchUrl($srchUrl, $this->pa_head_05); // pa_head_05
        $this->buildSearchUrl($srchUrl, $this->pa_process_05); // pa_process_05
        $this->buildSearchUrl($srchUrl, $this->pa_head_06); // pa_head_06
        $this->buildSearchUrl($srchUrl, $this->pa_process_06); // pa_process_06
        $this->buildSearchUrl($srchUrl, $this->pa_head_07); // pa_head_07
        $this->buildSearchUrl($srchUrl, $this->pa_process_07); // pa_process_07
        $this->buildSearchUrl($srchUrl, $this->pa_head_08); // pa_head_08
        $this->buildSearchUrl($srchUrl, $this->pa_process_08); // pa_process_08
        $this->buildSearchUrl($srchUrl, $this->pa_head_09); // pa_head_09
        $this->buildSearchUrl($srchUrl, $this->pa_process_09); // pa_process_09
        $this->buildSearchUrl($srchUrl, $this->pa_head_10); // pa_head_10
        $this->buildSearchUrl($srchUrl, $this->pa_process_10); // pa_process_10
        $this->buildSearchUrl($srchUrl, $this->publish); // publish
        $this->buildSearchUrl($srchUrl, $this->ppr_01); // ppr_01
        $this->buildSearchUrl($srchUrl, $this->ppr_02); // ppr_02
        $this->buildSearchUrl($srchUrl, $this->ppr_03); // ppr_03
        $this->buildSearchUrl($srchUrl, $this->ppr_04); // ppr_04
        $this->buildSearchUrl($srchUrl, $this->ppr_05); // ppr_05
        $this->buildSearchUrl($srchUrl, $this->ppr_06); // ppr_06
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product_group
        if ($this->product_group->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // calculation_method
        if ($this->calculation_method->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // shape
        if ($this->shape->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sqm
        if ($this->sqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cbm
        if ($this->cbm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // process
        if ($this->process->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_00
        if ($this->v_00->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_01
        if ($this->v_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_01_validation
        if ($this->v_01_validation->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_02
        if ($this->v_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_02_validation
        if ($this->v_02_validation->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_03
        if ($this->v_03->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_03_validation
        if ($this->v_03_validation->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_04
        if ($this->v_04->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_04_validation
        if ($this->v_04_validation->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_05
        if ($this->v_05->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_05_validation
        if ($this->v_05_validation->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_06
        if ($this->v_06->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_06_validation
        if ($this->v_06_validation->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_07
        if ($this->v_07->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_07_validation
        if ($this->v_07_validation->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_08
        if ($this->v_08->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_08_validation
        if ($this->v_08_validation->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_09
        if ($this->v_09->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_09_validation
        if ($this->v_09_validation->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_10
        if ($this->v_10->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_10_validation
        if ($this->v_10_validation->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_01_head
        if ($this->b_01_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_02_head
        if ($this->b_02_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_03_head
        if ($this->b_03_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_04_head
        if ($this->b_04_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_05_head
        if ($this->b_05_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_06_head
        if ($this->b_06_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_07_head
        if ($this->b_07_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_08_head
        if ($this->b_08_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_09_head
        if ($this->b_09_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_10_head
        if ($this->b_10_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_11_head
        if ($this->b_11_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_12_head
        if ($this->b_12_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_13_head
        if ($this->b_13_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_14_head
        if ($this->b_14_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_15_head
        if ($this->b_15_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // q_sku
        if ($this->q_sku->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_01_head
        if ($this->t_01_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_02_head
        if ($this->t_02_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_03_head
        if ($this->t_03_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_04_head
        if ($this->t_04_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_05_head
        if ($this->t_05_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_06_head
        if ($this->t_06_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_07_head
        if ($this->t_07_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_08_head
        if ($this->t_08_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_09_head
        if ($this->t_09_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_10_head
        if ($this->t_10_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_11_head
        if ($this->t_11_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_12_head
        if ($this->t_12_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_13_head
        if ($this->t_13_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_14_head
        if ($this->t_14_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_15_head
        if ($this->t_15_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_01_head
        if ($this->po_01_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_02_head
        if ($this->po_02_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_03_head
        if ($this->po_03_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_04_head
        if ($this->po_04_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_05_head
        if ($this->po_05_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_06_head
        if ($this->po_06_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_07_head
        if ($this->po_07_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_08_head
        if ($this->po_08_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_17_head
        if ($this->po_17_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_18_head
        if ($this->po_18_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_19_head
        if ($this->po_19_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_20_head
        if ($this->po_20_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // jc_01_head
        if ($this->jc_01_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // jc_02_head
        if ($this->jc_02_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // jc_03_head
        if ($this->jc_03_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // jc_04_head
        if ($this->jc_04_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // jc_05_head
        if ($this->jc_05_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // jc_06_head
        if ($this->jc_06_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // jc_07_head
        if ($this->jc_07_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // jc_08_head
        if ($this->jc_08_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // jc_09_head
        if ($this->jc_09_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // jc_10_head
        if ($this->jc_10_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_shape
        if ($this->pc_shape->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_unit
        if ($this->pc_unit->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_w
        if ($this->pc_w->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_l
        if ($this->pc_l->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_h
        if ($this->pc_h->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_partner_size
        if ($this->pc_partner_size->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_sqm
        if ($this->pc_sqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_01_head
        if ($this->pc_01_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_02_head
        if ($this->pc_02_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_03_head
        if ($this->pc_03_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_04_head
        if ($this->pc_04_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_05_head
        if ($this->pc_05_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_06_head
        if ($this->pc_06_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_07_head
        if ($this->pc_07_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_08_head
        if ($this->pc_08_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_09_head
        if ($this->pc_09_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_10_head
        if ($this->pc_10_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_11_head
        if ($this->pc_11_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_12_head
        if ($this->pc_12_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // image
        if ($this->image->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_process_size_w
        if ($this->pa_process_size_w->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_process_size_l
        if ($this->pa_process_size_l->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_head_01
        if ($this->pa_head_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_process_01
        if ($this->pa_process_01->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->pa_process_01->AdvancedSearch->SearchValue)) {
            $this->pa_process_01->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_01->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_01->AdvancedSearch->SearchValue2)) {
            $this->pa_process_01->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_01->AdvancedSearch->SearchValue2);
        }

        // pa_head_02
        if ($this->pa_head_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_process_02
        if ($this->pa_process_02->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->pa_process_02->AdvancedSearch->SearchValue)) {
            $this->pa_process_02->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_02->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_02->AdvancedSearch->SearchValue2)) {
            $this->pa_process_02->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_02->AdvancedSearch->SearchValue2);
        }

        // pa_head_03
        if ($this->pa_head_03->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_process_03
        if ($this->pa_process_03->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->pa_process_03->AdvancedSearch->SearchValue)) {
            $this->pa_process_03->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_03->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_03->AdvancedSearch->SearchValue2)) {
            $this->pa_process_03->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_03->AdvancedSearch->SearchValue2);
        }

        // pa_head_04
        if ($this->pa_head_04->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_process_04
        if ($this->pa_process_04->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->pa_process_04->AdvancedSearch->SearchValue)) {
            $this->pa_process_04->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_04->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_04->AdvancedSearch->SearchValue2)) {
            $this->pa_process_04->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_04->AdvancedSearch->SearchValue2);
        }

        // pa_head_05
        if ($this->pa_head_05->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_process_05
        if ($this->pa_process_05->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->pa_process_05->AdvancedSearch->SearchValue)) {
            $this->pa_process_05->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_05->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_05->AdvancedSearch->SearchValue2)) {
            $this->pa_process_05->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_05->AdvancedSearch->SearchValue2);
        }

        // pa_head_06
        if ($this->pa_head_06->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_process_06
        if ($this->pa_process_06->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->pa_process_06->AdvancedSearch->SearchValue)) {
            $this->pa_process_06->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_06->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_06->AdvancedSearch->SearchValue2)) {
            $this->pa_process_06->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_06->AdvancedSearch->SearchValue2);
        }

        // pa_head_07
        if ($this->pa_head_07->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_process_07
        if ($this->pa_process_07->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->pa_process_07->AdvancedSearch->SearchValue)) {
            $this->pa_process_07->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_07->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_07->AdvancedSearch->SearchValue2)) {
            $this->pa_process_07->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_07->AdvancedSearch->SearchValue2);
        }

        // pa_head_08
        if ($this->pa_head_08->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_process_08
        if ($this->pa_process_08->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->pa_process_08->AdvancedSearch->SearchValue)) {
            $this->pa_process_08->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_08->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_08->AdvancedSearch->SearchValue2)) {
            $this->pa_process_08->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_08->AdvancedSearch->SearchValue2);
        }

        // pa_head_09
        if ($this->pa_head_09->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_process_09
        if ($this->pa_process_09->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->pa_process_09->AdvancedSearch->SearchValue)) {
            $this->pa_process_09->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_09->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_09->AdvancedSearch->SearchValue2)) {
            $this->pa_process_09->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_09->AdvancedSearch->SearchValue2);
        }

        // pa_head_10
        if ($this->pa_head_10->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_process_10
        if ($this->pa_process_10->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->pa_process_10->AdvancedSearch->SearchValue)) {
            $this->pa_process_10->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_10->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_10->AdvancedSearch->SearchValue2)) {
            $this->pa_process_10->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_10->AdvancedSearch->SearchValue2);
        }

        // publish
        if ($this->publish->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ppr_01
        if ($this->ppr_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ppr_02
        if ($this->ppr_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ppr_03
        if ($this->ppr_03->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ppr_04
        if ($this->ppr_04->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ppr_05
        if ($this->ppr_05->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ppr_06
        if ($this->ppr_06->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // product_group
        $this->product_group->RowCssClass = "row";

        // calculation_method
        $this->calculation_method->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // v_00
        $this->v_00->RowCssClass = "row";

        // v_01
        $this->v_01->RowCssClass = "row";

        // v_01_validation
        $this->v_01_validation->RowCssClass = "row";

        // v_02
        $this->v_02->RowCssClass = "row";

        // v_02_validation
        $this->v_02_validation->RowCssClass = "row";

        // v_03
        $this->v_03->RowCssClass = "row";

        // v_03_validation
        $this->v_03_validation->RowCssClass = "row";

        // v_04
        $this->v_04->RowCssClass = "row";

        // v_04_validation
        $this->v_04_validation->RowCssClass = "row";

        // v_05
        $this->v_05->RowCssClass = "row";

        // v_05_validation
        $this->v_05_validation->RowCssClass = "row";

        // v_06
        $this->v_06->RowCssClass = "row";

        // v_06_validation
        $this->v_06_validation->RowCssClass = "row";

        // v_07
        $this->v_07->RowCssClass = "row";

        // v_07_validation
        $this->v_07_validation->RowCssClass = "row";

        // v_08
        $this->v_08->RowCssClass = "row";

        // v_08_validation
        $this->v_08_validation->RowCssClass = "row";

        // v_09
        $this->v_09->RowCssClass = "row";

        // v_09_validation
        $this->v_09_validation->RowCssClass = "row";

        // v_10
        $this->v_10->RowCssClass = "row";

        // v_10_validation
        $this->v_10_validation->RowCssClass = "row";

        // b_01_head
        $this->b_01_head->RowCssClass = "row";

        // b_02_head
        $this->b_02_head->RowCssClass = "row";

        // b_03_head
        $this->b_03_head->RowCssClass = "row";

        // b_04_head
        $this->b_04_head->RowCssClass = "row";

        // b_05_head
        $this->b_05_head->RowCssClass = "row";

        // b_06_head
        $this->b_06_head->RowCssClass = "row";

        // b_07_head
        $this->b_07_head->RowCssClass = "row";

        // b_08_head
        $this->b_08_head->RowCssClass = "row";

        // b_09_head
        $this->b_09_head->RowCssClass = "row";

        // b_10_head
        $this->b_10_head->RowCssClass = "row";

        // b_11_head
        $this->b_11_head->RowCssClass = "row";

        // b_12_head
        $this->b_12_head->RowCssClass = "row";

        // b_13_head
        $this->b_13_head->RowCssClass = "row";

        // b_14_head
        $this->b_14_head->RowCssClass = "row";

        // b_15_head
        $this->b_15_head->RowCssClass = "row";

        // q_sku
        $this->q_sku->RowCssClass = "row";

        // t_01_head
        $this->t_01_head->RowCssClass = "row";

        // t_02_head
        $this->t_02_head->RowCssClass = "row";

        // t_03_head
        $this->t_03_head->RowCssClass = "row";

        // t_04_head
        $this->t_04_head->RowCssClass = "row";

        // t_05_head
        $this->t_05_head->RowCssClass = "row";

        // t_06_head
        $this->t_06_head->RowCssClass = "row";

        // t_07_head
        $this->t_07_head->RowCssClass = "row";

        // t_08_head
        $this->t_08_head->RowCssClass = "row";

        // t_09_head
        $this->t_09_head->RowCssClass = "row";

        // t_10_head
        $this->t_10_head->RowCssClass = "row";

        // t_11_head
        $this->t_11_head->RowCssClass = "row";

        // t_12_head
        $this->t_12_head->RowCssClass = "row";

        // t_13_head
        $this->t_13_head->RowCssClass = "row";

        // t_14_head
        $this->t_14_head->RowCssClass = "row";

        // t_15_head
        $this->t_15_head->RowCssClass = "row";

        // po_01_head
        $this->po_01_head->RowCssClass = "row";

        // po_02_head
        $this->po_02_head->RowCssClass = "row";

        // po_03_head
        $this->po_03_head->RowCssClass = "row";

        // po_04_head
        $this->po_04_head->RowCssClass = "row";

        // po_05_head
        $this->po_05_head->RowCssClass = "row";

        // po_06_head
        $this->po_06_head->RowCssClass = "row";

        // po_07_head
        $this->po_07_head->RowCssClass = "row";

        // po_08_head
        $this->po_08_head->RowCssClass = "row";

        // po_17_head
        $this->po_17_head->RowCssClass = "row";

        // po_18_head
        $this->po_18_head->RowCssClass = "row";

        // po_19_head
        $this->po_19_head->RowCssClass = "row";

        // po_20_head
        $this->po_20_head->RowCssClass = "row";

        // jc_01_head
        $this->jc_01_head->RowCssClass = "row";

        // jc_02_head
        $this->jc_02_head->RowCssClass = "row";

        // jc_03_head
        $this->jc_03_head->RowCssClass = "row";

        // jc_04_head
        $this->jc_04_head->RowCssClass = "row";

        // jc_05_head
        $this->jc_05_head->RowCssClass = "row";

        // jc_06_head
        $this->jc_06_head->RowCssClass = "row";

        // jc_07_head
        $this->jc_07_head->RowCssClass = "row";

        // jc_08_head
        $this->jc_08_head->RowCssClass = "row";

        // jc_09_head
        $this->jc_09_head->RowCssClass = "row";

        // jc_10_head
        $this->jc_10_head->RowCssClass = "row";

        // pc_shape
        $this->pc_shape->RowCssClass = "row";

        // pc_unit
        $this->pc_unit->RowCssClass = "row";

        // pc_w
        $this->pc_w->RowCssClass = "row";

        // pc_l
        $this->pc_l->RowCssClass = "row";

        // pc_h
        $this->pc_h->RowCssClass = "row";

        // pc_partner_size
        $this->pc_partner_size->RowCssClass = "row";

        // pc_sqm
        $this->pc_sqm->RowCssClass = "row";

        // pc_01_head
        $this->pc_01_head->RowCssClass = "row";

        // pc_02_head
        $this->pc_02_head->RowCssClass = "row";

        // pc_03_head
        $this->pc_03_head->RowCssClass = "row";

        // pc_04_head
        $this->pc_04_head->RowCssClass = "row";

        // pc_05_head
        $this->pc_05_head->RowCssClass = "row";

        // pc_06_head
        $this->pc_06_head->RowCssClass = "row";

        // pc_07_head
        $this->pc_07_head->RowCssClass = "row";

        // pc_08_head
        $this->pc_08_head->RowCssClass = "row";

        // pc_09_head
        $this->pc_09_head->RowCssClass = "row";

        // pc_10_head
        $this->pc_10_head->RowCssClass = "row";

        // pc_11_head
        $this->pc_11_head->RowCssClass = "row";

        // pc_12_head
        $this->pc_12_head->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // pa_process_size_w
        $this->pa_process_size_w->RowCssClass = "row";

        // pa_process_size_l
        $this->pa_process_size_l->RowCssClass = "row";

        // pa_head_01
        $this->pa_head_01->RowCssClass = "row";

        // pa_process_01
        $this->pa_process_01->RowCssClass = "row";

        // pa_head_02
        $this->pa_head_02->RowCssClass = "row";

        // pa_process_02
        $this->pa_process_02->RowCssClass = "row";

        // pa_head_03
        $this->pa_head_03->RowCssClass = "row";

        // pa_process_03
        $this->pa_process_03->RowCssClass = "row";

        // pa_head_04
        $this->pa_head_04->RowCssClass = "row";

        // pa_process_04
        $this->pa_process_04->RowCssClass = "row";

        // pa_head_05
        $this->pa_head_05->RowCssClass = "row";

        // pa_process_05
        $this->pa_process_05->RowCssClass = "row";

        // pa_head_06
        $this->pa_head_06->RowCssClass = "row";

        // pa_process_06
        $this->pa_process_06->RowCssClass = "row";

        // pa_head_07
        $this->pa_head_07->RowCssClass = "row";

        // pa_process_07
        $this->pa_process_07->RowCssClass = "row";

        // pa_head_08
        $this->pa_head_08->RowCssClass = "row";

        // pa_process_08
        $this->pa_process_08->RowCssClass = "row";

        // pa_head_09
        $this->pa_head_09->RowCssClass = "row";

        // pa_process_09
        $this->pa_process_09->RowCssClass = "row";

        // pa_head_10
        $this->pa_head_10->RowCssClass = "row";

        // pa_process_10
        $this->pa_process_10->RowCssClass = "row";

        // publish
        $this->publish->RowCssClass = "row";

        // ppr_01
        $this->ppr_01->RowCssClass = "row";

        // ppr_02
        $this->ppr_02->RowCssClass = "row";

        // ppr_03
        $this->ppr_03->RowCssClass = "row";

        // ppr_04
        $this->ppr_04->RowCssClass = "row";

        // ppr_05
        $this->ppr_05->RowCssClass = "row";

        // ppr_06
        $this->ppr_06->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // product_group
            $this->product_group->ViewValue = $this->product_group->CurrentValue;

            // calculation_method
            $curVal = strval($this->calculation_method->CurrentValue);
            if ($curVal != "") {
                $this->calculation_method->ViewValue = $this->calculation_method->lookupCacheOption($curVal);
                if ($this->calculation_method->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->calculation_method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->calculation_method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->calculation_method->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->calculation_method->Lookup->renderViewRow($rswrk[0]);
                        $this->calculation_method->ViewValue = $this->calculation_method->displayValue($arwrk);
                    } else {
                        $this->calculation_method->ViewValue = FormatNumber($this->calculation_method->CurrentValue, $this->calculation_method->formatPattern());
                    }
                }
            } else {
                $this->calculation_method->ViewValue = null;
            }

            // shape
            $this->shape->ViewValue = $this->shape->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // v_00
            $this->v_00->ViewValue = $this->v_00->CurrentValue;

            // v_01
            $this->v_01->ViewValue = $this->v_01->CurrentValue;

            // v_01_validation
            $this->v_01_validation->ViewValue = $this->v_01_validation->CurrentValue;

            // v_02
            $this->v_02->ViewValue = $this->v_02->CurrentValue;

            // v_02_validation
            $this->v_02_validation->ViewValue = $this->v_02_validation->CurrentValue;

            // v_03
            $this->v_03->ViewValue = $this->v_03->CurrentValue;

            // v_03_validation
            $this->v_03_validation->ViewValue = $this->v_03_validation->CurrentValue;

            // v_04
            $this->v_04->ViewValue = $this->v_04->CurrentValue;

            // v_04_validation
            $this->v_04_validation->ViewValue = $this->v_04_validation->CurrentValue;

            // v_05
            $this->v_05->ViewValue = $this->v_05->CurrentValue;

            // v_05_validation
            $this->v_05_validation->ViewValue = $this->v_05_validation->CurrentValue;

            // v_06
            $this->v_06->ViewValue = $this->v_06->CurrentValue;

            // v_06_validation
            $this->v_06_validation->ViewValue = $this->v_06_validation->CurrentValue;

            // v_07
            $this->v_07->ViewValue = $this->v_07->CurrentValue;

            // v_07_validation
            $this->v_07_validation->ViewValue = $this->v_07_validation->CurrentValue;

            // v_08
            $this->v_08->ViewValue = $this->v_08->CurrentValue;

            // v_08_validation
            $this->v_08_validation->ViewValue = $this->v_08_validation->CurrentValue;

            // v_09
            $this->v_09->ViewValue = $this->v_09->CurrentValue;

            // v_09_validation
            $this->v_09_validation->ViewValue = $this->v_09_validation->CurrentValue;

            // v_10
            $this->v_10->ViewValue = $this->v_10->CurrentValue;

            // v_10_validation
            $this->v_10_validation->ViewValue = $this->v_10_validation->CurrentValue;

            // b_01_head
            $this->b_01_head->ViewValue = $this->b_01_head->CurrentValue;

            // b_02_head
            $this->b_02_head->ViewValue = $this->b_02_head->CurrentValue;

            // b_03_head
            $this->b_03_head->ViewValue = $this->b_03_head->CurrentValue;

            // b_04_head
            $this->b_04_head->ViewValue = $this->b_04_head->CurrentValue;

            // b_05_head
            $this->b_05_head->ViewValue = $this->b_05_head->CurrentValue;

            // b_06_head
            $this->b_06_head->ViewValue = $this->b_06_head->CurrentValue;

            // b_07_head
            $this->b_07_head->ViewValue = $this->b_07_head->CurrentValue;

            // b_08_head
            $this->b_08_head->ViewValue = $this->b_08_head->CurrentValue;

            // b_09_head
            $this->b_09_head->ViewValue = $this->b_09_head->CurrentValue;

            // b_10_head
            $this->b_10_head->ViewValue = $this->b_10_head->CurrentValue;

            // b_11_head
            $this->b_11_head->ViewValue = $this->b_11_head->CurrentValue;

            // b_12_head
            $this->b_12_head->ViewValue = $this->b_12_head->CurrentValue;

            // b_13_head
            $this->b_13_head->ViewValue = $this->b_13_head->CurrentValue;

            // b_14_head
            $this->b_14_head->ViewValue = $this->b_14_head->CurrentValue;

            // b_15_head
            $this->b_15_head->ViewValue = $this->b_15_head->CurrentValue;

            // q_sku
            $this->q_sku->ViewValue = $this->q_sku->CurrentValue;

            // t_01_head
            $this->t_01_head->ViewValue = $this->t_01_head->CurrentValue;

            // t_02_head
            $this->t_02_head->ViewValue = $this->t_02_head->CurrentValue;

            // t_03_head
            $this->t_03_head->ViewValue = $this->t_03_head->CurrentValue;

            // t_04_head
            $this->t_04_head->ViewValue = $this->t_04_head->CurrentValue;

            // t_05_head
            $this->t_05_head->ViewValue = $this->t_05_head->CurrentValue;

            // t_06_head
            $this->t_06_head->ViewValue = $this->t_06_head->CurrentValue;

            // t_07_head
            $this->t_07_head->ViewValue = $this->t_07_head->CurrentValue;

            // t_08_head
            $this->t_08_head->ViewValue = $this->t_08_head->CurrentValue;

            // t_09_head
            $this->t_09_head->ViewValue = $this->t_09_head->CurrentValue;

            // t_10_head
            $this->t_10_head->ViewValue = $this->t_10_head->CurrentValue;

            // t_11_head
            $this->t_11_head->ViewValue = $this->t_11_head->CurrentValue;

            // t_12_head
            $this->t_12_head->ViewValue = $this->t_12_head->CurrentValue;

            // t_13_head
            $this->t_13_head->ViewValue = $this->t_13_head->CurrentValue;

            // t_14_head
            $this->t_14_head->ViewValue = $this->t_14_head->CurrentValue;

            // t_15_head
            $this->t_15_head->ViewValue = $this->t_15_head->CurrentValue;

            // po_01_head
            $this->po_01_head->ViewValue = $this->po_01_head->CurrentValue;

            // po_02_head
            $this->po_02_head->ViewValue = $this->po_02_head->CurrentValue;

            // po_03_head
            $this->po_03_head->ViewValue = $this->po_03_head->CurrentValue;

            // po_04_head
            $this->po_04_head->ViewValue = $this->po_04_head->CurrentValue;

            // po_05_head
            $this->po_05_head->ViewValue = $this->po_05_head->CurrentValue;

            // po_06_head
            $this->po_06_head->ViewValue = $this->po_06_head->CurrentValue;

            // po_07_head
            $this->po_07_head->ViewValue = $this->po_07_head->CurrentValue;

            // po_08_head
            $this->po_08_head->ViewValue = $this->po_08_head->CurrentValue;

            // po_17_head
            $this->po_17_head->ViewValue = $this->po_17_head->CurrentValue;

            // po_18_head
            $this->po_18_head->ViewValue = $this->po_18_head->CurrentValue;

            // po_19_head
            $this->po_19_head->ViewValue = $this->po_19_head->CurrentValue;

            // po_20_head
            $this->po_20_head->ViewValue = $this->po_20_head->CurrentValue;

            // jc_01_head
            $this->jc_01_head->ViewValue = $this->jc_01_head->CurrentValue;

            // jc_02_head
            $this->jc_02_head->ViewValue = $this->jc_02_head->CurrentValue;

            // jc_03_head
            $this->jc_03_head->ViewValue = $this->jc_03_head->CurrentValue;

            // jc_04_head
            $this->jc_04_head->ViewValue = $this->jc_04_head->CurrentValue;

            // jc_05_head
            $this->jc_05_head->ViewValue = $this->jc_05_head->CurrentValue;

            // jc_06_head
            $this->jc_06_head->ViewValue = $this->jc_06_head->CurrentValue;

            // jc_07_head
            $this->jc_07_head->ViewValue = $this->jc_07_head->CurrentValue;

            // jc_08_head
            $this->jc_08_head->ViewValue = $this->jc_08_head->CurrentValue;

            // jc_09_head
            $this->jc_09_head->ViewValue = $this->jc_09_head->CurrentValue;

            // jc_10_head
            $this->jc_10_head->ViewValue = $this->jc_10_head->CurrentValue;

            // pc_shape
            $this->pc_shape->ViewValue = $this->pc_shape->CurrentValue;

            // pc_unit
            $this->pc_unit->ViewValue = $this->pc_unit->CurrentValue;

            // pc_w
            $this->pc_w->ViewValue = $this->pc_w->CurrentValue;

            // pc_l
            $this->pc_l->ViewValue = $this->pc_l->CurrentValue;

            // pc_h
            $this->pc_h->ViewValue = $this->pc_h->CurrentValue;

            // pc_partner_size
            $this->pc_partner_size->ViewValue = $this->pc_partner_size->CurrentValue;

            // pc_sqm
            $this->pc_sqm->ViewValue = $this->pc_sqm->CurrentValue;

            // pc_01_head
            $this->pc_01_head->ViewValue = $this->pc_01_head->CurrentValue;

            // pc_02_head
            $this->pc_02_head->ViewValue = $this->pc_02_head->CurrentValue;

            // pc_03_head
            $this->pc_03_head->ViewValue = $this->pc_03_head->CurrentValue;

            // pc_04_head
            $this->pc_04_head->ViewValue = $this->pc_04_head->CurrentValue;

            // pc_05_head
            $this->pc_05_head->ViewValue = $this->pc_05_head->CurrentValue;

            // pc_06_head
            $this->pc_06_head->ViewValue = $this->pc_06_head->CurrentValue;

            // pc_07_head
            $this->pc_07_head->ViewValue = $this->pc_07_head->CurrentValue;

            // pc_08_head
            $this->pc_08_head->ViewValue = $this->pc_08_head->CurrentValue;

            // pc_09_head
            $this->pc_09_head->ViewValue = $this->pc_09_head->CurrentValue;

            // pc_10_head
            $this->pc_10_head->ViewValue = $this->pc_10_head->CurrentValue;

            // pc_11_head
            $this->pc_11_head->ViewValue = $this->pc_11_head->CurrentValue;

            // pc_12_head
            $this->pc_12_head->ViewValue = $this->pc_12_head->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ImageWidth = 0;
                $this->image->ImageHeight = 50;
                $this->image->ImageAlt = $this->image->alt();
                $this->image->ImageCssClass = "ew-image";
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // pa_process_size_w
            $this->pa_process_size_w->ViewValue = $this->pa_process_size_w->CurrentValue;

            // pa_process_size_l
            $this->pa_process_size_l->ViewValue = $this->pa_process_size_l->CurrentValue;

            // pa_head_01
            $this->pa_head_01->ViewValue = $this->pa_head_01->CurrentValue;

            // pa_process_01
            $curVal = strval($this->pa_process_01->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_01->ViewValue = $this->pa_process_01->lookupCacheOption($curVal);
                if ($this->pa_process_01->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_01->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_01->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_01->Lookup->renderViewRow($row);
                            $this->pa_process_01->ViewValue->add($this->pa_process_01->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_01->ViewValue = $this->pa_process_01->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_01->ViewValue = null;
            }

            // pa_head_02
            $this->pa_head_02->ViewValue = $this->pa_head_02->CurrentValue;

            // pa_process_02
            $curVal = strval($this->pa_process_02->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_02->ViewValue = $this->pa_process_02->lookupCacheOption($curVal);
                if ($this->pa_process_02->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_02->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_02->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_02->Lookup->renderViewRow($row);
                            $this->pa_process_02->ViewValue->add($this->pa_process_02->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_02->ViewValue = $this->pa_process_02->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_02->ViewValue = null;
            }

            // pa_head_03
            $this->pa_head_03->ViewValue = $this->pa_head_03->CurrentValue;

            // pa_process_03
            $curVal = strval($this->pa_process_03->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_03->ViewValue = $this->pa_process_03->lookupCacheOption($curVal);
                if ($this->pa_process_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_03->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_03->Lookup->renderViewRow($row);
                            $this->pa_process_03->ViewValue->add($this->pa_process_03->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_03->ViewValue = $this->pa_process_03->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_03->ViewValue = null;
            }

            // pa_head_04
            $this->pa_head_04->ViewValue = $this->pa_head_04->CurrentValue;

            // pa_process_04
            $curVal = strval($this->pa_process_04->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_04->ViewValue = $this->pa_process_04->lookupCacheOption($curVal);
                if ($this->pa_process_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_04->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_04->Lookup->renderViewRow($row);
                            $this->pa_process_04->ViewValue->add($this->pa_process_04->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_04->ViewValue = $this->pa_process_04->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_04->ViewValue = null;
            }

            // pa_head_05
            $this->pa_head_05->ViewValue = $this->pa_head_05->CurrentValue;

            // pa_process_05
            $curVal = strval($this->pa_process_05->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_05->ViewValue = $this->pa_process_05->lookupCacheOption($curVal);
                if ($this->pa_process_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_05->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_05->Lookup->renderViewRow($row);
                            $this->pa_process_05->ViewValue->add($this->pa_process_05->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_05->ViewValue = $this->pa_process_05->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_05->ViewValue = null;
            }

            // pa_head_06
            $this->pa_head_06->ViewValue = $this->pa_head_06->CurrentValue;

            // pa_process_06
            $curVal = strval($this->pa_process_06->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_06->ViewValue = $this->pa_process_06->lookupCacheOption($curVal);
                if ($this->pa_process_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_06->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_06->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_06->Lookup->renderViewRow($row);
                            $this->pa_process_06->ViewValue->add($this->pa_process_06->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_06->ViewValue = $this->pa_process_06->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_06->ViewValue = null;
            }

            // pa_head_07
            $this->pa_head_07->ViewValue = $this->pa_head_07->CurrentValue;

            // pa_process_07
            $curVal = strval($this->pa_process_07->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_07->ViewValue = $this->pa_process_07->lookupCacheOption($curVal);
                if ($this->pa_process_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_07->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_07->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_07->Lookup->renderViewRow($row);
                            $this->pa_process_07->ViewValue->add($this->pa_process_07->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_07->ViewValue = $this->pa_process_07->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_07->ViewValue = null;
            }

            // pa_head_08
            $this->pa_head_08->ViewValue = $this->pa_head_08->CurrentValue;

            // pa_process_08
            $curVal = strval($this->pa_process_08->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_08->ViewValue = $this->pa_process_08->lookupCacheOption($curVal);
                if ($this->pa_process_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_08->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_08->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_08->Lookup->renderViewRow($row);
                            $this->pa_process_08->ViewValue->add($this->pa_process_08->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_08->ViewValue = $this->pa_process_08->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_08->ViewValue = null;
            }

            // pa_head_09
            $this->pa_head_09->ViewValue = $this->pa_head_09->CurrentValue;

            // pa_process_09
            $curVal = strval($this->pa_process_09->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_09->ViewValue = $this->pa_process_09->lookupCacheOption($curVal);
                if ($this->pa_process_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_09->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_09->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_09->Lookup->renderViewRow($row);
                            $this->pa_process_09->ViewValue->add($this->pa_process_09->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_09->ViewValue = $this->pa_process_09->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_09->ViewValue = null;
            }

            // pa_head_10
            $this->pa_head_10->ViewValue = $this->pa_head_10->CurrentValue;

            // pa_process_10
            $curVal = strval($this->pa_process_10->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_10->ViewValue = $this->pa_process_10->lookupCacheOption($curVal);
                if ($this->pa_process_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_10->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_10->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_10->Lookup->renderViewRow($row);
                            $this->pa_process_10->ViewValue->add($this->pa_process_10->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_10->ViewValue = $this->pa_process_10->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_10->ViewValue = null;
            }

            // publish
            $this->publish->ViewValue = $this->publish->CurrentValue;
            $this->publish->ViewValue = FormatNumber($this->publish->ViewValue, $this->publish->formatPattern());

            // ppr_01
            $this->ppr_01->ViewValue = $this->ppr_01->CurrentValue;

            // ppr_02
            $this->ppr_02->ViewValue = $this->ppr_02->CurrentValue;

            // ppr_03
            $this->ppr_03->ViewValue = $this->ppr_03->CurrentValue;

            // ppr_04
            $this->ppr_04->ViewValue = $this->ppr_04->CurrentValue;

            // ppr_05
            $this->ppr_05->ViewValue = $this->ppr_05->CurrentValue;

            // ppr_06
            $this->ppr_06->ViewValue = $this->ppr_06->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // product_group
            $this->product_group->HrefValue = "";
            $this->product_group->TooltipValue = "";

            // calculation_method
            $this->calculation_method->HrefValue = "";
            $this->calculation_method->TooltipValue = "";

            // shape
            $this->shape->HrefValue = "";
            $this->shape->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";

            // process
            $this->process->HrefValue = "";
            $this->process->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // v_00
            $this->v_00->HrefValue = "";
            $this->v_00->TooltipValue = "";

            // v_01
            $this->v_01->HrefValue = "";
            $this->v_01->TooltipValue = "";

            // v_01_validation
            $this->v_01_validation->HrefValue = "";
            $this->v_01_validation->TooltipValue = "";

            // v_02
            $this->v_02->HrefValue = "";
            $this->v_02->TooltipValue = "";

            // v_02_validation
            $this->v_02_validation->HrefValue = "";
            $this->v_02_validation->TooltipValue = "";

            // v_03
            $this->v_03->HrefValue = "";
            $this->v_03->TooltipValue = "";

            // v_03_validation
            $this->v_03_validation->HrefValue = "";
            $this->v_03_validation->TooltipValue = "";

            // v_04
            $this->v_04->HrefValue = "";
            $this->v_04->TooltipValue = "";

            // v_04_validation
            $this->v_04_validation->HrefValue = "";
            $this->v_04_validation->TooltipValue = "";

            // v_05
            $this->v_05->HrefValue = "";
            $this->v_05->TooltipValue = "";

            // v_05_validation
            $this->v_05_validation->HrefValue = "";
            $this->v_05_validation->TooltipValue = "";

            // v_06
            $this->v_06->HrefValue = "";
            $this->v_06->TooltipValue = "";

            // v_06_validation
            $this->v_06_validation->HrefValue = "";
            $this->v_06_validation->TooltipValue = "";

            // v_07
            $this->v_07->HrefValue = "";
            $this->v_07->TooltipValue = "";

            // v_07_validation
            $this->v_07_validation->HrefValue = "";
            $this->v_07_validation->TooltipValue = "";

            // v_08
            $this->v_08->HrefValue = "";
            $this->v_08->TooltipValue = "";

            // v_08_validation
            $this->v_08_validation->HrefValue = "";
            $this->v_08_validation->TooltipValue = "";

            // v_09
            $this->v_09->HrefValue = "";
            $this->v_09->TooltipValue = "";

            // v_09_validation
            $this->v_09_validation->HrefValue = "";
            $this->v_09_validation->TooltipValue = "";

            // v_10
            $this->v_10->HrefValue = "";
            $this->v_10->TooltipValue = "";

            // v_10_validation
            $this->v_10_validation->HrefValue = "";
            $this->v_10_validation->TooltipValue = "";

            // b_01_head
            $this->b_01_head->HrefValue = "";
            $this->b_01_head->TooltipValue = "";

            // b_02_head
            $this->b_02_head->HrefValue = "";
            $this->b_02_head->TooltipValue = "";

            // b_03_head
            $this->b_03_head->HrefValue = "";
            $this->b_03_head->TooltipValue = "";

            // b_04_head
            $this->b_04_head->HrefValue = "";
            $this->b_04_head->TooltipValue = "";

            // b_05_head
            $this->b_05_head->HrefValue = "";
            $this->b_05_head->TooltipValue = "";

            // b_06_head
            $this->b_06_head->HrefValue = "";
            $this->b_06_head->TooltipValue = "";

            // b_07_head
            $this->b_07_head->HrefValue = "";
            $this->b_07_head->TooltipValue = "";

            // b_08_head
            $this->b_08_head->HrefValue = "";
            $this->b_08_head->TooltipValue = "";

            // b_09_head
            $this->b_09_head->HrefValue = "";
            $this->b_09_head->TooltipValue = "";

            // b_10_head
            $this->b_10_head->HrefValue = "";
            $this->b_10_head->TooltipValue = "";

            // b_11_head
            $this->b_11_head->HrefValue = "";
            $this->b_11_head->TooltipValue = "";

            // b_12_head
            $this->b_12_head->HrefValue = "";
            $this->b_12_head->TooltipValue = "";

            // b_13_head
            $this->b_13_head->HrefValue = "";
            $this->b_13_head->TooltipValue = "";

            // b_14_head
            $this->b_14_head->HrefValue = "";
            $this->b_14_head->TooltipValue = "";

            // b_15_head
            $this->b_15_head->HrefValue = "";
            $this->b_15_head->TooltipValue = "";

            // q_sku
            $this->q_sku->HrefValue = "";
            $this->q_sku->TooltipValue = "";

            // t_01_head
            $this->t_01_head->HrefValue = "";
            $this->t_01_head->TooltipValue = "";

            // t_02_head
            $this->t_02_head->HrefValue = "";
            $this->t_02_head->TooltipValue = "";

            // t_03_head
            $this->t_03_head->HrefValue = "";
            $this->t_03_head->TooltipValue = "";

            // t_04_head
            $this->t_04_head->HrefValue = "";
            $this->t_04_head->TooltipValue = "";

            // t_05_head
            $this->t_05_head->HrefValue = "";
            $this->t_05_head->TooltipValue = "";

            // t_06_head
            $this->t_06_head->HrefValue = "";
            $this->t_06_head->TooltipValue = "";

            // t_07_head
            $this->t_07_head->HrefValue = "";
            $this->t_07_head->TooltipValue = "";

            // t_08_head
            $this->t_08_head->HrefValue = "";
            $this->t_08_head->TooltipValue = "";

            // t_09_head
            $this->t_09_head->HrefValue = "";
            $this->t_09_head->TooltipValue = "";

            // t_10_head
            $this->t_10_head->HrefValue = "";
            $this->t_10_head->TooltipValue = "";

            // t_11_head
            $this->t_11_head->HrefValue = "";
            $this->t_11_head->TooltipValue = "";

            // t_12_head
            $this->t_12_head->HrefValue = "";
            $this->t_12_head->TooltipValue = "";

            // t_13_head
            $this->t_13_head->HrefValue = "";
            $this->t_13_head->TooltipValue = "";

            // t_14_head
            $this->t_14_head->HrefValue = "";
            $this->t_14_head->TooltipValue = "";

            // t_15_head
            $this->t_15_head->HrefValue = "";
            $this->t_15_head->TooltipValue = "";

            // po_01_head
            $this->po_01_head->HrefValue = "";
            $this->po_01_head->TooltipValue = "";

            // po_02_head
            $this->po_02_head->HrefValue = "";
            $this->po_02_head->TooltipValue = "";

            // po_03_head
            $this->po_03_head->HrefValue = "";
            $this->po_03_head->TooltipValue = "";

            // po_04_head
            $this->po_04_head->HrefValue = "";
            $this->po_04_head->TooltipValue = "";

            // po_05_head
            $this->po_05_head->HrefValue = "";
            $this->po_05_head->TooltipValue = "";

            // po_06_head
            $this->po_06_head->HrefValue = "";
            $this->po_06_head->TooltipValue = "";

            // po_07_head
            $this->po_07_head->HrefValue = "";
            $this->po_07_head->TooltipValue = "";

            // po_08_head
            $this->po_08_head->HrefValue = "";
            $this->po_08_head->TooltipValue = "";

            // po_17_head
            $this->po_17_head->HrefValue = "";
            $this->po_17_head->TooltipValue = "";

            // po_18_head
            $this->po_18_head->HrefValue = "";
            $this->po_18_head->TooltipValue = "";

            // po_19_head
            $this->po_19_head->HrefValue = "";
            $this->po_19_head->TooltipValue = "";

            // po_20_head
            $this->po_20_head->HrefValue = "";
            $this->po_20_head->TooltipValue = "";

            // jc_01_head
            $this->jc_01_head->HrefValue = "";
            $this->jc_01_head->TooltipValue = "";

            // jc_02_head
            $this->jc_02_head->HrefValue = "";
            $this->jc_02_head->TooltipValue = "";

            // jc_03_head
            $this->jc_03_head->HrefValue = "";
            $this->jc_03_head->TooltipValue = "";

            // jc_04_head
            $this->jc_04_head->HrefValue = "";
            $this->jc_04_head->TooltipValue = "";

            // jc_05_head
            $this->jc_05_head->HrefValue = "";
            $this->jc_05_head->TooltipValue = "";

            // jc_06_head
            $this->jc_06_head->HrefValue = "";
            $this->jc_06_head->TooltipValue = "";

            // jc_07_head
            $this->jc_07_head->HrefValue = "";
            $this->jc_07_head->TooltipValue = "";

            // jc_08_head
            $this->jc_08_head->HrefValue = "";
            $this->jc_08_head->TooltipValue = "";

            // jc_09_head
            $this->jc_09_head->HrefValue = "";
            $this->jc_09_head->TooltipValue = "";

            // jc_10_head
            $this->jc_10_head->HrefValue = "";
            $this->jc_10_head->TooltipValue = "";

            // pc_shape
            $this->pc_shape->HrefValue = "";
            $this->pc_shape->TooltipValue = "";

            // pc_unit
            $this->pc_unit->HrefValue = "";
            $this->pc_unit->TooltipValue = "";

            // pc_w
            $this->pc_w->HrefValue = "";
            $this->pc_w->TooltipValue = "";

            // pc_l
            $this->pc_l->HrefValue = "";
            $this->pc_l->TooltipValue = "";

            // pc_h
            $this->pc_h->HrefValue = "";
            $this->pc_h->TooltipValue = "";

            // pc_partner_size
            $this->pc_partner_size->HrefValue = "";
            $this->pc_partner_size->TooltipValue = "";

            // pc_sqm
            $this->pc_sqm->HrefValue = "";
            $this->pc_sqm->TooltipValue = "";

            // pc_01_head
            $this->pc_01_head->HrefValue = "";
            $this->pc_01_head->TooltipValue = "";

            // pc_02_head
            $this->pc_02_head->HrefValue = "";
            $this->pc_02_head->TooltipValue = "";

            // pc_03_head
            $this->pc_03_head->HrefValue = "";
            $this->pc_03_head->TooltipValue = "";

            // pc_04_head
            $this->pc_04_head->HrefValue = "";
            $this->pc_04_head->TooltipValue = "";

            // pc_05_head
            $this->pc_05_head->HrefValue = "";
            $this->pc_05_head->TooltipValue = "";

            // pc_06_head
            $this->pc_06_head->HrefValue = "";
            $this->pc_06_head->TooltipValue = "";

            // pc_07_head
            $this->pc_07_head->HrefValue = "";
            $this->pc_07_head->TooltipValue = "";

            // pc_08_head
            $this->pc_08_head->HrefValue = "";
            $this->pc_08_head->TooltipValue = "";

            // pc_09_head
            $this->pc_09_head->HrefValue = "";
            $this->pc_09_head->TooltipValue = "";

            // pc_10_head
            $this->pc_10_head->HrefValue = "";
            $this->pc_10_head->TooltipValue = "";

            // pc_11_head
            $this->pc_11_head->HrefValue = "";
            $this->pc_11_head->TooltipValue = "";

            // pc_12_head
            $this->pc_12_head->HrefValue = "";
            $this->pc_12_head->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->htmlDecode($this->image->Upload->DbValue)); // Add prefix/suffix
                $this->image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
                }
            } else {
                $this->image->HrefValue = "";
            }
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
            $this->image->TooltipValue = "";
            if ($this->image->UseColorbox) {
                if (EmptyValue($this->image->TooltipValue)) {
                    $this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->image->LinkAttrs["data-rel"] = "product_group_x_image";
                $this->image->LinkAttrs->appendClass("ew-lightbox");
            }

            // pa_process_size_w
            $this->pa_process_size_w->HrefValue = "";
            $this->pa_process_size_w->TooltipValue = "";

            // pa_process_size_l
            $this->pa_process_size_l->HrefValue = "";
            $this->pa_process_size_l->TooltipValue = "";

            // pa_head_01
            $this->pa_head_01->HrefValue = "";
            $this->pa_head_01->TooltipValue = "";

            // pa_process_01
            $this->pa_process_01->HrefValue = "";
            $this->pa_process_01->TooltipValue = "";

            // pa_head_02
            $this->pa_head_02->HrefValue = "";
            $this->pa_head_02->TooltipValue = "";

            // pa_process_02
            $this->pa_process_02->HrefValue = "";
            $this->pa_process_02->TooltipValue = "";

            // pa_head_03
            $this->pa_head_03->HrefValue = "";
            $this->pa_head_03->TooltipValue = "";

            // pa_process_03
            $this->pa_process_03->HrefValue = "";
            $this->pa_process_03->TooltipValue = "";

            // pa_head_04
            $this->pa_head_04->HrefValue = "";
            $this->pa_head_04->TooltipValue = "";

            // pa_process_04
            $this->pa_process_04->HrefValue = "";
            $this->pa_process_04->TooltipValue = "";

            // pa_head_05
            $this->pa_head_05->HrefValue = "";
            $this->pa_head_05->TooltipValue = "";

            // pa_process_05
            $this->pa_process_05->HrefValue = "";
            $this->pa_process_05->TooltipValue = "";

            // pa_head_06
            $this->pa_head_06->HrefValue = "";
            $this->pa_head_06->TooltipValue = "";

            // pa_process_06
            $this->pa_process_06->HrefValue = "";
            $this->pa_process_06->TooltipValue = "";

            // pa_head_07
            $this->pa_head_07->HrefValue = "";
            $this->pa_head_07->TooltipValue = "";

            // pa_process_07
            $this->pa_process_07->HrefValue = "";
            $this->pa_process_07->TooltipValue = "";

            // pa_head_08
            $this->pa_head_08->HrefValue = "";
            $this->pa_head_08->TooltipValue = "";

            // pa_process_08
            $this->pa_process_08->HrefValue = "";
            $this->pa_process_08->TooltipValue = "";

            // pa_head_09
            $this->pa_head_09->HrefValue = "";
            $this->pa_head_09->TooltipValue = "";

            // pa_process_09
            $this->pa_process_09->HrefValue = "";
            $this->pa_process_09->TooltipValue = "";

            // pa_head_10
            $this->pa_head_10->HrefValue = "";
            $this->pa_head_10->TooltipValue = "";

            // pa_process_10
            $this->pa_process_10->HrefValue = "";
            $this->pa_process_10->TooltipValue = "";

            // publish
            $this->publish->HrefValue = "";
            $this->publish->TooltipValue = "";

            // ppr_01
            $this->ppr_01->HrefValue = "";
            $this->ppr_01->TooltipValue = "";

            // ppr_02
            $this->ppr_02->HrefValue = "";
            $this->ppr_02->TooltipValue = "";

            // ppr_03
            $this->ppr_03->HrefValue = "";
            $this->ppr_03->TooltipValue = "";

            // ppr_04
            $this->ppr_04->HrefValue = "";
            $this->ppr_04->TooltipValue = "";

            // ppr_05
            $this->ppr_05->HrefValue = "";
            $this->ppr_05->TooltipValue = "";

            // ppr_06
            $this->ppr_06->HrefValue = "";
            $this->ppr_06->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // product_group
            $this->product_group->setupEditAttributes();
            if (!$this->product_group->Raw) {
                $this->product_group->AdvancedSearch->SearchValue = HtmlDecode($this->product_group->AdvancedSearch->SearchValue);
            }
            $this->product_group->EditValue = HtmlEncode($this->product_group->AdvancedSearch->SearchValue);
            $this->product_group->PlaceHolder = RemoveHtml($this->product_group->caption());

            // calculation_method
            $this->calculation_method->setupEditAttributes();
            $curVal = trim(strval($this->calculation_method->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->calculation_method->AdvancedSearch->ViewValue = $this->calculation_method->lookupCacheOption($curVal);
            } else {
                $this->calculation_method->AdvancedSearch->ViewValue = $this->calculation_method->Lookup !== null && is_array($this->calculation_method->lookupOptions()) && count($this->calculation_method->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->calculation_method->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->calculation_method->EditValue = array_values($this->calculation_method->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->calculation_method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->calculation_method->AdvancedSearch->SearchValue, $this->calculation_method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->calculation_method->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->calculation_method->EditValue = $arwrk;
            }
            $this->calculation_method->PlaceHolder = RemoveHtml($this->calculation_method->caption());

            // shape
            $this->shape->setupEditAttributes();
            if (!$this->shape->Raw) {
                $this->shape->AdvancedSearch->SearchValue = HtmlDecode($this->shape->AdvancedSearch->SearchValue);
            }
            $this->shape->EditValue = HtmlEncode($this->shape->AdvancedSearch->SearchValue);
            $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            if (!$this->sqm->Raw) {
                $this->sqm->AdvancedSearch->SearchValue = HtmlDecode($this->sqm->AdvancedSearch->SearchValue);
            }
            $this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

            // cbm
            $this->cbm->setupEditAttributes();
            if (!$this->cbm->Raw) {
                $this->cbm->AdvancedSearch->SearchValue = HtmlDecode($this->cbm->AdvancedSearch->SearchValue);
            }
            $this->cbm->EditValue = HtmlEncode($this->cbm->AdvancedSearch->SearchValue);
            $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

            // process
            $this->process->setupEditAttributes();
            $curVal = trim(strval($this->process->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->process->AdvancedSearch->ViewValue = $this->process->lookupCacheOption($curVal);
            } else {
                $this->process->AdvancedSearch->ViewValue = $this->process->Lookup !== null && is_array($this->process->lookupOptions()) && count($this->process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->process->EditValue = array_values($this->process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->process->AdvancedSearch->SearchValue, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process->EditValue = $arwrk;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // v_00
            $this->v_00->setupEditAttributes();
            if (!$this->v_00->Raw) {
                $this->v_00->AdvancedSearch->SearchValue = HtmlDecode($this->v_00->AdvancedSearch->SearchValue);
            }
            $this->v_00->EditValue = HtmlEncode($this->v_00->AdvancedSearch->SearchValue);
            $this->v_00->PlaceHolder = RemoveHtml($this->v_00->caption());

            // v_01
            $this->v_01->setupEditAttributes();
            if (!$this->v_01->Raw) {
                $this->v_01->AdvancedSearch->SearchValue = HtmlDecode($this->v_01->AdvancedSearch->SearchValue);
            }
            $this->v_01->EditValue = HtmlEncode($this->v_01->AdvancedSearch->SearchValue);
            $this->v_01->PlaceHolder = RemoveHtml($this->v_01->caption());

            // v_01_validation
            $this->v_01_validation->setupEditAttributes();
            if (!$this->v_01_validation->Raw) {
                $this->v_01_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_01_validation->AdvancedSearch->SearchValue);
            }
            $this->v_01_validation->EditValue = HtmlEncode($this->v_01_validation->AdvancedSearch->SearchValue);
            $this->v_01_validation->PlaceHolder = RemoveHtml($this->v_01_validation->caption());

            // v_02
            $this->v_02->setupEditAttributes();
            if (!$this->v_02->Raw) {
                $this->v_02->AdvancedSearch->SearchValue = HtmlDecode($this->v_02->AdvancedSearch->SearchValue);
            }
            $this->v_02->EditValue = HtmlEncode($this->v_02->AdvancedSearch->SearchValue);
            $this->v_02->PlaceHolder = RemoveHtml($this->v_02->caption());

            // v_02_validation
            $this->v_02_validation->setupEditAttributes();
            if (!$this->v_02_validation->Raw) {
                $this->v_02_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_02_validation->AdvancedSearch->SearchValue);
            }
            $this->v_02_validation->EditValue = HtmlEncode($this->v_02_validation->AdvancedSearch->SearchValue);
            $this->v_02_validation->PlaceHolder = RemoveHtml($this->v_02_validation->caption());

            // v_03
            $this->v_03->setupEditAttributes();
            if (!$this->v_03->Raw) {
                $this->v_03->AdvancedSearch->SearchValue = HtmlDecode($this->v_03->AdvancedSearch->SearchValue);
            }
            $this->v_03->EditValue = HtmlEncode($this->v_03->AdvancedSearch->SearchValue);
            $this->v_03->PlaceHolder = RemoveHtml($this->v_03->caption());

            // v_03_validation
            $this->v_03_validation->setupEditAttributes();
            if (!$this->v_03_validation->Raw) {
                $this->v_03_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_03_validation->AdvancedSearch->SearchValue);
            }
            $this->v_03_validation->EditValue = HtmlEncode($this->v_03_validation->AdvancedSearch->SearchValue);
            $this->v_03_validation->PlaceHolder = RemoveHtml($this->v_03_validation->caption());

            // v_04
            $this->v_04->setupEditAttributes();
            if (!$this->v_04->Raw) {
                $this->v_04->AdvancedSearch->SearchValue = HtmlDecode($this->v_04->AdvancedSearch->SearchValue);
            }
            $this->v_04->EditValue = HtmlEncode($this->v_04->AdvancedSearch->SearchValue);
            $this->v_04->PlaceHolder = RemoveHtml($this->v_04->caption());

            // v_04_validation
            $this->v_04_validation->setupEditAttributes();
            if (!$this->v_04_validation->Raw) {
                $this->v_04_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_04_validation->AdvancedSearch->SearchValue);
            }
            $this->v_04_validation->EditValue = HtmlEncode($this->v_04_validation->AdvancedSearch->SearchValue);
            $this->v_04_validation->PlaceHolder = RemoveHtml($this->v_04_validation->caption());

            // v_05
            $this->v_05->setupEditAttributes();
            if (!$this->v_05->Raw) {
                $this->v_05->AdvancedSearch->SearchValue = HtmlDecode($this->v_05->AdvancedSearch->SearchValue);
            }
            $this->v_05->EditValue = HtmlEncode($this->v_05->AdvancedSearch->SearchValue);
            $this->v_05->PlaceHolder = RemoveHtml($this->v_05->caption());

            // v_05_validation
            $this->v_05_validation->setupEditAttributes();
            if (!$this->v_05_validation->Raw) {
                $this->v_05_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_05_validation->AdvancedSearch->SearchValue);
            }
            $this->v_05_validation->EditValue = HtmlEncode($this->v_05_validation->AdvancedSearch->SearchValue);
            $this->v_05_validation->PlaceHolder = RemoveHtml($this->v_05_validation->caption());

            // v_06
            $this->v_06->setupEditAttributes();
            if (!$this->v_06->Raw) {
                $this->v_06->AdvancedSearch->SearchValue = HtmlDecode($this->v_06->AdvancedSearch->SearchValue);
            }
            $this->v_06->EditValue = HtmlEncode($this->v_06->AdvancedSearch->SearchValue);
            $this->v_06->PlaceHolder = RemoveHtml($this->v_06->caption());

            // v_06_validation
            $this->v_06_validation->setupEditAttributes();
            if (!$this->v_06_validation->Raw) {
                $this->v_06_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_06_validation->AdvancedSearch->SearchValue);
            }
            $this->v_06_validation->EditValue = HtmlEncode($this->v_06_validation->AdvancedSearch->SearchValue);
            $this->v_06_validation->PlaceHolder = RemoveHtml($this->v_06_validation->caption());

            // v_07
            $this->v_07->setupEditAttributes();
            if (!$this->v_07->Raw) {
                $this->v_07->AdvancedSearch->SearchValue = HtmlDecode($this->v_07->AdvancedSearch->SearchValue);
            }
            $this->v_07->EditValue = HtmlEncode($this->v_07->AdvancedSearch->SearchValue);
            $this->v_07->PlaceHolder = RemoveHtml($this->v_07->caption());

            // v_07_validation
            $this->v_07_validation->setupEditAttributes();
            if (!$this->v_07_validation->Raw) {
                $this->v_07_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_07_validation->AdvancedSearch->SearchValue);
            }
            $this->v_07_validation->EditValue = HtmlEncode($this->v_07_validation->AdvancedSearch->SearchValue);
            $this->v_07_validation->PlaceHolder = RemoveHtml($this->v_07_validation->caption());

            // v_08
            $this->v_08->setupEditAttributes();
            if (!$this->v_08->Raw) {
                $this->v_08->AdvancedSearch->SearchValue = HtmlDecode($this->v_08->AdvancedSearch->SearchValue);
            }
            $this->v_08->EditValue = HtmlEncode($this->v_08->AdvancedSearch->SearchValue);
            $this->v_08->PlaceHolder = RemoveHtml($this->v_08->caption());

            // v_08_validation
            $this->v_08_validation->setupEditAttributes();
            if (!$this->v_08_validation->Raw) {
                $this->v_08_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_08_validation->AdvancedSearch->SearchValue);
            }
            $this->v_08_validation->EditValue = HtmlEncode($this->v_08_validation->AdvancedSearch->SearchValue);
            $this->v_08_validation->PlaceHolder = RemoveHtml($this->v_08_validation->caption());

            // v_09
            $this->v_09->setupEditAttributes();
            if (!$this->v_09->Raw) {
                $this->v_09->AdvancedSearch->SearchValue = HtmlDecode($this->v_09->AdvancedSearch->SearchValue);
            }
            $this->v_09->EditValue = HtmlEncode($this->v_09->AdvancedSearch->SearchValue);
            $this->v_09->PlaceHolder = RemoveHtml($this->v_09->caption());

            // v_09_validation
            $this->v_09_validation->setupEditAttributes();
            if (!$this->v_09_validation->Raw) {
                $this->v_09_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_09_validation->AdvancedSearch->SearchValue);
            }
            $this->v_09_validation->EditValue = HtmlEncode($this->v_09_validation->AdvancedSearch->SearchValue);
            $this->v_09_validation->PlaceHolder = RemoveHtml($this->v_09_validation->caption());

            // v_10
            $this->v_10->setupEditAttributes();
            if (!$this->v_10->Raw) {
                $this->v_10->AdvancedSearch->SearchValue = HtmlDecode($this->v_10->AdvancedSearch->SearchValue);
            }
            $this->v_10->EditValue = HtmlEncode($this->v_10->AdvancedSearch->SearchValue);
            $this->v_10->PlaceHolder = RemoveHtml($this->v_10->caption());

            // v_10_validation
            $this->v_10_validation->setupEditAttributes();
            if (!$this->v_10_validation->Raw) {
                $this->v_10_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_10_validation->AdvancedSearch->SearchValue);
            }
            $this->v_10_validation->EditValue = HtmlEncode($this->v_10_validation->AdvancedSearch->SearchValue);
            $this->v_10_validation->PlaceHolder = RemoveHtml($this->v_10_validation->caption());

            // b_01_head
            $this->b_01_head->setupEditAttributes();
            if (!$this->b_01_head->Raw) {
                $this->b_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_01_head->AdvancedSearch->SearchValue);
            }
            $this->b_01_head->EditValue = HtmlEncode($this->b_01_head->AdvancedSearch->SearchValue);
            $this->b_01_head->PlaceHolder = RemoveHtml($this->b_01_head->caption());

            // b_02_head
            $this->b_02_head->setupEditAttributes();
            if (!$this->b_02_head->Raw) {
                $this->b_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_02_head->AdvancedSearch->SearchValue);
            }
            $this->b_02_head->EditValue = HtmlEncode($this->b_02_head->AdvancedSearch->SearchValue);
            $this->b_02_head->PlaceHolder = RemoveHtml($this->b_02_head->caption());

            // b_03_head
            $this->b_03_head->setupEditAttributes();
            if (!$this->b_03_head->Raw) {
                $this->b_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_03_head->AdvancedSearch->SearchValue);
            }
            $this->b_03_head->EditValue = HtmlEncode($this->b_03_head->AdvancedSearch->SearchValue);
            $this->b_03_head->PlaceHolder = RemoveHtml($this->b_03_head->caption());

            // b_04_head
            $this->b_04_head->setupEditAttributes();
            if (!$this->b_04_head->Raw) {
                $this->b_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_04_head->AdvancedSearch->SearchValue);
            }
            $this->b_04_head->EditValue = HtmlEncode($this->b_04_head->AdvancedSearch->SearchValue);
            $this->b_04_head->PlaceHolder = RemoveHtml($this->b_04_head->caption());

            // b_05_head
            $this->b_05_head->setupEditAttributes();
            if (!$this->b_05_head->Raw) {
                $this->b_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_05_head->AdvancedSearch->SearchValue);
            }
            $this->b_05_head->EditValue = HtmlEncode($this->b_05_head->AdvancedSearch->SearchValue);
            $this->b_05_head->PlaceHolder = RemoveHtml($this->b_05_head->caption());

            // b_06_head
            $this->b_06_head->setupEditAttributes();
            if (!$this->b_06_head->Raw) {
                $this->b_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_06_head->AdvancedSearch->SearchValue);
            }
            $this->b_06_head->EditValue = HtmlEncode($this->b_06_head->AdvancedSearch->SearchValue);
            $this->b_06_head->PlaceHolder = RemoveHtml($this->b_06_head->caption());

            // b_07_head
            $this->b_07_head->setupEditAttributes();
            if (!$this->b_07_head->Raw) {
                $this->b_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_07_head->AdvancedSearch->SearchValue);
            }
            $this->b_07_head->EditValue = HtmlEncode($this->b_07_head->AdvancedSearch->SearchValue);
            $this->b_07_head->PlaceHolder = RemoveHtml($this->b_07_head->caption());

            // b_08_head
            $this->b_08_head->setupEditAttributes();
            if (!$this->b_08_head->Raw) {
                $this->b_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_08_head->AdvancedSearch->SearchValue);
            }
            $this->b_08_head->EditValue = HtmlEncode($this->b_08_head->AdvancedSearch->SearchValue);
            $this->b_08_head->PlaceHolder = RemoveHtml($this->b_08_head->caption());

            // b_09_head
            $this->b_09_head->setupEditAttributes();
            if (!$this->b_09_head->Raw) {
                $this->b_09_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_09_head->AdvancedSearch->SearchValue);
            }
            $this->b_09_head->EditValue = HtmlEncode($this->b_09_head->AdvancedSearch->SearchValue);
            $this->b_09_head->PlaceHolder = RemoveHtml($this->b_09_head->caption());

            // b_10_head
            $this->b_10_head->setupEditAttributes();
            if (!$this->b_10_head->Raw) {
                $this->b_10_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_10_head->AdvancedSearch->SearchValue);
            }
            $this->b_10_head->EditValue = HtmlEncode($this->b_10_head->AdvancedSearch->SearchValue);
            $this->b_10_head->PlaceHolder = RemoveHtml($this->b_10_head->caption());

            // b_11_head
            $this->b_11_head->setupEditAttributes();
            if (!$this->b_11_head->Raw) {
                $this->b_11_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_11_head->AdvancedSearch->SearchValue);
            }
            $this->b_11_head->EditValue = HtmlEncode($this->b_11_head->AdvancedSearch->SearchValue);
            $this->b_11_head->PlaceHolder = RemoveHtml($this->b_11_head->caption());

            // b_12_head
            $this->b_12_head->setupEditAttributes();
            if (!$this->b_12_head->Raw) {
                $this->b_12_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_12_head->AdvancedSearch->SearchValue);
            }
            $this->b_12_head->EditValue = HtmlEncode($this->b_12_head->AdvancedSearch->SearchValue);
            $this->b_12_head->PlaceHolder = RemoveHtml($this->b_12_head->caption());

            // b_13_head
            $this->b_13_head->setupEditAttributes();
            if (!$this->b_13_head->Raw) {
                $this->b_13_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_13_head->AdvancedSearch->SearchValue);
            }
            $this->b_13_head->EditValue = HtmlEncode($this->b_13_head->AdvancedSearch->SearchValue);
            $this->b_13_head->PlaceHolder = RemoveHtml($this->b_13_head->caption());

            // b_14_head
            $this->b_14_head->setupEditAttributes();
            if (!$this->b_14_head->Raw) {
                $this->b_14_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_14_head->AdvancedSearch->SearchValue);
            }
            $this->b_14_head->EditValue = HtmlEncode($this->b_14_head->AdvancedSearch->SearchValue);
            $this->b_14_head->PlaceHolder = RemoveHtml($this->b_14_head->caption());

            // b_15_head
            $this->b_15_head->setupEditAttributes();
            if (!$this->b_15_head->Raw) {
                $this->b_15_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_15_head->AdvancedSearch->SearchValue);
            }
            $this->b_15_head->EditValue = HtmlEncode($this->b_15_head->AdvancedSearch->SearchValue);
            $this->b_15_head->PlaceHolder = RemoveHtml($this->b_15_head->caption());

            // q_sku
            $this->q_sku->setupEditAttributes();
            if (!$this->q_sku->Raw) {
                $this->q_sku->AdvancedSearch->SearchValue = HtmlDecode($this->q_sku->AdvancedSearch->SearchValue);
            }
            $this->q_sku->EditValue = HtmlEncode($this->q_sku->AdvancedSearch->SearchValue);
            $this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());

            // t_01_head
            $this->t_01_head->setupEditAttributes();
            if (!$this->t_01_head->Raw) {
                $this->t_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_01_head->AdvancedSearch->SearchValue);
            }
            $this->t_01_head->EditValue = HtmlEncode($this->t_01_head->AdvancedSearch->SearchValue);
            $this->t_01_head->PlaceHolder = RemoveHtml($this->t_01_head->caption());

            // t_02_head
            $this->t_02_head->setupEditAttributes();
            if (!$this->t_02_head->Raw) {
                $this->t_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_02_head->AdvancedSearch->SearchValue);
            }
            $this->t_02_head->EditValue = HtmlEncode($this->t_02_head->AdvancedSearch->SearchValue);
            $this->t_02_head->PlaceHolder = RemoveHtml($this->t_02_head->caption());

            // t_03_head
            $this->t_03_head->setupEditAttributes();
            if (!$this->t_03_head->Raw) {
                $this->t_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_03_head->AdvancedSearch->SearchValue);
            }
            $this->t_03_head->EditValue = HtmlEncode($this->t_03_head->AdvancedSearch->SearchValue);
            $this->t_03_head->PlaceHolder = RemoveHtml($this->t_03_head->caption());

            // t_04_head
            $this->t_04_head->setupEditAttributes();
            if (!$this->t_04_head->Raw) {
                $this->t_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_04_head->AdvancedSearch->SearchValue);
            }
            $this->t_04_head->EditValue = HtmlEncode($this->t_04_head->AdvancedSearch->SearchValue);
            $this->t_04_head->PlaceHolder = RemoveHtml($this->t_04_head->caption());

            // t_05_head
            $this->t_05_head->setupEditAttributes();
            if (!$this->t_05_head->Raw) {
                $this->t_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_05_head->AdvancedSearch->SearchValue);
            }
            $this->t_05_head->EditValue = HtmlEncode($this->t_05_head->AdvancedSearch->SearchValue);
            $this->t_05_head->PlaceHolder = RemoveHtml($this->t_05_head->caption());

            // t_06_head
            $this->t_06_head->setupEditAttributes();
            if (!$this->t_06_head->Raw) {
                $this->t_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_06_head->AdvancedSearch->SearchValue);
            }
            $this->t_06_head->EditValue = HtmlEncode($this->t_06_head->AdvancedSearch->SearchValue);
            $this->t_06_head->PlaceHolder = RemoveHtml($this->t_06_head->caption());

            // t_07_head
            $this->t_07_head->setupEditAttributes();
            if (!$this->t_07_head->Raw) {
                $this->t_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_07_head->AdvancedSearch->SearchValue);
            }
            $this->t_07_head->EditValue = HtmlEncode($this->t_07_head->AdvancedSearch->SearchValue);
            $this->t_07_head->PlaceHolder = RemoveHtml($this->t_07_head->caption());

            // t_08_head
            $this->t_08_head->setupEditAttributes();
            if (!$this->t_08_head->Raw) {
                $this->t_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_08_head->AdvancedSearch->SearchValue);
            }
            $this->t_08_head->EditValue = HtmlEncode($this->t_08_head->AdvancedSearch->SearchValue);
            $this->t_08_head->PlaceHolder = RemoveHtml($this->t_08_head->caption());

            // t_09_head
            $this->t_09_head->setupEditAttributes();
            if (!$this->t_09_head->Raw) {
                $this->t_09_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_09_head->AdvancedSearch->SearchValue);
            }
            $this->t_09_head->EditValue = HtmlEncode($this->t_09_head->AdvancedSearch->SearchValue);
            $this->t_09_head->PlaceHolder = RemoveHtml($this->t_09_head->caption());

            // t_10_head
            $this->t_10_head->setupEditAttributes();
            if (!$this->t_10_head->Raw) {
                $this->t_10_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_10_head->AdvancedSearch->SearchValue);
            }
            $this->t_10_head->EditValue = HtmlEncode($this->t_10_head->AdvancedSearch->SearchValue);
            $this->t_10_head->PlaceHolder = RemoveHtml($this->t_10_head->caption());

            // t_11_head
            $this->t_11_head->setupEditAttributes();
            if (!$this->t_11_head->Raw) {
                $this->t_11_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_11_head->AdvancedSearch->SearchValue);
            }
            $this->t_11_head->EditValue = HtmlEncode($this->t_11_head->AdvancedSearch->SearchValue);
            $this->t_11_head->PlaceHolder = RemoveHtml($this->t_11_head->caption());

            // t_12_head
            $this->t_12_head->setupEditAttributes();
            if (!$this->t_12_head->Raw) {
                $this->t_12_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_12_head->AdvancedSearch->SearchValue);
            }
            $this->t_12_head->EditValue = HtmlEncode($this->t_12_head->AdvancedSearch->SearchValue);
            $this->t_12_head->PlaceHolder = RemoveHtml($this->t_12_head->caption());

            // t_13_head
            $this->t_13_head->setupEditAttributes();
            if (!$this->t_13_head->Raw) {
                $this->t_13_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_13_head->AdvancedSearch->SearchValue);
            }
            $this->t_13_head->EditValue = HtmlEncode($this->t_13_head->AdvancedSearch->SearchValue);
            $this->t_13_head->PlaceHolder = RemoveHtml($this->t_13_head->caption());

            // t_14_head
            $this->t_14_head->setupEditAttributes();
            if (!$this->t_14_head->Raw) {
                $this->t_14_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_14_head->AdvancedSearch->SearchValue);
            }
            $this->t_14_head->EditValue = HtmlEncode($this->t_14_head->AdvancedSearch->SearchValue);
            $this->t_14_head->PlaceHolder = RemoveHtml($this->t_14_head->caption());

            // t_15_head
            $this->t_15_head->setupEditAttributes();
            if (!$this->t_15_head->Raw) {
                $this->t_15_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_15_head->AdvancedSearch->SearchValue);
            }
            $this->t_15_head->EditValue = HtmlEncode($this->t_15_head->AdvancedSearch->SearchValue);
            $this->t_15_head->PlaceHolder = RemoveHtml($this->t_15_head->caption());

            // po_01_head
            $this->po_01_head->setupEditAttributes();
            if (!$this->po_01_head->Raw) {
                $this->po_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_01_head->AdvancedSearch->SearchValue);
            }
            $this->po_01_head->EditValue = HtmlEncode($this->po_01_head->AdvancedSearch->SearchValue);
            $this->po_01_head->PlaceHolder = RemoveHtml($this->po_01_head->caption());

            // po_02_head
            $this->po_02_head->setupEditAttributes();
            if (!$this->po_02_head->Raw) {
                $this->po_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_02_head->AdvancedSearch->SearchValue);
            }
            $this->po_02_head->EditValue = HtmlEncode($this->po_02_head->AdvancedSearch->SearchValue);
            $this->po_02_head->PlaceHolder = RemoveHtml($this->po_02_head->caption());

            // po_03_head
            $this->po_03_head->setupEditAttributes();
            if (!$this->po_03_head->Raw) {
                $this->po_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_03_head->AdvancedSearch->SearchValue);
            }
            $this->po_03_head->EditValue = HtmlEncode($this->po_03_head->AdvancedSearch->SearchValue);
            $this->po_03_head->PlaceHolder = RemoveHtml($this->po_03_head->caption());

            // po_04_head
            $this->po_04_head->setupEditAttributes();
            if (!$this->po_04_head->Raw) {
                $this->po_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_04_head->AdvancedSearch->SearchValue);
            }
            $this->po_04_head->EditValue = HtmlEncode($this->po_04_head->AdvancedSearch->SearchValue);
            $this->po_04_head->PlaceHolder = RemoveHtml($this->po_04_head->caption());

            // po_05_head
            $this->po_05_head->setupEditAttributes();
            if (!$this->po_05_head->Raw) {
                $this->po_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_05_head->AdvancedSearch->SearchValue);
            }
            $this->po_05_head->EditValue = HtmlEncode($this->po_05_head->AdvancedSearch->SearchValue);
            $this->po_05_head->PlaceHolder = RemoveHtml($this->po_05_head->caption());

            // po_06_head
            $this->po_06_head->setupEditAttributes();
            if (!$this->po_06_head->Raw) {
                $this->po_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_06_head->AdvancedSearch->SearchValue);
            }
            $this->po_06_head->EditValue = HtmlEncode($this->po_06_head->AdvancedSearch->SearchValue);
            $this->po_06_head->PlaceHolder = RemoveHtml($this->po_06_head->caption());

            // po_07_head
            $this->po_07_head->setupEditAttributes();
            if (!$this->po_07_head->Raw) {
                $this->po_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_07_head->AdvancedSearch->SearchValue);
            }
            $this->po_07_head->EditValue = HtmlEncode($this->po_07_head->AdvancedSearch->SearchValue);
            $this->po_07_head->PlaceHolder = RemoveHtml($this->po_07_head->caption());

            // po_08_head
            $this->po_08_head->setupEditAttributes();
            if (!$this->po_08_head->Raw) {
                $this->po_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_08_head->AdvancedSearch->SearchValue);
            }
            $this->po_08_head->EditValue = HtmlEncode($this->po_08_head->AdvancedSearch->SearchValue);
            $this->po_08_head->PlaceHolder = RemoveHtml($this->po_08_head->caption());

            // po_17_head
            $this->po_17_head->setupEditAttributes();
            if (!$this->po_17_head->Raw) {
                $this->po_17_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_17_head->AdvancedSearch->SearchValue);
            }
            $this->po_17_head->EditValue = HtmlEncode($this->po_17_head->AdvancedSearch->SearchValue);
            $this->po_17_head->PlaceHolder = RemoveHtml($this->po_17_head->caption());

            // po_18_head
            $this->po_18_head->setupEditAttributes();
            if (!$this->po_18_head->Raw) {
                $this->po_18_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_18_head->AdvancedSearch->SearchValue);
            }
            $this->po_18_head->EditValue = HtmlEncode($this->po_18_head->AdvancedSearch->SearchValue);
            $this->po_18_head->PlaceHolder = RemoveHtml($this->po_18_head->caption());

            // po_19_head
            $this->po_19_head->setupEditAttributes();
            if (!$this->po_19_head->Raw) {
                $this->po_19_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_19_head->AdvancedSearch->SearchValue);
            }
            $this->po_19_head->EditValue = HtmlEncode($this->po_19_head->AdvancedSearch->SearchValue);
            $this->po_19_head->PlaceHolder = RemoveHtml($this->po_19_head->caption());

            // po_20_head
            $this->po_20_head->setupEditAttributes();
            if (!$this->po_20_head->Raw) {
                $this->po_20_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_20_head->AdvancedSearch->SearchValue);
            }
            $this->po_20_head->EditValue = HtmlEncode($this->po_20_head->AdvancedSearch->SearchValue);
            $this->po_20_head->PlaceHolder = RemoveHtml($this->po_20_head->caption());

            // jc_01_head
            $this->jc_01_head->setupEditAttributes();
            if (!$this->jc_01_head->Raw) {
                $this->jc_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_01_head->AdvancedSearch->SearchValue);
            }
            $this->jc_01_head->EditValue = HtmlEncode($this->jc_01_head->AdvancedSearch->SearchValue);
            $this->jc_01_head->PlaceHolder = RemoveHtml($this->jc_01_head->caption());

            // jc_02_head
            $this->jc_02_head->setupEditAttributes();
            if (!$this->jc_02_head->Raw) {
                $this->jc_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_02_head->AdvancedSearch->SearchValue);
            }
            $this->jc_02_head->EditValue = HtmlEncode($this->jc_02_head->AdvancedSearch->SearchValue);
            $this->jc_02_head->PlaceHolder = RemoveHtml($this->jc_02_head->caption());

            // jc_03_head
            $this->jc_03_head->setupEditAttributes();
            if (!$this->jc_03_head->Raw) {
                $this->jc_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_03_head->AdvancedSearch->SearchValue);
            }
            $this->jc_03_head->EditValue = HtmlEncode($this->jc_03_head->AdvancedSearch->SearchValue);
            $this->jc_03_head->PlaceHolder = RemoveHtml($this->jc_03_head->caption());

            // jc_04_head
            $this->jc_04_head->setupEditAttributes();
            if (!$this->jc_04_head->Raw) {
                $this->jc_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_04_head->AdvancedSearch->SearchValue);
            }
            $this->jc_04_head->EditValue = HtmlEncode($this->jc_04_head->AdvancedSearch->SearchValue);
            $this->jc_04_head->PlaceHolder = RemoveHtml($this->jc_04_head->caption());

            // jc_05_head
            $this->jc_05_head->setupEditAttributes();
            if (!$this->jc_05_head->Raw) {
                $this->jc_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_05_head->AdvancedSearch->SearchValue);
            }
            $this->jc_05_head->EditValue = HtmlEncode($this->jc_05_head->AdvancedSearch->SearchValue);
            $this->jc_05_head->PlaceHolder = RemoveHtml($this->jc_05_head->caption());

            // jc_06_head
            $this->jc_06_head->setupEditAttributes();
            if (!$this->jc_06_head->Raw) {
                $this->jc_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_06_head->AdvancedSearch->SearchValue);
            }
            $this->jc_06_head->EditValue = HtmlEncode($this->jc_06_head->AdvancedSearch->SearchValue);
            $this->jc_06_head->PlaceHolder = RemoveHtml($this->jc_06_head->caption());

            // jc_07_head
            $this->jc_07_head->setupEditAttributes();
            if (!$this->jc_07_head->Raw) {
                $this->jc_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_07_head->AdvancedSearch->SearchValue);
            }
            $this->jc_07_head->EditValue = HtmlEncode($this->jc_07_head->AdvancedSearch->SearchValue);
            $this->jc_07_head->PlaceHolder = RemoveHtml($this->jc_07_head->caption());

            // jc_08_head
            $this->jc_08_head->setupEditAttributes();
            if (!$this->jc_08_head->Raw) {
                $this->jc_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_08_head->AdvancedSearch->SearchValue);
            }
            $this->jc_08_head->EditValue = HtmlEncode($this->jc_08_head->AdvancedSearch->SearchValue);
            $this->jc_08_head->PlaceHolder = RemoveHtml($this->jc_08_head->caption());

            // jc_09_head
            $this->jc_09_head->setupEditAttributes();
            if (!$this->jc_09_head->Raw) {
                $this->jc_09_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_09_head->AdvancedSearch->SearchValue);
            }
            $this->jc_09_head->EditValue = HtmlEncode($this->jc_09_head->AdvancedSearch->SearchValue);
            $this->jc_09_head->PlaceHolder = RemoveHtml($this->jc_09_head->caption());

            // jc_10_head
            $this->jc_10_head->setupEditAttributes();
            if (!$this->jc_10_head->Raw) {
                $this->jc_10_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_10_head->AdvancedSearch->SearchValue);
            }
            $this->jc_10_head->EditValue = HtmlEncode($this->jc_10_head->AdvancedSearch->SearchValue);
            $this->jc_10_head->PlaceHolder = RemoveHtml($this->jc_10_head->caption());

            // pc_shape
            $this->pc_shape->setupEditAttributes();
            if (!$this->pc_shape->Raw) {
                $this->pc_shape->AdvancedSearch->SearchValue = HtmlDecode($this->pc_shape->AdvancedSearch->SearchValue);
            }
            $this->pc_shape->EditValue = HtmlEncode($this->pc_shape->AdvancedSearch->SearchValue);
            $this->pc_shape->PlaceHolder = RemoveHtml($this->pc_shape->caption());

            // pc_unit
            $this->pc_unit->setupEditAttributes();
            if (!$this->pc_unit->Raw) {
                $this->pc_unit->AdvancedSearch->SearchValue = HtmlDecode($this->pc_unit->AdvancedSearch->SearchValue);
            }
            $this->pc_unit->EditValue = HtmlEncode($this->pc_unit->AdvancedSearch->SearchValue);
            $this->pc_unit->PlaceHolder = RemoveHtml($this->pc_unit->caption());

            // pc_w
            $this->pc_w->setupEditAttributes();
            if (!$this->pc_w->Raw) {
                $this->pc_w->AdvancedSearch->SearchValue = HtmlDecode($this->pc_w->AdvancedSearch->SearchValue);
            }
            $this->pc_w->EditValue = HtmlEncode($this->pc_w->AdvancedSearch->SearchValue);
            $this->pc_w->PlaceHolder = RemoveHtml($this->pc_w->caption());

            // pc_l
            $this->pc_l->setupEditAttributes();
            if (!$this->pc_l->Raw) {
                $this->pc_l->AdvancedSearch->SearchValue = HtmlDecode($this->pc_l->AdvancedSearch->SearchValue);
            }
            $this->pc_l->EditValue = HtmlEncode($this->pc_l->AdvancedSearch->SearchValue);
            $this->pc_l->PlaceHolder = RemoveHtml($this->pc_l->caption());

            // pc_h
            $this->pc_h->setupEditAttributes();
            if (!$this->pc_h->Raw) {
                $this->pc_h->AdvancedSearch->SearchValue = HtmlDecode($this->pc_h->AdvancedSearch->SearchValue);
            }
            $this->pc_h->EditValue = HtmlEncode($this->pc_h->AdvancedSearch->SearchValue);
            $this->pc_h->PlaceHolder = RemoveHtml($this->pc_h->caption());

            // pc_partner_size
            $this->pc_partner_size->setupEditAttributes();
            if (!$this->pc_partner_size->Raw) {
                $this->pc_partner_size->AdvancedSearch->SearchValue = HtmlDecode($this->pc_partner_size->AdvancedSearch->SearchValue);
            }
            $this->pc_partner_size->EditValue = HtmlEncode($this->pc_partner_size->AdvancedSearch->SearchValue);
            $this->pc_partner_size->PlaceHolder = RemoveHtml($this->pc_partner_size->caption());

            // pc_sqm
            $this->pc_sqm->setupEditAttributes();
            if (!$this->pc_sqm->Raw) {
                $this->pc_sqm->AdvancedSearch->SearchValue = HtmlDecode($this->pc_sqm->AdvancedSearch->SearchValue);
            }
            $this->pc_sqm->EditValue = HtmlEncode($this->pc_sqm->AdvancedSearch->SearchValue);
            $this->pc_sqm->PlaceHolder = RemoveHtml($this->pc_sqm->caption());

            // pc_01_head
            $this->pc_01_head->setupEditAttributes();
            if (!$this->pc_01_head->Raw) {
                $this->pc_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_01_head->AdvancedSearch->SearchValue);
            }
            $this->pc_01_head->EditValue = HtmlEncode($this->pc_01_head->AdvancedSearch->SearchValue);
            $this->pc_01_head->PlaceHolder = RemoveHtml($this->pc_01_head->caption());

            // pc_02_head
            $this->pc_02_head->setupEditAttributes();
            if (!$this->pc_02_head->Raw) {
                $this->pc_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_02_head->AdvancedSearch->SearchValue);
            }
            $this->pc_02_head->EditValue = HtmlEncode($this->pc_02_head->AdvancedSearch->SearchValue);
            $this->pc_02_head->PlaceHolder = RemoveHtml($this->pc_02_head->caption());

            // pc_03_head
            $this->pc_03_head->setupEditAttributes();
            if (!$this->pc_03_head->Raw) {
                $this->pc_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_03_head->AdvancedSearch->SearchValue);
            }
            $this->pc_03_head->EditValue = HtmlEncode($this->pc_03_head->AdvancedSearch->SearchValue);
            $this->pc_03_head->PlaceHolder = RemoveHtml($this->pc_03_head->caption());

            // pc_04_head
            $this->pc_04_head->setupEditAttributes();
            if (!$this->pc_04_head->Raw) {
                $this->pc_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_04_head->AdvancedSearch->SearchValue);
            }
            $this->pc_04_head->EditValue = HtmlEncode($this->pc_04_head->AdvancedSearch->SearchValue);
            $this->pc_04_head->PlaceHolder = RemoveHtml($this->pc_04_head->caption());

            // pc_05_head
            $this->pc_05_head->setupEditAttributes();
            if (!$this->pc_05_head->Raw) {
                $this->pc_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_05_head->AdvancedSearch->SearchValue);
            }
            $this->pc_05_head->EditValue = HtmlEncode($this->pc_05_head->AdvancedSearch->SearchValue);
            $this->pc_05_head->PlaceHolder = RemoveHtml($this->pc_05_head->caption());

            // pc_06_head
            $this->pc_06_head->setupEditAttributes();
            if (!$this->pc_06_head->Raw) {
                $this->pc_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_06_head->AdvancedSearch->SearchValue);
            }
            $this->pc_06_head->EditValue = HtmlEncode($this->pc_06_head->AdvancedSearch->SearchValue);
            $this->pc_06_head->PlaceHolder = RemoveHtml($this->pc_06_head->caption());

            // pc_07_head
            $this->pc_07_head->setupEditAttributes();
            if (!$this->pc_07_head->Raw) {
                $this->pc_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_07_head->AdvancedSearch->SearchValue);
            }
            $this->pc_07_head->EditValue = HtmlEncode($this->pc_07_head->AdvancedSearch->SearchValue);
            $this->pc_07_head->PlaceHolder = RemoveHtml($this->pc_07_head->caption());

            // pc_08_head
            $this->pc_08_head->setupEditAttributes();
            if (!$this->pc_08_head->Raw) {
                $this->pc_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_08_head->AdvancedSearch->SearchValue);
            }
            $this->pc_08_head->EditValue = HtmlEncode($this->pc_08_head->AdvancedSearch->SearchValue);
            $this->pc_08_head->PlaceHolder = RemoveHtml($this->pc_08_head->caption());

            // pc_09_head
            $this->pc_09_head->setupEditAttributes();
            if (!$this->pc_09_head->Raw) {
                $this->pc_09_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_09_head->AdvancedSearch->SearchValue);
            }
            $this->pc_09_head->EditValue = HtmlEncode($this->pc_09_head->AdvancedSearch->SearchValue);
            $this->pc_09_head->PlaceHolder = RemoveHtml($this->pc_09_head->caption());

            // pc_10_head
            $this->pc_10_head->setupEditAttributes();
            if (!$this->pc_10_head->Raw) {
                $this->pc_10_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_10_head->AdvancedSearch->SearchValue);
            }
            $this->pc_10_head->EditValue = HtmlEncode($this->pc_10_head->AdvancedSearch->SearchValue);
            $this->pc_10_head->PlaceHolder = RemoveHtml($this->pc_10_head->caption());

            // pc_11_head
            $this->pc_11_head->setupEditAttributes();
            if (!$this->pc_11_head->Raw) {
                $this->pc_11_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_11_head->AdvancedSearch->SearchValue);
            }
            $this->pc_11_head->EditValue = HtmlEncode($this->pc_11_head->AdvancedSearch->SearchValue);
            $this->pc_11_head->PlaceHolder = RemoveHtml($this->pc_11_head->caption());

            // pc_12_head
            $this->pc_12_head->setupEditAttributes();
            if (!$this->pc_12_head->Raw) {
                $this->pc_12_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_12_head->AdvancedSearch->SearchValue);
            }
            $this->pc_12_head->EditValue = HtmlEncode($this->pc_12_head->AdvancedSearch->SearchValue);
            $this->pc_12_head->PlaceHolder = RemoveHtml($this->pc_12_head->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // image
            $this->image->setupEditAttributes();
            if (!$this->image->Raw) {
                $this->image->AdvancedSearch->SearchValue = HtmlDecode($this->image->AdvancedSearch->SearchValue);
            }
            $this->image->EditValue = HtmlEncode($this->image->AdvancedSearch->SearchValue);
            $this->image->PlaceHolder = RemoveHtml($this->image->caption());

            // pa_process_size_w
            $this->pa_process_size_w->setupEditAttributes();
            if (!$this->pa_process_size_w->Raw) {
                $this->pa_process_size_w->AdvancedSearch->SearchValue = HtmlDecode($this->pa_process_size_w->AdvancedSearch->SearchValue);
            }
            $this->pa_process_size_w->EditValue = HtmlEncode($this->pa_process_size_w->AdvancedSearch->SearchValue);
            $this->pa_process_size_w->PlaceHolder = RemoveHtml($this->pa_process_size_w->caption());

            // pa_process_size_l
            $this->pa_process_size_l->setupEditAttributes();
            if (!$this->pa_process_size_l->Raw) {
                $this->pa_process_size_l->AdvancedSearch->SearchValue = HtmlDecode($this->pa_process_size_l->AdvancedSearch->SearchValue);
            }
            $this->pa_process_size_l->EditValue = HtmlEncode($this->pa_process_size_l->AdvancedSearch->SearchValue);
            $this->pa_process_size_l->PlaceHolder = RemoveHtml($this->pa_process_size_l->caption());

            // pa_head_01
            $this->pa_head_01->setupEditAttributes();
            if (!$this->pa_head_01->Raw) {
                $this->pa_head_01->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_01->AdvancedSearch->SearchValue);
            }
            $this->pa_head_01->EditValue = HtmlEncode($this->pa_head_01->AdvancedSearch->SearchValue);
            $this->pa_head_01->PlaceHolder = RemoveHtml($this->pa_head_01->caption());

            // pa_process_01
            $curVal = trim(strval($this->pa_process_01->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pa_process_01->AdvancedSearch->ViewValue = $this->pa_process_01->lookupCacheOption($curVal);
            } else {
                $this->pa_process_01->AdvancedSearch->ViewValue = $this->pa_process_01->Lookup !== null && is_array($this->pa_process_01->lookupOptions()) && count($this->pa_process_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_01->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pa_process_01->EditValue = array_values($this->pa_process_01->lookupOptions());
                if ($this->pa_process_01->AdvancedSearch->ViewValue == "") {
                    $this->pa_process_01->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_01->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_01->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_01->Lookup->renderViewRow($row);
                        $this->pa_process_01->AdvancedSearch->ViewValue->add($this->pa_process_01->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_01->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_01->EditValue = $arwrk;
            }
            $this->pa_process_01->PlaceHolder = RemoveHtml($this->pa_process_01->caption());
            $curVal = trim(strval($this->pa_process_01->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->pa_process_01->AdvancedSearch->ViewValue2 = $this->pa_process_01->lookupCacheOption($curVal);
            } else {
                $this->pa_process_01->AdvancedSearch->ViewValue2 = $this->pa_process_01->Lookup !== null && is_array($this->pa_process_01->lookupOptions()) && count($this->pa_process_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_01->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->pa_process_01->EditValue2 = array_values($this->pa_process_01->lookupOptions());
                if ($this->pa_process_01->AdvancedSearch->ViewValue2 == "") {
                    $this->pa_process_01->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_01->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_01->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_01->Lookup->renderViewRow($row);
                        $this->pa_process_01->AdvancedSearch->ViewValue2->add($this->pa_process_01->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_01->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_01->EditValue2 = $arwrk;
            }
            $this->pa_process_01->PlaceHolder = RemoveHtml($this->pa_process_01->caption());

            // pa_head_02
            $this->pa_head_02->setupEditAttributes();
            if (!$this->pa_head_02->Raw) {
                $this->pa_head_02->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_02->AdvancedSearch->SearchValue);
            }
            $this->pa_head_02->EditValue = HtmlEncode($this->pa_head_02->AdvancedSearch->SearchValue);
            $this->pa_head_02->PlaceHolder = RemoveHtml($this->pa_head_02->caption());

            // pa_process_02
            $curVal = trim(strval($this->pa_process_02->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pa_process_02->AdvancedSearch->ViewValue = $this->pa_process_02->lookupCacheOption($curVal);
            } else {
                $this->pa_process_02->AdvancedSearch->ViewValue = $this->pa_process_02->Lookup !== null && is_array($this->pa_process_02->lookupOptions()) && count($this->pa_process_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_02->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pa_process_02->EditValue = array_values($this->pa_process_02->lookupOptions());
                if ($this->pa_process_02->AdvancedSearch->ViewValue == "") {
                    $this->pa_process_02->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_02->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_02->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_02->Lookup->renderViewRow($row);
                        $this->pa_process_02->AdvancedSearch->ViewValue->add($this->pa_process_02->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_02->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_02->EditValue = $arwrk;
            }
            $this->pa_process_02->PlaceHolder = RemoveHtml($this->pa_process_02->caption());
            $curVal = trim(strval($this->pa_process_02->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->pa_process_02->AdvancedSearch->ViewValue2 = $this->pa_process_02->lookupCacheOption($curVal);
            } else {
                $this->pa_process_02->AdvancedSearch->ViewValue2 = $this->pa_process_02->Lookup !== null && is_array($this->pa_process_02->lookupOptions()) && count($this->pa_process_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_02->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->pa_process_02->EditValue2 = array_values($this->pa_process_02->lookupOptions());
                if ($this->pa_process_02->AdvancedSearch->ViewValue2 == "") {
                    $this->pa_process_02->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_02->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_02->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_02->Lookup->renderViewRow($row);
                        $this->pa_process_02->AdvancedSearch->ViewValue2->add($this->pa_process_02->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_02->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_02->EditValue2 = $arwrk;
            }
            $this->pa_process_02->PlaceHolder = RemoveHtml($this->pa_process_02->caption());

            // pa_head_03
            $this->pa_head_03->setupEditAttributes();
            if (!$this->pa_head_03->Raw) {
                $this->pa_head_03->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_03->AdvancedSearch->SearchValue);
            }
            $this->pa_head_03->EditValue = HtmlEncode($this->pa_head_03->AdvancedSearch->SearchValue);
            $this->pa_head_03->PlaceHolder = RemoveHtml($this->pa_head_03->caption());

            // pa_process_03
            $curVal = trim(strval($this->pa_process_03->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pa_process_03->AdvancedSearch->ViewValue = $this->pa_process_03->lookupCacheOption($curVal);
            } else {
                $this->pa_process_03->AdvancedSearch->ViewValue = $this->pa_process_03->Lookup !== null && is_array($this->pa_process_03->lookupOptions()) && count($this->pa_process_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_03->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pa_process_03->EditValue = array_values($this->pa_process_03->lookupOptions());
                if ($this->pa_process_03->AdvancedSearch->ViewValue == "") {
                    $this->pa_process_03->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_03->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_03->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_03->Lookup->renderViewRow($row);
                        $this->pa_process_03->AdvancedSearch->ViewValue->add($this->pa_process_03->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_03->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_03->EditValue = $arwrk;
            }
            $this->pa_process_03->PlaceHolder = RemoveHtml($this->pa_process_03->caption());
            $curVal = trim(strval($this->pa_process_03->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->pa_process_03->AdvancedSearch->ViewValue2 = $this->pa_process_03->lookupCacheOption($curVal);
            } else {
                $this->pa_process_03->AdvancedSearch->ViewValue2 = $this->pa_process_03->Lookup !== null && is_array($this->pa_process_03->lookupOptions()) && count($this->pa_process_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_03->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->pa_process_03->EditValue2 = array_values($this->pa_process_03->lookupOptions());
                if ($this->pa_process_03->AdvancedSearch->ViewValue2 == "") {
                    $this->pa_process_03->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_03->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_03->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_03->Lookup->renderViewRow($row);
                        $this->pa_process_03->AdvancedSearch->ViewValue2->add($this->pa_process_03->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_03->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_03->EditValue2 = $arwrk;
            }
            $this->pa_process_03->PlaceHolder = RemoveHtml($this->pa_process_03->caption());

            // pa_head_04
            $this->pa_head_04->setupEditAttributes();
            if (!$this->pa_head_04->Raw) {
                $this->pa_head_04->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_04->AdvancedSearch->SearchValue);
            }
            $this->pa_head_04->EditValue = HtmlEncode($this->pa_head_04->AdvancedSearch->SearchValue);
            $this->pa_head_04->PlaceHolder = RemoveHtml($this->pa_head_04->caption());

            // pa_process_04
            $curVal = trim(strval($this->pa_process_04->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pa_process_04->AdvancedSearch->ViewValue = $this->pa_process_04->lookupCacheOption($curVal);
            } else {
                $this->pa_process_04->AdvancedSearch->ViewValue = $this->pa_process_04->Lookup !== null && is_array($this->pa_process_04->lookupOptions()) && count($this->pa_process_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_04->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pa_process_04->EditValue = array_values($this->pa_process_04->lookupOptions());
                if ($this->pa_process_04->AdvancedSearch->ViewValue == "") {
                    $this->pa_process_04->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_04->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_04->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_04->Lookup->renderViewRow($row);
                        $this->pa_process_04->AdvancedSearch->ViewValue->add($this->pa_process_04->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_04->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_04->EditValue = $arwrk;
            }
            $this->pa_process_04->PlaceHolder = RemoveHtml($this->pa_process_04->caption());
            $curVal = trim(strval($this->pa_process_04->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->pa_process_04->AdvancedSearch->ViewValue2 = $this->pa_process_04->lookupCacheOption($curVal);
            } else {
                $this->pa_process_04->AdvancedSearch->ViewValue2 = $this->pa_process_04->Lookup !== null && is_array($this->pa_process_04->lookupOptions()) && count($this->pa_process_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_04->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->pa_process_04->EditValue2 = array_values($this->pa_process_04->lookupOptions());
                if ($this->pa_process_04->AdvancedSearch->ViewValue2 == "") {
                    $this->pa_process_04->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_04->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_04->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_04->Lookup->renderViewRow($row);
                        $this->pa_process_04->AdvancedSearch->ViewValue2->add($this->pa_process_04->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_04->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_04->EditValue2 = $arwrk;
            }
            $this->pa_process_04->PlaceHolder = RemoveHtml($this->pa_process_04->caption());

            // pa_head_05
            $this->pa_head_05->setupEditAttributes();
            if (!$this->pa_head_05->Raw) {
                $this->pa_head_05->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_05->AdvancedSearch->SearchValue);
            }
            $this->pa_head_05->EditValue = HtmlEncode($this->pa_head_05->AdvancedSearch->SearchValue);
            $this->pa_head_05->PlaceHolder = RemoveHtml($this->pa_head_05->caption());

            // pa_process_05
            $curVal = trim(strval($this->pa_process_05->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pa_process_05->AdvancedSearch->ViewValue = $this->pa_process_05->lookupCacheOption($curVal);
            } else {
                $this->pa_process_05->AdvancedSearch->ViewValue = $this->pa_process_05->Lookup !== null && is_array($this->pa_process_05->lookupOptions()) && count($this->pa_process_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_05->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pa_process_05->EditValue = array_values($this->pa_process_05->lookupOptions());
                if ($this->pa_process_05->AdvancedSearch->ViewValue == "") {
                    $this->pa_process_05->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_05->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_05->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_05->Lookup->renderViewRow($row);
                        $this->pa_process_05->AdvancedSearch->ViewValue->add($this->pa_process_05->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_05->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_05->EditValue = $arwrk;
            }
            $this->pa_process_05->PlaceHolder = RemoveHtml($this->pa_process_05->caption());
            $curVal = trim(strval($this->pa_process_05->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->pa_process_05->AdvancedSearch->ViewValue2 = $this->pa_process_05->lookupCacheOption($curVal);
            } else {
                $this->pa_process_05->AdvancedSearch->ViewValue2 = $this->pa_process_05->Lookup !== null && is_array($this->pa_process_05->lookupOptions()) && count($this->pa_process_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_05->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->pa_process_05->EditValue2 = array_values($this->pa_process_05->lookupOptions());
                if ($this->pa_process_05->AdvancedSearch->ViewValue2 == "") {
                    $this->pa_process_05->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_05->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_05->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_05->Lookup->renderViewRow($row);
                        $this->pa_process_05->AdvancedSearch->ViewValue2->add($this->pa_process_05->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_05->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_05->EditValue2 = $arwrk;
            }
            $this->pa_process_05->PlaceHolder = RemoveHtml($this->pa_process_05->caption());

            // pa_head_06
            $this->pa_head_06->setupEditAttributes();
            if (!$this->pa_head_06->Raw) {
                $this->pa_head_06->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_06->AdvancedSearch->SearchValue);
            }
            $this->pa_head_06->EditValue = HtmlEncode($this->pa_head_06->AdvancedSearch->SearchValue);
            $this->pa_head_06->PlaceHolder = RemoveHtml($this->pa_head_06->caption());

            // pa_process_06
            $curVal = trim(strval($this->pa_process_06->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pa_process_06->AdvancedSearch->ViewValue = $this->pa_process_06->lookupCacheOption($curVal);
            } else {
                $this->pa_process_06->AdvancedSearch->ViewValue = $this->pa_process_06->Lookup !== null && is_array($this->pa_process_06->lookupOptions()) && count($this->pa_process_06->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_06->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pa_process_06->EditValue = array_values($this->pa_process_06->lookupOptions());
                if ($this->pa_process_06->AdvancedSearch->ViewValue == "") {
                    $this->pa_process_06->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_06->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_06->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_06->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_06->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_06->Lookup->renderViewRow($row);
                        $this->pa_process_06->AdvancedSearch->ViewValue->add($this->pa_process_06->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_06->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_06->EditValue = $arwrk;
            }
            $this->pa_process_06->PlaceHolder = RemoveHtml($this->pa_process_06->caption());
            $curVal = trim(strval($this->pa_process_06->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->pa_process_06->AdvancedSearch->ViewValue2 = $this->pa_process_06->lookupCacheOption($curVal);
            } else {
                $this->pa_process_06->AdvancedSearch->ViewValue2 = $this->pa_process_06->Lookup !== null && is_array($this->pa_process_06->lookupOptions()) && count($this->pa_process_06->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_06->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->pa_process_06->EditValue2 = array_values($this->pa_process_06->lookupOptions());
                if ($this->pa_process_06->AdvancedSearch->ViewValue2 == "") {
                    $this->pa_process_06->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_06->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_06->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_06->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_06->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_06->Lookup->renderViewRow($row);
                        $this->pa_process_06->AdvancedSearch->ViewValue2->add($this->pa_process_06->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_06->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_06->EditValue2 = $arwrk;
            }
            $this->pa_process_06->PlaceHolder = RemoveHtml($this->pa_process_06->caption());

            // pa_head_07
            $this->pa_head_07->setupEditAttributes();
            if (!$this->pa_head_07->Raw) {
                $this->pa_head_07->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_07->AdvancedSearch->SearchValue);
            }
            $this->pa_head_07->EditValue = HtmlEncode($this->pa_head_07->AdvancedSearch->SearchValue);
            $this->pa_head_07->PlaceHolder = RemoveHtml($this->pa_head_07->caption());

            // pa_process_07
            $curVal = trim(strval($this->pa_process_07->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pa_process_07->AdvancedSearch->ViewValue = $this->pa_process_07->lookupCacheOption($curVal);
            } else {
                $this->pa_process_07->AdvancedSearch->ViewValue = $this->pa_process_07->Lookup !== null && is_array($this->pa_process_07->lookupOptions()) && count($this->pa_process_07->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_07->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pa_process_07->EditValue = array_values($this->pa_process_07->lookupOptions());
                if ($this->pa_process_07->AdvancedSearch->ViewValue == "") {
                    $this->pa_process_07->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_07->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_07->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_07->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_07->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_07->Lookup->renderViewRow($row);
                        $this->pa_process_07->AdvancedSearch->ViewValue->add($this->pa_process_07->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_07->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_07->EditValue = $arwrk;
            }
            $this->pa_process_07->PlaceHolder = RemoveHtml($this->pa_process_07->caption());
            $curVal = trim(strval($this->pa_process_07->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->pa_process_07->AdvancedSearch->ViewValue2 = $this->pa_process_07->lookupCacheOption($curVal);
            } else {
                $this->pa_process_07->AdvancedSearch->ViewValue2 = $this->pa_process_07->Lookup !== null && is_array($this->pa_process_07->lookupOptions()) && count($this->pa_process_07->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_07->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->pa_process_07->EditValue2 = array_values($this->pa_process_07->lookupOptions());
                if ($this->pa_process_07->AdvancedSearch->ViewValue2 == "") {
                    $this->pa_process_07->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_07->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_07->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_07->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_07->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_07->Lookup->renderViewRow($row);
                        $this->pa_process_07->AdvancedSearch->ViewValue2->add($this->pa_process_07->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_07->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_07->EditValue2 = $arwrk;
            }
            $this->pa_process_07->PlaceHolder = RemoveHtml($this->pa_process_07->caption());

            // pa_head_08
            $this->pa_head_08->setupEditAttributes();
            if (!$this->pa_head_08->Raw) {
                $this->pa_head_08->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_08->AdvancedSearch->SearchValue);
            }
            $this->pa_head_08->EditValue = HtmlEncode($this->pa_head_08->AdvancedSearch->SearchValue);
            $this->pa_head_08->PlaceHolder = RemoveHtml($this->pa_head_08->caption());

            // pa_process_08
            $curVal = trim(strval($this->pa_process_08->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pa_process_08->AdvancedSearch->ViewValue = $this->pa_process_08->lookupCacheOption($curVal);
            } else {
                $this->pa_process_08->AdvancedSearch->ViewValue = $this->pa_process_08->Lookup !== null && is_array($this->pa_process_08->lookupOptions()) && count($this->pa_process_08->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_08->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pa_process_08->EditValue = array_values($this->pa_process_08->lookupOptions());
                if ($this->pa_process_08->AdvancedSearch->ViewValue == "") {
                    $this->pa_process_08->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_08->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_08->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_08->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_08->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_08->Lookup->renderViewRow($row);
                        $this->pa_process_08->AdvancedSearch->ViewValue->add($this->pa_process_08->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_08->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_08->EditValue = $arwrk;
            }
            $this->pa_process_08->PlaceHolder = RemoveHtml($this->pa_process_08->caption());
            $curVal = trim(strval($this->pa_process_08->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->pa_process_08->AdvancedSearch->ViewValue2 = $this->pa_process_08->lookupCacheOption($curVal);
            } else {
                $this->pa_process_08->AdvancedSearch->ViewValue2 = $this->pa_process_08->Lookup !== null && is_array($this->pa_process_08->lookupOptions()) && count($this->pa_process_08->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_08->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->pa_process_08->EditValue2 = array_values($this->pa_process_08->lookupOptions());
                if ($this->pa_process_08->AdvancedSearch->ViewValue2 == "") {
                    $this->pa_process_08->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_08->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_08->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_08->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_08->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_08->Lookup->renderViewRow($row);
                        $this->pa_process_08->AdvancedSearch->ViewValue2->add($this->pa_process_08->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_08->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_08->EditValue2 = $arwrk;
            }
            $this->pa_process_08->PlaceHolder = RemoveHtml($this->pa_process_08->caption());

            // pa_head_09
            $this->pa_head_09->setupEditAttributes();
            if (!$this->pa_head_09->Raw) {
                $this->pa_head_09->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_09->AdvancedSearch->SearchValue);
            }
            $this->pa_head_09->EditValue = HtmlEncode($this->pa_head_09->AdvancedSearch->SearchValue);
            $this->pa_head_09->PlaceHolder = RemoveHtml($this->pa_head_09->caption());

            // pa_process_09
            $curVal = trim(strval($this->pa_process_09->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pa_process_09->AdvancedSearch->ViewValue = $this->pa_process_09->lookupCacheOption($curVal);
            } else {
                $this->pa_process_09->AdvancedSearch->ViewValue = $this->pa_process_09->Lookup !== null && is_array($this->pa_process_09->lookupOptions()) && count($this->pa_process_09->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_09->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pa_process_09->EditValue = array_values($this->pa_process_09->lookupOptions());
                if ($this->pa_process_09->AdvancedSearch->ViewValue == "") {
                    $this->pa_process_09->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_09->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_09->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_09->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_09->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_09->Lookup->renderViewRow($row);
                        $this->pa_process_09->AdvancedSearch->ViewValue->add($this->pa_process_09->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_09->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_09->EditValue = $arwrk;
            }
            $this->pa_process_09->PlaceHolder = RemoveHtml($this->pa_process_09->caption());
            $curVal = trim(strval($this->pa_process_09->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->pa_process_09->AdvancedSearch->ViewValue2 = $this->pa_process_09->lookupCacheOption($curVal);
            } else {
                $this->pa_process_09->AdvancedSearch->ViewValue2 = $this->pa_process_09->Lookup !== null && is_array($this->pa_process_09->lookupOptions()) && count($this->pa_process_09->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_09->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->pa_process_09->EditValue2 = array_values($this->pa_process_09->lookupOptions());
                if ($this->pa_process_09->AdvancedSearch->ViewValue2 == "") {
                    $this->pa_process_09->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_09->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_09->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_09->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_09->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_09->Lookup->renderViewRow($row);
                        $this->pa_process_09->AdvancedSearch->ViewValue2->add($this->pa_process_09->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_09->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_09->EditValue2 = $arwrk;
            }
            $this->pa_process_09->PlaceHolder = RemoveHtml($this->pa_process_09->caption());

            // pa_head_10
            $this->pa_head_10->setupEditAttributes();
            if (!$this->pa_head_10->Raw) {
                $this->pa_head_10->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_10->AdvancedSearch->SearchValue);
            }
            $this->pa_head_10->EditValue = HtmlEncode($this->pa_head_10->AdvancedSearch->SearchValue);
            $this->pa_head_10->PlaceHolder = RemoveHtml($this->pa_head_10->caption());

            // pa_process_10
            $curVal = trim(strval($this->pa_process_10->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pa_process_10->AdvancedSearch->ViewValue = $this->pa_process_10->lookupCacheOption($curVal);
            } else {
                $this->pa_process_10->AdvancedSearch->ViewValue = $this->pa_process_10->Lookup !== null && is_array($this->pa_process_10->lookupOptions()) && count($this->pa_process_10->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_10->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pa_process_10->EditValue = array_values($this->pa_process_10->lookupOptions());
                if ($this->pa_process_10->AdvancedSearch->ViewValue == "") {
                    $this->pa_process_10->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_10->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_10->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_10->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_10->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_10->Lookup->renderViewRow($row);
                        $this->pa_process_10->AdvancedSearch->ViewValue->add($this->pa_process_10->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_10->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_10->EditValue = $arwrk;
            }
            $this->pa_process_10->PlaceHolder = RemoveHtml($this->pa_process_10->caption());
            $curVal = trim(strval($this->pa_process_10->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->pa_process_10->AdvancedSearch->ViewValue2 = $this->pa_process_10->lookupCacheOption($curVal);
            } else {
                $this->pa_process_10->AdvancedSearch->ViewValue2 = $this->pa_process_10->Lookup !== null && is_array($this->pa_process_10->lookupOptions()) && count($this->pa_process_10->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_10->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->pa_process_10->EditValue2 = array_values($this->pa_process_10->lookupOptions());
                if ($this->pa_process_10->AdvancedSearch->ViewValue2 == "") {
                    $this->pa_process_10->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_10->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_10->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_10->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_10->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_10->Lookup->renderViewRow($row);
                        $this->pa_process_10->AdvancedSearch->ViewValue2->add($this->pa_process_10->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_10->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_10->EditValue2 = $arwrk;
            }
            $this->pa_process_10->PlaceHolder = RemoveHtml($this->pa_process_10->caption());

            // publish
            $this->publish->setupEditAttributes();
            $this->publish->EditValue = $this->publish->AdvancedSearch->SearchValue;
            $this->publish->PlaceHolder = RemoveHtml($this->publish->caption());

            // ppr_01
            $this->ppr_01->setupEditAttributes();
            if (!$this->ppr_01->Raw) {
                $this->ppr_01->AdvancedSearch->SearchValue = HtmlDecode($this->ppr_01->AdvancedSearch->SearchValue);
            }
            $this->ppr_01->EditValue = HtmlEncode($this->ppr_01->AdvancedSearch->SearchValue);
            $this->ppr_01->PlaceHolder = RemoveHtml($this->ppr_01->caption());

            // ppr_02
            $this->ppr_02->setupEditAttributes();
            if (!$this->ppr_02->Raw) {
                $this->ppr_02->AdvancedSearch->SearchValue = HtmlDecode($this->ppr_02->AdvancedSearch->SearchValue);
            }
            $this->ppr_02->EditValue = HtmlEncode($this->ppr_02->AdvancedSearch->SearchValue);
            $this->ppr_02->PlaceHolder = RemoveHtml($this->ppr_02->caption());

            // ppr_03
            $this->ppr_03->setupEditAttributes();
            if (!$this->ppr_03->Raw) {
                $this->ppr_03->AdvancedSearch->SearchValue = HtmlDecode($this->ppr_03->AdvancedSearch->SearchValue);
            }
            $this->ppr_03->EditValue = HtmlEncode($this->ppr_03->AdvancedSearch->SearchValue);
            $this->ppr_03->PlaceHolder = RemoveHtml($this->ppr_03->caption());

            // ppr_04
            $this->ppr_04->setupEditAttributes();
            if (!$this->ppr_04->Raw) {
                $this->ppr_04->AdvancedSearch->SearchValue = HtmlDecode($this->ppr_04->AdvancedSearch->SearchValue);
            }
            $this->ppr_04->EditValue = HtmlEncode($this->ppr_04->AdvancedSearch->SearchValue);
            $this->ppr_04->PlaceHolder = RemoveHtml($this->ppr_04->caption());

            // ppr_05
            $this->ppr_05->setupEditAttributes();
            if (!$this->ppr_05->Raw) {
                $this->ppr_05->AdvancedSearch->SearchValue = HtmlDecode($this->ppr_05->AdvancedSearch->SearchValue);
            }
            $this->ppr_05->EditValue = HtmlEncode($this->ppr_05->AdvancedSearch->SearchValue);
            $this->ppr_05->PlaceHolder = RemoveHtml($this->ppr_05->caption());

            // ppr_06
            $this->ppr_06->setupEditAttributes();
            if (!$this->ppr_06->Raw) {
                $this->ppr_06->AdvancedSearch->SearchValue = HtmlDecode($this->ppr_06->AdvancedSearch->SearchValue);
            }
            $this->ppr_06->EditValue = HtmlEncode($this->ppr_06->AdvancedSearch->SearchValue);
            $this->ppr_06->PlaceHolder = RemoveHtml($this->ppr_06->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->publish->AdvancedSearch->SearchValue)) {
            $this->publish->addErrorMessage($this->publish->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->product_group->AdvancedSearch->load();
        $this->calculation_method->AdvancedSearch->load();
        $this->shape->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->process->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->v_00->AdvancedSearch->load();
        $this->v_01->AdvancedSearch->load();
        $this->v_01_validation->AdvancedSearch->load();
        $this->v_02->AdvancedSearch->load();
        $this->v_02_validation->AdvancedSearch->load();
        $this->v_03->AdvancedSearch->load();
        $this->v_03_validation->AdvancedSearch->load();
        $this->v_04->AdvancedSearch->load();
        $this->v_04_validation->AdvancedSearch->load();
        $this->v_05->AdvancedSearch->load();
        $this->v_05_validation->AdvancedSearch->load();
        $this->v_06->AdvancedSearch->load();
        $this->v_06_validation->AdvancedSearch->load();
        $this->v_07->AdvancedSearch->load();
        $this->v_07_validation->AdvancedSearch->load();
        $this->v_08->AdvancedSearch->load();
        $this->v_08_validation->AdvancedSearch->load();
        $this->v_09->AdvancedSearch->load();
        $this->v_09_validation->AdvancedSearch->load();
        $this->v_10->AdvancedSearch->load();
        $this->v_10_validation->AdvancedSearch->load();
        $this->b_01_head->AdvancedSearch->load();
        $this->b_02_head->AdvancedSearch->load();
        $this->b_03_head->AdvancedSearch->load();
        $this->b_04_head->AdvancedSearch->load();
        $this->b_05_head->AdvancedSearch->load();
        $this->b_06_head->AdvancedSearch->load();
        $this->b_07_head->AdvancedSearch->load();
        $this->b_08_head->AdvancedSearch->load();
        $this->b_09_head->AdvancedSearch->load();
        $this->b_10_head->AdvancedSearch->load();
        $this->b_11_head->AdvancedSearch->load();
        $this->b_12_head->AdvancedSearch->load();
        $this->b_13_head->AdvancedSearch->load();
        $this->b_14_head->AdvancedSearch->load();
        $this->b_15_head->AdvancedSearch->load();
        $this->q_sku->AdvancedSearch->load();
        $this->t_01_head->AdvancedSearch->load();
        $this->t_02_head->AdvancedSearch->load();
        $this->t_03_head->AdvancedSearch->load();
        $this->t_04_head->AdvancedSearch->load();
        $this->t_05_head->AdvancedSearch->load();
        $this->t_06_head->AdvancedSearch->load();
        $this->t_07_head->AdvancedSearch->load();
        $this->t_08_head->AdvancedSearch->load();
        $this->t_09_head->AdvancedSearch->load();
        $this->t_10_head->AdvancedSearch->load();
        $this->t_11_head->AdvancedSearch->load();
        $this->t_12_head->AdvancedSearch->load();
        $this->t_13_head->AdvancedSearch->load();
        $this->t_14_head->AdvancedSearch->load();
        $this->t_15_head->AdvancedSearch->load();
        $this->po_01_head->AdvancedSearch->load();
        $this->po_02_head->AdvancedSearch->load();
        $this->po_03_head->AdvancedSearch->load();
        $this->po_04_head->AdvancedSearch->load();
        $this->po_05_head->AdvancedSearch->load();
        $this->po_06_head->AdvancedSearch->load();
        $this->po_07_head->AdvancedSearch->load();
        $this->po_08_head->AdvancedSearch->load();
        $this->po_17_head->AdvancedSearch->load();
        $this->po_18_head->AdvancedSearch->load();
        $this->po_19_head->AdvancedSearch->load();
        $this->po_20_head->AdvancedSearch->load();
        $this->jc_01_head->AdvancedSearch->load();
        $this->jc_02_head->AdvancedSearch->load();
        $this->jc_03_head->AdvancedSearch->load();
        $this->jc_04_head->AdvancedSearch->load();
        $this->jc_05_head->AdvancedSearch->load();
        $this->jc_06_head->AdvancedSearch->load();
        $this->jc_07_head->AdvancedSearch->load();
        $this->jc_08_head->AdvancedSearch->load();
        $this->jc_09_head->AdvancedSearch->load();
        $this->jc_10_head->AdvancedSearch->load();
        $this->pc_shape->AdvancedSearch->load();
        $this->pc_unit->AdvancedSearch->load();
        $this->pc_w->AdvancedSearch->load();
        $this->pc_l->AdvancedSearch->load();
        $this->pc_h->AdvancedSearch->load();
        $this->pc_partner_size->AdvancedSearch->load();
        $this->pc_sqm->AdvancedSearch->load();
        $this->pc_01_head->AdvancedSearch->load();
        $this->pc_02_head->AdvancedSearch->load();
        $this->pc_03_head->AdvancedSearch->load();
        $this->pc_04_head->AdvancedSearch->load();
        $this->pc_05_head->AdvancedSearch->load();
        $this->pc_06_head->AdvancedSearch->load();
        $this->pc_07_head->AdvancedSearch->load();
        $this->pc_08_head->AdvancedSearch->load();
        $this->pc_09_head->AdvancedSearch->load();
        $this->pc_10_head->AdvancedSearch->load();
        $this->pc_11_head->AdvancedSearch->load();
        $this->pc_12_head->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->image->AdvancedSearch->load();
        $this->pa_process_size_w->AdvancedSearch->load();
        $this->pa_process_size_l->AdvancedSearch->load();
        $this->pa_head_01->AdvancedSearch->load();
        $this->pa_process_01->AdvancedSearch->load();
        $this->pa_head_02->AdvancedSearch->load();
        $this->pa_process_02->AdvancedSearch->load();
        $this->pa_head_03->AdvancedSearch->load();
        $this->pa_process_03->AdvancedSearch->load();
        $this->pa_head_04->AdvancedSearch->load();
        $this->pa_process_04->AdvancedSearch->load();
        $this->pa_head_05->AdvancedSearch->load();
        $this->pa_process_05->AdvancedSearch->load();
        $this->pa_head_06->AdvancedSearch->load();
        $this->pa_process_06->AdvancedSearch->load();
        $this->pa_head_07->AdvancedSearch->load();
        $this->pa_process_07->AdvancedSearch->load();
        $this->pa_head_08->AdvancedSearch->load();
        $this->pa_process_08->AdvancedSearch->load();
        $this->pa_head_09->AdvancedSearch->load();
        $this->pa_process_09->AdvancedSearch->load();
        $this->pa_head_10->AdvancedSearch->load();
        $this->pa_process_10->AdvancedSearch->load();
        $this->publish->AdvancedSearch->load();
        $this->ppr_01->AdvancedSearch->load();
        $this->ppr_02->AdvancedSearch->load();
        $this->ppr_03->AdvancedSearch->load();
        $this->ppr_04->AdvancedSearch->load();
        $this->ppr_05->AdvancedSearch->load();
        $this->ppr_06->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("productgrouplist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "tabs";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $pages->add(6);
        $pages->add(7);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_calculation_method":
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_v_01_validation":
                    break;
                case "x_pa_process_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
