<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductGroupList extends ProductGroup
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductGroupList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fproduct_grouplist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "productgrouplist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->grp->setVisibility();
        $this->product_group->setVisibility();
        $this->calculation_method->setVisibility();
        $this->shape->setVisibility();
        $this->sqm->setVisibility();
        $this->cbm->setVisibility();
        $this->process->setVisibility();
        $this->status->setVisibility();
        $this->v_00->setVisibility();
        $this->v_01->setVisibility();
        $this->v_01_validation->setVisibility();
        $this->v_02->setVisibility();
        $this->v_02_validation->setVisibility();
        $this->v_03->setVisibility();
        $this->v_03_validation->setVisibility();
        $this->v_04->setVisibility();
        $this->v_04_validation->setVisibility();
        $this->v_05->setVisibility();
        $this->v_05_validation->setVisibility();
        $this->v_06->setVisibility();
        $this->v_06_validation->setVisibility();
        $this->v_07->setVisibility();
        $this->v_07_validation->setVisibility();
        $this->v_08->setVisibility();
        $this->v_08_validation->setVisibility();
        $this->v_09->setVisibility();
        $this->v_09_validation->setVisibility();
        $this->v_10->setVisibility();
        $this->v_10_validation->setVisibility();
        $this->b_01_head->setVisibility();
        $this->b_02_head->setVisibility();
        $this->b_03_head->setVisibility();
        $this->b_04_head->setVisibility();
        $this->b_05_head->setVisibility();
        $this->b_06_head->setVisibility();
        $this->b_07_head->setVisibility();
        $this->b_08_head->setVisibility();
        $this->b_09_head->setVisibility();
        $this->b_10_head->setVisibility();
        $this->b_11_head->setVisibility();
        $this->b_12_head->setVisibility();
        $this->b_13_head->setVisibility();
        $this->b_14_head->setVisibility();
        $this->b_15_head->setVisibility();
        $this->q_sku->setVisibility();
        $this->t_01_head->setVisibility();
        $this->t_02_head->setVisibility();
        $this->t_03_head->setVisibility();
        $this->t_04_head->setVisibility();
        $this->t_05_head->setVisibility();
        $this->t_06_head->setVisibility();
        $this->t_07_head->setVisibility();
        $this->t_08_head->setVisibility();
        $this->t_09_head->setVisibility();
        $this->t_10_head->setVisibility();
        $this->t_11_head->setVisibility();
        $this->t_12_head->setVisibility();
        $this->t_13_head->setVisibility();
        $this->t_14_head->setVisibility();
        $this->t_15_head->setVisibility();
        $this->po_01_head->setVisibility();
        $this->po_02_head->setVisibility();
        $this->po_03_head->setVisibility();
        $this->po_04_head->setVisibility();
        $this->po_05_head->setVisibility();
        $this->po_06_head->setVisibility();
        $this->po_07_head->setVisibility();
        $this->po_08_head->setVisibility();
        $this->po_17_head->setVisibility();
        $this->po_18_head->setVisibility();
        $this->po_19_head->setVisibility();
        $this->po_20_head->setVisibility();
        $this->jc_01_head->setVisibility();
        $this->jc_02_head->setVisibility();
        $this->jc_03_head->setVisibility();
        $this->jc_04_head->setVisibility();
        $this->jc_05_head->setVisibility();
        $this->jc_06_head->setVisibility();
        $this->jc_07_head->setVisibility();
        $this->jc_08_head->setVisibility();
        $this->jc_09_head->setVisibility();
        $this->jc_10_head->setVisibility();
        $this->pc_shape->setVisibility();
        $this->pc_unit->setVisibility();
        $this->pc_w->setVisibility();
        $this->pc_l->setVisibility();
        $this->pc_h->setVisibility();
        $this->pc_partner_size->setVisibility();
        $this->pc_sqm->setVisibility();
        $this->pc_01_head->setVisibility();
        $this->pc_02_head->setVisibility();
        $this->pc_03_head->setVisibility();
        $this->pc_04_head->setVisibility();
        $this->pc_05_head->setVisibility();
        $this->pc_06_head->setVisibility();
        $this->pc_07_head->setVisibility();
        $this->pc_08_head->setVisibility();
        $this->pc_09_head->setVisibility();
        $this->pc_10_head->setVisibility();
        $this->pc_11_head->setVisibility();
        $this->pc_12_head->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->image->setVisibility();
        $this->pa_process_size_w->setVisibility();
        $this->pa_process_size_l->setVisibility();
        $this->pa_head_01->setVisibility();
        $this->pa_process_01->setVisibility();
        $this->pa_head_02->setVisibility();
        $this->pa_process_02->setVisibility();
        $this->pa_head_03->setVisibility();
        $this->pa_process_03->setVisibility();
        $this->pa_head_04->setVisibility();
        $this->pa_process_04->setVisibility();
        $this->pa_head_05->setVisibility();
        $this->pa_process_05->setVisibility();
        $this->pa_head_06->setVisibility();
        $this->pa_process_06->setVisibility();
        $this->pa_head_07->setVisibility();
        $this->pa_process_07->setVisibility();
        $this->pa_head_08->setVisibility();
        $this->pa_process_08->setVisibility();
        $this->pa_head_09->setVisibility();
        $this->pa_process_09->setVisibility();
        $this->pa_head_10->setVisibility();
        $this->pa_process_10->setVisibility();
        $this->publish->setVisibility();
        $this->ppr_01->setVisibility();
        $this->ppr_02->setVisibility();
        $this->ppr_03->setVisibility();
        $this->ppr_04->setVisibility();
        $this->ppr_05->setVisibility();
        $this->ppr_06->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'product_group';
        $this->TableName = 'product_group';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (product_group)
        if (!isset($GLOBALS["product_group"]) || $GLOBALS["product_group"]::class == PROJECT_NAMESPACE . "product_group") {
            $GLOBALS["product_group"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "productgroupadd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "productgroupdelete";
        $this->MultiUpdateUrl = "productgroupupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_group');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "productgroupview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->calculation_method);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->v_01_validation);
        $this->setupLookupOptions($this->pa_process_01);
        $this->setupLookupOptions($this->pa_process_02);
        $this->setupLookupOptions($this->pa_process_03);
        $this->setupLookupOptions($this->pa_process_04);
        $this->setupLookupOptions($this->pa_process_05);
        $this->setupLookupOptions($this->pa_process_06);
        $this->setupLookupOptions($this->pa_process_07);
        $this->setupLookupOptions($this->pa_process_08);
        $this->setupLookupOptions($this->pa_process_09);
        $this->setupLookupOptions($this->pa_process_10);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fproduct_groupgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fproduct_groupsrch");
        }
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
        $filterList = Concat($filterList, $this->product_group->AdvancedSearch->toJson(), ","); // Field product_group
        $filterList = Concat($filterList, $this->calculation_method->AdvancedSearch->toJson(), ","); // Field calculation_method
        $filterList = Concat($filterList, $this->shape->AdvancedSearch->toJson(), ","); // Field shape
        $filterList = Concat($filterList, $this->sqm->AdvancedSearch->toJson(), ","); // Field sqm
        $filterList = Concat($filterList, $this->cbm->AdvancedSearch->toJson(), ","); // Field cbm
        $filterList = Concat($filterList, $this->process->AdvancedSearch->toJson(), ","); // Field process
        $filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
        $filterList = Concat($filterList, $this->v_00->AdvancedSearch->toJson(), ","); // Field v_00
        $filterList = Concat($filterList, $this->v_01->AdvancedSearch->toJson(), ","); // Field v_01
        $filterList = Concat($filterList, $this->v_01_validation->AdvancedSearch->toJson(), ","); // Field v_01_validation
        $filterList = Concat($filterList, $this->v_02->AdvancedSearch->toJson(), ","); // Field v_02
        $filterList = Concat($filterList, $this->v_02_validation->AdvancedSearch->toJson(), ","); // Field v_02_validation
        $filterList = Concat($filterList, $this->v_03->AdvancedSearch->toJson(), ","); // Field v_03
        $filterList = Concat($filterList, $this->v_03_validation->AdvancedSearch->toJson(), ","); // Field v_03_validation
        $filterList = Concat($filterList, $this->v_04->AdvancedSearch->toJson(), ","); // Field v_04
        $filterList = Concat($filterList, $this->v_04_validation->AdvancedSearch->toJson(), ","); // Field v_04_validation
        $filterList = Concat($filterList, $this->v_05->AdvancedSearch->toJson(), ","); // Field v_05
        $filterList = Concat($filterList, $this->v_05_validation->AdvancedSearch->toJson(), ","); // Field v_05_validation
        $filterList = Concat($filterList, $this->v_06->AdvancedSearch->toJson(), ","); // Field v_06
        $filterList = Concat($filterList, $this->v_06_validation->AdvancedSearch->toJson(), ","); // Field v_06_validation
        $filterList = Concat($filterList, $this->v_07->AdvancedSearch->toJson(), ","); // Field v_07
        $filterList = Concat($filterList, $this->v_07_validation->AdvancedSearch->toJson(), ","); // Field v_07_validation
        $filterList = Concat($filterList, $this->v_08->AdvancedSearch->toJson(), ","); // Field v_08
        $filterList = Concat($filterList, $this->v_08_validation->AdvancedSearch->toJson(), ","); // Field v_08_validation
        $filterList = Concat($filterList, $this->v_09->AdvancedSearch->toJson(), ","); // Field v_09
        $filterList = Concat($filterList, $this->v_09_validation->AdvancedSearch->toJson(), ","); // Field v_09_validation
        $filterList = Concat($filterList, $this->v_10->AdvancedSearch->toJson(), ","); // Field v_10
        $filterList = Concat($filterList, $this->v_10_validation->AdvancedSearch->toJson(), ","); // Field v_10_validation
        $filterList = Concat($filterList, $this->b_01_head->AdvancedSearch->toJson(), ","); // Field b_01_head
        $filterList = Concat($filterList, $this->b_02_head->AdvancedSearch->toJson(), ","); // Field b_02_head
        $filterList = Concat($filterList, $this->b_03_head->AdvancedSearch->toJson(), ","); // Field b_03_head
        $filterList = Concat($filterList, $this->b_04_head->AdvancedSearch->toJson(), ","); // Field b_04_head
        $filterList = Concat($filterList, $this->b_05_head->AdvancedSearch->toJson(), ","); // Field b_05_head
        $filterList = Concat($filterList, $this->b_06_head->AdvancedSearch->toJson(), ","); // Field b_06_head
        $filterList = Concat($filterList, $this->b_07_head->AdvancedSearch->toJson(), ","); // Field b_07_head
        $filterList = Concat($filterList, $this->b_08_head->AdvancedSearch->toJson(), ","); // Field b_08_head
        $filterList = Concat($filterList, $this->b_09_head->AdvancedSearch->toJson(), ","); // Field b_09_head
        $filterList = Concat($filterList, $this->b_10_head->AdvancedSearch->toJson(), ","); // Field b_10_head
        $filterList = Concat($filterList, $this->b_11_head->AdvancedSearch->toJson(), ","); // Field b_11_head
        $filterList = Concat($filterList, $this->b_12_head->AdvancedSearch->toJson(), ","); // Field b_12_head
        $filterList = Concat($filterList, $this->b_13_head->AdvancedSearch->toJson(), ","); // Field b_13_head
        $filterList = Concat($filterList, $this->b_14_head->AdvancedSearch->toJson(), ","); // Field b_14_head
        $filterList = Concat($filterList, $this->b_15_head->AdvancedSearch->toJson(), ","); // Field b_15_head
        $filterList = Concat($filterList, $this->q_sku->AdvancedSearch->toJson(), ","); // Field q_sku
        $filterList = Concat($filterList, $this->t_01_head->AdvancedSearch->toJson(), ","); // Field t_01_head
        $filterList = Concat($filterList, $this->t_02_head->AdvancedSearch->toJson(), ","); // Field t_02_head
        $filterList = Concat($filterList, $this->t_03_head->AdvancedSearch->toJson(), ","); // Field t_03_head
        $filterList = Concat($filterList, $this->t_04_head->AdvancedSearch->toJson(), ","); // Field t_04_head
        $filterList = Concat($filterList, $this->t_05_head->AdvancedSearch->toJson(), ","); // Field t_05_head
        $filterList = Concat($filterList, $this->t_06_head->AdvancedSearch->toJson(), ","); // Field t_06_head
        $filterList = Concat($filterList, $this->t_07_head->AdvancedSearch->toJson(), ","); // Field t_07_head
        $filterList = Concat($filterList, $this->t_08_head->AdvancedSearch->toJson(), ","); // Field t_08_head
        $filterList = Concat($filterList, $this->t_09_head->AdvancedSearch->toJson(), ","); // Field t_09_head
        $filterList = Concat($filterList, $this->t_10_head->AdvancedSearch->toJson(), ","); // Field t_10_head
        $filterList = Concat($filterList, $this->t_11_head->AdvancedSearch->toJson(), ","); // Field t_11_head
        $filterList = Concat($filterList, $this->t_12_head->AdvancedSearch->toJson(), ","); // Field t_12_head
        $filterList = Concat($filterList, $this->t_13_head->AdvancedSearch->toJson(), ","); // Field t_13_head
        $filterList = Concat($filterList, $this->t_14_head->AdvancedSearch->toJson(), ","); // Field t_14_head
        $filterList = Concat($filterList, $this->t_15_head->AdvancedSearch->toJson(), ","); // Field t_15_head
        $filterList = Concat($filterList, $this->po_01_head->AdvancedSearch->toJson(), ","); // Field po_01_head
        $filterList = Concat($filterList, $this->po_02_head->AdvancedSearch->toJson(), ","); // Field po_02_head
        $filterList = Concat($filterList, $this->po_03_head->AdvancedSearch->toJson(), ","); // Field po_03_head
        $filterList = Concat($filterList, $this->po_04_head->AdvancedSearch->toJson(), ","); // Field po_04_head
        $filterList = Concat($filterList, $this->po_05_head->AdvancedSearch->toJson(), ","); // Field po_05_head
        $filterList = Concat($filterList, $this->po_06_head->AdvancedSearch->toJson(), ","); // Field po_06_head
        $filterList = Concat($filterList, $this->po_07_head->AdvancedSearch->toJson(), ","); // Field po_07_head
        $filterList = Concat($filterList, $this->po_08_head->AdvancedSearch->toJson(), ","); // Field po_08_head
        $filterList = Concat($filterList, $this->po_17_head->AdvancedSearch->toJson(), ","); // Field po_17_head
        $filterList = Concat($filterList, $this->po_18_head->AdvancedSearch->toJson(), ","); // Field po_18_head
        $filterList = Concat($filterList, $this->po_19_head->AdvancedSearch->toJson(), ","); // Field po_19_head
        $filterList = Concat($filterList, $this->po_20_head->AdvancedSearch->toJson(), ","); // Field po_20_head
        $filterList = Concat($filterList, $this->jc_01_head->AdvancedSearch->toJson(), ","); // Field jc_01_head
        $filterList = Concat($filterList, $this->jc_02_head->AdvancedSearch->toJson(), ","); // Field jc_02_head
        $filterList = Concat($filterList, $this->jc_03_head->AdvancedSearch->toJson(), ","); // Field jc_03_head
        $filterList = Concat($filterList, $this->jc_04_head->AdvancedSearch->toJson(), ","); // Field jc_04_head
        $filterList = Concat($filterList, $this->jc_05_head->AdvancedSearch->toJson(), ","); // Field jc_05_head
        $filterList = Concat($filterList, $this->jc_06_head->AdvancedSearch->toJson(), ","); // Field jc_06_head
        $filterList = Concat($filterList, $this->jc_07_head->AdvancedSearch->toJson(), ","); // Field jc_07_head
        $filterList = Concat($filterList, $this->jc_08_head->AdvancedSearch->toJson(), ","); // Field jc_08_head
        $filterList = Concat($filterList, $this->jc_09_head->AdvancedSearch->toJson(), ","); // Field jc_09_head
        $filterList = Concat($filterList, $this->jc_10_head->AdvancedSearch->toJson(), ","); // Field jc_10_head
        $filterList = Concat($filterList, $this->pc_shape->AdvancedSearch->toJson(), ","); // Field pc_shape
        $filterList = Concat($filterList, $this->pc_unit->AdvancedSearch->toJson(), ","); // Field pc_unit
        $filterList = Concat($filterList, $this->pc_w->AdvancedSearch->toJson(), ","); // Field pc_w
        $filterList = Concat($filterList, $this->pc_l->AdvancedSearch->toJson(), ","); // Field pc_l
        $filterList = Concat($filterList, $this->pc_h->AdvancedSearch->toJson(), ","); // Field pc_h
        $filterList = Concat($filterList, $this->pc_partner_size->AdvancedSearch->toJson(), ","); // Field pc_partner_size
        $filterList = Concat($filterList, $this->pc_sqm->AdvancedSearch->toJson(), ","); // Field pc_sqm
        $filterList = Concat($filterList, $this->pc_01_head->AdvancedSearch->toJson(), ","); // Field pc_01_head
        $filterList = Concat($filterList, $this->pc_02_head->AdvancedSearch->toJson(), ","); // Field pc_02_head
        $filterList = Concat($filterList, $this->pc_03_head->AdvancedSearch->toJson(), ","); // Field pc_03_head
        $filterList = Concat($filterList, $this->pc_04_head->AdvancedSearch->toJson(), ","); // Field pc_04_head
        $filterList = Concat($filterList, $this->pc_05_head->AdvancedSearch->toJson(), ","); // Field pc_05_head
        $filterList = Concat($filterList, $this->pc_06_head->AdvancedSearch->toJson(), ","); // Field pc_06_head
        $filterList = Concat($filterList, $this->pc_07_head->AdvancedSearch->toJson(), ","); // Field pc_07_head
        $filterList = Concat($filterList, $this->pc_08_head->AdvancedSearch->toJson(), ","); // Field pc_08_head
        $filterList = Concat($filterList, $this->pc_09_head->AdvancedSearch->toJson(), ","); // Field pc_09_head
        $filterList = Concat($filterList, $this->pc_10_head->AdvancedSearch->toJson(), ","); // Field pc_10_head
        $filterList = Concat($filterList, $this->pc_11_head->AdvancedSearch->toJson(), ","); // Field pc_11_head
        $filterList = Concat($filterList, $this->pc_12_head->AdvancedSearch->toJson(), ","); // Field pc_12_head
        $filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
        $filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
        $filterList = Concat($filterList, $this->image->AdvancedSearch->toJson(), ","); // Field image
        $filterList = Concat($filterList, $this->pa_process_size_w->AdvancedSearch->toJson(), ","); // Field pa_process_size_w
        $filterList = Concat($filterList, $this->pa_process_size_l->AdvancedSearch->toJson(), ","); // Field pa_process_size_l
        $filterList = Concat($filterList, $this->pa_head_01->AdvancedSearch->toJson(), ","); // Field pa_head_01
        $filterList = Concat($filterList, $this->pa_process_01->AdvancedSearch->toJson(), ","); // Field pa_process_01
        $filterList = Concat($filterList, $this->pa_head_02->AdvancedSearch->toJson(), ","); // Field pa_head_02
        $filterList = Concat($filterList, $this->pa_process_02->AdvancedSearch->toJson(), ","); // Field pa_process_02
        $filterList = Concat($filterList, $this->pa_head_03->AdvancedSearch->toJson(), ","); // Field pa_head_03
        $filterList = Concat($filterList, $this->pa_process_03->AdvancedSearch->toJson(), ","); // Field pa_process_03
        $filterList = Concat($filterList, $this->pa_head_04->AdvancedSearch->toJson(), ","); // Field pa_head_04
        $filterList = Concat($filterList, $this->pa_process_04->AdvancedSearch->toJson(), ","); // Field pa_process_04
        $filterList = Concat($filterList, $this->pa_head_05->AdvancedSearch->toJson(), ","); // Field pa_head_05
        $filterList = Concat($filterList, $this->pa_process_05->AdvancedSearch->toJson(), ","); // Field pa_process_05
        $filterList = Concat($filterList, $this->pa_head_06->AdvancedSearch->toJson(), ","); // Field pa_head_06
        $filterList = Concat($filterList, $this->pa_process_06->AdvancedSearch->toJson(), ","); // Field pa_process_06
        $filterList = Concat($filterList, $this->pa_head_07->AdvancedSearch->toJson(), ","); // Field pa_head_07
        $filterList = Concat($filterList, $this->pa_process_07->AdvancedSearch->toJson(), ","); // Field pa_process_07
        $filterList = Concat($filterList, $this->pa_head_08->AdvancedSearch->toJson(), ","); // Field pa_head_08
        $filterList = Concat($filterList, $this->pa_process_08->AdvancedSearch->toJson(), ","); // Field pa_process_08
        $filterList = Concat($filterList, $this->pa_head_09->AdvancedSearch->toJson(), ","); // Field pa_head_09
        $filterList = Concat($filterList, $this->pa_process_09->AdvancedSearch->toJson(), ","); // Field pa_process_09
        $filterList = Concat($filterList, $this->pa_head_10->AdvancedSearch->toJson(), ","); // Field pa_head_10
        $filterList = Concat($filterList, $this->pa_process_10->AdvancedSearch->toJson(), ","); // Field pa_process_10
        $filterList = Concat($filterList, $this->publish->AdvancedSearch->toJson(), ","); // Field publish
        $filterList = Concat($filterList, $this->ppr_01->AdvancedSearch->toJson(), ","); // Field ppr_01
        $filterList = Concat($filterList, $this->ppr_02->AdvancedSearch->toJson(), ","); // Field ppr_02
        $filterList = Concat($filterList, $this->ppr_03->AdvancedSearch->toJson(), ","); // Field ppr_03
        $filterList = Concat($filterList, $this->ppr_04->AdvancedSearch->toJson(), ","); // Field ppr_04
        $filterList = Concat($filterList, $this->ppr_05->AdvancedSearch->toJson(), ","); // Field ppr_05
        $filterList = Concat($filterList, $this->ppr_06->AdvancedSearch->toJson(), ","); // Field ppr_06
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fproduct_groupsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field grp
        $this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
        $this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
        $this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
        $this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
        $this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
        $this->grp->AdvancedSearch->save();

        // Field product_group
        $this->product_group->AdvancedSearch->SearchValue = @$filter["x_product_group"];
        $this->product_group->AdvancedSearch->SearchOperator = @$filter["z_product_group"];
        $this->product_group->AdvancedSearch->SearchCondition = @$filter["v_product_group"];
        $this->product_group->AdvancedSearch->SearchValue2 = @$filter["y_product_group"];
        $this->product_group->AdvancedSearch->SearchOperator2 = @$filter["w_product_group"];
        $this->product_group->AdvancedSearch->save();

        // Field calculation_method
        $this->calculation_method->AdvancedSearch->SearchValue = @$filter["x_calculation_method"];
        $this->calculation_method->AdvancedSearch->SearchOperator = @$filter["z_calculation_method"];
        $this->calculation_method->AdvancedSearch->SearchCondition = @$filter["v_calculation_method"];
        $this->calculation_method->AdvancedSearch->SearchValue2 = @$filter["y_calculation_method"];
        $this->calculation_method->AdvancedSearch->SearchOperator2 = @$filter["w_calculation_method"];
        $this->calculation_method->AdvancedSearch->save();

        // Field shape
        $this->shape->AdvancedSearch->SearchValue = @$filter["x_shape"];
        $this->shape->AdvancedSearch->SearchOperator = @$filter["z_shape"];
        $this->shape->AdvancedSearch->SearchCondition = @$filter["v_shape"];
        $this->shape->AdvancedSearch->SearchValue2 = @$filter["y_shape"];
        $this->shape->AdvancedSearch->SearchOperator2 = @$filter["w_shape"];
        $this->shape->AdvancedSearch->save();

        // Field sqm
        $this->sqm->AdvancedSearch->SearchValue = @$filter["x_sqm"];
        $this->sqm->AdvancedSearch->SearchOperator = @$filter["z_sqm"];
        $this->sqm->AdvancedSearch->SearchCondition = @$filter["v_sqm"];
        $this->sqm->AdvancedSearch->SearchValue2 = @$filter["y_sqm"];
        $this->sqm->AdvancedSearch->SearchOperator2 = @$filter["w_sqm"];
        $this->sqm->AdvancedSearch->save();

        // Field cbm
        $this->cbm->AdvancedSearch->SearchValue = @$filter["x_cbm"];
        $this->cbm->AdvancedSearch->SearchOperator = @$filter["z_cbm"];
        $this->cbm->AdvancedSearch->SearchCondition = @$filter["v_cbm"];
        $this->cbm->AdvancedSearch->SearchValue2 = @$filter["y_cbm"];
        $this->cbm->AdvancedSearch->SearchOperator2 = @$filter["w_cbm"];
        $this->cbm->AdvancedSearch->save();

        // Field process
        $this->process->AdvancedSearch->SearchValue = @$filter["x_process"];
        $this->process->AdvancedSearch->SearchOperator = @$filter["z_process"];
        $this->process->AdvancedSearch->SearchCondition = @$filter["v_process"];
        $this->process->AdvancedSearch->SearchValue2 = @$filter["y_process"];
        $this->process->AdvancedSearch->SearchOperator2 = @$filter["w_process"];
        $this->process->AdvancedSearch->save();

        // Field status
        $this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
        $this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
        $this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
        $this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
        $this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
        $this->status->AdvancedSearch->save();

        // Field v_00
        $this->v_00->AdvancedSearch->SearchValue = @$filter["x_v_00"];
        $this->v_00->AdvancedSearch->SearchOperator = @$filter["z_v_00"];
        $this->v_00->AdvancedSearch->SearchCondition = @$filter["v_v_00"];
        $this->v_00->AdvancedSearch->SearchValue2 = @$filter["y_v_00"];
        $this->v_00->AdvancedSearch->SearchOperator2 = @$filter["w_v_00"];
        $this->v_00->AdvancedSearch->save();

        // Field v_01
        $this->v_01->AdvancedSearch->SearchValue = @$filter["x_v_01"];
        $this->v_01->AdvancedSearch->SearchOperator = @$filter["z_v_01"];
        $this->v_01->AdvancedSearch->SearchCondition = @$filter["v_v_01"];
        $this->v_01->AdvancedSearch->SearchValue2 = @$filter["y_v_01"];
        $this->v_01->AdvancedSearch->SearchOperator2 = @$filter["w_v_01"];
        $this->v_01->AdvancedSearch->save();

        // Field v_01_validation
        $this->v_01_validation->AdvancedSearch->SearchValue = @$filter["x_v_01_validation"];
        $this->v_01_validation->AdvancedSearch->SearchOperator = @$filter["z_v_01_validation"];
        $this->v_01_validation->AdvancedSearch->SearchCondition = @$filter["v_v_01_validation"];
        $this->v_01_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_01_validation"];
        $this->v_01_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_01_validation"];
        $this->v_01_validation->AdvancedSearch->save();

        // Field v_02
        $this->v_02->AdvancedSearch->SearchValue = @$filter["x_v_02"];
        $this->v_02->AdvancedSearch->SearchOperator = @$filter["z_v_02"];
        $this->v_02->AdvancedSearch->SearchCondition = @$filter["v_v_02"];
        $this->v_02->AdvancedSearch->SearchValue2 = @$filter["y_v_02"];
        $this->v_02->AdvancedSearch->SearchOperator2 = @$filter["w_v_02"];
        $this->v_02->AdvancedSearch->save();

        // Field v_02_validation
        $this->v_02_validation->AdvancedSearch->SearchValue = @$filter["x_v_02_validation"];
        $this->v_02_validation->AdvancedSearch->SearchOperator = @$filter["z_v_02_validation"];
        $this->v_02_validation->AdvancedSearch->SearchCondition = @$filter["v_v_02_validation"];
        $this->v_02_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_02_validation"];
        $this->v_02_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_02_validation"];
        $this->v_02_validation->AdvancedSearch->save();

        // Field v_03
        $this->v_03->AdvancedSearch->SearchValue = @$filter["x_v_03"];
        $this->v_03->AdvancedSearch->SearchOperator = @$filter["z_v_03"];
        $this->v_03->AdvancedSearch->SearchCondition = @$filter["v_v_03"];
        $this->v_03->AdvancedSearch->SearchValue2 = @$filter["y_v_03"];
        $this->v_03->AdvancedSearch->SearchOperator2 = @$filter["w_v_03"];
        $this->v_03->AdvancedSearch->save();

        // Field v_03_validation
        $this->v_03_validation->AdvancedSearch->SearchValue = @$filter["x_v_03_validation"];
        $this->v_03_validation->AdvancedSearch->SearchOperator = @$filter["z_v_03_validation"];
        $this->v_03_validation->AdvancedSearch->SearchCondition = @$filter["v_v_03_validation"];
        $this->v_03_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_03_validation"];
        $this->v_03_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_03_validation"];
        $this->v_03_validation->AdvancedSearch->save();

        // Field v_04
        $this->v_04->AdvancedSearch->SearchValue = @$filter["x_v_04"];
        $this->v_04->AdvancedSearch->SearchOperator = @$filter["z_v_04"];
        $this->v_04->AdvancedSearch->SearchCondition = @$filter["v_v_04"];
        $this->v_04->AdvancedSearch->SearchValue2 = @$filter["y_v_04"];
        $this->v_04->AdvancedSearch->SearchOperator2 = @$filter["w_v_04"];
        $this->v_04->AdvancedSearch->save();

        // Field v_04_validation
        $this->v_04_validation->AdvancedSearch->SearchValue = @$filter["x_v_04_validation"];
        $this->v_04_validation->AdvancedSearch->SearchOperator = @$filter["z_v_04_validation"];
        $this->v_04_validation->AdvancedSearch->SearchCondition = @$filter["v_v_04_validation"];
        $this->v_04_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_04_validation"];
        $this->v_04_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_04_validation"];
        $this->v_04_validation->AdvancedSearch->save();

        // Field v_05
        $this->v_05->AdvancedSearch->SearchValue = @$filter["x_v_05"];
        $this->v_05->AdvancedSearch->SearchOperator = @$filter["z_v_05"];
        $this->v_05->AdvancedSearch->SearchCondition = @$filter["v_v_05"];
        $this->v_05->AdvancedSearch->SearchValue2 = @$filter["y_v_05"];
        $this->v_05->AdvancedSearch->SearchOperator2 = @$filter["w_v_05"];
        $this->v_05->AdvancedSearch->save();

        // Field v_05_validation
        $this->v_05_validation->AdvancedSearch->SearchValue = @$filter["x_v_05_validation"];
        $this->v_05_validation->AdvancedSearch->SearchOperator = @$filter["z_v_05_validation"];
        $this->v_05_validation->AdvancedSearch->SearchCondition = @$filter["v_v_05_validation"];
        $this->v_05_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_05_validation"];
        $this->v_05_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_05_validation"];
        $this->v_05_validation->AdvancedSearch->save();

        // Field v_06
        $this->v_06->AdvancedSearch->SearchValue = @$filter["x_v_06"];
        $this->v_06->AdvancedSearch->SearchOperator = @$filter["z_v_06"];
        $this->v_06->AdvancedSearch->SearchCondition = @$filter["v_v_06"];
        $this->v_06->AdvancedSearch->SearchValue2 = @$filter["y_v_06"];
        $this->v_06->AdvancedSearch->SearchOperator2 = @$filter["w_v_06"];
        $this->v_06->AdvancedSearch->save();

        // Field v_06_validation
        $this->v_06_validation->AdvancedSearch->SearchValue = @$filter["x_v_06_validation"];
        $this->v_06_validation->AdvancedSearch->SearchOperator = @$filter["z_v_06_validation"];
        $this->v_06_validation->AdvancedSearch->SearchCondition = @$filter["v_v_06_validation"];
        $this->v_06_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_06_validation"];
        $this->v_06_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_06_validation"];
        $this->v_06_validation->AdvancedSearch->save();

        // Field v_07
        $this->v_07->AdvancedSearch->SearchValue = @$filter["x_v_07"];
        $this->v_07->AdvancedSearch->SearchOperator = @$filter["z_v_07"];
        $this->v_07->AdvancedSearch->SearchCondition = @$filter["v_v_07"];
        $this->v_07->AdvancedSearch->SearchValue2 = @$filter["y_v_07"];
        $this->v_07->AdvancedSearch->SearchOperator2 = @$filter["w_v_07"];
        $this->v_07->AdvancedSearch->save();

        // Field v_07_validation
        $this->v_07_validation->AdvancedSearch->SearchValue = @$filter["x_v_07_validation"];
        $this->v_07_validation->AdvancedSearch->SearchOperator = @$filter["z_v_07_validation"];
        $this->v_07_validation->AdvancedSearch->SearchCondition = @$filter["v_v_07_validation"];
        $this->v_07_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_07_validation"];
        $this->v_07_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_07_validation"];
        $this->v_07_validation->AdvancedSearch->save();

        // Field v_08
        $this->v_08->AdvancedSearch->SearchValue = @$filter["x_v_08"];
        $this->v_08->AdvancedSearch->SearchOperator = @$filter["z_v_08"];
        $this->v_08->AdvancedSearch->SearchCondition = @$filter["v_v_08"];
        $this->v_08->AdvancedSearch->SearchValue2 = @$filter["y_v_08"];
        $this->v_08->AdvancedSearch->SearchOperator2 = @$filter["w_v_08"];
        $this->v_08->AdvancedSearch->save();

        // Field v_08_validation
        $this->v_08_validation->AdvancedSearch->SearchValue = @$filter["x_v_08_validation"];
        $this->v_08_validation->AdvancedSearch->SearchOperator = @$filter["z_v_08_validation"];
        $this->v_08_validation->AdvancedSearch->SearchCondition = @$filter["v_v_08_validation"];
        $this->v_08_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_08_validation"];
        $this->v_08_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_08_validation"];
        $this->v_08_validation->AdvancedSearch->save();

        // Field v_09
        $this->v_09->AdvancedSearch->SearchValue = @$filter["x_v_09"];
        $this->v_09->AdvancedSearch->SearchOperator = @$filter["z_v_09"];
        $this->v_09->AdvancedSearch->SearchCondition = @$filter["v_v_09"];
        $this->v_09->AdvancedSearch->SearchValue2 = @$filter["y_v_09"];
        $this->v_09->AdvancedSearch->SearchOperator2 = @$filter["w_v_09"];
        $this->v_09->AdvancedSearch->save();

        // Field v_09_validation
        $this->v_09_validation->AdvancedSearch->SearchValue = @$filter["x_v_09_validation"];
        $this->v_09_validation->AdvancedSearch->SearchOperator = @$filter["z_v_09_validation"];
        $this->v_09_validation->AdvancedSearch->SearchCondition = @$filter["v_v_09_validation"];
        $this->v_09_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_09_validation"];
        $this->v_09_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_09_validation"];
        $this->v_09_validation->AdvancedSearch->save();

        // Field v_10
        $this->v_10->AdvancedSearch->SearchValue = @$filter["x_v_10"];
        $this->v_10->AdvancedSearch->SearchOperator = @$filter["z_v_10"];
        $this->v_10->AdvancedSearch->SearchCondition = @$filter["v_v_10"];
        $this->v_10->AdvancedSearch->SearchValue2 = @$filter["y_v_10"];
        $this->v_10->AdvancedSearch->SearchOperator2 = @$filter["w_v_10"];
        $this->v_10->AdvancedSearch->save();

        // Field v_10_validation
        $this->v_10_validation->AdvancedSearch->SearchValue = @$filter["x_v_10_validation"];
        $this->v_10_validation->AdvancedSearch->SearchOperator = @$filter["z_v_10_validation"];
        $this->v_10_validation->AdvancedSearch->SearchCondition = @$filter["v_v_10_validation"];
        $this->v_10_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_10_validation"];
        $this->v_10_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_10_validation"];
        $this->v_10_validation->AdvancedSearch->save();

        // Field b_01_head
        $this->b_01_head->AdvancedSearch->SearchValue = @$filter["x_b_01_head"];
        $this->b_01_head->AdvancedSearch->SearchOperator = @$filter["z_b_01_head"];
        $this->b_01_head->AdvancedSearch->SearchCondition = @$filter["v_b_01_head"];
        $this->b_01_head->AdvancedSearch->SearchValue2 = @$filter["y_b_01_head"];
        $this->b_01_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_01_head"];
        $this->b_01_head->AdvancedSearch->save();

        // Field b_02_head
        $this->b_02_head->AdvancedSearch->SearchValue = @$filter["x_b_02_head"];
        $this->b_02_head->AdvancedSearch->SearchOperator = @$filter["z_b_02_head"];
        $this->b_02_head->AdvancedSearch->SearchCondition = @$filter["v_b_02_head"];
        $this->b_02_head->AdvancedSearch->SearchValue2 = @$filter["y_b_02_head"];
        $this->b_02_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_02_head"];
        $this->b_02_head->AdvancedSearch->save();

        // Field b_03_head
        $this->b_03_head->AdvancedSearch->SearchValue = @$filter["x_b_03_head"];
        $this->b_03_head->AdvancedSearch->SearchOperator = @$filter["z_b_03_head"];
        $this->b_03_head->AdvancedSearch->SearchCondition = @$filter["v_b_03_head"];
        $this->b_03_head->AdvancedSearch->SearchValue2 = @$filter["y_b_03_head"];
        $this->b_03_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_03_head"];
        $this->b_03_head->AdvancedSearch->save();

        // Field b_04_head
        $this->b_04_head->AdvancedSearch->SearchValue = @$filter["x_b_04_head"];
        $this->b_04_head->AdvancedSearch->SearchOperator = @$filter["z_b_04_head"];
        $this->b_04_head->AdvancedSearch->SearchCondition = @$filter["v_b_04_head"];
        $this->b_04_head->AdvancedSearch->SearchValue2 = @$filter["y_b_04_head"];
        $this->b_04_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_04_head"];
        $this->b_04_head->AdvancedSearch->save();

        // Field b_05_head
        $this->b_05_head->AdvancedSearch->SearchValue = @$filter["x_b_05_head"];
        $this->b_05_head->AdvancedSearch->SearchOperator = @$filter["z_b_05_head"];
        $this->b_05_head->AdvancedSearch->SearchCondition = @$filter["v_b_05_head"];
        $this->b_05_head->AdvancedSearch->SearchValue2 = @$filter["y_b_05_head"];
        $this->b_05_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_05_head"];
        $this->b_05_head->AdvancedSearch->save();

        // Field b_06_head
        $this->b_06_head->AdvancedSearch->SearchValue = @$filter["x_b_06_head"];
        $this->b_06_head->AdvancedSearch->SearchOperator = @$filter["z_b_06_head"];
        $this->b_06_head->AdvancedSearch->SearchCondition = @$filter["v_b_06_head"];
        $this->b_06_head->AdvancedSearch->SearchValue2 = @$filter["y_b_06_head"];
        $this->b_06_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_06_head"];
        $this->b_06_head->AdvancedSearch->save();

        // Field b_07_head
        $this->b_07_head->AdvancedSearch->SearchValue = @$filter["x_b_07_head"];
        $this->b_07_head->AdvancedSearch->SearchOperator = @$filter["z_b_07_head"];
        $this->b_07_head->AdvancedSearch->SearchCondition = @$filter["v_b_07_head"];
        $this->b_07_head->AdvancedSearch->SearchValue2 = @$filter["y_b_07_head"];
        $this->b_07_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_07_head"];
        $this->b_07_head->AdvancedSearch->save();

        // Field b_08_head
        $this->b_08_head->AdvancedSearch->SearchValue = @$filter["x_b_08_head"];
        $this->b_08_head->AdvancedSearch->SearchOperator = @$filter["z_b_08_head"];
        $this->b_08_head->AdvancedSearch->SearchCondition = @$filter["v_b_08_head"];
        $this->b_08_head->AdvancedSearch->SearchValue2 = @$filter["y_b_08_head"];
        $this->b_08_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_08_head"];
        $this->b_08_head->AdvancedSearch->save();

        // Field b_09_head
        $this->b_09_head->AdvancedSearch->SearchValue = @$filter["x_b_09_head"];
        $this->b_09_head->AdvancedSearch->SearchOperator = @$filter["z_b_09_head"];
        $this->b_09_head->AdvancedSearch->SearchCondition = @$filter["v_b_09_head"];
        $this->b_09_head->AdvancedSearch->SearchValue2 = @$filter["y_b_09_head"];
        $this->b_09_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_09_head"];
        $this->b_09_head->AdvancedSearch->save();

        // Field b_10_head
        $this->b_10_head->AdvancedSearch->SearchValue = @$filter["x_b_10_head"];
        $this->b_10_head->AdvancedSearch->SearchOperator = @$filter["z_b_10_head"];
        $this->b_10_head->AdvancedSearch->SearchCondition = @$filter["v_b_10_head"];
        $this->b_10_head->AdvancedSearch->SearchValue2 = @$filter["y_b_10_head"];
        $this->b_10_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_10_head"];
        $this->b_10_head->AdvancedSearch->save();

        // Field b_11_head
        $this->b_11_head->AdvancedSearch->SearchValue = @$filter["x_b_11_head"];
        $this->b_11_head->AdvancedSearch->SearchOperator = @$filter["z_b_11_head"];
        $this->b_11_head->AdvancedSearch->SearchCondition = @$filter["v_b_11_head"];
        $this->b_11_head->AdvancedSearch->SearchValue2 = @$filter["y_b_11_head"];
        $this->b_11_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_11_head"];
        $this->b_11_head->AdvancedSearch->save();

        // Field b_12_head
        $this->b_12_head->AdvancedSearch->SearchValue = @$filter["x_b_12_head"];
        $this->b_12_head->AdvancedSearch->SearchOperator = @$filter["z_b_12_head"];
        $this->b_12_head->AdvancedSearch->SearchCondition = @$filter["v_b_12_head"];
        $this->b_12_head->AdvancedSearch->SearchValue2 = @$filter["y_b_12_head"];
        $this->b_12_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_12_head"];
        $this->b_12_head->AdvancedSearch->save();

        // Field b_13_head
        $this->b_13_head->AdvancedSearch->SearchValue = @$filter["x_b_13_head"];
        $this->b_13_head->AdvancedSearch->SearchOperator = @$filter["z_b_13_head"];
        $this->b_13_head->AdvancedSearch->SearchCondition = @$filter["v_b_13_head"];
        $this->b_13_head->AdvancedSearch->SearchValue2 = @$filter["y_b_13_head"];
        $this->b_13_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_13_head"];
        $this->b_13_head->AdvancedSearch->save();

        // Field b_14_head
        $this->b_14_head->AdvancedSearch->SearchValue = @$filter["x_b_14_head"];
        $this->b_14_head->AdvancedSearch->SearchOperator = @$filter["z_b_14_head"];
        $this->b_14_head->AdvancedSearch->SearchCondition = @$filter["v_b_14_head"];
        $this->b_14_head->AdvancedSearch->SearchValue2 = @$filter["y_b_14_head"];
        $this->b_14_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_14_head"];
        $this->b_14_head->AdvancedSearch->save();

        // Field b_15_head
        $this->b_15_head->AdvancedSearch->SearchValue = @$filter["x_b_15_head"];
        $this->b_15_head->AdvancedSearch->SearchOperator = @$filter["z_b_15_head"];
        $this->b_15_head->AdvancedSearch->SearchCondition = @$filter["v_b_15_head"];
        $this->b_15_head->AdvancedSearch->SearchValue2 = @$filter["y_b_15_head"];
        $this->b_15_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_15_head"];
        $this->b_15_head->AdvancedSearch->save();

        // Field q_sku
        $this->q_sku->AdvancedSearch->SearchValue = @$filter["x_q_sku"];
        $this->q_sku->AdvancedSearch->SearchOperator = @$filter["z_q_sku"];
        $this->q_sku->AdvancedSearch->SearchCondition = @$filter["v_q_sku"];
        $this->q_sku->AdvancedSearch->SearchValue2 = @$filter["y_q_sku"];
        $this->q_sku->AdvancedSearch->SearchOperator2 = @$filter["w_q_sku"];
        $this->q_sku->AdvancedSearch->save();

        // Field t_01_head
        $this->t_01_head->AdvancedSearch->SearchValue = @$filter["x_t_01_head"];
        $this->t_01_head->AdvancedSearch->SearchOperator = @$filter["z_t_01_head"];
        $this->t_01_head->AdvancedSearch->SearchCondition = @$filter["v_t_01_head"];
        $this->t_01_head->AdvancedSearch->SearchValue2 = @$filter["y_t_01_head"];
        $this->t_01_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_01_head"];
        $this->t_01_head->AdvancedSearch->save();

        // Field t_02_head
        $this->t_02_head->AdvancedSearch->SearchValue = @$filter["x_t_02_head"];
        $this->t_02_head->AdvancedSearch->SearchOperator = @$filter["z_t_02_head"];
        $this->t_02_head->AdvancedSearch->SearchCondition = @$filter["v_t_02_head"];
        $this->t_02_head->AdvancedSearch->SearchValue2 = @$filter["y_t_02_head"];
        $this->t_02_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_02_head"];
        $this->t_02_head->AdvancedSearch->save();

        // Field t_03_head
        $this->t_03_head->AdvancedSearch->SearchValue = @$filter["x_t_03_head"];
        $this->t_03_head->AdvancedSearch->SearchOperator = @$filter["z_t_03_head"];
        $this->t_03_head->AdvancedSearch->SearchCondition = @$filter["v_t_03_head"];
        $this->t_03_head->AdvancedSearch->SearchValue2 = @$filter["y_t_03_head"];
        $this->t_03_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_03_head"];
        $this->t_03_head->AdvancedSearch->save();

        // Field t_04_head
        $this->t_04_head->AdvancedSearch->SearchValue = @$filter["x_t_04_head"];
        $this->t_04_head->AdvancedSearch->SearchOperator = @$filter["z_t_04_head"];
        $this->t_04_head->AdvancedSearch->SearchCondition = @$filter["v_t_04_head"];
        $this->t_04_head->AdvancedSearch->SearchValue2 = @$filter["y_t_04_head"];
        $this->t_04_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_04_head"];
        $this->t_04_head->AdvancedSearch->save();

        // Field t_05_head
        $this->t_05_head->AdvancedSearch->SearchValue = @$filter["x_t_05_head"];
        $this->t_05_head->AdvancedSearch->SearchOperator = @$filter["z_t_05_head"];
        $this->t_05_head->AdvancedSearch->SearchCondition = @$filter["v_t_05_head"];
        $this->t_05_head->AdvancedSearch->SearchValue2 = @$filter["y_t_05_head"];
        $this->t_05_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_05_head"];
        $this->t_05_head->AdvancedSearch->save();

        // Field t_06_head
        $this->t_06_head->AdvancedSearch->SearchValue = @$filter["x_t_06_head"];
        $this->t_06_head->AdvancedSearch->SearchOperator = @$filter["z_t_06_head"];
        $this->t_06_head->AdvancedSearch->SearchCondition = @$filter["v_t_06_head"];
        $this->t_06_head->AdvancedSearch->SearchValue2 = @$filter["y_t_06_head"];
        $this->t_06_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_06_head"];
        $this->t_06_head->AdvancedSearch->save();

        // Field t_07_head
        $this->t_07_head->AdvancedSearch->SearchValue = @$filter["x_t_07_head"];
        $this->t_07_head->AdvancedSearch->SearchOperator = @$filter["z_t_07_head"];
        $this->t_07_head->AdvancedSearch->SearchCondition = @$filter["v_t_07_head"];
        $this->t_07_head->AdvancedSearch->SearchValue2 = @$filter["y_t_07_head"];
        $this->t_07_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_07_head"];
        $this->t_07_head->AdvancedSearch->save();

        // Field t_08_head
        $this->t_08_head->AdvancedSearch->SearchValue = @$filter["x_t_08_head"];
        $this->t_08_head->AdvancedSearch->SearchOperator = @$filter["z_t_08_head"];
        $this->t_08_head->AdvancedSearch->SearchCondition = @$filter["v_t_08_head"];
        $this->t_08_head->AdvancedSearch->SearchValue2 = @$filter["y_t_08_head"];
        $this->t_08_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_08_head"];
        $this->t_08_head->AdvancedSearch->save();

        // Field t_09_head
        $this->t_09_head->AdvancedSearch->SearchValue = @$filter["x_t_09_head"];
        $this->t_09_head->AdvancedSearch->SearchOperator = @$filter["z_t_09_head"];
        $this->t_09_head->AdvancedSearch->SearchCondition = @$filter["v_t_09_head"];
        $this->t_09_head->AdvancedSearch->SearchValue2 = @$filter["y_t_09_head"];
        $this->t_09_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_09_head"];
        $this->t_09_head->AdvancedSearch->save();

        // Field t_10_head
        $this->t_10_head->AdvancedSearch->SearchValue = @$filter["x_t_10_head"];
        $this->t_10_head->AdvancedSearch->SearchOperator = @$filter["z_t_10_head"];
        $this->t_10_head->AdvancedSearch->SearchCondition = @$filter["v_t_10_head"];
        $this->t_10_head->AdvancedSearch->SearchValue2 = @$filter["y_t_10_head"];
        $this->t_10_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_10_head"];
        $this->t_10_head->AdvancedSearch->save();

        // Field t_11_head
        $this->t_11_head->AdvancedSearch->SearchValue = @$filter["x_t_11_head"];
        $this->t_11_head->AdvancedSearch->SearchOperator = @$filter["z_t_11_head"];
        $this->t_11_head->AdvancedSearch->SearchCondition = @$filter["v_t_11_head"];
        $this->t_11_head->AdvancedSearch->SearchValue2 = @$filter["y_t_11_head"];
        $this->t_11_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_11_head"];
        $this->t_11_head->AdvancedSearch->save();

        // Field t_12_head
        $this->t_12_head->AdvancedSearch->SearchValue = @$filter["x_t_12_head"];
        $this->t_12_head->AdvancedSearch->SearchOperator = @$filter["z_t_12_head"];
        $this->t_12_head->AdvancedSearch->SearchCondition = @$filter["v_t_12_head"];
        $this->t_12_head->AdvancedSearch->SearchValue2 = @$filter["y_t_12_head"];
        $this->t_12_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_12_head"];
        $this->t_12_head->AdvancedSearch->save();

        // Field t_13_head
        $this->t_13_head->AdvancedSearch->SearchValue = @$filter["x_t_13_head"];
        $this->t_13_head->AdvancedSearch->SearchOperator = @$filter["z_t_13_head"];
        $this->t_13_head->AdvancedSearch->SearchCondition = @$filter["v_t_13_head"];
        $this->t_13_head->AdvancedSearch->SearchValue2 = @$filter["y_t_13_head"];
        $this->t_13_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_13_head"];
        $this->t_13_head->AdvancedSearch->save();

        // Field t_14_head
        $this->t_14_head->AdvancedSearch->SearchValue = @$filter["x_t_14_head"];
        $this->t_14_head->AdvancedSearch->SearchOperator = @$filter["z_t_14_head"];
        $this->t_14_head->AdvancedSearch->SearchCondition = @$filter["v_t_14_head"];
        $this->t_14_head->AdvancedSearch->SearchValue2 = @$filter["y_t_14_head"];
        $this->t_14_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_14_head"];
        $this->t_14_head->AdvancedSearch->save();

        // Field t_15_head
        $this->t_15_head->AdvancedSearch->SearchValue = @$filter["x_t_15_head"];
        $this->t_15_head->AdvancedSearch->SearchOperator = @$filter["z_t_15_head"];
        $this->t_15_head->AdvancedSearch->SearchCondition = @$filter["v_t_15_head"];
        $this->t_15_head->AdvancedSearch->SearchValue2 = @$filter["y_t_15_head"];
        $this->t_15_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_15_head"];
        $this->t_15_head->AdvancedSearch->save();

        // Field po_01_head
        $this->po_01_head->AdvancedSearch->SearchValue = @$filter["x_po_01_head"];
        $this->po_01_head->AdvancedSearch->SearchOperator = @$filter["z_po_01_head"];
        $this->po_01_head->AdvancedSearch->SearchCondition = @$filter["v_po_01_head"];
        $this->po_01_head->AdvancedSearch->SearchValue2 = @$filter["y_po_01_head"];
        $this->po_01_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_01_head"];
        $this->po_01_head->AdvancedSearch->save();

        // Field po_02_head
        $this->po_02_head->AdvancedSearch->SearchValue = @$filter["x_po_02_head"];
        $this->po_02_head->AdvancedSearch->SearchOperator = @$filter["z_po_02_head"];
        $this->po_02_head->AdvancedSearch->SearchCondition = @$filter["v_po_02_head"];
        $this->po_02_head->AdvancedSearch->SearchValue2 = @$filter["y_po_02_head"];
        $this->po_02_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_02_head"];
        $this->po_02_head->AdvancedSearch->save();

        // Field po_03_head
        $this->po_03_head->AdvancedSearch->SearchValue = @$filter["x_po_03_head"];
        $this->po_03_head->AdvancedSearch->SearchOperator = @$filter["z_po_03_head"];
        $this->po_03_head->AdvancedSearch->SearchCondition = @$filter["v_po_03_head"];
        $this->po_03_head->AdvancedSearch->SearchValue2 = @$filter["y_po_03_head"];
        $this->po_03_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_03_head"];
        $this->po_03_head->AdvancedSearch->save();

        // Field po_04_head
        $this->po_04_head->AdvancedSearch->SearchValue = @$filter["x_po_04_head"];
        $this->po_04_head->AdvancedSearch->SearchOperator = @$filter["z_po_04_head"];
        $this->po_04_head->AdvancedSearch->SearchCondition = @$filter["v_po_04_head"];
        $this->po_04_head->AdvancedSearch->SearchValue2 = @$filter["y_po_04_head"];
        $this->po_04_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_04_head"];
        $this->po_04_head->AdvancedSearch->save();

        // Field po_05_head
        $this->po_05_head->AdvancedSearch->SearchValue = @$filter["x_po_05_head"];
        $this->po_05_head->AdvancedSearch->SearchOperator = @$filter["z_po_05_head"];
        $this->po_05_head->AdvancedSearch->SearchCondition = @$filter["v_po_05_head"];
        $this->po_05_head->AdvancedSearch->SearchValue2 = @$filter["y_po_05_head"];
        $this->po_05_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_05_head"];
        $this->po_05_head->AdvancedSearch->save();

        // Field po_06_head
        $this->po_06_head->AdvancedSearch->SearchValue = @$filter["x_po_06_head"];
        $this->po_06_head->AdvancedSearch->SearchOperator = @$filter["z_po_06_head"];
        $this->po_06_head->AdvancedSearch->SearchCondition = @$filter["v_po_06_head"];
        $this->po_06_head->AdvancedSearch->SearchValue2 = @$filter["y_po_06_head"];
        $this->po_06_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_06_head"];
        $this->po_06_head->AdvancedSearch->save();

        // Field po_07_head
        $this->po_07_head->AdvancedSearch->SearchValue = @$filter["x_po_07_head"];
        $this->po_07_head->AdvancedSearch->SearchOperator = @$filter["z_po_07_head"];
        $this->po_07_head->AdvancedSearch->SearchCondition = @$filter["v_po_07_head"];
        $this->po_07_head->AdvancedSearch->SearchValue2 = @$filter["y_po_07_head"];
        $this->po_07_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_07_head"];
        $this->po_07_head->AdvancedSearch->save();

        // Field po_08_head
        $this->po_08_head->AdvancedSearch->SearchValue = @$filter["x_po_08_head"];
        $this->po_08_head->AdvancedSearch->SearchOperator = @$filter["z_po_08_head"];
        $this->po_08_head->AdvancedSearch->SearchCondition = @$filter["v_po_08_head"];
        $this->po_08_head->AdvancedSearch->SearchValue2 = @$filter["y_po_08_head"];
        $this->po_08_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_08_head"];
        $this->po_08_head->AdvancedSearch->save();

        // Field po_17_head
        $this->po_17_head->AdvancedSearch->SearchValue = @$filter["x_po_17_head"];
        $this->po_17_head->AdvancedSearch->SearchOperator = @$filter["z_po_17_head"];
        $this->po_17_head->AdvancedSearch->SearchCondition = @$filter["v_po_17_head"];
        $this->po_17_head->AdvancedSearch->SearchValue2 = @$filter["y_po_17_head"];
        $this->po_17_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_17_head"];
        $this->po_17_head->AdvancedSearch->save();

        // Field po_18_head
        $this->po_18_head->AdvancedSearch->SearchValue = @$filter["x_po_18_head"];
        $this->po_18_head->AdvancedSearch->SearchOperator = @$filter["z_po_18_head"];
        $this->po_18_head->AdvancedSearch->SearchCondition = @$filter["v_po_18_head"];
        $this->po_18_head->AdvancedSearch->SearchValue2 = @$filter["y_po_18_head"];
        $this->po_18_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_18_head"];
        $this->po_18_head->AdvancedSearch->save();

        // Field po_19_head
        $this->po_19_head->AdvancedSearch->SearchValue = @$filter["x_po_19_head"];
        $this->po_19_head->AdvancedSearch->SearchOperator = @$filter["z_po_19_head"];
        $this->po_19_head->AdvancedSearch->SearchCondition = @$filter["v_po_19_head"];
        $this->po_19_head->AdvancedSearch->SearchValue2 = @$filter["y_po_19_head"];
        $this->po_19_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_19_head"];
        $this->po_19_head->AdvancedSearch->save();

        // Field po_20_head
        $this->po_20_head->AdvancedSearch->SearchValue = @$filter["x_po_20_head"];
        $this->po_20_head->AdvancedSearch->SearchOperator = @$filter["z_po_20_head"];
        $this->po_20_head->AdvancedSearch->SearchCondition = @$filter["v_po_20_head"];
        $this->po_20_head->AdvancedSearch->SearchValue2 = @$filter["y_po_20_head"];
        $this->po_20_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_20_head"];
        $this->po_20_head->AdvancedSearch->save();

        // Field jc_01_head
        $this->jc_01_head->AdvancedSearch->SearchValue = @$filter["x_jc_01_head"];
        $this->jc_01_head->AdvancedSearch->SearchOperator = @$filter["z_jc_01_head"];
        $this->jc_01_head->AdvancedSearch->SearchCondition = @$filter["v_jc_01_head"];
        $this->jc_01_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_01_head"];
        $this->jc_01_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_01_head"];
        $this->jc_01_head->AdvancedSearch->save();

        // Field jc_02_head
        $this->jc_02_head->AdvancedSearch->SearchValue = @$filter["x_jc_02_head"];
        $this->jc_02_head->AdvancedSearch->SearchOperator = @$filter["z_jc_02_head"];
        $this->jc_02_head->AdvancedSearch->SearchCondition = @$filter["v_jc_02_head"];
        $this->jc_02_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_02_head"];
        $this->jc_02_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_02_head"];
        $this->jc_02_head->AdvancedSearch->save();

        // Field jc_03_head
        $this->jc_03_head->AdvancedSearch->SearchValue = @$filter["x_jc_03_head"];
        $this->jc_03_head->AdvancedSearch->SearchOperator = @$filter["z_jc_03_head"];
        $this->jc_03_head->AdvancedSearch->SearchCondition = @$filter["v_jc_03_head"];
        $this->jc_03_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_03_head"];
        $this->jc_03_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_03_head"];
        $this->jc_03_head->AdvancedSearch->save();

        // Field jc_04_head
        $this->jc_04_head->AdvancedSearch->SearchValue = @$filter["x_jc_04_head"];
        $this->jc_04_head->AdvancedSearch->SearchOperator = @$filter["z_jc_04_head"];
        $this->jc_04_head->AdvancedSearch->SearchCondition = @$filter["v_jc_04_head"];
        $this->jc_04_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_04_head"];
        $this->jc_04_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_04_head"];
        $this->jc_04_head->AdvancedSearch->save();

        // Field jc_05_head
        $this->jc_05_head->AdvancedSearch->SearchValue = @$filter["x_jc_05_head"];
        $this->jc_05_head->AdvancedSearch->SearchOperator = @$filter["z_jc_05_head"];
        $this->jc_05_head->AdvancedSearch->SearchCondition = @$filter["v_jc_05_head"];
        $this->jc_05_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_05_head"];
        $this->jc_05_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_05_head"];
        $this->jc_05_head->AdvancedSearch->save();

        // Field jc_06_head
        $this->jc_06_head->AdvancedSearch->SearchValue = @$filter["x_jc_06_head"];
        $this->jc_06_head->AdvancedSearch->SearchOperator = @$filter["z_jc_06_head"];
        $this->jc_06_head->AdvancedSearch->SearchCondition = @$filter["v_jc_06_head"];
        $this->jc_06_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_06_head"];
        $this->jc_06_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_06_head"];
        $this->jc_06_head->AdvancedSearch->save();

        // Field jc_07_head
        $this->jc_07_head->AdvancedSearch->SearchValue = @$filter["x_jc_07_head"];
        $this->jc_07_head->AdvancedSearch->SearchOperator = @$filter["z_jc_07_head"];
        $this->jc_07_head->AdvancedSearch->SearchCondition = @$filter["v_jc_07_head"];
        $this->jc_07_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_07_head"];
        $this->jc_07_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_07_head"];
        $this->jc_07_head->AdvancedSearch->save();

        // Field jc_08_head
        $this->jc_08_head->AdvancedSearch->SearchValue = @$filter["x_jc_08_head"];
        $this->jc_08_head->AdvancedSearch->SearchOperator = @$filter["z_jc_08_head"];
        $this->jc_08_head->AdvancedSearch->SearchCondition = @$filter["v_jc_08_head"];
        $this->jc_08_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_08_head"];
        $this->jc_08_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_08_head"];
        $this->jc_08_head->AdvancedSearch->save();

        // Field jc_09_head
        $this->jc_09_head->AdvancedSearch->SearchValue = @$filter["x_jc_09_head"];
        $this->jc_09_head->AdvancedSearch->SearchOperator = @$filter["z_jc_09_head"];
        $this->jc_09_head->AdvancedSearch->SearchCondition = @$filter["v_jc_09_head"];
        $this->jc_09_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_09_head"];
        $this->jc_09_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_09_head"];
        $this->jc_09_head->AdvancedSearch->save();

        // Field jc_10_head
        $this->jc_10_head->AdvancedSearch->SearchValue = @$filter["x_jc_10_head"];
        $this->jc_10_head->AdvancedSearch->SearchOperator = @$filter["z_jc_10_head"];
        $this->jc_10_head->AdvancedSearch->SearchCondition = @$filter["v_jc_10_head"];
        $this->jc_10_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_10_head"];
        $this->jc_10_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_10_head"];
        $this->jc_10_head->AdvancedSearch->save();

        // Field pc_shape
        $this->pc_shape->AdvancedSearch->SearchValue = @$filter["x_pc_shape"];
        $this->pc_shape->AdvancedSearch->SearchOperator = @$filter["z_pc_shape"];
        $this->pc_shape->AdvancedSearch->SearchCondition = @$filter["v_pc_shape"];
        $this->pc_shape->AdvancedSearch->SearchValue2 = @$filter["y_pc_shape"];
        $this->pc_shape->AdvancedSearch->SearchOperator2 = @$filter["w_pc_shape"];
        $this->pc_shape->AdvancedSearch->save();

        // Field pc_unit
        $this->pc_unit->AdvancedSearch->SearchValue = @$filter["x_pc_unit"];
        $this->pc_unit->AdvancedSearch->SearchOperator = @$filter["z_pc_unit"];
        $this->pc_unit->AdvancedSearch->SearchCondition = @$filter["v_pc_unit"];
        $this->pc_unit->AdvancedSearch->SearchValue2 = @$filter["y_pc_unit"];
        $this->pc_unit->AdvancedSearch->SearchOperator2 = @$filter["w_pc_unit"];
        $this->pc_unit->AdvancedSearch->save();

        // Field pc_w
        $this->pc_w->AdvancedSearch->SearchValue = @$filter["x_pc_w"];
        $this->pc_w->AdvancedSearch->SearchOperator = @$filter["z_pc_w"];
        $this->pc_w->AdvancedSearch->SearchCondition = @$filter["v_pc_w"];
        $this->pc_w->AdvancedSearch->SearchValue2 = @$filter["y_pc_w"];
        $this->pc_w->AdvancedSearch->SearchOperator2 = @$filter["w_pc_w"];
        $this->pc_w->AdvancedSearch->save();

        // Field pc_l
        $this->pc_l->AdvancedSearch->SearchValue = @$filter["x_pc_l"];
        $this->pc_l->AdvancedSearch->SearchOperator = @$filter["z_pc_l"];
        $this->pc_l->AdvancedSearch->SearchCondition = @$filter["v_pc_l"];
        $this->pc_l->AdvancedSearch->SearchValue2 = @$filter["y_pc_l"];
        $this->pc_l->AdvancedSearch->SearchOperator2 = @$filter["w_pc_l"];
        $this->pc_l->AdvancedSearch->save();

        // Field pc_h
        $this->pc_h->AdvancedSearch->SearchValue = @$filter["x_pc_h"];
        $this->pc_h->AdvancedSearch->SearchOperator = @$filter["z_pc_h"];
        $this->pc_h->AdvancedSearch->SearchCondition = @$filter["v_pc_h"];
        $this->pc_h->AdvancedSearch->SearchValue2 = @$filter["y_pc_h"];
        $this->pc_h->AdvancedSearch->SearchOperator2 = @$filter["w_pc_h"];
        $this->pc_h->AdvancedSearch->save();

        // Field pc_partner_size
        $this->pc_partner_size->AdvancedSearch->SearchValue = @$filter["x_pc_partner_size"];
        $this->pc_partner_size->AdvancedSearch->SearchOperator = @$filter["z_pc_partner_size"];
        $this->pc_partner_size->AdvancedSearch->SearchCondition = @$filter["v_pc_partner_size"];
        $this->pc_partner_size->AdvancedSearch->SearchValue2 = @$filter["y_pc_partner_size"];
        $this->pc_partner_size->AdvancedSearch->SearchOperator2 = @$filter["w_pc_partner_size"];
        $this->pc_partner_size->AdvancedSearch->save();

        // Field pc_sqm
        $this->pc_sqm->AdvancedSearch->SearchValue = @$filter["x_pc_sqm"];
        $this->pc_sqm->AdvancedSearch->SearchOperator = @$filter["z_pc_sqm"];
        $this->pc_sqm->AdvancedSearch->SearchCondition = @$filter["v_pc_sqm"];
        $this->pc_sqm->AdvancedSearch->SearchValue2 = @$filter["y_pc_sqm"];
        $this->pc_sqm->AdvancedSearch->SearchOperator2 = @$filter["w_pc_sqm"];
        $this->pc_sqm->AdvancedSearch->save();

        // Field pc_01_head
        $this->pc_01_head->AdvancedSearch->SearchValue = @$filter["x_pc_01_head"];
        $this->pc_01_head->AdvancedSearch->SearchOperator = @$filter["z_pc_01_head"];
        $this->pc_01_head->AdvancedSearch->SearchCondition = @$filter["v_pc_01_head"];
        $this->pc_01_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_01_head"];
        $this->pc_01_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_01_head"];
        $this->pc_01_head->AdvancedSearch->save();

        // Field pc_02_head
        $this->pc_02_head->AdvancedSearch->SearchValue = @$filter["x_pc_02_head"];
        $this->pc_02_head->AdvancedSearch->SearchOperator = @$filter["z_pc_02_head"];
        $this->pc_02_head->AdvancedSearch->SearchCondition = @$filter["v_pc_02_head"];
        $this->pc_02_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_02_head"];
        $this->pc_02_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_02_head"];
        $this->pc_02_head->AdvancedSearch->save();

        // Field pc_03_head
        $this->pc_03_head->AdvancedSearch->SearchValue = @$filter["x_pc_03_head"];
        $this->pc_03_head->AdvancedSearch->SearchOperator = @$filter["z_pc_03_head"];
        $this->pc_03_head->AdvancedSearch->SearchCondition = @$filter["v_pc_03_head"];
        $this->pc_03_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_03_head"];
        $this->pc_03_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_03_head"];
        $this->pc_03_head->AdvancedSearch->save();

        // Field pc_04_head
        $this->pc_04_head->AdvancedSearch->SearchValue = @$filter["x_pc_04_head"];
        $this->pc_04_head->AdvancedSearch->SearchOperator = @$filter["z_pc_04_head"];
        $this->pc_04_head->AdvancedSearch->SearchCondition = @$filter["v_pc_04_head"];
        $this->pc_04_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_04_head"];
        $this->pc_04_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_04_head"];
        $this->pc_04_head->AdvancedSearch->save();

        // Field pc_05_head
        $this->pc_05_head->AdvancedSearch->SearchValue = @$filter["x_pc_05_head"];
        $this->pc_05_head->AdvancedSearch->SearchOperator = @$filter["z_pc_05_head"];
        $this->pc_05_head->AdvancedSearch->SearchCondition = @$filter["v_pc_05_head"];
        $this->pc_05_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_05_head"];
        $this->pc_05_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_05_head"];
        $this->pc_05_head->AdvancedSearch->save();

        // Field pc_06_head
        $this->pc_06_head->AdvancedSearch->SearchValue = @$filter["x_pc_06_head"];
        $this->pc_06_head->AdvancedSearch->SearchOperator = @$filter["z_pc_06_head"];
        $this->pc_06_head->AdvancedSearch->SearchCondition = @$filter["v_pc_06_head"];
        $this->pc_06_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_06_head"];
        $this->pc_06_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_06_head"];
        $this->pc_06_head->AdvancedSearch->save();

        // Field pc_07_head
        $this->pc_07_head->AdvancedSearch->SearchValue = @$filter["x_pc_07_head"];
        $this->pc_07_head->AdvancedSearch->SearchOperator = @$filter["z_pc_07_head"];
        $this->pc_07_head->AdvancedSearch->SearchCondition = @$filter["v_pc_07_head"];
        $this->pc_07_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_07_head"];
        $this->pc_07_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_07_head"];
        $this->pc_07_head->AdvancedSearch->save();

        // Field pc_08_head
        $this->pc_08_head->AdvancedSearch->SearchValue = @$filter["x_pc_08_head"];
        $this->pc_08_head->AdvancedSearch->SearchOperator = @$filter["z_pc_08_head"];
        $this->pc_08_head->AdvancedSearch->SearchCondition = @$filter["v_pc_08_head"];
        $this->pc_08_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_08_head"];
        $this->pc_08_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_08_head"];
        $this->pc_08_head->AdvancedSearch->save();

        // Field pc_09_head
        $this->pc_09_head->AdvancedSearch->SearchValue = @$filter["x_pc_09_head"];
        $this->pc_09_head->AdvancedSearch->SearchOperator = @$filter["z_pc_09_head"];
        $this->pc_09_head->AdvancedSearch->SearchCondition = @$filter["v_pc_09_head"];
        $this->pc_09_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_09_head"];
        $this->pc_09_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_09_head"];
        $this->pc_09_head->AdvancedSearch->save();

        // Field pc_10_head
        $this->pc_10_head->AdvancedSearch->SearchValue = @$filter["x_pc_10_head"];
        $this->pc_10_head->AdvancedSearch->SearchOperator = @$filter["z_pc_10_head"];
        $this->pc_10_head->AdvancedSearch->SearchCondition = @$filter["v_pc_10_head"];
        $this->pc_10_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_10_head"];
        $this->pc_10_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_10_head"];
        $this->pc_10_head->AdvancedSearch->save();

        // Field pc_11_head
        $this->pc_11_head->AdvancedSearch->SearchValue = @$filter["x_pc_11_head"];
        $this->pc_11_head->AdvancedSearch->SearchOperator = @$filter["z_pc_11_head"];
        $this->pc_11_head->AdvancedSearch->SearchCondition = @$filter["v_pc_11_head"];
        $this->pc_11_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_11_head"];
        $this->pc_11_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_11_head"];
        $this->pc_11_head->AdvancedSearch->save();

        // Field pc_12_head
        $this->pc_12_head->AdvancedSearch->SearchValue = @$filter["x_pc_12_head"];
        $this->pc_12_head->AdvancedSearch->SearchOperator = @$filter["z_pc_12_head"];
        $this->pc_12_head->AdvancedSearch->SearchCondition = @$filter["v_pc_12_head"];
        $this->pc_12_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_12_head"];
        $this->pc_12_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_12_head"];
        $this->pc_12_head->AdvancedSearch->save();

        // Field operator
        $this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
        $this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
        $this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
        $this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
        $this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
        $this->operator->AdvancedSearch->save();

        // Field datetime
        $this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
        $this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
        $this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
        $this->datetime->AdvancedSearch->save();

        // Field image
        $this->image->AdvancedSearch->SearchValue = @$filter["x_image"];
        $this->image->AdvancedSearch->SearchOperator = @$filter["z_image"];
        $this->image->AdvancedSearch->SearchCondition = @$filter["v_image"];
        $this->image->AdvancedSearch->SearchValue2 = @$filter["y_image"];
        $this->image->AdvancedSearch->SearchOperator2 = @$filter["w_image"];
        $this->image->AdvancedSearch->save();

        // Field pa_process_size_w
        $this->pa_process_size_w->AdvancedSearch->SearchValue = @$filter["x_pa_process_size_w"];
        $this->pa_process_size_w->AdvancedSearch->SearchOperator = @$filter["z_pa_process_size_w"];
        $this->pa_process_size_w->AdvancedSearch->SearchCondition = @$filter["v_pa_process_size_w"];
        $this->pa_process_size_w->AdvancedSearch->SearchValue2 = @$filter["y_pa_process_size_w"];
        $this->pa_process_size_w->AdvancedSearch->SearchOperator2 = @$filter["w_pa_process_size_w"];
        $this->pa_process_size_w->AdvancedSearch->save();

        // Field pa_process_size_l
        $this->pa_process_size_l->AdvancedSearch->SearchValue = @$filter["x_pa_process_size_l"];
        $this->pa_process_size_l->AdvancedSearch->SearchOperator = @$filter["z_pa_process_size_l"];
        $this->pa_process_size_l->AdvancedSearch->SearchCondition = @$filter["v_pa_process_size_l"];
        $this->pa_process_size_l->AdvancedSearch->SearchValue2 = @$filter["y_pa_process_size_l"];
        $this->pa_process_size_l->AdvancedSearch->SearchOperator2 = @$filter["w_pa_process_size_l"];
        $this->pa_process_size_l->AdvancedSearch->save();

        // Field pa_head_01
        $this->pa_head_01->AdvancedSearch->SearchValue = @$filter["x_pa_head_01"];
        $this->pa_head_01->AdvancedSearch->SearchOperator = @$filter["z_pa_head_01"];
        $this->pa_head_01->AdvancedSearch->SearchCondition = @$filter["v_pa_head_01"];
        $this->pa_head_01->AdvancedSearch->SearchValue2 = @$filter["y_pa_head_01"];
        $this->pa_head_01->AdvancedSearch->SearchOperator2 = @$filter["w_pa_head_01"];
        $this->pa_head_01->AdvancedSearch->save();

        // Field pa_process_01
        $this->pa_process_01->AdvancedSearch->SearchValue = @$filter["x_pa_process_01"];
        $this->pa_process_01->AdvancedSearch->SearchOperator = @$filter["z_pa_process_01"];
        $this->pa_process_01->AdvancedSearch->SearchCondition = @$filter["v_pa_process_01"];
        $this->pa_process_01->AdvancedSearch->SearchValue2 = @$filter["y_pa_process_01"];
        $this->pa_process_01->AdvancedSearch->SearchOperator2 = @$filter["w_pa_process_01"];
        $this->pa_process_01->AdvancedSearch->save();

        // Field pa_head_02
        $this->pa_head_02->AdvancedSearch->SearchValue = @$filter["x_pa_head_02"];
        $this->pa_head_02->AdvancedSearch->SearchOperator = @$filter["z_pa_head_02"];
        $this->pa_head_02->AdvancedSearch->SearchCondition = @$filter["v_pa_head_02"];
        $this->pa_head_02->AdvancedSearch->SearchValue2 = @$filter["y_pa_head_02"];
        $this->pa_head_02->AdvancedSearch->SearchOperator2 = @$filter["w_pa_head_02"];
        $this->pa_head_02->AdvancedSearch->save();

        // Field pa_process_02
        $this->pa_process_02->AdvancedSearch->SearchValue = @$filter["x_pa_process_02"];
        $this->pa_process_02->AdvancedSearch->SearchOperator = @$filter["z_pa_process_02"];
        $this->pa_process_02->AdvancedSearch->SearchCondition = @$filter["v_pa_process_02"];
        $this->pa_process_02->AdvancedSearch->SearchValue2 = @$filter["y_pa_process_02"];
        $this->pa_process_02->AdvancedSearch->SearchOperator2 = @$filter["w_pa_process_02"];
        $this->pa_process_02->AdvancedSearch->save();

        // Field pa_head_03
        $this->pa_head_03->AdvancedSearch->SearchValue = @$filter["x_pa_head_03"];
        $this->pa_head_03->AdvancedSearch->SearchOperator = @$filter["z_pa_head_03"];
        $this->pa_head_03->AdvancedSearch->SearchCondition = @$filter["v_pa_head_03"];
        $this->pa_head_03->AdvancedSearch->SearchValue2 = @$filter["y_pa_head_03"];
        $this->pa_head_03->AdvancedSearch->SearchOperator2 = @$filter["w_pa_head_03"];
        $this->pa_head_03->AdvancedSearch->save();

        // Field pa_process_03
        $this->pa_process_03->AdvancedSearch->SearchValue = @$filter["x_pa_process_03"];
        $this->pa_process_03->AdvancedSearch->SearchOperator = @$filter["z_pa_process_03"];
        $this->pa_process_03->AdvancedSearch->SearchCondition = @$filter["v_pa_process_03"];
        $this->pa_process_03->AdvancedSearch->SearchValue2 = @$filter["y_pa_process_03"];
        $this->pa_process_03->AdvancedSearch->SearchOperator2 = @$filter["w_pa_process_03"];
        $this->pa_process_03->AdvancedSearch->save();

        // Field pa_head_04
        $this->pa_head_04->AdvancedSearch->SearchValue = @$filter["x_pa_head_04"];
        $this->pa_head_04->AdvancedSearch->SearchOperator = @$filter["z_pa_head_04"];
        $this->pa_head_04->AdvancedSearch->SearchCondition = @$filter["v_pa_head_04"];
        $this->pa_head_04->AdvancedSearch->SearchValue2 = @$filter["y_pa_head_04"];
        $this->pa_head_04->AdvancedSearch->SearchOperator2 = @$filter["w_pa_head_04"];
        $this->pa_head_04->AdvancedSearch->save();

        // Field pa_process_04
        $this->pa_process_04->AdvancedSearch->SearchValue = @$filter["x_pa_process_04"];
        $this->pa_process_04->AdvancedSearch->SearchOperator = @$filter["z_pa_process_04"];
        $this->pa_process_04->AdvancedSearch->SearchCondition = @$filter["v_pa_process_04"];
        $this->pa_process_04->AdvancedSearch->SearchValue2 = @$filter["y_pa_process_04"];
        $this->pa_process_04->AdvancedSearch->SearchOperator2 = @$filter["w_pa_process_04"];
        $this->pa_process_04->AdvancedSearch->save();

        // Field pa_head_05
        $this->pa_head_05->AdvancedSearch->SearchValue = @$filter["x_pa_head_05"];
        $this->pa_head_05->AdvancedSearch->SearchOperator = @$filter["z_pa_head_05"];
        $this->pa_head_05->AdvancedSearch->SearchCondition = @$filter["v_pa_head_05"];
        $this->pa_head_05->AdvancedSearch->SearchValue2 = @$filter["y_pa_head_05"];
        $this->pa_head_05->AdvancedSearch->SearchOperator2 = @$filter["w_pa_head_05"];
        $this->pa_head_05->AdvancedSearch->save();

        // Field pa_process_05
        $this->pa_process_05->AdvancedSearch->SearchValue = @$filter["x_pa_process_05"];
        $this->pa_process_05->AdvancedSearch->SearchOperator = @$filter["z_pa_process_05"];
        $this->pa_process_05->AdvancedSearch->SearchCondition = @$filter["v_pa_process_05"];
        $this->pa_process_05->AdvancedSearch->SearchValue2 = @$filter["y_pa_process_05"];
        $this->pa_process_05->AdvancedSearch->SearchOperator2 = @$filter["w_pa_process_05"];
        $this->pa_process_05->AdvancedSearch->save();

        // Field pa_head_06
        $this->pa_head_06->AdvancedSearch->SearchValue = @$filter["x_pa_head_06"];
        $this->pa_head_06->AdvancedSearch->SearchOperator = @$filter["z_pa_head_06"];
        $this->pa_head_06->AdvancedSearch->SearchCondition = @$filter["v_pa_head_06"];
        $this->pa_head_06->AdvancedSearch->SearchValue2 = @$filter["y_pa_head_06"];
        $this->pa_head_06->AdvancedSearch->SearchOperator2 = @$filter["w_pa_head_06"];
        $this->pa_head_06->AdvancedSearch->save();

        // Field pa_process_06
        $this->pa_process_06->AdvancedSearch->SearchValue = @$filter["x_pa_process_06"];
        $this->pa_process_06->AdvancedSearch->SearchOperator = @$filter["z_pa_process_06"];
        $this->pa_process_06->AdvancedSearch->SearchCondition = @$filter["v_pa_process_06"];
        $this->pa_process_06->AdvancedSearch->SearchValue2 = @$filter["y_pa_process_06"];
        $this->pa_process_06->AdvancedSearch->SearchOperator2 = @$filter["w_pa_process_06"];
        $this->pa_process_06->AdvancedSearch->save();

        // Field pa_head_07
        $this->pa_head_07->AdvancedSearch->SearchValue = @$filter["x_pa_head_07"];
        $this->pa_head_07->AdvancedSearch->SearchOperator = @$filter["z_pa_head_07"];
        $this->pa_head_07->AdvancedSearch->SearchCondition = @$filter["v_pa_head_07"];
        $this->pa_head_07->AdvancedSearch->SearchValue2 = @$filter["y_pa_head_07"];
        $this->pa_head_07->AdvancedSearch->SearchOperator2 = @$filter["w_pa_head_07"];
        $this->pa_head_07->AdvancedSearch->save();

        // Field pa_process_07
        $this->pa_process_07->AdvancedSearch->SearchValue = @$filter["x_pa_process_07"];
        $this->pa_process_07->AdvancedSearch->SearchOperator = @$filter["z_pa_process_07"];
        $this->pa_process_07->AdvancedSearch->SearchCondition = @$filter["v_pa_process_07"];
        $this->pa_process_07->AdvancedSearch->SearchValue2 = @$filter["y_pa_process_07"];
        $this->pa_process_07->AdvancedSearch->SearchOperator2 = @$filter["w_pa_process_07"];
        $this->pa_process_07->AdvancedSearch->save();

        // Field pa_head_08
        $this->pa_head_08->AdvancedSearch->SearchValue = @$filter["x_pa_head_08"];
        $this->pa_head_08->AdvancedSearch->SearchOperator = @$filter["z_pa_head_08"];
        $this->pa_head_08->AdvancedSearch->SearchCondition = @$filter["v_pa_head_08"];
        $this->pa_head_08->AdvancedSearch->SearchValue2 = @$filter["y_pa_head_08"];
        $this->pa_head_08->AdvancedSearch->SearchOperator2 = @$filter["w_pa_head_08"];
        $this->pa_head_08->AdvancedSearch->save();

        // Field pa_process_08
        $this->pa_process_08->AdvancedSearch->SearchValue = @$filter["x_pa_process_08"];
        $this->pa_process_08->AdvancedSearch->SearchOperator = @$filter["z_pa_process_08"];
        $this->pa_process_08->AdvancedSearch->SearchCondition = @$filter["v_pa_process_08"];
        $this->pa_process_08->AdvancedSearch->SearchValue2 = @$filter["y_pa_process_08"];
        $this->pa_process_08->AdvancedSearch->SearchOperator2 = @$filter["w_pa_process_08"];
        $this->pa_process_08->AdvancedSearch->save();

        // Field pa_head_09
        $this->pa_head_09->AdvancedSearch->SearchValue = @$filter["x_pa_head_09"];
        $this->pa_head_09->AdvancedSearch->SearchOperator = @$filter["z_pa_head_09"];
        $this->pa_head_09->AdvancedSearch->SearchCondition = @$filter["v_pa_head_09"];
        $this->pa_head_09->AdvancedSearch->SearchValue2 = @$filter["y_pa_head_09"];
        $this->pa_head_09->AdvancedSearch->SearchOperator2 = @$filter["w_pa_head_09"];
        $this->pa_head_09->AdvancedSearch->save();

        // Field pa_process_09
        $this->pa_process_09->AdvancedSearch->SearchValue = @$filter["x_pa_process_09"];
        $this->pa_process_09->AdvancedSearch->SearchOperator = @$filter["z_pa_process_09"];
        $this->pa_process_09->AdvancedSearch->SearchCondition = @$filter["v_pa_process_09"];
        $this->pa_process_09->AdvancedSearch->SearchValue2 = @$filter["y_pa_process_09"];
        $this->pa_process_09->AdvancedSearch->SearchOperator2 = @$filter["w_pa_process_09"];
        $this->pa_process_09->AdvancedSearch->save();

        // Field pa_head_10
        $this->pa_head_10->AdvancedSearch->SearchValue = @$filter["x_pa_head_10"];
        $this->pa_head_10->AdvancedSearch->SearchOperator = @$filter["z_pa_head_10"];
        $this->pa_head_10->AdvancedSearch->SearchCondition = @$filter["v_pa_head_10"];
        $this->pa_head_10->AdvancedSearch->SearchValue2 = @$filter["y_pa_head_10"];
        $this->pa_head_10->AdvancedSearch->SearchOperator2 = @$filter["w_pa_head_10"];
        $this->pa_head_10->AdvancedSearch->save();

        // Field pa_process_10
        $this->pa_process_10->AdvancedSearch->SearchValue = @$filter["x_pa_process_10"];
        $this->pa_process_10->AdvancedSearch->SearchOperator = @$filter["z_pa_process_10"];
        $this->pa_process_10->AdvancedSearch->SearchCondition = @$filter["v_pa_process_10"];
        $this->pa_process_10->AdvancedSearch->SearchValue2 = @$filter["y_pa_process_10"];
        $this->pa_process_10->AdvancedSearch->SearchOperator2 = @$filter["w_pa_process_10"];
        $this->pa_process_10->AdvancedSearch->save();

        // Field publish
        $this->publish->AdvancedSearch->SearchValue = @$filter["x_publish"];
        $this->publish->AdvancedSearch->SearchOperator = @$filter["z_publish"];
        $this->publish->AdvancedSearch->SearchCondition = @$filter["v_publish"];
        $this->publish->AdvancedSearch->SearchValue2 = @$filter["y_publish"];
        $this->publish->AdvancedSearch->SearchOperator2 = @$filter["w_publish"];
        $this->publish->AdvancedSearch->save();

        // Field ppr_01
        $this->ppr_01->AdvancedSearch->SearchValue = @$filter["x_ppr_01"];
        $this->ppr_01->AdvancedSearch->SearchOperator = @$filter["z_ppr_01"];
        $this->ppr_01->AdvancedSearch->SearchCondition = @$filter["v_ppr_01"];
        $this->ppr_01->AdvancedSearch->SearchValue2 = @$filter["y_ppr_01"];
        $this->ppr_01->AdvancedSearch->SearchOperator2 = @$filter["w_ppr_01"];
        $this->ppr_01->AdvancedSearch->save();

        // Field ppr_02
        $this->ppr_02->AdvancedSearch->SearchValue = @$filter["x_ppr_02"];
        $this->ppr_02->AdvancedSearch->SearchOperator = @$filter["z_ppr_02"];
        $this->ppr_02->AdvancedSearch->SearchCondition = @$filter["v_ppr_02"];
        $this->ppr_02->AdvancedSearch->SearchValue2 = @$filter["y_ppr_02"];
        $this->ppr_02->AdvancedSearch->SearchOperator2 = @$filter["w_ppr_02"];
        $this->ppr_02->AdvancedSearch->save();

        // Field ppr_03
        $this->ppr_03->AdvancedSearch->SearchValue = @$filter["x_ppr_03"];
        $this->ppr_03->AdvancedSearch->SearchOperator = @$filter["z_ppr_03"];
        $this->ppr_03->AdvancedSearch->SearchCondition = @$filter["v_ppr_03"];
        $this->ppr_03->AdvancedSearch->SearchValue2 = @$filter["y_ppr_03"];
        $this->ppr_03->AdvancedSearch->SearchOperator2 = @$filter["w_ppr_03"];
        $this->ppr_03->AdvancedSearch->save();

        // Field ppr_04
        $this->ppr_04->AdvancedSearch->SearchValue = @$filter["x_ppr_04"];
        $this->ppr_04->AdvancedSearch->SearchOperator = @$filter["z_ppr_04"];
        $this->ppr_04->AdvancedSearch->SearchCondition = @$filter["v_ppr_04"];
        $this->ppr_04->AdvancedSearch->SearchValue2 = @$filter["y_ppr_04"];
        $this->ppr_04->AdvancedSearch->SearchOperator2 = @$filter["w_ppr_04"];
        $this->ppr_04->AdvancedSearch->save();

        // Field ppr_05
        $this->ppr_05->AdvancedSearch->SearchValue = @$filter["x_ppr_05"];
        $this->ppr_05->AdvancedSearch->SearchOperator = @$filter["z_ppr_05"];
        $this->ppr_05->AdvancedSearch->SearchCondition = @$filter["v_ppr_05"];
        $this->ppr_05->AdvancedSearch->SearchValue2 = @$filter["y_ppr_05"];
        $this->ppr_05->AdvancedSearch->SearchOperator2 = @$filter["w_ppr_05"];
        $this->ppr_05->AdvancedSearch->save();

        // Field ppr_06
        $this->ppr_06->AdvancedSearch->SearchValue = @$filter["x_ppr_06"];
        $this->ppr_06->AdvancedSearch->SearchOperator = @$filter["z_ppr_06"];
        $this->ppr_06->AdvancedSearch->SearchCondition = @$filter["v_ppr_06"];
        $this->ppr_06->AdvancedSearch->SearchValue2 = @$filter["y_ppr_06"];
        $this->ppr_06->AdvancedSearch->SearchOperator2 = @$filter["w_ppr_06"];
        $this->ppr_06->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->grp, $default, false); // grp
        $this->buildSearchSql($where, $this->product_group, $default, false); // product_group
        $this->buildSearchSql($where, $this->calculation_method, $default, false); // calculation_method
        $this->buildSearchSql($where, $this->shape, $default, false); // shape
        $this->buildSearchSql($where, $this->sqm, $default, false); // sqm
        $this->buildSearchSql($where, $this->cbm, $default, false); // cbm
        $this->buildSearchSql($where, $this->process, $default, false); // process
        $this->buildSearchSql($where, $this->status, $default, false); // status
        $this->buildSearchSql($where, $this->v_00, $default, false); // v_00
        $this->buildSearchSql($where, $this->v_01, $default, false); // v_01
        $this->buildSearchSql($where, $this->v_01_validation, $default, false); // v_01_validation
        $this->buildSearchSql($where, $this->v_02, $default, false); // v_02
        $this->buildSearchSql($where, $this->v_02_validation, $default, false); // v_02_validation
        $this->buildSearchSql($where, $this->v_03, $default, false); // v_03
        $this->buildSearchSql($where, $this->v_03_validation, $default, false); // v_03_validation
        $this->buildSearchSql($where, $this->v_04, $default, false); // v_04
        $this->buildSearchSql($where, $this->v_04_validation, $default, false); // v_04_validation
        $this->buildSearchSql($where, $this->v_05, $default, false); // v_05
        $this->buildSearchSql($where, $this->v_05_validation, $default, false); // v_05_validation
        $this->buildSearchSql($where, $this->v_06, $default, false); // v_06
        $this->buildSearchSql($where, $this->v_06_validation, $default, false); // v_06_validation
        $this->buildSearchSql($where, $this->v_07, $default, false); // v_07
        $this->buildSearchSql($where, $this->v_07_validation, $default, false); // v_07_validation
        $this->buildSearchSql($where, $this->v_08, $default, false); // v_08
        $this->buildSearchSql($where, $this->v_08_validation, $default, false); // v_08_validation
        $this->buildSearchSql($where, $this->v_09, $default, false); // v_09
        $this->buildSearchSql($where, $this->v_09_validation, $default, false); // v_09_validation
        $this->buildSearchSql($where, $this->v_10, $default, false); // v_10
        $this->buildSearchSql($where, $this->v_10_validation, $default, false); // v_10_validation
        $this->buildSearchSql($where, $this->b_01_head, $default, false); // b_01_head
        $this->buildSearchSql($where, $this->b_02_head, $default, false); // b_02_head
        $this->buildSearchSql($where, $this->b_03_head, $default, false); // b_03_head
        $this->buildSearchSql($where, $this->b_04_head, $default, false); // b_04_head
        $this->buildSearchSql($where, $this->b_05_head, $default, false); // b_05_head
        $this->buildSearchSql($where, $this->b_06_head, $default, false); // b_06_head
        $this->buildSearchSql($where, $this->b_07_head, $default, false); // b_07_head
        $this->buildSearchSql($where, $this->b_08_head, $default, false); // b_08_head
        $this->buildSearchSql($where, $this->b_09_head, $default, false); // b_09_head
        $this->buildSearchSql($where, $this->b_10_head, $default, false); // b_10_head
        $this->buildSearchSql($where, $this->b_11_head, $default, false); // b_11_head
        $this->buildSearchSql($where, $this->b_12_head, $default, false); // b_12_head
        $this->buildSearchSql($where, $this->b_13_head, $default, false); // b_13_head
        $this->buildSearchSql($where, $this->b_14_head, $default, false); // b_14_head
        $this->buildSearchSql($where, $this->b_15_head, $default, false); // b_15_head
        $this->buildSearchSql($where, $this->q_sku, $default, false); // q_sku
        $this->buildSearchSql($where, $this->t_01_head, $default, false); // t_01_head
        $this->buildSearchSql($where, $this->t_02_head, $default, false); // t_02_head
        $this->buildSearchSql($where, $this->t_03_head, $default, false); // t_03_head
        $this->buildSearchSql($where, $this->t_04_head, $default, false); // t_04_head
        $this->buildSearchSql($where, $this->t_05_head, $default, false); // t_05_head
        $this->buildSearchSql($where, $this->t_06_head, $default, false); // t_06_head
        $this->buildSearchSql($where, $this->t_07_head, $default, false); // t_07_head
        $this->buildSearchSql($where, $this->t_08_head, $default, false); // t_08_head
        $this->buildSearchSql($where, $this->t_09_head, $default, false); // t_09_head
        $this->buildSearchSql($where, $this->t_10_head, $default, false); // t_10_head
        $this->buildSearchSql($where, $this->t_11_head, $default, false); // t_11_head
        $this->buildSearchSql($where, $this->t_12_head, $default, false); // t_12_head
        $this->buildSearchSql($where, $this->t_13_head, $default, false); // t_13_head
        $this->buildSearchSql($where, $this->t_14_head, $default, false); // t_14_head
        $this->buildSearchSql($where, $this->t_15_head, $default, false); // t_15_head
        $this->buildSearchSql($where, $this->po_01_head, $default, false); // po_01_head
        $this->buildSearchSql($where, $this->po_02_head, $default, false); // po_02_head
        $this->buildSearchSql($where, $this->po_03_head, $default, false); // po_03_head
        $this->buildSearchSql($where, $this->po_04_head, $default, false); // po_04_head
        $this->buildSearchSql($where, $this->po_05_head, $default, false); // po_05_head
        $this->buildSearchSql($where, $this->po_06_head, $default, false); // po_06_head
        $this->buildSearchSql($where, $this->po_07_head, $default, false); // po_07_head
        $this->buildSearchSql($where, $this->po_08_head, $default, false); // po_08_head
        $this->buildSearchSql($where, $this->po_17_head, $default, false); // po_17_head
        $this->buildSearchSql($where, $this->po_18_head, $default, false); // po_18_head
        $this->buildSearchSql($where, $this->po_19_head, $default, false); // po_19_head
        $this->buildSearchSql($where, $this->po_20_head, $default, false); // po_20_head
        $this->buildSearchSql($where, $this->jc_01_head, $default, false); // jc_01_head
        $this->buildSearchSql($where, $this->jc_02_head, $default, false); // jc_02_head
        $this->buildSearchSql($where, $this->jc_03_head, $default, false); // jc_03_head
        $this->buildSearchSql($where, $this->jc_04_head, $default, false); // jc_04_head
        $this->buildSearchSql($where, $this->jc_05_head, $default, false); // jc_05_head
        $this->buildSearchSql($where, $this->jc_06_head, $default, false); // jc_06_head
        $this->buildSearchSql($where, $this->jc_07_head, $default, false); // jc_07_head
        $this->buildSearchSql($where, $this->jc_08_head, $default, false); // jc_08_head
        $this->buildSearchSql($where, $this->jc_09_head, $default, false); // jc_09_head
        $this->buildSearchSql($where, $this->jc_10_head, $default, false); // jc_10_head
        $this->buildSearchSql($where, $this->pc_shape, $default, false); // pc_shape
        $this->buildSearchSql($where, $this->pc_unit, $default, false); // pc_unit
        $this->buildSearchSql($where, $this->pc_w, $default, false); // pc_w
        $this->buildSearchSql($where, $this->pc_l, $default, false); // pc_l
        $this->buildSearchSql($where, $this->pc_h, $default, false); // pc_h
        $this->buildSearchSql($where, $this->pc_partner_size, $default, false); // pc_partner_size
        $this->buildSearchSql($where, $this->pc_sqm, $default, false); // pc_sqm
        $this->buildSearchSql($where, $this->pc_01_head, $default, false); // pc_01_head
        $this->buildSearchSql($where, $this->pc_02_head, $default, false); // pc_02_head
        $this->buildSearchSql($where, $this->pc_03_head, $default, false); // pc_03_head
        $this->buildSearchSql($where, $this->pc_04_head, $default, false); // pc_04_head
        $this->buildSearchSql($where, $this->pc_05_head, $default, false); // pc_05_head
        $this->buildSearchSql($where, $this->pc_06_head, $default, false); // pc_06_head
        $this->buildSearchSql($where, $this->pc_07_head, $default, false); // pc_07_head
        $this->buildSearchSql($where, $this->pc_08_head, $default, false); // pc_08_head
        $this->buildSearchSql($where, $this->pc_09_head, $default, false); // pc_09_head
        $this->buildSearchSql($where, $this->pc_10_head, $default, false); // pc_10_head
        $this->buildSearchSql($where, $this->pc_11_head, $default, false); // pc_11_head
        $this->buildSearchSql($where, $this->pc_12_head, $default, false); // pc_12_head
        $this->buildSearchSql($where, $this->operator, $default, false); // operator
        $this->buildSearchSql($where, $this->datetime, $default, false); // datetime
        $this->buildSearchSql($where, $this->image, $default, false); // image
        $this->buildSearchSql($where, $this->pa_process_size_w, $default, false); // pa_process_size_w
        $this->buildSearchSql($where, $this->pa_process_size_l, $default, false); // pa_process_size_l
        $this->buildSearchSql($where, $this->pa_head_01, $default, false); // pa_head_01
        $this->buildSearchSql($where, $this->pa_process_01, $default, true); // pa_process_01
        $this->buildSearchSql($where, $this->pa_head_02, $default, false); // pa_head_02
        $this->buildSearchSql($where, $this->pa_process_02, $default, true); // pa_process_02
        $this->buildSearchSql($where, $this->pa_head_03, $default, false); // pa_head_03
        $this->buildSearchSql($where, $this->pa_process_03, $default, true); // pa_process_03
        $this->buildSearchSql($where, $this->pa_head_04, $default, false); // pa_head_04
        $this->buildSearchSql($where, $this->pa_process_04, $default, true); // pa_process_04
        $this->buildSearchSql($where, $this->pa_head_05, $default, false); // pa_head_05
        $this->buildSearchSql($where, $this->pa_process_05, $default, true); // pa_process_05
        $this->buildSearchSql($where, $this->pa_head_06, $default, false); // pa_head_06
        $this->buildSearchSql($where, $this->pa_process_06, $default, true); // pa_process_06
        $this->buildSearchSql($where, $this->pa_head_07, $default, false); // pa_head_07
        $this->buildSearchSql($where, $this->pa_process_07, $default, true); // pa_process_07
        $this->buildSearchSql($where, $this->pa_head_08, $default, false); // pa_head_08
        $this->buildSearchSql($where, $this->pa_process_08, $default, true); // pa_process_08
        $this->buildSearchSql($where, $this->pa_head_09, $default, false); // pa_head_09
        $this->buildSearchSql($where, $this->pa_process_09, $default, true); // pa_process_09
        $this->buildSearchSql($where, $this->pa_head_10, $default, false); // pa_head_10
        $this->buildSearchSql($where, $this->pa_process_10, $default, true); // pa_process_10
        $this->buildSearchSql($where, $this->publish, $default, false); // publish
        $this->buildSearchSql($where, $this->ppr_01, $default, false); // ppr_01
        $this->buildSearchSql($where, $this->ppr_02, $default, false); // ppr_02
        $this->buildSearchSql($where, $this->ppr_03, $default, false); // ppr_03
        $this->buildSearchSql($where, $this->ppr_04, $default, false); // ppr_04
        $this->buildSearchSql($where, $this->ppr_05, $default, false); // ppr_05
        $this->buildSearchSql($where, $this->ppr_06, $default, false); // ppr_06

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->id->AdvancedSearch->save(); // id
            $this->grp->AdvancedSearch->save(); // grp
            $this->product_group->AdvancedSearch->save(); // product_group
            $this->calculation_method->AdvancedSearch->save(); // calculation_method
            $this->shape->AdvancedSearch->save(); // shape
            $this->sqm->AdvancedSearch->save(); // sqm
            $this->cbm->AdvancedSearch->save(); // cbm
            $this->process->AdvancedSearch->save(); // process
            $this->status->AdvancedSearch->save(); // status
            $this->v_00->AdvancedSearch->save(); // v_00
            $this->v_01->AdvancedSearch->save(); // v_01
            $this->v_01_validation->AdvancedSearch->save(); // v_01_validation
            $this->v_02->AdvancedSearch->save(); // v_02
            $this->v_02_validation->AdvancedSearch->save(); // v_02_validation
            $this->v_03->AdvancedSearch->save(); // v_03
            $this->v_03_validation->AdvancedSearch->save(); // v_03_validation
            $this->v_04->AdvancedSearch->save(); // v_04
            $this->v_04_validation->AdvancedSearch->save(); // v_04_validation
            $this->v_05->AdvancedSearch->save(); // v_05
            $this->v_05_validation->AdvancedSearch->save(); // v_05_validation
            $this->v_06->AdvancedSearch->save(); // v_06
            $this->v_06_validation->AdvancedSearch->save(); // v_06_validation
            $this->v_07->AdvancedSearch->save(); // v_07
            $this->v_07_validation->AdvancedSearch->save(); // v_07_validation
            $this->v_08->AdvancedSearch->save(); // v_08
            $this->v_08_validation->AdvancedSearch->save(); // v_08_validation
            $this->v_09->AdvancedSearch->save(); // v_09
            $this->v_09_validation->AdvancedSearch->save(); // v_09_validation
            $this->v_10->AdvancedSearch->save(); // v_10
            $this->v_10_validation->AdvancedSearch->save(); // v_10_validation
            $this->b_01_head->AdvancedSearch->save(); // b_01_head
            $this->b_02_head->AdvancedSearch->save(); // b_02_head
            $this->b_03_head->AdvancedSearch->save(); // b_03_head
            $this->b_04_head->AdvancedSearch->save(); // b_04_head
            $this->b_05_head->AdvancedSearch->save(); // b_05_head
            $this->b_06_head->AdvancedSearch->save(); // b_06_head
            $this->b_07_head->AdvancedSearch->save(); // b_07_head
            $this->b_08_head->AdvancedSearch->save(); // b_08_head
            $this->b_09_head->AdvancedSearch->save(); // b_09_head
            $this->b_10_head->AdvancedSearch->save(); // b_10_head
            $this->b_11_head->AdvancedSearch->save(); // b_11_head
            $this->b_12_head->AdvancedSearch->save(); // b_12_head
            $this->b_13_head->AdvancedSearch->save(); // b_13_head
            $this->b_14_head->AdvancedSearch->save(); // b_14_head
            $this->b_15_head->AdvancedSearch->save(); // b_15_head
            $this->q_sku->AdvancedSearch->save(); // q_sku
            $this->t_01_head->AdvancedSearch->save(); // t_01_head
            $this->t_02_head->AdvancedSearch->save(); // t_02_head
            $this->t_03_head->AdvancedSearch->save(); // t_03_head
            $this->t_04_head->AdvancedSearch->save(); // t_04_head
            $this->t_05_head->AdvancedSearch->save(); // t_05_head
            $this->t_06_head->AdvancedSearch->save(); // t_06_head
            $this->t_07_head->AdvancedSearch->save(); // t_07_head
            $this->t_08_head->AdvancedSearch->save(); // t_08_head
            $this->t_09_head->AdvancedSearch->save(); // t_09_head
            $this->t_10_head->AdvancedSearch->save(); // t_10_head
            $this->t_11_head->AdvancedSearch->save(); // t_11_head
            $this->t_12_head->AdvancedSearch->save(); // t_12_head
            $this->t_13_head->AdvancedSearch->save(); // t_13_head
            $this->t_14_head->AdvancedSearch->save(); // t_14_head
            $this->t_15_head->AdvancedSearch->save(); // t_15_head
            $this->po_01_head->AdvancedSearch->save(); // po_01_head
            $this->po_02_head->AdvancedSearch->save(); // po_02_head
            $this->po_03_head->AdvancedSearch->save(); // po_03_head
            $this->po_04_head->AdvancedSearch->save(); // po_04_head
            $this->po_05_head->AdvancedSearch->save(); // po_05_head
            $this->po_06_head->AdvancedSearch->save(); // po_06_head
            $this->po_07_head->AdvancedSearch->save(); // po_07_head
            $this->po_08_head->AdvancedSearch->save(); // po_08_head
            $this->po_17_head->AdvancedSearch->save(); // po_17_head
            $this->po_18_head->AdvancedSearch->save(); // po_18_head
            $this->po_19_head->AdvancedSearch->save(); // po_19_head
            $this->po_20_head->AdvancedSearch->save(); // po_20_head
            $this->jc_01_head->AdvancedSearch->save(); // jc_01_head
            $this->jc_02_head->AdvancedSearch->save(); // jc_02_head
            $this->jc_03_head->AdvancedSearch->save(); // jc_03_head
            $this->jc_04_head->AdvancedSearch->save(); // jc_04_head
            $this->jc_05_head->AdvancedSearch->save(); // jc_05_head
            $this->jc_06_head->AdvancedSearch->save(); // jc_06_head
            $this->jc_07_head->AdvancedSearch->save(); // jc_07_head
            $this->jc_08_head->AdvancedSearch->save(); // jc_08_head
            $this->jc_09_head->AdvancedSearch->save(); // jc_09_head
            $this->jc_10_head->AdvancedSearch->save(); // jc_10_head
            $this->pc_shape->AdvancedSearch->save(); // pc_shape
            $this->pc_unit->AdvancedSearch->save(); // pc_unit
            $this->pc_w->AdvancedSearch->save(); // pc_w
            $this->pc_l->AdvancedSearch->save(); // pc_l
            $this->pc_h->AdvancedSearch->save(); // pc_h
            $this->pc_partner_size->AdvancedSearch->save(); // pc_partner_size
            $this->pc_sqm->AdvancedSearch->save(); // pc_sqm
            $this->pc_01_head->AdvancedSearch->save(); // pc_01_head
            $this->pc_02_head->AdvancedSearch->save(); // pc_02_head
            $this->pc_03_head->AdvancedSearch->save(); // pc_03_head
            $this->pc_04_head->AdvancedSearch->save(); // pc_04_head
            $this->pc_05_head->AdvancedSearch->save(); // pc_05_head
            $this->pc_06_head->AdvancedSearch->save(); // pc_06_head
            $this->pc_07_head->AdvancedSearch->save(); // pc_07_head
            $this->pc_08_head->AdvancedSearch->save(); // pc_08_head
            $this->pc_09_head->AdvancedSearch->save(); // pc_09_head
            $this->pc_10_head->AdvancedSearch->save(); // pc_10_head
            $this->pc_11_head->AdvancedSearch->save(); // pc_11_head
            $this->pc_12_head->AdvancedSearch->save(); // pc_12_head
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->image->AdvancedSearch->save(); // image
            $this->pa_process_size_w->AdvancedSearch->save(); // pa_process_size_w
            $this->pa_process_size_l->AdvancedSearch->save(); // pa_process_size_l
            $this->pa_head_01->AdvancedSearch->save(); // pa_head_01
            $this->pa_process_01->AdvancedSearch->save(); // pa_process_01
            $this->pa_head_02->AdvancedSearch->save(); // pa_head_02
            $this->pa_process_02->AdvancedSearch->save(); // pa_process_02
            $this->pa_head_03->AdvancedSearch->save(); // pa_head_03
            $this->pa_process_03->AdvancedSearch->save(); // pa_process_03
            $this->pa_head_04->AdvancedSearch->save(); // pa_head_04
            $this->pa_process_04->AdvancedSearch->save(); // pa_process_04
            $this->pa_head_05->AdvancedSearch->save(); // pa_head_05
            $this->pa_process_05->AdvancedSearch->save(); // pa_process_05
            $this->pa_head_06->AdvancedSearch->save(); // pa_head_06
            $this->pa_process_06->AdvancedSearch->save(); // pa_process_06
            $this->pa_head_07->AdvancedSearch->save(); // pa_head_07
            $this->pa_process_07->AdvancedSearch->save(); // pa_process_07
            $this->pa_head_08->AdvancedSearch->save(); // pa_head_08
            $this->pa_process_08->AdvancedSearch->save(); // pa_process_08
            $this->pa_head_09->AdvancedSearch->save(); // pa_head_09
            $this->pa_process_09->AdvancedSearch->save(); // pa_process_09
            $this->pa_head_10->AdvancedSearch->save(); // pa_head_10
            $this->pa_process_10->AdvancedSearch->save(); // pa_process_10
            $this->publish->AdvancedSearch->save(); // publish
            $this->ppr_01->AdvancedSearch->save(); // ppr_01
            $this->ppr_02->AdvancedSearch->save(); // ppr_02
            $this->ppr_03->AdvancedSearch->save(); // ppr_03
            $this->ppr_04->AdvancedSearch->save(); // ppr_04
            $this->ppr_05->AdvancedSearch->save(); // ppr_05
            $this->ppr_06->AdvancedSearch->save(); // ppr_06

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->id->AdvancedSearch->save(); // id
            $this->grp->AdvancedSearch->save(); // grp
            $this->product_group->AdvancedSearch->save(); // product_group
            $this->calculation_method->AdvancedSearch->save(); // calculation_method
            $this->shape->AdvancedSearch->save(); // shape
            $this->sqm->AdvancedSearch->save(); // sqm
            $this->cbm->AdvancedSearch->save(); // cbm
            $this->process->AdvancedSearch->save(); // process
            $this->status->AdvancedSearch->save(); // status
            $this->v_00->AdvancedSearch->save(); // v_00
            $this->v_01->AdvancedSearch->save(); // v_01
            $this->v_01_validation->AdvancedSearch->save(); // v_01_validation
            $this->v_02->AdvancedSearch->save(); // v_02
            $this->v_02_validation->AdvancedSearch->save(); // v_02_validation
            $this->v_03->AdvancedSearch->save(); // v_03
            $this->v_03_validation->AdvancedSearch->save(); // v_03_validation
            $this->v_04->AdvancedSearch->save(); // v_04
            $this->v_04_validation->AdvancedSearch->save(); // v_04_validation
            $this->v_05->AdvancedSearch->save(); // v_05
            $this->v_05_validation->AdvancedSearch->save(); // v_05_validation
            $this->v_06->AdvancedSearch->save(); // v_06
            $this->v_06_validation->AdvancedSearch->save(); // v_06_validation
            $this->v_07->AdvancedSearch->save(); // v_07
            $this->v_07_validation->AdvancedSearch->save(); // v_07_validation
            $this->v_08->AdvancedSearch->save(); // v_08
            $this->v_08_validation->AdvancedSearch->save(); // v_08_validation
            $this->v_09->AdvancedSearch->save(); // v_09
            $this->v_09_validation->AdvancedSearch->save(); // v_09_validation
            $this->v_10->AdvancedSearch->save(); // v_10
            $this->v_10_validation->AdvancedSearch->save(); // v_10_validation
            $this->b_01_head->AdvancedSearch->save(); // b_01_head
            $this->b_02_head->AdvancedSearch->save(); // b_02_head
            $this->b_03_head->AdvancedSearch->save(); // b_03_head
            $this->b_04_head->AdvancedSearch->save(); // b_04_head
            $this->b_05_head->AdvancedSearch->save(); // b_05_head
            $this->b_06_head->AdvancedSearch->save(); // b_06_head
            $this->b_07_head->AdvancedSearch->save(); // b_07_head
            $this->b_08_head->AdvancedSearch->save(); // b_08_head
            $this->b_09_head->AdvancedSearch->save(); // b_09_head
            $this->b_10_head->AdvancedSearch->save(); // b_10_head
            $this->b_11_head->AdvancedSearch->save(); // b_11_head
            $this->b_12_head->AdvancedSearch->save(); // b_12_head
            $this->b_13_head->AdvancedSearch->save(); // b_13_head
            $this->b_14_head->AdvancedSearch->save(); // b_14_head
            $this->b_15_head->AdvancedSearch->save(); // b_15_head
            $this->q_sku->AdvancedSearch->save(); // q_sku
            $this->t_01_head->AdvancedSearch->save(); // t_01_head
            $this->t_02_head->AdvancedSearch->save(); // t_02_head
            $this->t_03_head->AdvancedSearch->save(); // t_03_head
            $this->t_04_head->AdvancedSearch->save(); // t_04_head
            $this->t_05_head->AdvancedSearch->save(); // t_05_head
            $this->t_06_head->AdvancedSearch->save(); // t_06_head
            $this->t_07_head->AdvancedSearch->save(); // t_07_head
            $this->t_08_head->AdvancedSearch->save(); // t_08_head
            $this->t_09_head->AdvancedSearch->save(); // t_09_head
            $this->t_10_head->AdvancedSearch->save(); // t_10_head
            $this->t_11_head->AdvancedSearch->save(); // t_11_head
            $this->t_12_head->AdvancedSearch->save(); // t_12_head
            $this->t_13_head->AdvancedSearch->save(); // t_13_head
            $this->t_14_head->AdvancedSearch->save(); // t_14_head
            $this->t_15_head->AdvancedSearch->save(); // t_15_head
            $this->po_01_head->AdvancedSearch->save(); // po_01_head
            $this->po_02_head->AdvancedSearch->save(); // po_02_head
            $this->po_03_head->AdvancedSearch->save(); // po_03_head
            $this->po_04_head->AdvancedSearch->save(); // po_04_head
            $this->po_05_head->AdvancedSearch->save(); // po_05_head
            $this->po_06_head->AdvancedSearch->save(); // po_06_head
            $this->po_07_head->AdvancedSearch->save(); // po_07_head
            $this->po_08_head->AdvancedSearch->save(); // po_08_head
            $this->po_17_head->AdvancedSearch->save(); // po_17_head
            $this->po_18_head->AdvancedSearch->save(); // po_18_head
            $this->po_19_head->AdvancedSearch->save(); // po_19_head
            $this->po_20_head->AdvancedSearch->save(); // po_20_head
            $this->jc_01_head->AdvancedSearch->save(); // jc_01_head
            $this->jc_02_head->AdvancedSearch->save(); // jc_02_head
            $this->jc_03_head->AdvancedSearch->save(); // jc_03_head
            $this->jc_04_head->AdvancedSearch->save(); // jc_04_head
            $this->jc_05_head->AdvancedSearch->save(); // jc_05_head
            $this->jc_06_head->AdvancedSearch->save(); // jc_06_head
            $this->jc_07_head->AdvancedSearch->save(); // jc_07_head
            $this->jc_08_head->AdvancedSearch->save(); // jc_08_head
            $this->jc_09_head->AdvancedSearch->save(); // jc_09_head
            $this->jc_10_head->AdvancedSearch->save(); // jc_10_head
            $this->pc_shape->AdvancedSearch->save(); // pc_shape
            $this->pc_unit->AdvancedSearch->save(); // pc_unit
            $this->pc_w->AdvancedSearch->save(); // pc_w
            $this->pc_l->AdvancedSearch->save(); // pc_l
            $this->pc_h->AdvancedSearch->save(); // pc_h
            $this->pc_partner_size->AdvancedSearch->save(); // pc_partner_size
            $this->pc_sqm->AdvancedSearch->save(); // pc_sqm
            $this->pc_01_head->AdvancedSearch->save(); // pc_01_head
            $this->pc_02_head->AdvancedSearch->save(); // pc_02_head
            $this->pc_03_head->AdvancedSearch->save(); // pc_03_head
            $this->pc_04_head->AdvancedSearch->save(); // pc_04_head
            $this->pc_05_head->AdvancedSearch->save(); // pc_05_head
            $this->pc_06_head->AdvancedSearch->save(); // pc_06_head
            $this->pc_07_head->AdvancedSearch->save(); // pc_07_head
            $this->pc_08_head->AdvancedSearch->save(); // pc_08_head
            $this->pc_09_head->AdvancedSearch->save(); // pc_09_head
            $this->pc_10_head->AdvancedSearch->save(); // pc_10_head
            $this->pc_11_head->AdvancedSearch->save(); // pc_11_head
            $this->pc_12_head->AdvancedSearch->save(); // pc_12_head
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->image->AdvancedSearch->save(); // image
            $this->pa_process_size_w->AdvancedSearch->save(); // pa_process_size_w
            $this->pa_process_size_l->AdvancedSearch->save(); // pa_process_size_l
            $this->pa_head_01->AdvancedSearch->save(); // pa_head_01
            $this->pa_process_01->AdvancedSearch->save(); // pa_process_01
            $this->pa_head_02->AdvancedSearch->save(); // pa_head_02
            $this->pa_process_02->AdvancedSearch->save(); // pa_process_02
            $this->pa_head_03->AdvancedSearch->save(); // pa_head_03
            $this->pa_process_03->AdvancedSearch->save(); // pa_process_03
            $this->pa_head_04->AdvancedSearch->save(); // pa_head_04
            $this->pa_process_04->AdvancedSearch->save(); // pa_process_04
            $this->pa_head_05->AdvancedSearch->save(); // pa_head_05
            $this->pa_process_05->AdvancedSearch->save(); // pa_process_05
            $this->pa_head_06->AdvancedSearch->save(); // pa_head_06
            $this->pa_process_06->AdvancedSearch->save(); // pa_process_06
            $this->pa_head_07->AdvancedSearch->save(); // pa_head_07
            $this->pa_process_07->AdvancedSearch->save(); // pa_process_07
            $this->pa_head_08->AdvancedSearch->save(); // pa_head_08
            $this->pa_process_08->AdvancedSearch->save(); // pa_process_08
            $this->pa_head_09->AdvancedSearch->save(); // pa_head_09
            $this->pa_process_09->AdvancedSearch->save(); // pa_process_09
            $this->pa_head_10->AdvancedSearch->save(); // pa_head_10
            $this->pa_process_10->AdvancedSearch->save(); // pa_process_10
            $this->publish->AdvancedSearch->save(); // publish
            $this->ppr_01->AdvancedSearch->save(); // ppr_01
            $this->ppr_02->AdvancedSearch->save(); // ppr_02
            $this->ppr_03->AdvancedSearch->save(); // ppr_03
            $this->ppr_04->AdvancedSearch->save(); // ppr_04
            $this->ppr_05->AdvancedSearch->save(); // ppr_05
            $this->ppr_06->AdvancedSearch->save(); // ppr_06
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field id
        $filter = $this->queryBuilderWhere("id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field grp
        $filter = $this->queryBuilderWhere("grp");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->grp, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->grp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field product_group
        $filter = $this->queryBuilderWhere("product_group");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->product_group, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->product_group->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field calculation_method
        $filter = $this->queryBuilderWhere("calculation_method");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->calculation_method, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->calculation_method->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field shape
        $filter = $this->queryBuilderWhere("shape");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->shape, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->shape->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field sqm
        $filter = $this->queryBuilderWhere("sqm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->sqm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->sqm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field cbm
        $filter = $this->queryBuilderWhere("cbm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->cbm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->cbm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field process
        $filter = $this->queryBuilderWhere("process");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->process, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->process->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field status
        $filter = $this->queryBuilderWhere("status");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->status, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->status->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_00
        $filter = $this->queryBuilderWhere("v_00");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_00, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_00->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_01
        $filter = $this->queryBuilderWhere("v_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_01_validation
        $filter = $this->queryBuilderWhere("v_01_validation");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_01_validation, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_01_validation->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_02
        $filter = $this->queryBuilderWhere("v_02");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_02, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_02->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_02_validation
        $filter = $this->queryBuilderWhere("v_02_validation");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_02_validation, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_02_validation->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_03
        $filter = $this->queryBuilderWhere("v_03");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_03, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_03->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_03_validation
        $filter = $this->queryBuilderWhere("v_03_validation");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_03_validation, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_03_validation->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_04
        $filter = $this->queryBuilderWhere("v_04");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_04, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_04->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_04_validation
        $filter = $this->queryBuilderWhere("v_04_validation");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_04_validation, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_04_validation->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_05
        $filter = $this->queryBuilderWhere("v_05");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_05, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_05->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_05_validation
        $filter = $this->queryBuilderWhere("v_05_validation");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_05_validation, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_05_validation->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_06
        $filter = $this->queryBuilderWhere("v_06");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_06, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_06->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_06_validation
        $filter = $this->queryBuilderWhere("v_06_validation");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_06_validation, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_06_validation->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_07
        $filter = $this->queryBuilderWhere("v_07");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_07, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_07->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_07_validation
        $filter = $this->queryBuilderWhere("v_07_validation");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_07_validation, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_07_validation->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_08
        $filter = $this->queryBuilderWhere("v_08");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_08, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_08->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_08_validation
        $filter = $this->queryBuilderWhere("v_08_validation");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_08_validation, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_08_validation->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_09
        $filter = $this->queryBuilderWhere("v_09");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_09, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_09->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_09_validation
        $filter = $this->queryBuilderWhere("v_09_validation");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_09_validation, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_09_validation->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_10
        $filter = $this->queryBuilderWhere("v_10");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_10, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_10->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_10_validation
        $filter = $this->queryBuilderWhere("v_10_validation");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_10_validation, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_10_validation->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field b_01_head
        $filter = $this->queryBuilderWhere("b_01_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->b_01_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->b_01_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field b_02_head
        $filter = $this->queryBuilderWhere("b_02_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->b_02_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->b_02_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field b_03_head
        $filter = $this->queryBuilderWhere("b_03_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->b_03_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->b_03_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field b_04_head
        $filter = $this->queryBuilderWhere("b_04_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->b_04_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->b_04_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field b_05_head
        $filter = $this->queryBuilderWhere("b_05_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->b_05_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->b_05_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field b_06_head
        $filter = $this->queryBuilderWhere("b_06_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->b_06_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->b_06_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field b_07_head
        $filter = $this->queryBuilderWhere("b_07_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->b_07_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->b_07_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field b_08_head
        $filter = $this->queryBuilderWhere("b_08_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->b_08_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->b_08_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field b_09_head
        $filter = $this->queryBuilderWhere("b_09_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->b_09_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->b_09_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field b_10_head
        $filter = $this->queryBuilderWhere("b_10_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->b_10_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->b_10_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field b_11_head
        $filter = $this->queryBuilderWhere("b_11_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->b_11_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->b_11_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field b_12_head
        $filter = $this->queryBuilderWhere("b_12_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->b_12_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->b_12_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field b_13_head
        $filter = $this->queryBuilderWhere("b_13_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->b_13_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->b_13_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field b_14_head
        $filter = $this->queryBuilderWhere("b_14_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->b_14_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->b_14_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field b_15_head
        $filter = $this->queryBuilderWhere("b_15_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->b_15_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->b_15_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field q_sku
        $filter = $this->queryBuilderWhere("q_sku");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->q_sku, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->q_sku->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field t_01_head
        $filter = $this->queryBuilderWhere("t_01_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->t_01_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->t_01_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field t_02_head
        $filter = $this->queryBuilderWhere("t_02_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->t_02_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->t_02_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field t_03_head
        $filter = $this->queryBuilderWhere("t_03_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->t_03_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->t_03_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field t_04_head
        $filter = $this->queryBuilderWhere("t_04_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->t_04_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->t_04_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field t_05_head
        $filter = $this->queryBuilderWhere("t_05_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->t_05_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->t_05_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field t_06_head
        $filter = $this->queryBuilderWhere("t_06_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->t_06_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->t_06_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field t_07_head
        $filter = $this->queryBuilderWhere("t_07_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->t_07_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->t_07_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field t_08_head
        $filter = $this->queryBuilderWhere("t_08_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->t_08_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->t_08_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field t_09_head
        $filter = $this->queryBuilderWhere("t_09_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->t_09_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->t_09_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field t_10_head
        $filter = $this->queryBuilderWhere("t_10_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->t_10_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->t_10_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field t_11_head
        $filter = $this->queryBuilderWhere("t_11_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->t_11_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->t_11_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field t_12_head
        $filter = $this->queryBuilderWhere("t_12_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->t_12_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->t_12_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field t_13_head
        $filter = $this->queryBuilderWhere("t_13_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->t_13_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->t_13_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field t_14_head
        $filter = $this->queryBuilderWhere("t_14_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->t_14_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->t_14_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field t_15_head
        $filter = $this->queryBuilderWhere("t_15_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->t_15_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->t_15_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_01_head
        $filter = $this->queryBuilderWhere("po_01_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_01_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_01_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_02_head
        $filter = $this->queryBuilderWhere("po_02_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_02_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_02_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_03_head
        $filter = $this->queryBuilderWhere("po_03_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_03_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_03_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_04_head
        $filter = $this->queryBuilderWhere("po_04_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_04_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_04_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_05_head
        $filter = $this->queryBuilderWhere("po_05_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_05_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_05_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_06_head
        $filter = $this->queryBuilderWhere("po_06_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_06_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_06_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_07_head
        $filter = $this->queryBuilderWhere("po_07_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_07_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_07_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_08_head
        $filter = $this->queryBuilderWhere("po_08_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_08_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_08_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_17_head
        $filter = $this->queryBuilderWhere("po_17_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_17_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_17_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_18_head
        $filter = $this->queryBuilderWhere("po_18_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_18_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_18_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_19_head
        $filter = $this->queryBuilderWhere("po_19_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_19_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_19_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_20_head
        $filter = $this->queryBuilderWhere("po_20_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_20_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_20_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field jc_01_head
        $filter = $this->queryBuilderWhere("jc_01_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->jc_01_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->jc_01_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field jc_02_head
        $filter = $this->queryBuilderWhere("jc_02_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->jc_02_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->jc_02_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field jc_03_head
        $filter = $this->queryBuilderWhere("jc_03_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->jc_03_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->jc_03_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field jc_04_head
        $filter = $this->queryBuilderWhere("jc_04_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->jc_04_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->jc_04_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field jc_05_head
        $filter = $this->queryBuilderWhere("jc_05_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->jc_05_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->jc_05_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field jc_06_head
        $filter = $this->queryBuilderWhere("jc_06_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->jc_06_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->jc_06_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field jc_07_head
        $filter = $this->queryBuilderWhere("jc_07_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->jc_07_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->jc_07_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field jc_08_head
        $filter = $this->queryBuilderWhere("jc_08_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->jc_08_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->jc_08_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field jc_09_head
        $filter = $this->queryBuilderWhere("jc_09_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->jc_09_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->jc_09_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field jc_10_head
        $filter = $this->queryBuilderWhere("jc_10_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->jc_10_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->jc_10_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_shape
        $filter = $this->queryBuilderWhere("pc_shape");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_shape, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_shape->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_unit
        $filter = $this->queryBuilderWhere("pc_unit");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_unit, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_unit->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_w
        $filter = $this->queryBuilderWhere("pc_w");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_w, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_w->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_l
        $filter = $this->queryBuilderWhere("pc_l");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_l, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_l->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_h
        $filter = $this->queryBuilderWhere("pc_h");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_h, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_h->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_partner_size
        $filter = $this->queryBuilderWhere("pc_partner_size");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_partner_size, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_partner_size->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_sqm
        $filter = $this->queryBuilderWhere("pc_sqm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_sqm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_sqm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_01_head
        $filter = $this->queryBuilderWhere("pc_01_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_01_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_01_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_02_head
        $filter = $this->queryBuilderWhere("pc_02_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_02_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_02_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_03_head
        $filter = $this->queryBuilderWhere("pc_03_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_03_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_03_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_04_head
        $filter = $this->queryBuilderWhere("pc_04_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_04_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_04_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_05_head
        $filter = $this->queryBuilderWhere("pc_05_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_05_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_05_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_06_head
        $filter = $this->queryBuilderWhere("pc_06_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_06_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_06_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_07_head
        $filter = $this->queryBuilderWhere("pc_07_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_07_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_07_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_08_head
        $filter = $this->queryBuilderWhere("pc_08_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_08_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_08_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_09_head
        $filter = $this->queryBuilderWhere("pc_09_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_09_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_09_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_10_head
        $filter = $this->queryBuilderWhere("pc_10_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_10_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_10_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_11_head
        $filter = $this->queryBuilderWhere("pc_11_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_11_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_11_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_12_head
        $filter = $this->queryBuilderWhere("pc_12_head");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_12_head, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_12_head->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field operator
        $filter = $this->queryBuilderWhere("operator");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->operator, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->operator->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field datetime
        $filter = $this->queryBuilderWhere("datetime");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->datetime, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->datetime->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field image
        $filter = $this->queryBuilderWhere("image");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->image, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->image->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_process_size_w
        $filter = $this->queryBuilderWhere("pa_process_size_w");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_process_size_w, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_process_size_w->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_process_size_l
        $filter = $this->queryBuilderWhere("pa_process_size_l");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_process_size_l, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_process_size_l->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_head_01
        $filter = $this->queryBuilderWhere("pa_head_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_head_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_head_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_process_01
        $filter = $this->queryBuilderWhere("pa_process_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_process_01, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_process_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_head_02
        $filter = $this->queryBuilderWhere("pa_head_02");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_head_02, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_head_02->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_process_02
        $filter = $this->queryBuilderWhere("pa_process_02");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_process_02, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_process_02->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_head_03
        $filter = $this->queryBuilderWhere("pa_head_03");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_head_03, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_head_03->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_process_03
        $filter = $this->queryBuilderWhere("pa_process_03");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_process_03, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_process_03->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_head_04
        $filter = $this->queryBuilderWhere("pa_head_04");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_head_04, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_head_04->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_process_04
        $filter = $this->queryBuilderWhere("pa_process_04");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_process_04, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_process_04->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_head_05
        $filter = $this->queryBuilderWhere("pa_head_05");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_head_05, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_head_05->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_process_05
        $filter = $this->queryBuilderWhere("pa_process_05");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_process_05, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_process_05->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_head_06
        $filter = $this->queryBuilderWhere("pa_head_06");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_head_06, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_head_06->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_process_06
        $filter = $this->queryBuilderWhere("pa_process_06");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_process_06, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_process_06->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_head_07
        $filter = $this->queryBuilderWhere("pa_head_07");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_head_07, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_head_07->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_process_07
        $filter = $this->queryBuilderWhere("pa_process_07");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_process_07, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_process_07->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_head_08
        $filter = $this->queryBuilderWhere("pa_head_08");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_head_08, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_head_08->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_process_08
        $filter = $this->queryBuilderWhere("pa_process_08");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_process_08, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_process_08->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_head_09
        $filter = $this->queryBuilderWhere("pa_head_09");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_head_09, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_head_09->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_process_09
        $filter = $this->queryBuilderWhere("pa_process_09");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_process_09, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_process_09->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_head_10
        $filter = $this->queryBuilderWhere("pa_head_10");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_head_10, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_head_10->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_process_10
        $filter = $this->queryBuilderWhere("pa_process_10");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_process_10, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_process_10->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field publish
        $filter = $this->queryBuilderWhere("publish");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->publish, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->publish->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ppr_01
        $filter = $this->queryBuilderWhere("ppr_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ppr_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ppr_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ppr_02
        $filter = $this->queryBuilderWhere("ppr_02");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ppr_02, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ppr_02->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ppr_03
        $filter = $this->queryBuilderWhere("ppr_03");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ppr_03, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ppr_03->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ppr_04
        $filter = $this->queryBuilderWhere("ppr_04");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ppr_04, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ppr_04->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ppr_05
        $filter = $this->queryBuilderWhere("ppr_05");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ppr_05, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ppr_05->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ppr_06
        $filter = $this->queryBuilderWhere("ppr_06");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ppr_06, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ppr_06->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->grp;
        $searchFlds[] = &$this->product_group;
        $searchFlds[] = &$this->shape;
        $searchFlds[] = &$this->sqm;
        $searchFlds[] = &$this->cbm;
        $searchFlds[] = &$this->status;
        $searchFlds[] = &$this->v_00;
        $searchFlds[] = &$this->v_01;
        $searchFlds[] = &$this->v_01_validation;
        $searchFlds[] = &$this->v_02;
        $searchFlds[] = &$this->v_02_validation;
        $searchFlds[] = &$this->v_03;
        $searchFlds[] = &$this->v_03_validation;
        $searchFlds[] = &$this->v_04;
        $searchFlds[] = &$this->v_04_validation;
        $searchFlds[] = &$this->v_05;
        $searchFlds[] = &$this->v_05_validation;
        $searchFlds[] = &$this->v_06;
        $searchFlds[] = &$this->v_06_validation;
        $searchFlds[] = &$this->v_07;
        $searchFlds[] = &$this->v_07_validation;
        $searchFlds[] = &$this->v_08;
        $searchFlds[] = &$this->v_08_validation;
        $searchFlds[] = &$this->v_09;
        $searchFlds[] = &$this->v_09_validation;
        $searchFlds[] = &$this->v_10;
        $searchFlds[] = &$this->v_10_validation;
        $searchFlds[] = &$this->b_01_head;
        $searchFlds[] = &$this->b_02_head;
        $searchFlds[] = &$this->b_03_head;
        $searchFlds[] = &$this->b_04_head;
        $searchFlds[] = &$this->b_05_head;
        $searchFlds[] = &$this->b_06_head;
        $searchFlds[] = &$this->b_07_head;
        $searchFlds[] = &$this->b_08_head;
        $searchFlds[] = &$this->b_09_head;
        $searchFlds[] = &$this->b_10_head;
        $searchFlds[] = &$this->b_11_head;
        $searchFlds[] = &$this->b_12_head;
        $searchFlds[] = &$this->b_13_head;
        $searchFlds[] = &$this->b_14_head;
        $searchFlds[] = &$this->b_15_head;
        $searchFlds[] = &$this->t_01_head;
        $searchFlds[] = &$this->t_02_head;
        $searchFlds[] = &$this->t_03_head;
        $searchFlds[] = &$this->t_04_head;
        $searchFlds[] = &$this->t_05_head;
        $searchFlds[] = &$this->t_06_head;
        $searchFlds[] = &$this->t_07_head;
        $searchFlds[] = &$this->t_08_head;
        $searchFlds[] = &$this->t_09_head;
        $searchFlds[] = &$this->t_10_head;
        $searchFlds[] = &$this->t_11_head;
        $searchFlds[] = &$this->t_12_head;
        $searchFlds[] = &$this->t_13_head;
        $searchFlds[] = &$this->t_14_head;
        $searchFlds[] = &$this->t_15_head;
        $searchFlds[] = &$this->po_01_head;
        $searchFlds[] = &$this->po_02_head;
        $searchFlds[] = &$this->po_03_head;
        $searchFlds[] = &$this->po_04_head;
        $searchFlds[] = &$this->po_05_head;
        $searchFlds[] = &$this->po_06_head;
        $searchFlds[] = &$this->po_07_head;
        $searchFlds[] = &$this->po_08_head;
        $searchFlds[] = &$this->po_17_head;
        $searchFlds[] = &$this->po_18_head;
        $searchFlds[] = &$this->po_19_head;
        $searchFlds[] = &$this->po_20_head;
        $searchFlds[] = &$this->jc_01_head;
        $searchFlds[] = &$this->jc_02_head;
        $searchFlds[] = &$this->jc_03_head;
        $searchFlds[] = &$this->jc_04_head;
        $searchFlds[] = &$this->jc_05_head;
        $searchFlds[] = &$this->jc_06_head;
        $searchFlds[] = &$this->jc_07_head;
        $searchFlds[] = &$this->jc_08_head;
        $searchFlds[] = &$this->jc_09_head;
        $searchFlds[] = &$this->jc_10_head;
        $searchFlds[] = &$this->pc_shape;
        $searchFlds[] = &$this->pc_unit;
        $searchFlds[] = &$this->pc_w;
        $searchFlds[] = &$this->pc_l;
        $searchFlds[] = &$this->pc_h;
        $searchFlds[] = &$this->pc_partner_size;
        $searchFlds[] = &$this->pc_sqm;
        $searchFlds[] = &$this->pc_01_head;
        $searchFlds[] = &$this->pc_02_head;
        $searchFlds[] = &$this->pc_03_head;
        $searchFlds[] = &$this->pc_04_head;
        $searchFlds[] = &$this->pc_05_head;
        $searchFlds[] = &$this->pc_06_head;
        $searchFlds[] = &$this->pc_07_head;
        $searchFlds[] = &$this->pc_08_head;
        $searchFlds[] = &$this->pc_09_head;
        $searchFlds[] = &$this->pc_10_head;
        $searchFlds[] = &$this->pc_11_head;
        $searchFlds[] = &$this->pc_12_head;
        $searchFlds[] = &$this->operator;
        $searchFlds[] = &$this->datetime;
        $searchFlds[] = &$this->image;
        $searchFlds[] = &$this->pa_process_size_w;
        $searchFlds[] = &$this->pa_process_size_l;
        $searchFlds[] = &$this->pa_head_01;
        $searchFlds[] = &$this->pa_process_01;
        $searchFlds[] = &$this->pa_head_02;
        $searchFlds[] = &$this->pa_process_02;
        $searchFlds[] = &$this->pa_head_03;
        $searchFlds[] = &$this->pa_process_03;
        $searchFlds[] = &$this->pa_head_04;
        $searchFlds[] = &$this->pa_process_04;
        $searchFlds[] = &$this->pa_head_05;
        $searchFlds[] = &$this->pa_process_05;
        $searchFlds[] = &$this->pa_head_06;
        $searchFlds[] = &$this->pa_process_06;
        $searchFlds[] = &$this->pa_head_07;
        $searchFlds[] = &$this->pa_process_07;
        $searchFlds[] = &$this->pa_head_08;
        $searchFlds[] = &$this->pa_process_08;
        $searchFlds[] = &$this->pa_head_09;
        $searchFlds[] = &$this->pa_process_09;
        $searchFlds[] = &$this->pa_head_10;
        $searchFlds[] = &$this->pa_process_10;
        $searchFlds[] = &$this->ppr_01;
        $searchFlds[] = &$this->ppr_02;
        $searchFlds[] = &$this->ppr_03;
        $searchFlds[] = &$this->ppr_04;
        $searchFlds[] = &$this->ppr_05;
        $searchFlds[] = &$this->ppr_06;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->product_group->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->calculation_method->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->shape->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sqm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cbm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->process->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_00->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_01_validation->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_02_validation->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_03->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_03_validation->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_04->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_04_validation->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_05->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_05_validation->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_06->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_06_validation->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_07->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_07_validation->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_08->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_08_validation->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_09->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_09_validation->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_10->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_10_validation->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_01_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_02_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_03_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_04_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_05_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_06_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_07_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_08_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_09_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_10_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_11_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_12_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_13_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_14_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_15_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->q_sku->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_01_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_02_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_03_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_04_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_05_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_06_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_07_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_08_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_09_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_10_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_11_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_12_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_13_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_14_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_15_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_01_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_02_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_03_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_04_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_05_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_06_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_07_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_08_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_17_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_18_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_19_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_20_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->jc_01_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->jc_02_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->jc_03_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->jc_04_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->jc_05_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->jc_06_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->jc_07_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->jc_08_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->jc_09_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->jc_10_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_shape->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_unit->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_w->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_l->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_h->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_partner_size->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_sqm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_01_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_02_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_03_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_04_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_05_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_06_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_07_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_08_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_09_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_10_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_11_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_12_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->image->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_process_size_w->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_process_size_l->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_head_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_process_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_head_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_process_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_head_03->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_process_03->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_head_04->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_process_04->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_head_05->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_process_05->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_head_06->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_process_06->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_head_07->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_process_07->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_head_08->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_process_08->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_head_09->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_process_09->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_head_10->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_process_10->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->publish->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ppr_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ppr_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ppr_03->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ppr_04->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ppr_05->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ppr_06->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->id->AdvancedSearch->unsetSession();
        $this->grp->AdvancedSearch->unsetSession();
        $this->product_group->AdvancedSearch->unsetSession();
        $this->calculation_method->AdvancedSearch->unsetSession();
        $this->shape->AdvancedSearch->unsetSession();
        $this->sqm->AdvancedSearch->unsetSession();
        $this->cbm->AdvancedSearch->unsetSession();
        $this->process->AdvancedSearch->unsetSession();
        $this->status->AdvancedSearch->unsetSession();
        $this->v_00->AdvancedSearch->unsetSession();
        $this->v_01->AdvancedSearch->unsetSession();
        $this->v_01_validation->AdvancedSearch->unsetSession();
        $this->v_02->AdvancedSearch->unsetSession();
        $this->v_02_validation->AdvancedSearch->unsetSession();
        $this->v_03->AdvancedSearch->unsetSession();
        $this->v_03_validation->AdvancedSearch->unsetSession();
        $this->v_04->AdvancedSearch->unsetSession();
        $this->v_04_validation->AdvancedSearch->unsetSession();
        $this->v_05->AdvancedSearch->unsetSession();
        $this->v_05_validation->AdvancedSearch->unsetSession();
        $this->v_06->AdvancedSearch->unsetSession();
        $this->v_06_validation->AdvancedSearch->unsetSession();
        $this->v_07->AdvancedSearch->unsetSession();
        $this->v_07_validation->AdvancedSearch->unsetSession();
        $this->v_08->AdvancedSearch->unsetSession();
        $this->v_08_validation->AdvancedSearch->unsetSession();
        $this->v_09->AdvancedSearch->unsetSession();
        $this->v_09_validation->AdvancedSearch->unsetSession();
        $this->v_10->AdvancedSearch->unsetSession();
        $this->v_10_validation->AdvancedSearch->unsetSession();
        $this->b_01_head->AdvancedSearch->unsetSession();
        $this->b_02_head->AdvancedSearch->unsetSession();
        $this->b_03_head->AdvancedSearch->unsetSession();
        $this->b_04_head->AdvancedSearch->unsetSession();
        $this->b_05_head->AdvancedSearch->unsetSession();
        $this->b_06_head->AdvancedSearch->unsetSession();
        $this->b_07_head->AdvancedSearch->unsetSession();
        $this->b_08_head->AdvancedSearch->unsetSession();
        $this->b_09_head->AdvancedSearch->unsetSession();
        $this->b_10_head->AdvancedSearch->unsetSession();
        $this->b_11_head->AdvancedSearch->unsetSession();
        $this->b_12_head->AdvancedSearch->unsetSession();
        $this->b_13_head->AdvancedSearch->unsetSession();
        $this->b_14_head->AdvancedSearch->unsetSession();
        $this->b_15_head->AdvancedSearch->unsetSession();
        $this->q_sku->AdvancedSearch->unsetSession();
        $this->t_01_head->AdvancedSearch->unsetSession();
        $this->t_02_head->AdvancedSearch->unsetSession();
        $this->t_03_head->AdvancedSearch->unsetSession();
        $this->t_04_head->AdvancedSearch->unsetSession();
        $this->t_05_head->AdvancedSearch->unsetSession();
        $this->t_06_head->AdvancedSearch->unsetSession();
        $this->t_07_head->AdvancedSearch->unsetSession();
        $this->t_08_head->AdvancedSearch->unsetSession();
        $this->t_09_head->AdvancedSearch->unsetSession();
        $this->t_10_head->AdvancedSearch->unsetSession();
        $this->t_11_head->AdvancedSearch->unsetSession();
        $this->t_12_head->AdvancedSearch->unsetSession();
        $this->t_13_head->AdvancedSearch->unsetSession();
        $this->t_14_head->AdvancedSearch->unsetSession();
        $this->t_15_head->AdvancedSearch->unsetSession();
        $this->po_01_head->AdvancedSearch->unsetSession();
        $this->po_02_head->AdvancedSearch->unsetSession();
        $this->po_03_head->AdvancedSearch->unsetSession();
        $this->po_04_head->AdvancedSearch->unsetSession();
        $this->po_05_head->AdvancedSearch->unsetSession();
        $this->po_06_head->AdvancedSearch->unsetSession();
        $this->po_07_head->AdvancedSearch->unsetSession();
        $this->po_08_head->AdvancedSearch->unsetSession();
        $this->po_17_head->AdvancedSearch->unsetSession();
        $this->po_18_head->AdvancedSearch->unsetSession();
        $this->po_19_head->AdvancedSearch->unsetSession();
        $this->po_20_head->AdvancedSearch->unsetSession();
        $this->jc_01_head->AdvancedSearch->unsetSession();
        $this->jc_02_head->AdvancedSearch->unsetSession();
        $this->jc_03_head->AdvancedSearch->unsetSession();
        $this->jc_04_head->AdvancedSearch->unsetSession();
        $this->jc_05_head->AdvancedSearch->unsetSession();
        $this->jc_06_head->AdvancedSearch->unsetSession();
        $this->jc_07_head->AdvancedSearch->unsetSession();
        $this->jc_08_head->AdvancedSearch->unsetSession();
        $this->jc_09_head->AdvancedSearch->unsetSession();
        $this->jc_10_head->AdvancedSearch->unsetSession();
        $this->pc_shape->AdvancedSearch->unsetSession();
        $this->pc_unit->AdvancedSearch->unsetSession();
        $this->pc_w->AdvancedSearch->unsetSession();
        $this->pc_l->AdvancedSearch->unsetSession();
        $this->pc_h->AdvancedSearch->unsetSession();
        $this->pc_partner_size->AdvancedSearch->unsetSession();
        $this->pc_sqm->AdvancedSearch->unsetSession();
        $this->pc_01_head->AdvancedSearch->unsetSession();
        $this->pc_02_head->AdvancedSearch->unsetSession();
        $this->pc_03_head->AdvancedSearch->unsetSession();
        $this->pc_04_head->AdvancedSearch->unsetSession();
        $this->pc_05_head->AdvancedSearch->unsetSession();
        $this->pc_06_head->AdvancedSearch->unsetSession();
        $this->pc_07_head->AdvancedSearch->unsetSession();
        $this->pc_08_head->AdvancedSearch->unsetSession();
        $this->pc_09_head->AdvancedSearch->unsetSession();
        $this->pc_10_head->AdvancedSearch->unsetSession();
        $this->pc_11_head->AdvancedSearch->unsetSession();
        $this->pc_12_head->AdvancedSearch->unsetSession();
        $this->operator->AdvancedSearch->unsetSession();
        $this->datetime->AdvancedSearch->unsetSession();
        $this->image->AdvancedSearch->unsetSession();
        $this->pa_process_size_w->AdvancedSearch->unsetSession();
        $this->pa_process_size_l->AdvancedSearch->unsetSession();
        $this->pa_head_01->AdvancedSearch->unsetSession();
        $this->pa_process_01->AdvancedSearch->unsetSession();
        $this->pa_head_02->AdvancedSearch->unsetSession();
        $this->pa_process_02->AdvancedSearch->unsetSession();
        $this->pa_head_03->AdvancedSearch->unsetSession();
        $this->pa_process_03->AdvancedSearch->unsetSession();
        $this->pa_head_04->AdvancedSearch->unsetSession();
        $this->pa_process_04->AdvancedSearch->unsetSession();
        $this->pa_head_05->AdvancedSearch->unsetSession();
        $this->pa_process_05->AdvancedSearch->unsetSession();
        $this->pa_head_06->AdvancedSearch->unsetSession();
        $this->pa_process_06->AdvancedSearch->unsetSession();
        $this->pa_head_07->AdvancedSearch->unsetSession();
        $this->pa_process_07->AdvancedSearch->unsetSession();
        $this->pa_head_08->AdvancedSearch->unsetSession();
        $this->pa_process_08->AdvancedSearch->unsetSession();
        $this->pa_head_09->AdvancedSearch->unsetSession();
        $this->pa_process_09->AdvancedSearch->unsetSession();
        $this->pa_head_10->AdvancedSearch->unsetSession();
        $this->pa_process_10->AdvancedSearch->unsetSession();
        $this->publish->AdvancedSearch->unsetSession();
        $this->ppr_01->AdvancedSearch->unsetSession();
        $this->ppr_02->AdvancedSearch->unsetSession();
        $this->ppr_03->AdvancedSearch->unsetSession();
        $this->ppr_04->AdvancedSearch->unsetSession();
        $this->ppr_05->AdvancedSearch->unsetSession();
        $this->ppr_06->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->id->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->product_group->AdvancedSearch->load();
        $this->calculation_method->AdvancedSearch->load();
        $this->shape->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->process->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->v_00->AdvancedSearch->load();
        $this->v_01->AdvancedSearch->load();
        $this->v_01_validation->AdvancedSearch->load();
        $this->v_02->AdvancedSearch->load();
        $this->v_02_validation->AdvancedSearch->load();
        $this->v_03->AdvancedSearch->load();
        $this->v_03_validation->AdvancedSearch->load();
        $this->v_04->AdvancedSearch->load();
        $this->v_04_validation->AdvancedSearch->load();
        $this->v_05->AdvancedSearch->load();
        $this->v_05_validation->AdvancedSearch->load();
        $this->v_06->AdvancedSearch->load();
        $this->v_06_validation->AdvancedSearch->load();
        $this->v_07->AdvancedSearch->load();
        $this->v_07_validation->AdvancedSearch->load();
        $this->v_08->AdvancedSearch->load();
        $this->v_08_validation->AdvancedSearch->load();
        $this->v_09->AdvancedSearch->load();
        $this->v_09_validation->AdvancedSearch->load();
        $this->v_10->AdvancedSearch->load();
        $this->v_10_validation->AdvancedSearch->load();
        $this->b_01_head->AdvancedSearch->load();
        $this->b_02_head->AdvancedSearch->load();
        $this->b_03_head->AdvancedSearch->load();
        $this->b_04_head->AdvancedSearch->load();
        $this->b_05_head->AdvancedSearch->load();
        $this->b_06_head->AdvancedSearch->load();
        $this->b_07_head->AdvancedSearch->load();
        $this->b_08_head->AdvancedSearch->load();
        $this->b_09_head->AdvancedSearch->load();
        $this->b_10_head->AdvancedSearch->load();
        $this->b_11_head->AdvancedSearch->load();
        $this->b_12_head->AdvancedSearch->load();
        $this->b_13_head->AdvancedSearch->load();
        $this->b_14_head->AdvancedSearch->load();
        $this->b_15_head->AdvancedSearch->load();
        $this->q_sku->AdvancedSearch->load();
        $this->t_01_head->AdvancedSearch->load();
        $this->t_02_head->AdvancedSearch->load();
        $this->t_03_head->AdvancedSearch->load();
        $this->t_04_head->AdvancedSearch->load();
        $this->t_05_head->AdvancedSearch->load();
        $this->t_06_head->AdvancedSearch->load();
        $this->t_07_head->AdvancedSearch->load();
        $this->t_08_head->AdvancedSearch->load();
        $this->t_09_head->AdvancedSearch->load();
        $this->t_10_head->AdvancedSearch->load();
        $this->t_11_head->AdvancedSearch->load();
        $this->t_12_head->AdvancedSearch->load();
        $this->t_13_head->AdvancedSearch->load();
        $this->t_14_head->AdvancedSearch->load();
        $this->t_15_head->AdvancedSearch->load();
        $this->po_01_head->AdvancedSearch->load();
        $this->po_02_head->AdvancedSearch->load();
        $this->po_03_head->AdvancedSearch->load();
        $this->po_04_head->AdvancedSearch->load();
        $this->po_05_head->AdvancedSearch->load();
        $this->po_06_head->AdvancedSearch->load();
        $this->po_07_head->AdvancedSearch->load();
        $this->po_08_head->AdvancedSearch->load();
        $this->po_17_head->AdvancedSearch->load();
        $this->po_18_head->AdvancedSearch->load();
        $this->po_19_head->AdvancedSearch->load();
        $this->po_20_head->AdvancedSearch->load();
        $this->jc_01_head->AdvancedSearch->load();
        $this->jc_02_head->AdvancedSearch->load();
        $this->jc_03_head->AdvancedSearch->load();
        $this->jc_04_head->AdvancedSearch->load();
        $this->jc_05_head->AdvancedSearch->load();
        $this->jc_06_head->AdvancedSearch->load();
        $this->jc_07_head->AdvancedSearch->load();
        $this->jc_08_head->AdvancedSearch->load();
        $this->jc_09_head->AdvancedSearch->load();
        $this->jc_10_head->AdvancedSearch->load();
        $this->pc_shape->AdvancedSearch->load();
        $this->pc_unit->AdvancedSearch->load();
        $this->pc_w->AdvancedSearch->load();
        $this->pc_l->AdvancedSearch->load();
        $this->pc_h->AdvancedSearch->load();
        $this->pc_partner_size->AdvancedSearch->load();
        $this->pc_sqm->AdvancedSearch->load();
        $this->pc_01_head->AdvancedSearch->load();
        $this->pc_02_head->AdvancedSearch->load();
        $this->pc_03_head->AdvancedSearch->load();
        $this->pc_04_head->AdvancedSearch->load();
        $this->pc_05_head->AdvancedSearch->load();
        $this->pc_06_head->AdvancedSearch->load();
        $this->pc_07_head->AdvancedSearch->load();
        $this->pc_08_head->AdvancedSearch->load();
        $this->pc_09_head->AdvancedSearch->load();
        $this->pc_10_head->AdvancedSearch->load();
        $this->pc_11_head->AdvancedSearch->load();
        $this->pc_12_head->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->image->AdvancedSearch->load();
        $this->pa_process_size_w->AdvancedSearch->load();
        $this->pa_process_size_l->AdvancedSearch->load();
        $this->pa_head_01->AdvancedSearch->load();
        $this->pa_process_01->AdvancedSearch->load();
        $this->pa_head_02->AdvancedSearch->load();
        $this->pa_process_02->AdvancedSearch->load();
        $this->pa_head_03->AdvancedSearch->load();
        $this->pa_process_03->AdvancedSearch->load();
        $this->pa_head_04->AdvancedSearch->load();
        $this->pa_process_04->AdvancedSearch->load();
        $this->pa_head_05->AdvancedSearch->load();
        $this->pa_process_05->AdvancedSearch->load();
        $this->pa_head_06->AdvancedSearch->load();
        $this->pa_process_06->AdvancedSearch->load();
        $this->pa_head_07->AdvancedSearch->load();
        $this->pa_process_07->AdvancedSearch->load();
        $this->pa_head_08->AdvancedSearch->load();
        $this->pa_process_08->AdvancedSearch->load();
        $this->pa_head_09->AdvancedSearch->load();
        $this->pa_process_09->AdvancedSearch->load();
        $this->pa_head_10->AdvancedSearch->load();
        $this->pa_process_10->AdvancedSearch->load();
        $this->publish->AdvancedSearch->load();
        $this->ppr_01->AdvancedSearch->load();
        $this->ppr_02->AdvancedSearch->load();
        $this->ppr_03->AdvancedSearch->load();
        $this->ppr_04->AdvancedSearch->load();
        $this->ppr_05->AdvancedSearch->load();
        $this->ppr_06->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " ASC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for Ctrl pressed
        $ctrl = Get("ctrl") !== null;

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id, $ctrl); // id
            $this->updateSort($this->grp, $ctrl); // grp
            $this->updateSort($this->product_group, $ctrl); // product_group
            $this->updateSort($this->calculation_method, $ctrl); // calculation_method
            $this->updateSort($this->shape, $ctrl); // shape
            $this->updateSort($this->sqm, $ctrl); // sqm
            $this->updateSort($this->cbm, $ctrl); // cbm
            $this->updateSort($this->process, $ctrl); // process
            $this->updateSort($this->status, $ctrl); // status
            $this->updateSort($this->v_00, $ctrl); // v_00
            $this->updateSort($this->v_01, $ctrl); // v_01
            $this->updateSort($this->v_01_validation, $ctrl); // v_01_validation
            $this->updateSort($this->v_02, $ctrl); // v_02
            $this->updateSort($this->v_02_validation, $ctrl); // v_02_validation
            $this->updateSort($this->v_03, $ctrl); // v_03
            $this->updateSort($this->v_03_validation, $ctrl); // v_03_validation
            $this->updateSort($this->v_04, $ctrl); // v_04
            $this->updateSort($this->v_04_validation, $ctrl); // v_04_validation
            $this->updateSort($this->v_05, $ctrl); // v_05
            $this->updateSort($this->v_05_validation, $ctrl); // v_05_validation
            $this->updateSort($this->v_06, $ctrl); // v_06
            $this->updateSort($this->v_06_validation, $ctrl); // v_06_validation
            $this->updateSort($this->v_07, $ctrl); // v_07
            $this->updateSort($this->v_07_validation, $ctrl); // v_07_validation
            $this->updateSort($this->v_08, $ctrl); // v_08
            $this->updateSort($this->v_08_validation, $ctrl); // v_08_validation
            $this->updateSort($this->v_09, $ctrl); // v_09
            $this->updateSort($this->v_09_validation, $ctrl); // v_09_validation
            $this->updateSort($this->v_10, $ctrl); // v_10
            $this->updateSort($this->v_10_validation, $ctrl); // v_10_validation
            $this->updateSort($this->b_01_head, $ctrl); // b_01_head
            $this->updateSort($this->b_02_head, $ctrl); // b_02_head
            $this->updateSort($this->b_03_head, $ctrl); // b_03_head
            $this->updateSort($this->b_04_head, $ctrl); // b_04_head
            $this->updateSort($this->b_05_head, $ctrl); // b_05_head
            $this->updateSort($this->b_06_head, $ctrl); // b_06_head
            $this->updateSort($this->b_07_head, $ctrl); // b_07_head
            $this->updateSort($this->b_08_head, $ctrl); // b_08_head
            $this->updateSort($this->b_09_head, $ctrl); // b_09_head
            $this->updateSort($this->b_10_head, $ctrl); // b_10_head
            $this->updateSort($this->b_11_head, $ctrl); // b_11_head
            $this->updateSort($this->b_12_head, $ctrl); // b_12_head
            $this->updateSort($this->b_13_head, $ctrl); // b_13_head
            $this->updateSort($this->b_14_head, $ctrl); // b_14_head
            $this->updateSort($this->b_15_head, $ctrl); // b_15_head
            $this->updateSort($this->q_sku, $ctrl); // q_sku
            $this->updateSort($this->t_01_head, $ctrl); // t_01_head
            $this->updateSort($this->t_02_head, $ctrl); // t_02_head
            $this->updateSort($this->t_03_head, $ctrl); // t_03_head
            $this->updateSort($this->t_04_head, $ctrl); // t_04_head
            $this->updateSort($this->t_05_head, $ctrl); // t_05_head
            $this->updateSort($this->t_06_head, $ctrl); // t_06_head
            $this->updateSort($this->t_07_head, $ctrl); // t_07_head
            $this->updateSort($this->t_08_head, $ctrl); // t_08_head
            $this->updateSort($this->t_09_head, $ctrl); // t_09_head
            $this->updateSort($this->t_10_head, $ctrl); // t_10_head
            $this->updateSort($this->t_11_head, $ctrl); // t_11_head
            $this->updateSort($this->t_12_head, $ctrl); // t_12_head
            $this->updateSort($this->t_13_head, $ctrl); // t_13_head
            $this->updateSort($this->t_14_head, $ctrl); // t_14_head
            $this->updateSort($this->t_15_head, $ctrl); // t_15_head
            $this->updateSort($this->po_01_head, $ctrl); // po_01_head
            $this->updateSort($this->po_02_head, $ctrl); // po_02_head
            $this->updateSort($this->po_03_head, $ctrl); // po_03_head
            $this->updateSort($this->po_04_head, $ctrl); // po_04_head
            $this->updateSort($this->po_05_head, $ctrl); // po_05_head
            $this->updateSort($this->po_06_head, $ctrl); // po_06_head
            $this->updateSort($this->po_07_head, $ctrl); // po_07_head
            $this->updateSort($this->po_08_head, $ctrl); // po_08_head
            $this->updateSort($this->po_17_head, $ctrl); // po_17_head
            $this->updateSort($this->po_18_head, $ctrl); // po_18_head
            $this->updateSort($this->po_19_head, $ctrl); // po_19_head
            $this->updateSort($this->po_20_head, $ctrl); // po_20_head
            $this->updateSort($this->jc_01_head, $ctrl); // jc_01_head
            $this->updateSort($this->jc_02_head, $ctrl); // jc_02_head
            $this->updateSort($this->jc_03_head, $ctrl); // jc_03_head
            $this->updateSort($this->jc_04_head, $ctrl); // jc_04_head
            $this->updateSort($this->jc_05_head, $ctrl); // jc_05_head
            $this->updateSort($this->jc_06_head, $ctrl); // jc_06_head
            $this->updateSort($this->jc_07_head, $ctrl); // jc_07_head
            $this->updateSort($this->jc_08_head, $ctrl); // jc_08_head
            $this->updateSort($this->jc_09_head, $ctrl); // jc_09_head
            $this->updateSort($this->jc_10_head, $ctrl); // jc_10_head
            $this->updateSort($this->pc_shape, $ctrl); // pc_shape
            $this->updateSort($this->pc_unit, $ctrl); // pc_unit
            $this->updateSort($this->pc_w, $ctrl); // pc_w
            $this->updateSort($this->pc_l, $ctrl); // pc_l
            $this->updateSort($this->pc_h, $ctrl); // pc_h
            $this->updateSort($this->pc_partner_size, $ctrl); // pc_partner_size
            $this->updateSort($this->pc_sqm, $ctrl); // pc_sqm
            $this->updateSort($this->pc_01_head, $ctrl); // pc_01_head
            $this->updateSort($this->pc_02_head, $ctrl); // pc_02_head
            $this->updateSort($this->pc_03_head, $ctrl); // pc_03_head
            $this->updateSort($this->pc_04_head, $ctrl); // pc_04_head
            $this->updateSort($this->pc_05_head, $ctrl); // pc_05_head
            $this->updateSort($this->pc_06_head, $ctrl); // pc_06_head
            $this->updateSort($this->pc_07_head, $ctrl); // pc_07_head
            $this->updateSort($this->pc_08_head, $ctrl); // pc_08_head
            $this->updateSort($this->pc_09_head, $ctrl); // pc_09_head
            $this->updateSort($this->pc_10_head, $ctrl); // pc_10_head
            $this->updateSort($this->pc_11_head, $ctrl); // pc_11_head
            $this->updateSort($this->pc_12_head, $ctrl); // pc_12_head
            $this->updateSort($this->operator, $ctrl); // operator
            $this->updateSort($this->datetime, $ctrl); // datetime
            $this->updateSort($this->image, $ctrl); // image
            $this->updateSort($this->pa_process_size_w, $ctrl); // pa_process_size_w
            $this->updateSort($this->pa_process_size_l, $ctrl); // pa_process_size_l
            $this->updateSort($this->pa_head_01, $ctrl); // pa_head_01
            $this->updateSort($this->pa_process_01, $ctrl); // pa_process_01
            $this->updateSort($this->pa_head_02, $ctrl); // pa_head_02
            $this->updateSort($this->pa_process_02, $ctrl); // pa_process_02
            $this->updateSort($this->pa_head_03, $ctrl); // pa_head_03
            $this->updateSort($this->pa_process_03, $ctrl); // pa_process_03
            $this->updateSort($this->pa_head_04, $ctrl); // pa_head_04
            $this->updateSort($this->pa_process_04, $ctrl); // pa_process_04
            $this->updateSort($this->pa_head_05, $ctrl); // pa_head_05
            $this->updateSort($this->pa_process_05, $ctrl); // pa_process_05
            $this->updateSort($this->pa_head_06, $ctrl); // pa_head_06
            $this->updateSort($this->pa_process_06, $ctrl); // pa_process_06
            $this->updateSort($this->pa_head_07, $ctrl); // pa_head_07
            $this->updateSort($this->pa_process_07, $ctrl); // pa_process_07
            $this->updateSort($this->pa_head_08, $ctrl); // pa_head_08
            $this->updateSort($this->pa_process_08, $ctrl); // pa_process_08
            $this->updateSort($this->pa_head_09, $ctrl); // pa_head_09
            $this->updateSort($this->pa_process_09, $ctrl); // pa_process_09
            $this->updateSort($this->pa_head_10, $ctrl); // pa_head_10
            $this->updateSort($this->pa_process_10, $ctrl); // pa_process_10
            $this->updateSort($this->publish, $ctrl); // publish
            $this->updateSort($this->ppr_01, $ctrl); // ppr_01
            $this->updateSort($this->ppr_02, $ctrl); // ppr_02
            $this->updateSort($this->ppr_03, $ctrl); // ppr_03
            $this->updateSort($this->ppr_04, $ctrl); // ppr_04
            $this->updateSort($this->ppr_05, $ctrl); // ppr_05
            $this->updateSort($this->ppr_06, $ctrl); // ppr_06
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->id->setSort("");
                $this->grp->setSort("");
                $this->product_group->setSort("");
                $this->calculation_method->setSort("");
                $this->shape->setSort("");
                $this->sqm->setSort("");
                $this->cbm->setSort("");
                $this->process->setSort("");
                $this->status->setSort("");
                $this->v_00->setSort("");
                $this->v_01->setSort("");
                $this->v_01_validation->setSort("");
                $this->v_02->setSort("");
                $this->v_02_validation->setSort("");
                $this->v_03->setSort("");
                $this->v_03_validation->setSort("");
                $this->v_04->setSort("");
                $this->v_04_validation->setSort("");
                $this->v_05->setSort("");
                $this->v_05_validation->setSort("");
                $this->v_06->setSort("");
                $this->v_06_validation->setSort("");
                $this->v_07->setSort("");
                $this->v_07_validation->setSort("");
                $this->v_08->setSort("");
                $this->v_08_validation->setSort("");
                $this->v_09->setSort("");
                $this->v_09_validation->setSort("");
                $this->v_10->setSort("");
                $this->v_10_validation->setSort("");
                $this->b_01_head->setSort("");
                $this->b_02_head->setSort("");
                $this->b_03_head->setSort("");
                $this->b_04_head->setSort("");
                $this->b_05_head->setSort("");
                $this->b_06_head->setSort("");
                $this->b_07_head->setSort("");
                $this->b_08_head->setSort("");
                $this->b_09_head->setSort("");
                $this->b_10_head->setSort("");
                $this->b_11_head->setSort("");
                $this->b_12_head->setSort("");
                $this->b_13_head->setSort("");
                $this->b_14_head->setSort("");
                $this->b_15_head->setSort("");
                $this->q_sku->setSort("");
                $this->t_01_head->setSort("");
                $this->t_02_head->setSort("");
                $this->t_03_head->setSort("");
                $this->t_04_head->setSort("");
                $this->t_05_head->setSort("");
                $this->t_06_head->setSort("");
                $this->t_07_head->setSort("");
                $this->t_08_head->setSort("");
                $this->t_09_head->setSort("");
                $this->t_10_head->setSort("");
                $this->t_11_head->setSort("");
                $this->t_12_head->setSort("");
                $this->t_13_head->setSort("");
                $this->t_14_head->setSort("");
                $this->t_15_head->setSort("");
                $this->po_01_head->setSort("");
                $this->po_02_head->setSort("");
                $this->po_03_head->setSort("");
                $this->po_04_head->setSort("");
                $this->po_05_head->setSort("");
                $this->po_06_head->setSort("");
                $this->po_07_head->setSort("");
                $this->po_08_head->setSort("");
                $this->po_17_head->setSort("");
                $this->po_18_head->setSort("");
                $this->po_19_head->setSort("");
                $this->po_20_head->setSort("");
                $this->jc_01_head->setSort("");
                $this->jc_02_head->setSort("");
                $this->jc_03_head->setSort("");
                $this->jc_04_head->setSort("");
                $this->jc_05_head->setSort("");
                $this->jc_06_head->setSort("");
                $this->jc_07_head->setSort("");
                $this->jc_08_head->setSort("");
                $this->jc_09_head->setSort("");
                $this->jc_10_head->setSort("");
                $this->pc_shape->setSort("");
                $this->pc_unit->setSort("");
                $this->pc_w->setSort("");
                $this->pc_l->setSort("");
                $this->pc_h->setSort("");
                $this->pc_partner_size->setSort("");
                $this->pc_sqm->setSort("");
                $this->pc_01_head->setSort("");
                $this->pc_02_head->setSort("");
                $this->pc_03_head->setSort("");
                $this->pc_04_head->setSort("");
                $this->pc_05_head->setSort("");
                $this->pc_06_head->setSort("");
                $this->pc_07_head->setSort("");
                $this->pc_08_head->setSort("");
                $this->pc_09_head->setSort("");
                $this->pc_10_head->setSort("");
                $this->pc_11_head->setSort("");
                $this->pc_12_head->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
                $this->image->setSort("");
                $this->pa_process_size_w->setSort("");
                $this->pa_process_size_l->setSort("");
                $this->pa_head_01->setSort("");
                $this->pa_process_01->setSort("");
                $this->pa_head_02->setSort("");
                $this->pa_process_02->setSort("");
                $this->pa_head_03->setSort("");
                $this->pa_process_03->setSort("");
                $this->pa_head_04->setSort("");
                $this->pa_process_04->setSort("");
                $this->pa_head_05->setSort("");
                $this->pa_process_05->setSort("");
                $this->pa_head_06->setSort("");
                $this->pa_process_06->setSort("");
                $this->pa_head_07->setSort("");
                $this->pa_process_07->setSort("");
                $this->pa_head_08->setSort("");
                $this->pa_process_08->setSort("");
                $this->pa_head_09->setSort("");
                $this->pa_process_09->setSort("");
                $this->pa_head_10->setSort("");
                $this->pa_process_10->setSort("");
                $this->publish->setSort("");
                $this->ppr_01->setSort("");
                $this->ppr_02->setSort("");
                $this->ppr_03->setSort("");
                $this->ppr_04->setSort("");
                $this->ppr_05->setSort("");
                $this->ppr_06->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"product_group\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"product_group\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"product_group\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fproduct_grouplist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fproduct_grouplist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"product_group\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "grp");
            $this->createColumnOption($option, "product_group");
            $this->createColumnOption($option, "calculation_method");
            $this->createColumnOption($option, "shape");
            $this->createColumnOption($option, "sqm");
            $this->createColumnOption($option, "cbm");
            $this->createColumnOption($option, "process");
            $this->createColumnOption($option, "status");
            $this->createColumnOption($option, "v_00");
            $this->createColumnOption($option, "v_01");
            $this->createColumnOption($option, "v_01_validation");
            $this->createColumnOption($option, "v_02");
            $this->createColumnOption($option, "v_02_validation");
            $this->createColumnOption($option, "v_03");
            $this->createColumnOption($option, "v_03_validation");
            $this->createColumnOption($option, "v_04");
            $this->createColumnOption($option, "v_04_validation");
            $this->createColumnOption($option, "v_05");
            $this->createColumnOption($option, "v_05_validation");
            $this->createColumnOption($option, "v_06");
            $this->createColumnOption($option, "v_06_validation");
            $this->createColumnOption($option, "v_07");
            $this->createColumnOption($option, "v_07_validation");
            $this->createColumnOption($option, "v_08");
            $this->createColumnOption($option, "v_08_validation");
            $this->createColumnOption($option, "v_09");
            $this->createColumnOption($option, "v_09_validation");
            $this->createColumnOption($option, "v_10");
            $this->createColumnOption($option, "v_10_validation");
            $this->createColumnOption($option, "b_01_head");
            $this->createColumnOption($option, "b_02_head");
            $this->createColumnOption($option, "b_03_head");
            $this->createColumnOption($option, "b_04_head");
            $this->createColumnOption($option, "b_05_head");
            $this->createColumnOption($option, "b_06_head");
            $this->createColumnOption($option, "b_07_head");
            $this->createColumnOption($option, "b_08_head");
            $this->createColumnOption($option, "b_09_head");
            $this->createColumnOption($option, "b_10_head");
            $this->createColumnOption($option, "b_11_head");
            $this->createColumnOption($option, "b_12_head");
            $this->createColumnOption($option, "b_13_head");
            $this->createColumnOption($option, "b_14_head");
            $this->createColumnOption($option, "b_15_head");
            $this->createColumnOption($option, "q_sku");
            $this->createColumnOption($option, "t_01_head");
            $this->createColumnOption($option, "t_02_head");
            $this->createColumnOption($option, "t_03_head");
            $this->createColumnOption($option, "t_04_head");
            $this->createColumnOption($option, "t_05_head");
            $this->createColumnOption($option, "t_06_head");
            $this->createColumnOption($option, "t_07_head");
            $this->createColumnOption($option, "t_08_head");
            $this->createColumnOption($option, "t_09_head");
            $this->createColumnOption($option, "t_10_head");
            $this->createColumnOption($option, "t_11_head");
            $this->createColumnOption($option, "t_12_head");
            $this->createColumnOption($option, "t_13_head");
            $this->createColumnOption($option, "t_14_head");
            $this->createColumnOption($option, "t_15_head");
            $this->createColumnOption($option, "po_01_head");
            $this->createColumnOption($option, "po_02_head");
            $this->createColumnOption($option, "po_03_head");
            $this->createColumnOption($option, "po_04_head");
            $this->createColumnOption($option, "po_05_head");
            $this->createColumnOption($option, "po_06_head");
            $this->createColumnOption($option, "po_07_head");
            $this->createColumnOption($option, "po_08_head");
            $this->createColumnOption($option, "po_17_head");
            $this->createColumnOption($option, "po_18_head");
            $this->createColumnOption($option, "po_19_head");
            $this->createColumnOption($option, "po_20_head");
            $this->createColumnOption($option, "jc_01_head");
            $this->createColumnOption($option, "jc_02_head");
            $this->createColumnOption($option, "jc_03_head");
            $this->createColumnOption($option, "jc_04_head");
            $this->createColumnOption($option, "jc_05_head");
            $this->createColumnOption($option, "jc_06_head");
            $this->createColumnOption($option, "jc_07_head");
            $this->createColumnOption($option, "jc_08_head");
            $this->createColumnOption($option, "jc_09_head");
            $this->createColumnOption($option, "jc_10_head");
            $this->createColumnOption($option, "pc_shape");
            $this->createColumnOption($option, "pc_unit");
            $this->createColumnOption($option, "pc_w");
            $this->createColumnOption($option, "pc_l");
            $this->createColumnOption($option, "pc_h");
            $this->createColumnOption($option, "pc_partner_size");
            $this->createColumnOption($option, "pc_sqm");
            $this->createColumnOption($option, "pc_01_head");
            $this->createColumnOption($option, "pc_02_head");
            $this->createColumnOption($option, "pc_03_head");
            $this->createColumnOption($option, "pc_04_head");
            $this->createColumnOption($option, "pc_05_head");
            $this->createColumnOption($option, "pc_06_head");
            $this->createColumnOption($option, "pc_07_head");
            $this->createColumnOption($option, "pc_08_head");
            $this->createColumnOption($option, "pc_09_head");
            $this->createColumnOption($option, "pc_10_head");
            $this->createColumnOption($option, "pc_11_head");
            $this->createColumnOption($option, "pc_12_head");
            $this->createColumnOption($option, "operator");
            $this->createColumnOption($option, "datetime");
            $this->createColumnOption($option, "image");
            $this->createColumnOption($option, "pa_process_size_w");
            $this->createColumnOption($option, "pa_process_size_l");
            $this->createColumnOption($option, "pa_head_01");
            $this->createColumnOption($option, "pa_process_01");
            $this->createColumnOption($option, "pa_head_02");
            $this->createColumnOption($option, "pa_process_02");
            $this->createColumnOption($option, "pa_head_03");
            $this->createColumnOption($option, "pa_process_03");
            $this->createColumnOption($option, "pa_head_04");
            $this->createColumnOption($option, "pa_process_04");
            $this->createColumnOption($option, "pa_head_05");
            $this->createColumnOption($option, "pa_process_05");
            $this->createColumnOption($option, "pa_head_06");
            $this->createColumnOption($option, "pa_process_06");
            $this->createColumnOption($option, "pa_head_07");
            $this->createColumnOption($option, "pa_process_07");
            $this->createColumnOption($option, "pa_head_08");
            $this->createColumnOption($option, "pa_process_08");
            $this->createColumnOption($option, "pa_head_09");
            $this->createColumnOption($option, "pa_process_09");
            $this->createColumnOption($option, "pa_head_10");
            $this->createColumnOption($option, "pa_process_10");
            $this->createColumnOption($option, "publish");
            $this->createColumnOption($option, "ppr_01");
            $this->createColumnOption($option, "ppr_02");
            $this->createColumnOption($option, "ppr_03");
            $this->createColumnOption($option, "ppr_04");
            $this->createColumnOption($option, "ppr_05");
            $this->createColumnOption($option, "ppr_06");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fproduct_groupsrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fproduct_groupsrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fproduct_grouplist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_product_group", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_product_group",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->grp->AdvancedSearch->SearchValue != "" || $this->grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // product_group
        if ($this->product_group->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->product_group->AdvancedSearch->SearchValue != "" || $this->product_group->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // calculation_method
        if ($this->calculation_method->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->calculation_method->AdvancedSearch->SearchValue != "" || $this->calculation_method->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // shape
        if ($this->shape->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->shape->AdvancedSearch->SearchValue != "" || $this->shape->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sqm
        if ($this->sqm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sqm->AdvancedSearch->SearchValue != "" || $this->sqm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cbm
        if ($this->cbm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cbm->AdvancedSearch->SearchValue != "" || $this->cbm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // process
        if ($this->process->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->process->AdvancedSearch->SearchValue != "" || $this->process->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->status->AdvancedSearch->SearchValue != "" || $this->status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_00
        if ($this->v_00->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_00->AdvancedSearch->SearchValue != "" || $this->v_00->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_01
        if ($this->v_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_01->AdvancedSearch->SearchValue != "" || $this->v_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_01_validation
        if ($this->v_01_validation->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_01_validation->AdvancedSearch->SearchValue != "" || $this->v_01_validation->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_02
        if ($this->v_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_02->AdvancedSearch->SearchValue != "" || $this->v_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_02_validation
        if ($this->v_02_validation->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_02_validation->AdvancedSearch->SearchValue != "" || $this->v_02_validation->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_03
        if ($this->v_03->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_03->AdvancedSearch->SearchValue != "" || $this->v_03->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_03_validation
        if ($this->v_03_validation->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_03_validation->AdvancedSearch->SearchValue != "" || $this->v_03_validation->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_04
        if ($this->v_04->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_04->AdvancedSearch->SearchValue != "" || $this->v_04->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_04_validation
        if ($this->v_04_validation->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_04_validation->AdvancedSearch->SearchValue != "" || $this->v_04_validation->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_05
        if ($this->v_05->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_05->AdvancedSearch->SearchValue != "" || $this->v_05->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_05_validation
        if ($this->v_05_validation->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_05_validation->AdvancedSearch->SearchValue != "" || $this->v_05_validation->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_06
        if ($this->v_06->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_06->AdvancedSearch->SearchValue != "" || $this->v_06->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_06_validation
        if ($this->v_06_validation->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_06_validation->AdvancedSearch->SearchValue != "" || $this->v_06_validation->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_07
        if ($this->v_07->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_07->AdvancedSearch->SearchValue != "" || $this->v_07->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_07_validation
        if ($this->v_07_validation->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_07_validation->AdvancedSearch->SearchValue != "" || $this->v_07_validation->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_08
        if ($this->v_08->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_08->AdvancedSearch->SearchValue != "" || $this->v_08->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_08_validation
        if ($this->v_08_validation->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_08_validation->AdvancedSearch->SearchValue != "" || $this->v_08_validation->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_09
        if ($this->v_09->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_09->AdvancedSearch->SearchValue != "" || $this->v_09->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_09_validation
        if ($this->v_09_validation->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_09_validation->AdvancedSearch->SearchValue != "" || $this->v_09_validation->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_10
        if ($this->v_10->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_10->AdvancedSearch->SearchValue != "" || $this->v_10->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_10_validation
        if ($this->v_10_validation->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_10_validation->AdvancedSearch->SearchValue != "" || $this->v_10_validation->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_01_head
        if ($this->b_01_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_01_head->AdvancedSearch->SearchValue != "" || $this->b_01_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_02_head
        if ($this->b_02_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_02_head->AdvancedSearch->SearchValue != "" || $this->b_02_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_03_head
        if ($this->b_03_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_03_head->AdvancedSearch->SearchValue != "" || $this->b_03_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_04_head
        if ($this->b_04_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_04_head->AdvancedSearch->SearchValue != "" || $this->b_04_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_05_head
        if ($this->b_05_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_05_head->AdvancedSearch->SearchValue != "" || $this->b_05_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_06_head
        if ($this->b_06_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_06_head->AdvancedSearch->SearchValue != "" || $this->b_06_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_07_head
        if ($this->b_07_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_07_head->AdvancedSearch->SearchValue != "" || $this->b_07_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_08_head
        if ($this->b_08_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_08_head->AdvancedSearch->SearchValue != "" || $this->b_08_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_09_head
        if ($this->b_09_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_09_head->AdvancedSearch->SearchValue != "" || $this->b_09_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_10_head
        if ($this->b_10_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_10_head->AdvancedSearch->SearchValue != "" || $this->b_10_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_11_head
        if ($this->b_11_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_11_head->AdvancedSearch->SearchValue != "" || $this->b_11_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_12_head
        if ($this->b_12_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_12_head->AdvancedSearch->SearchValue != "" || $this->b_12_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_13_head
        if ($this->b_13_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_13_head->AdvancedSearch->SearchValue != "" || $this->b_13_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_14_head
        if ($this->b_14_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_14_head->AdvancedSearch->SearchValue != "" || $this->b_14_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_15_head
        if ($this->b_15_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_15_head->AdvancedSearch->SearchValue != "" || $this->b_15_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // q_sku
        if ($this->q_sku->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->q_sku->AdvancedSearch->SearchValue != "" || $this->q_sku->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_01_head
        if ($this->t_01_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_01_head->AdvancedSearch->SearchValue != "" || $this->t_01_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_02_head
        if ($this->t_02_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_02_head->AdvancedSearch->SearchValue != "" || $this->t_02_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_03_head
        if ($this->t_03_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_03_head->AdvancedSearch->SearchValue != "" || $this->t_03_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_04_head
        if ($this->t_04_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_04_head->AdvancedSearch->SearchValue != "" || $this->t_04_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_05_head
        if ($this->t_05_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_05_head->AdvancedSearch->SearchValue != "" || $this->t_05_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_06_head
        if ($this->t_06_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_06_head->AdvancedSearch->SearchValue != "" || $this->t_06_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_07_head
        if ($this->t_07_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_07_head->AdvancedSearch->SearchValue != "" || $this->t_07_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_08_head
        if ($this->t_08_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_08_head->AdvancedSearch->SearchValue != "" || $this->t_08_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_09_head
        if ($this->t_09_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_09_head->AdvancedSearch->SearchValue != "" || $this->t_09_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_10_head
        if ($this->t_10_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_10_head->AdvancedSearch->SearchValue != "" || $this->t_10_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_11_head
        if ($this->t_11_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_11_head->AdvancedSearch->SearchValue != "" || $this->t_11_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_12_head
        if ($this->t_12_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_12_head->AdvancedSearch->SearchValue != "" || $this->t_12_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_13_head
        if ($this->t_13_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_13_head->AdvancedSearch->SearchValue != "" || $this->t_13_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_14_head
        if ($this->t_14_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_14_head->AdvancedSearch->SearchValue != "" || $this->t_14_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_15_head
        if ($this->t_15_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_15_head->AdvancedSearch->SearchValue != "" || $this->t_15_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_01_head
        if ($this->po_01_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_01_head->AdvancedSearch->SearchValue != "" || $this->po_01_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_02_head
        if ($this->po_02_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_02_head->AdvancedSearch->SearchValue != "" || $this->po_02_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_03_head
        if ($this->po_03_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_03_head->AdvancedSearch->SearchValue != "" || $this->po_03_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_04_head
        if ($this->po_04_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_04_head->AdvancedSearch->SearchValue != "" || $this->po_04_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_05_head
        if ($this->po_05_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_05_head->AdvancedSearch->SearchValue != "" || $this->po_05_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_06_head
        if ($this->po_06_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_06_head->AdvancedSearch->SearchValue != "" || $this->po_06_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_07_head
        if ($this->po_07_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_07_head->AdvancedSearch->SearchValue != "" || $this->po_07_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_08_head
        if ($this->po_08_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_08_head->AdvancedSearch->SearchValue != "" || $this->po_08_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_17_head
        if ($this->po_17_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_17_head->AdvancedSearch->SearchValue != "" || $this->po_17_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_18_head
        if ($this->po_18_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_18_head->AdvancedSearch->SearchValue != "" || $this->po_18_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_19_head
        if ($this->po_19_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_19_head->AdvancedSearch->SearchValue != "" || $this->po_19_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_20_head
        if ($this->po_20_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_20_head->AdvancedSearch->SearchValue != "" || $this->po_20_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // jc_01_head
        if ($this->jc_01_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->jc_01_head->AdvancedSearch->SearchValue != "" || $this->jc_01_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // jc_02_head
        if ($this->jc_02_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->jc_02_head->AdvancedSearch->SearchValue != "" || $this->jc_02_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // jc_03_head
        if ($this->jc_03_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->jc_03_head->AdvancedSearch->SearchValue != "" || $this->jc_03_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // jc_04_head
        if ($this->jc_04_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->jc_04_head->AdvancedSearch->SearchValue != "" || $this->jc_04_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // jc_05_head
        if ($this->jc_05_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->jc_05_head->AdvancedSearch->SearchValue != "" || $this->jc_05_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // jc_06_head
        if ($this->jc_06_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->jc_06_head->AdvancedSearch->SearchValue != "" || $this->jc_06_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // jc_07_head
        if ($this->jc_07_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->jc_07_head->AdvancedSearch->SearchValue != "" || $this->jc_07_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // jc_08_head
        if ($this->jc_08_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->jc_08_head->AdvancedSearch->SearchValue != "" || $this->jc_08_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // jc_09_head
        if ($this->jc_09_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->jc_09_head->AdvancedSearch->SearchValue != "" || $this->jc_09_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // jc_10_head
        if ($this->jc_10_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->jc_10_head->AdvancedSearch->SearchValue != "" || $this->jc_10_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_shape
        if ($this->pc_shape->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_shape->AdvancedSearch->SearchValue != "" || $this->pc_shape->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_unit
        if ($this->pc_unit->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_unit->AdvancedSearch->SearchValue != "" || $this->pc_unit->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_w
        if ($this->pc_w->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_w->AdvancedSearch->SearchValue != "" || $this->pc_w->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_l
        if ($this->pc_l->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_l->AdvancedSearch->SearchValue != "" || $this->pc_l->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_h
        if ($this->pc_h->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_h->AdvancedSearch->SearchValue != "" || $this->pc_h->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_partner_size
        if ($this->pc_partner_size->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_partner_size->AdvancedSearch->SearchValue != "" || $this->pc_partner_size->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_sqm
        if ($this->pc_sqm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_sqm->AdvancedSearch->SearchValue != "" || $this->pc_sqm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_01_head
        if ($this->pc_01_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_01_head->AdvancedSearch->SearchValue != "" || $this->pc_01_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_02_head
        if ($this->pc_02_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_02_head->AdvancedSearch->SearchValue != "" || $this->pc_02_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_03_head
        if ($this->pc_03_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_03_head->AdvancedSearch->SearchValue != "" || $this->pc_03_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_04_head
        if ($this->pc_04_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_04_head->AdvancedSearch->SearchValue != "" || $this->pc_04_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_05_head
        if ($this->pc_05_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_05_head->AdvancedSearch->SearchValue != "" || $this->pc_05_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_06_head
        if ($this->pc_06_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_06_head->AdvancedSearch->SearchValue != "" || $this->pc_06_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_07_head
        if ($this->pc_07_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_07_head->AdvancedSearch->SearchValue != "" || $this->pc_07_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_08_head
        if ($this->pc_08_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_08_head->AdvancedSearch->SearchValue != "" || $this->pc_08_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_09_head
        if ($this->pc_09_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_09_head->AdvancedSearch->SearchValue != "" || $this->pc_09_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_10_head
        if ($this->pc_10_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_10_head->AdvancedSearch->SearchValue != "" || $this->pc_10_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_11_head
        if ($this->pc_11_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_11_head->AdvancedSearch->SearchValue != "" || $this->pc_11_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_12_head
        if ($this->pc_12_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_12_head->AdvancedSearch->SearchValue != "" || $this->pc_12_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator->AdvancedSearch->SearchValue != "" || $this->operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime->AdvancedSearch->SearchValue != "" || $this->datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // image
        if ($this->image->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->image->AdvancedSearch->SearchValue != "" || $this->image->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_process_size_w
        if ($this->pa_process_size_w->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_process_size_w->AdvancedSearch->SearchValue != "" || $this->pa_process_size_w->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_process_size_l
        if ($this->pa_process_size_l->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_process_size_l->AdvancedSearch->SearchValue != "" || $this->pa_process_size_l->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_head_01
        if ($this->pa_head_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_head_01->AdvancedSearch->SearchValue != "" || $this->pa_head_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_process_01
        if ($this->pa_process_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_process_01->AdvancedSearch->SearchValue != "" || $this->pa_process_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->pa_process_01->AdvancedSearch->SearchValue)) {
            $this->pa_process_01->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_01->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_01->AdvancedSearch->SearchValue2)) {
            $this->pa_process_01->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_01->AdvancedSearch->SearchValue2);
        }

        // pa_head_02
        if ($this->pa_head_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_head_02->AdvancedSearch->SearchValue != "" || $this->pa_head_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_process_02
        if ($this->pa_process_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_process_02->AdvancedSearch->SearchValue != "" || $this->pa_process_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->pa_process_02->AdvancedSearch->SearchValue)) {
            $this->pa_process_02->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_02->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_02->AdvancedSearch->SearchValue2)) {
            $this->pa_process_02->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_02->AdvancedSearch->SearchValue2);
        }

        // pa_head_03
        if ($this->pa_head_03->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_head_03->AdvancedSearch->SearchValue != "" || $this->pa_head_03->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_process_03
        if ($this->pa_process_03->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_process_03->AdvancedSearch->SearchValue != "" || $this->pa_process_03->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->pa_process_03->AdvancedSearch->SearchValue)) {
            $this->pa_process_03->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_03->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_03->AdvancedSearch->SearchValue2)) {
            $this->pa_process_03->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_03->AdvancedSearch->SearchValue2);
        }

        // pa_head_04
        if ($this->pa_head_04->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_head_04->AdvancedSearch->SearchValue != "" || $this->pa_head_04->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_process_04
        if ($this->pa_process_04->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_process_04->AdvancedSearch->SearchValue != "" || $this->pa_process_04->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->pa_process_04->AdvancedSearch->SearchValue)) {
            $this->pa_process_04->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_04->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_04->AdvancedSearch->SearchValue2)) {
            $this->pa_process_04->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_04->AdvancedSearch->SearchValue2);
        }

        // pa_head_05
        if ($this->pa_head_05->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_head_05->AdvancedSearch->SearchValue != "" || $this->pa_head_05->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_process_05
        if ($this->pa_process_05->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_process_05->AdvancedSearch->SearchValue != "" || $this->pa_process_05->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->pa_process_05->AdvancedSearch->SearchValue)) {
            $this->pa_process_05->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_05->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_05->AdvancedSearch->SearchValue2)) {
            $this->pa_process_05->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_05->AdvancedSearch->SearchValue2);
        }

        // pa_head_06
        if ($this->pa_head_06->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_head_06->AdvancedSearch->SearchValue != "" || $this->pa_head_06->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_process_06
        if ($this->pa_process_06->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_process_06->AdvancedSearch->SearchValue != "" || $this->pa_process_06->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->pa_process_06->AdvancedSearch->SearchValue)) {
            $this->pa_process_06->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_06->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_06->AdvancedSearch->SearchValue2)) {
            $this->pa_process_06->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_06->AdvancedSearch->SearchValue2);
        }

        // pa_head_07
        if ($this->pa_head_07->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_head_07->AdvancedSearch->SearchValue != "" || $this->pa_head_07->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_process_07
        if ($this->pa_process_07->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_process_07->AdvancedSearch->SearchValue != "" || $this->pa_process_07->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->pa_process_07->AdvancedSearch->SearchValue)) {
            $this->pa_process_07->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_07->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_07->AdvancedSearch->SearchValue2)) {
            $this->pa_process_07->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_07->AdvancedSearch->SearchValue2);
        }

        // pa_head_08
        if ($this->pa_head_08->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_head_08->AdvancedSearch->SearchValue != "" || $this->pa_head_08->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_process_08
        if ($this->pa_process_08->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_process_08->AdvancedSearch->SearchValue != "" || $this->pa_process_08->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->pa_process_08->AdvancedSearch->SearchValue)) {
            $this->pa_process_08->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_08->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_08->AdvancedSearch->SearchValue2)) {
            $this->pa_process_08->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_08->AdvancedSearch->SearchValue2);
        }

        // pa_head_09
        if ($this->pa_head_09->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_head_09->AdvancedSearch->SearchValue != "" || $this->pa_head_09->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_process_09
        if ($this->pa_process_09->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_process_09->AdvancedSearch->SearchValue != "" || $this->pa_process_09->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->pa_process_09->AdvancedSearch->SearchValue)) {
            $this->pa_process_09->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_09->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_09->AdvancedSearch->SearchValue2)) {
            $this->pa_process_09->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_09->AdvancedSearch->SearchValue2);
        }

        // pa_head_10
        if ($this->pa_head_10->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_head_10->AdvancedSearch->SearchValue != "" || $this->pa_head_10->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_process_10
        if ($this->pa_process_10->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_process_10->AdvancedSearch->SearchValue != "" || $this->pa_process_10->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->pa_process_10->AdvancedSearch->SearchValue)) {
            $this->pa_process_10->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_10->AdvancedSearch->SearchValue);
        }
        if (is_array($this->pa_process_10->AdvancedSearch->SearchValue2)) {
            $this->pa_process_10->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->pa_process_10->AdvancedSearch->SearchValue2);
        }

        // publish
        if ($this->publish->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->publish->AdvancedSearch->SearchValue != "" || $this->publish->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ppr_01
        if ($this->ppr_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ppr_01->AdvancedSearch->SearchValue != "" || $this->ppr_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ppr_02
        if ($this->ppr_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ppr_02->AdvancedSearch->SearchValue != "" || $this->ppr_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ppr_03
        if ($this->ppr_03->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ppr_03->AdvancedSearch->SearchValue != "" || $this->ppr_03->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ppr_04
        if ($this->ppr_04->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ppr_04->AdvancedSearch->SearchValue != "" || $this->ppr_04->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ppr_05
        if ($this->ppr_05->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ppr_05->AdvancedSearch->SearchValue != "" || $this->ppr_05->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ppr_06
        if ($this->ppr_06->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ppr_06->AdvancedSearch->SearchValue != "" || $this->ppr_06->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->product_group->setDbValue($row['product_group']);
        $this->calculation_method->setDbValue($row['calculation_method']);
        $this->shape->setDbValue($row['shape']);
        $this->sqm->setDbValue($row['sqm']);
        $this->cbm->setDbValue($row['cbm']);
        $this->process->setDbValue($row['process']);
        $this->status->setDbValue($row['status']);
        $this->v_00->setDbValue($row['v_00']);
        $this->v_01->setDbValue($row['v_01']);
        $this->v_01_validation->setDbValue($row['v_01_validation']);
        $this->v_02->setDbValue($row['v_02']);
        $this->v_02_validation->setDbValue($row['v_02_validation']);
        $this->v_03->setDbValue($row['v_03']);
        $this->v_03_validation->setDbValue($row['v_03_validation']);
        $this->v_04->setDbValue($row['v_04']);
        $this->v_04_validation->setDbValue($row['v_04_validation']);
        $this->v_05->setDbValue($row['v_05']);
        $this->v_05_validation->setDbValue($row['v_05_validation']);
        $this->v_06->setDbValue($row['v_06']);
        $this->v_06_validation->setDbValue($row['v_06_validation']);
        $this->v_07->setDbValue($row['v_07']);
        $this->v_07_validation->setDbValue($row['v_07_validation']);
        $this->v_08->setDbValue($row['v_08']);
        $this->v_08_validation->setDbValue($row['v_08_validation']);
        $this->v_09->setDbValue($row['v_09']);
        $this->v_09_validation->setDbValue($row['v_09_validation']);
        $this->v_10->setDbValue($row['v_10']);
        $this->v_10_validation->setDbValue($row['v_10_validation']);
        $this->b_01_head->setDbValue($row['b_01_head']);
        $this->b_02_head->setDbValue($row['b_02_head']);
        $this->b_03_head->setDbValue($row['b_03_head']);
        $this->b_04_head->setDbValue($row['b_04_head']);
        $this->b_05_head->setDbValue($row['b_05_head']);
        $this->b_06_head->setDbValue($row['b_06_head']);
        $this->b_07_head->setDbValue($row['b_07_head']);
        $this->b_08_head->setDbValue($row['b_08_head']);
        $this->b_09_head->setDbValue($row['b_09_head']);
        $this->b_10_head->setDbValue($row['b_10_head']);
        $this->b_11_head->setDbValue($row['b_11_head']);
        $this->b_12_head->setDbValue($row['b_12_head']);
        $this->b_13_head->setDbValue($row['b_13_head']);
        $this->b_14_head->setDbValue($row['b_14_head']);
        $this->b_15_head->setDbValue($row['b_15_head']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->t_01_head->setDbValue($row['t_01_head']);
        $this->t_02_head->setDbValue($row['t_02_head']);
        $this->t_03_head->setDbValue($row['t_03_head']);
        $this->t_04_head->setDbValue($row['t_04_head']);
        $this->t_05_head->setDbValue($row['t_05_head']);
        $this->t_06_head->setDbValue($row['t_06_head']);
        $this->t_07_head->setDbValue($row['t_07_head']);
        $this->t_08_head->setDbValue($row['t_08_head']);
        $this->t_09_head->setDbValue($row['t_09_head']);
        $this->t_10_head->setDbValue($row['t_10_head']);
        $this->t_11_head->setDbValue($row['t_11_head']);
        $this->t_12_head->setDbValue($row['t_12_head']);
        $this->t_13_head->setDbValue($row['t_13_head']);
        $this->t_14_head->setDbValue($row['t_14_head']);
        $this->t_15_head->setDbValue($row['t_15_head']);
        $this->po_01_head->setDbValue($row['po_01_head']);
        $this->po_02_head->setDbValue($row['po_02_head']);
        $this->po_03_head->setDbValue($row['po_03_head']);
        $this->po_04_head->setDbValue($row['po_04_head']);
        $this->po_05_head->setDbValue($row['po_05_head']);
        $this->po_06_head->setDbValue($row['po_06_head']);
        $this->po_07_head->setDbValue($row['po_07_head']);
        $this->po_08_head->setDbValue($row['po_08_head']);
        $this->po_17_head->setDbValue($row['po_17_head']);
        $this->po_18_head->setDbValue($row['po_18_head']);
        $this->po_19_head->setDbValue($row['po_19_head']);
        $this->po_20_head->setDbValue($row['po_20_head']);
        $this->jc_01_head->setDbValue($row['jc_01_head']);
        $this->jc_02_head->setDbValue($row['jc_02_head']);
        $this->jc_03_head->setDbValue($row['jc_03_head']);
        $this->jc_04_head->setDbValue($row['jc_04_head']);
        $this->jc_05_head->setDbValue($row['jc_05_head']);
        $this->jc_06_head->setDbValue($row['jc_06_head']);
        $this->jc_07_head->setDbValue($row['jc_07_head']);
        $this->jc_08_head->setDbValue($row['jc_08_head']);
        $this->jc_09_head->setDbValue($row['jc_09_head']);
        $this->jc_10_head->setDbValue($row['jc_10_head']);
        $this->pc_shape->setDbValue($row['pc_shape']);
        $this->pc_unit->setDbValue($row['pc_unit']);
        $this->pc_w->setDbValue($row['pc_w']);
        $this->pc_l->setDbValue($row['pc_l']);
        $this->pc_h->setDbValue($row['pc_h']);
        $this->pc_partner_size->setDbValue($row['pc_partner_size']);
        $this->pc_sqm->setDbValue($row['pc_sqm']);
        $this->pc_01_head->setDbValue($row['pc_01_head']);
        $this->pc_02_head->setDbValue($row['pc_02_head']);
        $this->pc_03_head->setDbValue($row['pc_03_head']);
        $this->pc_04_head->setDbValue($row['pc_04_head']);
        $this->pc_05_head->setDbValue($row['pc_05_head']);
        $this->pc_06_head->setDbValue($row['pc_06_head']);
        $this->pc_07_head->setDbValue($row['pc_07_head']);
        $this->pc_08_head->setDbValue($row['pc_08_head']);
        $this->pc_09_head->setDbValue($row['pc_09_head']);
        $this->pc_10_head->setDbValue($row['pc_10_head']);
        $this->pc_11_head->setDbValue($row['pc_11_head']);
        $this->pc_12_head->setDbValue($row['pc_12_head']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->pa_process_size_w->setDbValue($row['pa_process_size_w']);
        $this->pa_process_size_l->setDbValue($row['pa_process_size_l']);
        $this->pa_head_01->setDbValue($row['pa_head_01']);
        $this->pa_process_01->setDbValue($row['pa_process_01']);
        $this->pa_head_02->setDbValue($row['pa_head_02']);
        $this->pa_process_02->setDbValue($row['pa_process_02']);
        $this->pa_head_03->setDbValue($row['pa_head_03']);
        $this->pa_process_03->setDbValue($row['pa_process_03']);
        $this->pa_head_04->setDbValue($row['pa_head_04']);
        $this->pa_process_04->setDbValue($row['pa_process_04']);
        $this->pa_head_05->setDbValue($row['pa_head_05']);
        $this->pa_process_05->setDbValue($row['pa_process_05']);
        $this->pa_head_06->setDbValue($row['pa_head_06']);
        $this->pa_process_06->setDbValue($row['pa_process_06']);
        $this->pa_head_07->setDbValue($row['pa_head_07']);
        $this->pa_process_07->setDbValue($row['pa_process_07']);
        $this->pa_head_08->setDbValue($row['pa_head_08']);
        $this->pa_process_08->setDbValue($row['pa_process_08']);
        $this->pa_head_09->setDbValue($row['pa_head_09']);
        $this->pa_process_09->setDbValue($row['pa_process_09']);
        $this->pa_head_10->setDbValue($row['pa_head_10']);
        $this->pa_process_10->setDbValue($row['pa_process_10']);
        $this->publish->setDbValue($row['publish']);
        $this->ppr_01->setDbValue($row['ppr_01']);
        $this->ppr_02->setDbValue($row['ppr_02']);
        $this->ppr_03->setDbValue($row['ppr_03']);
        $this->ppr_04->setDbValue($row['ppr_04']);
        $this->ppr_05->setDbValue($row['ppr_05']);
        $this->ppr_06->setDbValue($row['ppr_06']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['product_group'] = $this->product_group->DefaultValue;
        $row['calculation_method'] = $this->calculation_method->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['v_00'] = $this->v_00->DefaultValue;
        $row['v_01'] = $this->v_01->DefaultValue;
        $row['v_01_validation'] = $this->v_01_validation->DefaultValue;
        $row['v_02'] = $this->v_02->DefaultValue;
        $row['v_02_validation'] = $this->v_02_validation->DefaultValue;
        $row['v_03'] = $this->v_03->DefaultValue;
        $row['v_03_validation'] = $this->v_03_validation->DefaultValue;
        $row['v_04'] = $this->v_04->DefaultValue;
        $row['v_04_validation'] = $this->v_04_validation->DefaultValue;
        $row['v_05'] = $this->v_05->DefaultValue;
        $row['v_05_validation'] = $this->v_05_validation->DefaultValue;
        $row['v_06'] = $this->v_06->DefaultValue;
        $row['v_06_validation'] = $this->v_06_validation->DefaultValue;
        $row['v_07'] = $this->v_07->DefaultValue;
        $row['v_07_validation'] = $this->v_07_validation->DefaultValue;
        $row['v_08'] = $this->v_08->DefaultValue;
        $row['v_08_validation'] = $this->v_08_validation->DefaultValue;
        $row['v_09'] = $this->v_09->DefaultValue;
        $row['v_09_validation'] = $this->v_09_validation->DefaultValue;
        $row['v_10'] = $this->v_10->DefaultValue;
        $row['v_10_validation'] = $this->v_10_validation->DefaultValue;
        $row['b_01_head'] = $this->b_01_head->DefaultValue;
        $row['b_02_head'] = $this->b_02_head->DefaultValue;
        $row['b_03_head'] = $this->b_03_head->DefaultValue;
        $row['b_04_head'] = $this->b_04_head->DefaultValue;
        $row['b_05_head'] = $this->b_05_head->DefaultValue;
        $row['b_06_head'] = $this->b_06_head->DefaultValue;
        $row['b_07_head'] = $this->b_07_head->DefaultValue;
        $row['b_08_head'] = $this->b_08_head->DefaultValue;
        $row['b_09_head'] = $this->b_09_head->DefaultValue;
        $row['b_10_head'] = $this->b_10_head->DefaultValue;
        $row['b_11_head'] = $this->b_11_head->DefaultValue;
        $row['b_12_head'] = $this->b_12_head->DefaultValue;
        $row['b_13_head'] = $this->b_13_head->DefaultValue;
        $row['b_14_head'] = $this->b_14_head->DefaultValue;
        $row['b_15_head'] = $this->b_15_head->DefaultValue;
        $row['q_sku'] = $this->q_sku->DefaultValue;
        $row['t_01_head'] = $this->t_01_head->DefaultValue;
        $row['t_02_head'] = $this->t_02_head->DefaultValue;
        $row['t_03_head'] = $this->t_03_head->DefaultValue;
        $row['t_04_head'] = $this->t_04_head->DefaultValue;
        $row['t_05_head'] = $this->t_05_head->DefaultValue;
        $row['t_06_head'] = $this->t_06_head->DefaultValue;
        $row['t_07_head'] = $this->t_07_head->DefaultValue;
        $row['t_08_head'] = $this->t_08_head->DefaultValue;
        $row['t_09_head'] = $this->t_09_head->DefaultValue;
        $row['t_10_head'] = $this->t_10_head->DefaultValue;
        $row['t_11_head'] = $this->t_11_head->DefaultValue;
        $row['t_12_head'] = $this->t_12_head->DefaultValue;
        $row['t_13_head'] = $this->t_13_head->DefaultValue;
        $row['t_14_head'] = $this->t_14_head->DefaultValue;
        $row['t_15_head'] = $this->t_15_head->DefaultValue;
        $row['po_01_head'] = $this->po_01_head->DefaultValue;
        $row['po_02_head'] = $this->po_02_head->DefaultValue;
        $row['po_03_head'] = $this->po_03_head->DefaultValue;
        $row['po_04_head'] = $this->po_04_head->DefaultValue;
        $row['po_05_head'] = $this->po_05_head->DefaultValue;
        $row['po_06_head'] = $this->po_06_head->DefaultValue;
        $row['po_07_head'] = $this->po_07_head->DefaultValue;
        $row['po_08_head'] = $this->po_08_head->DefaultValue;
        $row['po_17_head'] = $this->po_17_head->DefaultValue;
        $row['po_18_head'] = $this->po_18_head->DefaultValue;
        $row['po_19_head'] = $this->po_19_head->DefaultValue;
        $row['po_20_head'] = $this->po_20_head->DefaultValue;
        $row['jc_01_head'] = $this->jc_01_head->DefaultValue;
        $row['jc_02_head'] = $this->jc_02_head->DefaultValue;
        $row['jc_03_head'] = $this->jc_03_head->DefaultValue;
        $row['jc_04_head'] = $this->jc_04_head->DefaultValue;
        $row['jc_05_head'] = $this->jc_05_head->DefaultValue;
        $row['jc_06_head'] = $this->jc_06_head->DefaultValue;
        $row['jc_07_head'] = $this->jc_07_head->DefaultValue;
        $row['jc_08_head'] = $this->jc_08_head->DefaultValue;
        $row['jc_09_head'] = $this->jc_09_head->DefaultValue;
        $row['jc_10_head'] = $this->jc_10_head->DefaultValue;
        $row['pc_shape'] = $this->pc_shape->DefaultValue;
        $row['pc_unit'] = $this->pc_unit->DefaultValue;
        $row['pc_w'] = $this->pc_w->DefaultValue;
        $row['pc_l'] = $this->pc_l->DefaultValue;
        $row['pc_h'] = $this->pc_h->DefaultValue;
        $row['pc_partner_size'] = $this->pc_partner_size->DefaultValue;
        $row['pc_sqm'] = $this->pc_sqm->DefaultValue;
        $row['pc_01_head'] = $this->pc_01_head->DefaultValue;
        $row['pc_02_head'] = $this->pc_02_head->DefaultValue;
        $row['pc_03_head'] = $this->pc_03_head->DefaultValue;
        $row['pc_04_head'] = $this->pc_04_head->DefaultValue;
        $row['pc_05_head'] = $this->pc_05_head->DefaultValue;
        $row['pc_06_head'] = $this->pc_06_head->DefaultValue;
        $row['pc_07_head'] = $this->pc_07_head->DefaultValue;
        $row['pc_08_head'] = $this->pc_08_head->DefaultValue;
        $row['pc_09_head'] = $this->pc_09_head->DefaultValue;
        $row['pc_10_head'] = $this->pc_10_head->DefaultValue;
        $row['pc_11_head'] = $this->pc_11_head->DefaultValue;
        $row['pc_12_head'] = $this->pc_12_head->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['pa_process_size_w'] = $this->pa_process_size_w->DefaultValue;
        $row['pa_process_size_l'] = $this->pa_process_size_l->DefaultValue;
        $row['pa_head_01'] = $this->pa_head_01->DefaultValue;
        $row['pa_process_01'] = $this->pa_process_01->DefaultValue;
        $row['pa_head_02'] = $this->pa_head_02->DefaultValue;
        $row['pa_process_02'] = $this->pa_process_02->DefaultValue;
        $row['pa_head_03'] = $this->pa_head_03->DefaultValue;
        $row['pa_process_03'] = $this->pa_process_03->DefaultValue;
        $row['pa_head_04'] = $this->pa_head_04->DefaultValue;
        $row['pa_process_04'] = $this->pa_process_04->DefaultValue;
        $row['pa_head_05'] = $this->pa_head_05->DefaultValue;
        $row['pa_process_05'] = $this->pa_process_05->DefaultValue;
        $row['pa_head_06'] = $this->pa_head_06->DefaultValue;
        $row['pa_process_06'] = $this->pa_process_06->DefaultValue;
        $row['pa_head_07'] = $this->pa_head_07->DefaultValue;
        $row['pa_process_07'] = $this->pa_process_07->DefaultValue;
        $row['pa_head_08'] = $this->pa_head_08->DefaultValue;
        $row['pa_process_08'] = $this->pa_process_08->DefaultValue;
        $row['pa_head_09'] = $this->pa_head_09->DefaultValue;
        $row['pa_process_09'] = $this->pa_process_09->DefaultValue;
        $row['pa_head_10'] = $this->pa_head_10->DefaultValue;
        $row['pa_process_10'] = $this->pa_process_10->DefaultValue;
        $row['publish'] = $this->publish->DefaultValue;
        $row['ppr_01'] = $this->ppr_01->DefaultValue;
        $row['ppr_02'] = $this->ppr_02->DefaultValue;
        $row['ppr_03'] = $this->ppr_03->DefaultValue;
        $row['ppr_04'] = $this->ppr_04->DefaultValue;
        $row['ppr_05'] = $this->ppr_05->DefaultValue;
        $row['ppr_06'] = $this->ppr_06->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // grp

        // product_group

        // calculation_method

        // shape

        // sqm

        // cbm

        // process

        // status

        // v_00

        // v_01

        // v_01_validation

        // v_02

        // v_02_validation

        // v_03

        // v_03_validation

        // v_04

        // v_04_validation

        // v_05

        // v_05_validation

        // v_06

        // v_06_validation

        // v_07

        // v_07_validation

        // v_08

        // v_08_validation

        // v_09

        // v_09_validation

        // v_10

        // v_10_validation

        // b_01_head

        // b_02_head

        // b_03_head

        // b_04_head

        // b_05_head

        // b_06_head

        // b_07_head

        // b_08_head

        // b_09_head

        // b_10_head

        // b_11_head

        // b_12_head

        // b_13_head

        // b_14_head

        // b_15_head

        // q_sku

        // t_01_head

        // t_02_head

        // t_03_head

        // t_04_head

        // t_05_head

        // t_06_head

        // t_07_head

        // t_08_head

        // t_09_head

        // t_10_head

        // t_11_head

        // t_12_head

        // t_13_head

        // t_14_head

        // t_15_head

        // po_01_head

        // po_02_head

        // po_03_head

        // po_04_head

        // po_05_head

        // po_06_head

        // po_07_head

        // po_08_head

        // po_17_head

        // po_18_head

        // po_19_head

        // po_20_head

        // jc_01_head

        // jc_02_head

        // jc_03_head

        // jc_04_head

        // jc_05_head

        // jc_06_head

        // jc_07_head

        // jc_08_head

        // jc_09_head

        // jc_10_head

        // pc_shape

        // pc_unit

        // pc_w

        // pc_l

        // pc_h

        // pc_partner_size

        // pc_sqm

        // pc_01_head

        // pc_02_head

        // pc_03_head

        // pc_04_head

        // pc_05_head

        // pc_06_head

        // pc_07_head

        // pc_08_head

        // pc_09_head

        // pc_10_head

        // pc_11_head

        // pc_12_head

        // operator

        // datetime

        // image

        // pa_process_size_w

        // pa_process_size_l

        // pa_head_01

        // pa_process_01

        // pa_head_02

        // pa_process_02

        // pa_head_03

        // pa_process_03

        // pa_head_04

        // pa_process_04

        // pa_head_05

        // pa_process_05

        // pa_head_06

        // pa_process_06

        // pa_head_07

        // pa_process_07

        // pa_head_08

        // pa_process_08

        // pa_head_09

        // pa_process_09

        // pa_head_10

        // pa_process_10

        // publish

        // ppr_01

        // ppr_02

        // ppr_03

        // ppr_04

        // ppr_05

        // ppr_06

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // product_group
            $this->product_group->ViewValue = $this->product_group->CurrentValue;

            // calculation_method
            $curVal = strval($this->calculation_method->CurrentValue);
            if ($curVal != "") {
                $this->calculation_method->ViewValue = $this->calculation_method->lookupCacheOption($curVal);
                if ($this->calculation_method->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->calculation_method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->calculation_method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->calculation_method->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->calculation_method->Lookup->renderViewRow($rswrk[0]);
                        $this->calculation_method->ViewValue = $this->calculation_method->displayValue($arwrk);
                    } else {
                        $this->calculation_method->ViewValue = FormatNumber($this->calculation_method->CurrentValue, $this->calculation_method->formatPattern());
                    }
                }
            } else {
                $this->calculation_method->ViewValue = null;
            }

            // shape
            $this->shape->ViewValue = $this->shape->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // v_00
            $this->v_00->ViewValue = $this->v_00->CurrentValue;

            // v_01
            $this->v_01->ViewValue = $this->v_01->CurrentValue;

            // v_01_validation
            $this->v_01_validation->ViewValue = $this->v_01_validation->CurrentValue;

            // v_02
            $this->v_02->ViewValue = $this->v_02->CurrentValue;

            // v_02_validation
            $this->v_02_validation->ViewValue = $this->v_02_validation->CurrentValue;

            // v_03
            $this->v_03->ViewValue = $this->v_03->CurrentValue;

            // v_03_validation
            $this->v_03_validation->ViewValue = $this->v_03_validation->CurrentValue;

            // v_04
            $this->v_04->ViewValue = $this->v_04->CurrentValue;

            // v_04_validation
            $this->v_04_validation->ViewValue = $this->v_04_validation->CurrentValue;

            // v_05
            $this->v_05->ViewValue = $this->v_05->CurrentValue;

            // v_05_validation
            $this->v_05_validation->ViewValue = $this->v_05_validation->CurrentValue;

            // v_06
            $this->v_06->ViewValue = $this->v_06->CurrentValue;

            // v_06_validation
            $this->v_06_validation->ViewValue = $this->v_06_validation->CurrentValue;

            // v_07
            $this->v_07->ViewValue = $this->v_07->CurrentValue;

            // v_07_validation
            $this->v_07_validation->ViewValue = $this->v_07_validation->CurrentValue;

            // v_08
            $this->v_08->ViewValue = $this->v_08->CurrentValue;

            // v_08_validation
            $this->v_08_validation->ViewValue = $this->v_08_validation->CurrentValue;

            // v_09
            $this->v_09->ViewValue = $this->v_09->CurrentValue;

            // v_09_validation
            $this->v_09_validation->ViewValue = $this->v_09_validation->CurrentValue;

            // v_10
            $this->v_10->ViewValue = $this->v_10->CurrentValue;

            // v_10_validation
            $this->v_10_validation->ViewValue = $this->v_10_validation->CurrentValue;

            // b_01_head
            $this->b_01_head->ViewValue = $this->b_01_head->CurrentValue;

            // b_02_head
            $this->b_02_head->ViewValue = $this->b_02_head->CurrentValue;

            // b_03_head
            $this->b_03_head->ViewValue = $this->b_03_head->CurrentValue;

            // b_04_head
            $this->b_04_head->ViewValue = $this->b_04_head->CurrentValue;

            // b_05_head
            $this->b_05_head->ViewValue = $this->b_05_head->CurrentValue;

            // b_06_head
            $this->b_06_head->ViewValue = $this->b_06_head->CurrentValue;

            // b_07_head
            $this->b_07_head->ViewValue = $this->b_07_head->CurrentValue;

            // b_08_head
            $this->b_08_head->ViewValue = $this->b_08_head->CurrentValue;

            // b_09_head
            $this->b_09_head->ViewValue = $this->b_09_head->CurrentValue;

            // b_10_head
            $this->b_10_head->ViewValue = $this->b_10_head->CurrentValue;

            // b_11_head
            $this->b_11_head->ViewValue = $this->b_11_head->CurrentValue;

            // b_12_head
            $this->b_12_head->ViewValue = $this->b_12_head->CurrentValue;

            // b_13_head
            $this->b_13_head->ViewValue = $this->b_13_head->CurrentValue;

            // b_14_head
            $this->b_14_head->ViewValue = $this->b_14_head->CurrentValue;

            // b_15_head
            $this->b_15_head->ViewValue = $this->b_15_head->CurrentValue;

            // q_sku
            $this->q_sku->ViewValue = $this->q_sku->CurrentValue;

            // t_01_head
            $this->t_01_head->ViewValue = $this->t_01_head->CurrentValue;

            // t_02_head
            $this->t_02_head->ViewValue = $this->t_02_head->CurrentValue;

            // t_03_head
            $this->t_03_head->ViewValue = $this->t_03_head->CurrentValue;

            // t_04_head
            $this->t_04_head->ViewValue = $this->t_04_head->CurrentValue;

            // t_05_head
            $this->t_05_head->ViewValue = $this->t_05_head->CurrentValue;

            // t_06_head
            $this->t_06_head->ViewValue = $this->t_06_head->CurrentValue;

            // t_07_head
            $this->t_07_head->ViewValue = $this->t_07_head->CurrentValue;

            // t_08_head
            $this->t_08_head->ViewValue = $this->t_08_head->CurrentValue;

            // t_09_head
            $this->t_09_head->ViewValue = $this->t_09_head->CurrentValue;

            // t_10_head
            $this->t_10_head->ViewValue = $this->t_10_head->CurrentValue;

            // t_11_head
            $this->t_11_head->ViewValue = $this->t_11_head->CurrentValue;

            // t_12_head
            $this->t_12_head->ViewValue = $this->t_12_head->CurrentValue;

            // t_13_head
            $this->t_13_head->ViewValue = $this->t_13_head->CurrentValue;

            // t_14_head
            $this->t_14_head->ViewValue = $this->t_14_head->CurrentValue;

            // t_15_head
            $this->t_15_head->ViewValue = $this->t_15_head->CurrentValue;

            // po_01_head
            $this->po_01_head->ViewValue = $this->po_01_head->CurrentValue;

            // po_02_head
            $this->po_02_head->ViewValue = $this->po_02_head->CurrentValue;

            // po_03_head
            $this->po_03_head->ViewValue = $this->po_03_head->CurrentValue;

            // po_04_head
            $this->po_04_head->ViewValue = $this->po_04_head->CurrentValue;

            // po_05_head
            $this->po_05_head->ViewValue = $this->po_05_head->CurrentValue;

            // po_06_head
            $this->po_06_head->ViewValue = $this->po_06_head->CurrentValue;

            // po_07_head
            $this->po_07_head->ViewValue = $this->po_07_head->CurrentValue;

            // po_08_head
            $this->po_08_head->ViewValue = $this->po_08_head->CurrentValue;

            // po_17_head
            $this->po_17_head->ViewValue = $this->po_17_head->CurrentValue;

            // po_18_head
            $this->po_18_head->ViewValue = $this->po_18_head->CurrentValue;

            // po_19_head
            $this->po_19_head->ViewValue = $this->po_19_head->CurrentValue;

            // po_20_head
            $this->po_20_head->ViewValue = $this->po_20_head->CurrentValue;

            // jc_01_head
            $this->jc_01_head->ViewValue = $this->jc_01_head->CurrentValue;

            // jc_02_head
            $this->jc_02_head->ViewValue = $this->jc_02_head->CurrentValue;

            // jc_03_head
            $this->jc_03_head->ViewValue = $this->jc_03_head->CurrentValue;

            // jc_04_head
            $this->jc_04_head->ViewValue = $this->jc_04_head->CurrentValue;

            // jc_05_head
            $this->jc_05_head->ViewValue = $this->jc_05_head->CurrentValue;

            // jc_06_head
            $this->jc_06_head->ViewValue = $this->jc_06_head->CurrentValue;

            // jc_07_head
            $this->jc_07_head->ViewValue = $this->jc_07_head->CurrentValue;

            // jc_08_head
            $this->jc_08_head->ViewValue = $this->jc_08_head->CurrentValue;

            // jc_09_head
            $this->jc_09_head->ViewValue = $this->jc_09_head->CurrentValue;

            // jc_10_head
            $this->jc_10_head->ViewValue = $this->jc_10_head->CurrentValue;

            // pc_shape
            $this->pc_shape->ViewValue = $this->pc_shape->CurrentValue;

            // pc_unit
            $this->pc_unit->ViewValue = $this->pc_unit->CurrentValue;

            // pc_w
            $this->pc_w->ViewValue = $this->pc_w->CurrentValue;

            // pc_l
            $this->pc_l->ViewValue = $this->pc_l->CurrentValue;

            // pc_h
            $this->pc_h->ViewValue = $this->pc_h->CurrentValue;

            // pc_partner_size
            $this->pc_partner_size->ViewValue = $this->pc_partner_size->CurrentValue;

            // pc_sqm
            $this->pc_sqm->ViewValue = $this->pc_sqm->CurrentValue;

            // pc_01_head
            $this->pc_01_head->ViewValue = $this->pc_01_head->CurrentValue;

            // pc_02_head
            $this->pc_02_head->ViewValue = $this->pc_02_head->CurrentValue;

            // pc_03_head
            $this->pc_03_head->ViewValue = $this->pc_03_head->CurrentValue;

            // pc_04_head
            $this->pc_04_head->ViewValue = $this->pc_04_head->CurrentValue;

            // pc_05_head
            $this->pc_05_head->ViewValue = $this->pc_05_head->CurrentValue;

            // pc_06_head
            $this->pc_06_head->ViewValue = $this->pc_06_head->CurrentValue;

            // pc_07_head
            $this->pc_07_head->ViewValue = $this->pc_07_head->CurrentValue;

            // pc_08_head
            $this->pc_08_head->ViewValue = $this->pc_08_head->CurrentValue;

            // pc_09_head
            $this->pc_09_head->ViewValue = $this->pc_09_head->CurrentValue;

            // pc_10_head
            $this->pc_10_head->ViewValue = $this->pc_10_head->CurrentValue;

            // pc_11_head
            $this->pc_11_head->ViewValue = $this->pc_11_head->CurrentValue;

            // pc_12_head
            $this->pc_12_head->ViewValue = $this->pc_12_head->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ImageWidth = 0;
                $this->image->ImageHeight = 50;
                $this->image->ImageAlt = $this->image->alt();
                $this->image->ImageCssClass = "ew-image";
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // pa_process_size_w
            $this->pa_process_size_w->ViewValue = $this->pa_process_size_w->CurrentValue;

            // pa_process_size_l
            $this->pa_process_size_l->ViewValue = $this->pa_process_size_l->CurrentValue;

            // pa_head_01
            $this->pa_head_01->ViewValue = $this->pa_head_01->CurrentValue;

            // pa_process_01
            $curVal = strval($this->pa_process_01->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_01->ViewValue = $this->pa_process_01->lookupCacheOption($curVal);
                if ($this->pa_process_01->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_01->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_01->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_01->Lookup->renderViewRow($row);
                            $this->pa_process_01->ViewValue->add($this->pa_process_01->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_01->ViewValue = $this->pa_process_01->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_01->ViewValue = null;
            }

            // pa_head_02
            $this->pa_head_02->ViewValue = $this->pa_head_02->CurrentValue;

            // pa_process_02
            $curVal = strval($this->pa_process_02->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_02->ViewValue = $this->pa_process_02->lookupCacheOption($curVal);
                if ($this->pa_process_02->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_02->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_02->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_02->Lookup->renderViewRow($row);
                            $this->pa_process_02->ViewValue->add($this->pa_process_02->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_02->ViewValue = $this->pa_process_02->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_02->ViewValue = null;
            }

            // pa_head_03
            $this->pa_head_03->ViewValue = $this->pa_head_03->CurrentValue;

            // pa_process_03
            $curVal = strval($this->pa_process_03->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_03->ViewValue = $this->pa_process_03->lookupCacheOption($curVal);
                if ($this->pa_process_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_03->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_03->Lookup->renderViewRow($row);
                            $this->pa_process_03->ViewValue->add($this->pa_process_03->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_03->ViewValue = $this->pa_process_03->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_03->ViewValue = null;
            }

            // pa_head_04
            $this->pa_head_04->ViewValue = $this->pa_head_04->CurrentValue;

            // pa_process_04
            $curVal = strval($this->pa_process_04->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_04->ViewValue = $this->pa_process_04->lookupCacheOption($curVal);
                if ($this->pa_process_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_04->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_04->Lookup->renderViewRow($row);
                            $this->pa_process_04->ViewValue->add($this->pa_process_04->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_04->ViewValue = $this->pa_process_04->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_04->ViewValue = null;
            }

            // pa_head_05
            $this->pa_head_05->ViewValue = $this->pa_head_05->CurrentValue;

            // pa_process_05
            $curVal = strval($this->pa_process_05->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_05->ViewValue = $this->pa_process_05->lookupCacheOption($curVal);
                if ($this->pa_process_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_05->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_05->Lookup->renderViewRow($row);
                            $this->pa_process_05->ViewValue->add($this->pa_process_05->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_05->ViewValue = $this->pa_process_05->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_05->ViewValue = null;
            }

            // pa_head_06
            $this->pa_head_06->ViewValue = $this->pa_head_06->CurrentValue;

            // pa_process_06
            $curVal = strval($this->pa_process_06->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_06->ViewValue = $this->pa_process_06->lookupCacheOption($curVal);
                if ($this->pa_process_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_06->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_06->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_06->Lookup->renderViewRow($row);
                            $this->pa_process_06->ViewValue->add($this->pa_process_06->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_06->ViewValue = $this->pa_process_06->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_06->ViewValue = null;
            }

            // pa_head_07
            $this->pa_head_07->ViewValue = $this->pa_head_07->CurrentValue;

            // pa_process_07
            $curVal = strval($this->pa_process_07->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_07->ViewValue = $this->pa_process_07->lookupCacheOption($curVal);
                if ($this->pa_process_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_07->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_07->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_07->Lookup->renderViewRow($row);
                            $this->pa_process_07->ViewValue->add($this->pa_process_07->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_07->ViewValue = $this->pa_process_07->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_07->ViewValue = null;
            }

            // pa_head_08
            $this->pa_head_08->ViewValue = $this->pa_head_08->CurrentValue;

            // pa_process_08
            $curVal = strval($this->pa_process_08->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_08->ViewValue = $this->pa_process_08->lookupCacheOption($curVal);
                if ($this->pa_process_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_08->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_08->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_08->Lookup->renderViewRow($row);
                            $this->pa_process_08->ViewValue->add($this->pa_process_08->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_08->ViewValue = $this->pa_process_08->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_08->ViewValue = null;
            }

            // pa_head_09
            $this->pa_head_09->ViewValue = $this->pa_head_09->CurrentValue;

            // pa_process_09
            $curVal = strval($this->pa_process_09->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_09->ViewValue = $this->pa_process_09->lookupCacheOption($curVal);
                if ($this->pa_process_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_09->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_09->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_09->Lookup->renderViewRow($row);
                            $this->pa_process_09->ViewValue->add($this->pa_process_09->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_09->ViewValue = $this->pa_process_09->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_09->ViewValue = null;
            }

            // pa_head_10
            $this->pa_head_10->ViewValue = $this->pa_head_10->CurrentValue;

            // pa_process_10
            $curVal = strval($this->pa_process_10->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_10->ViewValue = $this->pa_process_10->lookupCacheOption($curVal);
                if ($this->pa_process_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_10->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_10->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_10->Lookup->renderViewRow($row);
                            $this->pa_process_10->ViewValue->add($this->pa_process_10->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_10->ViewValue = $this->pa_process_10->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_10->ViewValue = null;
            }

            // publish
            $this->publish->ViewValue = $this->publish->CurrentValue;
            $this->publish->ViewValue = FormatNumber($this->publish->ViewValue, $this->publish->formatPattern());

            // ppr_01
            $this->ppr_01->ViewValue = $this->ppr_01->CurrentValue;

            // ppr_02
            $this->ppr_02->ViewValue = $this->ppr_02->CurrentValue;

            // ppr_03
            $this->ppr_03->ViewValue = $this->ppr_03->CurrentValue;

            // ppr_04
            $this->ppr_04->ViewValue = $this->ppr_04->CurrentValue;

            // ppr_05
            $this->ppr_05->ViewValue = $this->ppr_05->CurrentValue;

            // ppr_06
            $this->ppr_06->ViewValue = $this->ppr_06->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->id->ViewValue = $this->highlightValue($this->id);
            }

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // product_group
            $this->product_group->HrefValue = "";
            $this->product_group->TooltipValue = "";
            if (!$this->isExport()) {
                $this->product_group->ViewValue = $this->highlightValue($this->product_group);
            }

            // calculation_method
            $this->calculation_method->HrefValue = "";
            $this->calculation_method->TooltipValue = "";

            // shape
            $this->shape->HrefValue = "";
            $this->shape->TooltipValue = "";
            if (!$this->isExport()) {
                $this->shape->ViewValue = $this->highlightValue($this->shape);
            }

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";
            if (!$this->isExport()) {
                $this->sqm->ViewValue = $this->highlightValue($this->sqm);
            }

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";
            if (!$this->isExport()) {
                $this->cbm->ViewValue = $this->highlightValue($this->cbm);
            }

            // process
            $this->process->HrefValue = "";
            $this->process->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // v_00
            $this->v_00->HrefValue = "";
            $this->v_00->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_00->ViewValue = $this->highlightValue($this->v_00);
            }

            // v_01
            $this->v_01->HrefValue = "";
            $this->v_01->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_01->ViewValue = $this->highlightValue($this->v_01);
            }

            // v_01_validation
            $this->v_01_validation->HrefValue = "";
            $this->v_01_validation->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_01_validation->ViewValue = $this->highlightValue($this->v_01_validation);
            }

            // v_02
            $this->v_02->HrefValue = "";
            $this->v_02->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_02->ViewValue = $this->highlightValue($this->v_02);
            }

            // v_02_validation
            $this->v_02_validation->HrefValue = "";
            $this->v_02_validation->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_02_validation->ViewValue = $this->highlightValue($this->v_02_validation);
            }

            // v_03
            $this->v_03->HrefValue = "";
            $this->v_03->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_03->ViewValue = $this->highlightValue($this->v_03);
            }

            // v_03_validation
            $this->v_03_validation->HrefValue = "";
            $this->v_03_validation->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_03_validation->ViewValue = $this->highlightValue($this->v_03_validation);
            }

            // v_04
            $this->v_04->HrefValue = "";
            $this->v_04->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_04->ViewValue = $this->highlightValue($this->v_04);
            }

            // v_04_validation
            $this->v_04_validation->HrefValue = "";
            $this->v_04_validation->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_04_validation->ViewValue = $this->highlightValue($this->v_04_validation);
            }

            // v_05
            $this->v_05->HrefValue = "";
            $this->v_05->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_05->ViewValue = $this->highlightValue($this->v_05);
            }

            // v_05_validation
            $this->v_05_validation->HrefValue = "";
            $this->v_05_validation->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_05_validation->ViewValue = $this->highlightValue($this->v_05_validation);
            }

            // v_06
            $this->v_06->HrefValue = "";
            $this->v_06->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_06->ViewValue = $this->highlightValue($this->v_06);
            }

            // v_06_validation
            $this->v_06_validation->HrefValue = "";
            $this->v_06_validation->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_06_validation->ViewValue = $this->highlightValue($this->v_06_validation);
            }

            // v_07
            $this->v_07->HrefValue = "";
            $this->v_07->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_07->ViewValue = $this->highlightValue($this->v_07);
            }

            // v_07_validation
            $this->v_07_validation->HrefValue = "";
            $this->v_07_validation->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_07_validation->ViewValue = $this->highlightValue($this->v_07_validation);
            }

            // v_08
            $this->v_08->HrefValue = "";
            $this->v_08->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_08->ViewValue = $this->highlightValue($this->v_08);
            }

            // v_08_validation
            $this->v_08_validation->HrefValue = "";
            $this->v_08_validation->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_08_validation->ViewValue = $this->highlightValue($this->v_08_validation);
            }

            // v_09
            $this->v_09->HrefValue = "";
            $this->v_09->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_09->ViewValue = $this->highlightValue($this->v_09);
            }

            // v_09_validation
            $this->v_09_validation->HrefValue = "";
            $this->v_09_validation->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_09_validation->ViewValue = $this->highlightValue($this->v_09_validation);
            }

            // v_10
            $this->v_10->HrefValue = "";
            $this->v_10->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_10->ViewValue = $this->highlightValue($this->v_10);
            }

            // v_10_validation
            $this->v_10_validation->HrefValue = "";
            $this->v_10_validation->TooltipValue = "";
            if (!$this->isExport()) {
                $this->v_10_validation->ViewValue = $this->highlightValue($this->v_10_validation);
            }

            // b_01_head
            $this->b_01_head->HrefValue = "";
            $this->b_01_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->b_01_head->ViewValue = $this->highlightValue($this->b_01_head);
            }

            // b_02_head
            $this->b_02_head->HrefValue = "";
            $this->b_02_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->b_02_head->ViewValue = $this->highlightValue($this->b_02_head);
            }

            // b_03_head
            $this->b_03_head->HrefValue = "";
            $this->b_03_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->b_03_head->ViewValue = $this->highlightValue($this->b_03_head);
            }

            // b_04_head
            $this->b_04_head->HrefValue = "";
            $this->b_04_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->b_04_head->ViewValue = $this->highlightValue($this->b_04_head);
            }

            // b_05_head
            $this->b_05_head->HrefValue = "";
            $this->b_05_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->b_05_head->ViewValue = $this->highlightValue($this->b_05_head);
            }

            // b_06_head
            $this->b_06_head->HrefValue = "";
            $this->b_06_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->b_06_head->ViewValue = $this->highlightValue($this->b_06_head);
            }

            // b_07_head
            $this->b_07_head->HrefValue = "";
            $this->b_07_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->b_07_head->ViewValue = $this->highlightValue($this->b_07_head);
            }

            // b_08_head
            $this->b_08_head->HrefValue = "";
            $this->b_08_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->b_08_head->ViewValue = $this->highlightValue($this->b_08_head);
            }

            // b_09_head
            $this->b_09_head->HrefValue = "";
            $this->b_09_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->b_09_head->ViewValue = $this->highlightValue($this->b_09_head);
            }

            // b_10_head
            $this->b_10_head->HrefValue = "";
            $this->b_10_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->b_10_head->ViewValue = $this->highlightValue($this->b_10_head);
            }

            // b_11_head
            $this->b_11_head->HrefValue = "";
            $this->b_11_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->b_11_head->ViewValue = $this->highlightValue($this->b_11_head);
            }

            // b_12_head
            $this->b_12_head->HrefValue = "";
            $this->b_12_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->b_12_head->ViewValue = $this->highlightValue($this->b_12_head);
            }

            // b_13_head
            $this->b_13_head->HrefValue = "";
            $this->b_13_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->b_13_head->ViewValue = $this->highlightValue($this->b_13_head);
            }

            // b_14_head
            $this->b_14_head->HrefValue = "";
            $this->b_14_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->b_14_head->ViewValue = $this->highlightValue($this->b_14_head);
            }

            // b_15_head
            $this->b_15_head->HrefValue = "";
            $this->b_15_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->b_15_head->ViewValue = $this->highlightValue($this->b_15_head);
            }

            // q_sku
            $this->q_sku->HrefValue = "";
            $this->q_sku->TooltipValue = "";
            if (!$this->isExport()) {
                $this->q_sku->ViewValue = $this->highlightValue($this->q_sku);
            }

            // t_01_head
            $this->t_01_head->HrefValue = "";
            $this->t_01_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->t_01_head->ViewValue = $this->highlightValue($this->t_01_head);
            }

            // t_02_head
            $this->t_02_head->HrefValue = "";
            $this->t_02_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->t_02_head->ViewValue = $this->highlightValue($this->t_02_head);
            }

            // t_03_head
            $this->t_03_head->HrefValue = "";
            $this->t_03_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->t_03_head->ViewValue = $this->highlightValue($this->t_03_head);
            }

            // t_04_head
            $this->t_04_head->HrefValue = "";
            $this->t_04_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->t_04_head->ViewValue = $this->highlightValue($this->t_04_head);
            }

            // t_05_head
            $this->t_05_head->HrefValue = "";
            $this->t_05_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->t_05_head->ViewValue = $this->highlightValue($this->t_05_head);
            }

            // t_06_head
            $this->t_06_head->HrefValue = "";
            $this->t_06_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->t_06_head->ViewValue = $this->highlightValue($this->t_06_head);
            }

            // t_07_head
            $this->t_07_head->HrefValue = "";
            $this->t_07_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->t_07_head->ViewValue = $this->highlightValue($this->t_07_head);
            }

            // t_08_head
            $this->t_08_head->HrefValue = "";
            $this->t_08_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->t_08_head->ViewValue = $this->highlightValue($this->t_08_head);
            }

            // t_09_head
            $this->t_09_head->HrefValue = "";
            $this->t_09_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->t_09_head->ViewValue = $this->highlightValue($this->t_09_head);
            }

            // t_10_head
            $this->t_10_head->HrefValue = "";
            $this->t_10_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->t_10_head->ViewValue = $this->highlightValue($this->t_10_head);
            }

            // t_11_head
            $this->t_11_head->HrefValue = "";
            $this->t_11_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->t_11_head->ViewValue = $this->highlightValue($this->t_11_head);
            }

            // t_12_head
            $this->t_12_head->HrefValue = "";
            $this->t_12_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->t_12_head->ViewValue = $this->highlightValue($this->t_12_head);
            }

            // t_13_head
            $this->t_13_head->HrefValue = "";
            $this->t_13_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->t_13_head->ViewValue = $this->highlightValue($this->t_13_head);
            }

            // t_14_head
            $this->t_14_head->HrefValue = "";
            $this->t_14_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->t_14_head->ViewValue = $this->highlightValue($this->t_14_head);
            }

            // t_15_head
            $this->t_15_head->HrefValue = "";
            $this->t_15_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->t_15_head->ViewValue = $this->highlightValue($this->t_15_head);
            }

            // po_01_head
            $this->po_01_head->HrefValue = "";
            $this->po_01_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->po_01_head->ViewValue = $this->highlightValue($this->po_01_head);
            }

            // po_02_head
            $this->po_02_head->HrefValue = "";
            $this->po_02_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->po_02_head->ViewValue = $this->highlightValue($this->po_02_head);
            }

            // po_03_head
            $this->po_03_head->HrefValue = "";
            $this->po_03_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->po_03_head->ViewValue = $this->highlightValue($this->po_03_head);
            }

            // po_04_head
            $this->po_04_head->HrefValue = "";
            $this->po_04_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->po_04_head->ViewValue = $this->highlightValue($this->po_04_head);
            }

            // po_05_head
            $this->po_05_head->HrefValue = "";
            $this->po_05_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->po_05_head->ViewValue = $this->highlightValue($this->po_05_head);
            }

            // po_06_head
            $this->po_06_head->HrefValue = "";
            $this->po_06_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->po_06_head->ViewValue = $this->highlightValue($this->po_06_head);
            }

            // po_07_head
            $this->po_07_head->HrefValue = "";
            $this->po_07_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->po_07_head->ViewValue = $this->highlightValue($this->po_07_head);
            }

            // po_08_head
            $this->po_08_head->HrefValue = "";
            $this->po_08_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->po_08_head->ViewValue = $this->highlightValue($this->po_08_head);
            }

            // po_17_head
            $this->po_17_head->HrefValue = "";
            $this->po_17_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->po_17_head->ViewValue = $this->highlightValue($this->po_17_head);
            }

            // po_18_head
            $this->po_18_head->HrefValue = "";
            $this->po_18_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->po_18_head->ViewValue = $this->highlightValue($this->po_18_head);
            }

            // po_19_head
            $this->po_19_head->HrefValue = "";
            $this->po_19_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->po_19_head->ViewValue = $this->highlightValue($this->po_19_head);
            }

            // po_20_head
            $this->po_20_head->HrefValue = "";
            $this->po_20_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->po_20_head->ViewValue = $this->highlightValue($this->po_20_head);
            }

            // jc_01_head
            $this->jc_01_head->HrefValue = "";
            $this->jc_01_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->jc_01_head->ViewValue = $this->highlightValue($this->jc_01_head);
            }

            // jc_02_head
            $this->jc_02_head->HrefValue = "";
            $this->jc_02_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->jc_02_head->ViewValue = $this->highlightValue($this->jc_02_head);
            }

            // jc_03_head
            $this->jc_03_head->HrefValue = "";
            $this->jc_03_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->jc_03_head->ViewValue = $this->highlightValue($this->jc_03_head);
            }

            // jc_04_head
            $this->jc_04_head->HrefValue = "";
            $this->jc_04_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->jc_04_head->ViewValue = $this->highlightValue($this->jc_04_head);
            }

            // jc_05_head
            $this->jc_05_head->HrefValue = "";
            $this->jc_05_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->jc_05_head->ViewValue = $this->highlightValue($this->jc_05_head);
            }

            // jc_06_head
            $this->jc_06_head->HrefValue = "";
            $this->jc_06_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->jc_06_head->ViewValue = $this->highlightValue($this->jc_06_head);
            }

            // jc_07_head
            $this->jc_07_head->HrefValue = "";
            $this->jc_07_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->jc_07_head->ViewValue = $this->highlightValue($this->jc_07_head);
            }

            // jc_08_head
            $this->jc_08_head->HrefValue = "";
            $this->jc_08_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->jc_08_head->ViewValue = $this->highlightValue($this->jc_08_head);
            }

            // jc_09_head
            $this->jc_09_head->HrefValue = "";
            $this->jc_09_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->jc_09_head->ViewValue = $this->highlightValue($this->jc_09_head);
            }

            // jc_10_head
            $this->jc_10_head->HrefValue = "";
            $this->jc_10_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->jc_10_head->ViewValue = $this->highlightValue($this->jc_10_head);
            }

            // pc_shape
            $this->pc_shape->HrefValue = "";
            $this->pc_shape->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_shape->ViewValue = $this->highlightValue($this->pc_shape);
            }

            // pc_unit
            $this->pc_unit->HrefValue = "";
            $this->pc_unit->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_unit->ViewValue = $this->highlightValue($this->pc_unit);
            }

            // pc_w
            $this->pc_w->HrefValue = "";
            $this->pc_w->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_w->ViewValue = $this->highlightValue($this->pc_w);
            }

            // pc_l
            $this->pc_l->HrefValue = "";
            $this->pc_l->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_l->ViewValue = $this->highlightValue($this->pc_l);
            }

            // pc_h
            $this->pc_h->HrefValue = "";
            $this->pc_h->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_h->ViewValue = $this->highlightValue($this->pc_h);
            }

            // pc_partner_size
            $this->pc_partner_size->HrefValue = "";
            $this->pc_partner_size->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_partner_size->ViewValue = $this->highlightValue($this->pc_partner_size);
            }

            // pc_sqm
            $this->pc_sqm->HrefValue = "";
            $this->pc_sqm->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_sqm->ViewValue = $this->highlightValue($this->pc_sqm);
            }

            // pc_01_head
            $this->pc_01_head->HrefValue = "";
            $this->pc_01_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_01_head->ViewValue = $this->highlightValue($this->pc_01_head);
            }

            // pc_02_head
            $this->pc_02_head->HrefValue = "";
            $this->pc_02_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_02_head->ViewValue = $this->highlightValue($this->pc_02_head);
            }

            // pc_03_head
            $this->pc_03_head->HrefValue = "";
            $this->pc_03_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_03_head->ViewValue = $this->highlightValue($this->pc_03_head);
            }

            // pc_04_head
            $this->pc_04_head->HrefValue = "";
            $this->pc_04_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_04_head->ViewValue = $this->highlightValue($this->pc_04_head);
            }

            // pc_05_head
            $this->pc_05_head->HrefValue = "";
            $this->pc_05_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_05_head->ViewValue = $this->highlightValue($this->pc_05_head);
            }

            // pc_06_head
            $this->pc_06_head->HrefValue = "";
            $this->pc_06_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_06_head->ViewValue = $this->highlightValue($this->pc_06_head);
            }

            // pc_07_head
            $this->pc_07_head->HrefValue = "";
            $this->pc_07_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_07_head->ViewValue = $this->highlightValue($this->pc_07_head);
            }

            // pc_08_head
            $this->pc_08_head->HrefValue = "";
            $this->pc_08_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_08_head->ViewValue = $this->highlightValue($this->pc_08_head);
            }

            // pc_09_head
            $this->pc_09_head->HrefValue = "";
            $this->pc_09_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_09_head->ViewValue = $this->highlightValue($this->pc_09_head);
            }

            // pc_10_head
            $this->pc_10_head->HrefValue = "";
            $this->pc_10_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_10_head->ViewValue = $this->highlightValue($this->pc_10_head);
            }

            // pc_11_head
            $this->pc_11_head->HrefValue = "";
            $this->pc_11_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_11_head->ViewValue = $this->highlightValue($this->pc_11_head);
            }

            // pc_12_head
            $this->pc_12_head->HrefValue = "";
            $this->pc_12_head->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pc_12_head->ViewValue = $this->highlightValue($this->pc_12_head);
            }

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";
            if (!$this->isExport()) {
                $this->operator->ViewValue = $this->highlightValue($this->operator);
            }

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
            if (!$this->isExport()) {
                $this->datetime->ViewValue = $this->highlightValue($this->datetime);
            }

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->htmlDecode($this->image->Upload->DbValue)); // Add prefix/suffix
                $this->image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
                }
            } else {
                $this->image->HrefValue = "";
            }
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
            $this->image->TooltipValue = "";
            if ($this->image->UseColorbox) {
                if (EmptyValue($this->image->TooltipValue)) {
                    $this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->image->LinkAttrs["data-rel"] = "product_group_x" . $this->RowCount . "_image";
                $this->image->LinkAttrs->appendClass("ew-lightbox");
            }

            // pa_process_size_w
            $this->pa_process_size_w->HrefValue = "";
            $this->pa_process_size_w->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pa_process_size_w->ViewValue = $this->highlightValue($this->pa_process_size_w);
            }

            // pa_process_size_l
            $this->pa_process_size_l->HrefValue = "";
            $this->pa_process_size_l->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pa_process_size_l->ViewValue = $this->highlightValue($this->pa_process_size_l);
            }

            // pa_head_01
            $this->pa_head_01->HrefValue = "";
            $this->pa_head_01->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pa_head_01->ViewValue = $this->highlightValue($this->pa_head_01);
            }

            // pa_process_01
            $this->pa_process_01->HrefValue = "";
            $this->pa_process_01->TooltipValue = "";

            // pa_head_02
            $this->pa_head_02->HrefValue = "";
            $this->pa_head_02->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pa_head_02->ViewValue = $this->highlightValue($this->pa_head_02);
            }

            // pa_process_02
            $this->pa_process_02->HrefValue = "";
            $this->pa_process_02->TooltipValue = "";

            // pa_head_03
            $this->pa_head_03->HrefValue = "";
            $this->pa_head_03->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pa_head_03->ViewValue = $this->highlightValue($this->pa_head_03);
            }

            // pa_process_03
            $this->pa_process_03->HrefValue = "";
            $this->pa_process_03->TooltipValue = "";

            // pa_head_04
            $this->pa_head_04->HrefValue = "";
            $this->pa_head_04->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pa_head_04->ViewValue = $this->highlightValue($this->pa_head_04);
            }

            // pa_process_04
            $this->pa_process_04->HrefValue = "";
            $this->pa_process_04->TooltipValue = "";

            // pa_head_05
            $this->pa_head_05->HrefValue = "";
            $this->pa_head_05->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pa_head_05->ViewValue = $this->highlightValue($this->pa_head_05);
            }

            // pa_process_05
            $this->pa_process_05->HrefValue = "";
            $this->pa_process_05->TooltipValue = "";

            // pa_head_06
            $this->pa_head_06->HrefValue = "";
            $this->pa_head_06->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pa_head_06->ViewValue = $this->highlightValue($this->pa_head_06);
            }

            // pa_process_06
            $this->pa_process_06->HrefValue = "";
            $this->pa_process_06->TooltipValue = "";

            // pa_head_07
            $this->pa_head_07->HrefValue = "";
            $this->pa_head_07->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pa_head_07->ViewValue = $this->highlightValue($this->pa_head_07);
            }

            // pa_process_07
            $this->pa_process_07->HrefValue = "";
            $this->pa_process_07->TooltipValue = "";

            // pa_head_08
            $this->pa_head_08->HrefValue = "";
            $this->pa_head_08->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pa_head_08->ViewValue = $this->highlightValue($this->pa_head_08);
            }

            // pa_process_08
            $this->pa_process_08->HrefValue = "";
            $this->pa_process_08->TooltipValue = "";

            // pa_head_09
            $this->pa_head_09->HrefValue = "";
            $this->pa_head_09->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pa_head_09->ViewValue = $this->highlightValue($this->pa_head_09);
            }

            // pa_process_09
            $this->pa_process_09->HrefValue = "";
            $this->pa_process_09->TooltipValue = "";

            // pa_head_10
            $this->pa_head_10->HrefValue = "";
            $this->pa_head_10->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pa_head_10->ViewValue = $this->highlightValue($this->pa_head_10);
            }

            // pa_process_10
            $this->pa_process_10->HrefValue = "";
            $this->pa_process_10->TooltipValue = "";

            // publish
            $this->publish->HrefValue = "";
            $this->publish->TooltipValue = "";

            // ppr_01
            $this->ppr_01->HrefValue = "";
            $this->ppr_01->TooltipValue = "";
            if (!$this->isExport()) {
                $this->ppr_01->ViewValue = $this->highlightValue($this->ppr_01);
            }

            // ppr_02
            $this->ppr_02->HrefValue = "";
            $this->ppr_02->TooltipValue = "";
            if (!$this->isExport()) {
                $this->ppr_02->ViewValue = $this->highlightValue($this->ppr_02);
            }

            // ppr_03
            $this->ppr_03->HrefValue = "";
            $this->ppr_03->TooltipValue = "";
            if (!$this->isExport()) {
                $this->ppr_03->ViewValue = $this->highlightValue($this->ppr_03);
            }

            // ppr_04
            $this->ppr_04->HrefValue = "";
            $this->ppr_04->TooltipValue = "";
            if (!$this->isExport()) {
                $this->ppr_04->ViewValue = $this->highlightValue($this->ppr_04);
            }

            // ppr_05
            $this->ppr_05->HrefValue = "";
            $this->ppr_05->TooltipValue = "";
            if (!$this->isExport()) {
                $this->ppr_05->ViewValue = $this->highlightValue($this->ppr_05);
            }

            // ppr_06
            $this->ppr_06->HrefValue = "";
            $this->ppr_06->TooltipValue = "";
            if (!$this->isExport()) {
                $this->ppr_06->ViewValue = $this->highlightValue($this->ppr_06);
            }
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // product_group
            $this->product_group->setupEditAttributes();
            if (!$this->product_group->Raw) {
                $this->product_group->AdvancedSearch->SearchValue = HtmlDecode($this->product_group->AdvancedSearch->SearchValue);
            }
            $this->product_group->EditValue = HtmlEncode($this->product_group->AdvancedSearch->SearchValue);
            $this->product_group->PlaceHolder = RemoveHtml($this->product_group->caption());

            // calculation_method
            $this->calculation_method->setupEditAttributes();
            $this->calculation_method->PlaceHolder = RemoveHtml($this->calculation_method->caption());

            // shape
            $this->shape->setupEditAttributes();
            if (!$this->shape->Raw) {
                $this->shape->AdvancedSearch->SearchValue = HtmlDecode($this->shape->AdvancedSearch->SearchValue);
            }
            $this->shape->EditValue = HtmlEncode($this->shape->AdvancedSearch->SearchValue);
            $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            if (!$this->sqm->Raw) {
                $this->sqm->AdvancedSearch->SearchValue = HtmlDecode($this->sqm->AdvancedSearch->SearchValue);
            }
            $this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

            // cbm
            $this->cbm->setupEditAttributes();
            if (!$this->cbm->Raw) {
                $this->cbm->AdvancedSearch->SearchValue = HtmlDecode($this->cbm->AdvancedSearch->SearchValue);
            }
            $this->cbm->EditValue = HtmlEncode($this->cbm->AdvancedSearch->SearchValue);
            $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

            // process
            $this->process->setupEditAttributes();
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // v_00
            $this->v_00->setupEditAttributes();
            if (!$this->v_00->Raw) {
                $this->v_00->AdvancedSearch->SearchValue = HtmlDecode($this->v_00->AdvancedSearch->SearchValue);
            }
            $this->v_00->EditValue = HtmlEncode($this->v_00->AdvancedSearch->SearchValue);
            $this->v_00->PlaceHolder = RemoveHtml($this->v_00->caption());

            // v_01
            $this->v_01->setupEditAttributes();
            if (!$this->v_01->Raw) {
                $this->v_01->AdvancedSearch->SearchValue = HtmlDecode($this->v_01->AdvancedSearch->SearchValue);
            }
            $this->v_01->EditValue = HtmlEncode($this->v_01->AdvancedSearch->SearchValue);
            $this->v_01->PlaceHolder = RemoveHtml($this->v_01->caption());

            // v_01_validation
            $this->v_01_validation->setupEditAttributes();
            if (!$this->v_01_validation->Raw) {
                $this->v_01_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_01_validation->AdvancedSearch->SearchValue);
            }
            $this->v_01_validation->EditValue = HtmlEncode($this->v_01_validation->AdvancedSearch->SearchValue);
            $this->v_01_validation->PlaceHolder = RemoveHtml($this->v_01_validation->caption());

            // v_02
            $this->v_02->setupEditAttributes();
            if (!$this->v_02->Raw) {
                $this->v_02->AdvancedSearch->SearchValue = HtmlDecode($this->v_02->AdvancedSearch->SearchValue);
            }
            $this->v_02->EditValue = HtmlEncode($this->v_02->AdvancedSearch->SearchValue);
            $this->v_02->PlaceHolder = RemoveHtml($this->v_02->caption());

            // v_02_validation
            $this->v_02_validation->setupEditAttributes();
            if (!$this->v_02_validation->Raw) {
                $this->v_02_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_02_validation->AdvancedSearch->SearchValue);
            }
            $this->v_02_validation->EditValue = HtmlEncode($this->v_02_validation->AdvancedSearch->SearchValue);
            $this->v_02_validation->PlaceHolder = RemoveHtml($this->v_02_validation->caption());

            // v_03
            $this->v_03->setupEditAttributes();
            if (!$this->v_03->Raw) {
                $this->v_03->AdvancedSearch->SearchValue = HtmlDecode($this->v_03->AdvancedSearch->SearchValue);
            }
            $this->v_03->EditValue = HtmlEncode($this->v_03->AdvancedSearch->SearchValue);
            $this->v_03->PlaceHolder = RemoveHtml($this->v_03->caption());

            // v_03_validation
            $this->v_03_validation->setupEditAttributes();
            if (!$this->v_03_validation->Raw) {
                $this->v_03_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_03_validation->AdvancedSearch->SearchValue);
            }
            $this->v_03_validation->EditValue = HtmlEncode($this->v_03_validation->AdvancedSearch->SearchValue);
            $this->v_03_validation->PlaceHolder = RemoveHtml($this->v_03_validation->caption());

            // v_04
            $this->v_04->setupEditAttributes();
            if (!$this->v_04->Raw) {
                $this->v_04->AdvancedSearch->SearchValue = HtmlDecode($this->v_04->AdvancedSearch->SearchValue);
            }
            $this->v_04->EditValue = HtmlEncode($this->v_04->AdvancedSearch->SearchValue);
            $this->v_04->PlaceHolder = RemoveHtml($this->v_04->caption());

            // v_04_validation
            $this->v_04_validation->setupEditAttributes();
            if (!$this->v_04_validation->Raw) {
                $this->v_04_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_04_validation->AdvancedSearch->SearchValue);
            }
            $this->v_04_validation->EditValue = HtmlEncode($this->v_04_validation->AdvancedSearch->SearchValue);
            $this->v_04_validation->PlaceHolder = RemoveHtml($this->v_04_validation->caption());

            // v_05
            $this->v_05->setupEditAttributes();
            if (!$this->v_05->Raw) {
                $this->v_05->AdvancedSearch->SearchValue = HtmlDecode($this->v_05->AdvancedSearch->SearchValue);
            }
            $this->v_05->EditValue = HtmlEncode($this->v_05->AdvancedSearch->SearchValue);
            $this->v_05->PlaceHolder = RemoveHtml($this->v_05->caption());

            // v_05_validation
            $this->v_05_validation->setupEditAttributes();
            if (!$this->v_05_validation->Raw) {
                $this->v_05_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_05_validation->AdvancedSearch->SearchValue);
            }
            $this->v_05_validation->EditValue = HtmlEncode($this->v_05_validation->AdvancedSearch->SearchValue);
            $this->v_05_validation->PlaceHolder = RemoveHtml($this->v_05_validation->caption());

            // v_06
            $this->v_06->setupEditAttributes();
            if (!$this->v_06->Raw) {
                $this->v_06->AdvancedSearch->SearchValue = HtmlDecode($this->v_06->AdvancedSearch->SearchValue);
            }
            $this->v_06->EditValue = HtmlEncode($this->v_06->AdvancedSearch->SearchValue);
            $this->v_06->PlaceHolder = RemoveHtml($this->v_06->caption());

            // v_06_validation
            $this->v_06_validation->setupEditAttributes();
            if (!$this->v_06_validation->Raw) {
                $this->v_06_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_06_validation->AdvancedSearch->SearchValue);
            }
            $this->v_06_validation->EditValue = HtmlEncode($this->v_06_validation->AdvancedSearch->SearchValue);
            $this->v_06_validation->PlaceHolder = RemoveHtml($this->v_06_validation->caption());

            // v_07
            $this->v_07->setupEditAttributes();
            if (!$this->v_07->Raw) {
                $this->v_07->AdvancedSearch->SearchValue = HtmlDecode($this->v_07->AdvancedSearch->SearchValue);
            }
            $this->v_07->EditValue = HtmlEncode($this->v_07->AdvancedSearch->SearchValue);
            $this->v_07->PlaceHolder = RemoveHtml($this->v_07->caption());

            // v_07_validation
            $this->v_07_validation->setupEditAttributes();
            if (!$this->v_07_validation->Raw) {
                $this->v_07_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_07_validation->AdvancedSearch->SearchValue);
            }
            $this->v_07_validation->EditValue = HtmlEncode($this->v_07_validation->AdvancedSearch->SearchValue);
            $this->v_07_validation->PlaceHolder = RemoveHtml($this->v_07_validation->caption());

            // v_08
            $this->v_08->setupEditAttributes();
            if (!$this->v_08->Raw) {
                $this->v_08->AdvancedSearch->SearchValue = HtmlDecode($this->v_08->AdvancedSearch->SearchValue);
            }
            $this->v_08->EditValue = HtmlEncode($this->v_08->AdvancedSearch->SearchValue);
            $this->v_08->PlaceHolder = RemoveHtml($this->v_08->caption());

            // v_08_validation
            $this->v_08_validation->setupEditAttributes();
            if (!$this->v_08_validation->Raw) {
                $this->v_08_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_08_validation->AdvancedSearch->SearchValue);
            }
            $this->v_08_validation->EditValue = HtmlEncode($this->v_08_validation->AdvancedSearch->SearchValue);
            $this->v_08_validation->PlaceHolder = RemoveHtml($this->v_08_validation->caption());

            // v_09
            $this->v_09->setupEditAttributes();
            if (!$this->v_09->Raw) {
                $this->v_09->AdvancedSearch->SearchValue = HtmlDecode($this->v_09->AdvancedSearch->SearchValue);
            }
            $this->v_09->EditValue = HtmlEncode($this->v_09->AdvancedSearch->SearchValue);
            $this->v_09->PlaceHolder = RemoveHtml($this->v_09->caption());

            // v_09_validation
            $this->v_09_validation->setupEditAttributes();
            if (!$this->v_09_validation->Raw) {
                $this->v_09_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_09_validation->AdvancedSearch->SearchValue);
            }
            $this->v_09_validation->EditValue = HtmlEncode($this->v_09_validation->AdvancedSearch->SearchValue);
            $this->v_09_validation->PlaceHolder = RemoveHtml($this->v_09_validation->caption());

            // v_10
            $this->v_10->setupEditAttributes();
            if (!$this->v_10->Raw) {
                $this->v_10->AdvancedSearch->SearchValue = HtmlDecode($this->v_10->AdvancedSearch->SearchValue);
            }
            $this->v_10->EditValue = HtmlEncode($this->v_10->AdvancedSearch->SearchValue);
            $this->v_10->PlaceHolder = RemoveHtml($this->v_10->caption());

            // v_10_validation
            $this->v_10_validation->setupEditAttributes();
            if (!$this->v_10_validation->Raw) {
                $this->v_10_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_10_validation->AdvancedSearch->SearchValue);
            }
            $this->v_10_validation->EditValue = HtmlEncode($this->v_10_validation->AdvancedSearch->SearchValue);
            $this->v_10_validation->PlaceHolder = RemoveHtml($this->v_10_validation->caption());

            // b_01_head
            $this->b_01_head->setupEditAttributes();
            if (!$this->b_01_head->Raw) {
                $this->b_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_01_head->AdvancedSearch->SearchValue);
            }
            $this->b_01_head->EditValue = HtmlEncode($this->b_01_head->AdvancedSearch->SearchValue);
            $this->b_01_head->PlaceHolder = RemoveHtml($this->b_01_head->caption());

            // b_02_head
            $this->b_02_head->setupEditAttributes();
            if (!$this->b_02_head->Raw) {
                $this->b_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_02_head->AdvancedSearch->SearchValue);
            }
            $this->b_02_head->EditValue = HtmlEncode($this->b_02_head->AdvancedSearch->SearchValue);
            $this->b_02_head->PlaceHolder = RemoveHtml($this->b_02_head->caption());

            // b_03_head
            $this->b_03_head->setupEditAttributes();
            if (!$this->b_03_head->Raw) {
                $this->b_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_03_head->AdvancedSearch->SearchValue);
            }
            $this->b_03_head->EditValue = HtmlEncode($this->b_03_head->AdvancedSearch->SearchValue);
            $this->b_03_head->PlaceHolder = RemoveHtml($this->b_03_head->caption());

            // b_04_head
            $this->b_04_head->setupEditAttributes();
            if (!$this->b_04_head->Raw) {
                $this->b_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_04_head->AdvancedSearch->SearchValue);
            }
            $this->b_04_head->EditValue = HtmlEncode($this->b_04_head->AdvancedSearch->SearchValue);
            $this->b_04_head->PlaceHolder = RemoveHtml($this->b_04_head->caption());

            // b_05_head
            $this->b_05_head->setupEditAttributes();
            if (!$this->b_05_head->Raw) {
                $this->b_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_05_head->AdvancedSearch->SearchValue);
            }
            $this->b_05_head->EditValue = HtmlEncode($this->b_05_head->AdvancedSearch->SearchValue);
            $this->b_05_head->PlaceHolder = RemoveHtml($this->b_05_head->caption());

            // b_06_head
            $this->b_06_head->setupEditAttributes();
            if (!$this->b_06_head->Raw) {
                $this->b_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_06_head->AdvancedSearch->SearchValue);
            }
            $this->b_06_head->EditValue = HtmlEncode($this->b_06_head->AdvancedSearch->SearchValue);
            $this->b_06_head->PlaceHolder = RemoveHtml($this->b_06_head->caption());

            // b_07_head
            $this->b_07_head->setupEditAttributes();
            if (!$this->b_07_head->Raw) {
                $this->b_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_07_head->AdvancedSearch->SearchValue);
            }
            $this->b_07_head->EditValue = HtmlEncode($this->b_07_head->AdvancedSearch->SearchValue);
            $this->b_07_head->PlaceHolder = RemoveHtml($this->b_07_head->caption());

            // b_08_head
            $this->b_08_head->setupEditAttributes();
            if (!$this->b_08_head->Raw) {
                $this->b_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_08_head->AdvancedSearch->SearchValue);
            }
            $this->b_08_head->EditValue = HtmlEncode($this->b_08_head->AdvancedSearch->SearchValue);
            $this->b_08_head->PlaceHolder = RemoveHtml($this->b_08_head->caption());

            // b_09_head
            $this->b_09_head->setupEditAttributes();
            if (!$this->b_09_head->Raw) {
                $this->b_09_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_09_head->AdvancedSearch->SearchValue);
            }
            $this->b_09_head->EditValue = HtmlEncode($this->b_09_head->AdvancedSearch->SearchValue);
            $this->b_09_head->PlaceHolder = RemoveHtml($this->b_09_head->caption());

            // b_10_head
            $this->b_10_head->setupEditAttributes();
            if (!$this->b_10_head->Raw) {
                $this->b_10_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_10_head->AdvancedSearch->SearchValue);
            }
            $this->b_10_head->EditValue = HtmlEncode($this->b_10_head->AdvancedSearch->SearchValue);
            $this->b_10_head->PlaceHolder = RemoveHtml($this->b_10_head->caption());

            // b_11_head
            $this->b_11_head->setupEditAttributes();
            if (!$this->b_11_head->Raw) {
                $this->b_11_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_11_head->AdvancedSearch->SearchValue);
            }
            $this->b_11_head->EditValue = HtmlEncode($this->b_11_head->AdvancedSearch->SearchValue);
            $this->b_11_head->PlaceHolder = RemoveHtml($this->b_11_head->caption());

            // b_12_head
            $this->b_12_head->setupEditAttributes();
            if (!$this->b_12_head->Raw) {
                $this->b_12_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_12_head->AdvancedSearch->SearchValue);
            }
            $this->b_12_head->EditValue = HtmlEncode($this->b_12_head->AdvancedSearch->SearchValue);
            $this->b_12_head->PlaceHolder = RemoveHtml($this->b_12_head->caption());

            // b_13_head
            $this->b_13_head->setupEditAttributes();
            if (!$this->b_13_head->Raw) {
                $this->b_13_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_13_head->AdvancedSearch->SearchValue);
            }
            $this->b_13_head->EditValue = HtmlEncode($this->b_13_head->AdvancedSearch->SearchValue);
            $this->b_13_head->PlaceHolder = RemoveHtml($this->b_13_head->caption());

            // b_14_head
            $this->b_14_head->setupEditAttributes();
            if (!$this->b_14_head->Raw) {
                $this->b_14_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_14_head->AdvancedSearch->SearchValue);
            }
            $this->b_14_head->EditValue = HtmlEncode($this->b_14_head->AdvancedSearch->SearchValue);
            $this->b_14_head->PlaceHolder = RemoveHtml($this->b_14_head->caption());

            // b_15_head
            $this->b_15_head->setupEditAttributes();
            if (!$this->b_15_head->Raw) {
                $this->b_15_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_15_head->AdvancedSearch->SearchValue);
            }
            $this->b_15_head->EditValue = HtmlEncode($this->b_15_head->AdvancedSearch->SearchValue);
            $this->b_15_head->PlaceHolder = RemoveHtml($this->b_15_head->caption());

            // q_sku
            $this->q_sku->setupEditAttributes();
            if (!$this->q_sku->Raw) {
                $this->q_sku->AdvancedSearch->SearchValue = HtmlDecode($this->q_sku->AdvancedSearch->SearchValue);
            }
            $this->q_sku->EditValue = HtmlEncode($this->q_sku->AdvancedSearch->SearchValue);
            $this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());

            // t_01_head
            $this->t_01_head->setupEditAttributes();
            if (!$this->t_01_head->Raw) {
                $this->t_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_01_head->AdvancedSearch->SearchValue);
            }
            $this->t_01_head->EditValue = HtmlEncode($this->t_01_head->AdvancedSearch->SearchValue);
            $this->t_01_head->PlaceHolder = RemoveHtml($this->t_01_head->caption());

            // t_02_head
            $this->t_02_head->setupEditAttributes();
            if (!$this->t_02_head->Raw) {
                $this->t_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_02_head->AdvancedSearch->SearchValue);
            }
            $this->t_02_head->EditValue = HtmlEncode($this->t_02_head->AdvancedSearch->SearchValue);
            $this->t_02_head->PlaceHolder = RemoveHtml($this->t_02_head->caption());

            // t_03_head
            $this->t_03_head->setupEditAttributes();
            if (!$this->t_03_head->Raw) {
                $this->t_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_03_head->AdvancedSearch->SearchValue);
            }
            $this->t_03_head->EditValue = HtmlEncode($this->t_03_head->AdvancedSearch->SearchValue);
            $this->t_03_head->PlaceHolder = RemoveHtml($this->t_03_head->caption());

            // t_04_head
            $this->t_04_head->setupEditAttributes();
            if (!$this->t_04_head->Raw) {
                $this->t_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_04_head->AdvancedSearch->SearchValue);
            }
            $this->t_04_head->EditValue = HtmlEncode($this->t_04_head->AdvancedSearch->SearchValue);
            $this->t_04_head->PlaceHolder = RemoveHtml($this->t_04_head->caption());

            // t_05_head
            $this->t_05_head->setupEditAttributes();
            if (!$this->t_05_head->Raw) {
                $this->t_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_05_head->AdvancedSearch->SearchValue);
            }
            $this->t_05_head->EditValue = HtmlEncode($this->t_05_head->AdvancedSearch->SearchValue);
            $this->t_05_head->PlaceHolder = RemoveHtml($this->t_05_head->caption());

            // t_06_head
            $this->t_06_head->setupEditAttributes();
            if (!$this->t_06_head->Raw) {
                $this->t_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_06_head->AdvancedSearch->SearchValue);
            }
            $this->t_06_head->EditValue = HtmlEncode($this->t_06_head->AdvancedSearch->SearchValue);
            $this->t_06_head->PlaceHolder = RemoveHtml($this->t_06_head->caption());

            // t_07_head
            $this->t_07_head->setupEditAttributes();
            if (!$this->t_07_head->Raw) {
                $this->t_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_07_head->AdvancedSearch->SearchValue);
            }
            $this->t_07_head->EditValue = HtmlEncode($this->t_07_head->AdvancedSearch->SearchValue);
            $this->t_07_head->PlaceHolder = RemoveHtml($this->t_07_head->caption());

            // t_08_head
            $this->t_08_head->setupEditAttributes();
            if (!$this->t_08_head->Raw) {
                $this->t_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_08_head->AdvancedSearch->SearchValue);
            }
            $this->t_08_head->EditValue = HtmlEncode($this->t_08_head->AdvancedSearch->SearchValue);
            $this->t_08_head->PlaceHolder = RemoveHtml($this->t_08_head->caption());

            // t_09_head
            $this->t_09_head->setupEditAttributes();
            if (!$this->t_09_head->Raw) {
                $this->t_09_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_09_head->AdvancedSearch->SearchValue);
            }
            $this->t_09_head->EditValue = HtmlEncode($this->t_09_head->AdvancedSearch->SearchValue);
            $this->t_09_head->PlaceHolder = RemoveHtml($this->t_09_head->caption());

            // t_10_head
            $this->t_10_head->setupEditAttributes();
            if (!$this->t_10_head->Raw) {
                $this->t_10_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_10_head->AdvancedSearch->SearchValue);
            }
            $this->t_10_head->EditValue = HtmlEncode($this->t_10_head->AdvancedSearch->SearchValue);
            $this->t_10_head->PlaceHolder = RemoveHtml($this->t_10_head->caption());

            // t_11_head
            $this->t_11_head->setupEditAttributes();
            if (!$this->t_11_head->Raw) {
                $this->t_11_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_11_head->AdvancedSearch->SearchValue);
            }
            $this->t_11_head->EditValue = HtmlEncode($this->t_11_head->AdvancedSearch->SearchValue);
            $this->t_11_head->PlaceHolder = RemoveHtml($this->t_11_head->caption());

            // t_12_head
            $this->t_12_head->setupEditAttributes();
            if (!$this->t_12_head->Raw) {
                $this->t_12_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_12_head->AdvancedSearch->SearchValue);
            }
            $this->t_12_head->EditValue = HtmlEncode($this->t_12_head->AdvancedSearch->SearchValue);
            $this->t_12_head->PlaceHolder = RemoveHtml($this->t_12_head->caption());

            // t_13_head
            $this->t_13_head->setupEditAttributes();
            if (!$this->t_13_head->Raw) {
                $this->t_13_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_13_head->AdvancedSearch->SearchValue);
            }
            $this->t_13_head->EditValue = HtmlEncode($this->t_13_head->AdvancedSearch->SearchValue);
            $this->t_13_head->PlaceHolder = RemoveHtml($this->t_13_head->caption());

            // t_14_head
            $this->t_14_head->setupEditAttributes();
            if (!$this->t_14_head->Raw) {
                $this->t_14_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_14_head->AdvancedSearch->SearchValue);
            }
            $this->t_14_head->EditValue = HtmlEncode($this->t_14_head->AdvancedSearch->SearchValue);
            $this->t_14_head->PlaceHolder = RemoveHtml($this->t_14_head->caption());

            // t_15_head
            $this->t_15_head->setupEditAttributes();
            if (!$this->t_15_head->Raw) {
                $this->t_15_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_15_head->AdvancedSearch->SearchValue);
            }
            $this->t_15_head->EditValue = HtmlEncode($this->t_15_head->AdvancedSearch->SearchValue);
            $this->t_15_head->PlaceHolder = RemoveHtml($this->t_15_head->caption());

            // po_01_head
            $this->po_01_head->setupEditAttributes();
            if (!$this->po_01_head->Raw) {
                $this->po_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_01_head->AdvancedSearch->SearchValue);
            }
            $this->po_01_head->EditValue = HtmlEncode($this->po_01_head->AdvancedSearch->SearchValue);
            $this->po_01_head->PlaceHolder = RemoveHtml($this->po_01_head->caption());

            // po_02_head
            $this->po_02_head->setupEditAttributes();
            if (!$this->po_02_head->Raw) {
                $this->po_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_02_head->AdvancedSearch->SearchValue);
            }
            $this->po_02_head->EditValue = HtmlEncode($this->po_02_head->AdvancedSearch->SearchValue);
            $this->po_02_head->PlaceHolder = RemoveHtml($this->po_02_head->caption());

            // po_03_head
            $this->po_03_head->setupEditAttributes();
            if (!$this->po_03_head->Raw) {
                $this->po_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_03_head->AdvancedSearch->SearchValue);
            }
            $this->po_03_head->EditValue = HtmlEncode($this->po_03_head->AdvancedSearch->SearchValue);
            $this->po_03_head->PlaceHolder = RemoveHtml($this->po_03_head->caption());

            // po_04_head
            $this->po_04_head->setupEditAttributes();
            if (!$this->po_04_head->Raw) {
                $this->po_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_04_head->AdvancedSearch->SearchValue);
            }
            $this->po_04_head->EditValue = HtmlEncode($this->po_04_head->AdvancedSearch->SearchValue);
            $this->po_04_head->PlaceHolder = RemoveHtml($this->po_04_head->caption());

            // po_05_head
            $this->po_05_head->setupEditAttributes();
            if (!$this->po_05_head->Raw) {
                $this->po_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_05_head->AdvancedSearch->SearchValue);
            }
            $this->po_05_head->EditValue = HtmlEncode($this->po_05_head->AdvancedSearch->SearchValue);
            $this->po_05_head->PlaceHolder = RemoveHtml($this->po_05_head->caption());

            // po_06_head
            $this->po_06_head->setupEditAttributes();
            if (!$this->po_06_head->Raw) {
                $this->po_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_06_head->AdvancedSearch->SearchValue);
            }
            $this->po_06_head->EditValue = HtmlEncode($this->po_06_head->AdvancedSearch->SearchValue);
            $this->po_06_head->PlaceHolder = RemoveHtml($this->po_06_head->caption());

            // po_07_head
            $this->po_07_head->setupEditAttributes();
            if (!$this->po_07_head->Raw) {
                $this->po_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_07_head->AdvancedSearch->SearchValue);
            }
            $this->po_07_head->EditValue = HtmlEncode($this->po_07_head->AdvancedSearch->SearchValue);
            $this->po_07_head->PlaceHolder = RemoveHtml($this->po_07_head->caption());

            // po_08_head
            $this->po_08_head->setupEditAttributes();
            if (!$this->po_08_head->Raw) {
                $this->po_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_08_head->AdvancedSearch->SearchValue);
            }
            $this->po_08_head->EditValue = HtmlEncode($this->po_08_head->AdvancedSearch->SearchValue);
            $this->po_08_head->PlaceHolder = RemoveHtml($this->po_08_head->caption());

            // po_17_head
            $this->po_17_head->setupEditAttributes();
            if (!$this->po_17_head->Raw) {
                $this->po_17_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_17_head->AdvancedSearch->SearchValue);
            }
            $this->po_17_head->EditValue = HtmlEncode($this->po_17_head->AdvancedSearch->SearchValue);
            $this->po_17_head->PlaceHolder = RemoveHtml($this->po_17_head->caption());

            // po_18_head
            $this->po_18_head->setupEditAttributes();
            if (!$this->po_18_head->Raw) {
                $this->po_18_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_18_head->AdvancedSearch->SearchValue);
            }
            $this->po_18_head->EditValue = HtmlEncode($this->po_18_head->AdvancedSearch->SearchValue);
            $this->po_18_head->PlaceHolder = RemoveHtml($this->po_18_head->caption());

            // po_19_head
            $this->po_19_head->setupEditAttributes();
            if (!$this->po_19_head->Raw) {
                $this->po_19_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_19_head->AdvancedSearch->SearchValue);
            }
            $this->po_19_head->EditValue = HtmlEncode($this->po_19_head->AdvancedSearch->SearchValue);
            $this->po_19_head->PlaceHolder = RemoveHtml($this->po_19_head->caption());

            // po_20_head
            $this->po_20_head->setupEditAttributes();
            if (!$this->po_20_head->Raw) {
                $this->po_20_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_20_head->AdvancedSearch->SearchValue);
            }
            $this->po_20_head->EditValue = HtmlEncode($this->po_20_head->AdvancedSearch->SearchValue);
            $this->po_20_head->PlaceHolder = RemoveHtml($this->po_20_head->caption());

            // jc_01_head
            $this->jc_01_head->setupEditAttributes();
            if (!$this->jc_01_head->Raw) {
                $this->jc_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_01_head->AdvancedSearch->SearchValue);
            }
            $this->jc_01_head->EditValue = HtmlEncode($this->jc_01_head->AdvancedSearch->SearchValue);
            $this->jc_01_head->PlaceHolder = RemoveHtml($this->jc_01_head->caption());

            // jc_02_head
            $this->jc_02_head->setupEditAttributes();
            if (!$this->jc_02_head->Raw) {
                $this->jc_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_02_head->AdvancedSearch->SearchValue);
            }
            $this->jc_02_head->EditValue = HtmlEncode($this->jc_02_head->AdvancedSearch->SearchValue);
            $this->jc_02_head->PlaceHolder = RemoveHtml($this->jc_02_head->caption());

            // jc_03_head
            $this->jc_03_head->setupEditAttributes();
            if (!$this->jc_03_head->Raw) {
                $this->jc_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_03_head->AdvancedSearch->SearchValue);
            }
            $this->jc_03_head->EditValue = HtmlEncode($this->jc_03_head->AdvancedSearch->SearchValue);
            $this->jc_03_head->PlaceHolder = RemoveHtml($this->jc_03_head->caption());

            // jc_04_head
            $this->jc_04_head->setupEditAttributes();
            if (!$this->jc_04_head->Raw) {
                $this->jc_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_04_head->AdvancedSearch->SearchValue);
            }
            $this->jc_04_head->EditValue = HtmlEncode($this->jc_04_head->AdvancedSearch->SearchValue);
            $this->jc_04_head->PlaceHolder = RemoveHtml($this->jc_04_head->caption());

            // jc_05_head
            $this->jc_05_head->setupEditAttributes();
            if (!$this->jc_05_head->Raw) {
                $this->jc_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_05_head->AdvancedSearch->SearchValue);
            }
            $this->jc_05_head->EditValue = HtmlEncode($this->jc_05_head->AdvancedSearch->SearchValue);
            $this->jc_05_head->PlaceHolder = RemoveHtml($this->jc_05_head->caption());

            // jc_06_head
            $this->jc_06_head->setupEditAttributes();
            if (!$this->jc_06_head->Raw) {
                $this->jc_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_06_head->AdvancedSearch->SearchValue);
            }
            $this->jc_06_head->EditValue = HtmlEncode($this->jc_06_head->AdvancedSearch->SearchValue);
            $this->jc_06_head->PlaceHolder = RemoveHtml($this->jc_06_head->caption());

            // jc_07_head
            $this->jc_07_head->setupEditAttributes();
            if (!$this->jc_07_head->Raw) {
                $this->jc_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_07_head->AdvancedSearch->SearchValue);
            }
            $this->jc_07_head->EditValue = HtmlEncode($this->jc_07_head->AdvancedSearch->SearchValue);
            $this->jc_07_head->PlaceHolder = RemoveHtml($this->jc_07_head->caption());

            // jc_08_head
            $this->jc_08_head->setupEditAttributes();
            if (!$this->jc_08_head->Raw) {
                $this->jc_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_08_head->AdvancedSearch->SearchValue);
            }
            $this->jc_08_head->EditValue = HtmlEncode($this->jc_08_head->AdvancedSearch->SearchValue);
            $this->jc_08_head->PlaceHolder = RemoveHtml($this->jc_08_head->caption());

            // jc_09_head
            $this->jc_09_head->setupEditAttributes();
            if (!$this->jc_09_head->Raw) {
                $this->jc_09_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_09_head->AdvancedSearch->SearchValue);
            }
            $this->jc_09_head->EditValue = HtmlEncode($this->jc_09_head->AdvancedSearch->SearchValue);
            $this->jc_09_head->PlaceHolder = RemoveHtml($this->jc_09_head->caption());

            // jc_10_head
            $this->jc_10_head->setupEditAttributes();
            if (!$this->jc_10_head->Raw) {
                $this->jc_10_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_10_head->AdvancedSearch->SearchValue);
            }
            $this->jc_10_head->EditValue = HtmlEncode($this->jc_10_head->AdvancedSearch->SearchValue);
            $this->jc_10_head->PlaceHolder = RemoveHtml($this->jc_10_head->caption());

            // pc_shape
            $this->pc_shape->setupEditAttributes();
            if (!$this->pc_shape->Raw) {
                $this->pc_shape->AdvancedSearch->SearchValue = HtmlDecode($this->pc_shape->AdvancedSearch->SearchValue);
            }
            $this->pc_shape->EditValue = HtmlEncode($this->pc_shape->AdvancedSearch->SearchValue);
            $this->pc_shape->PlaceHolder = RemoveHtml($this->pc_shape->caption());

            // pc_unit
            $this->pc_unit->setupEditAttributes();
            if (!$this->pc_unit->Raw) {
                $this->pc_unit->AdvancedSearch->SearchValue = HtmlDecode($this->pc_unit->AdvancedSearch->SearchValue);
            }
            $this->pc_unit->EditValue = HtmlEncode($this->pc_unit->AdvancedSearch->SearchValue);
            $this->pc_unit->PlaceHolder = RemoveHtml($this->pc_unit->caption());

            // pc_w
            $this->pc_w->setupEditAttributes();
            if (!$this->pc_w->Raw) {
                $this->pc_w->AdvancedSearch->SearchValue = HtmlDecode($this->pc_w->AdvancedSearch->SearchValue);
            }
            $this->pc_w->EditValue = HtmlEncode($this->pc_w->AdvancedSearch->SearchValue);
            $this->pc_w->PlaceHolder = RemoveHtml($this->pc_w->caption());

            // pc_l
            $this->pc_l->setupEditAttributes();
            if (!$this->pc_l->Raw) {
                $this->pc_l->AdvancedSearch->SearchValue = HtmlDecode($this->pc_l->AdvancedSearch->SearchValue);
            }
            $this->pc_l->EditValue = HtmlEncode($this->pc_l->AdvancedSearch->SearchValue);
            $this->pc_l->PlaceHolder = RemoveHtml($this->pc_l->caption());

            // pc_h
            $this->pc_h->setupEditAttributes();
            if (!$this->pc_h->Raw) {
                $this->pc_h->AdvancedSearch->SearchValue = HtmlDecode($this->pc_h->AdvancedSearch->SearchValue);
            }
            $this->pc_h->EditValue = HtmlEncode($this->pc_h->AdvancedSearch->SearchValue);
            $this->pc_h->PlaceHolder = RemoveHtml($this->pc_h->caption());

            // pc_partner_size
            $this->pc_partner_size->setupEditAttributes();
            if (!$this->pc_partner_size->Raw) {
                $this->pc_partner_size->AdvancedSearch->SearchValue = HtmlDecode($this->pc_partner_size->AdvancedSearch->SearchValue);
            }
            $this->pc_partner_size->EditValue = HtmlEncode($this->pc_partner_size->AdvancedSearch->SearchValue);
            $this->pc_partner_size->PlaceHolder = RemoveHtml($this->pc_partner_size->caption());

            // pc_sqm
            $this->pc_sqm->setupEditAttributes();
            if (!$this->pc_sqm->Raw) {
                $this->pc_sqm->AdvancedSearch->SearchValue = HtmlDecode($this->pc_sqm->AdvancedSearch->SearchValue);
            }
            $this->pc_sqm->EditValue = HtmlEncode($this->pc_sqm->AdvancedSearch->SearchValue);
            $this->pc_sqm->PlaceHolder = RemoveHtml($this->pc_sqm->caption());

            // pc_01_head
            $this->pc_01_head->setupEditAttributes();
            if (!$this->pc_01_head->Raw) {
                $this->pc_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_01_head->AdvancedSearch->SearchValue);
            }
            $this->pc_01_head->EditValue = HtmlEncode($this->pc_01_head->AdvancedSearch->SearchValue);
            $this->pc_01_head->PlaceHolder = RemoveHtml($this->pc_01_head->caption());

            // pc_02_head
            $this->pc_02_head->setupEditAttributes();
            if (!$this->pc_02_head->Raw) {
                $this->pc_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_02_head->AdvancedSearch->SearchValue);
            }
            $this->pc_02_head->EditValue = HtmlEncode($this->pc_02_head->AdvancedSearch->SearchValue);
            $this->pc_02_head->PlaceHolder = RemoveHtml($this->pc_02_head->caption());

            // pc_03_head
            $this->pc_03_head->setupEditAttributes();
            if (!$this->pc_03_head->Raw) {
                $this->pc_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_03_head->AdvancedSearch->SearchValue);
            }
            $this->pc_03_head->EditValue = HtmlEncode($this->pc_03_head->AdvancedSearch->SearchValue);
            $this->pc_03_head->PlaceHolder = RemoveHtml($this->pc_03_head->caption());

            // pc_04_head
            $this->pc_04_head->setupEditAttributes();
            if (!$this->pc_04_head->Raw) {
                $this->pc_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_04_head->AdvancedSearch->SearchValue);
            }
            $this->pc_04_head->EditValue = HtmlEncode($this->pc_04_head->AdvancedSearch->SearchValue);
            $this->pc_04_head->PlaceHolder = RemoveHtml($this->pc_04_head->caption());

            // pc_05_head
            $this->pc_05_head->setupEditAttributes();
            if (!$this->pc_05_head->Raw) {
                $this->pc_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_05_head->AdvancedSearch->SearchValue);
            }
            $this->pc_05_head->EditValue = HtmlEncode($this->pc_05_head->AdvancedSearch->SearchValue);
            $this->pc_05_head->PlaceHolder = RemoveHtml($this->pc_05_head->caption());

            // pc_06_head
            $this->pc_06_head->setupEditAttributes();
            if (!$this->pc_06_head->Raw) {
                $this->pc_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_06_head->AdvancedSearch->SearchValue);
            }
            $this->pc_06_head->EditValue = HtmlEncode($this->pc_06_head->AdvancedSearch->SearchValue);
            $this->pc_06_head->PlaceHolder = RemoveHtml($this->pc_06_head->caption());

            // pc_07_head
            $this->pc_07_head->setupEditAttributes();
            if (!$this->pc_07_head->Raw) {
                $this->pc_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_07_head->AdvancedSearch->SearchValue);
            }
            $this->pc_07_head->EditValue = HtmlEncode($this->pc_07_head->AdvancedSearch->SearchValue);
            $this->pc_07_head->PlaceHolder = RemoveHtml($this->pc_07_head->caption());

            // pc_08_head
            $this->pc_08_head->setupEditAttributes();
            if (!$this->pc_08_head->Raw) {
                $this->pc_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_08_head->AdvancedSearch->SearchValue);
            }
            $this->pc_08_head->EditValue = HtmlEncode($this->pc_08_head->AdvancedSearch->SearchValue);
            $this->pc_08_head->PlaceHolder = RemoveHtml($this->pc_08_head->caption());

            // pc_09_head
            $this->pc_09_head->setupEditAttributes();
            if (!$this->pc_09_head->Raw) {
                $this->pc_09_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_09_head->AdvancedSearch->SearchValue);
            }
            $this->pc_09_head->EditValue = HtmlEncode($this->pc_09_head->AdvancedSearch->SearchValue);
            $this->pc_09_head->PlaceHolder = RemoveHtml($this->pc_09_head->caption());

            // pc_10_head
            $this->pc_10_head->setupEditAttributes();
            if (!$this->pc_10_head->Raw) {
                $this->pc_10_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_10_head->AdvancedSearch->SearchValue);
            }
            $this->pc_10_head->EditValue = HtmlEncode($this->pc_10_head->AdvancedSearch->SearchValue);
            $this->pc_10_head->PlaceHolder = RemoveHtml($this->pc_10_head->caption());

            // pc_11_head
            $this->pc_11_head->setupEditAttributes();
            if (!$this->pc_11_head->Raw) {
                $this->pc_11_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_11_head->AdvancedSearch->SearchValue);
            }
            $this->pc_11_head->EditValue = HtmlEncode($this->pc_11_head->AdvancedSearch->SearchValue);
            $this->pc_11_head->PlaceHolder = RemoveHtml($this->pc_11_head->caption());

            // pc_12_head
            $this->pc_12_head->setupEditAttributes();
            if (!$this->pc_12_head->Raw) {
                $this->pc_12_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_12_head->AdvancedSearch->SearchValue);
            }
            $this->pc_12_head->EditValue = HtmlEncode($this->pc_12_head->AdvancedSearch->SearchValue);
            $this->pc_12_head->PlaceHolder = RemoveHtml($this->pc_12_head->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // image
            $this->image->setupEditAttributes();
            if (!$this->image->Raw) {
                $this->image->AdvancedSearch->SearchValue = HtmlDecode($this->image->AdvancedSearch->SearchValue);
            }
            $this->image->EditValue = HtmlEncode($this->image->AdvancedSearch->SearchValue);
            $this->image->PlaceHolder = RemoveHtml($this->image->caption());

            // pa_process_size_w
            $this->pa_process_size_w->setupEditAttributes();
            if (!$this->pa_process_size_w->Raw) {
                $this->pa_process_size_w->AdvancedSearch->SearchValue = HtmlDecode($this->pa_process_size_w->AdvancedSearch->SearchValue);
            }
            $this->pa_process_size_w->EditValue = HtmlEncode($this->pa_process_size_w->AdvancedSearch->SearchValue);
            $this->pa_process_size_w->PlaceHolder = RemoveHtml($this->pa_process_size_w->caption());

            // pa_process_size_l
            $this->pa_process_size_l->setupEditAttributes();
            if (!$this->pa_process_size_l->Raw) {
                $this->pa_process_size_l->AdvancedSearch->SearchValue = HtmlDecode($this->pa_process_size_l->AdvancedSearch->SearchValue);
            }
            $this->pa_process_size_l->EditValue = HtmlEncode($this->pa_process_size_l->AdvancedSearch->SearchValue);
            $this->pa_process_size_l->PlaceHolder = RemoveHtml($this->pa_process_size_l->caption());

            // pa_head_01
            $this->pa_head_01->setupEditAttributes();
            if (!$this->pa_head_01->Raw) {
                $this->pa_head_01->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_01->AdvancedSearch->SearchValue);
            }
            $this->pa_head_01->EditValue = HtmlEncode($this->pa_head_01->AdvancedSearch->SearchValue);
            $this->pa_head_01->PlaceHolder = RemoveHtml($this->pa_head_01->caption());

            // pa_process_01
            $this->pa_process_01->PlaceHolder = RemoveHtml($this->pa_process_01->caption());
            $this->pa_process_01->PlaceHolder = RemoveHtml($this->pa_process_01->caption());

            // pa_head_02
            $this->pa_head_02->setupEditAttributes();
            if (!$this->pa_head_02->Raw) {
                $this->pa_head_02->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_02->AdvancedSearch->SearchValue);
            }
            $this->pa_head_02->EditValue = HtmlEncode($this->pa_head_02->AdvancedSearch->SearchValue);
            $this->pa_head_02->PlaceHolder = RemoveHtml($this->pa_head_02->caption());

            // pa_process_02
            $this->pa_process_02->PlaceHolder = RemoveHtml($this->pa_process_02->caption());
            $this->pa_process_02->PlaceHolder = RemoveHtml($this->pa_process_02->caption());

            // pa_head_03
            $this->pa_head_03->setupEditAttributes();
            if (!$this->pa_head_03->Raw) {
                $this->pa_head_03->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_03->AdvancedSearch->SearchValue);
            }
            $this->pa_head_03->EditValue = HtmlEncode($this->pa_head_03->AdvancedSearch->SearchValue);
            $this->pa_head_03->PlaceHolder = RemoveHtml($this->pa_head_03->caption());

            // pa_process_03
            $this->pa_process_03->PlaceHolder = RemoveHtml($this->pa_process_03->caption());
            $this->pa_process_03->PlaceHolder = RemoveHtml($this->pa_process_03->caption());

            // pa_head_04
            $this->pa_head_04->setupEditAttributes();
            if (!$this->pa_head_04->Raw) {
                $this->pa_head_04->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_04->AdvancedSearch->SearchValue);
            }
            $this->pa_head_04->EditValue = HtmlEncode($this->pa_head_04->AdvancedSearch->SearchValue);
            $this->pa_head_04->PlaceHolder = RemoveHtml($this->pa_head_04->caption());

            // pa_process_04
            $this->pa_process_04->PlaceHolder = RemoveHtml($this->pa_process_04->caption());
            $this->pa_process_04->PlaceHolder = RemoveHtml($this->pa_process_04->caption());

            // pa_head_05
            $this->pa_head_05->setupEditAttributes();
            if (!$this->pa_head_05->Raw) {
                $this->pa_head_05->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_05->AdvancedSearch->SearchValue);
            }
            $this->pa_head_05->EditValue = HtmlEncode($this->pa_head_05->AdvancedSearch->SearchValue);
            $this->pa_head_05->PlaceHolder = RemoveHtml($this->pa_head_05->caption());

            // pa_process_05
            $this->pa_process_05->PlaceHolder = RemoveHtml($this->pa_process_05->caption());
            $this->pa_process_05->PlaceHolder = RemoveHtml($this->pa_process_05->caption());

            // pa_head_06
            $this->pa_head_06->setupEditAttributes();
            if (!$this->pa_head_06->Raw) {
                $this->pa_head_06->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_06->AdvancedSearch->SearchValue);
            }
            $this->pa_head_06->EditValue = HtmlEncode($this->pa_head_06->AdvancedSearch->SearchValue);
            $this->pa_head_06->PlaceHolder = RemoveHtml($this->pa_head_06->caption());

            // pa_process_06
            $this->pa_process_06->PlaceHolder = RemoveHtml($this->pa_process_06->caption());
            $this->pa_process_06->PlaceHolder = RemoveHtml($this->pa_process_06->caption());

            // pa_head_07
            $this->pa_head_07->setupEditAttributes();
            if (!$this->pa_head_07->Raw) {
                $this->pa_head_07->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_07->AdvancedSearch->SearchValue);
            }
            $this->pa_head_07->EditValue = HtmlEncode($this->pa_head_07->AdvancedSearch->SearchValue);
            $this->pa_head_07->PlaceHolder = RemoveHtml($this->pa_head_07->caption());

            // pa_process_07
            $this->pa_process_07->PlaceHolder = RemoveHtml($this->pa_process_07->caption());
            $this->pa_process_07->PlaceHolder = RemoveHtml($this->pa_process_07->caption());

            // pa_head_08
            $this->pa_head_08->setupEditAttributes();
            if (!$this->pa_head_08->Raw) {
                $this->pa_head_08->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_08->AdvancedSearch->SearchValue);
            }
            $this->pa_head_08->EditValue = HtmlEncode($this->pa_head_08->AdvancedSearch->SearchValue);
            $this->pa_head_08->PlaceHolder = RemoveHtml($this->pa_head_08->caption());

            // pa_process_08
            $this->pa_process_08->PlaceHolder = RemoveHtml($this->pa_process_08->caption());
            $this->pa_process_08->PlaceHolder = RemoveHtml($this->pa_process_08->caption());

            // pa_head_09
            $this->pa_head_09->setupEditAttributes();
            if (!$this->pa_head_09->Raw) {
                $this->pa_head_09->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_09->AdvancedSearch->SearchValue);
            }
            $this->pa_head_09->EditValue = HtmlEncode($this->pa_head_09->AdvancedSearch->SearchValue);
            $this->pa_head_09->PlaceHolder = RemoveHtml($this->pa_head_09->caption());

            // pa_process_09
            $this->pa_process_09->PlaceHolder = RemoveHtml($this->pa_process_09->caption());
            $this->pa_process_09->PlaceHolder = RemoveHtml($this->pa_process_09->caption());

            // pa_head_10
            $this->pa_head_10->setupEditAttributes();
            if (!$this->pa_head_10->Raw) {
                $this->pa_head_10->AdvancedSearch->SearchValue = HtmlDecode($this->pa_head_10->AdvancedSearch->SearchValue);
            }
            $this->pa_head_10->EditValue = HtmlEncode($this->pa_head_10->AdvancedSearch->SearchValue);
            $this->pa_head_10->PlaceHolder = RemoveHtml($this->pa_head_10->caption());

            // pa_process_10
            $this->pa_process_10->PlaceHolder = RemoveHtml($this->pa_process_10->caption());
            $this->pa_process_10->PlaceHolder = RemoveHtml($this->pa_process_10->caption());

            // publish
            $this->publish->setupEditAttributes();
            $this->publish->EditValue = $this->publish->AdvancedSearch->SearchValue;
            $this->publish->PlaceHolder = RemoveHtml($this->publish->caption());

            // ppr_01
            $this->ppr_01->setupEditAttributes();
            if (!$this->ppr_01->Raw) {
                $this->ppr_01->AdvancedSearch->SearchValue = HtmlDecode($this->ppr_01->AdvancedSearch->SearchValue);
            }
            $this->ppr_01->EditValue = HtmlEncode($this->ppr_01->AdvancedSearch->SearchValue);
            $this->ppr_01->PlaceHolder = RemoveHtml($this->ppr_01->caption());

            // ppr_02
            $this->ppr_02->setupEditAttributes();
            if (!$this->ppr_02->Raw) {
                $this->ppr_02->AdvancedSearch->SearchValue = HtmlDecode($this->ppr_02->AdvancedSearch->SearchValue);
            }
            $this->ppr_02->EditValue = HtmlEncode($this->ppr_02->AdvancedSearch->SearchValue);
            $this->ppr_02->PlaceHolder = RemoveHtml($this->ppr_02->caption());

            // ppr_03
            $this->ppr_03->setupEditAttributes();
            if (!$this->ppr_03->Raw) {
                $this->ppr_03->AdvancedSearch->SearchValue = HtmlDecode($this->ppr_03->AdvancedSearch->SearchValue);
            }
            $this->ppr_03->EditValue = HtmlEncode($this->ppr_03->AdvancedSearch->SearchValue);
            $this->ppr_03->PlaceHolder = RemoveHtml($this->ppr_03->caption());

            // ppr_04
            $this->ppr_04->setupEditAttributes();
            if (!$this->ppr_04->Raw) {
                $this->ppr_04->AdvancedSearch->SearchValue = HtmlDecode($this->ppr_04->AdvancedSearch->SearchValue);
            }
            $this->ppr_04->EditValue = HtmlEncode($this->ppr_04->AdvancedSearch->SearchValue);
            $this->ppr_04->PlaceHolder = RemoveHtml($this->ppr_04->caption());

            // ppr_05
            $this->ppr_05->setupEditAttributes();
            if (!$this->ppr_05->Raw) {
                $this->ppr_05->AdvancedSearch->SearchValue = HtmlDecode($this->ppr_05->AdvancedSearch->SearchValue);
            }
            $this->ppr_05->EditValue = HtmlEncode($this->ppr_05->AdvancedSearch->SearchValue);
            $this->ppr_05->PlaceHolder = RemoveHtml($this->ppr_05->caption());

            // ppr_06
            $this->ppr_06->setupEditAttributes();
            if (!$this->ppr_06->Raw) {
                $this->ppr_06->AdvancedSearch->SearchValue = HtmlDecode($this->ppr_06->AdvancedSearch->SearchValue);
            }
            $this->ppr_06->EditValue = HtmlEncode($this->ppr_06->AdvancedSearch->SearchValue);
            $this->ppr_06->PlaceHolder = RemoveHtml($this->ppr_06->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->product_group->AdvancedSearch->load();
        $this->calculation_method->AdvancedSearch->load();
        $this->shape->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->process->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->v_00->AdvancedSearch->load();
        $this->v_01->AdvancedSearch->load();
        $this->v_01_validation->AdvancedSearch->load();
        $this->v_02->AdvancedSearch->load();
        $this->v_02_validation->AdvancedSearch->load();
        $this->v_03->AdvancedSearch->load();
        $this->v_03_validation->AdvancedSearch->load();
        $this->v_04->AdvancedSearch->load();
        $this->v_04_validation->AdvancedSearch->load();
        $this->v_05->AdvancedSearch->load();
        $this->v_05_validation->AdvancedSearch->load();
        $this->v_06->AdvancedSearch->load();
        $this->v_06_validation->AdvancedSearch->load();
        $this->v_07->AdvancedSearch->load();
        $this->v_07_validation->AdvancedSearch->load();
        $this->v_08->AdvancedSearch->load();
        $this->v_08_validation->AdvancedSearch->load();
        $this->v_09->AdvancedSearch->load();
        $this->v_09_validation->AdvancedSearch->load();
        $this->v_10->AdvancedSearch->load();
        $this->v_10_validation->AdvancedSearch->load();
        $this->b_01_head->AdvancedSearch->load();
        $this->b_02_head->AdvancedSearch->load();
        $this->b_03_head->AdvancedSearch->load();
        $this->b_04_head->AdvancedSearch->load();
        $this->b_05_head->AdvancedSearch->load();
        $this->b_06_head->AdvancedSearch->load();
        $this->b_07_head->AdvancedSearch->load();
        $this->b_08_head->AdvancedSearch->load();
        $this->b_09_head->AdvancedSearch->load();
        $this->b_10_head->AdvancedSearch->load();
        $this->b_11_head->AdvancedSearch->load();
        $this->b_12_head->AdvancedSearch->load();
        $this->b_13_head->AdvancedSearch->load();
        $this->b_14_head->AdvancedSearch->load();
        $this->b_15_head->AdvancedSearch->load();
        $this->q_sku->AdvancedSearch->load();
        $this->t_01_head->AdvancedSearch->load();
        $this->t_02_head->AdvancedSearch->load();
        $this->t_03_head->AdvancedSearch->load();
        $this->t_04_head->AdvancedSearch->load();
        $this->t_05_head->AdvancedSearch->load();
        $this->t_06_head->AdvancedSearch->load();
        $this->t_07_head->AdvancedSearch->load();
        $this->t_08_head->AdvancedSearch->load();
        $this->t_09_head->AdvancedSearch->load();
        $this->t_10_head->AdvancedSearch->load();
        $this->t_11_head->AdvancedSearch->load();
        $this->t_12_head->AdvancedSearch->load();
        $this->t_13_head->AdvancedSearch->load();
        $this->t_14_head->AdvancedSearch->load();
        $this->t_15_head->AdvancedSearch->load();
        $this->po_01_head->AdvancedSearch->load();
        $this->po_02_head->AdvancedSearch->load();
        $this->po_03_head->AdvancedSearch->load();
        $this->po_04_head->AdvancedSearch->load();
        $this->po_05_head->AdvancedSearch->load();
        $this->po_06_head->AdvancedSearch->load();
        $this->po_07_head->AdvancedSearch->load();
        $this->po_08_head->AdvancedSearch->load();
        $this->po_17_head->AdvancedSearch->load();
        $this->po_18_head->AdvancedSearch->load();
        $this->po_19_head->AdvancedSearch->load();
        $this->po_20_head->AdvancedSearch->load();
        $this->jc_01_head->AdvancedSearch->load();
        $this->jc_02_head->AdvancedSearch->load();
        $this->jc_03_head->AdvancedSearch->load();
        $this->jc_04_head->AdvancedSearch->load();
        $this->jc_05_head->AdvancedSearch->load();
        $this->jc_06_head->AdvancedSearch->load();
        $this->jc_07_head->AdvancedSearch->load();
        $this->jc_08_head->AdvancedSearch->load();
        $this->jc_09_head->AdvancedSearch->load();
        $this->jc_10_head->AdvancedSearch->load();
        $this->pc_shape->AdvancedSearch->load();
        $this->pc_unit->AdvancedSearch->load();
        $this->pc_w->AdvancedSearch->load();
        $this->pc_l->AdvancedSearch->load();
        $this->pc_h->AdvancedSearch->load();
        $this->pc_partner_size->AdvancedSearch->load();
        $this->pc_sqm->AdvancedSearch->load();
        $this->pc_01_head->AdvancedSearch->load();
        $this->pc_02_head->AdvancedSearch->load();
        $this->pc_03_head->AdvancedSearch->load();
        $this->pc_04_head->AdvancedSearch->load();
        $this->pc_05_head->AdvancedSearch->load();
        $this->pc_06_head->AdvancedSearch->load();
        $this->pc_07_head->AdvancedSearch->load();
        $this->pc_08_head->AdvancedSearch->load();
        $this->pc_09_head->AdvancedSearch->load();
        $this->pc_10_head->AdvancedSearch->load();
        $this->pc_11_head->AdvancedSearch->load();
        $this->pc_12_head->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->image->AdvancedSearch->load();
        $this->pa_process_size_w->AdvancedSearch->load();
        $this->pa_process_size_l->AdvancedSearch->load();
        $this->pa_head_01->AdvancedSearch->load();
        $this->pa_process_01->AdvancedSearch->load();
        $this->pa_head_02->AdvancedSearch->load();
        $this->pa_process_02->AdvancedSearch->load();
        $this->pa_head_03->AdvancedSearch->load();
        $this->pa_process_03->AdvancedSearch->load();
        $this->pa_head_04->AdvancedSearch->load();
        $this->pa_process_04->AdvancedSearch->load();
        $this->pa_head_05->AdvancedSearch->load();
        $this->pa_process_05->AdvancedSearch->load();
        $this->pa_head_06->AdvancedSearch->load();
        $this->pa_process_06->AdvancedSearch->load();
        $this->pa_head_07->AdvancedSearch->load();
        $this->pa_process_07->AdvancedSearch->load();
        $this->pa_head_08->AdvancedSearch->load();
        $this->pa_process_08->AdvancedSearch->load();
        $this->pa_head_09->AdvancedSearch->load();
        $this->pa_process_09->AdvancedSearch->load();
        $this->pa_head_10->AdvancedSearch->load();
        $this->pa_process_10->AdvancedSearch->load();
        $this->publish->AdvancedSearch->load();
        $this->ppr_01->AdvancedSearch->load();
        $this->ppr_02->AdvancedSearch->load();
        $this->ppr_03->AdvancedSearch->load();
        $this->ppr_04->AdvancedSearch->load();
        $this->ppr_05->AdvancedSearch->load();
        $this->ppr_06->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fproduct_grouplist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fproduct_grouplist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fproduct_grouplist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fproduct_grouplist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = false;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fproduct_groupsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"product_group\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"productgroupsearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"productgroupsearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"fproduct_groupsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_calculation_method":
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_v_01_validation":
                    break;
                case "x_pa_process_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type) {
    	if ($type == 'success') {
    		//$msg = "your success message";
    	} elseif ($type == 'failure') {
    		//$msg = "your failure message";
    	} elseif ($type == 'warning') {
    		//$msg = "your warning message";
    	} else {
    	if (CurrentUserID() == '-1')
    	$msg = "<a href=\"autoprogramme?ac=93e87919d9c89e6459f4fbd0b03b5bc0&apcid=d5cb15b7eceeb8965bb6937b1f34cfc1\" class=\"btn btn-danger ew-action\" style=\"color:blue\">Import from INT_Fibre (Missing)</a>";
    	}
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	if (CurrentUserID() !=  -1)
    	{
    		$this->OtherOptions["addedit"]->Items["add"]->Visible = False;
    	}
    	if (CurrentUserID() == '-1')
    	{
    		$item = &$this->OtherOptions['action']->Add("Import from INT_Fibre (Missing)");
    		$item->Body = "<a href=\"autoprogramme?ac=93e87919d9c89e6459f4fbd0b03b5bc0&apcid=d5cb15b7eceeb8965bb6937b1f34cfc1\" class=\"btn btn-danger ew-action\" style=\"color:blue\">Import from INT_Fibre (Missing)</a>";
    	$item->Visible = True;
    	}
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered() {
    	// Example:
    	//$this->ListOptions->Items["new"]->Body = "xxx";
    	$IDS = ExecuteRow("SELECT ifnull(GROUP_CONCAT(`product_group`.`id`),0) as `ids` FROM `product_group` left join `int_fibre_product_group` on `int_fibre_product_group`.id = `product_group`.`id` where `int_fibre_product_group`.`product_group` != `product_group`.`product_group` || `int_fibre_product_group`.`id` is null");
    $ID = $IDS['ids'];
    $mismatch =  explode(",", $ID);
    	if ((CurrentUserID() == '-1') && (in_array($this->id->CurrentValue, $mismatch)))
    	{
    		$this->ListOptions->Add("Update to INT_Fibre (Export)"); // Replace abclink with your name of the link
    		$this->ListOptions->Items["Update to INT_Fibre (Export)"]->Body ='<a href="autoprogramme?ac=6bd9e83aef373774188a51f80463f37b&apcid=d5cb15b7eceeb8965bb6937b1f34cfc1&id=' . $this->id->CurrentValue . '" data-bs-original-title ="Update to INT_Fibre (Export)"><i data-phrase="Update to INT_Fibre (Export)"  class="fa fa-recycle fa-2x ew-icon" style="color:red"></i></a>';
    		$NIDS = ExecuteRow("SELECT ifnull(GROUP_CONCAT(`product_group`.`id`),0) as `ids` FROM `product_group` left join `int_fibre_product_group` on `int_fibre_product_group`.id = `product_group`.`id` where `int_fibre_product_group`.`id` is null");
    		$NID = $NIDS['ids'];
    		$Nmismatch =  explode(",", $NID);
    		if (((CurrentUserID() == '-1') && (in_array($this->id->CurrentValue, $Nmismatch))) === false)
    		{
    			$this->ListOptions->Add("Update from INT_Fibre (Import)"); // Replace abclink with your name of the link
    			$this->ListOptions->Items["Update from INT_Fibre (Import)"]->Body ='<a href="autoprogramme?ac=fa6c0ebbc86ee0d9d7ed3e7b4fdbf486&apcid=d5cb15b7eceeb8965bb6937b1f34cfc1&id=' . $this->id->CurrentValue . '" data-bs-original-title ="Update from INT_Fibre (Import)"><i data-phrase="Update from INT_Fibre (Import)"  class="fa fa-sign-in fa-2x ew-icon" style="color:blue"></i></a>';
    		}
    	}
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
