<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductGroupEdit extends ProductGroup
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductGroupEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "productgroupedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->grp->setVisibility();
        $this->product_group->setVisibility();
        $this->calculation_method->setVisibility();
        $this->shape->setVisibility();
        $this->sqm->setVisibility();
        $this->cbm->setVisibility();
        $this->process->setVisibility();
        $this->status->setVisibility();
        $this->v_00->setVisibility();
        $this->v_01->setVisibility();
        $this->v_01_validation->setVisibility();
        $this->v_02->setVisibility();
        $this->v_02_validation->setVisibility();
        $this->v_03->setVisibility();
        $this->v_03_validation->setVisibility();
        $this->v_04->setVisibility();
        $this->v_04_validation->setVisibility();
        $this->v_05->setVisibility();
        $this->v_05_validation->setVisibility();
        $this->v_06->setVisibility();
        $this->v_06_validation->setVisibility();
        $this->v_07->setVisibility();
        $this->v_07_validation->setVisibility();
        $this->v_08->setVisibility();
        $this->v_08_validation->setVisibility();
        $this->v_09->setVisibility();
        $this->v_09_validation->setVisibility();
        $this->v_10->setVisibility();
        $this->v_10_validation->setVisibility();
        $this->b_01_head->setVisibility();
        $this->b_02_head->setVisibility();
        $this->b_03_head->setVisibility();
        $this->b_04_head->setVisibility();
        $this->b_05_head->setVisibility();
        $this->b_06_head->setVisibility();
        $this->b_07_head->setVisibility();
        $this->b_08_head->setVisibility();
        $this->b_09_head->setVisibility();
        $this->b_10_head->setVisibility();
        $this->b_11_head->setVisibility();
        $this->b_12_head->setVisibility();
        $this->b_13_head->setVisibility();
        $this->b_14_head->setVisibility();
        $this->b_15_head->setVisibility();
        $this->q_sku->setVisibility();
        $this->t_01_head->setVisibility();
        $this->t_02_head->setVisibility();
        $this->t_03_head->setVisibility();
        $this->t_04_head->setVisibility();
        $this->t_05_head->setVisibility();
        $this->t_06_head->setVisibility();
        $this->t_07_head->setVisibility();
        $this->t_08_head->setVisibility();
        $this->t_09_head->setVisibility();
        $this->t_10_head->setVisibility();
        $this->t_11_head->setVisibility();
        $this->t_12_head->setVisibility();
        $this->t_13_head->setVisibility();
        $this->t_14_head->setVisibility();
        $this->t_15_head->setVisibility();
        $this->po_01_head->setVisibility();
        $this->po_02_head->setVisibility();
        $this->po_03_head->setVisibility();
        $this->po_04_head->setVisibility();
        $this->po_05_head->setVisibility();
        $this->po_06_head->setVisibility();
        $this->po_07_head->setVisibility();
        $this->po_08_head->setVisibility();
        $this->po_17_head->setVisibility();
        $this->po_18_head->setVisibility();
        $this->po_19_head->setVisibility();
        $this->po_20_head->setVisibility();
        $this->jc_01_head->setVisibility();
        $this->jc_02_head->setVisibility();
        $this->jc_03_head->setVisibility();
        $this->jc_04_head->setVisibility();
        $this->jc_05_head->setVisibility();
        $this->jc_06_head->setVisibility();
        $this->jc_07_head->setVisibility();
        $this->jc_08_head->setVisibility();
        $this->jc_09_head->setVisibility();
        $this->jc_10_head->setVisibility();
        $this->pc_shape->setVisibility();
        $this->pc_unit->setVisibility();
        $this->pc_w->setVisibility();
        $this->pc_l->setVisibility();
        $this->pc_h->setVisibility();
        $this->pc_partner_size->setVisibility();
        $this->pc_sqm->setVisibility();
        $this->pc_01_head->setVisibility();
        $this->pc_02_head->setVisibility();
        $this->pc_03_head->setVisibility();
        $this->pc_04_head->setVisibility();
        $this->pc_05_head->setVisibility();
        $this->pc_06_head->setVisibility();
        $this->pc_07_head->setVisibility();
        $this->pc_08_head->setVisibility();
        $this->pc_09_head->setVisibility();
        $this->pc_10_head->setVisibility();
        $this->pc_11_head->setVisibility();
        $this->pc_12_head->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->image->setVisibility();
        $this->pa_process_size_w->setVisibility();
        $this->pa_process_size_l->setVisibility();
        $this->pa_head_01->setVisibility();
        $this->pa_process_01->setVisibility();
        $this->pa_head_02->setVisibility();
        $this->pa_process_02->setVisibility();
        $this->pa_head_03->setVisibility();
        $this->pa_process_03->setVisibility();
        $this->pa_head_04->setVisibility();
        $this->pa_process_04->setVisibility();
        $this->pa_head_05->setVisibility();
        $this->pa_process_05->setVisibility();
        $this->pa_head_06->setVisibility();
        $this->pa_process_06->setVisibility();
        $this->pa_head_07->setVisibility();
        $this->pa_process_07->setVisibility();
        $this->pa_head_08->setVisibility();
        $this->pa_process_08->setVisibility();
        $this->pa_head_09->setVisibility();
        $this->pa_process_09->setVisibility();
        $this->pa_head_10->setVisibility();
        $this->pa_process_10->setVisibility();
        $this->publish->setVisibility();
        $this->ppr_01->setVisibility();
        $this->ppr_02->setVisibility();
        $this->ppr_03->setVisibility();
        $this->ppr_04->setVisibility();
        $this->ppr_05->setVisibility();
        $this->ppr_06->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'product_group';
        $this->TableName = 'product_group';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (product_group)
        if (!isset($GLOBALS["product_group"]) || $GLOBALS["product_group"]::class == PROJECT_NAMESPACE . "product_group") {
            $GLOBALS["product_group"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_group');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "productgroupview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->calculation_method);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->v_01_validation);
        $this->setupLookupOptions($this->pa_process_01);
        $this->setupLookupOptions($this->pa_process_02);
        $this->setupLookupOptions($this->pa_process_03);
        $this->setupLookupOptions($this->pa_process_04);
        $this->setupLookupOptions($this->pa_process_05);
        $this->setupLookupOptions($this->pa_process_06);
        $this->setupLookupOptions($this->pa_process_07);
        $this->setupLookupOptions($this->pa_process_08);
        $this->setupLookupOptions($this->pa_process_09);
        $this->setupLookupOptions($this->pa_process_10);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("productgrouplist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "productgrouplist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "productgrouplist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "productgrouplist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->image->Upload->Index = $CurrentForm->Index;
        $this->image->Upload->uploadFile();
        $this->image->CurrentValue = $this->image->Upload->FileName;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 'product_group' first before field var 'x_product_group'
        $val = $CurrentForm->hasValue("product_group") ? $CurrentForm->getValue("product_group") : $CurrentForm->getValue("x_product_group");
        if (!$this->product_group->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_group->Visible = false; // Disable update for API request
            } else {
                $this->product_group->setFormValue($val);
            }
        }

        // Check field name 'calculation_method' first before field var 'x_calculation_method'
        $val = $CurrentForm->hasValue("calculation_method") ? $CurrentForm->getValue("calculation_method") : $CurrentForm->getValue("x_calculation_method");
        if (!$this->calculation_method->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->calculation_method->Visible = false; // Disable update for API request
            } else {
                $this->calculation_method->setFormValue($val);
            }
        }

        // Check field name 'shape' first before field var 'x_shape'
        $val = $CurrentForm->hasValue("shape") ? $CurrentForm->getValue("shape") : $CurrentForm->getValue("x_shape");
        if (!$this->shape->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shape->Visible = false; // Disable update for API request
            } else {
                $this->shape->setFormValue($val);
            }
        }

        // Check field name 'sqm' first before field var 'x_sqm'
        $val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
        if (!$this->sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sqm->Visible = false; // Disable update for API request
            } else {
                $this->sqm->setFormValue($val);
            }
        }

        // Check field name 'cbm' first before field var 'x_cbm'
        $val = $CurrentForm->hasValue("cbm") ? $CurrentForm->getValue("cbm") : $CurrentForm->getValue("x_cbm");
        if (!$this->cbm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cbm->Visible = false; // Disable update for API request
            } else {
                $this->cbm->setFormValue($val);
            }
        }

        // Check field name 'process' first before field var 'x_process'
        $val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
        if (!$this->process->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->process->Visible = false; // Disable update for API request
            } else {
                $this->process->setFormValue($val);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'v_00' first before field var 'x_v_00'
        $val = $CurrentForm->hasValue("v_00") ? $CurrentForm->getValue("v_00") : $CurrentForm->getValue("x_v_00");
        if (!$this->v_00->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_00->Visible = false; // Disable update for API request
            } else {
                $this->v_00->setFormValue($val);
            }
        }

        // Check field name 'v_01' first before field var 'x_v_01'
        $val = $CurrentForm->hasValue("v_01") ? $CurrentForm->getValue("v_01") : $CurrentForm->getValue("x_v_01");
        if (!$this->v_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_01->Visible = false; // Disable update for API request
            } else {
                $this->v_01->setFormValue($val);
            }
        }

        // Check field name 'v_01_validation' first before field var 'x_v_01_validation'
        $val = $CurrentForm->hasValue("v_01_validation") ? $CurrentForm->getValue("v_01_validation") : $CurrentForm->getValue("x_v_01_validation");
        if (!$this->v_01_validation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_01_validation->Visible = false; // Disable update for API request
            } else {
                $this->v_01_validation->setFormValue($val);
            }
        }

        // Check field name 'v_02' first before field var 'x_v_02'
        $val = $CurrentForm->hasValue("v_02") ? $CurrentForm->getValue("v_02") : $CurrentForm->getValue("x_v_02");
        if (!$this->v_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_02->Visible = false; // Disable update for API request
            } else {
                $this->v_02->setFormValue($val);
            }
        }

        // Check field name 'v_02_validation' first before field var 'x_v_02_validation'
        $val = $CurrentForm->hasValue("v_02_validation") ? $CurrentForm->getValue("v_02_validation") : $CurrentForm->getValue("x_v_02_validation");
        if (!$this->v_02_validation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_02_validation->Visible = false; // Disable update for API request
            } else {
                $this->v_02_validation->setFormValue($val);
            }
        }

        // Check field name 'v_03' first before field var 'x_v_03'
        $val = $CurrentForm->hasValue("v_03") ? $CurrentForm->getValue("v_03") : $CurrentForm->getValue("x_v_03");
        if (!$this->v_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_03->Visible = false; // Disable update for API request
            } else {
                $this->v_03->setFormValue($val);
            }
        }

        // Check field name 'v_03_validation' first before field var 'x_v_03_validation'
        $val = $CurrentForm->hasValue("v_03_validation") ? $CurrentForm->getValue("v_03_validation") : $CurrentForm->getValue("x_v_03_validation");
        if (!$this->v_03_validation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_03_validation->Visible = false; // Disable update for API request
            } else {
                $this->v_03_validation->setFormValue($val);
            }
        }

        // Check field name 'v_04' first before field var 'x_v_04'
        $val = $CurrentForm->hasValue("v_04") ? $CurrentForm->getValue("v_04") : $CurrentForm->getValue("x_v_04");
        if (!$this->v_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_04->Visible = false; // Disable update for API request
            } else {
                $this->v_04->setFormValue($val);
            }
        }

        // Check field name 'v_04_validation' first before field var 'x_v_04_validation'
        $val = $CurrentForm->hasValue("v_04_validation") ? $CurrentForm->getValue("v_04_validation") : $CurrentForm->getValue("x_v_04_validation");
        if (!$this->v_04_validation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_04_validation->Visible = false; // Disable update for API request
            } else {
                $this->v_04_validation->setFormValue($val);
            }
        }

        // Check field name 'v_05' first before field var 'x_v_05'
        $val = $CurrentForm->hasValue("v_05") ? $CurrentForm->getValue("v_05") : $CurrentForm->getValue("x_v_05");
        if (!$this->v_05->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_05->Visible = false; // Disable update for API request
            } else {
                $this->v_05->setFormValue($val);
            }
        }

        // Check field name 'v_05_validation' first before field var 'x_v_05_validation'
        $val = $CurrentForm->hasValue("v_05_validation") ? $CurrentForm->getValue("v_05_validation") : $CurrentForm->getValue("x_v_05_validation");
        if (!$this->v_05_validation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_05_validation->Visible = false; // Disable update for API request
            } else {
                $this->v_05_validation->setFormValue($val);
            }
        }

        // Check field name 'v_06' first before field var 'x_v_06'
        $val = $CurrentForm->hasValue("v_06") ? $CurrentForm->getValue("v_06") : $CurrentForm->getValue("x_v_06");
        if (!$this->v_06->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_06->Visible = false; // Disable update for API request
            } else {
                $this->v_06->setFormValue($val);
            }
        }

        // Check field name 'v_06_validation' first before field var 'x_v_06_validation'
        $val = $CurrentForm->hasValue("v_06_validation") ? $CurrentForm->getValue("v_06_validation") : $CurrentForm->getValue("x_v_06_validation");
        if (!$this->v_06_validation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_06_validation->Visible = false; // Disable update for API request
            } else {
                $this->v_06_validation->setFormValue($val);
            }
        }

        // Check field name 'v_07' first before field var 'x_v_07'
        $val = $CurrentForm->hasValue("v_07") ? $CurrentForm->getValue("v_07") : $CurrentForm->getValue("x_v_07");
        if (!$this->v_07->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_07->Visible = false; // Disable update for API request
            } else {
                $this->v_07->setFormValue($val);
            }
        }

        // Check field name 'v_07_validation' first before field var 'x_v_07_validation'
        $val = $CurrentForm->hasValue("v_07_validation") ? $CurrentForm->getValue("v_07_validation") : $CurrentForm->getValue("x_v_07_validation");
        if (!$this->v_07_validation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_07_validation->Visible = false; // Disable update for API request
            } else {
                $this->v_07_validation->setFormValue($val);
            }
        }

        // Check field name 'v_08' first before field var 'x_v_08'
        $val = $CurrentForm->hasValue("v_08") ? $CurrentForm->getValue("v_08") : $CurrentForm->getValue("x_v_08");
        if (!$this->v_08->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_08->Visible = false; // Disable update for API request
            } else {
                $this->v_08->setFormValue($val);
            }
        }

        // Check field name 'v_08_validation' first before field var 'x_v_08_validation'
        $val = $CurrentForm->hasValue("v_08_validation") ? $CurrentForm->getValue("v_08_validation") : $CurrentForm->getValue("x_v_08_validation");
        if (!$this->v_08_validation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_08_validation->Visible = false; // Disable update for API request
            } else {
                $this->v_08_validation->setFormValue($val);
            }
        }

        // Check field name 'v_09' first before field var 'x_v_09'
        $val = $CurrentForm->hasValue("v_09") ? $CurrentForm->getValue("v_09") : $CurrentForm->getValue("x_v_09");
        if (!$this->v_09->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_09->Visible = false; // Disable update for API request
            } else {
                $this->v_09->setFormValue($val);
            }
        }

        // Check field name 'v_09_validation' first before field var 'x_v_09_validation'
        $val = $CurrentForm->hasValue("v_09_validation") ? $CurrentForm->getValue("v_09_validation") : $CurrentForm->getValue("x_v_09_validation");
        if (!$this->v_09_validation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_09_validation->Visible = false; // Disable update for API request
            } else {
                $this->v_09_validation->setFormValue($val);
            }
        }

        // Check field name 'v_10' first before field var 'x_v_10'
        $val = $CurrentForm->hasValue("v_10") ? $CurrentForm->getValue("v_10") : $CurrentForm->getValue("x_v_10");
        if (!$this->v_10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_10->Visible = false; // Disable update for API request
            } else {
                $this->v_10->setFormValue($val);
            }
        }

        // Check field name 'v_10_validation' first before field var 'x_v_10_validation'
        $val = $CurrentForm->hasValue("v_10_validation") ? $CurrentForm->getValue("v_10_validation") : $CurrentForm->getValue("x_v_10_validation");
        if (!$this->v_10_validation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_10_validation->Visible = false; // Disable update for API request
            } else {
                $this->v_10_validation->setFormValue($val);
            }
        }

        // Check field name 'b_01_head' first before field var 'x_b_01_head'
        $val = $CurrentForm->hasValue("b_01_head") ? $CurrentForm->getValue("b_01_head") : $CurrentForm->getValue("x_b_01_head");
        if (!$this->b_01_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_01_head->Visible = false; // Disable update for API request
            } else {
                $this->b_01_head->setFormValue($val);
            }
        }

        // Check field name 'b_02_head' first before field var 'x_b_02_head'
        $val = $CurrentForm->hasValue("b_02_head") ? $CurrentForm->getValue("b_02_head") : $CurrentForm->getValue("x_b_02_head");
        if (!$this->b_02_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_02_head->Visible = false; // Disable update for API request
            } else {
                $this->b_02_head->setFormValue($val);
            }
        }

        // Check field name 'b_03_head' first before field var 'x_b_03_head'
        $val = $CurrentForm->hasValue("b_03_head") ? $CurrentForm->getValue("b_03_head") : $CurrentForm->getValue("x_b_03_head");
        if (!$this->b_03_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_03_head->Visible = false; // Disable update for API request
            } else {
                $this->b_03_head->setFormValue($val);
            }
        }

        // Check field name 'b_04_head' first before field var 'x_b_04_head'
        $val = $CurrentForm->hasValue("b_04_head") ? $CurrentForm->getValue("b_04_head") : $CurrentForm->getValue("x_b_04_head");
        if (!$this->b_04_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_04_head->Visible = false; // Disable update for API request
            } else {
                $this->b_04_head->setFormValue($val);
            }
        }

        // Check field name 'b_05_head' first before field var 'x_b_05_head'
        $val = $CurrentForm->hasValue("b_05_head") ? $CurrentForm->getValue("b_05_head") : $CurrentForm->getValue("x_b_05_head");
        if (!$this->b_05_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_05_head->Visible = false; // Disable update for API request
            } else {
                $this->b_05_head->setFormValue($val);
            }
        }

        // Check field name 'b_06_head' first before field var 'x_b_06_head'
        $val = $CurrentForm->hasValue("b_06_head") ? $CurrentForm->getValue("b_06_head") : $CurrentForm->getValue("x_b_06_head");
        if (!$this->b_06_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_06_head->Visible = false; // Disable update for API request
            } else {
                $this->b_06_head->setFormValue($val);
            }
        }

        // Check field name 'b_07_head' first before field var 'x_b_07_head'
        $val = $CurrentForm->hasValue("b_07_head") ? $CurrentForm->getValue("b_07_head") : $CurrentForm->getValue("x_b_07_head");
        if (!$this->b_07_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_07_head->Visible = false; // Disable update for API request
            } else {
                $this->b_07_head->setFormValue($val);
            }
        }

        // Check field name 'b_08_head' first before field var 'x_b_08_head'
        $val = $CurrentForm->hasValue("b_08_head") ? $CurrentForm->getValue("b_08_head") : $CurrentForm->getValue("x_b_08_head");
        if (!$this->b_08_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_08_head->Visible = false; // Disable update for API request
            } else {
                $this->b_08_head->setFormValue($val);
            }
        }

        // Check field name 'b_09_head' first before field var 'x_b_09_head'
        $val = $CurrentForm->hasValue("b_09_head") ? $CurrentForm->getValue("b_09_head") : $CurrentForm->getValue("x_b_09_head");
        if (!$this->b_09_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_09_head->Visible = false; // Disable update for API request
            } else {
                $this->b_09_head->setFormValue($val);
            }
        }

        // Check field name 'b_10_head' first before field var 'x_b_10_head'
        $val = $CurrentForm->hasValue("b_10_head") ? $CurrentForm->getValue("b_10_head") : $CurrentForm->getValue("x_b_10_head");
        if (!$this->b_10_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_10_head->Visible = false; // Disable update for API request
            } else {
                $this->b_10_head->setFormValue($val);
            }
        }

        // Check field name 'b_11_head' first before field var 'x_b_11_head'
        $val = $CurrentForm->hasValue("b_11_head") ? $CurrentForm->getValue("b_11_head") : $CurrentForm->getValue("x_b_11_head");
        if (!$this->b_11_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_11_head->Visible = false; // Disable update for API request
            } else {
                $this->b_11_head->setFormValue($val);
            }
        }

        // Check field name 'b_12_head' first before field var 'x_b_12_head'
        $val = $CurrentForm->hasValue("b_12_head") ? $CurrentForm->getValue("b_12_head") : $CurrentForm->getValue("x_b_12_head");
        if (!$this->b_12_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_12_head->Visible = false; // Disable update for API request
            } else {
                $this->b_12_head->setFormValue($val);
            }
        }

        // Check field name 'b_13_head' first before field var 'x_b_13_head'
        $val = $CurrentForm->hasValue("b_13_head") ? $CurrentForm->getValue("b_13_head") : $CurrentForm->getValue("x_b_13_head");
        if (!$this->b_13_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_13_head->Visible = false; // Disable update for API request
            } else {
                $this->b_13_head->setFormValue($val);
            }
        }

        // Check field name 'b_14_head' first before field var 'x_b_14_head'
        $val = $CurrentForm->hasValue("b_14_head") ? $CurrentForm->getValue("b_14_head") : $CurrentForm->getValue("x_b_14_head");
        if (!$this->b_14_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_14_head->Visible = false; // Disable update for API request
            } else {
                $this->b_14_head->setFormValue($val);
            }
        }

        // Check field name 'b_15_head' first before field var 'x_b_15_head'
        $val = $CurrentForm->hasValue("b_15_head") ? $CurrentForm->getValue("b_15_head") : $CurrentForm->getValue("x_b_15_head");
        if (!$this->b_15_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_15_head->Visible = false; // Disable update for API request
            } else {
                $this->b_15_head->setFormValue($val);
            }
        }

        // Check field name 'q_sku' first before field var 'x_q_sku'
        $val = $CurrentForm->hasValue("q_sku") ? $CurrentForm->getValue("q_sku") : $CurrentForm->getValue("x_q_sku");
        if (!$this->q_sku->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->q_sku->Visible = false; // Disable update for API request
            } else {
                $this->q_sku->setFormValue($val);
            }
        }

        // Check field name 't_01_head' first before field var 'x_t_01_head'
        $val = $CurrentForm->hasValue("t_01_head") ? $CurrentForm->getValue("t_01_head") : $CurrentForm->getValue("x_t_01_head");
        if (!$this->t_01_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_01_head->Visible = false; // Disable update for API request
            } else {
                $this->t_01_head->setFormValue($val);
            }
        }

        // Check field name 't_02_head' first before field var 'x_t_02_head'
        $val = $CurrentForm->hasValue("t_02_head") ? $CurrentForm->getValue("t_02_head") : $CurrentForm->getValue("x_t_02_head");
        if (!$this->t_02_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_02_head->Visible = false; // Disable update for API request
            } else {
                $this->t_02_head->setFormValue($val);
            }
        }

        // Check field name 't_03_head' first before field var 'x_t_03_head'
        $val = $CurrentForm->hasValue("t_03_head") ? $CurrentForm->getValue("t_03_head") : $CurrentForm->getValue("x_t_03_head");
        if (!$this->t_03_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_03_head->Visible = false; // Disable update for API request
            } else {
                $this->t_03_head->setFormValue($val);
            }
        }

        // Check field name 't_04_head' first before field var 'x_t_04_head'
        $val = $CurrentForm->hasValue("t_04_head") ? $CurrentForm->getValue("t_04_head") : $CurrentForm->getValue("x_t_04_head");
        if (!$this->t_04_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_04_head->Visible = false; // Disable update for API request
            } else {
                $this->t_04_head->setFormValue($val);
            }
        }

        // Check field name 't_05_head' first before field var 'x_t_05_head'
        $val = $CurrentForm->hasValue("t_05_head") ? $CurrentForm->getValue("t_05_head") : $CurrentForm->getValue("x_t_05_head");
        if (!$this->t_05_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_05_head->Visible = false; // Disable update for API request
            } else {
                $this->t_05_head->setFormValue($val);
            }
        }

        // Check field name 't_06_head' first before field var 'x_t_06_head'
        $val = $CurrentForm->hasValue("t_06_head") ? $CurrentForm->getValue("t_06_head") : $CurrentForm->getValue("x_t_06_head");
        if (!$this->t_06_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_06_head->Visible = false; // Disable update for API request
            } else {
                $this->t_06_head->setFormValue($val);
            }
        }

        // Check field name 't_07_head' first before field var 'x_t_07_head'
        $val = $CurrentForm->hasValue("t_07_head") ? $CurrentForm->getValue("t_07_head") : $CurrentForm->getValue("x_t_07_head");
        if (!$this->t_07_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_07_head->Visible = false; // Disable update for API request
            } else {
                $this->t_07_head->setFormValue($val);
            }
        }

        // Check field name 't_08_head' first before field var 'x_t_08_head'
        $val = $CurrentForm->hasValue("t_08_head") ? $CurrentForm->getValue("t_08_head") : $CurrentForm->getValue("x_t_08_head");
        if (!$this->t_08_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_08_head->Visible = false; // Disable update for API request
            } else {
                $this->t_08_head->setFormValue($val);
            }
        }

        // Check field name 't_09_head' first before field var 'x_t_09_head'
        $val = $CurrentForm->hasValue("t_09_head") ? $CurrentForm->getValue("t_09_head") : $CurrentForm->getValue("x_t_09_head");
        if (!$this->t_09_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_09_head->Visible = false; // Disable update for API request
            } else {
                $this->t_09_head->setFormValue($val);
            }
        }

        // Check field name 't_10_head' first before field var 'x_t_10_head'
        $val = $CurrentForm->hasValue("t_10_head") ? $CurrentForm->getValue("t_10_head") : $CurrentForm->getValue("x_t_10_head");
        if (!$this->t_10_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_10_head->Visible = false; // Disable update for API request
            } else {
                $this->t_10_head->setFormValue($val);
            }
        }

        // Check field name 't_11_head' first before field var 'x_t_11_head'
        $val = $CurrentForm->hasValue("t_11_head") ? $CurrentForm->getValue("t_11_head") : $CurrentForm->getValue("x_t_11_head");
        if (!$this->t_11_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_11_head->Visible = false; // Disable update for API request
            } else {
                $this->t_11_head->setFormValue($val);
            }
        }

        // Check field name 't_12_head' first before field var 'x_t_12_head'
        $val = $CurrentForm->hasValue("t_12_head") ? $CurrentForm->getValue("t_12_head") : $CurrentForm->getValue("x_t_12_head");
        if (!$this->t_12_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_12_head->Visible = false; // Disable update for API request
            } else {
                $this->t_12_head->setFormValue($val);
            }
        }

        // Check field name 't_13_head' first before field var 'x_t_13_head'
        $val = $CurrentForm->hasValue("t_13_head") ? $CurrentForm->getValue("t_13_head") : $CurrentForm->getValue("x_t_13_head");
        if (!$this->t_13_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_13_head->Visible = false; // Disable update for API request
            } else {
                $this->t_13_head->setFormValue($val);
            }
        }

        // Check field name 't_14_head' first before field var 'x_t_14_head'
        $val = $CurrentForm->hasValue("t_14_head") ? $CurrentForm->getValue("t_14_head") : $CurrentForm->getValue("x_t_14_head");
        if (!$this->t_14_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_14_head->Visible = false; // Disable update for API request
            } else {
                $this->t_14_head->setFormValue($val);
            }
        }

        // Check field name 't_15_head' first before field var 'x_t_15_head'
        $val = $CurrentForm->hasValue("t_15_head") ? $CurrentForm->getValue("t_15_head") : $CurrentForm->getValue("x_t_15_head");
        if (!$this->t_15_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_15_head->Visible = false; // Disable update for API request
            } else {
                $this->t_15_head->setFormValue($val);
            }
        }

        // Check field name 'po_01_head' first before field var 'x_po_01_head'
        $val = $CurrentForm->hasValue("po_01_head") ? $CurrentForm->getValue("po_01_head") : $CurrentForm->getValue("x_po_01_head");
        if (!$this->po_01_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_01_head->Visible = false; // Disable update for API request
            } else {
                $this->po_01_head->setFormValue($val);
            }
        }

        // Check field name 'po_02_head' first before field var 'x_po_02_head'
        $val = $CurrentForm->hasValue("po_02_head") ? $CurrentForm->getValue("po_02_head") : $CurrentForm->getValue("x_po_02_head");
        if (!$this->po_02_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_02_head->Visible = false; // Disable update for API request
            } else {
                $this->po_02_head->setFormValue($val);
            }
        }

        // Check field name 'po_03_head' first before field var 'x_po_03_head'
        $val = $CurrentForm->hasValue("po_03_head") ? $CurrentForm->getValue("po_03_head") : $CurrentForm->getValue("x_po_03_head");
        if (!$this->po_03_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_03_head->Visible = false; // Disable update for API request
            } else {
                $this->po_03_head->setFormValue($val);
            }
        }

        // Check field name 'po_04_head' first before field var 'x_po_04_head'
        $val = $CurrentForm->hasValue("po_04_head") ? $CurrentForm->getValue("po_04_head") : $CurrentForm->getValue("x_po_04_head");
        if (!$this->po_04_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_04_head->Visible = false; // Disable update for API request
            } else {
                $this->po_04_head->setFormValue($val);
            }
        }

        // Check field name 'po_05_head' first before field var 'x_po_05_head'
        $val = $CurrentForm->hasValue("po_05_head") ? $CurrentForm->getValue("po_05_head") : $CurrentForm->getValue("x_po_05_head");
        if (!$this->po_05_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_05_head->Visible = false; // Disable update for API request
            } else {
                $this->po_05_head->setFormValue($val);
            }
        }

        // Check field name 'po_06_head' first before field var 'x_po_06_head'
        $val = $CurrentForm->hasValue("po_06_head") ? $CurrentForm->getValue("po_06_head") : $CurrentForm->getValue("x_po_06_head");
        if (!$this->po_06_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_06_head->Visible = false; // Disable update for API request
            } else {
                $this->po_06_head->setFormValue($val);
            }
        }

        // Check field name 'po_07_head' first before field var 'x_po_07_head'
        $val = $CurrentForm->hasValue("po_07_head") ? $CurrentForm->getValue("po_07_head") : $CurrentForm->getValue("x_po_07_head");
        if (!$this->po_07_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_07_head->Visible = false; // Disable update for API request
            } else {
                $this->po_07_head->setFormValue($val);
            }
        }

        // Check field name 'po_08_head' first before field var 'x_po_08_head'
        $val = $CurrentForm->hasValue("po_08_head") ? $CurrentForm->getValue("po_08_head") : $CurrentForm->getValue("x_po_08_head");
        if (!$this->po_08_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_08_head->Visible = false; // Disable update for API request
            } else {
                $this->po_08_head->setFormValue($val);
            }
        }

        // Check field name 'po_17_head' first before field var 'x_po_17_head'
        $val = $CurrentForm->hasValue("po_17_head") ? $CurrentForm->getValue("po_17_head") : $CurrentForm->getValue("x_po_17_head");
        if (!$this->po_17_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_17_head->Visible = false; // Disable update for API request
            } else {
                $this->po_17_head->setFormValue($val);
            }
        }

        // Check field name 'po_18_head' first before field var 'x_po_18_head'
        $val = $CurrentForm->hasValue("po_18_head") ? $CurrentForm->getValue("po_18_head") : $CurrentForm->getValue("x_po_18_head");
        if (!$this->po_18_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_18_head->Visible = false; // Disable update for API request
            } else {
                $this->po_18_head->setFormValue($val);
            }
        }

        // Check field name 'po_19_head' first before field var 'x_po_19_head'
        $val = $CurrentForm->hasValue("po_19_head") ? $CurrentForm->getValue("po_19_head") : $CurrentForm->getValue("x_po_19_head");
        if (!$this->po_19_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_19_head->Visible = false; // Disable update for API request
            } else {
                $this->po_19_head->setFormValue($val);
            }
        }

        // Check field name 'po_20_head' first before field var 'x_po_20_head'
        $val = $CurrentForm->hasValue("po_20_head") ? $CurrentForm->getValue("po_20_head") : $CurrentForm->getValue("x_po_20_head");
        if (!$this->po_20_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_20_head->Visible = false; // Disable update for API request
            } else {
                $this->po_20_head->setFormValue($val);
            }
        }

        // Check field name 'jc_01_head' first before field var 'x_jc_01_head'
        $val = $CurrentForm->hasValue("jc_01_head") ? $CurrentForm->getValue("jc_01_head") : $CurrentForm->getValue("x_jc_01_head");
        if (!$this->jc_01_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_01_head->Visible = false; // Disable update for API request
            } else {
                $this->jc_01_head->setFormValue($val);
            }
        }

        // Check field name 'jc_02_head' first before field var 'x_jc_02_head'
        $val = $CurrentForm->hasValue("jc_02_head") ? $CurrentForm->getValue("jc_02_head") : $CurrentForm->getValue("x_jc_02_head");
        if (!$this->jc_02_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_02_head->Visible = false; // Disable update for API request
            } else {
                $this->jc_02_head->setFormValue($val);
            }
        }

        // Check field name 'jc_03_head' first before field var 'x_jc_03_head'
        $val = $CurrentForm->hasValue("jc_03_head") ? $CurrentForm->getValue("jc_03_head") : $CurrentForm->getValue("x_jc_03_head");
        if (!$this->jc_03_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_03_head->Visible = false; // Disable update for API request
            } else {
                $this->jc_03_head->setFormValue($val);
            }
        }

        // Check field name 'jc_04_head' first before field var 'x_jc_04_head'
        $val = $CurrentForm->hasValue("jc_04_head") ? $CurrentForm->getValue("jc_04_head") : $CurrentForm->getValue("x_jc_04_head");
        if (!$this->jc_04_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_04_head->Visible = false; // Disable update for API request
            } else {
                $this->jc_04_head->setFormValue($val);
            }
        }

        // Check field name 'jc_05_head' first before field var 'x_jc_05_head'
        $val = $CurrentForm->hasValue("jc_05_head") ? $CurrentForm->getValue("jc_05_head") : $CurrentForm->getValue("x_jc_05_head");
        if (!$this->jc_05_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_05_head->Visible = false; // Disable update for API request
            } else {
                $this->jc_05_head->setFormValue($val);
            }
        }

        // Check field name 'jc_06_head' first before field var 'x_jc_06_head'
        $val = $CurrentForm->hasValue("jc_06_head") ? $CurrentForm->getValue("jc_06_head") : $CurrentForm->getValue("x_jc_06_head");
        if (!$this->jc_06_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_06_head->Visible = false; // Disable update for API request
            } else {
                $this->jc_06_head->setFormValue($val);
            }
        }

        // Check field name 'jc_07_head' first before field var 'x_jc_07_head'
        $val = $CurrentForm->hasValue("jc_07_head") ? $CurrentForm->getValue("jc_07_head") : $CurrentForm->getValue("x_jc_07_head");
        if (!$this->jc_07_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_07_head->Visible = false; // Disable update for API request
            } else {
                $this->jc_07_head->setFormValue($val);
            }
        }

        // Check field name 'jc_08_head' first before field var 'x_jc_08_head'
        $val = $CurrentForm->hasValue("jc_08_head") ? $CurrentForm->getValue("jc_08_head") : $CurrentForm->getValue("x_jc_08_head");
        if (!$this->jc_08_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_08_head->Visible = false; // Disable update for API request
            } else {
                $this->jc_08_head->setFormValue($val);
            }
        }

        // Check field name 'jc_09_head' first before field var 'x_jc_09_head'
        $val = $CurrentForm->hasValue("jc_09_head") ? $CurrentForm->getValue("jc_09_head") : $CurrentForm->getValue("x_jc_09_head");
        if (!$this->jc_09_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_09_head->Visible = false; // Disable update for API request
            } else {
                $this->jc_09_head->setFormValue($val);
            }
        }

        // Check field name 'jc_10_head' first before field var 'x_jc_10_head'
        $val = $CurrentForm->hasValue("jc_10_head") ? $CurrentForm->getValue("jc_10_head") : $CurrentForm->getValue("x_jc_10_head");
        if (!$this->jc_10_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_10_head->Visible = false; // Disable update for API request
            } else {
                $this->jc_10_head->setFormValue($val);
            }
        }

        // Check field name 'pc_shape' first before field var 'x_pc_shape'
        $val = $CurrentForm->hasValue("pc_shape") ? $CurrentForm->getValue("pc_shape") : $CurrentForm->getValue("x_pc_shape");
        if (!$this->pc_shape->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_shape->Visible = false; // Disable update for API request
            } else {
                $this->pc_shape->setFormValue($val);
            }
        }

        // Check field name 'pc_unit' first before field var 'x_pc_unit'
        $val = $CurrentForm->hasValue("pc_unit") ? $CurrentForm->getValue("pc_unit") : $CurrentForm->getValue("x_pc_unit");
        if (!$this->pc_unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_unit->Visible = false; // Disable update for API request
            } else {
                $this->pc_unit->setFormValue($val);
            }
        }

        // Check field name 'pc_w' first before field var 'x_pc_w'
        $val = $CurrentForm->hasValue("pc_w") ? $CurrentForm->getValue("pc_w") : $CurrentForm->getValue("x_pc_w");
        if (!$this->pc_w->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_w->Visible = false; // Disable update for API request
            } else {
                $this->pc_w->setFormValue($val);
            }
        }

        // Check field name 'pc_l' first before field var 'x_pc_l'
        $val = $CurrentForm->hasValue("pc_l") ? $CurrentForm->getValue("pc_l") : $CurrentForm->getValue("x_pc_l");
        if (!$this->pc_l->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_l->Visible = false; // Disable update for API request
            } else {
                $this->pc_l->setFormValue($val);
            }
        }

        // Check field name 'pc_h' first before field var 'x_pc_h'
        $val = $CurrentForm->hasValue("pc_h") ? $CurrentForm->getValue("pc_h") : $CurrentForm->getValue("x_pc_h");
        if (!$this->pc_h->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_h->Visible = false; // Disable update for API request
            } else {
                $this->pc_h->setFormValue($val);
            }
        }

        // Check field name 'pc_partner_size' first before field var 'x_pc_partner_size'
        $val = $CurrentForm->hasValue("pc_partner_size") ? $CurrentForm->getValue("pc_partner_size") : $CurrentForm->getValue("x_pc_partner_size");
        if (!$this->pc_partner_size->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_partner_size->Visible = false; // Disable update for API request
            } else {
                $this->pc_partner_size->setFormValue($val);
            }
        }

        // Check field name 'pc_sqm' first before field var 'x_pc_sqm'
        $val = $CurrentForm->hasValue("pc_sqm") ? $CurrentForm->getValue("pc_sqm") : $CurrentForm->getValue("x_pc_sqm");
        if (!$this->pc_sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_sqm->Visible = false; // Disable update for API request
            } else {
                $this->pc_sqm->setFormValue($val);
            }
        }

        // Check field name 'pc_01_head' first before field var 'x_pc_01_head'
        $val = $CurrentForm->hasValue("pc_01_head") ? $CurrentForm->getValue("pc_01_head") : $CurrentForm->getValue("x_pc_01_head");
        if (!$this->pc_01_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_01_head->Visible = false; // Disable update for API request
            } else {
                $this->pc_01_head->setFormValue($val);
            }
        }

        // Check field name 'pc_02_head' first before field var 'x_pc_02_head'
        $val = $CurrentForm->hasValue("pc_02_head") ? $CurrentForm->getValue("pc_02_head") : $CurrentForm->getValue("x_pc_02_head");
        if (!$this->pc_02_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_02_head->Visible = false; // Disable update for API request
            } else {
                $this->pc_02_head->setFormValue($val);
            }
        }

        // Check field name 'pc_03_head' first before field var 'x_pc_03_head'
        $val = $CurrentForm->hasValue("pc_03_head") ? $CurrentForm->getValue("pc_03_head") : $CurrentForm->getValue("x_pc_03_head");
        if (!$this->pc_03_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_03_head->Visible = false; // Disable update for API request
            } else {
                $this->pc_03_head->setFormValue($val);
            }
        }

        // Check field name 'pc_04_head' first before field var 'x_pc_04_head'
        $val = $CurrentForm->hasValue("pc_04_head") ? $CurrentForm->getValue("pc_04_head") : $CurrentForm->getValue("x_pc_04_head");
        if (!$this->pc_04_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_04_head->Visible = false; // Disable update for API request
            } else {
                $this->pc_04_head->setFormValue($val);
            }
        }

        // Check field name 'pc_05_head' first before field var 'x_pc_05_head'
        $val = $CurrentForm->hasValue("pc_05_head") ? $CurrentForm->getValue("pc_05_head") : $CurrentForm->getValue("x_pc_05_head");
        if (!$this->pc_05_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_05_head->Visible = false; // Disable update for API request
            } else {
                $this->pc_05_head->setFormValue($val);
            }
        }

        // Check field name 'pc_06_head' first before field var 'x_pc_06_head'
        $val = $CurrentForm->hasValue("pc_06_head") ? $CurrentForm->getValue("pc_06_head") : $CurrentForm->getValue("x_pc_06_head");
        if (!$this->pc_06_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_06_head->Visible = false; // Disable update for API request
            } else {
                $this->pc_06_head->setFormValue($val);
            }
        }

        // Check field name 'pc_07_head' first before field var 'x_pc_07_head'
        $val = $CurrentForm->hasValue("pc_07_head") ? $CurrentForm->getValue("pc_07_head") : $CurrentForm->getValue("x_pc_07_head");
        if (!$this->pc_07_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_07_head->Visible = false; // Disable update for API request
            } else {
                $this->pc_07_head->setFormValue($val);
            }
        }

        // Check field name 'pc_08_head' first before field var 'x_pc_08_head'
        $val = $CurrentForm->hasValue("pc_08_head") ? $CurrentForm->getValue("pc_08_head") : $CurrentForm->getValue("x_pc_08_head");
        if (!$this->pc_08_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_08_head->Visible = false; // Disable update for API request
            } else {
                $this->pc_08_head->setFormValue($val);
            }
        }

        // Check field name 'pc_09_head' first before field var 'x_pc_09_head'
        $val = $CurrentForm->hasValue("pc_09_head") ? $CurrentForm->getValue("pc_09_head") : $CurrentForm->getValue("x_pc_09_head");
        if (!$this->pc_09_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_09_head->Visible = false; // Disable update for API request
            } else {
                $this->pc_09_head->setFormValue($val);
            }
        }

        // Check field name 'pc_10_head' first before field var 'x_pc_10_head'
        $val = $CurrentForm->hasValue("pc_10_head") ? $CurrentForm->getValue("pc_10_head") : $CurrentForm->getValue("x_pc_10_head");
        if (!$this->pc_10_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_10_head->Visible = false; // Disable update for API request
            } else {
                $this->pc_10_head->setFormValue($val);
            }
        }

        // Check field name 'pc_11_head' first before field var 'x_pc_11_head'
        $val = $CurrentForm->hasValue("pc_11_head") ? $CurrentForm->getValue("pc_11_head") : $CurrentForm->getValue("x_pc_11_head");
        if (!$this->pc_11_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_11_head->Visible = false; // Disable update for API request
            } else {
                $this->pc_11_head->setFormValue($val);
            }
        }

        // Check field name 'pc_12_head' first before field var 'x_pc_12_head'
        $val = $CurrentForm->hasValue("pc_12_head") ? $CurrentForm->getValue("pc_12_head") : $CurrentForm->getValue("x_pc_12_head");
        if (!$this->pc_12_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_12_head->Visible = false; // Disable update for API request
            } else {
                $this->pc_12_head->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'pa_process_size_w' first before field var 'x_pa_process_size_w'
        $val = $CurrentForm->hasValue("pa_process_size_w") ? $CurrentForm->getValue("pa_process_size_w") : $CurrentForm->getValue("x_pa_process_size_w");
        if (!$this->pa_process_size_w->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_process_size_w->Visible = false; // Disable update for API request
            } else {
                $this->pa_process_size_w->setFormValue($val);
            }
        }

        // Check field name 'pa_process_size_l' first before field var 'x_pa_process_size_l'
        $val = $CurrentForm->hasValue("pa_process_size_l") ? $CurrentForm->getValue("pa_process_size_l") : $CurrentForm->getValue("x_pa_process_size_l");
        if (!$this->pa_process_size_l->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_process_size_l->Visible = false; // Disable update for API request
            } else {
                $this->pa_process_size_l->setFormValue($val);
            }
        }

        // Check field name 'pa_head_01' first before field var 'x_pa_head_01'
        $val = $CurrentForm->hasValue("pa_head_01") ? $CurrentForm->getValue("pa_head_01") : $CurrentForm->getValue("x_pa_head_01");
        if (!$this->pa_head_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_head_01->Visible = false; // Disable update for API request
            } else {
                $this->pa_head_01->setFormValue($val);
            }
        }

        // Check field name 'pa_process_01' first before field var 'x_pa_process_01'
        $val = $CurrentForm->hasValue("pa_process_01") ? $CurrentForm->getValue("pa_process_01") : $CurrentForm->getValue("x_pa_process_01");
        if (!$this->pa_process_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_process_01->Visible = false; // Disable update for API request
            } else {
                $this->pa_process_01->setFormValue($val);
            }
        }

        // Check field name 'pa_head_02' first before field var 'x_pa_head_02'
        $val = $CurrentForm->hasValue("pa_head_02") ? $CurrentForm->getValue("pa_head_02") : $CurrentForm->getValue("x_pa_head_02");
        if (!$this->pa_head_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_head_02->Visible = false; // Disable update for API request
            } else {
                $this->pa_head_02->setFormValue($val);
            }
        }

        // Check field name 'pa_process_02' first before field var 'x_pa_process_02'
        $val = $CurrentForm->hasValue("pa_process_02") ? $CurrentForm->getValue("pa_process_02") : $CurrentForm->getValue("x_pa_process_02");
        if (!$this->pa_process_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_process_02->Visible = false; // Disable update for API request
            } else {
                $this->pa_process_02->setFormValue($val);
            }
        }

        // Check field name 'pa_head_03' first before field var 'x_pa_head_03'
        $val = $CurrentForm->hasValue("pa_head_03") ? $CurrentForm->getValue("pa_head_03") : $CurrentForm->getValue("x_pa_head_03");
        if (!$this->pa_head_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_head_03->Visible = false; // Disable update for API request
            } else {
                $this->pa_head_03->setFormValue($val);
            }
        }

        // Check field name 'pa_process_03' first before field var 'x_pa_process_03'
        $val = $CurrentForm->hasValue("pa_process_03") ? $CurrentForm->getValue("pa_process_03") : $CurrentForm->getValue("x_pa_process_03");
        if (!$this->pa_process_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_process_03->Visible = false; // Disable update for API request
            } else {
                $this->pa_process_03->setFormValue($val);
            }
        }

        // Check field name 'pa_head_04' first before field var 'x_pa_head_04'
        $val = $CurrentForm->hasValue("pa_head_04") ? $CurrentForm->getValue("pa_head_04") : $CurrentForm->getValue("x_pa_head_04");
        if (!$this->pa_head_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_head_04->Visible = false; // Disable update for API request
            } else {
                $this->pa_head_04->setFormValue($val);
            }
        }

        // Check field name 'pa_process_04' first before field var 'x_pa_process_04'
        $val = $CurrentForm->hasValue("pa_process_04") ? $CurrentForm->getValue("pa_process_04") : $CurrentForm->getValue("x_pa_process_04");
        if (!$this->pa_process_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_process_04->Visible = false; // Disable update for API request
            } else {
                $this->pa_process_04->setFormValue($val);
            }
        }

        // Check field name 'pa_head_05' first before field var 'x_pa_head_05'
        $val = $CurrentForm->hasValue("pa_head_05") ? $CurrentForm->getValue("pa_head_05") : $CurrentForm->getValue("x_pa_head_05");
        if (!$this->pa_head_05->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_head_05->Visible = false; // Disable update for API request
            } else {
                $this->pa_head_05->setFormValue($val);
            }
        }

        // Check field name 'pa_process_05' first before field var 'x_pa_process_05'
        $val = $CurrentForm->hasValue("pa_process_05") ? $CurrentForm->getValue("pa_process_05") : $CurrentForm->getValue("x_pa_process_05");
        if (!$this->pa_process_05->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_process_05->Visible = false; // Disable update for API request
            } else {
                $this->pa_process_05->setFormValue($val);
            }
        }

        // Check field name 'pa_head_06' first before field var 'x_pa_head_06'
        $val = $CurrentForm->hasValue("pa_head_06") ? $CurrentForm->getValue("pa_head_06") : $CurrentForm->getValue("x_pa_head_06");
        if (!$this->pa_head_06->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_head_06->Visible = false; // Disable update for API request
            } else {
                $this->pa_head_06->setFormValue($val);
            }
        }

        // Check field name 'pa_process_06' first before field var 'x_pa_process_06'
        $val = $CurrentForm->hasValue("pa_process_06") ? $CurrentForm->getValue("pa_process_06") : $CurrentForm->getValue("x_pa_process_06");
        if (!$this->pa_process_06->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_process_06->Visible = false; // Disable update for API request
            } else {
                $this->pa_process_06->setFormValue($val);
            }
        }

        // Check field name 'pa_head_07' first before field var 'x_pa_head_07'
        $val = $CurrentForm->hasValue("pa_head_07") ? $CurrentForm->getValue("pa_head_07") : $CurrentForm->getValue("x_pa_head_07");
        if (!$this->pa_head_07->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_head_07->Visible = false; // Disable update for API request
            } else {
                $this->pa_head_07->setFormValue($val);
            }
        }

        // Check field name 'pa_process_07' first before field var 'x_pa_process_07'
        $val = $CurrentForm->hasValue("pa_process_07") ? $CurrentForm->getValue("pa_process_07") : $CurrentForm->getValue("x_pa_process_07");
        if (!$this->pa_process_07->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_process_07->Visible = false; // Disable update for API request
            } else {
                $this->pa_process_07->setFormValue($val);
            }
        }

        // Check field name 'pa_head_08' first before field var 'x_pa_head_08'
        $val = $CurrentForm->hasValue("pa_head_08") ? $CurrentForm->getValue("pa_head_08") : $CurrentForm->getValue("x_pa_head_08");
        if (!$this->pa_head_08->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_head_08->Visible = false; // Disable update for API request
            } else {
                $this->pa_head_08->setFormValue($val);
            }
        }

        // Check field name 'pa_process_08' first before field var 'x_pa_process_08'
        $val = $CurrentForm->hasValue("pa_process_08") ? $CurrentForm->getValue("pa_process_08") : $CurrentForm->getValue("x_pa_process_08");
        if (!$this->pa_process_08->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_process_08->Visible = false; // Disable update for API request
            } else {
                $this->pa_process_08->setFormValue($val);
            }
        }

        // Check field name 'pa_head_09' first before field var 'x_pa_head_09'
        $val = $CurrentForm->hasValue("pa_head_09") ? $CurrentForm->getValue("pa_head_09") : $CurrentForm->getValue("x_pa_head_09");
        if (!$this->pa_head_09->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_head_09->Visible = false; // Disable update for API request
            } else {
                $this->pa_head_09->setFormValue($val);
            }
        }

        // Check field name 'pa_process_09' first before field var 'x_pa_process_09'
        $val = $CurrentForm->hasValue("pa_process_09") ? $CurrentForm->getValue("pa_process_09") : $CurrentForm->getValue("x_pa_process_09");
        if (!$this->pa_process_09->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_process_09->Visible = false; // Disable update for API request
            } else {
                $this->pa_process_09->setFormValue($val);
            }
        }

        // Check field name 'pa_head_10' first before field var 'x_pa_head_10'
        $val = $CurrentForm->hasValue("pa_head_10") ? $CurrentForm->getValue("pa_head_10") : $CurrentForm->getValue("x_pa_head_10");
        if (!$this->pa_head_10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_head_10->Visible = false; // Disable update for API request
            } else {
                $this->pa_head_10->setFormValue($val);
            }
        }

        // Check field name 'pa_process_10' first before field var 'x_pa_process_10'
        $val = $CurrentForm->hasValue("pa_process_10") ? $CurrentForm->getValue("pa_process_10") : $CurrentForm->getValue("x_pa_process_10");
        if (!$this->pa_process_10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_process_10->Visible = false; // Disable update for API request
            } else {
                $this->pa_process_10->setFormValue($val);
            }
        }

        // Check field name 'publish' first before field var 'x_publish'
        $val = $CurrentForm->hasValue("publish") ? $CurrentForm->getValue("publish") : $CurrentForm->getValue("x_publish");
        if (!$this->publish->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->publish->Visible = false; // Disable update for API request
            } else {
                $this->publish->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ppr_01' first before field var 'x_ppr_01'
        $val = $CurrentForm->hasValue("ppr_01") ? $CurrentForm->getValue("ppr_01") : $CurrentForm->getValue("x_ppr_01");
        if (!$this->ppr_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ppr_01->Visible = false; // Disable update for API request
            } else {
                $this->ppr_01->setFormValue($val);
            }
        }

        // Check field name 'ppr_02' first before field var 'x_ppr_02'
        $val = $CurrentForm->hasValue("ppr_02") ? $CurrentForm->getValue("ppr_02") : $CurrentForm->getValue("x_ppr_02");
        if (!$this->ppr_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ppr_02->Visible = false; // Disable update for API request
            } else {
                $this->ppr_02->setFormValue($val);
            }
        }

        // Check field name 'ppr_03' first before field var 'x_ppr_03'
        $val = $CurrentForm->hasValue("ppr_03") ? $CurrentForm->getValue("ppr_03") : $CurrentForm->getValue("x_ppr_03");
        if (!$this->ppr_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ppr_03->Visible = false; // Disable update for API request
            } else {
                $this->ppr_03->setFormValue($val);
            }
        }

        // Check field name 'ppr_04' first before field var 'x_ppr_04'
        $val = $CurrentForm->hasValue("ppr_04") ? $CurrentForm->getValue("ppr_04") : $CurrentForm->getValue("x_ppr_04");
        if (!$this->ppr_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ppr_04->Visible = false; // Disable update for API request
            } else {
                $this->ppr_04->setFormValue($val);
            }
        }

        // Check field name 'ppr_05' first before field var 'x_ppr_05'
        $val = $CurrentForm->hasValue("ppr_05") ? $CurrentForm->getValue("ppr_05") : $CurrentForm->getValue("x_ppr_05");
        if (!$this->ppr_05->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ppr_05->Visible = false; // Disable update for API request
            } else {
                $this->ppr_05->setFormValue($val);
            }
        }

        // Check field name 'ppr_06' first before field var 'x_ppr_06'
        $val = $CurrentForm->hasValue("ppr_06") ? $CurrentForm->getValue("ppr_06") : $CurrentForm->getValue("x_ppr_06");
        if (!$this->ppr_06->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ppr_06->Visible = false; // Disable update for API request
            } else {
                $this->ppr_06->setFormValue($val);
            }
        }
		$this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
		$this->image->UploadPath = $this->image->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->product_group->CurrentValue = $this->product_group->FormValue;
        $this->calculation_method->CurrentValue = $this->calculation_method->FormValue;
        $this->shape->CurrentValue = $this->shape->FormValue;
        $this->sqm->CurrentValue = $this->sqm->FormValue;
        $this->cbm->CurrentValue = $this->cbm->FormValue;
        $this->process->CurrentValue = $this->process->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->v_00->CurrentValue = $this->v_00->FormValue;
        $this->v_01->CurrentValue = $this->v_01->FormValue;
        $this->v_01_validation->CurrentValue = $this->v_01_validation->FormValue;
        $this->v_02->CurrentValue = $this->v_02->FormValue;
        $this->v_02_validation->CurrentValue = $this->v_02_validation->FormValue;
        $this->v_03->CurrentValue = $this->v_03->FormValue;
        $this->v_03_validation->CurrentValue = $this->v_03_validation->FormValue;
        $this->v_04->CurrentValue = $this->v_04->FormValue;
        $this->v_04_validation->CurrentValue = $this->v_04_validation->FormValue;
        $this->v_05->CurrentValue = $this->v_05->FormValue;
        $this->v_05_validation->CurrentValue = $this->v_05_validation->FormValue;
        $this->v_06->CurrentValue = $this->v_06->FormValue;
        $this->v_06_validation->CurrentValue = $this->v_06_validation->FormValue;
        $this->v_07->CurrentValue = $this->v_07->FormValue;
        $this->v_07_validation->CurrentValue = $this->v_07_validation->FormValue;
        $this->v_08->CurrentValue = $this->v_08->FormValue;
        $this->v_08_validation->CurrentValue = $this->v_08_validation->FormValue;
        $this->v_09->CurrentValue = $this->v_09->FormValue;
        $this->v_09_validation->CurrentValue = $this->v_09_validation->FormValue;
        $this->v_10->CurrentValue = $this->v_10->FormValue;
        $this->v_10_validation->CurrentValue = $this->v_10_validation->FormValue;
        $this->b_01_head->CurrentValue = $this->b_01_head->FormValue;
        $this->b_02_head->CurrentValue = $this->b_02_head->FormValue;
        $this->b_03_head->CurrentValue = $this->b_03_head->FormValue;
        $this->b_04_head->CurrentValue = $this->b_04_head->FormValue;
        $this->b_05_head->CurrentValue = $this->b_05_head->FormValue;
        $this->b_06_head->CurrentValue = $this->b_06_head->FormValue;
        $this->b_07_head->CurrentValue = $this->b_07_head->FormValue;
        $this->b_08_head->CurrentValue = $this->b_08_head->FormValue;
        $this->b_09_head->CurrentValue = $this->b_09_head->FormValue;
        $this->b_10_head->CurrentValue = $this->b_10_head->FormValue;
        $this->b_11_head->CurrentValue = $this->b_11_head->FormValue;
        $this->b_12_head->CurrentValue = $this->b_12_head->FormValue;
        $this->b_13_head->CurrentValue = $this->b_13_head->FormValue;
        $this->b_14_head->CurrentValue = $this->b_14_head->FormValue;
        $this->b_15_head->CurrentValue = $this->b_15_head->FormValue;
        $this->q_sku->CurrentValue = $this->q_sku->FormValue;
        $this->t_01_head->CurrentValue = $this->t_01_head->FormValue;
        $this->t_02_head->CurrentValue = $this->t_02_head->FormValue;
        $this->t_03_head->CurrentValue = $this->t_03_head->FormValue;
        $this->t_04_head->CurrentValue = $this->t_04_head->FormValue;
        $this->t_05_head->CurrentValue = $this->t_05_head->FormValue;
        $this->t_06_head->CurrentValue = $this->t_06_head->FormValue;
        $this->t_07_head->CurrentValue = $this->t_07_head->FormValue;
        $this->t_08_head->CurrentValue = $this->t_08_head->FormValue;
        $this->t_09_head->CurrentValue = $this->t_09_head->FormValue;
        $this->t_10_head->CurrentValue = $this->t_10_head->FormValue;
        $this->t_11_head->CurrentValue = $this->t_11_head->FormValue;
        $this->t_12_head->CurrentValue = $this->t_12_head->FormValue;
        $this->t_13_head->CurrentValue = $this->t_13_head->FormValue;
        $this->t_14_head->CurrentValue = $this->t_14_head->FormValue;
        $this->t_15_head->CurrentValue = $this->t_15_head->FormValue;
        $this->po_01_head->CurrentValue = $this->po_01_head->FormValue;
        $this->po_02_head->CurrentValue = $this->po_02_head->FormValue;
        $this->po_03_head->CurrentValue = $this->po_03_head->FormValue;
        $this->po_04_head->CurrentValue = $this->po_04_head->FormValue;
        $this->po_05_head->CurrentValue = $this->po_05_head->FormValue;
        $this->po_06_head->CurrentValue = $this->po_06_head->FormValue;
        $this->po_07_head->CurrentValue = $this->po_07_head->FormValue;
        $this->po_08_head->CurrentValue = $this->po_08_head->FormValue;
        $this->po_17_head->CurrentValue = $this->po_17_head->FormValue;
        $this->po_18_head->CurrentValue = $this->po_18_head->FormValue;
        $this->po_19_head->CurrentValue = $this->po_19_head->FormValue;
        $this->po_20_head->CurrentValue = $this->po_20_head->FormValue;
        $this->jc_01_head->CurrentValue = $this->jc_01_head->FormValue;
        $this->jc_02_head->CurrentValue = $this->jc_02_head->FormValue;
        $this->jc_03_head->CurrentValue = $this->jc_03_head->FormValue;
        $this->jc_04_head->CurrentValue = $this->jc_04_head->FormValue;
        $this->jc_05_head->CurrentValue = $this->jc_05_head->FormValue;
        $this->jc_06_head->CurrentValue = $this->jc_06_head->FormValue;
        $this->jc_07_head->CurrentValue = $this->jc_07_head->FormValue;
        $this->jc_08_head->CurrentValue = $this->jc_08_head->FormValue;
        $this->jc_09_head->CurrentValue = $this->jc_09_head->FormValue;
        $this->jc_10_head->CurrentValue = $this->jc_10_head->FormValue;
        $this->pc_shape->CurrentValue = $this->pc_shape->FormValue;
        $this->pc_unit->CurrentValue = $this->pc_unit->FormValue;
        $this->pc_w->CurrentValue = $this->pc_w->FormValue;
        $this->pc_l->CurrentValue = $this->pc_l->FormValue;
        $this->pc_h->CurrentValue = $this->pc_h->FormValue;
        $this->pc_partner_size->CurrentValue = $this->pc_partner_size->FormValue;
        $this->pc_sqm->CurrentValue = $this->pc_sqm->FormValue;
        $this->pc_01_head->CurrentValue = $this->pc_01_head->FormValue;
        $this->pc_02_head->CurrentValue = $this->pc_02_head->FormValue;
        $this->pc_03_head->CurrentValue = $this->pc_03_head->FormValue;
        $this->pc_04_head->CurrentValue = $this->pc_04_head->FormValue;
        $this->pc_05_head->CurrentValue = $this->pc_05_head->FormValue;
        $this->pc_06_head->CurrentValue = $this->pc_06_head->FormValue;
        $this->pc_07_head->CurrentValue = $this->pc_07_head->FormValue;
        $this->pc_08_head->CurrentValue = $this->pc_08_head->FormValue;
        $this->pc_09_head->CurrentValue = $this->pc_09_head->FormValue;
        $this->pc_10_head->CurrentValue = $this->pc_10_head->FormValue;
        $this->pc_11_head->CurrentValue = $this->pc_11_head->FormValue;
        $this->pc_12_head->CurrentValue = $this->pc_12_head->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->pa_process_size_w->CurrentValue = $this->pa_process_size_w->FormValue;
        $this->pa_process_size_l->CurrentValue = $this->pa_process_size_l->FormValue;
        $this->pa_head_01->CurrentValue = $this->pa_head_01->FormValue;
        $this->pa_process_01->CurrentValue = $this->pa_process_01->FormValue;
        $this->pa_head_02->CurrentValue = $this->pa_head_02->FormValue;
        $this->pa_process_02->CurrentValue = $this->pa_process_02->FormValue;
        $this->pa_head_03->CurrentValue = $this->pa_head_03->FormValue;
        $this->pa_process_03->CurrentValue = $this->pa_process_03->FormValue;
        $this->pa_head_04->CurrentValue = $this->pa_head_04->FormValue;
        $this->pa_process_04->CurrentValue = $this->pa_process_04->FormValue;
        $this->pa_head_05->CurrentValue = $this->pa_head_05->FormValue;
        $this->pa_process_05->CurrentValue = $this->pa_process_05->FormValue;
        $this->pa_head_06->CurrentValue = $this->pa_head_06->FormValue;
        $this->pa_process_06->CurrentValue = $this->pa_process_06->FormValue;
        $this->pa_head_07->CurrentValue = $this->pa_head_07->FormValue;
        $this->pa_process_07->CurrentValue = $this->pa_process_07->FormValue;
        $this->pa_head_08->CurrentValue = $this->pa_head_08->FormValue;
        $this->pa_process_08->CurrentValue = $this->pa_process_08->FormValue;
        $this->pa_head_09->CurrentValue = $this->pa_head_09->FormValue;
        $this->pa_process_09->CurrentValue = $this->pa_process_09->FormValue;
        $this->pa_head_10->CurrentValue = $this->pa_head_10->FormValue;
        $this->pa_process_10->CurrentValue = $this->pa_process_10->FormValue;
        $this->publish->CurrentValue = $this->publish->FormValue;
        $this->ppr_01->CurrentValue = $this->ppr_01->FormValue;
        $this->ppr_02->CurrentValue = $this->ppr_02->FormValue;
        $this->ppr_03->CurrentValue = $this->ppr_03->FormValue;
        $this->ppr_04->CurrentValue = $this->ppr_04->FormValue;
        $this->ppr_05->CurrentValue = $this->ppr_05->FormValue;
        $this->ppr_06->CurrentValue = $this->ppr_06->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->product_group->setDbValue($row['product_group']);
        $this->calculation_method->setDbValue($row['calculation_method']);
        $this->shape->setDbValue($row['shape']);
        $this->sqm->setDbValue($row['sqm']);
        $this->cbm->setDbValue($row['cbm']);
        $this->process->setDbValue($row['process']);
        $this->status->setDbValue($row['status']);
        $this->v_00->setDbValue($row['v_00']);
        $this->v_01->setDbValue($row['v_01']);
        $this->v_01_validation->setDbValue($row['v_01_validation']);
        $this->v_02->setDbValue($row['v_02']);
        $this->v_02_validation->setDbValue($row['v_02_validation']);
        $this->v_03->setDbValue($row['v_03']);
        $this->v_03_validation->setDbValue($row['v_03_validation']);
        $this->v_04->setDbValue($row['v_04']);
        $this->v_04_validation->setDbValue($row['v_04_validation']);
        $this->v_05->setDbValue($row['v_05']);
        $this->v_05_validation->setDbValue($row['v_05_validation']);
        $this->v_06->setDbValue($row['v_06']);
        $this->v_06_validation->setDbValue($row['v_06_validation']);
        $this->v_07->setDbValue($row['v_07']);
        $this->v_07_validation->setDbValue($row['v_07_validation']);
        $this->v_08->setDbValue($row['v_08']);
        $this->v_08_validation->setDbValue($row['v_08_validation']);
        $this->v_09->setDbValue($row['v_09']);
        $this->v_09_validation->setDbValue($row['v_09_validation']);
        $this->v_10->setDbValue($row['v_10']);
        $this->v_10_validation->setDbValue($row['v_10_validation']);
        $this->b_01_head->setDbValue($row['b_01_head']);
        $this->b_02_head->setDbValue($row['b_02_head']);
        $this->b_03_head->setDbValue($row['b_03_head']);
        $this->b_04_head->setDbValue($row['b_04_head']);
        $this->b_05_head->setDbValue($row['b_05_head']);
        $this->b_06_head->setDbValue($row['b_06_head']);
        $this->b_07_head->setDbValue($row['b_07_head']);
        $this->b_08_head->setDbValue($row['b_08_head']);
        $this->b_09_head->setDbValue($row['b_09_head']);
        $this->b_10_head->setDbValue($row['b_10_head']);
        $this->b_11_head->setDbValue($row['b_11_head']);
        $this->b_12_head->setDbValue($row['b_12_head']);
        $this->b_13_head->setDbValue($row['b_13_head']);
        $this->b_14_head->setDbValue($row['b_14_head']);
        $this->b_15_head->setDbValue($row['b_15_head']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->t_01_head->setDbValue($row['t_01_head']);
        $this->t_02_head->setDbValue($row['t_02_head']);
        $this->t_03_head->setDbValue($row['t_03_head']);
        $this->t_04_head->setDbValue($row['t_04_head']);
        $this->t_05_head->setDbValue($row['t_05_head']);
        $this->t_06_head->setDbValue($row['t_06_head']);
        $this->t_07_head->setDbValue($row['t_07_head']);
        $this->t_08_head->setDbValue($row['t_08_head']);
        $this->t_09_head->setDbValue($row['t_09_head']);
        $this->t_10_head->setDbValue($row['t_10_head']);
        $this->t_11_head->setDbValue($row['t_11_head']);
        $this->t_12_head->setDbValue($row['t_12_head']);
        $this->t_13_head->setDbValue($row['t_13_head']);
        $this->t_14_head->setDbValue($row['t_14_head']);
        $this->t_15_head->setDbValue($row['t_15_head']);
        $this->po_01_head->setDbValue($row['po_01_head']);
        $this->po_02_head->setDbValue($row['po_02_head']);
        $this->po_03_head->setDbValue($row['po_03_head']);
        $this->po_04_head->setDbValue($row['po_04_head']);
        $this->po_05_head->setDbValue($row['po_05_head']);
        $this->po_06_head->setDbValue($row['po_06_head']);
        $this->po_07_head->setDbValue($row['po_07_head']);
        $this->po_08_head->setDbValue($row['po_08_head']);
        $this->po_17_head->setDbValue($row['po_17_head']);
        $this->po_18_head->setDbValue($row['po_18_head']);
        $this->po_19_head->setDbValue($row['po_19_head']);
        $this->po_20_head->setDbValue($row['po_20_head']);
        $this->jc_01_head->setDbValue($row['jc_01_head']);
        $this->jc_02_head->setDbValue($row['jc_02_head']);
        $this->jc_03_head->setDbValue($row['jc_03_head']);
        $this->jc_04_head->setDbValue($row['jc_04_head']);
        $this->jc_05_head->setDbValue($row['jc_05_head']);
        $this->jc_06_head->setDbValue($row['jc_06_head']);
        $this->jc_07_head->setDbValue($row['jc_07_head']);
        $this->jc_08_head->setDbValue($row['jc_08_head']);
        $this->jc_09_head->setDbValue($row['jc_09_head']);
        $this->jc_10_head->setDbValue($row['jc_10_head']);
        $this->pc_shape->setDbValue($row['pc_shape']);
        $this->pc_unit->setDbValue($row['pc_unit']);
        $this->pc_w->setDbValue($row['pc_w']);
        $this->pc_l->setDbValue($row['pc_l']);
        $this->pc_h->setDbValue($row['pc_h']);
        $this->pc_partner_size->setDbValue($row['pc_partner_size']);
        $this->pc_sqm->setDbValue($row['pc_sqm']);
        $this->pc_01_head->setDbValue($row['pc_01_head']);
        $this->pc_02_head->setDbValue($row['pc_02_head']);
        $this->pc_03_head->setDbValue($row['pc_03_head']);
        $this->pc_04_head->setDbValue($row['pc_04_head']);
        $this->pc_05_head->setDbValue($row['pc_05_head']);
        $this->pc_06_head->setDbValue($row['pc_06_head']);
        $this->pc_07_head->setDbValue($row['pc_07_head']);
        $this->pc_08_head->setDbValue($row['pc_08_head']);
        $this->pc_09_head->setDbValue($row['pc_09_head']);
        $this->pc_10_head->setDbValue($row['pc_10_head']);
        $this->pc_11_head->setDbValue($row['pc_11_head']);
        $this->pc_12_head->setDbValue($row['pc_12_head']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->pa_process_size_w->setDbValue($row['pa_process_size_w']);
        $this->pa_process_size_l->setDbValue($row['pa_process_size_l']);
        $this->pa_head_01->setDbValue($row['pa_head_01']);
        $this->pa_process_01->setDbValue($row['pa_process_01']);
        $this->pa_head_02->setDbValue($row['pa_head_02']);
        $this->pa_process_02->setDbValue($row['pa_process_02']);
        $this->pa_head_03->setDbValue($row['pa_head_03']);
        $this->pa_process_03->setDbValue($row['pa_process_03']);
        $this->pa_head_04->setDbValue($row['pa_head_04']);
        $this->pa_process_04->setDbValue($row['pa_process_04']);
        $this->pa_head_05->setDbValue($row['pa_head_05']);
        $this->pa_process_05->setDbValue($row['pa_process_05']);
        $this->pa_head_06->setDbValue($row['pa_head_06']);
        $this->pa_process_06->setDbValue($row['pa_process_06']);
        $this->pa_head_07->setDbValue($row['pa_head_07']);
        $this->pa_process_07->setDbValue($row['pa_process_07']);
        $this->pa_head_08->setDbValue($row['pa_head_08']);
        $this->pa_process_08->setDbValue($row['pa_process_08']);
        $this->pa_head_09->setDbValue($row['pa_head_09']);
        $this->pa_process_09->setDbValue($row['pa_process_09']);
        $this->pa_head_10->setDbValue($row['pa_head_10']);
        $this->pa_process_10->setDbValue($row['pa_process_10']);
        $this->publish->setDbValue($row['publish']);
        $this->ppr_01->setDbValue($row['ppr_01']);
        $this->ppr_02->setDbValue($row['ppr_02']);
        $this->ppr_03->setDbValue($row['ppr_03']);
        $this->ppr_04->setDbValue($row['ppr_04']);
        $this->ppr_05->setDbValue($row['ppr_05']);
        $this->ppr_06->setDbValue($row['ppr_06']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['product_group'] = $this->product_group->DefaultValue;
        $row['calculation_method'] = $this->calculation_method->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['v_00'] = $this->v_00->DefaultValue;
        $row['v_01'] = $this->v_01->DefaultValue;
        $row['v_01_validation'] = $this->v_01_validation->DefaultValue;
        $row['v_02'] = $this->v_02->DefaultValue;
        $row['v_02_validation'] = $this->v_02_validation->DefaultValue;
        $row['v_03'] = $this->v_03->DefaultValue;
        $row['v_03_validation'] = $this->v_03_validation->DefaultValue;
        $row['v_04'] = $this->v_04->DefaultValue;
        $row['v_04_validation'] = $this->v_04_validation->DefaultValue;
        $row['v_05'] = $this->v_05->DefaultValue;
        $row['v_05_validation'] = $this->v_05_validation->DefaultValue;
        $row['v_06'] = $this->v_06->DefaultValue;
        $row['v_06_validation'] = $this->v_06_validation->DefaultValue;
        $row['v_07'] = $this->v_07->DefaultValue;
        $row['v_07_validation'] = $this->v_07_validation->DefaultValue;
        $row['v_08'] = $this->v_08->DefaultValue;
        $row['v_08_validation'] = $this->v_08_validation->DefaultValue;
        $row['v_09'] = $this->v_09->DefaultValue;
        $row['v_09_validation'] = $this->v_09_validation->DefaultValue;
        $row['v_10'] = $this->v_10->DefaultValue;
        $row['v_10_validation'] = $this->v_10_validation->DefaultValue;
        $row['b_01_head'] = $this->b_01_head->DefaultValue;
        $row['b_02_head'] = $this->b_02_head->DefaultValue;
        $row['b_03_head'] = $this->b_03_head->DefaultValue;
        $row['b_04_head'] = $this->b_04_head->DefaultValue;
        $row['b_05_head'] = $this->b_05_head->DefaultValue;
        $row['b_06_head'] = $this->b_06_head->DefaultValue;
        $row['b_07_head'] = $this->b_07_head->DefaultValue;
        $row['b_08_head'] = $this->b_08_head->DefaultValue;
        $row['b_09_head'] = $this->b_09_head->DefaultValue;
        $row['b_10_head'] = $this->b_10_head->DefaultValue;
        $row['b_11_head'] = $this->b_11_head->DefaultValue;
        $row['b_12_head'] = $this->b_12_head->DefaultValue;
        $row['b_13_head'] = $this->b_13_head->DefaultValue;
        $row['b_14_head'] = $this->b_14_head->DefaultValue;
        $row['b_15_head'] = $this->b_15_head->DefaultValue;
        $row['q_sku'] = $this->q_sku->DefaultValue;
        $row['t_01_head'] = $this->t_01_head->DefaultValue;
        $row['t_02_head'] = $this->t_02_head->DefaultValue;
        $row['t_03_head'] = $this->t_03_head->DefaultValue;
        $row['t_04_head'] = $this->t_04_head->DefaultValue;
        $row['t_05_head'] = $this->t_05_head->DefaultValue;
        $row['t_06_head'] = $this->t_06_head->DefaultValue;
        $row['t_07_head'] = $this->t_07_head->DefaultValue;
        $row['t_08_head'] = $this->t_08_head->DefaultValue;
        $row['t_09_head'] = $this->t_09_head->DefaultValue;
        $row['t_10_head'] = $this->t_10_head->DefaultValue;
        $row['t_11_head'] = $this->t_11_head->DefaultValue;
        $row['t_12_head'] = $this->t_12_head->DefaultValue;
        $row['t_13_head'] = $this->t_13_head->DefaultValue;
        $row['t_14_head'] = $this->t_14_head->DefaultValue;
        $row['t_15_head'] = $this->t_15_head->DefaultValue;
        $row['po_01_head'] = $this->po_01_head->DefaultValue;
        $row['po_02_head'] = $this->po_02_head->DefaultValue;
        $row['po_03_head'] = $this->po_03_head->DefaultValue;
        $row['po_04_head'] = $this->po_04_head->DefaultValue;
        $row['po_05_head'] = $this->po_05_head->DefaultValue;
        $row['po_06_head'] = $this->po_06_head->DefaultValue;
        $row['po_07_head'] = $this->po_07_head->DefaultValue;
        $row['po_08_head'] = $this->po_08_head->DefaultValue;
        $row['po_17_head'] = $this->po_17_head->DefaultValue;
        $row['po_18_head'] = $this->po_18_head->DefaultValue;
        $row['po_19_head'] = $this->po_19_head->DefaultValue;
        $row['po_20_head'] = $this->po_20_head->DefaultValue;
        $row['jc_01_head'] = $this->jc_01_head->DefaultValue;
        $row['jc_02_head'] = $this->jc_02_head->DefaultValue;
        $row['jc_03_head'] = $this->jc_03_head->DefaultValue;
        $row['jc_04_head'] = $this->jc_04_head->DefaultValue;
        $row['jc_05_head'] = $this->jc_05_head->DefaultValue;
        $row['jc_06_head'] = $this->jc_06_head->DefaultValue;
        $row['jc_07_head'] = $this->jc_07_head->DefaultValue;
        $row['jc_08_head'] = $this->jc_08_head->DefaultValue;
        $row['jc_09_head'] = $this->jc_09_head->DefaultValue;
        $row['jc_10_head'] = $this->jc_10_head->DefaultValue;
        $row['pc_shape'] = $this->pc_shape->DefaultValue;
        $row['pc_unit'] = $this->pc_unit->DefaultValue;
        $row['pc_w'] = $this->pc_w->DefaultValue;
        $row['pc_l'] = $this->pc_l->DefaultValue;
        $row['pc_h'] = $this->pc_h->DefaultValue;
        $row['pc_partner_size'] = $this->pc_partner_size->DefaultValue;
        $row['pc_sqm'] = $this->pc_sqm->DefaultValue;
        $row['pc_01_head'] = $this->pc_01_head->DefaultValue;
        $row['pc_02_head'] = $this->pc_02_head->DefaultValue;
        $row['pc_03_head'] = $this->pc_03_head->DefaultValue;
        $row['pc_04_head'] = $this->pc_04_head->DefaultValue;
        $row['pc_05_head'] = $this->pc_05_head->DefaultValue;
        $row['pc_06_head'] = $this->pc_06_head->DefaultValue;
        $row['pc_07_head'] = $this->pc_07_head->DefaultValue;
        $row['pc_08_head'] = $this->pc_08_head->DefaultValue;
        $row['pc_09_head'] = $this->pc_09_head->DefaultValue;
        $row['pc_10_head'] = $this->pc_10_head->DefaultValue;
        $row['pc_11_head'] = $this->pc_11_head->DefaultValue;
        $row['pc_12_head'] = $this->pc_12_head->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['pa_process_size_w'] = $this->pa_process_size_w->DefaultValue;
        $row['pa_process_size_l'] = $this->pa_process_size_l->DefaultValue;
        $row['pa_head_01'] = $this->pa_head_01->DefaultValue;
        $row['pa_process_01'] = $this->pa_process_01->DefaultValue;
        $row['pa_head_02'] = $this->pa_head_02->DefaultValue;
        $row['pa_process_02'] = $this->pa_process_02->DefaultValue;
        $row['pa_head_03'] = $this->pa_head_03->DefaultValue;
        $row['pa_process_03'] = $this->pa_process_03->DefaultValue;
        $row['pa_head_04'] = $this->pa_head_04->DefaultValue;
        $row['pa_process_04'] = $this->pa_process_04->DefaultValue;
        $row['pa_head_05'] = $this->pa_head_05->DefaultValue;
        $row['pa_process_05'] = $this->pa_process_05->DefaultValue;
        $row['pa_head_06'] = $this->pa_head_06->DefaultValue;
        $row['pa_process_06'] = $this->pa_process_06->DefaultValue;
        $row['pa_head_07'] = $this->pa_head_07->DefaultValue;
        $row['pa_process_07'] = $this->pa_process_07->DefaultValue;
        $row['pa_head_08'] = $this->pa_head_08->DefaultValue;
        $row['pa_process_08'] = $this->pa_process_08->DefaultValue;
        $row['pa_head_09'] = $this->pa_head_09->DefaultValue;
        $row['pa_process_09'] = $this->pa_process_09->DefaultValue;
        $row['pa_head_10'] = $this->pa_head_10->DefaultValue;
        $row['pa_process_10'] = $this->pa_process_10->DefaultValue;
        $row['publish'] = $this->publish->DefaultValue;
        $row['ppr_01'] = $this->ppr_01->DefaultValue;
        $row['ppr_02'] = $this->ppr_02->DefaultValue;
        $row['ppr_03'] = $this->ppr_03->DefaultValue;
        $row['ppr_04'] = $this->ppr_04->DefaultValue;
        $row['ppr_05'] = $this->ppr_05->DefaultValue;
        $row['ppr_06'] = $this->ppr_06->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // product_group
        $this->product_group->RowCssClass = "row";

        // calculation_method
        $this->calculation_method->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // v_00
        $this->v_00->RowCssClass = "row";

        // v_01
        $this->v_01->RowCssClass = "row";

        // v_01_validation
        $this->v_01_validation->RowCssClass = "row";

        // v_02
        $this->v_02->RowCssClass = "row";

        // v_02_validation
        $this->v_02_validation->RowCssClass = "row";

        // v_03
        $this->v_03->RowCssClass = "row";

        // v_03_validation
        $this->v_03_validation->RowCssClass = "row";

        // v_04
        $this->v_04->RowCssClass = "row";

        // v_04_validation
        $this->v_04_validation->RowCssClass = "row";

        // v_05
        $this->v_05->RowCssClass = "row";

        // v_05_validation
        $this->v_05_validation->RowCssClass = "row";

        // v_06
        $this->v_06->RowCssClass = "row";

        // v_06_validation
        $this->v_06_validation->RowCssClass = "row";

        // v_07
        $this->v_07->RowCssClass = "row";

        // v_07_validation
        $this->v_07_validation->RowCssClass = "row";

        // v_08
        $this->v_08->RowCssClass = "row";

        // v_08_validation
        $this->v_08_validation->RowCssClass = "row";

        // v_09
        $this->v_09->RowCssClass = "row";

        // v_09_validation
        $this->v_09_validation->RowCssClass = "row";

        // v_10
        $this->v_10->RowCssClass = "row";

        // v_10_validation
        $this->v_10_validation->RowCssClass = "row";

        // b_01_head
        $this->b_01_head->RowCssClass = "row";

        // b_02_head
        $this->b_02_head->RowCssClass = "row";

        // b_03_head
        $this->b_03_head->RowCssClass = "row";

        // b_04_head
        $this->b_04_head->RowCssClass = "row";

        // b_05_head
        $this->b_05_head->RowCssClass = "row";

        // b_06_head
        $this->b_06_head->RowCssClass = "row";

        // b_07_head
        $this->b_07_head->RowCssClass = "row";

        // b_08_head
        $this->b_08_head->RowCssClass = "row";

        // b_09_head
        $this->b_09_head->RowCssClass = "row";

        // b_10_head
        $this->b_10_head->RowCssClass = "row";

        // b_11_head
        $this->b_11_head->RowCssClass = "row";

        // b_12_head
        $this->b_12_head->RowCssClass = "row";

        // b_13_head
        $this->b_13_head->RowCssClass = "row";

        // b_14_head
        $this->b_14_head->RowCssClass = "row";

        // b_15_head
        $this->b_15_head->RowCssClass = "row";

        // q_sku
        $this->q_sku->RowCssClass = "row";

        // t_01_head
        $this->t_01_head->RowCssClass = "row";

        // t_02_head
        $this->t_02_head->RowCssClass = "row";

        // t_03_head
        $this->t_03_head->RowCssClass = "row";

        // t_04_head
        $this->t_04_head->RowCssClass = "row";

        // t_05_head
        $this->t_05_head->RowCssClass = "row";

        // t_06_head
        $this->t_06_head->RowCssClass = "row";

        // t_07_head
        $this->t_07_head->RowCssClass = "row";

        // t_08_head
        $this->t_08_head->RowCssClass = "row";

        // t_09_head
        $this->t_09_head->RowCssClass = "row";

        // t_10_head
        $this->t_10_head->RowCssClass = "row";

        // t_11_head
        $this->t_11_head->RowCssClass = "row";

        // t_12_head
        $this->t_12_head->RowCssClass = "row";

        // t_13_head
        $this->t_13_head->RowCssClass = "row";

        // t_14_head
        $this->t_14_head->RowCssClass = "row";

        // t_15_head
        $this->t_15_head->RowCssClass = "row";

        // po_01_head
        $this->po_01_head->RowCssClass = "row";

        // po_02_head
        $this->po_02_head->RowCssClass = "row";

        // po_03_head
        $this->po_03_head->RowCssClass = "row";

        // po_04_head
        $this->po_04_head->RowCssClass = "row";

        // po_05_head
        $this->po_05_head->RowCssClass = "row";

        // po_06_head
        $this->po_06_head->RowCssClass = "row";

        // po_07_head
        $this->po_07_head->RowCssClass = "row";

        // po_08_head
        $this->po_08_head->RowCssClass = "row";

        // po_17_head
        $this->po_17_head->RowCssClass = "row";

        // po_18_head
        $this->po_18_head->RowCssClass = "row";

        // po_19_head
        $this->po_19_head->RowCssClass = "row";

        // po_20_head
        $this->po_20_head->RowCssClass = "row";

        // jc_01_head
        $this->jc_01_head->RowCssClass = "row";

        // jc_02_head
        $this->jc_02_head->RowCssClass = "row";

        // jc_03_head
        $this->jc_03_head->RowCssClass = "row";

        // jc_04_head
        $this->jc_04_head->RowCssClass = "row";

        // jc_05_head
        $this->jc_05_head->RowCssClass = "row";

        // jc_06_head
        $this->jc_06_head->RowCssClass = "row";

        // jc_07_head
        $this->jc_07_head->RowCssClass = "row";

        // jc_08_head
        $this->jc_08_head->RowCssClass = "row";

        // jc_09_head
        $this->jc_09_head->RowCssClass = "row";

        // jc_10_head
        $this->jc_10_head->RowCssClass = "row";

        // pc_shape
        $this->pc_shape->RowCssClass = "row";

        // pc_unit
        $this->pc_unit->RowCssClass = "row";

        // pc_w
        $this->pc_w->RowCssClass = "row";

        // pc_l
        $this->pc_l->RowCssClass = "row";

        // pc_h
        $this->pc_h->RowCssClass = "row";

        // pc_partner_size
        $this->pc_partner_size->RowCssClass = "row";

        // pc_sqm
        $this->pc_sqm->RowCssClass = "row";

        // pc_01_head
        $this->pc_01_head->RowCssClass = "row";

        // pc_02_head
        $this->pc_02_head->RowCssClass = "row";

        // pc_03_head
        $this->pc_03_head->RowCssClass = "row";

        // pc_04_head
        $this->pc_04_head->RowCssClass = "row";

        // pc_05_head
        $this->pc_05_head->RowCssClass = "row";

        // pc_06_head
        $this->pc_06_head->RowCssClass = "row";

        // pc_07_head
        $this->pc_07_head->RowCssClass = "row";

        // pc_08_head
        $this->pc_08_head->RowCssClass = "row";

        // pc_09_head
        $this->pc_09_head->RowCssClass = "row";

        // pc_10_head
        $this->pc_10_head->RowCssClass = "row";

        // pc_11_head
        $this->pc_11_head->RowCssClass = "row";

        // pc_12_head
        $this->pc_12_head->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // pa_process_size_w
        $this->pa_process_size_w->RowCssClass = "row";

        // pa_process_size_l
        $this->pa_process_size_l->RowCssClass = "row";

        // pa_head_01
        $this->pa_head_01->RowCssClass = "row";

        // pa_process_01
        $this->pa_process_01->RowCssClass = "row";

        // pa_head_02
        $this->pa_head_02->RowCssClass = "row";

        // pa_process_02
        $this->pa_process_02->RowCssClass = "row";

        // pa_head_03
        $this->pa_head_03->RowCssClass = "row";

        // pa_process_03
        $this->pa_process_03->RowCssClass = "row";

        // pa_head_04
        $this->pa_head_04->RowCssClass = "row";

        // pa_process_04
        $this->pa_process_04->RowCssClass = "row";

        // pa_head_05
        $this->pa_head_05->RowCssClass = "row";

        // pa_process_05
        $this->pa_process_05->RowCssClass = "row";

        // pa_head_06
        $this->pa_head_06->RowCssClass = "row";

        // pa_process_06
        $this->pa_process_06->RowCssClass = "row";

        // pa_head_07
        $this->pa_head_07->RowCssClass = "row";

        // pa_process_07
        $this->pa_process_07->RowCssClass = "row";

        // pa_head_08
        $this->pa_head_08->RowCssClass = "row";

        // pa_process_08
        $this->pa_process_08->RowCssClass = "row";

        // pa_head_09
        $this->pa_head_09->RowCssClass = "row";

        // pa_process_09
        $this->pa_process_09->RowCssClass = "row";

        // pa_head_10
        $this->pa_head_10->RowCssClass = "row";

        // pa_process_10
        $this->pa_process_10->RowCssClass = "row";

        // publish
        $this->publish->RowCssClass = "row";

        // ppr_01
        $this->ppr_01->RowCssClass = "row";

        // ppr_02
        $this->ppr_02->RowCssClass = "row";

        // ppr_03
        $this->ppr_03->RowCssClass = "row";

        // ppr_04
        $this->ppr_04->RowCssClass = "row";

        // ppr_05
        $this->ppr_05->RowCssClass = "row";

        // ppr_06
        $this->ppr_06->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // product_group
            $this->product_group->ViewValue = $this->product_group->CurrentValue;

            // calculation_method
            $curVal = strval($this->calculation_method->CurrentValue);
            if ($curVal != "") {
                $this->calculation_method->ViewValue = $this->calculation_method->lookupCacheOption($curVal);
                if ($this->calculation_method->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->calculation_method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->calculation_method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->calculation_method->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->calculation_method->Lookup->renderViewRow($rswrk[0]);
                        $this->calculation_method->ViewValue = $this->calculation_method->displayValue($arwrk);
                    } else {
                        $this->calculation_method->ViewValue = FormatNumber($this->calculation_method->CurrentValue, $this->calculation_method->formatPattern());
                    }
                }
            } else {
                $this->calculation_method->ViewValue = null;
            }

            // shape
            $this->shape->ViewValue = $this->shape->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // v_00
            $this->v_00->ViewValue = $this->v_00->CurrentValue;

            // v_01
            $this->v_01->ViewValue = $this->v_01->CurrentValue;

            // v_01_validation
            $this->v_01_validation->ViewValue = $this->v_01_validation->CurrentValue;

            // v_02
            $this->v_02->ViewValue = $this->v_02->CurrentValue;

            // v_02_validation
            $this->v_02_validation->ViewValue = $this->v_02_validation->CurrentValue;

            // v_03
            $this->v_03->ViewValue = $this->v_03->CurrentValue;

            // v_03_validation
            $this->v_03_validation->ViewValue = $this->v_03_validation->CurrentValue;

            // v_04
            $this->v_04->ViewValue = $this->v_04->CurrentValue;

            // v_04_validation
            $this->v_04_validation->ViewValue = $this->v_04_validation->CurrentValue;

            // v_05
            $this->v_05->ViewValue = $this->v_05->CurrentValue;

            // v_05_validation
            $this->v_05_validation->ViewValue = $this->v_05_validation->CurrentValue;

            // v_06
            $this->v_06->ViewValue = $this->v_06->CurrentValue;

            // v_06_validation
            $this->v_06_validation->ViewValue = $this->v_06_validation->CurrentValue;

            // v_07
            $this->v_07->ViewValue = $this->v_07->CurrentValue;

            // v_07_validation
            $this->v_07_validation->ViewValue = $this->v_07_validation->CurrentValue;

            // v_08
            $this->v_08->ViewValue = $this->v_08->CurrentValue;

            // v_08_validation
            $this->v_08_validation->ViewValue = $this->v_08_validation->CurrentValue;

            // v_09
            $this->v_09->ViewValue = $this->v_09->CurrentValue;

            // v_09_validation
            $this->v_09_validation->ViewValue = $this->v_09_validation->CurrentValue;

            // v_10
            $this->v_10->ViewValue = $this->v_10->CurrentValue;

            // v_10_validation
            $this->v_10_validation->ViewValue = $this->v_10_validation->CurrentValue;

            // b_01_head
            $this->b_01_head->ViewValue = $this->b_01_head->CurrentValue;

            // b_02_head
            $this->b_02_head->ViewValue = $this->b_02_head->CurrentValue;

            // b_03_head
            $this->b_03_head->ViewValue = $this->b_03_head->CurrentValue;

            // b_04_head
            $this->b_04_head->ViewValue = $this->b_04_head->CurrentValue;

            // b_05_head
            $this->b_05_head->ViewValue = $this->b_05_head->CurrentValue;

            // b_06_head
            $this->b_06_head->ViewValue = $this->b_06_head->CurrentValue;

            // b_07_head
            $this->b_07_head->ViewValue = $this->b_07_head->CurrentValue;

            // b_08_head
            $this->b_08_head->ViewValue = $this->b_08_head->CurrentValue;

            // b_09_head
            $this->b_09_head->ViewValue = $this->b_09_head->CurrentValue;

            // b_10_head
            $this->b_10_head->ViewValue = $this->b_10_head->CurrentValue;

            // b_11_head
            $this->b_11_head->ViewValue = $this->b_11_head->CurrentValue;

            // b_12_head
            $this->b_12_head->ViewValue = $this->b_12_head->CurrentValue;

            // b_13_head
            $this->b_13_head->ViewValue = $this->b_13_head->CurrentValue;

            // b_14_head
            $this->b_14_head->ViewValue = $this->b_14_head->CurrentValue;

            // b_15_head
            $this->b_15_head->ViewValue = $this->b_15_head->CurrentValue;

            // q_sku
            $this->q_sku->ViewValue = $this->q_sku->CurrentValue;

            // t_01_head
            $this->t_01_head->ViewValue = $this->t_01_head->CurrentValue;

            // t_02_head
            $this->t_02_head->ViewValue = $this->t_02_head->CurrentValue;

            // t_03_head
            $this->t_03_head->ViewValue = $this->t_03_head->CurrentValue;

            // t_04_head
            $this->t_04_head->ViewValue = $this->t_04_head->CurrentValue;

            // t_05_head
            $this->t_05_head->ViewValue = $this->t_05_head->CurrentValue;

            // t_06_head
            $this->t_06_head->ViewValue = $this->t_06_head->CurrentValue;

            // t_07_head
            $this->t_07_head->ViewValue = $this->t_07_head->CurrentValue;

            // t_08_head
            $this->t_08_head->ViewValue = $this->t_08_head->CurrentValue;

            // t_09_head
            $this->t_09_head->ViewValue = $this->t_09_head->CurrentValue;

            // t_10_head
            $this->t_10_head->ViewValue = $this->t_10_head->CurrentValue;

            // t_11_head
            $this->t_11_head->ViewValue = $this->t_11_head->CurrentValue;

            // t_12_head
            $this->t_12_head->ViewValue = $this->t_12_head->CurrentValue;

            // t_13_head
            $this->t_13_head->ViewValue = $this->t_13_head->CurrentValue;

            // t_14_head
            $this->t_14_head->ViewValue = $this->t_14_head->CurrentValue;

            // t_15_head
            $this->t_15_head->ViewValue = $this->t_15_head->CurrentValue;

            // po_01_head
            $this->po_01_head->ViewValue = $this->po_01_head->CurrentValue;

            // po_02_head
            $this->po_02_head->ViewValue = $this->po_02_head->CurrentValue;

            // po_03_head
            $this->po_03_head->ViewValue = $this->po_03_head->CurrentValue;

            // po_04_head
            $this->po_04_head->ViewValue = $this->po_04_head->CurrentValue;

            // po_05_head
            $this->po_05_head->ViewValue = $this->po_05_head->CurrentValue;

            // po_06_head
            $this->po_06_head->ViewValue = $this->po_06_head->CurrentValue;

            // po_07_head
            $this->po_07_head->ViewValue = $this->po_07_head->CurrentValue;

            // po_08_head
            $this->po_08_head->ViewValue = $this->po_08_head->CurrentValue;

            // po_17_head
            $this->po_17_head->ViewValue = $this->po_17_head->CurrentValue;

            // po_18_head
            $this->po_18_head->ViewValue = $this->po_18_head->CurrentValue;

            // po_19_head
            $this->po_19_head->ViewValue = $this->po_19_head->CurrentValue;

            // po_20_head
            $this->po_20_head->ViewValue = $this->po_20_head->CurrentValue;

            // jc_01_head
            $this->jc_01_head->ViewValue = $this->jc_01_head->CurrentValue;

            // jc_02_head
            $this->jc_02_head->ViewValue = $this->jc_02_head->CurrentValue;

            // jc_03_head
            $this->jc_03_head->ViewValue = $this->jc_03_head->CurrentValue;

            // jc_04_head
            $this->jc_04_head->ViewValue = $this->jc_04_head->CurrentValue;

            // jc_05_head
            $this->jc_05_head->ViewValue = $this->jc_05_head->CurrentValue;

            // jc_06_head
            $this->jc_06_head->ViewValue = $this->jc_06_head->CurrentValue;

            // jc_07_head
            $this->jc_07_head->ViewValue = $this->jc_07_head->CurrentValue;

            // jc_08_head
            $this->jc_08_head->ViewValue = $this->jc_08_head->CurrentValue;

            // jc_09_head
            $this->jc_09_head->ViewValue = $this->jc_09_head->CurrentValue;

            // jc_10_head
            $this->jc_10_head->ViewValue = $this->jc_10_head->CurrentValue;

            // pc_shape
            $this->pc_shape->ViewValue = $this->pc_shape->CurrentValue;

            // pc_unit
            $this->pc_unit->ViewValue = $this->pc_unit->CurrentValue;

            // pc_w
            $this->pc_w->ViewValue = $this->pc_w->CurrentValue;

            // pc_l
            $this->pc_l->ViewValue = $this->pc_l->CurrentValue;

            // pc_h
            $this->pc_h->ViewValue = $this->pc_h->CurrentValue;

            // pc_partner_size
            $this->pc_partner_size->ViewValue = $this->pc_partner_size->CurrentValue;

            // pc_sqm
            $this->pc_sqm->ViewValue = $this->pc_sqm->CurrentValue;

            // pc_01_head
            $this->pc_01_head->ViewValue = $this->pc_01_head->CurrentValue;

            // pc_02_head
            $this->pc_02_head->ViewValue = $this->pc_02_head->CurrentValue;

            // pc_03_head
            $this->pc_03_head->ViewValue = $this->pc_03_head->CurrentValue;

            // pc_04_head
            $this->pc_04_head->ViewValue = $this->pc_04_head->CurrentValue;

            // pc_05_head
            $this->pc_05_head->ViewValue = $this->pc_05_head->CurrentValue;

            // pc_06_head
            $this->pc_06_head->ViewValue = $this->pc_06_head->CurrentValue;

            // pc_07_head
            $this->pc_07_head->ViewValue = $this->pc_07_head->CurrentValue;

            // pc_08_head
            $this->pc_08_head->ViewValue = $this->pc_08_head->CurrentValue;

            // pc_09_head
            $this->pc_09_head->ViewValue = $this->pc_09_head->CurrentValue;

            // pc_10_head
            $this->pc_10_head->ViewValue = $this->pc_10_head->CurrentValue;

            // pc_11_head
            $this->pc_11_head->ViewValue = $this->pc_11_head->CurrentValue;

            // pc_12_head
            $this->pc_12_head->ViewValue = $this->pc_12_head->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ImageWidth = 0;
                $this->image->ImageHeight = 50;
                $this->image->ImageAlt = $this->image->alt();
                $this->image->ImageCssClass = "ew-image";
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // pa_process_size_w
            $this->pa_process_size_w->ViewValue = $this->pa_process_size_w->CurrentValue;

            // pa_process_size_l
            $this->pa_process_size_l->ViewValue = $this->pa_process_size_l->CurrentValue;

            // pa_head_01
            $this->pa_head_01->ViewValue = $this->pa_head_01->CurrentValue;

            // pa_process_01
            $curVal = strval($this->pa_process_01->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_01->ViewValue = $this->pa_process_01->lookupCacheOption($curVal);
                if ($this->pa_process_01->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_01->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_01->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_01->Lookup->renderViewRow($row);
                            $this->pa_process_01->ViewValue->add($this->pa_process_01->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_01->ViewValue = $this->pa_process_01->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_01->ViewValue = null;
            }

            // pa_head_02
            $this->pa_head_02->ViewValue = $this->pa_head_02->CurrentValue;

            // pa_process_02
            $curVal = strval($this->pa_process_02->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_02->ViewValue = $this->pa_process_02->lookupCacheOption($curVal);
                if ($this->pa_process_02->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_02->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_02->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_02->Lookup->renderViewRow($row);
                            $this->pa_process_02->ViewValue->add($this->pa_process_02->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_02->ViewValue = $this->pa_process_02->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_02->ViewValue = null;
            }

            // pa_head_03
            $this->pa_head_03->ViewValue = $this->pa_head_03->CurrentValue;

            // pa_process_03
            $curVal = strval($this->pa_process_03->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_03->ViewValue = $this->pa_process_03->lookupCacheOption($curVal);
                if ($this->pa_process_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_03->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_03->Lookup->renderViewRow($row);
                            $this->pa_process_03->ViewValue->add($this->pa_process_03->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_03->ViewValue = $this->pa_process_03->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_03->ViewValue = null;
            }

            // pa_head_04
            $this->pa_head_04->ViewValue = $this->pa_head_04->CurrentValue;

            // pa_process_04
            $curVal = strval($this->pa_process_04->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_04->ViewValue = $this->pa_process_04->lookupCacheOption($curVal);
                if ($this->pa_process_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_04->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_04->Lookup->renderViewRow($row);
                            $this->pa_process_04->ViewValue->add($this->pa_process_04->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_04->ViewValue = $this->pa_process_04->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_04->ViewValue = null;
            }

            // pa_head_05
            $this->pa_head_05->ViewValue = $this->pa_head_05->CurrentValue;

            // pa_process_05
            $curVal = strval($this->pa_process_05->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_05->ViewValue = $this->pa_process_05->lookupCacheOption($curVal);
                if ($this->pa_process_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_05->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_05->Lookup->renderViewRow($row);
                            $this->pa_process_05->ViewValue->add($this->pa_process_05->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_05->ViewValue = $this->pa_process_05->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_05->ViewValue = null;
            }

            // pa_head_06
            $this->pa_head_06->ViewValue = $this->pa_head_06->CurrentValue;

            // pa_process_06
            $curVal = strval($this->pa_process_06->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_06->ViewValue = $this->pa_process_06->lookupCacheOption($curVal);
                if ($this->pa_process_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_06->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_06->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_06->Lookup->renderViewRow($row);
                            $this->pa_process_06->ViewValue->add($this->pa_process_06->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_06->ViewValue = $this->pa_process_06->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_06->ViewValue = null;
            }

            // pa_head_07
            $this->pa_head_07->ViewValue = $this->pa_head_07->CurrentValue;

            // pa_process_07
            $curVal = strval($this->pa_process_07->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_07->ViewValue = $this->pa_process_07->lookupCacheOption($curVal);
                if ($this->pa_process_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_07->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_07->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_07->Lookup->renderViewRow($row);
                            $this->pa_process_07->ViewValue->add($this->pa_process_07->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_07->ViewValue = $this->pa_process_07->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_07->ViewValue = null;
            }

            // pa_head_08
            $this->pa_head_08->ViewValue = $this->pa_head_08->CurrentValue;

            // pa_process_08
            $curVal = strval($this->pa_process_08->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_08->ViewValue = $this->pa_process_08->lookupCacheOption($curVal);
                if ($this->pa_process_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_08->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_08->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_08->Lookup->renderViewRow($row);
                            $this->pa_process_08->ViewValue->add($this->pa_process_08->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_08->ViewValue = $this->pa_process_08->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_08->ViewValue = null;
            }

            // pa_head_09
            $this->pa_head_09->ViewValue = $this->pa_head_09->CurrentValue;

            // pa_process_09
            $curVal = strval($this->pa_process_09->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_09->ViewValue = $this->pa_process_09->lookupCacheOption($curVal);
                if ($this->pa_process_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_09->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_09->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_09->Lookup->renderViewRow($row);
                            $this->pa_process_09->ViewValue->add($this->pa_process_09->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_09->ViewValue = $this->pa_process_09->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_09->ViewValue = null;
            }

            // pa_head_10
            $this->pa_head_10->ViewValue = $this->pa_head_10->CurrentValue;

            // pa_process_10
            $curVal = strval($this->pa_process_10->CurrentValue);
            if ($curVal != "") {
                $this->pa_process_10->ViewValue = $this->pa_process_10->lookupCacheOption($curVal);
                if ($this->pa_process_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_10->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_10->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->pa_process_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_process_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->pa_process_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->pa_process_10->Lookup->renderViewRow($row);
                            $this->pa_process_10->ViewValue->add($this->pa_process_10->displayValue($arwrk));
                        }
                    } else {
                        $this->pa_process_10->ViewValue = $this->pa_process_10->CurrentValue;
                    }
                }
            } else {
                $this->pa_process_10->ViewValue = null;
            }

            // publish
            $this->publish->ViewValue = $this->publish->CurrentValue;
            $this->publish->ViewValue = FormatNumber($this->publish->ViewValue, $this->publish->formatPattern());

            // ppr_01
            $this->ppr_01->ViewValue = $this->ppr_01->CurrentValue;

            // ppr_02
            $this->ppr_02->ViewValue = $this->ppr_02->CurrentValue;

            // ppr_03
            $this->ppr_03->ViewValue = $this->ppr_03->CurrentValue;

            // ppr_04
            $this->ppr_04->ViewValue = $this->ppr_04->CurrentValue;

            // ppr_05
            $this->ppr_05->ViewValue = $this->ppr_05->CurrentValue;

            // ppr_06
            $this->ppr_06->ViewValue = $this->ppr_06->CurrentValue;

            // id
            $this->id->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // product_group
            $this->product_group->HrefValue = "";

            // calculation_method
            $this->calculation_method->HrefValue = "";

            // shape
            $this->shape->HrefValue = "";

            // sqm
            $this->sqm->HrefValue = "";

            // cbm
            $this->cbm->HrefValue = "";

            // process
            $this->process->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // v_00
            $this->v_00->HrefValue = "";

            // v_01
            $this->v_01->HrefValue = "";

            // v_01_validation
            $this->v_01_validation->HrefValue = "";

            // v_02
            $this->v_02->HrefValue = "";

            // v_02_validation
            $this->v_02_validation->HrefValue = "";

            // v_03
            $this->v_03->HrefValue = "";

            // v_03_validation
            $this->v_03_validation->HrefValue = "";

            // v_04
            $this->v_04->HrefValue = "";

            // v_04_validation
            $this->v_04_validation->HrefValue = "";

            // v_05
            $this->v_05->HrefValue = "";

            // v_05_validation
            $this->v_05_validation->HrefValue = "";

            // v_06
            $this->v_06->HrefValue = "";

            // v_06_validation
            $this->v_06_validation->HrefValue = "";

            // v_07
            $this->v_07->HrefValue = "";

            // v_07_validation
            $this->v_07_validation->HrefValue = "";

            // v_08
            $this->v_08->HrefValue = "";

            // v_08_validation
            $this->v_08_validation->HrefValue = "";

            // v_09
            $this->v_09->HrefValue = "";

            // v_09_validation
            $this->v_09_validation->HrefValue = "";

            // v_10
            $this->v_10->HrefValue = "";

            // v_10_validation
            $this->v_10_validation->HrefValue = "";

            // b_01_head
            $this->b_01_head->HrefValue = "";

            // b_02_head
            $this->b_02_head->HrefValue = "";

            // b_03_head
            $this->b_03_head->HrefValue = "";

            // b_04_head
            $this->b_04_head->HrefValue = "";

            // b_05_head
            $this->b_05_head->HrefValue = "";

            // b_06_head
            $this->b_06_head->HrefValue = "";

            // b_07_head
            $this->b_07_head->HrefValue = "";

            // b_08_head
            $this->b_08_head->HrefValue = "";

            // b_09_head
            $this->b_09_head->HrefValue = "";

            // b_10_head
            $this->b_10_head->HrefValue = "";

            // b_11_head
            $this->b_11_head->HrefValue = "";

            // b_12_head
            $this->b_12_head->HrefValue = "";

            // b_13_head
            $this->b_13_head->HrefValue = "";

            // b_14_head
            $this->b_14_head->HrefValue = "";

            // b_15_head
            $this->b_15_head->HrefValue = "";

            // q_sku
            $this->q_sku->HrefValue = "";

            // t_01_head
            $this->t_01_head->HrefValue = "";

            // t_02_head
            $this->t_02_head->HrefValue = "";

            // t_03_head
            $this->t_03_head->HrefValue = "";

            // t_04_head
            $this->t_04_head->HrefValue = "";

            // t_05_head
            $this->t_05_head->HrefValue = "";

            // t_06_head
            $this->t_06_head->HrefValue = "";

            // t_07_head
            $this->t_07_head->HrefValue = "";

            // t_08_head
            $this->t_08_head->HrefValue = "";

            // t_09_head
            $this->t_09_head->HrefValue = "";

            // t_10_head
            $this->t_10_head->HrefValue = "";

            // t_11_head
            $this->t_11_head->HrefValue = "";

            // t_12_head
            $this->t_12_head->HrefValue = "";

            // t_13_head
            $this->t_13_head->HrefValue = "";

            // t_14_head
            $this->t_14_head->HrefValue = "";

            // t_15_head
            $this->t_15_head->HrefValue = "";

            // po_01_head
            $this->po_01_head->HrefValue = "";

            // po_02_head
            $this->po_02_head->HrefValue = "";

            // po_03_head
            $this->po_03_head->HrefValue = "";

            // po_04_head
            $this->po_04_head->HrefValue = "";

            // po_05_head
            $this->po_05_head->HrefValue = "";

            // po_06_head
            $this->po_06_head->HrefValue = "";

            // po_07_head
            $this->po_07_head->HrefValue = "";

            // po_08_head
            $this->po_08_head->HrefValue = "";

            // po_17_head
            $this->po_17_head->HrefValue = "";

            // po_18_head
            $this->po_18_head->HrefValue = "";

            // po_19_head
            $this->po_19_head->HrefValue = "";

            // po_20_head
            $this->po_20_head->HrefValue = "";

            // jc_01_head
            $this->jc_01_head->HrefValue = "";

            // jc_02_head
            $this->jc_02_head->HrefValue = "";

            // jc_03_head
            $this->jc_03_head->HrefValue = "";

            // jc_04_head
            $this->jc_04_head->HrefValue = "";

            // jc_05_head
            $this->jc_05_head->HrefValue = "";

            // jc_06_head
            $this->jc_06_head->HrefValue = "";

            // jc_07_head
            $this->jc_07_head->HrefValue = "";

            // jc_08_head
            $this->jc_08_head->HrefValue = "";

            // jc_09_head
            $this->jc_09_head->HrefValue = "";

            // jc_10_head
            $this->jc_10_head->HrefValue = "";

            // pc_shape
            $this->pc_shape->HrefValue = "";

            // pc_unit
            $this->pc_unit->HrefValue = "";

            // pc_w
            $this->pc_w->HrefValue = "";

            // pc_l
            $this->pc_l->HrefValue = "";

            // pc_h
            $this->pc_h->HrefValue = "";

            // pc_partner_size
            $this->pc_partner_size->HrefValue = "";

            // pc_sqm
            $this->pc_sqm->HrefValue = "";

            // pc_01_head
            $this->pc_01_head->HrefValue = "";

            // pc_02_head
            $this->pc_02_head->HrefValue = "";

            // pc_03_head
            $this->pc_03_head->HrefValue = "";

            // pc_04_head
            $this->pc_04_head->HrefValue = "";

            // pc_05_head
            $this->pc_05_head->HrefValue = "";

            // pc_06_head
            $this->pc_06_head->HrefValue = "";

            // pc_07_head
            $this->pc_07_head->HrefValue = "";

            // pc_08_head
            $this->pc_08_head->HrefValue = "";

            // pc_09_head
            $this->pc_09_head->HrefValue = "";

            // pc_10_head
            $this->pc_10_head->HrefValue = "";

            // pc_11_head
            $this->pc_11_head->HrefValue = "";

            // pc_12_head
            $this->pc_12_head->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->htmlDecode($this->image->Upload->DbValue)); // Add prefix/suffix
                $this->image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
                }
            } else {
                $this->image->HrefValue = "";
            }
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

            // pa_process_size_w
            $this->pa_process_size_w->HrefValue = "";

            // pa_process_size_l
            $this->pa_process_size_l->HrefValue = "";

            // pa_head_01
            $this->pa_head_01->HrefValue = "";

            // pa_process_01
            $this->pa_process_01->HrefValue = "";

            // pa_head_02
            $this->pa_head_02->HrefValue = "";

            // pa_process_02
            $this->pa_process_02->HrefValue = "";

            // pa_head_03
            $this->pa_head_03->HrefValue = "";

            // pa_process_03
            $this->pa_process_03->HrefValue = "";

            // pa_head_04
            $this->pa_head_04->HrefValue = "";

            // pa_process_04
            $this->pa_process_04->HrefValue = "";

            // pa_head_05
            $this->pa_head_05->HrefValue = "";

            // pa_process_05
            $this->pa_process_05->HrefValue = "";

            // pa_head_06
            $this->pa_head_06->HrefValue = "";

            // pa_process_06
            $this->pa_process_06->HrefValue = "";

            // pa_head_07
            $this->pa_head_07->HrefValue = "";

            // pa_process_07
            $this->pa_process_07->HrefValue = "";

            // pa_head_08
            $this->pa_head_08->HrefValue = "";

            // pa_process_08
            $this->pa_process_08->HrefValue = "";

            // pa_head_09
            $this->pa_head_09->HrefValue = "";

            // pa_process_09
            $this->pa_process_09->HrefValue = "";

            // pa_head_10
            $this->pa_head_10->HrefValue = "";

            // pa_process_10
            $this->pa_process_10->HrefValue = "";

            // publish
            $this->publish->HrefValue = "";

            // ppr_01
            $this->ppr_01->HrefValue = "";

            // ppr_02
            $this->ppr_02->HrefValue = "";

            // ppr_03
            $this->ppr_03->HrefValue = "";

            // ppr_04
            $this->ppr_04->HrefValue = "";

            // ppr_05
            $this->ppr_05->HrefValue = "";

            // ppr_06
            $this->ppr_06->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // product_group
            $this->product_group->setupEditAttributes();
            if (!$this->product_group->Raw) {
                $this->product_group->CurrentValue = HtmlDecode($this->product_group->CurrentValue);
            }
            $this->product_group->EditValue = HtmlEncode($this->product_group->CurrentValue);
            $this->product_group->PlaceHolder = RemoveHtml($this->product_group->caption());

            // calculation_method
            $this->calculation_method->setupEditAttributes();
            $curVal = trim(strval($this->calculation_method->CurrentValue));
            if ($curVal != "") {
                $this->calculation_method->ViewValue = $this->calculation_method->lookupCacheOption($curVal);
            } else {
                $this->calculation_method->ViewValue = $this->calculation_method->Lookup !== null && is_array($this->calculation_method->lookupOptions()) && count($this->calculation_method->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->calculation_method->ViewValue !== null) { // Load from cache
                $this->calculation_method->EditValue = array_values($this->calculation_method->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->calculation_method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->calculation_method->CurrentValue, $this->calculation_method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->calculation_method->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->calculation_method->EditValue = $arwrk;
            }
            $this->calculation_method->PlaceHolder = RemoveHtml($this->calculation_method->caption());

            // shape
            $this->shape->setupEditAttributes();
            if (!$this->shape->Raw) {
                $this->shape->CurrentValue = HtmlDecode($this->shape->CurrentValue);
            }
            $this->shape->EditValue = HtmlEncode($this->shape->CurrentValue);
            $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            if (!$this->sqm->Raw) {
                $this->sqm->CurrentValue = HtmlDecode($this->sqm->CurrentValue);
            }
            $this->sqm->EditValue = HtmlEncode($this->sqm->CurrentValue);
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

            // cbm
            $this->cbm->setupEditAttributes();
            if (!$this->cbm->Raw) {
                $this->cbm->CurrentValue = HtmlDecode($this->cbm->CurrentValue);
            }
            $this->cbm->EditValue = HtmlEncode($this->cbm->CurrentValue);
            $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

            // process
            $this->process->setupEditAttributes();
            $curVal = trim(strval($this->process->CurrentValue));
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            } else {
                $this->process->ViewValue = $this->process->Lookup !== null && is_array($this->process->lookupOptions()) && count($this->process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process->ViewValue !== null) { // Load from cache
                $this->process->EditValue = array_values($this->process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->process->CurrentValue, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process->EditValue = $arwrk;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // v_00
            $this->v_00->setupEditAttributes();
            if (!$this->v_00->Raw) {
                $this->v_00->CurrentValue = HtmlDecode($this->v_00->CurrentValue);
            }
            $this->v_00->EditValue = HtmlEncode($this->v_00->CurrentValue);
            $this->v_00->PlaceHolder = RemoveHtml($this->v_00->caption());

            // v_01
            $this->v_01->setupEditAttributes();
            if (!$this->v_01->Raw) {
                $this->v_01->CurrentValue = HtmlDecode($this->v_01->CurrentValue);
            }
            $this->v_01->EditValue = HtmlEncode($this->v_01->CurrentValue);
            $this->v_01->PlaceHolder = RemoveHtml($this->v_01->caption());

            // v_01_validation
            $this->v_01_validation->setupEditAttributes();
            if (!$this->v_01_validation->Raw) {
                $this->v_01_validation->CurrentValue = HtmlDecode($this->v_01_validation->CurrentValue);
            }
            $this->v_01_validation->EditValue = HtmlEncode($this->v_01_validation->CurrentValue);
            $this->v_01_validation->PlaceHolder = RemoveHtml($this->v_01_validation->caption());

            // v_02
            $this->v_02->setupEditAttributes();
            if (!$this->v_02->Raw) {
                $this->v_02->CurrentValue = HtmlDecode($this->v_02->CurrentValue);
            }
            $this->v_02->EditValue = HtmlEncode($this->v_02->CurrentValue);
            $this->v_02->PlaceHolder = RemoveHtml($this->v_02->caption());

            // v_02_validation
            $this->v_02_validation->setupEditAttributes();
            if (!$this->v_02_validation->Raw) {
                $this->v_02_validation->CurrentValue = HtmlDecode($this->v_02_validation->CurrentValue);
            }
            $this->v_02_validation->EditValue = HtmlEncode($this->v_02_validation->CurrentValue);
            $this->v_02_validation->PlaceHolder = RemoveHtml($this->v_02_validation->caption());

            // v_03
            $this->v_03->setupEditAttributes();
            if (!$this->v_03->Raw) {
                $this->v_03->CurrentValue = HtmlDecode($this->v_03->CurrentValue);
            }
            $this->v_03->EditValue = HtmlEncode($this->v_03->CurrentValue);
            $this->v_03->PlaceHolder = RemoveHtml($this->v_03->caption());

            // v_03_validation
            $this->v_03_validation->setupEditAttributes();
            if (!$this->v_03_validation->Raw) {
                $this->v_03_validation->CurrentValue = HtmlDecode($this->v_03_validation->CurrentValue);
            }
            $this->v_03_validation->EditValue = HtmlEncode($this->v_03_validation->CurrentValue);
            $this->v_03_validation->PlaceHolder = RemoveHtml($this->v_03_validation->caption());

            // v_04
            $this->v_04->setupEditAttributes();
            if (!$this->v_04->Raw) {
                $this->v_04->CurrentValue = HtmlDecode($this->v_04->CurrentValue);
            }
            $this->v_04->EditValue = HtmlEncode($this->v_04->CurrentValue);
            $this->v_04->PlaceHolder = RemoveHtml($this->v_04->caption());

            // v_04_validation
            $this->v_04_validation->setupEditAttributes();
            if (!$this->v_04_validation->Raw) {
                $this->v_04_validation->CurrentValue = HtmlDecode($this->v_04_validation->CurrentValue);
            }
            $this->v_04_validation->EditValue = HtmlEncode($this->v_04_validation->CurrentValue);
            $this->v_04_validation->PlaceHolder = RemoveHtml($this->v_04_validation->caption());

            // v_05
            $this->v_05->setupEditAttributes();
            if (!$this->v_05->Raw) {
                $this->v_05->CurrentValue = HtmlDecode($this->v_05->CurrentValue);
            }
            $this->v_05->EditValue = HtmlEncode($this->v_05->CurrentValue);
            $this->v_05->PlaceHolder = RemoveHtml($this->v_05->caption());

            // v_05_validation
            $this->v_05_validation->setupEditAttributes();
            if (!$this->v_05_validation->Raw) {
                $this->v_05_validation->CurrentValue = HtmlDecode($this->v_05_validation->CurrentValue);
            }
            $this->v_05_validation->EditValue = HtmlEncode($this->v_05_validation->CurrentValue);
            $this->v_05_validation->PlaceHolder = RemoveHtml($this->v_05_validation->caption());

            // v_06
            $this->v_06->setupEditAttributes();
            if (!$this->v_06->Raw) {
                $this->v_06->CurrentValue = HtmlDecode($this->v_06->CurrentValue);
            }
            $this->v_06->EditValue = HtmlEncode($this->v_06->CurrentValue);
            $this->v_06->PlaceHolder = RemoveHtml($this->v_06->caption());

            // v_06_validation
            $this->v_06_validation->setupEditAttributes();
            if (!$this->v_06_validation->Raw) {
                $this->v_06_validation->CurrentValue = HtmlDecode($this->v_06_validation->CurrentValue);
            }
            $this->v_06_validation->EditValue = HtmlEncode($this->v_06_validation->CurrentValue);
            $this->v_06_validation->PlaceHolder = RemoveHtml($this->v_06_validation->caption());

            // v_07
            $this->v_07->setupEditAttributes();
            if (!$this->v_07->Raw) {
                $this->v_07->CurrentValue = HtmlDecode($this->v_07->CurrentValue);
            }
            $this->v_07->EditValue = HtmlEncode($this->v_07->CurrentValue);
            $this->v_07->PlaceHolder = RemoveHtml($this->v_07->caption());

            // v_07_validation
            $this->v_07_validation->setupEditAttributes();
            if (!$this->v_07_validation->Raw) {
                $this->v_07_validation->CurrentValue = HtmlDecode($this->v_07_validation->CurrentValue);
            }
            $this->v_07_validation->EditValue = HtmlEncode($this->v_07_validation->CurrentValue);
            $this->v_07_validation->PlaceHolder = RemoveHtml($this->v_07_validation->caption());

            // v_08
            $this->v_08->setupEditAttributes();
            if (!$this->v_08->Raw) {
                $this->v_08->CurrentValue = HtmlDecode($this->v_08->CurrentValue);
            }
            $this->v_08->EditValue = HtmlEncode($this->v_08->CurrentValue);
            $this->v_08->PlaceHolder = RemoveHtml($this->v_08->caption());

            // v_08_validation
            $this->v_08_validation->setupEditAttributes();
            if (!$this->v_08_validation->Raw) {
                $this->v_08_validation->CurrentValue = HtmlDecode($this->v_08_validation->CurrentValue);
            }
            $this->v_08_validation->EditValue = HtmlEncode($this->v_08_validation->CurrentValue);
            $this->v_08_validation->PlaceHolder = RemoveHtml($this->v_08_validation->caption());

            // v_09
            $this->v_09->setupEditAttributes();
            if (!$this->v_09->Raw) {
                $this->v_09->CurrentValue = HtmlDecode($this->v_09->CurrentValue);
            }
            $this->v_09->EditValue = HtmlEncode($this->v_09->CurrentValue);
            $this->v_09->PlaceHolder = RemoveHtml($this->v_09->caption());

            // v_09_validation
            $this->v_09_validation->setupEditAttributes();
            if (!$this->v_09_validation->Raw) {
                $this->v_09_validation->CurrentValue = HtmlDecode($this->v_09_validation->CurrentValue);
            }
            $this->v_09_validation->EditValue = HtmlEncode($this->v_09_validation->CurrentValue);
            $this->v_09_validation->PlaceHolder = RemoveHtml($this->v_09_validation->caption());

            // v_10
            $this->v_10->setupEditAttributes();
            if (!$this->v_10->Raw) {
                $this->v_10->CurrentValue = HtmlDecode($this->v_10->CurrentValue);
            }
            $this->v_10->EditValue = HtmlEncode($this->v_10->CurrentValue);
            $this->v_10->PlaceHolder = RemoveHtml($this->v_10->caption());

            // v_10_validation
            $this->v_10_validation->setupEditAttributes();
            if (!$this->v_10_validation->Raw) {
                $this->v_10_validation->CurrentValue = HtmlDecode($this->v_10_validation->CurrentValue);
            }
            $this->v_10_validation->EditValue = HtmlEncode($this->v_10_validation->CurrentValue);
            $this->v_10_validation->PlaceHolder = RemoveHtml($this->v_10_validation->caption());

            // b_01_head
            $this->b_01_head->setupEditAttributes();
            if (!$this->b_01_head->Raw) {
                $this->b_01_head->CurrentValue = HtmlDecode($this->b_01_head->CurrentValue);
            }
            $this->b_01_head->EditValue = HtmlEncode($this->b_01_head->CurrentValue);
            $this->b_01_head->PlaceHolder = RemoveHtml($this->b_01_head->caption());

            // b_02_head
            $this->b_02_head->setupEditAttributes();
            if (!$this->b_02_head->Raw) {
                $this->b_02_head->CurrentValue = HtmlDecode($this->b_02_head->CurrentValue);
            }
            $this->b_02_head->EditValue = HtmlEncode($this->b_02_head->CurrentValue);
            $this->b_02_head->PlaceHolder = RemoveHtml($this->b_02_head->caption());

            // b_03_head
            $this->b_03_head->setupEditAttributes();
            if (!$this->b_03_head->Raw) {
                $this->b_03_head->CurrentValue = HtmlDecode($this->b_03_head->CurrentValue);
            }
            $this->b_03_head->EditValue = HtmlEncode($this->b_03_head->CurrentValue);
            $this->b_03_head->PlaceHolder = RemoveHtml($this->b_03_head->caption());

            // b_04_head
            $this->b_04_head->setupEditAttributes();
            if (!$this->b_04_head->Raw) {
                $this->b_04_head->CurrentValue = HtmlDecode($this->b_04_head->CurrentValue);
            }
            $this->b_04_head->EditValue = HtmlEncode($this->b_04_head->CurrentValue);
            $this->b_04_head->PlaceHolder = RemoveHtml($this->b_04_head->caption());

            // b_05_head
            $this->b_05_head->setupEditAttributes();
            if (!$this->b_05_head->Raw) {
                $this->b_05_head->CurrentValue = HtmlDecode($this->b_05_head->CurrentValue);
            }
            $this->b_05_head->EditValue = HtmlEncode($this->b_05_head->CurrentValue);
            $this->b_05_head->PlaceHolder = RemoveHtml($this->b_05_head->caption());

            // b_06_head
            $this->b_06_head->setupEditAttributes();
            if (!$this->b_06_head->Raw) {
                $this->b_06_head->CurrentValue = HtmlDecode($this->b_06_head->CurrentValue);
            }
            $this->b_06_head->EditValue = HtmlEncode($this->b_06_head->CurrentValue);
            $this->b_06_head->PlaceHolder = RemoveHtml($this->b_06_head->caption());

            // b_07_head
            $this->b_07_head->setupEditAttributes();
            if (!$this->b_07_head->Raw) {
                $this->b_07_head->CurrentValue = HtmlDecode($this->b_07_head->CurrentValue);
            }
            $this->b_07_head->EditValue = HtmlEncode($this->b_07_head->CurrentValue);
            $this->b_07_head->PlaceHolder = RemoveHtml($this->b_07_head->caption());

            // b_08_head
            $this->b_08_head->setupEditAttributes();
            if (!$this->b_08_head->Raw) {
                $this->b_08_head->CurrentValue = HtmlDecode($this->b_08_head->CurrentValue);
            }
            $this->b_08_head->EditValue = HtmlEncode($this->b_08_head->CurrentValue);
            $this->b_08_head->PlaceHolder = RemoveHtml($this->b_08_head->caption());

            // b_09_head
            $this->b_09_head->setupEditAttributes();
            if (!$this->b_09_head->Raw) {
                $this->b_09_head->CurrentValue = HtmlDecode($this->b_09_head->CurrentValue);
            }
            $this->b_09_head->EditValue = HtmlEncode($this->b_09_head->CurrentValue);
            $this->b_09_head->PlaceHolder = RemoveHtml($this->b_09_head->caption());

            // b_10_head
            $this->b_10_head->setupEditAttributes();
            if (!$this->b_10_head->Raw) {
                $this->b_10_head->CurrentValue = HtmlDecode($this->b_10_head->CurrentValue);
            }
            $this->b_10_head->EditValue = HtmlEncode($this->b_10_head->CurrentValue);
            $this->b_10_head->PlaceHolder = RemoveHtml($this->b_10_head->caption());

            // b_11_head
            $this->b_11_head->setupEditAttributes();
            if (!$this->b_11_head->Raw) {
                $this->b_11_head->CurrentValue = HtmlDecode($this->b_11_head->CurrentValue);
            }
            $this->b_11_head->EditValue = HtmlEncode($this->b_11_head->CurrentValue);
            $this->b_11_head->PlaceHolder = RemoveHtml($this->b_11_head->caption());

            // b_12_head
            $this->b_12_head->setupEditAttributes();
            if (!$this->b_12_head->Raw) {
                $this->b_12_head->CurrentValue = HtmlDecode($this->b_12_head->CurrentValue);
            }
            $this->b_12_head->EditValue = HtmlEncode($this->b_12_head->CurrentValue);
            $this->b_12_head->PlaceHolder = RemoveHtml($this->b_12_head->caption());

            // b_13_head
            $this->b_13_head->setupEditAttributes();
            if (!$this->b_13_head->Raw) {
                $this->b_13_head->CurrentValue = HtmlDecode($this->b_13_head->CurrentValue);
            }
            $this->b_13_head->EditValue = HtmlEncode($this->b_13_head->CurrentValue);
            $this->b_13_head->PlaceHolder = RemoveHtml($this->b_13_head->caption());

            // b_14_head
            $this->b_14_head->setupEditAttributes();
            if (!$this->b_14_head->Raw) {
                $this->b_14_head->CurrentValue = HtmlDecode($this->b_14_head->CurrentValue);
            }
            $this->b_14_head->EditValue = HtmlEncode($this->b_14_head->CurrentValue);
            $this->b_14_head->PlaceHolder = RemoveHtml($this->b_14_head->caption());

            // b_15_head
            $this->b_15_head->setupEditAttributes();
            if (!$this->b_15_head->Raw) {
                $this->b_15_head->CurrentValue = HtmlDecode($this->b_15_head->CurrentValue);
            }
            $this->b_15_head->EditValue = HtmlEncode($this->b_15_head->CurrentValue);
            $this->b_15_head->PlaceHolder = RemoveHtml($this->b_15_head->caption());

            // q_sku
            $this->q_sku->setupEditAttributes();
            if (!$this->q_sku->Raw) {
                $this->q_sku->CurrentValue = HtmlDecode($this->q_sku->CurrentValue);
            }
            $this->q_sku->EditValue = HtmlEncode($this->q_sku->CurrentValue);
            $this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());

            // t_01_head
            $this->t_01_head->setupEditAttributes();
            if (!$this->t_01_head->Raw) {
                $this->t_01_head->CurrentValue = HtmlDecode($this->t_01_head->CurrentValue);
            }
            $this->t_01_head->EditValue = HtmlEncode($this->t_01_head->CurrentValue);
            $this->t_01_head->PlaceHolder = RemoveHtml($this->t_01_head->caption());

            // t_02_head
            $this->t_02_head->setupEditAttributes();
            if (!$this->t_02_head->Raw) {
                $this->t_02_head->CurrentValue = HtmlDecode($this->t_02_head->CurrentValue);
            }
            $this->t_02_head->EditValue = HtmlEncode($this->t_02_head->CurrentValue);
            $this->t_02_head->PlaceHolder = RemoveHtml($this->t_02_head->caption());

            // t_03_head
            $this->t_03_head->setupEditAttributes();
            if (!$this->t_03_head->Raw) {
                $this->t_03_head->CurrentValue = HtmlDecode($this->t_03_head->CurrentValue);
            }
            $this->t_03_head->EditValue = HtmlEncode($this->t_03_head->CurrentValue);
            $this->t_03_head->PlaceHolder = RemoveHtml($this->t_03_head->caption());

            // t_04_head
            $this->t_04_head->setupEditAttributes();
            if (!$this->t_04_head->Raw) {
                $this->t_04_head->CurrentValue = HtmlDecode($this->t_04_head->CurrentValue);
            }
            $this->t_04_head->EditValue = HtmlEncode($this->t_04_head->CurrentValue);
            $this->t_04_head->PlaceHolder = RemoveHtml($this->t_04_head->caption());

            // t_05_head
            $this->t_05_head->setupEditAttributes();
            if (!$this->t_05_head->Raw) {
                $this->t_05_head->CurrentValue = HtmlDecode($this->t_05_head->CurrentValue);
            }
            $this->t_05_head->EditValue = HtmlEncode($this->t_05_head->CurrentValue);
            $this->t_05_head->PlaceHolder = RemoveHtml($this->t_05_head->caption());

            // t_06_head
            $this->t_06_head->setupEditAttributes();
            if (!$this->t_06_head->Raw) {
                $this->t_06_head->CurrentValue = HtmlDecode($this->t_06_head->CurrentValue);
            }
            $this->t_06_head->EditValue = HtmlEncode($this->t_06_head->CurrentValue);
            $this->t_06_head->PlaceHolder = RemoveHtml($this->t_06_head->caption());

            // t_07_head
            $this->t_07_head->setupEditAttributes();
            if (!$this->t_07_head->Raw) {
                $this->t_07_head->CurrentValue = HtmlDecode($this->t_07_head->CurrentValue);
            }
            $this->t_07_head->EditValue = HtmlEncode($this->t_07_head->CurrentValue);
            $this->t_07_head->PlaceHolder = RemoveHtml($this->t_07_head->caption());

            // t_08_head
            $this->t_08_head->setupEditAttributes();
            if (!$this->t_08_head->Raw) {
                $this->t_08_head->CurrentValue = HtmlDecode($this->t_08_head->CurrentValue);
            }
            $this->t_08_head->EditValue = HtmlEncode($this->t_08_head->CurrentValue);
            $this->t_08_head->PlaceHolder = RemoveHtml($this->t_08_head->caption());

            // t_09_head
            $this->t_09_head->setupEditAttributes();
            if (!$this->t_09_head->Raw) {
                $this->t_09_head->CurrentValue = HtmlDecode($this->t_09_head->CurrentValue);
            }
            $this->t_09_head->EditValue = HtmlEncode($this->t_09_head->CurrentValue);
            $this->t_09_head->PlaceHolder = RemoveHtml($this->t_09_head->caption());

            // t_10_head
            $this->t_10_head->setupEditAttributes();
            if (!$this->t_10_head->Raw) {
                $this->t_10_head->CurrentValue = HtmlDecode($this->t_10_head->CurrentValue);
            }
            $this->t_10_head->EditValue = HtmlEncode($this->t_10_head->CurrentValue);
            $this->t_10_head->PlaceHolder = RemoveHtml($this->t_10_head->caption());

            // t_11_head
            $this->t_11_head->setupEditAttributes();
            if (!$this->t_11_head->Raw) {
                $this->t_11_head->CurrentValue = HtmlDecode($this->t_11_head->CurrentValue);
            }
            $this->t_11_head->EditValue = HtmlEncode($this->t_11_head->CurrentValue);
            $this->t_11_head->PlaceHolder = RemoveHtml($this->t_11_head->caption());

            // t_12_head
            $this->t_12_head->setupEditAttributes();
            if (!$this->t_12_head->Raw) {
                $this->t_12_head->CurrentValue = HtmlDecode($this->t_12_head->CurrentValue);
            }
            $this->t_12_head->EditValue = HtmlEncode($this->t_12_head->CurrentValue);
            $this->t_12_head->PlaceHolder = RemoveHtml($this->t_12_head->caption());

            // t_13_head
            $this->t_13_head->setupEditAttributes();
            if (!$this->t_13_head->Raw) {
                $this->t_13_head->CurrentValue = HtmlDecode($this->t_13_head->CurrentValue);
            }
            $this->t_13_head->EditValue = HtmlEncode($this->t_13_head->CurrentValue);
            $this->t_13_head->PlaceHolder = RemoveHtml($this->t_13_head->caption());

            // t_14_head
            $this->t_14_head->setupEditAttributes();
            if (!$this->t_14_head->Raw) {
                $this->t_14_head->CurrentValue = HtmlDecode($this->t_14_head->CurrentValue);
            }
            $this->t_14_head->EditValue = HtmlEncode($this->t_14_head->CurrentValue);
            $this->t_14_head->PlaceHolder = RemoveHtml($this->t_14_head->caption());

            // t_15_head
            $this->t_15_head->setupEditAttributes();
            if (!$this->t_15_head->Raw) {
                $this->t_15_head->CurrentValue = HtmlDecode($this->t_15_head->CurrentValue);
            }
            $this->t_15_head->EditValue = HtmlEncode($this->t_15_head->CurrentValue);
            $this->t_15_head->PlaceHolder = RemoveHtml($this->t_15_head->caption());

            // po_01_head
            $this->po_01_head->setupEditAttributes();
            if (!$this->po_01_head->Raw) {
                $this->po_01_head->CurrentValue = HtmlDecode($this->po_01_head->CurrentValue);
            }
            $this->po_01_head->EditValue = HtmlEncode($this->po_01_head->CurrentValue);
            $this->po_01_head->PlaceHolder = RemoveHtml($this->po_01_head->caption());

            // po_02_head
            $this->po_02_head->setupEditAttributes();
            if (!$this->po_02_head->Raw) {
                $this->po_02_head->CurrentValue = HtmlDecode($this->po_02_head->CurrentValue);
            }
            $this->po_02_head->EditValue = HtmlEncode($this->po_02_head->CurrentValue);
            $this->po_02_head->PlaceHolder = RemoveHtml($this->po_02_head->caption());

            // po_03_head
            $this->po_03_head->setupEditAttributes();
            if (!$this->po_03_head->Raw) {
                $this->po_03_head->CurrentValue = HtmlDecode($this->po_03_head->CurrentValue);
            }
            $this->po_03_head->EditValue = HtmlEncode($this->po_03_head->CurrentValue);
            $this->po_03_head->PlaceHolder = RemoveHtml($this->po_03_head->caption());

            // po_04_head
            $this->po_04_head->setupEditAttributes();
            if (!$this->po_04_head->Raw) {
                $this->po_04_head->CurrentValue = HtmlDecode($this->po_04_head->CurrentValue);
            }
            $this->po_04_head->EditValue = HtmlEncode($this->po_04_head->CurrentValue);
            $this->po_04_head->PlaceHolder = RemoveHtml($this->po_04_head->caption());

            // po_05_head
            $this->po_05_head->setupEditAttributes();
            if (!$this->po_05_head->Raw) {
                $this->po_05_head->CurrentValue = HtmlDecode($this->po_05_head->CurrentValue);
            }
            $this->po_05_head->EditValue = HtmlEncode($this->po_05_head->CurrentValue);
            $this->po_05_head->PlaceHolder = RemoveHtml($this->po_05_head->caption());

            // po_06_head
            $this->po_06_head->setupEditAttributes();
            if (!$this->po_06_head->Raw) {
                $this->po_06_head->CurrentValue = HtmlDecode($this->po_06_head->CurrentValue);
            }
            $this->po_06_head->EditValue = HtmlEncode($this->po_06_head->CurrentValue);
            $this->po_06_head->PlaceHolder = RemoveHtml($this->po_06_head->caption());

            // po_07_head
            $this->po_07_head->setupEditAttributes();
            if (!$this->po_07_head->Raw) {
                $this->po_07_head->CurrentValue = HtmlDecode($this->po_07_head->CurrentValue);
            }
            $this->po_07_head->EditValue = HtmlEncode($this->po_07_head->CurrentValue);
            $this->po_07_head->PlaceHolder = RemoveHtml($this->po_07_head->caption());

            // po_08_head
            $this->po_08_head->setupEditAttributes();
            if (!$this->po_08_head->Raw) {
                $this->po_08_head->CurrentValue = HtmlDecode($this->po_08_head->CurrentValue);
            }
            $this->po_08_head->EditValue = HtmlEncode($this->po_08_head->CurrentValue);
            $this->po_08_head->PlaceHolder = RemoveHtml($this->po_08_head->caption());

            // po_17_head
            $this->po_17_head->setupEditAttributes();
            if (!$this->po_17_head->Raw) {
                $this->po_17_head->CurrentValue = HtmlDecode($this->po_17_head->CurrentValue);
            }
            $this->po_17_head->EditValue = HtmlEncode($this->po_17_head->CurrentValue);
            $this->po_17_head->PlaceHolder = RemoveHtml($this->po_17_head->caption());

            // po_18_head
            $this->po_18_head->setupEditAttributes();
            if (!$this->po_18_head->Raw) {
                $this->po_18_head->CurrentValue = HtmlDecode($this->po_18_head->CurrentValue);
            }
            $this->po_18_head->EditValue = HtmlEncode($this->po_18_head->CurrentValue);
            $this->po_18_head->PlaceHolder = RemoveHtml($this->po_18_head->caption());

            // po_19_head
            $this->po_19_head->setupEditAttributes();
            if (!$this->po_19_head->Raw) {
                $this->po_19_head->CurrentValue = HtmlDecode($this->po_19_head->CurrentValue);
            }
            $this->po_19_head->EditValue = HtmlEncode($this->po_19_head->CurrentValue);
            $this->po_19_head->PlaceHolder = RemoveHtml($this->po_19_head->caption());

            // po_20_head
            $this->po_20_head->setupEditAttributes();
            if (!$this->po_20_head->Raw) {
                $this->po_20_head->CurrentValue = HtmlDecode($this->po_20_head->CurrentValue);
            }
            $this->po_20_head->EditValue = HtmlEncode($this->po_20_head->CurrentValue);
            $this->po_20_head->PlaceHolder = RemoveHtml($this->po_20_head->caption());

            // jc_01_head
            $this->jc_01_head->setupEditAttributes();
            if (!$this->jc_01_head->Raw) {
                $this->jc_01_head->CurrentValue = HtmlDecode($this->jc_01_head->CurrentValue);
            }
            $this->jc_01_head->EditValue = HtmlEncode($this->jc_01_head->CurrentValue);
            $this->jc_01_head->PlaceHolder = RemoveHtml($this->jc_01_head->caption());

            // jc_02_head
            $this->jc_02_head->setupEditAttributes();
            if (!$this->jc_02_head->Raw) {
                $this->jc_02_head->CurrentValue = HtmlDecode($this->jc_02_head->CurrentValue);
            }
            $this->jc_02_head->EditValue = HtmlEncode($this->jc_02_head->CurrentValue);
            $this->jc_02_head->PlaceHolder = RemoveHtml($this->jc_02_head->caption());

            // jc_03_head
            $this->jc_03_head->setupEditAttributes();
            if (!$this->jc_03_head->Raw) {
                $this->jc_03_head->CurrentValue = HtmlDecode($this->jc_03_head->CurrentValue);
            }
            $this->jc_03_head->EditValue = HtmlEncode($this->jc_03_head->CurrentValue);
            $this->jc_03_head->PlaceHolder = RemoveHtml($this->jc_03_head->caption());

            // jc_04_head
            $this->jc_04_head->setupEditAttributes();
            if (!$this->jc_04_head->Raw) {
                $this->jc_04_head->CurrentValue = HtmlDecode($this->jc_04_head->CurrentValue);
            }
            $this->jc_04_head->EditValue = HtmlEncode($this->jc_04_head->CurrentValue);
            $this->jc_04_head->PlaceHolder = RemoveHtml($this->jc_04_head->caption());

            // jc_05_head
            $this->jc_05_head->setupEditAttributes();
            if (!$this->jc_05_head->Raw) {
                $this->jc_05_head->CurrentValue = HtmlDecode($this->jc_05_head->CurrentValue);
            }
            $this->jc_05_head->EditValue = HtmlEncode($this->jc_05_head->CurrentValue);
            $this->jc_05_head->PlaceHolder = RemoveHtml($this->jc_05_head->caption());

            // jc_06_head
            $this->jc_06_head->setupEditAttributes();
            if (!$this->jc_06_head->Raw) {
                $this->jc_06_head->CurrentValue = HtmlDecode($this->jc_06_head->CurrentValue);
            }
            $this->jc_06_head->EditValue = HtmlEncode($this->jc_06_head->CurrentValue);
            $this->jc_06_head->PlaceHolder = RemoveHtml($this->jc_06_head->caption());

            // jc_07_head
            $this->jc_07_head->setupEditAttributes();
            if (!$this->jc_07_head->Raw) {
                $this->jc_07_head->CurrentValue = HtmlDecode($this->jc_07_head->CurrentValue);
            }
            $this->jc_07_head->EditValue = HtmlEncode($this->jc_07_head->CurrentValue);
            $this->jc_07_head->PlaceHolder = RemoveHtml($this->jc_07_head->caption());

            // jc_08_head
            $this->jc_08_head->setupEditAttributes();
            if (!$this->jc_08_head->Raw) {
                $this->jc_08_head->CurrentValue = HtmlDecode($this->jc_08_head->CurrentValue);
            }
            $this->jc_08_head->EditValue = HtmlEncode($this->jc_08_head->CurrentValue);
            $this->jc_08_head->PlaceHolder = RemoveHtml($this->jc_08_head->caption());

            // jc_09_head
            $this->jc_09_head->setupEditAttributes();
            if (!$this->jc_09_head->Raw) {
                $this->jc_09_head->CurrentValue = HtmlDecode($this->jc_09_head->CurrentValue);
            }
            $this->jc_09_head->EditValue = HtmlEncode($this->jc_09_head->CurrentValue);
            $this->jc_09_head->PlaceHolder = RemoveHtml($this->jc_09_head->caption());

            // jc_10_head
            $this->jc_10_head->setupEditAttributes();
            if (!$this->jc_10_head->Raw) {
                $this->jc_10_head->CurrentValue = HtmlDecode($this->jc_10_head->CurrentValue);
            }
            $this->jc_10_head->EditValue = HtmlEncode($this->jc_10_head->CurrentValue);
            $this->jc_10_head->PlaceHolder = RemoveHtml($this->jc_10_head->caption());

            // pc_shape
            $this->pc_shape->setupEditAttributes();
            if (!$this->pc_shape->Raw) {
                $this->pc_shape->CurrentValue = HtmlDecode($this->pc_shape->CurrentValue);
            }
            $this->pc_shape->EditValue = HtmlEncode($this->pc_shape->CurrentValue);
            $this->pc_shape->PlaceHolder = RemoveHtml($this->pc_shape->caption());

            // pc_unit
            $this->pc_unit->setupEditAttributes();
            if (!$this->pc_unit->Raw) {
                $this->pc_unit->CurrentValue = HtmlDecode($this->pc_unit->CurrentValue);
            }
            $this->pc_unit->EditValue = HtmlEncode($this->pc_unit->CurrentValue);
            $this->pc_unit->PlaceHolder = RemoveHtml($this->pc_unit->caption());

            // pc_w
            $this->pc_w->setupEditAttributes();
            if (!$this->pc_w->Raw) {
                $this->pc_w->CurrentValue = HtmlDecode($this->pc_w->CurrentValue);
            }
            $this->pc_w->EditValue = HtmlEncode($this->pc_w->CurrentValue);
            $this->pc_w->PlaceHolder = RemoveHtml($this->pc_w->caption());

            // pc_l
            $this->pc_l->setupEditAttributes();
            if (!$this->pc_l->Raw) {
                $this->pc_l->CurrentValue = HtmlDecode($this->pc_l->CurrentValue);
            }
            $this->pc_l->EditValue = HtmlEncode($this->pc_l->CurrentValue);
            $this->pc_l->PlaceHolder = RemoveHtml($this->pc_l->caption());

            // pc_h
            $this->pc_h->setupEditAttributes();
            if (!$this->pc_h->Raw) {
                $this->pc_h->CurrentValue = HtmlDecode($this->pc_h->CurrentValue);
            }
            $this->pc_h->EditValue = HtmlEncode($this->pc_h->CurrentValue);
            $this->pc_h->PlaceHolder = RemoveHtml($this->pc_h->caption());

            // pc_partner_size
            $this->pc_partner_size->setupEditAttributes();
            if (!$this->pc_partner_size->Raw) {
                $this->pc_partner_size->CurrentValue = HtmlDecode($this->pc_partner_size->CurrentValue);
            }
            $this->pc_partner_size->EditValue = HtmlEncode($this->pc_partner_size->CurrentValue);
            $this->pc_partner_size->PlaceHolder = RemoveHtml($this->pc_partner_size->caption());

            // pc_sqm
            $this->pc_sqm->setupEditAttributes();
            if (!$this->pc_sqm->Raw) {
                $this->pc_sqm->CurrentValue = HtmlDecode($this->pc_sqm->CurrentValue);
            }
            $this->pc_sqm->EditValue = HtmlEncode($this->pc_sqm->CurrentValue);
            $this->pc_sqm->PlaceHolder = RemoveHtml($this->pc_sqm->caption());

            // pc_01_head
            $this->pc_01_head->setupEditAttributes();
            if (!$this->pc_01_head->Raw) {
                $this->pc_01_head->CurrentValue = HtmlDecode($this->pc_01_head->CurrentValue);
            }
            $this->pc_01_head->EditValue = HtmlEncode($this->pc_01_head->CurrentValue);
            $this->pc_01_head->PlaceHolder = RemoveHtml($this->pc_01_head->caption());

            // pc_02_head
            $this->pc_02_head->setupEditAttributes();
            if (!$this->pc_02_head->Raw) {
                $this->pc_02_head->CurrentValue = HtmlDecode($this->pc_02_head->CurrentValue);
            }
            $this->pc_02_head->EditValue = HtmlEncode($this->pc_02_head->CurrentValue);
            $this->pc_02_head->PlaceHolder = RemoveHtml($this->pc_02_head->caption());

            // pc_03_head
            $this->pc_03_head->setupEditAttributes();
            if (!$this->pc_03_head->Raw) {
                $this->pc_03_head->CurrentValue = HtmlDecode($this->pc_03_head->CurrentValue);
            }
            $this->pc_03_head->EditValue = HtmlEncode($this->pc_03_head->CurrentValue);
            $this->pc_03_head->PlaceHolder = RemoveHtml($this->pc_03_head->caption());

            // pc_04_head
            $this->pc_04_head->setupEditAttributes();
            if (!$this->pc_04_head->Raw) {
                $this->pc_04_head->CurrentValue = HtmlDecode($this->pc_04_head->CurrentValue);
            }
            $this->pc_04_head->EditValue = HtmlEncode($this->pc_04_head->CurrentValue);
            $this->pc_04_head->PlaceHolder = RemoveHtml($this->pc_04_head->caption());

            // pc_05_head
            $this->pc_05_head->setupEditAttributes();
            if (!$this->pc_05_head->Raw) {
                $this->pc_05_head->CurrentValue = HtmlDecode($this->pc_05_head->CurrentValue);
            }
            $this->pc_05_head->EditValue = HtmlEncode($this->pc_05_head->CurrentValue);
            $this->pc_05_head->PlaceHolder = RemoveHtml($this->pc_05_head->caption());

            // pc_06_head
            $this->pc_06_head->setupEditAttributes();
            if (!$this->pc_06_head->Raw) {
                $this->pc_06_head->CurrentValue = HtmlDecode($this->pc_06_head->CurrentValue);
            }
            $this->pc_06_head->EditValue = HtmlEncode($this->pc_06_head->CurrentValue);
            $this->pc_06_head->PlaceHolder = RemoveHtml($this->pc_06_head->caption());

            // pc_07_head
            $this->pc_07_head->setupEditAttributes();
            if (!$this->pc_07_head->Raw) {
                $this->pc_07_head->CurrentValue = HtmlDecode($this->pc_07_head->CurrentValue);
            }
            $this->pc_07_head->EditValue = HtmlEncode($this->pc_07_head->CurrentValue);
            $this->pc_07_head->PlaceHolder = RemoveHtml($this->pc_07_head->caption());

            // pc_08_head
            $this->pc_08_head->setupEditAttributes();
            if (!$this->pc_08_head->Raw) {
                $this->pc_08_head->CurrentValue = HtmlDecode($this->pc_08_head->CurrentValue);
            }
            $this->pc_08_head->EditValue = HtmlEncode($this->pc_08_head->CurrentValue);
            $this->pc_08_head->PlaceHolder = RemoveHtml($this->pc_08_head->caption());

            // pc_09_head
            $this->pc_09_head->setupEditAttributes();
            if (!$this->pc_09_head->Raw) {
                $this->pc_09_head->CurrentValue = HtmlDecode($this->pc_09_head->CurrentValue);
            }
            $this->pc_09_head->EditValue = HtmlEncode($this->pc_09_head->CurrentValue);
            $this->pc_09_head->PlaceHolder = RemoveHtml($this->pc_09_head->caption());

            // pc_10_head
            $this->pc_10_head->setupEditAttributes();
            if (!$this->pc_10_head->Raw) {
                $this->pc_10_head->CurrentValue = HtmlDecode($this->pc_10_head->CurrentValue);
            }
            $this->pc_10_head->EditValue = HtmlEncode($this->pc_10_head->CurrentValue);
            $this->pc_10_head->PlaceHolder = RemoveHtml($this->pc_10_head->caption());

            // pc_11_head
            $this->pc_11_head->setupEditAttributes();
            if (!$this->pc_11_head->Raw) {
                $this->pc_11_head->CurrentValue = HtmlDecode($this->pc_11_head->CurrentValue);
            }
            $this->pc_11_head->EditValue = HtmlEncode($this->pc_11_head->CurrentValue);
            $this->pc_11_head->PlaceHolder = RemoveHtml($this->pc_11_head->caption());

            // pc_12_head
            $this->pc_12_head->setupEditAttributes();
            if (!$this->pc_12_head->Raw) {
                $this->pc_12_head->CurrentValue = HtmlDecode($this->pc_12_head->CurrentValue);
            }
            $this->pc_12_head->EditValue = HtmlEncode($this->pc_12_head->CurrentValue);
            $this->pc_12_head->PlaceHolder = RemoveHtml($this->pc_12_head->caption());

            // operator

            // datetime

            // image
            $this->image->setupEditAttributes();
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ImageWidth = 0;
                $this->image->ImageHeight = 50;
                $this->image->ImageAlt = $this->image->alt();
                $this->image->ImageCssClass = "ew-image";
                $this->image->EditValue = $this->image->Upload->DbValue;
            } else {
                $this->image->EditValue = "";
            }
            if (!EmptyValue($this->image->CurrentValue)) {
                $this->image->Upload->FileName = $this->image->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->image);
            }

            // pa_process_size_w
            $this->pa_process_size_w->setupEditAttributes();
            if (!$this->pa_process_size_w->Raw) {
                $this->pa_process_size_w->CurrentValue = HtmlDecode($this->pa_process_size_w->CurrentValue);
            }
            $this->pa_process_size_w->EditValue = HtmlEncode($this->pa_process_size_w->CurrentValue);
            $this->pa_process_size_w->PlaceHolder = RemoveHtml($this->pa_process_size_w->caption());

            // pa_process_size_l
            $this->pa_process_size_l->setupEditAttributes();
            if (!$this->pa_process_size_l->Raw) {
                $this->pa_process_size_l->CurrentValue = HtmlDecode($this->pa_process_size_l->CurrentValue);
            }
            $this->pa_process_size_l->EditValue = HtmlEncode($this->pa_process_size_l->CurrentValue);
            $this->pa_process_size_l->PlaceHolder = RemoveHtml($this->pa_process_size_l->caption());

            // pa_head_01
            $this->pa_head_01->setupEditAttributes();
            if (!$this->pa_head_01->Raw) {
                $this->pa_head_01->CurrentValue = HtmlDecode($this->pa_head_01->CurrentValue);
            }
            $this->pa_head_01->EditValue = HtmlEncode($this->pa_head_01->CurrentValue);
            $this->pa_head_01->PlaceHolder = RemoveHtml($this->pa_head_01->caption());

            // pa_process_01
            $curVal = trim(strval($this->pa_process_01->CurrentValue));
            if ($curVal != "") {
                $this->pa_process_01->ViewValue = $this->pa_process_01->lookupCacheOption($curVal);
            } else {
                $this->pa_process_01->ViewValue = $this->pa_process_01->Lookup !== null && is_array($this->pa_process_01->lookupOptions()) && count($this->pa_process_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_01->ViewValue !== null) { // Load from cache
                $this->pa_process_01->EditValue = array_values($this->pa_process_01->lookupOptions());
                if ($this->pa_process_01->ViewValue == "") {
                    $this->pa_process_01->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_01->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_01->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_01->Lookup->renderViewRow($row);
                        $this->pa_process_01->ViewValue->add($this->pa_process_01->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_01->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_01->EditValue = $arwrk;
            }
            $this->pa_process_01->PlaceHolder = RemoveHtml($this->pa_process_01->caption());

            // pa_head_02
            $this->pa_head_02->setupEditAttributes();
            if (!$this->pa_head_02->Raw) {
                $this->pa_head_02->CurrentValue = HtmlDecode($this->pa_head_02->CurrentValue);
            }
            $this->pa_head_02->EditValue = HtmlEncode($this->pa_head_02->CurrentValue);
            $this->pa_head_02->PlaceHolder = RemoveHtml($this->pa_head_02->caption());

            // pa_process_02
            $curVal = trim(strval($this->pa_process_02->CurrentValue));
            if ($curVal != "") {
                $this->pa_process_02->ViewValue = $this->pa_process_02->lookupCacheOption($curVal);
            } else {
                $this->pa_process_02->ViewValue = $this->pa_process_02->Lookup !== null && is_array($this->pa_process_02->lookupOptions()) && count($this->pa_process_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_02->ViewValue !== null) { // Load from cache
                $this->pa_process_02->EditValue = array_values($this->pa_process_02->lookupOptions());
                if ($this->pa_process_02->ViewValue == "") {
                    $this->pa_process_02->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_02->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_02->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_02->Lookup->renderViewRow($row);
                        $this->pa_process_02->ViewValue->add($this->pa_process_02->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_02->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_02->EditValue = $arwrk;
            }
            $this->pa_process_02->PlaceHolder = RemoveHtml($this->pa_process_02->caption());

            // pa_head_03
            $this->pa_head_03->setupEditAttributes();
            if (!$this->pa_head_03->Raw) {
                $this->pa_head_03->CurrentValue = HtmlDecode($this->pa_head_03->CurrentValue);
            }
            $this->pa_head_03->EditValue = HtmlEncode($this->pa_head_03->CurrentValue);
            $this->pa_head_03->PlaceHolder = RemoveHtml($this->pa_head_03->caption());

            // pa_process_03
            $curVal = trim(strval($this->pa_process_03->CurrentValue));
            if ($curVal != "") {
                $this->pa_process_03->ViewValue = $this->pa_process_03->lookupCacheOption($curVal);
            } else {
                $this->pa_process_03->ViewValue = $this->pa_process_03->Lookup !== null && is_array($this->pa_process_03->lookupOptions()) && count($this->pa_process_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_03->ViewValue !== null) { // Load from cache
                $this->pa_process_03->EditValue = array_values($this->pa_process_03->lookupOptions());
                if ($this->pa_process_03->ViewValue == "") {
                    $this->pa_process_03->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_03->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_03->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_03->Lookup->renderViewRow($row);
                        $this->pa_process_03->ViewValue->add($this->pa_process_03->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_03->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_03->EditValue = $arwrk;
            }
            $this->pa_process_03->PlaceHolder = RemoveHtml($this->pa_process_03->caption());

            // pa_head_04
            $this->pa_head_04->setupEditAttributes();
            if (!$this->pa_head_04->Raw) {
                $this->pa_head_04->CurrentValue = HtmlDecode($this->pa_head_04->CurrentValue);
            }
            $this->pa_head_04->EditValue = HtmlEncode($this->pa_head_04->CurrentValue);
            $this->pa_head_04->PlaceHolder = RemoveHtml($this->pa_head_04->caption());

            // pa_process_04
            $curVal = trim(strval($this->pa_process_04->CurrentValue));
            if ($curVal != "") {
                $this->pa_process_04->ViewValue = $this->pa_process_04->lookupCacheOption($curVal);
            } else {
                $this->pa_process_04->ViewValue = $this->pa_process_04->Lookup !== null && is_array($this->pa_process_04->lookupOptions()) && count($this->pa_process_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_04->ViewValue !== null) { // Load from cache
                $this->pa_process_04->EditValue = array_values($this->pa_process_04->lookupOptions());
                if ($this->pa_process_04->ViewValue == "") {
                    $this->pa_process_04->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_04->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_04->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_04->Lookup->renderViewRow($row);
                        $this->pa_process_04->ViewValue->add($this->pa_process_04->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_04->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_04->EditValue = $arwrk;
            }
            $this->pa_process_04->PlaceHolder = RemoveHtml($this->pa_process_04->caption());

            // pa_head_05
            $this->pa_head_05->setupEditAttributes();
            if (!$this->pa_head_05->Raw) {
                $this->pa_head_05->CurrentValue = HtmlDecode($this->pa_head_05->CurrentValue);
            }
            $this->pa_head_05->EditValue = HtmlEncode($this->pa_head_05->CurrentValue);
            $this->pa_head_05->PlaceHolder = RemoveHtml($this->pa_head_05->caption());

            // pa_process_05
            $curVal = trim(strval($this->pa_process_05->CurrentValue));
            if ($curVal != "") {
                $this->pa_process_05->ViewValue = $this->pa_process_05->lookupCacheOption($curVal);
            } else {
                $this->pa_process_05->ViewValue = $this->pa_process_05->Lookup !== null && is_array($this->pa_process_05->lookupOptions()) && count($this->pa_process_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_05->ViewValue !== null) { // Load from cache
                $this->pa_process_05->EditValue = array_values($this->pa_process_05->lookupOptions());
                if ($this->pa_process_05->ViewValue == "") {
                    $this->pa_process_05->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_05->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_05->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_05->Lookup->renderViewRow($row);
                        $this->pa_process_05->ViewValue->add($this->pa_process_05->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_05->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_05->EditValue = $arwrk;
            }
            $this->pa_process_05->PlaceHolder = RemoveHtml($this->pa_process_05->caption());

            // pa_head_06
            $this->pa_head_06->setupEditAttributes();
            if (!$this->pa_head_06->Raw) {
                $this->pa_head_06->CurrentValue = HtmlDecode($this->pa_head_06->CurrentValue);
            }
            $this->pa_head_06->EditValue = HtmlEncode($this->pa_head_06->CurrentValue);
            $this->pa_head_06->PlaceHolder = RemoveHtml($this->pa_head_06->caption());

            // pa_process_06
            $curVal = trim(strval($this->pa_process_06->CurrentValue));
            if ($curVal != "") {
                $this->pa_process_06->ViewValue = $this->pa_process_06->lookupCacheOption($curVal);
            } else {
                $this->pa_process_06->ViewValue = $this->pa_process_06->Lookup !== null && is_array($this->pa_process_06->lookupOptions()) && count($this->pa_process_06->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_06->ViewValue !== null) { // Load from cache
                $this->pa_process_06->EditValue = array_values($this->pa_process_06->lookupOptions());
                if ($this->pa_process_06->ViewValue == "") {
                    $this->pa_process_06->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_06->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_06->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_06->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_06->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_06->Lookup->renderViewRow($row);
                        $this->pa_process_06->ViewValue->add($this->pa_process_06->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_06->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_06->EditValue = $arwrk;
            }
            $this->pa_process_06->PlaceHolder = RemoveHtml($this->pa_process_06->caption());

            // pa_head_07
            $this->pa_head_07->setupEditAttributes();
            if (!$this->pa_head_07->Raw) {
                $this->pa_head_07->CurrentValue = HtmlDecode($this->pa_head_07->CurrentValue);
            }
            $this->pa_head_07->EditValue = HtmlEncode($this->pa_head_07->CurrentValue);
            $this->pa_head_07->PlaceHolder = RemoveHtml($this->pa_head_07->caption());

            // pa_process_07
            $curVal = trim(strval($this->pa_process_07->CurrentValue));
            if ($curVal != "") {
                $this->pa_process_07->ViewValue = $this->pa_process_07->lookupCacheOption($curVal);
            } else {
                $this->pa_process_07->ViewValue = $this->pa_process_07->Lookup !== null && is_array($this->pa_process_07->lookupOptions()) && count($this->pa_process_07->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_07->ViewValue !== null) { // Load from cache
                $this->pa_process_07->EditValue = array_values($this->pa_process_07->lookupOptions());
                if ($this->pa_process_07->ViewValue == "") {
                    $this->pa_process_07->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_07->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_07->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_07->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_07->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_07->Lookup->renderViewRow($row);
                        $this->pa_process_07->ViewValue->add($this->pa_process_07->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_07->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_07->EditValue = $arwrk;
            }
            $this->pa_process_07->PlaceHolder = RemoveHtml($this->pa_process_07->caption());

            // pa_head_08
            $this->pa_head_08->setupEditAttributes();
            if (!$this->pa_head_08->Raw) {
                $this->pa_head_08->CurrentValue = HtmlDecode($this->pa_head_08->CurrentValue);
            }
            $this->pa_head_08->EditValue = HtmlEncode($this->pa_head_08->CurrentValue);
            $this->pa_head_08->PlaceHolder = RemoveHtml($this->pa_head_08->caption());

            // pa_process_08
            $curVal = trim(strval($this->pa_process_08->CurrentValue));
            if ($curVal != "") {
                $this->pa_process_08->ViewValue = $this->pa_process_08->lookupCacheOption($curVal);
            } else {
                $this->pa_process_08->ViewValue = $this->pa_process_08->Lookup !== null && is_array($this->pa_process_08->lookupOptions()) && count($this->pa_process_08->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_08->ViewValue !== null) { // Load from cache
                $this->pa_process_08->EditValue = array_values($this->pa_process_08->lookupOptions());
                if ($this->pa_process_08->ViewValue == "") {
                    $this->pa_process_08->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_08->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_08->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_08->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_08->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_08->Lookup->renderViewRow($row);
                        $this->pa_process_08->ViewValue->add($this->pa_process_08->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_08->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_08->EditValue = $arwrk;
            }
            $this->pa_process_08->PlaceHolder = RemoveHtml($this->pa_process_08->caption());

            // pa_head_09
            $this->pa_head_09->setupEditAttributes();
            if (!$this->pa_head_09->Raw) {
                $this->pa_head_09->CurrentValue = HtmlDecode($this->pa_head_09->CurrentValue);
            }
            $this->pa_head_09->EditValue = HtmlEncode($this->pa_head_09->CurrentValue);
            $this->pa_head_09->PlaceHolder = RemoveHtml($this->pa_head_09->caption());

            // pa_process_09
            $curVal = trim(strval($this->pa_process_09->CurrentValue));
            if ($curVal != "") {
                $this->pa_process_09->ViewValue = $this->pa_process_09->lookupCacheOption($curVal);
            } else {
                $this->pa_process_09->ViewValue = $this->pa_process_09->Lookup !== null && is_array($this->pa_process_09->lookupOptions()) && count($this->pa_process_09->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_09->ViewValue !== null) { // Load from cache
                $this->pa_process_09->EditValue = array_values($this->pa_process_09->lookupOptions());
                if ($this->pa_process_09->ViewValue == "") {
                    $this->pa_process_09->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_09->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_09->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_09->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_09->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_09->Lookup->renderViewRow($row);
                        $this->pa_process_09->ViewValue->add($this->pa_process_09->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_09->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_09->EditValue = $arwrk;
            }
            $this->pa_process_09->PlaceHolder = RemoveHtml($this->pa_process_09->caption());

            // pa_head_10
            $this->pa_head_10->setupEditAttributes();
            if (!$this->pa_head_10->Raw) {
                $this->pa_head_10->CurrentValue = HtmlDecode($this->pa_head_10->CurrentValue);
            }
            $this->pa_head_10->EditValue = HtmlEncode($this->pa_head_10->CurrentValue);
            $this->pa_head_10->PlaceHolder = RemoveHtml($this->pa_head_10->caption());

            // pa_process_10
            $curVal = trim(strval($this->pa_process_10->CurrentValue));
            if ($curVal != "") {
                $this->pa_process_10->ViewValue = $this->pa_process_10->lookupCacheOption($curVal);
            } else {
                $this->pa_process_10->ViewValue = $this->pa_process_10->Lookup !== null && is_array($this->pa_process_10->lookupOptions()) && count($this->pa_process_10->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pa_process_10->ViewValue !== null) { // Load from cache
                $this->pa_process_10->EditValue = array_values($this->pa_process_10->lookupOptions());
                if ($this->pa_process_10->ViewValue == "") {
                    $this->pa_process_10->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->pa_process_10->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_10->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->pa_process_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_10->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_10->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_10->Lookup->renderViewRow($row);
                        $this->pa_process_10->ViewValue->add($this->pa_process_10->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->pa_process_10->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->pa_process_10->EditValue = $arwrk;
            }
            $this->pa_process_10->PlaceHolder = RemoveHtml($this->pa_process_10->caption());

            // publish
            $this->publish->setupEditAttributes();
            $this->publish->EditValue = $this->publish->CurrentValue;
            $this->publish->PlaceHolder = RemoveHtml($this->publish->caption());
            if (strval($this->publish->EditValue) != "" && is_numeric($this->publish->EditValue)) {
                $this->publish->EditValue = FormatNumber($this->publish->EditValue, null);
            }

            // ppr_01
            $this->ppr_01->setupEditAttributes();
            if (!$this->ppr_01->Raw) {
                $this->ppr_01->CurrentValue = HtmlDecode($this->ppr_01->CurrentValue);
            }
            $this->ppr_01->EditValue = HtmlEncode($this->ppr_01->CurrentValue);
            $this->ppr_01->PlaceHolder = RemoveHtml($this->ppr_01->caption());

            // ppr_02
            $this->ppr_02->setupEditAttributes();
            if (!$this->ppr_02->Raw) {
                $this->ppr_02->CurrentValue = HtmlDecode($this->ppr_02->CurrentValue);
            }
            $this->ppr_02->EditValue = HtmlEncode($this->ppr_02->CurrentValue);
            $this->ppr_02->PlaceHolder = RemoveHtml($this->ppr_02->caption());

            // ppr_03
            $this->ppr_03->setupEditAttributes();
            if (!$this->ppr_03->Raw) {
                $this->ppr_03->CurrentValue = HtmlDecode($this->ppr_03->CurrentValue);
            }
            $this->ppr_03->EditValue = HtmlEncode($this->ppr_03->CurrentValue);
            $this->ppr_03->PlaceHolder = RemoveHtml($this->ppr_03->caption());

            // ppr_04
            $this->ppr_04->setupEditAttributes();
            if (!$this->ppr_04->Raw) {
                $this->ppr_04->CurrentValue = HtmlDecode($this->ppr_04->CurrentValue);
            }
            $this->ppr_04->EditValue = HtmlEncode($this->ppr_04->CurrentValue);
            $this->ppr_04->PlaceHolder = RemoveHtml($this->ppr_04->caption());

            // ppr_05
            $this->ppr_05->setupEditAttributes();
            if (!$this->ppr_05->Raw) {
                $this->ppr_05->CurrentValue = HtmlDecode($this->ppr_05->CurrentValue);
            }
            $this->ppr_05->EditValue = HtmlEncode($this->ppr_05->CurrentValue);
            $this->ppr_05->PlaceHolder = RemoveHtml($this->ppr_05->caption());

            // ppr_06
            $this->ppr_06->setupEditAttributes();
            if (!$this->ppr_06->Raw) {
                $this->ppr_06->CurrentValue = HtmlDecode($this->ppr_06->CurrentValue);
            }
            $this->ppr_06->EditValue = HtmlEncode($this->ppr_06->CurrentValue);
            $this->ppr_06->PlaceHolder = RemoveHtml($this->ppr_06->caption());

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // product_group
            $this->product_group->HrefValue = "";

            // calculation_method
            $this->calculation_method->HrefValue = "";

            // shape
            $this->shape->HrefValue = "";

            // sqm
            $this->sqm->HrefValue = "";

            // cbm
            $this->cbm->HrefValue = "";

            // process
            $this->process->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // v_00
            $this->v_00->HrefValue = "";

            // v_01
            $this->v_01->HrefValue = "";

            // v_01_validation
            $this->v_01_validation->HrefValue = "";

            // v_02
            $this->v_02->HrefValue = "";

            // v_02_validation
            $this->v_02_validation->HrefValue = "";

            // v_03
            $this->v_03->HrefValue = "";

            // v_03_validation
            $this->v_03_validation->HrefValue = "";

            // v_04
            $this->v_04->HrefValue = "";

            // v_04_validation
            $this->v_04_validation->HrefValue = "";

            // v_05
            $this->v_05->HrefValue = "";

            // v_05_validation
            $this->v_05_validation->HrefValue = "";

            // v_06
            $this->v_06->HrefValue = "";

            // v_06_validation
            $this->v_06_validation->HrefValue = "";

            // v_07
            $this->v_07->HrefValue = "";

            // v_07_validation
            $this->v_07_validation->HrefValue = "";

            // v_08
            $this->v_08->HrefValue = "";

            // v_08_validation
            $this->v_08_validation->HrefValue = "";

            // v_09
            $this->v_09->HrefValue = "";

            // v_09_validation
            $this->v_09_validation->HrefValue = "";

            // v_10
            $this->v_10->HrefValue = "";

            // v_10_validation
            $this->v_10_validation->HrefValue = "";

            // b_01_head
            $this->b_01_head->HrefValue = "";

            // b_02_head
            $this->b_02_head->HrefValue = "";

            // b_03_head
            $this->b_03_head->HrefValue = "";

            // b_04_head
            $this->b_04_head->HrefValue = "";

            // b_05_head
            $this->b_05_head->HrefValue = "";

            // b_06_head
            $this->b_06_head->HrefValue = "";

            // b_07_head
            $this->b_07_head->HrefValue = "";

            // b_08_head
            $this->b_08_head->HrefValue = "";

            // b_09_head
            $this->b_09_head->HrefValue = "";

            // b_10_head
            $this->b_10_head->HrefValue = "";

            // b_11_head
            $this->b_11_head->HrefValue = "";

            // b_12_head
            $this->b_12_head->HrefValue = "";

            // b_13_head
            $this->b_13_head->HrefValue = "";

            // b_14_head
            $this->b_14_head->HrefValue = "";

            // b_15_head
            $this->b_15_head->HrefValue = "";

            // q_sku
            $this->q_sku->HrefValue = "";

            // t_01_head
            $this->t_01_head->HrefValue = "";

            // t_02_head
            $this->t_02_head->HrefValue = "";

            // t_03_head
            $this->t_03_head->HrefValue = "";

            // t_04_head
            $this->t_04_head->HrefValue = "";

            // t_05_head
            $this->t_05_head->HrefValue = "";

            // t_06_head
            $this->t_06_head->HrefValue = "";

            // t_07_head
            $this->t_07_head->HrefValue = "";

            // t_08_head
            $this->t_08_head->HrefValue = "";

            // t_09_head
            $this->t_09_head->HrefValue = "";

            // t_10_head
            $this->t_10_head->HrefValue = "";

            // t_11_head
            $this->t_11_head->HrefValue = "";

            // t_12_head
            $this->t_12_head->HrefValue = "";

            // t_13_head
            $this->t_13_head->HrefValue = "";

            // t_14_head
            $this->t_14_head->HrefValue = "";

            // t_15_head
            $this->t_15_head->HrefValue = "";

            // po_01_head
            $this->po_01_head->HrefValue = "";

            // po_02_head
            $this->po_02_head->HrefValue = "";

            // po_03_head
            $this->po_03_head->HrefValue = "";

            // po_04_head
            $this->po_04_head->HrefValue = "";

            // po_05_head
            $this->po_05_head->HrefValue = "";

            // po_06_head
            $this->po_06_head->HrefValue = "";

            // po_07_head
            $this->po_07_head->HrefValue = "";

            // po_08_head
            $this->po_08_head->HrefValue = "";

            // po_17_head
            $this->po_17_head->HrefValue = "";

            // po_18_head
            $this->po_18_head->HrefValue = "";

            // po_19_head
            $this->po_19_head->HrefValue = "";

            // po_20_head
            $this->po_20_head->HrefValue = "";

            // jc_01_head
            $this->jc_01_head->HrefValue = "";

            // jc_02_head
            $this->jc_02_head->HrefValue = "";

            // jc_03_head
            $this->jc_03_head->HrefValue = "";

            // jc_04_head
            $this->jc_04_head->HrefValue = "";

            // jc_05_head
            $this->jc_05_head->HrefValue = "";

            // jc_06_head
            $this->jc_06_head->HrefValue = "";

            // jc_07_head
            $this->jc_07_head->HrefValue = "";

            // jc_08_head
            $this->jc_08_head->HrefValue = "";

            // jc_09_head
            $this->jc_09_head->HrefValue = "";

            // jc_10_head
            $this->jc_10_head->HrefValue = "";

            // pc_shape
            $this->pc_shape->HrefValue = "";

            // pc_unit
            $this->pc_unit->HrefValue = "";

            // pc_w
            $this->pc_w->HrefValue = "";

            // pc_l
            $this->pc_l->HrefValue = "";

            // pc_h
            $this->pc_h->HrefValue = "";

            // pc_partner_size
            $this->pc_partner_size->HrefValue = "";

            // pc_sqm
            $this->pc_sqm->HrefValue = "";

            // pc_01_head
            $this->pc_01_head->HrefValue = "";

            // pc_02_head
            $this->pc_02_head->HrefValue = "";

            // pc_03_head
            $this->pc_03_head->HrefValue = "";

            // pc_04_head
            $this->pc_04_head->HrefValue = "";

            // pc_05_head
            $this->pc_05_head->HrefValue = "";

            // pc_06_head
            $this->pc_06_head->HrefValue = "";

            // pc_07_head
            $this->pc_07_head->HrefValue = "";

            // pc_08_head
            $this->pc_08_head->HrefValue = "";

            // pc_09_head
            $this->pc_09_head->HrefValue = "";

            // pc_10_head
            $this->pc_10_head->HrefValue = "";

            // pc_11_head
            $this->pc_11_head->HrefValue = "";

            // pc_12_head
            $this->pc_12_head->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->htmlDecode($this->image->Upload->DbValue)); // Add prefix/suffix
                $this->image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
                }
            } else {
                $this->image->HrefValue = "";
            }
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

            // pa_process_size_w
            $this->pa_process_size_w->HrefValue = "";

            // pa_process_size_l
            $this->pa_process_size_l->HrefValue = "";

            // pa_head_01
            $this->pa_head_01->HrefValue = "";

            // pa_process_01
            $this->pa_process_01->HrefValue = "";

            // pa_head_02
            $this->pa_head_02->HrefValue = "";

            // pa_process_02
            $this->pa_process_02->HrefValue = "";

            // pa_head_03
            $this->pa_head_03->HrefValue = "";

            // pa_process_03
            $this->pa_process_03->HrefValue = "";

            // pa_head_04
            $this->pa_head_04->HrefValue = "";

            // pa_process_04
            $this->pa_process_04->HrefValue = "";

            // pa_head_05
            $this->pa_head_05->HrefValue = "";

            // pa_process_05
            $this->pa_process_05->HrefValue = "";

            // pa_head_06
            $this->pa_head_06->HrefValue = "";

            // pa_process_06
            $this->pa_process_06->HrefValue = "";

            // pa_head_07
            $this->pa_head_07->HrefValue = "";

            // pa_process_07
            $this->pa_process_07->HrefValue = "";

            // pa_head_08
            $this->pa_head_08->HrefValue = "";

            // pa_process_08
            $this->pa_process_08->HrefValue = "";

            // pa_head_09
            $this->pa_head_09->HrefValue = "";

            // pa_process_09
            $this->pa_process_09->HrefValue = "";

            // pa_head_10
            $this->pa_head_10->HrefValue = "";

            // pa_process_10
            $this->pa_process_10->HrefValue = "";

            // publish
            $this->publish->HrefValue = "";

            // ppr_01
            $this->ppr_01->HrefValue = "";

            // ppr_02
            $this->ppr_02->HrefValue = "";

            // ppr_03
            $this->ppr_03->HrefValue = "";

            // ppr_04
            $this->ppr_04->HrefValue = "";

            // ppr_05
            $this->ppr_05->HrefValue = "";

            // ppr_06
            $this->ppr_06->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->product_group->Visible && $this->product_group->Required) {
                if (!$this->product_group->IsDetailKey && EmptyValue($this->product_group->FormValue)) {
                    $this->product_group->addErrorMessage(str_replace("%s", $this->product_group->caption(), $this->product_group->RequiredErrorMessage));
                }
            }
            if ($this->calculation_method->Visible && $this->calculation_method->Required) {
                if (!$this->calculation_method->IsDetailKey && EmptyValue($this->calculation_method->FormValue)) {
                    $this->calculation_method->addErrorMessage(str_replace("%s", $this->calculation_method->caption(), $this->calculation_method->RequiredErrorMessage));
                }
            }
            if ($this->shape->Visible && $this->shape->Required) {
                if (!$this->shape->IsDetailKey && EmptyValue($this->shape->FormValue)) {
                    $this->shape->addErrorMessage(str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
                }
            }
            if ($this->sqm->Visible && $this->sqm->Required) {
                if (!$this->sqm->IsDetailKey && EmptyValue($this->sqm->FormValue)) {
                    $this->sqm->addErrorMessage(str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
                }
            }
            if ($this->cbm->Visible && $this->cbm->Required) {
                if (!$this->cbm->IsDetailKey && EmptyValue($this->cbm->FormValue)) {
                    $this->cbm->addErrorMessage(str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
                }
            }
            if ($this->process->Visible && $this->process->Required) {
                if (!$this->process->IsDetailKey && EmptyValue($this->process->FormValue)) {
                    $this->process->addErrorMessage(str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->v_00->Visible && $this->v_00->Required) {
                if (!$this->v_00->IsDetailKey && EmptyValue($this->v_00->FormValue)) {
                    $this->v_00->addErrorMessage(str_replace("%s", $this->v_00->caption(), $this->v_00->RequiredErrorMessage));
                }
            }
            if ($this->v_01->Visible && $this->v_01->Required) {
                if (!$this->v_01->IsDetailKey && EmptyValue($this->v_01->FormValue)) {
                    $this->v_01->addErrorMessage(str_replace("%s", $this->v_01->caption(), $this->v_01->RequiredErrorMessage));
                }
            }
            if ($this->v_01_validation->Visible && $this->v_01_validation->Required) {
                if (!$this->v_01_validation->IsDetailKey && EmptyValue($this->v_01_validation->FormValue)) {
                    $this->v_01_validation->addErrorMessage(str_replace("%s", $this->v_01_validation->caption(), $this->v_01_validation->RequiredErrorMessage));
                }
            }
            if ($this->v_02->Visible && $this->v_02->Required) {
                if (!$this->v_02->IsDetailKey && EmptyValue($this->v_02->FormValue)) {
                    $this->v_02->addErrorMessage(str_replace("%s", $this->v_02->caption(), $this->v_02->RequiredErrorMessage));
                }
            }
            if ($this->v_02_validation->Visible && $this->v_02_validation->Required) {
                if (!$this->v_02_validation->IsDetailKey && EmptyValue($this->v_02_validation->FormValue)) {
                    $this->v_02_validation->addErrorMessage(str_replace("%s", $this->v_02_validation->caption(), $this->v_02_validation->RequiredErrorMessage));
                }
            }
            if ($this->v_03->Visible && $this->v_03->Required) {
                if (!$this->v_03->IsDetailKey && EmptyValue($this->v_03->FormValue)) {
                    $this->v_03->addErrorMessage(str_replace("%s", $this->v_03->caption(), $this->v_03->RequiredErrorMessage));
                }
            }
            if ($this->v_03_validation->Visible && $this->v_03_validation->Required) {
                if (!$this->v_03_validation->IsDetailKey && EmptyValue($this->v_03_validation->FormValue)) {
                    $this->v_03_validation->addErrorMessage(str_replace("%s", $this->v_03_validation->caption(), $this->v_03_validation->RequiredErrorMessage));
                }
            }
            if ($this->v_04->Visible && $this->v_04->Required) {
                if (!$this->v_04->IsDetailKey && EmptyValue($this->v_04->FormValue)) {
                    $this->v_04->addErrorMessage(str_replace("%s", $this->v_04->caption(), $this->v_04->RequiredErrorMessage));
                }
            }
            if ($this->v_04_validation->Visible && $this->v_04_validation->Required) {
                if (!$this->v_04_validation->IsDetailKey && EmptyValue($this->v_04_validation->FormValue)) {
                    $this->v_04_validation->addErrorMessage(str_replace("%s", $this->v_04_validation->caption(), $this->v_04_validation->RequiredErrorMessage));
                }
            }
            if ($this->v_05->Visible && $this->v_05->Required) {
                if (!$this->v_05->IsDetailKey && EmptyValue($this->v_05->FormValue)) {
                    $this->v_05->addErrorMessage(str_replace("%s", $this->v_05->caption(), $this->v_05->RequiredErrorMessage));
                }
            }
            if ($this->v_05_validation->Visible && $this->v_05_validation->Required) {
                if (!$this->v_05_validation->IsDetailKey && EmptyValue($this->v_05_validation->FormValue)) {
                    $this->v_05_validation->addErrorMessage(str_replace("%s", $this->v_05_validation->caption(), $this->v_05_validation->RequiredErrorMessage));
                }
            }
            if ($this->v_06->Visible && $this->v_06->Required) {
                if (!$this->v_06->IsDetailKey && EmptyValue($this->v_06->FormValue)) {
                    $this->v_06->addErrorMessage(str_replace("%s", $this->v_06->caption(), $this->v_06->RequiredErrorMessage));
                }
            }
            if ($this->v_06_validation->Visible && $this->v_06_validation->Required) {
                if (!$this->v_06_validation->IsDetailKey && EmptyValue($this->v_06_validation->FormValue)) {
                    $this->v_06_validation->addErrorMessage(str_replace("%s", $this->v_06_validation->caption(), $this->v_06_validation->RequiredErrorMessage));
                }
            }
            if ($this->v_07->Visible && $this->v_07->Required) {
                if (!$this->v_07->IsDetailKey && EmptyValue($this->v_07->FormValue)) {
                    $this->v_07->addErrorMessage(str_replace("%s", $this->v_07->caption(), $this->v_07->RequiredErrorMessage));
                }
            }
            if ($this->v_07_validation->Visible && $this->v_07_validation->Required) {
                if (!$this->v_07_validation->IsDetailKey && EmptyValue($this->v_07_validation->FormValue)) {
                    $this->v_07_validation->addErrorMessage(str_replace("%s", $this->v_07_validation->caption(), $this->v_07_validation->RequiredErrorMessage));
                }
            }
            if ($this->v_08->Visible && $this->v_08->Required) {
                if (!$this->v_08->IsDetailKey && EmptyValue($this->v_08->FormValue)) {
                    $this->v_08->addErrorMessage(str_replace("%s", $this->v_08->caption(), $this->v_08->RequiredErrorMessage));
                }
            }
            if ($this->v_08_validation->Visible && $this->v_08_validation->Required) {
                if (!$this->v_08_validation->IsDetailKey && EmptyValue($this->v_08_validation->FormValue)) {
                    $this->v_08_validation->addErrorMessage(str_replace("%s", $this->v_08_validation->caption(), $this->v_08_validation->RequiredErrorMessage));
                }
            }
            if ($this->v_09->Visible && $this->v_09->Required) {
                if (!$this->v_09->IsDetailKey && EmptyValue($this->v_09->FormValue)) {
                    $this->v_09->addErrorMessage(str_replace("%s", $this->v_09->caption(), $this->v_09->RequiredErrorMessage));
                }
            }
            if ($this->v_09_validation->Visible && $this->v_09_validation->Required) {
                if (!$this->v_09_validation->IsDetailKey && EmptyValue($this->v_09_validation->FormValue)) {
                    $this->v_09_validation->addErrorMessage(str_replace("%s", $this->v_09_validation->caption(), $this->v_09_validation->RequiredErrorMessage));
                }
            }
            if ($this->v_10->Visible && $this->v_10->Required) {
                if (!$this->v_10->IsDetailKey && EmptyValue($this->v_10->FormValue)) {
                    $this->v_10->addErrorMessage(str_replace("%s", $this->v_10->caption(), $this->v_10->RequiredErrorMessage));
                }
            }
            if ($this->v_10_validation->Visible && $this->v_10_validation->Required) {
                if (!$this->v_10_validation->IsDetailKey && EmptyValue($this->v_10_validation->FormValue)) {
                    $this->v_10_validation->addErrorMessage(str_replace("%s", $this->v_10_validation->caption(), $this->v_10_validation->RequiredErrorMessage));
                }
            }
            if ($this->b_01_head->Visible && $this->b_01_head->Required) {
                if (!$this->b_01_head->IsDetailKey && EmptyValue($this->b_01_head->FormValue)) {
                    $this->b_01_head->addErrorMessage(str_replace("%s", $this->b_01_head->caption(), $this->b_01_head->RequiredErrorMessage));
                }
            }
            if ($this->b_02_head->Visible && $this->b_02_head->Required) {
                if (!$this->b_02_head->IsDetailKey && EmptyValue($this->b_02_head->FormValue)) {
                    $this->b_02_head->addErrorMessage(str_replace("%s", $this->b_02_head->caption(), $this->b_02_head->RequiredErrorMessage));
                }
            }
            if ($this->b_03_head->Visible && $this->b_03_head->Required) {
                if (!$this->b_03_head->IsDetailKey && EmptyValue($this->b_03_head->FormValue)) {
                    $this->b_03_head->addErrorMessage(str_replace("%s", $this->b_03_head->caption(), $this->b_03_head->RequiredErrorMessage));
                }
            }
            if ($this->b_04_head->Visible && $this->b_04_head->Required) {
                if (!$this->b_04_head->IsDetailKey && EmptyValue($this->b_04_head->FormValue)) {
                    $this->b_04_head->addErrorMessage(str_replace("%s", $this->b_04_head->caption(), $this->b_04_head->RequiredErrorMessage));
                }
            }
            if ($this->b_05_head->Visible && $this->b_05_head->Required) {
                if (!$this->b_05_head->IsDetailKey && EmptyValue($this->b_05_head->FormValue)) {
                    $this->b_05_head->addErrorMessage(str_replace("%s", $this->b_05_head->caption(), $this->b_05_head->RequiredErrorMessage));
                }
            }
            if ($this->b_06_head->Visible && $this->b_06_head->Required) {
                if (!$this->b_06_head->IsDetailKey && EmptyValue($this->b_06_head->FormValue)) {
                    $this->b_06_head->addErrorMessage(str_replace("%s", $this->b_06_head->caption(), $this->b_06_head->RequiredErrorMessage));
                }
            }
            if ($this->b_07_head->Visible && $this->b_07_head->Required) {
                if (!$this->b_07_head->IsDetailKey && EmptyValue($this->b_07_head->FormValue)) {
                    $this->b_07_head->addErrorMessage(str_replace("%s", $this->b_07_head->caption(), $this->b_07_head->RequiredErrorMessage));
                }
            }
            if ($this->b_08_head->Visible && $this->b_08_head->Required) {
                if (!$this->b_08_head->IsDetailKey && EmptyValue($this->b_08_head->FormValue)) {
                    $this->b_08_head->addErrorMessage(str_replace("%s", $this->b_08_head->caption(), $this->b_08_head->RequiredErrorMessage));
                }
            }
            if ($this->b_09_head->Visible && $this->b_09_head->Required) {
                if (!$this->b_09_head->IsDetailKey && EmptyValue($this->b_09_head->FormValue)) {
                    $this->b_09_head->addErrorMessage(str_replace("%s", $this->b_09_head->caption(), $this->b_09_head->RequiredErrorMessage));
                }
            }
            if ($this->b_10_head->Visible && $this->b_10_head->Required) {
                if (!$this->b_10_head->IsDetailKey && EmptyValue($this->b_10_head->FormValue)) {
                    $this->b_10_head->addErrorMessage(str_replace("%s", $this->b_10_head->caption(), $this->b_10_head->RequiredErrorMessage));
                }
            }
            if ($this->b_11_head->Visible && $this->b_11_head->Required) {
                if (!$this->b_11_head->IsDetailKey && EmptyValue($this->b_11_head->FormValue)) {
                    $this->b_11_head->addErrorMessage(str_replace("%s", $this->b_11_head->caption(), $this->b_11_head->RequiredErrorMessage));
                }
            }
            if ($this->b_12_head->Visible && $this->b_12_head->Required) {
                if (!$this->b_12_head->IsDetailKey && EmptyValue($this->b_12_head->FormValue)) {
                    $this->b_12_head->addErrorMessage(str_replace("%s", $this->b_12_head->caption(), $this->b_12_head->RequiredErrorMessage));
                }
            }
            if ($this->b_13_head->Visible && $this->b_13_head->Required) {
                if (!$this->b_13_head->IsDetailKey && EmptyValue($this->b_13_head->FormValue)) {
                    $this->b_13_head->addErrorMessage(str_replace("%s", $this->b_13_head->caption(), $this->b_13_head->RequiredErrorMessage));
                }
            }
            if ($this->b_14_head->Visible && $this->b_14_head->Required) {
                if (!$this->b_14_head->IsDetailKey && EmptyValue($this->b_14_head->FormValue)) {
                    $this->b_14_head->addErrorMessage(str_replace("%s", $this->b_14_head->caption(), $this->b_14_head->RequiredErrorMessage));
                }
            }
            if ($this->b_15_head->Visible && $this->b_15_head->Required) {
                if (!$this->b_15_head->IsDetailKey && EmptyValue($this->b_15_head->FormValue)) {
                    $this->b_15_head->addErrorMessage(str_replace("%s", $this->b_15_head->caption(), $this->b_15_head->RequiredErrorMessage));
                }
            }
            if ($this->q_sku->Visible && $this->q_sku->Required) {
                if (!$this->q_sku->IsDetailKey && EmptyValue($this->q_sku->FormValue)) {
                    $this->q_sku->addErrorMessage(str_replace("%s", $this->q_sku->caption(), $this->q_sku->RequiredErrorMessage));
                }
            }
            if ($this->t_01_head->Visible && $this->t_01_head->Required) {
                if (!$this->t_01_head->IsDetailKey && EmptyValue($this->t_01_head->FormValue)) {
                    $this->t_01_head->addErrorMessage(str_replace("%s", $this->t_01_head->caption(), $this->t_01_head->RequiredErrorMessage));
                }
            }
            if ($this->t_02_head->Visible && $this->t_02_head->Required) {
                if (!$this->t_02_head->IsDetailKey && EmptyValue($this->t_02_head->FormValue)) {
                    $this->t_02_head->addErrorMessage(str_replace("%s", $this->t_02_head->caption(), $this->t_02_head->RequiredErrorMessage));
                }
            }
            if ($this->t_03_head->Visible && $this->t_03_head->Required) {
                if (!$this->t_03_head->IsDetailKey && EmptyValue($this->t_03_head->FormValue)) {
                    $this->t_03_head->addErrorMessage(str_replace("%s", $this->t_03_head->caption(), $this->t_03_head->RequiredErrorMessage));
                }
            }
            if ($this->t_04_head->Visible && $this->t_04_head->Required) {
                if (!$this->t_04_head->IsDetailKey && EmptyValue($this->t_04_head->FormValue)) {
                    $this->t_04_head->addErrorMessage(str_replace("%s", $this->t_04_head->caption(), $this->t_04_head->RequiredErrorMessage));
                }
            }
            if ($this->t_05_head->Visible && $this->t_05_head->Required) {
                if (!$this->t_05_head->IsDetailKey && EmptyValue($this->t_05_head->FormValue)) {
                    $this->t_05_head->addErrorMessage(str_replace("%s", $this->t_05_head->caption(), $this->t_05_head->RequiredErrorMessage));
                }
            }
            if ($this->t_06_head->Visible && $this->t_06_head->Required) {
                if (!$this->t_06_head->IsDetailKey && EmptyValue($this->t_06_head->FormValue)) {
                    $this->t_06_head->addErrorMessage(str_replace("%s", $this->t_06_head->caption(), $this->t_06_head->RequiredErrorMessage));
                }
            }
            if ($this->t_07_head->Visible && $this->t_07_head->Required) {
                if (!$this->t_07_head->IsDetailKey && EmptyValue($this->t_07_head->FormValue)) {
                    $this->t_07_head->addErrorMessage(str_replace("%s", $this->t_07_head->caption(), $this->t_07_head->RequiredErrorMessage));
                }
            }
            if ($this->t_08_head->Visible && $this->t_08_head->Required) {
                if (!$this->t_08_head->IsDetailKey && EmptyValue($this->t_08_head->FormValue)) {
                    $this->t_08_head->addErrorMessage(str_replace("%s", $this->t_08_head->caption(), $this->t_08_head->RequiredErrorMessage));
                }
            }
            if ($this->t_09_head->Visible && $this->t_09_head->Required) {
                if (!$this->t_09_head->IsDetailKey && EmptyValue($this->t_09_head->FormValue)) {
                    $this->t_09_head->addErrorMessage(str_replace("%s", $this->t_09_head->caption(), $this->t_09_head->RequiredErrorMessage));
                }
            }
            if ($this->t_10_head->Visible && $this->t_10_head->Required) {
                if (!$this->t_10_head->IsDetailKey && EmptyValue($this->t_10_head->FormValue)) {
                    $this->t_10_head->addErrorMessage(str_replace("%s", $this->t_10_head->caption(), $this->t_10_head->RequiredErrorMessage));
                }
            }
            if ($this->t_11_head->Visible && $this->t_11_head->Required) {
                if (!$this->t_11_head->IsDetailKey && EmptyValue($this->t_11_head->FormValue)) {
                    $this->t_11_head->addErrorMessage(str_replace("%s", $this->t_11_head->caption(), $this->t_11_head->RequiredErrorMessage));
                }
            }
            if ($this->t_12_head->Visible && $this->t_12_head->Required) {
                if (!$this->t_12_head->IsDetailKey && EmptyValue($this->t_12_head->FormValue)) {
                    $this->t_12_head->addErrorMessage(str_replace("%s", $this->t_12_head->caption(), $this->t_12_head->RequiredErrorMessage));
                }
            }
            if ($this->t_13_head->Visible && $this->t_13_head->Required) {
                if (!$this->t_13_head->IsDetailKey && EmptyValue($this->t_13_head->FormValue)) {
                    $this->t_13_head->addErrorMessage(str_replace("%s", $this->t_13_head->caption(), $this->t_13_head->RequiredErrorMessage));
                }
            }
            if ($this->t_14_head->Visible && $this->t_14_head->Required) {
                if (!$this->t_14_head->IsDetailKey && EmptyValue($this->t_14_head->FormValue)) {
                    $this->t_14_head->addErrorMessage(str_replace("%s", $this->t_14_head->caption(), $this->t_14_head->RequiredErrorMessage));
                }
            }
            if ($this->t_15_head->Visible && $this->t_15_head->Required) {
                if (!$this->t_15_head->IsDetailKey && EmptyValue($this->t_15_head->FormValue)) {
                    $this->t_15_head->addErrorMessage(str_replace("%s", $this->t_15_head->caption(), $this->t_15_head->RequiredErrorMessage));
                }
            }
            if ($this->po_01_head->Visible && $this->po_01_head->Required) {
                if (!$this->po_01_head->IsDetailKey && EmptyValue($this->po_01_head->FormValue)) {
                    $this->po_01_head->addErrorMessage(str_replace("%s", $this->po_01_head->caption(), $this->po_01_head->RequiredErrorMessage));
                }
            }
            if ($this->po_02_head->Visible && $this->po_02_head->Required) {
                if (!$this->po_02_head->IsDetailKey && EmptyValue($this->po_02_head->FormValue)) {
                    $this->po_02_head->addErrorMessage(str_replace("%s", $this->po_02_head->caption(), $this->po_02_head->RequiredErrorMessage));
                }
            }
            if ($this->po_03_head->Visible && $this->po_03_head->Required) {
                if (!$this->po_03_head->IsDetailKey && EmptyValue($this->po_03_head->FormValue)) {
                    $this->po_03_head->addErrorMessage(str_replace("%s", $this->po_03_head->caption(), $this->po_03_head->RequiredErrorMessage));
                }
            }
            if ($this->po_04_head->Visible && $this->po_04_head->Required) {
                if (!$this->po_04_head->IsDetailKey && EmptyValue($this->po_04_head->FormValue)) {
                    $this->po_04_head->addErrorMessage(str_replace("%s", $this->po_04_head->caption(), $this->po_04_head->RequiredErrorMessage));
                }
            }
            if ($this->po_05_head->Visible && $this->po_05_head->Required) {
                if (!$this->po_05_head->IsDetailKey && EmptyValue($this->po_05_head->FormValue)) {
                    $this->po_05_head->addErrorMessage(str_replace("%s", $this->po_05_head->caption(), $this->po_05_head->RequiredErrorMessage));
                }
            }
            if ($this->po_06_head->Visible && $this->po_06_head->Required) {
                if (!$this->po_06_head->IsDetailKey && EmptyValue($this->po_06_head->FormValue)) {
                    $this->po_06_head->addErrorMessage(str_replace("%s", $this->po_06_head->caption(), $this->po_06_head->RequiredErrorMessage));
                }
            }
            if ($this->po_07_head->Visible && $this->po_07_head->Required) {
                if (!$this->po_07_head->IsDetailKey && EmptyValue($this->po_07_head->FormValue)) {
                    $this->po_07_head->addErrorMessage(str_replace("%s", $this->po_07_head->caption(), $this->po_07_head->RequiredErrorMessage));
                }
            }
            if ($this->po_08_head->Visible && $this->po_08_head->Required) {
                if (!$this->po_08_head->IsDetailKey && EmptyValue($this->po_08_head->FormValue)) {
                    $this->po_08_head->addErrorMessage(str_replace("%s", $this->po_08_head->caption(), $this->po_08_head->RequiredErrorMessage));
                }
            }
            if ($this->po_17_head->Visible && $this->po_17_head->Required) {
                if (!$this->po_17_head->IsDetailKey && EmptyValue($this->po_17_head->FormValue)) {
                    $this->po_17_head->addErrorMessage(str_replace("%s", $this->po_17_head->caption(), $this->po_17_head->RequiredErrorMessage));
                }
            }
            if ($this->po_18_head->Visible && $this->po_18_head->Required) {
                if (!$this->po_18_head->IsDetailKey && EmptyValue($this->po_18_head->FormValue)) {
                    $this->po_18_head->addErrorMessage(str_replace("%s", $this->po_18_head->caption(), $this->po_18_head->RequiredErrorMessage));
                }
            }
            if ($this->po_19_head->Visible && $this->po_19_head->Required) {
                if (!$this->po_19_head->IsDetailKey && EmptyValue($this->po_19_head->FormValue)) {
                    $this->po_19_head->addErrorMessage(str_replace("%s", $this->po_19_head->caption(), $this->po_19_head->RequiredErrorMessage));
                }
            }
            if ($this->po_20_head->Visible && $this->po_20_head->Required) {
                if (!$this->po_20_head->IsDetailKey && EmptyValue($this->po_20_head->FormValue)) {
                    $this->po_20_head->addErrorMessage(str_replace("%s", $this->po_20_head->caption(), $this->po_20_head->RequiredErrorMessage));
                }
            }
            if ($this->jc_01_head->Visible && $this->jc_01_head->Required) {
                if (!$this->jc_01_head->IsDetailKey && EmptyValue($this->jc_01_head->FormValue)) {
                    $this->jc_01_head->addErrorMessage(str_replace("%s", $this->jc_01_head->caption(), $this->jc_01_head->RequiredErrorMessage));
                }
            }
            if ($this->jc_02_head->Visible && $this->jc_02_head->Required) {
                if (!$this->jc_02_head->IsDetailKey && EmptyValue($this->jc_02_head->FormValue)) {
                    $this->jc_02_head->addErrorMessage(str_replace("%s", $this->jc_02_head->caption(), $this->jc_02_head->RequiredErrorMessage));
                }
            }
            if ($this->jc_03_head->Visible && $this->jc_03_head->Required) {
                if (!$this->jc_03_head->IsDetailKey && EmptyValue($this->jc_03_head->FormValue)) {
                    $this->jc_03_head->addErrorMessage(str_replace("%s", $this->jc_03_head->caption(), $this->jc_03_head->RequiredErrorMessage));
                }
            }
            if ($this->jc_04_head->Visible && $this->jc_04_head->Required) {
                if (!$this->jc_04_head->IsDetailKey && EmptyValue($this->jc_04_head->FormValue)) {
                    $this->jc_04_head->addErrorMessage(str_replace("%s", $this->jc_04_head->caption(), $this->jc_04_head->RequiredErrorMessage));
                }
            }
            if ($this->jc_05_head->Visible && $this->jc_05_head->Required) {
                if (!$this->jc_05_head->IsDetailKey && EmptyValue($this->jc_05_head->FormValue)) {
                    $this->jc_05_head->addErrorMessage(str_replace("%s", $this->jc_05_head->caption(), $this->jc_05_head->RequiredErrorMessage));
                }
            }
            if ($this->jc_06_head->Visible && $this->jc_06_head->Required) {
                if (!$this->jc_06_head->IsDetailKey && EmptyValue($this->jc_06_head->FormValue)) {
                    $this->jc_06_head->addErrorMessage(str_replace("%s", $this->jc_06_head->caption(), $this->jc_06_head->RequiredErrorMessage));
                }
            }
            if ($this->jc_07_head->Visible && $this->jc_07_head->Required) {
                if (!$this->jc_07_head->IsDetailKey && EmptyValue($this->jc_07_head->FormValue)) {
                    $this->jc_07_head->addErrorMessage(str_replace("%s", $this->jc_07_head->caption(), $this->jc_07_head->RequiredErrorMessage));
                }
            }
            if ($this->jc_08_head->Visible && $this->jc_08_head->Required) {
                if (!$this->jc_08_head->IsDetailKey && EmptyValue($this->jc_08_head->FormValue)) {
                    $this->jc_08_head->addErrorMessage(str_replace("%s", $this->jc_08_head->caption(), $this->jc_08_head->RequiredErrorMessage));
                }
            }
            if ($this->jc_09_head->Visible && $this->jc_09_head->Required) {
                if (!$this->jc_09_head->IsDetailKey && EmptyValue($this->jc_09_head->FormValue)) {
                    $this->jc_09_head->addErrorMessage(str_replace("%s", $this->jc_09_head->caption(), $this->jc_09_head->RequiredErrorMessage));
                }
            }
            if ($this->jc_10_head->Visible && $this->jc_10_head->Required) {
                if (!$this->jc_10_head->IsDetailKey && EmptyValue($this->jc_10_head->FormValue)) {
                    $this->jc_10_head->addErrorMessage(str_replace("%s", $this->jc_10_head->caption(), $this->jc_10_head->RequiredErrorMessage));
                }
            }
            if ($this->pc_shape->Visible && $this->pc_shape->Required) {
                if (!$this->pc_shape->IsDetailKey && EmptyValue($this->pc_shape->FormValue)) {
                    $this->pc_shape->addErrorMessage(str_replace("%s", $this->pc_shape->caption(), $this->pc_shape->RequiredErrorMessage));
                }
            }
            if ($this->pc_unit->Visible && $this->pc_unit->Required) {
                if (!$this->pc_unit->IsDetailKey && EmptyValue($this->pc_unit->FormValue)) {
                    $this->pc_unit->addErrorMessage(str_replace("%s", $this->pc_unit->caption(), $this->pc_unit->RequiredErrorMessage));
                }
            }
            if ($this->pc_w->Visible && $this->pc_w->Required) {
                if (!$this->pc_w->IsDetailKey && EmptyValue($this->pc_w->FormValue)) {
                    $this->pc_w->addErrorMessage(str_replace("%s", $this->pc_w->caption(), $this->pc_w->RequiredErrorMessage));
                }
            }
            if ($this->pc_l->Visible && $this->pc_l->Required) {
                if (!$this->pc_l->IsDetailKey && EmptyValue($this->pc_l->FormValue)) {
                    $this->pc_l->addErrorMessage(str_replace("%s", $this->pc_l->caption(), $this->pc_l->RequiredErrorMessage));
                }
            }
            if ($this->pc_h->Visible && $this->pc_h->Required) {
                if (!$this->pc_h->IsDetailKey && EmptyValue($this->pc_h->FormValue)) {
                    $this->pc_h->addErrorMessage(str_replace("%s", $this->pc_h->caption(), $this->pc_h->RequiredErrorMessage));
                }
            }
            if ($this->pc_partner_size->Visible && $this->pc_partner_size->Required) {
                if (!$this->pc_partner_size->IsDetailKey && EmptyValue($this->pc_partner_size->FormValue)) {
                    $this->pc_partner_size->addErrorMessage(str_replace("%s", $this->pc_partner_size->caption(), $this->pc_partner_size->RequiredErrorMessage));
                }
            }
            if ($this->pc_sqm->Visible && $this->pc_sqm->Required) {
                if (!$this->pc_sqm->IsDetailKey && EmptyValue($this->pc_sqm->FormValue)) {
                    $this->pc_sqm->addErrorMessage(str_replace("%s", $this->pc_sqm->caption(), $this->pc_sqm->RequiredErrorMessage));
                }
            }
            if ($this->pc_01_head->Visible && $this->pc_01_head->Required) {
                if (!$this->pc_01_head->IsDetailKey && EmptyValue($this->pc_01_head->FormValue)) {
                    $this->pc_01_head->addErrorMessage(str_replace("%s", $this->pc_01_head->caption(), $this->pc_01_head->RequiredErrorMessage));
                }
            }
            if ($this->pc_02_head->Visible && $this->pc_02_head->Required) {
                if (!$this->pc_02_head->IsDetailKey && EmptyValue($this->pc_02_head->FormValue)) {
                    $this->pc_02_head->addErrorMessage(str_replace("%s", $this->pc_02_head->caption(), $this->pc_02_head->RequiredErrorMessage));
                }
            }
            if ($this->pc_03_head->Visible && $this->pc_03_head->Required) {
                if (!$this->pc_03_head->IsDetailKey && EmptyValue($this->pc_03_head->FormValue)) {
                    $this->pc_03_head->addErrorMessage(str_replace("%s", $this->pc_03_head->caption(), $this->pc_03_head->RequiredErrorMessage));
                }
            }
            if ($this->pc_04_head->Visible && $this->pc_04_head->Required) {
                if (!$this->pc_04_head->IsDetailKey && EmptyValue($this->pc_04_head->FormValue)) {
                    $this->pc_04_head->addErrorMessage(str_replace("%s", $this->pc_04_head->caption(), $this->pc_04_head->RequiredErrorMessage));
                }
            }
            if ($this->pc_05_head->Visible && $this->pc_05_head->Required) {
                if (!$this->pc_05_head->IsDetailKey && EmptyValue($this->pc_05_head->FormValue)) {
                    $this->pc_05_head->addErrorMessage(str_replace("%s", $this->pc_05_head->caption(), $this->pc_05_head->RequiredErrorMessage));
                }
            }
            if ($this->pc_06_head->Visible && $this->pc_06_head->Required) {
                if (!$this->pc_06_head->IsDetailKey && EmptyValue($this->pc_06_head->FormValue)) {
                    $this->pc_06_head->addErrorMessage(str_replace("%s", $this->pc_06_head->caption(), $this->pc_06_head->RequiredErrorMessage));
                }
            }
            if ($this->pc_07_head->Visible && $this->pc_07_head->Required) {
                if (!$this->pc_07_head->IsDetailKey && EmptyValue($this->pc_07_head->FormValue)) {
                    $this->pc_07_head->addErrorMessage(str_replace("%s", $this->pc_07_head->caption(), $this->pc_07_head->RequiredErrorMessage));
                }
            }
            if ($this->pc_08_head->Visible && $this->pc_08_head->Required) {
                if (!$this->pc_08_head->IsDetailKey && EmptyValue($this->pc_08_head->FormValue)) {
                    $this->pc_08_head->addErrorMessage(str_replace("%s", $this->pc_08_head->caption(), $this->pc_08_head->RequiredErrorMessage));
                }
            }
            if ($this->pc_09_head->Visible && $this->pc_09_head->Required) {
                if (!$this->pc_09_head->IsDetailKey && EmptyValue($this->pc_09_head->FormValue)) {
                    $this->pc_09_head->addErrorMessage(str_replace("%s", $this->pc_09_head->caption(), $this->pc_09_head->RequiredErrorMessage));
                }
            }
            if ($this->pc_10_head->Visible && $this->pc_10_head->Required) {
                if (!$this->pc_10_head->IsDetailKey && EmptyValue($this->pc_10_head->FormValue)) {
                    $this->pc_10_head->addErrorMessage(str_replace("%s", $this->pc_10_head->caption(), $this->pc_10_head->RequiredErrorMessage));
                }
            }
            if ($this->pc_11_head->Visible && $this->pc_11_head->Required) {
                if (!$this->pc_11_head->IsDetailKey && EmptyValue($this->pc_11_head->FormValue)) {
                    $this->pc_11_head->addErrorMessage(str_replace("%s", $this->pc_11_head->caption(), $this->pc_11_head->RequiredErrorMessage));
                }
            }
            if ($this->pc_12_head->Visible && $this->pc_12_head->Required) {
                if (!$this->pc_12_head->IsDetailKey && EmptyValue($this->pc_12_head->FormValue)) {
                    $this->pc_12_head->addErrorMessage(str_replace("%s", $this->pc_12_head->caption(), $this->pc_12_head->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->image->Visible && $this->image->Required) {
                if ($this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
                    $this->image->addErrorMessage(str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
                }
            }
            if ($this->pa_process_size_w->Visible && $this->pa_process_size_w->Required) {
                if (!$this->pa_process_size_w->IsDetailKey && EmptyValue($this->pa_process_size_w->FormValue)) {
                    $this->pa_process_size_w->addErrorMessage(str_replace("%s", $this->pa_process_size_w->caption(), $this->pa_process_size_w->RequiredErrorMessage));
                }
            }
            if ($this->pa_process_size_l->Visible && $this->pa_process_size_l->Required) {
                if (!$this->pa_process_size_l->IsDetailKey && EmptyValue($this->pa_process_size_l->FormValue)) {
                    $this->pa_process_size_l->addErrorMessage(str_replace("%s", $this->pa_process_size_l->caption(), $this->pa_process_size_l->RequiredErrorMessage));
                }
            }
            if ($this->pa_head_01->Visible && $this->pa_head_01->Required) {
                if (!$this->pa_head_01->IsDetailKey && EmptyValue($this->pa_head_01->FormValue)) {
                    $this->pa_head_01->addErrorMessage(str_replace("%s", $this->pa_head_01->caption(), $this->pa_head_01->RequiredErrorMessage));
                }
            }
            if ($this->pa_process_01->Visible && $this->pa_process_01->Required) {
                if ($this->pa_process_01->FormValue == "") {
                    $this->pa_process_01->addErrorMessage(str_replace("%s", $this->pa_process_01->caption(), $this->pa_process_01->RequiredErrorMessage));
                }
            }
            if ($this->pa_head_02->Visible && $this->pa_head_02->Required) {
                if (!$this->pa_head_02->IsDetailKey && EmptyValue($this->pa_head_02->FormValue)) {
                    $this->pa_head_02->addErrorMessage(str_replace("%s", $this->pa_head_02->caption(), $this->pa_head_02->RequiredErrorMessage));
                }
            }
            if ($this->pa_process_02->Visible && $this->pa_process_02->Required) {
                if ($this->pa_process_02->FormValue == "") {
                    $this->pa_process_02->addErrorMessage(str_replace("%s", $this->pa_process_02->caption(), $this->pa_process_02->RequiredErrorMessage));
                }
            }
            if ($this->pa_head_03->Visible && $this->pa_head_03->Required) {
                if (!$this->pa_head_03->IsDetailKey && EmptyValue($this->pa_head_03->FormValue)) {
                    $this->pa_head_03->addErrorMessage(str_replace("%s", $this->pa_head_03->caption(), $this->pa_head_03->RequiredErrorMessage));
                }
            }
            if ($this->pa_process_03->Visible && $this->pa_process_03->Required) {
                if ($this->pa_process_03->FormValue == "") {
                    $this->pa_process_03->addErrorMessage(str_replace("%s", $this->pa_process_03->caption(), $this->pa_process_03->RequiredErrorMessage));
                }
            }
            if ($this->pa_head_04->Visible && $this->pa_head_04->Required) {
                if (!$this->pa_head_04->IsDetailKey && EmptyValue($this->pa_head_04->FormValue)) {
                    $this->pa_head_04->addErrorMessage(str_replace("%s", $this->pa_head_04->caption(), $this->pa_head_04->RequiredErrorMessage));
                }
            }
            if ($this->pa_process_04->Visible && $this->pa_process_04->Required) {
                if ($this->pa_process_04->FormValue == "") {
                    $this->pa_process_04->addErrorMessage(str_replace("%s", $this->pa_process_04->caption(), $this->pa_process_04->RequiredErrorMessage));
                }
            }
            if ($this->pa_head_05->Visible && $this->pa_head_05->Required) {
                if (!$this->pa_head_05->IsDetailKey && EmptyValue($this->pa_head_05->FormValue)) {
                    $this->pa_head_05->addErrorMessage(str_replace("%s", $this->pa_head_05->caption(), $this->pa_head_05->RequiredErrorMessage));
                }
            }
            if ($this->pa_process_05->Visible && $this->pa_process_05->Required) {
                if ($this->pa_process_05->FormValue == "") {
                    $this->pa_process_05->addErrorMessage(str_replace("%s", $this->pa_process_05->caption(), $this->pa_process_05->RequiredErrorMessage));
                }
            }
            if ($this->pa_head_06->Visible && $this->pa_head_06->Required) {
                if (!$this->pa_head_06->IsDetailKey && EmptyValue($this->pa_head_06->FormValue)) {
                    $this->pa_head_06->addErrorMessage(str_replace("%s", $this->pa_head_06->caption(), $this->pa_head_06->RequiredErrorMessage));
                }
            }
            if ($this->pa_process_06->Visible && $this->pa_process_06->Required) {
                if ($this->pa_process_06->FormValue == "") {
                    $this->pa_process_06->addErrorMessage(str_replace("%s", $this->pa_process_06->caption(), $this->pa_process_06->RequiredErrorMessage));
                }
            }
            if ($this->pa_head_07->Visible && $this->pa_head_07->Required) {
                if (!$this->pa_head_07->IsDetailKey && EmptyValue($this->pa_head_07->FormValue)) {
                    $this->pa_head_07->addErrorMessage(str_replace("%s", $this->pa_head_07->caption(), $this->pa_head_07->RequiredErrorMessage));
                }
            }
            if ($this->pa_process_07->Visible && $this->pa_process_07->Required) {
                if ($this->pa_process_07->FormValue == "") {
                    $this->pa_process_07->addErrorMessage(str_replace("%s", $this->pa_process_07->caption(), $this->pa_process_07->RequiredErrorMessage));
                }
            }
            if ($this->pa_head_08->Visible && $this->pa_head_08->Required) {
                if (!$this->pa_head_08->IsDetailKey && EmptyValue($this->pa_head_08->FormValue)) {
                    $this->pa_head_08->addErrorMessage(str_replace("%s", $this->pa_head_08->caption(), $this->pa_head_08->RequiredErrorMessage));
                }
            }
            if ($this->pa_process_08->Visible && $this->pa_process_08->Required) {
                if ($this->pa_process_08->FormValue == "") {
                    $this->pa_process_08->addErrorMessage(str_replace("%s", $this->pa_process_08->caption(), $this->pa_process_08->RequiredErrorMessage));
                }
            }
            if ($this->pa_head_09->Visible && $this->pa_head_09->Required) {
                if (!$this->pa_head_09->IsDetailKey && EmptyValue($this->pa_head_09->FormValue)) {
                    $this->pa_head_09->addErrorMessage(str_replace("%s", $this->pa_head_09->caption(), $this->pa_head_09->RequiredErrorMessage));
                }
            }
            if ($this->pa_process_09->Visible && $this->pa_process_09->Required) {
                if ($this->pa_process_09->FormValue == "") {
                    $this->pa_process_09->addErrorMessage(str_replace("%s", $this->pa_process_09->caption(), $this->pa_process_09->RequiredErrorMessage));
                }
            }
            if ($this->pa_head_10->Visible && $this->pa_head_10->Required) {
                if (!$this->pa_head_10->IsDetailKey && EmptyValue($this->pa_head_10->FormValue)) {
                    $this->pa_head_10->addErrorMessage(str_replace("%s", $this->pa_head_10->caption(), $this->pa_head_10->RequiredErrorMessage));
                }
            }
            if ($this->pa_process_10->Visible && $this->pa_process_10->Required) {
                if ($this->pa_process_10->FormValue == "") {
                    $this->pa_process_10->addErrorMessage(str_replace("%s", $this->pa_process_10->caption(), $this->pa_process_10->RequiredErrorMessage));
                }
            }
            if ($this->publish->Visible && $this->publish->Required) {
                if (!$this->publish->IsDetailKey && EmptyValue($this->publish->FormValue)) {
                    $this->publish->addErrorMessage(str_replace("%s", $this->publish->caption(), $this->publish->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->publish->FormValue)) {
                $this->publish->addErrorMessage($this->publish->getErrorMessage(false));
            }
            if ($this->ppr_01->Visible && $this->ppr_01->Required) {
                if (!$this->ppr_01->IsDetailKey && EmptyValue($this->ppr_01->FormValue)) {
                    $this->ppr_01->addErrorMessage(str_replace("%s", $this->ppr_01->caption(), $this->ppr_01->RequiredErrorMessage));
                }
            }
            if ($this->ppr_02->Visible && $this->ppr_02->Required) {
                if (!$this->ppr_02->IsDetailKey && EmptyValue($this->ppr_02->FormValue)) {
                    $this->ppr_02->addErrorMessage(str_replace("%s", $this->ppr_02->caption(), $this->ppr_02->RequiredErrorMessage));
                }
            }
            if ($this->ppr_03->Visible && $this->ppr_03->Required) {
                if (!$this->ppr_03->IsDetailKey && EmptyValue($this->ppr_03->FormValue)) {
                    $this->ppr_03->addErrorMessage(str_replace("%s", $this->ppr_03->caption(), $this->ppr_03->RequiredErrorMessage));
                }
            }
            if ($this->ppr_04->Visible && $this->ppr_04->Required) {
                if (!$this->ppr_04->IsDetailKey && EmptyValue($this->ppr_04->FormValue)) {
                    $this->ppr_04->addErrorMessage(str_replace("%s", $this->ppr_04->caption(), $this->ppr_04->RequiredErrorMessage));
                }
            }
            if ($this->ppr_05->Visible && $this->ppr_05->Required) {
                if (!$this->ppr_05->IsDetailKey && EmptyValue($this->ppr_05->FormValue)) {
                    $this->ppr_05->addErrorMessage(str_replace("%s", $this->ppr_05->caption(), $this->ppr_05->RequiredErrorMessage));
                }
            }
            if ($this->ppr_06->Visible && $this->ppr_06->Required) {
                if (!$this->ppr_06->IsDetailKey && EmptyValue($this->ppr_06->FormValue)) {
                    $this->ppr_06->addErrorMessage(str_replace("%s", $this->ppr_06->caption(), $this->ppr_06->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->image->Visible && !$this->image->Upload->KeepFile) {
            $this->image->UploadPath = $this->image->getUploadPath();
            if (!EmptyValue($this->image->Upload->FileName)) {
                FixUploadFileNames($this->image);
                $this->image->setDbValueDef($rsnew, $this->image->Upload->FileName, $this->image->ReadOnly);
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
                if ($this->image->Visible && !$this->image->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->image, $rsnew['image'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $this->image->UploadPath = $this->image->OldUploadPath;
        $rsnew = [];

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, $this->grp->ReadOnly);

        // product_group
        $this->product_group->setDbValueDef($rsnew, $this->product_group->CurrentValue, $this->product_group->ReadOnly);

        // calculation_method
        $this->calculation_method->setDbValueDef($rsnew, $this->calculation_method->CurrentValue, $this->calculation_method->ReadOnly);

        // shape
        $this->shape->setDbValueDef($rsnew, $this->shape->CurrentValue, $this->shape->ReadOnly);

        // sqm
        $this->sqm->setDbValueDef($rsnew, $this->sqm->CurrentValue, $this->sqm->ReadOnly);

        // cbm
        $this->cbm->setDbValueDef($rsnew, $this->cbm->CurrentValue, $this->cbm->ReadOnly);

        // process
        $this->process->setDbValueDef($rsnew, $this->process->CurrentValue, $this->process->ReadOnly);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, $this->status->ReadOnly);

        // v_00
        $this->v_00->setDbValueDef($rsnew, $this->v_00->CurrentValue, $this->v_00->ReadOnly);

        // v_01
        $this->v_01->setDbValueDef($rsnew, $this->v_01->CurrentValue, $this->v_01->ReadOnly);

        // v_01_validation
        $this->v_01_validation->setDbValueDef($rsnew, $this->v_01_validation->CurrentValue, $this->v_01_validation->ReadOnly);

        // v_02
        $this->v_02->setDbValueDef($rsnew, $this->v_02->CurrentValue, $this->v_02->ReadOnly);

        // v_02_validation
        $this->v_02_validation->setDbValueDef($rsnew, $this->v_02_validation->CurrentValue, $this->v_02_validation->ReadOnly);

        // v_03
        $this->v_03->setDbValueDef($rsnew, $this->v_03->CurrentValue, $this->v_03->ReadOnly);

        // v_03_validation
        $this->v_03_validation->setDbValueDef($rsnew, $this->v_03_validation->CurrentValue, $this->v_03_validation->ReadOnly);

        // v_04
        $this->v_04->setDbValueDef($rsnew, $this->v_04->CurrentValue, $this->v_04->ReadOnly);

        // v_04_validation
        $this->v_04_validation->setDbValueDef($rsnew, $this->v_04_validation->CurrentValue, $this->v_04_validation->ReadOnly);

        // v_05
        $this->v_05->setDbValueDef($rsnew, $this->v_05->CurrentValue, $this->v_05->ReadOnly);

        // v_05_validation
        $this->v_05_validation->setDbValueDef($rsnew, $this->v_05_validation->CurrentValue, $this->v_05_validation->ReadOnly);

        // v_06
        $this->v_06->setDbValueDef($rsnew, $this->v_06->CurrentValue, $this->v_06->ReadOnly);

        // v_06_validation
        $this->v_06_validation->setDbValueDef($rsnew, $this->v_06_validation->CurrentValue, $this->v_06_validation->ReadOnly);

        // v_07
        $this->v_07->setDbValueDef($rsnew, $this->v_07->CurrentValue, $this->v_07->ReadOnly);

        // v_07_validation
        $this->v_07_validation->setDbValueDef($rsnew, $this->v_07_validation->CurrentValue, $this->v_07_validation->ReadOnly);

        // v_08
        $this->v_08->setDbValueDef($rsnew, $this->v_08->CurrentValue, $this->v_08->ReadOnly);

        // v_08_validation
        $this->v_08_validation->setDbValueDef($rsnew, $this->v_08_validation->CurrentValue, $this->v_08_validation->ReadOnly);

        // v_09
        $this->v_09->setDbValueDef($rsnew, $this->v_09->CurrentValue, $this->v_09->ReadOnly);

        // v_09_validation
        $this->v_09_validation->setDbValueDef($rsnew, $this->v_09_validation->CurrentValue, $this->v_09_validation->ReadOnly);

        // v_10
        $this->v_10->setDbValueDef($rsnew, $this->v_10->CurrentValue, $this->v_10->ReadOnly);

        // v_10_validation
        $this->v_10_validation->setDbValueDef($rsnew, $this->v_10_validation->CurrentValue, $this->v_10_validation->ReadOnly);

        // b_01_head
        $this->b_01_head->setDbValueDef($rsnew, $this->b_01_head->CurrentValue, $this->b_01_head->ReadOnly);

        // b_02_head
        $this->b_02_head->setDbValueDef($rsnew, $this->b_02_head->CurrentValue, $this->b_02_head->ReadOnly);

        // b_03_head
        $this->b_03_head->setDbValueDef($rsnew, $this->b_03_head->CurrentValue, $this->b_03_head->ReadOnly);

        // b_04_head
        $this->b_04_head->setDbValueDef($rsnew, $this->b_04_head->CurrentValue, $this->b_04_head->ReadOnly);

        // b_05_head
        $this->b_05_head->setDbValueDef($rsnew, $this->b_05_head->CurrentValue, $this->b_05_head->ReadOnly);

        // b_06_head
        $this->b_06_head->setDbValueDef($rsnew, $this->b_06_head->CurrentValue, $this->b_06_head->ReadOnly);

        // b_07_head
        $this->b_07_head->setDbValueDef($rsnew, $this->b_07_head->CurrentValue, $this->b_07_head->ReadOnly);

        // b_08_head
        $this->b_08_head->setDbValueDef($rsnew, $this->b_08_head->CurrentValue, $this->b_08_head->ReadOnly);

        // b_09_head
        $this->b_09_head->setDbValueDef($rsnew, $this->b_09_head->CurrentValue, $this->b_09_head->ReadOnly);

        // b_10_head
        $this->b_10_head->setDbValueDef($rsnew, $this->b_10_head->CurrentValue, $this->b_10_head->ReadOnly);

        // b_11_head
        $this->b_11_head->setDbValueDef($rsnew, $this->b_11_head->CurrentValue, $this->b_11_head->ReadOnly);

        // b_12_head
        $this->b_12_head->setDbValueDef($rsnew, $this->b_12_head->CurrentValue, $this->b_12_head->ReadOnly);

        // b_13_head
        $this->b_13_head->setDbValueDef($rsnew, $this->b_13_head->CurrentValue, $this->b_13_head->ReadOnly);

        // b_14_head
        $this->b_14_head->setDbValueDef($rsnew, $this->b_14_head->CurrentValue, $this->b_14_head->ReadOnly);

        // b_15_head
        $this->b_15_head->setDbValueDef($rsnew, $this->b_15_head->CurrentValue, $this->b_15_head->ReadOnly);

        // q_sku
        $this->q_sku->setDbValueDef($rsnew, $this->q_sku->CurrentValue, $this->q_sku->ReadOnly);

        // t_01_head
        $this->t_01_head->setDbValueDef($rsnew, $this->t_01_head->CurrentValue, $this->t_01_head->ReadOnly);

        // t_02_head
        $this->t_02_head->setDbValueDef($rsnew, $this->t_02_head->CurrentValue, $this->t_02_head->ReadOnly);

        // t_03_head
        $this->t_03_head->setDbValueDef($rsnew, $this->t_03_head->CurrentValue, $this->t_03_head->ReadOnly);

        // t_04_head
        $this->t_04_head->setDbValueDef($rsnew, $this->t_04_head->CurrentValue, $this->t_04_head->ReadOnly);

        // t_05_head
        $this->t_05_head->setDbValueDef($rsnew, $this->t_05_head->CurrentValue, $this->t_05_head->ReadOnly);

        // t_06_head
        $this->t_06_head->setDbValueDef($rsnew, $this->t_06_head->CurrentValue, $this->t_06_head->ReadOnly);

        // t_07_head
        $this->t_07_head->setDbValueDef($rsnew, $this->t_07_head->CurrentValue, $this->t_07_head->ReadOnly);

        // t_08_head
        $this->t_08_head->setDbValueDef($rsnew, $this->t_08_head->CurrentValue, $this->t_08_head->ReadOnly);

        // t_09_head
        $this->t_09_head->setDbValueDef($rsnew, $this->t_09_head->CurrentValue, $this->t_09_head->ReadOnly);

        // t_10_head
        $this->t_10_head->setDbValueDef($rsnew, $this->t_10_head->CurrentValue, $this->t_10_head->ReadOnly);

        // t_11_head
        $this->t_11_head->setDbValueDef($rsnew, $this->t_11_head->CurrentValue, $this->t_11_head->ReadOnly);

        // t_12_head
        $this->t_12_head->setDbValueDef($rsnew, $this->t_12_head->CurrentValue, $this->t_12_head->ReadOnly);

        // t_13_head
        $this->t_13_head->setDbValueDef($rsnew, $this->t_13_head->CurrentValue, $this->t_13_head->ReadOnly);

        // t_14_head
        $this->t_14_head->setDbValueDef($rsnew, $this->t_14_head->CurrentValue, $this->t_14_head->ReadOnly);

        // t_15_head
        $this->t_15_head->setDbValueDef($rsnew, $this->t_15_head->CurrentValue, $this->t_15_head->ReadOnly);

        // po_01_head
        $this->po_01_head->setDbValueDef($rsnew, $this->po_01_head->CurrentValue, $this->po_01_head->ReadOnly);

        // po_02_head
        $this->po_02_head->setDbValueDef($rsnew, $this->po_02_head->CurrentValue, $this->po_02_head->ReadOnly);

        // po_03_head
        $this->po_03_head->setDbValueDef($rsnew, $this->po_03_head->CurrentValue, $this->po_03_head->ReadOnly);

        // po_04_head
        $this->po_04_head->setDbValueDef($rsnew, $this->po_04_head->CurrentValue, $this->po_04_head->ReadOnly);

        // po_05_head
        $this->po_05_head->setDbValueDef($rsnew, $this->po_05_head->CurrentValue, $this->po_05_head->ReadOnly);

        // po_06_head
        $this->po_06_head->setDbValueDef($rsnew, $this->po_06_head->CurrentValue, $this->po_06_head->ReadOnly);

        // po_07_head
        $this->po_07_head->setDbValueDef($rsnew, $this->po_07_head->CurrentValue, $this->po_07_head->ReadOnly);

        // po_08_head
        $this->po_08_head->setDbValueDef($rsnew, $this->po_08_head->CurrentValue, $this->po_08_head->ReadOnly);

        // po_17_head
        $this->po_17_head->setDbValueDef($rsnew, $this->po_17_head->CurrentValue, $this->po_17_head->ReadOnly);

        // po_18_head
        $this->po_18_head->setDbValueDef($rsnew, $this->po_18_head->CurrentValue, $this->po_18_head->ReadOnly);

        // po_19_head
        $this->po_19_head->setDbValueDef($rsnew, $this->po_19_head->CurrentValue, $this->po_19_head->ReadOnly);

        // po_20_head
        $this->po_20_head->setDbValueDef($rsnew, $this->po_20_head->CurrentValue, $this->po_20_head->ReadOnly);

        // jc_01_head
        $this->jc_01_head->setDbValueDef($rsnew, $this->jc_01_head->CurrentValue, $this->jc_01_head->ReadOnly);

        // jc_02_head
        $this->jc_02_head->setDbValueDef($rsnew, $this->jc_02_head->CurrentValue, $this->jc_02_head->ReadOnly);

        // jc_03_head
        $this->jc_03_head->setDbValueDef($rsnew, $this->jc_03_head->CurrentValue, $this->jc_03_head->ReadOnly);

        // jc_04_head
        $this->jc_04_head->setDbValueDef($rsnew, $this->jc_04_head->CurrentValue, $this->jc_04_head->ReadOnly);

        // jc_05_head
        $this->jc_05_head->setDbValueDef($rsnew, $this->jc_05_head->CurrentValue, $this->jc_05_head->ReadOnly);

        // jc_06_head
        $this->jc_06_head->setDbValueDef($rsnew, $this->jc_06_head->CurrentValue, $this->jc_06_head->ReadOnly);

        // jc_07_head
        $this->jc_07_head->setDbValueDef($rsnew, $this->jc_07_head->CurrentValue, $this->jc_07_head->ReadOnly);

        // jc_08_head
        $this->jc_08_head->setDbValueDef($rsnew, $this->jc_08_head->CurrentValue, $this->jc_08_head->ReadOnly);

        // jc_09_head
        $this->jc_09_head->setDbValueDef($rsnew, $this->jc_09_head->CurrentValue, $this->jc_09_head->ReadOnly);

        // jc_10_head
        $this->jc_10_head->setDbValueDef($rsnew, $this->jc_10_head->CurrentValue, $this->jc_10_head->ReadOnly);

        // pc_shape
        $this->pc_shape->setDbValueDef($rsnew, $this->pc_shape->CurrentValue, $this->pc_shape->ReadOnly);

        // pc_unit
        $this->pc_unit->setDbValueDef($rsnew, $this->pc_unit->CurrentValue, $this->pc_unit->ReadOnly);

        // pc_w
        $this->pc_w->setDbValueDef($rsnew, $this->pc_w->CurrentValue, $this->pc_w->ReadOnly);

        // pc_l
        $this->pc_l->setDbValueDef($rsnew, $this->pc_l->CurrentValue, $this->pc_l->ReadOnly);

        // pc_h
        $this->pc_h->setDbValueDef($rsnew, $this->pc_h->CurrentValue, $this->pc_h->ReadOnly);

        // pc_partner_size
        $this->pc_partner_size->setDbValueDef($rsnew, $this->pc_partner_size->CurrentValue, $this->pc_partner_size->ReadOnly);

        // pc_sqm
        $this->pc_sqm->setDbValueDef($rsnew, $this->pc_sqm->CurrentValue, $this->pc_sqm->ReadOnly);

        // pc_01_head
        $this->pc_01_head->setDbValueDef($rsnew, $this->pc_01_head->CurrentValue, $this->pc_01_head->ReadOnly);

        // pc_02_head
        $this->pc_02_head->setDbValueDef($rsnew, $this->pc_02_head->CurrentValue, $this->pc_02_head->ReadOnly);

        // pc_03_head
        $this->pc_03_head->setDbValueDef($rsnew, $this->pc_03_head->CurrentValue, $this->pc_03_head->ReadOnly);

        // pc_04_head
        $this->pc_04_head->setDbValueDef($rsnew, $this->pc_04_head->CurrentValue, $this->pc_04_head->ReadOnly);

        // pc_05_head
        $this->pc_05_head->setDbValueDef($rsnew, $this->pc_05_head->CurrentValue, $this->pc_05_head->ReadOnly);

        // pc_06_head
        $this->pc_06_head->setDbValueDef($rsnew, $this->pc_06_head->CurrentValue, $this->pc_06_head->ReadOnly);

        // pc_07_head
        $this->pc_07_head->setDbValueDef($rsnew, $this->pc_07_head->CurrentValue, $this->pc_07_head->ReadOnly);

        // pc_08_head
        $this->pc_08_head->setDbValueDef($rsnew, $this->pc_08_head->CurrentValue, $this->pc_08_head->ReadOnly);

        // pc_09_head
        $this->pc_09_head->setDbValueDef($rsnew, $this->pc_09_head->CurrentValue, $this->pc_09_head->ReadOnly);

        // pc_10_head
        $this->pc_10_head->setDbValueDef($rsnew, $this->pc_10_head->CurrentValue, $this->pc_10_head->ReadOnly);

        // pc_11_head
        $this->pc_11_head->setDbValueDef($rsnew, $this->pc_11_head->CurrentValue, $this->pc_11_head->ReadOnly);

        // pc_12_head
        $this->pc_12_head->setDbValueDef($rsnew, $this->pc_12_head->CurrentValue, $this->pc_12_head->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);

        // image
        if ($this->image->Visible && !$this->image->ReadOnly && !$this->image->Upload->KeepFile) {
            if ($this->image->Upload->FileName == "") {
                $rsnew['image'] = null;
            } else {
                FixUploadTempFileNames($this->image);
                $rsnew['image'] = $this->image->Upload->FileName;
            }
            $this->image->ImageWidth = 300; // Resize width
            $this->image->ImageHeight = 300; // Resize height
        }

        // pa_process_size_w
        $this->pa_process_size_w->setDbValueDef($rsnew, $this->pa_process_size_w->CurrentValue, $this->pa_process_size_w->ReadOnly);

        // pa_process_size_l
        $this->pa_process_size_l->setDbValueDef($rsnew, $this->pa_process_size_l->CurrentValue, $this->pa_process_size_l->ReadOnly);

        // pa_head_01
        $this->pa_head_01->setDbValueDef($rsnew, $this->pa_head_01->CurrentValue, $this->pa_head_01->ReadOnly);

        // pa_process_01
        $this->pa_process_01->setDbValueDef($rsnew, $this->pa_process_01->CurrentValue, $this->pa_process_01->ReadOnly);

        // pa_head_02
        $this->pa_head_02->setDbValueDef($rsnew, $this->pa_head_02->CurrentValue, $this->pa_head_02->ReadOnly);

        // pa_process_02
        $this->pa_process_02->setDbValueDef($rsnew, $this->pa_process_02->CurrentValue, $this->pa_process_02->ReadOnly);

        // pa_head_03
        $this->pa_head_03->setDbValueDef($rsnew, $this->pa_head_03->CurrentValue, $this->pa_head_03->ReadOnly);

        // pa_process_03
        $this->pa_process_03->setDbValueDef($rsnew, $this->pa_process_03->CurrentValue, $this->pa_process_03->ReadOnly);

        // pa_head_04
        $this->pa_head_04->setDbValueDef($rsnew, $this->pa_head_04->CurrentValue, $this->pa_head_04->ReadOnly);

        // pa_process_04
        $this->pa_process_04->setDbValueDef($rsnew, $this->pa_process_04->CurrentValue, $this->pa_process_04->ReadOnly);

        // pa_head_05
        $this->pa_head_05->setDbValueDef($rsnew, $this->pa_head_05->CurrentValue, $this->pa_head_05->ReadOnly);

        // pa_process_05
        $this->pa_process_05->setDbValueDef($rsnew, $this->pa_process_05->CurrentValue, $this->pa_process_05->ReadOnly);

        // pa_head_06
        $this->pa_head_06->setDbValueDef($rsnew, $this->pa_head_06->CurrentValue, $this->pa_head_06->ReadOnly);

        // pa_process_06
        $this->pa_process_06->setDbValueDef($rsnew, $this->pa_process_06->CurrentValue, $this->pa_process_06->ReadOnly);

        // pa_head_07
        $this->pa_head_07->setDbValueDef($rsnew, $this->pa_head_07->CurrentValue, $this->pa_head_07->ReadOnly);

        // pa_process_07
        $this->pa_process_07->setDbValueDef($rsnew, $this->pa_process_07->CurrentValue, $this->pa_process_07->ReadOnly);

        // pa_head_08
        $this->pa_head_08->setDbValueDef($rsnew, $this->pa_head_08->CurrentValue, $this->pa_head_08->ReadOnly);

        // pa_process_08
        $this->pa_process_08->setDbValueDef($rsnew, $this->pa_process_08->CurrentValue, $this->pa_process_08->ReadOnly);

        // pa_head_09
        $this->pa_head_09->setDbValueDef($rsnew, $this->pa_head_09->CurrentValue, $this->pa_head_09->ReadOnly);

        // pa_process_09
        $this->pa_process_09->setDbValueDef($rsnew, $this->pa_process_09->CurrentValue, $this->pa_process_09->ReadOnly);

        // pa_head_10
        $this->pa_head_10->setDbValueDef($rsnew, $this->pa_head_10->CurrentValue, $this->pa_head_10->ReadOnly);

        // pa_process_10
        $this->pa_process_10->setDbValueDef($rsnew, $this->pa_process_10->CurrentValue, $this->pa_process_10->ReadOnly);

        // publish
        $this->publish->setDbValueDef($rsnew, $this->publish->CurrentValue, $this->publish->ReadOnly);

        // ppr_01
        $this->ppr_01->setDbValueDef($rsnew, $this->ppr_01->CurrentValue, $this->ppr_01->ReadOnly);

        // ppr_02
        $this->ppr_02->setDbValueDef($rsnew, $this->ppr_02->CurrentValue, $this->ppr_02->ReadOnly);

        // ppr_03
        $this->ppr_03->setDbValueDef($rsnew, $this->ppr_03->CurrentValue, $this->ppr_03->ReadOnly);

        // ppr_04
        $this->ppr_04->setDbValueDef($rsnew, $this->ppr_04->CurrentValue, $this->ppr_04->ReadOnly);

        // ppr_05
        $this->ppr_05->setDbValueDef($rsnew, $this->ppr_05->CurrentValue, $this->ppr_05->ReadOnly);

        // ppr_06
        $this->ppr_06->setDbValueDef($rsnew, $this->ppr_06->CurrentValue, $this->ppr_06->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['grp'])) { // grp
            $this->grp->CurrentValue = $row['grp'];
        }
        if (isset($row['product_group'])) { // product_group
            $this->product_group->CurrentValue = $row['product_group'];
        }
        if (isset($row['calculation_method'])) { // calculation_method
            $this->calculation_method->CurrentValue = $row['calculation_method'];
        }
        if (isset($row['shape'])) { // shape
            $this->shape->CurrentValue = $row['shape'];
        }
        if (isset($row['sqm'])) { // sqm
            $this->sqm->CurrentValue = $row['sqm'];
        }
        if (isset($row['cbm'])) { // cbm
            $this->cbm->CurrentValue = $row['cbm'];
        }
        if (isset($row['process'])) { // process
            $this->process->CurrentValue = $row['process'];
        }
        if (isset($row['status'])) { // status
            $this->status->CurrentValue = $row['status'];
        }
        if (isset($row['v_00'])) { // v_00
            $this->v_00->CurrentValue = $row['v_00'];
        }
        if (isset($row['v_01'])) { // v_01
            $this->v_01->CurrentValue = $row['v_01'];
        }
        if (isset($row['v_01_validation'])) { // v_01_validation
            $this->v_01_validation->CurrentValue = $row['v_01_validation'];
        }
        if (isset($row['v_02'])) { // v_02
            $this->v_02->CurrentValue = $row['v_02'];
        }
        if (isset($row['v_02_validation'])) { // v_02_validation
            $this->v_02_validation->CurrentValue = $row['v_02_validation'];
        }
        if (isset($row['v_03'])) { // v_03
            $this->v_03->CurrentValue = $row['v_03'];
        }
        if (isset($row['v_03_validation'])) { // v_03_validation
            $this->v_03_validation->CurrentValue = $row['v_03_validation'];
        }
        if (isset($row['v_04'])) { // v_04
            $this->v_04->CurrentValue = $row['v_04'];
        }
        if (isset($row['v_04_validation'])) { // v_04_validation
            $this->v_04_validation->CurrentValue = $row['v_04_validation'];
        }
        if (isset($row['v_05'])) { // v_05
            $this->v_05->CurrentValue = $row['v_05'];
        }
        if (isset($row['v_05_validation'])) { // v_05_validation
            $this->v_05_validation->CurrentValue = $row['v_05_validation'];
        }
        if (isset($row['v_06'])) { // v_06
            $this->v_06->CurrentValue = $row['v_06'];
        }
        if (isset($row['v_06_validation'])) { // v_06_validation
            $this->v_06_validation->CurrentValue = $row['v_06_validation'];
        }
        if (isset($row['v_07'])) { // v_07
            $this->v_07->CurrentValue = $row['v_07'];
        }
        if (isset($row['v_07_validation'])) { // v_07_validation
            $this->v_07_validation->CurrentValue = $row['v_07_validation'];
        }
        if (isset($row['v_08'])) { // v_08
            $this->v_08->CurrentValue = $row['v_08'];
        }
        if (isset($row['v_08_validation'])) { // v_08_validation
            $this->v_08_validation->CurrentValue = $row['v_08_validation'];
        }
        if (isset($row['v_09'])) { // v_09
            $this->v_09->CurrentValue = $row['v_09'];
        }
        if (isset($row['v_09_validation'])) { // v_09_validation
            $this->v_09_validation->CurrentValue = $row['v_09_validation'];
        }
        if (isset($row['v_10'])) { // v_10
            $this->v_10->CurrentValue = $row['v_10'];
        }
        if (isset($row['v_10_validation'])) { // v_10_validation
            $this->v_10_validation->CurrentValue = $row['v_10_validation'];
        }
        if (isset($row['b_01_head'])) { // b_01_head
            $this->b_01_head->CurrentValue = $row['b_01_head'];
        }
        if (isset($row['b_02_head'])) { // b_02_head
            $this->b_02_head->CurrentValue = $row['b_02_head'];
        }
        if (isset($row['b_03_head'])) { // b_03_head
            $this->b_03_head->CurrentValue = $row['b_03_head'];
        }
        if (isset($row['b_04_head'])) { // b_04_head
            $this->b_04_head->CurrentValue = $row['b_04_head'];
        }
        if (isset($row['b_05_head'])) { // b_05_head
            $this->b_05_head->CurrentValue = $row['b_05_head'];
        }
        if (isset($row['b_06_head'])) { // b_06_head
            $this->b_06_head->CurrentValue = $row['b_06_head'];
        }
        if (isset($row['b_07_head'])) { // b_07_head
            $this->b_07_head->CurrentValue = $row['b_07_head'];
        }
        if (isset($row['b_08_head'])) { // b_08_head
            $this->b_08_head->CurrentValue = $row['b_08_head'];
        }
        if (isset($row['b_09_head'])) { // b_09_head
            $this->b_09_head->CurrentValue = $row['b_09_head'];
        }
        if (isset($row['b_10_head'])) { // b_10_head
            $this->b_10_head->CurrentValue = $row['b_10_head'];
        }
        if (isset($row['b_11_head'])) { // b_11_head
            $this->b_11_head->CurrentValue = $row['b_11_head'];
        }
        if (isset($row['b_12_head'])) { // b_12_head
            $this->b_12_head->CurrentValue = $row['b_12_head'];
        }
        if (isset($row['b_13_head'])) { // b_13_head
            $this->b_13_head->CurrentValue = $row['b_13_head'];
        }
        if (isset($row['b_14_head'])) { // b_14_head
            $this->b_14_head->CurrentValue = $row['b_14_head'];
        }
        if (isset($row['b_15_head'])) { // b_15_head
            $this->b_15_head->CurrentValue = $row['b_15_head'];
        }
        if (isset($row['q_sku'])) { // q_sku
            $this->q_sku->CurrentValue = $row['q_sku'];
        }
        if (isset($row['t_01_head'])) { // t_01_head
            $this->t_01_head->CurrentValue = $row['t_01_head'];
        }
        if (isset($row['t_02_head'])) { // t_02_head
            $this->t_02_head->CurrentValue = $row['t_02_head'];
        }
        if (isset($row['t_03_head'])) { // t_03_head
            $this->t_03_head->CurrentValue = $row['t_03_head'];
        }
        if (isset($row['t_04_head'])) { // t_04_head
            $this->t_04_head->CurrentValue = $row['t_04_head'];
        }
        if (isset($row['t_05_head'])) { // t_05_head
            $this->t_05_head->CurrentValue = $row['t_05_head'];
        }
        if (isset($row['t_06_head'])) { // t_06_head
            $this->t_06_head->CurrentValue = $row['t_06_head'];
        }
        if (isset($row['t_07_head'])) { // t_07_head
            $this->t_07_head->CurrentValue = $row['t_07_head'];
        }
        if (isset($row['t_08_head'])) { // t_08_head
            $this->t_08_head->CurrentValue = $row['t_08_head'];
        }
        if (isset($row['t_09_head'])) { // t_09_head
            $this->t_09_head->CurrentValue = $row['t_09_head'];
        }
        if (isset($row['t_10_head'])) { // t_10_head
            $this->t_10_head->CurrentValue = $row['t_10_head'];
        }
        if (isset($row['t_11_head'])) { // t_11_head
            $this->t_11_head->CurrentValue = $row['t_11_head'];
        }
        if (isset($row['t_12_head'])) { // t_12_head
            $this->t_12_head->CurrentValue = $row['t_12_head'];
        }
        if (isset($row['t_13_head'])) { // t_13_head
            $this->t_13_head->CurrentValue = $row['t_13_head'];
        }
        if (isset($row['t_14_head'])) { // t_14_head
            $this->t_14_head->CurrentValue = $row['t_14_head'];
        }
        if (isset($row['t_15_head'])) { // t_15_head
            $this->t_15_head->CurrentValue = $row['t_15_head'];
        }
        if (isset($row['po_01_head'])) { // po_01_head
            $this->po_01_head->CurrentValue = $row['po_01_head'];
        }
        if (isset($row['po_02_head'])) { // po_02_head
            $this->po_02_head->CurrentValue = $row['po_02_head'];
        }
        if (isset($row['po_03_head'])) { // po_03_head
            $this->po_03_head->CurrentValue = $row['po_03_head'];
        }
        if (isset($row['po_04_head'])) { // po_04_head
            $this->po_04_head->CurrentValue = $row['po_04_head'];
        }
        if (isset($row['po_05_head'])) { // po_05_head
            $this->po_05_head->CurrentValue = $row['po_05_head'];
        }
        if (isset($row['po_06_head'])) { // po_06_head
            $this->po_06_head->CurrentValue = $row['po_06_head'];
        }
        if (isset($row['po_07_head'])) { // po_07_head
            $this->po_07_head->CurrentValue = $row['po_07_head'];
        }
        if (isset($row['po_08_head'])) { // po_08_head
            $this->po_08_head->CurrentValue = $row['po_08_head'];
        }
        if (isset($row['po_17_head'])) { // po_17_head
            $this->po_17_head->CurrentValue = $row['po_17_head'];
        }
        if (isset($row['po_18_head'])) { // po_18_head
            $this->po_18_head->CurrentValue = $row['po_18_head'];
        }
        if (isset($row['po_19_head'])) { // po_19_head
            $this->po_19_head->CurrentValue = $row['po_19_head'];
        }
        if (isset($row['po_20_head'])) { // po_20_head
            $this->po_20_head->CurrentValue = $row['po_20_head'];
        }
        if (isset($row['jc_01_head'])) { // jc_01_head
            $this->jc_01_head->CurrentValue = $row['jc_01_head'];
        }
        if (isset($row['jc_02_head'])) { // jc_02_head
            $this->jc_02_head->CurrentValue = $row['jc_02_head'];
        }
        if (isset($row['jc_03_head'])) { // jc_03_head
            $this->jc_03_head->CurrentValue = $row['jc_03_head'];
        }
        if (isset($row['jc_04_head'])) { // jc_04_head
            $this->jc_04_head->CurrentValue = $row['jc_04_head'];
        }
        if (isset($row['jc_05_head'])) { // jc_05_head
            $this->jc_05_head->CurrentValue = $row['jc_05_head'];
        }
        if (isset($row['jc_06_head'])) { // jc_06_head
            $this->jc_06_head->CurrentValue = $row['jc_06_head'];
        }
        if (isset($row['jc_07_head'])) { // jc_07_head
            $this->jc_07_head->CurrentValue = $row['jc_07_head'];
        }
        if (isset($row['jc_08_head'])) { // jc_08_head
            $this->jc_08_head->CurrentValue = $row['jc_08_head'];
        }
        if (isset($row['jc_09_head'])) { // jc_09_head
            $this->jc_09_head->CurrentValue = $row['jc_09_head'];
        }
        if (isset($row['jc_10_head'])) { // jc_10_head
            $this->jc_10_head->CurrentValue = $row['jc_10_head'];
        }
        if (isset($row['pc_shape'])) { // pc_shape
            $this->pc_shape->CurrentValue = $row['pc_shape'];
        }
        if (isset($row['pc_unit'])) { // pc_unit
            $this->pc_unit->CurrentValue = $row['pc_unit'];
        }
        if (isset($row['pc_w'])) { // pc_w
            $this->pc_w->CurrentValue = $row['pc_w'];
        }
        if (isset($row['pc_l'])) { // pc_l
            $this->pc_l->CurrentValue = $row['pc_l'];
        }
        if (isset($row['pc_h'])) { // pc_h
            $this->pc_h->CurrentValue = $row['pc_h'];
        }
        if (isset($row['pc_partner_size'])) { // pc_partner_size
            $this->pc_partner_size->CurrentValue = $row['pc_partner_size'];
        }
        if (isset($row['pc_sqm'])) { // pc_sqm
            $this->pc_sqm->CurrentValue = $row['pc_sqm'];
        }
        if (isset($row['pc_01_head'])) { // pc_01_head
            $this->pc_01_head->CurrentValue = $row['pc_01_head'];
        }
        if (isset($row['pc_02_head'])) { // pc_02_head
            $this->pc_02_head->CurrentValue = $row['pc_02_head'];
        }
        if (isset($row['pc_03_head'])) { // pc_03_head
            $this->pc_03_head->CurrentValue = $row['pc_03_head'];
        }
        if (isset($row['pc_04_head'])) { // pc_04_head
            $this->pc_04_head->CurrentValue = $row['pc_04_head'];
        }
        if (isset($row['pc_05_head'])) { // pc_05_head
            $this->pc_05_head->CurrentValue = $row['pc_05_head'];
        }
        if (isset($row['pc_06_head'])) { // pc_06_head
            $this->pc_06_head->CurrentValue = $row['pc_06_head'];
        }
        if (isset($row['pc_07_head'])) { // pc_07_head
            $this->pc_07_head->CurrentValue = $row['pc_07_head'];
        }
        if (isset($row['pc_08_head'])) { // pc_08_head
            $this->pc_08_head->CurrentValue = $row['pc_08_head'];
        }
        if (isset($row['pc_09_head'])) { // pc_09_head
            $this->pc_09_head->CurrentValue = $row['pc_09_head'];
        }
        if (isset($row['pc_10_head'])) { // pc_10_head
            $this->pc_10_head->CurrentValue = $row['pc_10_head'];
        }
        if (isset($row['pc_11_head'])) { // pc_11_head
            $this->pc_11_head->CurrentValue = $row['pc_11_head'];
        }
        if (isset($row['pc_12_head'])) { // pc_12_head
            $this->pc_12_head->CurrentValue = $row['pc_12_head'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['image'])) { // image
            $this->image->CurrentValue = $row['image'];
        }
        if (isset($row['pa_process_size_w'])) { // pa_process_size_w
            $this->pa_process_size_w->CurrentValue = $row['pa_process_size_w'];
        }
        if (isset($row['pa_process_size_l'])) { // pa_process_size_l
            $this->pa_process_size_l->CurrentValue = $row['pa_process_size_l'];
        }
        if (isset($row['pa_head_01'])) { // pa_head_01
            $this->pa_head_01->CurrentValue = $row['pa_head_01'];
        }
        if (isset($row['pa_process_01'])) { // pa_process_01
            $this->pa_process_01->CurrentValue = $row['pa_process_01'];
        }
        if (isset($row['pa_head_02'])) { // pa_head_02
            $this->pa_head_02->CurrentValue = $row['pa_head_02'];
        }
        if (isset($row['pa_process_02'])) { // pa_process_02
            $this->pa_process_02->CurrentValue = $row['pa_process_02'];
        }
        if (isset($row['pa_head_03'])) { // pa_head_03
            $this->pa_head_03->CurrentValue = $row['pa_head_03'];
        }
        if (isset($row['pa_process_03'])) { // pa_process_03
            $this->pa_process_03->CurrentValue = $row['pa_process_03'];
        }
        if (isset($row['pa_head_04'])) { // pa_head_04
            $this->pa_head_04->CurrentValue = $row['pa_head_04'];
        }
        if (isset($row['pa_process_04'])) { // pa_process_04
            $this->pa_process_04->CurrentValue = $row['pa_process_04'];
        }
        if (isset($row['pa_head_05'])) { // pa_head_05
            $this->pa_head_05->CurrentValue = $row['pa_head_05'];
        }
        if (isset($row['pa_process_05'])) { // pa_process_05
            $this->pa_process_05->CurrentValue = $row['pa_process_05'];
        }
        if (isset($row['pa_head_06'])) { // pa_head_06
            $this->pa_head_06->CurrentValue = $row['pa_head_06'];
        }
        if (isset($row['pa_process_06'])) { // pa_process_06
            $this->pa_process_06->CurrentValue = $row['pa_process_06'];
        }
        if (isset($row['pa_head_07'])) { // pa_head_07
            $this->pa_head_07->CurrentValue = $row['pa_head_07'];
        }
        if (isset($row['pa_process_07'])) { // pa_process_07
            $this->pa_process_07->CurrentValue = $row['pa_process_07'];
        }
        if (isset($row['pa_head_08'])) { // pa_head_08
            $this->pa_head_08->CurrentValue = $row['pa_head_08'];
        }
        if (isset($row['pa_process_08'])) { // pa_process_08
            $this->pa_process_08->CurrentValue = $row['pa_process_08'];
        }
        if (isset($row['pa_head_09'])) { // pa_head_09
            $this->pa_head_09->CurrentValue = $row['pa_head_09'];
        }
        if (isset($row['pa_process_09'])) { // pa_process_09
            $this->pa_process_09->CurrentValue = $row['pa_process_09'];
        }
        if (isset($row['pa_head_10'])) { // pa_head_10
            $this->pa_head_10->CurrentValue = $row['pa_head_10'];
        }
        if (isset($row['pa_process_10'])) { // pa_process_10
            $this->pa_process_10->CurrentValue = $row['pa_process_10'];
        }
        if (isset($row['publish'])) { // publish
            $this->publish->CurrentValue = $row['publish'];
        }
        if (isset($row['ppr_01'])) { // ppr_01
            $this->ppr_01->CurrentValue = $row['ppr_01'];
        }
        if (isset($row['ppr_02'])) { // ppr_02
            $this->ppr_02->CurrentValue = $row['ppr_02'];
        }
        if (isset($row['ppr_03'])) { // ppr_03
            $this->ppr_03->CurrentValue = $row['ppr_03'];
        }
        if (isset($row['ppr_04'])) { // ppr_04
            $this->ppr_04->CurrentValue = $row['ppr_04'];
        }
        if (isset($row['ppr_05'])) { // ppr_05
            $this->ppr_05->CurrentValue = $row['ppr_05'];
        }
        if (isset($row['ppr_06'])) { // ppr_06
            $this->ppr_06->CurrentValue = $row['ppr_06'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("productgrouplist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "tabs";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $pages->add(6);
        $pages->add(7);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_calculation_method":
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_v_01_validation":
                    break;
                case "x_pa_process_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_process_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
