<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for product_group
 */
class ProductGroup extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $grp;
    public $product_group;
    public $calculation_method;
    public $shape;
    public $sqm;
    public $cbm;
    public $process;
    public $status;
    public $v_00;
    public $v_01;
    public $v_01_validation;
    public $v_02;
    public $v_02_validation;
    public $v_03;
    public $v_03_validation;
    public $v_04;
    public $v_04_validation;
    public $v_05;
    public $v_05_validation;
    public $v_06;
    public $v_06_validation;
    public $v_07;
    public $v_07_validation;
    public $v_08;
    public $v_08_validation;
    public $v_09;
    public $v_09_validation;
    public $v_10;
    public $v_10_validation;
    public $b_01_head;
    public $b_02_head;
    public $b_03_head;
    public $b_04_head;
    public $b_05_head;
    public $b_06_head;
    public $b_07_head;
    public $b_08_head;
    public $b_09_head;
    public $b_10_head;
    public $b_11_head;
    public $b_12_head;
    public $b_13_head;
    public $b_14_head;
    public $b_15_head;
    public $q_sku;
    public $t_01_head;
    public $t_02_head;
    public $t_03_head;
    public $t_04_head;
    public $t_05_head;
    public $t_06_head;
    public $t_07_head;
    public $t_08_head;
    public $t_09_head;
    public $t_10_head;
    public $t_11_head;
    public $t_12_head;
    public $t_13_head;
    public $t_14_head;
    public $t_15_head;
    public $po_01_head;
    public $po_02_head;
    public $po_03_head;
    public $po_04_head;
    public $po_05_head;
    public $po_06_head;
    public $po_07_head;
    public $po_08_head;
    public $po_17_head;
    public $po_18_head;
    public $po_19_head;
    public $po_20_head;
    public $jc_01_head;
    public $jc_02_head;
    public $jc_03_head;
    public $jc_04_head;
    public $jc_05_head;
    public $jc_06_head;
    public $jc_07_head;
    public $jc_08_head;
    public $jc_09_head;
    public $jc_10_head;
    public $pc_shape;
    public $pc_unit;
    public $pc_w;
    public $pc_l;
    public $pc_h;
    public $pc_partner_size;
    public $pc_sqm;
    public $pc_01_head;
    public $pc_02_head;
    public $pc_03_head;
    public $pc_04_head;
    public $pc_05_head;
    public $pc_06_head;
    public $pc_07_head;
    public $pc_08_head;
    public $pc_09_head;
    public $pc_10_head;
    public $pc_11_head;
    public $pc_12_head;
    public $operator;
    public $datetime;
    public $image;
    public $pa_process_size_w;
    public $pa_process_size_l;
    public $pa_head_01;
    public $pa_process_01;
    public $pa_head_02;
    public $pa_process_02;
    public $pa_head_03;
    public $pa_process_03;
    public $pa_head_04;
    public $pa_process_04;
    public $pa_head_05;
    public $pa_process_05;
    public $pa_head_06;
    public $pa_process_06;
    public $pa_head_07;
    public $pa_process_07;
    public $pa_head_08;
    public $pa_process_08;
    public $pa_head_09;
    public $pa_process_09;
    public $pa_head_10;
    public $pa_process_10;
    public $publish;
    public $ppr_01;
    public $ppr_02;
    public $ppr_03;
    public $ppr_04;
    public $ppr_05;
    public $ppr_06;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "product_group";
        $this->TableName = 'product_group';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "product_group";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Nullable = false; // NOT NULL field
        $this->grp->Required = true; // Required field
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'grp', false, 'id', ["grp","","",""], '', '', [], [], [], [], [], [], false, '`grp` ASC', '', "`grp`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['grp'] = &$this->grp;

        // product_group
        $this->product_group = new DbField(
            $this, // Table
            'x_product_group', // Variable name
            'product_group', // Name
            '`product_group`', // Expression
            '`product_group`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_group`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product_group->InputTextType = "text";
        $this->product_group->Required = true; // Required field
        $this->product_group->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_group'] = &$this->product_group;

        // calculation_method
        $this->calculation_method = new DbField(
            $this, // Table
            'x_calculation_method', // Variable name
            'calculation_method', // Name
            '`calculation_method`', // Expression
            '`calculation_method`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`calculation_method`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->calculation_method->InputTextType = "text";
        $this->calculation_method->Raw = true;
        $this->calculation_method->Nullable = false; // NOT NULL field
        $this->calculation_method->Required = true; // Required field
        $this->calculation_method->setSelectMultiple(false); // Select one
        $this->calculation_method->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->calculation_method->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->calculation_method->Lookup = new Lookup($this->calculation_method, 'unit', false, 'id', ["description","sign","",""], '', '', [], [], [], [], [], [], false, '`description` ASC', '', "CONCAT(COALESCE(`description`, ''),'" . ValueSeparator(1, $this->calculation_method) . "',COALESCE(`sign`,''))");
        $this->calculation_method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->calculation_method->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['calculation_method'] = &$this->calculation_method;

        // shape
        $this->shape = new DbField(
            $this, // Table
            'x_shape', // Variable name
            'shape', // Name
            '`shape`', // Expression
            '`shape`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shape`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->shape->InputTextType = "text";
        $this->shape->Nullable = false; // NOT NULL field
        $this->shape->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['shape'] = &$this->shape;

        // sqm
        $this->sqm = new DbField(
            $this, // Table
            'x_sqm', // Variable name
            'sqm', // Name
            '`sqm`', // Expression
            '`sqm`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm->InputTextType = "text";
        $this->sqm->Nullable = false; // NOT NULL field
        $this->sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['sqm'] = &$this->sqm;

        // cbm
        $this->cbm = new DbField(
            $this, // Table
            'x_cbm', // Variable name
            'cbm', // Name
            '`cbm`', // Expression
            '`cbm`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cbm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cbm->InputTextType = "text";
        $this->cbm->Nullable = false; // NOT NULL field
        $this->cbm->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['cbm'] = &$this->cbm;

        // process
        $this->process = new DbField(
            $this, // Table
            'x_process', // Variable name
            'process', // Name
            '`process`', // Expression
            '`process`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->process->InputTextType = "text";
        $this->process->Raw = true;
        $this->process->setSelectMultiple(false); // Select one
        $this->process->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->process->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->process->Lookup = new Lookup($this->process, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['process'] = &$this->process;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getDefault", fn() => 1);
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->Nullable = false; // NOT NULL field
        $this->status->Required = true; // Required field
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'product_group', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 2;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status'] = &$this->status;

        // v_00
        $this->v_00 = new DbField(
            $this, // Table
            'x_v_00', // Variable name
            'v_00', // Name
            '`v_00`', // Expression
            '`v_00`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_00`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_00->addMethod("getDefault", fn() => "--NA--");
        $this->v_00->InputTextType = "text";
        $this->v_00->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_00'] = &$this->v_00;

        // v_01
        $this->v_01 = new DbField(
            $this, // Table
            'x_v_01', // Variable name
            'v_01', // Name
            '`v_01`', // Expression
            '`v_01`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_01->addMethod("getDefault", fn() => "--NA--");
        $this->v_01->InputTextType = "text";
        $this->v_01->Nullable = false; // NOT NULL field
        $this->v_01->Required = true; // Required field
        $this->v_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_01'] = &$this->v_01;

        // v_01_validation
        $this->v_01_validation = new DbField(
            $this, // Table
            'x_v_01_validation', // Variable name
            'v_01_validation', // Name
            '`v_01_validation`', // Expression
            '`v_01_validation`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_01_validation`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_01_validation->addMethod("getDefault", fn() => "1,12");
        $this->v_01_validation->InputTextType = "text";
        $this->v_01_validation->Nullable = false; // NOT NULL field
        $this->v_01_validation->Required = true; // Required field
        $this->v_01_validation->Lookup = new Lookup($this->v_01_validation, 'product_group', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->v_01_validation->OptionCount = 5;
        $this->v_01_validation->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_01_validation'] = &$this->v_01_validation;

        // v_02
        $this->v_02 = new DbField(
            $this, // Table
            'x_v_02', // Variable name
            'v_02', // Name
            '`v_02`', // Expression
            '`v_02`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_02->addMethod("getDefault", fn() => "--NA--");
        $this->v_02->InputTextType = "text";
        $this->v_02->Nullable = false; // NOT NULL field
        $this->v_02->Required = true; // Required field
        $this->v_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_02'] = &$this->v_02;

        // v_02_validation
        $this->v_02_validation = new DbField(
            $this, // Table
            'x_v_02_validation', // Variable name
            'v_02_validation', // Name
            '`v_02_validation`', // Expression
            '`v_02_validation`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_02_validation`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_02_validation->addMethod("getDefault", fn() => "1,12");
        $this->v_02_validation->InputTextType = "text";
        $this->v_02_validation->Nullable = false; // NOT NULL field
        $this->v_02_validation->Required = true; // Required field
        $this->v_02_validation->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_02_validation'] = &$this->v_02_validation;

        // v_03
        $this->v_03 = new DbField(
            $this, // Table
            'x_v_03', // Variable name
            'v_03', // Name
            '`v_03`', // Expression
            '`v_03`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_03->addMethod("getDefault", fn() => "--NA--");
        $this->v_03->InputTextType = "text";
        $this->v_03->Nullable = false; // NOT NULL field
        $this->v_03->Required = true; // Required field
        $this->v_03->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_03'] = &$this->v_03;

        // v_03_validation
        $this->v_03_validation = new DbField(
            $this, // Table
            'x_v_03_validation', // Variable name
            'v_03_validation', // Name
            '`v_03_validation`', // Expression
            '`v_03_validation`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_03_validation`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_03_validation->addMethod("getDefault", fn() => "1,12");
        $this->v_03_validation->InputTextType = "text";
        $this->v_03_validation->Nullable = false; // NOT NULL field
        $this->v_03_validation->Required = true; // Required field
        $this->v_03_validation->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_03_validation'] = &$this->v_03_validation;

        // v_04
        $this->v_04 = new DbField(
            $this, // Table
            'x_v_04', // Variable name
            'v_04', // Name
            '`v_04`', // Expression
            '`v_04`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_04->addMethod("getDefault", fn() => "--NA--");
        $this->v_04->InputTextType = "text";
        $this->v_04->Nullable = false; // NOT NULL field
        $this->v_04->Required = true; // Required field
        $this->v_04->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_04'] = &$this->v_04;

        // v_04_validation
        $this->v_04_validation = new DbField(
            $this, // Table
            'x_v_04_validation', // Variable name
            'v_04_validation', // Name
            '`v_04_validation`', // Expression
            '`v_04_validation`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_04_validation`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_04_validation->addMethod("getDefault", fn() => "1,12");
        $this->v_04_validation->InputTextType = "text";
        $this->v_04_validation->Nullable = false; // NOT NULL field
        $this->v_04_validation->Required = true; // Required field
        $this->v_04_validation->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_04_validation'] = &$this->v_04_validation;

        // v_05
        $this->v_05 = new DbField(
            $this, // Table
            'x_v_05', // Variable name
            'v_05', // Name
            '`v_05`', // Expression
            '`v_05`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_05`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_05->addMethod("getDefault", fn() => "--NA--");
        $this->v_05->InputTextType = "text";
        $this->v_05->Nullable = false; // NOT NULL field
        $this->v_05->Required = true; // Required field
        $this->v_05->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_05'] = &$this->v_05;

        // v_05_validation
        $this->v_05_validation = new DbField(
            $this, // Table
            'x_v_05_validation', // Variable name
            'v_05_validation', // Name
            '`v_05_validation`', // Expression
            '`v_05_validation`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_05_validation`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_05_validation->addMethod("getDefault", fn() => "1,12");
        $this->v_05_validation->InputTextType = "text";
        $this->v_05_validation->Nullable = false; // NOT NULL field
        $this->v_05_validation->Required = true; // Required field
        $this->v_05_validation->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_05_validation'] = &$this->v_05_validation;

        // v_06
        $this->v_06 = new DbField(
            $this, // Table
            'x_v_06', // Variable name
            'v_06', // Name
            '`v_06`', // Expression
            '`v_06`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_06`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_06->addMethod("getDefault", fn() => "--NA--");
        $this->v_06->InputTextType = "text";
        $this->v_06->Nullable = false; // NOT NULL field
        $this->v_06->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_06'] = &$this->v_06;

        // v_06_validation
        $this->v_06_validation = new DbField(
            $this, // Table
            'x_v_06_validation', // Variable name
            'v_06_validation', // Name
            '`v_06_validation`', // Expression
            '`v_06_validation`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_06_validation`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_06_validation->addMethod("getDefault", fn() => "1,12");
        $this->v_06_validation->InputTextType = "text";
        $this->v_06_validation->Nullable = false; // NOT NULL field
        $this->v_06_validation->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_06_validation'] = &$this->v_06_validation;

        // v_07
        $this->v_07 = new DbField(
            $this, // Table
            'x_v_07', // Variable name
            'v_07', // Name
            '`v_07`', // Expression
            '`v_07`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_07`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_07->addMethod("getDefault", fn() => "--NA--");
        $this->v_07->InputTextType = "text";
        $this->v_07->Nullable = false; // NOT NULL field
        $this->v_07->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_07'] = &$this->v_07;

        // v_07_validation
        $this->v_07_validation = new DbField(
            $this, // Table
            'x_v_07_validation', // Variable name
            'v_07_validation', // Name
            '`v_07_validation`', // Expression
            '`v_07_validation`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_07_validation`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_07_validation->addMethod("getDefault", fn() => "1,12");
        $this->v_07_validation->InputTextType = "text";
        $this->v_07_validation->Nullable = false; // NOT NULL field
        $this->v_07_validation->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_07_validation'] = &$this->v_07_validation;

        // v_08
        $this->v_08 = new DbField(
            $this, // Table
            'x_v_08', // Variable name
            'v_08', // Name
            '`v_08`', // Expression
            '`v_08`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_08`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_08->addMethod("getDefault", fn() => "--NA--");
        $this->v_08->InputTextType = "text";
        $this->v_08->Nullable = false; // NOT NULL field
        $this->v_08->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_08'] = &$this->v_08;

        // v_08_validation
        $this->v_08_validation = new DbField(
            $this, // Table
            'x_v_08_validation', // Variable name
            'v_08_validation', // Name
            '`v_08_validation`', // Expression
            '`v_08_validation`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_08_validation`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_08_validation->addMethod("getDefault", fn() => "1,12");
        $this->v_08_validation->InputTextType = "text";
        $this->v_08_validation->Nullable = false; // NOT NULL field
        $this->v_08_validation->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_08_validation'] = &$this->v_08_validation;

        // v_09
        $this->v_09 = new DbField(
            $this, // Table
            'x_v_09', // Variable name
            'v_09', // Name
            '`v_09`', // Expression
            '`v_09`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_09`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_09->addMethod("getDefault", fn() => "--NA--");
        $this->v_09->InputTextType = "text";
        $this->v_09->Nullable = false; // NOT NULL field
        $this->v_09->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_09'] = &$this->v_09;

        // v_09_validation
        $this->v_09_validation = new DbField(
            $this, // Table
            'x_v_09_validation', // Variable name
            'v_09_validation', // Name
            '`v_09_validation`', // Expression
            '`v_09_validation`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_09_validation`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_09_validation->addMethod("getDefault", fn() => "1,12");
        $this->v_09_validation->InputTextType = "text";
        $this->v_09_validation->Nullable = false; // NOT NULL field
        $this->v_09_validation->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_09_validation'] = &$this->v_09_validation;

        // v_10
        $this->v_10 = new DbField(
            $this, // Table
            'x_v_10', // Variable name
            'v_10', // Name
            '`v_10`', // Expression
            '`v_10`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_10`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_10->addMethod("getDefault", fn() => "--NA--");
        $this->v_10->InputTextType = "text";
        $this->v_10->Nullable = false; // NOT NULL field
        $this->v_10->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_10'] = &$this->v_10;

        // v_10_validation
        $this->v_10_validation = new DbField(
            $this, // Table
            'x_v_10_validation', // Variable name
            'v_10_validation', // Name
            '`v_10_validation`', // Expression
            '`v_10_validation`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_10_validation`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_10_validation->addMethod("getDefault", fn() => "1,12");
        $this->v_10_validation->InputTextType = "text";
        $this->v_10_validation->Nullable = false; // NOT NULL field
        $this->v_10_validation->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['v_10_validation'] = &$this->v_10_validation;

        // b_01_head
        $this->b_01_head = new DbField(
            $this, // Table
            'x_b_01_head', // Variable name
            'b_01_head', // Name
            '`b_01_head`', // Expression
            '`b_01_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_01_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_01_head->addMethod("getDefault", fn() => "--NA--");
        $this->b_01_head->InputTextType = "text";
        $this->b_01_head->Nullable = false; // NOT NULL field
        $this->b_01_head->Required = true; // Required field
        $this->b_01_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['b_01_head'] = &$this->b_01_head;

        // b_02_head
        $this->b_02_head = new DbField(
            $this, // Table
            'x_b_02_head', // Variable name
            'b_02_head', // Name
            '`b_02_head`', // Expression
            '`b_02_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_02_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_02_head->addMethod("getDefault", fn() => "--NA--");
        $this->b_02_head->InputTextType = "text";
        $this->b_02_head->Nullable = false; // NOT NULL field
        $this->b_02_head->Required = true; // Required field
        $this->b_02_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['b_02_head'] = &$this->b_02_head;

        // b_03_head
        $this->b_03_head = new DbField(
            $this, // Table
            'x_b_03_head', // Variable name
            'b_03_head', // Name
            '`b_03_head`', // Expression
            '`b_03_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_03_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_03_head->addMethod("getDefault", fn() => "--NA--");
        $this->b_03_head->InputTextType = "text";
        $this->b_03_head->Nullable = false; // NOT NULL field
        $this->b_03_head->Required = true; // Required field
        $this->b_03_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['b_03_head'] = &$this->b_03_head;

        // b_04_head
        $this->b_04_head = new DbField(
            $this, // Table
            'x_b_04_head', // Variable name
            'b_04_head', // Name
            '`b_04_head`', // Expression
            '`b_04_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_04_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_04_head->addMethod("getDefault", fn() => "--NA--");
        $this->b_04_head->InputTextType = "text";
        $this->b_04_head->Nullable = false; // NOT NULL field
        $this->b_04_head->Required = true; // Required field
        $this->b_04_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['b_04_head'] = &$this->b_04_head;

        // b_05_head
        $this->b_05_head = new DbField(
            $this, // Table
            'x_b_05_head', // Variable name
            'b_05_head', // Name
            '`b_05_head`', // Expression
            '`b_05_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_05_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_05_head->addMethod("getDefault", fn() => "--NA--");
        $this->b_05_head->InputTextType = "text";
        $this->b_05_head->Nullable = false; // NOT NULL field
        $this->b_05_head->Required = true; // Required field
        $this->b_05_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['b_05_head'] = &$this->b_05_head;

        // b_06_head
        $this->b_06_head = new DbField(
            $this, // Table
            'x_b_06_head', // Variable name
            'b_06_head', // Name
            '`b_06_head`', // Expression
            '`b_06_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_06_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_06_head->addMethod("getDefault", fn() => "--NA--");
        $this->b_06_head->InputTextType = "text";
        $this->b_06_head->Nullable = false; // NOT NULL field
        $this->b_06_head->Required = true; // Required field
        $this->b_06_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['b_06_head'] = &$this->b_06_head;

        // b_07_head
        $this->b_07_head = new DbField(
            $this, // Table
            'x_b_07_head', // Variable name
            'b_07_head', // Name
            '`b_07_head`', // Expression
            '`b_07_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_07_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_07_head->addMethod("getDefault", fn() => "--NA--");
        $this->b_07_head->InputTextType = "text";
        $this->b_07_head->Nullable = false; // NOT NULL field
        $this->b_07_head->Required = true; // Required field
        $this->b_07_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['b_07_head'] = &$this->b_07_head;

        // b_08_head
        $this->b_08_head = new DbField(
            $this, // Table
            'x_b_08_head', // Variable name
            'b_08_head', // Name
            '`b_08_head`', // Expression
            '`b_08_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_08_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_08_head->addMethod("getDefault", fn() => "--NA--");
        $this->b_08_head->InputTextType = "text";
        $this->b_08_head->Nullable = false; // NOT NULL field
        $this->b_08_head->Required = true; // Required field
        $this->b_08_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['b_08_head'] = &$this->b_08_head;

        // b_09_head
        $this->b_09_head = new DbField(
            $this, // Table
            'x_b_09_head', // Variable name
            'b_09_head', // Name
            '`b_09_head`', // Expression
            '`b_09_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_09_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_09_head->addMethod("getDefault", fn() => "--NA--");
        $this->b_09_head->InputTextType = "text";
        $this->b_09_head->Nullable = false; // NOT NULL field
        $this->b_09_head->Required = true; // Required field
        $this->b_09_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['b_09_head'] = &$this->b_09_head;

        // b_10_head
        $this->b_10_head = new DbField(
            $this, // Table
            'x_b_10_head', // Variable name
            'b_10_head', // Name
            '`b_10_head`', // Expression
            '`b_10_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_10_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_10_head->addMethod("getDefault", fn() => "--NA--");
        $this->b_10_head->InputTextType = "text";
        $this->b_10_head->Nullable = false; // NOT NULL field
        $this->b_10_head->Required = true; // Required field
        $this->b_10_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['b_10_head'] = &$this->b_10_head;

        // b_11_head
        $this->b_11_head = new DbField(
            $this, // Table
            'x_b_11_head', // Variable name
            'b_11_head', // Name
            '`b_11_head`', // Expression
            '`b_11_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_11_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_11_head->addMethod("getDefault", fn() => "--NA--");
        $this->b_11_head->InputTextType = "text";
        $this->b_11_head->Nullable = false; // NOT NULL field
        $this->b_11_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['b_11_head'] = &$this->b_11_head;

        // b_12_head
        $this->b_12_head = new DbField(
            $this, // Table
            'x_b_12_head', // Variable name
            'b_12_head', // Name
            '`b_12_head`', // Expression
            '`b_12_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_12_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_12_head->addMethod("getDefault", fn() => "--NA--");
        $this->b_12_head->InputTextType = "text";
        $this->b_12_head->Nullable = false; // NOT NULL field
        $this->b_12_head->Required = true; // Required field
        $this->b_12_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['b_12_head'] = &$this->b_12_head;

        // b_13_head
        $this->b_13_head = new DbField(
            $this, // Table
            'x_b_13_head', // Variable name
            'b_13_head', // Name
            '`b_13_head`', // Expression
            '`b_13_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_13_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_13_head->addMethod("getDefault", fn() => "--NA--");
        $this->b_13_head->InputTextType = "text";
        $this->b_13_head->Nullable = false; // NOT NULL field
        $this->b_13_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['b_13_head'] = &$this->b_13_head;

        // b_14_head
        $this->b_14_head = new DbField(
            $this, // Table
            'x_b_14_head', // Variable name
            'b_14_head', // Name
            '`b_14_head`', // Expression
            '`b_14_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_14_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_14_head->addMethod("getDefault", fn() => "--NA--");
        $this->b_14_head->InputTextType = "text";
        $this->b_14_head->Nullable = false; // NOT NULL field
        $this->b_14_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['b_14_head'] = &$this->b_14_head;

        // b_15_head
        $this->b_15_head = new DbField(
            $this, // Table
            'x_b_15_head', // Variable name
            'b_15_head', // Name
            '`b_15_head`', // Expression
            '`b_15_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_15_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_15_head->addMethod("getDefault", fn() => "--NA--");
        $this->b_15_head->InputTextType = "text";
        $this->b_15_head->Nullable = false; // NOT NULL field
        $this->b_15_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['b_15_head'] = &$this->b_15_head;

        // q_sku
        $this->q_sku = new DbField(
            $this, // Table
            'x_q_sku', // Variable name
            'q_sku', // Name
            '`q_sku`', // Expression
            '`q_sku`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`q_sku`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->q_sku->addMethod("getDefault", fn() => 1.00);
        $this->q_sku->InputTextType = "text";
        $this->q_sku->Nullable = false; // NOT NULL field
        $this->q_sku->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['q_sku'] = &$this->q_sku;

        // t_01_head
        $this->t_01_head = new DbField(
            $this, // Table
            'x_t_01_head', // Variable name
            't_01_head', // Name
            '`t_01_head`', // Expression
            '`t_01_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_01_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_01_head->addMethod("getDefault", fn() => "--NA--");
        $this->t_01_head->InputTextType = "text";
        $this->t_01_head->Nullable = false; // NOT NULL field
        $this->t_01_head->Required = true; // Required field
        $this->t_01_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['t_01_head'] = &$this->t_01_head;

        // t_02_head
        $this->t_02_head = new DbField(
            $this, // Table
            'x_t_02_head', // Variable name
            't_02_head', // Name
            '`t_02_head`', // Expression
            '`t_02_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_02_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_02_head->addMethod("getDefault", fn() => "--NA--");
        $this->t_02_head->InputTextType = "text";
        $this->t_02_head->Nullable = false; // NOT NULL field
        $this->t_02_head->Required = true; // Required field
        $this->t_02_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['t_02_head'] = &$this->t_02_head;

        // t_03_head
        $this->t_03_head = new DbField(
            $this, // Table
            'x_t_03_head', // Variable name
            't_03_head', // Name
            '`t_03_head`', // Expression
            '`t_03_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_03_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_03_head->addMethod("getDefault", fn() => "--NA--");
        $this->t_03_head->InputTextType = "text";
        $this->t_03_head->Nullable = false; // NOT NULL field
        $this->t_03_head->Required = true; // Required field
        $this->t_03_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['t_03_head'] = &$this->t_03_head;

        // t_04_head
        $this->t_04_head = new DbField(
            $this, // Table
            'x_t_04_head', // Variable name
            't_04_head', // Name
            '`t_04_head`', // Expression
            '`t_04_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_04_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_04_head->addMethod("getDefault", fn() => "--NA--");
        $this->t_04_head->InputTextType = "text";
        $this->t_04_head->Nullable = false; // NOT NULL field
        $this->t_04_head->Required = true; // Required field
        $this->t_04_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['t_04_head'] = &$this->t_04_head;

        // t_05_head
        $this->t_05_head = new DbField(
            $this, // Table
            'x_t_05_head', // Variable name
            't_05_head', // Name
            '`t_05_head`', // Expression
            '`t_05_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_05_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_05_head->addMethod("getDefault", fn() => "--NA--");
        $this->t_05_head->InputTextType = "text";
        $this->t_05_head->Nullable = false; // NOT NULL field
        $this->t_05_head->Required = true; // Required field
        $this->t_05_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['t_05_head'] = &$this->t_05_head;

        // t_06_head
        $this->t_06_head = new DbField(
            $this, // Table
            'x_t_06_head', // Variable name
            't_06_head', // Name
            '`t_06_head`', // Expression
            '`t_06_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_06_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_06_head->addMethod("getDefault", fn() => "--NA--");
        $this->t_06_head->InputTextType = "text";
        $this->t_06_head->Nullable = false; // NOT NULL field
        $this->t_06_head->Required = true; // Required field
        $this->t_06_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['t_06_head'] = &$this->t_06_head;

        // t_07_head
        $this->t_07_head = new DbField(
            $this, // Table
            'x_t_07_head', // Variable name
            't_07_head', // Name
            '`t_07_head`', // Expression
            '`t_07_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_07_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_07_head->addMethod("getDefault", fn() => "--NA--");
        $this->t_07_head->InputTextType = "text";
        $this->t_07_head->Nullable = false; // NOT NULL field
        $this->t_07_head->Required = true; // Required field
        $this->t_07_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['t_07_head'] = &$this->t_07_head;

        // t_08_head
        $this->t_08_head = new DbField(
            $this, // Table
            'x_t_08_head', // Variable name
            't_08_head', // Name
            '`t_08_head`', // Expression
            '`t_08_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_08_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_08_head->addMethod("getDefault", fn() => "--NA--");
        $this->t_08_head->InputTextType = "text";
        $this->t_08_head->Nullable = false; // NOT NULL field
        $this->t_08_head->Required = true; // Required field
        $this->t_08_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['t_08_head'] = &$this->t_08_head;

        // t_09_head
        $this->t_09_head = new DbField(
            $this, // Table
            'x_t_09_head', // Variable name
            't_09_head', // Name
            '`t_09_head`', // Expression
            '`t_09_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_09_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_09_head->addMethod("getDefault", fn() => "--NA--");
        $this->t_09_head->InputTextType = "text";
        $this->t_09_head->Nullable = false; // NOT NULL field
        $this->t_09_head->Required = true; // Required field
        $this->t_09_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['t_09_head'] = &$this->t_09_head;

        // t_10_head
        $this->t_10_head = new DbField(
            $this, // Table
            'x_t_10_head', // Variable name
            't_10_head', // Name
            '`t_10_head`', // Expression
            '`t_10_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_10_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_10_head->addMethod("getDefault", fn() => "--NA--");
        $this->t_10_head->InputTextType = "text";
        $this->t_10_head->Nullable = false; // NOT NULL field
        $this->t_10_head->Required = true; // Required field
        $this->t_10_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['t_10_head'] = &$this->t_10_head;

        // t_11_head
        $this->t_11_head = new DbField(
            $this, // Table
            'x_t_11_head', // Variable name
            't_11_head', // Name
            '`t_11_head`', // Expression
            '`t_11_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_11_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_11_head->addMethod("getDefault", fn() => "--NA--");
        $this->t_11_head->InputTextType = "text";
        $this->t_11_head->Nullable = false; // NOT NULL field
        $this->t_11_head->Required = true; // Required field
        $this->t_11_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['t_11_head'] = &$this->t_11_head;

        // t_12_head
        $this->t_12_head = new DbField(
            $this, // Table
            'x_t_12_head', // Variable name
            't_12_head', // Name
            '`t_12_head`', // Expression
            '`t_12_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_12_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_12_head->addMethod("getDefault", fn() => "--NA--");
        $this->t_12_head->InputTextType = "text";
        $this->t_12_head->Nullable = false; // NOT NULL field
        $this->t_12_head->Required = true; // Required field
        $this->t_12_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['t_12_head'] = &$this->t_12_head;

        // t_13_head
        $this->t_13_head = new DbField(
            $this, // Table
            'x_t_13_head', // Variable name
            't_13_head', // Name
            '`t_13_head`', // Expression
            '`t_13_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_13_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_13_head->addMethod("getDefault", fn() => "--NA--");
        $this->t_13_head->InputTextType = "text";
        $this->t_13_head->Nullable = false; // NOT NULL field
        $this->t_13_head->Required = true; // Required field
        $this->t_13_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['t_13_head'] = &$this->t_13_head;

        // t_14_head
        $this->t_14_head = new DbField(
            $this, // Table
            'x_t_14_head', // Variable name
            't_14_head', // Name
            '`t_14_head`', // Expression
            '`t_14_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_14_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_14_head->addMethod("getDefault", fn() => "--NA--");
        $this->t_14_head->InputTextType = "text";
        $this->t_14_head->Nullable = false; // NOT NULL field
        $this->t_14_head->Required = true; // Required field
        $this->t_14_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['t_14_head'] = &$this->t_14_head;

        // t_15_head
        $this->t_15_head = new DbField(
            $this, // Table
            'x_t_15_head', // Variable name
            't_15_head', // Name
            '`t_15_head`', // Expression
            '`t_15_head`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_15_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_15_head->addMethod("getDefault", fn() => "--NA--");
        $this->t_15_head->InputTextType = "text";
        $this->t_15_head->Nullable = false; // NOT NULL field
        $this->t_15_head->Required = true; // Required field
        $this->t_15_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['t_15_head'] = &$this->t_15_head;

        // po_01_head
        $this->po_01_head = new DbField(
            $this, // Table
            'x_po_01_head', // Variable name
            'po_01_head', // Name
            '`po_01_head`', // Expression
            '`po_01_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_01_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_01_head->addMethod("getDefault", fn() => "--NA--");
        $this->po_01_head->InputTextType = "text";
        $this->po_01_head->Nullable = false; // NOT NULL field
        $this->po_01_head->Required = true; // Required field
        $this->po_01_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['po_01_head'] = &$this->po_01_head;

        // po_02_head
        $this->po_02_head = new DbField(
            $this, // Table
            'x_po_02_head', // Variable name
            'po_02_head', // Name
            '`po_02_head`', // Expression
            '`po_02_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_02_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_02_head->addMethod("getDefault", fn() => "--NA--");
        $this->po_02_head->InputTextType = "text";
        $this->po_02_head->Nullable = false; // NOT NULL field
        $this->po_02_head->Required = true; // Required field
        $this->po_02_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['po_02_head'] = &$this->po_02_head;

        // po_03_head
        $this->po_03_head = new DbField(
            $this, // Table
            'x_po_03_head', // Variable name
            'po_03_head', // Name
            '`po_03_head`', // Expression
            '`po_03_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_03_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_03_head->addMethod("getDefault", fn() => "--NA--");
        $this->po_03_head->InputTextType = "text";
        $this->po_03_head->Nullable = false; // NOT NULL field
        $this->po_03_head->Required = true; // Required field
        $this->po_03_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['po_03_head'] = &$this->po_03_head;

        // po_04_head
        $this->po_04_head = new DbField(
            $this, // Table
            'x_po_04_head', // Variable name
            'po_04_head', // Name
            '`po_04_head`', // Expression
            '`po_04_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_04_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_04_head->addMethod("getDefault", fn() => "--NA--");
        $this->po_04_head->InputTextType = "text";
        $this->po_04_head->Nullable = false; // NOT NULL field
        $this->po_04_head->Required = true; // Required field
        $this->po_04_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['po_04_head'] = &$this->po_04_head;

        // po_05_head
        $this->po_05_head = new DbField(
            $this, // Table
            'x_po_05_head', // Variable name
            'po_05_head', // Name
            '`po_05_head`', // Expression
            '`po_05_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_05_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_05_head->addMethod("getDefault", fn() => "--NA--");
        $this->po_05_head->InputTextType = "text";
        $this->po_05_head->Nullable = false; // NOT NULL field
        $this->po_05_head->Required = true; // Required field
        $this->po_05_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['po_05_head'] = &$this->po_05_head;

        // po_06_head
        $this->po_06_head = new DbField(
            $this, // Table
            'x_po_06_head', // Variable name
            'po_06_head', // Name
            '`po_06_head`', // Expression
            '`po_06_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_06_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_06_head->addMethod("getDefault", fn() => "--NA--");
        $this->po_06_head->InputTextType = "text";
        $this->po_06_head->Nullable = false; // NOT NULL field
        $this->po_06_head->Required = true; // Required field
        $this->po_06_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['po_06_head'] = &$this->po_06_head;

        // po_07_head
        $this->po_07_head = new DbField(
            $this, // Table
            'x_po_07_head', // Variable name
            'po_07_head', // Name
            '`po_07_head`', // Expression
            '`po_07_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_07_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_07_head->addMethod("getDefault", fn() => "--NA--");
        $this->po_07_head->InputTextType = "text";
        $this->po_07_head->Nullable = false; // NOT NULL field
        $this->po_07_head->Required = true; // Required field
        $this->po_07_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['po_07_head'] = &$this->po_07_head;

        // po_08_head
        $this->po_08_head = new DbField(
            $this, // Table
            'x_po_08_head', // Variable name
            'po_08_head', // Name
            '`po_08_head`', // Expression
            '`po_08_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_08_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_08_head->addMethod("getDefault", fn() => "--NA--");
        $this->po_08_head->InputTextType = "text";
        $this->po_08_head->Nullable = false; // NOT NULL field
        $this->po_08_head->Required = true; // Required field
        $this->po_08_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['po_08_head'] = &$this->po_08_head;

        // po_17_head
        $this->po_17_head = new DbField(
            $this, // Table
            'x_po_17_head', // Variable name
            'po_17_head', // Name
            '`po_17_head`', // Expression
            '`po_17_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_17_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_17_head->addMethod("getDefault", fn() => "--NA--");
        $this->po_17_head->InputTextType = "text";
        $this->po_17_head->Nullable = false; // NOT NULL field
        $this->po_17_head->Required = true; // Required field
        $this->po_17_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['po_17_head'] = &$this->po_17_head;

        // po_18_head
        $this->po_18_head = new DbField(
            $this, // Table
            'x_po_18_head', // Variable name
            'po_18_head', // Name
            '`po_18_head`', // Expression
            '`po_18_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_18_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_18_head->addMethod("getDefault", fn() => "--NA--");
        $this->po_18_head->InputTextType = "text";
        $this->po_18_head->Nullable = false; // NOT NULL field
        $this->po_18_head->Required = true; // Required field
        $this->po_18_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['po_18_head'] = &$this->po_18_head;

        // po_19_head
        $this->po_19_head = new DbField(
            $this, // Table
            'x_po_19_head', // Variable name
            'po_19_head', // Name
            '`po_19_head`', // Expression
            '`po_19_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_19_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_19_head->addMethod("getDefault", fn() => "--NA--");
        $this->po_19_head->InputTextType = "text";
        $this->po_19_head->Nullable = false; // NOT NULL field
        $this->po_19_head->Required = true; // Required field
        $this->po_19_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['po_19_head'] = &$this->po_19_head;

        // po_20_head
        $this->po_20_head = new DbField(
            $this, // Table
            'x_po_20_head', // Variable name
            'po_20_head', // Name
            '`po_20_head`', // Expression
            '`po_20_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_20_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_20_head->addMethod("getDefault", fn() => "--NA--");
        $this->po_20_head->InputTextType = "text";
        $this->po_20_head->Nullable = false; // NOT NULL field
        $this->po_20_head->Required = true; // Required field
        $this->po_20_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['po_20_head'] = &$this->po_20_head;

        // jc_01_head
        $this->jc_01_head = new DbField(
            $this, // Table
            'x_jc_01_head', // Variable name
            'jc_01_head', // Name
            '`jc_01_head`', // Expression
            '`jc_01_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_01_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_01_head->InputTextType = "text";
        $this->jc_01_head->Nullable = false; // NOT NULL field
        $this->jc_01_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['jc_01_head'] = &$this->jc_01_head;

        // jc_02_head
        $this->jc_02_head = new DbField(
            $this, // Table
            'x_jc_02_head', // Variable name
            'jc_02_head', // Name
            '`jc_02_head`', // Expression
            '`jc_02_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_02_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_02_head->InputTextType = "text";
        $this->jc_02_head->Nullable = false; // NOT NULL field
        $this->jc_02_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['jc_02_head'] = &$this->jc_02_head;

        // jc_03_head
        $this->jc_03_head = new DbField(
            $this, // Table
            'x_jc_03_head', // Variable name
            'jc_03_head', // Name
            '`jc_03_head`', // Expression
            '`jc_03_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_03_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_03_head->InputTextType = "text";
        $this->jc_03_head->Nullable = false; // NOT NULL field
        $this->jc_03_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['jc_03_head'] = &$this->jc_03_head;

        // jc_04_head
        $this->jc_04_head = new DbField(
            $this, // Table
            'x_jc_04_head', // Variable name
            'jc_04_head', // Name
            '`jc_04_head`', // Expression
            '`jc_04_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_04_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_04_head->InputTextType = "text";
        $this->jc_04_head->Nullable = false; // NOT NULL field
        $this->jc_04_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['jc_04_head'] = &$this->jc_04_head;

        // jc_05_head
        $this->jc_05_head = new DbField(
            $this, // Table
            'x_jc_05_head', // Variable name
            'jc_05_head', // Name
            '`jc_05_head`', // Expression
            '`jc_05_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_05_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_05_head->InputTextType = "text";
        $this->jc_05_head->Nullable = false; // NOT NULL field
        $this->jc_05_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['jc_05_head'] = &$this->jc_05_head;

        // jc_06_head
        $this->jc_06_head = new DbField(
            $this, // Table
            'x_jc_06_head', // Variable name
            'jc_06_head', // Name
            '`jc_06_head`', // Expression
            '`jc_06_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_06_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_06_head->InputTextType = "text";
        $this->jc_06_head->Nullable = false; // NOT NULL field
        $this->jc_06_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['jc_06_head'] = &$this->jc_06_head;

        // jc_07_head
        $this->jc_07_head = new DbField(
            $this, // Table
            'x_jc_07_head', // Variable name
            'jc_07_head', // Name
            '`jc_07_head`', // Expression
            '`jc_07_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_07_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_07_head->InputTextType = "text";
        $this->jc_07_head->Nullable = false; // NOT NULL field
        $this->jc_07_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['jc_07_head'] = &$this->jc_07_head;

        // jc_08_head
        $this->jc_08_head = new DbField(
            $this, // Table
            'x_jc_08_head', // Variable name
            'jc_08_head', // Name
            '`jc_08_head`', // Expression
            '`jc_08_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_08_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_08_head->InputTextType = "text";
        $this->jc_08_head->Nullable = false; // NOT NULL field
        $this->jc_08_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['jc_08_head'] = &$this->jc_08_head;

        // jc_09_head
        $this->jc_09_head = new DbField(
            $this, // Table
            'x_jc_09_head', // Variable name
            'jc_09_head', // Name
            '`jc_09_head`', // Expression
            '`jc_09_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_09_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_09_head->InputTextType = "text";
        $this->jc_09_head->Nullable = false; // NOT NULL field
        $this->jc_09_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['jc_09_head'] = &$this->jc_09_head;

        // jc_10_head
        $this->jc_10_head = new DbField(
            $this, // Table
            'x_jc_10_head', // Variable name
            'jc_10_head', // Name
            '`jc_10_head`', // Expression
            '`jc_10_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_10_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_10_head->InputTextType = "text";
        $this->jc_10_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['jc_10_head'] = &$this->jc_10_head;

        // pc_shape
        $this->pc_shape = new DbField(
            $this, // Table
            'x_pc_shape', // Variable name
            'pc_shape', // Name
            '`pc_shape`', // Expression
            '`pc_shape`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_shape`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_shape->addMethod("getDefault", fn() => "--NA--");
        $this->pc_shape->InputTextType = "text";
        $this->pc_shape->Nullable = false; // NOT NULL field
        $this->pc_shape->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_shape'] = &$this->pc_shape;

        // pc_unit
        $this->pc_unit = new DbField(
            $this, // Table
            'x_pc_unit', // Variable name
            'pc_unit', // Name
            '`pc_unit`', // Expression
            '`pc_unit`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_unit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_unit->addMethod("getDefault", fn() => "--NA--");
        $this->pc_unit->InputTextType = "text";
        $this->pc_unit->Nullable = false; // NOT NULL field
        $this->pc_unit->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_unit'] = &$this->pc_unit;

        // pc_w
        $this->pc_w = new DbField(
            $this, // Table
            'x_pc_w', // Variable name
            'pc_w', // Name
            '`pc_w`', // Expression
            '`pc_w`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_w`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_w->addMethod("getDefault", fn() => "--NA--");
        $this->pc_w->InputTextType = "text";
        $this->pc_w->Nullable = false; // NOT NULL field
        $this->pc_w->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_w'] = &$this->pc_w;

        // pc_l
        $this->pc_l = new DbField(
            $this, // Table
            'x_pc_l', // Variable name
            'pc_l', // Name
            '`pc_l`', // Expression
            '`pc_l`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_l`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_l->addMethod("getDefault", fn() => "--NA--");
        $this->pc_l->InputTextType = "text";
        $this->pc_l->Nullable = false; // NOT NULL field
        $this->pc_l->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_l'] = &$this->pc_l;

        // pc_h
        $this->pc_h = new DbField(
            $this, // Table
            'x_pc_h', // Variable name
            'pc_h', // Name
            '`pc_h`', // Expression
            '`pc_h`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_h`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_h->addMethod("getDefault", fn() => "--NA--");
        $this->pc_h->InputTextType = "text";
        $this->pc_h->Nullable = false; // NOT NULL field
        $this->pc_h->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_h'] = &$this->pc_h;

        // pc_partner_size
        $this->pc_partner_size = new DbField(
            $this, // Table
            'x_pc_partner_size', // Variable name
            'pc_partner_size', // Name
            '`pc_partner_size`', // Expression
            '`pc_partner_size`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_partner_size`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_partner_size->addMethod("getDefault", fn() => "--NA--");
        $this->pc_partner_size->InputTextType = "text";
        $this->pc_partner_size->Nullable = false; // NOT NULL field
        $this->pc_partner_size->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_partner_size'] = &$this->pc_partner_size;

        // pc_sqm
        $this->pc_sqm = new DbField(
            $this, // Table
            'x_pc_sqm', // Variable name
            'pc_sqm', // Name
            '`pc_sqm`', // Expression
            '`pc_sqm`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_sqm->addMethod("getDefault", fn() => "--NA--");
        $this->pc_sqm->InputTextType = "text";
        $this->pc_sqm->Nullable = false; // NOT NULL field
        $this->pc_sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_sqm'] = &$this->pc_sqm;

        // pc_01_head
        $this->pc_01_head = new DbField(
            $this, // Table
            'x_pc_01_head', // Variable name
            'pc_01_head', // Name
            '`pc_01_head`', // Expression
            '`pc_01_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_01_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_01_head->addMethod("getDefault", fn() => "--NA--");
        $this->pc_01_head->InputTextType = "text";
        $this->pc_01_head->Nullable = false; // NOT NULL field
        $this->pc_01_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_01_head'] = &$this->pc_01_head;

        // pc_02_head
        $this->pc_02_head = new DbField(
            $this, // Table
            'x_pc_02_head', // Variable name
            'pc_02_head', // Name
            '`pc_02_head`', // Expression
            '`pc_02_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_02_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_02_head->addMethod("getDefault", fn() => "--NA--");
        $this->pc_02_head->InputTextType = "text";
        $this->pc_02_head->Nullable = false; // NOT NULL field
        $this->pc_02_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_02_head'] = &$this->pc_02_head;

        // pc_03_head
        $this->pc_03_head = new DbField(
            $this, // Table
            'x_pc_03_head', // Variable name
            'pc_03_head', // Name
            '`pc_03_head`', // Expression
            '`pc_03_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_03_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_03_head->addMethod("getDefault", fn() => "--NA--");
        $this->pc_03_head->InputTextType = "text";
        $this->pc_03_head->Nullable = false; // NOT NULL field
        $this->pc_03_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_03_head'] = &$this->pc_03_head;

        // pc_04_head
        $this->pc_04_head = new DbField(
            $this, // Table
            'x_pc_04_head', // Variable name
            'pc_04_head', // Name
            '`pc_04_head`', // Expression
            '`pc_04_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_04_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_04_head->addMethod("getDefault", fn() => "--NA--");
        $this->pc_04_head->InputTextType = "text";
        $this->pc_04_head->Nullable = false; // NOT NULL field
        $this->pc_04_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_04_head'] = &$this->pc_04_head;

        // pc_05_head
        $this->pc_05_head = new DbField(
            $this, // Table
            'x_pc_05_head', // Variable name
            'pc_05_head', // Name
            '`pc_05_head`', // Expression
            '`pc_05_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_05_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_05_head->addMethod("getDefault", fn() => "--NA--");
        $this->pc_05_head->InputTextType = "text";
        $this->pc_05_head->Nullable = false; // NOT NULL field
        $this->pc_05_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_05_head'] = &$this->pc_05_head;

        // pc_06_head
        $this->pc_06_head = new DbField(
            $this, // Table
            'x_pc_06_head', // Variable name
            'pc_06_head', // Name
            '`pc_06_head`', // Expression
            '`pc_06_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_06_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_06_head->addMethod("getDefault", fn() => "--NA--");
        $this->pc_06_head->InputTextType = "text";
        $this->pc_06_head->Nullable = false; // NOT NULL field
        $this->pc_06_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_06_head'] = &$this->pc_06_head;

        // pc_07_head
        $this->pc_07_head = new DbField(
            $this, // Table
            'x_pc_07_head', // Variable name
            'pc_07_head', // Name
            '`pc_07_head`', // Expression
            '`pc_07_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_07_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_07_head->addMethod("getDefault", fn() => "--NA--");
        $this->pc_07_head->InputTextType = "text";
        $this->pc_07_head->Nullable = false; // NOT NULL field
        $this->pc_07_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_07_head'] = &$this->pc_07_head;

        // pc_08_head
        $this->pc_08_head = new DbField(
            $this, // Table
            'x_pc_08_head', // Variable name
            'pc_08_head', // Name
            '`pc_08_head`', // Expression
            '`pc_08_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_08_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_08_head->addMethod("getDefault", fn() => "--NA--");
        $this->pc_08_head->InputTextType = "text";
        $this->pc_08_head->Nullable = false; // NOT NULL field
        $this->pc_08_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_08_head'] = &$this->pc_08_head;

        // pc_09_head
        $this->pc_09_head = new DbField(
            $this, // Table
            'x_pc_09_head', // Variable name
            'pc_09_head', // Name
            '`pc_09_head`', // Expression
            '`pc_09_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_09_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_09_head->addMethod("getDefault", fn() => "--NA--");
        $this->pc_09_head->InputTextType = "text";
        $this->pc_09_head->Nullable = false; // NOT NULL field
        $this->pc_09_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_09_head'] = &$this->pc_09_head;

        // pc_10_head
        $this->pc_10_head = new DbField(
            $this, // Table
            'x_pc_10_head', // Variable name
            'pc_10_head', // Name
            '`pc_10_head`', // Expression
            '`pc_10_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_10_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_10_head->addMethod("getDefault", fn() => "--NA--");
        $this->pc_10_head->InputTextType = "text";
        $this->pc_10_head->Nullable = false; // NOT NULL field
        $this->pc_10_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_10_head'] = &$this->pc_10_head;

        // pc_11_head
        $this->pc_11_head = new DbField(
            $this, // Table
            'x_pc_11_head', // Variable name
            'pc_11_head', // Name
            '`pc_11_head`', // Expression
            '`pc_11_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_11_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_11_head->addMethod("getDefault", fn() => "--NA--");
        $this->pc_11_head->InputTextType = "text";
        $this->pc_11_head->Nullable = false; // NOT NULL field
        $this->pc_11_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_11_head'] = &$this->pc_11_head;

        // pc_12_head
        $this->pc_12_head = new DbField(
            $this, // Table
            'x_pc_12_head', // Variable name
            'pc_12_head', // Name
            '`pc_12_head`', // Expression
            '`pc_12_head`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_12_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pc_12_head->addMethod("getDefault", fn() => "--NA--");
        $this->pc_12_head->InputTextType = "text";
        $this->pc_12_head->Nullable = false; // NOT NULL field
        $this->pc_12_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pc_12_head'] = &$this->pc_12_head;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // image
        $this->image = new DbField(
            $this, // Table
            'x_image', // Variable name
            'image', // Name
            '`image`', // Expression
            '`image`', // Basic search expression
            200, // Type
            196, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`image`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->image->addMethod("getUploadPath", fn() => '.p_uploads/category/s_grp/');
        $this->image->InputTextType = "text";
        $this->image->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['image'] = &$this->image;

        // pa_process_size_w
        $this->pa_process_size_w = new DbField(
            $this, // Table
            'x_pa_process_size_w', // Variable name
            'pa_process_size_w', // Name
            '`pa_process_size_w`', // Expression
            '`pa_process_size_w`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_process_size_w`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_process_size_w->InputTextType = "text";
        $this->pa_process_size_w->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_process_size_w'] = &$this->pa_process_size_w;

        // pa_process_size_l
        $this->pa_process_size_l = new DbField(
            $this, // Table
            'x_pa_process_size_l', // Variable name
            'pa_process_size_l', // Name
            '`pa_process_size_l`', // Expression
            '`pa_process_size_l`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_process_size_l`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_process_size_l->InputTextType = "text";
        $this->pa_process_size_l->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_process_size_l'] = &$this->pa_process_size_l;

        // pa_head_01
        $this->pa_head_01 = new DbField(
            $this, // Table
            'x_pa_head_01', // Variable name
            'pa_head_01', // Name
            '`pa_head_01`', // Expression
            '`pa_head_01`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_head_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_head_01->addMethod("getDefault", fn() => "--NA--");
        $this->pa_head_01->InputTextType = "text";
        $this->pa_head_01->Nullable = false; // NOT NULL field
        $this->pa_head_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pa_head_01'] = &$this->pa_head_01;

        // pa_process_01
        $this->pa_process_01 = new DbField(
            $this, // Table
            'x_pa_process_01', // Variable name
            'pa_process_01', // Name
            '`pa_process_01`', // Expression
            '`pa_process_01`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_process_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->pa_process_01->addMethod("getSelectFilter", fn() => "`type`=1");
        $this->pa_process_01->InputTextType = "text";
        $this->pa_process_01->Lookup = new Lookup($this->pa_process_01, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->pa_process_01->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_process_01'] = &$this->pa_process_01;

        // pa_head_02
        $this->pa_head_02 = new DbField(
            $this, // Table
            'x_pa_head_02', // Variable name
            'pa_head_02', // Name
            '`pa_head_02`', // Expression
            '`pa_head_02`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_head_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_head_02->addMethod("getDefault", fn() => "--NA--");
        $this->pa_head_02->InputTextType = "text";
        $this->pa_head_02->Nullable = false; // NOT NULL field
        $this->pa_head_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pa_head_02'] = &$this->pa_head_02;

        // pa_process_02
        $this->pa_process_02 = new DbField(
            $this, // Table
            'x_pa_process_02', // Variable name
            'pa_process_02', // Name
            '`pa_process_02`', // Expression
            '`pa_process_02`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_process_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->pa_process_02->addMethod("getSelectFilter", fn() => "`type`=1");
        $this->pa_process_02->InputTextType = "text";
        $this->pa_process_02->Lookup = new Lookup($this->pa_process_02, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->pa_process_02->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_process_02'] = &$this->pa_process_02;

        // pa_head_03
        $this->pa_head_03 = new DbField(
            $this, // Table
            'x_pa_head_03', // Variable name
            'pa_head_03', // Name
            '`pa_head_03`', // Expression
            '`pa_head_03`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_head_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_head_03->addMethod("getDefault", fn() => "--NA--");
        $this->pa_head_03->InputTextType = "text";
        $this->pa_head_03->Nullable = false; // NOT NULL field
        $this->pa_head_03->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pa_head_03'] = &$this->pa_head_03;

        // pa_process_03
        $this->pa_process_03 = new DbField(
            $this, // Table
            'x_pa_process_03', // Variable name
            'pa_process_03', // Name
            '`pa_process_03`', // Expression
            '`pa_process_03`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_process_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->pa_process_03->addMethod("getSelectFilter", fn() => "`type`=1");
        $this->pa_process_03->InputTextType = "text";
        $this->pa_process_03->Lookup = new Lookup($this->pa_process_03, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->pa_process_03->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_process_03'] = &$this->pa_process_03;

        // pa_head_04
        $this->pa_head_04 = new DbField(
            $this, // Table
            'x_pa_head_04', // Variable name
            'pa_head_04', // Name
            '`pa_head_04`', // Expression
            '`pa_head_04`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_head_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_head_04->addMethod("getDefault", fn() => "--NA--");
        $this->pa_head_04->InputTextType = "text";
        $this->pa_head_04->Nullable = false; // NOT NULL field
        $this->pa_head_04->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pa_head_04'] = &$this->pa_head_04;

        // pa_process_04
        $this->pa_process_04 = new DbField(
            $this, // Table
            'x_pa_process_04', // Variable name
            'pa_process_04', // Name
            '`pa_process_04`', // Expression
            '`pa_process_04`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_process_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->pa_process_04->addMethod("getSelectFilter", fn() => "`type`=1");
        $this->pa_process_04->InputTextType = "text";
        $this->pa_process_04->Lookup = new Lookup($this->pa_process_04, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->pa_process_04->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_process_04'] = &$this->pa_process_04;

        // pa_head_05
        $this->pa_head_05 = new DbField(
            $this, // Table
            'x_pa_head_05', // Variable name
            'pa_head_05', // Name
            '`pa_head_05`', // Expression
            '`pa_head_05`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_head_05`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_head_05->addMethod("getDefault", fn() => "--NA--");
        $this->pa_head_05->InputTextType = "text";
        $this->pa_head_05->Nullable = false; // NOT NULL field
        $this->pa_head_05->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pa_head_05'] = &$this->pa_head_05;

        // pa_process_05
        $this->pa_process_05 = new DbField(
            $this, // Table
            'x_pa_process_05', // Variable name
            'pa_process_05', // Name
            '`pa_process_05`', // Expression
            '`pa_process_05`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_process_05`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->pa_process_05->addMethod("getSelectFilter", fn() => "`type`=1");
        $this->pa_process_05->InputTextType = "text";
        $this->pa_process_05->Lookup = new Lookup($this->pa_process_05, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->pa_process_05->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_process_05'] = &$this->pa_process_05;

        // pa_head_06
        $this->pa_head_06 = new DbField(
            $this, // Table
            'x_pa_head_06', // Variable name
            'pa_head_06', // Name
            '`pa_head_06`', // Expression
            '`pa_head_06`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_head_06`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_head_06->addMethod("getDefault", fn() => "--NA--");
        $this->pa_head_06->InputTextType = "text";
        $this->pa_head_06->Nullable = false; // NOT NULL field
        $this->pa_head_06->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pa_head_06'] = &$this->pa_head_06;

        // pa_process_06
        $this->pa_process_06 = new DbField(
            $this, // Table
            'x_pa_process_06', // Variable name
            'pa_process_06', // Name
            '`pa_process_06`', // Expression
            '`pa_process_06`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_process_06`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->pa_process_06->addMethod("getSelectFilter", fn() => "`type`=1");
        $this->pa_process_06->InputTextType = "text";
        $this->pa_process_06->Lookup = new Lookup($this->pa_process_06, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->pa_process_06->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_process_06'] = &$this->pa_process_06;

        // pa_head_07
        $this->pa_head_07 = new DbField(
            $this, // Table
            'x_pa_head_07', // Variable name
            'pa_head_07', // Name
            '`pa_head_07`', // Expression
            '`pa_head_07`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_head_07`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_head_07->addMethod("getDefault", fn() => "--NA--");
        $this->pa_head_07->InputTextType = "text";
        $this->pa_head_07->Nullable = false; // NOT NULL field
        $this->pa_head_07->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pa_head_07'] = &$this->pa_head_07;

        // pa_process_07
        $this->pa_process_07 = new DbField(
            $this, // Table
            'x_pa_process_07', // Variable name
            'pa_process_07', // Name
            '`pa_process_07`', // Expression
            '`pa_process_07`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_process_07`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->pa_process_07->addMethod("getSelectFilter", fn() => "`type`=1");
        $this->pa_process_07->InputTextType = "text";
        $this->pa_process_07->Lookup = new Lookup($this->pa_process_07, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->pa_process_07->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_process_07'] = &$this->pa_process_07;

        // pa_head_08
        $this->pa_head_08 = new DbField(
            $this, // Table
            'x_pa_head_08', // Variable name
            'pa_head_08', // Name
            '`pa_head_08`', // Expression
            '`pa_head_08`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_head_08`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_head_08->addMethod("getDefault", fn() => "--NA--");
        $this->pa_head_08->InputTextType = "text";
        $this->pa_head_08->Nullable = false; // NOT NULL field
        $this->pa_head_08->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pa_head_08'] = &$this->pa_head_08;

        // pa_process_08
        $this->pa_process_08 = new DbField(
            $this, // Table
            'x_pa_process_08', // Variable name
            'pa_process_08', // Name
            '`pa_process_08`', // Expression
            '`pa_process_08`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_process_08`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->pa_process_08->addMethod("getSelectFilter", fn() => "`type`=1");
        $this->pa_process_08->InputTextType = "text";
        $this->pa_process_08->Lookup = new Lookup($this->pa_process_08, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->pa_process_08->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_process_08'] = &$this->pa_process_08;

        // pa_head_09
        $this->pa_head_09 = new DbField(
            $this, // Table
            'x_pa_head_09', // Variable name
            'pa_head_09', // Name
            '`pa_head_09`', // Expression
            '`pa_head_09`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_head_09`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_head_09->addMethod("getDefault", fn() => "--NA--");
        $this->pa_head_09->InputTextType = "text";
        $this->pa_head_09->Nullable = false; // NOT NULL field
        $this->pa_head_09->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pa_head_09'] = &$this->pa_head_09;

        // pa_process_09
        $this->pa_process_09 = new DbField(
            $this, // Table
            'x_pa_process_09', // Variable name
            'pa_process_09', // Name
            '`pa_process_09`', // Expression
            '`pa_process_09`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_process_09`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->pa_process_09->addMethod("getSelectFilter", fn() => "`type`=1");
        $this->pa_process_09->InputTextType = "text";
        $this->pa_process_09->Lookup = new Lookup($this->pa_process_09, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->pa_process_09->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_process_09'] = &$this->pa_process_09;

        // pa_head_10
        $this->pa_head_10 = new DbField(
            $this, // Table
            'x_pa_head_10', // Variable name
            'pa_head_10', // Name
            '`pa_head_10`', // Expression
            '`pa_head_10`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_head_10`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_head_10->addMethod("getDefault", fn() => "--NA--");
        $this->pa_head_10->InputTextType = "text";
        $this->pa_head_10->Nullable = false; // NOT NULL field
        $this->pa_head_10->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pa_head_10'] = &$this->pa_head_10;

        // pa_process_10
        $this->pa_process_10 = new DbField(
            $this, // Table
            'x_pa_process_10', // Variable name
            'pa_process_10', // Name
            '`pa_process_10`', // Expression
            '`pa_process_10`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_process_10`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->pa_process_10->addMethod("getSelectFilter", fn() => "`type`=1");
        $this->pa_process_10->InputTextType = "text";
        $this->pa_process_10->Lookup = new Lookup($this->pa_process_10, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->pa_process_10->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_process_10'] = &$this->pa_process_10;

        // publish
        $this->publish = new DbField(
            $this, // Table
            'x_publish', // Variable name
            'publish', // Name
            '`publish`', // Expression
            '`publish`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`publish`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->publish->addMethod("getDefault", fn() => 0);
        $this->publish->InputTextType = "text";
        $this->publish->Raw = true;
        $this->publish->Nullable = false; // NOT NULL field
        $this->publish->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->publish->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['publish'] = &$this->publish;

        // ppr_01
        $this->ppr_01 = new DbField(
            $this, // Table
            'x_ppr_01', // Variable name
            'ppr_01', // Name
            '`ppr_01`', // Expression
            '`ppr_01`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ppr_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ppr_01->addMethod("getDefault", fn() => "--NA--");
        $this->ppr_01->InputTextType = "text";
        $this->ppr_01->Nullable = false; // NOT NULL field
        $this->ppr_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['ppr_01'] = &$this->ppr_01;

        // ppr_02
        $this->ppr_02 = new DbField(
            $this, // Table
            'x_ppr_02', // Variable name
            'ppr_02', // Name
            '`ppr_02`', // Expression
            '`ppr_02`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ppr_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ppr_02->addMethod("getDefault", fn() => "--NA--");
        $this->ppr_02->InputTextType = "text";
        $this->ppr_02->Nullable = false; // NOT NULL field
        $this->ppr_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['ppr_02'] = &$this->ppr_02;

        // ppr_03
        $this->ppr_03 = new DbField(
            $this, // Table
            'x_ppr_03', // Variable name
            'ppr_03', // Name
            '`ppr_03`', // Expression
            '`ppr_03`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ppr_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ppr_03->addMethod("getDefault", fn() => "--NA--");
        $this->ppr_03->InputTextType = "text";
        $this->ppr_03->Nullable = false; // NOT NULL field
        $this->ppr_03->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['ppr_03'] = &$this->ppr_03;

        // ppr_04
        $this->ppr_04 = new DbField(
            $this, // Table
            'x_ppr_04', // Variable name
            'ppr_04', // Name
            '`ppr_04`', // Expression
            '`ppr_04`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ppr_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ppr_04->addMethod("getDefault", fn() => "--NA--");
        $this->ppr_04->InputTextType = "text";
        $this->ppr_04->Nullable = false; // NOT NULL field
        $this->ppr_04->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['ppr_04'] = &$this->ppr_04;

        // ppr_05
        $this->ppr_05 = new DbField(
            $this, // Table
            'x_ppr_05', // Variable name
            'ppr_05', // Name
            '`ppr_05`', // Expression
            '`ppr_05`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ppr_05`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ppr_05->addMethod("getDefault", fn() => "--NA--");
        $this->ppr_05->InputTextType = "text";
        $this->ppr_05->Nullable = false; // NOT NULL field
        $this->ppr_05->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['ppr_05'] = &$this->ppr_05;

        // ppr_06
        $this->ppr_06 = new DbField(
            $this, // Table
            'x_ppr_06', // Variable name
            'ppr_06', // Name
            '`ppr_06`', // Expression
            '`ppr_06`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ppr_06`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ppr_06->addMethod("getDefault", fn() => "--NA--");
        $this->ppr_06->InputTextType = "text";
        $this->ppr_06->Nullable = false; // NOT NULL field
        $this->ppr_06->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['ppr_06'] = &$this->ppr_06;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "product_group";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "`status` = 1";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->grp->DbValue = $row['grp'];
        $this->product_group->DbValue = $row['product_group'];
        $this->calculation_method->DbValue = $row['calculation_method'];
        $this->shape->DbValue = $row['shape'];
        $this->sqm->DbValue = $row['sqm'];
        $this->cbm->DbValue = $row['cbm'];
        $this->process->DbValue = $row['process'];
        $this->status->DbValue = $row['status'];
        $this->v_00->DbValue = $row['v_00'];
        $this->v_01->DbValue = $row['v_01'];
        $this->v_01_validation->DbValue = $row['v_01_validation'];
        $this->v_02->DbValue = $row['v_02'];
        $this->v_02_validation->DbValue = $row['v_02_validation'];
        $this->v_03->DbValue = $row['v_03'];
        $this->v_03_validation->DbValue = $row['v_03_validation'];
        $this->v_04->DbValue = $row['v_04'];
        $this->v_04_validation->DbValue = $row['v_04_validation'];
        $this->v_05->DbValue = $row['v_05'];
        $this->v_05_validation->DbValue = $row['v_05_validation'];
        $this->v_06->DbValue = $row['v_06'];
        $this->v_06_validation->DbValue = $row['v_06_validation'];
        $this->v_07->DbValue = $row['v_07'];
        $this->v_07_validation->DbValue = $row['v_07_validation'];
        $this->v_08->DbValue = $row['v_08'];
        $this->v_08_validation->DbValue = $row['v_08_validation'];
        $this->v_09->DbValue = $row['v_09'];
        $this->v_09_validation->DbValue = $row['v_09_validation'];
        $this->v_10->DbValue = $row['v_10'];
        $this->v_10_validation->DbValue = $row['v_10_validation'];
        $this->b_01_head->DbValue = $row['b_01_head'];
        $this->b_02_head->DbValue = $row['b_02_head'];
        $this->b_03_head->DbValue = $row['b_03_head'];
        $this->b_04_head->DbValue = $row['b_04_head'];
        $this->b_05_head->DbValue = $row['b_05_head'];
        $this->b_06_head->DbValue = $row['b_06_head'];
        $this->b_07_head->DbValue = $row['b_07_head'];
        $this->b_08_head->DbValue = $row['b_08_head'];
        $this->b_09_head->DbValue = $row['b_09_head'];
        $this->b_10_head->DbValue = $row['b_10_head'];
        $this->b_11_head->DbValue = $row['b_11_head'];
        $this->b_12_head->DbValue = $row['b_12_head'];
        $this->b_13_head->DbValue = $row['b_13_head'];
        $this->b_14_head->DbValue = $row['b_14_head'];
        $this->b_15_head->DbValue = $row['b_15_head'];
        $this->q_sku->DbValue = $row['q_sku'];
        $this->t_01_head->DbValue = $row['t_01_head'];
        $this->t_02_head->DbValue = $row['t_02_head'];
        $this->t_03_head->DbValue = $row['t_03_head'];
        $this->t_04_head->DbValue = $row['t_04_head'];
        $this->t_05_head->DbValue = $row['t_05_head'];
        $this->t_06_head->DbValue = $row['t_06_head'];
        $this->t_07_head->DbValue = $row['t_07_head'];
        $this->t_08_head->DbValue = $row['t_08_head'];
        $this->t_09_head->DbValue = $row['t_09_head'];
        $this->t_10_head->DbValue = $row['t_10_head'];
        $this->t_11_head->DbValue = $row['t_11_head'];
        $this->t_12_head->DbValue = $row['t_12_head'];
        $this->t_13_head->DbValue = $row['t_13_head'];
        $this->t_14_head->DbValue = $row['t_14_head'];
        $this->t_15_head->DbValue = $row['t_15_head'];
        $this->po_01_head->DbValue = $row['po_01_head'];
        $this->po_02_head->DbValue = $row['po_02_head'];
        $this->po_03_head->DbValue = $row['po_03_head'];
        $this->po_04_head->DbValue = $row['po_04_head'];
        $this->po_05_head->DbValue = $row['po_05_head'];
        $this->po_06_head->DbValue = $row['po_06_head'];
        $this->po_07_head->DbValue = $row['po_07_head'];
        $this->po_08_head->DbValue = $row['po_08_head'];
        $this->po_17_head->DbValue = $row['po_17_head'];
        $this->po_18_head->DbValue = $row['po_18_head'];
        $this->po_19_head->DbValue = $row['po_19_head'];
        $this->po_20_head->DbValue = $row['po_20_head'];
        $this->jc_01_head->DbValue = $row['jc_01_head'];
        $this->jc_02_head->DbValue = $row['jc_02_head'];
        $this->jc_03_head->DbValue = $row['jc_03_head'];
        $this->jc_04_head->DbValue = $row['jc_04_head'];
        $this->jc_05_head->DbValue = $row['jc_05_head'];
        $this->jc_06_head->DbValue = $row['jc_06_head'];
        $this->jc_07_head->DbValue = $row['jc_07_head'];
        $this->jc_08_head->DbValue = $row['jc_08_head'];
        $this->jc_09_head->DbValue = $row['jc_09_head'];
        $this->jc_10_head->DbValue = $row['jc_10_head'];
        $this->pc_shape->DbValue = $row['pc_shape'];
        $this->pc_unit->DbValue = $row['pc_unit'];
        $this->pc_w->DbValue = $row['pc_w'];
        $this->pc_l->DbValue = $row['pc_l'];
        $this->pc_h->DbValue = $row['pc_h'];
        $this->pc_partner_size->DbValue = $row['pc_partner_size'];
        $this->pc_sqm->DbValue = $row['pc_sqm'];
        $this->pc_01_head->DbValue = $row['pc_01_head'];
        $this->pc_02_head->DbValue = $row['pc_02_head'];
        $this->pc_03_head->DbValue = $row['pc_03_head'];
        $this->pc_04_head->DbValue = $row['pc_04_head'];
        $this->pc_05_head->DbValue = $row['pc_05_head'];
        $this->pc_06_head->DbValue = $row['pc_06_head'];
        $this->pc_07_head->DbValue = $row['pc_07_head'];
        $this->pc_08_head->DbValue = $row['pc_08_head'];
        $this->pc_09_head->DbValue = $row['pc_09_head'];
        $this->pc_10_head->DbValue = $row['pc_10_head'];
        $this->pc_11_head->DbValue = $row['pc_11_head'];
        $this->pc_12_head->DbValue = $row['pc_12_head'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->image->Upload->DbValue = $row['image'];
        $this->pa_process_size_w->DbValue = $row['pa_process_size_w'];
        $this->pa_process_size_l->DbValue = $row['pa_process_size_l'];
        $this->pa_head_01->DbValue = $row['pa_head_01'];
        $this->pa_process_01->DbValue = $row['pa_process_01'];
        $this->pa_head_02->DbValue = $row['pa_head_02'];
        $this->pa_process_02->DbValue = $row['pa_process_02'];
        $this->pa_head_03->DbValue = $row['pa_head_03'];
        $this->pa_process_03->DbValue = $row['pa_process_03'];
        $this->pa_head_04->DbValue = $row['pa_head_04'];
        $this->pa_process_04->DbValue = $row['pa_process_04'];
        $this->pa_head_05->DbValue = $row['pa_head_05'];
        $this->pa_process_05->DbValue = $row['pa_process_05'];
        $this->pa_head_06->DbValue = $row['pa_head_06'];
        $this->pa_process_06->DbValue = $row['pa_process_06'];
        $this->pa_head_07->DbValue = $row['pa_head_07'];
        $this->pa_process_07->DbValue = $row['pa_process_07'];
        $this->pa_head_08->DbValue = $row['pa_head_08'];
        $this->pa_process_08->DbValue = $row['pa_process_08'];
        $this->pa_head_09->DbValue = $row['pa_head_09'];
        $this->pa_process_09->DbValue = $row['pa_process_09'];
        $this->pa_head_10->DbValue = $row['pa_head_10'];
        $this->pa_process_10->DbValue = $row['pa_process_10'];
        $this->publish->DbValue = $row['publish'];
        $this->ppr_01->DbValue = $row['ppr_01'];
        $this->ppr_02->DbValue = $row['ppr_02'];
        $this->ppr_03->DbValue = $row['ppr_03'];
        $this->ppr_04->DbValue = $row['ppr_04'];
        $this->ppr_05->DbValue = $row['ppr_05'];
        $this->ppr_06->DbValue = $row['ppr_06'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['image']) ? [] : [$row['image']];
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->image->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->image->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("productgrouplist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "productgroupview" => $Language->phrase("View"),
            "productgroupedit" => $Language->phrase("Edit"),
            "productgroupadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "productgrouplist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "ProductGroupView",
            Config("API_ADD_ACTION") => "ProductGroupAdd",
            Config("API_EDIT_ACTION") => "ProductGroupEdit",
            Config("API_DELETE_ACTION") => "ProductGroupDelete",
            Config("API_LIST_ACTION") => "ProductGroupList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "productgrouplist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("productgroupview", $parm);
        } else {
            $url = $this->keyUrl("productgroupview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "productgroupadd?" . $parm;
        } else {
            $url = "productgroupadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("productgroupedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("productgrouplist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("productgroupadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("productgrouplist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("productgroupdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->product_group->setDbValue($row['product_group']);
        $this->calculation_method->setDbValue($row['calculation_method']);
        $this->shape->setDbValue($row['shape']);
        $this->sqm->setDbValue($row['sqm']);
        $this->cbm->setDbValue($row['cbm']);
        $this->process->setDbValue($row['process']);
        $this->status->setDbValue($row['status']);
        $this->v_00->setDbValue($row['v_00']);
        $this->v_01->setDbValue($row['v_01']);
        $this->v_01_validation->setDbValue($row['v_01_validation']);
        $this->v_02->setDbValue($row['v_02']);
        $this->v_02_validation->setDbValue($row['v_02_validation']);
        $this->v_03->setDbValue($row['v_03']);
        $this->v_03_validation->setDbValue($row['v_03_validation']);
        $this->v_04->setDbValue($row['v_04']);
        $this->v_04_validation->setDbValue($row['v_04_validation']);
        $this->v_05->setDbValue($row['v_05']);
        $this->v_05_validation->setDbValue($row['v_05_validation']);
        $this->v_06->setDbValue($row['v_06']);
        $this->v_06_validation->setDbValue($row['v_06_validation']);
        $this->v_07->setDbValue($row['v_07']);
        $this->v_07_validation->setDbValue($row['v_07_validation']);
        $this->v_08->setDbValue($row['v_08']);
        $this->v_08_validation->setDbValue($row['v_08_validation']);
        $this->v_09->setDbValue($row['v_09']);
        $this->v_09_validation->setDbValue($row['v_09_validation']);
        $this->v_10->setDbValue($row['v_10']);
        $this->v_10_validation->setDbValue($row['v_10_validation']);
        $this->b_01_head->setDbValue($row['b_01_head']);
        $this->b_02_head->setDbValue($row['b_02_head']);
        $this->b_03_head->setDbValue($row['b_03_head']);
        $this->b_04_head->setDbValue($row['b_04_head']);
        $this->b_05_head->setDbValue($row['b_05_head']);
        $this->b_06_head->setDbValue($row['b_06_head']);
        $this->b_07_head->setDbValue($row['b_07_head']);
        $this->b_08_head->setDbValue($row['b_08_head']);
        $this->b_09_head->setDbValue($row['b_09_head']);
        $this->b_10_head->setDbValue($row['b_10_head']);
        $this->b_11_head->setDbValue($row['b_11_head']);
        $this->b_12_head->setDbValue($row['b_12_head']);
        $this->b_13_head->setDbValue($row['b_13_head']);
        $this->b_14_head->setDbValue($row['b_14_head']);
        $this->b_15_head->setDbValue($row['b_15_head']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->t_01_head->setDbValue($row['t_01_head']);
        $this->t_02_head->setDbValue($row['t_02_head']);
        $this->t_03_head->setDbValue($row['t_03_head']);
        $this->t_04_head->setDbValue($row['t_04_head']);
        $this->t_05_head->setDbValue($row['t_05_head']);
        $this->t_06_head->setDbValue($row['t_06_head']);
        $this->t_07_head->setDbValue($row['t_07_head']);
        $this->t_08_head->setDbValue($row['t_08_head']);
        $this->t_09_head->setDbValue($row['t_09_head']);
        $this->t_10_head->setDbValue($row['t_10_head']);
        $this->t_11_head->setDbValue($row['t_11_head']);
        $this->t_12_head->setDbValue($row['t_12_head']);
        $this->t_13_head->setDbValue($row['t_13_head']);
        $this->t_14_head->setDbValue($row['t_14_head']);
        $this->t_15_head->setDbValue($row['t_15_head']);
        $this->po_01_head->setDbValue($row['po_01_head']);
        $this->po_02_head->setDbValue($row['po_02_head']);
        $this->po_03_head->setDbValue($row['po_03_head']);
        $this->po_04_head->setDbValue($row['po_04_head']);
        $this->po_05_head->setDbValue($row['po_05_head']);
        $this->po_06_head->setDbValue($row['po_06_head']);
        $this->po_07_head->setDbValue($row['po_07_head']);
        $this->po_08_head->setDbValue($row['po_08_head']);
        $this->po_17_head->setDbValue($row['po_17_head']);
        $this->po_18_head->setDbValue($row['po_18_head']);
        $this->po_19_head->setDbValue($row['po_19_head']);
        $this->po_20_head->setDbValue($row['po_20_head']);
        $this->jc_01_head->setDbValue($row['jc_01_head']);
        $this->jc_02_head->setDbValue($row['jc_02_head']);
        $this->jc_03_head->setDbValue($row['jc_03_head']);
        $this->jc_04_head->setDbValue($row['jc_04_head']);
        $this->jc_05_head->setDbValue($row['jc_05_head']);
        $this->jc_06_head->setDbValue($row['jc_06_head']);
        $this->jc_07_head->setDbValue($row['jc_07_head']);
        $this->jc_08_head->setDbValue($row['jc_08_head']);
        $this->jc_09_head->setDbValue($row['jc_09_head']);
        $this->jc_10_head->setDbValue($row['jc_10_head']);
        $this->pc_shape->setDbValue($row['pc_shape']);
        $this->pc_unit->setDbValue($row['pc_unit']);
        $this->pc_w->setDbValue($row['pc_w']);
        $this->pc_l->setDbValue($row['pc_l']);
        $this->pc_h->setDbValue($row['pc_h']);
        $this->pc_partner_size->setDbValue($row['pc_partner_size']);
        $this->pc_sqm->setDbValue($row['pc_sqm']);
        $this->pc_01_head->setDbValue($row['pc_01_head']);
        $this->pc_02_head->setDbValue($row['pc_02_head']);
        $this->pc_03_head->setDbValue($row['pc_03_head']);
        $this->pc_04_head->setDbValue($row['pc_04_head']);
        $this->pc_05_head->setDbValue($row['pc_05_head']);
        $this->pc_06_head->setDbValue($row['pc_06_head']);
        $this->pc_07_head->setDbValue($row['pc_07_head']);
        $this->pc_08_head->setDbValue($row['pc_08_head']);
        $this->pc_09_head->setDbValue($row['pc_09_head']);
        $this->pc_10_head->setDbValue($row['pc_10_head']);
        $this->pc_11_head->setDbValue($row['pc_11_head']);
        $this->pc_12_head->setDbValue($row['pc_12_head']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->image->Upload->DbValue = $row['image'];
        $this->pa_process_size_w->setDbValue($row['pa_process_size_w']);
        $this->pa_process_size_l->setDbValue($row['pa_process_size_l']);
        $this->pa_head_01->setDbValue($row['pa_head_01']);
        $this->pa_process_01->setDbValue($row['pa_process_01']);
        $this->pa_head_02->setDbValue($row['pa_head_02']);
        $this->pa_process_02->setDbValue($row['pa_process_02']);
        $this->pa_head_03->setDbValue($row['pa_head_03']);
        $this->pa_process_03->setDbValue($row['pa_process_03']);
        $this->pa_head_04->setDbValue($row['pa_head_04']);
        $this->pa_process_04->setDbValue($row['pa_process_04']);
        $this->pa_head_05->setDbValue($row['pa_head_05']);
        $this->pa_process_05->setDbValue($row['pa_process_05']);
        $this->pa_head_06->setDbValue($row['pa_head_06']);
        $this->pa_process_06->setDbValue($row['pa_process_06']);
        $this->pa_head_07->setDbValue($row['pa_head_07']);
        $this->pa_process_07->setDbValue($row['pa_process_07']);
        $this->pa_head_08->setDbValue($row['pa_head_08']);
        $this->pa_process_08->setDbValue($row['pa_process_08']);
        $this->pa_head_09->setDbValue($row['pa_head_09']);
        $this->pa_process_09->setDbValue($row['pa_process_09']);
        $this->pa_head_10->setDbValue($row['pa_head_10']);
        $this->pa_process_10->setDbValue($row['pa_process_10']);
        $this->publish->setDbValue($row['publish']);
        $this->ppr_01->setDbValue($row['ppr_01']);
        $this->ppr_02->setDbValue($row['ppr_02']);
        $this->ppr_03->setDbValue($row['ppr_03']);
        $this->ppr_04->setDbValue($row['ppr_04']);
        $this->ppr_05->setDbValue($row['ppr_05']);
        $this->ppr_06->setDbValue($row['ppr_06']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "ProductGroupList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // grp

        // product_group

        // calculation_method

        // shape

        // sqm

        // cbm

        // process

        // status

        // v_00

        // v_01

        // v_01_validation

        // v_02

        // v_02_validation

        // v_03

        // v_03_validation

        // v_04

        // v_04_validation

        // v_05

        // v_05_validation

        // v_06

        // v_06_validation

        // v_07

        // v_07_validation

        // v_08

        // v_08_validation

        // v_09

        // v_09_validation

        // v_10

        // v_10_validation

        // b_01_head

        // b_02_head

        // b_03_head

        // b_04_head

        // b_05_head

        // b_06_head

        // b_07_head

        // b_08_head

        // b_09_head

        // b_10_head

        // b_11_head

        // b_12_head

        // b_13_head

        // b_14_head

        // b_15_head

        // q_sku

        // t_01_head

        // t_02_head

        // t_03_head

        // t_04_head

        // t_05_head

        // t_06_head

        // t_07_head

        // t_08_head

        // t_09_head

        // t_10_head

        // t_11_head

        // t_12_head

        // t_13_head

        // t_14_head

        // t_15_head

        // po_01_head

        // po_02_head

        // po_03_head

        // po_04_head

        // po_05_head

        // po_06_head

        // po_07_head

        // po_08_head

        // po_17_head

        // po_18_head

        // po_19_head

        // po_20_head

        // jc_01_head

        // jc_02_head

        // jc_03_head

        // jc_04_head

        // jc_05_head

        // jc_06_head

        // jc_07_head

        // jc_08_head

        // jc_09_head

        // jc_10_head

        // pc_shape

        // pc_unit

        // pc_w

        // pc_l

        // pc_h

        // pc_partner_size

        // pc_sqm

        // pc_01_head

        // pc_02_head

        // pc_03_head

        // pc_04_head

        // pc_05_head

        // pc_06_head

        // pc_07_head

        // pc_08_head

        // pc_09_head

        // pc_10_head

        // pc_11_head

        // pc_12_head

        // operator

        // datetime

        // image

        // pa_process_size_w

        // pa_process_size_l

        // pa_head_01

        // pa_process_01

        // pa_head_02

        // pa_process_02

        // pa_head_03

        // pa_process_03

        // pa_head_04

        // pa_process_04

        // pa_head_05

        // pa_process_05

        // pa_head_06

        // pa_process_06

        // pa_head_07

        // pa_process_07

        // pa_head_08

        // pa_process_08

        // pa_head_09

        // pa_process_09

        // pa_head_10

        // pa_process_10

        // publish

        // ppr_01

        // ppr_02

        // ppr_03

        // ppr_04

        // ppr_05

        // ppr_06

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = $this->grp->CurrentValue;
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // product_group
        $this->product_group->ViewValue = $this->product_group->CurrentValue;

        // calculation_method
        $curVal = strval($this->calculation_method->CurrentValue);
        if ($curVal != "") {
            $this->calculation_method->ViewValue = $this->calculation_method->lookupCacheOption($curVal);
            if ($this->calculation_method->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->calculation_method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->calculation_method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->calculation_method->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->calculation_method->Lookup->renderViewRow($rswrk[0]);
                    $this->calculation_method->ViewValue = $this->calculation_method->displayValue($arwrk);
                } else {
                    $this->calculation_method->ViewValue = FormatNumber($this->calculation_method->CurrentValue, $this->calculation_method->formatPattern());
                }
            }
        } else {
            $this->calculation_method->ViewValue = null;
        }

        // shape
        $this->shape->ViewValue = $this->shape->CurrentValue;

        // sqm
        $this->sqm->ViewValue = $this->sqm->CurrentValue;

        // cbm
        $this->cbm->ViewValue = $this->cbm->CurrentValue;

        // process
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                    $this->process->ViewValue = $this->process->displayValue($arwrk);
                } else {
                    $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                }
            }
        } else {
            $this->process->ViewValue = null;
        }

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // v_00
        $this->v_00->ViewValue = $this->v_00->CurrentValue;

        // v_01
        $this->v_01->ViewValue = $this->v_01->CurrentValue;

        // v_01_validation
        $this->v_01_validation->ViewValue = $this->v_01_validation->CurrentValue;

        // v_02
        $this->v_02->ViewValue = $this->v_02->CurrentValue;

        // v_02_validation
        $this->v_02_validation->ViewValue = $this->v_02_validation->CurrentValue;

        // v_03
        $this->v_03->ViewValue = $this->v_03->CurrentValue;

        // v_03_validation
        $this->v_03_validation->ViewValue = $this->v_03_validation->CurrentValue;

        // v_04
        $this->v_04->ViewValue = $this->v_04->CurrentValue;

        // v_04_validation
        $this->v_04_validation->ViewValue = $this->v_04_validation->CurrentValue;

        // v_05
        $this->v_05->ViewValue = $this->v_05->CurrentValue;

        // v_05_validation
        $this->v_05_validation->ViewValue = $this->v_05_validation->CurrentValue;

        // v_06
        $this->v_06->ViewValue = $this->v_06->CurrentValue;

        // v_06_validation
        $this->v_06_validation->ViewValue = $this->v_06_validation->CurrentValue;

        // v_07
        $this->v_07->ViewValue = $this->v_07->CurrentValue;

        // v_07_validation
        $this->v_07_validation->ViewValue = $this->v_07_validation->CurrentValue;

        // v_08
        $this->v_08->ViewValue = $this->v_08->CurrentValue;

        // v_08_validation
        $this->v_08_validation->ViewValue = $this->v_08_validation->CurrentValue;

        // v_09
        $this->v_09->ViewValue = $this->v_09->CurrentValue;

        // v_09_validation
        $this->v_09_validation->ViewValue = $this->v_09_validation->CurrentValue;

        // v_10
        $this->v_10->ViewValue = $this->v_10->CurrentValue;

        // v_10_validation
        $this->v_10_validation->ViewValue = $this->v_10_validation->CurrentValue;

        // b_01_head
        $this->b_01_head->ViewValue = $this->b_01_head->CurrentValue;

        // b_02_head
        $this->b_02_head->ViewValue = $this->b_02_head->CurrentValue;

        // b_03_head
        $this->b_03_head->ViewValue = $this->b_03_head->CurrentValue;

        // b_04_head
        $this->b_04_head->ViewValue = $this->b_04_head->CurrentValue;

        // b_05_head
        $this->b_05_head->ViewValue = $this->b_05_head->CurrentValue;

        // b_06_head
        $this->b_06_head->ViewValue = $this->b_06_head->CurrentValue;

        // b_07_head
        $this->b_07_head->ViewValue = $this->b_07_head->CurrentValue;

        // b_08_head
        $this->b_08_head->ViewValue = $this->b_08_head->CurrentValue;

        // b_09_head
        $this->b_09_head->ViewValue = $this->b_09_head->CurrentValue;

        // b_10_head
        $this->b_10_head->ViewValue = $this->b_10_head->CurrentValue;

        // b_11_head
        $this->b_11_head->ViewValue = $this->b_11_head->CurrentValue;

        // b_12_head
        $this->b_12_head->ViewValue = $this->b_12_head->CurrentValue;

        // b_13_head
        $this->b_13_head->ViewValue = $this->b_13_head->CurrentValue;

        // b_14_head
        $this->b_14_head->ViewValue = $this->b_14_head->CurrentValue;

        // b_15_head
        $this->b_15_head->ViewValue = $this->b_15_head->CurrentValue;

        // q_sku
        $this->q_sku->ViewValue = $this->q_sku->CurrentValue;

        // t_01_head
        $this->t_01_head->ViewValue = $this->t_01_head->CurrentValue;

        // t_02_head
        $this->t_02_head->ViewValue = $this->t_02_head->CurrentValue;

        // t_03_head
        $this->t_03_head->ViewValue = $this->t_03_head->CurrentValue;

        // t_04_head
        $this->t_04_head->ViewValue = $this->t_04_head->CurrentValue;

        // t_05_head
        $this->t_05_head->ViewValue = $this->t_05_head->CurrentValue;

        // t_06_head
        $this->t_06_head->ViewValue = $this->t_06_head->CurrentValue;

        // t_07_head
        $this->t_07_head->ViewValue = $this->t_07_head->CurrentValue;

        // t_08_head
        $this->t_08_head->ViewValue = $this->t_08_head->CurrentValue;

        // t_09_head
        $this->t_09_head->ViewValue = $this->t_09_head->CurrentValue;

        // t_10_head
        $this->t_10_head->ViewValue = $this->t_10_head->CurrentValue;

        // t_11_head
        $this->t_11_head->ViewValue = $this->t_11_head->CurrentValue;

        // t_12_head
        $this->t_12_head->ViewValue = $this->t_12_head->CurrentValue;

        // t_13_head
        $this->t_13_head->ViewValue = $this->t_13_head->CurrentValue;

        // t_14_head
        $this->t_14_head->ViewValue = $this->t_14_head->CurrentValue;

        // t_15_head
        $this->t_15_head->ViewValue = $this->t_15_head->CurrentValue;

        // po_01_head
        $this->po_01_head->ViewValue = $this->po_01_head->CurrentValue;

        // po_02_head
        $this->po_02_head->ViewValue = $this->po_02_head->CurrentValue;

        // po_03_head
        $this->po_03_head->ViewValue = $this->po_03_head->CurrentValue;

        // po_04_head
        $this->po_04_head->ViewValue = $this->po_04_head->CurrentValue;

        // po_05_head
        $this->po_05_head->ViewValue = $this->po_05_head->CurrentValue;

        // po_06_head
        $this->po_06_head->ViewValue = $this->po_06_head->CurrentValue;

        // po_07_head
        $this->po_07_head->ViewValue = $this->po_07_head->CurrentValue;

        // po_08_head
        $this->po_08_head->ViewValue = $this->po_08_head->CurrentValue;

        // po_17_head
        $this->po_17_head->ViewValue = $this->po_17_head->CurrentValue;

        // po_18_head
        $this->po_18_head->ViewValue = $this->po_18_head->CurrentValue;

        // po_19_head
        $this->po_19_head->ViewValue = $this->po_19_head->CurrentValue;

        // po_20_head
        $this->po_20_head->ViewValue = $this->po_20_head->CurrentValue;

        // jc_01_head
        $this->jc_01_head->ViewValue = $this->jc_01_head->CurrentValue;

        // jc_02_head
        $this->jc_02_head->ViewValue = $this->jc_02_head->CurrentValue;

        // jc_03_head
        $this->jc_03_head->ViewValue = $this->jc_03_head->CurrentValue;

        // jc_04_head
        $this->jc_04_head->ViewValue = $this->jc_04_head->CurrentValue;

        // jc_05_head
        $this->jc_05_head->ViewValue = $this->jc_05_head->CurrentValue;

        // jc_06_head
        $this->jc_06_head->ViewValue = $this->jc_06_head->CurrentValue;

        // jc_07_head
        $this->jc_07_head->ViewValue = $this->jc_07_head->CurrentValue;

        // jc_08_head
        $this->jc_08_head->ViewValue = $this->jc_08_head->CurrentValue;

        // jc_09_head
        $this->jc_09_head->ViewValue = $this->jc_09_head->CurrentValue;

        // jc_10_head
        $this->jc_10_head->ViewValue = $this->jc_10_head->CurrentValue;

        // pc_shape
        $this->pc_shape->ViewValue = $this->pc_shape->CurrentValue;

        // pc_unit
        $this->pc_unit->ViewValue = $this->pc_unit->CurrentValue;

        // pc_w
        $this->pc_w->ViewValue = $this->pc_w->CurrentValue;

        // pc_l
        $this->pc_l->ViewValue = $this->pc_l->CurrentValue;

        // pc_h
        $this->pc_h->ViewValue = $this->pc_h->CurrentValue;

        // pc_partner_size
        $this->pc_partner_size->ViewValue = $this->pc_partner_size->CurrentValue;

        // pc_sqm
        $this->pc_sqm->ViewValue = $this->pc_sqm->CurrentValue;

        // pc_01_head
        $this->pc_01_head->ViewValue = $this->pc_01_head->CurrentValue;

        // pc_02_head
        $this->pc_02_head->ViewValue = $this->pc_02_head->CurrentValue;

        // pc_03_head
        $this->pc_03_head->ViewValue = $this->pc_03_head->CurrentValue;

        // pc_04_head
        $this->pc_04_head->ViewValue = $this->pc_04_head->CurrentValue;

        // pc_05_head
        $this->pc_05_head->ViewValue = $this->pc_05_head->CurrentValue;

        // pc_06_head
        $this->pc_06_head->ViewValue = $this->pc_06_head->CurrentValue;

        // pc_07_head
        $this->pc_07_head->ViewValue = $this->pc_07_head->CurrentValue;

        // pc_08_head
        $this->pc_08_head->ViewValue = $this->pc_08_head->CurrentValue;

        // pc_09_head
        $this->pc_09_head->ViewValue = $this->pc_09_head->CurrentValue;

        // pc_10_head
        $this->pc_10_head->ViewValue = $this->pc_10_head->CurrentValue;

        // pc_11_head
        $this->pc_11_head->ViewValue = $this->pc_11_head->CurrentValue;

        // pc_12_head
        $this->pc_12_head->ViewValue = $this->pc_12_head->CurrentValue;

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // image
        $this->image->UploadPath = $this->image->getUploadPath(); // PHP
        if (!EmptyValue($this->image->Upload->DbValue)) {
            $this->image->ImageWidth = 0;
            $this->image->ImageHeight = 50;
            $this->image->ImageAlt = $this->image->alt();
            $this->image->ImageCssClass = "ew-image";
            $this->image->ViewValue = $this->image->Upload->DbValue;
        } else {
            $this->image->ViewValue = "";
        }

        // pa_process_size_w
        $this->pa_process_size_w->ViewValue = $this->pa_process_size_w->CurrentValue;

        // pa_process_size_l
        $this->pa_process_size_l->ViewValue = $this->pa_process_size_l->CurrentValue;

        // pa_head_01
        $this->pa_head_01->ViewValue = $this->pa_head_01->CurrentValue;

        // pa_process_01
        $curVal = strval($this->pa_process_01->CurrentValue);
        if ($curVal != "") {
            $this->pa_process_01->ViewValue = $this->pa_process_01->lookupCacheOption($curVal);
            if ($this->pa_process_01->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->pa_process_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_01->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->pa_process_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_01->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_01->Lookup->renderViewRow($row);
                        $this->pa_process_01->ViewValue->add($this->pa_process_01->displayValue($arwrk));
                    }
                } else {
                    $this->pa_process_01->ViewValue = $this->pa_process_01->CurrentValue;
                }
            }
        } else {
            $this->pa_process_01->ViewValue = null;
        }

        // pa_head_02
        $this->pa_head_02->ViewValue = $this->pa_head_02->CurrentValue;

        // pa_process_02
        $curVal = strval($this->pa_process_02->CurrentValue);
        if ($curVal != "") {
            $this->pa_process_02->ViewValue = $this->pa_process_02->lookupCacheOption($curVal);
            if ($this->pa_process_02->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->pa_process_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_02->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->pa_process_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_02->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_02->Lookup->renderViewRow($row);
                        $this->pa_process_02->ViewValue->add($this->pa_process_02->displayValue($arwrk));
                    }
                } else {
                    $this->pa_process_02->ViewValue = $this->pa_process_02->CurrentValue;
                }
            }
        } else {
            $this->pa_process_02->ViewValue = null;
        }

        // pa_head_03
        $this->pa_head_03->ViewValue = $this->pa_head_03->CurrentValue;

        // pa_process_03
        $curVal = strval($this->pa_process_03->CurrentValue);
        if ($curVal != "") {
            $this->pa_process_03->ViewValue = $this->pa_process_03->lookupCacheOption($curVal);
            if ($this->pa_process_03->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->pa_process_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_03->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->pa_process_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_03->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_03->Lookup->renderViewRow($row);
                        $this->pa_process_03->ViewValue->add($this->pa_process_03->displayValue($arwrk));
                    }
                } else {
                    $this->pa_process_03->ViewValue = $this->pa_process_03->CurrentValue;
                }
            }
        } else {
            $this->pa_process_03->ViewValue = null;
        }

        // pa_head_04
        $this->pa_head_04->ViewValue = $this->pa_head_04->CurrentValue;

        // pa_process_04
        $curVal = strval($this->pa_process_04->CurrentValue);
        if ($curVal != "") {
            $this->pa_process_04->ViewValue = $this->pa_process_04->lookupCacheOption($curVal);
            if ($this->pa_process_04->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->pa_process_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_04->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->pa_process_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_04->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_04->Lookup->renderViewRow($row);
                        $this->pa_process_04->ViewValue->add($this->pa_process_04->displayValue($arwrk));
                    }
                } else {
                    $this->pa_process_04->ViewValue = $this->pa_process_04->CurrentValue;
                }
            }
        } else {
            $this->pa_process_04->ViewValue = null;
        }

        // pa_head_05
        $this->pa_head_05->ViewValue = $this->pa_head_05->CurrentValue;

        // pa_process_05
        $curVal = strval($this->pa_process_05->CurrentValue);
        if ($curVal != "") {
            $this->pa_process_05->ViewValue = $this->pa_process_05->lookupCacheOption($curVal);
            if ($this->pa_process_05->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->pa_process_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_05->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->pa_process_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_05->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_05->Lookup->renderViewRow($row);
                        $this->pa_process_05->ViewValue->add($this->pa_process_05->displayValue($arwrk));
                    }
                } else {
                    $this->pa_process_05->ViewValue = $this->pa_process_05->CurrentValue;
                }
            }
        } else {
            $this->pa_process_05->ViewValue = null;
        }

        // pa_head_06
        $this->pa_head_06->ViewValue = $this->pa_head_06->CurrentValue;

        // pa_process_06
        $curVal = strval($this->pa_process_06->CurrentValue);
        if ($curVal != "") {
            $this->pa_process_06->ViewValue = $this->pa_process_06->lookupCacheOption($curVal);
            if ($this->pa_process_06->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->pa_process_06->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_06->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->pa_process_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_06->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_06->Lookup->renderViewRow($row);
                        $this->pa_process_06->ViewValue->add($this->pa_process_06->displayValue($arwrk));
                    }
                } else {
                    $this->pa_process_06->ViewValue = $this->pa_process_06->CurrentValue;
                }
            }
        } else {
            $this->pa_process_06->ViewValue = null;
        }

        // pa_head_07
        $this->pa_head_07->ViewValue = $this->pa_head_07->CurrentValue;

        // pa_process_07
        $curVal = strval($this->pa_process_07->CurrentValue);
        if ($curVal != "") {
            $this->pa_process_07->ViewValue = $this->pa_process_07->lookupCacheOption($curVal);
            if ($this->pa_process_07->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->pa_process_07->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_07->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->pa_process_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_07->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_07->Lookup->renderViewRow($row);
                        $this->pa_process_07->ViewValue->add($this->pa_process_07->displayValue($arwrk));
                    }
                } else {
                    $this->pa_process_07->ViewValue = $this->pa_process_07->CurrentValue;
                }
            }
        } else {
            $this->pa_process_07->ViewValue = null;
        }

        // pa_head_08
        $this->pa_head_08->ViewValue = $this->pa_head_08->CurrentValue;

        // pa_process_08
        $curVal = strval($this->pa_process_08->CurrentValue);
        if ($curVal != "") {
            $this->pa_process_08->ViewValue = $this->pa_process_08->lookupCacheOption($curVal);
            if ($this->pa_process_08->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->pa_process_08->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_08->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->pa_process_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_08->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_08->Lookup->renderViewRow($row);
                        $this->pa_process_08->ViewValue->add($this->pa_process_08->displayValue($arwrk));
                    }
                } else {
                    $this->pa_process_08->ViewValue = $this->pa_process_08->CurrentValue;
                }
            }
        } else {
            $this->pa_process_08->ViewValue = null;
        }

        // pa_head_09
        $this->pa_head_09->ViewValue = $this->pa_head_09->CurrentValue;

        // pa_process_09
        $curVal = strval($this->pa_process_09->CurrentValue);
        if ($curVal != "") {
            $this->pa_process_09->ViewValue = $this->pa_process_09->lookupCacheOption($curVal);
            if ($this->pa_process_09->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->pa_process_09->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_09->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->pa_process_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_09->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_09->Lookup->renderViewRow($row);
                        $this->pa_process_09->ViewValue->add($this->pa_process_09->displayValue($arwrk));
                    }
                } else {
                    $this->pa_process_09->ViewValue = $this->pa_process_09->CurrentValue;
                }
            }
        } else {
            $this->pa_process_09->ViewValue = null;
        }

        // pa_head_10
        $this->pa_head_10->ViewValue = $this->pa_head_10->CurrentValue;

        // pa_process_10
        $curVal = strval($this->pa_process_10->CurrentValue);
        if ($curVal != "") {
            $this->pa_process_10->ViewValue = $this->pa_process_10->lookupCacheOption($curVal);
            if ($this->pa_process_10->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->pa_process_10->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->pa_process_10->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->pa_process_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_process_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->pa_process_10->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->pa_process_10->Lookup->renderViewRow($row);
                        $this->pa_process_10->ViewValue->add($this->pa_process_10->displayValue($arwrk));
                    }
                } else {
                    $this->pa_process_10->ViewValue = $this->pa_process_10->CurrentValue;
                }
            }
        } else {
            $this->pa_process_10->ViewValue = null;
        }

        // publish
        $this->publish->ViewValue = $this->publish->CurrentValue;
        $this->publish->ViewValue = FormatNumber($this->publish->ViewValue, $this->publish->formatPattern());

        // ppr_01
        $this->ppr_01->ViewValue = $this->ppr_01->CurrentValue;

        // ppr_02
        $this->ppr_02->ViewValue = $this->ppr_02->CurrentValue;

        // ppr_03
        $this->ppr_03->ViewValue = $this->ppr_03->CurrentValue;

        // ppr_04
        $this->ppr_04->ViewValue = $this->ppr_04->CurrentValue;

        // ppr_05
        $this->ppr_05->ViewValue = $this->ppr_05->CurrentValue;

        // ppr_06
        $this->ppr_06->ViewValue = $this->ppr_06->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // product_group
        $this->product_group->HrefValue = "";
        $this->product_group->TooltipValue = "";

        // calculation_method
        $this->calculation_method->HrefValue = "";
        $this->calculation_method->TooltipValue = "";

        // shape
        $this->shape->HrefValue = "";
        $this->shape->TooltipValue = "";

        // sqm
        $this->sqm->HrefValue = "";
        $this->sqm->TooltipValue = "";

        // cbm
        $this->cbm->HrefValue = "";
        $this->cbm->TooltipValue = "";

        // process
        $this->process->HrefValue = "";
        $this->process->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // v_00
        $this->v_00->HrefValue = "";
        $this->v_00->TooltipValue = "";

        // v_01
        $this->v_01->HrefValue = "";
        $this->v_01->TooltipValue = "";

        // v_01_validation
        $this->v_01_validation->HrefValue = "";
        $this->v_01_validation->TooltipValue = "";

        // v_02
        $this->v_02->HrefValue = "";
        $this->v_02->TooltipValue = "";

        // v_02_validation
        $this->v_02_validation->HrefValue = "";
        $this->v_02_validation->TooltipValue = "";

        // v_03
        $this->v_03->HrefValue = "";
        $this->v_03->TooltipValue = "";

        // v_03_validation
        $this->v_03_validation->HrefValue = "";
        $this->v_03_validation->TooltipValue = "";

        // v_04
        $this->v_04->HrefValue = "";
        $this->v_04->TooltipValue = "";

        // v_04_validation
        $this->v_04_validation->HrefValue = "";
        $this->v_04_validation->TooltipValue = "";

        // v_05
        $this->v_05->HrefValue = "";
        $this->v_05->TooltipValue = "";

        // v_05_validation
        $this->v_05_validation->HrefValue = "";
        $this->v_05_validation->TooltipValue = "";

        // v_06
        $this->v_06->HrefValue = "";
        $this->v_06->TooltipValue = "";

        // v_06_validation
        $this->v_06_validation->HrefValue = "";
        $this->v_06_validation->TooltipValue = "";

        // v_07
        $this->v_07->HrefValue = "";
        $this->v_07->TooltipValue = "";

        // v_07_validation
        $this->v_07_validation->HrefValue = "";
        $this->v_07_validation->TooltipValue = "";

        // v_08
        $this->v_08->HrefValue = "";
        $this->v_08->TooltipValue = "";

        // v_08_validation
        $this->v_08_validation->HrefValue = "";
        $this->v_08_validation->TooltipValue = "";

        // v_09
        $this->v_09->HrefValue = "";
        $this->v_09->TooltipValue = "";

        // v_09_validation
        $this->v_09_validation->HrefValue = "";
        $this->v_09_validation->TooltipValue = "";

        // v_10
        $this->v_10->HrefValue = "";
        $this->v_10->TooltipValue = "";

        // v_10_validation
        $this->v_10_validation->HrefValue = "";
        $this->v_10_validation->TooltipValue = "";

        // b_01_head
        $this->b_01_head->HrefValue = "";
        $this->b_01_head->TooltipValue = "";

        // b_02_head
        $this->b_02_head->HrefValue = "";
        $this->b_02_head->TooltipValue = "";

        // b_03_head
        $this->b_03_head->HrefValue = "";
        $this->b_03_head->TooltipValue = "";

        // b_04_head
        $this->b_04_head->HrefValue = "";
        $this->b_04_head->TooltipValue = "";

        // b_05_head
        $this->b_05_head->HrefValue = "";
        $this->b_05_head->TooltipValue = "";

        // b_06_head
        $this->b_06_head->HrefValue = "";
        $this->b_06_head->TooltipValue = "";

        // b_07_head
        $this->b_07_head->HrefValue = "";
        $this->b_07_head->TooltipValue = "";

        // b_08_head
        $this->b_08_head->HrefValue = "";
        $this->b_08_head->TooltipValue = "";

        // b_09_head
        $this->b_09_head->HrefValue = "";
        $this->b_09_head->TooltipValue = "";

        // b_10_head
        $this->b_10_head->HrefValue = "";
        $this->b_10_head->TooltipValue = "";

        // b_11_head
        $this->b_11_head->HrefValue = "";
        $this->b_11_head->TooltipValue = "";

        // b_12_head
        $this->b_12_head->HrefValue = "";
        $this->b_12_head->TooltipValue = "";

        // b_13_head
        $this->b_13_head->HrefValue = "";
        $this->b_13_head->TooltipValue = "";

        // b_14_head
        $this->b_14_head->HrefValue = "";
        $this->b_14_head->TooltipValue = "";

        // b_15_head
        $this->b_15_head->HrefValue = "";
        $this->b_15_head->TooltipValue = "";

        // q_sku
        $this->q_sku->HrefValue = "";
        $this->q_sku->TooltipValue = "";

        // t_01_head
        $this->t_01_head->HrefValue = "";
        $this->t_01_head->TooltipValue = "";

        // t_02_head
        $this->t_02_head->HrefValue = "";
        $this->t_02_head->TooltipValue = "";

        // t_03_head
        $this->t_03_head->HrefValue = "";
        $this->t_03_head->TooltipValue = "";

        // t_04_head
        $this->t_04_head->HrefValue = "";
        $this->t_04_head->TooltipValue = "";

        // t_05_head
        $this->t_05_head->HrefValue = "";
        $this->t_05_head->TooltipValue = "";

        // t_06_head
        $this->t_06_head->HrefValue = "";
        $this->t_06_head->TooltipValue = "";

        // t_07_head
        $this->t_07_head->HrefValue = "";
        $this->t_07_head->TooltipValue = "";

        // t_08_head
        $this->t_08_head->HrefValue = "";
        $this->t_08_head->TooltipValue = "";

        // t_09_head
        $this->t_09_head->HrefValue = "";
        $this->t_09_head->TooltipValue = "";

        // t_10_head
        $this->t_10_head->HrefValue = "";
        $this->t_10_head->TooltipValue = "";

        // t_11_head
        $this->t_11_head->HrefValue = "";
        $this->t_11_head->TooltipValue = "";

        // t_12_head
        $this->t_12_head->HrefValue = "";
        $this->t_12_head->TooltipValue = "";

        // t_13_head
        $this->t_13_head->HrefValue = "";
        $this->t_13_head->TooltipValue = "";

        // t_14_head
        $this->t_14_head->HrefValue = "";
        $this->t_14_head->TooltipValue = "";

        // t_15_head
        $this->t_15_head->HrefValue = "";
        $this->t_15_head->TooltipValue = "";

        // po_01_head
        $this->po_01_head->HrefValue = "";
        $this->po_01_head->TooltipValue = "";

        // po_02_head
        $this->po_02_head->HrefValue = "";
        $this->po_02_head->TooltipValue = "";

        // po_03_head
        $this->po_03_head->HrefValue = "";
        $this->po_03_head->TooltipValue = "";

        // po_04_head
        $this->po_04_head->HrefValue = "";
        $this->po_04_head->TooltipValue = "";

        // po_05_head
        $this->po_05_head->HrefValue = "";
        $this->po_05_head->TooltipValue = "";

        // po_06_head
        $this->po_06_head->HrefValue = "";
        $this->po_06_head->TooltipValue = "";

        // po_07_head
        $this->po_07_head->HrefValue = "";
        $this->po_07_head->TooltipValue = "";

        // po_08_head
        $this->po_08_head->HrefValue = "";
        $this->po_08_head->TooltipValue = "";

        // po_17_head
        $this->po_17_head->HrefValue = "";
        $this->po_17_head->TooltipValue = "";

        // po_18_head
        $this->po_18_head->HrefValue = "";
        $this->po_18_head->TooltipValue = "";

        // po_19_head
        $this->po_19_head->HrefValue = "";
        $this->po_19_head->TooltipValue = "";

        // po_20_head
        $this->po_20_head->HrefValue = "";
        $this->po_20_head->TooltipValue = "";

        // jc_01_head
        $this->jc_01_head->HrefValue = "";
        $this->jc_01_head->TooltipValue = "";

        // jc_02_head
        $this->jc_02_head->HrefValue = "";
        $this->jc_02_head->TooltipValue = "";

        // jc_03_head
        $this->jc_03_head->HrefValue = "";
        $this->jc_03_head->TooltipValue = "";

        // jc_04_head
        $this->jc_04_head->HrefValue = "";
        $this->jc_04_head->TooltipValue = "";

        // jc_05_head
        $this->jc_05_head->HrefValue = "";
        $this->jc_05_head->TooltipValue = "";

        // jc_06_head
        $this->jc_06_head->HrefValue = "";
        $this->jc_06_head->TooltipValue = "";

        // jc_07_head
        $this->jc_07_head->HrefValue = "";
        $this->jc_07_head->TooltipValue = "";

        // jc_08_head
        $this->jc_08_head->HrefValue = "";
        $this->jc_08_head->TooltipValue = "";

        // jc_09_head
        $this->jc_09_head->HrefValue = "";
        $this->jc_09_head->TooltipValue = "";

        // jc_10_head
        $this->jc_10_head->HrefValue = "";
        $this->jc_10_head->TooltipValue = "";

        // pc_shape
        $this->pc_shape->HrefValue = "";
        $this->pc_shape->TooltipValue = "";

        // pc_unit
        $this->pc_unit->HrefValue = "";
        $this->pc_unit->TooltipValue = "";

        // pc_w
        $this->pc_w->HrefValue = "";
        $this->pc_w->TooltipValue = "";

        // pc_l
        $this->pc_l->HrefValue = "";
        $this->pc_l->TooltipValue = "";

        // pc_h
        $this->pc_h->HrefValue = "";
        $this->pc_h->TooltipValue = "";

        // pc_partner_size
        $this->pc_partner_size->HrefValue = "";
        $this->pc_partner_size->TooltipValue = "";

        // pc_sqm
        $this->pc_sqm->HrefValue = "";
        $this->pc_sqm->TooltipValue = "";

        // pc_01_head
        $this->pc_01_head->HrefValue = "";
        $this->pc_01_head->TooltipValue = "";

        // pc_02_head
        $this->pc_02_head->HrefValue = "";
        $this->pc_02_head->TooltipValue = "";

        // pc_03_head
        $this->pc_03_head->HrefValue = "";
        $this->pc_03_head->TooltipValue = "";

        // pc_04_head
        $this->pc_04_head->HrefValue = "";
        $this->pc_04_head->TooltipValue = "";

        // pc_05_head
        $this->pc_05_head->HrefValue = "";
        $this->pc_05_head->TooltipValue = "";

        // pc_06_head
        $this->pc_06_head->HrefValue = "";
        $this->pc_06_head->TooltipValue = "";

        // pc_07_head
        $this->pc_07_head->HrefValue = "";
        $this->pc_07_head->TooltipValue = "";

        // pc_08_head
        $this->pc_08_head->HrefValue = "";
        $this->pc_08_head->TooltipValue = "";

        // pc_09_head
        $this->pc_09_head->HrefValue = "";
        $this->pc_09_head->TooltipValue = "";

        // pc_10_head
        $this->pc_10_head->HrefValue = "";
        $this->pc_10_head->TooltipValue = "";

        // pc_11_head
        $this->pc_11_head->HrefValue = "";
        $this->pc_11_head->TooltipValue = "";

        // pc_12_head
        $this->pc_12_head->HrefValue = "";
        $this->pc_12_head->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // image
        $this->image->UploadPath = $this->image->getUploadPath(); // PHP
        if (!EmptyValue($this->image->Upload->DbValue)) {
            $this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->htmlDecode($this->image->Upload->DbValue)); // Add prefix/suffix
            $this->image->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
            }
        } else {
            $this->image->HrefValue = "";
        }
        $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
        $this->image->TooltipValue = "";
        if ($this->image->UseColorbox) {
            if (EmptyValue($this->image->TooltipValue)) {
                $this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->image->LinkAttrs["data-rel"] = "product_group_x_image";
            $this->image->LinkAttrs->appendClass("ew-lightbox");
        }

        // pa_process_size_w
        $this->pa_process_size_w->HrefValue = "";
        $this->pa_process_size_w->TooltipValue = "";

        // pa_process_size_l
        $this->pa_process_size_l->HrefValue = "";
        $this->pa_process_size_l->TooltipValue = "";

        // pa_head_01
        $this->pa_head_01->HrefValue = "";
        $this->pa_head_01->TooltipValue = "";

        // pa_process_01
        $this->pa_process_01->HrefValue = "";
        $this->pa_process_01->TooltipValue = "";

        // pa_head_02
        $this->pa_head_02->HrefValue = "";
        $this->pa_head_02->TooltipValue = "";

        // pa_process_02
        $this->pa_process_02->HrefValue = "";
        $this->pa_process_02->TooltipValue = "";

        // pa_head_03
        $this->pa_head_03->HrefValue = "";
        $this->pa_head_03->TooltipValue = "";

        // pa_process_03
        $this->pa_process_03->HrefValue = "";
        $this->pa_process_03->TooltipValue = "";

        // pa_head_04
        $this->pa_head_04->HrefValue = "";
        $this->pa_head_04->TooltipValue = "";

        // pa_process_04
        $this->pa_process_04->HrefValue = "";
        $this->pa_process_04->TooltipValue = "";

        // pa_head_05
        $this->pa_head_05->HrefValue = "";
        $this->pa_head_05->TooltipValue = "";

        // pa_process_05
        $this->pa_process_05->HrefValue = "";
        $this->pa_process_05->TooltipValue = "";

        // pa_head_06
        $this->pa_head_06->HrefValue = "";
        $this->pa_head_06->TooltipValue = "";

        // pa_process_06
        $this->pa_process_06->HrefValue = "";
        $this->pa_process_06->TooltipValue = "";

        // pa_head_07
        $this->pa_head_07->HrefValue = "";
        $this->pa_head_07->TooltipValue = "";

        // pa_process_07
        $this->pa_process_07->HrefValue = "";
        $this->pa_process_07->TooltipValue = "";

        // pa_head_08
        $this->pa_head_08->HrefValue = "";
        $this->pa_head_08->TooltipValue = "";

        // pa_process_08
        $this->pa_process_08->HrefValue = "";
        $this->pa_process_08->TooltipValue = "";

        // pa_head_09
        $this->pa_head_09->HrefValue = "";
        $this->pa_head_09->TooltipValue = "";

        // pa_process_09
        $this->pa_process_09->HrefValue = "";
        $this->pa_process_09->TooltipValue = "";

        // pa_head_10
        $this->pa_head_10->HrefValue = "";
        $this->pa_head_10->TooltipValue = "";

        // pa_process_10
        $this->pa_process_10->HrefValue = "";
        $this->pa_process_10->TooltipValue = "";

        // publish
        $this->publish->HrefValue = "";
        $this->publish->TooltipValue = "";

        // ppr_01
        $this->ppr_01->HrefValue = "";
        $this->ppr_01->TooltipValue = "";

        // ppr_02
        $this->ppr_02->HrefValue = "";
        $this->ppr_02->TooltipValue = "";

        // ppr_03
        $this->ppr_03->HrefValue = "";
        $this->ppr_03->TooltipValue = "";

        // ppr_04
        $this->ppr_04->HrefValue = "";
        $this->ppr_04->TooltipValue = "";

        // ppr_05
        $this->ppr_05->HrefValue = "";
        $this->ppr_05->TooltipValue = "";

        // ppr_06
        $this->ppr_06->HrefValue = "";
        $this->ppr_06->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

        // product_group
        $this->product_group->setupEditAttributes();
        if (!$this->product_group->Raw) {
            $this->product_group->CurrentValue = HtmlDecode($this->product_group->CurrentValue);
        }
        $this->product_group->EditValue = $this->product_group->CurrentValue;
        $this->product_group->PlaceHolder = RemoveHtml($this->product_group->caption());

        // calculation_method
        $this->calculation_method->setupEditAttributes();
        $this->calculation_method->PlaceHolder = RemoveHtml($this->calculation_method->caption());

        // shape
        $this->shape->setupEditAttributes();
        if (!$this->shape->Raw) {
            $this->shape->CurrentValue = HtmlDecode($this->shape->CurrentValue);
        }
        $this->shape->EditValue = $this->shape->CurrentValue;
        $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

        // sqm
        $this->sqm->setupEditAttributes();
        if (!$this->sqm->Raw) {
            $this->sqm->CurrentValue = HtmlDecode($this->sqm->CurrentValue);
        }
        $this->sqm->EditValue = $this->sqm->CurrentValue;
        $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

        // cbm
        $this->cbm->setupEditAttributes();
        if (!$this->cbm->Raw) {
            $this->cbm->CurrentValue = HtmlDecode($this->cbm->CurrentValue);
        }
        $this->cbm->EditValue = $this->cbm->CurrentValue;
        $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

        // process
        $this->process->setupEditAttributes();
        $this->process->PlaceHolder = RemoveHtml($this->process->caption());

        // status
        $this->status->setupEditAttributes();
        $this->status->EditValue = $this->status->options(true);
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // v_00
        $this->v_00->setupEditAttributes();
        if (!$this->v_00->Raw) {
            $this->v_00->CurrentValue = HtmlDecode($this->v_00->CurrentValue);
        }
        $this->v_00->EditValue = $this->v_00->CurrentValue;
        $this->v_00->PlaceHolder = RemoveHtml($this->v_00->caption());

        // v_01
        $this->v_01->setupEditAttributes();
        if (!$this->v_01->Raw) {
            $this->v_01->CurrentValue = HtmlDecode($this->v_01->CurrentValue);
        }
        $this->v_01->EditValue = $this->v_01->CurrentValue;
        $this->v_01->PlaceHolder = RemoveHtml($this->v_01->caption());

        // v_01_validation
        $this->v_01_validation->setupEditAttributes();
        if (!$this->v_01_validation->Raw) {
            $this->v_01_validation->CurrentValue = HtmlDecode($this->v_01_validation->CurrentValue);
        }
        $this->v_01_validation->EditValue = $this->v_01_validation->CurrentValue;
        $this->v_01_validation->PlaceHolder = RemoveHtml($this->v_01_validation->caption());

        // v_02
        $this->v_02->setupEditAttributes();
        if (!$this->v_02->Raw) {
            $this->v_02->CurrentValue = HtmlDecode($this->v_02->CurrentValue);
        }
        $this->v_02->EditValue = $this->v_02->CurrentValue;
        $this->v_02->PlaceHolder = RemoveHtml($this->v_02->caption());

        // v_02_validation
        $this->v_02_validation->setupEditAttributes();
        if (!$this->v_02_validation->Raw) {
            $this->v_02_validation->CurrentValue = HtmlDecode($this->v_02_validation->CurrentValue);
        }
        $this->v_02_validation->EditValue = $this->v_02_validation->CurrentValue;
        $this->v_02_validation->PlaceHolder = RemoveHtml($this->v_02_validation->caption());

        // v_03
        $this->v_03->setupEditAttributes();
        if (!$this->v_03->Raw) {
            $this->v_03->CurrentValue = HtmlDecode($this->v_03->CurrentValue);
        }
        $this->v_03->EditValue = $this->v_03->CurrentValue;
        $this->v_03->PlaceHolder = RemoveHtml($this->v_03->caption());

        // v_03_validation
        $this->v_03_validation->setupEditAttributes();
        if (!$this->v_03_validation->Raw) {
            $this->v_03_validation->CurrentValue = HtmlDecode($this->v_03_validation->CurrentValue);
        }
        $this->v_03_validation->EditValue = $this->v_03_validation->CurrentValue;
        $this->v_03_validation->PlaceHolder = RemoveHtml($this->v_03_validation->caption());

        // v_04
        $this->v_04->setupEditAttributes();
        if (!$this->v_04->Raw) {
            $this->v_04->CurrentValue = HtmlDecode($this->v_04->CurrentValue);
        }
        $this->v_04->EditValue = $this->v_04->CurrentValue;
        $this->v_04->PlaceHolder = RemoveHtml($this->v_04->caption());

        // v_04_validation
        $this->v_04_validation->setupEditAttributes();
        if (!$this->v_04_validation->Raw) {
            $this->v_04_validation->CurrentValue = HtmlDecode($this->v_04_validation->CurrentValue);
        }
        $this->v_04_validation->EditValue = $this->v_04_validation->CurrentValue;
        $this->v_04_validation->PlaceHolder = RemoveHtml($this->v_04_validation->caption());

        // v_05
        $this->v_05->setupEditAttributes();
        if (!$this->v_05->Raw) {
            $this->v_05->CurrentValue = HtmlDecode($this->v_05->CurrentValue);
        }
        $this->v_05->EditValue = $this->v_05->CurrentValue;
        $this->v_05->PlaceHolder = RemoveHtml($this->v_05->caption());

        // v_05_validation
        $this->v_05_validation->setupEditAttributes();
        if (!$this->v_05_validation->Raw) {
            $this->v_05_validation->CurrentValue = HtmlDecode($this->v_05_validation->CurrentValue);
        }
        $this->v_05_validation->EditValue = $this->v_05_validation->CurrentValue;
        $this->v_05_validation->PlaceHolder = RemoveHtml($this->v_05_validation->caption());

        // v_06
        $this->v_06->setupEditAttributes();
        if (!$this->v_06->Raw) {
            $this->v_06->CurrentValue = HtmlDecode($this->v_06->CurrentValue);
        }
        $this->v_06->EditValue = $this->v_06->CurrentValue;
        $this->v_06->PlaceHolder = RemoveHtml($this->v_06->caption());

        // v_06_validation
        $this->v_06_validation->setupEditAttributes();
        if (!$this->v_06_validation->Raw) {
            $this->v_06_validation->CurrentValue = HtmlDecode($this->v_06_validation->CurrentValue);
        }
        $this->v_06_validation->EditValue = $this->v_06_validation->CurrentValue;
        $this->v_06_validation->PlaceHolder = RemoveHtml($this->v_06_validation->caption());

        // v_07
        $this->v_07->setupEditAttributes();
        if (!$this->v_07->Raw) {
            $this->v_07->CurrentValue = HtmlDecode($this->v_07->CurrentValue);
        }
        $this->v_07->EditValue = $this->v_07->CurrentValue;
        $this->v_07->PlaceHolder = RemoveHtml($this->v_07->caption());

        // v_07_validation
        $this->v_07_validation->setupEditAttributes();
        if (!$this->v_07_validation->Raw) {
            $this->v_07_validation->CurrentValue = HtmlDecode($this->v_07_validation->CurrentValue);
        }
        $this->v_07_validation->EditValue = $this->v_07_validation->CurrentValue;
        $this->v_07_validation->PlaceHolder = RemoveHtml($this->v_07_validation->caption());

        // v_08
        $this->v_08->setupEditAttributes();
        if (!$this->v_08->Raw) {
            $this->v_08->CurrentValue = HtmlDecode($this->v_08->CurrentValue);
        }
        $this->v_08->EditValue = $this->v_08->CurrentValue;
        $this->v_08->PlaceHolder = RemoveHtml($this->v_08->caption());

        // v_08_validation
        $this->v_08_validation->setupEditAttributes();
        if (!$this->v_08_validation->Raw) {
            $this->v_08_validation->CurrentValue = HtmlDecode($this->v_08_validation->CurrentValue);
        }
        $this->v_08_validation->EditValue = $this->v_08_validation->CurrentValue;
        $this->v_08_validation->PlaceHolder = RemoveHtml($this->v_08_validation->caption());

        // v_09
        $this->v_09->setupEditAttributes();
        if (!$this->v_09->Raw) {
            $this->v_09->CurrentValue = HtmlDecode($this->v_09->CurrentValue);
        }
        $this->v_09->EditValue = $this->v_09->CurrentValue;
        $this->v_09->PlaceHolder = RemoveHtml($this->v_09->caption());

        // v_09_validation
        $this->v_09_validation->setupEditAttributes();
        if (!$this->v_09_validation->Raw) {
            $this->v_09_validation->CurrentValue = HtmlDecode($this->v_09_validation->CurrentValue);
        }
        $this->v_09_validation->EditValue = $this->v_09_validation->CurrentValue;
        $this->v_09_validation->PlaceHolder = RemoveHtml($this->v_09_validation->caption());

        // v_10
        $this->v_10->setupEditAttributes();
        if (!$this->v_10->Raw) {
            $this->v_10->CurrentValue = HtmlDecode($this->v_10->CurrentValue);
        }
        $this->v_10->EditValue = $this->v_10->CurrentValue;
        $this->v_10->PlaceHolder = RemoveHtml($this->v_10->caption());

        // v_10_validation
        $this->v_10_validation->setupEditAttributes();
        if (!$this->v_10_validation->Raw) {
            $this->v_10_validation->CurrentValue = HtmlDecode($this->v_10_validation->CurrentValue);
        }
        $this->v_10_validation->EditValue = $this->v_10_validation->CurrentValue;
        $this->v_10_validation->PlaceHolder = RemoveHtml($this->v_10_validation->caption());

        // b_01_head
        $this->b_01_head->setupEditAttributes();
        if (!$this->b_01_head->Raw) {
            $this->b_01_head->CurrentValue = HtmlDecode($this->b_01_head->CurrentValue);
        }
        $this->b_01_head->EditValue = $this->b_01_head->CurrentValue;
        $this->b_01_head->PlaceHolder = RemoveHtml($this->b_01_head->caption());

        // b_02_head
        $this->b_02_head->setupEditAttributes();
        if (!$this->b_02_head->Raw) {
            $this->b_02_head->CurrentValue = HtmlDecode($this->b_02_head->CurrentValue);
        }
        $this->b_02_head->EditValue = $this->b_02_head->CurrentValue;
        $this->b_02_head->PlaceHolder = RemoveHtml($this->b_02_head->caption());

        // b_03_head
        $this->b_03_head->setupEditAttributes();
        if (!$this->b_03_head->Raw) {
            $this->b_03_head->CurrentValue = HtmlDecode($this->b_03_head->CurrentValue);
        }
        $this->b_03_head->EditValue = $this->b_03_head->CurrentValue;
        $this->b_03_head->PlaceHolder = RemoveHtml($this->b_03_head->caption());

        // b_04_head
        $this->b_04_head->setupEditAttributes();
        if (!$this->b_04_head->Raw) {
            $this->b_04_head->CurrentValue = HtmlDecode($this->b_04_head->CurrentValue);
        }
        $this->b_04_head->EditValue = $this->b_04_head->CurrentValue;
        $this->b_04_head->PlaceHolder = RemoveHtml($this->b_04_head->caption());

        // b_05_head
        $this->b_05_head->setupEditAttributes();
        if (!$this->b_05_head->Raw) {
            $this->b_05_head->CurrentValue = HtmlDecode($this->b_05_head->CurrentValue);
        }
        $this->b_05_head->EditValue = $this->b_05_head->CurrentValue;
        $this->b_05_head->PlaceHolder = RemoveHtml($this->b_05_head->caption());

        // b_06_head
        $this->b_06_head->setupEditAttributes();
        if (!$this->b_06_head->Raw) {
            $this->b_06_head->CurrentValue = HtmlDecode($this->b_06_head->CurrentValue);
        }
        $this->b_06_head->EditValue = $this->b_06_head->CurrentValue;
        $this->b_06_head->PlaceHolder = RemoveHtml($this->b_06_head->caption());

        // b_07_head
        $this->b_07_head->setupEditAttributes();
        if (!$this->b_07_head->Raw) {
            $this->b_07_head->CurrentValue = HtmlDecode($this->b_07_head->CurrentValue);
        }
        $this->b_07_head->EditValue = $this->b_07_head->CurrentValue;
        $this->b_07_head->PlaceHolder = RemoveHtml($this->b_07_head->caption());

        // b_08_head
        $this->b_08_head->setupEditAttributes();
        if (!$this->b_08_head->Raw) {
            $this->b_08_head->CurrentValue = HtmlDecode($this->b_08_head->CurrentValue);
        }
        $this->b_08_head->EditValue = $this->b_08_head->CurrentValue;
        $this->b_08_head->PlaceHolder = RemoveHtml($this->b_08_head->caption());

        // b_09_head
        $this->b_09_head->setupEditAttributes();
        if (!$this->b_09_head->Raw) {
            $this->b_09_head->CurrentValue = HtmlDecode($this->b_09_head->CurrentValue);
        }
        $this->b_09_head->EditValue = $this->b_09_head->CurrentValue;
        $this->b_09_head->PlaceHolder = RemoveHtml($this->b_09_head->caption());

        // b_10_head
        $this->b_10_head->setupEditAttributes();
        if (!$this->b_10_head->Raw) {
            $this->b_10_head->CurrentValue = HtmlDecode($this->b_10_head->CurrentValue);
        }
        $this->b_10_head->EditValue = $this->b_10_head->CurrentValue;
        $this->b_10_head->PlaceHolder = RemoveHtml($this->b_10_head->caption());

        // b_11_head
        $this->b_11_head->setupEditAttributes();
        if (!$this->b_11_head->Raw) {
            $this->b_11_head->CurrentValue = HtmlDecode($this->b_11_head->CurrentValue);
        }
        $this->b_11_head->EditValue = $this->b_11_head->CurrentValue;
        $this->b_11_head->PlaceHolder = RemoveHtml($this->b_11_head->caption());

        // b_12_head
        $this->b_12_head->setupEditAttributes();
        if (!$this->b_12_head->Raw) {
            $this->b_12_head->CurrentValue = HtmlDecode($this->b_12_head->CurrentValue);
        }
        $this->b_12_head->EditValue = $this->b_12_head->CurrentValue;
        $this->b_12_head->PlaceHolder = RemoveHtml($this->b_12_head->caption());

        // b_13_head
        $this->b_13_head->setupEditAttributes();
        if (!$this->b_13_head->Raw) {
            $this->b_13_head->CurrentValue = HtmlDecode($this->b_13_head->CurrentValue);
        }
        $this->b_13_head->EditValue = $this->b_13_head->CurrentValue;
        $this->b_13_head->PlaceHolder = RemoveHtml($this->b_13_head->caption());

        // b_14_head
        $this->b_14_head->setupEditAttributes();
        if (!$this->b_14_head->Raw) {
            $this->b_14_head->CurrentValue = HtmlDecode($this->b_14_head->CurrentValue);
        }
        $this->b_14_head->EditValue = $this->b_14_head->CurrentValue;
        $this->b_14_head->PlaceHolder = RemoveHtml($this->b_14_head->caption());

        // b_15_head
        $this->b_15_head->setupEditAttributes();
        if (!$this->b_15_head->Raw) {
            $this->b_15_head->CurrentValue = HtmlDecode($this->b_15_head->CurrentValue);
        }
        $this->b_15_head->EditValue = $this->b_15_head->CurrentValue;
        $this->b_15_head->PlaceHolder = RemoveHtml($this->b_15_head->caption());

        // q_sku
        $this->q_sku->setupEditAttributes();
        if (!$this->q_sku->Raw) {
            $this->q_sku->CurrentValue = HtmlDecode($this->q_sku->CurrentValue);
        }
        $this->q_sku->EditValue = $this->q_sku->CurrentValue;
        $this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());

        // t_01_head
        $this->t_01_head->setupEditAttributes();
        if (!$this->t_01_head->Raw) {
            $this->t_01_head->CurrentValue = HtmlDecode($this->t_01_head->CurrentValue);
        }
        $this->t_01_head->EditValue = $this->t_01_head->CurrentValue;
        $this->t_01_head->PlaceHolder = RemoveHtml($this->t_01_head->caption());

        // t_02_head
        $this->t_02_head->setupEditAttributes();
        if (!$this->t_02_head->Raw) {
            $this->t_02_head->CurrentValue = HtmlDecode($this->t_02_head->CurrentValue);
        }
        $this->t_02_head->EditValue = $this->t_02_head->CurrentValue;
        $this->t_02_head->PlaceHolder = RemoveHtml($this->t_02_head->caption());

        // t_03_head
        $this->t_03_head->setupEditAttributes();
        if (!$this->t_03_head->Raw) {
            $this->t_03_head->CurrentValue = HtmlDecode($this->t_03_head->CurrentValue);
        }
        $this->t_03_head->EditValue = $this->t_03_head->CurrentValue;
        $this->t_03_head->PlaceHolder = RemoveHtml($this->t_03_head->caption());

        // t_04_head
        $this->t_04_head->setupEditAttributes();
        if (!$this->t_04_head->Raw) {
            $this->t_04_head->CurrentValue = HtmlDecode($this->t_04_head->CurrentValue);
        }
        $this->t_04_head->EditValue = $this->t_04_head->CurrentValue;
        $this->t_04_head->PlaceHolder = RemoveHtml($this->t_04_head->caption());

        // t_05_head
        $this->t_05_head->setupEditAttributes();
        if (!$this->t_05_head->Raw) {
            $this->t_05_head->CurrentValue = HtmlDecode($this->t_05_head->CurrentValue);
        }
        $this->t_05_head->EditValue = $this->t_05_head->CurrentValue;
        $this->t_05_head->PlaceHolder = RemoveHtml($this->t_05_head->caption());

        // t_06_head
        $this->t_06_head->setupEditAttributes();
        if (!$this->t_06_head->Raw) {
            $this->t_06_head->CurrentValue = HtmlDecode($this->t_06_head->CurrentValue);
        }
        $this->t_06_head->EditValue = $this->t_06_head->CurrentValue;
        $this->t_06_head->PlaceHolder = RemoveHtml($this->t_06_head->caption());

        // t_07_head
        $this->t_07_head->setupEditAttributes();
        if (!$this->t_07_head->Raw) {
            $this->t_07_head->CurrentValue = HtmlDecode($this->t_07_head->CurrentValue);
        }
        $this->t_07_head->EditValue = $this->t_07_head->CurrentValue;
        $this->t_07_head->PlaceHolder = RemoveHtml($this->t_07_head->caption());

        // t_08_head
        $this->t_08_head->setupEditAttributes();
        if (!$this->t_08_head->Raw) {
            $this->t_08_head->CurrentValue = HtmlDecode($this->t_08_head->CurrentValue);
        }
        $this->t_08_head->EditValue = $this->t_08_head->CurrentValue;
        $this->t_08_head->PlaceHolder = RemoveHtml($this->t_08_head->caption());

        // t_09_head
        $this->t_09_head->setupEditAttributes();
        if (!$this->t_09_head->Raw) {
            $this->t_09_head->CurrentValue = HtmlDecode($this->t_09_head->CurrentValue);
        }
        $this->t_09_head->EditValue = $this->t_09_head->CurrentValue;
        $this->t_09_head->PlaceHolder = RemoveHtml($this->t_09_head->caption());

        // t_10_head
        $this->t_10_head->setupEditAttributes();
        if (!$this->t_10_head->Raw) {
            $this->t_10_head->CurrentValue = HtmlDecode($this->t_10_head->CurrentValue);
        }
        $this->t_10_head->EditValue = $this->t_10_head->CurrentValue;
        $this->t_10_head->PlaceHolder = RemoveHtml($this->t_10_head->caption());

        // t_11_head
        $this->t_11_head->setupEditAttributes();
        if (!$this->t_11_head->Raw) {
            $this->t_11_head->CurrentValue = HtmlDecode($this->t_11_head->CurrentValue);
        }
        $this->t_11_head->EditValue = $this->t_11_head->CurrentValue;
        $this->t_11_head->PlaceHolder = RemoveHtml($this->t_11_head->caption());

        // t_12_head
        $this->t_12_head->setupEditAttributes();
        if (!$this->t_12_head->Raw) {
            $this->t_12_head->CurrentValue = HtmlDecode($this->t_12_head->CurrentValue);
        }
        $this->t_12_head->EditValue = $this->t_12_head->CurrentValue;
        $this->t_12_head->PlaceHolder = RemoveHtml($this->t_12_head->caption());

        // t_13_head
        $this->t_13_head->setupEditAttributes();
        if (!$this->t_13_head->Raw) {
            $this->t_13_head->CurrentValue = HtmlDecode($this->t_13_head->CurrentValue);
        }
        $this->t_13_head->EditValue = $this->t_13_head->CurrentValue;
        $this->t_13_head->PlaceHolder = RemoveHtml($this->t_13_head->caption());

        // t_14_head
        $this->t_14_head->setupEditAttributes();
        if (!$this->t_14_head->Raw) {
            $this->t_14_head->CurrentValue = HtmlDecode($this->t_14_head->CurrentValue);
        }
        $this->t_14_head->EditValue = $this->t_14_head->CurrentValue;
        $this->t_14_head->PlaceHolder = RemoveHtml($this->t_14_head->caption());

        // t_15_head
        $this->t_15_head->setupEditAttributes();
        if (!$this->t_15_head->Raw) {
            $this->t_15_head->CurrentValue = HtmlDecode($this->t_15_head->CurrentValue);
        }
        $this->t_15_head->EditValue = $this->t_15_head->CurrentValue;
        $this->t_15_head->PlaceHolder = RemoveHtml($this->t_15_head->caption());

        // po_01_head
        $this->po_01_head->setupEditAttributes();
        if (!$this->po_01_head->Raw) {
            $this->po_01_head->CurrentValue = HtmlDecode($this->po_01_head->CurrentValue);
        }
        $this->po_01_head->EditValue = $this->po_01_head->CurrentValue;
        $this->po_01_head->PlaceHolder = RemoveHtml($this->po_01_head->caption());

        // po_02_head
        $this->po_02_head->setupEditAttributes();
        if (!$this->po_02_head->Raw) {
            $this->po_02_head->CurrentValue = HtmlDecode($this->po_02_head->CurrentValue);
        }
        $this->po_02_head->EditValue = $this->po_02_head->CurrentValue;
        $this->po_02_head->PlaceHolder = RemoveHtml($this->po_02_head->caption());

        // po_03_head
        $this->po_03_head->setupEditAttributes();
        if (!$this->po_03_head->Raw) {
            $this->po_03_head->CurrentValue = HtmlDecode($this->po_03_head->CurrentValue);
        }
        $this->po_03_head->EditValue = $this->po_03_head->CurrentValue;
        $this->po_03_head->PlaceHolder = RemoveHtml($this->po_03_head->caption());

        // po_04_head
        $this->po_04_head->setupEditAttributes();
        if (!$this->po_04_head->Raw) {
            $this->po_04_head->CurrentValue = HtmlDecode($this->po_04_head->CurrentValue);
        }
        $this->po_04_head->EditValue = $this->po_04_head->CurrentValue;
        $this->po_04_head->PlaceHolder = RemoveHtml($this->po_04_head->caption());

        // po_05_head
        $this->po_05_head->setupEditAttributes();
        if (!$this->po_05_head->Raw) {
            $this->po_05_head->CurrentValue = HtmlDecode($this->po_05_head->CurrentValue);
        }
        $this->po_05_head->EditValue = $this->po_05_head->CurrentValue;
        $this->po_05_head->PlaceHolder = RemoveHtml($this->po_05_head->caption());

        // po_06_head
        $this->po_06_head->setupEditAttributes();
        if (!$this->po_06_head->Raw) {
            $this->po_06_head->CurrentValue = HtmlDecode($this->po_06_head->CurrentValue);
        }
        $this->po_06_head->EditValue = $this->po_06_head->CurrentValue;
        $this->po_06_head->PlaceHolder = RemoveHtml($this->po_06_head->caption());

        // po_07_head
        $this->po_07_head->setupEditAttributes();
        if (!$this->po_07_head->Raw) {
            $this->po_07_head->CurrentValue = HtmlDecode($this->po_07_head->CurrentValue);
        }
        $this->po_07_head->EditValue = $this->po_07_head->CurrentValue;
        $this->po_07_head->PlaceHolder = RemoveHtml($this->po_07_head->caption());

        // po_08_head
        $this->po_08_head->setupEditAttributes();
        if (!$this->po_08_head->Raw) {
            $this->po_08_head->CurrentValue = HtmlDecode($this->po_08_head->CurrentValue);
        }
        $this->po_08_head->EditValue = $this->po_08_head->CurrentValue;
        $this->po_08_head->PlaceHolder = RemoveHtml($this->po_08_head->caption());

        // po_17_head
        $this->po_17_head->setupEditAttributes();
        if (!$this->po_17_head->Raw) {
            $this->po_17_head->CurrentValue = HtmlDecode($this->po_17_head->CurrentValue);
        }
        $this->po_17_head->EditValue = $this->po_17_head->CurrentValue;
        $this->po_17_head->PlaceHolder = RemoveHtml($this->po_17_head->caption());

        // po_18_head
        $this->po_18_head->setupEditAttributes();
        if (!$this->po_18_head->Raw) {
            $this->po_18_head->CurrentValue = HtmlDecode($this->po_18_head->CurrentValue);
        }
        $this->po_18_head->EditValue = $this->po_18_head->CurrentValue;
        $this->po_18_head->PlaceHolder = RemoveHtml($this->po_18_head->caption());

        // po_19_head
        $this->po_19_head->setupEditAttributes();
        if (!$this->po_19_head->Raw) {
            $this->po_19_head->CurrentValue = HtmlDecode($this->po_19_head->CurrentValue);
        }
        $this->po_19_head->EditValue = $this->po_19_head->CurrentValue;
        $this->po_19_head->PlaceHolder = RemoveHtml($this->po_19_head->caption());

        // po_20_head
        $this->po_20_head->setupEditAttributes();
        if (!$this->po_20_head->Raw) {
            $this->po_20_head->CurrentValue = HtmlDecode($this->po_20_head->CurrentValue);
        }
        $this->po_20_head->EditValue = $this->po_20_head->CurrentValue;
        $this->po_20_head->PlaceHolder = RemoveHtml($this->po_20_head->caption());

        // jc_01_head
        $this->jc_01_head->setupEditAttributes();
        if (!$this->jc_01_head->Raw) {
            $this->jc_01_head->CurrentValue = HtmlDecode($this->jc_01_head->CurrentValue);
        }
        $this->jc_01_head->EditValue = $this->jc_01_head->CurrentValue;
        $this->jc_01_head->PlaceHolder = RemoveHtml($this->jc_01_head->caption());

        // jc_02_head
        $this->jc_02_head->setupEditAttributes();
        if (!$this->jc_02_head->Raw) {
            $this->jc_02_head->CurrentValue = HtmlDecode($this->jc_02_head->CurrentValue);
        }
        $this->jc_02_head->EditValue = $this->jc_02_head->CurrentValue;
        $this->jc_02_head->PlaceHolder = RemoveHtml($this->jc_02_head->caption());

        // jc_03_head
        $this->jc_03_head->setupEditAttributes();
        if (!$this->jc_03_head->Raw) {
            $this->jc_03_head->CurrentValue = HtmlDecode($this->jc_03_head->CurrentValue);
        }
        $this->jc_03_head->EditValue = $this->jc_03_head->CurrentValue;
        $this->jc_03_head->PlaceHolder = RemoveHtml($this->jc_03_head->caption());

        // jc_04_head
        $this->jc_04_head->setupEditAttributes();
        if (!$this->jc_04_head->Raw) {
            $this->jc_04_head->CurrentValue = HtmlDecode($this->jc_04_head->CurrentValue);
        }
        $this->jc_04_head->EditValue = $this->jc_04_head->CurrentValue;
        $this->jc_04_head->PlaceHolder = RemoveHtml($this->jc_04_head->caption());

        // jc_05_head
        $this->jc_05_head->setupEditAttributes();
        if (!$this->jc_05_head->Raw) {
            $this->jc_05_head->CurrentValue = HtmlDecode($this->jc_05_head->CurrentValue);
        }
        $this->jc_05_head->EditValue = $this->jc_05_head->CurrentValue;
        $this->jc_05_head->PlaceHolder = RemoveHtml($this->jc_05_head->caption());

        // jc_06_head
        $this->jc_06_head->setupEditAttributes();
        if (!$this->jc_06_head->Raw) {
            $this->jc_06_head->CurrentValue = HtmlDecode($this->jc_06_head->CurrentValue);
        }
        $this->jc_06_head->EditValue = $this->jc_06_head->CurrentValue;
        $this->jc_06_head->PlaceHolder = RemoveHtml($this->jc_06_head->caption());

        // jc_07_head
        $this->jc_07_head->setupEditAttributes();
        if (!$this->jc_07_head->Raw) {
            $this->jc_07_head->CurrentValue = HtmlDecode($this->jc_07_head->CurrentValue);
        }
        $this->jc_07_head->EditValue = $this->jc_07_head->CurrentValue;
        $this->jc_07_head->PlaceHolder = RemoveHtml($this->jc_07_head->caption());

        // jc_08_head
        $this->jc_08_head->setupEditAttributes();
        if (!$this->jc_08_head->Raw) {
            $this->jc_08_head->CurrentValue = HtmlDecode($this->jc_08_head->CurrentValue);
        }
        $this->jc_08_head->EditValue = $this->jc_08_head->CurrentValue;
        $this->jc_08_head->PlaceHolder = RemoveHtml($this->jc_08_head->caption());

        // jc_09_head
        $this->jc_09_head->setupEditAttributes();
        if (!$this->jc_09_head->Raw) {
            $this->jc_09_head->CurrentValue = HtmlDecode($this->jc_09_head->CurrentValue);
        }
        $this->jc_09_head->EditValue = $this->jc_09_head->CurrentValue;
        $this->jc_09_head->PlaceHolder = RemoveHtml($this->jc_09_head->caption());

        // jc_10_head
        $this->jc_10_head->setupEditAttributes();
        if (!$this->jc_10_head->Raw) {
            $this->jc_10_head->CurrentValue = HtmlDecode($this->jc_10_head->CurrentValue);
        }
        $this->jc_10_head->EditValue = $this->jc_10_head->CurrentValue;
        $this->jc_10_head->PlaceHolder = RemoveHtml($this->jc_10_head->caption());

        // pc_shape
        $this->pc_shape->setupEditAttributes();
        if (!$this->pc_shape->Raw) {
            $this->pc_shape->CurrentValue = HtmlDecode($this->pc_shape->CurrentValue);
        }
        $this->pc_shape->EditValue = $this->pc_shape->CurrentValue;
        $this->pc_shape->PlaceHolder = RemoveHtml($this->pc_shape->caption());

        // pc_unit
        $this->pc_unit->setupEditAttributes();
        if (!$this->pc_unit->Raw) {
            $this->pc_unit->CurrentValue = HtmlDecode($this->pc_unit->CurrentValue);
        }
        $this->pc_unit->EditValue = $this->pc_unit->CurrentValue;
        $this->pc_unit->PlaceHolder = RemoveHtml($this->pc_unit->caption());

        // pc_w
        $this->pc_w->setupEditAttributes();
        if (!$this->pc_w->Raw) {
            $this->pc_w->CurrentValue = HtmlDecode($this->pc_w->CurrentValue);
        }
        $this->pc_w->EditValue = $this->pc_w->CurrentValue;
        $this->pc_w->PlaceHolder = RemoveHtml($this->pc_w->caption());

        // pc_l
        $this->pc_l->setupEditAttributes();
        if (!$this->pc_l->Raw) {
            $this->pc_l->CurrentValue = HtmlDecode($this->pc_l->CurrentValue);
        }
        $this->pc_l->EditValue = $this->pc_l->CurrentValue;
        $this->pc_l->PlaceHolder = RemoveHtml($this->pc_l->caption());

        // pc_h
        $this->pc_h->setupEditAttributes();
        if (!$this->pc_h->Raw) {
            $this->pc_h->CurrentValue = HtmlDecode($this->pc_h->CurrentValue);
        }
        $this->pc_h->EditValue = $this->pc_h->CurrentValue;
        $this->pc_h->PlaceHolder = RemoveHtml($this->pc_h->caption());

        // pc_partner_size
        $this->pc_partner_size->setupEditAttributes();
        if (!$this->pc_partner_size->Raw) {
            $this->pc_partner_size->CurrentValue = HtmlDecode($this->pc_partner_size->CurrentValue);
        }
        $this->pc_partner_size->EditValue = $this->pc_partner_size->CurrentValue;
        $this->pc_partner_size->PlaceHolder = RemoveHtml($this->pc_partner_size->caption());

        // pc_sqm
        $this->pc_sqm->setupEditAttributes();
        if (!$this->pc_sqm->Raw) {
            $this->pc_sqm->CurrentValue = HtmlDecode($this->pc_sqm->CurrentValue);
        }
        $this->pc_sqm->EditValue = $this->pc_sqm->CurrentValue;
        $this->pc_sqm->PlaceHolder = RemoveHtml($this->pc_sqm->caption());

        // pc_01_head
        $this->pc_01_head->setupEditAttributes();
        if (!$this->pc_01_head->Raw) {
            $this->pc_01_head->CurrentValue = HtmlDecode($this->pc_01_head->CurrentValue);
        }
        $this->pc_01_head->EditValue = $this->pc_01_head->CurrentValue;
        $this->pc_01_head->PlaceHolder = RemoveHtml($this->pc_01_head->caption());

        // pc_02_head
        $this->pc_02_head->setupEditAttributes();
        if (!$this->pc_02_head->Raw) {
            $this->pc_02_head->CurrentValue = HtmlDecode($this->pc_02_head->CurrentValue);
        }
        $this->pc_02_head->EditValue = $this->pc_02_head->CurrentValue;
        $this->pc_02_head->PlaceHolder = RemoveHtml($this->pc_02_head->caption());

        // pc_03_head
        $this->pc_03_head->setupEditAttributes();
        if (!$this->pc_03_head->Raw) {
            $this->pc_03_head->CurrentValue = HtmlDecode($this->pc_03_head->CurrentValue);
        }
        $this->pc_03_head->EditValue = $this->pc_03_head->CurrentValue;
        $this->pc_03_head->PlaceHolder = RemoveHtml($this->pc_03_head->caption());

        // pc_04_head
        $this->pc_04_head->setupEditAttributes();
        if (!$this->pc_04_head->Raw) {
            $this->pc_04_head->CurrentValue = HtmlDecode($this->pc_04_head->CurrentValue);
        }
        $this->pc_04_head->EditValue = $this->pc_04_head->CurrentValue;
        $this->pc_04_head->PlaceHolder = RemoveHtml($this->pc_04_head->caption());

        // pc_05_head
        $this->pc_05_head->setupEditAttributes();
        if (!$this->pc_05_head->Raw) {
            $this->pc_05_head->CurrentValue = HtmlDecode($this->pc_05_head->CurrentValue);
        }
        $this->pc_05_head->EditValue = $this->pc_05_head->CurrentValue;
        $this->pc_05_head->PlaceHolder = RemoveHtml($this->pc_05_head->caption());

        // pc_06_head
        $this->pc_06_head->setupEditAttributes();
        if (!$this->pc_06_head->Raw) {
            $this->pc_06_head->CurrentValue = HtmlDecode($this->pc_06_head->CurrentValue);
        }
        $this->pc_06_head->EditValue = $this->pc_06_head->CurrentValue;
        $this->pc_06_head->PlaceHolder = RemoveHtml($this->pc_06_head->caption());

        // pc_07_head
        $this->pc_07_head->setupEditAttributes();
        if (!$this->pc_07_head->Raw) {
            $this->pc_07_head->CurrentValue = HtmlDecode($this->pc_07_head->CurrentValue);
        }
        $this->pc_07_head->EditValue = $this->pc_07_head->CurrentValue;
        $this->pc_07_head->PlaceHolder = RemoveHtml($this->pc_07_head->caption());

        // pc_08_head
        $this->pc_08_head->setupEditAttributes();
        if (!$this->pc_08_head->Raw) {
            $this->pc_08_head->CurrentValue = HtmlDecode($this->pc_08_head->CurrentValue);
        }
        $this->pc_08_head->EditValue = $this->pc_08_head->CurrentValue;
        $this->pc_08_head->PlaceHolder = RemoveHtml($this->pc_08_head->caption());

        // pc_09_head
        $this->pc_09_head->setupEditAttributes();
        if (!$this->pc_09_head->Raw) {
            $this->pc_09_head->CurrentValue = HtmlDecode($this->pc_09_head->CurrentValue);
        }
        $this->pc_09_head->EditValue = $this->pc_09_head->CurrentValue;
        $this->pc_09_head->PlaceHolder = RemoveHtml($this->pc_09_head->caption());

        // pc_10_head
        $this->pc_10_head->setupEditAttributes();
        if (!$this->pc_10_head->Raw) {
            $this->pc_10_head->CurrentValue = HtmlDecode($this->pc_10_head->CurrentValue);
        }
        $this->pc_10_head->EditValue = $this->pc_10_head->CurrentValue;
        $this->pc_10_head->PlaceHolder = RemoveHtml($this->pc_10_head->caption());

        // pc_11_head
        $this->pc_11_head->setupEditAttributes();
        if (!$this->pc_11_head->Raw) {
            $this->pc_11_head->CurrentValue = HtmlDecode($this->pc_11_head->CurrentValue);
        }
        $this->pc_11_head->EditValue = $this->pc_11_head->CurrentValue;
        $this->pc_11_head->PlaceHolder = RemoveHtml($this->pc_11_head->caption());

        // pc_12_head
        $this->pc_12_head->setupEditAttributes();
        if (!$this->pc_12_head->Raw) {
            $this->pc_12_head->CurrentValue = HtmlDecode($this->pc_12_head->CurrentValue);
        }
        $this->pc_12_head->EditValue = $this->pc_12_head->CurrentValue;
        $this->pc_12_head->PlaceHolder = RemoveHtml($this->pc_12_head->caption());

        // operator

        // datetime

        // image
        $this->image->setupEditAttributes();
        $this->image->UploadPath = $this->image->getUploadPath(); // PHP
        if (!EmptyValue($this->image->Upload->DbValue)) {
            $this->image->ImageWidth = 0;
            $this->image->ImageHeight = 50;
            $this->image->ImageAlt = $this->image->alt();
            $this->image->ImageCssClass = "ew-image";
            $this->image->EditValue = $this->image->Upload->DbValue;
        } else {
            $this->image->EditValue = "";
        }
        if (!EmptyValue($this->image->CurrentValue)) {
            $this->image->Upload->FileName = $this->image->CurrentValue;
        }

        // pa_process_size_w
        $this->pa_process_size_w->setupEditAttributes();
        if (!$this->pa_process_size_w->Raw) {
            $this->pa_process_size_w->CurrentValue = HtmlDecode($this->pa_process_size_w->CurrentValue);
        }
        $this->pa_process_size_w->EditValue = $this->pa_process_size_w->CurrentValue;
        $this->pa_process_size_w->PlaceHolder = RemoveHtml($this->pa_process_size_w->caption());

        // pa_process_size_l
        $this->pa_process_size_l->setupEditAttributes();
        if (!$this->pa_process_size_l->Raw) {
            $this->pa_process_size_l->CurrentValue = HtmlDecode($this->pa_process_size_l->CurrentValue);
        }
        $this->pa_process_size_l->EditValue = $this->pa_process_size_l->CurrentValue;
        $this->pa_process_size_l->PlaceHolder = RemoveHtml($this->pa_process_size_l->caption());

        // pa_head_01
        $this->pa_head_01->setupEditAttributes();
        if (!$this->pa_head_01->Raw) {
            $this->pa_head_01->CurrentValue = HtmlDecode($this->pa_head_01->CurrentValue);
        }
        $this->pa_head_01->EditValue = $this->pa_head_01->CurrentValue;
        $this->pa_head_01->PlaceHolder = RemoveHtml($this->pa_head_01->caption());

        // pa_process_01
        $this->pa_process_01->PlaceHolder = RemoveHtml($this->pa_process_01->caption());

        // pa_head_02
        $this->pa_head_02->setupEditAttributes();
        if (!$this->pa_head_02->Raw) {
            $this->pa_head_02->CurrentValue = HtmlDecode($this->pa_head_02->CurrentValue);
        }
        $this->pa_head_02->EditValue = $this->pa_head_02->CurrentValue;
        $this->pa_head_02->PlaceHolder = RemoveHtml($this->pa_head_02->caption());

        // pa_process_02
        $this->pa_process_02->PlaceHolder = RemoveHtml($this->pa_process_02->caption());

        // pa_head_03
        $this->pa_head_03->setupEditAttributes();
        if (!$this->pa_head_03->Raw) {
            $this->pa_head_03->CurrentValue = HtmlDecode($this->pa_head_03->CurrentValue);
        }
        $this->pa_head_03->EditValue = $this->pa_head_03->CurrentValue;
        $this->pa_head_03->PlaceHolder = RemoveHtml($this->pa_head_03->caption());

        // pa_process_03
        $this->pa_process_03->PlaceHolder = RemoveHtml($this->pa_process_03->caption());

        // pa_head_04
        $this->pa_head_04->setupEditAttributes();
        if (!$this->pa_head_04->Raw) {
            $this->pa_head_04->CurrentValue = HtmlDecode($this->pa_head_04->CurrentValue);
        }
        $this->pa_head_04->EditValue = $this->pa_head_04->CurrentValue;
        $this->pa_head_04->PlaceHolder = RemoveHtml($this->pa_head_04->caption());

        // pa_process_04
        $this->pa_process_04->PlaceHolder = RemoveHtml($this->pa_process_04->caption());

        // pa_head_05
        $this->pa_head_05->setupEditAttributes();
        if (!$this->pa_head_05->Raw) {
            $this->pa_head_05->CurrentValue = HtmlDecode($this->pa_head_05->CurrentValue);
        }
        $this->pa_head_05->EditValue = $this->pa_head_05->CurrentValue;
        $this->pa_head_05->PlaceHolder = RemoveHtml($this->pa_head_05->caption());

        // pa_process_05
        $this->pa_process_05->PlaceHolder = RemoveHtml($this->pa_process_05->caption());

        // pa_head_06
        $this->pa_head_06->setupEditAttributes();
        if (!$this->pa_head_06->Raw) {
            $this->pa_head_06->CurrentValue = HtmlDecode($this->pa_head_06->CurrentValue);
        }
        $this->pa_head_06->EditValue = $this->pa_head_06->CurrentValue;
        $this->pa_head_06->PlaceHolder = RemoveHtml($this->pa_head_06->caption());

        // pa_process_06
        $this->pa_process_06->PlaceHolder = RemoveHtml($this->pa_process_06->caption());

        // pa_head_07
        $this->pa_head_07->setupEditAttributes();
        if (!$this->pa_head_07->Raw) {
            $this->pa_head_07->CurrentValue = HtmlDecode($this->pa_head_07->CurrentValue);
        }
        $this->pa_head_07->EditValue = $this->pa_head_07->CurrentValue;
        $this->pa_head_07->PlaceHolder = RemoveHtml($this->pa_head_07->caption());

        // pa_process_07
        $this->pa_process_07->PlaceHolder = RemoveHtml($this->pa_process_07->caption());

        // pa_head_08
        $this->pa_head_08->setupEditAttributes();
        if (!$this->pa_head_08->Raw) {
            $this->pa_head_08->CurrentValue = HtmlDecode($this->pa_head_08->CurrentValue);
        }
        $this->pa_head_08->EditValue = $this->pa_head_08->CurrentValue;
        $this->pa_head_08->PlaceHolder = RemoveHtml($this->pa_head_08->caption());

        // pa_process_08
        $this->pa_process_08->PlaceHolder = RemoveHtml($this->pa_process_08->caption());

        // pa_head_09
        $this->pa_head_09->setupEditAttributes();
        if (!$this->pa_head_09->Raw) {
            $this->pa_head_09->CurrentValue = HtmlDecode($this->pa_head_09->CurrentValue);
        }
        $this->pa_head_09->EditValue = $this->pa_head_09->CurrentValue;
        $this->pa_head_09->PlaceHolder = RemoveHtml($this->pa_head_09->caption());

        // pa_process_09
        $this->pa_process_09->PlaceHolder = RemoveHtml($this->pa_process_09->caption());

        // pa_head_10
        $this->pa_head_10->setupEditAttributes();
        if (!$this->pa_head_10->Raw) {
            $this->pa_head_10->CurrentValue = HtmlDecode($this->pa_head_10->CurrentValue);
        }
        $this->pa_head_10->EditValue = $this->pa_head_10->CurrentValue;
        $this->pa_head_10->PlaceHolder = RemoveHtml($this->pa_head_10->caption());

        // pa_process_10
        $this->pa_process_10->PlaceHolder = RemoveHtml($this->pa_process_10->caption());

        // publish
        $this->publish->setupEditAttributes();
        $this->publish->EditValue = $this->publish->CurrentValue;
        $this->publish->PlaceHolder = RemoveHtml($this->publish->caption());
        if (strval($this->publish->EditValue) != "" && is_numeric($this->publish->EditValue)) {
            $this->publish->EditValue = FormatNumber($this->publish->EditValue, null);
        }

        // ppr_01
        $this->ppr_01->setupEditAttributes();
        if (!$this->ppr_01->Raw) {
            $this->ppr_01->CurrentValue = HtmlDecode($this->ppr_01->CurrentValue);
        }
        $this->ppr_01->EditValue = $this->ppr_01->CurrentValue;
        $this->ppr_01->PlaceHolder = RemoveHtml($this->ppr_01->caption());

        // ppr_02
        $this->ppr_02->setupEditAttributes();
        if (!$this->ppr_02->Raw) {
            $this->ppr_02->CurrentValue = HtmlDecode($this->ppr_02->CurrentValue);
        }
        $this->ppr_02->EditValue = $this->ppr_02->CurrentValue;
        $this->ppr_02->PlaceHolder = RemoveHtml($this->ppr_02->caption());

        // ppr_03
        $this->ppr_03->setupEditAttributes();
        if (!$this->ppr_03->Raw) {
            $this->ppr_03->CurrentValue = HtmlDecode($this->ppr_03->CurrentValue);
        }
        $this->ppr_03->EditValue = $this->ppr_03->CurrentValue;
        $this->ppr_03->PlaceHolder = RemoveHtml($this->ppr_03->caption());

        // ppr_04
        $this->ppr_04->setupEditAttributes();
        if (!$this->ppr_04->Raw) {
            $this->ppr_04->CurrentValue = HtmlDecode($this->ppr_04->CurrentValue);
        }
        $this->ppr_04->EditValue = $this->ppr_04->CurrentValue;
        $this->ppr_04->PlaceHolder = RemoveHtml($this->ppr_04->caption());

        // ppr_05
        $this->ppr_05->setupEditAttributes();
        if (!$this->ppr_05->Raw) {
            $this->ppr_05->CurrentValue = HtmlDecode($this->ppr_05->CurrentValue);
        }
        $this->ppr_05->EditValue = $this->ppr_05->CurrentValue;
        $this->ppr_05->PlaceHolder = RemoveHtml($this->ppr_05->caption());

        // ppr_06
        $this->ppr_06->setupEditAttributes();
        if (!$this->ppr_06->Raw) {
            $this->ppr_06->CurrentValue = HtmlDecode($this->ppr_06->CurrentValue);
        }
        $this->ppr_06->EditValue = $this->ppr_06->CurrentValue;
        $this->ppr_06->PlaceHolder = RemoveHtml($this->ppr_06->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->product_group);
                    $doc->exportCaption($this->calculation_method);
                    $doc->exportCaption($this->shape);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->cbm);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->v_00);
                    $doc->exportCaption($this->v_01);
                    $doc->exportCaption($this->v_01_validation);
                    $doc->exportCaption($this->v_02);
                    $doc->exportCaption($this->v_02_validation);
                    $doc->exportCaption($this->v_03);
                    $doc->exportCaption($this->v_03_validation);
                    $doc->exportCaption($this->v_04);
                    $doc->exportCaption($this->v_04_validation);
                    $doc->exportCaption($this->v_05);
                    $doc->exportCaption($this->v_05_validation);
                    $doc->exportCaption($this->v_06);
                    $doc->exportCaption($this->v_06_validation);
                    $doc->exportCaption($this->v_07);
                    $doc->exportCaption($this->v_07_validation);
                    $doc->exportCaption($this->v_08);
                    $doc->exportCaption($this->v_08_validation);
                    $doc->exportCaption($this->v_09);
                    $doc->exportCaption($this->v_09_validation);
                    $doc->exportCaption($this->v_10);
                    $doc->exportCaption($this->v_10_validation);
                    $doc->exportCaption($this->b_01_head);
                    $doc->exportCaption($this->b_02_head);
                    $doc->exportCaption($this->b_03_head);
                    $doc->exportCaption($this->b_04_head);
                    $doc->exportCaption($this->b_05_head);
                    $doc->exportCaption($this->b_06_head);
                    $doc->exportCaption($this->b_07_head);
                    $doc->exportCaption($this->b_08_head);
                    $doc->exportCaption($this->b_09_head);
                    $doc->exportCaption($this->b_10_head);
                    $doc->exportCaption($this->b_11_head);
                    $doc->exportCaption($this->b_12_head);
                    $doc->exportCaption($this->b_13_head);
                    $doc->exportCaption($this->b_14_head);
                    $doc->exportCaption($this->b_15_head);
                    $doc->exportCaption($this->q_sku);
                    $doc->exportCaption($this->t_01_head);
                    $doc->exportCaption($this->t_02_head);
                    $doc->exportCaption($this->t_03_head);
                    $doc->exportCaption($this->t_04_head);
                    $doc->exportCaption($this->t_05_head);
                    $doc->exportCaption($this->t_06_head);
                    $doc->exportCaption($this->t_07_head);
                    $doc->exportCaption($this->t_08_head);
                    $doc->exportCaption($this->t_09_head);
                    $doc->exportCaption($this->t_10_head);
                    $doc->exportCaption($this->t_11_head);
                    $doc->exportCaption($this->t_12_head);
                    $doc->exportCaption($this->t_13_head);
                    $doc->exportCaption($this->t_14_head);
                    $doc->exportCaption($this->t_15_head);
                    $doc->exportCaption($this->po_01_head);
                    $doc->exportCaption($this->po_02_head);
                    $doc->exportCaption($this->po_03_head);
                    $doc->exportCaption($this->po_04_head);
                    $doc->exportCaption($this->po_05_head);
                    $doc->exportCaption($this->po_06_head);
                    $doc->exportCaption($this->po_07_head);
                    $doc->exportCaption($this->po_08_head);
                    $doc->exportCaption($this->po_17_head);
                    $doc->exportCaption($this->po_18_head);
                    $doc->exportCaption($this->po_19_head);
                    $doc->exportCaption($this->po_20_head);
                    $doc->exportCaption($this->jc_01_head);
                    $doc->exportCaption($this->jc_02_head);
                    $doc->exportCaption($this->jc_03_head);
                    $doc->exportCaption($this->jc_04_head);
                    $doc->exportCaption($this->jc_05_head);
                    $doc->exportCaption($this->jc_06_head);
                    $doc->exportCaption($this->jc_07_head);
                    $doc->exportCaption($this->jc_08_head);
                    $doc->exportCaption($this->jc_09_head);
                    $doc->exportCaption($this->jc_10_head);
                    $doc->exportCaption($this->pc_shape);
                    $doc->exportCaption($this->pc_unit);
                    $doc->exportCaption($this->pc_w);
                    $doc->exportCaption($this->pc_l);
                    $doc->exportCaption($this->pc_h);
                    $doc->exportCaption($this->pc_partner_size);
                    $doc->exportCaption($this->pc_sqm);
                    $doc->exportCaption($this->pc_01_head);
                    $doc->exportCaption($this->pc_02_head);
                    $doc->exportCaption($this->pc_03_head);
                    $doc->exportCaption($this->pc_04_head);
                    $doc->exportCaption($this->pc_05_head);
                    $doc->exportCaption($this->pc_06_head);
                    $doc->exportCaption($this->pc_07_head);
                    $doc->exportCaption($this->pc_08_head);
                    $doc->exportCaption($this->pc_09_head);
                    $doc->exportCaption($this->pc_10_head);
                    $doc->exportCaption($this->pc_11_head);
                    $doc->exportCaption($this->pc_12_head);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->image);
                    $doc->exportCaption($this->pa_process_size_w);
                    $doc->exportCaption($this->pa_process_size_l);
                    $doc->exportCaption($this->pa_head_01);
                    $doc->exportCaption($this->pa_process_01);
                    $doc->exportCaption($this->pa_head_02);
                    $doc->exportCaption($this->pa_process_02);
                    $doc->exportCaption($this->pa_head_03);
                    $doc->exportCaption($this->pa_process_03);
                    $doc->exportCaption($this->pa_head_04);
                    $doc->exportCaption($this->pa_process_04);
                    $doc->exportCaption($this->pa_head_05);
                    $doc->exportCaption($this->pa_process_05);
                    $doc->exportCaption($this->pa_head_06);
                    $doc->exportCaption($this->pa_process_06);
                    $doc->exportCaption($this->pa_head_07);
                    $doc->exportCaption($this->pa_process_07);
                    $doc->exportCaption($this->pa_head_08);
                    $doc->exportCaption($this->pa_process_08);
                    $doc->exportCaption($this->pa_head_09);
                    $doc->exportCaption($this->pa_process_09);
                    $doc->exportCaption($this->pa_head_10);
                    $doc->exportCaption($this->pa_process_10);
                    $doc->exportCaption($this->publish);
                    $doc->exportCaption($this->ppr_01);
                    $doc->exportCaption($this->ppr_02);
                    $doc->exportCaption($this->ppr_03);
                    $doc->exportCaption($this->ppr_04);
                    $doc->exportCaption($this->ppr_05);
                    $doc->exportCaption($this->ppr_06);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->product_group);
                    $doc->exportCaption($this->calculation_method);
                    $doc->exportCaption($this->shape);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->cbm);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->v_00);
                    $doc->exportCaption($this->v_01);
                    $doc->exportCaption($this->v_01_validation);
                    $doc->exportCaption($this->v_02);
                    $doc->exportCaption($this->v_02_validation);
                    $doc->exportCaption($this->v_03);
                    $doc->exportCaption($this->v_03_validation);
                    $doc->exportCaption($this->v_04);
                    $doc->exportCaption($this->v_04_validation);
                    $doc->exportCaption($this->v_05);
                    $doc->exportCaption($this->v_05_validation);
                    $doc->exportCaption($this->v_06);
                    $doc->exportCaption($this->v_06_validation);
                    $doc->exportCaption($this->v_07);
                    $doc->exportCaption($this->v_07_validation);
                    $doc->exportCaption($this->v_08);
                    $doc->exportCaption($this->v_08_validation);
                    $doc->exportCaption($this->v_09);
                    $doc->exportCaption($this->v_09_validation);
                    $doc->exportCaption($this->v_10);
                    $doc->exportCaption($this->v_10_validation);
                    $doc->exportCaption($this->b_01_head);
                    $doc->exportCaption($this->b_02_head);
                    $doc->exportCaption($this->b_03_head);
                    $doc->exportCaption($this->b_04_head);
                    $doc->exportCaption($this->b_05_head);
                    $doc->exportCaption($this->b_06_head);
                    $doc->exportCaption($this->b_07_head);
                    $doc->exportCaption($this->b_08_head);
                    $doc->exportCaption($this->b_09_head);
                    $doc->exportCaption($this->b_10_head);
                    $doc->exportCaption($this->b_11_head);
                    $doc->exportCaption($this->b_12_head);
                    $doc->exportCaption($this->b_13_head);
                    $doc->exportCaption($this->b_14_head);
                    $doc->exportCaption($this->b_15_head);
                    $doc->exportCaption($this->q_sku);
                    $doc->exportCaption($this->t_01_head);
                    $doc->exportCaption($this->t_02_head);
                    $doc->exportCaption($this->t_03_head);
                    $doc->exportCaption($this->t_04_head);
                    $doc->exportCaption($this->t_05_head);
                    $doc->exportCaption($this->t_06_head);
                    $doc->exportCaption($this->t_07_head);
                    $doc->exportCaption($this->t_08_head);
                    $doc->exportCaption($this->t_09_head);
                    $doc->exportCaption($this->t_10_head);
                    $doc->exportCaption($this->t_11_head);
                    $doc->exportCaption($this->t_12_head);
                    $doc->exportCaption($this->t_13_head);
                    $doc->exportCaption($this->t_14_head);
                    $doc->exportCaption($this->t_15_head);
                    $doc->exportCaption($this->po_01_head);
                    $doc->exportCaption($this->po_02_head);
                    $doc->exportCaption($this->po_03_head);
                    $doc->exportCaption($this->po_04_head);
                    $doc->exportCaption($this->po_05_head);
                    $doc->exportCaption($this->po_06_head);
                    $doc->exportCaption($this->po_07_head);
                    $doc->exportCaption($this->po_17_head);
                    $doc->exportCaption($this->po_18_head);
                    $doc->exportCaption($this->po_19_head);
                    $doc->exportCaption($this->po_20_head);
                    $doc->exportCaption($this->jc_01_head);
                    $doc->exportCaption($this->jc_02_head);
                    $doc->exportCaption($this->jc_03_head);
                    $doc->exportCaption($this->jc_04_head);
                    $doc->exportCaption($this->jc_05_head);
                    $doc->exportCaption($this->jc_06_head);
                    $doc->exportCaption($this->jc_07_head);
                    $doc->exportCaption($this->jc_08_head);
                    $doc->exportCaption($this->jc_09_head);
                    $doc->exportCaption($this->jc_10_head);
                    $doc->exportCaption($this->pc_shape);
                    $doc->exportCaption($this->pc_unit);
                    $doc->exportCaption($this->pc_w);
                    $doc->exportCaption($this->pc_l);
                    $doc->exportCaption($this->pc_h);
                    $doc->exportCaption($this->pc_partner_size);
                    $doc->exportCaption($this->pc_sqm);
                    $doc->exportCaption($this->pc_01_head);
                    $doc->exportCaption($this->pc_02_head);
                    $doc->exportCaption($this->pc_03_head);
                    $doc->exportCaption($this->pc_04_head);
                    $doc->exportCaption($this->pc_05_head);
                    $doc->exportCaption($this->pc_06_head);
                    $doc->exportCaption($this->pc_07_head);
                    $doc->exportCaption($this->pc_08_head);
                    $doc->exportCaption($this->pc_09_head);
                    $doc->exportCaption($this->pc_10_head);
                    $doc->exportCaption($this->pc_11_head);
                    $doc->exportCaption($this->pc_12_head);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->image);
                    $doc->exportCaption($this->pa_process_size_w);
                    $doc->exportCaption($this->pa_process_size_l);
                    $doc->exportCaption($this->pa_head_01);
                    $doc->exportCaption($this->pa_process_01);
                    $doc->exportCaption($this->pa_head_02);
                    $doc->exportCaption($this->pa_process_02);
                    $doc->exportCaption($this->pa_head_03);
                    $doc->exportCaption($this->pa_process_03);
                    $doc->exportCaption($this->pa_head_04);
                    $doc->exportCaption($this->pa_process_04);
                    $doc->exportCaption($this->pa_head_05);
                    $doc->exportCaption($this->pa_process_05);
                    $doc->exportCaption($this->pa_head_06);
                    $doc->exportCaption($this->pa_process_06);
                    $doc->exportCaption($this->pa_head_07);
                    $doc->exportCaption($this->pa_process_07);
                    $doc->exportCaption($this->pa_head_08);
                    $doc->exportCaption($this->pa_process_08);
                    $doc->exportCaption($this->pa_head_09);
                    $doc->exportCaption($this->pa_process_09);
                    $doc->exportCaption($this->pa_head_10);
                    $doc->exportCaption($this->pa_process_10);
                    $doc->exportCaption($this->publish);
                    $doc->exportCaption($this->ppr_01);
                    $doc->exportCaption($this->ppr_02);
                    $doc->exportCaption($this->ppr_03);
                    $doc->exportCaption($this->ppr_04);
                    $doc->exportCaption($this->ppr_05);
                    $doc->exportCaption($this->ppr_06);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->product_group);
                        $doc->exportField($this->calculation_method);
                        $doc->exportField($this->shape);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->cbm);
                        $doc->exportField($this->process);
                        $doc->exportField($this->status);
                        $doc->exportField($this->v_00);
                        $doc->exportField($this->v_01);
                        $doc->exportField($this->v_01_validation);
                        $doc->exportField($this->v_02);
                        $doc->exportField($this->v_02_validation);
                        $doc->exportField($this->v_03);
                        $doc->exportField($this->v_03_validation);
                        $doc->exportField($this->v_04);
                        $doc->exportField($this->v_04_validation);
                        $doc->exportField($this->v_05);
                        $doc->exportField($this->v_05_validation);
                        $doc->exportField($this->v_06);
                        $doc->exportField($this->v_06_validation);
                        $doc->exportField($this->v_07);
                        $doc->exportField($this->v_07_validation);
                        $doc->exportField($this->v_08);
                        $doc->exportField($this->v_08_validation);
                        $doc->exportField($this->v_09);
                        $doc->exportField($this->v_09_validation);
                        $doc->exportField($this->v_10);
                        $doc->exportField($this->v_10_validation);
                        $doc->exportField($this->b_01_head);
                        $doc->exportField($this->b_02_head);
                        $doc->exportField($this->b_03_head);
                        $doc->exportField($this->b_04_head);
                        $doc->exportField($this->b_05_head);
                        $doc->exportField($this->b_06_head);
                        $doc->exportField($this->b_07_head);
                        $doc->exportField($this->b_08_head);
                        $doc->exportField($this->b_09_head);
                        $doc->exportField($this->b_10_head);
                        $doc->exportField($this->b_11_head);
                        $doc->exportField($this->b_12_head);
                        $doc->exportField($this->b_13_head);
                        $doc->exportField($this->b_14_head);
                        $doc->exportField($this->b_15_head);
                        $doc->exportField($this->q_sku);
                        $doc->exportField($this->t_01_head);
                        $doc->exportField($this->t_02_head);
                        $doc->exportField($this->t_03_head);
                        $doc->exportField($this->t_04_head);
                        $doc->exportField($this->t_05_head);
                        $doc->exportField($this->t_06_head);
                        $doc->exportField($this->t_07_head);
                        $doc->exportField($this->t_08_head);
                        $doc->exportField($this->t_09_head);
                        $doc->exportField($this->t_10_head);
                        $doc->exportField($this->t_11_head);
                        $doc->exportField($this->t_12_head);
                        $doc->exportField($this->t_13_head);
                        $doc->exportField($this->t_14_head);
                        $doc->exportField($this->t_15_head);
                        $doc->exportField($this->po_01_head);
                        $doc->exportField($this->po_02_head);
                        $doc->exportField($this->po_03_head);
                        $doc->exportField($this->po_04_head);
                        $doc->exportField($this->po_05_head);
                        $doc->exportField($this->po_06_head);
                        $doc->exportField($this->po_07_head);
                        $doc->exportField($this->po_08_head);
                        $doc->exportField($this->po_17_head);
                        $doc->exportField($this->po_18_head);
                        $doc->exportField($this->po_19_head);
                        $doc->exportField($this->po_20_head);
                        $doc->exportField($this->jc_01_head);
                        $doc->exportField($this->jc_02_head);
                        $doc->exportField($this->jc_03_head);
                        $doc->exportField($this->jc_04_head);
                        $doc->exportField($this->jc_05_head);
                        $doc->exportField($this->jc_06_head);
                        $doc->exportField($this->jc_07_head);
                        $doc->exportField($this->jc_08_head);
                        $doc->exportField($this->jc_09_head);
                        $doc->exportField($this->jc_10_head);
                        $doc->exportField($this->pc_shape);
                        $doc->exportField($this->pc_unit);
                        $doc->exportField($this->pc_w);
                        $doc->exportField($this->pc_l);
                        $doc->exportField($this->pc_h);
                        $doc->exportField($this->pc_partner_size);
                        $doc->exportField($this->pc_sqm);
                        $doc->exportField($this->pc_01_head);
                        $doc->exportField($this->pc_02_head);
                        $doc->exportField($this->pc_03_head);
                        $doc->exportField($this->pc_04_head);
                        $doc->exportField($this->pc_05_head);
                        $doc->exportField($this->pc_06_head);
                        $doc->exportField($this->pc_07_head);
                        $doc->exportField($this->pc_08_head);
                        $doc->exportField($this->pc_09_head);
                        $doc->exportField($this->pc_10_head);
                        $doc->exportField($this->pc_11_head);
                        $doc->exportField($this->pc_12_head);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->image);
                        $doc->exportField($this->pa_process_size_w);
                        $doc->exportField($this->pa_process_size_l);
                        $doc->exportField($this->pa_head_01);
                        $doc->exportField($this->pa_process_01);
                        $doc->exportField($this->pa_head_02);
                        $doc->exportField($this->pa_process_02);
                        $doc->exportField($this->pa_head_03);
                        $doc->exportField($this->pa_process_03);
                        $doc->exportField($this->pa_head_04);
                        $doc->exportField($this->pa_process_04);
                        $doc->exportField($this->pa_head_05);
                        $doc->exportField($this->pa_process_05);
                        $doc->exportField($this->pa_head_06);
                        $doc->exportField($this->pa_process_06);
                        $doc->exportField($this->pa_head_07);
                        $doc->exportField($this->pa_process_07);
                        $doc->exportField($this->pa_head_08);
                        $doc->exportField($this->pa_process_08);
                        $doc->exportField($this->pa_head_09);
                        $doc->exportField($this->pa_process_09);
                        $doc->exportField($this->pa_head_10);
                        $doc->exportField($this->pa_process_10);
                        $doc->exportField($this->publish);
                        $doc->exportField($this->ppr_01);
                        $doc->exportField($this->ppr_02);
                        $doc->exportField($this->ppr_03);
                        $doc->exportField($this->ppr_04);
                        $doc->exportField($this->ppr_05);
                        $doc->exportField($this->ppr_06);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->product_group);
                        $doc->exportField($this->calculation_method);
                        $doc->exportField($this->shape);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->cbm);
                        $doc->exportField($this->process);
                        $doc->exportField($this->status);
                        $doc->exportField($this->v_00);
                        $doc->exportField($this->v_01);
                        $doc->exportField($this->v_01_validation);
                        $doc->exportField($this->v_02);
                        $doc->exportField($this->v_02_validation);
                        $doc->exportField($this->v_03);
                        $doc->exportField($this->v_03_validation);
                        $doc->exportField($this->v_04);
                        $doc->exportField($this->v_04_validation);
                        $doc->exportField($this->v_05);
                        $doc->exportField($this->v_05_validation);
                        $doc->exportField($this->v_06);
                        $doc->exportField($this->v_06_validation);
                        $doc->exportField($this->v_07);
                        $doc->exportField($this->v_07_validation);
                        $doc->exportField($this->v_08);
                        $doc->exportField($this->v_08_validation);
                        $doc->exportField($this->v_09);
                        $doc->exportField($this->v_09_validation);
                        $doc->exportField($this->v_10);
                        $doc->exportField($this->v_10_validation);
                        $doc->exportField($this->b_01_head);
                        $doc->exportField($this->b_02_head);
                        $doc->exportField($this->b_03_head);
                        $doc->exportField($this->b_04_head);
                        $doc->exportField($this->b_05_head);
                        $doc->exportField($this->b_06_head);
                        $doc->exportField($this->b_07_head);
                        $doc->exportField($this->b_08_head);
                        $doc->exportField($this->b_09_head);
                        $doc->exportField($this->b_10_head);
                        $doc->exportField($this->b_11_head);
                        $doc->exportField($this->b_12_head);
                        $doc->exportField($this->b_13_head);
                        $doc->exportField($this->b_14_head);
                        $doc->exportField($this->b_15_head);
                        $doc->exportField($this->q_sku);
                        $doc->exportField($this->t_01_head);
                        $doc->exportField($this->t_02_head);
                        $doc->exportField($this->t_03_head);
                        $doc->exportField($this->t_04_head);
                        $doc->exportField($this->t_05_head);
                        $doc->exportField($this->t_06_head);
                        $doc->exportField($this->t_07_head);
                        $doc->exportField($this->t_08_head);
                        $doc->exportField($this->t_09_head);
                        $doc->exportField($this->t_10_head);
                        $doc->exportField($this->t_11_head);
                        $doc->exportField($this->t_12_head);
                        $doc->exportField($this->t_13_head);
                        $doc->exportField($this->t_14_head);
                        $doc->exportField($this->t_15_head);
                        $doc->exportField($this->po_01_head);
                        $doc->exportField($this->po_02_head);
                        $doc->exportField($this->po_03_head);
                        $doc->exportField($this->po_04_head);
                        $doc->exportField($this->po_05_head);
                        $doc->exportField($this->po_06_head);
                        $doc->exportField($this->po_07_head);
                        $doc->exportField($this->po_17_head);
                        $doc->exportField($this->po_18_head);
                        $doc->exportField($this->po_19_head);
                        $doc->exportField($this->po_20_head);
                        $doc->exportField($this->jc_01_head);
                        $doc->exportField($this->jc_02_head);
                        $doc->exportField($this->jc_03_head);
                        $doc->exportField($this->jc_04_head);
                        $doc->exportField($this->jc_05_head);
                        $doc->exportField($this->jc_06_head);
                        $doc->exportField($this->jc_07_head);
                        $doc->exportField($this->jc_08_head);
                        $doc->exportField($this->jc_09_head);
                        $doc->exportField($this->jc_10_head);
                        $doc->exportField($this->pc_shape);
                        $doc->exportField($this->pc_unit);
                        $doc->exportField($this->pc_w);
                        $doc->exportField($this->pc_l);
                        $doc->exportField($this->pc_h);
                        $doc->exportField($this->pc_partner_size);
                        $doc->exportField($this->pc_sqm);
                        $doc->exportField($this->pc_01_head);
                        $doc->exportField($this->pc_02_head);
                        $doc->exportField($this->pc_03_head);
                        $doc->exportField($this->pc_04_head);
                        $doc->exportField($this->pc_05_head);
                        $doc->exportField($this->pc_06_head);
                        $doc->exportField($this->pc_07_head);
                        $doc->exportField($this->pc_08_head);
                        $doc->exportField($this->pc_09_head);
                        $doc->exportField($this->pc_10_head);
                        $doc->exportField($this->pc_11_head);
                        $doc->exportField($this->pc_12_head);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->image);
                        $doc->exportField($this->pa_process_size_w);
                        $doc->exportField($this->pa_process_size_l);
                        $doc->exportField($this->pa_head_01);
                        $doc->exportField($this->pa_process_01);
                        $doc->exportField($this->pa_head_02);
                        $doc->exportField($this->pa_process_02);
                        $doc->exportField($this->pa_head_03);
                        $doc->exportField($this->pa_process_03);
                        $doc->exportField($this->pa_head_04);
                        $doc->exportField($this->pa_process_04);
                        $doc->exportField($this->pa_head_05);
                        $doc->exportField($this->pa_process_05);
                        $doc->exportField($this->pa_head_06);
                        $doc->exportField($this->pa_process_06);
                        $doc->exportField($this->pa_head_07);
                        $doc->exportField($this->pa_process_07);
                        $doc->exportField($this->pa_head_08);
                        $doc->exportField($this->pa_process_08);
                        $doc->exportField($this->pa_head_09);
                        $doc->exportField($this->pa_process_09);
                        $doc->exportField($this->pa_head_10);
                        $doc->exportField($this->pa_process_10);
                        $doc->exportField($this->publish);
                        $doc->exportField($this->ppr_01);
                        $doc->exportField($this->ppr_02);
                        $doc->exportField($this->ppr_03);
                        $doc->exportField($this->ppr_04);
                        $doc->exportField($this->ppr_05);
                        $doc->exportField($this->ppr_06);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'image') {
            $fldName = "image";
            $fileNameFld = "image";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->id->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
