<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductCartSUpdate extends ProductCartS
{
    use MessagesTrait;

    // Page ID
    public $PageID = "update";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductCartSUpdate";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "productcartsupdate";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->location->Visible = false;
        $this->company_id->Visible = false;
        $this->partner_id->setVisibility();
        $this->partner_rid->Visible = false;
        $this->product_type->Visible = false;
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->product->Visible = false;
        $this->rid->Visible = false;
        $this->packing_type->Visible = false;
        $this->batch_no->Visible = false;
        $this->shape->Visible = false;
        $this->unit->Visible = false;
        $this->w->Visible = false;
        $this->w_cm->Visible = false;
        $this->l->Visible = false;
        $this->l_cm->Visible = false;
        $this->h->Visible = false;
        $this->h_cm->Visible = false;
        $this->partner_size->Visible = false;
        $this->size->Visible = false;
        $this->sqm->Visible = false;
        $this->quantity->Visible = false;
        $this->price->Visible = false;
        $this->currency->Visible = false;
        $this->amount->Visible = false;
        $this->status->Visible = false;
        $this->cart_id->Visible = false;
        $this->po_id->Visible = false;
        $this->rid_1->Visible = false;
        $this->hsn_code->Visible = false;
        $this->despatch_date->Visible = false;
        $this->pkt_quantity->Visible = false;
        $this->multiprice_id->Visible = false;
        $this->discount_price->Visible = false;
        $this->cbm->Visible = false;
        $this->tax->Visible = false;
        $this->tax_amount->Visible = false;
        $this->shipping_method->Visible = false;
        $this->shipping_local->Visible = false;
        $this->shipping_abroad->Visible = false;
        $this->shipping_charge->Visible = false;
        $this->additional_discount->Visible = false;
        $this->total_amount->Visible = false;
        $this->buyer_uid->Visible = false;
        $this->label->Visible = false;
        $this->remarks->Visible = false;
        $this->p_remarks->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->o_datetime->Visible = false;
        $this->cart_amount->Visible = false;
        $this->c_total->Visible = false;
        $this->_1->Visible = false;
        $this->_2->Visible = false;
        $this->_3->Visible = false;
        $this->_4->Visible = false;
        $this->_5->Visible = false;
        $this->_6->Visible = false;
        $this->_7->Visible = false;
        $this->_8->Visible = false;
        $this->image->Visible = false;
        $this->r_text->Visible = false;
        $this->t_id->Visible = false;
        $this->_9->Visible = false;
        $this->_10->Visible = false;
        $this->_11->Visible = false;
        $this->_12->Visible = false;
        $this->sqm_u->Visible = false;
        $this->reports_to->Visible = false;
        $this->buyer_loc->Visible = false;
        $this->p_id->Visible = false;
        $this->partner_code->Visible = false;
        $this->q_sku->Visible = false;
        $this->partner_order_no->Visible = false;
        $this->p_qty->Visible = false;
        $this->product_code->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'product_cart_s';
        $this->TableName = 'product_cart_s';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-update-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (product_cart_s)
        if (!isset($GLOBALS["product_cart_s"]) || $GLOBALS["product_cart_s"]::class == PROJECT_NAMESPACE . "product_cart_s") {
            $GLOBALS["product_cart_s"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_cart_s');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "productcartsview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-update-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $RecKeys;
    public $Disabled;
    public $UpdateCount = 0;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->partner_rid);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->po_id);
        $this->setupLookupOptions($this->operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Try to load keys from list form
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        if (Post("action") !== null && Post("action") !== "") {
            // Get action
            $this->CurrentAction = Post("action");
            $this->loadFormValues(); // Get form values

            // Validate form
            if (!$this->validateForm()) {
                $this->CurrentAction = "show"; // Form error, reset action
                if (!$this->hasInvalidFields()) { // No fields selected
                    $this->setFailureMessage($Language->phrase("NoFieldSelected"));
                }
            }
        } else {
            $this->loadMultiUpdateValues(); // Load initial values to form
        }
        if (count($this->RecKeys) <= 0) {
            $this->terminate("productcartslist"); // No records selected, return to list
            return;
        }
        if ($this->isUpdate()) {
                if ($this->updateRows()) { // Update Records based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up update success message
                    }

                    // Do not return Json for UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                    }
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([
                        "success" => false,
                        "validation" => $this->getValidationErrors(),
                        "error" => $this->getFailureMessage()
                    ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->restoreFormValues(); // Restore form values
                }
        }

        // Render row
        if ($this->isConfirm()) { // Confirm page
            $this->RowType = RowType::VIEW; // Render view
            $this->Disabled = " disabled";
        } else {
            $this->RowType = RowType::EDIT; // Render edit
            $this->Disabled = "";
        }
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Load initial values to form if field values are identical in all selected records
    protected function loadMultiUpdateValues()
    {
        $this->CurrentFilter = $this->getFilterFromRecordKeys();

        // Load result set
        if ($rs = $this->loadRecordset()) {
            $i = 1;
            while ($row = $rs->fetch()) {
                if ($i == 1) {
                    $this->partner_id->setDbValue($row['partner_id']);
                    $this->p_remarks->setDbValue($row['p_remarks']);
                } else {
                    if (!CompareValue($this->partner_id->DbValue, $row['partner_id'])) {
                        $this->partner_id->CurrentValue = null;
                    }
                    if (!CompareValue($this->p_remarks->DbValue, $row['p_remarks'])) {
                        $this->p_remarks->CurrentValue = null;
                    }
                }
                $i++;
            }
            $rs->free();
        }
    }

    // Set up key value
    protected function setupKeyValues($key)
    {
        $keyFld = $key;
        if (!is_numeric($keyFld)) {
            return false;
        }
        $this->id->OldValue = $keyFld;
        return true;
    }

    // Update all selected rows
    protected function updateRows()
    {
        global $Language;
        $conn = $this->getConnection();
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }
        if ($this->AuditTrailOnEdit) {
            $this->writeAuditTrailDummy($Language->phrase("BatchUpdateBegin")); // Batch update begin
        }

        // Get old records
        $this->CurrentFilter = $this->getFilterFromRecordKeys(false);
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAllAssociative($sql);

        // Update all rows
        $successKeys = [];
        $failKeys = [];
        foreach ($this->RecKeys as $reckey) {
            if ($this->setupKeyValues($reckey)) {
                $thisKey = $reckey;
                $this->SendEmail = false; // Do not send email on update success
                $this->UpdateCount += 1; // Update record count for records being updated
                $rowUpdated = $this->editRow(); // Update this row
            } else {
                $rowUpdated = false;
            }
            if (!$rowUpdated) {
                if ($this->UseTransaction) { // Update failed
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                $successKeys[] = $thisKey;
            }
        }

        // Check if any rows updated
        if (count($successKeys) > 0) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if update some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("UpdateSomeRecordsFailed")));
            }

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateSuccess")); // Batch update success
            }
            return true;
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateRollback")); // Batch update rollback
            }
            return false;
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'partner_id' first before field var 'x_partner_id'
        $val = $CurrentForm->hasValue("partner_id") ? $CurrentForm->getValue("partner_id") : $CurrentForm->getValue("x_partner_id");
        if (!$this->partner_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_id->Visible = false; // Disable update for API request
            } else {
                $this->partner_id->setFormValue($val);
            }
        }
        $this->partner_id->MultiUpdate = $CurrentForm->getValue("u_partner_id");

        // Check field name 'p_remarks' first before field var 'x_p_remarks'
        $val = $CurrentForm->hasValue("p_remarks") ? $CurrentForm->getValue("p_remarks") : $CurrentForm->getValue("x_p_remarks");
        if (!$this->p_remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->p_remarks->Visible = false; // Disable update for API request
            } else {
                $this->p_remarks->setFormValue($val);
            }
        }
        $this->p_remarks->MultiUpdate = $CurrentForm->getValue("u_p_remarks");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->partner_id->CurrentValue = $this->partner_id->FormValue;
        $this->p_remarks->CurrentValue = $this->p_remarks->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->location->setDbValue($row['location']);
        $this->company_id->setDbValue($row['company_id']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->partner_rid->setDbValue($row['partner_rid']);
        $this->product_type->setDbValue($row['product_type']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->shape->setDbValue($row['shape']);
        $this->unit->setDbValue($row['unit']);
        $this->w->setDbValue($row['w']);
        $this->w_cm->setDbValue($row['w_cm']);
        $this->l->setDbValue($row['l']);
        $this->l_cm->setDbValue($row['l_cm']);
        $this->h->setDbValue($row['h']);
        $this->h_cm->setDbValue($row['h_cm']);
        $this->partner_size->setDbValue($row['partner_size']);
        $this->size->setDbValue($row['size']);
        $this->sqm->setDbValue($row['sqm']);
        $this->quantity->setDbValue($row['quantity']);
        $this->price->setDbValue($row['price']);
        $this->currency->setDbValue($row['currency']);
        $this->amount->setDbValue($row['amount']);
        $this->status->setDbValue($row['status']);
        $this->cart_id->setDbValue($row['cart_id']);
        $this->po_id->setDbValue($row['po_id']);
        $this->rid_1->setDbValue($row['rid_1']);
        $this->hsn_code->setDbValue($row['hsn_code']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->pkt_quantity->setDbValue($row['pkt_quantity']);
        $this->multiprice_id->setDbValue($row['multiprice_id']);
        $this->discount_price->setDbValue($row['discount_price']);
        $this->cbm->setDbValue($row['cbm']);
        $this->tax->setDbValue($row['tax']);
        $this->tax_amount->setDbValue($row['tax_amount']);
        $this->shipping_method->setDbValue($row['shipping_method']);
        $this->shipping_local->setDbValue($row['shipping_local']);
        $this->shipping_abroad->setDbValue($row['shipping_abroad']);
        $this->shipping_charge->setDbValue($row['shipping_charge']);
        $this->additional_discount->setDbValue($row['additional_discount']);
        $this->total_amount->setDbValue($row['total_amount']);
        $this->buyer_uid->setDbValue($row['buyer_uid']);
        $this->label->setDbValue($row['label']);
        $this->remarks->setDbValue($row['remarks']);
        $this->p_remarks->setDbValue($row['p_remarks']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->o_datetime->setDbValue($row['o_datetime']);
        $this->cart_amount->setDbValue($row['cart_amount']);
        $this->c_total->setDbValue($row['c_total']);
        $this->_1->setDbValue($row['1']);
        $this->_2->setDbValue($row['2']);
        $this->_3->setDbValue($row['3']);
        $this->_4->setDbValue($row['4']);
        $this->_5->setDbValue($row['5']);
        $this->_6->setDbValue($row['6']);
        $this->_7->setDbValue($row['7']);
        $this->_8->setDbValue($row['8']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->r_text->setDbValue($row['r_text']);
        $this->t_id->setDbValue($row['t_id']);
        $this->_9->setDbValue($row['9']);
        $this->_10->setDbValue($row['10']);
        $this->_11->setDbValue($row['11']);
        $this->_12->setDbValue($row['12']);
        $this->sqm_u->setDbValue($row['sqm_u']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->buyer_loc->setDbValue($row['buyer_loc']);
        $this->p_id->setDbValue($row['p_id']);
        $this->partner_code->setDbValue($row['partner_code']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->partner_order_no->setDbValue($row['partner_order_no']);
        $this->p_qty->setDbValue($row['p_qty']);
        $this->product_code->setDbValue($row['product_code']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['partner_rid'] = $this->partner_rid->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['w'] = $this->w->DefaultValue;
        $row['w_cm'] = $this->w_cm->DefaultValue;
        $row['l'] = $this->l->DefaultValue;
        $row['l_cm'] = $this->l_cm->DefaultValue;
        $row['h'] = $this->h->DefaultValue;
        $row['h_cm'] = $this->h_cm->DefaultValue;
        $row['partner_size'] = $this->partner_size->DefaultValue;
        $row['size'] = $this->size->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['cart_id'] = $this->cart_id->DefaultValue;
        $row['po_id'] = $this->po_id->DefaultValue;
        $row['rid_1'] = $this->rid_1->DefaultValue;
        $row['hsn_code'] = $this->hsn_code->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['pkt_quantity'] = $this->pkt_quantity->DefaultValue;
        $row['multiprice_id'] = $this->multiprice_id->DefaultValue;
        $row['discount_price'] = $this->discount_price->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['tax'] = $this->tax->DefaultValue;
        $row['tax_amount'] = $this->tax_amount->DefaultValue;
        $row['shipping_method'] = $this->shipping_method->DefaultValue;
        $row['shipping_local'] = $this->shipping_local->DefaultValue;
        $row['shipping_abroad'] = $this->shipping_abroad->DefaultValue;
        $row['shipping_charge'] = $this->shipping_charge->DefaultValue;
        $row['additional_discount'] = $this->additional_discount->DefaultValue;
        $row['total_amount'] = $this->total_amount->DefaultValue;
        $row['buyer_uid'] = $this->buyer_uid->DefaultValue;
        $row['label'] = $this->label->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['p_remarks'] = $this->p_remarks->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['o_datetime'] = $this->o_datetime->DefaultValue;
        $row['cart_amount'] = $this->cart_amount->DefaultValue;
        $row['c_total'] = $this->c_total->DefaultValue;
        $row['1'] = $this->_1->DefaultValue;
        $row['2'] = $this->_2->DefaultValue;
        $row['3'] = $this->_3->DefaultValue;
        $row['4'] = $this->_4->DefaultValue;
        $row['5'] = $this->_5->DefaultValue;
        $row['6'] = $this->_6->DefaultValue;
        $row['7'] = $this->_7->DefaultValue;
        $row['8'] = $this->_8->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['r_text'] = $this->r_text->DefaultValue;
        $row['t_id'] = $this->t_id->DefaultValue;
        $row['9'] = $this->_9->DefaultValue;
        $row['10'] = $this->_10->DefaultValue;
        $row['11'] = $this->_11->DefaultValue;
        $row['12'] = $this->_12->DefaultValue;
        $row['sqm_u'] = $this->sqm_u->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['buyer_loc'] = $this->buyer_loc->DefaultValue;
        $row['p_id'] = $this->p_id->DefaultValue;
        $row['partner_code'] = $this->partner_code->DefaultValue;
        $row['q_sku'] = $this->q_sku->DefaultValue;
        $row['partner_order_no'] = $this->partner_order_no->DefaultValue;
        $row['p_qty'] = $this->p_qty->DefaultValue;
        $row['product_code'] = $this->product_code->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // partner_id
        $this->partner_id->RowCssClass = "row";

        // partner_rid
        $this->partner_rid->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // unit
        $this->unit->RowCssClass = "row";

        // w
        $this->w->RowCssClass = "row";

        // w_cm
        $this->w_cm->RowCssClass = "row";

        // l
        $this->l->RowCssClass = "row";

        // l_cm
        $this->l_cm->RowCssClass = "row";

        // h
        $this->h->RowCssClass = "row";

        // h_cm
        $this->h_cm->RowCssClass = "row";

        // partner_size
        $this->partner_size->RowCssClass = "row";

        // size
        $this->size->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // price
        $this->price->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // cart_id
        $this->cart_id->RowCssClass = "row";

        // po_id
        $this->po_id->RowCssClass = "row";

        // rid_1
        $this->rid_1->RowCssClass = "row";

        // hsn_code
        $this->hsn_code->RowCssClass = "row";

        // despatch_date
        $this->despatch_date->RowCssClass = "row";

        // pkt_quantity
        $this->pkt_quantity->RowCssClass = "row";

        // multiprice_id
        $this->multiprice_id->RowCssClass = "row";

        // discount_price
        $this->discount_price->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // tax
        $this->tax->RowCssClass = "row";

        // tax_amount
        $this->tax_amount->RowCssClass = "row";

        // shipping_method
        $this->shipping_method->RowCssClass = "row";

        // shipping_local
        $this->shipping_local->RowCssClass = "row";

        // shipping_abroad
        $this->shipping_abroad->RowCssClass = "row";

        // shipping_charge
        $this->shipping_charge->RowCssClass = "row";

        // additional_discount
        $this->additional_discount->RowCssClass = "row";

        // total_amount
        $this->total_amount->RowCssClass = "row";

        // buyer_uid
        $this->buyer_uid->RowCssClass = "row";

        // label
        $this->label->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // p_remarks
        $this->p_remarks->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // o_datetime
        $this->o_datetime->RowCssClass = "row";

        // cart_amount
        $this->cart_amount->RowCssClass = "row";

        // c_total
        $this->c_total->RowCssClass = "row";

        // 1
        $this->_1->RowCssClass = "row";

        // 2
        $this->_2->RowCssClass = "row";

        // 3
        $this->_3->RowCssClass = "row";

        // 4
        $this->_4->RowCssClass = "row";

        // 5
        $this->_5->RowCssClass = "row";

        // 6
        $this->_6->RowCssClass = "row";

        // 7
        $this->_7->RowCssClass = "row";

        // 8
        $this->_8->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // r_text
        $this->r_text->RowCssClass = "row";

        // t_id
        $this->t_id->RowCssClass = "row";

        // 9
        $this->_9->RowCssClass = "row";

        // 10
        $this->_10->RowCssClass = "row";

        // 11
        $this->_11->RowCssClass = "row";

        // 12
        $this->_12->RowCssClass = "row";

        // sqm_u
        $this->sqm_u->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // buyer_loc
        $this->buyer_loc->RowCssClass = "row";

        // p_id
        $this->p_id->RowCssClass = "row";

        // partner_code
        $this->partner_code->RowCssClass = "row";

        // q_sku
        $this->q_sku->RowCssClass = "row";

        // partner_order_no
        $this->partner_order_no->RowCssClass = "row";

        // p_qty
        $this->p_qty->RowCssClass = "row";

        // product_code
        $this->product_code->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                        $this->location->ViewValue = $this->location->displayValue($arwrk);
                    } else {
                        $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // partner_rid
            $this->partner_rid->ViewValue = $this->partner_rid->CurrentValue;
            $curVal = strval($this->partner_rid->CurrentValue);
            if ($curVal != "") {
                $this->partner_rid->ViewValue = $this->partner_rid->lookupCacheOption($curVal);
                if ($this->partner_rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_rid->ViewValue = $this->partner_rid->displayValue($arwrk);
                    } else {
                        $this->partner_rid->ViewValue = $this->partner_rid->CurrentValue;
                    }
                }
            } else {
                $this->partner_rid->ViewValue = null;
            }

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                        $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                    } else {
                        $this->product_type->ViewValue = FormatNumber($this->product_type->CurrentValue, $this->product_type->formatPattern());
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // grp
            $this->grp->ViewValue = $this->grp->CurrentValue;
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // batch_no
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                        $this->shape->ViewValue = $this->shape->displayValue($arwrk);
                    } else {
                        $this->shape->ViewValue = FormatNumber($this->shape->CurrentValue, $this->shape->formatPattern());
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // unit
            $curVal = strval($this->unit->CurrentValue);
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
                if ($this->unit->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                        $this->unit->ViewValue = $this->unit->displayValue($arwrk);
                    } else {
                        $this->unit->ViewValue = FormatNumber($this->unit->CurrentValue, $this->unit->formatPattern());
                    }
                }
            } else {
                $this->unit->ViewValue = null;
            }

            // w
            $this->w->ViewValue = $this->w->CurrentValue;

            // w_cm
            $this->w_cm->ViewValue = $this->w_cm->CurrentValue;
            $this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, $this->w_cm->formatPattern());

            // l
            $this->l->ViewValue = $this->l->CurrentValue;

            // l_cm
            $this->l_cm->ViewValue = $this->l_cm->CurrentValue;
            $this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, $this->l_cm->formatPattern());

            // h
            $this->h->ViewValue = $this->h->CurrentValue;

            // h_cm
            $this->h_cm->ViewValue = $this->h_cm->CurrentValue;
            $this->h_cm->ViewValue = FormatNumber($this->h_cm->ViewValue, $this->h_cm->formatPattern());

            // partner_size
            $this->partner_size->ViewValue = $this->partner_size->CurrentValue;

            // size
            $this->size->ViewValue = $this->size->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // po_id
            $this->po_id->ViewValue = $this->po_id->CurrentValue;
            $curVal = strval($this->po_id->CurrentValue);
            if ($curVal != "") {
                $this->po_id->ViewValue = $this->po_id->lookupCacheOption($curVal);
                if ($this->po_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_id->Lookup->renderViewRow($rswrk[0]);
                        $this->po_id->ViewValue = $this->po_id->displayValue($arwrk);
                    } else {
                        $this->po_id->ViewValue = FormatNumber($this->po_id->CurrentValue, $this->po_id->formatPattern());
                    }
                }
            } else {
                $this->po_id->ViewValue = null;
            }

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // label
            $this->label->ViewValue = $this->label->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // p_remarks
            $this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // partner_id
            $this->partner_id->HrefValue = "";
            $this->partner_id->TooltipValue = "";

            // p_remarks
            $this->p_remarks->HrefValue = "";
            $this->p_remarks->TooltipValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // partner_id
            $this->partner_id->setupEditAttributes();
            $this->partner_id->EditValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->EditValue = HtmlEncode($this->partner_id->CurrentValue);
                    }
                }
            } else {
                $this->partner_id->EditValue = null;
            }
            $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

            // p_remarks
            $this->p_remarks->setupEditAttributes();
            if (!$this->p_remarks->Raw) {
                $this->p_remarks->CurrentValue = HtmlDecode($this->p_remarks->CurrentValue);
            }
            $this->p_remarks->EditValue = HtmlEncode($this->p_remarks->CurrentValue);
            $this->p_remarks->PlaceHolder = RemoveHtml($this->p_remarks->caption());

            // Edit refer script

            // partner_id
            $this->partner_id->HrefValue = "";

            // p_remarks
            $this->p_remarks->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;
        $updateCnt = 0;
        if ($this->partner_id->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->p_remarks->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($updateCnt == 0) {
            return false;
        }

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->partner_id->Visible && $this->partner_id->Required) {
                if ($this->partner_id->MultiUpdate != "" && !$this->partner_id->IsDetailKey && EmptyValue($this->partner_id->FormValue)) {
                    $this->partner_id->addErrorMessage(str_replace("%s", $this->partner_id->caption(), $this->partner_id->RequiredErrorMessage));
                }
            }
            if ($this->p_remarks->Visible && $this->p_remarks->Required) {
                if ($this->p_remarks->MultiUpdate != "" && !$this->p_remarks->IsDetailKey && EmptyValue($this->p_remarks->FormValue)) {
                    $this->p_remarks->addErrorMessage(str_replace("%s", $this->p_remarks->caption(), $this->p_remarks->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // partner_id
        $this->partner_id->setDbValueDef($rsnew, $this->partner_id->CurrentValue, $this->partner_id->ReadOnly || $this->partner_id->MultiUpdate != "1");

        // p_remarks
        $this->p_remarks->setDbValueDef($rsnew, $this->p_remarks->CurrentValue, $this->p_remarks->ReadOnly || $this->p_remarks->MultiUpdate != "1");
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['partner_id'])) { // partner_id
            $this->partner_id->CurrentValue = $row['partner_id'];
        }
        if (isset($row['p_remarks'])) { // p_remarks
            $this->p_remarks->CurrentValue = $row['p_remarks'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("productcartslist"), "", $this->TableVar, true);
        $pageId = "update";
        $Breadcrumb->add("update", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_batch_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_unit":
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_po_id":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'product_cart_s');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
