<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductCartSSampleAdd extends ProductCartSSample
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductCartSSampleAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "productcartssampleadd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->po_id->Visible = false;
        $this->company_id->setVisibility();
        $this->partner_id->setVisibility();
        $this->product_type->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->rid_1->Visible = false;
        $this->_1->setVisibility();
        $this->shape->setVisibility();
        $this->unit->setVisibility();
        $this->w->setVisibility();
        $this->w_cm->setVisibility();
        $this->l->setVisibility();
        $this->l_cm->setVisibility();
        $this->h->setVisibility();
        $this->h_cm->setVisibility();
        $this->partner_size->setVisibility();
        $this->sqm->setVisibility();
        $this->quantity->setVisibility();
        $this->price->setVisibility();
        $this->currency->setVisibility();
        $this->amount->setVisibility();
        $this->_2->setVisibility();
        $this->_3->setVisibility();
        $this->_4->setVisibility();
        $this->_5->setVisibility();
        $this->_6->setVisibility();
        $this->_7->setVisibility();
        $this->_8->setVisibility();
        $this->_9->setVisibility();
        $this->_10->setVisibility();
        $this->_11->setVisibility();
        $this->_12->setVisibility();
        $this->remarks->setVisibility();
        $this->image->setVisibility();
        $this->buyer_uid->setVisibility();
        $this->status->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->r_text->Visible = false;
        $this->t_id->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'product_cart_s_sample';
        $this->TableName = 'product_cart_s_sample';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (product_cart_s_sample)
        if (!isset($GLOBALS["product_cart_s_sample"]) || $GLOBALS["product_cart_s_sample"]::class == PROJECT_NAMESPACE . "product_cart_s_sample") {
            $GLOBALS["product_cart_s_sample"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_cart_s_sample');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "productcartssampleview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->po_id);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("productcartssamplelist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "productcartssamplelist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "productcartssampleview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "productcartssamplelist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "productcartssamplelist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->image->Upload->Index = $CurrentForm->Index;
        $this->image->Upload->uploadFile();
        $this->image->CurrentValue = $this->image->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->company_id->DefaultValue = $this->company_id->getDefault(); // PHP
        $this->company_id->OldValue = $this->company_id->DefaultValue;
        $this->partner_id->DefaultValue = $this->partner_id->getDefault(); // PHP
        $this->partner_id->OldValue = $this->partner_id->DefaultValue;
        $this->product_type->DefaultValue = $this->product_type->getDefault(); // PHP
        $this->product_type->OldValue = $this->product_type->DefaultValue;
        $this->grp->DefaultValue = $this->grp->getDefault(); // PHP
        $this->grp->OldValue = $this->grp->DefaultValue;
        $this->s_grp->DefaultValue = $this->s_grp->getDefault(); // PHP
        $this->s_grp->OldValue = $this->s_grp->DefaultValue;
        $this->product->DefaultValue = $this->product->getDefault(); // PHP
        $this->product->OldValue = $this->product->DefaultValue;
        $this->rid->DefaultValue = $this->rid->getDefault(); // PHP
        $this->rid->OldValue = $this->rid->DefaultValue;
        $this->shape->DefaultValue = $this->shape->getDefault(); // PHP
        $this->shape->OldValue = $this->shape->DefaultValue;
        $this->unit->DefaultValue = $this->unit->getDefault(); // PHP
        $this->unit->OldValue = $this->unit->DefaultValue;
        $this->w->DefaultValue = $this->w->getDefault(); // PHP
        $this->w->OldValue = $this->w->DefaultValue;
        $this->l->DefaultValue = $this->l->getDefault(); // PHP
        $this->l->OldValue = $this->l->DefaultValue;
        $this->h->DefaultValue = $this->h->getDefault(); // PHP
        $this->h->OldValue = $this->h->DefaultValue;
        $this->quantity->DefaultValue = $this->quantity->getDefault(); // PHP
        $this->quantity->OldValue = $this->quantity->DefaultValue;
        $this->price->DefaultValue = $this->price->getDefault(); // PHP
        $this->price->OldValue = $this->price->DefaultValue;
        $this->_9->DefaultValue = $this->_9->getDefault(); // PHP
        $this->_9->OldValue = $this->_9->DefaultValue;
        $this->_10->DefaultValue = $this->_10->getDefault(); // PHP
        $this->_10->OldValue = $this->_10->DefaultValue;
        $this->_11->DefaultValue = $this->_11->getDefault(); // PHP
        $this->_11->OldValue = $this->_11->DefaultValue;
        $this->_12->DefaultValue = $this->_12->getDefault(); // PHP
        $this->_12->OldValue = $this->_12->DefaultValue;
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val);
            }
        }

        // Check field name 'partner_id' first before field var 'x_partner_id'
        $val = $CurrentForm->hasValue("partner_id") ? $CurrentForm->getValue("partner_id") : $CurrentForm->getValue("x_partner_id");
        if (!$this->partner_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_id->Visible = false; // Disable update for API request
            } else {
                $this->partner_id->setFormValue($val);
            }
        }

        // Check field name 'product_type' first before field var 'x_product_type'
        $val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
        if (!$this->product_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_type->Visible = false; // Disable update for API request
            } else {
                $this->product_type->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val);
            }
        }

        // Check field name '1' first before field var 'x__1'
        $val = $CurrentForm->hasValue("1") ? $CurrentForm->getValue("1") : $CurrentForm->getValue("x__1");
        if (!$this->_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_1->Visible = false; // Disable update for API request
            } else {
                $this->_1->setFormValue($val);
            }
        }

        // Check field name 'shape' first before field var 'x_shape'
        $val = $CurrentForm->hasValue("shape") ? $CurrentForm->getValue("shape") : $CurrentForm->getValue("x_shape");
        if (!$this->shape->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shape->Visible = false; // Disable update for API request
            } else {
                $this->shape->setFormValue($val);
            }
        }

        // Check field name 'unit' first before field var 'x_unit'
        $val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
        if (!$this->unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unit->Visible = false; // Disable update for API request
            } else {
                $this->unit->setFormValue($val);
            }
        }

        // Check field name 'w' first before field var 'x_w'
        $val = $CurrentForm->hasValue("w") ? $CurrentForm->getValue("w") : $CurrentForm->getValue("x_w");
        if (!$this->w->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->w->Visible = false; // Disable update for API request
            } else {
                $this->w->setFormValue($val);
            }
        }

        // Check field name 'w_cm' first before field var 'x_w_cm'
        $val = $CurrentForm->hasValue("w_cm") ? $CurrentForm->getValue("w_cm") : $CurrentForm->getValue("x_w_cm");
        if (!$this->w_cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->w_cm->Visible = false; // Disable update for API request
            } else {
                $this->w_cm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'l' first before field var 'x_l'
        $val = $CurrentForm->hasValue("l") ? $CurrentForm->getValue("l") : $CurrentForm->getValue("x_l");
        if (!$this->l->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->l->Visible = false; // Disable update for API request
            } else {
                $this->l->setFormValue($val);
            }
        }

        // Check field name 'l_cm' first before field var 'x_l_cm'
        $val = $CurrentForm->hasValue("l_cm") ? $CurrentForm->getValue("l_cm") : $CurrentForm->getValue("x_l_cm");
        if (!$this->l_cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->l_cm->Visible = false; // Disable update for API request
            } else {
                $this->l_cm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'h' first before field var 'x_h'
        $val = $CurrentForm->hasValue("h") ? $CurrentForm->getValue("h") : $CurrentForm->getValue("x_h");
        if (!$this->h->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->h->Visible = false; // Disable update for API request
            } else {
                $this->h->setFormValue($val);
            }
        }

        // Check field name 'h_cm' first before field var 'x_h_cm'
        $val = $CurrentForm->hasValue("h_cm") ? $CurrentForm->getValue("h_cm") : $CurrentForm->getValue("x_h_cm");
        if (!$this->h_cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->h_cm->Visible = false; // Disable update for API request
            } else {
                $this->h_cm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'partner_size' first before field var 'x_partner_size'
        $val = $CurrentForm->hasValue("partner_size") ? $CurrentForm->getValue("partner_size") : $CurrentForm->getValue("x_partner_size");
        if (!$this->partner_size->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_size->Visible = false; // Disable update for API request
            } else {
                $this->partner_size->setFormValue($val);
            }
        }

        // Check field name 'sqm' first before field var 'x_sqm'
        $val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
        if (!$this->sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sqm->Visible = false; // Disable update for API request
            } else {
                $this->sqm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'price' first before field var 'x_price'
        $val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
        if (!$this->price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->price->Visible = false; // Disable update for API request
            } else {
                $this->price->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'currency' first before field var 'x_currency'
        $val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
        if (!$this->currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->currency->Visible = false; // Disable update for API request
            } else {
                $this->currency->setFormValue($val);
            }
        }

        // Check field name 'amount' first before field var 'x_amount'
        $val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
        if (!$this->amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount->Visible = false; // Disable update for API request
            } else {
                $this->amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name '2' first before field var 'x__2'
        $val = $CurrentForm->hasValue("2") ? $CurrentForm->getValue("2") : $CurrentForm->getValue("x__2");
        if (!$this->_2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_2->Visible = false; // Disable update for API request
            } else {
                $this->_2->setFormValue($val);
            }
        }

        // Check field name '3' first before field var 'x__3'
        $val = $CurrentForm->hasValue("3") ? $CurrentForm->getValue("3") : $CurrentForm->getValue("x__3");
        if (!$this->_3->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_3->Visible = false; // Disable update for API request
            } else {
                $this->_3->setFormValue($val);
            }
        }

        // Check field name '4' first before field var 'x__4'
        $val = $CurrentForm->hasValue("4") ? $CurrentForm->getValue("4") : $CurrentForm->getValue("x__4");
        if (!$this->_4->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_4->Visible = false; // Disable update for API request
            } else {
                $this->_4->setFormValue($val);
            }
        }

        // Check field name '5' first before field var 'x__5'
        $val = $CurrentForm->hasValue("5") ? $CurrentForm->getValue("5") : $CurrentForm->getValue("x__5");
        if (!$this->_5->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_5->Visible = false; // Disable update for API request
            } else {
                $this->_5->setFormValue($val);
            }
        }

        // Check field name '6' first before field var 'x__6'
        $val = $CurrentForm->hasValue("6") ? $CurrentForm->getValue("6") : $CurrentForm->getValue("x__6");
        if (!$this->_6->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_6->Visible = false; // Disable update for API request
            } else {
                $this->_6->setFormValue($val);
            }
        }

        // Check field name '7' first before field var 'x__7'
        $val = $CurrentForm->hasValue("7") ? $CurrentForm->getValue("7") : $CurrentForm->getValue("x__7");
        if (!$this->_7->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_7->Visible = false; // Disable update for API request
            } else {
                $this->_7->setFormValue($val);
            }
        }

        // Check field name '8' first before field var 'x__8'
        $val = $CurrentForm->hasValue("8") ? $CurrentForm->getValue("8") : $CurrentForm->getValue("x__8");
        if (!$this->_8->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_8->Visible = false; // Disable update for API request
            } else {
                $this->_8->setFormValue($val);
            }
        }

        // Check field name '9' first before field var 'x__9'
        $val = $CurrentForm->hasValue("9") ? $CurrentForm->getValue("9") : $CurrentForm->getValue("x__9");
        if (!$this->_9->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_9->Visible = false; // Disable update for API request
            } else {
                $this->_9->setFormValue($val);
            }
        }

        // Check field name '10' first before field var 'x__10'
        $val = $CurrentForm->hasValue("10") ? $CurrentForm->getValue("10") : $CurrentForm->getValue("x__10");
        if (!$this->_10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_10->Visible = false; // Disable update for API request
            } else {
                $this->_10->setFormValue($val);
            }
        }

        // Check field name '11' first before field var 'x__11'
        $val = $CurrentForm->hasValue("11") ? $CurrentForm->getValue("11") : $CurrentForm->getValue("x__11");
        if (!$this->_11->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_11->Visible = false; // Disable update for API request
            } else {
                $this->_11->setFormValue($val);
            }
        }

        // Check field name '12' first before field var 'x__12'
        $val = $CurrentForm->hasValue("12") ? $CurrentForm->getValue("12") : $CurrentForm->getValue("x__12");
        if (!$this->_12->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_12->Visible = false; // Disable update for API request
            } else {
                $this->_12->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'buyer_uid' first before field var 'x_buyer_uid'
        $val = $CurrentForm->hasValue("buyer_uid") ? $CurrentForm->getValue("buyer_uid") : $CurrentForm->getValue("x_buyer_uid");
        if (!$this->buyer_uid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_uid->Visible = false; // Disable update for API request
            } else {
                $this->buyer_uid->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		$this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
		$this->image->UploadPath = $this->image->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->partner_id->CurrentValue = $this->partner_id->FormValue;
        $this->product_type->CurrentValue = $this->product_type->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->_1->CurrentValue = $this->_1->FormValue;
        $this->shape->CurrentValue = $this->shape->FormValue;
        $this->unit->CurrentValue = $this->unit->FormValue;
        $this->w->CurrentValue = $this->w->FormValue;
        $this->w_cm->CurrentValue = $this->w_cm->FormValue;
        $this->l->CurrentValue = $this->l->FormValue;
        $this->l_cm->CurrentValue = $this->l_cm->FormValue;
        $this->h->CurrentValue = $this->h->FormValue;
        $this->h_cm->CurrentValue = $this->h_cm->FormValue;
        $this->partner_size->CurrentValue = $this->partner_size->FormValue;
        $this->sqm->CurrentValue = $this->sqm->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->price->CurrentValue = $this->price->FormValue;
        $this->currency->CurrentValue = $this->currency->FormValue;
        $this->amount->CurrentValue = $this->amount->FormValue;
        $this->_2->CurrentValue = $this->_2->FormValue;
        $this->_3->CurrentValue = $this->_3->FormValue;
        $this->_4->CurrentValue = $this->_4->FormValue;
        $this->_5->CurrentValue = $this->_5->FormValue;
        $this->_6->CurrentValue = $this->_6->FormValue;
        $this->_7->CurrentValue = $this->_7->FormValue;
        $this->_8->CurrentValue = $this->_8->FormValue;
        $this->_9->CurrentValue = $this->_9->FormValue;
        $this->_10->CurrentValue = $this->_10->FormValue;
        $this->_11->CurrentValue = $this->_11->FormValue;
        $this->_12->CurrentValue = $this->_12->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->buyer_uid->CurrentValue = $this->buyer_uid->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->po_id->setDbValue($row['po_id']);
        $this->company_id->setDbValue($row['company_id']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->product_type->setDbValue($row['product_type']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->rid_1->setDbValue($row['rid_1']);
        $this->_1->setDbValue($row['1']);
        $this->shape->setDbValue($row['shape']);
        $this->unit->setDbValue($row['unit']);
        $this->w->setDbValue($row['w']);
        $this->w_cm->setDbValue($row['w_cm']);
        $this->l->setDbValue($row['l']);
        $this->l_cm->setDbValue($row['l_cm']);
        $this->h->setDbValue($row['h']);
        $this->h_cm->setDbValue($row['h_cm']);
        $this->partner_size->setDbValue($row['partner_size']);
        $this->sqm->setDbValue($row['sqm']);
        $this->quantity->setDbValue($row['quantity']);
        $this->price->setDbValue($row['price']);
        $this->currency->setDbValue($row['currency']);
        $this->amount->setDbValue($row['amount']);
        $this->_2->setDbValue($row['2']);
        $this->_3->setDbValue($row['3']);
        $this->_4->setDbValue($row['4']);
        $this->_5->setDbValue($row['5']);
        $this->_6->setDbValue($row['6']);
        $this->_7->setDbValue($row['7']);
        $this->_8->setDbValue($row['8']);
        $this->_9->setDbValue($row['9']);
        $this->_10->setDbValue($row['10']);
        $this->_11->setDbValue($row['11']);
        $this->_12->setDbValue($row['12']);
        $this->remarks->setDbValue($row['remarks']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->buyer_uid->setDbValue($row['buyer_uid']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->r_text->setDbValue($row['r_text']);
        $this->t_id->setDbValue($row['t_id']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['po_id'] = $this->po_id->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['rid_1'] = $this->rid_1->DefaultValue;
        $row['1'] = $this->_1->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['w'] = $this->w->DefaultValue;
        $row['w_cm'] = $this->w_cm->DefaultValue;
        $row['l'] = $this->l->DefaultValue;
        $row['l_cm'] = $this->l_cm->DefaultValue;
        $row['h'] = $this->h->DefaultValue;
        $row['h_cm'] = $this->h_cm->DefaultValue;
        $row['partner_size'] = $this->partner_size->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['2'] = $this->_2->DefaultValue;
        $row['3'] = $this->_3->DefaultValue;
        $row['4'] = $this->_4->DefaultValue;
        $row['5'] = $this->_5->DefaultValue;
        $row['6'] = $this->_6->DefaultValue;
        $row['7'] = $this->_7->DefaultValue;
        $row['8'] = $this->_8->DefaultValue;
        $row['9'] = $this->_9->DefaultValue;
        $row['10'] = $this->_10->DefaultValue;
        $row['11'] = $this->_11->DefaultValue;
        $row['12'] = $this->_12->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['buyer_uid'] = $this->buyer_uid->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['r_text'] = $this->r_text->DefaultValue;
        $row['t_id'] = $this->t_id->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // po_id
        $this->po_id->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // partner_id
        $this->partner_id->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // rid_1
        $this->rid_1->RowCssClass = "row";

        // 1
        $this->_1->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // unit
        $this->unit->RowCssClass = "row";

        // w
        $this->w->RowCssClass = "row";

        // w_cm
        $this->w_cm->RowCssClass = "row";

        // l
        $this->l->RowCssClass = "row";

        // l_cm
        $this->l_cm->RowCssClass = "row";

        // h
        $this->h->RowCssClass = "row";

        // h_cm
        $this->h_cm->RowCssClass = "row";

        // partner_size
        $this->partner_size->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // price
        $this->price->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // 2
        $this->_2->RowCssClass = "row";

        // 3
        $this->_3->RowCssClass = "row";

        // 4
        $this->_4->RowCssClass = "row";

        // 5
        $this->_5->RowCssClass = "row";

        // 6
        $this->_6->RowCssClass = "row";

        // 7
        $this->_7->RowCssClass = "row";

        // 8
        $this->_8->RowCssClass = "row";

        // 9
        $this->_9->RowCssClass = "row";

        // 10
        $this->_10->RowCssClass = "row";

        // 11
        $this->_11->RowCssClass = "row";

        // 12
        $this->_12->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // buyer_uid
        $this->buyer_uid->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // r_text
        $this->r_text->RowCssClass = "row";

        // t_id
        $this->t_id->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // po_id
            $curVal = strval($this->po_id->CurrentValue);
            if ($curVal != "") {
                $this->po_id->ViewValue = $this->po_id->lookupCacheOption($curVal);
                if ($this->po_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_id->Lookup->renderViewRow($rswrk[0]);
                        $this->po_id->ViewValue = $this->po_id->displayValue($arwrk);
                    } else {
                        $this->po_id->ViewValue = FormatNumber($this->po_id->CurrentValue, $this->po_id->formatPattern());
                    }
                }
            } else {
                $this->po_id->ViewValue = null;
            }

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // partner_id
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // product_type
            if (strval($this->product_type->CurrentValue) != "") {
                $this->product_type->ViewValue = $this->product_type->optionCaption($this->product_type->CurrentValue);
            } else {
                $this->product_type->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // rid_1
            $this->rid_1->ViewValue = $this->rid_1->CurrentValue;

            // 1
            $this->_1->ViewValue = $this->_1->CurrentValue;

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                        $this->shape->ViewValue = $this->shape->displayValue($arwrk);
                    } else {
                        $this->shape->ViewValue = FormatNumber($this->shape->CurrentValue, $this->shape->formatPattern());
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // unit
            if (strval($this->unit->CurrentValue) != "") {
                $this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
            } else {
                $this->unit->ViewValue = null;
            }

            // w
            $this->w->ViewValue = $this->w->CurrentValue;

            // w_cm
            $this->w_cm->ViewValue = $this->w_cm->CurrentValue;
            $this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, $this->w_cm->formatPattern());

            // l
            $this->l->ViewValue = $this->l->CurrentValue;

            // l_cm
            $this->l_cm->ViewValue = $this->l_cm->CurrentValue;
            $this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, $this->l_cm->formatPattern());

            // h
            $this->h->ViewValue = $this->h->CurrentValue;

            // h_cm
            $this->h_cm->ViewValue = $this->h_cm->CurrentValue;
            $this->h_cm->ViewValue = FormatNumber($this->h_cm->ViewValue, $this->h_cm->formatPattern());

            // partner_size
            $this->partner_size->ViewValue = $this->partner_size->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // 2
            $this->_2->ViewValue = $this->_2->CurrentValue;

            // 3
            $this->_3->ViewValue = $this->_3->CurrentValue;

            // 4
            $this->_4->ViewValue = $this->_4->CurrentValue;

            // 5
            $this->_5->ViewValue = $this->_5->CurrentValue;

            // 6
            $this->_6->ViewValue = $this->_6->CurrentValue;

            // 7
            $this->_7->ViewValue = $this->_7->CurrentValue;

            // 8
            $this->_8->ViewValue = $this->_8->CurrentValue;

            // 9
            $this->_9->ViewValue = $this->_9->CurrentValue;

            // 10
            $this->_10->ViewValue = $this->_10->CurrentValue;

            // 11
            $this->_11->ViewValue = $this->_11->CurrentValue;

            // 12
            $this->_12->ViewValue = $this->_12->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ImageWidth = 0;
                $this->image->ImageHeight = 50;
                $this->image->ImageAlt = $this->image->alt();
                $this->image->ImageCssClass = "ew-image";
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // buyer_uid
            $this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // company_id
            $this->company_id->HrefValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";

            // product_type
            $this->product_type->HrefValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid
            $this->rid->HrefValue = "";

            // 1
            $this->_1->HrefValue = "";

            // shape
            $this->shape->HrefValue = "";

            // unit
            if (!EmptyValue($this->unit->CurrentValue)) {
                $this->unit->HrefValue = $this->unit->getLinkPrefix() . $this->unit->CurrentValue; // Add prefix/suffix
                $this->unit->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
                }
            } else {
                $this->unit->HrefValue = "";
            }

            // w
            $this->w->HrefValue = "";

            // w_cm
            $this->w_cm->HrefValue = "";

            // l
            $this->l->HrefValue = "";

            // l_cm
            $this->l_cm->HrefValue = "";

            // h
            $this->h->HrefValue = "";

            // h_cm
            $this->h_cm->HrefValue = "";

            // partner_size
            $this->partner_size->HrefValue = "";

            // sqm
            $this->sqm->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // 2
            $this->_2->HrefValue = "";

            // 3
            $this->_3->HrefValue = "";

            // 4
            $this->_4->HrefValue = "";

            // 5
            $this->_5->HrefValue = "";

            // 6
            $this->_6->HrefValue = "";

            // 7
            $this->_7->HrefValue = "";

            // 8
            $this->_8->HrefValue = "";

            // 9
            $this->_9->HrefValue = "";

            // 10
            $this->_10->HrefValue = "";

            // 11
            $this->_11->HrefValue = "";

            // 12
            $this->_12->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->HrefValue = "%u"; // Add prefix/suffix
                $this->image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
                }
            } else {
                $this->image->HrefValue = "";
            }
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

            // buyer_uid
            $this->buyer_uid->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = trim(strval($this->company_id->CurrentValue));
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->CurrentValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // partner_id
            $this->partner_id->setupEditAttributes();
            $curVal = trim(strval($this->partner_id->CurrentValue));
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
            } else {
                $this->partner_id->ViewValue = $this->partner_id->Lookup !== null && is_array($this->partner_id->lookupOptions()) && count($this->partner_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->partner_id->ViewValue !== null) { // Load from cache
                $this->partner_id->EditValue = array_values($this->partner_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->partner_id->CurrentValue, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->partner_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->partner_id->EditValue = $arwrk;
            }
            $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

            // product_type
            $this->product_type->setupEditAttributes();
            $this->product_type->EditCustomAttributes = $this->product_type->getEditCustomAttributes(); // PHP
            $this->product_type->EditValue = $this->product_type->options(true);
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid
            $this->rid->setupEditAttributes();
            $curVal = trim(strval($this->rid->CurrentValue));
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
            } else {
                $this->rid->ViewValue = $this->rid->Lookup !== null && is_array($this->rid->lookupOptions()) && count($this->rid->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid->ViewValue !== null) { // Load from cache
                $this->rid->EditValue = array_values($this->rid->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid->CurrentValue, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->rid->EditValue = $arwrk;
            }
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // 1
            $this->_1->setupEditAttributes();
            if (!$this->_1->Raw) {
                $this->_1->CurrentValue = HtmlDecode($this->_1->CurrentValue);
            }
            $this->_1->EditValue = HtmlEncode($this->_1->CurrentValue);
            $this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

            // shape
            $this->shape->setupEditAttributes();
            $curVal = trim(strval($this->shape->CurrentValue));
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
            } else {
                $this->shape->ViewValue = $this->shape->Lookup !== null && is_array($this->shape->lookupOptions()) && count($this->shape->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->shape->ViewValue !== null) { // Load from cache
                $this->shape->EditValue = array_values($this->shape->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->shape->CurrentValue, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                $sqlWrk = $this->shape->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->shape->EditValue = $arwrk;
            }
            $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

            // unit
            $this->unit->setupEditAttributes();
            $this->unit->EditValue = $this->unit->options(true);
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

            // w
            $this->w->setupEditAttributes();
            if (!$this->w->Raw) {
                $this->w->CurrentValue = HtmlDecode($this->w->CurrentValue);
            }
            $this->w->EditValue = HtmlEncode($this->w->CurrentValue);
            $this->w->PlaceHolder = RemoveHtml($this->w->caption());

            // w_cm
            $this->w_cm->setupEditAttributes();
            $this->w_cm->EditCustomAttributes = $this->w_cm->getEditCustomAttributes(); // PHP
            $this->w_cm->EditValue = $this->w_cm->CurrentValue;
            $this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());
            if (strval($this->w_cm->EditValue) != "" && is_numeric($this->w_cm->EditValue)) {
                $this->w_cm->EditValue = FormatNumber($this->w_cm->EditValue, null);
            }

            // l
            $this->l->setupEditAttributes();
            if (!$this->l->Raw) {
                $this->l->CurrentValue = HtmlDecode($this->l->CurrentValue);
            }
            $this->l->EditValue = HtmlEncode($this->l->CurrentValue);
            $this->l->PlaceHolder = RemoveHtml($this->l->caption());

            // l_cm
            $this->l_cm->setupEditAttributes();
            $this->l_cm->EditCustomAttributes = $this->l_cm->getEditCustomAttributes(); // PHP
            $this->l_cm->EditValue = $this->l_cm->CurrentValue;
            $this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());
            if (strval($this->l_cm->EditValue) != "" && is_numeric($this->l_cm->EditValue)) {
                $this->l_cm->EditValue = FormatNumber($this->l_cm->EditValue, null);
            }

            // h
            $this->h->setupEditAttributes();
            if (!$this->h->Raw) {
                $this->h->CurrentValue = HtmlDecode($this->h->CurrentValue);
            }
            $this->h->EditValue = HtmlEncode($this->h->CurrentValue);
            $this->h->PlaceHolder = RemoveHtml($this->h->caption());

            // h_cm
            $this->h_cm->setupEditAttributes();
            $this->h_cm->EditCustomAttributes = $this->h_cm->getEditCustomAttributes(); // PHP
            $this->h_cm->EditValue = $this->h_cm->CurrentValue;
            $this->h_cm->PlaceHolder = RemoveHtml($this->h_cm->caption());
            if (strval($this->h_cm->EditValue) != "" && is_numeric($this->h_cm->EditValue)) {
                $this->h_cm->EditValue = FormatNumber($this->h_cm->EditValue, null);
            }

            // partner_size
            $this->partner_size->setupEditAttributes();
            if (!$this->partner_size->Raw) {
                $this->partner_size->CurrentValue = HtmlDecode($this->partner_size->CurrentValue);
            }
            $this->partner_size->EditValue = HtmlEncode($this->partner_size->CurrentValue);
            $this->partner_size->PlaceHolder = RemoveHtml($this->partner_size->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditCustomAttributes = $this->sqm->getEditCustomAttributes(); // PHP
            $this->sqm->EditValue = $this->sqm->CurrentValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
            if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
                $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
            }

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // price
            $this->price->setupEditAttributes();
            $this->price->EditValue = $this->price->CurrentValue;
            $this->price->PlaceHolder = RemoveHtml($this->price->caption());
            if (strval($this->price->EditValue) != "" && is_numeric($this->price->EditValue)) {
                $this->price->EditValue = FormatNumber($this->price->EditValue, null);
            }

            // currency
            $this->currency->setupEditAttributes();
            $curVal = trim(strval($this->currency->CurrentValue));
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
            } else {
                $this->currency->ViewValue = $this->currency->Lookup !== null && is_array($this->currency->lookupOptions()) && count($this->currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->currency->ViewValue !== null) { // Load from cache
                $this->currency->EditValue = array_values($this->currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->currency->CurrentValue, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->currency->EditValue = $arwrk;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditCustomAttributes = $this->amount->getEditCustomAttributes(); // PHP
            $this->amount->EditValue = $this->amount->CurrentValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
            if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
                $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
            }

            // 2
            $this->_2->setupEditAttributes();
            if (!$this->_2->Raw) {
                $this->_2->CurrentValue = HtmlDecode($this->_2->CurrentValue);
            }
            $this->_2->EditValue = HtmlEncode($this->_2->CurrentValue);
            $this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

            // 3
            $this->_3->setupEditAttributes();
            if (!$this->_3->Raw) {
                $this->_3->CurrentValue = HtmlDecode($this->_3->CurrentValue);
            }
            $this->_3->EditValue = HtmlEncode($this->_3->CurrentValue);
            $this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

            // 4
            $this->_4->setupEditAttributes();
            if (!$this->_4->Raw) {
                $this->_4->CurrentValue = HtmlDecode($this->_4->CurrentValue);
            }
            $this->_4->EditValue = HtmlEncode($this->_4->CurrentValue);
            $this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

            // 5
            $this->_5->setupEditAttributes();
            if (!$this->_5->Raw) {
                $this->_5->CurrentValue = HtmlDecode($this->_5->CurrentValue);
            }
            $this->_5->EditValue = HtmlEncode($this->_5->CurrentValue);
            $this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

            // 6
            $this->_6->setupEditAttributes();
            if (!$this->_6->Raw) {
                $this->_6->CurrentValue = HtmlDecode($this->_6->CurrentValue);
            }
            $this->_6->EditValue = HtmlEncode($this->_6->CurrentValue);
            $this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

            // 7
            $this->_7->setupEditAttributes();
            if (!$this->_7->Raw) {
                $this->_7->CurrentValue = HtmlDecode($this->_7->CurrentValue);
            }
            $this->_7->EditValue = HtmlEncode($this->_7->CurrentValue);
            $this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

            // 8
            $this->_8->setupEditAttributes();
            if (!$this->_8->Raw) {
                $this->_8->CurrentValue = HtmlDecode($this->_8->CurrentValue);
            }
            $this->_8->EditValue = HtmlEncode($this->_8->CurrentValue);
            $this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

            // 9
            $this->_9->setupEditAttributes();
            if (!$this->_9->Raw) {
                $this->_9->CurrentValue = HtmlDecode($this->_9->CurrentValue);
            }
            $this->_9->EditValue = HtmlEncode($this->_9->CurrentValue);
            $this->_9->PlaceHolder = RemoveHtml($this->_9->caption());

            // 10
            $this->_10->setupEditAttributes();
            if (!$this->_10->Raw) {
                $this->_10->CurrentValue = HtmlDecode($this->_10->CurrentValue);
            }
            $this->_10->EditValue = HtmlEncode($this->_10->CurrentValue);
            $this->_10->PlaceHolder = RemoveHtml($this->_10->caption());

            // 11
            $this->_11->setupEditAttributes();
            if (!$this->_11->Raw) {
                $this->_11->CurrentValue = HtmlDecode($this->_11->CurrentValue);
            }
            $this->_11->EditValue = HtmlEncode($this->_11->CurrentValue);
            $this->_11->PlaceHolder = RemoveHtml($this->_11->caption());

            // 12
            $this->_12->setupEditAttributes();
            if (!$this->_12->Raw) {
                $this->_12->CurrentValue = HtmlDecode($this->_12->CurrentValue);
            }
            $this->_12->EditValue = HtmlEncode($this->_12->CurrentValue);
            $this->_12->PlaceHolder = RemoveHtml($this->_12->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // image
            $this->image->setupEditAttributes();
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ImageWidth = 0;
                $this->image->ImageHeight = 50;
                $this->image->ImageAlt = $this->image->alt();
                $this->image->ImageCssClass = "ew-image";
                $this->image->EditValue = $this->image->Upload->DbValue;
            } else {
                $this->image->EditValue = "";
            }
            if (!EmptyValue($this->image->CurrentValue)) {
                $this->image->Upload->FileName = $this->image->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->image->Upload->DbValue = null;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->image);
            }

            // buyer_uid
            $this->buyer_uid->setupEditAttributes();
            $this->buyer_uid->EditValue = HtmlEncode($this->buyer_uid->CurrentValue);
            $this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

            // operator

            // datetime

            // Add refer script

            // company_id
            $this->company_id->HrefValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";

            // product_type
            $this->product_type->HrefValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid
            $this->rid->HrefValue = "";

            // 1
            $this->_1->HrefValue = "";

            // shape
            $this->shape->HrefValue = "";

            // unit
            if (!EmptyValue($this->unit->CurrentValue)) {
                $this->unit->HrefValue = $this->unit->getLinkPrefix() . $this->unit->CurrentValue; // Add prefix/suffix
                $this->unit->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
                }
            } else {
                $this->unit->HrefValue = "";
            }

            // w
            $this->w->HrefValue = "";

            // w_cm
            $this->w_cm->HrefValue = "";

            // l
            $this->l->HrefValue = "";

            // l_cm
            $this->l_cm->HrefValue = "";

            // h
            $this->h->HrefValue = "";

            // h_cm
            $this->h_cm->HrefValue = "";

            // partner_size
            $this->partner_size->HrefValue = "";

            // sqm
            $this->sqm->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // 2
            $this->_2->HrefValue = "";

            // 3
            $this->_3->HrefValue = "";

            // 4
            $this->_4->HrefValue = "";

            // 5
            $this->_5->HrefValue = "";

            // 6
            $this->_6->HrefValue = "";

            // 7
            $this->_7->HrefValue = "";

            // 8
            $this->_8->HrefValue = "";

            // 9
            $this->_9->HrefValue = "";

            // 10
            $this->_10->HrefValue = "";

            // 11
            $this->_11->HrefValue = "";

            // 12
            $this->_12->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->HrefValue = "%u"; // Add prefix/suffix
                $this->image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
                }
            } else {
                $this->image->HrefValue = "";
            }
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

            // buyer_uid
            $this->buyer_uid->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if ($this->partner_id->Visible && $this->partner_id->Required) {
                if (!$this->partner_id->IsDetailKey && EmptyValue($this->partner_id->FormValue)) {
                    $this->partner_id->addErrorMessage(str_replace("%s", $this->partner_id->caption(), $this->partner_id->RequiredErrorMessage));
                }
            }
            if ($this->product_type->Visible && $this->product_type->Required) {
                if (!$this->product_type->IsDetailKey && EmptyValue($this->product_type->FormValue)) {
                    $this->product_type->addErrorMessage(str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if (!$this->rid->IsDetailKey && EmptyValue($this->rid->FormValue)) {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if ($this->_1->Visible && $this->_1->Required) {
                if (!$this->_1->IsDetailKey && EmptyValue($this->_1->FormValue)) {
                    $this->_1->addErrorMessage(str_replace("%s", $this->_1->caption(), $this->_1->RequiredErrorMessage));
                }
            }
            if ($this->shape->Visible && $this->shape->Required) {
                if (!$this->shape->IsDetailKey && EmptyValue($this->shape->FormValue)) {
                    $this->shape->addErrorMessage(str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
                }
            }
            if ($this->unit->Visible && $this->unit->Required) {
                if (!$this->unit->IsDetailKey && EmptyValue($this->unit->FormValue)) {
                    $this->unit->addErrorMessage(str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
                }
            }
            if ($this->w->Visible && $this->w->Required) {
                if (!$this->w->IsDetailKey && EmptyValue($this->w->FormValue)) {
                    $this->w->addErrorMessage(str_replace("%s", $this->w->caption(), $this->w->RequiredErrorMessage));
                }
            }
            if ($this->w_cm->Visible && $this->w_cm->Required) {
                if (!$this->w_cm->IsDetailKey && EmptyValue($this->w_cm->FormValue)) {
                    $this->w_cm->addErrorMessage(str_replace("%s", $this->w_cm->caption(), $this->w_cm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->w_cm->FormValue)) {
                $this->w_cm->addErrorMessage($this->w_cm->getErrorMessage(false));
            }
            if ($this->l->Visible && $this->l->Required) {
                if (!$this->l->IsDetailKey && EmptyValue($this->l->FormValue)) {
                    $this->l->addErrorMessage(str_replace("%s", $this->l->caption(), $this->l->RequiredErrorMessage));
                }
            }
            if ($this->l_cm->Visible && $this->l_cm->Required) {
                if (!$this->l_cm->IsDetailKey && EmptyValue($this->l_cm->FormValue)) {
                    $this->l_cm->addErrorMessage(str_replace("%s", $this->l_cm->caption(), $this->l_cm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->l_cm->FormValue)) {
                $this->l_cm->addErrorMessage($this->l_cm->getErrorMessage(false));
            }
            if ($this->h->Visible && $this->h->Required) {
                if (!$this->h->IsDetailKey && EmptyValue($this->h->FormValue)) {
                    $this->h->addErrorMessage(str_replace("%s", $this->h->caption(), $this->h->RequiredErrorMessage));
                }
            }
            if ($this->h_cm->Visible && $this->h_cm->Required) {
                if (!$this->h_cm->IsDetailKey && EmptyValue($this->h_cm->FormValue)) {
                    $this->h_cm->addErrorMessage(str_replace("%s", $this->h_cm->caption(), $this->h_cm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->h_cm->FormValue)) {
                $this->h_cm->addErrorMessage($this->h_cm->getErrorMessage(false));
            }
            if ($this->partner_size->Visible && $this->partner_size->Required) {
                if (!$this->partner_size->IsDetailKey && EmptyValue($this->partner_size->FormValue)) {
                    $this->partner_size->addErrorMessage(str_replace("%s", $this->partner_size->caption(), $this->partner_size->RequiredErrorMessage));
                }
            }
            if ($this->sqm->Visible && $this->sqm->Required) {
                if (!$this->sqm->IsDetailKey && EmptyValue($this->sqm->FormValue)) {
                    $this->sqm->addErrorMessage(str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->sqm->FormValue)) {
                $this->sqm->addErrorMessage($this->sqm->getErrorMessage(false));
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity->FormValue)) {
                $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
            }
            if ($this->price->Visible && $this->price->Required) {
                if (!$this->price->IsDetailKey && EmptyValue($this->price->FormValue)) {
                    $this->price->addErrorMessage(str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->price->FormValue)) {
                $this->price->addErrorMessage($this->price->getErrorMessage(false));
            }
            if ($this->currency->Visible && $this->currency->Required) {
                if (!$this->currency->IsDetailKey && EmptyValue($this->currency->FormValue)) {
                    $this->currency->addErrorMessage(str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
                }
            }
            if ($this->amount->Visible && $this->amount->Required) {
                if (!$this->amount->IsDetailKey && EmptyValue($this->amount->FormValue)) {
                    $this->amount->addErrorMessage(str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->amount->FormValue)) {
                $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
            }
            if ($this->_2->Visible && $this->_2->Required) {
                if (!$this->_2->IsDetailKey && EmptyValue($this->_2->FormValue)) {
                    $this->_2->addErrorMessage(str_replace("%s", $this->_2->caption(), $this->_2->RequiredErrorMessage));
                }
            }
            if ($this->_3->Visible && $this->_3->Required) {
                if (!$this->_3->IsDetailKey && EmptyValue($this->_3->FormValue)) {
                    $this->_3->addErrorMessage(str_replace("%s", $this->_3->caption(), $this->_3->RequiredErrorMessage));
                }
            }
            if ($this->_4->Visible && $this->_4->Required) {
                if (!$this->_4->IsDetailKey && EmptyValue($this->_4->FormValue)) {
                    $this->_4->addErrorMessage(str_replace("%s", $this->_4->caption(), $this->_4->RequiredErrorMessage));
                }
            }
            if ($this->_5->Visible && $this->_5->Required) {
                if (!$this->_5->IsDetailKey && EmptyValue($this->_5->FormValue)) {
                    $this->_5->addErrorMessage(str_replace("%s", $this->_5->caption(), $this->_5->RequiredErrorMessage));
                }
            }
            if ($this->_6->Visible && $this->_6->Required) {
                if (!$this->_6->IsDetailKey && EmptyValue($this->_6->FormValue)) {
                    $this->_6->addErrorMessage(str_replace("%s", $this->_6->caption(), $this->_6->RequiredErrorMessage));
                }
            }
            if ($this->_7->Visible && $this->_7->Required) {
                if (!$this->_7->IsDetailKey && EmptyValue($this->_7->FormValue)) {
                    $this->_7->addErrorMessage(str_replace("%s", $this->_7->caption(), $this->_7->RequiredErrorMessage));
                }
            }
            if ($this->_8->Visible && $this->_8->Required) {
                if (!$this->_8->IsDetailKey && EmptyValue($this->_8->FormValue)) {
                    $this->_8->addErrorMessage(str_replace("%s", $this->_8->caption(), $this->_8->RequiredErrorMessage));
                }
            }
            if ($this->_9->Visible && $this->_9->Required) {
                if (!$this->_9->IsDetailKey && EmptyValue($this->_9->FormValue)) {
                    $this->_9->addErrorMessage(str_replace("%s", $this->_9->caption(), $this->_9->RequiredErrorMessage));
                }
            }
            if ($this->_10->Visible && $this->_10->Required) {
                if (!$this->_10->IsDetailKey && EmptyValue($this->_10->FormValue)) {
                    $this->_10->addErrorMessage(str_replace("%s", $this->_10->caption(), $this->_10->RequiredErrorMessage));
                }
            }
            if ($this->_11->Visible && $this->_11->Required) {
                if (!$this->_11->IsDetailKey && EmptyValue($this->_11->FormValue)) {
                    $this->_11->addErrorMessage(str_replace("%s", $this->_11->caption(), $this->_11->RequiredErrorMessage));
                }
            }
            if ($this->_12->Visible && $this->_12->Required) {
                if (!$this->_12->IsDetailKey && EmptyValue($this->_12->FormValue)) {
                    $this->_12->addErrorMessage(str_replace("%s", $this->_12->caption(), $this->_12->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->image->Visible && $this->image->Required) {
                if ($this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
                    $this->image->addErrorMessage(str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
                }
            }
            if ($this->buyer_uid->Visible && $this->buyer_uid->Required) {
                if (!$this->buyer_uid->IsDetailKey && EmptyValue($this->buyer_uid->FormValue)) {
                    $this->buyer_uid->addErrorMessage(str_replace("%s", $this->buyer_uid->caption(), $this->buyer_uid->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();
        if ($this->image->Visible && !$this->image->Upload->KeepFile) {
            $this->image->UploadPath = $this->image->getUploadPath();
            if (!EmptyValue($this->image->Upload->FileName)) {
                $this->image->Upload->DbValue = null;
                FixUploadFileNames($this->image);
                $this->image->setDbValueDef($rsnew, $this->image->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $this->image->UploadPath = $this->image->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->image->Visible && !$this->image->Upload->KeepFile) {
                    $this->image->Upload->DbValue = null;
                    if (!SaveUploadFiles($this->image, $rsnew['image'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, false);

        // partner_id
        $this->partner_id->setDbValueDef($rsnew, $this->partner_id->CurrentValue, false);

        // product_type
        $this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, false);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, false);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, false);

        // rid
        $this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, false);

        // 1
        $this->_1->setDbValueDef($rsnew, $this->_1->CurrentValue, false);

        // shape
        $this->shape->setDbValueDef($rsnew, $this->shape->CurrentValue, false);

        // unit
        $this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, false);

        // w
        $this->w->setDbValueDef($rsnew, $this->w->CurrentValue, false);

        // w_cm
        $this->w_cm->setDbValueDef($rsnew, $this->w_cm->CurrentValue, false);

        // l
        $this->l->setDbValueDef($rsnew, $this->l->CurrentValue, false);

        // l_cm
        $this->l_cm->setDbValueDef($rsnew, $this->l_cm->CurrentValue, false);

        // h
        $this->h->setDbValueDef($rsnew, $this->h->CurrentValue, false);

        // h_cm
        $this->h_cm->setDbValueDef($rsnew, $this->h_cm->CurrentValue, false);

        // partner_size
        $this->partner_size->setDbValueDef($rsnew, $this->partner_size->CurrentValue, false);

        // sqm
        $this->sqm->setDbValueDef($rsnew, $this->sqm->CurrentValue, strval($this->sqm->CurrentValue) == "");

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, false);

        // price
        $this->price->setDbValueDef($rsnew, $this->price->CurrentValue, false);

        // currency
        $this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, false);

        // amount
        $this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, false);

        // 2
        $this->_2->setDbValueDef($rsnew, $this->_2->CurrentValue, false);

        // 3
        $this->_3->setDbValueDef($rsnew, $this->_3->CurrentValue, false);

        // 4
        $this->_4->setDbValueDef($rsnew, $this->_4->CurrentValue, false);

        // 5
        $this->_5->setDbValueDef($rsnew, $this->_5->CurrentValue, false);

        // 6
        $this->_6->setDbValueDef($rsnew, $this->_6->CurrentValue, false);

        // 7
        $this->_7->setDbValueDef($rsnew, $this->_7->CurrentValue, false);

        // 8
        $this->_8->setDbValueDef($rsnew, $this->_8->CurrentValue, false);

        // 9
        $this->_9->setDbValueDef($rsnew, $this->_9->CurrentValue, false);

        // 10
        $this->_10->setDbValueDef($rsnew, $this->_10->CurrentValue, false);

        // 11
        $this->_11->setDbValueDef($rsnew, $this->_11->CurrentValue, false);

        // 12
        $this->_12->setDbValueDef($rsnew, $this->_12->CurrentValue, false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // image
        if ($this->image->Visible && !$this->image->Upload->KeepFile) {
            if ($this->image->Upload->FileName == "") {
                $rsnew['image'] = null;
            } else {
                FixUploadTempFileNames($this->image);
                $rsnew['image'] = $this->image->Upload->FileName;
            }
            $this->image->ImageWidth = 0; // Resize width
            $this->image->ImageHeight = 640; // Resize height
        }

        // buyer_uid
        $this->buyer_uid->setDbValueDef($rsnew, $this->buyer_uid->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['company_id'])) { // company_id
            $this->company_id->setFormValue($row['company_id']);
        }
        if (isset($row['partner_id'])) { // partner_id
            $this->partner_id->setFormValue($row['partner_id']);
        }
        if (isset($row['product_type'])) { // product_type
            $this->product_type->setFormValue($row['product_type']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->setFormValue($row['s_grp']);
        }
        if (isset($row['product'])) { // product
            $this->product->setFormValue($row['product']);
        }
        if (isset($row['rid'])) { // rid
            $this->rid->setFormValue($row['rid']);
        }
        if (isset($row['1'])) { // 1
            $this->_1->setFormValue($row['1']);
        }
        if (isset($row['shape'])) { // shape
            $this->shape->setFormValue($row['shape']);
        }
        if (isset($row['unit'])) { // unit
            $this->unit->setFormValue($row['unit']);
        }
        if (isset($row['w'])) { // w
            $this->w->setFormValue($row['w']);
        }
        if (isset($row['w_cm'])) { // w_cm
            $this->w_cm->setFormValue($row['w_cm']);
        }
        if (isset($row['l'])) { // l
            $this->l->setFormValue($row['l']);
        }
        if (isset($row['l_cm'])) { // l_cm
            $this->l_cm->setFormValue($row['l_cm']);
        }
        if (isset($row['h'])) { // h
            $this->h->setFormValue($row['h']);
        }
        if (isset($row['h_cm'])) { // h_cm
            $this->h_cm->setFormValue($row['h_cm']);
        }
        if (isset($row['partner_size'])) { // partner_size
            $this->partner_size->setFormValue($row['partner_size']);
        }
        if (isset($row['sqm'])) { // sqm
            $this->sqm->setFormValue($row['sqm']);
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->setFormValue($row['quantity']);
        }
        if (isset($row['price'])) { // price
            $this->price->setFormValue($row['price']);
        }
        if (isset($row['currency'])) { // currency
            $this->currency->setFormValue($row['currency']);
        }
        if (isset($row['amount'])) { // amount
            $this->amount->setFormValue($row['amount']);
        }
        if (isset($row['2'])) { // 2
            $this->_2->setFormValue($row['2']);
        }
        if (isset($row['3'])) { // 3
            $this->_3->setFormValue($row['3']);
        }
        if (isset($row['4'])) { // 4
            $this->_4->setFormValue($row['4']);
        }
        if (isset($row['5'])) { // 5
            $this->_5->setFormValue($row['5']);
        }
        if (isset($row['6'])) { // 6
            $this->_6->setFormValue($row['6']);
        }
        if (isset($row['7'])) { // 7
            $this->_7->setFormValue($row['7']);
        }
        if (isset($row['8'])) { // 8
            $this->_8->setFormValue($row['8']);
        }
        if (isset($row['9'])) { // 9
            $this->_9->setFormValue($row['9']);
        }
        if (isset($row['10'])) { // 10
            $this->_10->setFormValue($row['10']);
        }
        if (isset($row['11'])) { // 11
            $this->_11->setFormValue($row['11']);
        }
        if (isset($row['12'])) { // 12
            $this->_12->setFormValue($row['12']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['image'])) { // image
            $this->image->setFormValue($row['image']);
        }
        if (isset($row['buyer_uid'])) { // buyer_uid
            $this->buyer_uid->setFormValue($row['buyer_uid']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("productcartssamplelist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_po_id":
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_unit":
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'product_cart_s_sample');		
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
