<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductCartSList extends ProductCartS
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductCartSList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fproduct_cart_slist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "productcartslist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->location->setVisibility();
        $this->company_id->setVisibility();
        $this->partner_id->setVisibility();
        $this->partner_rid->setVisibility();
        $this->product_type->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->packing_type->setVisibility();
        $this->batch_no->setVisibility();
        $this->shape->setVisibility();
        $this->unit->setVisibility();
        $this->w->setVisibility();
        $this->w_cm->setVisibility();
        $this->l->setVisibility();
        $this->l_cm->setVisibility();
        $this->h->setVisibility();
        $this->h_cm->setVisibility();
        $this->partner_size->setVisibility();
        $this->size->Visible = false;
        $this->sqm->Visible = false;
        $this->quantity->setVisibility();
        $this->price->setVisibility();
        $this->currency->Visible = false;
        $this->amount->setVisibility();
        $this->status->setVisibility();
        $this->cart_id->Visible = false;
        $this->po_id->setVisibility();
        $this->rid_1->Visible = false;
        $this->hsn_code->Visible = false;
        $this->despatch_date->Visible = false;
        $this->pkt_quantity->Visible = false;
        $this->multiprice_id->Visible = false;
        $this->discount_price->Visible = false;
        $this->cbm->Visible = false;
        $this->tax->Visible = false;
        $this->tax_amount->Visible = false;
        $this->shipping_method->Visible = false;
        $this->shipping_local->Visible = false;
        $this->shipping_abroad->Visible = false;
        $this->shipping_charge->Visible = false;
        $this->additional_discount->Visible = false;
        $this->total_amount->Visible = false;
        $this->buyer_uid->Visible = false;
        $this->label->Visible = false;
        $this->remarks->setVisibility();
        $this->p_remarks->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->o_datetime->Visible = false;
        $this->cart_amount->Visible = false;
        $this->c_total->Visible = false;
        $this->_1->Visible = false;
        $this->_2->Visible = false;
        $this->_3->Visible = false;
        $this->_4->Visible = false;
        $this->_5->Visible = false;
        $this->_6->Visible = false;
        $this->_7->Visible = false;
        $this->_8->Visible = false;
        $this->image->Visible = false;
        $this->r_text->Visible = false;
        $this->t_id->Visible = false;
        $this->_9->Visible = false;
        $this->_10->Visible = false;
        $this->_11->Visible = false;
        $this->_12->Visible = false;
        $this->sqm_u->Visible = false;
        $this->reports_to->Visible = false;
        $this->buyer_loc->Visible = false;
        $this->p_id->Visible = false;
        $this->partner_code->Visible = false;
        $this->q_sku->Visible = false;
        $this->partner_order_no->Visible = false;
        $this->p_qty->Visible = false;
        $this->product_code->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'product_cart_s';
        $this->TableName = 'product_cart_s';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (product_cart_s)
        if (!isset($GLOBALS["product_cart_s"]) || $GLOBALS["product_cart_s"]::class == PROJECT_NAMESPACE . "product_cart_s") {
            $GLOBALS["product_cart_s"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "productcartsadd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "productcartsdelete";
        $this->MultiUpdateUrl = "productcartsupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_cart_s');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "productcartsview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "20,50,100,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up master detail parameters
        $this->setupMasterParms();

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->partner_rid);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->po_id);
        $this->setupLookupOptions($this->operator);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fproduct_cart_sgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }

        // Restore master/detail filter from session
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Restore master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Restore detail filter from session
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Load master record
        if ($this->CurrentMode != "add" && $this->DbMasterFilter != "" && $this->getCurrentMasterTable() == "material_status") {
            $masterTbl = Container("material_status");
            $rsmaster = $masterTbl->loadRs($this->DbMasterFilter)->fetchAssociative();
            $this->MasterRecordExists = $rsmaster !== false;
            if (!$this->MasterRecordExists) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
                $this->terminate("materialstatuslist"); // Return to master page
                return;
            } else {
                $masterTbl->loadListRowValues($rsmaster);
                $masterTbl->RowType = RowType::MASTER; // Master row
                $masterTbl->renderListRow();
            }
        }

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);

        // Export selected records
        if ($this->isExport()) {
            $this->CurrentFilter = $this->buildExportSelectedFilter();
        }
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }

            // Audit trail on search
            if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
                $searchParm = ServerVar("QUERY_STRING");
                $searchSql = $this->getSessionWhere();
                $this->writeAuditTrailOnSearch($searchParm, $searchSql);
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fproduct_cart_ssrch");
        }
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->location->AdvancedSearch->toJson(), ","); // Field location
        $filterList = Concat($filterList, $this->company_id->AdvancedSearch->toJson(), ","); // Field company_id
        $filterList = Concat($filterList, $this->partner_id->AdvancedSearch->toJson(), ","); // Field partner_id
        $filterList = Concat($filterList, $this->partner_rid->AdvancedSearch->toJson(), ","); // Field partner_rid
        $filterList = Concat($filterList, $this->product_type->AdvancedSearch->toJson(), ","); // Field product_type
        $filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
        $filterList = Concat($filterList, $this->s_grp->AdvancedSearch->toJson(), ","); // Field s_grp
        $filterList = Concat($filterList, $this->product->AdvancedSearch->toJson(), ","); // Field product
        $filterList = Concat($filterList, $this->rid->AdvancedSearch->toJson(), ","); // Field rid
        $filterList = Concat($filterList, $this->packing_type->AdvancedSearch->toJson(), ","); // Field packing_type
        $filterList = Concat($filterList, $this->batch_no->AdvancedSearch->toJson(), ","); // Field batch_no
        $filterList = Concat($filterList, $this->shape->AdvancedSearch->toJson(), ","); // Field shape
        $filterList = Concat($filterList, $this->unit->AdvancedSearch->toJson(), ","); // Field unit
        $filterList = Concat($filterList, $this->w->AdvancedSearch->toJson(), ","); // Field w
        $filterList = Concat($filterList, $this->w_cm->AdvancedSearch->toJson(), ","); // Field w_cm
        $filterList = Concat($filterList, $this->l->AdvancedSearch->toJson(), ","); // Field l
        $filterList = Concat($filterList, $this->l_cm->AdvancedSearch->toJson(), ","); // Field l_cm
        $filterList = Concat($filterList, $this->h->AdvancedSearch->toJson(), ","); // Field h
        $filterList = Concat($filterList, $this->h_cm->AdvancedSearch->toJson(), ","); // Field h_cm
        $filterList = Concat($filterList, $this->partner_size->AdvancedSearch->toJson(), ","); // Field partner_size
        $filterList = Concat($filterList, $this->size->AdvancedSearch->toJson(), ","); // Field size
        $filterList = Concat($filterList, $this->sqm->AdvancedSearch->toJson(), ","); // Field sqm
        $filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
        $filterList = Concat($filterList, $this->price->AdvancedSearch->toJson(), ","); // Field price
        $filterList = Concat($filterList, $this->currency->AdvancedSearch->toJson(), ","); // Field currency
        $filterList = Concat($filterList, $this->po_id->AdvancedSearch->toJson(), ","); // Field po_id
        $filterList = Concat($filterList, $this->cbm->AdvancedSearch->toJson(), ","); // Field cbm
        $filterList = Concat($filterList, $this->buyer_uid->AdvancedSearch->toJson(), ","); // Field buyer_uid
        $filterList = Concat($filterList, $this->label->AdvancedSearch->toJson(), ","); // Field label
        $filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
        $filterList = Concat($filterList, $this->p_remarks->AdvancedSearch->toJson(), ","); // Field p_remarks
        $filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
        $filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fproduct_cart_ssrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field location
        $this->location->AdvancedSearch->SearchValue = @$filter["x_location"];
        $this->location->AdvancedSearch->SearchOperator = @$filter["z_location"];
        $this->location->AdvancedSearch->SearchCondition = @$filter["v_location"];
        $this->location->AdvancedSearch->SearchValue2 = @$filter["y_location"];
        $this->location->AdvancedSearch->SearchOperator2 = @$filter["w_location"];
        $this->location->AdvancedSearch->save();

        // Field company_id
        $this->company_id->AdvancedSearch->SearchValue = @$filter["x_company_id"];
        $this->company_id->AdvancedSearch->SearchOperator = @$filter["z_company_id"];
        $this->company_id->AdvancedSearch->SearchCondition = @$filter["v_company_id"];
        $this->company_id->AdvancedSearch->SearchValue2 = @$filter["y_company_id"];
        $this->company_id->AdvancedSearch->SearchOperator2 = @$filter["w_company_id"];
        $this->company_id->AdvancedSearch->save();

        // Field partner_id
        $this->partner_id->AdvancedSearch->SearchValue = @$filter["x_partner_id"];
        $this->partner_id->AdvancedSearch->SearchOperator = @$filter["z_partner_id"];
        $this->partner_id->AdvancedSearch->SearchCondition = @$filter["v_partner_id"];
        $this->partner_id->AdvancedSearch->SearchValue2 = @$filter["y_partner_id"];
        $this->partner_id->AdvancedSearch->SearchOperator2 = @$filter["w_partner_id"];
        $this->partner_id->AdvancedSearch->save();

        // Field partner_rid
        $this->partner_rid->AdvancedSearch->SearchValue = @$filter["x_partner_rid"];
        $this->partner_rid->AdvancedSearch->SearchOperator = @$filter["z_partner_rid"];
        $this->partner_rid->AdvancedSearch->SearchCondition = @$filter["v_partner_rid"];
        $this->partner_rid->AdvancedSearch->SearchValue2 = @$filter["y_partner_rid"];
        $this->partner_rid->AdvancedSearch->SearchOperator2 = @$filter["w_partner_rid"];
        $this->partner_rid->AdvancedSearch->save();

        // Field product_type
        $this->product_type->AdvancedSearch->SearchValue = @$filter["x_product_type"];
        $this->product_type->AdvancedSearch->SearchOperator = @$filter["z_product_type"];
        $this->product_type->AdvancedSearch->SearchCondition = @$filter["v_product_type"];
        $this->product_type->AdvancedSearch->SearchValue2 = @$filter["y_product_type"];
        $this->product_type->AdvancedSearch->SearchOperator2 = @$filter["w_product_type"];
        $this->product_type->AdvancedSearch->save();

        // Field grp
        $this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
        $this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
        $this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
        $this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
        $this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
        $this->grp->AdvancedSearch->save();

        // Field s_grp
        $this->s_grp->AdvancedSearch->SearchValue = @$filter["x_s_grp"];
        $this->s_grp->AdvancedSearch->SearchOperator = @$filter["z_s_grp"];
        $this->s_grp->AdvancedSearch->SearchCondition = @$filter["v_s_grp"];
        $this->s_grp->AdvancedSearch->SearchValue2 = @$filter["y_s_grp"];
        $this->s_grp->AdvancedSearch->SearchOperator2 = @$filter["w_s_grp"];
        $this->s_grp->AdvancedSearch->save();

        // Field product
        $this->product->AdvancedSearch->SearchValue = @$filter["x_product"];
        $this->product->AdvancedSearch->SearchOperator = @$filter["z_product"];
        $this->product->AdvancedSearch->SearchCondition = @$filter["v_product"];
        $this->product->AdvancedSearch->SearchValue2 = @$filter["y_product"];
        $this->product->AdvancedSearch->SearchOperator2 = @$filter["w_product"];
        $this->product->AdvancedSearch->save();

        // Field rid
        $this->rid->AdvancedSearch->SearchValue = @$filter["x_rid"];
        $this->rid->AdvancedSearch->SearchOperator = @$filter["z_rid"];
        $this->rid->AdvancedSearch->SearchCondition = @$filter["v_rid"];
        $this->rid->AdvancedSearch->SearchValue2 = @$filter["y_rid"];
        $this->rid->AdvancedSearch->SearchOperator2 = @$filter["w_rid"];
        $this->rid->AdvancedSearch->save();

        // Field packing_type
        $this->packing_type->AdvancedSearch->SearchValue = @$filter["x_packing_type"];
        $this->packing_type->AdvancedSearch->SearchOperator = @$filter["z_packing_type"];
        $this->packing_type->AdvancedSearch->SearchCondition = @$filter["v_packing_type"];
        $this->packing_type->AdvancedSearch->SearchValue2 = @$filter["y_packing_type"];
        $this->packing_type->AdvancedSearch->SearchOperator2 = @$filter["w_packing_type"];
        $this->packing_type->AdvancedSearch->save();

        // Field batch_no
        $this->batch_no->AdvancedSearch->SearchValue = @$filter["x_batch_no"];
        $this->batch_no->AdvancedSearch->SearchOperator = @$filter["z_batch_no"];
        $this->batch_no->AdvancedSearch->SearchCondition = @$filter["v_batch_no"];
        $this->batch_no->AdvancedSearch->SearchValue2 = @$filter["y_batch_no"];
        $this->batch_no->AdvancedSearch->SearchOperator2 = @$filter["w_batch_no"];
        $this->batch_no->AdvancedSearch->save();

        // Field shape
        $this->shape->AdvancedSearch->SearchValue = @$filter["x_shape"];
        $this->shape->AdvancedSearch->SearchOperator = @$filter["z_shape"];
        $this->shape->AdvancedSearch->SearchCondition = @$filter["v_shape"];
        $this->shape->AdvancedSearch->SearchValue2 = @$filter["y_shape"];
        $this->shape->AdvancedSearch->SearchOperator2 = @$filter["w_shape"];
        $this->shape->AdvancedSearch->save();

        // Field unit
        $this->unit->AdvancedSearch->SearchValue = @$filter["x_unit"];
        $this->unit->AdvancedSearch->SearchOperator = @$filter["z_unit"];
        $this->unit->AdvancedSearch->SearchCondition = @$filter["v_unit"];
        $this->unit->AdvancedSearch->SearchValue2 = @$filter["y_unit"];
        $this->unit->AdvancedSearch->SearchOperator2 = @$filter["w_unit"];
        $this->unit->AdvancedSearch->save();

        // Field w
        $this->w->AdvancedSearch->SearchValue = @$filter["x_w"];
        $this->w->AdvancedSearch->SearchOperator = @$filter["z_w"];
        $this->w->AdvancedSearch->SearchCondition = @$filter["v_w"];
        $this->w->AdvancedSearch->SearchValue2 = @$filter["y_w"];
        $this->w->AdvancedSearch->SearchOperator2 = @$filter["w_w"];
        $this->w->AdvancedSearch->save();

        // Field w_cm
        $this->w_cm->AdvancedSearch->SearchValue = @$filter["x_w_cm"];
        $this->w_cm->AdvancedSearch->SearchOperator = @$filter["z_w_cm"];
        $this->w_cm->AdvancedSearch->SearchCondition = @$filter["v_w_cm"];
        $this->w_cm->AdvancedSearch->SearchValue2 = @$filter["y_w_cm"];
        $this->w_cm->AdvancedSearch->SearchOperator2 = @$filter["w_w_cm"];
        $this->w_cm->AdvancedSearch->save();

        // Field l
        $this->l->AdvancedSearch->SearchValue = @$filter["x_l"];
        $this->l->AdvancedSearch->SearchOperator = @$filter["z_l"];
        $this->l->AdvancedSearch->SearchCondition = @$filter["v_l"];
        $this->l->AdvancedSearch->SearchValue2 = @$filter["y_l"];
        $this->l->AdvancedSearch->SearchOperator2 = @$filter["w_l"];
        $this->l->AdvancedSearch->save();

        // Field l_cm
        $this->l_cm->AdvancedSearch->SearchValue = @$filter["x_l_cm"];
        $this->l_cm->AdvancedSearch->SearchOperator = @$filter["z_l_cm"];
        $this->l_cm->AdvancedSearch->SearchCondition = @$filter["v_l_cm"];
        $this->l_cm->AdvancedSearch->SearchValue2 = @$filter["y_l_cm"];
        $this->l_cm->AdvancedSearch->SearchOperator2 = @$filter["w_l_cm"];
        $this->l_cm->AdvancedSearch->save();

        // Field h
        $this->h->AdvancedSearch->SearchValue = @$filter["x_h"];
        $this->h->AdvancedSearch->SearchOperator = @$filter["z_h"];
        $this->h->AdvancedSearch->SearchCondition = @$filter["v_h"];
        $this->h->AdvancedSearch->SearchValue2 = @$filter["y_h"];
        $this->h->AdvancedSearch->SearchOperator2 = @$filter["w_h"];
        $this->h->AdvancedSearch->save();

        // Field h_cm
        $this->h_cm->AdvancedSearch->SearchValue = @$filter["x_h_cm"];
        $this->h_cm->AdvancedSearch->SearchOperator = @$filter["z_h_cm"];
        $this->h_cm->AdvancedSearch->SearchCondition = @$filter["v_h_cm"];
        $this->h_cm->AdvancedSearch->SearchValue2 = @$filter["y_h_cm"];
        $this->h_cm->AdvancedSearch->SearchOperator2 = @$filter["w_h_cm"];
        $this->h_cm->AdvancedSearch->save();

        // Field partner_size
        $this->partner_size->AdvancedSearch->SearchValue = @$filter["x_partner_size"];
        $this->partner_size->AdvancedSearch->SearchOperator = @$filter["z_partner_size"];
        $this->partner_size->AdvancedSearch->SearchCondition = @$filter["v_partner_size"];
        $this->partner_size->AdvancedSearch->SearchValue2 = @$filter["y_partner_size"];
        $this->partner_size->AdvancedSearch->SearchOperator2 = @$filter["w_partner_size"];
        $this->partner_size->AdvancedSearch->save();

        // Field size
        $this->size->AdvancedSearch->SearchValue = @$filter["x_size"];
        $this->size->AdvancedSearch->SearchOperator = @$filter["z_size"];
        $this->size->AdvancedSearch->SearchCondition = @$filter["v_size"];
        $this->size->AdvancedSearch->SearchValue2 = @$filter["y_size"];
        $this->size->AdvancedSearch->SearchOperator2 = @$filter["w_size"];
        $this->size->AdvancedSearch->save();

        // Field sqm
        $this->sqm->AdvancedSearch->SearchValue = @$filter["x_sqm"];
        $this->sqm->AdvancedSearch->SearchOperator = @$filter["z_sqm"];
        $this->sqm->AdvancedSearch->SearchCondition = @$filter["v_sqm"];
        $this->sqm->AdvancedSearch->SearchValue2 = @$filter["y_sqm"];
        $this->sqm->AdvancedSearch->SearchOperator2 = @$filter["w_sqm"];
        $this->sqm->AdvancedSearch->save();

        // Field quantity
        $this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
        $this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
        $this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
        $this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
        $this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
        $this->quantity->AdvancedSearch->save();

        // Field price
        $this->price->AdvancedSearch->SearchValue = @$filter["x_price"];
        $this->price->AdvancedSearch->SearchOperator = @$filter["z_price"];
        $this->price->AdvancedSearch->SearchCondition = @$filter["v_price"];
        $this->price->AdvancedSearch->SearchValue2 = @$filter["y_price"];
        $this->price->AdvancedSearch->SearchOperator2 = @$filter["w_price"];
        $this->price->AdvancedSearch->save();

        // Field currency
        $this->currency->AdvancedSearch->SearchValue = @$filter["x_currency"];
        $this->currency->AdvancedSearch->SearchOperator = @$filter["z_currency"];
        $this->currency->AdvancedSearch->SearchCondition = @$filter["v_currency"];
        $this->currency->AdvancedSearch->SearchValue2 = @$filter["y_currency"];
        $this->currency->AdvancedSearch->SearchOperator2 = @$filter["w_currency"];
        $this->currency->AdvancedSearch->save();

        // Field po_id
        $this->po_id->AdvancedSearch->SearchValue = @$filter["x_po_id"];
        $this->po_id->AdvancedSearch->SearchOperator = @$filter["z_po_id"];
        $this->po_id->AdvancedSearch->SearchCondition = @$filter["v_po_id"];
        $this->po_id->AdvancedSearch->SearchValue2 = @$filter["y_po_id"];
        $this->po_id->AdvancedSearch->SearchOperator2 = @$filter["w_po_id"];
        $this->po_id->AdvancedSearch->save();

        // Field cbm
        $this->cbm->AdvancedSearch->SearchValue = @$filter["x_cbm"];
        $this->cbm->AdvancedSearch->SearchOperator = @$filter["z_cbm"];
        $this->cbm->AdvancedSearch->SearchCondition = @$filter["v_cbm"];
        $this->cbm->AdvancedSearch->SearchValue2 = @$filter["y_cbm"];
        $this->cbm->AdvancedSearch->SearchOperator2 = @$filter["w_cbm"];
        $this->cbm->AdvancedSearch->save();

        // Field buyer_uid
        $this->buyer_uid->AdvancedSearch->SearchValue = @$filter["x_buyer_uid"];
        $this->buyer_uid->AdvancedSearch->SearchOperator = @$filter["z_buyer_uid"];
        $this->buyer_uid->AdvancedSearch->SearchCondition = @$filter["v_buyer_uid"];
        $this->buyer_uid->AdvancedSearch->SearchValue2 = @$filter["y_buyer_uid"];
        $this->buyer_uid->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_uid"];
        $this->buyer_uid->AdvancedSearch->save();

        // Field label
        $this->label->AdvancedSearch->SearchValue = @$filter["x_label"];
        $this->label->AdvancedSearch->SearchOperator = @$filter["z_label"];
        $this->label->AdvancedSearch->SearchCondition = @$filter["v_label"];
        $this->label->AdvancedSearch->SearchValue2 = @$filter["y_label"];
        $this->label->AdvancedSearch->SearchOperator2 = @$filter["w_label"];
        $this->label->AdvancedSearch->save();

        // Field remarks
        $this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
        $this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
        $this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
        $this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
        $this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
        $this->remarks->AdvancedSearch->save();

        // Field p_remarks
        $this->p_remarks->AdvancedSearch->SearchValue = @$filter["x_p_remarks"];
        $this->p_remarks->AdvancedSearch->SearchOperator = @$filter["z_p_remarks"];
        $this->p_remarks->AdvancedSearch->SearchCondition = @$filter["v_p_remarks"];
        $this->p_remarks->AdvancedSearch->SearchValue2 = @$filter["y_p_remarks"];
        $this->p_remarks->AdvancedSearch->SearchOperator2 = @$filter["w_p_remarks"];
        $this->p_remarks->AdvancedSearch->save();

        // Field operator
        $this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
        $this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
        $this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
        $this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
        $this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
        $this->operator->AdvancedSearch->save();

        // Field datetime
        $this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
        $this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
        $this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
        $this->datetime->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->location, $default, false); // location
        $this->buildSearchSql($where, $this->company_id, $default, false); // company_id
        $this->buildSearchSql($where, $this->partner_id, $default, false); // partner_id
        $this->buildSearchSql($where, $this->partner_rid, $default, false); // partner_rid
        $this->buildSearchSql($where, $this->product_type, $default, false); // product_type
        $this->buildSearchSql($where, $this->grp, $default, false); // grp
        $this->buildSearchSql($where, $this->s_grp, $default, false); // s_grp
        $this->buildSearchSql($where, $this->product, $default, false); // product
        $this->buildSearchSql($where, $this->rid, $default, false); // rid
        $this->buildSearchSql($where, $this->packing_type, $default, false); // packing_type
        $this->buildSearchSql($where, $this->batch_no, $default, false); // batch_no
        $this->buildSearchSql($where, $this->shape, $default, false); // shape
        $this->buildSearchSql($where, $this->unit, $default, false); // unit
        $this->buildSearchSql($where, $this->w, $default, false); // w
        $this->buildSearchSql($where, $this->w_cm, $default, false); // w_cm
        $this->buildSearchSql($where, $this->l, $default, false); // l
        $this->buildSearchSql($where, $this->l_cm, $default, false); // l_cm
        $this->buildSearchSql($where, $this->h, $default, false); // h
        $this->buildSearchSql($where, $this->h_cm, $default, false); // h_cm
        $this->buildSearchSql($where, $this->partner_size, $default, false); // partner_size
        $this->buildSearchSql($where, $this->size, $default, false); // size
        $this->buildSearchSql($where, $this->sqm, $default, false); // sqm
        $this->buildSearchSql($where, $this->quantity, $default, false); // quantity
        $this->buildSearchSql($where, $this->price, $default, false); // price
        $this->buildSearchSql($where, $this->currency, $default, false); // currency
        $this->buildSearchSql($where, $this->po_id, $default, false); // po_id
        $this->buildSearchSql($where, $this->cbm, $default, false); // cbm
        $this->buildSearchSql($where, $this->buyer_uid, $default, false); // buyer_uid
        $this->buildSearchSql($where, $this->label, $default, false); // label
        $this->buildSearchSql($where, $this->remarks, $default, false); // remarks
        $this->buildSearchSql($where, $this->p_remarks, $default, false); // p_remarks
        $this->buildSearchSql($where, $this->operator, $default, false); // operator
        $this->buildSearchSql($where, $this->datetime, $default, false); // datetime

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->id->AdvancedSearch->save(); // id
            $this->location->AdvancedSearch->save(); // location
            $this->company_id->AdvancedSearch->save(); // company_id
            $this->partner_id->AdvancedSearch->save(); // partner_id
            $this->partner_rid->AdvancedSearch->save(); // partner_rid
            $this->product_type->AdvancedSearch->save(); // product_type
            $this->grp->AdvancedSearch->save(); // grp
            $this->s_grp->AdvancedSearch->save(); // s_grp
            $this->product->AdvancedSearch->save(); // product
            $this->rid->AdvancedSearch->save(); // rid
            $this->packing_type->AdvancedSearch->save(); // packing_type
            $this->batch_no->AdvancedSearch->save(); // batch_no
            $this->shape->AdvancedSearch->save(); // shape
            $this->unit->AdvancedSearch->save(); // unit
            $this->w->AdvancedSearch->save(); // w
            $this->w_cm->AdvancedSearch->save(); // w_cm
            $this->l->AdvancedSearch->save(); // l
            $this->l_cm->AdvancedSearch->save(); // l_cm
            $this->h->AdvancedSearch->save(); // h
            $this->h_cm->AdvancedSearch->save(); // h_cm
            $this->partner_size->AdvancedSearch->save(); // partner_size
            $this->size->AdvancedSearch->save(); // size
            $this->sqm->AdvancedSearch->save(); // sqm
            $this->quantity->AdvancedSearch->save(); // quantity
            $this->price->AdvancedSearch->save(); // price
            $this->currency->AdvancedSearch->save(); // currency
            $this->po_id->AdvancedSearch->save(); // po_id
            $this->cbm->AdvancedSearch->save(); // cbm
            $this->buyer_uid->AdvancedSearch->save(); // buyer_uid
            $this->label->AdvancedSearch->save(); // label
            $this->remarks->AdvancedSearch->save(); // remarks
            $this->p_remarks->AdvancedSearch->save(); // p_remarks
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->id->AdvancedSearch->save(); // id
            $this->location->AdvancedSearch->save(); // location
            $this->company_id->AdvancedSearch->save(); // company_id
            $this->partner_id->AdvancedSearch->save(); // partner_id
            $this->partner_rid->AdvancedSearch->save(); // partner_rid
            $this->product_type->AdvancedSearch->save(); // product_type
            $this->grp->AdvancedSearch->save(); // grp
            $this->s_grp->AdvancedSearch->save(); // s_grp
            $this->product->AdvancedSearch->save(); // product
            $this->rid->AdvancedSearch->save(); // rid
            $this->packing_type->AdvancedSearch->save(); // packing_type
            $this->batch_no->AdvancedSearch->save(); // batch_no
            $this->shape->AdvancedSearch->save(); // shape
            $this->unit->AdvancedSearch->save(); // unit
            $this->w->AdvancedSearch->save(); // w
            $this->w_cm->AdvancedSearch->save(); // w_cm
            $this->l->AdvancedSearch->save(); // l
            $this->l_cm->AdvancedSearch->save(); // l_cm
            $this->h->AdvancedSearch->save(); // h
            $this->h_cm->AdvancedSearch->save(); // h_cm
            $this->partner_size->AdvancedSearch->save(); // partner_size
            $this->size->AdvancedSearch->save(); // size
            $this->sqm->AdvancedSearch->save(); // sqm
            $this->quantity->AdvancedSearch->save(); // quantity
            $this->price->AdvancedSearch->save(); // price
            $this->currency->AdvancedSearch->save(); // currency
            $this->po_id->AdvancedSearch->save(); // po_id
            $this->cbm->AdvancedSearch->save(); // cbm
            $this->buyer_uid->AdvancedSearch->save(); // buyer_uid
            $this->label->AdvancedSearch->save(); // label
            $this->remarks->AdvancedSearch->save(); // remarks
            $this->p_remarks->AdvancedSearch->save(); // p_remarks
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field id
        $filter = $this->queryBuilderWhere("id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field location
        $filter = $this->queryBuilderWhere("location");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->location, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->location->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field company_id
        $filter = $this->queryBuilderWhere("company_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->company_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->company_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field partner_id
        $filter = $this->queryBuilderWhere("partner_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->partner_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->partner_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field partner_rid
        $filter = $this->queryBuilderWhere("partner_rid");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->partner_rid, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->partner_rid->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field product_type
        $filter = $this->queryBuilderWhere("product_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->product_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->product_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field grp
        $filter = $this->queryBuilderWhere("grp");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->grp, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->grp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field s_grp
        $filter = $this->queryBuilderWhere("s_grp");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->s_grp, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->s_grp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field product
        $filter = $this->queryBuilderWhere("product");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->product, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->product->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field rid
        $filter = $this->queryBuilderWhere("rid");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->rid, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->rid->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field packing_type
        $filter = $this->queryBuilderWhere("packing_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->packing_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->packing_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field batch_no
        $filter = $this->queryBuilderWhere("batch_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->batch_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->batch_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field shape
        $filter = $this->queryBuilderWhere("shape");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->shape, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->shape->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field unit
        $filter = $this->queryBuilderWhere("unit");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->unit, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->unit->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field w
        $filter = $this->queryBuilderWhere("w");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->w, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->w->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field w_cm
        $filter = $this->queryBuilderWhere("w_cm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->w_cm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->w_cm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field l
        $filter = $this->queryBuilderWhere("l");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->l, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->l->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field l_cm
        $filter = $this->queryBuilderWhere("l_cm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->l_cm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->l_cm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field h
        $filter = $this->queryBuilderWhere("h");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->h, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->h->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field h_cm
        $filter = $this->queryBuilderWhere("h_cm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->h_cm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->h_cm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field partner_size
        $filter = $this->queryBuilderWhere("partner_size");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->partner_size, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->partner_size->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field quantity
        $filter = $this->queryBuilderWhere("quantity");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->quantity, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->quantity->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field price
        $filter = $this->queryBuilderWhere("price");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->price, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->price->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po_id
        $filter = $this->queryBuilderWhere("po_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field remarks
        $filter = $this->queryBuilderWhere("remarks");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->remarks, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->remarks->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field p_remarks
        $filter = $this->queryBuilderWhere("p_remarks");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->p_remarks, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->p_remarks->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field operator
        $filter = $this->queryBuilderWhere("operator");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->operator, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->operator->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field datetime
        $filter = $this->queryBuilderWhere("datetime");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->datetime, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->datetime->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->partner_rid;
        $searchFlds[] = &$this->product;
        $searchFlds[] = &$this->rid;
        $searchFlds[] = &$this->packing_type;
        $searchFlds[] = &$this->w;
        $searchFlds[] = &$this->l;
        $searchFlds[] = &$this->h;
        $searchFlds[] = &$this->partner_size;
        $searchFlds[] = &$this->size;
        $searchFlds[] = &$this->price;
        $searchFlds[] = &$this->buyer_uid;
        $searchFlds[] = &$this->label;
        $searchFlds[] = &$this->remarks;
        $searchFlds[] = &$this->p_remarks;
        $searchFlds[] = &$this->t_id;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->location->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->company_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->partner_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->partner_rid->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->product_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->s_grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->product->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->rid->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->packing_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->batch_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->shape->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->unit->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->w->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->w_cm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->l->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->l_cm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->h->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->h_cm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->partner_size->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->size->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sqm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->quantity->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->price->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->currency->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cbm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_uid->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->label->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->remarks->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->p_remarks->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->id->AdvancedSearch->unsetSession();
        $this->location->AdvancedSearch->unsetSession();
        $this->company_id->AdvancedSearch->unsetSession();
        $this->partner_id->AdvancedSearch->unsetSession();
        $this->partner_rid->AdvancedSearch->unsetSession();
        $this->product_type->AdvancedSearch->unsetSession();
        $this->grp->AdvancedSearch->unsetSession();
        $this->s_grp->AdvancedSearch->unsetSession();
        $this->product->AdvancedSearch->unsetSession();
        $this->rid->AdvancedSearch->unsetSession();
        $this->packing_type->AdvancedSearch->unsetSession();
        $this->batch_no->AdvancedSearch->unsetSession();
        $this->shape->AdvancedSearch->unsetSession();
        $this->unit->AdvancedSearch->unsetSession();
        $this->w->AdvancedSearch->unsetSession();
        $this->w_cm->AdvancedSearch->unsetSession();
        $this->l->AdvancedSearch->unsetSession();
        $this->l_cm->AdvancedSearch->unsetSession();
        $this->h->AdvancedSearch->unsetSession();
        $this->h_cm->AdvancedSearch->unsetSession();
        $this->partner_size->AdvancedSearch->unsetSession();
        $this->size->AdvancedSearch->unsetSession();
        $this->sqm->AdvancedSearch->unsetSession();
        $this->quantity->AdvancedSearch->unsetSession();
        $this->price->AdvancedSearch->unsetSession();
        $this->currency->AdvancedSearch->unsetSession();
        $this->po_id->AdvancedSearch->unsetSession();
        $this->cbm->AdvancedSearch->unsetSession();
        $this->buyer_uid->AdvancedSearch->unsetSession();
        $this->label->AdvancedSearch->unsetSession();
        $this->remarks->AdvancedSearch->unsetSession();
        $this->p_remarks->AdvancedSearch->unsetSession();
        $this->operator->AdvancedSearch->unsetSession();
        $this->datetime->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->id->AdvancedSearch->load();
        $this->location->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->partner_id->AdvancedSearch->load();
        $this->partner_rid->AdvancedSearch->load();
        $this->product_type->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->rid->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->batch_no->AdvancedSearch->load();
        $this->shape->AdvancedSearch->load();
        $this->unit->AdvancedSearch->load();
        $this->w->AdvancedSearch->load();
        $this->w_cm->AdvancedSearch->load();
        $this->l->AdvancedSearch->load();
        $this->l_cm->AdvancedSearch->load();
        $this->h->AdvancedSearch->load();
        $this->h_cm->AdvancedSearch->load();
        $this->partner_size->AdvancedSearch->load();
        $this->size->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->price->AdvancedSearch->load();
        $this->currency->AdvancedSearch->load();
        $this->po_id->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->buyer_uid->AdvancedSearch->load();
        $this->label->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->p_remarks->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id); // id
            $this->updateSort($this->location); // location
            $this->updateSort($this->company_id); // company_id
            $this->updateSort($this->partner_id); // partner_id
            $this->updateSort($this->partner_rid); // partner_rid
            $this->updateSort($this->product_type); // product_type
            $this->updateSort($this->grp); // grp
            $this->updateSort($this->s_grp); // s_grp
            $this->updateSort($this->product); // product
            $this->updateSort($this->rid); // rid
            $this->updateSort($this->packing_type); // packing_type
            $this->updateSort($this->batch_no); // batch_no
            $this->updateSort($this->shape); // shape
            $this->updateSort($this->unit); // unit
            $this->updateSort($this->w); // w
            $this->updateSort($this->w_cm); // w_cm
            $this->updateSort($this->l); // l
            $this->updateSort($this->l_cm); // l_cm
            $this->updateSort($this->h); // h
            $this->updateSort($this->h_cm); // h_cm
            $this->updateSort($this->partner_size); // partner_size
            $this->updateSort($this->quantity); // quantity
            $this->updateSort($this->price); // price
            $this->updateSort($this->amount); // amount
            $this->updateSort($this->status); // status
            $this->updateSort($this->po_id); // po_id
            $this->updateSort($this->remarks); // remarks
            $this->updateSort($this->p_remarks); // p_remarks
            $this->updateSort($this->operator); // operator
            $this->updateSort($this->datetime); // datetime
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset master/detail keys
            if ($this->Command == "resetall") {
                $this->setCurrentMasterTable(""); // Clear master table
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
                        $this->rid->setSessionValue("");
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->id->setSort("");
                $this->location->setSort("");
                $this->company_id->setSort("");
                $this->partner_id->setSort("");
                $this->partner_rid->setSort("");
                $this->product_type->setSort("");
                $this->grp->setSort("");
                $this->s_grp->setSort("");
                $this->product->setSort("");
                $this->rid->setSort("");
                $this->packing_type->setSort("");
                $this->batch_no->setSort("");
                $this->shape->setSort("");
                $this->unit->setSort("");
                $this->w->setSort("");
                $this->w_cm->setSort("");
                $this->l->setSort("");
                $this->l_cm->setSort("");
                $this->h->setSort("");
                $this->h_cm->setSort("");
                $this->partner_size->setSort("");
                $this->size->setSort("");
                $this->sqm->setSort("");
                $this->quantity->setSort("");
                $this->price->setSort("");
                $this->currency->setSort("");
                $this->amount->setSort("");
                $this->status->setSort("");
                $this->cart_id->setSort("");
                $this->po_id->setSort("");
                $this->rid_1->setSort("");
                $this->hsn_code->setSort("");
                $this->despatch_date->setSort("");
                $this->pkt_quantity->setSort("");
                $this->multiprice_id->setSort("");
                $this->discount_price->setSort("");
                $this->cbm->setSort("");
                $this->tax->setSort("");
                $this->tax_amount->setSort("");
                $this->shipping_method->setSort("");
                $this->shipping_local->setSort("");
                $this->shipping_abroad->setSort("");
                $this->shipping_charge->setSort("");
                $this->additional_discount->setSort("");
                $this->total_amount->setSort("");
                $this->buyer_uid->setSort("");
                $this->label->setSort("");
                $this->remarks->setSort("");
                $this->p_remarks->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
                $this->o_datetime->setSort("");
                $this->cart_amount->setSort("");
                $this->c_total->setSort("");
                $this->_1->setSort("");
                $this->_2->setSort("");
                $this->_3->setSort("");
                $this->_4->setSort("");
                $this->_5->setSort("");
                $this->_6->setSort("");
                $this->_7->setSort("");
                $this->_8->setSort("");
                $this->image->setSort("");
                $this->r_text->setSort("");
                $this->t_id->setSort("");
                $this->_9->setSort("");
                $this->_10->setSort("");
                $this->_11->setSort("");
                $this->_12->setSort("");
                $this->sqm_u->setSort("");
                $this->reports_to->setSort("");
                $this->buyer_loc->setSort("");
                $this->p_id->setSort("");
                $this->partner_code->setSort("");
                $this->q_sku->setSort("");
                $this->partner_order_no->setSort("");
                $this->p_qty->setSort("");
                $this->product_code->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "delete"
        $item = &$this->ListOptions->add("delete");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = true;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"product_cart_s\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"product_cart_s\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"product_cart_s\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "delete"
            $opt = $this->ListOptions["delete"];
            if ($Security->canDelete()) {
                $deleteCaption = $Language->phrase("DeleteLink");
                $deleteTitle = HtmlTitle($deleteCaption);
                if ($this->UseAjaxActions) {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\" data-ew-action=\"inline\" data-action=\"delete\" title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" data-key= \"" . HtmlEncode($this->getKey(true)) . "\" data-url=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\"" .
                        ($this->InlineDelete ? " data-ew-action=\"inline-delete\"" : "") .
                        " title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fproduct_cart_slist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fproduct_cart_slist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"product_cart_s\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["action"];

        // Add multi update
        $item = &$option->add("multiupdate");
        $item->Body = "<button type=\"button\" class=\"ew-action ew-multi-update\" title=\"" .
            $Language->phrase("UpdateSelectedLink", true) . "\" data-table=\"product_cart_s\" data-caption=\"" .
            $Language->phrase("UpdateSelectedLink", true) . "\" form=\"fproduct_cart_slist\" data-ew-action=\"" .
            ($this->ModalUpdate && !IsMobile() ? "modal" : "submit") . "\"" .
            ($this->ModalUpdate && !IsMobile() ? " data-action=\"update\"" : "") .
            ($this->UseAjaxActions ? " data-ajax=\"true\"" : "") .
            " data-url=\"" . GetUrl($this->MultiUpdateUrl) . "\">" . $Language->phrase("UpdateSelectedLink") . "</button>";
        $item->Visible = $Security->canEdit();

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "location");
            $this->createColumnOption($option, "company_id");
            $this->createColumnOption($option, "partner_id");
            $this->createColumnOption($option, "partner_rid");
            $this->createColumnOption($option, "product_type");
            $this->createColumnOption($option, "grp");
            $this->createColumnOption($option, "s_grp");
            $this->createColumnOption($option, "product");
            $this->createColumnOption($option, "rid");
            $this->createColumnOption($option, "packing_type");
            $this->createColumnOption($option, "batch_no");
            $this->createColumnOption($option, "shape");
            $this->createColumnOption($option, "unit");
            $this->createColumnOption($option, "w");
            $this->createColumnOption($option, "w_cm");
            $this->createColumnOption($option, "l");
            $this->createColumnOption($option, "l_cm");
            $this->createColumnOption($option, "h");
            $this->createColumnOption($option, "h_cm");
            $this->createColumnOption($option, "partner_size");
            $this->createColumnOption($option, "quantity");
            $this->createColumnOption($option, "price");
            $this->createColumnOption($option, "amount");
            $this->createColumnOption($option, "status");
            $this->createColumnOption($option, "po_id");
            $this->createColumnOption($option, "remarks");
            $this->createColumnOption($option, "p_remarks");
            $this->createColumnOption($option, "operator");
            $this->createColumnOption($option, "datetime");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fproduct_cart_ssrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fproduct_cart_ssrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fproduct_cart_slist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_product_cart_s", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_product_cart_s",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // location
        if ($this->location->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->location->AdvancedSearch->SearchValue != "" || $this->location->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // company_id
        if ($this->company_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->company_id->AdvancedSearch->SearchValue != "" || $this->company_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // partner_id
        if ($this->partner_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->partner_id->AdvancedSearch->SearchValue != "" || $this->partner_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // partner_rid
        if ($this->partner_rid->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->partner_rid->AdvancedSearch->SearchValue != "" || $this->partner_rid->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // product_type
        if ($this->product_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->product_type->AdvancedSearch->SearchValue != "" || $this->product_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->grp->AdvancedSearch->SearchValue != "" || $this->grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // s_grp
        if ($this->s_grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->s_grp->AdvancedSearch->SearchValue != "" || $this->s_grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // product
        if ($this->product->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->product->AdvancedSearch->SearchValue != "" || $this->product->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // rid
        if ($this->rid->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->rid->AdvancedSearch->SearchValue != "" || $this->rid->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // packing_type
        if ($this->packing_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->packing_type->AdvancedSearch->SearchValue != "" || $this->packing_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // batch_no
        if ($this->batch_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->batch_no->AdvancedSearch->SearchValue != "" || $this->batch_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // shape
        if ($this->shape->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->shape->AdvancedSearch->SearchValue != "" || $this->shape->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // unit
        if ($this->unit->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->unit->AdvancedSearch->SearchValue != "" || $this->unit->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // w
        if ($this->w->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->w->AdvancedSearch->SearchValue != "" || $this->w->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // w_cm
        if ($this->w_cm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->w_cm->AdvancedSearch->SearchValue != "" || $this->w_cm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // l
        if ($this->l->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->l->AdvancedSearch->SearchValue != "" || $this->l->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // l_cm
        if ($this->l_cm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->l_cm->AdvancedSearch->SearchValue != "" || $this->l_cm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // h
        if ($this->h->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->h->AdvancedSearch->SearchValue != "" || $this->h->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // h_cm
        if ($this->h_cm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->h_cm->AdvancedSearch->SearchValue != "" || $this->h_cm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // partner_size
        if ($this->partner_size->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->partner_size->AdvancedSearch->SearchValue != "" || $this->partner_size->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // size
        if ($this->size->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->size->AdvancedSearch->SearchValue != "" || $this->size->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sqm
        if ($this->sqm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sqm->AdvancedSearch->SearchValue != "" || $this->sqm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->quantity->AdvancedSearch->SearchValue != "" || $this->quantity->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // price
        if ($this->price->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->price->AdvancedSearch->SearchValue != "" || $this->price->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // currency
        if ($this->currency->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->currency->AdvancedSearch->SearchValue != "" || $this->currency->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po_id
        if ($this->po_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po_id->AdvancedSearch->SearchValue != "" || $this->po_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cbm
        if ($this->cbm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cbm->AdvancedSearch->SearchValue != "" || $this->cbm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_uid
        if ($this->buyer_uid->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_uid->AdvancedSearch->SearchValue != "" || $this->buyer_uid->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // label
        if ($this->label->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->label->AdvancedSearch->SearchValue != "" || $this->label->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->remarks->AdvancedSearch->SearchValue != "" || $this->remarks->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // p_remarks
        if ($this->p_remarks->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->p_remarks->AdvancedSearch->SearchValue != "" || $this->p_remarks->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator->AdvancedSearch->SearchValue != "" || $this->operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime->AdvancedSearch->SearchValue != "" || $this->datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->location->setDbValue($row['location']);
        $this->company_id->setDbValue($row['company_id']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->partner_rid->setDbValue($row['partner_rid']);
        $this->product_type->setDbValue($row['product_type']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->shape->setDbValue($row['shape']);
        $this->unit->setDbValue($row['unit']);
        $this->w->setDbValue($row['w']);
        $this->w_cm->setDbValue($row['w_cm']);
        $this->l->setDbValue($row['l']);
        $this->l_cm->setDbValue($row['l_cm']);
        $this->h->setDbValue($row['h']);
        $this->h_cm->setDbValue($row['h_cm']);
        $this->partner_size->setDbValue($row['partner_size']);
        $this->size->setDbValue($row['size']);
        $this->sqm->setDbValue($row['sqm']);
        $this->quantity->setDbValue($row['quantity']);
        $this->price->setDbValue($row['price']);
        $this->currency->setDbValue($row['currency']);
        $this->amount->setDbValue($row['amount']);
        $this->status->setDbValue($row['status']);
        $this->cart_id->setDbValue($row['cart_id']);
        $this->po_id->setDbValue($row['po_id']);
        $this->rid_1->setDbValue($row['rid_1']);
        $this->hsn_code->setDbValue($row['hsn_code']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->pkt_quantity->setDbValue($row['pkt_quantity']);
        $this->multiprice_id->setDbValue($row['multiprice_id']);
        $this->discount_price->setDbValue($row['discount_price']);
        $this->cbm->setDbValue($row['cbm']);
        $this->tax->setDbValue($row['tax']);
        $this->tax_amount->setDbValue($row['tax_amount']);
        $this->shipping_method->setDbValue($row['shipping_method']);
        $this->shipping_local->setDbValue($row['shipping_local']);
        $this->shipping_abroad->setDbValue($row['shipping_abroad']);
        $this->shipping_charge->setDbValue($row['shipping_charge']);
        $this->additional_discount->setDbValue($row['additional_discount']);
        $this->total_amount->setDbValue($row['total_amount']);
        $this->buyer_uid->setDbValue($row['buyer_uid']);
        $this->label->setDbValue($row['label']);
        $this->remarks->setDbValue($row['remarks']);
        $this->p_remarks->setDbValue($row['p_remarks']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->o_datetime->setDbValue($row['o_datetime']);
        $this->cart_amount->setDbValue($row['cart_amount']);
        $this->c_total->setDbValue($row['c_total']);
        $this->_1->setDbValue($row['1']);
        $this->_2->setDbValue($row['2']);
        $this->_3->setDbValue($row['3']);
        $this->_4->setDbValue($row['4']);
        $this->_5->setDbValue($row['5']);
        $this->_6->setDbValue($row['6']);
        $this->_7->setDbValue($row['7']);
        $this->_8->setDbValue($row['8']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->r_text->setDbValue($row['r_text']);
        $this->t_id->setDbValue($row['t_id']);
        $this->_9->setDbValue($row['9']);
        $this->_10->setDbValue($row['10']);
        $this->_11->setDbValue($row['11']);
        $this->_12->setDbValue($row['12']);
        $this->sqm_u->setDbValue($row['sqm_u']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->buyer_loc->setDbValue($row['buyer_loc']);
        $this->p_id->setDbValue($row['p_id']);
        $this->partner_code->setDbValue($row['partner_code']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->partner_order_no->setDbValue($row['partner_order_no']);
        $this->p_qty->setDbValue($row['p_qty']);
        $this->product_code->setDbValue($row['product_code']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['partner_rid'] = $this->partner_rid->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['w'] = $this->w->DefaultValue;
        $row['w_cm'] = $this->w_cm->DefaultValue;
        $row['l'] = $this->l->DefaultValue;
        $row['l_cm'] = $this->l_cm->DefaultValue;
        $row['h'] = $this->h->DefaultValue;
        $row['h_cm'] = $this->h_cm->DefaultValue;
        $row['partner_size'] = $this->partner_size->DefaultValue;
        $row['size'] = $this->size->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['cart_id'] = $this->cart_id->DefaultValue;
        $row['po_id'] = $this->po_id->DefaultValue;
        $row['rid_1'] = $this->rid_1->DefaultValue;
        $row['hsn_code'] = $this->hsn_code->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['pkt_quantity'] = $this->pkt_quantity->DefaultValue;
        $row['multiprice_id'] = $this->multiprice_id->DefaultValue;
        $row['discount_price'] = $this->discount_price->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['tax'] = $this->tax->DefaultValue;
        $row['tax_amount'] = $this->tax_amount->DefaultValue;
        $row['shipping_method'] = $this->shipping_method->DefaultValue;
        $row['shipping_local'] = $this->shipping_local->DefaultValue;
        $row['shipping_abroad'] = $this->shipping_abroad->DefaultValue;
        $row['shipping_charge'] = $this->shipping_charge->DefaultValue;
        $row['additional_discount'] = $this->additional_discount->DefaultValue;
        $row['total_amount'] = $this->total_amount->DefaultValue;
        $row['buyer_uid'] = $this->buyer_uid->DefaultValue;
        $row['label'] = $this->label->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['p_remarks'] = $this->p_remarks->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['o_datetime'] = $this->o_datetime->DefaultValue;
        $row['cart_amount'] = $this->cart_amount->DefaultValue;
        $row['c_total'] = $this->c_total->DefaultValue;
        $row['1'] = $this->_1->DefaultValue;
        $row['2'] = $this->_2->DefaultValue;
        $row['3'] = $this->_3->DefaultValue;
        $row['4'] = $this->_4->DefaultValue;
        $row['5'] = $this->_5->DefaultValue;
        $row['6'] = $this->_6->DefaultValue;
        $row['7'] = $this->_7->DefaultValue;
        $row['8'] = $this->_8->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['r_text'] = $this->r_text->DefaultValue;
        $row['t_id'] = $this->t_id->DefaultValue;
        $row['9'] = $this->_9->DefaultValue;
        $row['10'] = $this->_10->DefaultValue;
        $row['11'] = $this->_11->DefaultValue;
        $row['12'] = $this->_12->DefaultValue;
        $row['sqm_u'] = $this->sqm_u->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['buyer_loc'] = $this->buyer_loc->DefaultValue;
        $row['p_id'] = $this->p_id->DefaultValue;
        $row['partner_code'] = $this->partner_code->DefaultValue;
        $row['q_sku'] = $this->q_sku->DefaultValue;
        $row['partner_order_no'] = $this->partner_order_no->DefaultValue;
        $row['p_qty'] = $this->p_qty->DefaultValue;
        $row['product_code'] = $this->product_code->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // location

        // company_id

        // partner_id

        // partner_rid

        // product_type

        // grp

        // s_grp

        // product

        // rid
        $this->rid->CellCssStyle = "white-space: nowrap;";

        // packing_type

        // batch_no

        // shape

        // unit

        // w

        // w_cm

        // l

        // l_cm

        // h

        // h_cm

        // partner_size

        // size

        // sqm

        // quantity

        // price

        // currency

        // amount
        $this->amount->CellCssStyle = "white-space: nowrap;";

        // status
        $this->status->CellCssStyle = "white-space: nowrap;";

        // cart_id
        $this->cart_id->CellCssStyle = "white-space: nowrap;";

        // po_id

        // rid_1
        $this->rid_1->CellCssStyle = "white-space: nowrap;";

        // hsn_code
        $this->hsn_code->CellCssStyle = "white-space: nowrap;";

        // despatch_date
        $this->despatch_date->CellCssStyle = "white-space: nowrap;";

        // pkt_quantity
        $this->pkt_quantity->CellCssStyle = "white-space: nowrap;";

        // multiprice_id
        $this->multiprice_id->CellCssStyle = "white-space: nowrap;";

        // discount_price
        $this->discount_price->CellCssStyle = "white-space: nowrap;";

        // cbm

        // tax
        $this->tax->CellCssStyle = "white-space: nowrap;";

        // tax_amount
        $this->tax_amount->CellCssStyle = "white-space: nowrap;";

        // shipping_method
        $this->shipping_method->CellCssStyle = "white-space: nowrap;";

        // shipping_local
        $this->shipping_local->CellCssStyle = "white-space: nowrap;";

        // shipping_abroad
        $this->shipping_abroad->CellCssStyle = "white-space: nowrap;";

        // shipping_charge
        $this->shipping_charge->CellCssStyle = "white-space: nowrap;";

        // additional_discount
        $this->additional_discount->CellCssStyle = "white-space: nowrap;";

        // total_amount
        $this->total_amount->CellCssStyle = "white-space: nowrap;";

        // buyer_uid

        // label

        // remarks

        // p_remarks

        // operator

        // datetime

        // o_datetime
        $this->o_datetime->CellCssStyle = "white-space: nowrap;";

        // cart_amount
        $this->cart_amount->CellCssStyle = "white-space: nowrap;";

        // c_total
        $this->c_total->CellCssStyle = "white-space: nowrap;";

        // 1
        $this->_1->CellCssStyle = "white-space: nowrap;";

        // 2
        $this->_2->CellCssStyle = "white-space: nowrap;";

        // 3
        $this->_3->CellCssStyle = "white-space: nowrap;";

        // 4
        $this->_4->CellCssStyle = "white-space: nowrap;";

        // 5
        $this->_5->CellCssStyle = "white-space: nowrap;";

        // 6
        $this->_6->CellCssStyle = "white-space: nowrap;";

        // 7
        $this->_7->CellCssStyle = "white-space: nowrap;";

        // 8
        $this->_8->CellCssStyle = "white-space: nowrap;";

        // image
        $this->image->CellCssStyle = "white-space: nowrap;";

        // r_text
        $this->r_text->CellCssStyle = "white-space: nowrap;";

        // t_id
        $this->t_id->CellCssStyle = "white-space: nowrap;";

        // 9
        $this->_9->CellCssStyle = "white-space: nowrap;";

        // 10
        $this->_10->CellCssStyle = "white-space: nowrap;";

        // 11
        $this->_11->CellCssStyle = "white-space: nowrap;";

        // 12
        $this->_12->CellCssStyle = "white-space: nowrap;";

        // sqm_u
        $this->sqm_u->CellCssStyle = "white-space: nowrap;";

        // reports_to
        $this->reports_to->CellCssStyle = "white-space: nowrap;";

        // buyer_loc
        $this->buyer_loc->CellCssStyle = "white-space: nowrap;";

        // p_id
        $this->p_id->CellCssStyle = "white-space: nowrap;";

        // partner_code
        $this->partner_code->CellCssStyle = "white-space: nowrap;";

        // q_sku
        $this->q_sku->CellCssStyle = "white-space: nowrap;";

        // partner_order_no
        $this->partner_order_no->CellCssStyle = "white-space: nowrap;";

        // p_qty
        $this->p_qty->CellCssStyle = "white-space: nowrap;";

        // product_code
        $this->product_code->CellCssStyle = "white-space: nowrap;";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                        $this->location->ViewValue = $this->location->displayValue($arwrk);
                    } else {
                        $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // partner_rid
            $this->partner_rid->ViewValue = $this->partner_rid->CurrentValue;
            $curVal = strval($this->partner_rid->CurrentValue);
            if ($curVal != "") {
                $this->partner_rid->ViewValue = $this->partner_rid->lookupCacheOption($curVal);
                if ($this->partner_rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_rid->ViewValue = $this->partner_rid->displayValue($arwrk);
                    } else {
                        $this->partner_rid->ViewValue = $this->partner_rid->CurrentValue;
                    }
                }
            } else {
                $this->partner_rid->ViewValue = null;
            }

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                        $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                    } else {
                        $this->product_type->ViewValue = FormatNumber($this->product_type->CurrentValue, $this->product_type->formatPattern());
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // grp
            $this->grp->ViewValue = $this->grp->CurrentValue;
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // batch_no
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                        $this->shape->ViewValue = $this->shape->displayValue($arwrk);
                    } else {
                        $this->shape->ViewValue = FormatNumber($this->shape->CurrentValue, $this->shape->formatPattern());
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // unit
            $curVal = strval($this->unit->CurrentValue);
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
                if ($this->unit->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                        $this->unit->ViewValue = $this->unit->displayValue($arwrk);
                    } else {
                        $this->unit->ViewValue = FormatNumber($this->unit->CurrentValue, $this->unit->formatPattern());
                    }
                }
            } else {
                $this->unit->ViewValue = null;
            }

            // w
            $this->w->ViewValue = $this->w->CurrentValue;

            // w_cm
            $this->w_cm->ViewValue = $this->w_cm->CurrentValue;
            $this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, $this->w_cm->formatPattern());

            // l
            $this->l->ViewValue = $this->l->CurrentValue;

            // l_cm
            $this->l_cm->ViewValue = $this->l_cm->CurrentValue;
            $this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, $this->l_cm->formatPattern());

            // h
            $this->h->ViewValue = $this->h->CurrentValue;

            // h_cm
            $this->h_cm->ViewValue = $this->h_cm->CurrentValue;
            $this->h_cm->ViewValue = FormatNumber($this->h_cm->ViewValue, $this->h_cm->formatPattern());

            // partner_size
            $this->partner_size->ViewValue = $this->partner_size->CurrentValue;

            // size
            $this->size->ViewValue = $this->size->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // po_id
            $this->po_id->ViewValue = $this->po_id->CurrentValue;
            $curVal = strval($this->po_id->CurrentValue);
            if ($curVal != "") {
                $this->po_id->ViewValue = $this->po_id->lookupCacheOption($curVal);
                if ($this->po_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_id->Lookup->renderViewRow($rswrk[0]);
                        $this->po_id->ViewValue = $this->po_id->displayValue($arwrk);
                    } else {
                        $this->po_id->ViewValue = FormatNumber($this->po_id->CurrentValue, $this->po_id->formatPattern());
                    }
                }
            } else {
                $this->po_id->ViewValue = null;
            }

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // label
            $this->label->ViewValue = $this->label->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // p_remarks
            $this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->id->ViewValue = $this->highlightValue($this->id);
            }

            // location
            $this->location->HrefValue = "";
            $this->location->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";
            $this->partner_id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->partner_id->ViewValue = $this->highlightValue($this->partner_id);
            }

            // partner_rid
            $this->partner_rid->HrefValue = "";
            $this->partner_rid->TooltipValue = "";
            if (!$this->isExport()) {
                $this->partner_rid->ViewValue = $this->highlightValue($this->partner_rid);
            }

            // product_type
            $this->product_type->HrefValue = "";
            $this->product_type->TooltipValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }
            $this->grp->TooltipValue = "";
            if (!$this->isExport()) {
                $this->grp->ViewValue = $this->highlightValue($this->grp);
            }

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }
            $this->s_grp->TooltipValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }
            $this->product->TooltipValue = "";

            // rid
            $this->rid->HrefValue = "";
            $this->rid->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";
            $this->batch_no->TooltipValue = "";

            // shape
            $this->shape->HrefValue = "";
            $this->shape->TooltipValue = "";

            // unit
            if (!EmptyValue($this->unit->CurrentValue)) {
                $this->unit->HrefValue = $this->unit->getLinkPrefix() . $this->unit->CurrentValue; // Add prefix/suffix
                $this->unit->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
                }
            } else {
                $this->unit->HrefValue = "";
            }
            $this->unit->TooltipValue = "";

            // w
            $this->w->HrefValue = "";
            $this->w->TooltipValue = "";
            if (!$this->isExport()) {
                $this->w->ViewValue = $this->highlightValue($this->w);
            }

            // w_cm
            $this->w_cm->HrefValue = "";
            $this->w_cm->TooltipValue = "";

            // l
            $this->l->HrefValue = "";
            $this->l->TooltipValue = "";
            if (!$this->isExport()) {
                $this->l->ViewValue = $this->highlightValue($this->l);
            }

            // l_cm
            $this->l_cm->HrefValue = "";
            $this->l_cm->TooltipValue = "";

            // h
            $this->h->HrefValue = "";
            $this->h->TooltipValue = "";
            if (!$this->isExport()) {
                $this->h->ViewValue = $this->highlightValue($this->h);
            }

            // h_cm
            $this->h_cm->HrefValue = "";
            $this->h_cm->TooltipValue = "";

            // partner_size
            $this->partner_size->HrefValue = "";
            $this->partner_size->TooltipValue = "";
            if (!$this->isExport()) {
                $this->partner_size->ViewValue = $this->highlightValue($this->partner_size);
            }

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // price
            $this->price->HrefValue = "";
            $this->price->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // po_id
            $this->po_id->HrefValue = "";
            $this->po_id->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";
            if (!$this->isExport()) {
                $this->remarks->ViewValue = $this->highlightValue($this->remarks);
            }

            // p_remarks
            $this->p_remarks->HrefValue = "";
            $this->p_remarks->TooltipValue = "";
            if (!$this->isExport()) {
                $this->p_remarks->ViewValue = $this->highlightValue($this->p_remarks);
            }

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
            if (!$this->isExport()) {
                $this->datetime->ViewValue = $this->highlightValue($this->datetime);
            }
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // location
            $this->location->setupEditAttributes();
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $this->company_id->EditValue = $this->company_id->AdvancedSearch->SearchValue;
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // partner_id
            $this->partner_id->setupEditAttributes();
            $this->partner_id->EditValue = $this->partner_id->AdvancedSearch->SearchValue;
            $curVal = strval($this->partner_id->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->EditValue = HtmlEncode($this->partner_id->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->partner_id->EditValue = null;
            }
            $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

            // partner_rid
            $this->partner_rid->setupEditAttributes();
            if (!$this->partner_rid->Raw) {
                $this->partner_rid->AdvancedSearch->SearchValue = HtmlDecode($this->partner_rid->AdvancedSearch->SearchValue);
            }
            $this->partner_rid->EditValue = HtmlEncode($this->partner_rid->AdvancedSearch->SearchValue);
            $this->partner_rid->PlaceHolder = RemoveHtml($this->partner_rid->caption());

            // product_type
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

            // grp
            $this->grp->setupEditAttributes();
            $this->grp->EditValue = $this->grp->AdvancedSearch->SearchValue;
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid
            $curVal = trim(strval($this->rid->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->rid->AdvancedSearch->ViewValue = $this->rid->lookupCacheOption($curVal);
            } else {
                $this->rid->AdvancedSearch->ViewValue = $this->rid->Lookup !== null && is_array($this->rid->lookupOptions()) && count($this->rid->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->rid->EditValue = array_values($this->rid->lookupOptions());
                if ($this->rid->AdvancedSearch->ViewValue == "") {
                    $this->rid->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid->AdvancedSearch->SearchValue, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                    $this->rid->AdvancedSearch->ViewValue = $this->rid->displayValue($arwrk);
                } else {
                    $this->rid->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->rid->EditValue = $arwrk;
            }
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());
            $curVal = trim(strval($this->rid->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->rid->AdvancedSearch->ViewValue2 = $this->rid->lookupCacheOption($curVal);
            } else {
                $this->rid->AdvancedSearch->ViewValue2 = $this->rid->Lookup !== null && is_array($this->rid->lookupOptions()) && count($this->rid->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->rid->EditValue2 = array_values($this->rid->lookupOptions());
                if ($this->rid->AdvancedSearch->ViewValue2 == "") {
                    $this->rid->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid->AdvancedSearch->SearchValue2, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                    $this->rid->AdvancedSearch->ViewValue2 = $this->rid->displayValue($arwrk);
                } else {
                    $this->rid->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->rid->EditValue2 = $arwrk;
            }
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // batch_no
            $this->batch_no->setupEditAttributes();
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // shape
            $this->shape->setupEditAttributes();
            $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

            // unit
            $this->unit->setupEditAttributes();
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

            // w
            $this->w->setupEditAttributes();
            if (!$this->w->Raw) {
                $this->w->AdvancedSearch->SearchValue = HtmlDecode($this->w->AdvancedSearch->SearchValue);
            }
            $this->w->EditValue = HtmlEncode($this->w->AdvancedSearch->SearchValue);
            $this->w->PlaceHolder = RemoveHtml($this->w->caption());

            // w_cm
            $this->w_cm->setupEditAttributes();
            $this->w_cm->EditCustomAttributes = $this->w_cm->getEditCustomAttributes(); // PHP
            $this->w_cm->EditValue = $this->w_cm->AdvancedSearch->SearchValue;
            $this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());

            // l
            $this->l->setupEditAttributes();
            if (!$this->l->Raw) {
                $this->l->AdvancedSearch->SearchValue = HtmlDecode($this->l->AdvancedSearch->SearchValue);
            }
            $this->l->EditValue = HtmlEncode($this->l->AdvancedSearch->SearchValue);
            $this->l->PlaceHolder = RemoveHtml($this->l->caption());

            // l_cm
            $this->l_cm->setupEditAttributes();
            $this->l_cm->EditCustomAttributes = $this->l_cm->getEditCustomAttributes(); // PHP
            $this->l_cm->EditValue = $this->l_cm->AdvancedSearch->SearchValue;
            $this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());

            // h
            $this->h->setupEditAttributes();
            if (!$this->h->Raw) {
                $this->h->AdvancedSearch->SearchValue = HtmlDecode($this->h->AdvancedSearch->SearchValue);
            }
            $this->h->EditValue = HtmlEncode($this->h->AdvancedSearch->SearchValue);
            $this->h->PlaceHolder = RemoveHtml($this->h->caption());

            // h_cm
            $this->h_cm->setupEditAttributes();
            $this->h_cm->EditCustomAttributes = $this->h_cm->getEditCustomAttributes(); // PHP
            $this->h_cm->EditValue = $this->h_cm->AdvancedSearch->SearchValue;
            $this->h_cm->PlaceHolder = RemoveHtml($this->h_cm->caption());

            // partner_size
            $this->partner_size->setupEditAttributes();
            if (!$this->partner_size->Raw) {
                $this->partner_size->AdvancedSearch->SearchValue = HtmlDecode($this->partner_size->AdvancedSearch->SearchValue);
            }
            $this->partner_size->EditValue = HtmlEncode($this->partner_size->AdvancedSearch->SearchValue);
            $this->partner_size->PlaceHolder = RemoveHtml($this->partner_size->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->AdvancedSearch->SearchValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

            // price
            $this->price->setupEditAttributes();
            $this->price->EditValue = $this->price->AdvancedSearch->SearchValue;
            $this->price->PlaceHolder = RemoveHtml($this->price->caption());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditCustomAttributes = $this->amount->getEditCustomAttributes(); // PHP
            $this->amount->EditValue = $this->amount->AdvancedSearch->SearchValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // po_id
            $this->po_id->setupEditAttributes();
            $this->po_id->EditValue = $this->po_id->AdvancedSearch->SearchValue;
            $curVal = strval($this->po_id->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->po_id->EditValue = $this->po_id->lookupCacheOption($curVal);
                if ($this->po_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_id->Lookup->renderViewRow($rswrk[0]);
                        $this->po_id->EditValue = $this->po_id->displayValue($arwrk);
                    } else {
                        $this->po_id->EditValue = HtmlEncode(FormatNumber($this->po_id->AdvancedSearch->SearchValue, $this->po_id->formatPattern()));
                    }
                }
            } else {
                $this->po_id->EditValue = null;
            }
            $this->po_id->PlaceHolder = RemoveHtml($this->po_id->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // p_remarks
            $this->p_remarks->setupEditAttributes();
            if (!$this->p_remarks->Raw) {
                $this->p_remarks->AdvancedSearch->SearchValue = HtmlDecode($this->p_remarks->AdvancedSearch->SearchValue);
            }
            $this->p_remarks->EditValue = HtmlEncode($this->p_remarks->AdvancedSearch->SearchValue);
            $this->p_remarks->PlaceHolder = RemoveHtml($this->p_remarks->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->po_id->AdvancedSearch->SearchValue)) {
            $this->po_id->addErrorMessage($this->po_id->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->location->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->partner_id->AdvancedSearch->load();
        $this->partner_rid->AdvancedSearch->load();
        $this->product_type->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->rid->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->batch_no->AdvancedSearch->load();
        $this->shape->AdvancedSearch->load();
        $this->unit->AdvancedSearch->load();
        $this->w->AdvancedSearch->load();
        $this->w_cm->AdvancedSearch->load();
        $this->l->AdvancedSearch->load();
        $this->l_cm->AdvancedSearch->load();
        $this->h->AdvancedSearch->load();
        $this->h_cm->AdvancedSearch->load();
        $this->partner_size->AdvancedSearch->load();
        $this->size->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->price->AdvancedSearch->load();
        $this->currency->AdvancedSearch->load();
        $this->po_id->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->buyer_uid->AdvancedSearch->load();
        $this->label->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->p_remarks->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Build export filter for selected records
    protected function buildExportSelectedFilter()
    {
        global $Language;
        $wrkFilter = "";
        if ($this->isExport()) {
            $wrkFilter = $this->getFilterFromRecordKeys();
        }
        return $wrkFilter;
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fproduct_cart_slist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fproduct_cart_slist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToExcel") . "</button>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fproduct_cart_slist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fproduct_cart_slist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToWord") . "</button>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fproduct_cart_slist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fproduct_cart_slist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToPdf") . "</button>";
            }
        } elseif (SameText($type, "html")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" form=\"fproduct_cart_slist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"html\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToHtml") . "</button>";
        } elseif (SameText($type, "xml")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" form=\"fproduct_cart_slist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"xml\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToXml") . "</button>";
        } elseif (SameText($type, "csv")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" form=\"fproduct_cart_slist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"csv\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToCsv") . "</button>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fproduct_cart_slist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="true"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" form=\"fproduct_cart_slist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"print\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("PrinterFriendly") . "</button>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fproduct_cart_ssrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"product_cart_s\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"productcartssearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"productcartssearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"fproduct_cart_ssrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Export master record
        if (Config("EXPORT_MASTER_RECORD") && $this->DbMasterFilter != "" && $this->getCurrentMasterTable() == "material_status") {
            $material_status = new MaterialStatusList();
            $rsmaster = $material_status->loadRs($this->DbMasterFilter); // Load master record
            if ($rsmaster) {
                $exportStyle = $doc->Style;
                $doc->setStyle("v"); // Change to vertical
                if (!$this->isExport("csv") || Config("EXPORT_MASTER_RECORD_FOR_CSV")) {
                    $doc->setTable($material_status);
                    $material_status->exportDocument($doc, $rsmaster);
                    $doc->exportEmptyRow();
                    $doc->setTable($this);
                }
                $doc->setStyle($exportStyle); // Restore
            }
        }

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "material_status") {
                $validMaster = true;
                $masterTbl = Container("material_status");
                if (($parm = Get("fk_id", Get("rid"))) !== null) {
                    $masterTbl->id->setQueryStringValue($parm);
                    $this->rid->QueryStringValue = $masterTbl->id->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->rid->setSessionValue($this->rid->QueryStringValue);
                    $foreignKeys["rid"] = $this->rid->QueryStringValue;
                    if (!is_numeric($masterTbl->id->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "material_status") {
                $validMaster = true;
                $masterTbl = Container("material_status");
                if (($parm = Post("fk_id", Post("rid"))) !== null) {
                    $masterTbl->id->setFormValue($parm);
                    $this->rid->FormValue = $masterTbl->id->FormValue;
                    $this->rid->setSessionValue($this->rid->FormValue);
                    $foreignKeys["rid"] = $this->rid->FormValue;
                    if (!is_numeric($masterTbl->id->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);

            // Update URL
            $this->AddUrl = $this->addMasterUrl($this->AddUrl);
            $this->InlineAddUrl = $this->addMasterUrl($this->InlineAddUrl);
            $this->GridAddUrl = $this->addMasterUrl($this->GridAddUrl);
            $this->GridEditUrl = $this->addMasterUrl($this->GridEditUrl);
            $this->MultiEditUrl = $this->addMasterUrl($this->MultiEditUrl);

            // Set up Breadcrumb
            if (!$this->isExport()) {
                $this->setupBreadcrumb(); // Set up breadcrumb again for the master table
            }

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "material_status") {
                if (!array_key_exists("rid", $foreignKeys)) { // Not current foreign key
                    $this->rid->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_batch_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_unit":
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_po_id":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'product_cart_s');
    	$item = &$this->OtherOptions['action']->Add("Create Order");
    	$item->Body = "<button class=\"btn btn-danger ew-action\" onclick=\"javascript:CreateOrder()\">Create Order From Selected</button>";
    	$item->Visible = True;
    	$this->sqm->ReadOnly = True;
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered() {
    	// Example:
    	if (($this->po_id->CurrentValue == 0) && ($this->status->CurrentValue == 0))
    		{
    			$this->ListOptions->Add("Create Order"); 
    			$this->ListOptions->Items["Create Order"]->Body = '<a href="posadd?CID=' . $this->company_id->CurrentValue . '&PID=' . $this->partner_id->CurrentValue . '&CAID=' .  $this->id->CurrentValue . '" data-bs-original-title ="Create Order"><i data-phrase="Create Order"  class="fa fa-sign-out fa-2x ew-icon" ></i></a>';
    		}
    	if ($this->status->CurrentValue == 0)
    	{
    		$this->ListOptions->Items['edit']->Visible=True;
    		$this->ListOptions->Items['delete']->Visible=True;
    		$this->ListOptions->Items['Create Order']->Visible=True;
    	} 
    	else if ($this->status->CurrentValue == 1)
    	{
    		$this->ListOptions->Items['checkbox']->Body='<i class="fa fa-hand-paper-o fa-lg"></i>';
    	}
    	else if ($this->status->CurrentValue > 2)
    	{
    		$this->ListOptions->Items['edit']->Visible=False;
    		$this->ListOptions->Items['delete']->Visible=False;
    		$this->ListOptions->Items['Create Order']->Visible=False;
    		$this->ListOptions->Items['checkbox']->Body='<i class="fa fa-hand-paper-o fa-2x"></i>';
    	}
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
