<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductCartSGrid extends ProductCartS
{
    use MessagesTrait;

    // Page ID
    public $PageID = "grid";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductCartSGrid";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fproduct_cart_sgrid";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "productcartsgrid";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->location->setVisibility();
        $this->company_id->setVisibility();
        $this->partner_id->setVisibility();
        $this->partner_rid->setVisibility();
        $this->product_type->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->packing_type->setVisibility();
        $this->batch_no->setVisibility();
        $this->shape->setVisibility();
        $this->unit->setVisibility();
        $this->w->setVisibility();
        $this->w_cm->setVisibility();
        $this->l->setVisibility();
        $this->l_cm->setVisibility();
        $this->h->setVisibility();
        $this->h_cm->setVisibility();
        $this->partner_size->setVisibility();
        $this->size->Visible = false;
        $this->sqm->Visible = false;
        $this->quantity->setVisibility();
        $this->price->setVisibility();
        $this->currency->Visible = false;
        $this->amount->setVisibility();
        $this->status->setVisibility();
        $this->cart_id->Visible = false;
        $this->po_id->setVisibility();
        $this->rid_1->Visible = false;
        $this->hsn_code->Visible = false;
        $this->despatch_date->Visible = false;
        $this->pkt_quantity->Visible = false;
        $this->multiprice_id->Visible = false;
        $this->discount_price->Visible = false;
        $this->cbm->Visible = false;
        $this->tax->Visible = false;
        $this->tax_amount->Visible = false;
        $this->shipping_method->Visible = false;
        $this->shipping_local->Visible = false;
        $this->shipping_abroad->Visible = false;
        $this->shipping_charge->Visible = false;
        $this->additional_discount->Visible = false;
        $this->total_amount->Visible = false;
        $this->buyer_uid->Visible = false;
        $this->label->Visible = false;
        $this->remarks->setVisibility();
        $this->p_remarks->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->o_datetime->Visible = false;
        $this->cart_amount->Visible = false;
        $this->c_total->Visible = false;
        $this->_1->Visible = false;
        $this->_2->Visible = false;
        $this->_3->Visible = false;
        $this->_4->Visible = false;
        $this->_5->Visible = false;
        $this->_6->Visible = false;
        $this->_7->Visible = false;
        $this->_8->Visible = false;
        $this->image->Visible = false;
        $this->r_text->Visible = false;
        $this->t_id->Visible = false;
        $this->_9->Visible = false;
        $this->_10->Visible = false;
        $this->_11->Visible = false;
        $this->_12->Visible = false;
        $this->sqm_u->Visible = false;
        $this->reports_to->Visible = false;
        $this->buyer_loc->Visible = false;
        $this->p_id->Visible = false;
        $this->partner_code->Visible = false;
        $this->q_sku->Visible = false;
        $this->partner_order_no->Visible = false;
        $this->p_qty->Visible = false;
        $this->product_code->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'product_cart_s';
        $this->TableName = 'product_cart_s';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $this->FormActionName .= "_" . $this->FormName;
        $this->OldKeyName .= "_" . $this->FormName;
        $this->FormBlankRowName .= "_" . $this->FormName;
        $this->FormKeyCountName .= "_" . $this->FormName;
        $GLOBALS["Grid"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (product_cart_s)
        if (!isset($GLOBALS["product_cart_s"]) || $GLOBALS["product_cart_s"]::class == PROJECT_NAMESPACE . "product_cart_s") {
            $GLOBALS["product_cart_s"] = &$this;
        }
        $this->AddUrl = "productcartsadd";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_cart_s');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;
        unset($GLOBALS["Grid"]);
        if ($url === "") {
            return;
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $ShowOtherOptions = false;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "20,50,100,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        if (Param("export") !== null) {
            $this->Export = Param("export");
        }

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up master detail parameters
        $this->setupMasterParms();

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->partner_rid);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->po_id);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fproduct_cart_sgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Show grid delete link for grid add / grid edit
        if ($this->AllowAddDeleteRow) {
            if ($this->isGridAdd() || $this->isGridEdit()) {
                $item = $this->ListOptions["griddelete"];
                if ($item) {
                    $item->Visible = $Security->allowDelete(CurrentProjectID() . $this->TableName);
                }
            }
        }

        // Set up sorting order
        $this->setupSortOrder();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }

        // Restore master/detail filter from session
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Restore master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Restore detail filter from session
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Load master record
        if ($this->CurrentMode != "add" && $this->DbMasterFilter != "" && $this->getCurrentMasterTable() == "material_status") {
            $masterTbl = Container("material_status");
            $rsmaster = $masterTbl->loadRs($this->DbMasterFilter)->fetchAssociative();
            $this->MasterRecordExists = $rsmaster !== false;
            if (!$this->MasterRecordExists) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
                $this->terminate("materialstatuslist"); // Return to master page
                return;
            } else {
                $masterTbl->loadListRowValues($rsmaster);
                $masterTbl->RowType = RowType::MASTER; // Master row
                $masterTbl->renderListRow();
            }
        }

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            if ($this->CurrentMode == "copy") {
                $this->TotalRecords = $this->listRecordCount();
                $this->StartRecord = 1;
                $this->DisplayRecords = $this->TotalRecords;
                $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);
            } else {
                $this->CurrentFilter = "0=1";
                $this->StartRecord = 1;
                $this->DisplayRecords = $this->GridAddRowCount;
            }
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->TotalRecords; // Display all records
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Exit inline mode
    protected function clearInlineMode()
    {
        $this->w_cm->FormValue = ""; // Clear form value
        $this->l_cm->FormValue = ""; // Clear form value
        $this->h_cm->FormValue = ""; // Clear form value
        $this->quantity->FormValue = ""; // Clear form value
        $this->price->FormValue = ""; // Clear form value
        $this->amount->FormValue = ""; // Clear form value
        $this->LastAction = $this->CurrentAction; // Save last action
        $this->CurrentAction = ""; // Clear action
        $_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
    }

    // Switch to grid add mode
    protected function gridAddMode()
    {
        $this->CurrentAction = "gridadd";
        $_SESSION[SESSION_INLINE_MODE] = "gridadd";
        $this->hideFieldsForAddEdit();
    }

    // Switch to grid edit mode
    protected function gridEditMode()
    {
        $this->CurrentAction = "gridedit";
        $_SESSION[SESSION_INLINE_MODE] = "gridedit";
        $this->hideFieldsForAddEdit();
    }

    // Perform update to grid
    public function gridUpdate()
    {
        global $Language, $CurrentForm;
        $gridUpdate = true;

        // Get old result set
        $this->CurrentFilter = $this->buildKeyFilter();
        if ($this->CurrentFilter == "") {
            $this->CurrentFilter = "0=1";
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        if ($rs = $conn->executeQuery($sql)) {
            $rsold = $rs->fetchAllAssociative();
        }

        // Call Grid Updating event
        if (!$this->gridUpdating($rsold)) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }
        $this->loadDefaultValues();
        if ($this->AuditTrailOnEdit) {
            $this->writeAuditTrailDummy($Language->phrase("BatchUpdateBegin")); // Batch update begin
        }
        $wrkfilter = "";
        $key = "";

        // Update row index and get row key
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Update all rows based on key
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            $CurrentForm->Index = $rowindex;
            $this->setKey($CurrentForm->getValue($this->OldKeyName));
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));

            // Load all values and keys
            if ($rowaction != "insertdelete" && $rowaction != "hide") { // Skip insert then deleted rows / hidden rows for grid edit
                $this->loadFormValues(); // Get form values
                if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
                    $gridUpdate = $this->OldKey != ""; // Key must not be empty
                } else {
                    $gridUpdate = true;
                }

                // Skip empty row
                if ($rowaction == "insert" && $this->emptyRow()) {
                // Validate form and insert/update/delete record
                } elseif ($gridUpdate) {
                    if ($rowaction == "delete") {
                        $this->CurrentFilter = $this->getRecordFilter();
                        $gridUpdate = $this->deleteRows(); // Delete this row
                    } else {
                        if ($rowaction == "insert") {
                            $gridUpdate = $this->addRow(); // Insert this row
                        } else {
                            if ($this->OldKey != "") {
                                $this->SendEmail = false; // Do not send email on update success
                                $gridUpdate = $this->editRow(); // Update this row
                            }
                        } // End update
                        if ($gridUpdate) { // Get inserted or updated filter
                            AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                        }
                    }
                }
                if ($gridUpdate) {
                    if ($key != "") {
                        $key .= ", ";
                    }
                    $key .= $this->OldKey;
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($gridUpdate) {
            $this->FilterForModalActions = $wrkfilter;

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Updated event
            $this->gridUpdated($rsold, $rsnew);
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateSuccess")); // Batch update success
            }
            $this->clearInlineMode(); // Clear inline edit mode
        } else {
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateRollback")); // Batch update rollback
            }
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
            }
        }
        return $gridUpdate;
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Perform grid add
    public function gridInsert()
    {
        global $Language, $CurrentForm;
        $rowindex = 1;
        $gridInsert = false;
        $conn = $this->getConnection();

        // Call Grid Inserting event
        if (!$this->gridInserting()) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridAddCancelled")); // Set grid add cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }
        $this->loadDefaultValues();

        // Init key filter
        $wrkfilter = "";
        $addcnt = 0;
        if ($this->AuditTrailOnAdd) {
            $this->writeAuditTrailDummy($Language->phrase("BatchInsertBegin")); // Batch insert begin
        }
        $key = "";

        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Insert all rows
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "" && $rowaction != "insert") {
                continue; // Skip
            }
            $rsold = null;
            if ($rowaction == "insert") {
                $this->OldKey = strval($CurrentForm->getValue($this->OldKeyName));
                $rsold = $this->loadOldRecord(); // Load old record
            }
            $this->loadFormValues(); // Get form values
            if (!$this->emptyRow()) {
                $addcnt++;
                $this->SendEmail = false; // Do not send email on insert success
                $gridInsert = $this->addRow($rsold); // Insert row (already validated by validateGridForm())
                if ($gridInsert) {
                    if ($key != "") {
                        $key .= Config("COMPOSITE_KEY_SEPARATOR");
                    }
                    $key .= $this->id->CurrentValue;

                    // Add filter for this record
                    AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($addcnt == 0) { // No record inserted
            $this->clearInlineMode(); // Clear grid add mode and return
            return true;
        }
        if ($gridInsert) {
            // Get new records
            $this->CurrentFilter = $wrkfilter;
            $this->FilterForModalActions = $wrkfilter;
            $sql = $this->getCurrentSql();
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Inserted event
            $this->gridInserted($rsnew);
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailDummy($Language->phrase("BatchInsertSuccess")); // Batch insert success
            }
            $this->clearInlineMode(); // Clear grid add mode
        } else {
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailDummy($Language->phrase("BatchInsertRollback")); // Batch insert rollback
            }
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("InsertFailed")); // Set insert failed message
            }
        }
        return $gridInsert;
    }

    // Check if empty row
    public function emptyRow()
    {
        global $CurrentForm;
        if (
            $CurrentForm->hasValue("x_location") &&
            $CurrentForm->hasValue("o_location") &&
            $this->location->CurrentValue != $this->location->DefaultValue &&
            !($this->location->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->location->CurrentValue == $this->location->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_company_id") &&
            $CurrentForm->hasValue("o_company_id") &&
            $this->company_id->CurrentValue != $this->company_id->DefaultValue &&
            !($this->company_id->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->company_id->CurrentValue == $this->company_id->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_partner_id") &&
            $CurrentForm->hasValue("o_partner_id") &&
            $this->partner_id->CurrentValue != $this->partner_id->DefaultValue &&
            !($this->partner_id->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->partner_id->CurrentValue == $this->partner_id->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_partner_rid") &&
            $CurrentForm->hasValue("o_partner_rid") &&
            $this->partner_rid->CurrentValue != $this->partner_rid->DefaultValue &&
            !($this->partner_rid->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->partner_rid->CurrentValue == $this->partner_rid->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_product_type") &&
            $CurrentForm->hasValue("o_product_type") &&
            $this->product_type->CurrentValue != $this->product_type->DefaultValue &&
            !($this->product_type->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->product_type->CurrentValue == $this->product_type->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_grp") &&
            $CurrentForm->hasValue("o_grp") &&
            $this->grp->CurrentValue != $this->grp->DefaultValue &&
            !($this->grp->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->grp->CurrentValue == $this->grp->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_s_grp") &&
            $CurrentForm->hasValue("o_s_grp") &&
            $this->s_grp->CurrentValue != $this->s_grp->DefaultValue &&
            !($this->s_grp->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->s_grp->CurrentValue == $this->s_grp->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_product") &&
            $CurrentForm->hasValue("o_product") &&
            $this->product->CurrentValue != $this->product->DefaultValue &&
            !($this->product->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->product->CurrentValue == $this->product->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_rid") &&
            $CurrentForm->hasValue("o_rid") &&
            $this->rid->CurrentValue != $this->rid->DefaultValue &&
            !($this->rid->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->rid->CurrentValue == $this->rid->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_packing_type") &&
            $CurrentForm->hasValue("o_packing_type") &&
            $this->packing_type->CurrentValue != $this->packing_type->DefaultValue &&
            !($this->packing_type->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->packing_type->CurrentValue == $this->packing_type->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_batch_no") &&
            $CurrentForm->hasValue("o_batch_no") &&
            $this->batch_no->CurrentValue != $this->batch_no->DefaultValue &&
            !($this->batch_no->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->batch_no->CurrentValue == $this->batch_no->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_shape") &&
            $CurrentForm->hasValue("o_shape") &&
            $this->shape->CurrentValue != $this->shape->DefaultValue &&
            !($this->shape->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->shape->CurrentValue == $this->shape->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_unit") &&
            $CurrentForm->hasValue("o_unit") &&
            $this->unit->CurrentValue != $this->unit->DefaultValue &&
            !($this->unit->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->unit->CurrentValue == $this->unit->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_w") &&
            $CurrentForm->hasValue("o_w") &&
            $this->w->CurrentValue != $this->w->DefaultValue &&
            !($this->w->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->w->CurrentValue == $this->w->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_w_cm") &&
            $CurrentForm->hasValue("o_w_cm") &&
            $this->w_cm->CurrentValue != $this->w_cm->DefaultValue &&
            !($this->w_cm->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->w_cm->CurrentValue == $this->w_cm->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_l") &&
            $CurrentForm->hasValue("o_l") &&
            $this->l->CurrentValue != $this->l->DefaultValue &&
            !($this->l->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->l->CurrentValue == $this->l->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_l_cm") &&
            $CurrentForm->hasValue("o_l_cm") &&
            $this->l_cm->CurrentValue != $this->l_cm->DefaultValue &&
            !($this->l_cm->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->l_cm->CurrentValue == $this->l_cm->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_h") &&
            $CurrentForm->hasValue("o_h") &&
            $this->h->CurrentValue != $this->h->DefaultValue &&
            !($this->h->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->h->CurrentValue == $this->h->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_h_cm") &&
            $CurrentForm->hasValue("o_h_cm") &&
            $this->h_cm->CurrentValue != $this->h_cm->DefaultValue &&
            !($this->h_cm->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->h_cm->CurrentValue == $this->h_cm->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_partner_size") &&
            $CurrentForm->hasValue("o_partner_size") &&
            $this->partner_size->CurrentValue != $this->partner_size->DefaultValue &&
            !($this->partner_size->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->partner_size->CurrentValue == $this->partner_size->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_quantity") &&
            $CurrentForm->hasValue("o_quantity") &&
            $this->quantity->CurrentValue != $this->quantity->DefaultValue &&
            !($this->quantity->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->quantity->CurrentValue == $this->quantity->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_price") &&
            $CurrentForm->hasValue("o_price") &&
            $this->price->CurrentValue != $this->price->DefaultValue &&
            !($this->price->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->price->CurrentValue == $this->price->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_amount") &&
            $CurrentForm->hasValue("o_amount") &&
            $this->amount->CurrentValue != $this->amount->DefaultValue &&
            !($this->amount->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->amount->CurrentValue == $this->amount->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_status") &&
            $CurrentForm->hasValue("o_status") &&
            $this->status->CurrentValue != $this->status->DefaultValue &&
            !($this->status->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->status->CurrentValue == $this->status->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_po_id") &&
            $CurrentForm->hasValue("o_po_id") &&
            $this->po_id->CurrentValue != $this->po_id->DefaultValue &&
            !($this->po_id->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->po_id->CurrentValue == $this->po_id->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_remarks") &&
            $CurrentForm->hasValue("o_remarks") &&
            $this->remarks->CurrentValue != $this->remarks->DefaultValue &&
            !($this->remarks->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->remarks->CurrentValue == $this->remarks->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_p_remarks") &&
            $CurrentForm->hasValue("o_p_remarks") &&
            $this->p_remarks->CurrentValue != $this->p_remarks->DefaultValue &&
            !($this->p_remarks->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->p_remarks->CurrentValue == $this->p_remarks->getSessionValue())
        ) {
            return false;
        }
        return true;
    }

    // Validate grid form
    public function validateGridForm()
    {
        global $CurrentForm;

        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Load default values for emptyRow checking
        $this->loadDefaultValues();

        // Validate all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete" && $rowaction != "hide") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } elseif (!$this->validateForm()) {
                    $this->ValidationErrors[$rowindex] = $this->getValidationErrors();
                    $this->EventCancelled = true;
                    return false;
                }
            }
        }
        return true;
    }

    // Get all form values of the grid
    public function getGridFormValues()
    {
        global $CurrentForm;
        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }
        $rows = [];

        // Loop through all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } else {
                    $rows[] = $this->getFieldValues("FormValue"); // Return row as array
                }
            }
        }
        return $rows; // Return as array of array
    }

    // Restore form values for current row
    public function restoreCurrentRowFormValues($idx)
    {
        global $CurrentForm;

        // Get row based on current index
        $CurrentForm->Index = $idx;
        $rowaction = strval($CurrentForm->getValue($this->FormActionName));
        $this->loadFormValues(); // Load form values
        // Set up invalid status correctly
        $this->resetFormError();
        if ($rowaction == "insert" && $this->emptyRow()) {
            // Ignore
        } else {
            $this->validateForm();
        }
    }

    // Reset form status
    public function resetFormError()
    {
        foreach ($this->Fields as $field) {
            $field->clearErrorMessage();
        }
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset master/detail keys
            if ($this->Command == "resetall") {
                $this->setCurrentMasterTable(""); // Clear master table
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
                        $this->rid->setSessionValue("");
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // "griddelete"
        if ($this->AllowAddDeleteRow) {
            $item = &$this->ListOptions->add("griddelete");
            $item->CssClass = "text-nowrap";
            $item->OnLeft = true;
            $item->Visible = false; // Default hidden
        }

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "delete"
        $item = &$this->ListOptions->add("delete");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();

        // Set up row action and key
        if ($CurrentForm && is_numeric($this->RowIndex) && $this->RowType != "view") {
            $CurrentForm->Index = $this->RowIndex;
            $actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
            $oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->OldKeyName);
            $blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
            if ($this->RowAction != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
            }
            $oldKey = $this->getKey(false); // Get from OldValue
            if ($oldKeyName != "" && $oldKey != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $oldKeyName . "\" id=\"" . $oldKeyName . "\" value=\"" . HtmlEncode($oldKey) . "\">";
            }
            if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow()) {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
            }
        }

        // "delete"
        if ($this->AllowAddDeleteRow) {
            if ($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") {
                $options = &$this->ListOptions;
                $options->UseButtonGroup = true; // Use button group for grid delete button
                $opt = $options["griddelete"];
                if (!$Security->allowDelete(CurrentProjectID() . $this->TableName) && is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
                    $opt->Body = "&nbsp;";
                } else {
                    $opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-ew-action=\"delete-grid-row\" data-rowindex=\"" . $this->RowIndex . "\">" . $Language->phrase("DeleteLink") . "</a>";
                }
            }
        }
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"product_cart_s\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"product_cart_s\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"product_cart_s\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "delete"
            $opt = $this->ListOptions["delete"];
            if ($Security->canDelete()) {
                $deleteCaption = $Language->phrase("DeleteLink");
                $deleteTitle = HtmlTitle($deleteCaption);
                if ($this->UseAjaxActions) {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\" data-ew-action=\"inline\" data-action=\"delete\" title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" data-key= \"" . HtmlEncode($this->getKey(true)) . "\" data-url=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\"" .
                        ($this->InlineDelete ? " data-ew-action=\"inline-delete\"" : "") .
                        " title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $option = $this->OtherOptions["addedit"];
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Add
        if ($this->CurrentMode == "view") { // Check view mode
            $item = &$option->add("add");
            $addcaption = HtmlTitle($Language->phrase("AddLink"));
            $this->AddUrl = $this->getAddUrl();
            if ($this->ModalAdd && !IsMobile()) {
                $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"product_cart_s\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
            } else {
                $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
            }
            $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        }
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
            if (in_array($this->CurrentMode, ["add", "copy", "edit"]) && !$this->isConfirm()) { // Check add/copy/edit mode
                if ($this->AllowAddDeleteRow) {
                    $option = $options["addedit"];
                    $option->UseDropDownButton = false;
                    $item = &$option->add("addblankrow");
                    $item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-ew-action=\"add-grid-row\">" . $Language->phrase("AddBlankRow") . "</a>";
                    $item->Visible = $Security->canAdd();
                    $this->ShowOtherOptions = $item->Visible;
                }
            }
            if ($this->CurrentMode == "view") { // Check view mode
                $option = $options["addedit"];
                $item = $option["add"];
                $this->ShowOtherOptions = $item?->Visible ?? false;
            }
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        $this->StartRecord = 1;
        $this->StopRecord = $this->TotalRecords; // Show all records

        // Restore number of post back records
        if ($CurrentForm && ($this->isConfirm() || $this->EventCancelled)) {
            $CurrentForm->resetIndex();
            if ($CurrentForm->hasValue($this->FormKeyCountName) && ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm())) {
                $this->KeyCount = $CurrentForm->getValue($this->FormKeyCountName);
                $this->StopRecord = $this->StartRecord + $this->KeyCount - 1;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_product_cart_s", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }
        if ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm() || $this->isMultiEdit()) {
            $this->RowIndex++;
            $CurrentForm->Index = $this->RowIndex;
            if ($CurrentForm->hasValue($this->FormActionName) && ($this->isConfirm() || $this->EventCancelled)) {
                $this->RowAction = strval($CurrentForm->getValue($this->FormActionName));
            } elseif ($this->isGridAdd()) {
                $this->RowAction = "insert";
            } else {
                $this->RowAction = "";
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isGridAdd()) {
            if ($this->CurrentMode == "copy") {
                $this->loadRowValues($this->CurrentRow); // Load row values
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
            } else {
                $this->loadRowValues(); // Load default values
                $this->OldKey = "";
            }
        } else {
            $this->loadRowValues($this->CurrentRow); // Load row values
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
        }
        $this->setKey($this->OldKey);
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }
        if ($this->isGridAdd() && $this->EventCancelled && !$CurrentForm->hasValue($this->FormBlankRowName)) { // Insert failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isGridEdit()) { // Grid edit
            if ($this->EventCancelled) {
                $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
            }
            if ($this->RowAction == "insert") {
                $this->RowType = RowType::ADD; // Render add
            } else {
                $this->RowType = RowType::EDIT; // Render edit
            }
        }
        if ($this->isGridEdit() && ($this->RowType == RowType::EDIT || $this->RowType == RowType::ADD) && $this->EventCancelled) { // Update failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isConfirm()) { // Confirm row
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_product_cart_s",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->location->DefaultValue = $this->location->getDefault(); // PHP
        $this->location->OldValue = $this->location->DefaultValue;
        $this->company_id->DefaultValue = $this->company_id->getDefault(); // PHP
        $this->company_id->OldValue = $this->company_id->DefaultValue;
        $this->partner_id->DefaultValue = $this->partner_id->getDefault(); // PHP
        $this->partner_id->OldValue = $this->partner_id->DefaultValue;
        $this->product_type->DefaultValue = $this->product_type->getDefault(); // PHP
        $this->product_type->OldValue = $this->product_type->DefaultValue;
        $this->grp->DefaultValue = $this->grp->getDefault(); // PHP
        $this->grp->OldValue = $this->grp->DefaultValue;
        $this->s_grp->DefaultValue = $this->s_grp->getDefault(); // PHP
        $this->s_grp->OldValue = $this->s_grp->DefaultValue;
        $this->product->DefaultValue = $this->product->getDefault(); // PHP
        $this->product->OldValue = $this->product->DefaultValue;
        $this->rid->DefaultValue = $this->rid->getDefault(); // PHP
        $this->rid->OldValue = $this->rid->DefaultValue;
        $this->packing_type->DefaultValue = $this->packing_type->getDefault(); // PHP
        $this->packing_type->OldValue = $this->packing_type->DefaultValue;
        $this->shape->DefaultValue = $this->shape->getDefault(); // PHP
        $this->shape->OldValue = $this->shape->DefaultValue;
        $this->unit->DefaultValue = $this->unit->getDefault(); // PHP
        $this->unit->OldValue = $this->unit->DefaultValue;
        $this->w->DefaultValue = $this->w->getDefault(); // PHP
        $this->w->OldValue = $this->w->DefaultValue;
        $this->l->DefaultValue = $this->l->getDefault(); // PHP
        $this->l->OldValue = $this->l->DefaultValue;
        $this->h->DefaultValue = $this->h->getDefault(); // PHP
        $this->h->OldValue = $this->h->DefaultValue;
        $this->quantity->DefaultValue = $this->quantity->getDefault(); // PHP
        $this->quantity->OldValue = $this->quantity->DefaultValue;
        $this->price->DefaultValue = $this->price->getDefault(); // PHP
        $this->price->OldValue = $this->price->DefaultValue;
        $this->currency->DefaultValue = $this->currency->getDefault(); // PHP
        $this->currency->OldValue = $this->currency->DefaultValue;
        $this->amount->DefaultValue = $this->amount->getDefault(); // PHP
        $this->amount->OldValue = $this->amount->DefaultValue;
        $this->shipping_charge->DefaultValue = $this->shipping_charge->getDefault(); // PHP
        $this->shipping_charge->OldValue = $this->shipping_charge->DefaultValue;
        $this->buyer_uid->DefaultValue = $this->buyer_uid->getDefault(); // PHP
        $this->buyer_uid->OldValue = $this->buyer_uid->DefaultValue;
        $this->label->DefaultValue = $this->label->getDefault(); // PHP
        $this->label->OldValue = $this->label->DefaultValue;
        $this->remarks->DefaultValue = $this->remarks->getDefault(); // PHP
        $this->remarks->OldValue = $this->remarks->DefaultValue;
        $this->p_remarks->DefaultValue = $this->p_remarks->getDefault(); // PHP
        $this->p_remarks->OldValue = $this->p_remarks->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->image->Upload->Index = $this->RowIndex;
        $this->q_sku->DefaultValue = $this->q_sku->getDefault(); // PHP
        $this->q_sku->OldValue = $this->q_sku->DefaultValue;
        $this->p_qty->DefaultValue = $this->p_qty->getDefault(); // PHP
        $this->p_qty->OldValue = $this->p_qty->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $CurrentForm->FormName = $this->FormName;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey && !$this->isGridAdd() && !$this->isAdd()) {
            $this->id->setFormValue($val);
        }

        // Check field name 'location' first before field var 'x_location'
        $val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
        if (!$this->location->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->location->Visible = false; // Disable update for API request
            } else {
                $this->location->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_location")) {
            $this->location->setOldValue($CurrentForm->getValue("o_location"));
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_company_id")) {
            $this->company_id->setOldValue($CurrentForm->getValue("o_company_id"));
        }

        // Check field name 'partner_id' first before field var 'x_partner_id'
        $val = $CurrentForm->hasValue("partner_id") ? $CurrentForm->getValue("partner_id") : $CurrentForm->getValue("x_partner_id");
        if (!$this->partner_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_id->Visible = false; // Disable update for API request
            } else {
                $this->partner_id->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_partner_id")) {
            $this->partner_id->setOldValue($CurrentForm->getValue("o_partner_id"));
        }

        // Check field name 'partner_rid' first before field var 'x_partner_rid'
        $val = $CurrentForm->hasValue("partner_rid") ? $CurrentForm->getValue("partner_rid") : $CurrentForm->getValue("x_partner_rid");
        if (!$this->partner_rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_rid->Visible = false; // Disable update for API request
            } else {
                $this->partner_rid->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_partner_rid")) {
            $this->partner_rid->setOldValue($CurrentForm->getValue("o_partner_rid"));
        }

        // Check field name 'product_type' first before field var 'x_product_type'
        $val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
        if (!$this->product_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_type->Visible = false; // Disable update for API request
            } else {
                $this->product_type->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_product_type")) {
            $this->product_type->setOldValue($CurrentForm->getValue("o_product_type"));
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_grp")) {
            $this->grp->setOldValue($CurrentForm->getValue("o_grp"));
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_s_grp")) {
            $this->s_grp->setOldValue($CurrentForm->getValue("o_s_grp"));
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_product")) {
            $this->product->setOldValue($CurrentForm->getValue("o_product"));
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_rid")) {
            $this->rid->setOldValue($CurrentForm->getValue("o_rid"));
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_packing_type")) {
            $this->packing_type->setOldValue($CurrentForm->getValue("o_packing_type"));
        }

        // Check field name 'batch_no' first before field var 'x_batch_no'
        $val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
        if (!$this->batch_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_no->Visible = false; // Disable update for API request
            } else {
                $this->batch_no->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_batch_no")) {
            $this->batch_no->setOldValue($CurrentForm->getValue("o_batch_no"));
        }

        // Check field name 'shape' first before field var 'x_shape'
        $val = $CurrentForm->hasValue("shape") ? $CurrentForm->getValue("shape") : $CurrentForm->getValue("x_shape");
        if (!$this->shape->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shape->Visible = false; // Disable update for API request
            } else {
                $this->shape->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_shape")) {
            $this->shape->setOldValue($CurrentForm->getValue("o_shape"));
        }

        // Check field name 'unit' first before field var 'x_unit'
        $val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
        if (!$this->unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unit->Visible = false; // Disable update for API request
            } else {
                $this->unit->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_unit")) {
            $this->unit->setOldValue($CurrentForm->getValue("o_unit"));
        }

        // Check field name 'w' first before field var 'x_w'
        $val = $CurrentForm->hasValue("w") ? $CurrentForm->getValue("w") : $CurrentForm->getValue("x_w");
        if (!$this->w->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->w->Visible = false; // Disable update for API request
            } else {
                $this->w->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_w")) {
            $this->w->setOldValue($CurrentForm->getValue("o_w"));
        }

        // Check field name 'w_cm' first before field var 'x_w_cm'
        $val = $CurrentForm->hasValue("w_cm") ? $CurrentForm->getValue("w_cm") : $CurrentForm->getValue("x_w_cm");
        if (!$this->w_cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->w_cm->Visible = false; // Disable update for API request
            } else {
                $this->w_cm->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_w_cm")) {
            $this->w_cm->setOldValue($CurrentForm->getValue("o_w_cm"));
        }

        // Check field name 'l' first before field var 'x_l'
        $val = $CurrentForm->hasValue("l") ? $CurrentForm->getValue("l") : $CurrentForm->getValue("x_l");
        if (!$this->l->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->l->Visible = false; // Disable update for API request
            } else {
                $this->l->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_l")) {
            $this->l->setOldValue($CurrentForm->getValue("o_l"));
        }

        // Check field name 'l_cm' first before field var 'x_l_cm'
        $val = $CurrentForm->hasValue("l_cm") ? $CurrentForm->getValue("l_cm") : $CurrentForm->getValue("x_l_cm");
        if (!$this->l_cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->l_cm->Visible = false; // Disable update for API request
            } else {
                $this->l_cm->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_l_cm")) {
            $this->l_cm->setOldValue($CurrentForm->getValue("o_l_cm"));
        }

        // Check field name 'h' first before field var 'x_h'
        $val = $CurrentForm->hasValue("h") ? $CurrentForm->getValue("h") : $CurrentForm->getValue("x_h");
        if (!$this->h->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->h->Visible = false; // Disable update for API request
            } else {
                $this->h->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_h")) {
            $this->h->setOldValue($CurrentForm->getValue("o_h"));
        }

        // Check field name 'h_cm' first before field var 'x_h_cm'
        $val = $CurrentForm->hasValue("h_cm") ? $CurrentForm->getValue("h_cm") : $CurrentForm->getValue("x_h_cm");
        if (!$this->h_cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->h_cm->Visible = false; // Disable update for API request
            } else {
                $this->h_cm->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_h_cm")) {
            $this->h_cm->setOldValue($CurrentForm->getValue("o_h_cm"));
        }

        // Check field name 'partner_size' first before field var 'x_partner_size'
        $val = $CurrentForm->hasValue("partner_size") ? $CurrentForm->getValue("partner_size") : $CurrentForm->getValue("x_partner_size");
        if (!$this->partner_size->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_size->Visible = false; // Disable update for API request
            } else {
                $this->partner_size->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_partner_size")) {
            $this->partner_size->setOldValue($CurrentForm->getValue("o_partner_size"));
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_quantity")) {
            $this->quantity->setOldValue($CurrentForm->getValue("o_quantity"));
        }

        // Check field name 'price' first before field var 'x_price'
        $val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
        if (!$this->price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->price->Visible = false; // Disable update for API request
            } else {
                $this->price->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_price")) {
            $this->price->setOldValue($CurrentForm->getValue("o_price"));
        }

        // Check field name 'amount' first before field var 'x_amount'
        $val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
        if (!$this->amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount->Visible = false; // Disable update for API request
            } else {
                $this->amount->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_amount")) {
            $this->amount->setOldValue($CurrentForm->getValue("o_amount"));
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_status")) {
            $this->status->setOldValue($CurrentForm->getValue("o_status"));
        }

        // Check field name 'po_id' first before field var 'x_po_id'
        $val = $CurrentForm->hasValue("po_id") ? $CurrentForm->getValue("po_id") : $CurrentForm->getValue("x_po_id");
        if (!$this->po_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_id->Visible = false; // Disable update for API request
            } else {
                $this->po_id->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_po_id")) {
            $this->po_id->setOldValue($CurrentForm->getValue("o_po_id"));
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_remarks")) {
            $this->remarks->setOldValue($CurrentForm->getValue("o_remarks"));
        }

        // Check field name 'p_remarks' first before field var 'x_p_remarks'
        $val = $CurrentForm->hasValue("p_remarks") ? $CurrentForm->getValue("p_remarks") : $CurrentForm->getValue("x_p_remarks");
        if (!$this->p_remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->p_remarks->Visible = false; // Disable update for API request
            } else {
                $this->p_remarks->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_p_remarks")) {
            $this->p_remarks->setOldValue($CurrentForm->getValue("o_p_remarks"));
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_operator")) {
            $this->operator->setOldValue($CurrentForm->getValue("o_operator"));
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
        if ($CurrentForm->hasValue("o_datetime")) {
            $this->datetime->setOldValue($CurrentForm->getValue("o_datetime"));
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        if (!$this->isGridAdd() && !$this->isAdd()) {
            $this->id->CurrentValue = $this->id->FormValue;
        }
        $this->location->CurrentValue = $this->location->FormValue;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->partner_id->CurrentValue = $this->partner_id->FormValue;
        $this->partner_rid->CurrentValue = $this->partner_rid->FormValue;
        $this->product_type->CurrentValue = $this->product_type->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->batch_no->CurrentValue = $this->batch_no->FormValue;
        $this->shape->CurrentValue = $this->shape->FormValue;
        $this->unit->CurrentValue = $this->unit->FormValue;
        $this->w->CurrentValue = $this->w->FormValue;
        $this->w_cm->CurrentValue = $this->w_cm->FormValue;
        $this->l->CurrentValue = $this->l->FormValue;
        $this->l_cm->CurrentValue = $this->l_cm->FormValue;
        $this->h->CurrentValue = $this->h->FormValue;
        $this->h_cm->CurrentValue = $this->h_cm->FormValue;
        $this->partner_size->CurrentValue = $this->partner_size->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->price->CurrentValue = $this->price->FormValue;
        $this->amount->CurrentValue = $this->amount->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->po_id->CurrentValue = $this->po_id->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->p_remarks->CurrentValue = $this->p_remarks->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->location->setDbValue($row['location']);
        $this->company_id->setDbValue($row['company_id']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->partner_rid->setDbValue($row['partner_rid']);
        $this->product_type->setDbValue($row['product_type']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->shape->setDbValue($row['shape']);
        $this->unit->setDbValue($row['unit']);
        $this->w->setDbValue($row['w']);
        $this->w_cm->setDbValue($row['w_cm']);
        $this->l->setDbValue($row['l']);
        $this->l_cm->setDbValue($row['l_cm']);
        $this->h->setDbValue($row['h']);
        $this->h_cm->setDbValue($row['h_cm']);
        $this->partner_size->setDbValue($row['partner_size']);
        $this->size->setDbValue($row['size']);
        $this->sqm->setDbValue($row['sqm']);
        $this->quantity->setDbValue($row['quantity']);
        $this->price->setDbValue($row['price']);
        $this->currency->setDbValue($row['currency']);
        $this->amount->setDbValue($row['amount']);
        $this->status->setDbValue($row['status']);
        $this->cart_id->setDbValue($row['cart_id']);
        $this->po_id->setDbValue($row['po_id']);
        $this->rid_1->setDbValue($row['rid_1']);
        $this->hsn_code->setDbValue($row['hsn_code']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->pkt_quantity->setDbValue($row['pkt_quantity']);
        $this->multiprice_id->setDbValue($row['multiprice_id']);
        $this->discount_price->setDbValue($row['discount_price']);
        $this->cbm->setDbValue($row['cbm']);
        $this->tax->setDbValue($row['tax']);
        $this->tax_amount->setDbValue($row['tax_amount']);
        $this->shipping_method->setDbValue($row['shipping_method']);
        $this->shipping_local->setDbValue($row['shipping_local']);
        $this->shipping_abroad->setDbValue($row['shipping_abroad']);
        $this->shipping_charge->setDbValue($row['shipping_charge']);
        $this->additional_discount->setDbValue($row['additional_discount']);
        $this->total_amount->setDbValue($row['total_amount']);
        $this->buyer_uid->setDbValue($row['buyer_uid']);
        $this->label->setDbValue($row['label']);
        $this->remarks->setDbValue($row['remarks']);
        $this->p_remarks->setDbValue($row['p_remarks']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->o_datetime->setDbValue($row['o_datetime']);
        $this->cart_amount->setDbValue($row['cart_amount']);
        $this->c_total->setDbValue($row['c_total']);
        $this->_1->setDbValue($row['1']);
        $this->_2->setDbValue($row['2']);
        $this->_3->setDbValue($row['3']);
        $this->_4->setDbValue($row['4']);
        $this->_5->setDbValue($row['5']);
        $this->_6->setDbValue($row['6']);
        $this->_7->setDbValue($row['7']);
        $this->_8->setDbValue($row['8']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->image->Upload->Index = $this->RowIndex;
        $this->r_text->setDbValue($row['r_text']);
        $this->t_id->setDbValue($row['t_id']);
        $this->_9->setDbValue($row['9']);
        $this->_10->setDbValue($row['10']);
        $this->_11->setDbValue($row['11']);
        $this->_12->setDbValue($row['12']);
        $this->sqm_u->setDbValue($row['sqm_u']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->buyer_loc->setDbValue($row['buyer_loc']);
        $this->p_id->setDbValue($row['p_id']);
        $this->partner_code->setDbValue($row['partner_code']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->partner_order_no->setDbValue($row['partner_order_no']);
        $this->p_qty->setDbValue($row['p_qty']);
        $this->product_code->setDbValue($row['product_code']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['partner_rid'] = $this->partner_rid->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['w'] = $this->w->DefaultValue;
        $row['w_cm'] = $this->w_cm->DefaultValue;
        $row['l'] = $this->l->DefaultValue;
        $row['l_cm'] = $this->l_cm->DefaultValue;
        $row['h'] = $this->h->DefaultValue;
        $row['h_cm'] = $this->h_cm->DefaultValue;
        $row['partner_size'] = $this->partner_size->DefaultValue;
        $row['size'] = $this->size->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['cart_id'] = $this->cart_id->DefaultValue;
        $row['po_id'] = $this->po_id->DefaultValue;
        $row['rid_1'] = $this->rid_1->DefaultValue;
        $row['hsn_code'] = $this->hsn_code->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['pkt_quantity'] = $this->pkt_quantity->DefaultValue;
        $row['multiprice_id'] = $this->multiprice_id->DefaultValue;
        $row['discount_price'] = $this->discount_price->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['tax'] = $this->tax->DefaultValue;
        $row['tax_amount'] = $this->tax_amount->DefaultValue;
        $row['shipping_method'] = $this->shipping_method->DefaultValue;
        $row['shipping_local'] = $this->shipping_local->DefaultValue;
        $row['shipping_abroad'] = $this->shipping_abroad->DefaultValue;
        $row['shipping_charge'] = $this->shipping_charge->DefaultValue;
        $row['additional_discount'] = $this->additional_discount->DefaultValue;
        $row['total_amount'] = $this->total_amount->DefaultValue;
        $row['buyer_uid'] = $this->buyer_uid->DefaultValue;
        $row['label'] = $this->label->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['p_remarks'] = $this->p_remarks->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['o_datetime'] = $this->o_datetime->DefaultValue;
        $row['cart_amount'] = $this->cart_amount->DefaultValue;
        $row['c_total'] = $this->c_total->DefaultValue;
        $row['1'] = $this->_1->DefaultValue;
        $row['2'] = $this->_2->DefaultValue;
        $row['3'] = $this->_3->DefaultValue;
        $row['4'] = $this->_4->DefaultValue;
        $row['5'] = $this->_5->DefaultValue;
        $row['6'] = $this->_6->DefaultValue;
        $row['7'] = $this->_7->DefaultValue;
        $row['8'] = $this->_8->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['r_text'] = $this->r_text->DefaultValue;
        $row['t_id'] = $this->t_id->DefaultValue;
        $row['9'] = $this->_9->DefaultValue;
        $row['10'] = $this->_10->DefaultValue;
        $row['11'] = $this->_11->DefaultValue;
        $row['12'] = $this->_12->DefaultValue;
        $row['sqm_u'] = $this->sqm_u->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['buyer_loc'] = $this->buyer_loc->DefaultValue;
        $row['p_id'] = $this->p_id->DefaultValue;
        $row['partner_code'] = $this->partner_code->DefaultValue;
        $row['q_sku'] = $this->q_sku->DefaultValue;
        $row['partner_order_no'] = $this->partner_order_no->DefaultValue;
        $row['p_qty'] = $this->p_qty->DefaultValue;
        $row['product_code'] = $this->product_code->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // location

        // company_id

        // partner_id

        // partner_rid

        // product_type

        // grp

        // s_grp

        // product

        // rid
        $this->rid->CellCssStyle = "white-space: nowrap;";

        // packing_type

        // batch_no

        // shape

        // unit

        // w

        // w_cm

        // l

        // l_cm

        // h

        // h_cm

        // partner_size

        // size

        // sqm

        // quantity

        // price

        // currency

        // amount
        $this->amount->CellCssStyle = "white-space: nowrap;";

        // status
        $this->status->CellCssStyle = "white-space: nowrap;";

        // cart_id
        $this->cart_id->CellCssStyle = "white-space: nowrap;";

        // po_id

        // rid_1
        $this->rid_1->CellCssStyle = "white-space: nowrap;";

        // hsn_code
        $this->hsn_code->CellCssStyle = "white-space: nowrap;";

        // despatch_date
        $this->despatch_date->CellCssStyle = "white-space: nowrap;";

        // pkt_quantity
        $this->pkt_quantity->CellCssStyle = "white-space: nowrap;";

        // multiprice_id
        $this->multiprice_id->CellCssStyle = "white-space: nowrap;";

        // discount_price
        $this->discount_price->CellCssStyle = "white-space: nowrap;";

        // cbm

        // tax
        $this->tax->CellCssStyle = "white-space: nowrap;";

        // tax_amount
        $this->tax_amount->CellCssStyle = "white-space: nowrap;";

        // shipping_method
        $this->shipping_method->CellCssStyle = "white-space: nowrap;";

        // shipping_local
        $this->shipping_local->CellCssStyle = "white-space: nowrap;";

        // shipping_abroad
        $this->shipping_abroad->CellCssStyle = "white-space: nowrap;";

        // shipping_charge
        $this->shipping_charge->CellCssStyle = "white-space: nowrap;";

        // additional_discount
        $this->additional_discount->CellCssStyle = "white-space: nowrap;";

        // total_amount
        $this->total_amount->CellCssStyle = "white-space: nowrap;";

        // buyer_uid

        // label

        // remarks

        // p_remarks

        // operator

        // datetime

        // o_datetime
        $this->o_datetime->CellCssStyle = "white-space: nowrap;";

        // cart_amount
        $this->cart_amount->CellCssStyle = "white-space: nowrap;";

        // c_total
        $this->c_total->CellCssStyle = "white-space: nowrap;";

        // 1
        $this->_1->CellCssStyle = "white-space: nowrap;";

        // 2
        $this->_2->CellCssStyle = "white-space: nowrap;";

        // 3
        $this->_3->CellCssStyle = "white-space: nowrap;";

        // 4
        $this->_4->CellCssStyle = "white-space: nowrap;";

        // 5
        $this->_5->CellCssStyle = "white-space: nowrap;";

        // 6
        $this->_6->CellCssStyle = "white-space: nowrap;";

        // 7
        $this->_7->CellCssStyle = "white-space: nowrap;";

        // 8
        $this->_8->CellCssStyle = "white-space: nowrap;";

        // image
        $this->image->CellCssStyle = "white-space: nowrap;";

        // r_text
        $this->r_text->CellCssStyle = "white-space: nowrap;";

        // t_id
        $this->t_id->CellCssStyle = "white-space: nowrap;";

        // 9
        $this->_9->CellCssStyle = "white-space: nowrap;";

        // 10
        $this->_10->CellCssStyle = "white-space: nowrap;";

        // 11
        $this->_11->CellCssStyle = "white-space: nowrap;";

        // 12
        $this->_12->CellCssStyle = "white-space: nowrap;";

        // sqm_u
        $this->sqm_u->CellCssStyle = "white-space: nowrap;";

        // reports_to
        $this->reports_to->CellCssStyle = "white-space: nowrap;";

        // buyer_loc
        $this->buyer_loc->CellCssStyle = "white-space: nowrap;";

        // p_id
        $this->p_id->CellCssStyle = "white-space: nowrap;";

        // partner_code
        $this->partner_code->CellCssStyle = "white-space: nowrap;";

        // q_sku
        $this->q_sku->CellCssStyle = "white-space: nowrap;";

        // partner_order_no
        $this->partner_order_no->CellCssStyle = "white-space: nowrap;";

        // p_qty
        $this->p_qty->CellCssStyle = "white-space: nowrap;";

        // product_code
        $this->product_code->CellCssStyle = "white-space: nowrap;";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                        $this->location->ViewValue = $this->location->displayValue($arwrk);
                    } else {
                        $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // partner_rid
            $this->partner_rid->ViewValue = $this->partner_rid->CurrentValue;
            $curVal = strval($this->partner_rid->CurrentValue);
            if ($curVal != "") {
                $this->partner_rid->ViewValue = $this->partner_rid->lookupCacheOption($curVal);
                if ($this->partner_rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_rid->ViewValue = $this->partner_rid->displayValue($arwrk);
                    } else {
                        $this->partner_rid->ViewValue = $this->partner_rid->CurrentValue;
                    }
                }
            } else {
                $this->partner_rid->ViewValue = null;
            }

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                        $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                    } else {
                        $this->product_type->ViewValue = FormatNumber($this->product_type->CurrentValue, $this->product_type->formatPattern());
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // grp
            $this->grp->ViewValue = $this->grp->CurrentValue;
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // batch_no
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                        $this->shape->ViewValue = $this->shape->displayValue($arwrk);
                    } else {
                        $this->shape->ViewValue = FormatNumber($this->shape->CurrentValue, $this->shape->formatPattern());
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // unit
            $curVal = strval($this->unit->CurrentValue);
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
                if ($this->unit->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                        $this->unit->ViewValue = $this->unit->displayValue($arwrk);
                    } else {
                        $this->unit->ViewValue = FormatNumber($this->unit->CurrentValue, $this->unit->formatPattern());
                    }
                }
            } else {
                $this->unit->ViewValue = null;
            }

            // w
            $this->w->ViewValue = $this->w->CurrentValue;

            // w_cm
            $this->w_cm->ViewValue = $this->w_cm->CurrentValue;
            $this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, $this->w_cm->formatPattern());

            // l
            $this->l->ViewValue = $this->l->CurrentValue;

            // l_cm
            $this->l_cm->ViewValue = $this->l_cm->CurrentValue;
            $this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, $this->l_cm->formatPattern());

            // h
            $this->h->ViewValue = $this->h->CurrentValue;

            // h_cm
            $this->h_cm->ViewValue = $this->h_cm->CurrentValue;
            $this->h_cm->ViewValue = FormatNumber($this->h_cm->ViewValue, $this->h_cm->formatPattern());

            // partner_size
            $this->partner_size->ViewValue = $this->partner_size->CurrentValue;

            // size
            $this->size->ViewValue = $this->size->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // po_id
            $this->po_id->ViewValue = $this->po_id->CurrentValue;
            $curVal = strval($this->po_id->CurrentValue);
            if ($curVal != "") {
                $this->po_id->ViewValue = $this->po_id->lookupCacheOption($curVal);
                if ($this->po_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_id->Lookup->renderViewRow($rswrk[0]);
                        $this->po_id->ViewValue = $this->po_id->displayValue($arwrk);
                    } else {
                        $this->po_id->ViewValue = FormatNumber($this->po_id->CurrentValue, $this->po_id->formatPattern());
                    }
                }
            } else {
                $this->po_id->ViewValue = null;
            }

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // label
            $this->label->ViewValue = $this->label->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // p_remarks
            $this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->id->ViewValue = $this->highlightValue($this->id);
            }

            // location
            $this->location->HrefValue = "";
            $this->location->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";
            $this->partner_id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->partner_id->ViewValue = $this->highlightValue($this->partner_id);
            }

            // partner_rid
            $this->partner_rid->HrefValue = "";
            $this->partner_rid->TooltipValue = "";
            if (!$this->isExport()) {
                $this->partner_rid->ViewValue = $this->highlightValue($this->partner_rid);
            }

            // product_type
            $this->product_type->HrefValue = "";
            $this->product_type->TooltipValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }
            $this->grp->TooltipValue = "";
            if (!$this->isExport()) {
                $this->grp->ViewValue = $this->highlightValue($this->grp);
            }

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }
            $this->s_grp->TooltipValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }
            $this->product->TooltipValue = "";

            // rid
            $this->rid->HrefValue = "";
            $this->rid->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";
            $this->batch_no->TooltipValue = "";

            // shape
            $this->shape->HrefValue = "";
            $this->shape->TooltipValue = "";

            // unit
            if (!EmptyValue($this->unit->CurrentValue)) {
                $this->unit->HrefValue = $this->unit->getLinkPrefix() . $this->unit->CurrentValue; // Add prefix/suffix
                $this->unit->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
                }
            } else {
                $this->unit->HrefValue = "";
            }
            $this->unit->TooltipValue = "";

            // w
            $this->w->HrefValue = "";
            $this->w->TooltipValue = "";
            if (!$this->isExport()) {
                $this->w->ViewValue = $this->highlightValue($this->w);
            }

            // w_cm
            $this->w_cm->HrefValue = "";
            $this->w_cm->TooltipValue = "";

            // l
            $this->l->HrefValue = "";
            $this->l->TooltipValue = "";
            if (!$this->isExport()) {
                $this->l->ViewValue = $this->highlightValue($this->l);
            }

            // l_cm
            $this->l_cm->HrefValue = "";
            $this->l_cm->TooltipValue = "";

            // h
            $this->h->HrefValue = "";
            $this->h->TooltipValue = "";
            if (!$this->isExport()) {
                $this->h->ViewValue = $this->highlightValue($this->h);
            }

            // h_cm
            $this->h_cm->HrefValue = "";
            $this->h_cm->TooltipValue = "";

            // partner_size
            $this->partner_size->HrefValue = "";
            $this->partner_size->TooltipValue = "";
            if (!$this->isExport()) {
                $this->partner_size->ViewValue = $this->highlightValue($this->partner_size);
            }

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // price
            $this->price->HrefValue = "";
            $this->price->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // po_id
            $this->po_id->HrefValue = "";
            $this->po_id->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";
            if (!$this->isExport()) {
                $this->remarks->ViewValue = $this->highlightValue($this->remarks);
            }

            // p_remarks
            $this->p_remarks->HrefValue = "";
            $this->p_remarks->TooltipValue = "";
            if (!$this->isExport()) {
                $this->p_remarks->ViewValue = $this->highlightValue($this->p_remarks);
            }

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
            if (!$this->isExport()) {
                $this->datetime->ViewValue = $this->highlightValue($this->datetime);
            }
        } elseif ($this->RowType == RowType::ADD) {
            // id

            // location
            $this->location->setupEditAttributes();
            $curVal = trim(strval($this->location->CurrentValue));
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->location->CurrentValue, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $this->company_id->EditValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->EditValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->EditValue = HtmlEncode(FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern()));
                    }
                }
            } else {
                $this->company_id->EditValue = null;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // partner_id
            $this->partner_id->setupEditAttributes();
            $this->partner_id->EditValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->EditValue = HtmlEncode($this->partner_id->CurrentValue);
                    }
                }
            } else {
                $this->partner_id->EditValue = null;
            }
            $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

            // partner_rid
            $this->partner_rid->setupEditAttributes();
            if (!$this->partner_rid->Raw) {
                $this->partner_rid->CurrentValue = HtmlDecode($this->partner_rid->CurrentValue);
            }
            $this->partner_rid->EditValue = HtmlEncode($this->partner_rid->CurrentValue);
            $curVal = strval($this->partner_rid->CurrentValue);
            if ($curVal != "") {
                $this->partner_rid->EditValue = $this->partner_rid->lookupCacheOption($curVal);
                if ($this->partner_rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_rid->EditValue = $this->partner_rid->displayValue($arwrk);
                    } else {
                        $this->partner_rid->EditValue = HtmlEncode($this->partner_rid->CurrentValue);
                    }
                }
            } else {
                $this->partner_rid->EditValue = null;
            }
            $this->partner_rid->PlaceHolder = RemoveHtml($this->partner_rid->caption());

            // product_type
            $curVal = trim(strval($this->product_type->CurrentValue));
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
            } else {
                $this->product_type->ViewValue = $this->product_type->Lookup !== null && is_array($this->product_type->lookupOptions()) && count($this->product_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_type->ViewValue !== null) { // Load from cache
                $this->product_type->EditValue = array_values($this->product_type->lookupOptions());
                if ($this->product_type->ViewValue == "") {
                    $this->product_type->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product_type->CurrentValue, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                    $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                } else {
                    $this->product_type->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->product_type->EditValue = $arwrk;
            }
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

            // grp
            $this->grp->setupEditAttributes();
            $this->grp->EditValue = $this->grp->CurrentValue;
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->EditValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->EditValue = HtmlEncode($this->grp->CurrentValue);
                    }
                }
            } else {
                $this->grp->EditValue = null;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
                if ($this->s_grp->ViewValue == "") {
                    $this->s_grp->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
                if ($this->product->ViewValue == "") {
                    $this->product->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid
            if ($this->rid->getSessionValue() != "") {
                $this->rid->CurrentValue = GetForeignKeyValue($this->rid->getSessionValue());
                $this->rid->OldValue = $this->rid->CurrentValue;
                $curVal = strval($this->rid->CurrentValue);
                if ($curVal != "") {
                    $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                    if ($this->rid->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                        $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                            $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                        } else {
                            $this->rid->ViewValue = $this->rid->CurrentValue;
                        }
                    }
                } else {
                    $this->rid->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->rid->CurrentValue));
                if ($curVal != "") {
                    $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                } else {
                    $this->rid->ViewValue = $this->rid->Lookup !== null && is_array($this->rid->lookupOptions()) && count($this->rid->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->rid->ViewValue !== null) { // Load from cache
                    $this->rid->EditValue = array_values($this->rid->lookupOptions());
                    if ($this->rid->ViewValue == "") {
                        $this->rid->ViewValue = $Language->phrase("PleaseSelect");
                    }
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid->CurrentValue, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $Language->phrase("PleaseSelect");
                    }
                    $arwrk = $rswrk;
                    $this->rid->EditValue = $arwrk;
                }
                $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());
            }

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->CurrentValue));
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->CurrentValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // batch_no
            $curVal = trim(strval($this->batch_no->CurrentValue));
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            } else {
                $this->batch_no->ViewValue = $this->batch_no->Lookup !== null && is_array($this->batch_no->lookupOptions()) && count($this->batch_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->batch_no->ViewValue !== null) { // Load from cache
                $this->batch_no->EditValue = array_values($this->batch_no->lookupOptions());
                if ($this->batch_no->ViewValue == "") {
                    $this->batch_no->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->batch_no->CurrentValue, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->batch_no->EditValue = $arwrk;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // shape
            $curVal = trim(strval($this->shape->CurrentValue));
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
            } else {
                $this->shape->ViewValue = $this->shape->Lookup !== null && is_array($this->shape->lookupOptions()) && count($this->shape->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->shape->ViewValue !== null) { // Load from cache
                $this->shape->EditValue = array_values($this->shape->lookupOptions());
                if ($this->shape->ViewValue == "") {
                    $this->shape->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->shape->CurrentValue, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                $sqlWrk = $this->shape->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                    $this->shape->ViewValue = $this->shape->displayValue($arwrk);
                } else {
                    $this->shape->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->shape->EditValue = $arwrk;
            }
            $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

            // unit
            $this->unit->setupEditAttributes();
            $curVal = trim(strval($this->unit->CurrentValue));
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
            } else {
                $this->unit->ViewValue = $this->unit->Lookup !== null && is_array($this->unit->lookupOptions()) && count($this->unit->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->unit->ViewValue !== null) { // Load from cache
                $this->unit->EditValue = array_values($this->unit->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->unit->CurrentValue, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->unit->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->unit->EditValue = $arwrk;
            }
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

            // w
            $this->w->setupEditAttributes();
            if (!$this->w->Raw) {
                $this->w->CurrentValue = HtmlDecode($this->w->CurrentValue);
            }
            $this->w->EditValue = HtmlEncode($this->w->CurrentValue);
            $this->w->PlaceHolder = RemoveHtml($this->w->caption());

            // w_cm
            $this->w_cm->setupEditAttributes();
            $this->w_cm->EditCustomAttributes = $this->w_cm->getEditCustomAttributes(); // PHP
            $this->w_cm->EditValue = $this->w_cm->CurrentValue;
            $this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());
            if (strval($this->w_cm->EditValue) != "" && is_numeric($this->w_cm->EditValue)) {
                $this->w_cm->EditValue = FormatNumber($this->w_cm->EditValue, null);
            }

            // l
            $this->l->setupEditAttributes();
            if (!$this->l->Raw) {
                $this->l->CurrentValue = HtmlDecode($this->l->CurrentValue);
            }
            $this->l->EditValue = HtmlEncode($this->l->CurrentValue);
            $this->l->PlaceHolder = RemoveHtml($this->l->caption());

            // l_cm
            $this->l_cm->setupEditAttributes();
            $this->l_cm->EditCustomAttributes = $this->l_cm->getEditCustomAttributes(); // PHP
            $this->l_cm->EditValue = $this->l_cm->CurrentValue;
            $this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());
            if (strval($this->l_cm->EditValue) != "" && is_numeric($this->l_cm->EditValue)) {
                $this->l_cm->EditValue = FormatNumber($this->l_cm->EditValue, null);
            }

            // h
            $this->h->setupEditAttributes();
            if (!$this->h->Raw) {
                $this->h->CurrentValue = HtmlDecode($this->h->CurrentValue);
            }
            $this->h->EditValue = HtmlEncode($this->h->CurrentValue);
            $this->h->PlaceHolder = RemoveHtml($this->h->caption());

            // h_cm
            $this->h_cm->setupEditAttributes();
            $this->h_cm->EditCustomAttributes = $this->h_cm->getEditCustomAttributes(); // PHP
            $this->h_cm->EditValue = $this->h_cm->CurrentValue;
            $this->h_cm->PlaceHolder = RemoveHtml($this->h_cm->caption());
            if (strval($this->h_cm->EditValue) != "" && is_numeric($this->h_cm->EditValue)) {
                $this->h_cm->EditValue = FormatNumber($this->h_cm->EditValue, null);
            }

            // partner_size
            $this->partner_size->setupEditAttributes();
            if (!$this->partner_size->Raw) {
                $this->partner_size->CurrentValue = HtmlDecode($this->partner_size->CurrentValue);
            }
            $this->partner_size->EditValue = HtmlEncode($this->partner_size->CurrentValue);
            $this->partner_size->PlaceHolder = RemoveHtml($this->partner_size->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // price
            $this->price->setupEditAttributes();
            $this->price->EditValue = $this->price->CurrentValue;
            $this->price->PlaceHolder = RemoveHtml($this->price->caption());
            if (strval($this->price->EditValue) != "" && is_numeric($this->price->EditValue)) {
                $this->price->EditValue = FormatNumber($this->price->EditValue, null);
            }

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditCustomAttributes = $this->amount->getEditCustomAttributes(); // PHP
            $this->amount->EditValue = $this->amount->CurrentValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
            if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
                $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
            }

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // po_id
            $this->po_id->setupEditAttributes();
            $this->po_id->EditValue = $this->po_id->CurrentValue;
            $curVal = strval($this->po_id->CurrentValue);
            if ($curVal != "") {
                $this->po_id->EditValue = $this->po_id->lookupCacheOption($curVal);
                if ($this->po_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_id->Lookup->renderViewRow($rswrk[0]);
                        $this->po_id->EditValue = $this->po_id->displayValue($arwrk);
                    } else {
                        $this->po_id->EditValue = HtmlEncode(FormatNumber($this->po_id->CurrentValue, $this->po_id->formatPattern()));
                    }
                }
            } else {
                $this->po_id->EditValue = null;
            }
            $this->po_id->PlaceHolder = RemoveHtml($this->po_id->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // p_remarks
            $this->p_remarks->setupEditAttributes();
            if (!$this->p_remarks->Raw) {
                $this->p_remarks->CurrentValue = HtmlDecode($this->p_remarks->CurrentValue);
            }
            $this->p_remarks->EditValue = HtmlEncode($this->p_remarks->CurrentValue);
            $this->p_remarks->PlaceHolder = RemoveHtml($this->p_remarks->caption());

            // operator

            // datetime

            // Add refer script

            // id
            $this->id->HrefValue = "";

            // location
            $this->location->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";

            // partner_rid
            $this->partner_rid->HrefValue = "";

            // product_type
            $this->product_type->HrefValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid
            $this->rid->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // shape
            $this->shape->HrefValue = "";

            // unit
            if (!EmptyValue($this->unit->CurrentValue)) {
                $this->unit->HrefValue = $this->unit->getLinkPrefix() . $this->unit->CurrentValue; // Add prefix/suffix
                $this->unit->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
                }
            } else {
                $this->unit->HrefValue = "";
            }

            // w
            $this->w->HrefValue = "";

            // w_cm
            $this->w_cm->HrefValue = "";

            // l
            $this->l->HrefValue = "";

            // l_cm
            $this->l_cm->HrefValue = "";

            // h
            $this->h->HrefValue = "";

            // h_cm
            $this->h_cm->HrefValue = "";

            // partner_size
            $this->partner_size->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // po_id
            $this->po_id->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // p_remarks
            $this->p_remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // location
            $this->location->setupEditAttributes();
            $curVal = trim(strval($this->location->CurrentValue));
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->location->CurrentValue, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $this->company_id->EditValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->EditValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->EditValue = HtmlEncode(FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern()));
                    }
                }
            } else {
                $this->company_id->EditValue = null;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // partner_id
            $this->partner_id->setupEditAttributes();
            $this->partner_id->EditValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->EditValue = HtmlEncode($this->partner_id->CurrentValue);
                    }
                }
            } else {
                $this->partner_id->EditValue = null;
            }
            $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

            // partner_rid
            $this->partner_rid->setupEditAttributes();
            if (!$this->partner_rid->Raw) {
                $this->partner_rid->CurrentValue = HtmlDecode($this->partner_rid->CurrentValue);
            }
            $this->partner_rid->EditValue = HtmlEncode($this->partner_rid->CurrentValue);
            $curVal = strval($this->partner_rid->CurrentValue);
            if ($curVal != "") {
                $this->partner_rid->EditValue = $this->partner_rid->lookupCacheOption($curVal);
                if ($this->partner_rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_rid->EditValue = $this->partner_rid->displayValue($arwrk);
                    } else {
                        $this->partner_rid->EditValue = HtmlEncode($this->partner_rid->CurrentValue);
                    }
                }
            } else {
                $this->partner_rid->EditValue = null;
            }
            $this->partner_rid->PlaceHolder = RemoveHtml($this->partner_rid->caption());

            // product_type
            $curVal = trim(strval($this->product_type->CurrentValue));
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
            } else {
                $this->product_type->ViewValue = $this->product_type->Lookup !== null && is_array($this->product_type->lookupOptions()) && count($this->product_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_type->ViewValue !== null) { // Load from cache
                $this->product_type->EditValue = array_values($this->product_type->lookupOptions());
                if ($this->product_type->ViewValue == "") {
                    $this->product_type->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product_type->CurrentValue, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                    $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                } else {
                    $this->product_type->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->product_type->EditValue = $arwrk;
            }
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

            // grp
            $this->grp->setupEditAttributes();
            $this->grp->EditValue = $this->grp->CurrentValue;
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->EditValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->EditValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->EditValue = null;
            }

            // s_grp
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
                if ($this->s_grp->ViewValue == "") {
                    $this->s_grp->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
                if ($this->product->ViewValue == "") {
                    $this->product->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid
            if ($this->rid->getSessionValue() != "") {
                $this->rid->CurrentValue = GetForeignKeyValue($this->rid->getSessionValue());
                $this->rid->OldValue = $this->rid->CurrentValue;
                $curVal = strval($this->rid->CurrentValue);
                if ($curVal != "") {
                    $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                    if ($this->rid->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                        $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                            $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                        } else {
                            $this->rid->ViewValue = $this->rid->CurrentValue;
                        }
                    }
                } else {
                    $this->rid->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->rid->CurrentValue));
                if ($curVal != "") {
                    $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                } else {
                    $this->rid->ViewValue = $this->rid->Lookup !== null && is_array($this->rid->lookupOptions()) && count($this->rid->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->rid->ViewValue !== null) { // Load from cache
                    $this->rid->EditValue = array_values($this->rid->lookupOptions());
                    if ($this->rid->ViewValue == "") {
                        $this->rid->ViewValue = $Language->phrase("PleaseSelect");
                    }
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid->CurrentValue, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $Language->phrase("PleaseSelect");
                    }
                    $arwrk = $rswrk;
                    $this->rid->EditValue = $arwrk;
                }
                $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());
            }

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->CurrentValue));
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->CurrentValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // batch_no
            $curVal = trim(strval($this->batch_no->CurrentValue));
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            } else {
                $this->batch_no->ViewValue = $this->batch_no->Lookup !== null && is_array($this->batch_no->lookupOptions()) && count($this->batch_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->batch_no->ViewValue !== null) { // Load from cache
                $this->batch_no->EditValue = array_values($this->batch_no->lookupOptions());
                if ($this->batch_no->ViewValue == "") {
                    $this->batch_no->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->batch_no->CurrentValue, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->batch_no->EditValue = $arwrk;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // shape
            $curVal = trim(strval($this->shape->CurrentValue));
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
            } else {
                $this->shape->ViewValue = $this->shape->Lookup !== null && is_array($this->shape->lookupOptions()) && count($this->shape->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->shape->ViewValue !== null) { // Load from cache
                $this->shape->EditValue = array_values($this->shape->lookupOptions());
                if ($this->shape->ViewValue == "") {
                    $this->shape->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->shape->CurrentValue, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                $sqlWrk = $this->shape->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                    $this->shape->ViewValue = $this->shape->displayValue($arwrk);
                } else {
                    $this->shape->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->shape->EditValue = $arwrk;
            }
            $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

            // unit
            $this->unit->setupEditAttributes();
            $curVal = trim(strval($this->unit->CurrentValue));
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
            } else {
                $this->unit->ViewValue = $this->unit->Lookup !== null && is_array($this->unit->lookupOptions()) && count($this->unit->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->unit->ViewValue !== null) { // Load from cache
                $this->unit->EditValue = array_values($this->unit->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->unit->CurrentValue, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->unit->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->unit->EditValue = $arwrk;
            }
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

            // w
            $this->w->setupEditAttributes();
            if (!$this->w->Raw) {
                $this->w->CurrentValue = HtmlDecode($this->w->CurrentValue);
            }
            $this->w->EditValue = HtmlEncode($this->w->CurrentValue);
            $this->w->PlaceHolder = RemoveHtml($this->w->caption());

            // w_cm
            $this->w_cm->setupEditAttributes();
            $this->w_cm->EditCustomAttributes = $this->w_cm->getEditCustomAttributes(); // PHP
            $this->w_cm->EditValue = $this->w_cm->CurrentValue;
            $this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());
            if (strval($this->w_cm->EditValue) != "" && is_numeric($this->w_cm->EditValue)) {
                $this->w_cm->EditValue = FormatNumber($this->w_cm->EditValue, null);
            }

            // l
            $this->l->setupEditAttributes();
            if (!$this->l->Raw) {
                $this->l->CurrentValue = HtmlDecode($this->l->CurrentValue);
            }
            $this->l->EditValue = HtmlEncode($this->l->CurrentValue);
            $this->l->PlaceHolder = RemoveHtml($this->l->caption());

            // l_cm
            $this->l_cm->setupEditAttributes();
            $this->l_cm->EditCustomAttributes = $this->l_cm->getEditCustomAttributes(); // PHP
            $this->l_cm->EditValue = $this->l_cm->CurrentValue;
            $this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());
            if (strval($this->l_cm->EditValue) != "" && is_numeric($this->l_cm->EditValue)) {
                $this->l_cm->EditValue = FormatNumber($this->l_cm->EditValue, null);
            }

            // h
            $this->h->setupEditAttributes();
            if (!$this->h->Raw) {
                $this->h->CurrentValue = HtmlDecode($this->h->CurrentValue);
            }
            $this->h->EditValue = HtmlEncode($this->h->CurrentValue);
            $this->h->PlaceHolder = RemoveHtml($this->h->caption());

            // h_cm
            $this->h_cm->setupEditAttributes();
            $this->h_cm->EditCustomAttributes = $this->h_cm->getEditCustomAttributes(); // PHP
            $this->h_cm->EditValue = $this->h_cm->CurrentValue;
            $this->h_cm->PlaceHolder = RemoveHtml($this->h_cm->caption());
            if (strval($this->h_cm->EditValue) != "" && is_numeric($this->h_cm->EditValue)) {
                $this->h_cm->EditValue = FormatNumber($this->h_cm->EditValue, null);
            }

            // partner_size
            $this->partner_size->setupEditAttributes();
            if (!$this->partner_size->Raw) {
                $this->partner_size->CurrentValue = HtmlDecode($this->partner_size->CurrentValue);
            }
            $this->partner_size->EditValue = HtmlEncode($this->partner_size->CurrentValue);
            $this->partner_size->PlaceHolder = RemoveHtml($this->partner_size->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // price
            $this->price->setupEditAttributes();
            $this->price->EditValue = $this->price->CurrentValue;
            $this->price->PlaceHolder = RemoveHtml($this->price->caption());
            if (strval($this->price->EditValue) != "" && is_numeric($this->price->EditValue)) {
                $this->price->EditValue = FormatNumber($this->price->EditValue, null);
            }

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditCustomAttributes = $this->amount->getEditCustomAttributes(); // PHP
            $this->amount->EditValue = $this->amount->CurrentValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
            if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
                $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
            }

            // status
            $this->status->setupEditAttributes();
            if (strval($this->status->CurrentValue) != "") {
                $this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->EditValue = null;
            }

            // po_id
            $this->po_id->setupEditAttributes();
            $this->po_id->EditValue = $this->po_id->CurrentValue;
            $curVal = strval($this->po_id->CurrentValue);
            if ($curVal != "") {
                $this->po_id->EditValue = $this->po_id->lookupCacheOption($curVal);
                if ($this->po_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_id->Lookup->renderViewRow($rswrk[0]);
                        $this->po_id->EditValue = $this->po_id->displayValue($arwrk);
                    } else {
                        $this->po_id->EditValue = FormatNumber($this->po_id->CurrentValue, $this->po_id->formatPattern());
                    }
                }
            } else {
                $this->po_id->EditValue = null;
            }

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // p_remarks
            $this->p_remarks->setupEditAttributes();
            if (!$this->p_remarks->Raw) {
                $this->p_remarks->CurrentValue = HtmlDecode($this->p_remarks->CurrentValue);
            }
            $this->p_remarks->EditValue = HtmlEncode($this->p_remarks->CurrentValue);
            $this->p_remarks->PlaceHolder = RemoveHtml($this->p_remarks->caption());

            // operator

            // datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // location
            $this->location->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";

            // partner_rid
            $this->partner_rid->HrefValue = "";

            // product_type
            $this->product_type->HrefValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }
            $this->grp->TooltipValue = "";

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid
            $this->rid->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // shape
            $this->shape->HrefValue = "";

            // unit
            if (!EmptyValue($this->unit->CurrentValue)) {
                $this->unit->HrefValue = $this->unit->getLinkPrefix() . $this->unit->CurrentValue; // Add prefix/suffix
                $this->unit->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
                }
            } else {
                $this->unit->HrefValue = "";
            }

            // w
            $this->w->HrefValue = "";

            // w_cm
            $this->w_cm->HrefValue = "";

            // l
            $this->l->HrefValue = "";

            // l_cm
            $this->l_cm->HrefValue = "";

            // h
            $this->h->HrefValue = "";

            // h_cm
            $this->h_cm->HrefValue = "";

            // partner_size
            $this->partner_size->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // po_id
            $this->po_id->HrefValue = "";
            $this->po_id->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // p_remarks
            $this->p_remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->location->Visible && $this->location->Required) {
                if (!$this->location->IsDetailKey && EmptyValue($this->location->FormValue)) {
                    $this->location->addErrorMessage(str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
                }
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->company_id->FormValue)) {
                $this->company_id->addErrorMessage($this->company_id->getErrorMessage(false));
            }
            if ($this->partner_id->Visible && $this->partner_id->Required) {
                if (!$this->partner_id->IsDetailKey && EmptyValue($this->partner_id->FormValue)) {
                    $this->partner_id->addErrorMessage(str_replace("%s", $this->partner_id->caption(), $this->partner_id->RequiredErrorMessage));
                }
            }
            if ($this->partner_rid->Visible && $this->partner_rid->Required) {
                if (!$this->partner_rid->IsDetailKey && EmptyValue($this->partner_rid->FormValue)) {
                    $this->partner_rid->addErrorMessage(str_replace("%s", $this->partner_rid->caption(), $this->partner_rid->RequiredErrorMessage));
                }
            }
            if ($this->product_type->Visible && $this->product_type->Required) {
                if (!$this->product_type->IsDetailKey && EmptyValue($this->product_type->FormValue)) {
                    $this->product_type->addErrorMessage(str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if (!$this->rid->IsDetailKey && EmptyValue($this->rid->FormValue)) {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->batch_no->Visible && $this->batch_no->Required) {
                if (!$this->batch_no->IsDetailKey && EmptyValue($this->batch_no->FormValue)) {
                    $this->batch_no->addErrorMessage(str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
                }
            }
            if ($this->shape->Visible && $this->shape->Required) {
                if (!$this->shape->IsDetailKey && EmptyValue($this->shape->FormValue)) {
                    $this->shape->addErrorMessage(str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
                }
            }
            if ($this->unit->Visible && $this->unit->Required) {
                if (!$this->unit->IsDetailKey && EmptyValue($this->unit->FormValue)) {
                    $this->unit->addErrorMessage(str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
                }
            }
            if ($this->w->Visible && $this->w->Required) {
                if (!$this->w->IsDetailKey && EmptyValue($this->w->FormValue)) {
                    $this->w->addErrorMessage(str_replace("%s", $this->w->caption(), $this->w->RequiredErrorMessage));
                }
            }
            if ($this->w_cm->Visible && $this->w_cm->Required) {
                if (!$this->w_cm->IsDetailKey && EmptyValue($this->w_cm->FormValue)) {
                    $this->w_cm->addErrorMessage(str_replace("%s", $this->w_cm->caption(), $this->w_cm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->w_cm->FormValue)) {
                $this->w_cm->addErrorMessage($this->w_cm->getErrorMessage(false));
            }
            if ($this->l->Visible && $this->l->Required) {
                if (!$this->l->IsDetailKey && EmptyValue($this->l->FormValue)) {
                    $this->l->addErrorMessage(str_replace("%s", $this->l->caption(), $this->l->RequiredErrorMessage));
                }
            }
            if ($this->l_cm->Visible && $this->l_cm->Required) {
                if (!$this->l_cm->IsDetailKey && EmptyValue($this->l_cm->FormValue)) {
                    $this->l_cm->addErrorMessage(str_replace("%s", $this->l_cm->caption(), $this->l_cm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->l_cm->FormValue)) {
                $this->l_cm->addErrorMessage($this->l_cm->getErrorMessage(false));
            }
            if ($this->h->Visible && $this->h->Required) {
                if (!$this->h->IsDetailKey && EmptyValue($this->h->FormValue)) {
                    $this->h->addErrorMessage(str_replace("%s", $this->h->caption(), $this->h->RequiredErrorMessage));
                }
            }
            if ($this->h_cm->Visible && $this->h_cm->Required) {
                if (!$this->h_cm->IsDetailKey && EmptyValue($this->h_cm->FormValue)) {
                    $this->h_cm->addErrorMessage(str_replace("%s", $this->h_cm->caption(), $this->h_cm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->h_cm->FormValue)) {
                $this->h_cm->addErrorMessage($this->h_cm->getErrorMessage(false));
            }
            if ($this->partner_size->Visible && $this->partner_size->Required) {
                if (!$this->partner_size->IsDetailKey && EmptyValue($this->partner_size->FormValue)) {
                    $this->partner_size->addErrorMessage(str_replace("%s", $this->partner_size->caption(), $this->partner_size->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity->FormValue)) {
                $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
            }
            if ($this->price->Visible && $this->price->Required) {
                if (!$this->price->IsDetailKey && EmptyValue($this->price->FormValue)) {
                    $this->price->addErrorMessage(str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->price->FormValue)) {
                $this->price->addErrorMessage($this->price->getErrorMessage(false));
            }
            if ($this->amount->Visible && $this->amount->Required) {
                if (!$this->amount->IsDetailKey && EmptyValue($this->amount->FormValue)) {
                    $this->amount->addErrorMessage(str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->amount->FormValue)) {
                $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->po_id->Visible && $this->po_id->Required) {
                if (!$this->po_id->IsDetailKey && EmptyValue($this->po_id->FormValue)) {
                    $this->po_id->addErrorMessage(str_replace("%s", $this->po_id->caption(), $this->po_id->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->p_remarks->Visible && $this->p_remarks->Required) {
                if (!$this->p_remarks->IsDetailKey && EmptyValue($this->p_remarks->FormValue)) {
                    $this->p_remarks->addErrorMessage(str_replace("%s", $this->p_remarks->caption(), $this->p_remarks->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->AuditTrailOnDelete) {
            $this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        return $deleteRows;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // location
        $this->location->setDbValueDef($rsnew, $this->location->CurrentValue, $this->location->ReadOnly);

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, $this->company_id->ReadOnly);

        // partner_id
        $this->partner_id->setDbValueDef($rsnew, $this->partner_id->CurrentValue, $this->partner_id->ReadOnly);

        // partner_rid
        $this->partner_rid->setDbValueDef($rsnew, $this->partner_rid->CurrentValue, $this->partner_rid->ReadOnly);

        // product_type
        $this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, $this->product_type->ReadOnly);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, $this->s_grp->ReadOnly);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, $this->product->ReadOnly);

        // rid
        if ($this->rid->getSessionValue() != "") {
            $this->rid->ReadOnly = true;
        }
        $this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, $this->rid->ReadOnly);

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, $this->packing_type->ReadOnly);

        // batch_no
        $this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, $this->batch_no->ReadOnly);

        // shape
        $this->shape->setDbValueDef($rsnew, $this->shape->CurrentValue, $this->shape->ReadOnly);

        // unit
        $this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, $this->unit->ReadOnly);

        // w
        $this->w->setDbValueDef($rsnew, $this->w->CurrentValue, $this->w->ReadOnly);

        // w_cm
        $this->w_cm->setDbValueDef($rsnew, $this->w_cm->CurrentValue, $this->w_cm->ReadOnly);

        // l
        $this->l->setDbValueDef($rsnew, $this->l->CurrentValue, $this->l->ReadOnly);

        // l_cm
        $this->l_cm->setDbValueDef($rsnew, $this->l_cm->CurrentValue, $this->l_cm->ReadOnly);

        // h
        $this->h->setDbValueDef($rsnew, $this->h->CurrentValue, $this->h->ReadOnly);

        // h_cm
        $this->h_cm->setDbValueDef($rsnew, $this->h_cm->CurrentValue, $this->h_cm->ReadOnly);

        // partner_size
        $this->partner_size->setDbValueDef($rsnew, $this->partner_size->CurrentValue, $this->partner_size->ReadOnly);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, $this->quantity->ReadOnly);

        // price
        $this->price->setDbValueDef($rsnew, $this->price->CurrentValue, $this->price->ReadOnly);

        // amount
        $this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, $this->amount->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);

        // p_remarks
        $this->p_remarks->setDbValueDef($rsnew, $this->p_remarks->CurrentValue, $this->p_remarks->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['location'])) { // location
            $this->location->CurrentValue = $row['location'];
        }
        if (isset($row['company_id'])) { // company_id
            $this->company_id->CurrentValue = $row['company_id'];
        }
        if (isset($row['partner_id'])) { // partner_id
            $this->partner_id->CurrentValue = $row['partner_id'];
        }
        if (isset($row['partner_rid'])) { // partner_rid
            $this->partner_rid->CurrentValue = $row['partner_rid'];
        }
        if (isset($row['product_type'])) { // product_type
            $this->product_type->CurrentValue = $row['product_type'];
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->CurrentValue = $row['s_grp'];
        }
        if (isset($row['product'])) { // product
            $this->product->CurrentValue = $row['product'];
        }
        if (isset($row['rid'])) { // rid
            $this->rid->CurrentValue = $row['rid'];
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->CurrentValue = $row['packing_type'];
        }
        if (isset($row['batch_no'])) { // batch_no
            $this->batch_no->CurrentValue = $row['batch_no'];
        }
        if (isset($row['shape'])) { // shape
            $this->shape->CurrentValue = $row['shape'];
        }
        if (isset($row['unit'])) { // unit
            $this->unit->CurrentValue = $row['unit'];
        }
        if (isset($row['w'])) { // w
            $this->w->CurrentValue = $row['w'];
        }
        if (isset($row['w_cm'])) { // w_cm
            $this->w_cm->CurrentValue = $row['w_cm'];
        }
        if (isset($row['l'])) { // l
            $this->l->CurrentValue = $row['l'];
        }
        if (isset($row['l_cm'])) { // l_cm
            $this->l_cm->CurrentValue = $row['l_cm'];
        }
        if (isset($row['h'])) { // h
            $this->h->CurrentValue = $row['h'];
        }
        if (isset($row['h_cm'])) { // h_cm
            $this->h_cm->CurrentValue = $row['h_cm'];
        }
        if (isset($row['partner_size'])) { // partner_size
            $this->partner_size->CurrentValue = $row['partner_size'];
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->CurrentValue = $row['quantity'];
        }
        if (isset($row['price'])) { // price
            $this->price->CurrentValue = $row['price'];
        }
        if (isset($row['amount'])) { // amount
            $this->amount->CurrentValue = $row['amount'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['p_remarks'])) { // p_remarks
            $this->p_remarks->CurrentValue = $row['p_remarks'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Set up foreign key field value from Session
        if ($this->getCurrentMasterTable() == "material_status") {
            $this->rid->Visible = true; // Need to insert foreign key
            $this->rid->CurrentValue = $this->rid->getSessionValue();
        }

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // location
        $this->location->setDbValueDef($rsnew, $this->location->CurrentValue, strval($this->location->CurrentValue) == "");

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, false);

        // partner_id
        $this->partner_id->setDbValueDef($rsnew, $this->partner_id->CurrentValue, false);

        // partner_rid
        $this->partner_rid->setDbValueDef($rsnew, $this->partner_rid->CurrentValue, false);

        // product_type
        $this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, false);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, false);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, false);

        // rid
        $this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, false);

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, strval($this->packing_type->CurrentValue) == "");

        // batch_no
        $this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, false);

        // shape
        $this->shape->setDbValueDef($rsnew, $this->shape->CurrentValue, false);

        // unit
        $this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, false);

        // w
        $this->w->setDbValueDef($rsnew, $this->w->CurrentValue, false);

        // w_cm
        $this->w_cm->setDbValueDef($rsnew, $this->w_cm->CurrentValue, false);

        // l
        $this->l->setDbValueDef($rsnew, $this->l->CurrentValue, false);

        // l_cm
        $this->l_cm->setDbValueDef($rsnew, $this->l_cm->CurrentValue, false);

        // h
        $this->h->setDbValueDef($rsnew, $this->h->CurrentValue, false);

        // h_cm
        $this->h_cm->setDbValueDef($rsnew, $this->h_cm->CurrentValue, false);

        // partner_size
        $this->partner_size->setDbValueDef($rsnew, $this->partner_size->CurrentValue, false);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, false);

        // price
        $this->price->setDbValueDef($rsnew, $this->price->CurrentValue, false);

        // amount
        $this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, false);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, strval($this->status->CurrentValue) == "");

        // po_id
        $this->po_id->setDbValueDef($rsnew, $this->po_id->CurrentValue, false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // p_remarks
        $this->p_remarks->setDbValueDef($rsnew, $this->p_remarks->CurrentValue, strval($this->p_remarks->CurrentValue) == "");

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['location'])) { // location
            $this->location->setFormValue($row['location']);
        }
        if (isset($row['company_id'])) { // company_id
            $this->company_id->setFormValue($row['company_id']);
        }
        if (isset($row['partner_id'])) { // partner_id
            $this->partner_id->setFormValue($row['partner_id']);
        }
        if (isset($row['partner_rid'])) { // partner_rid
            $this->partner_rid->setFormValue($row['partner_rid']);
        }
        if (isset($row['product_type'])) { // product_type
            $this->product_type->setFormValue($row['product_type']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->setFormValue($row['s_grp']);
        }
        if (isset($row['product'])) { // product
            $this->product->setFormValue($row['product']);
        }
        if (isset($row['rid'])) { // rid
            $this->rid->setFormValue($row['rid']);
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->setFormValue($row['packing_type']);
        }
        if (isset($row['batch_no'])) { // batch_no
            $this->batch_no->setFormValue($row['batch_no']);
        }
        if (isset($row['shape'])) { // shape
            $this->shape->setFormValue($row['shape']);
        }
        if (isset($row['unit'])) { // unit
            $this->unit->setFormValue($row['unit']);
        }
        if (isset($row['w'])) { // w
            $this->w->setFormValue($row['w']);
        }
        if (isset($row['w_cm'])) { // w_cm
            $this->w_cm->setFormValue($row['w_cm']);
        }
        if (isset($row['l'])) { // l
            $this->l->setFormValue($row['l']);
        }
        if (isset($row['l_cm'])) { // l_cm
            $this->l_cm->setFormValue($row['l_cm']);
        }
        if (isset($row['h'])) { // h
            $this->h->setFormValue($row['h']);
        }
        if (isset($row['h_cm'])) { // h_cm
            $this->h_cm->setFormValue($row['h_cm']);
        }
        if (isset($row['partner_size'])) { // partner_size
            $this->partner_size->setFormValue($row['partner_size']);
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->setFormValue($row['quantity']);
        }
        if (isset($row['price'])) { // price
            $this->price->setFormValue($row['price']);
        }
        if (isset($row['amount'])) { // amount
            $this->amount->setFormValue($row['amount']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
        if (isset($row['po_id'])) { // po_id
            $this->po_id->setFormValue($row['po_id']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['p_remarks'])) { // p_remarks
            $this->p_remarks->setFormValue($row['p_remarks']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        // Hide foreign keys
        $masterTblVar = $this->getCurrentMasterTable();
        if ($masterTblVar == "material_status") {
            $masterTbl = Container("material_status");
            if ($masterTbl->EventCancelled) {
                $this->EventCancelled = true;
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_batch_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_unit":
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_po_id":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'product_cart_s');
    	$item = &$this->OtherOptions['action']->Add("Create Order");
    	$item->Body = "<button class=\"btn btn-danger ew-action\" onclick=\"javascript:CreateOrder()\">Create Order From Selected</button>";
    	$item->Visible = True;
    	$this->sqm->ReadOnly = True;
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }
}
