<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProductCartBWbcEdit extends ProductCartBWbc
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProductCartBWbcEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "productcartbwbcedit";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->level->setVisibility();
        $this->company_id->setVisibility();
        $this->partner_order_no->setVisibility();
        $this->reports_to->Visible = false;
        $this->location->setVisibility();
        $this->cart_id->Visible = false;
        $this->po_id->setVisibility();
        $this->partner_id->setVisibility();
        $this->partner_rid->setVisibility();
        $this->partner_code->setVisibility();
        $this->product_type->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->packing_type->setVisibility();
        $this->batch_no->setVisibility();
        $this->unit->Visible = false;
        $this->shape->Visible = false;
        $this->partner_size->Visible = false;
        $this->size->Visible = false;
        $this->rid_1->Visible = false;
        $this->hsn_code->Visible = false;
        $this->quantity->setVisibility();
        $this->despatch_date->Visible = false;
        $this->pkt_quantity->Visible = false;
        $this->multiprice_id->Visible = false;
        $this->price->setVisibility();
        $this->currency->setVisibility();
        $this->discount_price->Visible = false;
        $this->amount->setVisibility();
        $this->cart_amount->Visible = false;
        $this->label->Visible = false;
        $this->cbm->Visible = false;
        $this->sqm->Visible = false;
        $this->sqm_u->Visible = false;
        $this->tax->Visible = false;
        $this->tax_amount->Visible = false;
        $this->shipping_method->Visible = false;
        $this->shipping_local->Visible = false;
        $this->shipping_abroad->Visible = false;
        $this->shipping_charge->setVisibility();
        $this->additional_discount->Visible = false;
        $this->total_amount->Visible = false;
        $this->status->setVisibility();
        $this->remarks->setVisibility();
        $this->buyer_uid->Visible = false;
        $this->buyer_loc->Visible = false;
        $this->operator->setVisibility();
        $this->o_datetime->Visible = false;
        $this->datetime->setVisibility();
        $this->q_sku->Visible = false;
        $this->w->Visible = false;
        $this->l->Visible = false;
        $this->h->Visible = false;
        $this->w_cm->Visible = false;
        $this->l_cm->Visible = false;
        $this->h_cm->Visible = false;
        $this->c_total->Visible = false;
        $this->_1->Visible = false;
        $this->_2->Visible = false;
        $this->_3->Visible = false;
        $this->_4->Visible = false;
        $this->_5->Visible = false;
        $this->_6->Visible = false;
        $this->_7->Visible = false;
        $this->_8->Visible = false;
        $this->_9->Visible = false;
        $this->_10->Visible = false;
        $this->_11->Visible = false;
        $this->_12->Visible = false;
        $this->r_text->Visible = false;
        $this->t_id->Visible = false;
        $this->m_out_id->Visible = false;
        $this->pam_qty->Visible = false;
        $this->grp_type->Visible = false;
        $this->image->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'product_cart_b_wbc';
        $this->TableName = 'product_cart_b_wbc';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (product_cart_b_wbc)
        if (!isset($GLOBALS["product_cart_b_wbc"]) || $GLOBALS["product_cart_b_wbc"]::class == PROJECT_NAMESPACE . "product_cart_b_wbc") {
            $GLOBALS["product_cart_b_wbc"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_cart_b_wbc');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "productcartbwbcview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->po_id->Required = false;
        $this->grp->Required = false;
        $this->rid->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->level);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->po_id);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->partner_rid);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Load record by position
        $loadByPosition = false;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
                if (!$loadByQuery || Get(Config("TABLE_START_REC")) !== null || Get(Config("TABLE_PAGE_NUMBER")) !== null) {
                    $loadByPosition = true;
                }
            }

            // Load result set
            if ($this->isShow()) {
                if (!$this->IsModal) { // Normal edit page
                    $this->StartRecord = 1; // Initialize start position
                    $this->Recordset = $this->loadRecordset(); // Load records
                    if ($this->TotalRecords <= 0) { // No record found
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $this->terminate("productcartbwbclist"); // Return to list page
                        return;
                    } elseif ($loadByPosition) { // Load record by position
                        $this->setupStartRecord(); // Set up start record position
                        // Point to current record
                        if ($this->StartRecord <= $this->TotalRecords) {
                            $this->fetch($this->StartRecord);
                            // Redirect to correct record
                            $this->loadRowValues($this->CurrentRow);
                            $url = $this->getCurrentUrl();
                            $this->terminate($url);
                            return;
                        }
                    } else { // Match key values
                        if ($this->id->CurrentValue != null) {
                            while ($this->fetch()) {
                                if (SameString($this->id->CurrentValue, $this->CurrentRow['id'])) {
                                    $this->setStartRecordNumber($this->StartRecord); // Save record position
                                    $loaded = true;
                                    break;
                                } else {
                                    $this->StartRecord++;
                                }
                            }
                        }
                    }

                    // Load current row values
                    if ($loaded) {
                        $this->loadRowValues($this->CurrentRow);
                    }
                } else {
                    // Load current record
                    $loaded = $this->loadRow();
                } // End modal checking
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                if (!$this->IsModal) { // Normal edit page
                    if (!$loaded) {
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $this->terminate("productcartbwbclist"); // Return to list page
                        return;
                    } else {
                    }
                } else { // Modal edit page
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("productcartbwbclist"); // No matching record, return to list
                        return;
                    }
                } // End modal checking
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "productcartbwbclist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "productcartbwbclist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "productcartbwbclist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();
        if (!$this->IsModal) { // Normal view page
            $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, "", $this->RecordRange, $this->AutoHidePager, false, false);
            $this->Pager->PageNumberName = Config("TABLE_PAGE_NUMBER");
            $this->Pager->PagePhraseId = "Record"; // Show as record
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->image->Upload->Index = $CurrentForm->Index;
        $this->image->Upload->uploadFile();
        $this->image->CurrentValue = $this->image->Upload->FileName;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'level' first before field var 'x_level'
        $val = $CurrentForm->hasValue("level") ? $CurrentForm->getValue("level") : $CurrentForm->getValue("x_level");
        if (!$this->level->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->level->Visible = false; // Disable update for API request
            } else {
                $this->level->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val);
            }
        }

        // Check field name 'partner_order_no' first before field var 'x_partner_order_no'
        $val = $CurrentForm->hasValue("partner_order_no") ? $CurrentForm->getValue("partner_order_no") : $CurrentForm->getValue("x_partner_order_no");
        if (!$this->partner_order_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_order_no->Visible = false; // Disable update for API request
            } else {
                $this->partner_order_no->setFormValue($val);
            }
        }

        // Check field name 'location' first before field var 'x_location'
        $val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
        if (!$this->location->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->location->Visible = false; // Disable update for API request
            } else {
                $this->location->setFormValue($val);
            }
        }

        // Check field name 'po_id' first before field var 'x_po_id'
        $val = $CurrentForm->hasValue("po_id") ? $CurrentForm->getValue("po_id") : $CurrentForm->getValue("x_po_id");
        if (!$this->po_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_id->Visible = false; // Disable update for API request
            } else {
                $this->po_id->setFormValue($val);
            }
        }

        // Check field name 'partner_id' first before field var 'x_partner_id'
        $val = $CurrentForm->hasValue("partner_id") ? $CurrentForm->getValue("partner_id") : $CurrentForm->getValue("x_partner_id");
        if (!$this->partner_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_id->Visible = false; // Disable update for API request
            } else {
                $this->partner_id->setFormValue($val);
            }
        }

        // Check field name 'partner_rid' first before field var 'x_partner_rid'
        $val = $CurrentForm->hasValue("partner_rid") ? $CurrentForm->getValue("partner_rid") : $CurrentForm->getValue("x_partner_rid");
        if (!$this->partner_rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_rid->Visible = false; // Disable update for API request
            } else {
                $this->partner_rid->setFormValue($val);
            }
        }

        // Check field name 'partner_code' first before field var 'x_partner_code'
        $val = $CurrentForm->hasValue("partner_code") ? $CurrentForm->getValue("partner_code") : $CurrentForm->getValue("x_partner_code");
        if (!$this->partner_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_code->Visible = false; // Disable update for API request
            } else {
                $this->partner_code->setFormValue($val);
            }
        }

        // Check field name 'product_type' first before field var 'x_product_type'
        $val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
        if (!$this->product_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_type->Visible = false; // Disable update for API request
            } else {
                $this->product_type->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val);
            }
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val);
            }
        }

        // Check field name 'batch_no' first before field var 'x_batch_no'
        $val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
        if (!$this->batch_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_no->Visible = false; // Disable update for API request
            } else {
                $this->batch_no->setFormValue($val);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'price' first before field var 'x_price'
        $val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
        if (!$this->price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->price->Visible = false; // Disable update for API request
            } else {
                $this->price->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'currency' first before field var 'x_currency'
        $val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
        if (!$this->currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->currency->Visible = false; // Disable update for API request
            } else {
                $this->currency->setFormValue($val);
            }
        }

        // Check field name 'amount' first before field var 'x_amount'
        $val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
        if (!$this->amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount->Visible = false; // Disable update for API request
            } else {
                $this->amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'shipping_charge' first before field var 'x_shipping_charge'
        $val = $CurrentForm->hasValue("shipping_charge") ? $CurrentForm->getValue("shipping_charge") : $CurrentForm->getValue("x_shipping_charge");
        if (!$this->shipping_charge->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shipping_charge->Visible = false; // Disable update for API request
            } else {
                $this->shipping_charge->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
		$this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
		$this->image->UploadPath = $this->image->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->level->CurrentValue = $this->level->FormValue;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->partner_order_no->CurrentValue = $this->partner_order_no->FormValue;
        $this->location->CurrentValue = $this->location->FormValue;
        $this->po_id->CurrentValue = $this->po_id->FormValue;
        $this->partner_id->CurrentValue = $this->partner_id->FormValue;
        $this->partner_rid->CurrentValue = $this->partner_rid->FormValue;
        $this->partner_code->CurrentValue = $this->partner_code->FormValue;
        $this->product_type->CurrentValue = $this->product_type->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->batch_no->CurrentValue = $this->batch_no->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->price->CurrentValue = $this->price->FormValue;
        $this->currency->CurrentValue = $this->currency->FormValue;
        $this->amount->CurrentValue = $this->amount->FormValue;
        $this->shipping_charge->CurrentValue = $this->shipping_charge->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->level->setDbValue($row['level']);
        $this->company_id->setDbValue($row['company_id']);
        $this->partner_order_no->setDbValue($row['partner_order_no']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->location->setDbValue($row['location']);
        $this->cart_id->setDbValue($row['cart_id']);
        $this->po_id->setDbValue($row['po_id']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->partner_rid->setDbValue($row['partner_rid']);
        $this->partner_code->setDbValue($row['partner_code']);
        $this->product_type->setDbValue($row['product_type']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->unit->setDbValue($row['unit']);
        $this->shape->setDbValue($row['shape']);
        $this->partner_size->setDbValue($row['partner_size']);
        $this->size->setDbValue($row['size']);
        $this->rid_1->setDbValue($row['rid_1']);
        $this->hsn_code->setDbValue($row['hsn_code']);
        $this->quantity->setDbValue($row['quantity']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->pkt_quantity->setDbValue($row['pkt_quantity']);
        $this->multiprice_id->setDbValue($row['multiprice_id']);
        $this->price->setDbValue($row['price']);
        $this->currency->setDbValue($row['currency']);
        $this->discount_price->setDbValue($row['discount_price']);
        $this->amount->setDbValue($row['amount']);
        $this->cart_amount->setDbValue($row['cart_amount']);
        $this->label->setDbValue($row['label']);
        $this->cbm->setDbValue($row['cbm']);
        $this->sqm->setDbValue($row['sqm']);
        $this->sqm_u->setDbValue($row['sqm_u']);
        $this->tax->setDbValue($row['tax']);
        $this->tax_amount->setDbValue($row['tax_amount']);
        $this->shipping_method->setDbValue($row['shipping_method']);
        $this->shipping_local->setDbValue($row['shipping_local']);
        $this->shipping_abroad->setDbValue($row['shipping_abroad']);
        $this->shipping_charge->setDbValue($row['shipping_charge']);
        $this->additional_discount->setDbValue($row['additional_discount']);
        $this->total_amount->setDbValue($row['total_amount']);
        $this->status->setDbValue($row['status']);
        $this->remarks->setDbValue($row['remarks']);
        $this->buyer_uid->setDbValue($row['buyer_uid']);
        $this->buyer_loc->setDbValue($row['buyer_loc']);
        $this->operator->setDbValue($row['operator']);
        $this->o_datetime->setDbValue($row['o_datetime']);
        $this->datetime->setDbValue($row['datetime']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->w->setDbValue($row['w']);
        $this->l->setDbValue($row['l']);
        $this->h->setDbValue($row['h']);
        $this->w_cm->setDbValue($row['w_cm']);
        $this->l_cm->setDbValue($row['l_cm']);
        $this->h_cm->setDbValue($row['h_cm']);
        $this->c_total->setDbValue($row['c_total']);
        $this->_1->setDbValue($row['1']);
        $this->_2->setDbValue($row['2']);
        $this->_3->setDbValue($row['3']);
        $this->_4->setDbValue($row['4']);
        $this->_5->setDbValue($row['5']);
        $this->_6->setDbValue($row['6']);
        $this->_7->setDbValue($row['7']);
        $this->_8->setDbValue($row['8']);
        $this->_9->setDbValue($row['9']);
        $this->_10->setDbValue($row['10']);
        $this->_11->setDbValue($row['11']);
        $this->_12->setDbValue($row['12']);
        $this->r_text->setDbValue($row['r_text']);
        $this->t_id->setDbValue($row['t_id']);
        $this->m_out_id->setDbValue($row['m_out_id']);
        $this->pam_qty->setDbValue($row['pam_qty']);
        $this->grp_type->setDbValue($row['grp_type']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['level'] = $this->level->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['partner_order_no'] = $this->partner_order_no->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['cart_id'] = $this->cart_id->DefaultValue;
        $row['po_id'] = $this->po_id->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['partner_rid'] = $this->partner_rid->DefaultValue;
        $row['partner_code'] = $this->partner_code->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['partner_size'] = $this->partner_size->DefaultValue;
        $row['size'] = $this->size->DefaultValue;
        $row['rid_1'] = $this->rid_1->DefaultValue;
        $row['hsn_code'] = $this->hsn_code->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['pkt_quantity'] = $this->pkt_quantity->DefaultValue;
        $row['multiprice_id'] = $this->multiprice_id->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['discount_price'] = $this->discount_price->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['cart_amount'] = $this->cart_amount->DefaultValue;
        $row['label'] = $this->label->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['sqm_u'] = $this->sqm_u->DefaultValue;
        $row['tax'] = $this->tax->DefaultValue;
        $row['tax_amount'] = $this->tax_amount->DefaultValue;
        $row['shipping_method'] = $this->shipping_method->DefaultValue;
        $row['shipping_local'] = $this->shipping_local->DefaultValue;
        $row['shipping_abroad'] = $this->shipping_abroad->DefaultValue;
        $row['shipping_charge'] = $this->shipping_charge->DefaultValue;
        $row['additional_discount'] = $this->additional_discount->DefaultValue;
        $row['total_amount'] = $this->total_amount->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['buyer_uid'] = $this->buyer_uid->DefaultValue;
        $row['buyer_loc'] = $this->buyer_loc->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['o_datetime'] = $this->o_datetime->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['q_sku'] = $this->q_sku->DefaultValue;
        $row['w'] = $this->w->DefaultValue;
        $row['l'] = $this->l->DefaultValue;
        $row['h'] = $this->h->DefaultValue;
        $row['w_cm'] = $this->w_cm->DefaultValue;
        $row['l_cm'] = $this->l_cm->DefaultValue;
        $row['h_cm'] = $this->h_cm->DefaultValue;
        $row['c_total'] = $this->c_total->DefaultValue;
        $row['1'] = $this->_1->DefaultValue;
        $row['2'] = $this->_2->DefaultValue;
        $row['3'] = $this->_3->DefaultValue;
        $row['4'] = $this->_4->DefaultValue;
        $row['5'] = $this->_5->DefaultValue;
        $row['6'] = $this->_6->DefaultValue;
        $row['7'] = $this->_7->DefaultValue;
        $row['8'] = $this->_8->DefaultValue;
        $row['9'] = $this->_9->DefaultValue;
        $row['10'] = $this->_10->DefaultValue;
        $row['11'] = $this->_11->DefaultValue;
        $row['12'] = $this->_12->DefaultValue;
        $row['r_text'] = $this->r_text->DefaultValue;
        $row['t_id'] = $this->t_id->DefaultValue;
        $row['m_out_id'] = $this->m_out_id->DefaultValue;
        $row['pam_qty'] = $this->pam_qty->DefaultValue;
        $row['grp_type'] = $this->grp_type->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // level
        $this->level->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // partner_order_no
        $this->partner_order_no->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // cart_id
        $this->cart_id->RowCssClass = "row";

        // po_id
        $this->po_id->RowCssClass = "row";

        // partner_id
        $this->partner_id->RowCssClass = "row";

        // partner_rid
        $this->partner_rid->RowCssClass = "row";

        // partner_code
        $this->partner_code->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // unit
        $this->unit->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // partner_size
        $this->partner_size->RowCssClass = "row";

        // size
        $this->size->RowCssClass = "row";

        // rid_1
        $this->rid_1->RowCssClass = "row";

        // hsn_code
        $this->hsn_code->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // despatch_date
        $this->despatch_date->RowCssClass = "row";

        // pkt_quantity
        $this->pkt_quantity->RowCssClass = "row";

        // multiprice_id
        $this->multiprice_id->RowCssClass = "row";

        // price
        $this->price->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // discount_price
        $this->discount_price->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // cart_amount
        $this->cart_amount->RowCssClass = "row";

        // label
        $this->label->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // sqm_u
        $this->sqm_u->RowCssClass = "row";

        // tax
        $this->tax->RowCssClass = "row";

        // tax_amount
        $this->tax_amount->RowCssClass = "row";

        // shipping_method
        $this->shipping_method->RowCssClass = "row";

        // shipping_local
        $this->shipping_local->RowCssClass = "row";

        // shipping_abroad
        $this->shipping_abroad->RowCssClass = "row";

        // shipping_charge
        $this->shipping_charge->RowCssClass = "row";

        // additional_discount
        $this->additional_discount->RowCssClass = "row";

        // total_amount
        $this->total_amount->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // buyer_uid
        $this->buyer_uid->RowCssClass = "row";

        // buyer_loc
        $this->buyer_loc->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // o_datetime
        $this->o_datetime->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // q_sku
        $this->q_sku->RowCssClass = "row";

        // w
        $this->w->RowCssClass = "row";

        // l
        $this->l->RowCssClass = "row";

        // h
        $this->h->RowCssClass = "row";

        // w_cm
        $this->w_cm->RowCssClass = "row";

        // l_cm
        $this->l_cm->RowCssClass = "row";

        // h_cm
        $this->h_cm->RowCssClass = "row";

        // c_total
        $this->c_total->RowCssClass = "row";

        // 1
        $this->_1->RowCssClass = "row";

        // 2
        $this->_2->RowCssClass = "row";

        // 3
        $this->_3->RowCssClass = "row";

        // 4
        $this->_4->RowCssClass = "row";

        // 5
        $this->_5->RowCssClass = "row";

        // 6
        $this->_6->RowCssClass = "row";

        // 7
        $this->_7->RowCssClass = "row";

        // 8
        $this->_8->RowCssClass = "row";

        // 9
        $this->_9->RowCssClass = "row";

        // 10
        $this->_10->RowCssClass = "row";

        // 11
        $this->_11->RowCssClass = "row";

        // 12
        $this->_12->RowCssClass = "row";

        // r_text
        $this->r_text->RowCssClass = "row";

        // t_id
        $this->t_id->RowCssClass = "row";

        // m_out_id
        $this->m_out_id->RowCssClass = "row";

        // pam_qty
        $this->pam_qty->RowCssClass = "row";

        // grp_type
        $this->grp_type->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // level
            $this->level->ViewValue = $this->level->CurrentValue;

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // partner_order_no
            $this->partner_order_no->ViewValue = $this->partner_order_no->CurrentValue;

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                        $this->location->ViewValue = $this->location->displayValue($arwrk);
                    } else {
                        $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // po_id
            $curVal = strval($this->po_id->CurrentValue);
            if ($curVal != "") {
                $this->po_id->ViewValue = $this->po_id->lookupCacheOption($curVal);
                if ($this->po_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_id->Lookup->renderViewRow($rswrk[0]);
                        $this->po_id->ViewValue = $this->po_id->displayValue($arwrk);
                    } else {
                        $this->po_id->ViewValue = FormatNumber($this->po_id->CurrentValue, $this->po_id->formatPattern());
                    }
                }
            } else {
                $this->po_id->ViewValue = null;
            }

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // partner_rid
            $this->partner_rid->ViewValue = $this->partner_rid->CurrentValue;
            $curVal = strval($this->partner_rid->CurrentValue);
            if ($curVal != "") {
                $this->partner_rid->ViewValue = $this->partner_rid->lookupCacheOption($curVal);
                if ($this->partner_rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_rid->ViewValue = $this->partner_rid->displayValue($arwrk);
                    } else {
                        $this->partner_rid->ViewValue = $this->partner_rid->CurrentValue;
                    }
                }
            } else {
                $this->partner_rid->ViewValue = null;
            }

            // partner_code
            $this->partner_code->ViewValue = $this->partner_code->CurrentValue;

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                        $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                    } else {
                        $this->product_type->ViewValue = FormatNumber($this->product_type->CurrentValue, $this->product_type->formatPattern());
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // batch_no
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // shipping_charge
            $this->shipping_charge->ViewValue = $this->shipping_charge->CurrentValue;
            $this->shipping_charge->ViewValue = FormatNumber($this->shipping_charge->ViewValue, $this->shipping_charge->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ImageWidth = 40;
                $this->image->ImageHeight = 40;
                $this->image->ImageAlt = $this->image->alt();
                $this->image->ImageCssClass = "ew-image";
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // id
            $this->id->HrefValue = "";

            // level
            $this->level->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // partner_order_no
            $this->partner_order_no->HrefValue = "";

            // location
            $this->location->HrefValue = "";

            // po_id
            if (!EmptyValue($this->po_id->CurrentValue)) {
                $this->po_id->HrefValue = $this->po_id->getLinkPrefix() . $this->po_id->CurrentValue; // Add prefix/suffix
                $this->po_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->po_id->HrefValue = FullUrl($this->po_id->HrefValue, "href");
                }
            } else {
                $this->po_id->HrefValue = "";
            }
            $this->po_id->TooltipValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";

            // partner_rid
            $this->partner_rid->HrefValue = "";

            // partner_code
            $this->partner_code->HrefValue = "";

            // product_type
            $this->product_type->HrefValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }
            $this->grp->TooltipValue = "";

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid
            $this->rid->HrefValue = "";
            $this->rid->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // shipping_charge
            $this->shipping_charge->HrefValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->HrefValue = "%u"; // Add prefix/suffix
                $this->image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
                }
            } else {
                $this->image->HrefValue = "";
            }
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // level
            $this->level->setupEditAttributes();
            $this->level->EditValue = $this->level->CurrentValue;
            $this->level->PlaceHolder = RemoveHtml($this->level->caption());

            // company_id
            $curVal = trim(strval($this->company_id->CurrentValue));
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
                if ($this->company_id->ViewValue == "") {
                    $this->company_id->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->CurrentValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                    $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                } else {
                    $this->company_id->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // partner_order_no
            $this->partner_order_no->setupEditAttributes();
            if (!$this->partner_order_no->Raw) {
                $this->partner_order_no->CurrentValue = HtmlDecode($this->partner_order_no->CurrentValue);
            }
            $this->partner_order_no->EditValue = HtmlEncode($this->partner_order_no->CurrentValue);
            $this->partner_order_no->PlaceHolder = RemoveHtml($this->partner_order_no->caption());

            // location
            $this->location->setupEditAttributes();
            $curVal = trim(strval($this->location->CurrentValue));
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->location->CurrentValue, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // po_id
            $this->po_id->setupEditAttributes();
            $curVal = strval($this->po_id->CurrentValue);
            if ($curVal != "") {
                $this->po_id->EditValue = $this->po_id->lookupCacheOption($curVal);
                if ($this->po_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_id->Lookup->renderViewRow($rswrk[0]);
                        $this->po_id->EditValue = $this->po_id->displayValue($arwrk);
                    } else {
                        $this->po_id->EditValue = FormatNumber($this->po_id->CurrentValue, $this->po_id->formatPattern());
                    }
                }
            } else {
                $this->po_id->EditValue = null;
            }

            // partner_id
            $this->partner_id->setupEditAttributes();
            $this->partner_id->EditValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->EditValue = HtmlEncode($this->partner_id->CurrentValue);
                    }
                }
            } else {
                $this->partner_id->EditValue = null;
            }
            $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

            // partner_rid
            $this->partner_rid->setupEditAttributes();
            if (!$this->partner_rid->Raw) {
                $this->partner_rid->CurrentValue = HtmlDecode($this->partner_rid->CurrentValue);
            }
            $this->partner_rid->EditValue = HtmlEncode($this->partner_rid->CurrentValue);
            $curVal = strval($this->partner_rid->CurrentValue);
            if ($curVal != "") {
                $this->partner_rid->EditValue = $this->partner_rid->lookupCacheOption($curVal);
                if ($this->partner_rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_rid->EditValue = $this->partner_rid->displayValue($arwrk);
                    } else {
                        $this->partner_rid->EditValue = HtmlEncode($this->partner_rid->CurrentValue);
                    }
                }
            } else {
                $this->partner_rid->EditValue = null;
            }
            $this->partner_rid->PlaceHolder = RemoveHtml($this->partner_rid->caption());

            // partner_code
            $this->partner_code->setupEditAttributes();
            if (!$this->partner_code->Raw) {
                $this->partner_code->CurrentValue = HtmlDecode($this->partner_code->CurrentValue);
            }
            $this->partner_code->EditValue = HtmlEncode($this->partner_code->CurrentValue);
            $this->partner_code->PlaceHolder = RemoveHtml($this->partner_code->caption());

            // product_type
            $this->product_type->setupEditAttributes();
            $curVal = trim(strval($this->product_type->CurrentValue));
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
            } else {
                $this->product_type->ViewValue = $this->product_type->Lookup !== null && is_array($this->product_type->lookupOptions()) && count($this->product_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_type->ViewValue !== null) { // Load from cache
                $this->product_type->EditValue = array_values($this->product_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product_type->CurrentValue, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product_type->EditValue = $arwrk;
            }
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->EditValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->EditValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->EditValue = null;
            }

            // s_grp
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
                if ($this->s_grp->ViewValue == "") {
                    $this->s_grp->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
                if ($this->product->ViewValue == "") {
                    $this->product->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid
            $this->rid->setupEditAttributes();
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->EditValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->EditValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->EditValue = null;
            }

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->CurrentValue));
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->CurrentValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // batch_no
            $curVal = trim(strval($this->batch_no->CurrentValue));
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            } else {
                $this->batch_no->ViewValue = $this->batch_no->Lookup !== null && is_array($this->batch_no->lookupOptions()) && count($this->batch_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->batch_no->ViewValue !== null) { // Load from cache
                $this->batch_no->EditValue = array_values($this->batch_no->lookupOptions());
                if ($this->batch_no->ViewValue == "") {
                    $this->batch_no->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->batch_no->CurrentValue, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->batch_no->EditValue = $arwrk;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // price
            $this->price->setupEditAttributes();
            $this->price->EditValue = $this->price->CurrentValue;
            $this->price->PlaceHolder = RemoveHtml($this->price->caption());
            if (strval($this->price->EditValue) != "" && is_numeric($this->price->EditValue)) {
                $this->price->EditValue = FormatNumber($this->price->EditValue, null);
            }

            // currency
            $this->currency->setupEditAttributes();
            $curVal = trim(strval($this->currency->CurrentValue));
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
            } else {
                $this->currency->ViewValue = $this->currency->Lookup !== null && is_array($this->currency->lookupOptions()) && count($this->currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->currency->ViewValue !== null) { // Load from cache
                $this->currency->EditValue = array_values($this->currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->currency->CurrentValue, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->currency->EditValue = $arwrk;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditCustomAttributes = $this->amount->getEditCustomAttributes(); // PHP
            $this->amount->EditValue = $this->amount->CurrentValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
            if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
                $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
            }

            // shipping_charge
            $this->shipping_charge->setupEditAttributes();
            $this->shipping_charge->EditValue = $this->shipping_charge->CurrentValue;
            $this->shipping_charge->PlaceHolder = RemoveHtml($this->shipping_charge->caption());
            if (strval($this->shipping_charge->EditValue) != "" && is_numeric($this->shipping_charge->EditValue)) {
                $this->shipping_charge->EditValue = FormatNumber($this->shipping_charge->EditValue, null);
            }

            // status
            $this->status->setupEditAttributes();
            if (strval($this->status->CurrentValue) != "") {
                $this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->EditValue = null;
            }

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // operator

            // datetime

            // image
            $this->image->setupEditAttributes();
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ImageWidth = 40;
                $this->image->ImageHeight = 40;
                $this->image->ImageAlt = $this->image->alt();
                $this->image->ImageCssClass = "ew-image";
                $this->image->EditValue = $this->image->Upload->DbValue;
            } else {
                $this->image->EditValue = "";
            }
            if (!EmptyValue($this->image->CurrentValue)) {
                $this->image->Upload->FileName = $this->image->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->image);
            }

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // level
            $this->level->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // partner_order_no
            $this->partner_order_no->HrefValue = "";

            // location
            $this->location->HrefValue = "";

            // po_id
            if (!EmptyValue($this->po_id->CurrentValue)) {
                $this->po_id->HrefValue = $this->po_id->getLinkPrefix() . $this->po_id->CurrentValue; // Add prefix/suffix
                $this->po_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->po_id->HrefValue = FullUrl($this->po_id->HrefValue, "href");
                }
            } else {
                $this->po_id->HrefValue = "";
            }
            $this->po_id->TooltipValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";

            // partner_rid
            $this->partner_rid->HrefValue = "";

            // partner_code
            $this->partner_code->HrefValue = "";

            // product_type
            $this->product_type->HrefValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }
            $this->grp->TooltipValue = "";

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid
            $this->rid->HrefValue = "";
            $this->rid->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // shipping_charge
            $this->shipping_charge->HrefValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->HrefValue = "%u"; // Add prefix/suffix
                $this->image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
                }
            } else {
                $this->image->HrefValue = "";
            }
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->level->Visible && $this->level->Required) {
                if (!$this->level->IsDetailKey && EmptyValue($this->level->FormValue)) {
                    $this->level->addErrorMessage(str_replace("%s", $this->level->caption(), $this->level->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->level->FormValue)) {
                $this->level->addErrorMessage($this->level->getErrorMessage(false));
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if ($this->company_id->FormValue == "") {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if ($this->partner_order_no->Visible && $this->partner_order_no->Required) {
                if (!$this->partner_order_no->IsDetailKey && EmptyValue($this->partner_order_no->FormValue)) {
                    $this->partner_order_no->addErrorMessage(str_replace("%s", $this->partner_order_no->caption(), $this->partner_order_no->RequiredErrorMessage));
                }
            }
            if ($this->location->Visible && $this->location->Required) {
                if (!$this->location->IsDetailKey && EmptyValue($this->location->FormValue)) {
                    $this->location->addErrorMessage(str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
                }
            }
            if ($this->po_id->Visible && $this->po_id->Required) {
                if (!$this->po_id->IsDetailKey && EmptyValue($this->po_id->FormValue)) {
                    $this->po_id->addErrorMessage(str_replace("%s", $this->po_id->caption(), $this->po_id->RequiredErrorMessage));
                }
            }
            if ($this->partner_id->Visible && $this->partner_id->Required) {
                if (!$this->partner_id->IsDetailKey && EmptyValue($this->partner_id->FormValue)) {
                    $this->partner_id->addErrorMessage(str_replace("%s", $this->partner_id->caption(), $this->partner_id->RequiredErrorMessage));
                }
            }
            if ($this->partner_rid->Visible && $this->partner_rid->Required) {
                if (!$this->partner_rid->IsDetailKey && EmptyValue($this->partner_rid->FormValue)) {
                    $this->partner_rid->addErrorMessage(str_replace("%s", $this->partner_rid->caption(), $this->partner_rid->RequiredErrorMessage));
                }
            }
            if ($this->partner_code->Visible && $this->partner_code->Required) {
                if (!$this->partner_code->IsDetailKey && EmptyValue($this->partner_code->FormValue)) {
                    $this->partner_code->addErrorMessage(str_replace("%s", $this->partner_code->caption(), $this->partner_code->RequiredErrorMessage));
                }
            }
            if ($this->product_type->Visible && $this->product_type->Required) {
                if (!$this->product_type->IsDetailKey && EmptyValue($this->product_type->FormValue)) {
                    $this->product_type->addErrorMessage(str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if (!$this->rid->IsDetailKey && EmptyValue($this->rid->FormValue)) {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->batch_no->Visible && $this->batch_no->Required) {
                if (!$this->batch_no->IsDetailKey && EmptyValue($this->batch_no->FormValue)) {
                    $this->batch_no->addErrorMessage(str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity->FormValue)) {
                $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
            }
            if ($this->price->Visible && $this->price->Required) {
                if (!$this->price->IsDetailKey && EmptyValue($this->price->FormValue)) {
                    $this->price->addErrorMessage(str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->price->FormValue)) {
                $this->price->addErrorMessage($this->price->getErrorMessage(false));
            }
            if ($this->currency->Visible && $this->currency->Required) {
                if (!$this->currency->IsDetailKey && EmptyValue($this->currency->FormValue)) {
                    $this->currency->addErrorMessage(str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
                }
            }
            if ($this->amount->Visible && $this->amount->Required) {
                if (!$this->amount->IsDetailKey && EmptyValue($this->amount->FormValue)) {
                    $this->amount->addErrorMessage(str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->amount->FormValue)) {
                $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
            }
            if ($this->shipping_charge->Visible && $this->shipping_charge->Required) {
                if (!$this->shipping_charge->IsDetailKey && EmptyValue($this->shipping_charge->FormValue)) {
                    $this->shipping_charge->addErrorMessage(str_replace("%s", $this->shipping_charge->caption(), $this->shipping_charge->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->shipping_charge->FormValue)) {
                $this->shipping_charge->addErrorMessage($this->shipping_charge->getErrorMessage(false));
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->image->Visible && $this->image->Required) {
                if ($this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
                    $this->image->addErrorMessage(str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->image->Visible && !$this->image->Upload->KeepFile) {
            $this->image->UploadPath = $this->image->getUploadPath();
            if (!EmptyValue($this->image->Upload->FileName)) {
                FixUploadFileNames($this->image);
                $this->image->setDbValueDef($rsnew, $this->image->Upload->FileName, $this->image->ReadOnly);
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
                if ($this->image->Visible && !$this->image->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->image, $rsnew['image'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $this->image->UploadPath = $this->image->OldUploadPath;
        $rsnew = [];

        // level
        $this->level->setDbValueDef($rsnew, $this->level->CurrentValue, $this->level->ReadOnly);

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, $this->company_id->ReadOnly);

        // partner_order_no
        $this->partner_order_no->setDbValueDef($rsnew, $this->partner_order_no->CurrentValue, $this->partner_order_no->ReadOnly);

        // location
        $this->location->setDbValueDef($rsnew, $this->location->CurrentValue, $this->location->ReadOnly);

        // partner_id
        $this->partner_id->setDbValueDef($rsnew, $this->partner_id->CurrentValue, $this->partner_id->ReadOnly);

        // partner_rid
        $this->partner_rid->setDbValueDef($rsnew, $this->partner_rid->CurrentValue, $this->partner_rid->ReadOnly);

        // partner_code
        $this->partner_code->setDbValueDef($rsnew, $this->partner_code->CurrentValue, $this->partner_code->ReadOnly);

        // product_type
        $this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, $this->product_type->ReadOnly);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, $this->s_grp->ReadOnly);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, $this->product->ReadOnly);

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, $this->packing_type->ReadOnly);

        // batch_no
        $this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, $this->batch_no->ReadOnly);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, $this->quantity->ReadOnly);

        // price
        $this->price->setDbValueDef($rsnew, $this->price->CurrentValue, $this->price->ReadOnly);

        // currency
        $this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, $this->currency->ReadOnly);

        // amount
        $this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, $this->amount->ReadOnly);

        // shipping_charge
        $this->shipping_charge->setDbValueDef($rsnew, $this->shipping_charge->CurrentValue, $this->shipping_charge->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);

        // image
        if ($this->image->Visible && !$this->image->ReadOnly && !$this->image->Upload->KeepFile) {
            if ($this->image->Upload->FileName == "") {
                $rsnew['image'] = null;
            } else {
                FixUploadTempFileNames($this->image);
                $rsnew['image'] = $this->image->Upload->FileName;
            }
            $this->image->ImageWidth = 640; // Resize width
            $this->image->ImageHeight = 640; // Resize height
        }
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['level'])) { // level
            $this->level->CurrentValue = $row['level'];
        }
        if (isset($row['company_id'])) { // company_id
            $this->company_id->CurrentValue = $row['company_id'];
        }
        if (isset($row['partner_order_no'])) { // partner_order_no
            $this->partner_order_no->CurrentValue = $row['partner_order_no'];
        }
        if (isset($row['location'])) { // location
            $this->location->CurrentValue = $row['location'];
        }
        if (isset($row['partner_id'])) { // partner_id
            $this->partner_id->CurrentValue = $row['partner_id'];
        }
        if (isset($row['partner_rid'])) { // partner_rid
            $this->partner_rid->CurrentValue = $row['partner_rid'];
        }
        if (isset($row['partner_code'])) { // partner_code
            $this->partner_code->CurrentValue = $row['partner_code'];
        }
        if (isset($row['product_type'])) { // product_type
            $this->product_type->CurrentValue = $row['product_type'];
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->CurrentValue = $row['s_grp'];
        }
        if (isset($row['product'])) { // product
            $this->product->CurrentValue = $row['product'];
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->CurrentValue = $row['packing_type'];
        }
        if (isset($row['batch_no'])) { // batch_no
            $this->batch_no->CurrentValue = $row['batch_no'];
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->CurrentValue = $row['quantity'];
        }
        if (isset($row['price'])) { // price
            $this->price->CurrentValue = $row['price'];
        }
        if (isset($row['currency'])) { // currency
            $this->currency->CurrentValue = $row['currency'];
        }
        if (isset($row['amount'])) { // amount
            $this->amount->CurrentValue = $row['amount'];
        }
        if (isset($row['shipping_charge'])) { // shipping_charge
            $this->shipping_charge->CurrentValue = $row['shipping_charge'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['image'])) { // image
            $this->image->CurrentValue = $row['image'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("productcartbwbclist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_level":
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_po_id":
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_batch_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_unit":
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'product_cart_b_wbc');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
    extract($_POST,EXTR_OVERWRITE);
    $batch= ExecuteScalar("SELECT `pd_byepass` FROM `portal_setup` Limit 1");
    $_SESSION[SESSION_WARNING_MESSAGE] = '';
    	if  ( ($batch < 2) && ($x_batch_no == null) && ($x_product_type != 10) )
    	{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Batch No.<br>";
    	}
    	if ($_SESSION[SESSION_WARNING_MESSAGE] == '')
    	{return TRUE;}
    	else
    	{return FALSE;}
    }
}
