<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for process_yeild
 */
class ProcessYeild extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $po;
    public $product_code;
    public $process;
    public $yeild;
    public $jc_yeild;
    public $cart_quantity;
    public $pam_qty;
    public $pending_qty;
    public $pp_qty;
    public $packing_type;
    public $batch_no;
    public $issue_to;
    public $jc_no;
    public $jc_quantity;
    public $despatch_week;
    public $despatch_date;
    public $company_id;
    public $par_com;
    public $last_processing_date;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "process_yeild";
        $this->TableName = 'process_yeild';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "process_yeild";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['id'] = &$this->id;

        // po
        $this->po = new DbField(
            $this, // Table
            'x_po', // Variable name
            'po', // Name
            '`po`', // Expression
            '`po`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po->InputTextType = "text";
        $this->po->Sortable = false; // Allow sort
        $this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['po'] = &$this->po;

        // product_code
        $this->product_code = new DbField(
            $this, // Table
            'x_product_code', // Variable name
            'product_code', // Name
            '`product_code`', // Expression
            '`product_code`', // Basic search expression
            200, // Type
            355, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product_code->InputTextType = "text";
        $this->product_code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_code'] = &$this->product_code;

        // process
        $this->process = new DbField(
            $this, // Table
            'x_process', // Variable name
            'process', // Name
            '`process`', // Expression
            '`process`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->process->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->process->InputTextType = "text";
        $this->process->Lookup = new Lookup($this->process, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['process'] = &$this->process;

        // yeild
        $this->yeild = new DbField(
            $this, // Table
            'x_yeild', // Variable name
            'yeild', // Name
            '`yeild`', // Expression
            '`yeild`', // Basic search expression
            5, // Type
            38, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`yeild`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->yeild->InputTextType = "text";
        $this->yeild->Raw = true;
        $this->yeild->FormatPattern = "0.00"; // Format pattern
        $this->yeild->DefaultNumberFormat = $this->yeild->FormatPattern;
        $this->yeild->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->yeild->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['yeild'] = &$this->yeild;

        // jc_yeild
        $this->jc_yeild = new DbField(
            $this, // Table
            'x_jc_yeild', // Variable name
            'jc_yeild', // Name
            '`jc_yeild`', // Expression
            '`jc_yeild`', // Basic search expression
            5, // Type
            19, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_yeild`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_yeild->InputTextType = "text";
        $this->jc_yeild->Raw = true;
        $this->jc_yeild->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->jc_yeild->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['jc_yeild'] = &$this->jc_yeild;

        // cart_quantity
        $this->cart_quantity = new DbField(
            $this, // Table
            'x_cart_quantity', // Variable name
            'cart_quantity', // Name
            '`cart_quantity`', // Expression
            '`cart_quantity`', // Basic search expression
            5, // Type
            23, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cart_quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cart_quantity->InputTextType = "text";
        $this->cart_quantity->Raw = true;
        $this->cart_quantity->FormatPattern = "0.00"; // Format pattern
        $this->cart_quantity->DefaultNumberFormat = $this->cart_quantity->FormatPattern;
        $this->cart_quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->cart_quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['cart_quantity'] = &$this->cart_quantity;

        // pam_qty
        $this->pam_qty = new DbField(
            $this, // Table
            'x_pam_qty', // Variable name
            'pam_qty', // Name
            '`pam_qty`', // Expression
            '`pam_qty`', // Basic search expression
            200, // Type
            32, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pam_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pam_qty->InputTextType = "text";
        $this->pam_qty->FormatPattern = "0.00"; // Format pattern
        $this->pam_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->pam_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pam_qty'] = &$this->pam_qty;

        // pending_qty
        $this->pending_qty = new DbField(
            $this, // Table
            'x_pending_qty', // Variable name
            'pending_qty', // Name
            '`pending_qty`', // Expression
            '`pending_qty`', // Basic search expression
            200, // Type
            19, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pending_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pending_qty->InputTextType = "text";
        $this->pending_qty->Sortable = false; // Allow sort
        $this->pending_qty->FormatPattern = "0.00"; // Format pattern
        $this->pending_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->pending_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pending_qty'] = &$this->pending_qty;

        // pp_qty
        $this->pp_qty = new DbField(
            $this, // Table
            'x_pp_qty', // Variable name
            'pp_qty', // Name
            '`pp_qty`', // Expression
            '`pp_qty`', // Basic search expression
            200, // Type
            33, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pp_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pp_qty->InputTextType = "text";
        $this->pp_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->pp_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pp_qty'] = &$this->pp_qty;

        // packing_type
        $this->packing_type = new DbField(
            $this, // Table
            'x_packing_type', // Variable name
            'packing_type', // Name
            '`packing_type`', // Expression
            '`packing_type`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packing_type->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->packing_type->InputTextType = "text";
        $this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packing_type->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['packing_type'] = &$this->packing_type;

        // batch_no
        $this->batch_no = new DbField(
            $this, // Table
            'x_batch_no', // Variable name
            'batch_no', // Name
            '`batch_no`', // Expression
            '`batch_no`', // Basic search expression
            200, // Type
            89, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`batch_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->batch_no->InputTextType = "text";
        $this->batch_no->Required = true; // Required field
        $this->batch_no->setSelectMultiple(false); // Select one
        $this->batch_no->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->batch_no->Lookup = new Lookup($this->batch_no, 'batch_no', false, 'id', ["batch_no","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`batch_no`");
        $this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->batch_no->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['batch_no'] = &$this->batch_no;

        // issue_to
        $this->issue_to = new DbField(
            $this, // Table
            'x_issue_to', // Variable name
            'issue_to', // Name
            '`issue_to`', // Expression
            '`issue_to`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`issue_to`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->issue_to->addMethod("getSelectFilter", fn() => "`category`=999 || `category`=105");
        $this->issue_to->InputTextType = "text";
        $this->issue_to->Raw = true;
        $this->issue_to->Lookup = new Lookup($this->issue_to, 'buyer_seller_view', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->issue_to->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['issue_to'] = &$this->issue_to;

        // jc_no
        $this->jc_no = new DbField(
            $this, // Table
            'x_jc_no', // Variable name
            'jc_no', // Name
            '`jc_no`', // Expression
            '`jc_no`', // Basic search expression
            201, // Type
            2147483647, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_no->InputTextType = "text";
        $this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['jc_no'] = &$this->jc_no;

        // jc_quantity
        $this->jc_quantity = new DbField(
            $this, // Table
            'x_jc_quantity', // Variable name
            'jc_quantity', // Name
            '`jc_quantity`', // Expression
            '`jc_quantity`', // Basic search expression
            5, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_quantity->InputTextType = "text";
        $this->jc_quantity->Raw = true;
        $this->jc_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->jc_quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['jc_quantity'] = &$this->jc_quantity;

        // despatch_week
        $this->despatch_week = new DbField(
            $this, // Table
            'x_despatch_week', // Variable name
            'despatch_week', // Name
            '`despatch_week`', // Expression
            '`despatch_week`', // Basic search expression
            200, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`despatch_week`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->despatch_week->InputTextType = "text";
        $this->despatch_week->setSelectMultiple(false); // Select one
        $this->despatch_week->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->despatch_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->despatch_week->Lookup = new Lookup($this->despatch_week, 'not_week', false, 'id', ["wed","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`wed`");
        $this->despatch_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->despatch_week->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['despatch_week'] = &$this->despatch_week;

        // despatch_date
        $this->despatch_date = new DbField(
            $this, // Table
            'x_despatch_date', // Variable name
            'despatch_date', // Name
            '`despatch_date`', // Expression
            '`despatch_date`', // Basic search expression
            200, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`despatch_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->despatch_date->InputTextType = "text";
        $this->despatch_date->Sortable = false; // Allow sort
        $this->despatch_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->despatch_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['despatch_date'] = &$this->despatch_date;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->company_id->addMethod("getSelectFilter", fn() => "`category`=1 || `category`=902");
        $this->company_id->InputTextType = "text";
        $this->company_id->Raw = true;
        $this->company_id->setSelectMultiple(false); // Select one
        $this->company_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->company_id->Lookup = new Lookup($this->company_id, 'buyer_seller_view', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->company_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['company_id'] = &$this->company_id;

        // par_com
        $this->par_com = new DbField(
            $this, // Table
            'x_par_com', // Variable name
            'par_com', // Name
            '`par_com`', // Expression
            '`par_com`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`par_com`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->par_com->InputTextType = "text";
        $this->par_com->Raw = true;
        $this->par_com->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->par_com->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['par_com'] = &$this->par_com;

        // last_processing_date
        $this->last_processing_date = new DbField(
            $this, // Table
            'x_last_processing_date', // Variable name
            'last_processing_date', // Name
            '`last_processing_date`', // Expression
            CastDateFieldForLike("`last_processing_date`", 0, "DB"), // Basic search expression
            135, // Type
            19, // Size
            0, // Date/Time format
            false, // Is upload field
            '`last_processing_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->last_processing_date->InputTextType = "text";
        $this->last_processing_date->Raw = true;
        $this->last_processing_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->last_processing_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['last_processing_date'] = &$this->last_processing_date;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "process_yeild";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->po->DbValue = $row['po'];
        $this->product_code->DbValue = $row['product_code'];
        $this->process->DbValue = $row['process'];
        $this->yeild->DbValue = $row['yeild'];
        $this->jc_yeild->DbValue = $row['jc_yeild'];
        $this->cart_quantity->DbValue = $row['cart_quantity'];
        $this->pam_qty->DbValue = $row['pam_qty'];
        $this->pending_qty->DbValue = $row['pending_qty'];
        $this->pp_qty->DbValue = $row['pp_qty'];
        $this->packing_type->DbValue = $row['packing_type'];
        $this->batch_no->DbValue = $row['batch_no'];
        $this->issue_to->DbValue = $row['issue_to'];
        $this->jc_no->DbValue = $row['jc_no'];
        $this->jc_quantity->DbValue = $row['jc_quantity'];
        $this->despatch_week->DbValue = $row['despatch_week'];
        $this->despatch_date->DbValue = $row['despatch_date'];
        $this->company_id->DbValue = $row['company_id'];
        $this->par_com->DbValue = $row['par_com'];
        $this->last_processing_date->DbValue = $row['last_processing_date'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("processyeildlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "processyeildview" => $Language->phrase("View"),
            "processyeildedit" => $Language->phrase("Edit"),
            "processyeildadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "processyeildlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "ProcessYeildView",
            Config("API_ADD_ACTION") => "ProcessYeildAdd",
            Config("API_EDIT_ACTION") => "ProcessYeildEdit",
            Config("API_DELETE_ACTION") => "ProcessYeildDelete",
            Config("API_LIST_ACTION") => "ProcessYeildList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "processyeildlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("processyeildview", $parm);
        } else {
            $url = $this->keyUrl("processyeildview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "processyeildadd?" . $parm;
        } else {
            $url = "processyeildadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("processyeildedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("processyeildlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("processyeildadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("processyeildlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("processyeilddelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, -1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, -1))) // Other API
                : []; // Non-API
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->po->setDbValue($row['po']);
        $this->product_code->setDbValue($row['product_code']);
        $this->process->setDbValue($row['process']);
        $this->yeild->setDbValue($row['yeild']);
        $this->jc_yeild->setDbValue($row['jc_yeild']);
        $this->cart_quantity->setDbValue($row['cart_quantity']);
        $this->pam_qty->setDbValue($row['pam_qty']);
        $this->pending_qty->setDbValue($row['pending_qty']);
        $this->pp_qty->setDbValue($row['pp_qty']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->issue_to->setDbValue($row['issue_to']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->jc_quantity->setDbValue($row['jc_quantity']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->company_id->setDbValue($row['company_id']);
        $this->par_com->setDbValue($row['par_com']);
        $this->last_processing_date->setDbValue($row['last_processing_date']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "ProcessYeildList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // po
        $this->po->CellCssStyle = "white-space: nowrap;";

        // product_code

        // process

        // yeild

        // jc_yeild

        // cart_quantity

        // pam_qty

        // pending_qty
        $this->pending_qty->CellCssStyle = "white-space: nowrap;";

        // pp_qty

        // packing_type

        // batch_no

        // issue_to

        // jc_no

        // jc_quantity

        // despatch_week

        // despatch_date
        $this->despatch_date->CellCssStyle = "white-space: nowrap;";

        // company_id

        // par_com

        // last_processing_date

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

        // po
        $this->po->ViewValue = $this->po->CurrentValue;

        // product_code
        $this->product_code->ViewValue = $this->product_code->CurrentValue;

        // process
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->process->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->process->Lookup->renderViewRow($row);
                        $this->process->ViewValue->add($this->process->displayValue($arwrk));
                    }
                } else {
                    $this->process->ViewValue = $this->process->CurrentValue;
                }
            }
        } else {
            $this->process->ViewValue = null;
        }

        // yeild
        $this->yeild->ViewValue = $this->yeild->CurrentValue;
        $this->yeild->ViewValue = FormatNumber($this->yeild->ViewValue, $this->yeild->formatPattern());
        $this->yeild->CssClass = "fw-bold";
        $this->yeild->CellCssStyle .= "text-align: right;";

        // jc_yeild
        $this->jc_yeild->ViewValue = $this->jc_yeild->CurrentValue;
        $this->jc_yeild->ViewValue = FormatNumber($this->jc_yeild->ViewValue, $this->jc_yeild->formatPattern());

        // cart_quantity
        $this->cart_quantity->ViewValue = $this->cart_quantity->CurrentValue;
        $this->cart_quantity->ViewValue = FormatNumber($this->cart_quantity->ViewValue, $this->cart_quantity->formatPattern());
        $this->cart_quantity->CellCssStyle .= "text-align: right;";

        // pam_qty
        $this->pam_qty->ViewValue = $this->pam_qty->CurrentValue;
        $this->pam_qty->CellCssStyle .= "text-align: right;";

        // pending_qty
        $this->pending_qty->ViewValue = $this->pending_qty->CurrentValue;
        $this->pending_qty->CellCssStyle .= "text-align: right;";

        // pp_qty
        $this->pp_qty->ViewValue = $this->pp_qty->CurrentValue;

        // packing_type
        $this->packing_type->ViewValue = $this->packing_type->CurrentValue;

        // batch_no
        $curVal = strval($this->batch_no->CurrentValue);
        if ($curVal != "") {
            $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            if ($this->batch_no->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
                }
            }
        } else {
            $this->batch_no->ViewValue = null;
        }

        // issue_to
        $this->issue_to->ViewValue = $this->issue_to->CurrentValue;
        $curVal = strval($this->issue_to->CurrentValue);
        if ($curVal != "") {
            $this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
            if ($this->issue_to->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->issue_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->issue_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->issue_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->issue_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->issue_to->Lookup->renderViewRow($rswrk[0]);
                    $this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
                } else {
                    $this->issue_to->ViewValue = $this->issue_to->CurrentValue;
                }
            }
        } else {
            $this->issue_to->ViewValue = null;
        }

        // jc_no
        $this->jc_no->ViewValue = $this->jc_no->CurrentValue;

        // jc_quantity
        $this->jc_quantity->ViewValue = $this->jc_quantity->CurrentValue;
        $this->jc_quantity->ViewValue = FormatNumber($this->jc_quantity->ViewValue, $this->jc_quantity->formatPattern());

        // despatch_week
        $curVal = strval($this->despatch_week->CurrentValue);
        if ($curVal != "") {
            $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            if ($this->despatch_week->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                    $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                } else {
                    $this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
                }
            }
        } else {
            $this->despatch_week->ViewValue = null;
        }

        // despatch_date
        $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;

        // company_id
        $curVal = strval($this->company_id->CurrentValue);
        if ($curVal != "") {
            $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            if ($this->company_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                    $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                } else {
                    $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                }
            }
        } else {
            $this->company_id->ViewValue = null;
        }

        // par_com
        $this->par_com->ViewValue = $this->par_com->CurrentValue;
        $this->par_com->ViewValue = FormatNumber($this->par_com->ViewValue, $this->par_com->formatPattern());

        // last_processing_date
        $this->last_processing_date->ViewValue = $this->last_processing_date->CurrentValue;
        $this->last_processing_date->ViewValue = FormatDateTime($this->last_processing_date->ViewValue, $this->last_processing_date->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // po
        $this->po->HrefValue = "";
        $this->po->TooltipValue = "";

        // product_code
        $this->product_code->HrefValue = "";
        $this->product_code->TooltipValue = "";

        // process
        $this->process->HrefValue = "";
        $this->process->TooltipValue = "";

        // yeild
        $this->yeild->HrefValue = "";
        $this->yeild->TooltipValue = "";

        // jc_yeild
        $this->jc_yeild->HrefValue = "";
        $this->jc_yeild->TooltipValue = "";

        // cart_quantity
        $this->cart_quantity->HrefValue = "";
        $this->cart_quantity->TooltipValue = "";

        // pam_qty
        $this->pam_qty->HrefValue = "";
        $this->pam_qty->TooltipValue = "";

        // pending_qty
        $this->pending_qty->HrefValue = "";
        $this->pending_qty->TooltipValue = "";

        // pp_qty
        $this->pp_qty->HrefValue = "";
        $this->pp_qty->TooltipValue = "";

        // packing_type
        $this->packing_type->HrefValue = "";
        $this->packing_type->TooltipValue = "";

        // batch_no
        $this->batch_no->HrefValue = "";
        $this->batch_no->TooltipValue = "";

        // issue_to
        $this->issue_to->HrefValue = "";
        $this->issue_to->TooltipValue = "";

        // jc_no
        $this->jc_no->HrefValue = "";
        $this->jc_no->TooltipValue = "";

        // jc_quantity
        $this->jc_quantity->HrefValue = "";
        $this->jc_quantity->TooltipValue = "";

        // despatch_week
        $this->despatch_week->HrefValue = "";
        $this->despatch_week->TooltipValue = "";

        // despatch_date
        $this->despatch_date->HrefValue = "";
        $this->despatch_date->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // par_com
        $this->par_com->HrefValue = "";
        $this->par_com->TooltipValue = "";

        // last_processing_date
        $this->last_processing_date->HrefValue = "";
        $this->last_processing_date->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->PlaceHolder = RemoveHtml($this->id->caption());
        if (strval($this->id->EditValue) != "" && is_numeric($this->id->EditValue)) {
            $this->id->EditValue = FormatNumber($this->id->EditValue, null);
        }

        // po
        $this->po->setupEditAttributes();
        if (!$this->po->Raw) {
            $this->po->CurrentValue = HtmlDecode($this->po->CurrentValue);
        }
        $this->po->EditValue = $this->po->CurrentValue;
        $this->po->PlaceHolder = RemoveHtml($this->po->caption());

        // product_code
        $this->product_code->setupEditAttributes();
        if (!$this->product_code->Raw) {
            $this->product_code->CurrentValue = HtmlDecode($this->product_code->CurrentValue);
        }
        $this->product_code->EditValue = $this->product_code->CurrentValue;
        $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

        // process
        $this->process->PlaceHolder = RemoveHtml($this->process->caption());

        // yeild
        $this->yeild->setupEditAttributes();
        $this->yeild->EditValue = $this->yeild->CurrentValue;
        $this->yeild->PlaceHolder = RemoveHtml($this->yeild->caption());
        if (strval($this->yeild->EditValue) != "" && is_numeric($this->yeild->EditValue)) {
            $this->yeild->EditValue = FormatNumber($this->yeild->EditValue, null);
        }

        // jc_yeild
        $this->jc_yeild->setupEditAttributes();
        $this->jc_yeild->EditValue = $this->jc_yeild->CurrentValue;
        $this->jc_yeild->PlaceHolder = RemoveHtml($this->jc_yeild->caption());
        if (strval($this->jc_yeild->EditValue) != "" && is_numeric($this->jc_yeild->EditValue)) {
            $this->jc_yeild->EditValue = FormatNumber($this->jc_yeild->EditValue, null);
        }

        // cart_quantity
        $this->cart_quantity->setupEditAttributes();
        $this->cart_quantity->EditValue = $this->cart_quantity->CurrentValue;
        $this->cart_quantity->PlaceHolder = RemoveHtml($this->cart_quantity->caption());
        if (strval($this->cart_quantity->EditValue) != "" && is_numeric($this->cart_quantity->EditValue)) {
            $this->cart_quantity->EditValue = FormatNumber($this->cart_quantity->EditValue, null);
        }

        // pam_qty
        $this->pam_qty->setupEditAttributes();
        if (!$this->pam_qty->Raw) {
            $this->pam_qty->CurrentValue = HtmlDecode($this->pam_qty->CurrentValue);
        }
        $this->pam_qty->EditValue = $this->pam_qty->CurrentValue;
        $this->pam_qty->PlaceHolder = RemoveHtml($this->pam_qty->caption());

        // pending_qty
        $this->pending_qty->setupEditAttributes();
        if (!$this->pending_qty->Raw) {
            $this->pending_qty->CurrentValue = HtmlDecode($this->pending_qty->CurrentValue);
        }
        $this->pending_qty->EditValue = $this->pending_qty->CurrentValue;
        $this->pending_qty->PlaceHolder = RemoveHtml($this->pending_qty->caption());

        // pp_qty
        $this->pp_qty->setupEditAttributes();
        if (!$this->pp_qty->Raw) {
            $this->pp_qty->CurrentValue = HtmlDecode($this->pp_qty->CurrentValue);
        }
        $this->pp_qty->EditValue = $this->pp_qty->CurrentValue;
        $this->pp_qty->PlaceHolder = RemoveHtml($this->pp_qty->caption());

        // packing_type
        $this->packing_type->setupEditAttributes();
        if (!$this->packing_type->Raw) {
            $this->packing_type->CurrentValue = HtmlDecode($this->packing_type->CurrentValue);
        }
        $this->packing_type->EditValue = $this->packing_type->CurrentValue;
        $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

        // batch_no
        $this->batch_no->setupEditAttributes();
        $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

        // issue_to
        $this->issue_to->setupEditAttributes();
        $this->issue_to->EditValue = $this->issue_to->CurrentValue;
        $this->issue_to->PlaceHolder = RemoveHtml($this->issue_to->caption());

        // jc_no
        $this->jc_no->setupEditAttributes();
        if (!$this->jc_no->Raw) {
            $this->jc_no->CurrentValue = HtmlDecode($this->jc_no->CurrentValue);
        }
        $this->jc_no->EditValue = $this->jc_no->CurrentValue;
        $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

        // jc_quantity
        $this->jc_quantity->setupEditAttributes();
        $this->jc_quantity->EditValue = $this->jc_quantity->CurrentValue;
        $this->jc_quantity->PlaceHolder = RemoveHtml($this->jc_quantity->caption());
        if (strval($this->jc_quantity->EditValue) != "" && is_numeric($this->jc_quantity->EditValue)) {
            $this->jc_quantity->EditValue = FormatNumber($this->jc_quantity->EditValue, null);
        }

        // despatch_week
        $this->despatch_week->setupEditAttributes();
        $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

        // despatch_date
        $this->despatch_date->setupEditAttributes();
        if (!$this->despatch_date->Raw) {
            $this->despatch_date->CurrentValue = HtmlDecode($this->despatch_date->CurrentValue);
        }
        $this->despatch_date->EditValue = $this->despatch_date->CurrentValue;
        $this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

        // company_id
        $this->company_id->setupEditAttributes();
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

        // par_com
        $this->par_com->setupEditAttributes();
        $this->par_com->EditValue = $this->par_com->CurrentValue;
        $this->par_com->PlaceHolder = RemoveHtml($this->par_com->caption());
        if (strval($this->par_com->EditValue) != "" && is_numeric($this->par_com->EditValue)) {
            $this->par_com->EditValue = FormatNumber($this->par_com->EditValue, null);
        }

        // last_processing_date
        $this->last_processing_date->setupEditAttributes();
        $this->last_processing_date->EditValue = FormatDateTime($this->last_processing_date->CurrentValue, $this->last_processing_date->formatPattern());
        $this->last_processing_date->PlaceHolder = RemoveHtml($this->last_processing_date->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->cart_quantity->CurrentValue)) {
                $this->cart_quantity->Total += $this->cart_quantity->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->pam_qty->CurrentValue)) {
                $this->pam_qty->Total += $this->pam_qty->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->pending_qty->CurrentValue)) {
                $this->pending_qty->Total += $this->pending_qty->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->pp_qty->CurrentValue)) {
                $this->pp_qty->Total += $this->pp_qty->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->cart_quantity->CurrentValue = $this->cart_quantity->Total;
            $this->cart_quantity->ViewValue = $this->cart_quantity->CurrentValue;
            $this->cart_quantity->ViewValue = FormatNumber($this->cart_quantity->ViewValue, $this->cart_quantity->formatPattern());
            $this->cart_quantity->CellCssStyle .= "text-align: right;";
            $this->cart_quantity->HrefValue = ""; // Clear href value
            $this->pam_qty->CurrentValue = $this->pam_qty->Total;
            $this->pam_qty->ViewValue = $this->pam_qty->CurrentValue;
            $this->pam_qty->CellCssStyle .= "text-align: right;";
            $this->pam_qty->HrefValue = ""; // Clear href value
            $this->pending_qty->CurrentValue = $this->pending_qty->Total;
            $this->pending_qty->ViewValue = $this->pending_qty->CurrentValue;
            $this->pending_qty->CellCssStyle .= "text-align: right;";
            $this->pending_qty->HrefValue = ""; // Clear href value
            $this->pp_qty->CurrentValue = $this->pp_qty->Total;
            $this->pp_qty->ViewValue = $this->pp_qty->CurrentValue;
            $this->pp_qty->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->product_code);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->yeild);
                    $doc->exportCaption($this->jc_yeild);
                    $doc->exportCaption($this->cart_quantity);
                    $doc->exportCaption($this->pam_qty);
                    $doc->exportCaption($this->pp_qty);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->issue_to);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->jc_quantity);
                    $doc->exportCaption($this->despatch_week);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->par_com);
                    $doc->exportCaption($this->last_processing_date);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->product_code);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->yeild);
                    $doc->exportCaption($this->jc_yeild);
                    $doc->exportCaption($this->cart_quantity);
                    $doc->exportCaption($this->pam_qty);
                    $doc->exportCaption($this->pp_qty);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->issue_to);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->jc_quantity);
                    $doc->exportCaption($this->despatch_week);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->par_com);
                    $doc->exportCaption($this->last_processing_date);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->product_code);
                        $doc->exportField($this->process);
                        $doc->exportField($this->yeild);
                        $doc->exportField($this->jc_yeild);
                        $doc->exportField($this->cart_quantity);
                        $doc->exportField($this->pam_qty);
                        $doc->exportField($this->pp_qty);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->issue_to);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->jc_quantity);
                        $doc->exportField($this->despatch_week);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->par_com);
                        $doc->exportField($this->last_processing_date);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->product_code);
                        $doc->exportField($this->process);
                        $doc->exportField($this->yeild);
                        $doc->exportField($this->jc_yeild);
                        $doc->exportField($this->cart_quantity);
                        $doc->exportField($this->pam_qty);
                        $doc->exportField($this->pp_qty);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->issue_to);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->jc_quantity);
                        $doc->exportField($this->despatch_week);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->par_com);
                        $doc->exportField($this->last_processing_date);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->id, '');
                $doc->exportAggregate($this->product_code, '');
                $doc->exportAggregate($this->process, '');
                $doc->exportAggregate($this->yeild, '');
                $doc->exportAggregate($this->jc_yeild, '');
                $doc->exportAggregate($this->cart_quantity, 'TOTAL');
                $doc->exportAggregate($this->pam_qty, 'TOTAL');
                $doc->exportAggregate($this->pp_qty, 'TOTAL');
                $doc->exportAggregate($this->packing_type, '');
                $doc->exportAggregate($this->batch_no, '');
                $doc->exportAggregate($this->issue_to, '');
                $doc->exportAggregate($this->jc_no, '');
                $doc->exportAggregate($this->jc_quantity, '');
                $doc->exportAggregate($this->despatch_week, '');
                $doc->exportAggregate($this->company_id, '');
                $doc->exportAggregate($this->par_com, '');
                $doc->exportAggregate($this->last_processing_date, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
