<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProcessWbcWppDelete extends ProcessWbcWpp
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProcessWbcWppDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "processwbcwppdelete";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->partner_id->setVisibility();
        $this->po->setVisibility();
        $this->dispatch_week->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid_tmp->setVisibility();
        $this->rid->setVisibility();
        $this->product_code->setVisibility();
        $this->packing_type->setVisibility();
        $this->sub_process->setVisibility();
        $this->quantity_sub->setVisibility();
        $this->qty->setVisibility();
        $this->p_qty->setVisibility();
        $this->c_qty_remarks->setVisibility();
        $this->remarks->setVisibility();
        $this->cart_id->setVisibility();
        $this->amount->setVisibility();
        $this->week_p->setVisibility();
        $this->process_all->setVisibility();
        $this->current_process->setVisibility();
        $this->loom_id->setVisibility();
        $this->process_date->setVisibility();
        $this->process_complete->setVisibility();
        $this->m_out_id->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'process_wbc_wpp';
        $this->TableName = 'process_wbc_wpp';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (process_wbc_wpp)
        if (!isset($GLOBALS["process_wbc_wpp"]) || $GLOBALS["process_wbc_wpp"]::class == PROJECT_NAMESPACE . "process_wbc_wpp") {
            $GLOBALS["process_wbc_wpp"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_wbc_wpp');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("processwbcwpplist"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson(["success" => false, "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            $this->Recordset = $this->loadRecordset();
            if ($this->TotalRecords <= 0) { // No record found, exit
                $this->Recordset?->free();
                $this->terminate("processwbcwpplist"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->po->setDbValue($row['po']);
        $this->dispatch_week->setDbValue($row['dispatch_week']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid_tmp->setDbValue($row['rid_tmp']);
        $this->rid->setDbValue($row['rid']);
        $this->product_code->setDbValue($row['product_code']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->sub_process->setDbValue($row['sub_process']);
        $this->quantity_sub->setDbValue($row['quantity_sub']);
        $this->qty->setDbValue($row['qty']);
        $this->p_qty->setDbValue($row['p_qty']);
        $this->c_qty_remarks->setDbValue($row['c_qty_remarks']);
        $this->remarks->setDbValue($row['remarks']);
        $this->cart_id->setDbValue($row['cart_id']);
        $this->amount->setDbValue($row['amount']);
        $this->week_p->setDbValue($row['week_p']);
        $this->process_all->setDbValue($row['process_all']);
        $this->current_process->setDbValue($row['current_process']);
        $this->loom_id->setDbValue($row['loom_id']);
        $this->process_date->setDbValue($row['process_date']);
        $this->process_complete->setDbValue($row['process_complete']);
        $this->m_out_id->setDbValue($row['m_out_id']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['dispatch_week'] = $this->dispatch_week->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid_tmp'] = $this->rid_tmp->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['product_code'] = $this->product_code->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['sub_process'] = $this->sub_process->DefaultValue;
        $row['quantity_sub'] = $this->quantity_sub->DefaultValue;
        $row['qty'] = $this->qty->DefaultValue;
        $row['p_qty'] = $this->p_qty->DefaultValue;
        $row['c_qty_remarks'] = $this->c_qty_remarks->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['cart_id'] = $this->cart_id->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['week_p'] = $this->week_p->DefaultValue;
        $row['process_all'] = $this->process_all->DefaultValue;
        $row['current_process'] = $this->current_process->DefaultValue;
        $row['loom_id'] = $this->loom_id->DefaultValue;
        $row['process_date'] = $this->process_date->DefaultValue;
        $row['process_complete'] = $this->process_complete->DefaultValue;
        $row['m_out_id'] = $this->m_out_id->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // partner_id

        // po

        // dispatch_week

        // grp

        // s_grp

        // product

        // rid_tmp

        // rid

        // product_code

        // packing_type

        // sub_process

        // quantity_sub

        // qty

        // p_qty

        // c_qty_remarks

        // remarks

        // cart_id

        // amount

        // week_p

        // process_all

        // current_process

        // loom_id

        // process_date

        // process_complete

        // m_out_id

        // operator

        // datetime

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $this->partner_id->ViewValue = FormatNumber($this->partner_id->ViewValue, $this->partner_id->formatPattern());

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // dispatch_week
            $this->dispatch_week->ViewValue = $this->dispatch_week->CurrentValue;
            $this->dispatch_week->ViewValue = FormatNumber($this->dispatch_week->ViewValue, $this->dispatch_week->formatPattern());

            // grp
            $this->grp->ViewValue = $this->grp->CurrentValue;
            $this->grp->ViewValue = FormatNumber($this->grp->ViewValue, $this->grp->formatPattern());

            // s_grp
            $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
            $this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, $this->s_grp->formatPattern());

            // product
            $this->product->ViewValue = $this->product->CurrentValue;
            $this->product->ViewValue = FormatNumber($this->product->ViewValue, $this->product->formatPattern());

            // rid_tmp
            $this->rid_tmp->ViewValue = $this->rid_tmp->CurrentValue;

            // rid
            $this->rid->ViewValue = $this->rid->CurrentValue;
            $this->rid->ViewValue = FormatNumber($this->rid->ViewValue, $this->rid->formatPattern());

            // product_code
            $this->product_code->ViewValue = $this->product_code->CurrentValue;

            // packing_type
            $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
            $this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, $this->packing_type->formatPattern());

            // sub_process
            $this->sub_process->ViewValue = $this->sub_process->CurrentValue;
            $this->sub_process->ViewValue = FormatNumber($this->sub_process->ViewValue, $this->sub_process->formatPattern());

            // quantity_sub
            $this->quantity_sub->ViewValue = $this->quantity_sub->CurrentValue;
            $this->quantity_sub->ViewValue = FormatNumber($this->quantity_sub->ViewValue, $this->quantity_sub->formatPattern());

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // p_qty
            $this->p_qty->ViewValue = $this->p_qty->CurrentValue;
            $this->p_qty->ViewValue = FormatNumber($this->p_qty->ViewValue, $this->p_qty->formatPattern());

            // c_qty_remarks
            $this->c_qty_remarks->ViewValue = $this->c_qty_remarks->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // cart_id
            $this->cart_id->ViewValue = $this->cart_id->CurrentValue;
            $this->cart_id->ViewValue = FormatNumber($this->cart_id->ViewValue, $this->cart_id->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // week_p
            $this->week_p->ViewValue = $this->week_p->CurrentValue;

            // process_all
            $this->process_all->ViewValue = $this->process_all->CurrentValue;

            // current_process
            $this->current_process->ViewValue = $this->current_process->CurrentValue;
            $this->current_process->ViewValue = FormatNumber($this->current_process->ViewValue, $this->current_process->formatPattern());

            // loom_id
            $this->loom_id->ViewValue = $this->loom_id->CurrentValue;
            $this->loom_id->ViewValue = FormatNumber($this->loom_id->ViewValue, $this->loom_id->formatPattern());

            // process_date
            $this->process_date->ViewValue = $this->process_date->CurrentValue;
            $this->process_date->ViewValue = FormatDateTime($this->process_date->ViewValue, $this->process_date->formatPattern());

            // process_complete
            $this->process_complete->ViewValue = $this->process_complete->CurrentValue;
            $this->process_complete->ViewValue = FormatDateTime($this->process_complete->ViewValue, $this->process_complete->formatPattern());

            // m_out_id
            $this->m_out_id->ViewValue = $this->m_out_id->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";
            $this->partner_id->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // dispatch_week
            $this->dispatch_week->HrefValue = "";
            $this->dispatch_week->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // product
            $this->product->HrefValue = "";
            $this->product->TooltipValue = "";

            // rid_tmp
            $this->rid_tmp->HrefValue = "";
            $this->rid_tmp->TooltipValue = "";

            // rid
            $this->rid->HrefValue = "";
            $this->rid->TooltipValue = "";

            // product_code
            $this->product_code->HrefValue = "";
            $this->product_code->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // sub_process
            $this->sub_process->HrefValue = "";
            $this->sub_process->TooltipValue = "";

            // quantity_sub
            $this->quantity_sub->HrefValue = "";
            $this->quantity_sub->TooltipValue = "";

            // qty
            $this->qty->HrefValue = "";
            $this->qty->TooltipValue = "";

            // p_qty
            $this->p_qty->HrefValue = "";
            $this->p_qty->TooltipValue = "";

            // c_qty_remarks
            $this->c_qty_remarks->HrefValue = "";
            $this->c_qty_remarks->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // cart_id
            $this->cart_id->HrefValue = "";
            $this->cart_id->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // week_p
            $this->week_p->HrefValue = "";
            $this->week_p->TooltipValue = "";

            // process_all
            $this->process_all->HrefValue = "";
            $this->process_all->TooltipValue = "";

            // current_process
            $this->current_process->HrefValue = "";
            $this->current_process->TooltipValue = "";

            // loom_id
            $this->loom_id->HrefValue = "";
            $this->loom_id->TooltipValue = "";

            // process_date
            $this->process_date->HrefValue = "";
            $this->process_date->TooltipValue = "";

            // process_complete
            $this->process_complete->HrefValue = "";
            $this->process_complete->TooltipValue = "";

            // m_out_id
            $this->m_out_id->HrefValue = "";
            $this->m_out_id->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Param("key_m") === null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("processwbcwpplist"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
