<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProcessWbcWppAdd extends ProcessWbcWpp
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProcessWbcWppAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "processwbcwppadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->partner_id->setVisibility();
        $this->po->setVisibility();
        $this->dispatch_week->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid_tmp->setVisibility();
        $this->rid->setVisibility();
        $this->product_code->setVisibility();
        $this->packing_type->setVisibility();
        $this->sub_process->setVisibility();
        $this->quantity_sub->setVisibility();
        $this->qty->setVisibility();
        $this->p_qty->setVisibility();
        $this->c_qty_remarks->setVisibility();
        $this->remarks->setVisibility();
        $this->cart_id->setVisibility();
        $this->amount->setVisibility();
        $this->week_p->setVisibility();
        $this->process_all->setVisibility();
        $this->current_process->setVisibility();
        $this->loom_id->setVisibility();
        $this->process_date->setVisibility();
        $this->process_complete->setVisibility();
        $this->m_out_id->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'process_wbc_wpp';
        $this->TableName = 'process_wbc_wpp';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (process_wbc_wpp)
        if (!isset($GLOBALS["process_wbc_wpp"]) || $GLOBALS["process_wbc_wpp"]::class == PROJECT_NAMESPACE . "process_wbc_wpp") {
            $GLOBALS["process_wbc_wpp"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_wbc_wpp');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "processwbcwppview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("processwbcwpplist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "processwbcwpplist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "processwbcwppview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "processwbcwpplist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "processwbcwpplist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->quantity_sub->DefaultValue = $this->quantity_sub->getDefault(); // PHP
        $this->quantity_sub->OldValue = $this->quantity_sub->DefaultValue;
        $this->amount->DefaultValue = $this->amount->getDefault(); // PHP
        $this->amount->OldValue = $this->amount->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'partner_id' first before field var 'x_partner_id'
        $val = $CurrentForm->hasValue("partner_id") ? $CurrentForm->getValue("partner_id") : $CurrentForm->getValue("x_partner_id");
        if (!$this->partner_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_id->Visible = false; // Disable update for API request
            } else {
                $this->partner_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'po' first before field var 'x_po'
        $val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
        if (!$this->po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po->Visible = false; // Disable update for API request
            } else {
                $this->po->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'dispatch_week' first before field var 'x_dispatch_week'
        $val = $CurrentForm->hasValue("dispatch_week") ? $CurrentForm->getValue("dispatch_week") : $CurrentForm->getValue("x_dispatch_week");
        if (!$this->dispatch_week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dispatch_week->Visible = false; // Disable update for API request
            } else {
                $this->dispatch_week->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val, true, $validate);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'rid_tmp' first before field var 'x_rid_tmp'
        $val = $CurrentForm->hasValue("rid_tmp") ? $CurrentForm->getValue("rid_tmp") : $CurrentForm->getValue("x_rid_tmp");
        if (!$this->rid_tmp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid_tmp->Visible = false; // Disable update for API request
            } else {
                $this->rid_tmp->setFormValue($val);
            }
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'product_code' first before field var 'x_product_code'
        $val = $CurrentForm->hasValue("product_code") ? $CurrentForm->getValue("product_code") : $CurrentForm->getValue("x_product_code");
        if (!$this->product_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_code->Visible = false; // Disable update for API request
            } else {
                $this->product_code->setFormValue($val);
            }
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'sub_process' first before field var 'x_sub_process'
        $val = $CurrentForm->hasValue("sub_process") ? $CurrentForm->getValue("sub_process") : $CurrentForm->getValue("x_sub_process");
        if (!$this->sub_process->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sub_process->Visible = false; // Disable update for API request
            } else {
                $this->sub_process->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'quantity_sub' first before field var 'x_quantity_sub'
        $val = $CurrentForm->hasValue("quantity_sub") ? $CurrentForm->getValue("quantity_sub") : $CurrentForm->getValue("x_quantity_sub");
        if (!$this->quantity_sub->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity_sub->Visible = false; // Disable update for API request
            } else {
                $this->quantity_sub->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'qty' first before field var 'x_qty'
        $val = $CurrentForm->hasValue("qty") ? $CurrentForm->getValue("qty") : $CurrentForm->getValue("x_qty");
        if (!$this->qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty->Visible = false; // Disable update for API request
            } else {
                $this->qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'p_qty' first before field var 'x_p_qty'
        $val = $CurrentForm->hasValue("p_qty") ? $CurrentForm->getValue("p_qty") : $CurrentForm->getValue("x_p_qty");
        if (!$this->p_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->p_qty->Visible = false; // Disable update for API request
            } else {
                $this->p_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'c_qty_remarks' first before field var 'x_c_qty_remarks'
        $val = $CurrentForm->hasValue("c_qty_remarks") ? $CurrentForm->getValue("c_qty_remarks") : $CurrentForm->getValue("x_c_qty_remarks");
        if (!$this->c_qty_remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->c_qty_remarks->Visible = false; // Disable update for API request
            } else {
                $this->c_qty_remarks->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'cart_id' first before field var 'x_cart_id'
        $val = $CurrentForm->hasValue("cart_id") ? $CurrentForm->getValue("cart_id") : $CurrentForm->getValue("x_cart_id");
        if (!$this->cart_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cart_id->Visible = false; // Disable update for API request
            } else {
                $this->cart_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'amount' first before field var 'x_amount'
        $val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
        if (!$this->amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount->Visible = false; // Disable update for API request
            } else {
                $this->amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'week_p' first before field var 'x_week_p'
        $val = $CurrentForm->hasValue("week_p") ? $CurrentForm->getValue("week_p") : $CurrentForm->getValue("x_week_p");
        if (!$this->week_p->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->week_p->Visible = false; // Disable update for API request
            } else {
                $this->week_p->setFormValue($val);
            }
        }

        // Check field name 'process_all' first before field var 'x_process_all'
        $val = $CurrentForm->hasValue("process_all") ? $CurrentForm->getValue("process_all") : $CurrentForm->getValue("x_process_all");
        if (!$this->process_all->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->process_all->Visible = false; // Disable update for API request
            } else {
                $this->process_all->setFormValue($val);
            }
        }

        // Check field name 'current_process' first before field var 'x_current_process'
        $val = $CurrentForm->hasValue("current_process") ? $CurrentForm->getValue("current_process") : $CurrentForm->getValue("x_current_process");
        if (!$this->current_process->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->current_process->Visible = false; // Disable update for API request
            } else {
                $this->current_process->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'loom_id' first before field var 'x_loom_id'
        $val = $CurrentForm->hasValue("loom_id") ? $CurrentForm->getValue("loom_id") : $CurrentForm->getValue("x_loom_id");
        if (!$this->loom_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->loom_id->Visible = false; // Disable update for API request
            } else {
                $this->loom_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'process_date' first before field var 'x_process_date'
        $val = $CurrentForm->hasValue("process_date") ? $CurrentForm->getValue("process_date") : $CurrentForm->getValue("x_process_date");
        if (!$this->process_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->process_date->Visible = false; // Disable update for API request
            } else {
                $this->process_date->setFormValue($val, true, $validate);
            }
            $this->process_date->CurrentValue = UnFormatDateTime($this->process_date->CurrentValue, $this->process_date->formatPattern());
        }

        // Check field name 'process_complete' first before field var 'x_process_complete'
        $val = $CurrentForm->hasValue("process_complete") ? $CurrentForm->getValue("process_complete") : $CurrentForm->getValue("x_process_complete");
        if (!$this->process_complete->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->process_complete->Visible = false; // Disable update for API request
            } else {
                $this->process_complete->setFormValue($val, true, $validate);
            }
            $this->process_complete->CurrentValue = UnFormatDateTime($this->process_complete->CurrentValue, $this->process_complete->formatPattern());
        }

        // Check field name 'm_out_id' first before field var 'x_m_out_id'
        $val = $CurrentForm->hasValue("m_out_id") ? $CurrentForm->getValue("m_out_id") : $CurrentForm->getValue("x_m_out_id");
        if (!$this->m_out_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_out_id->Visible = false; // Disable update for API request
            } else {
                $this->m_out_id->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val, true, $validate);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->partner_id->CurrentValue = $this->partner_id->FormValue;
        $this->po->CurrentValue = $this->po->FormValue;
        $this->dispatch_week->CurrentValue = $this->dispatch_week->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->rid_tmp->CurrentValue = $this->rid_tmp->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->product_code->CurrentValue = $this->product_code->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->sub_process->CurrentValue = $this->sub_process->FormValue;
        $this->quantity_sub->CurrentValue = $this->quantity_sub->FormValue;
        $this->qty->CurrentValue = $this->qty->FormValue;
        $this->p_qty->CurrentValue = $this->p_qty->FormValue;
        $this->c_qty_remarks->CurrentValue = $this->c_qty_remarks->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->cart_id->CurrentValue = $this->cart_id->FormValue;
        $this->amount->CurrentValue = $this->amount->FormValue;
        $this->week_p->CurrentValue = $this->week_p->FormValue;
        $this->process_all->CurrentValue = $this->process_all->FormValue;
        $this->current_process->CurrentValue = $this->current_process->FormValue;
        $this->loom_id->CurrentValue = $this->loom_id->FormValue;
        $this->process_date->CurrentValue = $this->process_date->FormValue;
        $this->process_date->CurrentValue = UnFormatDateTime($this->process_date->CurrentValue, $this->process_date->formatPattern());
        $this->process_complete->CurrentValue = $this->process_complete->FormValue;
        $this->process_complete->CurrentValue = UnFormatDateTime($this->process_complete->CurrentValue, $this->process_complete->formatPattern());
        $this->m_out_id->CurrentValue = $this->m_out_id->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->po->setDbValue($row['po']);
        $this->dispatch_week->setDbValue($row['dispatch_week']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid_tmp->setDbValue($row['rid_tmp']);
        $this->rid->setDbValue($row['rid']);
        $this->product_code->setDbValue($row['product_code']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->sub_process->setDbValue($row['sub_process']);
        $this->quantity_sub->setDbValue($row['quantity_sub']);
        $this->qty->setDbValue($row['qty']);
        $this->p_qty->setDbValue($row['p_qty']);
        $this->c_qty_remarks->setDbValue($row['c_qty_remarks']);
        $this->remarks->setDbValue($row['remarks']);
        $this->cart_id->setDbValue($row['cart_id']);
        $this->amount->setDbValue($row['amount']);
        $this->week_p->setDbValue($row['week_p']);
        $this->process_all->setDbValue($row['process_all']);
        $this->current_process->setDbValue($row['current_process']);
        $this->loom_id->setDbValue($row['loom_id']);
        $this->process_date->setDbValue($row['process_date']);
        $this->process_complete->setDbValue($row['process_complete']);
        $this->m_out_id->setDbValue($row['m_out_id']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['dispatch_week'] = $this->dispatch_week->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid_tmp'] = $this->rid_tmp->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['product_code'] = $this->product_code->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['sub_process'] = $this->sub_process->DefaultValue;
        $row['quantity_sub'] = $this->quantity_sub->DefaultValue;
        $row['qty'] = $this->qty->DefaultValue;
        $row['p_qty'] = $this->p_qty->DefaultValue;
        $row['c_qty_remarks'] = $this->c_qty_remarks->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['cart_id'] = $this->cart_id->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['week_p'] = $this->week_p->DefaultValue;
        $row['process_all'] = $this->process_all->DefaultValue;
        $row['current_process'] = $this->current_process->DefaultValue;
        $row['loom_id'] = $this->loom_id->DefaultValue;
        $row['process_date'] = $this->process_date->DefaultValue;
        $row['process_complete'] = $this->process_complete->DefaultValue;
        $row['m_out_id'] = $this->m_out_id->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // partner_id
        $this->partner_id->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // dispatch_week
        $this->dispatch_week->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid_tmp
        $this->rid_tmp->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // product_code
        $this->product_code->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // sub_process
        $this->sub_process->RowCssClass = "row";

        // quantity_sub
        $this->quantity_sub->RowCssClass = "row";

        // qty
        $this->qty->RowCssClass = "row";

        // p_qty
        $this->p_qty->RowCssClass = "row";

        // c_qty_remarks
        $this->c_qty_remarks->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // cart_id
        $this->cart_id->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // week_p
        $this->week_p->RowCssClass = "row";

        // process_all
        $this->process_all->RowCssClass = "row";

        // current_process
        $this->current_process->RowCssClass = "row";

        // loom_id
        $this->loom_id->RowCssClass = "row";

        // process_date
        $this->process_date->RowCssClass = "row";

        // process_complete
        $this->process_complete->RowCssClass = "row";

        // m_out_id
        $this->m_out_id->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $this->partner_id->ViewValue = FormatNumber($this->partner_id->ViewValue, $this->partner_id->formatPattern());

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // dispatch_week
            $this->dispatch_week->ViewValue = $this->dispatch_week->CurrentValue;
            $this->dispatch_week->ViewValue = FormatNumber($this->dispatch_week->ViewValue, $this->dispatch_week->formatPattern());

            // grp
            $this->grp->ViewValue = $this->grp->CurrentValue;
            $this->grp->ViewValue = FormatNumber($this->grp->ViewValue, $this->grp->formatPattern());

            // s_grp
            $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
            $this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, $this->s_grp->formatPattern());

            // product
            $this->product->ViewValue = $this->product->CurrentValue;
            $this->product->ViewValue = FormatNumber($this->product->ViewValue, $this->product->formatPattern());

            // rid_tmp
            $this->rid_tmp->ViewValue = $this->rid_tmp->CurrentValue;

            // rid
            $this->rid->ViewValue = $this->rid->CurrentValue;
            $this->rid->ViewValue = FormatNumber($this->rid->ViewValue, $this->rid->formatPattern());

            // product_code
            $this->product_code->ViewValue = $this->product_code->CurrentValue;

            // packing_type
            $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
            $this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, $this->packing_type->formatPattern());

            // sub_process
            $this->sub_process->ViewValue = $this->sub_process->CurrentValue;
            $this->sub_process->ViewValue = FormatNumber($this->sub_process->ViewValue, $this->sub_process->formatPattern());

            // quantity_sub
            $this->quantity_sub->ViewValue = $this->quantity_sub->CurrentValue;
            $this->quantity_sub->ViewValue = FormatNumber($this->quantity_sub->ViewValue, $this->quantity_sub->formatPattern());

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // p_qty
            $this->p_qty->ViewValue = $this->p_qty->CurrentValue;
            $this->p_qty->ViewValue = FormatNumber($this->p_qty->ViewValue, $this->p_qty->formatPattern());

            // c_qty_remarks
            $this->c_qty_remarks->ViewValue = $this->c_qty_remarks->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // cart_id
            $this->cart_id->ViewValue = $this->cart_id->CurrentValue;
            $this->cart_id->ViewValue = FormatNumber($this->cart_id->ViewValue, $this->cart_id->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // week_p
            $this->week_p->ViewValue = $this->week_p->CurrentValue;

            // process_all
            $this->process_all->ViewValue = $this->process_all->CurrentValue;

            // current_process
            $this->current_process->ViewValue = $this->current_process->CurrentValue;
            $this->current_process->ViewValue = FormatNumber($this->current_process->ViewValue, $this->current_process->formatPattern());

            // loom_id
            $this->loom_id->ViewValue = $this->loom_id->CurrentValue;
            $this->loom_id->ViewValue = FormatNumber($this->loom_id->ViewValue, $this->loom_id->formatPattern());

            // process_date
            $this->process_date->ViewValue = $this->process_date->CurrentValue;
            $this->process_date->ViewValue = FormatDateTime($this->process_date->ViewValue, $this->process_date->formatPattern());

            // process_complete
            $this->process_complete->ViewValue = $this->process_complete->CurrentValue;
            $this->process_complete->ViewValue = FormatDateTime($this->process_complete->ViewValue, $this->process_complete->formatPattern());

            // m_out_id
            $this->m_out_id->ViewValue = $this->m_out_id->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // partner_id
            $this->partner_id->HrefValue = "";

            // po
            $this->po->HrefValue = "";

            // dispatch_week
            $this->dispatch_week->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // product
            $this->product->HrefValue = "";

            // rid_tmp
            $this->rid_tmp->HrefValue = "";

            // rid
            $this->rid->HrefValue = "";

            // product_code
            $this->product_code->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // sub_process
            $this->sub_process->HrefValue = "";

            // quantity_sub
            $this->quantity_sub->HrefValue = "";

            // qty
            $this->qty->HrefValue = "";

            // p_qty
            $this->p_qty->HrefValue = "";

            // c_qty_remarks
            $this->c_qty_remarks->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // cart_id
            $this->cart_id->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // week_p
            $this->week_p->HrefValue = "";

            // process_all
            $this->process_all->HrefValue = "";

            // current_process
            $this->current_process->HrefValue = "";

            // loom_id
            $this->loom_id->HrefValue = "";

            // process_date
            $this->process_date->HrefValue = "";

            // process_complete
            $this->process_complete->HrefValue = "";

            // m_out_id
            $this->m_out_id->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // partner_id
            $this->partner_id->setupEditAttributes();
            $this->partner_id->EditValue = $this->partner_id->CurrentValue;
            $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());
            if (strval($this->partner_id->EditValue) != "" && is_numeric($this->partner_id->EditValue)) {
                $this->partner_id->EditValue = FormatNumber($this->partner_id->EditValue, null);
            }

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->CurrentValue;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());
            if (strval($this->po->EditValue) != "" && is_numeric($this->po->EditValue)) {
                $this->po->EditValue = FormatNumber($this->po->EditValue, null);
            }

            // dispatch_week
            $this->dispatch_week->setupEditAttributes();
            $this->dispatch_week->EditValue = $this->dispatch_week->CurrentValue;
            $this->dispatch_week->PlaceHolder = RemoveHtml($this->dispatch_week->caption());
            if (strval($this->dispatch_week->EditValue) != "" && is_numeric($this->dispatch_week->EditValue)) {
                $this->dispatch_week->EditValue = FormatNumber($this->dispatch_week->EditValue, null);
            }

            // grp
            $this->grp->setupEditAttributes();
            $this->grp->EditValue = $this->grp->CurrentValue;
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());
            if (strval($this->grp->EditValue) != "" && is_numeric($this->grp->EditValue)) {
                $this->grp->EditValue = FormatNumber($this->grp->EditValue, null);
            }

            // s_grp
            $this->s_grp->setupEditAttributes();
            $this->s_grp->EditValue = $this->s_grp->CurrentValue;
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());
            if (strval($this->s_grp->EditValue) != "" && is_numeric($this->s_grp->EditValue)) {
                $this->s_grp->EditValue = FormatNumber($this->s_grp->EditValue, null);
            }

            // product
            $this->product->setupEditAttributes();
            $this->product->EditValue = $this->product->CurrentValue;
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());
            if (strval($this->product->EditValue) != "" && is_numeric($this->product->EditValue)) {
                $this->product->EditValue = FormatNumber($this->product->EditValue, null);
            }

            // rid_tmp
            $this->rid_tmp->setupEditAttributes();
            if (!$this->rid_tmp->Raw) {
                $this->rid_tmp->CurrentValue = HtmlDecode($this->rid_tmp->CurrentValue);
            }
            $this->rid_tmp->EditValue = HtmlEncode($this->rid_tmp->CurrentValue);
            $this->rid_tmp->PlaceHolder = RemoveHtml($this->rid_tmp->caption());

            // rid
            $this->rid->setupEditAttributes();
            $this->rid->EditValue = $this->rid->CurrentValue;
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());
            if (strval($this->rid->EditValue) != "" && is_numeric($this->rid->EditValue)) {
                $this->rid->EditValue = FormatNumber($this->rid->EditValue, null);
            }

            // product_code
            $this->product_code->setupEditAttributes();
            if (!$this->product_code->Raw) {
                $this->product_code->CurrentValue = HtmlDecode($this->product_code->CurrentValue);
            }
            $this->product_code->EditValue = HtmlEncode($this->product_code->CurrentValue);
            $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $this->packing_type->EditValue = $this->packing_type->CurrentValue;
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());
            if (strval($this->packing_type->EditValue) != "" && is_numeric($this->packing_type->EditValue)) {
                $this->packing_type->EditValue = FormatNumber($this->packing_type->EditValue, null);
            }

            // sub_process
            $this->sub_process->setupEditAttributes();
            $this->sub_process->EditValue = $this->sub_process->CurrentValue;
            $this->sub_process->PlaceHolder = RemoveHtml($this->sub_process->caption());
            if (strval($this->sub_process->EditValue) != "" && is_numeric($this->sub_process->EditValue)) {
                $this->sub_process->EditValue = FormatNumber($this->sub_process->EditValue, null);
            }

            // quantity_sub
            $this->quantity_sub->setupEditAttributes();
            $this->quantity_sub->EditValue = $this->quantity_sub->CurrentValue;
            $this->quantity_sub->PlaceHolder = RemoveHtml($this->quantity_sub->caption());
            if (strval($this->quantity_sub->EditValue) != "" && is_numeric($this->quantity_sub->EditValue)) {
                $this->quantity_sub->EditValue = FormatNumber($this->quantity_sub->EditValue, null);
            }

            // qty
            $this->qty->setupEditAttributes();
            $this->qty->EditValue = $this->qty->CurrentValue;
            $this->qty->PlaceHolder = RemoveHtml($this->qty->caption());
            if (strval($this->qty->EditValue) != "" && is_numeric($this->qty->EditValue)) {
                $this->qty->EditValue = FormatNumber($this->qty->EditValue, null);
            }

            // p_qty
            $this->p_qty->setupEditAttributes();
            $this->p_qty->EditValue = $this->p_qty->CurrentValue;
            $this->p_qty->PlaceHolder = RemoveHtml($this->p_qty->caption());
            if (strval($this->p_qty->EditValue) != "" && is_numeric($this->p_qty->EditValue)) {
                $this->p_qty->EditValue = FormatNumber($this->p_qty->EditValue, null);
            }

            // c_qty_remarks
            $this->c_qty_remarks->setupEditAttributes();
            if (!$this->c_qty_remarks->Raw) {
                $this->c_qty_remarks->CurrentValue = HtmlDecode($this->c_qty_remarks->CurrentValue);
            }
            $this->c_qty_remarks->EditValue = HtmlEncode($this->c_qty_remarks->CurrentValue);
            $this->c_qty_remarks->PlaceHolder = RemoveHtml($this->c_qty_remarks->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // cart_id
            $this->cart_id->setupEditAttributes();
            $this->cart_id->EditValue = $this->cart_id->CurrentValue;
            $this->cart_id->PlaceHolder = RemoveHtml($this->cart_id->caption());
            if (strval($this->cart_id->EditValue) != "" && is_numeric($this->cart_id->EditValue)) {
                $this->cart_id->EditValue = FormatNumber($this->cart_id->EditValue, null);
            }

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->CurrentValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
            if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
                $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
            }

            // week_p
            $this->week_p->setupEditAttributes();
            if (!$this->week_p->Raw) {
                $this->week_p->CurrentValue = HtmlDecode($this->week_p->CurrentValue);
            }
            $this->week_p->EditValue = HtmlEncode($this->week_p->CurrentValue);
            $this->week_p->PlaceHolder = RemoveHtml($this->week_p->caption());

            // process_all
            $this->process_all->setupEditAttributes();
            if (!$this->process_all->Raw) {
                $this->process_all->CurrentValue = HtmlDecode($this->process_all->CurrentValue);
            }
            $this->process_all->EditValue = HtmlEncode($this->process_all->CurrentValue);
            $this->process_all->PlaceHolder = RemoveHtml($this->process_all->caption());

            // current_process
            $this->current_process->setupEditAttributes();
            $this->current_process->EditValue = $this->current_process->CurrentValue;
            $this->current_process->PlaceHolder = RemoveHtml($this->current_process->caption());
            if (strval($this->current_process->EditValue) != "" && is_numeric($this->current_process->EditValue)) {
                $this->current_process->EditValue = FormatNumber($this->current_process->EditValue, null);
            }

            // loom_id
            $this->loom_id->setupEditAttributes();
            $this->loom_id->EditValue = $this->loom_id->CurrentValue;
            $this->loom_id->PlaceHolder = RemoveHtml($this->loom_id->caption());
            if (strval($this->loom_id->EditValue) != "" && is_numeric($this->loom_id->EditValue)) {
                $this->loom_id->EditValue = FormatNumber($this->loom_id->EditValue, null);
            }

            // process_date
            $this->process_date->setupEditAttributes();
            $this->process_date->EditValue = HtmlEncode(FormatDateTime($this->process_date->CurrentValue, $this->process_date->formatPattern()));
            $this->process_date->PlaceHolder = RemoveHtml($this->process_date->caption());

            // process_complete
            $this->process_complete->setupEditAttributes();
            $this->process_complete->EditValue = HtmlEncode(FormatDateTime($this->process_complete->CurrentValue, $this->process_complete->formatPattern()));
            $this->process_complete->PlaceHolder = RemoveHtml($this->process_complete->caption());

            // m_out_id
            $this->m_out_id->setupEditAttributes();
            if (!$this->m_out_id->Raw) {
                $this->m_out_id->CurrentValue = HtmlDecode($this->m_out_id->CurrentValue);
            }
            $this->m_out_id->EditValue = HtmlEncode($this->m_out_id->CurrentValue);
            $this->m_out_id->PlaceHolder = RemoveHtml($this->m_out_id->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->CurrentValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());
            if (strval($this->operator->EditValue) != "" && is_numeric($this->operator->EditValue)) {
                $this->operator->EditValue = FormatNumber($this->operator->EditValue, null);
            }

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // Add refer script

            // partner_id
            $this->partner_id->HrefValue = "";

            // po
            $this->po->HrefValue = "";

            // dispatch_week
            $this->dispatch_week->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // product
            $this->product->HrefValue = "";

            // rid_tmp
            $this->rid_tmp->HrefValue = "";

            // rid
            $this->rid->HrefValue = "";

            // product_code
            $this->product_code->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // sub_process
            $this->sub_process->HrefValue = "";

            // quantity_sub
            $this->quantity_sub->HrefValue = "";

            // qty
            $this->qty->HrefValue = "";

            // p_qty
            $this->p_qty->HrefValue = "";

            // c_qty_remarks
            $this->c_qty_remarks->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // cart_id
            $this->cart_id->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // week_p
            $this->week_p->HrefValue = "";

            // process_all
            $this->process_all->HrefValue = "";

            // current_process
            $this->current_process->HrefValue = "";

            // loom_id
            $this->loom_id->HrefValue = "";

            // process_date
            $this->process_date->HrefValue = "";

            // process_complete
            $this->process_complete->HrefValue = "";

            // m_out_id
            $this->m_out_id->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->partner_id->Visible && $this->partner_id->Required) {
                if (!$this->partner_id->IsDetailKey && EmptyValue($this->partner_id->FormValue)) {
                    $this->partner_id->addErrorMessage(str_replace("%s", $this->partner_id->caption(), $this->partner_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->partner_id->FormValue)) {
                $this->partner_id->addErrorMessage($this->partner_id->getErrorMessage(false));
            }
            if ($this->po->Visible && $this->po->Required) {
                if (!$this->po->IsDetailKey && EmptyValue($this->po->FormValue)) {
                    $this->po->addErrorMessage(str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->po->FormValue)) {
                $this->po->addErrorMessage($this->po->getErrorMessage(false));
            }
            if ($this->dispatch_week->Visible && $this->dispatch_week->Required) {
                if (!$this->dispatch_week->IsDetailKey && EmptyValue($this->dispatch_week->FormValue)) {
                    $this->dispatch_week->addErrorMessage(str_replace("%s", $this->dispatch_week->caption(), $this->dispatch_week->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->dispatch_week->FormValue)) {
                $this->dispatch_week->addErrorMessage($this->dispatch_week->getErrorMessage(false));
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->grp->FormValue)) {
                $this->grp->addErrorMessage($this->grp->getErrorMessage(false));
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->s_grp->FormValue)) {
                $this->s_grp->addErrorMessage($this->s_grp->getErrorMessage(false));
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->product->FormValue)) {
                $this->product->addErrorMessage($this->product->getErrorMessage(false));
            }
            if ($this->rid_tmp->Visible && $this->rid_tmp->Required) {
                if (!$this->rid_tmp->IsDetailKey && EmptyValue($this->rid_tmp->FormValue)) {
                    $this->rid_tmp->addErrorMessage(str_replace("%s", $this->rid_tmp->caption(), $this->rid_tmp->RequiredErrorMessage));
                }
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if (!$this->rid->IsDetailKey && EmptyValue($this->rid->FormValue)) {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->rid->FormValue)) {
                $this->rid->addErrorMessage($this->rid->getErrorMessage(false));
            }
            if ($this->product_code->Visible && $this->product_code->Required) {
                if (!$this->product_code->IsDetailKey && EmptyValue($this->product_code->FormValue)) {
                    $this->product_code->addErrorMessage(str_replace("%s", $this->product_code->caption(), $this->product_code->RequiredErrorMessage));
                }
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->packing_type->FormValue)) {
                $this->packing_type->addErrorMessage($this->packing_type->getErrorMessage(false));
            }
            if ($this->sub_process->Visible && $this->sub_process->Required) {
                if (!$this->sub_process->IsDetailKey && EmptyValue($this->sub_process->FormValue)) {
                    $this->sub_process->addErrorMessage(str_replace("%s", $this->sub_process->caption(), $this->sub_process->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->sub_process->FormValue)) {
                $this->sub_process->addErrorMessage($this->sub_process->getErrorMessage(false));
            }
            if ($this->quantity_sub->Visible && $this->quantity_sub->Required) {
                if (!$this->quantity_sub->IsDetailKey && EmptyValue($this->quantity_sub->FormValue)) {
                    $this->quantity_sub->addErrorMessage(str_replace("%s", $this->quantity_sub->caption(), $this->quantity_sub->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->quantity_sub->FormValue)) {
                $this->quantity_sub->addErrorMessage($this->quantity_sub->getErrorMessage(false));
            }
            if ($this->qty->Visible && $this->qty->Required) {
                if (!$this->qty->IsDetailKey && EmptyValue($this->qty->FormValue)) {
                    $this->qty->addErrorMessage(str_replace("%s", $this->qty->caption(), $this->qty->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty->FormValue)) {
                $this->qty->addErrorMessage($this->qty->getErrorMessage(false));
            }
            if ($this->p_qty->Visible && $this->p_qty->Required) {
                if (!$this->p_qty->IsDetailKey && EmptyValue($this->p_qty->FormValue)) {
                    $this->p_qty->addErrorMessage(str_replace("%s", $this->p_qty->caption(), $this->p_qty->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->p_qty->FormValue)) {
                $this->p_qty->addErrorMessage($this->p_qty->getErrorMessage(false));
            }
            if ($this->c_qty_remarks->Visible && $this->c_qty_remarks->Required) {
                if (!$this->c_qty_remarks->IsDetailKey && EmptyValue($this->c_qty_remarks->FormValue)) {
                    $this->c_qty_remarks->addErrorMessage(str_replace("%s", $this->c_qty_remarks->caption(), $this->c_qty_remarks->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->cart_id->Visible && $this->cart_id->Required) {
                if (!$this->cart_id->IsDetailKey && EmptyValue($this->cart_id->FormValue)) {
                    $this->cart_id->addErrorMessage(str_replace("%s", $this->cart_id->caption(), $this->cart_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->cart_id->FormValue)) {
                $this->cart_id->addErrorMessage($this->cart_id->getErrorMessage(false));
            }
            if ($this->amount->Visible && $this->amount->Required) {
                if (!$this->amount->IsDetailKey && EmptyValue($this->amount->FormValue)) {
                    $this->amount->addErrorMessage(str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->amount->FormValue)) {
                $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
            }
            if ($this->week_p->Visible && $this->week_p->Required) {
                if (!$this->week_p->IsDetailKey && EmptyValue($this->week_p->FormValue)) {
                    $this->week_p->addErrorMessage(str_replace("%s", $this->week_p->caption(), $this->week_p->RequiredErrorMessage));
                }
            }
            if ($this->process_all->Visible && $this->process_all->Required) {
                if (!$this->process_all->IsDetailKey && EmptyValue($this->process_all->FormValue)) {
                    $this->process_all->addErrorMessage(str_replace("%s", $this->process_all->caption(), $this->process_all->RequiredErrorMessage));
                }
            }
            if ($this->current_process->Visible && $this->current_process->Required) {
                if (!$this->current_process->IsDetailKey && EmptyValue($this->current_process->FormValue)) {
                    $this->current_process->addErrorMessage(str_replace("%s", $this->current_process->caption(), $this->current_process->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->current_process->FormValue)) {
                $this->current_process->addErrorMessage($this->current_process->getErrorMessage(false));
            }
            if ($this->loom_id->Visible && $this->loom_id->Required) {
                if (!$this->loom_id->IsDetailKey && EmptyValue($this->loom_id->FormValue)) {
                    $this->loom_id->addErrorMessage(str_replace("%s", $this->loom_id->caption(), $this->loom_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->loom_id->FormValue)) {
                $this->loom_id->addErrorMessage($this->loom_id->getErrorMessage(false));
            }
            if ($this->process_date->Visible && $this->process_date->Required) {
                if (!$this->process_date->IsDetailKey && EmptyValue($this->process_date->FormValue)) {
                    $this->process_date->addErrorMessage(str_replace("%s", $this->process_date->caption(), $this->process_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->process_date->FormValue, $this->process_date->formatPattern())) {
                $this->process_date->addErrorMessage($this->process_date->getErrorMessage(false));
            }
            if ($this->process_complete->Visible && $this->process_complete->Required) {
                if (!$this->process_complete->IsDetailKey && EmptyValue($this->process_complete->FormValue)) {
                    $this->process_complete->addErrorMessage(str_replace("%s", $this->process_complete->caption(), $this->process_complete->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->process_complete->FormValue, $this->process_complete->formatPattern())) {
                $this->process_complete->addErrorMessage($this->process_complete->getErrorMessage(false));
            }
            if ($this->m_out_id->Visible && $this->m_out_id->Required) {
                if (!$this->m_out_id->IsDetailKey && EmptyValue($this->m_out_id->FormValue)) {
                    $this->m_out_id->addErrorMessage(str_replace("%s", $this->m_out_id->caption(), $this->m_out_id->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->operator->FormValue)) {
                $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->datetime->FormValue, $this->datetime->formatPattern())) {
                $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // partner_id
        $this->partner_id->setDbValueDef($rsnew, $this->partner_id->CurrentValue, false);

        // po
        $this->po->setDbValueDef($rsnew, $this->po->CurrentValue, false);

        // dispatch_week
        $this->dispatch_week->setDbValueDef($rsnew, $this->dispatch_week->CurrentValue, false);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, false);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, false);

        // rid_tmp
        $this->rid_tmp->setDbValueDef($rsnew, $this->rid_tmp->CurrentValue, false);

        // rid
        $this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, false);

        // product_code
        $this->product_code->setDbValueDef($rsnew, $this->product_code->CurrentValue, false);

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, false);

        // sub_process
        $this->sub_process->setDbValueDef($rsnew, $this->sub_process->CurrentValue, false);

        // quantity_sub
        $this->quantity_sub->setDbValueDef($rsnew, $this->quantity_sub->CurrentValue, strval($this->quantity_sub->CurrentValue) == "");

        // qty
        $this->qty->setDbValueDef($rsnew, $this->qty->CurrentValue, false);

        // p_qty
        $this->p_qty->setDbValueDef($rsnew, $this->p_qty->CurrentValue, false);

        // c_qty_remarks
        $this->c_qty_remarks->setDbValueDef($rsnew, $this->c_qty_remarks->CurrentValue, false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // cart_id
        $this->cart_id->setDbValueDef($rsnew, $this->cart_id->CurrentValue, false);

        // amount
        $this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, strval($this->amount->CurrentValue) == "");

        // week_p
        $this->week_p->setDbValueDef($rsnew, $this->week_p->CurrentValue, false);

        // process_all
        $this->process_all->setDbValueDef($rsnew, $this->process_all->CurrentValue, false);

        // current_process
        $this->current_process->setDbValueDef($rsnew, $this->current_process->CurrentValue, false);

        // loom_id
        $this->loom_id->setDbValueDef($rsnew, $this->loom_id->CurrentValue, false);

        // process_date
        $this->process_date->setDbValueDef($rsnew, UnFormatDateTime($this->process_date->CurrentValue, $this->process_date->formatPattern()), false);

        // process_complete
        $this->process_complete->setDbValueDef($rsnew, UnFormatDateTime($this->process_complete->CurrentValue, $this->process_complete->formatPattern()), false);

        // m_out_id
        $this->m_out_id->setDbValueDef($rsnew, $this->m_out_id->CurrentValue, false);

        // operator
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['partner_id'])) { // partner_id
            $this->partner_id->setFormValue($row['partner_id']);
        }
        if (isset($row['po'])) { // po
            $this->po->setFormValue($row['po']);
        }
        if (isset($row['dispatch_week'])) { // dispatch_week
            $this->dispatch_week->setFormValue($row['dispatch_week']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->setFormValue($row['s_grp']);
        }
        if (isset($row['product'])) { // product
            $this->product->setFormValue($row['product']);
        }
        if (isset($row['rid_tmp'])) { // rid_tmp
            $this->rid_tmp->setFormValue($row['rid_tmp']);
        }
        if (isset($row['rid'])) { // rid
            $this->rid->setFormValue($row['rid']);
        }
        if (isset($row['product_code'])) { // product_code
            $this->product_code->setFormValue($row['product_code']);
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->setFormValue($row['packing_type']);
        }
        if (isset($row['sub_process'])) { // sub_process
            $this->sub_process->setFormValue($row['sub_process']);
        }
        if (isset($row['quantity_sub'])) { // quantity_sub
            $this->quantity_sub->setFormValue($row['quantity_sub']);
        }
        if (isset($row['qty'])) { // qty
            $this->qty->setFormValue($row['qty']);
        }
        if (isset($row['p_qty'])) { // p_qty
            $this->p_qty->setFormValue($row['p_qty']);
        }
        if (isset($row['c_qty_remarks'])) { // c_qty_remarks
            $this->c_qty_remarks->setFormValue($row['c_qty_remarks']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['cart_id'])) { // cart_id
            $this->cart_id->setFormValue($row['cart_id']);
        }
        if (isset($row['amount'])) { // amount
            $this->amount->setFormValue($row['amount']);
        }
        if (isset($row['week_p'])) { // week_p
            $this->week_p->setFormValue($row['week_p']);
        }
        if (isset($row['process_all'])) { // process_all
            $this->process_all->setFormValue($row['process_all']);
        }
        if (isset($row['current_process'])) { // current_process
            $this->current_process->setFormValue($row['current_process']);
        }
        if (isset($row['loom_id'])) { // loom_id
            $this->loom_id->setFormValue($row['loom_id']);
        }
        if (isset($row['process_date'])) { // process_date
            $this->process_date->setFormValue($row['process_date']);
        }
        if (isset($row['process_complete'])) { // process_complete
            $this->process_complete->setFormValue($row['process_complete']);
        }
        if (isset($row['m_out_id'])) { // m_out_id
            $this->m_out_id->setFormValue($row['m_out_id']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("processwbcwpplist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
