<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProcessTableHsAdd extends ProcessTableHs
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProcessTableHsAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "processtablehsadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->grp->setVisibility();
        $this->godown->setVisibility();
        $this->emp_name->setVisibility();
        $this->ref->setVisibility();
        $this->rid->setVisibility();
        $this->batch_no->setVisibility();
        $this->count->setVisibility();
        $this->count_received->setVisibility();
        $this->twist->setVisibility();
        $this->quantity_avg_act->setVisibility();
        $this->quantity->setVisibility();
        $this->status->setVisibility();
        $this->std_rate->setVisibility();
        $this->_40->setVisibility();
        $this->total_amount->setVisibility();
        $this->payment->setVisibility();
        $this->remarks->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->product->Visible = false;
        $this->process->Visible = false;
        $this->packets->Visible = false;
        $this->packing_type->Visible = false;
        $this->product_code_new->Visible = false;
        $this->product_new->Visible = false;
        $this->dated->Visible = false;
        $this->s_grp->Visible = false;
        $this->lot_no->Visible = false;
        $this->tmp_lot->Visible = false;
        $this->shortage->Visible = false;
        $this->shortage_amount->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'process_table_hs';
        $this->TableName = 'process_table_hs';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (process_table_hs)
        if (!isset($GLOBALS["process_table_hs"]) || $GLOBALS["process_table_hs"]::class == PROJECT_NAMESPACE . "process_table_hs") {
            $GLOBALS["process_table_hs"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_table_hs');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "processtablehsview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->godown);
        $this->setupLookupOptions($this->twist);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->std_rate);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->s_grp);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("processtablehslist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = "autoprogramme?apcid=7eabe3a1649ffa2b3ff8c02ebfd5659f";

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "processtablehslist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "processtablehslist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->grp->DefaultValue = $this->grp->getDefault(); // PHP
        $this->grp->OldValue = $this->grp->DefaultValue;
        $this->godown->DefaultValue = $this->godown->getDefault(); // PHP
        $this->godown->OldValue = $this->godown->DefaultValue;
        $this->std_rate->DefaultValue = $this->std_rate->getDefault(); // PHP
        $this->std_rate->OldValue = $this->std_rate->DefaultValue;
        $this->payment->DefaultValue = $this->payment->getDefault(); // PHP
        $this->payment->OldValue = $this->payment->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->s_grp->DefaultValue = $this->s_grp->getDefault(); // PHP
        $this->s_grp->OldValue = $this->s_grp->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 'godown' first before field var 'x_godown'
        $val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
        if (!$this->godown->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->godown->Visible = false; // Disable update for API request
            } else {
                $this->godown->setFormValue($val);
            }
        }

        // Check field name 'emp_name' first before field var 'x_emp_name'
        $val = $CurrentForm->hasValue("emp_name") ? $CurrentForm->getValue("emp_name") : $CurrentForm->getValue("x_emp_name");
        if (!$this->emp_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->emp_name->Visible = false; // Disable update for API request
            } else {
                $this->emp_name->setFormValue($val);
            }
        }

        // Check field name 'ref' first before field var 'x_ref'
        $val = $CurrentForm->hasValue("ref") ? $CurrentForm->getValue("ref") : $CurrentForm->getValue("x_ref");
        if (!$this->ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ref->Visible = false; // Disable update for API request
            } else {
                $this->ref->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'batch_no' first before field var 'x_batch_no'
        $val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
        if (!$this->batch_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_no->Visible = false; // Disable update for API request
            } else {
                $this->batch_no->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'count' first before field var 'x_count'
        $val = $CurrentForm->hasValue("count") ? $CurrentForm->getValue("count") : $CurrentForm->getValue("x_count");
        if (!$this->count->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->count->Visible = false; // Disable update for API request
            } else {
                $this->count->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'count_received' first before field var 'x_count_received'
        $val = $CurrentForm->hasValue("count_received") ? $CurrentForm->getValue("count_received") : $CurrentForm->getValue("x_count_received");
        if (!$this->count_received->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->count_received->Visible = false; // Disable update for API request
            } else {
                $this->count_received->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'twist' first before field var 'x_twist'
        $val = $CurrentForm->hasValue("twist") ? $CurrentForm->getValue("twist") : $CurrentForm->getValue("x_twist");
        if (!$this->twist->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->twist->Visible = false; // Disable update for API request
            } else {
                $this->twist->setFormValue($val);
            }
        }

        // Check field name 'quantity_avg_act' first before field var 'x_quantity_avg_act'
        $val = $CurrentForm->hasValue("quantity_avg_act") ? $CurrentForm->getValue("quantity_avg_act") : $CurrentForm->getValue("x_quantity_avg_act");
        if (!$this->quantity_avg_act->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity_avg_act->Visible = false; // Disable update for API request
            } else {
                $this->quantity_avg_act->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'std_rate' first before field var 'x_std_rate'
        $val = $CurrentForm->hasValue("std_rate") ? $CurrentForm->getValue("std_rate") : $CurrentForm->getValue("x_std_rate");
        if (!$this->std_rate->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->std_rate->Visible = false; // Disable update for API request
            } else {
                $this->std_rate->setFormValue($val);
            }
        }

        // Check field name '@' first before field var 'x__40'
        $val = $CurrentForm->hasValue("@") ? $CurrentForm->getValue("@") : $CurrentForm->getValue("x__40");
        if (!$this->_40->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_40->Visible = false; // Disable update for API request
            } else {
                $this->_40->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'total_amount' first before field var 'x_total_amount'
        $val = $CurrentForm->hasValue("total_amount") ? $CurrentForm->getValue("total_amount") : $CurrentForm->getValue("x_total_amount");
        if (!$this->total_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->total_amount->Visible = false; // Disable update for API request
            } else {
                $this->total_amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'payment' first before field var 'x_payment'
        $val = $CurrentForm->hasValue("payment") ? $CurrentForm->getValue("payment") : $CurrentForm->getValue("x_payment");
        if (!$this->payment->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->payment->Visible = false; // Disable update for API request
            } else {
                $this->payment->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->godown->CurrentValue = $this->godown->FormValue;
        $this->emp_name->CurrentValue = $this->emp_name->FormValue;
        $this->ref->CurrentValue = $this->ref->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->batch_no->CurrentValue = $this->batch_no->FormValue;
        $this->count->CurrentValue = $this->count->FormValue;
        $this->count_received->CurrentValue = $this->count_received->FormValue;
        $this->twist->CurrentValue = $this->twist->FormValue;
        $this->quantity_avg_act->CurrentValue = $this->quantity_avg_act->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->std_rate->CurrentValue = $this->std_rate->FormValue;
        $this->_40->CurrentValue = $this->_40->FormValue;
        $this->total_amount->CurrentValue = $this->total_amount->FormValue;
        $this->payment->CurrentValue = $this->payment->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->godown->setDbValue($row['godown']);
        $this->emp_name->setDbValue($row['emp_name']);
        $this->ref->setDbValue($row['ref']);
        $this->rid->setDbValue($row['rid']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->count->setDbValue($row['count']);
        $this->count_received->setDbValue($row['count_received']);
        $this->twist->setDbValue($row['twist']);
        $this->quantity_avg_act->setDbValue($row['quantity_avg_act']);
        $this->quantity->setDbValue($row['quantity']);
        $this->status->setDbValue($row['status']);
        $this->std_rate->setDbValue($row['std_rate']);
        $this->_40->setDbValue($row['@']);
        $this->total_amount->setDbValue($row['total_amount']);
        $this->payment->setDbValue($row['payment']);
        $this->remarks->setDbValue($row['remarks']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->product->setDbValue($row['product']);
        $this->process->setDbValue($row['process']);
        $this->packets->setDbValue($row['packets']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->product_code_new->setDbValue($row['product_code_new']);
        $this->product_new->setDbValue($row['product_new']);
        $this->dated->setDbValue($row['dated']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->tmp_lot->setDbValue($row['tmp_lot']);
        $this->shortage->setDbValue($row['shortage']);
        $this->shortage_amount->setDbValue($row['shortage_amount']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['godown'] = $this->godown->DefaultValue;
        $row['emp_name'] = $this->emp_name->DefaultValue;
        $row['ref'] = $this->ref->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['count'] = $this->count->DefaultValue;
        $row['count_received'] = $this->count_received->DefaultValue;
        $row['twist'] = $this->twist->DefaultValue;
        $row['quantity_avg_act'] = $this->quantity_avg_act->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['std_rate'] = $this->std_rate->DefaultValue;
        $row['@'] = $this->_40->DefaultValue;
        $row['total_amount'] = $this->total_amount->DefaultValue;
        $row['payment'] = $this->payment->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['packets'] = $this->packets->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['product_code_new'] = $this->product_code_new->DefaultValue;
        $row['product_new'] = $this->product_new->DefaultValue;
        $row['dated'] = $this->dated->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['lot_no'] = $this->lot_no->DefaultValue;
        $row['tmp_lot'] = $this->tmp_lot->DefaultValue;
        $row['shortage'] = $this->shortage->DefaultValue;
        $row['shortage_amount'] = $this->shortage_amount->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // godown
        $this->godown->RowCssClass = "row";

        // emp_name
        $this->emp_name->RowCssClass = "row";

        // ref
        $this->ref->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // count
        $this->count->RowCssClass = "row";

        // count_received
        $this->count_received->RowCssClass = "row";

        // twist
        $this->twist->RowCssClass = "row";

        // quantity_avg_act
        $this->quantity_avg_act->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // std_rate
        $this->std_rate->RowCssClass = "row";

        // @
        $this->_40->RowCssClass = "row";

        // total_amount
        $this->total_amount->RowCssClass = "row";

        // payment
        $this->payment->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // packets
        $this->packets->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // product_code_new
        $this->product_code_new->RowCssClass = "row";

        // product_new
        $this->product_new->RowCssClass = "row";

        // dated
        $this->dated->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // tmp_lot
        $this->tmp_lot->RowCssClass = "row";

        // shortage
        $this->shortage->RowCssClass = "row";

        // shortage_amount
        $this->shortage_amount->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            if (strval($this->grp->CurrentValue) != "") {
                $this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
            } else {
                $this->grp->ViewValue = null;
            }

            // godown
            $curVal = strval($this->godown->CurrentValue);
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                        $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                    } else {
                        $this->godown->ViewValue = FormatNumber($this->godown->CurrentValue, $this->godown->formatPattern());
                    }
                }
            } else {
                $this->godown->ViewValue = null;
            }

            // emp_name
            $this->emp_name->ViewValue = $this->emp_name->CurrentValue;

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;

            // rid
            $this->rid->ViewValue = $this->rid->CurrentValue;
            $this->rid->ViewValue = FormatNumber($this->rid->ViewValue, $this->rid->formatPattern());

            // batch_no
            $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
            $this->batch_no->ViewValue = FormatNumber($this->batch_no->ViewValue, $this->batch_no->formatPattern());

            // count
            $this->count->ViewValue = $this->count->CurrentValue;
            $this->count->ViewValue = FormatNumber($this->count->ViewValue, $this->count->formatPattern());

            // count_received
            $this->count_received->ViewValue = $this->count_received->CurrentValue;

            // twist
            if (strval($this->twist->CurrentValue) != "") {
                $this->twist->ViewValue = $this->twist->optionCaption($this->twist->CurrentValue);
            } else {
                $this->twist->ViewValue = null;
            }

            // quantity_avg_act
            $this->quantity_avg_act->ViewValue = $this->quantity_avg_act->CurrentValue;
            $this->quantity_avg_act->ViewValue = FormatNumber($this->quantity_avg_act->ViewValue, $this->quantity_avg_act->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // std_rate
            $curVal = strval($this->std_rate->CurrentValue);
            if ($curVal != "") {
                $this->std_rate->ViewValue = $this->std_rate->lookupCacheOption($curVal);
                if ($this->std_rate->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->std_rate->Lookup->getTable()->Fields["@"]->searchExpression(), "=", $curVal, $this->std_rate->Lookup->getTable()->Fields["@"]->searchDataType(), "");
                    $sqlWrk = $this->std_rate->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->std_rate->Lookup->renderViewRow($rswrk[0]);
                        $this->std_rate->ViewValue = $this->std_rate->displayValue($arwrk);
                    } else {
                        $this->std_rate->ViewValue = FormatNumber($this->std_rate->CurrentValue, $this->std_rate->formatPattern());
                    }
                }
            } else {
                $this->std_rate->ViewValue = null;
            }

            // @
            $this->_40->ViewValue = $this->_40->CurrentValue;
            $this->_40->ViewValue = FormatNumber($this->_40->ViewValue, $this->_40->formatPattern());

            // total_amount
            $this->total_amount->ViewValue = $this->total_amount->CurrentValue;
            $this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, $this->total_amount->formatPattern());

            // payment
            $this->payment->ViewValue = $this->payment->CurrentValue;
            $this->payment->ViewValue = FormatNumber($this->payment->ViewValue, $this->payment->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // grp
            $this->grp->HrefValue = "";

            // godown
            if (!EmptyValue($this->godown->CurrentValue)) {
                $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
                $this->godown->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
                }
            } else {
                $this->godown->HrefValue = "";
            }

            // emp_name
            if (!EmptyValue($this->emp_name->CurrentValue)) {
                $this->emp_name->HrefValue = $this->emp_name->getLinkPrefix() . $this->emp_name->CurrentValue; // Add prefix/suffix
                $this->emp_name->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->emp_name->HrefValue = FullUrl($this->emp_name->HrefValue, "href");
                }
            } else {
                $this->emp_name->HrefValue = "";
            }

            // ref
            $this->ref->HrefValue = "";
            $this->ref->TooltipValue = "";

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }
            $this->rid->TooltipValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";
            $this->batch_no->TooltipValue = "";

            // count
            $this->count->HrefValue = "";

            // count_received
            $this->count_received->HrefValue = "";

            // twist
            $this->twist->HrefValue = "";

            // quantity_avg_act
            $this->quantity_avg_act->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // std_rate
            $this->std_rate->HrefValue = "";

            // @
            $this->_40->HrefValue = "";

            // total_amount
            $this->total_amount->HrefValue = "";

            // payment
            $this->payment->HrefValue = "";
            $this->payment->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // grp
            $this->grp->setupEditAttributes();
            $this->grp->EditValue = $this->grp->options(true);
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // godown
            $this->godown->setupEditAttributes();
            $curVal = trim(strval($this->godown->CurrentValue));
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
            } else {
                $this->godown->ViewValue = $this->godown->Lookup !== null && is_array($this->godown->lookupOptions()) && count($this->godown->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->godown->ViewValue !== null) { // Load from cache
                $this->godown->EditValue = array_values($this->godown->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->godown->CurrentValue, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->godown->EditValue = $arwrk;
            }
            $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

            // emp_name
            $this->emp_name->setupEditAttributes();
            if (!$this->emp_name->Raw) {
                $this->emp_name->CurrentValue = HtmlDecode($this->emp_name->CurrentValue);
            }
            $this->emp_name->EditValue = HtmlEncode($this->emp_name->CurrentValue);
            $this->emp_name->PlaceHolder = RemoveHtml($this->emp_name->caption());

            // ref
            $this->ref->setupEditAttributes();
            $this->ref->EditValue = $this->ref->CurrentValue;
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());
            if (strval($this->ref->EditValue) != "" && is_numeric($this->ref->EditValue)) {
                $this->ref->EditValue = $this->ref->EditValue;
            }

            // rid
            $this->rid->setupEditAttributes();
            $this->rid->EditValue = $this->rid->CurrentValue;
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());
            if (strval($this->rid->EditValue) != "" && is_numeric($this->rid->EditValue)) {
                $this->rid->EditValue = FormatNumber($this->rid->EditValue, null);
            }

            // batch_no
            $this->batch_no->setupEditAttributes();
            $this->batch_no->EditValue = $this->batch_no->CurrentValue;
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());
            if (strval($this->batch_no->EditValue) != "" && is_numeric($this->batch_no->EditValue)) {
                $this->batch_no->EditValue = FormatNumber($this->batch_no->EditValue, null);
            }

            // count
            $this->count->setupEditAttributes();
            $this->count->EditValue = $this->count->CurrentValue;
            $this->count->PlaceHolder = RemoveHtml($this->count->caption());
            if (strval($this->count->EditValue) != "" && is_numeric($this->count->EditValue)) {
                $this->count->EditValue = FormatNumber($this->count->EditValue, null);
            }

            // count_received
            $this->count_received->setupEditAttributes();
            if (!$this->count_received->Raw) {
                $this->count_received->CurrentValue = HtmlDecode($this->count_received->CurrentValue);
            }
            $this->count_received->EditValue = HtmlEncode($this->count_received->CurrentValue);
            $this->count_received->PlaceHolder = RemoveHtml($this->count_received->caption());

            // twist
            $this->twist->setupEditAttributes();
            $this->twist->EditValue = $this->twist->options(true);
            $this->twist->PlaceHolder = RemoveHtml($this->twist->caption());

            // quantity_avg_act
            $this->quantity_avg_act->setupEditAttributes();
            $this->quantity_avg_act->EditValue = $this->quantity_avg_act->CurrentValue;
            $this->quantity_avg_act->PlaceHolder = RemoveHtml($this->quantity_avg_act->caption());
            if (strval($this->quantity_avg_act->EditValue) != "" && is_numeric($this->quantity_avg_act->EditValue)) {
                $this->quantity_avg_act->EditValue = FormatNumber($this->quantity_avg_act->EditValue, null);
            }

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // status
            $this->status->EditValue = $this->status->options(false);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // std_rate
            $this->std_rate->setupEditAttributes();
            $curVal = trim(strval($this->std_rate->CurrentValue));
            if ($curVal != "") {
                $this->std_rate->ViewValue = $this->std_rate->lookupCacheOption($curVal);
            } else {
                $this->std_rate->ViewValue = $this->std_rate->Lookup !== null && is_array($this->std_rate->lookupOptions()) && count($this->std_rate->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->std_rate->ViewValue !== null) { // Load from cache
                $this->std_rate->EditValue = array_values($this->std_rate->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->std_rate->Lookup->getTable()->Fields["@"]->searchExpression(), "=", $this->std_rate->CurrentValue, $this->std_rate->Lookup->getTable()->Fields["@"]->searchDataType(), "");
                }
                $sqlWrk = $this->std_rate->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->std_rate->Lookup->renderViewRow($row);
                }
                $this->std_rate->EditValue = $arwrk;
            }
            $this->std_rate->PlaceHolder = RemoveHtml($this->std_rate->caption());

            // @
            $this->_40->setupEditAttributes();
            $this->_40->EditValue = $this->_40->CurrentValue;
            $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
            if (strval($this->_40->EditValue) != "" && is_numeric($this->_40->EditValue)) {
                $this->_40->EditValue = FormatNumber($this->_40->EditValue, null);
            }

            // total_amount
            $this->total_amount->setupEditAttributes();
            $this->total_amount->EditValue = $this->total_amount->CurrentValue;
            $this->total_amount->PlaceHolder = RemoveHtml($this->total_amount->caption());
            if (strval($this->total_amount->EditValue) != "" && is_numeric($this->total_amount->EditValue)) {
                $this->total_amount->EditValue = FormatNumber($this->total_amount->EditValue, null);
            }

            // payment
            $this->payment->setupEditAttributes();
            $this->payment->EditValue = $this->payment->CurrentValue;
            $this->payment->PlaceHolder = RemoveHtml($this->payment->caption());
            if (strval($this->payment->EditValue) != "" && is_numeric($this->payment->EditValue)) {
                $this->payment->EditValue = FormatNumber($this->payment->EditValue, null);
            }

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // operator

            // datetime

            // Add refer script

            // grp
            $this->grp->HrefValue = "";

            // godown
            if (!EmptyValue($this->godown->CurrentValue)) {
                $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
                $this->godown->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
                }
            } else {
                $this->godown->HrefValue = "";
            }

            // emp_name
            if (!EmptyValue($this->emp_name->CurrentValue)) {
                $this->emp_name->HrefValue = $this->emp_name->getLinkPrefix() . $this->emp_name->CurrentValue; // Add prefix/suffix
                $this->emp_name->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->emp_name->HrefValue = FullUrl($this->emp_name->HrefValue, "href");
                }
            } else {
                $this->emp_name->HrefValue = "";
            }

            // ref
            $this->ref->HrefValue = "";

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }

            // batch_no
            $this->batch_no->HrefValue = "";

            // count
            $this->count->HrefValue = "";

            // count_received
            $this->count_received->HrefValue = "";

            // twist
            $this->twist->HrefValue = "";

            // quantity_avg_act
            $this->quantity_avg_act->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // std_rate
            $this->std_rate->HrefValue = "";

            // @
            $this->_40->HrefValue = "";

            // total_amount
            $this->total_amount->HrefValue = "";

            // payment
            $this->payment->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->godown->Visible && $this->godown->Required) {
                if (!$this->godown->IsDetailKey && EmptyValue($this->godown->FormValue)) {
                    $this->godown->addErrorMessage(str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
                }
            }
            if ($this->emp_name->Visible && $this->emp_name->Required) {
                if (!$this->emp_name->IsDetailKey && EmptyValue($this->emp_name->FormValue)) {
                    $this->emp_name->addErrorMessage(str_replace("%s", $this->emp_name->caption(), $this->emp_name->RequiredErrorMessage));
                }
            }
            if ($this->ref->Visible && $this->ref->Required) {
                if (!$this->ref->IsDetailKey && EmptyValue($this->ref->FormValue)) {
                    $this->ref->addErrorMessage(str_replace("%s", $this->ref->caption(), $this->ref->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->ref->FormValue)) {
                $this->ref->addErrorMessage($this->ref->getErrorMessage(false));
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if (!$this->rid->IsDetailKey && EmptyValue($this->rid->FormValue)) {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->rid->FormValue)) {
                $this->rid->addErrorMessage($this->rid->getErrorMessage(false));
            }
            if ($this->batch_no->Visible && $this->batch_no->Required) {
                if (!$this->batch_no->IsDetailKey && EmptyValue($this->batch_no->FormValue)) {
                    $this->batch_no->addErrorMessage(str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->batch_no->FormValue)) {
                $this->batch_no->addErrorMessage($this->batch_no->getErrorMessage(false));
            }
            if ($this->count->Visible && $this->count->Required) {
                if (!$this->count->IsDetailKey && EmptyValue($this->count->FormValue)) {
                    $this->count->addErrorMessage(str_replace("%s", $this->count->caption(), $this->count->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->count->FormValue)) {
                $this->count->addErrorMessage($this->count->getErrorMessage(false));
            }
            if ($this->count_received->Visible && $this->count_received->Required) {
                if (!$this->count_received->IsDetailKey && EmptyValue($this->count_received->FormValue)) {
                    $this->count_received->addErrorMessage(str_replace("%s", $this->count_received->caption(), $this->count_received->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->count_received->FormValue)) {
                $this->count_received->addErrorMessage($this->count_received->getErrorMessage(false));
            }
            if ($this->twist->Visible && $this->twist->Required) {
                if (!$this->twist->IsDetailKey && EmptyValue($this->twist->FormValue)) {
                    $this->twist->addErrorMessage(str_replace("%s", $this->twist->caption(), $this->twist->RequiredErrorMessage));
                }
            }
            if ($this->quantity_avg_act->Visible && $this->quantity_avg_act->Required) {
                if (!$this->quantity_avg_act->IsDetailKey && EmptyValue($this->quantity_avg_act->FormValue)) {
                    $this->quantity_avg_act->addErrorMessage(str_replace("%s", $this->quantity_avg_act->caption(), $this->quantity_avg_act->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity_avg_act->FormValue)) {
                $this->quantity_avg_act->addErrorMessage($this->quantity_avg_act->getErrorMessage(false));
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity->FormValue)) {
                $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
            }
            if ($this->status->Visible && $this->status->Required) {
                if ($this->status->FormValue == "") {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->std_rate->Visible && $this->std_rate->Required) {
                if (!$this->std_rate->IsDetailKey && EmptyValue($this->std_rate->FormValue)) {
                    $this->std_rate->addErrorMessage(str_replace("%s", $this->std_rate->caption(), $this->std_rate->RequiredErrorMessage));
                }
            }
            if ($this->_40->Visible && $this->_40->Required) {
                if (!$this->_40->IsDetailKey && EmptyValue($this->_40->FormValue)) {
                    $this->_40->addErrorMessage(str_replace("%s", $this->_40->caption(), $this->_40->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->_40->FormValue)) {
                $this->_40->addErrorMessage($this->_40->getErrorMessage(false));
            }
            if ($this->total_amount->Visible && $this->total_amount->Required) {
                if (!$this->total_amount->IsDetailKey && EmptyValue($this->total_amount->FormValue)) {
                    $this->total_amount->addErrorMessage(str_replace("%s", $this->total_amount->caption(), $this->total_amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->total_amount->FormValue)) {
                $this->total_amount->addErrorMessage($this->total_amount->getErrorMessage(false));
            }
            if ($this->payment->Visible && $this->payment->Required) {
                if (!$this->payment->IsDetailKey && EmptyValue($this->payment->FormValue)) {
                    $this->payment->addErrorMessage(str_replace("%s", $this->payment->caption(), $this->payment->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->payment->FormValue)) {
                $this->payment->addErrorMessage($this->payment->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // godown
        $this->godown->setDbValueDef($rsnew, $this->godown->CurrentValue, false);

        // emp_name
        $this->emp_name->setDbValueDef($rsnew, $this->emp_name->CurrentValue, false);

        // ref
        $this->ref->setDbValueDef($rsnew, $this->ref->CurrentValue, false);

        // rid
        $this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, false);

        // batch_no
        $this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, false);

        // count
        $this->count->setDbValueDef($rsnew, $this->count->CurrentValue, false);

        // count_received
        $this->count_received->setDbValueDef($rsnew, $this->count_received->CurrentValue, false);

        // twist
        $this->twist->setDbValueDef($rsnew, $this->twist->CurrentValue, false);

        // quantity_avg_act
        $this->quantity_avg_act->setDbValueDef($rsnew, $this->quantity_avg_act->CurrentValue, false);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, false);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, false);

        // std_rate
        $this->std_rate->setDbValueDef($rsnew, $this->std_rate->CurrentValue, false);

        // @
        $this->_40->setDbValueDef($rsnew, $this->_40->CurrentValue, false);

        // total_amount
        $this->total_amount->setDbValueDef($rsnew, $this->total_amount->CurrentValue, false);

        // payment
        $this->payment->setDbValueDef($rsnew, $this->payment->CurrentValue, false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['godown'])) { // godown
            $this->godown->setFormValue($row['godown']);
        }
        if (isset($row['emp_name'])) { // emp_name
            $this->emp_name->setFormValue($row['emp_name']);
        }
        if (isset($row['ref'])) { // ref
            $this->ref->setFormValue($row['ref']);
        }
        if (isset($row['rid'])) { // rid
            $this->rid->setFormValue($row['rid']);
        }
        if (isset($row['batch_no'])) { // batch_no
            $this->batch_no->setFormValue($row['batch_no']);
        }
        if (isset($row['count'])) { // count
            $this->count->setFormValue($row['count']);
        }
        if (isset($row['count_received'])) { // count_received
            $this->count_received->setFormValue($row['count_received']);
        }
        if (isset($row['twist'])) { // twist
            $this->twist->setFormValue($row['twist']);
        }
        if (isset($row['quantity_avg_act'])) { // quantity_avg_act
            $this->quantity_avg_act->setFormValue($row['quantity_avg_act']);
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->setFormValue($row['quantity']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
        if (isset($row['std_rate'])) { // std_rate
            $this->std_rate->setFormValue($row['std_rate']);
        }
        if (isset($row['@'])) { // @
            $this->_40->setFormValue($row['@']);
        }
        if (isset($row['total_amount'])) { // total_amount
            $this->total_amount->setFormValue($row['total_amount']);
        }
        if (isset($row['payment'])) { // payment
            $this->payment->setFormValue($row['payment']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("processtablehslist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    break;
                case "x_godown":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_twist":
                    break;
                case "x_status":
                    break;
                case "x_std_rate":
                    break;
                case "x_operator":
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    break;
                case "x_s_grp":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    		$this->lot_no->ReadOnly = TRUE;
    		$this->tmp_lot->ReadOnly = TRUE;
    		$this->std_rate->ReadOnly = TRUE;
    		$this->grp->ReadOnly = TRUE;
    		$this->s_grp->ReadOnly = TRUE;
    		$this->rid->ReadOnly = TRUE;
    		$this->quantity_avg_act->ReadOnly = TRUE;
    		$this->count->ReadOnly = TRUE;
    		$this->total_amount->ReadOnly = TRUE;
    		$this->batch_no->ReadOnly = TRUE;
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
