<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for process_table_hs
 */
class ProcessTableHs extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $grp;
    public $godown;
    public $emp_name;
    public $ref;
    public $rid;
    public $batch_no;
    public $count;
    public $count_received;
    public $twist;
    public $quantity_avg_act;
    public $quantity;
    public $status;
    public $std_rate;
    public $_40;
    public $total_amount;
    public $payment;
    public $remarks;
    public $operator;
    public $datetime;
    public $product;
    public $process;
    public $packets;
    public $packing_type;
    public $product_code_new;
    public $product_new;
    public $dated;
    public $s_grp;
    public $lot_no;
    public $tmp_lot;
    public $shortage;
    public $shortage_amount;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "process_table_hs";
        $this->TableName = 'process_table_hs';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "process_table_hs";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getDefault", fn() => 23);
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Nullable = false; // NOT NULL field
        $this->grp->Required = true; // Required field
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'process_table_hs', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->grp->OptionCount = 1;
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['grp'] = &$this->grp;

        // godown
        $this->godown = new DbField(
            $this, // Table
            'x_godown', // Variable name
            'godown', // Name
            '`godown`', // Expression
            '`godown`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`godown`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->godown->addMethod("getSelectFilter", fn() => (!empty(User_Site())) ? "`id` IN (".User_Site().")" : "id = 0");
        $this->godown->addMethod("getDefault", fn() => (isset($_COOKIE["User_Site"]))? $_COOKIE["User_Site"]:"");
        $this->godown->addMethod("getLinkPrefix", fn() => "processtablehslist?x_godown=");
        $this->godown->InputTextType = "text";
        $this->godown->Raw = true;
        $this->godown->Nullable = false; // NOT NULL field
        $this->godown->Required = true; // Required field
        $this->godown->setSelectMultiple(false); // Select one
        $this->godown->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->godown->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->godown->Lookup = new Lookup($this->godown, 'godown_table', false, 'id', ["name","code","",""], '', '', [], ["x_emp_name"], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->godown) . "',COALESCE(`code`,''))");
        $this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->godown->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['godown'] = &$this->godown;

        // emp_name
        $this->emp_name = new DbField(
            $this, // Table
            'x_emp_name', // Variable name
            'emp_name', // Name
            '`emp_name`', // Expression
            '`emp_name`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`emp_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->emp_name->addMethod("getSelectFilter", fn() => "`Balance` > 0");
        $this->emp_name->addMethod("getLinkPrefix", fn() => "processtablehslist?x_emp_name=");
        $this->emp_name->InputTextType = "text";
        $this->emp_name->Nullable = false; // NOT NULL field
        $this->emp_name->Required = true; // Required field
        $this->emp_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['emp_name'] = &$this->emp_name;

        // ref
        $this->ref = new DbField(
            $this, // Table
            'x_ref', // Variable name
            'ref', // Name
            '`ref`', // Expression
            '`ref`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ref->addMethod("getSelectFilter", fn() => "`Balance`> 0");
        $this->ref->InputTextType = "text";
        $this->ref->Raw = true;
        $this->ref->Nullable = false; // NOT NULL field
        $this->ref->Required = true; // Required field
        $this->ref->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ref'] = &$this->ref;

        // rid
        $this->rid = new DbField(
            $this, // Table
            'x_rid', // Variable name
            'rid', // Name
            '`rid`', // Expression
            '`rid`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rid->addMethod("getLinkPrefix", fn() => "processtablehslist?x_rid=");
        $this->rid->InputTextType = "text";
        $this->rid->Raw = true;
        $this->rid->Nullable = false; // NOT NULL field
        $this->rid->Required = true; // Required field
        $this->rid->Sortable = false; // Allow sort
        $this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->rid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['rid'] = &$this->rid;

        // batch_no
        $this->batch_no = new DbField(
            $this, // Table
            'x_batch_no', // Variable name
            'batch_no', // Name
            '`batch_no`', // Expression
            '`batch_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`batch_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->batch_no->InputTextType = "text";
        $this->batch_no->Raw = true;
        $this->batch_no->Nullable = false; // NOT NULL field
        $this->batch_no->Required = true; // Required field
        $this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->batch_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['batch_no'] = &$this->batch_no;

        // count
        $this->count = new DbField(
            $this, // Table
            'x_count', // Variable name
            'count', // Name
            '`count`', // Expression
            '`count`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`count`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->count->InputTextType = "text";
        $this->count->Raw = true;
        $this->count->Nullable = false; // NOT NULL field
        $this->count->Required = true; // Required field
        $this->count->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->count->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['count'] = &$this->count;

        // count_received
        $this->count_received = new DbField(
            $this, // Table
            'x_count_received', // Variable name
            'count_received', // Name
            '`count_received`', // Expression
            '`count_received`', // Basic search expression
            200, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`count_received`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->count_received->addMethod("getSelectFilter", fn() => "`grp` = 2");
        $this->count_received->InputTextType = "text";
        $this->count_received->Nullable = false; // NOT NULL field
        $this->count_received->Required = true; // Required field
        $this->count_received->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->count_received->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['count_received'] = &$this->count_received;

        // twist
        $this->twist = new DbField(
            $this, // Table
            'x_twist', // Variable name
            'twist', // Name
            '`twist`', // Expression
            '`twist`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`twist`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->twist->InputTextType = "text";
        $this->twist->Raw = true;
        $this->twist->Nullable = false; // NOT NULL field
        $this->twist->Required = true; // Required field
        $this->twist->setSelectMultiple(false); // Select one
        $this->twist->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->twist->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->twist->Lookup = new Lookup($this->twist, 'process_table_hs', false, '', ["","","",""], '', '', [], [], [], [], ["@","@"], ["x_std_rate","x__40"], false, '', '', "");
        $this->twist->OptionCount = 3;
        $this->twist->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->twist->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['twist'] = &$this->twist;

        // quantity_avg_act
        $this->quantity_avg_act = new DbField(
            $this, // Table
            'x_quantity_avg_act', // Variable name
            'quantity_avg_act', // Name
            '`quantity_avg_act`', // Expression
            '`quantity_avg_act`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity_avg_act`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity_avg_act->InputTextType = "text";
        $this->quantity_avg_act->Raw = true;
        $this->quantity_avg_act->Nullable = false; // NOT NULL field
        $this->quantity_avg_act->Required = true; // Required field
        $this->quantity_avg_act->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->quantity_avg_act->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['quantity_avg_act'] = &$this->quantity_avg_act;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->Nullable = false; // NOT NULL field
        $this->quantity->Required = true; // Required field
        $this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['quantity'] = &$this->quantity;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->Nullable = false; // NOT NULL field
        $this->status->Required = true; // Required field
        $this->status->Lookup = new Lookup($this->status, 'process_table_hs', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 2;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status'] = &$this->status;

        // std_rate
        $this->std_rate = new DbField(
            $this, // Table
            'x_std_rate', // Variable name
            'std_rate', // Name
            '`std_rate`', // Expression
            '`std_rate`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`std_rate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->std_rate->addMethod("getDefault", fn() => 0.00);
        $this->std_rate->InputTextType = "text";
        $this->std_rate->Raw = true;
        $this->std_rate->setSelectMultiple(false); // Select one
        $this->std_rate->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->std_rate->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->std_rate->Lookup = new Lookup($this->std_rate, 'payment_plan_hs', false, '@', ["@","","",""], '', '', ["x_rid"], [], ["rid"], ["x_rid"], [], [], true, '`@` ASC', '', "`@`");
        $this->std_rate->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->std_rate->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['std_rate'] = &$this->std_rate;

        // @
        $this->_40 = new DbField(
            $this, // Table
            'x__40', // Variable name
            '@', // Name
            '`@`', // Expression
            '`@`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`@`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_40->InputTextType = "text";
        $this->_40->Raw = true;
        $this->_40->Nullable = false; // NOT NULL field
        $this->_40->Required = true; // Required field
        $this->_40->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_40->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['@'] = &$this->_40;

        // total_amount
        $this->total_amount = new DbField(
            $this, // Table
            'x_total_amount', // Variable name
            'total_amount', // Name
            '`total_amount`', // Expression
            '`total_amount`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`total_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->total_amount->InputTextType = "text";
        $this->total_amount->Raw = true;
        $this->total_amount->Nullable = false; // NOT NULL field
        $this->total_amount->Required = true; // Required field
        $this->total_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->total_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['total_amount'] = &$this->total_amount;

        // payment
        $this->payment = new DbField(
            $this, // Table
            'x_payment', // Variable name
            'payment', // Name
            '`payment`', // Expression
            '`payment`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->payment->addMethod("getDefault", fn() => 0.00);
        $this->payment->InputTextType = "text";
        $this->payment->Raw = true;
        $this->payment->Nullable = false; // NOT NULL field
        $this->payment->Required = true; // Required field
        $this->payment->Sortable = false; // Allow sort
        $this->payment->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->payment->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['payment'] = &$this->payment;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            40, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product->addMethod("getLinkPrefix", fn() => "processtablehslist?x_product=");
        $this->product->InputTextType = "text";
        $this->product->Raw = true;
        $this->product->Nullable = false; // NOT NULL field
        $this->product->Required = true; // Required field
        $this->product->Sortable = false; // Allow sort
        $this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['product'] = &$this->product;

        // process
        $this->process = new DbField(
            $this, // Table
            'x_process', // Variable name
            'process', // Name
            '`process`', // Expression
            '`process`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process->addMethod("getSelectFilter", fn() => "`id` = 23");
        $this->process->addMethod("getLinkPrefix", fn() => "processtablehslist?x_process=");
        $this->process->InputTextType = "text";
        $this->process->Raw = true;
        $this->process->Nullable = false; // NOT NULL field
        $this->process->Required = true; // Required field
        $this->process->Sortable = false; // Allow sort
        $this->process->setSelectMultiple(false); // Select one
        $this->process->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->process->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->process->Lookup = new Lookup($this->process, 'process', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['process'] = &$this->process;

        // packets
        $this->packets = new DbField(
            $this, // Table
            'x_packets', // Variable name
            'packets', // Name
            '`packets`', // Expression
            '`packets`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packets`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packets->InputTextType = "text";
        $this->packets->Raw = true;
        $this->packets->Nullable = false; // NOT NULL field
        $this->packets->Required = true; // Required field
        $this->packets->Sortable = false; // Allow sort
        $this->packets->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packets->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['packets'] = &$this->packets;

        // packing_type
        $this->packing_type = new DbField(
            $this, // Table
            'x_packing_type', // Variable name
            'packing_type', // Name
            '`packing_type`', // Expression
            '`packing_type`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->packing_type->addMethod("getLinkPrefix", fn() => "processtablehslist?x_packing_type=");
        $this->packing_type->InputTextType = "text";
        $this->packing_type->Raw = true;
        $this->packing_type->Nullable = false; // NOT NULL field
        $this->packing_type->Required = true; // Required field
        $this->packing_type->Sortable = false; // Allow sort
        $this->packing_type->setSelectMultiple(false); // Select one
        $this->packing_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->packing_type->Lookup = new Lookup($this->packing_type, 'packing_type', false, 'id', ["packing","code","",""], '', '', [], [], [], [], [], [], true, '`packing` ASC', '', "CONCAT(COALESCE(`packing`, ''),'" . ValueSeparator(1, $this->packing_type) . "',COALESCE(`code`,''))");
        $this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packing_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['packing_type'] = &$this->packing_type;

        // product_code_new
        $this->product_code_new = new DbField(
            $this, // Table
            'x_product_code_new', // Variable name
            'product_code_new', // Name
            '`product_code_new`', // Expression
            '`product_code_new`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_code_new`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product_code_new->InputTextType = "text";
        $this->product_code_new->Raw = true;
        $this->product_code_new->Nullable = false; // NOT NULL field
        $this->product_code_new->Required = true; // Required field
        $this->product_code_new->Sortable = false; // Allow sort
        $this->product_code_new->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product_code_new->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['product_code_new'] = &$this->product_code_new;

        // product_new
        $this->product_new = new DbField(
            $this, // Table
            'x_product_new', // Variable name
            'product_new', // Name
            '`product_new`', // Expression
            '`product_new`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_new`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product_new->InputTextType = "text";
        $this->product_new->Raw = true;
        $this->product_new->Nullable = false; // NOT NULL field
        $this->product_new->Required = true; // Required field
        $this->product_new->Sortable = false; // Allow sort
        $this->product_new->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product_new->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['product_new'] = &$this->product_new;

        // dated
        $this->dated = new DbField(
            $this, // Table
            'x_dated', // Variable name
            'dated', // Name
            '`dated`', // Expression
            CastDateFieldForLike("`dated`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`dated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->dated->addMethod("getAutoUpdateValue", fn() => CurrentDate());
        $this->dated->InputTextType = "text";
        $this->dated->Raw = true;
        $this->dated->Nullable = false; // NOT NULL field
        $this->dated->Sortable = false; // Allow sort
        $this->dated->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->dated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['dated'] = &$this->dated;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->s_grp->addMethod("getDefault", fn() => 23);
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->Nullable = false; // NOT NULL field
        $this->s_grp->Required = true; // Required field
        $this->s_grp->Sortable = false; // Allow sort
        $this->s_grp->setSelectMultiple(false); // Select one
        $this->s_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->s_grp->Lookup = new Lookup($this->s_grp, 'process_table_hs', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->s_grp->OptionCount = 1;
        $this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->s_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // lot_no
        $this->lot_no = new DbField(
            $this, // Table
            'x_lot_no', // Variable name
            'lot_no', // Name
            '`lot_no`', // Expression
            '`lot_no`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lot_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lot_no->InputTextType = "text";
        $this->lot_no->Raw = true;
        $this->lot_no->Nullable = false; // NOT NULL field
        $this->lot_no->Required = true; // Required field
        $this->lot_no->Sortable = false; // Allow sort
        $this->lot_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->lot_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['lot_no'] = &$this->lot_no;

        // tmp_lot
        $this->tmp_lot = new DbField(
            $this, // Table
            'x_tmp_lot', // Variable name
            'tmp_lot', // Name
            '`tmp_lot`', // Expression
            '`tmp_lot`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`tmp_lot`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tmp_lot->InputTextType = "text";
        $this->tmp_lot->Raw = true;
        $this->tmp_lot->Nullable = false; // NOT NULL field
        $this->tmp_lot->Required = true; // Required field
        $this->tmp_lot->Sortable = false; // Allow sort
        $this->tmp_lot->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->tmp_lot->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['tmp_lot'] = &$this->tmp_lot;

        // shortage
        $this->shortage = new DbField(
            $this, // Table
            'x_shortage', // Variable name
            'shortage', // Name
            '`shortage`', // Expression
            '`shortage`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shortage`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->shortage->InputTextType = "text";
        $this->shortage->Raw = true;
        $this->shortage->Sortable = false; // Allow sort
        $this->shortage->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->shortage->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['shortage'] = &$this->shortage;

        // shortage_amount
        $this->shortage_amount = new DbField(
            $this, // Table
            'x_shortage_amount', // Variable name
            'shortage_amount', // Name
            '`shortage_amount`', // Expression
            '`shortage_amount`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shortage_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->shortage_amount->InputTextType = "text";
        $this->shortage_amount->Raw = true;
        $this->shortage_amount->Sortable = false; // Allow sort
        $this->shortage_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->shortage_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['shortage_amount'] = &$this->shortage_amount;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "process_table_hs";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->grp->DbValue = $row['grp'];
        $this->godown->DbValue = $row['godown'];
        $this->emp_name->DbValue = $row['emp_name'];
        $this->ref->DbValue = $row['ref'];
        $this->rid->DbValue = $row['rid'];
        $this->batch_no->DbValue = $row['batch_no'];
        $this->count->DbValue = $row['count'];
        $this->count_received->DbValue = $row['count_received'];
        $this->twist->DbValue = $row['twist'];
        $this->quantity_avg_act->DbValue = $row['quantity_avg_act'];
        $this->quantity->DbValue = $row['quantity'];
        $this->status->DbValue = $row['status'];
        $this->std_rate->DbValue = $row['std_rate'];
        $this->_40->DbValue = $row['@'];
        $this->total_amount->DbValue = $row['total_amount'];
        $this->payment->DbValue = $row['payment'];
        $this->remarks->DbValue = $row['remarks'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->product->DbValue = $row['product'];
        $this->process->DbValue = $row['process'];
        $this->packets->DbValue = $row['packets'];
        $this->packing_type->DbValue = $row['packing_type'];
        $this->product_code_new->DbValue = $row['product_code_new'];
        $this->product_new->DbValue = $row['product_new'];
        $this->dated->DbValue = $row['dated'];
        $this->s_grp->DbValue = $row['s_grp'];
        $this->lot_no->DbValue = $row['lot_no'];
        $this->tmp_lot->DbValue = $row['tmp_lot'];
        $this->shortage->DbValue = $row['shortage'];
        $this->shortage_amount->DbValue = $row['shortage_amount'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("processtablehslist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "processtablehsview" => $Language->phrase("View"),
            "processtablehsedit" => $Language->phrase("Edit"),
            "processtablehsadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "processtablehslist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "ProcessTableHsView",
            Config("API_ADD_ACTION") => "ProcessTableHsAdd",
            Config("API_EDIT_ACTION") => "ProcessTableHsEdit",
            Config("API_DELETE_ACTION") => "ProcessTableHsDelete",
            Config("API_LIST_ACTION") => "ProcessTableHsList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "processtablehslist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("processtablehsview", $parm);
        } else {
            $url = $this->keyUrl("processtablehsview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "processtablehsadd?" . $parm;
        } else {
            $url = "processtablehsadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("processtablehsedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("processtablehslist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("processtablehsadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("processtablehslist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("processtablehsdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->godown->setDbValue($row['godown']);
        $this->emp_name->setDbValue($row['emp_name']);
        $this->ref->setDbValue($row['ref']);
        $this->rid->setDbValue($row['rid']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->count->setDbValue($row['count']);
        $this->count_received->setDbValue($row['count_received']);
        $this->twist->setDbValue($row['twist']);
        $this->quantity_avg_act->setDbValue($row['quantity_avg_act']);
        $this->quantity->setDbValue($row['quantity']);
        $this->status->setDbValue($row['status']);
        $this->std_rate->setDbValue($row['std_rate']);
        $this->_40->setDbValue($row['@']);
        $this->total_amount->setDbValue($row['total_amount']);
        $this->payment->setDbValue($row['payment']);
        $this->remarks->setDbValue($row['remarks']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->product->setDbValue($row['product']);
        $this->process->setDbValue($row['process']);
        $this->packets->setDbValue($row['packets']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->product_code_new->setDbValue($row['product_code_new']);
        $this->product_new->setDbValue($row['product_new']);
        $this->dated->setDbValue($row['dated']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->tmp_lot->setDbValue($row['tmp_lot']);
        $this->shortage->setDbValue($row['shortage']);
        $this->shortage_amount->setDbValue($row['shortage_amount']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "ProcessTableHsList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // grp

        // godown

        // emp_name

        // ref

        // rid

        // batch_no

        // count

        // count_received

        // twist

        // quantity_avg_act

        // quantity

        // status

        // std_rate

        // @

        // total_amount

        // payment

        // remarks

        // operator

        // datetime

        // product
        $this->product->CellCssStyle = "white-space: nowrap;";

        // process
        $this->process->CellCssStyle = "white-space: nowrap;";

        // packets
        $this->packets->CellCssStyle = "white-space: nowrap;";

        // packing_type
        $this->packing_type->CellCssStyle = "white-space: nowrap;";

        // product_code_new
        $this->product_code_new->CellCssStyle = "white-space: nowrap;";

        // product_new
        $this->product_new->CellCssStyle = "white-space: nowrap;";

        // dated
        $this->dated->CellCssStyle = "white-space: nowrap;";

        // s_grp
        $this->s_grp->CellCssStyle = "white-space: nowrap;";

        // lot_no
        $this->lot_no->CellCssStyle = "white-space: nowrap;";

        // tmp_lot
        $this->tmp_lot->CellCssStyle = "white-space: nowrap;";

        // shortage
        $this->shortage->CellCssStyle = "white-space: nowrap;";

        // shortage_amount
        $this->shortage_amount->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // grp
        if (strval($this->grp->CurrentValue) != "") {
            $this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
        } else {
            $this->grp->ViewValue = null;
        }

        // godown
        $curVal = strval($this->godown->CurrentValue);
        if ($curVal != "") {
            $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
            if ($this->godown->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                    $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                } else {
                    $this->godown->ViewValue = FormatNumber($this->godown->CurrentValue, $this->godown->formatPattern());
                }
            }
        } else {
            $this->godown->ViewValue = null;
        }

        // emp_name
        $this->emp_name->ViewValue = $this->emp_name->CurrentValue;

        // ref
        $this->ref->ViewValue = $this->ref->CurrentValue;

        // rid
        $this->rid->ViewValue = $this->rid->CurrentValue;
        $this->rid->ViewValue = FormatNumber($this->rid->ViewValue, $this->rid->formatPattern());

        // batch_no
        $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
        $this->batch_no->ViewValue = FormatNumber($this->batch_no->ViewValue, $this->batch_no->formatPattern());

        // count
        $this->count->ViewValue = $this->count->CurrentValue;
        $this->count->ViewValue = FormatNumber($this->count->ViewValue, $this->count->formatPattern());

        // count_received
        $this->count_received->ViewValue = $this->count_received->CurrentValue;

        // twist
        if (strval($this->twist->CurrentValue) != "") {
            $this->twist->ViewValue = $this->twist->optionCaption($this->twist->CurrentValue);
        } else {
            $this->twist->ViewValue = null;
        }

        // quantity_avg_act
        $this->quantity_avg_act->ViewValue = $this->quantity_avg_act->CurrentValue;
        $this->quantity_avg_act->ViewValue = FormatNumber($this->quantity_avg_act->ViewValue, $this->quantity_avg_act->formatPattern());

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // std_rate
        $curVal = strval($this->std_rate->CurrentValue);
        if ($curVal != "") {
            $this->std_rate->ViewValue = $this->std_rate->lookupCacheOption($curVal);
            if ($this->std_rate->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->std_rate->Lookup->getTable()->Fields["@"]->searchExpression(), "=", $curVal, $this->std_rate->Lookup->getTable()->Fields["@"]->searchDataType(), "");
                $sqlWrk = $this->std_rate->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->std_rate->Lookup->renderViewRow($rswrk[0]);
                    $this->std_rate->ViewValue = $this->std_rate->displayValue($arwrk);
                } else {
                    $this->std_rate->ViewValue = FormatNumber($this->std_rate->CurrentValue, $this->std_rate->formatPattern());
                }
            }
        } else {
            $this->std_rate->ViewValue = null;
        }

        // @
        $this->_40->ViewValue = $this->_40->CurrentValue;
        $this->_40->ViewValue = FormatNumber($this->_40->ViewValue, $this->_40->formatPattern());

        // total_amount
        $this->total_amount->ViewValue = $this->total_amount->CurrentValue;
        $this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, $this->total_amount->formatPattern());

        // payment
        $this->payment->ViewValue = $this->payment->CurrentValue;
        $this->payment->ViewValue = FormatNumber($this->payment->ViewValue, $this->payment->formatPattern());

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // product
        $this->product->ViewValue = $this->product->CurrentValue;
        $this->product->ViewValue = FormatNumber($this->product->ViewValue, $this->product->formatPattern());

        // process
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                    $this->process->ViewValue = $this->process->displayValue($arwrk);
                } else {
                    $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                }
            }
        } else {
            $this->process->ViewValue = null;
        }

        // packets
        $this->packets->ViewValue = $this->packets->CurrentValue;
        $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

        // packing_type
        $curVal = strval($this->packing_type->CurrentValue);
        if ($curVal != "") {
            $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            if ($this->packing_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                    $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                } else {
                    $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                }
            }
        } else {
            $this->packing_type->ViewValue = null;
        }

        // product_code_new
        $this->product_code_new->ViewValue = $this->product_code_new->CurrentValue;
        $this->product_code_new->ViewValue = FormatNumber($this->product_code_new->ViewValue, $this->product_code_new->formatPattern());

        // product_new
        $this->product_new->ViewValue = $this->product_new->CurrentValue;
        $this->product_new->ViewValue = FormatNumber($this->product_new->ViewValue, $this->product_new->formatPattern());

        // dated
        $this->dated->ViewValue = $this->dated->CurrentValue;
        $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

        // s_grp
        if (strval($this->s_grp->CurrentValue) != "") {
            $this->s_grp->ViewValue = $this->s_grp->optionCaption($this->s_grp->CurrentValue);
        } else {
            $this->s_grp->ViewValue = null;
        }

        // lot_no
        $this->lot_no->ViewValue = $this->lot_no->CurrentValue;
        $this->lot_no->ViewValue = FormatNumber($this->lot_no->ViewValue, $this->lot_no->formatPattern());

        // tmp_lot
        $this->tmp_lot->ViewValue = $this->tmp_lot->CurrentValue;
        $this->tmp_lot->ViewValue = FormatNumber($this->tmp_lot->ViewValue, $this->tmp_lot->formatPattern());

        // shortage
        $this->shortage->ViewValue = $this->shortage->CurrentValue;
        $this->shortage->ViewValue = FormatNumber($this->shortage->ViewValue, $this->shortage->formatPattern());

        // shortage_amount
        $this->shortage_amount->ViewValue = $this->shortage_amount->CurrentValue;
        $this->shortage_amount->ViewValue = FormatNumber($this->shortage_amount->ViewValue, $this->shortage_amount->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // godown
        if (!EmptyValue($this->godown->CurrentValue)) {
            $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
            $this->godown->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
            }
        } else {
            $this->godown->HrefValue = "";
        }
        $this->godown->TooltipValue = "";

        // emp_name
        if (!EmptyValue($this->emp_name->CurrentValue)) {
            $this->emp_name->HrefValue = $this->emp_name->getLinkPrefix() . $this->emp_name->CurrentValue; // Add prefix/suffix
            $this->emp_name->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->emp_name->HrefValue = FullUrl($this->emp_name->HrefValue, "href");
            }
        } else {
            $this->emp_name->HrefValue = "";
        }
        $this->emp_name->TooltipValue = "";

        // ref
        $this->ref->HrefValue = "";
        $this->ref->TooltipValue = "";

        // rid
        if (!EmptyValue($this->rid->CurrentValue)) {
            $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
            $this->rid->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
            }
        } else {
            $this->rid->HrefValue = "";
        }
        $this->rid->TooltipValue = "";

        // batch_no
        $this->batch_no->HrefValue = "";
        $this->batch_no->TooltipValue = "";

        // count
        $this->count->HrefValue = "";
        $this->count->TooltipValue = "";

        // count_received
        $this->count_received->HrefValue = "";
        $this->count_received->TooltipValue = "";

        // twist
        $this->twist->HrefValue = "";
        $this->twist->TooltipValue = "";

        // quantity_avg_act
        $this->quantity_avg_act->HrefValue = "";
        $this->quantity_avg_act->TooltipValue = "";

        // quantity
        $this->quantity->HrefValue = "";
        $this->quantity->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // std_rate
        $this->std_rate->HrefValue = "";
        $this->std_rate->TooltipValue = "";

        // @
        $this->_40->HrefValue = "";
        $this->_40->TooltipValue = "";

        // total_amount
        $this->total_amount->HrefValue = "";
        $this->total_amount->TooltipValue = "";

        // payment
        $this->payment->HrefValue = "";
        $this->payment->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // product
        if (!EmptyValue($this->product->CurrentValue)) {
            $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
            $this->product->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
            }
        } else {
            $this->product->HrefValue = "";
        }
        $this->product->TooltipValue = "";

        // process
        if (!EmptyValue($this->process->CurrentValue)) {
            $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
            $this->process->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
            }
        } else {
            $this->process->HrefValue = "";
        }
        $this->process->TooltipValue = "";

        // packets
        $this->packets->HrefValue = "";
        $this->packets->TooltipValue = "";

        // packing_type
        if (!EmptyValue($this->packing_type->CurrentValue)) {
            $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
            $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
            }
        } else {
            $this->packing_type->HrefValue = "";
        }
        $this->packing_type->TooltipValue = "";

        // product_code_new
        $this->product_code_new->HrefValue = "";
        $this->product_code_new->TooltipValue = "";

        // product_new
        $this->product_new->HrefValue = "";
        $this->product_new->TooltipValue = "";

        // dated
        $this->dated->HrefValue = "";
        $this->dated->TooltipValue = "";

        // s_grp
        $this->s_grp->HrefValue = "";
        $this->s_grp->TooltipValue = "";

        // lot_no
        $this->lot_no->HrefValue = "";
        $this->lot_no->TooltipValue = "";

        // tmp_lot
        $this->tmp_lot->HrefValue = "";
        $this->tmp_lot->TooltipValue = "";

        // shortage
        $this->shortage->HrefValue = "";
        $this->shortage->TooltipValue = "";

        // shortage_amount
        $this->shortage_amount->HrefValue = "";
        $this->shortage_amount->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->EditValue = $this->grp->options(true);
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

        // godown
        $this->godown->setupEditAttributes();
        $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

        // emp_name
        $this->emp_name->setupEditAttributes();
        if (!$this->emp_name->Raw) {
            $this->emp_name->CurrentValue = HtmlDecode($this->emp_name->CurrentValue);
        }
        $this->emp_name->EditValue = $this->emp_name->CurrentValue;
        $this->emp_name->PlaceHolder = RemoveHtml($this->emp_name->caption());

        // ref
        $this->ref->setupEditAttributes();
        $this->ref->EditValue = $this->ref->CurrentValue;

        // rid
        $this->rid->setupEditAttributes();
        $this->rid->EditValue = $this->rid->CurrentValue;
        $this->rid->EditValue = FormatNumber($this->rid->EditValue, $this->rid->formatPattern());

        // batch_no
        $this->batch_no->setupEditAttributes();
        $this->batch_no->EditValue = $this->batch_no->CurrentValue;
        $this->batch_no->EditValue = FormatNumber($this->batch_no->EditValue, $this->batch_no->formatPattern());

        // count
        $this->count->setupEditAttributes();
        $this->count->EditValue = $this->count->CurrentValue;
        $this->count->PlaceHolder = RemoveHtml($this->count->caption());
        if (strval($this->count->EditValue) != "" && is_numeric($this->count->EditValue)) {
            $this->count->EditValue = FormatNumber($this->count->EditValue, null);
        }

        // count_received
        $this->count_received->setupEditAttributes();
        if (!$this->count_received->Raw) {
            $this->count_received->CurrentValue = HtmlDecode($this->count_received->CurrentValue);
        }
        $this->count_received->EditValue = $this->count_received->CurrentValue;
        $this->count_received->PlaceHolder = RemoveHtml($this->count_received->caption());

        // twist
        $this->twist->setupEditAttributes();
        $this->twist->EditValue = $this->twist->options(true);
        $this->twist->PlaceHolder = RemoveHtml($this->twist->caption());

        // quantity_avg_act
        $this->quantity_avg_act->setupEditAttributes();
        $this->quantity_avg_act->EditValue = $this->quantity_avg_act->CurrentValue;
        $this->quantity_avg_act->PlaceHolder = RemoveHtml($this->quantity_avg_act->caption());
        if (strval($this->quantity_avg_act->EditValue) != "" && is_numeric($this->quantity_avg_act->EditValue)) {
            $this->quantity_avg_act->EditValue = FormatNumber($this->quantity_avg_act->EditValue, null);
        }

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
        if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
        }

        // status
        $this->status->EditValue = $this->status->options(false);
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // std_rate
        $this->std_rate->setupEditAttributes();
        $this->std_rate->PlaceHolder = RemoveHtml($this->std_rate->caption());

        // @
        $this->_40->setupEditAttributes();
        $this->_40->EditValue = $this->_40->CurrentValue;
        $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
        if (strval($this->_40->EditValue) != "" && is_numeric($this->_40->EditValue)) {
            $this->_40->EditValue = FormatNumber($this->_40->EditValue, null);
        }

        // total_amount
        $this->total_amount->setupEditAttributes();
        $this->total_amount->EditValue = $this->total_amount->CurrentValue;
        $this->total_amount->PlaceHolder = RemoveHtml($this->total_amount->caption());
        if (strval($this->total_amount->EditValue) != "" && is_numeric($this->total_amount->EditValue)) {
            $this->total_amount->EditValue = FormatNumber($this->total_amount->EditValue, null);
        }

        // payment
        $this->payment->setupEditAttributes();
        $this->payment->EditValue = $this->payment->CurrentValue;
        $this->payment->EditValue = FormatNumber($this->payment->EditValue, $this->payment->formatPattern());

        // remarks
        $this->remarks->setupEditAttributes();
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // operator

        // datetime

        // product
        $this->product->setupEditAttributes();
        $this->product->EditValue = $this->product->CurrentValue;
        $this->product->PlaceHolder = RemoveHtml($this->product->caption());
        if (strval($this->product->EditValue) != "" && is_numeric($this->product->EditValue)) {
            $this->product->EditValue = FormatNumber($this->product->EditValue, null);
        }

        // process
        $this->process->setupEditAttributes();
        $this->process->PlaceHolder = RemoveHtml($this->process->caption());

        // packets
        $this->packets->setupEditAttributes();
        $this->packets->EditValue = $this->packets->CurrentValue;
        $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
        if (strval($this->packets->EditValue) != "" && is_numeric($this->packets->EditValue)) {
            $this->packets->EditValue = FormatNumber($this->packets->EditValue, null);
        }

        // packing_type
        $this->packing_type->setupEditAttributes();
        $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

        // product_code_new
        $this->product_code_new->setupEditAttributes();
        $this->product_code_new->EditValue = $this->product_code_new->CurrentValue;
        $this->product_code_new->PlaceHolder = RemoveHtml($this->product_code_new->caption());
        if (strval($this->product_code_new->EditValue) != "" && is_numeric($this->product_code_new->EditValue)) {
            $this->product_code_new->EditValue = FormatNumber($this->product_code_new->EditValue, null);
        }

        // product_new
        $this->product_new->setupEditAttributes();
        $this->product_new->EditValue = $this->product_new->CurrentValue;
        $this->product_new->PlaceHolder = RemoveHtml($this->product_new->caption());
        if (strval($this->product_new->EditValue) != "" && is_numeric($this->product_new->EditValue)) {
            $this->product_new->EditValue = FormatNumber($this->product_new->EditValue, null);
        }

        // dated

        // s_grp
        $this->s_grp->setupEditAttributes();
        $this->s_grp->EditValue = $this->s_grp->options(true);
        $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

        // lot_no
        $this->lot_no->setupEditAttributes();
        $this->lot_no->EditValue = $this->lot_no->CurrentValue;
        $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());
        if (strval($this->lot_no->EditValue) != "" && is_numeric($this->lot_no->EditValue)) {
            $this->lot_no->EditValue = FormatNumber($this->lot_no->EditValue, null);
        }

        // tmp_lot
        $this->tmp_lot->setupEditAttributes();
        $this->tmp_lot->EditValue = $this->tmp_lot->CurrentValue;
        $this->tmp_lot->PlaceHolder = RemoveHtml($this->tmp_lot->caption());
        if (strval($this->tmp_lot->EditValue) != "" && is_numeric($this->tmp_lot->EditValue)) {
            $this->tmp_lot->EditValue = FormatNumber($this->tmp_lot->EditValue, null);
        }

        // shortage
        $this->shortage->setupEditAttributes();
        $this->shortage->EditValue = $this->shortage->CurrentValue;
        $this->shortage->PlaceHolder = RemoveHtml($this->shortage->caption());
        if (strval($this->shortage->EditValue) != "" && is_numeric($this->shortage->EditValue)) {
            $this->shortage->EditValue = FormatNumber($this->shortage->EditValue, null);
        }

        // shortage_amount
        $this->shortage_amount->setupEditAttributes();
        $this->shortage_amount->EditValue = $this->shortage_amount->CurrentValue;
        $this->shortage_amount->PlaceHolder = RemoveHtml($this->shortage_amount->caption());
        if (strval($this->shortage_amount->EditValue) != "" && is_numeric($this->shortage_amount->EditValue)) {
            $this->shortage_amount->EditValue = FormatNumber($this->shortage_amount->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->godown);
                    $doc->exportCaption($this->emp_name);
                    $doc->exportCaption($this->ref);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->count);
                    $doc->exportCaption($this->count_received);
                    $doc->exportCaption($this->twist);
                    $doc->exportCaption($this->quantity_avg_act);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->std_rate);
                    $doc->exportCaption($this->_40);
                    $doc->exportCaption($this->total_amount);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->godown);
                    $doc->exportCaption($this->emp_name);
                    $doc->exportCaption($this->ref);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->count);
                    $doc->exportCaption($this->count_received);
                    $doc->exportCaption($this->twist);
                    $doc->exportCaption($this->quantity_avg_act);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->std_rate);
                    $doc->exportCaption($this->_40);
                    $doc->exportCaption($this->total_amount);
                    $doc->exportCaption($this->payment);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->godown);
                        $doc->exportField($this->emp_name);
                        $doc->exportField($this->ref);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->count);
                        $doc->exportField($this->count_received);
                        $doc->exportField($this->twist);
                        $doc->exportField($this->quantity_avg_act);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->status);
                        $doc->exportField($this->std_rate);
                        $doc->exportField($this->_40);
                        $doc->exportField($this->total_amount);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->godown);
                        $doc->exportField($this->emp_name);
                        $doc->exportField($this->ref);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->count);
                        $doc->exportField($this->count_received);
                        $doc->exportField($this->twist);
                        $doc->exportField($this->quantity_avg_act);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->status);
                        $doc->exportField($this->std_rate);
                        $doc->exportField($this->_40);
                        $doc->exportField($this->total_amount);
                        $doc->exportField($this->payment);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
