<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for process_action_single_old
 */
class ProcessActionSingleOld extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $location;
    public $employee_1;
    public $employee_2;
    public $employee_3;
    public $employee_id;
    public $process;
    public $confirm_process;
    public $process_other;
    public $code;
    public $size_actual;
    public $weight_actual;
    public $valuation;
    public $deduction;
    public $upload;
    public $roll_no;
    public $qty;
    public $payment;
    public $remark;
    public $operator;
    public $datetime;
    public $tmp_id;
    public $uid;
    public $buyer_id;
    public $design_id;
    public $size_cm;
    public $sqm;
    public $jc_no;
    public $loom_id;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "process_action_single_old";
        $this->TableName = 'process_action_single_old';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "process_action_single_old";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // location
        $this->location = new DbField(
            $this, // Table
            'x_location', // Variable name
            'location', // Name
            '`location`', // Expression
            '`location`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`location`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->location->addMethod("getSelectFilter", fn() => (User_Site()  == 0)? "`id` > 0" : "`id` > 0 and `id` IN (" . User_Site() . ")");
        $this->location->addMethod("getDefault", fn() => ((isset($_COOKIE["Location"]))? $_COOKIE["Location"]:''));
        $this->location->InputTextType = "text";
        $this->location->Raw = true;
        $this->location->Nullable = false; // NOT NULL field
        $this->location->Required = true; // Required field
        $this->location->setSelectMultiple(false); // Select one
        $this->location->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->location->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->location->Lookup = new Lookup($this->location, 'godown_table', true, 'id', ["name","code","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->location) . "',COALESCE(`code`,''))");
        $this->location->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->location->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['location'] = &$this->location;

        // employee_1
        $this->employee_1 = new DbField(
            $this, // Table
            'x_employee_1', // Variable name
            'employee_1', // Name
            '`employee_1`', // Expression
            '`employee_1`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`employee_1`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->employee_1->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "");
        $this->employee_1->addMethod("getDefault", fn() => ((isset($_COOKIE["PA_LID1"]))? $_COOKIE["PA_LID1"]:''));
        $this->employee_1->addMethod("getLinkPrefix", fn() => "processactionlist?x_emp_name=");
        $this->employee_1->InputTextType = "text";
        $this->employee_1->Raw = true;
        $this->employee_1->Required = true; // Required field
        $this->employee_1->Sortable = false; // Allow sort
        $this->employee_1->setSelectMultiple(false); // Select one
        $this->employee_1->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->employee_1->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->employee_1->Lookup = new Lookup($this->employee_1, 'production_employee', true, 'id', ["id","user_name","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->employee_1) . "',COALESCE(`user_name`,''))");
        $this->employee_1->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['employee_1'] = &$this->employee_1;

        // employee_2
        $this->employee_2 = new DbField(
            $this, // Table
            'x_employee_2', // Variable name
            'employee_2', // Name
            '`employee_2`', // Expression
            '`employee_2`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`employee_2`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->employee_2->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "");
        $this->employee_2->InputTextType = "text";
        $this->employee_2->Raw = true;
        $this->employee_2->Required = true; // Required field
        $this->employee_2->Sortable = false; // Allow sort
        $this->employee_2->setSelectMultiple(false); // Select one
        $this->employee_2->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->employee_2->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->employee_2->Lookup = new Lookup($this->employee_2, 'production_employee', false, 'id', ["id","user_name","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->employee_2) . "',COALESCE(`user_name`,''))");
        $this->employee_2->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->employee_2->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['employee_2'] = &$this->employee_2;

        // employee_3
        $this->employee_3 = new DbField(
            $this, // Table
            'x_employee_3', // Variable name
            'employee_3', // Name
            '`employee_3`', // Expression
            '`employee_3`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`employee_3`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->employee_3->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "");
        $this->employee_3->InputTextType = "text";
        $this->employee_3->Raw = true;
        $this->employee_3->Required = true; // Required field
        $this->employee_3->Sortable = false; // Allow sort
        $this->employee_3->setSelectMultiple(false); // Select one
        $this->employee_3->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->employee_3->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->employee_3->Lookup = new Lookup($this->employee_3, 'production_employee', false, 'id', ["id","user_name","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->employee_3) . "',COALESCE(`user_name`,''))");
        $this->employee_3->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->employee_3->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['employee_3'] = &$this->employee_3;

        // employee_id
        $this->employee_id = new DbField(
            $this, // Table
            'x_employee_id', // Variable name
            'employee_id', // Name
            '`employee_id`', // Expression
            '`employee_id`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`employee_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->employee_id->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "");
        $this->employee_id->InputTextType = "text";
        $this->employee_id->Lookup = new Lookup($this->employee_id, 'production_employee', true, 'id', ["id","user_name","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->employee_id) . "',COALESCE(`user_name`,''))");
        $this->employee_id->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['employee_id'] = &$this->employee_id;

        // process
        $this->process = new DbField(
            $this, // Table
            'x_process', // Variable name
            'process', // Name
            '`process`', // Expression
            '`process`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process->addMethod("getSelectFilter", fn() => "`status` = 1 and `type` = 1");
        $this->process->addMethod("getDefault", fn() => ((isset($_GET["prid"]))? $_GET["prid"]:((isset($_COOKIE["prid"]))? $_COOKIE["prid"]:'')));
        $this->process->addMethod("getLinkPrefix", fn() => "processactionlist?x_process=");
        $this->process->InputTextType = "text";
        $this->process->Raw = true;
        $this->process->Nullable = false; // NOT NULL field
        $this->process->Required = true; // Required field
        $this->process->setSelectMultiple(false); // Select one
        $this->process->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->process->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->process->Lookup = new Lookup($this->process, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], ["x_confirm_process"], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['process'] = &$this->process;

        // confirm_process
        $this->confirm_process = new DbField(
            $this, // Table
            'x_confirm_process', // Variable name
            'confirm_process', // Name
            '`confirm_process`', // Expression
            '`confirm_process`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`confirm_process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->confirm_process->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->confirm_process->addMethod("getDefault", fn() => ((isset($_GET["prid"]))? $_GET["prid"]:((isset($_COOKIE["prid"]))? $_COOKIE["prid"]:'')));
        $this->confirm_process->InputTextType = "text";
        $this->confirm_process->Raw = true;
        $this->confirm_process->Nullable = false; // NOT NULL field
        $this->confirm_process->Required = true; // Required field
        $this->confirm_process->Sortable = false; // Allow sort
        $this->confirm_process->setSelectMultiple(false); // Select one
        $this->confirm_process->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->confirm_process->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->confirm_process->Lookup = new Lookup($this->confirm_process, 'sub_process_type', false, 'id', ["name","","",""], '', '', ["x_process"], [], ["id"], ["x_id"], [], [], false, '`name` ASC', '', "`name`");
        $this->confirm_process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->confirm_process->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['confirm_process'] = &$this->confirm_process;

        // process_other
        $this->process_other = new DbField(
            $this, // Table
            'x_process_other', // Variable name
            'process_other', // Name
            '`process_other`', // Expression
            '`process_other`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_other`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->process_other->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ?  "`status` = 1 and `id` != " . $_COOKIE["prid"] . " and FIND_IN_SET(". $_COOKIE["prid"] .", `pao`)" : "");
        $this->process_other->addMethod("getDefault", fn() => ((isset($_COOKIE["poa"]))? $_COOKIE["poa"]:''));
        $this->process_other->InputTextType = "text";
        $this->process_other->Lookup = new Lookup($this->process_other, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`s_grp` ASC', '', "`name`");
        $this->process_other->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['process_other'] = &$this->process_other;

        // code
        $this->code = new DbField(
            $this, // Table
            'x_code', // Variable name
            'code', // Name
            '`code`', // Expression
            '`code`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->code->addMethod("getEditCustomAttributes", fn() => 'autofocus');
        $this->code->addMethod("getLinkPrefix", fn() => "bcodelist?x__barcode=");
        $this->code->InputTextType = "text";
        $this->code->Raw = true;
        $this->code->Nullable = false; // NOT NULL field
        $this->code->Required = true; // Required field
        $this->code->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['code'] = &$this->code;

        // size_actual
        $this->size_actual = new DbField(
            $this, // Table
            'x_size_actual', // Variable name
            'size_actual', // Name
            '`size_actual`', // Expression
            '`size_actual`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size_actual`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size_actual->InputTextType = "text";
        $this->size_actual->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['size_actual'] = &$this->size_actual;

        // weight_actual
        $this->weight_actual = new DbField(
            $this, // Table
            'x_weight_actual', // Variable name
            'weight_actual', // Name
            '`weight_actual`', // Expression
            '`weight_actual`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`weight_actual`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->weight_actual->InputTextType = "text";
        $this->weight_actual->Raw = true;
        $this->weight_actual->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->weight_actual->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['weight_actual'] = &$this->weight_actual;

        // valuation
        $this->valuation = new DbField(
            $this, // Table
            'x_valuation', // Variable name
            'valuation', // Name
            '`valuation`', // Expression
            '`valuation`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`valuation`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->valuation->addMethod("getDefault", fn() => 0);
        $this->valuation->InputTextType = "text";
        $this->valuation->Raw = true;
        $this->valuation->setSelectMultiple(false); // Select one
        $this->valuation->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->valuation->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->valuation->Lookup = new Lookup($this->valuation, 'process_action_single_old', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->valuation->OptionCount = 4;
        $this->valuation->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->valuation->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['valuation'] = &$this->valuation;

        // deduction
        $this->deduction = new DbField(
            $this, // Table
            'x_deduction', // Variable name
            'deduction', // Name
            '`deduction`', // Expression
            '`deduction`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`deduction`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->deduction->addMethod("getDefault", fn() => 0.00);
        $this->deduction->InputTextType = "text";
        $this->deduction->Raw = true;
        $this->deduction->Nullable = false; // NOT NULL field
        $this->deduction->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->deduction->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['deduction'] = &$this->deduction;

        // upload
        $this->upload = new DbField(
            $this, // Table
            'x_upload', // Variable name
            'upload', // Name
            '`upload`', // Expression
            '`upload`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`upload`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->upload->addMethod("getUploadPath", fn() => '.p_uploads/weaving/');
        $this->upload->InputTextType = "text";
        $this->upload->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['upload'] = &$this->upload;

        // roll_no
        $this->roll_no = new DbField(
            $this, // Table
            'x_roll_no', // Variable name
            'roll_no', // Name
            '`roll_no`', // Expression
            '`roll_no`', // Basic search expression
            18, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`roll_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->roll_no->addMethod("getDefault", fn() => ((isset($_COOKIE["rn"]))? $_COOKIE["rn"]:0));
        $this->roll_no->InputTextType = "text";
        $this->roll_no->Raw = true;
        $this->roll_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['roll_no'] = &$this->roll_no;

        // qty
        $this->qty = new DbField(
            $this, // Table
            'x_qty', // Variable name
            'qty', // Name
            '`qty`', // Expression
            '`qty`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty->addMethod("getDefault", fn() => ((isset($_COOKIE["nop"]))? $_COOKIE["nop"]:0));
        $this->qty->InputTextType = "text";
        $this->qty->Raw = true;
        $this->qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['qty'] = &$this->qty;

        // payment
        $this->payment = new DbField(
            $this, // Table
            'x_payment', // Variable name
            'payment', // Name
            '`payment`', // Expression
            '`payment`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->payment->InputTextType = "text";
        $this->payment->Required = true; // Required field
        $this->payment->Lookup = new Lookup($this->payment, 'payment_period', false, 'id', ["payment_description","","",""], '', '', [], [], [], [], [], [], false, '`payment_description` ASC', '', "`payment_description`");
        $this->payment->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->payment->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['payment'] = &$this->payment;

        // remark
        $this->remark = new DbField(
            $this, // Table
            'x_remark', // Variable name
            'remark', // Name
            '`remark`', // Expression
            '`remark`', // Basic search expression
            200, // Type
            225, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remark`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->remark->InputTextType = "text";
        $this->remark->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remark'] = &$this->remark;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->Required = true; // Required field
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->Required = true; // Required field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // tmp_id
        $this->tmp_id = new DbField(
            $this, // Table
            'x_tmp_id', // Variable name
            'tmp_id', // Name
            '`tmp_id`', // Expression
            '`tmp_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`tmp_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tmp_id->InputTextType = "text";
        $this->tmp_id->Raw = true;
        $this->tmp_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->tmp_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['tmp_id'] = &$this->tmp_id;

        // uid
        $this->uid = new DbField(
            $this, // Table
            'x_uid', // Variable name
            'uid', // Name
            '`uid`', // Expression
            '`uid`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`uid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->uid->InputTextType = "text";
        $this->uid->Nullable = false; // NOT NULL field
        $this->uid->Required = true; // Required field
        $this->uid->Sortable = false; // Allow sort
        $this->uid->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['uid'] = &$this->uid;

        // buyer_id
        $this->buyer_id = new DbField(
            $this, // Table
            'x_buyer_id', // Variable name
            'buyer_id', // Name
            '`buyer_id`', // Expression
            '`buyer_id`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_id->InputTextType = "text";
        $this->buyer_id->Raw = true;
        $this->buyer_id->Lookup = new Lookup($this->buyer_id, 'buyer_seller_view', false, 'id', ["code","","",""], '', '', [], [], [], [], [], [], false, '`code` ASC', '', "`code`");
        $this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyer_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_id'] = &$this->buyer_id;

        // design_id
        $this->design_id = new DbField(
            $this, // Table
            'x_design_id', // Variable name
            'design_id', // Name
            '`design_id`', // Expression
            '`design_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`design_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->design_id->addMethod("getSelectFilter", fn() => "`grp`=3");
        $this->design_id->InputTextType = "text";
        $this->design_id->Raw = true;
        $this->design_id->Lookup = new Lookup($this->design_id, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->design_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->design_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['design_id'] = &$this->design_id;

        // size_cm
        $this->size_cm = new DbField(
            $this, // Table
            'x_size_cm', // Variable name
            'size_cm', // Name
            '`size_cm`', // Expression
            '`size_cm`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size_cm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size_cm->InputTextType = "text";
        $this->size_cm->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['size_cm'] = &$this->size_cm;

        // sqm
        $this->sqm = new DbField(
            $this, // Table
            'x_sqm', // Variable name
            'sqm', // Name
            '`sqm`', // Expression
            '`sqm`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm->addMethod("getDefault", fn() => 0.000);
        $this->sqm->InputTextType = "text";
        $this->sqm->Raw = true;
        $this->sqm->Nullable = false; // NOT NULL field
        $this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['sqm'] = &$this->sqm;

        // jc_no
        $this->jc_no = new DbField(
            $this, // Table
            'x_jc_no', // Variable name
            'jc_no', // Name
            '`jc_no`', // Expression
            '`jc_no`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_no->InputTextType = "text";
        $this->jc_no->Raw = true;
        $this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['jc_no'] = &$this->jc_no;

        // loom_id
        $this->loom_id = new DbField(
            $this, // Table
            'x_loom_id', // Variable name
            'loom_id', // Name
            '`loom_id`', // Expression
            '`loom_id`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`loom_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->loom_id->InputTextType = "text";
        $this->loom_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['loom_id'] = &$this->loom_id;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "process_action_single_old";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = (User_Site() == 0)? "" : "`operator` = " .  CurrentUserID() . "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->location->DbValue = $row['location'];
        $this->employee_1->DbValue = $row['employee_1'];
        $this->employee_2->DbValue = $row['employee_2'];
        $this->employee_3->DbValue = $row['employee_3'];
        $this->employee_id->DbValue = $row['employee_id'];
        $this->process->DbValue = $row['process'];
        $this->confirm_process->DbValue = $row['confirm_process'];
        $this->process_other->DbValue = $row['process_other'];
        $this->code->DbValue = $row['code'];
        $this->size_actual->DbValue = $row['size_actual'];
        $this->weight_actual->DbValue = $row['weight_actual'];
        $this->valuation->DbValue = $row['valuation'];
        $this->deduction->DbValue = $row['deduction'];
        $this->upload->Upload->DbValue = $row['upload'];
        $this->roll_no->DbValue = $row['roll_no'];
        $this->qty->DbValue = $row['qty'];
        $this->payment->DbValue = $row['payment'];
        $this->remark->DbValue = $row['remark'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->tmp_id->DbValue = $row['tmp_id'];
        $this->uid->DbValue = $row['uid'];
        $this->buyer_id->DbValue = $row['buyer_id'];
        $this->design_id->DbValue = $row['design_id'];
        $this->size_cm->DbValue = $row['size_cm'];
        $this->sqm->DbValue = $row['sqm'];
        $this->jc_no->DbValue = $row['jc_no'];
        $this->loom_id->DbValue = $row['loom_id'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['upload']) ? [] : [$row['upload']];
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->upload->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->upload->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("processactionsingleoldlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "processactionsingleoldview" => $Language->phrase("View"),
            "processactionsingleoldedit" => $Language->phrase("Edit"),
            "processactionsingleoldadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "processactionsingleoldlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "ProcessActionSingleOldView",
            Config("API_ADD_ACTION") => "ProcessActionSingleOldAdd",
            Config("API_EDIT_ACTION") => "ProcessActionSingleOldEdit",
            Config("API_DELETE_ACTION") => "ProcessActionSingleOldDelete",
            Config("API_LIST_ACTION") => "ProcessActionSingleOldList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "processactionsingleoldlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("processactionsingleoldview", $parm);
        } else {
            $url = $this->keyUrl("processactionsingleoldview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "processactionsingleoldadd?" . $parm;
        } else {
            $url = "processactionsingleoldadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("processactionsingleoldedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("processactionsingleoldlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("processactionsingleoldadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("processactionsingleoldlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("processactionsingleolddelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->location->setDbValue($row['location']);
        $this->employee_1->setDbValue($row['employee_1']);
        $this->employee_2->setDbValue($row['employee_2']);
        $this->employee_3->setDbValue($row['employee_3']);
        $this->employee_id->setDbValue($row['employee_id']);
        $this->process->setDbValue($row['process']);
        $this->confirm_process->setDbValue($row['confirm_process']);
        $this->process_other->setDbValue($row['process_other']);
        $this->code->setDbValue($row['code']);
        $this->size_actual->setDbValue($row['size_actual']);
        $this->weight_actual->setDbValue($row['weight_actual']);
        $this->valuation->setDbValue($row['valuation']);
        $this->deduction->setDbValue($row['deduction']);
        $this->upload->Upload->DbValue = $row['upload'];
        $this->roll_no->setDbValue($row['roll_no']);
        $this->qty->setDbValue($row['qty']);
        $this->payment->setDbValue($row['payment']);
        $this->remark->setDbValue($row['remark']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->tmp_id->setDbValue($row['tmp_id']);
        $this->uid->setDbValue($row['uid']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->design_id->setDbValue($row['design_id']);
        $this->size_cm->setDbValue($row['size_cm']);
        $this->sqm->setDbValue($row['sqm']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->loom_id->setDbValue($row['loom_id']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "ProcessActionSingleOldList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // location

        // employee_1
        $this->employee_1->CellCssStyle = "white-space: nowrap;";

        // employee_2
        $this->employee_2->CellCssStyle = "white-space: nowrap;";

        // employee_3
        $this->employee_3->CellCssStyle = "white-space: nowrap;";

        // employee_id

        // process

        // confirm_process
        $this->confirm_process->CellCssStyle = "white-space: nowrap;";

        // process_other

        // code

        // size_actual

        // weight_actual

        // valuation

        // deduction

        // upload

        // roll_no

        // qty

        // payment
        $this->payment->CellCssStyle = "white-space: nowrap;";

        // remark

        // operator

        // datetime

        // tmp_id
        $this->tmp_id->CellCssStyle = "white-space: nowrap;";

        // uid
        $this->uid->CellCssStyle = "white-space: nowrap;";

        // buyer_id

        // design_id

        // size_cm

        // sqm

        // jc_no

        // loom_id

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // location
        $curVal = strval($this->location->CurrentValue);
        if ($curVal != "") {
            $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
            if ($this->location->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                    $this->location->ViewValue = $this->location->displayValue($arwrk);
                } else {
                    $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                }
            }
        } else {
            $this->location->ViewValue = null;
        }

        // employee_1
        $curVal = strval($this->employee_1->CurrentValue);
        if ($curVal != "") {
            $this->employee_1->ViewValue = $this->employee_1->lookupCacheOption($curVal);
            if ($this->employee_1->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->employee_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_1->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->employee_1->getSelectFilter($this); // PHP
                $sqlWrk = $this->employee_1->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->employee_1->Lookup->renderViewRow($rswrk[0]);
                    $this->employee_1->ViewValue = $this->employee_1->displayValue($arwrk);
                } else {
                    $this->employee_1->ViewValue = $this->employee_1->CurrentValue;
                }
            }
        } else {
            $this->employee_1->ViewValue = null;
        }

        // employee_2
        $curVal = strval($this->employee_2->CurrentValue);
        if ($curVal != "") {
            $this->employee_2->ViewValue = $this->employee_2->lookupCacheOption($curVal);
            if ($this->employee_2->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->employee_2->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_2->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->employee_2->getSelectFilter($this); // PHP
                $sqlWrk = $this->employee_2->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->employee_2->Lookup->renderViewRow($rswrk[0]);
                    $this->employee_2->ViewValue = $this->employee_2->displayValue($arwrk);
                } else {
                    $this->employee_2->ViewValue = FormatNumber($this->employee_2->CurrentValue, $this->employee_2->formatPattern());
                }
            }
        } else {
            $this->employee_2->ViewValue = null;
        }

        // employee_3
        $curVal = strval($this->employee_3->CurrentValue);
        if ($curVal != "") {
            $this->employee_3->ViewValue = $this->employee_3->lookupCacheOption($curVal);
            if ($this->employee_3->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->employee_3->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_3->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->employee_3->getSelectFilter($this); // PHP
                $sqlWrk = $this->employee_3->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->employee_3->Lookup->renderViewRow($rswrk[0]);
                    $this->employee_3->ViewValue = $this->employee_3->displayValue($arwrk);
                } else {
                    $this->employee_3->ViewValue = FormatNumber($this->employee_3->CurrentValue, $this->employee_3->formatPattern());
                }
            }
        } else {
            $this->employee_3->ViewValue = null;
        }

        // employee_id
        $curVal = strval($this->employee_id->CurrentValue);
        if ($curVal != "") {
            $this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
            if ($this->employee_id->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->employee_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->employee_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->employee_id->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->employee_id->Lookup->renderViewRow($row);
                        $this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
                    }
                } else {
                    $this->employee_id->ViewValue = $this->employee_id->CurrentValue;
                }
            }
        } else {
            $this->employee_id->ViewValue = null;
        }

        // process
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                    $this->process->ViewValue = $this->process->displayValue($arwrk);
                } else {
                    $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                }
            }
        } else {
            $this->process->ViewValue = null;
        }

        // confirm_process
        $curVal = strval($this->confirm_process->CurrentValue);
        if ($curVal != "") {
            $this->confirm_process->ViewValue = $this->confirm_process->lookupCacheOption($curVal);
            if ($this->confirm_process->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->confirm_process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->confirm_process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->confirm_process->getSelectFilter($this); // PHP
                $sqlWrk = $this->confirm_process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->confirm_process->Lookup->renderViewRow($rswrk[0]);
                    $this->confirm_process->ViewValue = $this->confirm_process->displayValue($arwrk);
                } else {
                    $this->confirm_process->ViewValue = $this->confirm_process->CurrentValue;
                }
            }
        } else {
            $this->confirm_process->ViewValue = null;
        }

        // process_other
        $curVal = strval($this->process_other->CurrentValue);
        if ($curVal != "") {
            $this->process_other->ViewValue = $this->process_other->lookupCacheOption($curVal);
            if ($this->process_other->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->process_other->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_other->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->process_other->getSelectFilter($this); // PHP
                $sqlWrk = $this->process_other->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->process_other->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->process_other->Lookup->renderViewRow($row);
                        $this->process_other->ViewValue->add($this->process_other->displayValue($arwrk));
                    }
                } else {
                    $this->process_other->ViewValue = $this->process_other->CurrentValue;
                }
            }
        } else {
            $this->process_other->ViewValue = null;
        }

        // code
        $this->code->ViewValue = $this->code->CurrentValue;

        // size_actual
        $this->size_actual->ViewValue = $this->size_actual->CurrentValue;

        // weight_actual
        $this->weight_actual->ViewValue = $this->weight_actual->CurrentValue;
        $this->weight_actual->ViewValue = FormatNumber($this->weight_actual->ViewValue, $this->weight_actual->formatPattern());

        // valuation
        if (strval($this->valuation->CurrentValue) != "") {
            $this->valuation->ViewValue = $this->valuation->optionCaption($this->valuation->CurrentValue);
        } else {
            $this->valuation->ViewValue = null;
        }

        // deduction
        $this->deduction->ViewValue = $this->deduction->CurrentValue;
        $this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, $this->deduction->formatPattern());

        // upload
        $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
        if (!EmptyValue($this->upload->Upload->DbValue)) {
            $this->upload->ImageWidth = 0;
            $this->upload->ImageHeight = 50;
            $this->upload->ImageAlt = $this->upload->alt();
            $this->upload->ImageCssClass = "ew-image";
            $this->upload->ViewValue = $this->upload->Upload->DbValue;
        } else {
            $this->upload->ViewValue = "";
        }

        // roll_no
        $this->roll_no->ViewValue = $this->roll_no->CurrentValue;
        $this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, $this->roll_no->formatPattern());

        // qty
        $this->qty->ViewValue = $this->qty->CurrentValue;
        $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

        // payment
        $curVal = strval($this->payment->CurrentValue);
        if ($curVal != "") {
            $this->payment->ViewValue = $this->payment->lookupCacheOption($curVal);
            if ($this->payment->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->payment->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->payment->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $sqlWrk = $this->payment->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->payment->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->payment->Lookup->renderViewRow($row);
                        $this->payment->ViewValue->add($this->payment->displayValue($arwrk));
                    }
                } else {
                    $this->payment->ViewValue = $this->payment->CurrentValue;
                }
            }
        } else {
            $this->payment->ViewValue = null;
        }

        // remark
        $this->remark->ViewValue = $this->remark->CurrentValue;

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // tmp_id
        $this->tmp_id->ViewValue = $this->tmp_id->CurrentValue;
        $this->tmp_id->ViewValue = FormatNumber($this->tmp_id->ViewValue, $this->tmp_id->formatPattern());

        // uid
        $this->uid->ViewValue = $this->uid->CurrentValue;

        // buyer_id
        $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
        $curVal = strval($this->buyer_id->CurrentValue);
        if ($curVal != "") {
            $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
            if ($this->buyer_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                } else {
                    $this->buyer_id->ViewValue = FormatNumber($this->buyer_id->CurrentValue, $this->buyer_id->formatPattern());
                }
            }
        } else {
            $this->buyer_id->ViewValue = null;
        }

        // design_id
        $this->design_id->ViewValue = $this->design_id->CurrentValue;
        $curVal = strval($this->design_id->CurrentValue);
        if ($curVal != "") {
            $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
            if ($this->design_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                    $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                } else {
                    $this->design_id->ViewValue = FormatNumber($this->design_id->CurrentValue, $this->design_id->formatPattern());
                }
            }
        } else {
            $this->design_id->ViewValue = null;
        }

        // size_cm
        $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

        // sqm
        $this->sqm->ViewValue = $this->sqm->CurrentValue;
        $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

        // jc_no
        $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
        $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

        // loom_id
        $this->loom_id->ViewValue = $this->loom_id->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // location
        $this->location->HrefValue = "";
        $this->location->TooltipValue = "";

        // employee_1
        if (!EmptyValue($this->employee_1->CurrentValue)) {
            $this->employee_1->HrefValue = $this->employee_1->getLinkPrefix() . $this->employee_1->CurrentValue; // Add prefix/suffix
            $this->employee_1->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->employee_1->HrefValue = FullUrl($this->employee_1->HrefValue, "href");
            }
        } else {
            $this->employee_1->HrefValue = "";
        }
        $this->employee_1->TooltipValue = "";

        // employee_2
        $this->employee_2->HrefValue = "";
        $this->employee_2->TooltipValue = "";

        // employee_3
        $this->employee_3->HrefValue = "";
        $this->employee_3->TooltipValue = "";

        // employee_id
        $this->employee_id->HrefValue = "";
        $this->employee_id->TooltipValue = "";

        // process
        if (!EmptyValue($this->process->CurrentValue)) {
            $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
            $this->process->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
            }
        } else {
            $this->process->HrefValue = "";
        }
        $this->process->TooltipValue = "";

        // confirm_process
        $this->confirm_process->HrefValue = "";
        $this->confirm_process->TooltipValue = "";

        // process_other
        $this->process_other->HrefValue = "";
        $this->process_other->TooltipValue = "";

        // code
        if (!EmptyValue($this->code->CurrentValue)) {
            $this->code->HrefValue = $this->code->getLinkPrefix() . $this->code->CurrentValue; // Add prefix/suffix
            $this->code->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->code->HrefValue = FullUrl($this->code->HrefValue, "href");
            }
        } else {
            $this->code->HrefValue = "";
        }
        $this->code->TooltipValue = "";

        // size_actual
        $this->size_actual->HrefValue = "";
        $this->size_actual->TooltipValue = "";

        // weight_actual
        $this->weight_actual->HrefValue = "";
        $this->weight_actual->TooltipValue = "";

        // valuation
        $this->valuation->HrefValue = "";
        $this->valuation->TooltipValue = "";

        // deduction
        $this->deduction->HrefValue = "";
        $this->deduction->TooltipValue = "";

        // upload
        $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
        if (!EmptyValue($this->upload->Upload->DbValue)) {
            $this->upload->HrefValue = GetFileUploadUrl($this->upload, $this->upload->htmlDecode($this->upload->Upload->DbValue)); // Add prefix/suffix
            $this->upload->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
            }
        } else {
            $this->upload->HrefValue = "";
        }
        $this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
        $this->upload->TooltipValue = "";
        if ($this->upload->UseColorbox) {
            if (EmptyValue($this->upload->TooltipValue)) {
                $this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->upload->LinkAttrs["data-rel"] = "process_action_single_old_x_upload";
            $this->upload->LinkAttrs->appendClass("ew-lightbox");
        }

        // roll_no
        $this->roll_no->HrefValue = "";
        $this->roll_no->TooltipValue = "";

        // qty
        $this->qty->HrefValue = "";
        $this->qty->TooltipValue = "";

        // payment
        $this->payment->HrefValue = "";
        $this->payment->TooltipValue = "";

        // remark
        $this->remark->HrefValue = "";
        $this->remark->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // tmp_id
        $this->tmp_id->HrefValue = "";
        $this->tmp_id->TooltipValue = "";

        // uid
        $this->uid->HrefValue = "";
        $this->uid->TooltipValue = "";

        // buyer_id
        $this->buyer_id->HrefValue = "";
        $this->buyer_id->TooltipValue = "";

        // design_id
        $this->design_id->HrefValue = "";
        $this->design_id->TooltipValue = "";

        // size_cm
        $this->size_cm->HrefValue = "";
        $this->size_cm->TooltipValue = "";

        // sqm
        $this->sqm->HrefValue = "";
        $this->sqm->TooltipValue = "";

        // jc_no
        $this->jc_no->HrefValue = "";
        $this->jc_no->TooltipValue = "";

        // loom_id
        $this->loom_id->HrefValue = "";
        $this->loom_id->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // location
        $this->location->setupEditAttributes();
        $curVal = strval($this->location->CurrentValue);
        if ($curVal != "") {
            $this->location->EditValue = $this->location->lookupCacheOption($curVal);
            if ($this->location->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                    $this->location->EditValue = $this->location->displayValue($arwrk);
                } else {
                    $this->location->EditValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                }
            }
        } else {
            $this->location->EditValue = null;
        }

        // employee_1
        $this->employee_1->setupEditAttributes();
        $this->employee_1->PlaceHolder = RemoveHtml($this->employee_1->caption());

        // employee_2
        $this->employee_2->setupEditAttributes();
        $this->employee_2->PlaceHolder = RemoveHtml($this->employee_2->caption());

        // employee_3
        $this->employee_3->setupEditAttributes();
        $this->employee_3->PlaceHolder = RemoveHtml($this->employee_3->caption());

        // employee_id
        $this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());

        // process
        $this->process->setupEditAttributes();
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->EditValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                    $this->process->EditValue = $this->process->displayValue($arwrk);
                } else {
                    $this->process->EditValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                }
            }
        } else {
            $this->process->EditValue = null;
        }

        // confirm_process
        $this->confirm_process->setupEditAttributes();
        $curVal = strval($this->confirm_process->CurrentValue);
        if ($curVal != "") {
            $this->confirm_process->EditValue = $this->confirm_process->lookupCacheOption($curVal);
            if ($this->confirm_process->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->confirm_process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->confirm_process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->confirm_process->getSelectFilter($this); // PHP
                $sqlWrk = $this->confirm_process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->confirm_process->Lookup->renderViewRow($rswrk[0]);
                    $this->confirm_process->EditValue = $this->confirm_process->displayValue($arwrk);
                } else {
                    $this->confirm_process->EditValue = $this->confirm_process->CurrentValue;
                }
            }
        } else {
            $this->confirm_process->EditValue = null;
        }

        // process_other
        $this->process_other->PlaceHolder = RemoveHtml($this->process_other->caption());

        // code
        $this->code->setupEditAttributes();
        $this->code->EditCustomAttributes = $this->code->getEditCustomAttributes(); // PHP
        $this->code->EditValue = $this->code->CurrentValue;

        // size_actual
        $this->size_actual->setupEditAttributes();
        if (!$this->size_actual->Raw) {
            $this->size_actual->CurrentValue = HtmlDecode($this->size_actual->CurrentValue);
        }
        $this->size_actual->EditValue = $this->size_actual->CurrentValue;
        $this->size_actual->PlaceHolder = RemoveHtml($this->size_actual->caption());

        // weight_actual
        $this->weight_actual->setupEditAttributes();
        $this->weight_actual->EditValue = $this->weight_actual->CurrentValue;
        $this->weight_actual->PlaceHolder = RemoveHtml($this->weight_actual->caption());
        if (strval($this->weight_actual->EditValue) != "" && is_numeric($this->weight_actual->EditValue)) {
            $this->weight_actual->EditValue = FormatNumber($this->weight_actual->EditValue, null);
        }

        // valuation
        $this->valuation->setupEditAttributes();
        $this->valuation->EditValue = $this->valuation->options(true);
        $this->valuation->PlaceHolder = RemoveHtml($this->valuation->caption());

        // deduction
        $this->deduction->setupEditAttributes();
        $this->deduction->EditValue = $this->deduction->CurrentValue;
        $this->deduction->PlaceHolder = RemoveHtml($this->deduction->caption());
        if (strval($this->deduction->EditValue) != "" && is_numeric($this->deduction->EditValue)) {
            $this->deduction->EditValue = FormatNumber($this->deduction->EditValue, null);
        }

        // upload
        $this->upload->setupEditAttributes();
        $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
        if (!EmptyValue($this->upload->Upload->DbValue)) {
            $this->upload->ImageWidth = 0;
            $this->upload->ImageHeight = 50;
            $this->upload->ImageAlt = $this->upload->alt();
            $this->upload->ImageCssClass = "ew-image";
            $this->upload->EditValue = $this->upload->Upload->DbValue;
        } else {
            $this->upload->EditValue = "";
        }
        if (!EmptyValue($this->upload->CurrentValue)) {
            $this->upload->Upload->FileName = $this->upload->CurrentValue;
        }

        // roll_no
        $this->roll_no->setupEditAttributes();
        $this->roll_no->EditValue = $this->roll_no->CurrentValue;
        $this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());
        if (strval($this->roll_no->EditValue) != "" && is_numeric($this->roll_no->EditValue)) {
            $this->roll_no->EditValue = FormatNumber($this->roll_no->EditValue, null);
        }

        // qty
        $this->qty->setupEditAttributes();
        $this->qty->EditValue = $this->qty->CurrentValue;
        $this->qty->PlaceHolder = RemoveHtml($this->qty->caption());
        if (strval($this->qty->EditValue) != "" && is_numeric($this->qty->EditValue)) {
            $this->qty->EditValue = FormatNumber($this->qty->EditValue, null);
        }

        // payment
        $this->payment->PlaceHolder = RemoveHtml($this->payment->caption());

        // remark
        $this->remark->setupEditAttributes();
        if (!$this->remark->Raw) {
            $this->remark->CurrentValue = HtmlDecode($this->remark->CurrentValue);
        }
        $this->remark->EditValue = $this->remark->CurrentValue;
        $this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

        // operator
        $this->operator->setupEditAttributes();
        $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

        // datetime
        $this->datetime->setupEditAttributes();
        $this->datetime->EditValue = FormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

        // tmp_id
        $this->tmp_id->setupEditAttributes();
        $this->tmp_id->EditValue = $this->tmp_id->CurrentValue;
        $this->tmp_id->PlaceHolder = RemoveHtml($this->tmp_id->caption());
        if (strval($this->tmp_id->EditValue) != "" && is_numeric($this->tmp_id->EditValue)) {
            $this->tmp_id->EditValue = FormatNumber($this->tmp_id->EditValue, null);
        }

        // uid
        $this->uid->setupEditAttributes();
        if (!$this->uid->Raw) {
            $this->uid->CurrentValue = HtmlDecode($this->uid->CurrentValue);
        }
        $this->uid->EditValue = $this->uid->CurrentValue;
        $this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

        // buyer_id
        $this->buyer_id->setupEditAttributes();
        $this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
        $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

        // design_id
        $this->design_id->setupEditAttributes();
        $this->design_id->EditValue = $this->design_id->CurrentValue;
        $this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

        // size_cm
        $this->size_cm->setupEditAttributes();
        if (!$this->size_cm->Raw) {
            $this->size_cm->CurrentValue = HtmlDecode($this->size_cm->CurrentValue);
        }
        $this->size_cm->EditValue = $this->size_cm->CurrentValue;
        $this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

        // sqm
        $this->sqm->setupEditAttributes();
        $this->sqm->EditValue = $this->sqm->CurrentValue;
        $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
        if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
            $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
        }

        // jc_no
        $this->jc_no->setupEditAttributes();
        $this->jc_no->EditValue = $this->jc_no->CurrentValue;
        $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());
        if (strval($this->jc_no->EditValue) != "" && is_numeric($this->jc_no->EditValue)) {
            $this->jc_no->EditValue = FormatNumber($this->jc_no->EditValue, null);
        }

        // loom_id
        $this->loom_id->setupEditAttributes();
        if (!$this->loom_id->Raw) {
            $this->loom_id->CurrentValue = HtmlDecode($this->loom_id->CurrentValue);
        }
        $this->loom_id->EditValue = $this->loom_id->CurrentValue;
        $this->loom_id->PlaceHolder = RemoveHtml($this->loom_id->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->employee_id);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->confirm_process);
                    $doc->exportCaption($this->process_other);
                    $doc->exportCaption($this->code);
                    $doc->exportCaption($this->size_actual);
                    $doc->exportCaption($this->weight_actual);
                    $doc->exportCaption($this->valuation);
                    $doc->exportCaption($this->deduction);
                    $doc->exportCaption($this->upload);
                    $doc->exportCaption($this->roll_no);
                    $doc->exportCaption($this->qty);
                    $doc->exportCaption($this->payment);
                    $doc->exportCaption($this->remark);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->tmp_id);
                    $doc->exportCaption($this->buyer_id);
                    $doc->exportCaption($this->design_id);
                    $doc->exportCaption($this->size_cm);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->loom_id);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->employee_id);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->process_other);
                    $doc->exportCaption($this->code);
                    $doc->exportCaption($this->size_actual);
                    $doc->exportCaption($this->weight_actual);
                    $doc->exportCaption($this->valuation);
                    $doc->exportCaption($this->deduction);
                    $doc->exportCaption($this->upload);
                    $doc->exportCaption($this->roll_no);
                    $doc->exportCaption($this->qty);
                    $doc->exportCaption($this->payment);
                    $doc->exportCaption($this->remark);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->tmp_id);
                    $doc->exportCaption($this->buyer_id);
                    $doc->exportCaption($this->design_id);
                    $doc->exportCaption($this->size_cm);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->loom_id);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->location);
                        $doc->exportField($this->employee_id);
                        $doc->exportField($this->process);
                        $doc->exportField($this->confirm_process);
                        $doc->exportField($this->process_other);
                        $doc->exportField($this->code);
                        $doc->exportField($this->size_actual);
                        $doc->exportField($this->weight_actual);
                        $doc->exportField($this->valuation);
                        $doc->exportField($this->deduction);
                        $doc->exportField($this->upload);
                        $doc->exportField($this->roll_no);
                        $doc->exportField($this->qty);
                        $doc->exportField($this->payment);
                        $doc->exportField($this->remark);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->tmp_id);
                        $doc->exportField($this->buyer_id);
                        $doc->exportField($this->design_id);
                        $doc->exportField($this->size_cm);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->loom_id);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->location);
                        $doc->exportField($this->employee_id);
                        $doc->exportField($this->process);
                        $doc->exportField($this->process_other);
                        $doc->exportField($this->code);
                        $doc->exportField($this->size_actual);
                        $doc->exportField($this->weight_actual);
                        $doc->exportField($this->valuation);
                        $doc->exportField($this->deduction);
                        $doc->exportField($this->upload);
                        $doc->exportField($this->roll_no);
                        $doc->exportField($this->qty);
                        $doc->exportField($this->payment);
                        $doc->exportField($this->remark);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->tmp_id);
                        $doc->exportField($this->buyer_id);
                        $doc->exportField($this->design_id);
                        $doc->exportField($this->size_cm);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->loom_id);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'upload') {
            $fldName = "upload";
            $fileNameFld = "upload";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->id->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
