<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProcessActionSearch extends ProcessAction
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProcessActionSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "processactionsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->process->setVisibility();
        $this->confirm_process->Visible = false;
        $this->process_other->setVisibility();
        $this->location->setVisibility();
        $this->godown->setVisibility();
        $this->code->setVisibility();
        $this->code_last->setVisibility();
        $this->employee_1->Visible = false;
        $this->employee_2->Visible = false;
        $this->employee_3->Visible = false;
        $this->employee_id->setVisibility();
        $this->qty->setVisibility();
        $this->roll_no->setVisibility();
        $this->size_w->setVisibility();
        $this->size_l->setVisibility();
        $this->size_h->setVisibility();
        $this->size_actual->setVisibility();
        $this->weight_actual->setVisibility();
        $this->lines_in_30cm->setVisibility();
        $this->d_01->setVisibility();
        $this->d_02->setVisibility();
        $this->d_03->setVisibility();
        $this->d_04->setVisibility();
        $this->d_05->setVisibility();
        $this->d_06->setVisibility();
        $this->d_07->setVisibility();
        $this->d_08->setVisibility();
        $this->d_09->setVisibility();
        $this->d_10->setVisibility();
        $this->valuation->setVisibility();
        $this->deduction->setVisibility();
        $this->remark->setVisibility();
        $this->upload->setVisibility();
        $this->uid->Visible = false;
        $this->payment->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'process_action';
        $this->TableName = 'process_action';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (process_action)
        if (!isset($GLOBALS["process_action"]) || $GLOBALS["process_action"]::class == PROJECT_NAMESPACE . "process_action") {
            $GLOBALS["process_action"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_action');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "processactionview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
                $this->upload->UploadPath = $this->upload->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->confirm_process);
        $this->setupLookupOptions($this->process_other);
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->godown);
        $this->setupLookupOptions($this->employee_1);
        $this->setupLookupOptions($this->employee_2);
        $this->setupLookupOptions($this->employee_3);
        $this->setupLookupOptions($this->employee_id);
        $this->setupLookupOptions($this->valuation);
        $this->setupLookupOptions($this->payment);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "processactionlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->process); // process
        $this->buildSearchUrl($srchUrl, $this->process_other); // process_other
        $this->buildSearchUrl($srchUrl, $this->location); // location
        $this->buildSearchUrl($srchUrl, $this->godown); // godown
        $this->buildSearchUrl($srchUrl, $this->code); // code
        $this->buildSearchUrl($srchUrl, $this->code_last); // code_last
        $this->buildSearchUrl($srchUrl, $this->employee_id); // employee_id
        $this->buildSearchUrl($srchUrl, $this->qty); // qty
        $this->buildSearchUrl($srchUrl, $this->roll_no); // roll_no
        $this->buildSearchUrl($srchUrl, $this->size_w); // size_w
        $this->buildSearchUrl($srchUrl, $this->size_l); // size_l
        $this->buildSearchUrl($srchUrl, $this->size_h); // size_h
        $this->buildSearchUrl($srchUrl, $this->size_actual); // size_actual
        $this->buildSearchUrl($srchUrl, $this->weight_actual); // weight_actual
        $this->buildSearchUrl($srchUrl, $this->lines_in_30cm); // lines_in_30cm
        $this->buildSearchUrl($srchUrl, $this->d_01); // d_01
        $this->buildSearchUrl($srchUrl, $this->d_02); // d_02
        $this->buildSearchUrl($srchUrl, $this->d_03); // d_03
        $this->buildSearchUrl($srchUrl, $this->d_04); // d_04
        $this->buildSearchUrl($srchUrl, $this->d_05); // d_05
        $this->buildSearchUrl($srchUrl, $this->d_06); // d_06
        $this->buildSearchUrl($srchUrl, $this->d_07); // d_07
        $this->buildSearchUrl($srchUrl, $this->d_08); // d_08
        $this->buildSearchUrl($srchUrl, $this->d_09); // d_09
        $this->buildSearchUrl($srchUrl, $this->d_10); // d_10
        $this->buildSearchUrl($srchUrl, $this->valuation); // valuation
        $this->buildSearchUrl($srchUrl, $this->deduction); // deduction
        $this->buildSearchUrl($srchUrl, $this->remark); // remark
        $this->buildSearchUrl($srchUrl, $this->upload); // upload
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // process
        if ($this->process->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // process_other
        if ($this->process_other->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->process_other->AdvancedSearch->SearchValue)) {
            $this->process_other->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->process_other->AdvancedSearch->SearchValue);
        }
        if (is_array($this->process_other->AdvancedSearch->SearchValue2)) {
            $this->process_other->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->process_other->AdvancedSearch->SearchValue2);
        }

        // location
        if ($this->location->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // godown
        if ($this->godown->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // code
        if ($this->code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // code_last
        if ($this->code_last->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // employee_id
        if ($this->employee_id->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->employee_id->AdvancedSearch->SearchValue)) {
            $this->employee_id->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->employee_id->AdvancedSearch->SearchValue);
        }
        if (is_array($this->employee_id->AdvancedSearch->SearchValue2)) {
            $this->employee_id->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->employee_id->AdvancedSearch->SearchValue2);
        }

        // qty
        if ($this->qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // roll_no
        if ($this->roll_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // size_w
        if ($this->size_w->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // size_l
        if ($this->size_l->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // size_h
        if ($this->size_h->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // size_actual
        if ($this->size_actual->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // weight_actual
        if ($this->weight_actual->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // lines_in_30cm
        if ($this->lines_in_30cm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_01
        if ($this->d_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_02
        if ($this->d_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_03
        if ($this->d_03->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_04
        if ($this->d_04->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_05
        if ($this->d_05->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_06
        if ($this->d_06->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_07
        if ($this->d_07->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_08
        if ($this->d_08->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_09
        if ($this->d_09->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_10
        if ($this->d_10->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // valuation
        if ($this->valuation->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // deduction
        if ($this->deduction->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remark
        if ($this->remark->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // upload
        if ($this->upload->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // confirm_process
        $this->confirm_process->RowCssClass = "row";

        // process_other
        $this->process_other->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // godown
        $this->godown->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // code_last
        $this->code_last->RowCssClass = "row";

        // employee_1
        $this->employee_1->RowCssClass = "row";

        // employee_2
        $this->employee_2->RowCssClass = "row";

        // employee_3
        $this->employee_3->RowCssClass = "row";

        // employee_id
        $this->employee_id->RowCssClass = "row";

        // qty
        $this->qty->RowCssClass = "row";

        // roll_no
        $this->roll_no->RowCssClass = "row";

        // size_w
        $this->size_w->RowCssClass = "row";

        // size_l
        $this->size_l->RowCssClass = "row";

        // size_h
        $this->size_h->RowCssClass = "row";

        // size_actual
        $this->size_actual->RowCssClass = "row";

        // weight_actual
        $this->weight_actual->RowCssClass = "row";

        // lines_in_30cm
        $this->lines_in_30cm->RowCssClass = "row";

        // d_01
        $this->d_01->RowCssClass = "row";

        // d_02
        $this->d_02->RowCssClass = "row";

        // d_03
        $this->d_03->RowCssClass = "row";

        // d_04
        $this->d_04->RowCssClass = "row";

        // d_05
        $this->d_05->RowCssClass = "row";

        // d_06
        $this->d_06->RowCssClass = "row";

        // d_07
        $this->d_07->RowCssClass = "row";

        // d_08
        $this->d_08->RowCssClass = "row";

        // d_09
        $this->d_09->RowCssClass = "row";

        // d_10
        $this->d_10->RowCssClass = "row";

        // valuation
        $this->valuation->RowCssClass = "row";

        // deduction
        $this->deduction->RowCssClass = "row";

        // remark
        $this->remark->RowCssClass = "row";

        // upload
        $this->upload->RowCssClass = "row";

        // uid
        $this->uid->RowCssClass = "row";

        // payment
        $this->payment->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // process
            $this->process->ViewValue = $this->process->CurrentValue;
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // process_other
            $curVal = strval($this->process_other->CurrentValue);
            if ($curVal != "") {
                $this->process_other->ViewValue = $this->process_other->lookupCacheOption($curVal);
                if ($this->process_other->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_other->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_other->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process_other->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process_other->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process_other->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process_other->Lookup->renderViewRow($row);
                            $this->process_other->ViewValue->add($this->process_other->displayValue($arwrk));
                        }
                    } else {
                        $this->process_other->ViewValue = $this->process_other->CurrentValue;
                    }
                }
            } else {
                $this->process_other->ViewValue = null;
            }

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                        $this->location->ViewValue = $this->location->displayValue($arwrk);
                    } else {
                        $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // godown
            $curVal = strval($this->godown->CurrentValue);
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                        $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                    } else {
                        $this->godown->ViewValue = FormatNumber($this->godown->CurrentValue, $this->godown->formatPattern());
                    }
                }
            } else {
                $this->godown->ViewValue = null;
            }

            // code
            $this->code->ViewValue = $this->code->CurrentValue;
            if ($this->code->ViewValue != null) {
                $this->code->ViewValue = str_replace(["\r\n", "\n", "\r"], "<br>", $this->code->ViewValue);
            }

            // code_last
            $this->code_last->ViewValue = $this->code_last->CurrentValue;

            // employee_id
            $curVal = strval($this->employee_id->CurrentValue);
            if ($curVal != "") {
                $this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
                if ($this->employee_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->employee_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->employee_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->employee_id->Lookup->renderViewRow($row);
                            $this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
                        }
                    } else {
                        $this->employee_id->ViewValue = $this->employee_id->CurrentValue;
                    }
                }
            } else {
                $this->employee_id->ViewValue = null;
            }

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // roll_no
            $this->roll_no->ViewValue = $this->roll_no->CurrentValue;
            $this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, $this->roll_no->formatPattern());

            // size_w
            $this->size_w->ViewValue = $this->size_w->CurrentValue;
            $this->size_w->ViewValue = FormatNumber($this->size_w->ViewValue, $this->size_w->formatPattern());

            // size_l
            $this->size_l->ViewValue = $this->size_l->CurrentValue;
            $this->size_l->ViewValue = FormatNumber($this->size_l->ViewValue, $this->size_l->formatPattern());

            // size_h
            $this->size_h->ViewValue = $this->size_h->CurrentValue;
            $this->size_h->ViewValue = FormatNumber($this->size_h->ViewValue, $this->size_h->formatPattern());

            // size_actual
            $this->size_actual->ViewValue = $this->size_actual->CurrentValue;

            // weight_actual
            $this->weight_actual->ViewValue = $this->weight_actual->CurrentValue;
            $this->weight_actual->ViewValue = FormatNumber($this->weight_actual->ViewValue, $this->weight_actual->formatPattern());

            // lines_in_30cm
            $this->lines_in_30cm->ViewValue = $this->lines_in_30cm->CurrentValue;

            // d_01
            $this->d_01->ViewValue = $this->d_01->CurrentValue;

            // d_02
            $this->d_02->ViewValue = $this->d_02->CurrentValue;

            // d_03
            $this->d_03->ViewValue = $this->d_03->CurrentValue;

            // d_04
            $this->d_04->ViewValue = $this->d_04->CurrentValue;

            // d_05
            $this->d_05->ViewValue = $this->d_05->CurrentValue;

            // d_06
            $this->d_06->ViewValue = $this->d_06->CurrentValue;

            // d_07
            $this->d_07->ViewValue = $this->d_07->CurrentValue;

            // d_08
            $this->d_08->ViewValue = $this->d_08->CurrentValue;

            // d_09
            $this->d_09->ViewValue = $this->d_09->CurrentValue;

            // d_10
            $this->d_10->ViewValue = $this->d_10->CurrentValue;

            // valuation
            if (strval($this->valuation->CurrentValue) != "") {
                $this->valuation->ViewValue = $this->valuation->optionCaption($this->valuation->CurrentValue);
            } else {
                $this->valuation->ViewValue = null;
            }

            // deduction
            $this->deduction->ViewValue = $this->deduction->CurrentValue;
            $this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, $this->deduction->formatPattern());

            // remark
            $this->remark->ViewValue = $this->remark->CurrentValue;

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->ImageWidth = 0;
                $this->upload->ImageHeight = 50;
                $this->upload->ImageAlt = $this->upload->alt();
                $this->upload->ImageCssClass = "ew-image";
                $this->upload->ViewValue = $this->upload->Upload->DbValue;
            } else {
                $this->upload->ViewValue = "";
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }
            $this->process->TooltipValue = "";

            // process_other
            $this->process_other->HrefValue = "";
            $this->process_other->TooltipValue = "";

            // location
            $this->location->HrefValue = "";
            $this->location->TooltipValue = "";

            // godown
            $this->godown->HrefValue = "";
            $this->godown->TooltipValue = "";

            // code
            if (!EmptyValue($this->code->CurrentValue)) {
                $this->code->HrefValue = $this->code->getLinkPrefix() . $this->code->CurrentValue; // Add prefix/suffix
                $this->code->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->code->HrefValue = FullUrl($this->code->HrefValue, "href");
                }
            } else {
                $this->code->HrefValue = "";
            }
            $this->code->TooltipValue = "";

            // code_last
            $this->code_last->HrefValue = "";
            $this->code_last->TooltipValue = "";

            // employee_id
            $this->employee_id->HrefValue = "";
            $this->employee_id->TooltipValue = "";

            // qty
            $this->qty->HrefValue = "";
            $this->qty->TooltipValue = "";

            // roll_no
            $this->roll_no->HrefValue = "";
            $this->roll_no->TooltipValue = "";

            // size_w
            $this->size_w->HrefValue = "";
            $this->size_w->TooltipValue = "";

            // size_l
            $this->size_l->HrefValue = "";
            $this->size_l->TooltipValue = "";

            // size_h
            $this->size_h->HrefValue = "";
            $this->size_h->TooltipValue = "";

            // size_actual
            $this->size_actual->HrefValue = "";
            $this->size_actual->TooltipValue = "";

            // weight_actual
            $this->weight_actual->HrefValue = "";
            $this->weight_actual->TooltipValue = "";

            // lines_in_30cm
            $this->lines_in_30cm->HrefValue = "";
            $this->lines_in_30cm->TooltipValue = "";

            // d_01
            $this->d_01->HrefValue = "";
            $this->d_01->TooltipValue = "";

            // d_02
            $this->d_02->HrefValue = "";
            $this->d_02->TooltipValue = "";

            // d_03
            $this->d_03->HrefValue = "";
            $this->d_03->TooltipValue = "";

            // d_04
            $this->d_04->HrefValue = "";
            $this->d_04->TooltipValue = "";

            // d_05
            $this->d_05->HrefValue = "";
            $this->d_05->TooltipValue = "";

            // d_06
            $this->d_06->HrefValue = "";
            $this->d_06->TooltipValue = "";

            // d_07
            $this->d_07->HrefValue = "";
            $this->d_07->TooltipValue = "";

            // d_08
            $this->d_08->HrefValue = "";
            $this->d_08->TooltipValue = "";

            // d_09
            $this->d_09->HrefValue = "";
            $this->d_09->TooltipValue = "";

            // d_10
            $this->d_10->HrefValue = "";
            $this->d_10->TooltipValue = "";

            // valuation
            $this->valuation->HrefValue = "";
            $this->valuation->TooltipValue = "";

            // deduction
            $this->deduction->HrefValue = "";
            $this->deduction->TooltipValue = "";

            // remark
            $this->remark->HrefValue = "";
            $this->remark->TooltipValue = "";

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->HrefValue = GetFileUploadUrl($this->upload, $this->upload->htmlDecode($this->upload->Upload->DbValue)); // Add prefix/suffix
                $this->upload->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
                }
            } else {
                $this->upload->HrefValue = "";
            }
            $this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
            $this->upload->TooltipValue = "";
            if ($this->upload->UseColorbox) {
                if (EmptyValue($this->upload->TooltipValue)) {
                    $this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->upload->LinkAttrs["data-rel"] = "process_action_x_upload";
                $this->upload->LinkAttrs->appendClass("ew-lightbox");
            }

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // process
            $this->process->setupEditAttributes();
            $this->process->EditCustomAttributes = $this->process->getEditCustomAttributes(); // PHP
            $this->process->EditValue = $this->process->AdvancedSearch->SearchValue;
            $curVal = strval($this->process->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->process->EditValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->EditValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->EditValue = HtmlEncode(FormatNumber($this->process->AdvancedSearch->SearchValue, $this->process->formatPattern()));
                    }
                }
            } else {
                $this->process->EditValue = null;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // process_other
            $curVal = trim(strval($this->process_other->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->process_other->AdvancedSearch->ViewValue = $this->process_other->lookupCacheOption($curVal);
            } else {
                $this->process_other->AdvancedSearch->ViewValue = $this->process_other->Lookup !== null && is_array($this->process_other->lookupOptions()) && count($this->process_other->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process_other->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->process_other->EditValue = array_values($this->process_other->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_other->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_other->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->process_other->getSelectFilter($this); // PHP
                $sqlWrk = $this->process_other->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process_other->EditValue = $arwrk;
            }
            $this->process_other->PlaceHolder = RemoveHtml($this->process_other->caption());

            // location
            $this->location->setupEditAttributes();
            $curVal = trim(strval($this->location->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->location->AdvancedSearch->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->AdvancedSearch->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->location->AdvancedSearch->SearchValue, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // godown
            $this->godown->setupEditAttributes();
            $curVal = trim(strval($this->godown->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->godown->AdvancedSearch->ViewValue = $this->godown->lookupCacheOption($curVal);
            } else {
                $this->godown->AdvancedSearch->ViewValue = $this->godown->Lookup !== null && is_array($this->godown->lookupOptions()) && count($this->godown->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->godown->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->godown->EditValue = array_values($this->godown->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->godown->AdvancedSearch->SearchValue, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->godown->EditValue = $arwrk;
            }
            $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

            // code
            $this->code->setupEditAttributes();
            $this->code->EditCustomAttributes = $this->code->getEditCustomAttributes(); // PHP
            $this->code->EditValue = HtmlEncode($this->code->AdvancedSearch->SearchValue);
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());
            $this->code->setupEditAttributes();
            $this->code->EditCustomAttributes = $this->code->getEditCustomAttributes(); // PHP
            $this->code->EditValue2 = HtmlEncode($this->code->AdvancedSearch->SearchValue2);
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());

            // code_last
            $this->code_last->setupEditAttributes();
            $this->code_last->EditValue = HtmlEncode($this->code_last->AdvancedSearch->SearchValue);
            $this->code_last->PlaceHolder = RemoveHtml($this->code_last->caption());
            $this->code_last->setupEditAttributes();
            $this->code_last->EditValue2 = HtmlEncode($this->code_last->AdvancedSearch->SearchValue2);
            $this->code_last->PlaceHolder = RemoveHtml($this->code_last->caption());

            // employee_id
            $curVal = trim(strval($this->employee_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->employee_id->AdvancedSearch->ViewValue = $this->employee_id->lookupCacheOption($curVal);
            } else {
                $this->employee_id->AdvancedSearch->ViewValue = $this->employee_id->Lookup !== null && is_array($this->employee_id->lookupOptions()) && count($this->employee_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->employee_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->employee_id->EditValue = array_values($this->employee_id->lookupOptions());
                if ($this->employee_id->AdvancedSearch->ViewValue == "") {
                    $this->employee_id->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->employee_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->employee_id->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->employee_id->Lookup->renderViewRow($row);
                        $this->employee_id->AdvancedSearch->ViewValue->add($this->employee_id->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->employee_id->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->employee_id->Lookup->renderViewRow($row);
                }
                $this->employee_id->EditValue = $arwrk;
            }
            $this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());
            $curVal = trim(strval($this->employee_id->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->employee_id->AdvancedSearch->ViewValue2 = $this->employee_id->lookupCacheOption($curVal);
            } else {
                $this->employee_id->AdvancedSearch->ViewValue2 = $this->employee_id->Lookup !== null && is_array($this->employee_id->lookupOptions()) && count($this->employee_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->employee_id->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->employee_id->EditValue2 = array_values($this->employee_id->lookupOptions());
                if ($this->employee_id->AdvancedSearch->ViewValue2 == "") {
                    $this->employee_id->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->employee_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->employee_id->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->employee_id->Lookup->renderViewRow($row);
                        $this->employee_id->AdvancedSearch->ViewValue2->add($this->employee_id->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->employee_id->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->employee_id->Lookup->renderViewRow($row);
                }
                $this->employee_id->EditValue2 = $arwrk;
            }
            $this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());

            // qty
            $this->qty->setupEditAttributes();
            $this->qty->EditValue = $this->qty->AdvancedSearch->SearchValue;
            $this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

            // roll_no
            $this->roll_no->setupEditAttributes();
            $this->roll_no->EditValue = $this->roll_no->AdvancedSearch->SearchValue;
            $this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

            // size_w
            $this->size_w->setupEditAttributes();
            $this->size_w->EditValue = $this->size_w->AdvancedSearch->SearchValue;
            $this->size_w->PlaceHolder = RemoveHtml($this->size_w->caption());

            // size_l
            $this->size_l->setupEditAttributes();
            $this->size_l->EditValue = $this->size_l->AdvancedSearch->SearchValue;
            $this->size_l->PlaceHolder = RemoveHtml($this->size_l->caption());

            // size_h
            $this->size_h->setupEditAttributes();
            $this->size_h->EditValue = $this->size_h->AdvancedSearch->SearchValue;
            $this->size_h->PlaceHolder = RemoveHtml($this->size_h->caption());

            // size_actual
            $this->size_actual->setupEditAttributes();
            if (!$this->size_actual->Raw) {
                $this->size_actual->AdvancedSearch->SearchValue = HtmlDecode($this->size_actual->AdvancedSearch->SearchValue);
            }
            $this->size_actual->EditValue = HtmlEncode($this->size_actual->AdvancedSearch->SearchValue);
            $this->size_actual->PlaceHolder = RemoveHtml($this->size_actual->caption());

            // weight_actual
            $this->weight_actual->setupEditAttributes();
            $this->weight_actual->EditValue = $this->weight_actual->AdvancedSearch->SearchValue;
            $this->weight_actual->PlaceHolder = RemoveHtml($this->weight_actual->caption());

            // lines_in_30cm
            $this->lines_in_30cm->setupEditAttributes();
            if (!$this->lines_in_30cm->Raw) {
                $this->lines_in_30cm->AdvancedSearch->SearchValue = HtmlDecode($this->lines_in_30cm->AdvancedSearch->SearchValue);
            }
            $this->lines_in_30cm->EditValue = HtmlEncode($this->lines_in_30cm->AdvancedSearch->SearchValue);
            $this->lines_in_30cm->PlaceHolder = RemoveHtml($this->lines_in_30cm->caption());

            // d_01
            $this->d_01->setupEditAttributes();
            if (!$this->d_01->Raw) {
                $this->d_01->AdvancedSearch->SearchValue = HtmlDecode($this->d_01->AdvancedSearch->SearchValue);
            }
            $this->d_01->EditValue = HtmlEncode($this->d_01->AdvancedSearch->SearchValue);
            $this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());

            // d_02
            $this->d_02->setupEditAttributes();
            if (!$this->d_02->Raw) {
                $this->d_02->AdvancedSearch->SearchValue = HtmlDecode($this->d_02->AdvancedSearch->SearchValue);
            }
            $this->d_02->EditValue = HtmlEncode($this->d_02->AdvancedSearch->SearchValue);
            $this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());

            // d_03
            $this->d_03->setupEditAttributes();
            if (!$this->d_03->Raw) {
                $this->d_03->AdvancedSearch->SearchValue = HtmlDecode($this->d_03->AdvancedSearch->SearchValue);
            }
            $this->d_03->EditValue = HtmlEncode($this->d_03->AdvancedSearch->SearchValue);
            $this->d_03->PlaceHolder = RemoveHtml($this->d_03->caption());

            // d_04
            $this->d_04->setupEditAttributes();
            if (!$this->d_04->Raw) {
                $this->d_04->AdvancedSearch->SearchValue = HtmlDecode($this->d_04->AdvancedSearch->SearchValue);
            }
            $this->d_04->EditValue = HtmlEncode($this->d_04->AdvancedSearch->SearchValue);
            $this->d_04->PlaceHolder = RemoveHtml($this->d_04->caption());

            // d_05
            $this->d_05->setupEditAttributes();
            if (!$this->d_05->Raw) {
                $this->d_05->AdvancedSearch->SearchValue = HtmlDecode($this->d_05->AdvancedSearch->SearchValue);
            }
            $this->d_05->EditValue = HtmlEncode($this->d_05->AdvancedSearch->SearchValue);
            $this->d_05->PlaceHolder = RemoveHtml($this->d_05->caption());

            // d_06
            $this->d_06->setupEditAttributes();
            if (!$this->d_06->Raw) {
                $this->d_06->AdvancedSearch->SearchValue = HtmlDecode($this->d_06->AdvancedSearch->SearchValue);
            }
            $this->d_06->EditValue = HtmlEncode($this->d_06->AdvancedSearch->SearchValue);
            $this->d_06->PlaceHolder = RemoveHtml($this->d_06->caption());

            // d_07
            $this->d_07->setupEditAttributes();
            if (!$this->d_07->Raw) {
                $this->d_07->AdvancedSearch->SearchValue = HtmlDecode($this->d_07->AdvancedSearch->SearchValue);
            }
            $this->d_07->EditValue = HtmlEncode($this->d_07->AdvancedSearch->SearchValue);
            $this->d_07->PlaceHolder = RemoveHtml($this->d_07->caption());

            // d_08
            $this->d_08->setupEditAttributes();
            if (!$this->d_08->Raw) {
                $this->d_08->AdvancedSearch->SearchValue = HtmlDecode($this->d_08->AdvancedSearch->SearchValue);
            }
            $this->d_08->EditValue = HtmlEncode($this->d_08->AdvancedSearch->SearchValue);
            $this->d_08->PlaceHolder = RemoveHtml($this->d_08->caption());

            // d_09
            $this->d_09->setupEditAttributes();
            if (!$this->d_09->Raw) {
                $this->d_09->AdvancedSearch->SearchValue = HtmlDecode($this->d_09->AdvancedSearch->SearchValue);
            }
            $this->d_09->EditValue = HtmlEncode($this->d_09->AdvancedSearch->SearchValue);
            $this->d_09->PlaceHolder = RemoveHtml($this->d_09->caption());

            // d_10
            $this->d_10->setupEditAttributes();
            if (!$this->d_10->Raw) {
                $this->d_10->AdvancedSearch->SearchValue = HtmlDecode($this->d_10->AdvancedSearch->SearchValue);
            }
            $this->d_10->EditValue = HtmlEncode($this->d_10->AdvancedSearch->SearchValue);
            $this->d_10->PlaceHolder = RemoveHtml($this->d_10->caption());

            // valuation
            $this->valuation->setupEditAttributes();
            $this->valuation->EditValue = $this->valuation->options(true);
            $this->valuation->PlaceHolder = RemoveHtml($this->valuation->caption());

            // deduction
            $this->deduction->setupEditAttributes();
            $this->deduction->EditValue = $this->deduction->AdvancedSearch->SearchValue;
            $this->deduction->PlaceHolder = RemoveHtml($this->deduction->caption());

            // remark
            $this->remark->setupEditAttributes();
            if (!$this->remark->Raw) {
                $this->remark->AdvancedSearch->SearchValue = HtmlDecode($this->remark->AdvancedSearch->SearchValue);
            }
            $this->remark->EditValue = HtmlEncode($this->remark->AdvancedSearch->SearchValue);
            $this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

            // upload
            $this->upload->setupEditAttributes();
            if (!$this->upload->Raw) {
                $this->upload->AdvancedSearch->SearchValue = HtmlDecode($this->upload->AdvancedSearch->SearchValue);
            }
            $this->upload->EditValue = HtmlEncode($this->upload->AdvancedSearch->SearchValue);
            $this->upload->PlaceHolder = RemoveHtml($this->upload->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->process->AdvancedSearch->SearchValue)) {
            $this->process->addErrorMessage($this->process->getErrorMessage(false));
        }
        if (!CheckInteger($this->size_w->AdvancedSearch->SearchValue)) {
            $this->size_w->addErrorMessage($this->size_w->getErrorMessage(false));
        }
        if (!CheckInteger($this->size_l->AdvancedSearch->SearchValue)) {
            $this->size_l->addErrorMessage($this->size_l->getErrorMessage(false));
        }
        if (!CheckInteger($this->size_h->AdvancedSearch->SearchValue)) {
            $this->size_h->addErrorMessage($this->size_h->getErrorMessage(false));
        }
        if (!CheckNumber($this->weight_actual->AdvancedSearch->SearchValue)) {
            $this->weight_actual->addErrorMessage($this->weight_actual->getErrorMessage(false));
        }
        if (!CheckNumber($this->lines_in_30cm->AdvancedSearch->SearchValue)) {
            $this->lines_in_30cm->addErrorMessage($this->lines_in_30cm->getErrorMessage(false));
        }
        if (!CheckNumber($this->deduction->AdvancedSearch->SearchValue)) {
            $this->deduction->addErrorMessage($this->deduction->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->process->AdvancedSearch->load();
        $this->process_other->AdvancedSearch->load();
        $this->location->AdvancedSearch->load();
        $this->godown->AdvancedSearch->load();
        $this->code->AdvancedSearch->load();
        $this->code_last->AdvancedSearch->load();
        $this->employee_id->AdvancedSearch->load();
        $this->qty->AdvancedSearch->load();
        $this->roll_no->AdvancedSearch->load();
        $this->size_w->AdvancedSearch->load();
        $this->size_l->AdvancedSearch->load();
        $this->size_h->AdvancedSearch->load();
        $this->size_actual->AdvancedSearch->load();
        $this->weight_actual->AdvancedSearch->load();
        $this->lines_in_30cm->AdvancedSearch->load();
        $this->d_01->AdvancedSearch->load();
        $this->d_02->AdvancedSearch->load();
        $this->d_03->AdvancedSearch->load();
        $this->d_04->AdvancedSearch->load();
        $this->d_05->AdvancedSearch->load();
        $this->d_06->AdvancedSearch->load();
        $this->d_07->AdvancedSearch->load();
        $this->d_08->AdvancedSearch->load();
        $this->d_09->AdvancedSearch->load();
        $this->d_10->AdvancedSearch->load();
        $this->valuation->AdvancedSearch->load();
        $this->deduction->AdvancedSearch->load();
        $this->remark->AdvancedSearch->load();
        $this->upload->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("processactionlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_confirm_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_other":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_godown":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_employee_1":
                    break;
                case "x_employee_2":
                    break;
                case "x_employee_3":
                    break;
                case "x_employee_id":
                    break;
                case "x_valuation":
                    break;
                case "x_payment":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'process_action');	
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
