<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProcessActionPaymentSearch extends ProcessActionPayment
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProcessActionPaymentSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "processactionpaymentsearch";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->location->setVisibility();
        $this->process->setVisibility();
        $this->emp_id->setVisibility();
        $this->emp_grp->Visible = false;
        $this->code->setVisibility();
        $this->ref->setVisibility();
        $this->size_wl->setVisibility();
        $this->process_->setVisibility();
        $this->final_amount->setVisibility();
        $this->amount->setVisibility();
        $this->c_charge->setVisibility();
        $this->c_id->setVisibility();
        $this->custom_size->setVisibility();
        $this->ded_jc->setVisibility();
        $this->ded_pa->setVisibility();
        $this->payment_type->setVisibility();
        $this->sqm->setVisibility();
        $this->sqm_grp->setVisibility();
        $this->_2_srm->setVisibility();
        $this->_4_srm->setVisibility();
        $this->process_fix->setVisibility();
        $this->method->setVisibility();
        $this->datetime->setVisibility();
        $this->payment->setVisibility();
        $this->grp->setVisibility();
        $this->remark->setVisibility();
        $this->pps->setVisibility();
        $this->category->setVisibility();
        $this->c_method->setVisibility();
        $this->uid->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'process_action_payment';
        $this->TableName = 'process_action_payment';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (process_action_payment)
        if (!isset($GLOBALS["process_action_payment"]) || $GLOBALS["process_action_payment"]::class == PROJECT_NAMESPACE . "process_action_payment") {
            $GLOBALS["process_action_payment"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_action_payment');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "processactionpaymentview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->emp_id);
        $this->setupLookupOptions($this->ref);
        $this->setupLookupOptions($this->c_id);
        $this->setupLookupOptions($this->payment_type);
        $this->setupLookupOptions($this->process_fix);
        $this->setupLookupOptions($this->method);
        $this->setupLookupOptions($this->payment);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->c_method);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "processactionpaymentlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->location); // location
        $this->buildSearchUrl($srchUrl, $this->process); // process
        $this->buildSearchUrl($srchUrl, $this->emp_id); // emp_id
        $this->buildSearchUrl($srchUrl, $this->code); // code
        $this->buildSearchUrl($srchUrl, $this->ref); // ref
        $this->buildSearchUrl($srchUrl, $this->size_wl); // size_wl
        $this->buildSearchUrl($srchUrl, $this->process_); // process_@
        $this->buildSearchUrl($srchUrl, $this->final_amount); // final_amount
        $this->buildSearchUrl($srchUrl, $this->amount); // amount
        $this->buildSearchUrl($srchUrl, $this->c_charge); // c_charge
        $this->buildSearchUrl($srchUrl, $this->c_id); // c_id
        $this->buildSearchUrl($srchUrl, $this->custom_size); // custom_size
        $this->buildSearchUrl($srchUrl, $this->ded_jc); // ded_jc
        $this->buildSearchUrl($srchUrl, $this->ded_pa); // ded_pa
        $this->buildSearchUrl($srchUrl, $this->payment_type); // payment_type
        $this->buildSearchUrl($srchUrl, $this->sqm); // sqm
        $this->buildSearchUrl($srchUrl, $this->sqm_grp); // sqm_grp
        $this->buildSearchUrl($srchUrl, $this->_2_srm); // 2_srm
        $this->buildSearchUrl($srchUrl, $this->_4_srm); // 4_srm
        $this->buildSearchUrl($srchUrl, $this->process_fix); // process_fix
        $this->buildSearchUrl($srchUrl, $this->method); // method
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->payment); // payment
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->remark); // remark
        $this->buildSearchUrl($srchUrl, $this->pps); // pps
        $this->buildSearchUrl($srchUrl, $this->category); // category
        $this->buildSearchUrl($srchUrl, $this->c_method); // c_method
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // location
        if ($this->location->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // process
        if ($this->process->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // emp_id
        if ($this->emp_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // code
        if ($this->code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ref
        if ($this->ref->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // size_wl
        if ($this->size_wl->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // process_@
        if ($this->process_->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // final_amount
        if ($this->final_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // amount
        if ($this->amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // c_charge
        if ($this->c_charge->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // c_id
        if ($this->c_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // custom_size
        if ($this->custom_size->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ded_jc
        if ($this->ded_jc->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ded_pa
        if ($this->ded_pa->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // payment_type
        if ($this->payment_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sqm
        if ($this->sqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sqm_grp
        if ($this->sqm_grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 2_srm
        if ($this->_2_srm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 4_srm
        if ($this->_4_srm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // process_fix
        if ($this->process_fix->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // method
        if ($this->method->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // payment
        if ($this->payment->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->payment->AdvancedSearch->SearchValue)) {
            $this->payment->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->payment->AdvancedSearch->SearchValue);
        }
        if (is_array($this->payment->AdvancedSearch->SearchValue2)) {
            $this->payment->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->payment->AdvancedSearch->SearchValue2);
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remark
        if ($this->remark->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pps
        if ($this->pps->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // c_method
        if ($this->c_method->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // emp_id
        $this->emp_id->RowCssClass = "row";

        // emp_grp
        $this->emp_grp->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // ref
        $this->ref->RowCssClass = "row";

        // size_wl
        $this->size_wl->RowCssClass = "row";

        // process_@
        $this->process_->RowCssClass = "row";

        // final_amount
        $this->final_amount->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // c_charge
        $this->c_charge->RowCssClass = "row";

        // c_id
        $this->c_id->RowCssClass = "row";

        // custom_size
        $this->custom_size->RowCssClass = "row";

        // ded_jc
        $this->ded_jc->RowCssClass = "row";

        // ded_pa
        $this->ded_pa->RowCssClass = "row";

        // payment_type
        $this->payment_type->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // sqm_grp
        $this->sqm_grp->RowCssClass = "row";

        // 2_srm
        $this->_2_srm->RowCssClass = "row";

        // 4_srm
        $this->_4_srm->RowCssClass = "row";

        // process_fix
        $this->process_fix->RowCssClass = "row";

        // method
        $this->method->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // payment
        $this->payment->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // remark
        $this->remark->RowCssClass = "row";

        // pps
        $this->pps->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // c_method
        $this->c_method->RowCssClass = "row";

        // uid
        $this->uid->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                        $this->location->ViewValue = $this->location->displayValue($arwrk);
                    } else {
                        $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // emp_id
            $curVal = strval($this->emp_id->CurrentValue);
            if ($curVal != "") {
                $this->emp_id->ViewValue = $this->emp_id->lookupCacheOption($curVal);
                if ($this->emp_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->emp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->emp_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->emp_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->emp_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->emp_id->Lookup->renderViewRow($rswrk[0]);
                        $this->emp_id->ViewValue = $this->emp_id->displayValue($arwrk);
                    } else {
                        $this->emp_id->ViewValue = FormatNumber($this->emp_id->CurrentValue, $this->emp_id->formatPattern());
                    }
                }
            } else {
                $this->emp_id->ViewValue = null;
            }

            // emp_grp
            $this->emp_grp->ViewValue = $this->emp_grp->CurrentValue;

            // code
            $this->code->ViewValue = $this->code->CurrentValue;
            $this->code->ViewValue = FormatNumber($this->code->ViewValue, $this->code->formatPattern());

            // ref
            $curVal = strval($this->ref->CurrentValue);
            if ($curVal != "") {
                $this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
                if ($this->ref->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ref->Lookup->renderViewRow($rswrk[0]);
                        $this->ref->ViewValue = $this->ref->displayValue($arwrk);
                    } else {
                        $this->ref->ViewValue = $this->ref->CurrentValue;
                    }
                }
            } else {
                $this->ref->ViewValue = null;
            }

            // size_wl
            $this->size_wl->ViewValue = $this->size_wl->CurrentValue;

            // process_@
            $this->process_->ViewValue = $this->process_->CurrentValue;
            $this->process_->ViewValue = FormatNumber($this->process_->ViewValue, $this->process_->formatPattern());

            // final_amount
            $this->final_amount->ViewValue = $this->final_amount->CurrentValue;
            $this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, $this->final_amount->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // c_charge
            $this->c_charge->ViewValue = $this->c_charge->CurrentValue;
            $this->c_charge->ViewValue = FormatNumber($this->c_charge->ViewValue, $this->c_charge->formatPattern());

            // c_id
            $curVal = strval($this->c_id->CurrentValue);
            if ($curVal != "") {
                $this->c_id->ViewValue = $this->c_id->lookupCacheOption($curVal);
                if ($this->c_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->c_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->c_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->c_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->c_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->c_id->Lookup->renderViewRow($rswrk[0]);
                        $this->c_id->ViewValue = $this->c_id->displayValue($arwrk);
                    } else {
                        $this->c_id->ViewValue = FormatNumber($this->c_id->CurrentValue, $this->c_id->formatPattern());
                    }
                }
            } else {
                $this->c_id->ViewValue = null;
            }

            // custom_size
            $this->custom_size->ViewValue = $this->custom_size->CurrentValue;
            $this->custom_size->ViewValue = FormatNumber($this->custom_size->ViewValue, $this->custom_size->formatPattern());

            // ded_jc
            $this->ded_jc->ViewValue = $this->ded_jc->CurrentValue;
            $this->ded_jc->ViewValue = FormatNumber($this->ded_jc->ViewValue, $this->ded_jc->formatPattern());

            // ded_pa
            $this->ded_pa->ViewValue = $this->ded_pa->CurrentValue;
            $this->ded_pa->ViewValue = FormatNumber($this->ded_pa->ViewValue, $this->ded_pa->formatPattern());

            // payment_type
            if (strval($this->payment_type->CurrentValue) != "") {
                $this->payment_type->ViewValue = $this->payment_type->optionCaption($this->payment_type->CurrentValue);
            } else {
                $this->payment_type->ViewValue = null;
            }

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // sqm_grp
            $this->sqm_grp->ViewValue = $this->sqm_grp->CurrentValue;
            $this->sqm_grp->ViewValue = FormatNumber($this->sqm_grp->ViewValue, $this->sqm_grp->formatPattern());

            // 2_srm
            $this->_2_srm->ViewValue = $this->_2_srm->CurrentValue;
            $this->_2_srm->ViewValue = FormatNumber($this->_2_srm->ViewValue, $this->_2_srm->formatPattern());

            // 4_srm
            $this->_4_srm->ViewValue = $this->_4_srm->CurrentValue;
            $this->_4_srm->ViewValue = FormatNumber($this->_4_srm->ViewValue, $this->_4_srm->formatPattern());

            // process_fix
            if (strval($this->process_fix->CurrentValue) != "") {
                $this->process_fix->ViewValue = $this->process_fix->optionCaption($this->process_fix->CurrentValue);
            } else {
                $this->process_fix->ViewValue = null;
            }

            // method
            if (strval($this->method->CurrentValue) != "") {
                $this->method->ViewValue = $this->method->optionCaption($this->method->CurrentValue);
            } else {
                $this->method->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // payment
            $curVal = strval($this->payment->CurrentValue);
            if ($curVal != "") {
                $this->payment->ViewValue = $this->payment->lookupCacheOption($curVal);
                if ($this->payment->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->payment->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->payment->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->payment->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->payment->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->payment->Lookup->renderViewRow($row);
                            $this->payment->ViewValue->add($this->payment->displayValue($arwrk));
                        }
                    } else {
                        $this->payment->ViewValue = $this->payment->CurrentValue;
                    }
                }
            } else {
                $this->payment->ViewValue = null;
            }

            // grp
            $this->grp->ViewValue = $this->grp->CurrentValue;
            $this->grp->ViewValue = FormatNumber($this->grp->ViewValue, $this->grp->formatPattern());

            // remark
            $this->remark->ViewValue = $this->remark->CurrentValue;

            // pps
            $this->pps->ViewValue = $this->pps->CurrentValue;
            $this->pps->ViewValue = FormatNumber($this->pps->ViewValue, $this->pps->formatPattern());

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // c_method
            $this->c_method->ViewValue = $this->c_method->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // location
            $this->location->HrefValue = "";
            $this->location->TooltipValue = "";

            // process
            $this->process->HrefValue = "";
            $this->process->TooltipValue = "";

            // emp_id
            $this->emp_id->HrefValue = "";
            $this->emp_id->TooltipValue = "";

            // code
            $this->code->HrefValue = "";
            $this->code->TooltipValue = "";

            // ref
            $this->ref->HrefValue = "";
            $this->ref->TooltipValue = "";

            // size_wl
            $this->size_wl->HrefValue = "";
            $this->size_wl->TooltipValue = "";

            // process_@
            $this->process_->HrefValue = "";
            $this->process_->TooltipValue = "";

            // final_amount
            $this->final_amount->HrefValue = "";
            $this->final_amount->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // c_charge
            $this->c_charge->HrefValue = "";
            $this->c_charge->TooltipValue = "";

            // c_id
            $this->c_id->HrefValue = "";
            $this->c_id->TooltipValue = "";

            // custom_size
            $this->custom_size->HrefValue = "";
            $this->custom_size->TooltipValue = "";

            // ded_jc
            $this->ded_jc->HrefValue = "";
            $this->ded_jc->TooltipValue = "";

            // ded_pa
            $this->ded_pa->HrefValue = "";
            $this->ded_pa->TooltipValue = "";

            // payment_type
            $this->payment_type->HrefValue = "";
            $this->payment_type->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // sqm_grp
            $this->sqm_grp->HrefValue = "";
            $this->sqm_grp->TooltipValue = "";

            // 2_srm
            $this->_2_srm->HrefValue = "";
            $this->_2_srm->TooltipValue = "";

            // 4_srm
            $this->_4_srm->HrefValue = "";
            $this->_4_srm->TooltipValue = "";

            // process_fix
            $this->process_fix->HrefValue = "";
            $this->process_fix->TooltipValue = "";

            // method
            $this->method->HrefValue = "";
            $this->method->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // payment
            $this->payment->HrefValue = "";
            $this->payment->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // remark
            $this->remark->HrefValue = "";
            $this->remark->TooltipValue = "";

            // pps
            $this->pps->HrefValue = "";
            $this->pps->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // c_method
            $this->c_method->HrefValue = "";
            $this->c_method->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // location
            $this->location->setupEditAttributes();
            $curVal = trim(strval($this->location->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->location->AdvancedSearch->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->AdvancedSearch->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->location->AdvancedSearch->SearchValue, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // process
            $this->process->setupEditAttributes();
            $curVal = trim(strval($this->process->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->process->AdvancedSearch->ViewValue = $this->process->lookupCacheOption($curVal);
            } else {
                $this->process->AdvancedSearch->ViewValue = $this->process->Lookup !== null && is_array($this->process->lookupOptions()) && count($this->process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->process->EditValue = array_values($this->process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->process->AdvancedSearch->SearchValue, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process->EditValue = $arwrk;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // emp_id
            $this->emp_id->setupEditAttributes();
            $curVal = trim(strval($this->emp_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->emp_id->AdvancedSearch->ViewValue = $this->emp_id->lookupCacheOption($curVal);
            } else {
                $this->emp_id->AdvancedSearch->ViewValue = $this->emp_id->Lookup !== null && is_array($this->emp_id->lookupOptions()) && count($this->emp_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->emp_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->emp_id->EditValue = array_values($this->emp_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->emp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->emp_id->AdvancedSearch->SearchValue, $this->emp_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->emp_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->emp_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->emp_id->Lookup->renderViewRow($row);
                }
                $this->emp_id->EditValue = $arwrk;
            }
            $this->emp_id->PlaceHolder = RemoveHtml($this->emp_id->caption());

            // code
            $this->code->setupEditAttributes();
            $this->code->EditValue = $this->code->AdvancedSearch->SearchValue;
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());
            $this->code->setupEditAttributes();
            $this->code->EditValue2 = $this->code->AdvancedSearch->SearchValue2;
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());

            // ref
            $this->ref->setupEditAttributes();
            $curVal = trim(strval($this->ref->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->ref->AdvancedSearch->ViewValue = $this->ref->lookupCacheOption($curVal);
            } else {
                $this->ref->AdvancedSearch->ViewValue = $this->ref->Lookup !== null && is_array($this->ref->lookupOptions()) && count($this->ref->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ref->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->ref->EditValue = array_values($this->ref->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->ref->AdvancedSearch->SearchValue, $this->ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->ref->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->ref->EditValue = $arwrk;
            }
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

            // size_wl
            $this->size_wl->setupEditAttributes();
            if (!$this->size_wl->Raw) {
                $this->size_wl->AdvancedSearch->SearchValue = HtmlDecode($this->size_wl->AdvancedSearch->SearchValue);
            }
            $this->size_wl->EditValue = HtmlEncode($this->size_wl->AdvancedSearch->SearchValue);
            $this->size_wl->PlaceHolder = RemoveHtml($this->size_wl->caption());

            // process_@
            $this->process_->setupEditAttributes();
            $this->process_->EditValue = $this->process_->AdvancedSearch->SearchValue;
            $this->process_->PlaceHolder = RemoveHtml($this->process_->caption());

            // final_amount
            $this->final_amount->setupEditAttributes();
            $this->final_amount->EditValue = $this->final_amount->AdvancedSearch->SearchValue;
            $this->final_amount->PlaceHolder = RemoveHtml($this->final_amount->caption());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->AdvancedSearch->SearchValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

            // c_charge
            $this->c_charge->setupEditAttributes();
            $this->c_charge->EditValue = $this->c_charge->AdvancedSearch->SearchValue;
            $this->c_charge->PlaceHolder = RemoveHtml($this->c_charge->caption());

            // c_id
            $this->c_id->setupEditAttributes();
            $curVal = trim(strval($this->c_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->c_id->AdvancedSearch->ViewValue = $this->c_id->lookupCacheOption($curVal);
            } else {
                $this->c_id->AdvancedSearch->ViewValue = $this->c_id->Lookup !== null && is_array($this->c_id->lookupOptions()) && count($this->c_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->c_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->c_id->EditValue = array_values($this->c_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->c_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->c_id->AdvancedSearch->SearchValue, $this->c_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->c_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->c_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->c_id->Lookup->renderViewRow($row);
                }
                $this->c_id->EditValue = $arwrk;
            }
            $this->c_id->PlaceHolder = RemoveHtml($this->c_id->caption());

            // custom_size
            $this->custom_size->setupEditAttributes();
            $this->custom_size->EditValue = $this->custom_size->AdvancedSearch->SearchValue;
            $this->custom_size->PlaceHolder = RemoveHtml($this->custom_size->caption());

            // ded_jc
            $this->ded_jc->setupEditAttributes();
            $this->ded_jc->EditValue = $this->ded_jc->AdvancedSearch->SearchValue;
            $this->ded_jc->PlaceHolder = RemoveHtml($this->ded_jc->caption());

            // ded_pa
            $this->ded_pa->setupEditAttributes();
            $this->ded_pa->EditValue = $this->ded_pa->AdvancedSearch->SearchValue;
            $this->ded_pa->PlaceHolder = RemoveHtml($this->ded_pa->caption());

            // payment_type
            $this->payment_type->setupEditAttributes();
            $this->payment_type->EditValue = $this->payment_type->options(true);
            $this->payment_type->PlaceHolder = RemoveHtml($this->payment_type->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->AdvancedSearch->SearchValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

            // sqm_grp
            $this->sqm_grp->setupEditAttributes();
            $this->sqm_grp->EditValue = $this->sqm_grp->AdvancedSearch->SearchValue;
            $this->sqm_grp->PlaceHolder = RemoveHtml($this->sqm_grp->caption());

            // 2_srm
            $this->_2_srm->setupEditAttributes();
            $this->_2_srm->EditValue = $this->_2_srm->AdvancedSearch->SearchValue;
            $this->_2_srm->PlaceHolder = RemoveHtml($this->_2_srm->caption());

            // 4_srm
            $this->_4_srm->setupEditAttributes();
            $this->_4_srm->EditValue = $this->_4_srm->AdvancedSearch->SearchValue;
            $this->_4_srm->PlaceHolder = RemoveHtml($this->_4_srm->caption());

            // process_fix
            $this->process_fix->setupEditAttributes();
            $this->process_fix->EditValue = $this->process_fix->options(true);
            $this->process_fix->PlaceHolder = RemoveHtml($this->process_fix->caption());

            // method
            $this->method->setupEditAttributes();
            $this->method->EditValue = $this->method->options(true);
            $this->method->PlaceHolder = RemoveHtml($this->method->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // payment
            $curVal = trim(strval($this->payment->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->payment->AdvancedSearch->ViewValue = $this->payment->lookupCacheOption($curVal);
            } else {
                $this->payment->AdvancedSearch->ViewValue = $this->payment->Lookup !== null && is_array($this->payment->lookupOptions()) && count($this->payment->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->payment->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->payment->EditValue = array_values($this->payment->lookupOptions());
                if ($this->payment->AdvancedSearch->ViewValue == "") {
                    $this->payment->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->payment->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->payment->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->payment->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->payment->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->payment->Lookup->renderViewRow($row);
                        $this->payment->AdvancedSearch->ViewValue->add($this->payment->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->payment->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->payment->EditValue = $arwrk;
            }
            $this->payment->PlaceHolder = RemoveHtml($this->payment->caption());
            $curVal = trim(strval($this->payment->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->payment->AdvancedSearch->ViewValue2 = $this->payment->lookupCacheOption($curVal);
            } else {
                $this->payment->AdvancedSearch->ViewValue2 = $this->payment->Lookup !== null && is_array($this->payment->lookupOptions()) && count($this->payment->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->payment->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->payment->EditValue2 = array_values($this->payment->lookupOptions());
                if ($this->payment->AdvancedSearch->ViewValue2 == "") {
                    $this->payment->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->payment->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->payment->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->payment->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->payment->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->payment->Lookup->renderViewRow($row);
                        $this->payment->AdvancedSearch->ViewValue2->add($this->payment->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->payment->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->payment->EditValue2 = $arwrk;
            }
            $this->payment->PlaceHolder = RemoveHtml($this->payment->caption());

            // grp
            $this->grp->setupEditAttributes();
            $this->grp->EditValue = $this->grp->AdvancedSearch->SearchValue;
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // remark
            $this->remark->setupEditAttributes();
            if (!$this->remark->Raw) {
                $this->remark->AdvancedSearch->SearchValue = HtmlDecode($this->remark->AdvancedSearch->SearchValue);
            }
            $this->remark->EditValue = HtmlEncode($this->remark->AdvancedSearch->SearchValue);
            $this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

            // pps
            $this->pps->setupEditAttributes();
            $this->pps->EditValue = $this->pps->AdvancedSearch->SearchValue;
            $this->pps->PlaceHolder = RemoveHtml($this->pps->caption());

            // category
            $this->category->setupEditAttributes();
            $curVal = trim(strval($this->category->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->category->AdvancedSearch->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->AdvancedSearch->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->category->AdvancedSearch->SearchValue, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // c_method
            $this->c_method->setupEditAttributes();
            $this->c_method->EditValue = $this->c_method->AdvancedSearch->SearchValue;
            $this->c_method->PlaceHolder = RemoveHtml($this->c_method->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckNumber($this->code->AdvancedSearch->SearchValue)) {
            $this->code->addErrorMessage($this->code->getErrorMessage(false));
        }
        if (!CheckNumber($this->code->AdvancedSearch->SearchValue2)) {
            $this->code->addErrorMessage($this->code->getErrorMessage(false));
        }
        if (!CheckInteger($this->size_wl->AdvancedSearch->SearchValue)) {
            $this->size_wl->addErrorMessage($this->size_wl->getErrorMessage(false));
        }
        if (!CheckInteger($this->process_->AdvancedSearch->SearchValue)) {
            $this->process_->addErrorMessage($this->process_->getErrorMessage(false));
        }
        if (!CheckNumber($this->final_amount->AdvancedSearch->SearchValue)) {
            $this->final_amount->addErrorMessage($this->final_amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->amount->AdvancedSearch->SearchValue)) {
            $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->c_charge->AdvancedSearch->SearchValue)) {
            $this->c_charge->addErrorMessage($this->c_charge->getErrorMessage(false));
        }
        if (!CheckNumber($this->custom_size->AdvancedSearch->SearchValue)) {
            $this->custom_size->addErrorMessage($this->custom_size->getErrorMessage(false));
        }
        if (!CheckNumber($this->ded_jc->AdvancedSearch->SearchValue)) {
            $this->ded_jc->addErrorMessage($this->ded_jc->getErrorMessage(false));
        }
        if (!CheckNumber($this->ded_pa->AdvancedSearch->SearchValue)) {
            $this->ded_pa->addErrorMessage($this->ded_pa->getErrorMessage(false));
        }
        if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
            $this->sqm->addErrorMessage($this->sqm->getErrorMessage(false));
        }
        if (!CheckNumber($this->sqm_grp->AdvancedSearch->SearchValue)) {
            $this->sqm_grp->addErrorMessage($this->sqm_grp->getErrorMessage(false));
        }
        if (!CheckInteger($this->_2_srm->AdvancedSearch->SearchValue)) {
            $this->_2_srm->addErrorMessage($this->_2_srm->getErrorMessage(false));
        }
        if (!CheckInteger($this->_4_srm->AdvancedSearch->SearchValue)) {
            $this->_4_srm->addErrorMessage($this->_4_srm->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->grp->AdvancedSearch->SearchValue)) {
            $this->grp->addErrorMessage($this->grp->getErrorMessage(false));
        }
        if (!CheckInteger($this->pps->AdvancedSearch->SearchValue)) {
            $this->pps->addErrorMessage($this->pps->getErrorMessage(false));
        }
        if (!CheckInteger($this->c_method->AdvancedSearch->SearchValue)) {
            $this->c_method->addErrorMessage($this->c_method->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->location->AdvancedSearch->load();
        $this->process->AdvancedSearch->load();
        $this->emp_id->AdvancedSearch->load();
        $this->code->AdvancedSearch->load();
        $this->ref->AdvancedSearch->load();
        $this->size_wl->AdvancedSearch->load();
        $this->process_->AdvancedSearch->load();
        $this->final_amount->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->c_charge->AdvancedSearch->load();
        $this->c_id->AdvancedSearch->load();
        $this->custom_size->AdvancedSearch->load();
        $this->ded_jc->AdvancedSearch->load();
        $this->ded_pa->AdvancedSearch->load();
        $this->payment_type->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->sqm_grp->AdvancedSearch->load();
        $this->_2_srm->AdvancedSearch->load();
        $this->_4_srm->AdvancedSearch->load();
        $this->process_fix->AdvancedSearch->load();
        $this->method->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->payment->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->remark->AdvancedSearch->load();
        $this->pps->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->c_method->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("processactionpaymentlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_emp_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_ref":
                    break;
                case "x_c_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_payment_type":
                    break;
                case "x_process_fix":
                    break;
                case "x_method":
                    break;
                case "x_payment":
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_c_method":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
