<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for process_action_payment_pe
 */
class ProcessActionPaymentPe extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $location;
    public $process;
    public $emp_id;
    public $contractor;
    public $qty;
    public $sqm;
    public $amount;
    public $payment;
    public $remarks;
    public $url;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "process_action_payment_pe";
        $this->TableName = 'process_action_payment_pe';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "process_action_payment_pe";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // location
        $this->location = new DbField(
            $this, // Table
            'x_location', // Variable name
            'location', // Name
            '`location`', // Expression
            '`location`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`location`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->location->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->location->InputTextType = "text";
        $this->location->Raw = true;
        $this->location->setSelectMultiple(false); // Select one
        $this->location->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->location->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->location->Lookup = new Lookup($this->location, 'godown_table', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->location->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->location->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['location'] = &$this->location;

        // process
        $this->process = new DbField(
            $this, // Table
            'x_process', // Variable name
            'process', // Name
            '`process`', // Expression
            '`process`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->process->addMethod("getLinkPrefix", fn() => "processactionpaymentpelist?x_process=");
        $this->process->InputTextType = "text";
        $this->process->Raw = true;
        $this->process->setSelectMultiple(false); // Select one
        $this->process->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->process->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->process->Lookup = new Lookup($this->process, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['process'] = &$this->process;

        // emp_id
        $this->emp_id = new DbField(
            $this, // Table
            'x_emp_id', // Variable name
            'emp_id', // Name
            '`emp_id`', // Expression
            '`emp_id`', // Basic search expression
            131, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`emp_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->emp_id->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->emp_id->addMethod("getLinkPrefix", fn() => "processactionpaymentpelist?x_empid=");
        $this->emp_id->InputTextType = "text";
        $this->emp_id->Raw = true;
        $this->emp_id->setSelectMultiple(false); // Select one
        $this->emp_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->emp_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->emp_id->Lookup = new Lookup($this->emp_id, 'production_employee', false, 'id', ["id","user_name","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->emp_id) . "',COALESCE(`user_name`,''))");
        $this->emp_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->emp_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['emp_id'] = &$this->emp_id;

        // contractor
        $this->contractor = new DbField(
            $this, // Table
            'x_contractor', // Variable name
            'contractor', // Name
            '`contractor`', // Expression
            '`contractor`', // Basic search expression
            200, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`contractor`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->contractor->addMethod("getSelectFilter", fn() => "`category`=99");
        $this->contractor->InputTextType = "text";
        $this->contractor->setSelectMultiple(false); // Select one
        $this->contractor->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->contractor->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->contractor->Lookup = new Lookup($this->contractor, 'production_employee', false, 'id', ["employee_name","","",""], '', '', [], [], [], [], [], [], false, '`employee_name` ASC', '', "`employee_name`");
        $this->contractor->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['contractor'] = &$this->contractor;

        // qty
        $this->qty = new DbField(
            $this, // Table
            'x_qty', // Variable name
            'qty', // Name
            '`qty`', // Expression
            '`qty`', // Basic search expression
            131, // Type
            30, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty->InputTextType = "text";
        $this->qty->Raw = true;
        $this->qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['qty'] = &$this->qty;

        // sqm
        $this->sqm = new DbField(
            $this, // Table
            'x_sqm', // Variable name
            'sqm', // Name
            '`sqm`', // Expression
            '`sqm`', // Basic search expression
            5, // Type
            19, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm->InputTextType = "text";
        $this->sqm->Raw = true;
        $this->sqm->Nullable = false; // NOT NULL field
        $this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['sqm'] = &$this->sqm;

        // amount
        $this->amount = new DbField(
            $this, // Table
            'x_amount', // Variable name
            'amount', // Name
            '`amount`', // Expression
            '`amount`', // Basic search expression
            5, // Type
            31, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->amount->InputTextType = "text";
        $this->amount->Raw = true;
        $this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['amount'] = &$this->amount;

        // payment
        $this->payment = new DbField(
            $this, // Table
            'x_payment', // Variable name
            'payment', // Name
            '`payment`', // Expression
            '`payment`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->payment->addMethod("getLinkPrefix", fn() => "processactionpaymentpelist?x_payment=");
        $this->payment->InputTextType = "text";
        $this->payment->setSelectMultiple(false); // Select one
        $this->payment->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->payment->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->payment->Lookup = new Lookup($this->payment, 'payment_period', false, 'id', ["payment_description","","",""], '', '', [], [], [], [], [], [], false, '`payment_description` ASC', '', "`payment_description`");
        $this->payment->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->payment->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['payment'] = &$this->payment;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->Nullable = false; // NOT NULL field
        $this->remarks->Required = true; // Required field
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['remarks'] = &$this->remarks;

        // url
        $this->url = new DbField(
            $this, // Table
            'x_url', // Variable name
            'url', // Name
            'concat(\'processactionpaymentlist?x_emp_id=\', `emp_id`, \'&x_payment=\', `payment`)', // Expression
            'concat(\'processactionpaymentlist?x_emp_id=\', `emp_id`, \'&x_payment=\', `payment`)', // Basic search expression
            200, // Type
            63, // Size
            -1, // Date/Time format
            false, // Is upload field
            'concat(\'processactionpaymentlist?x_emp_id=\', `emp_id`, \'&x_payment=\', `payment`)', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->url->InputTextType = "text";
        $this->url->IsCustom = true; // Custom field
        $this->url->Sortable = false; // Allow sort
        $this->url->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['url'] = &$this->url;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "process_action_payment_pe";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        return "*, concat('processactionpaymentlist?x_emp_id=', `emp_id`, '&x_payment=', `payment`) AS `url`";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->location->DbValue = $row['location'];
        $this->process->DbValue = $row['process'];
        $this->emp_id->DbValue = $row['emp_id'];
        $this->contractor->DbValue = $row['contractor'];
        $this->qty->DbValue = $row['qty'];
        $this->sqm->DbValue = $row['sqm'];
        $this->amount->DbValue = $row['amount'];
        $this->payment->DbValue = $row['payment'];
        $this->remarks->DbValue = $row['remarks'];
        $this->url->DbValue = $row['url'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("processactionpaymentpelist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "processactionpaymentpeview" => $Language->phrase("View"),
            "processactionpaymentpeedit" => $Language->phrase("Edit"),
            "processactionpaymentpeadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "processactionpaymentpelist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "ProcessActionPaymentPeView",
            Config("API_ADD_ACTION") => "ProcessActionPaymentPeAdd",
            Config("API_EDIT_ACTION") => "ProcessActionPaymentPeEdit",
            Config("API_DELETE_ACTION") => "ProcessActionPaymentPeDelete",
            Config("API_LIST_ACTION") => "ProcessActionPaymentPeList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "processactionpaymentpelist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("processactionpaymentpeview", $parm);
        } else {
            $url = $this->keyUrl("processactionpaymentpeview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "processactionpaymentpeadd?" . $parm;
        } else {
            $url = "processactionpaymentpeadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("processactionpaymentpeedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("processactionpaymentpelist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("processactionpaymentpeadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("processactionpaymentpelist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("processactionpaymentpedelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, -1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, -1))) // Other API
                : []; // Non-API
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->location->setDbValue($row['location']);
        $this->process->setDbValue($row['process']);
        $this->emp_id->setDbValue($row['emp_id']);
        $this->contractor->setDbValue($row['contractor']);
        $this->qty->setDbValue($row['qty']);
        $this->sqm->setDbValue($row['sqm']);
        $this->amount->setDbValue($row['amount']);
        $this->payment->setDbValue($row['payment']);
        $this->remarks->setDbValue($row['remarks']);
        $this->url->setDbValue($row['url']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "ProcessActionPaymentPeList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // location

        // process

        // emp_id

        // contractor

        // qty

        // sqm

        // amount

        // payment

        // remarks

        // url
        $this->url->CellCssStyle = "white-space: nowrap;";

        // location
        $curVal = strval($this->location->CurrentValue);
        if ($curVal != "") {
            $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
            if ($this->location->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                    $this->location->ViewValue = $this->location->displayValue($arwrk);
                } else {
                    $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                }
            }
        } else {
            $this->location->ViewValue = null;
        }

        // process
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                    $this->process->ViewValue = $this->process->displayValue($arwrk);
                } else {
                    $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                }
            }
        } else {
            $this->process->ViewValue = null;
        }

        // emp_id
        $curVal = strval($this->emp_id->CurrentValue);
        if ($curVal != "") {
            $this->emp_id->ViewValue = $this->emp_id->lookupCacheOption($curVal);
            if ($this->emp_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->emp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->emp_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->emp_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->emp_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->emp_id->Lookup->renderViewRow($rswrk[0]);
                    $this->emp_id->ViewValue = $this->emp_id->displayValue($arwrk);
                } else {
                    $this->emp_id->ViewValue = FormatNumber($this->emp_id->CurrentValue, $this->emp_id->formatPattern());
                }
            }
        } else {
            $this->emp_id->ViewValue = null;
        }

        // contractor
        $curVal = strval($this->contractor->CurrentValue);
        if ($curVal != "") {
            $this->contractor->ViewValue = $this->contractor->lookupCacheOption($curVal);
            if ($this->contractor->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->contractor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->contractor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->contractor->getSelectFilter($this); // PHP
                $sqlWrk = $this->contractor->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->contractor->Lookup->renderViewRow($rswrk[0]);
                    $this->contractor->ViewValue = $this->contractor->displayValue($arwrk);
                } else {
                    $this->contractor->ViewValue = $this->contractor->CurrentValue;
                }
            }
        } else {
            $this->contractor->ViewValue = null;
        }

        // qty
        $this->qty->ViewValue = $this->qty->CurrentValue;
        $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

        // sqm
        $this->sqm->ViewValue = $this->sqm->CurrentValue;
        $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

        // amount
        $this->amount->ViewValue = $this->amount->CurrentValue;
        $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

        // payment
        $curVal = strval($this->payment->CurrentValue);
        if ($curVal != "") {
            $this->payment->ViewValue = $this->payment->lookupCacheOption($curVal);
            if ($this->payment->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->payment->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->payment->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->payment->Lookup->renderViewRow($rswrk[0]);
                    $this->payment->ViewValue = $this->payment->displayValue($arwrk);
                } else {
                    $this->payment->ViewValue = $this->payment->CurrentValue;
                }
            }
        } else {
            $this->payment->ViewValue = null;
        }

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // url
        $this->url->ViewValue = $this->url->CurrentValue;

        // location
        $this->location->HrefValue = "";
        $this->location->TooltipValue = "";

        // process
        if (!EmptyValue($this->process->CurrentValue)) {
            $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
            $this->process->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
            }
        } else {
            $this->process->HrefValue = "";
        }
        $this->process->TooltipValue = "";

        // emp_id
        if (!EmptyValue($this->emp_id->CurrentValue)) {
            $this->emp_id->HrefValue = $this->emp_id->getLinkPrefix() . $this->emp_id->CurrentValue; // Add prefix/suffix
            $this->emp_id->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->emp_id->HrefValue = FullUrl($this->emp_id->HrefValue, "href");
            }
        } else {
            $this->emp_id->HrefValue = "";
        }
        $this->emp_id->TooltipValue = "";

        // contractor
        $this->contractor->HrefValue = "";
        $this->contractor->TooltipValue = "";

        // qty
        $this->qty->HrefValue = "";
        $this->qty->TooltipValue = "";

        // sqm
        $this->sqm->HrefValue = "";
        $this->sqm->TooltipValue = "";

        // amount
        if (!EmptyValue($this->url->CurrentValue)) {
            $this->amount->HrefValue = (!empty($this->url->ViewValue) && !is_array($this->url->ViewValue) ? RemoveHtml($this->url->ViewValue) : $this->url->CurrentValue); // Add prefix/suffix
            $this->amount->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->amount->HrefValue = FullUrl($this->amount->HrefValue, "href");
            }
        } else {
            $this->amount->HrefValue = "";
        }
        $this->amount->TooltipValue = "";

        // payment
        if (!EmptyValue($this->payment->CurrentValue)) {
            $this->payment->HrefValue = $this->payment->getLinkPrefix() . $this->payment->CurrentValue; // Add prefix/suffix
            $this->payment->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->payment->HrefValue = FullUrl($this->payment->HrefValue, "href");
            }
        } else {
            $this->payment->HrefValue = "";
        }
        $this->payment->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // url
        $this->url->HrefValue = "";
        $this->url->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // location
        $this->location->setupEditAttributes();
        $this->location->PlaceHolder = RemoveHtml($this->location->caption());

        // process
        $this->process->setupEditAttributes();
        $this->process->PlaceHolder = RemoveHtml($this->process->caption());

        // emp_id
        $this->emp_id->setupEditAttributes();
        $this->emp_id->PlaceHolder = RemoveHtml($this->emp_id->caption());

        // contractor
        $this->contractor->setupEditAttributes();
        $this->contractor->PlaceHolder = RemoveHtml($this->contractor->caption());

        // qty
        $this->qty->setupEditAttributes();
        $this->qty->EditValue = $this->qty->CurrentValue;
        $this->qty->PlaceHolder = RemoveHtml($this->qty->caption());
        if (strval($this->qty->EditValue) != "" && is_numeric($this->qty->EditValue)) {
            $this->qty->EditValue = FormatNumber($this->qty->EditValue, null);
        }

        // sqm
        $this->sqm->setupEditAttributes();
        $this->sqm->EditValue = $this->sqm->CurrentValue;
        $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
        if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
            $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
        }

        // amount
        $this->amount->setupEditAttributes();
        $this->amount->EditValue = $this->amount->CurrentValue;
        $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
        if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
            $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
        }

        // payment
        $this->payment->setupEditAttributes();
        $this->payment->PlaceHolder = RemoveHtml($this->payment->caption());

        // remarks
        $this->remarks->setupEditAttributes();
        if (!$this->remarks->Raw) {
            $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
        }
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // url
        $this->url->setupEditAttributes();
        if (!$this->url->Raw) {
            $this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
        }
        $this->url->EditValue = $this->url->CurrentValue;
        $this->url->PlaceHolder = RemoveHtml($this->url->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            $this->emp_id->Count++; // Increment count
            if (is_numeric($this->qty->CurrentValue)) {
                $this->qty->Total += $this->qty->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->sqm->CurrentValue)) {
                $this->sqm->Total += $this->sqm->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->amount->CurrentValue)) {
                $this->amount->Total += $this->amount->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->emp_id->CurrentValue = $this->emp_id->Count;
            $this->emp_id->ViewValue = $this->emp_id->CurrentValue;
            $this->emp_id->HrefValue = ""; // Clear href value
            $this->qty->CurrentValue = $this->qty->Total;
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());
            $this->qty->HrefValue = ""; // Clear href value
            $this->sqm->CurrentValue = $this->sqm->Total;
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());
            $this->sqm->HrefValue = ""; // Clear href value
            $this->amount->CurrentValue = $this->amount->Total;
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());
            $this->amount->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->emp_id);
                    $doc->exportCaption($this->contractor);
                    $doc->exportCaption($this->qty);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->payment);
                    $doc->exportCaption($this->remarks);
                } else {
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->emp_id);
                    $doc->exportCaption($this->contractor);
                    $doc->exportCaption($this->qty);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->payment);
                    $doc->exportCaption($this->remarks);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->location);
                        $doc->exportField($this->process);
                        $doc->exportField($this->emp_id);
                        $doc->exportField($this->contractor);
                        $doc->exportField($this->qty);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->payment);
                        $doc->exportField($this->remarks);
                    } else {
                        $doc->exportField($this->location);
                        $doc->exportField($this->process);
                        $doc->exportField($this->emp_id);
                        $doc->exportField($this->contractor);
                        $doc->exportField($this->qty);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->payment);
                        $doc->exportField($this->remarks);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->location, '');
                $doc->exportAggregate($this->process, '');
                $doc->exportAggregate($this->emp_id, 'COUNT');
                $doc->exportAggregate($this->contractor, '');
                $doc->exportAggregate($this->qty, 'TOTAL');
                $doc->exportAggregate($this->sqm, 'TOTAL');
                $doc->exportAggregate($this->amount, 'TOTAL');
                $doc->exportAggregate($this->payment, '');
                $doc->exportAggregate($this->remarks, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
