<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for process_action_payment
 */
class ProcessActionPayment extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $location;
    public $process;
    public $emp_id;
    public $emp_grp;
    public $code;
    public $ref;
    public $size_wl;
    public $process_;
    public $final_amount;
    public $amount;
    public $c_charge;
    public $c_id;
    public $custom_size;
    public $ded_jc;
    public $ded_pa;
    public $payment_type;
    public $sqm;
    public $sqm_grp;
    public $_2_srm;
    public $_4_srm;
    public $process_fix;
    public $method;
    public $datetime;
    public $payment;
    public $grp;
    public $remark;
    public $pps;
    public $category;
    public $c_method;
    public $uid;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "process_action_payment";
        $this->TableName = 'process_action_payment';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "process_action_payment";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // location
        $this->location = new DbField(
            $this, // Table
            'x_location', // Variable name
            'location', // Name
            '`location`', // Expression
            '`location`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`location`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->location->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->location->InputTextType = "text";
        $this->location->Raw = true;
        $this->location->setSelectMultiple(false); // Select one
        $this->location->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->location->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->location->Lookup = new Lookup($this->location, 'godown_table', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->location->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->location->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['location'] = &$this->location;

        // process
        $this->process = new DbField(
            $this, // Table
            'x_process', // Variable name
            'process', // Name
            '`process`', // Expression
            '`process`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->process->InputTextType = "text";
        $this->process->Raw = true;
        $this->process->setSelectMultiple(false); // Select one
        $this->process->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->process->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->process->Lookup = new Lookup($this->process, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['process'] = &$this->process;

        // emp_id
        $this->emp_id = new DbField(
            $this, // Table
            'x_emp_id', // Variable name
            'emp_id', // Name
            '`emp_id`', // Expression
            '`emp_id`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`emp_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->emp_id->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->emp_id->InputTextType = "text";
        $this->emp_id->Raw = true;
        $this->emp_id->setSelectMultiple(false); // Select one
        $this->emp_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->emp_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->emp_id->Lookup = new Lookup($this->emp_id, 'production_employee', false, 'id', ["id","user_name","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->emp_id) . "',COALESCE(`user_name`,''))");
        $this->emp_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->emp_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['emp_id'] = &$this->emp_id;

        // emp_grp
        $this->emp_grp = new DbField(
            $this, // Table
            'x_emp_grp', // Variable name
            'emp_grp', // Name
            '`emp_grp`', // Expression
            '`emp_grp`', // Basic search expression
            200, // Type
            40, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`emp_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->emp_grp->InputTextType = "text";
        $this->emp_grp->Nullable = false; // NOT NULL field
        $this->emp_grp->Required = true; // Required field
        $this->emp_grp->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['emp_grp'] = &$this->emp_grp;

        // code
        $this->code = new DbField(
            $this, // Table
            'x_code', // Variable name
            'code', // Name
            '`code`', // Expression
            '`code`', // Basic search expression
            20, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->code->InputTextType = "text";
        $this->code->Raw = true;
        $this->code->Nullable = false; // NOT NULL field
        $this->code->Required = true; // Required field
        $this->code->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->code->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['code'] = &$this->code;

        // ref
        $this->ref = new DbField(
            $this, // Table
            'x_ref', // Variable name
            'ref', // Name
            '`ref`', // Expression
            '`ref`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ref->InputTextType = "text";
        $this->ref->Nullable = false; // NOT NULL field
        $this->ref->Required = true; // Required field
        $this->ref->setSelectMultiple(false); // Select one
        $this->ref->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->ref->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->ref->Lookup = new Lookup($this->ref, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->ref->SearchOperators = ["=", "<>"];
        $this->Fields['ref'] = &$this->ref;

        // size_wl
        $this->size_wl = new DbField(
            $this, // Table
            'x_size_wl', // Variable name
            'size_wl', // Name
            '`size_wl`', // Expression
            '`size_wl`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size_wl`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size_wl->InputTextType = "text";
        $this->size_wl->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->size_wl->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['size_wl'] = &$this->size_wl;

        // process_@
        $this->process_ = new DbField(
            $this, // Table
            'x_process_', // Variable name
            'process_@', // Name
            '`process_@`', // Expression
            '`process_@`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_@`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->process_->InputTextType = "text";
        $this->process_->Raw = true;
        $this->process_->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process_->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['process_@'] = &$this->process_;

        // final_amount
        $this->final_amount = new DbField(
            $this, // Table
            'x_final_amount', // Variable name
            'final_amount', // Name
            '`final_amount`', // Expression
            '`final_amount`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`final_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->final_amount->addMethod("getDefault", fn() => 0);
        $this->final_amount->InputTextType = "text";
        $this->final_amount->Raw = true;
        $this->final_amount->Nullable = false; // NOT NULL field
        $this->final_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->final_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['final_amount'] = &$this->final_amount;

        // amount
        $this->amount = new DbField(
            $this, // Table
            'x_amount', // Variable name
            'amount', // Name
            '`amount`', // Expression
            '`amount`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->amount->InputTextType = "text";
        $this->amount->Raw = true;
        $this->amount->Nullable = false; // NOT NULL field
        $this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['amount'] = &$this->amount;

        // c_charge
        $this->c_charge = new DbField(
            $this, // Table
            'x_c_charge', // Variable name
            'c_charge', // Name
            '`c_charge`', // Expression
            '`c_charge`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`c_charge`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->c_charge->addMethod("getDefault", fn() => 0);
        $this->c_charge->InputTextType = "text";
        $this->c_charge->Raw = true;
        $this->c_charge->Nullable = false; // NOT NULL field
        $this->c_charge->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->c_charge->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['c_charge'] = &$this->c_charge;

        // c_id
        $this->c_id = new DbField(
            $this, // Table
            'x_c_id', // Variable name
            'c_id', // Name
            '`c_id`', // Expression
            '`c_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`c_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->c_id->addMethod("getSelectFilter", fn() => "`category`=99 and `status` = 1");
        $this->c_id->addMethod("getDefault", fn() => 0);
        $this->c_id->InputTextType = "text";
        $this->c_id->Raw = true;
        $this->c_id->Nullable = false; // NOT NULL field
        $this->c_id->setSelectMultiple(false); // Select one
        $this->c_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->c_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->c_id->Lookup = new Lookup($this->c_id, 'production_employee', false, 'id', ["id","user_name","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->c_id) . "',COALESCE(`user_name`,''))");
        $this->c_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->c_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['c_id'] = &$this->c_id;

        // custom_size
        $this->custom_size = new DbField(
            $this, // Table
            'x_custom_size', // Variable name
            'custom_size', // Name
            '`custom_size`', // Expression
            '`custom_size`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`custom_size`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->custom_size->addMethod("getDefault", fn() => 0);
        $this->custom_size->InputTextType = "text";
        $this->custom_size->Raw = true;
        $this->custom_size->Nullable = false; // NOT NULL field
        $this->custom_size->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->custom_size->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['custom_size'] = &$this->custom_size;

        // ded_jc
        $this->ded_jc = new DbField(
            $this, // Table
            'x_ded_jc', // Variable name
            'ded_jc', // Name
            '`ded_jc`', // Expression
            '`ded_jc`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ded_jc`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ded_jc->InputTextType = "text";
        $this->ded_jc->Raw = true;
        $this->ded_jc->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->ded_jc->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ded_jc'] = &$this->ded_jc;

        // ded_pa
        $this->ded_pa = new DbField(
            $this, // Table
            'x_ded_pa', // Variable name
            'ded_pa', // Name
            '`ded_pa`', // Expression
            '`ded_pa`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ded_pa`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ded_pa->InputTextType = "text";
        $this->ded_pa->Raw = true;
        $this->ded_pa->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->ded_pa->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ded_pa'] = &$this->ded_pa;

        // payment_type
        $this->payment_type = new DbField(
            $this, // Table
            'x_payment_type', // Variable name
            'payment_type', // Name
            '`payment_type`', // Expression
            '`payment_type`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->payment_type->InputTextType = "text";
        $this->payment_type->Raw = true;
        $this->payment_type->Nullable = false; // NOT NULL field
        $this->payment_type->Required = true; // Required field
        $this->payment_type->setSelectMultiple(false); // Select one
        $this->payment_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->payment_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->payment_type->Lookup = new Lookup($this->payment_type, 'payment_plan', false, 'id', ["yes_no","","",""], '', '', [], [], [], [], [], [], false, '`yes_no` ASC', '', "`yes_no`");
        $this->payment_type->OptionCount = 2;
        $this->payment_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->payment_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['payment_type'] = &$this->payment_type;

        // sqm
        $this->sqm = new DbField(
            $this, // Table
            'x_sqm', // Variable name
            'sqm', // Name
            '`sqm`', // Expression
            '`sqm`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm->InputTextType = "text";
        $this->sqm->Raw = true;
        $this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sqm'] = &$this->sqm;

        // sqm_grp
        $this->sqm_grp = new DbField(
            $this, // Table
            'x_sqm_grp', // Variable name
            'sqm_grp', // Name
            '`sqm_grp`', // Expression
            '`sqm_grp`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm_grp->InputTextType = "text";
        $this->sqm_grp->Raw = true;
        $this->sqm_grp->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm_grp->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sqm_grp'] = &$this->sqm_grp;

        // 2_srm
        $this->_2_srm = new DbField(
            $this, // Table
            'x__2_srm', // Variable name
            '2_srm', // Name
            '`2_srm`', // Expression
            '`2_srm`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`2_srm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_2_srm->InputTextType = "text";
        $this->_2_srm->Raw = true;
        $this->_2_srm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_2_srm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['2_srm'] = &$this->_2_srm;

        // 4_srm
        $this->_4_srm = new DbField(
            $this, // Table
            'x__4_srm', // Variable name
            '4_srm', // Name
            '`4_srm`', // Expression
            '`4_srm`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`4_srm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_4_srm->InputTextType = "text";
        $this->_4_srm->Raw = true;
        $this->_4_srm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_4_srm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['4_srm'] = &$this->_4_srm;

        // process_fix
        $this->process_fix = new DbField(
            $this, // Table
            'x_process_fix', // Variable name
            'process_fix', // Name
            '`process_fix`', // Expression
            '`process_fix`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_fix`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process_fix->InputTextType = "text";
        $this->process_fix->Raw = true;
        $this->process_fix->setSelectMultiple(false); // Select one
        $this->process_fix->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->process_fix->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->process_fix->Lookup = new Lookup($this->process_fix, 'payment_plan', false, 'id', ["fix","","",""], '', '', [], [], [], [], [], [], false, '`fix` ASC', '', "`fix`");
        $this->process_fix->OptionCount = 2;
        $this->process_fix->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process_fix->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['process_fix'] = &$this->process_fix;

        // method
        $this->method = new DbField(
            $this, // Table
            'x_method', // Variable name
            'method', // Name
            '`method`', // Expression
            '`method`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`method`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->method->InputTextType = "text";
        $this->method->Raw = true;
        $this->method->setSelectMultiple(false); // Select one
        $this->method->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->method->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->method->Lookup = new Lookup($this->method, 'payment_plan', false, 'id', ["method","","",""], '', '', [], [], [], [], [], [], false, '`method` ASC', '', "`method`");
        $this->method->OptionCount = 4;
        $this->method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->method->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['method'] = &$this->method;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // payment
        $this->payment = new DbField(
            $this, // Table
            'x_payment', // Variable name
            'payment', // Name
            '`payment`', // Expression
            '`payment`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->payment->InputTextType = "text";
        $this->payment->Lookup = new Lookup($this->payment, 'payment_period', false, 'id', ["payment_description","","",""], '', '', [], [], [], [], [], [], false, '`payment_description` ASC', '', "`payment_description`");
        $this->payment->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->payment->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['payment'] = &$this->payment;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Nullable = false; // NOT NULL field
        $this->grp->Required = true; // Required field
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['grp'] = &$this->grp;

        // remark
        $this->remark = new DbField(
            $this, // Table
            'x_remark', // Variable name
            'remark', // Name
            '`remark`', // Expression
            '`remark`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remark`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->remark->InputTextType = "text";
        $this->remark->Nullable = false; // NOT NULL field
        $this->remark->Required = true; // Required field
        $this->remark->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['remark'] = &$this->remark;

        // pps
        $this->pps = new DbField(
            $this, // Table
            'x_pps', // Variable name
            'pps', // Name
            '`pps`', // Expression
            '`pps`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pps`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pps->addMethod("getDefault", fn() => 0);
        $this->pps->InputTextType = "text";
        $this->pps->Raw = true;
        $this->pps->Nullable = false; // NOT NULL field
        $this->pps->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pps->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['pps'] = &$this->pps;

        // category
        $this->category = new DbField(
            $this, // Table
            'x_category', // Variable name
            'category', // Name
            '`category`', // Expression
            '`category`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->category->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->category->InputTextType = "text";
        $this->category->Raw = true;
        $this->category->setSelectMultiple(false); // Select one
        $this->category->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->category->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->category->Lookup = new Lookup($this->category, 'product_category', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->category->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['category'] = &$this->category;

        // c_method
        $this->c_method = new DbField(
            $this, // Table
            'x_c_method', // Variable name
            'c_method', // Name
            '`c_method`', // Expression
            '`c_method`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`c_method`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->c_method->InputTextType = "text";
        $this->c_method->Raw = true;
        $this->c_method->Lookup = new Lookup($this->c_method, 'process_action_payment', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->c_method->OptionCount = 4;
        $this->c_method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->c_method->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['c_method'] = &$this->c_method;

        // uid
        $this->uid = new DbField(
            $this, // Table
            'x_uid', // Variable name
            'uid', // Name
            '`uid`', // Expression
            '`uid`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`uid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->uid->InputTextType = "text";
        $this->uid->Sortable = false; // Allow sort
        $this->uid->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['uid'] = &$this->uid;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "process_action_payment";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'id';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->location->DbValue = $row['location'];
        $this->process->DbValue = $row['process'];
        $this->emp_id->DbValue = $row['emp_id'];
        $this->emp_grp->DbValue = $row['emp_grp'];
        $this->code->DbValue = $row['code'];
        $this->ref->DbValue = $row['ref'];
        $this->size_wl->DbValue = $row['size_wl'];
        $this->process_->DbValue = $row['process_@'];
        $this->final_amount->DbValue = $row['final_amount'];
        $this->amount->DbValue = $row['amount'];
        $this->c_charge->DbValue = $row['c_charge'];
        $this->c_id->DbValue = $row['c_id'];
        $this->custom_size->DbValue = $row['custom_size'];
        $this->ded_jc->DbValue = $row['ded_jc'];
        $this->ded_pa->DbValue = $row['ded_pa'];
        $this->payment_type->DbValue = $row['payment_type'];
        $this->sqm->DbValue = $row['sqm'];
        $this->sqm_grp->DbValue = $row['sqm_grp'];
        $this->_2_srm->DbValue = $row['2_srm'];
        $this->_4_srm->DbValue = $row['4_srm'];
        $this->process_fix->DbValue = $row['process_fix'];
        $this->method->DbValue = $row['method'];
        $this->datetime->DbValue = $row['datetime'];
        $this->payment->DbValue = $row['payment'];
        $this->grp->DbValue = $row['grp'];
        $this->remark->DbValue = $row['remark'];
        $this->pps->DbValue = $row['pps'];
        $this->category->DbValue = $row['category'];
        $this->c_method->DbValue = $row['c_method'];
        $this->uid->DbValue = $row['uid'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("processactionpaymentlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "processactionpaymentview" => $Language->phrase("View"),
            "processactionpaymentedit" => $Language->phrase("Edit"),
            "processactionpaymentadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "processactionpaymentlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "ProcessActionPaymentView",
            Config("API_ADD_ACTION") => "ProcessActionPaymentAdd",
            Config("API_EDIT_ACTION") => "ProcessActionPaymentEdit",
            Config("API_DELETE_ACTION") => "ProcessActionPaymentDelete",
            Config("API_LIST_ACTION") => "ProcessActionPaymentList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "processactionpaymentlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("processactionpaymentview", $parm);
        } else {
            $url = $this->keyUrl("processactionpaymentview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "processactionpaymentadd?" . $parm;
        } else {
            $url = "processactionpaymentadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("processactionpaymentedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("processactionpaymentlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("processactionpaymentadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("processactionpaymentlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("processactionpaymentdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->location->setDbValue($row['location']);
        $this->process->setDbValue($row['process']);
        $this->emp_id->setDbValue($row['emp_id']);
        $this->emp_grp->setDbValue($row['emp_grp']);
        $this->code->setDbValue($row['code']);
        $this->ref->setDbValue($row['ref']);
        $this->size_wl->setDbValue($row['size_wl']);
        $this->process_->setDbValue($row['process_@']);
        $this->final_amount->setDbValue($row['final_amount']);
        $this->amount->setDbValue($row['amount']);
        $this->c_charge->setDbValue($row['c_charge']);
        $this->c_id->setDbValue($row['c_id']);
        $this->custom_size->setDbValue($row['custom_size']);
        $this->ded_jc->setDbValue($row['ded_jc']);
        $this->ded_pa->setDbValue($row['ded_pa']);
        $this->payment_type->setDbValue($row['payment_type']);
        $this->sqm->setDbValue($row['sqm']);
        $this->sqm_grp->setDbValue($row['sqm_grp']);
        $this->_2_srm->setDbValue($row['2_srm']);
        $this->_4_srm->setDbValue($row['4_srm']);
        $this->process_fix->setDbValue($row['process_fix']);
        $this->method->setDbValue($row['method']);
        $this->datetime->setDbValue($row['datetime']);
        $this->payment->setDbValue($row['payment']);
        $this->grp->setDbValue($row['grp']);
        $this->remark->setDbValue($row['remark']);
        $this->pps->setDbValue($row['pps']);
        $this->category->setDbValue($row['category']);
        $this->c_method->setDbValue($row['c_method']);
        $this->uid->setDbValue($row['uid']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "ProcessActionPaymentList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // location

        // process

        // emp_id

        // emp_grp

        // code

        // ref

        // size_wl

        // process_@

        // final_amount

        // amount

        // c_charge

        // c_id

        // custom_size

        // ded_jc

        // ded_pa

        // payment_type

        // sqm

        // sqm_grp

        // 2_srm

        // 4_srm

        // process_fix

        // method

        // datetime

        // payment

        // grp

        // remark

        // pps

        // category

        // c_method

        // uid
        $this->uid->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // location
        $curVal = strval($this->location->CurrentValue);
        if ($curVal != "") {
            $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
            if ($this->location->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                    $this->location->ViewValue = $this->location->displayValue($arwrk);
                } else {
                    $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                }
            }
        } else {
            $this->location->ViewValue = null;
        }

        // process
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                    $this->process->ViewValue = $this->process->displayValue($arwrk);
                } else {
                    $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                }
            }
        } else {
            $this->process->ViewValue = null;
        }

        // emp_id
        $curVal = strval($this->emp_id->CurrentValue);
        if ($curVal != "") {
            $this->emp_id->ViewValue = $this->emp_id->lookupCacheOption($curVal);
            if ($this->emp_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->emp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->emp_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->emp_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->emp_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->emp_id->Lookup->renderViewRow($rswrk[0]);
                    $this->emp_id->ViewValue = $this->emp_id->displayValue($arwrk);
                } else {
                    $this->emp_id->ViewValue = FormatNumber($this->emp_id->CurrentValue, $this->emp_id->formatPattern());
                }
            }
        } else {
            $this->emp_id->ViewValue = null;
        }

        // emp_grp
        $this->emp_grp->ViewValue = $this->emp_grp->CurrentValue;

        // code
        $this->code->ViewValue = $this->code->CurrentValue;
        $this->code->ViewValue = FormatNumber($this->code->ViewValue, $this->code->formatPattern());

        // ref
        $curVal = strval($this->ref->CurrentValue);
        if ($curVal != "") {
            $this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
            if ($this->ref->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ref->Lookup->renderViewRow($rswrk[0]);
                    $this->ref->ViewValue = $this->ref->displayValue($arwrk);
                } else {
                    $this->ref->ViewValue = $this->ref->CurrentValue;
                }
            }
        } else {
            $this->ref->ViewValue = null;
        }

        // size_wl
        $this->size_wl->ViewValue = $this->size_wl->CurrentValue;

        // process_@
        $this->process_->ViewValue = $this->process_->CurrentValue;
        $this->process_->ViewValue = FormatNumber($this->process_->ViewValue, $this->process_->formatPattern());

        // final_amount
        $this->final_amount->ViewValue = $this->final_amount->CurrentValue;
        $this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, $this->final_amount->formatPattern());

        // amount
        $this->amount->ViewValue = $this->amount->CurrentValue;
        $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

        // c_charge
        $this->c_charge->ViewValue = $this->c_charge->CurrentValue;
        $this->c_charge->ViewValue = FormatNumber($this->c_charge->ViewValue, $this->c_charge->formatPattern());

        // c_id
        $curVal = strval($this->c_id->CurrentValue);
        if ($curVal != "") {
            $this->c_id->ViewValue = $this->c_id->lookupCacheOption($curVal);
            if ($this->c_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->c_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->c_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->c_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->c_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->c_id->Lookup->renderViewRow($rswrk[0]);
                    $this->c_id->ViewValue = $this->c_id->displayValue($arwrk);
                } else {
                    $this->c_id->ViewValue = FormatNumber($this->c_id->CurrentValue, $this->c_id->formatPattern());
                }
            }
        } else {
            $this->c_id->ViewValue = null;
        }

        // custom_size
        $this->custom_size->ViewValue = $this->custom_size->CurrentValue;
        $this->custom_size->ViewValue = FormatNumber($this->custom_size->ViewValue, $this->custom_size->formatPattern());

        // ded_jc
        $this->ded_jc->ViewValue = $this->ded_jc->CurrentValue;
        $this->ded_jc->ViewValue = FormatNumber($this->ded_jc->ViewValue, $this->ded_jc->formatPattern());

        // ded_pa
        $this->ded_pa->ViewValue = $this->ded_pa->CurrentValue;
        $this->ded_pa->ViewValue = FormatNumber($this->ded_pa->ViewValue, $this->ded_pa->formatPattern());

        // payment_type
        if (strval($this->payment_type->CurrentValue) != "") {
            $this->payment_type->ViewValue = $this->payment_type->optionCaption($this->payment_type->CurrentValue);
        } else {
            $this->payment_type->ViewValue = null;
        }

        // sqm
        $this->sqm->ViewValue = $this->sqm->CurrentValue;
        $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

        // sqm_grp
        $this->sqm_grp->ViewValue = $this->sqm_grp->CurrentValue;
        $this->sqm_grp->ViewValue = FormatNumber($this->sqm_grp->ViewValue, $this->sqm_grp->formatPattern());

        // 2_srm
        $this->_2_srm->ViewValue = $this->_2_srm->CurrentValue;
        $this->_2_srm->ViewValue = FormatNumber($this->_2_srm->ViewValue, $this->_2_srm->formatPattern());

        // 4_srm
        $this->_4_srm->ViewValue = $this->_4_srm->CurrentValue;
        $this->_4_srm->ViewValue = FormatNumber($this->_4_srm->ViewValue, $this->_4_srm->formatPattern());

        // process_fix
        if (strval($this->process_fix->CurrentValue) != "") {
            $this->process_fix->ViewValue = $this->process_fix->optionCaption($this->process_fix->CurrentValue);
        } else {
            $this->process_fix->ViewValue = null;
        }

        // method
        if (strval($this->method->CurrentValue) != "") {
            $this->method->ViewValue = $this->method->optionCaption($this->method->CurrentValue);
        } else {
            $this->method->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // payment
        $curVal = strval($this->payment->CurrentValue);
        if ($curVal != "") {
            $this->payment->ViewValue = $this->payment->lookupCacheOption($curVal);
            if ($this->payment->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->payment->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->payment->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $sqlWrk = $this->payment->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->payment->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->payment->Lookup->renderViewRow($row);
                        $this->payment->ViewValue->add($this->payment->displayValue($arwrk));
                    }
                } else {
                    $this->payment->ViewValue = $this->payment->CurrentValue;
                }
            }
        } else {
            $this->payment->ViewValue = null;
        }

        // grp
        $this->grp->ViewValue = $this->grp->CurrentValue;
        $this->grp->ViewValue = FormatNumber($this->grp->ViewValue, $this->grp->formatPattern());

        // remark
        $this->remark->ViewValue = $this->remark->CurrentValue;

        // pps
        $this->pps->ViewValue = $this->pps->CurrentValue;
        $this->pps->ViewValue = FormatNumber($this->pps->ViewValue, $this->pps->formatPattern());

        // category
        $curVal = strval($this->category->CurrentValue);
        if ($curVal != "") {
            $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            if ($this->category->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                    $this->category->ViewValue = $this->category->displayValue($arwrk);
                } else {
                    $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                }
            }
        } else {
            $this->category->ViewValue = null;
        }

        // c_method
        $this->c_method->ViewValue = $this->c_method->CurrentValue;

        // uid
        $this->uid->ViewValue = $this->uid->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // location
        $this->location->HrefValue = "";
        $this->location->TooltipValue = "";

        // process
        $this->process->HrefValue = "";
        $this->process->TooltipValue = "";

        // emp_id
        $this->emp_id->HrefValue = "";
        $this->emp_id->TooltipValue = "";

        // emp_grp
        $this->emp_grp->HrefValue = "";
        $this->emp_grp->TooltipValue = "";

        // code
        $this->code->HrefValue = "";
        $this->code->TooltipValue = "";

        // ref
        $this->ref->HrefValue = "";
        $this->ref->TooltipValue = "";

        // size_wl
        $this->size_wl->HrefValue = "";
        $this->size_wl->TooltipValue = "";

        // process_@
        $this->process_->HrefValue = "";
        $this->process_->TooltipValue = "";

        // final_amount
        $this->final_amount->HrefValue = "";
        $this->final_amount->TooltipValue = "";

        // amount
        $this->amount->HrefValue = "";
        $this->amount->TooltipValue = "";

        // c_charge
        $this->c_charge->HrefValue = "";
        $this->c_charge->TooltipValue = "";

        // c_id
        $this->c_id->HrefValue = "";
        $this->c_id->TooltipValue = "";

        // custom_size
        $this->custom_size->HrefValue = "";
        $this->custom_size->TooltipValue = "";

        // ded_jc
        $this->ded_jc->HrefValue = "";
        $this->ded_jc->TooltipValue = "";

        // ded_pa
        $this->ded_pa->HrefValue = "";
        $this->ded_pa->TooltipValue = "";

        // payment_type
        $this->payment_type->HrefValue = "";
        $this->payment_type->TooltipValue = "";

        // sqm
        $this->sqm->HrefValue = "";
        $this->sqm->TooltipValue = "";

        // sqm_grp
        $this->sqm_grp->HrefValue = "";
        $this->sqm_grp->TooltipValue = "";

        // 2_srm
        $this->_2_srm->HrefValue = "";
        $this->_2_srm->TooltipValue = "";

        // 4_srm
        $this->_4_srm->HrefValue = "";
        $this->_4_srm->TooltipValue = "";

        // process_fix
        $this->process_fix->HrefValue = "";
        $this->process_fix->TooltipValue = "";

        // method
        $this->method->HrefValue = "";
        $this->method->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // payment
        $this->payment->HrefValue = "";
        $this->payment->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // remark
        $this->remark->HrefValue = "";
        $this->remark->TooltipValue = "";

        // pps
        $this->pps->HrefValue = "";
        $this->pps->TooltipValue = "";

        // category
        $this->category->HrefValue = "";
        $this->category->TooltipValue = "";

        // c_method
        $this->c_method->HrefValue = "";
        $this->c_method->TooltipValue = "";

        // uid
        $this->uid->HrefValue = "";
        $this->uid->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // location
        $this->location->setupEditAttributes();
        $this->location->PlaceHolder = RemoveHtml($this->location->caption());

        // process
        $this->process->setupEditAttributes();
        $this->process->PlaceHolder = RemoveHtml($this->process->caption());

        // emp_id
        $this->emp_id->setupEditAttributes();
        $this->emp_id->PlaceHolder = RemoveHtml($this->emp_id->caption());

        // emp_grp
        $this->emp_grp->setupEditAttributes();
        if (!$this->emp_grp->Raw) {
            $this->emp_grp->CurrentValue = HtmlDecode($this->emp_grp->CurrentValue);
        }
        $this->emp_grp->EditValue = $this->emp_grp->CurrentValue;
        $this->emp_grp->PlaceHolder = RemoveHtml($this->emp_grp->caption());

        // code
        $this->code->setupEditAttributes();
        $this->code->EditValue = $this->code->CurrentValue;
        $this->code->PlaceHolder = RemoveHtml($this->code->caption());
        if (strval($this->code->EditValue) != "" && is_numeric($this->code->EditValue)) {
            $this->code->EditValue = FormatNumber($this->code->EditValue, null);
        }

        // ref
        $this->ref->setupEditAttributes();
        $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

        // size_wl
        $this->size_wl->setupEditAttributes();
        if (!$this->size_wl->Raw) {
            $this->size_wl->CurrentValue = HtmlDecode($this->size_wl->CurrentValue);
        }
        $this->size_wl->EditValue = $this->size_wl->CurrentValue;
        $this->size_wl->PlaceHolder = RemoveHtml($this->size_wl->caption());

        // process_@
        $this->process_->setupEditAttributes();
        $this->process_->EditValue = $this->process_->CurrentValue;
        $this->process_->PlaceHolder = RemoveHtml($this->process_->caption());
        if (strval($this->process_->EditValue) != "" && is_numeric($this->process_->EditValue)) {
            $this->process_->EditValue = FormatNumber($this->process_->EditValue, null);
        }

        // final_amount
        $this->final_amount->setupEditAttributes();
        $this->final_amount->EditValue = $this->final_amount->CurrentValue;
        $this->final_amount->PlaceHolder = RemoveHtml($this->final_amount->caption());
        if (strval($this->final_amount->EditValue) != "" && is_numeric($this->final_amount->EditValue)) {
            $this->final_amount->EditValue = FormatNumber($this->final_amount->EditValue, null);
        }

        // amount
        $this->amount->setupEditAttributes();
        $this->amount->EditValue = $this->amount->CurrentValue;
        $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
        if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
            $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
        }

        // c_charge
        $this->c_charge->setupEditAttributes();
        $this->c_charge->EditValue = $this->c_charge->CurrentValue;
        $this->c_charge->PlaceHolder = RemoveHtml($this->c_charge->caption());
        if (strval($this->c_charge->EditValue) != "" && is_numeric($this->c_charge->EditValue)) {
            $this->c_charge->EditValue = FormatNumber($this->c_charge->EditValue, null);
        }

        // c_id
        $this->c_id->setupEditAttributes();
        $this->c_id->PlaceHolder = RemoveHtml($this->c_id->caption());

        // custom_size
        $this->custom_size->setupEditAttributes();
        $this->custom_size->EditValue = $this->custom_size->CurrentValue;
        $this->custom_size->PlaceHolder = RemoveHtml($this->custom_size->caption());
        if (strval($this->custom_size->EditValue) != "" && is_numeric($this->custom_size->EditValue)) {
            $this->custom_size->EditValue = FormatNumber($this->custom_size->EditValue, null);
        }

        // ded_jc
        $this->ded_jc->setupEditAttributes();
        $this->ded_jc->EditValue = $this->ded_jc->CurrentValue;
        $this->ded_jc->PlaceHolder = RemoveHtml($this->ded_jc->caption());
        if (strval($this->ded_jc->EditValue) != "" && is_numeric($this->ded_jc->EditValue)) {
            $this->ded_jc->EditValue = FormatNumber($this->ded_jc->EditValue, null);
        }

        // ded_pa
        $this->ded_pa->setupEditAttributes();
        $this->ded_pa->EditValue = $this->ded_pa->CurrentValue;
        $this->ded_pa->PlaceHolder = RemoveHtml($this->ded_pa->caption());
        if (strval($this->ded_pa->EditValue) != "" && is_numeric($this->ded_pa->EditValue)) {
            $this->ded_pa->EditValue = FormatNumber($this->ded_pa->EditValue, null);
        }

        // payment_type
        $this->payment_type->setupEditAttributes();
        $this->payment_type->EditValue = $this->payment_type->options(true);
        $this->payment_type->PlaceHolder = RemoveHtml($this->payment_type->caption());

        // sqm
        $this->sqm->setupEditAttributes();
        $this->sqm->EditValue = $this->sqm->CurrentValue;
        $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
        if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
            $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
        }

        // sqm_grp
        $this->sqm_grp->setupEditAttributes();
        $this->sqm_grp->EditValue = $this->sqm_grp->CurrentValue;
        $this->sqm_grp->PlaceHolder = RemoveHtml($this->sqm_grp->caption());
        if (strval($this->sqm_grp->EditValue) != "" && is_numeric($this->sqm_grp->EditValue)) {
            $this->sqm_grp->EditValue = FormatNumber($this->sqm_grp->EditValue, null);
        }

        // 2_srm
        $this->_2_srm->setupEditAttributes();
        $this->_2_srm->EditValue = $this->_2_srm->CurrentValue;
        $this->_2_srm->PlaceHolder = RemoveHtml($this->_2_srm->caption());
        if (strval($this->_2_srm->EditValue) != "" && is_numeric($this->_2_srm->EditValue)) {
            $this->_2_srm->EditValue = FormatNumber($this->_2_srm->EditValue, null);
        }

        // 4_srm
        $this->_4_srm->setupEditAttributes();
        $this->_4_srm->EditValue = $this->_4_srm->CurrentValue;
        $this->_4_srm->PlaceHolder = RemoveHtml($this->_4_srm->caption());
        if (strval($this->_4_srm->EditValue) != "" && is_numeric($this->_4_srm->EditValue)) {
            $this->_4_srm->EditValue = FormatNumber($this->_4_srm->EditValue, null);
        }

        // process_fix
        $this->process_fix->setupEditAttributes();
        $this->process_fix->EditValue = $this->process_fix->options(true);
        $this->process_fix->PlaceHolder = RemoveHtml($this->process_fix->caption());

        // method
        $this->method->setupEditAttributes();
        $this->method->EditValue = $this->method->options(true);
        $this->method->PlaceHolder = RemoveHtml($this->method->caption());

        // datetime

        // payment
        $this->payment->PlaceHolder = RemoveHtml($this->payment->caption());

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->EditValue = $this->grp->CurrentValue;
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());
        if (strval($this->grp->EditValue) != "" && is_numeric($this->grp->EditValue)) {
            $this->grp->EditValue = FormatNumber($this->grp->EditValue, null);
        }

        // remark
        $this->remark->setupEditAttributes();
        if (!$this->remark->Raw) {
            $this->remark->CurrentValue = HtmlDecode($this->remark->CurrentValue);
        }
        $this->remark->EditValue = $this->remark->CurrentValue;
        $this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

        // pps
        $this->pps->setupEditAttributes();
        $this->pps->EditValue = $this->pps->CurrentValue;
        $this->pps->PlaceHolder = RemoveHtml($this->pps->caption());
        if (strval($this->pps->EditValue) != "" && is_numeric($this->pps->EditValue)) {
            $this->pps->EditValue = FormatNumber($this->pps->EditValue, null);
        }

        // category
        $this->category->setupEditAttributes();
        $this->category->PlaceHolder = RemoveHtml($this->category->caption());

        // c_method
        $this->c_method->setupEditAttributes();
        $this->c_method->EditValue = $this->c_method->CurrentValue;
        $this->c_method->PlaceHolder = RemoveHtml($this->c_method->caption());

        // uid
        $this->uid->setupEditAttributes();
        if (!$this->uid->Raw) {
            $this->uid->CurrentValue = HtmlDecode($this->uid->CurrentValue);
        }
        $this->uid->EditValue = $this->uid->CurrentValue;
        $this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->final_amount->CurrentValue)) {
                $this->final_amount->Total += $this->final_amount->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->final_amount->CurrentValue = $this->final_amount->Total;
            $this->final_amount->ViewValue = $this->final_amount->CurrentValue;
            $this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, $this->final_amount->formatPattern());
            $this->final_amount->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->emp_id);
                    $doc->exportCaption($this->emp_grp);
                    $doc->exportCaption($this->code);
                    $doc->exportCaption($this->ref);
                    $doc->exportCaption($this->size_wl);
                    $doc->exportCaption($this->process_);
                    $doc->exportCaption($this->final_amount);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->c_charge);
                    $doc->exportCaption($this->c_id);
                    $doc->exportCaption($this->custom_size);
                    $doc->exportCaption($this->ded_jc);
                    $doc->exportCaption($this->ded_pa);
                    $doc->exportCaption($this->payment_type);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->sqm_grp);
                    $doc->exportCaption($this->_2_srm);
                    $doc->exportCaption($this->_4_srm);
                    $doc->exportCaption($this->process_fix);
                    $doc->exportCaption($this->method);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->payment);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->remark);
                    $doc->exportCaption($this->pps);
                    $doc->exportCaption($this->category);
                    $doc->exportCaption($this->c_method);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->emp_id);
                    $doc->exportCaption($this->emp_grp);
                    $doc->exportCaption($this->code);
                    $doc->exportCaption($this->ref);
                    $doc->exportCaption($this->size_wl);
                    $doc->exportCaption($this->process_);
                    $doc->exportCaption($this->final_amount);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->c_charge);
                    $doc->exportCaption($this->c_id);
                    $doc->exportCaption($this->custom_size);
                    $doc->exportCaption($this->ded_jc);
                    $doc->exportCaption($this->ded_pa);
                    $doc->exportCaption($this->payment_type);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->sqm_grp);
                    $doc->exportCaption($this->_2_srm);
                    $doc->exportCaption($this->_4_srm);
                    $doc->exportCaption($this->process_fix);
                    $doc->exportCaption($this->method);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->payment);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->remark);
                    $doc->exportCaption($this->pps);
                    $doc->exportCaption($this->category);
                    $doc->exportCaption($this->c_method);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->location);
                        $doc->exportField($this->process);
                        $doc->exportField($this->emp_id);
                        $doc->exportField($this->emp_grp);
                        $doc->exportField($this->code);
                        $doc->exportField($this->ref);
                        $doc->exportField($this->size_wl);
                        $doc->exportField($this->process_);
                        $doc->exportField($this->final_amount);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->c_charge);
                        $doc->exportField($this->c_id);
                        $doc->exportField($this->custom_size);
                        $doc->exportField($this->ded_jc);
                        $doc->exportField($this->ded_pa);
                        $doc->exportField($this->payment_type);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->sqm_grp);
                        $doc->exportField($this->_2_srm);
                        $doc->exportField($this->_4_srm);
                        $doc->exportField($this->process_fix);
                        $doc->exportField($this->method);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->payment);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->remark);
                        $doc->exportField($this->pps);
                        $doc->exportField($this->category);
                        $doc->exportField($this->c_method);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->location);
                        $doc->exportField($this->process);
                        $doc->exportField($this->emp_id);
                        $doc->exportField($this->emp_grp);
                        $doc->exportField($this->code);
                        $doc->exportField($this->ref);
                        $doc->exportField($this->size_wl);
                        $doc->exportField($this->process_);
                        $doc->exportField($this->final_amount);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->c_charge);
                        $doc->exportField($this->c_id);
                        $doc->exportField($this->custom_size);
                        $doc->exportField($this->ded_jc);
                        $doc->exportField($this->ded_pa);
                        $doc->exportField($this->payment_type);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->sqm_grp);
                        $doc->exportField($this->_2_srm);
                        $doc->exportField($this->_4_srm);
                        $doc->exportField($this->process_fix);
                        $doc->exportField($this->method);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->payment);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->remark);
                        $doc->exportField($this->pps);
                        $doc->exportField($this->category);
                        $doc->exportField($this->c_method);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->id, '');
                $doc->exportAggregate($this->location, '');
                $doc->exportAggregate($this->process, '');
                $doc->exportAggregate($this->emp_id, '');
                $doc->exportAggregate($this->emp_grp, '');
                $doc->exportAggregate($this->code, '');
                $doc->exportAggregate($this->ref, '');
                $doc->exportAggregate($this->size_wl, '');
                $doc->exportAggregate($this->process_, '');
                $doc->exportAggregate($this->final_amount, 'TOTAL');
                $doc->exportAggregate($this->amount, '');
                $doc->exportAggregate($this->c_charge, '');
                $doc->exportAggregate($this->c_id, '');
                $doc->exportAggregate($this->custom_size, '');
                $doc->exportAggregate($this->ded_jc, '');
                $doc->exportAggregate($this->ded_pa, '');
                $doc->exportAggregate($this->payment_type, '');
                $doc->exportAggregate($this->sqm, '');
                $doc->exportAggregate($this->sqm_grp, '');
                $doc->exportAggregate($this->_2_srm, '');
                $doc->exportAggregate($this->_4_srm, '');
                $doc->exportAggregate($this->process_fix, '');
                $doc->exportAggregate($this->method, '');
                $doc->exportAggregate($this->datetime, '');
                $doc->exportAggregate($this->payment, '');
                $doc->exportAggregate($this->grp, '');
                $doc->exportAggregate($this->remark, '');
                $doc->exportAggregate($this->pps, '');
                $doc->exportAggregate($this->category, '');
                $doc->exportAggregate($this->c_method, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUserIdentifier(), $typ, 'process_action_payment');
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'process_action_payment', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DataType::DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'process_action_payment', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'process_action_payment', $fldname, $key, $oldvalue);
            }
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
