<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for process_action_material_payment
 */
class ProcessActionMaterialPayment extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $location;
    public $process;
    public $emp_id;
    public $rid;
    public $quantity;
    public $process_from;
    public $process_to;
    public $process_method;
    public $ply;
    public $rid_new;
    public $process_;
    public $amount;
    public $incentive;
    public $final_amount;
    public $description;
    public $remarks;
    public $payment;
    public $pp_id;
    public $datetime;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "process_action_material_payment";
        $this->TableName = 'process_action_material_payment';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "process_action_material_payment";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // location
        $this->location = new DbField(
            $this, // Table
            'x_location', // Variable name
            'location', // Name
            '`location`', // Expression
            '`location`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`location`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->location->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->location->InputTextType = "text";
        $this->location->Raw = true;
        $this->location->Nullable = false; // NOT NULL field
        $this->location->Required = true; // Required field
        $this->location->setSelectMultiple(false); // Select one
        $this->location->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->location->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->location->Lookup = new Lookup($this->location, 'godown_table', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->location->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->location->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['location'] = &$this->location;

        // process
        $this->process = new DbField(
            $this, // Table
            'x_process', // Variable name
            'process', // Name
            '`process`', // Expression
            '`process`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process->addMethod("getSelectFilter", fn() => "`status` = 1 and `type` = 2");
        $this->process->addMethod("getDefault", fn() => ((isset($_COOKIE["prid"]))? $_COOKIE["prid"]:''));
        $this->process->addMethod("getLinkPrefix", fn() => "processactionlist?x_process=");
        $this->process->InputTextType = "text";
        $this->process->Raw = true;
        $this->process->Nullable = false; // NOT NULL field
        $this->process->Required = true; // Required field
        $this->process->setSelectMultiple(false); // Select one
        $this->process->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->process->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->process->Lookup = new Lookup($this->process, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['process'] = &$this->process;

        // emp_id
        $this->emp_id = new DbField(
            $this, // Table
            'x_emp_id', // Variable name
            'emp_id', // Name
            '`emp_id`', // Expression
            '`emp_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`emp_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->emp_id->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->emp_id->InputTextType = "text";
        $this->emp_id->Raw = true;
        $this->emp_id->Lookup = new Lookup($this->emp_id, 'production_employee', false, 'id', ["id","user_name","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->emp_id) . "',COALESCE(`user_name`,''))");
        $this->emp_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->emp_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['emp_id'] = &$this->emp_id;

        // rid
        $this->rid = new DbField(
            $this, // Table
            'x_rid', // Variable name
            'rid', // Name
            '`rid`', // Expression
            '`rid`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__rid', // Virtual expression
            true, // Is virtual
            false, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rid->InputTextType = "text";
        $this->rid->Raw = true;
        $this->rid->Lookup = new Lookup($this->rid, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->rid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['rid'] = &$this->rid;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['quantity'] = &$this->quantity;

        // process_from
        $this->process_from = new DbField(
            $this, // Table
            'x_process_from', // Variable name
            'process_from', // Name
            '`process_from`', // Expression
            '`process_from`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_from`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process_from->InputTextType = "text";
        $this->process_from->Raw = true;
        $this->process_from->Nullable = false; // NOT NULL field
        $this->process_from->Required = true; // Required field
        $this->process_from->setSelectMultiple(false); // Select one
        $this->process_from->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->process_from->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->process_from->Lookup = new Lookup($this->process_from, 'packing_type', false, 'id', ["code","","",""], '', '', [], [], [], [], [], [], false, '`code` ASC', '', "`code`");
        $this->process_from->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process_from->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['process_from'] = &$this->process_from;

        // process_to
        $this->process_to = new DbField(
            $this, // Table
            'x_process_to', // Variable name
            'process_to', // Name
            '`process_to`', // Expression
            '`process_to`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_to`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process_to->InputTextType = "text";
        $this->process_to->Raw = true;
        $this->process_to->Nullable = false; // NOT NULL field
        $this->process_to->Required = true; // Required field
        $this->process_to->setSelectMultiple(false); // Select one
        $this->process_to->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->process_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->process_to->Lookup = new Lookup($this->process_to, 'packing_type', false, 'id', ["code","","",""], '', '', [], [], [], [], [], [], false, '`code` ASC', '', "`code`");
        $this->process_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process_to->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['process_to'] = &$this->process_to;

        // process_method
        $this->process_method = new DbField(
            $this, // Table
            'x_process_method', // Variable name
            'process_method', // Name
            '`process_method`', // Expression
            '`process_method`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_method`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process_method->InputTextType = "text";
        $this->process_method->Raw = true;
        $this->process_method->setSelectMultiple(false); // Select one
        $this->process_method->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->process_method->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->process_method->Lookup = new Lookup($this->process_method, 'process_action_material_payment', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->process_method->OptionCount = 2;
        $this->process_method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process_method->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['process_method'] = &$this->process_method;

        // ply
        $this->ply = new DbField(
            $this, // Table
            'x_ply', // Variable name
            'ply', // Name
            '`ply`', // Expression
            '`ply`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ply`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ply->InputTextType = "text";
        $this->ply->Raw = true;
        $this->ply->Nullable = false; // NOT NULL field
        $this->ply->Required = true; // Required field
        $this->ply->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ply->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ply'] = &$this->ply;

        // rid_new
        $this->rid_new = new DbField(
            $this, // Table
            'x_rid_new', // Variable name
            'rid_new', // Name
            '`rid_new`', // Expression
            '`rid_new`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid_new`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->rid_new->addMethod("getSelectFilter", fn() => "`status`=1 and `product` = 51");
        $this->rid_new->InputTextType = "text";
        $this->rid_new->Raw = true;
        $this->rid_new->Nullable = false; // NOT NULL field
        $this->rid_new->Required = true; // Required field
        $this->rid_new->setSelectMultiple(false); // Select one
        $this->rid_new->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->rid_new->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->rid_new->Lookup = new Lookup($this->rid_new, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->rid_new->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->rid_new->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['rid_new'] = &$this->rid_new;

        // process_@
        $this->process_ = new DbField(
            $this, // Table
            'x_process_', // Variable name
            'process_@', // Name
            '`process_@`', // Expression
            '`process_@`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_@`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->process_->InputTextType = "text";
        $this->process_->Raw = true;
        $this->process_->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process_->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['process_@'] = &$this->process_;

        // amount
        $this->amount = new DbField(
            $this, // Table
            'x_amount', // Variable name
            'amount', // Name
            '`amount`', // Expression
            '`amount`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->amount->InputTextType = "text";
        $this->amount->Raw = true;
        $this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['amount'] = &$this->amount;

        // incentive
        $this->incentive = new DbField(
            $this, // Table
            'x_incentive', // Variable name
            'incentive', // Name
            '`incentive`', // Expression
            '`incentive`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`incentive`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->incentive->addMethod("getDefault", fn() => 0);
        $this->incentive->InputTextType = "text";
        $this->incentive->Raw = true;
        $this->incentive->Nullable = false; // NOT NULL field
        $this->incentive->Required = true; // Required field
        $this->incentive->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->incentive->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['incentive'] = &$this->incentive;

        // final_amount
        $this->final_amount = new DbField(
            $this, // Table
            'x_final_amount', // Variable name
            'final_amount', // Name
            '`final_amount`', // Expression
            '`final_amount`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`final_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->final_amount->addMethod("getDefault", fn() => 0);
        $this->final_amount->InputTextType = "text";
        $this->final_amount->Raw = true;
        $this->final_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->final_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['final_amount'] = &$this->final_amount;

        // description
        $this->description = new DbField(
            $this, // Table
            'x_description', // Variable name
            'description', // Name
            '`description`', // Expression
            '`description`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description->InputTextType = "text";
        $this->description->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['description'] = &$this->description;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            225, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->Nullable = false; // NOT NULL field
        $this->remarks->Required = true; // Required field
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['remarks'] = &$this->remarks;

        // payment
        $this->payment = new DbField(
            $this, // Table
            'x_payment', // Variable name
            'payment', // Name
            '`payment`', // Expression
            '`payment`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->payment->InputTextType = "text";
        $this->payment->Raw = true;
        $this->payment->Required = true; // Required field
        $this->payment->Lookup = new Lookup($this->payment, 'payment_period', false, 'id', ["payment_description","","",""], '', '', [], [], [], [], [], [], false, '`payment_description` ASC', '', "`payment_description`");
        $this->payment->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->payment->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['payment'] = &$this->payment;

        // pp_id
        $this->pp_id = new DbField(
            $this, // Table
            'x_pp_id', // Variable name
            'pp_id', // Name
            '`pp_id`', // Expression
            '`pp_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pp_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pp_id->InputTextType = "text";
        $this->pp_id->Raw = true;
        $this->pp_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pp_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['pp_id'] = &$this->pp_id;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Required = true; // Required field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            if ($ctrl) {
                $orderByList = $this->getSessionOrderByList();
                $arOrderBy = !empty($orderByList) ? explode(", ", $orderByList) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderByList = implode(", ", $arOrderBy);
                $this->setSessionOrderByList($orderByList); // Save to Session
            } else {
                $this->setSessionOrderByList($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "process_action_material_payment";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ", (SELECT `product_code` FROM ref TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.id = process_action_material_payment.rid LIMIT 1) AS EV__rid FROM process_action_material_payment)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if (
            $this->rid->AdvancedSearch->SearchValue != "" ||
            $this->rid->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->rid->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->rid->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'id';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->location->DbValue = $row['location'];
        $this->process->DbValue = $row['process'];
        $this->emp_id->DbValue = $row['emp_id'];
        $this->rid->DbValue = $row['rid'];
        $this->quantity->DbValue = $row['quantity'];
        $this->process_from->DbValue = $row['process_from'];
        $this->process_to->DbValue = $row['process_to'];
        $this->process_method->DbValue = $row['process_method'];
        $this->ply->DbValue = $row['ply'];
        $this->rid_new->DbValue = $row['rid_new'];
        $this->process_->DbValue = $row['process_@'];
        $this->amount->DbValue = $row['amount'];
        $this->incentive->DbValue = $row['incentive'];
        $this->final_amount->DbValue = $row['final_amount'];
        $this->description->DbValue = $row['description'];
        $this->remarks->DbValue = $row['remarks'];
        $this->payment->DbValue = $row['payment'];
        $this->pp_id->DbValue = $row['pp_id'];
        $this->datetime->DbValue = $row['datetime'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("processactionmaterialpaymentlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "processactionmaterialpaymentview" => $Language->phrase("View"),
            "processactionmaterialpaymentedit" => $Language->phrase("Edit"),
            "processactionmaterialpaymentadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "processactionmaterialpaymentlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "ProcessActionMaterialPaymentView",
            Config("API_ADD_ACTION") => "ProcessActionMaterialPaymentAdd",
            Config("API_EDIT_ACTION") => "ProcessActionMaterialPaymentEdit",
            Config("API_DELETE_ACTION") => "ProcessActionMaterialPaymentDelete",
            Config("API_LIST_ACTION") => "ProcessActionMaterialPaymentList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "processactionmaterialpaymentlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("processactionmaterialpaymentview", $parm);
        } else {
            $url = $this->keyUrl("processactionmaterialpaymentview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "processactionmaterialpaymentadd?" . $parm;
        } else {
            $url = "processactionmaterialpaymentadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("processactionmaterialpaymentedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("processactionmaterialpaymentlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("processactionmaterialpaymentadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("processactionmaterialpaymentlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("processactionmaterialpaymentdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->location->setDbValue($row['location']);
        $this->process->setDbValue($row['process']);
        $this->emp_id->setDbValue($row['emp_id']);
        $this->rid->setDbValue($row['rid']);
        $this->quantity->setDbValue($row['quantity']);
        $this->process_from->setDbValue($row['process_from']);
        $this->process_to->setDbValue($row['process_to']);
        $this->process_method->setDbValue($row['process_method']);
        $this->ply->setDbValue($row['ply']);
        $this->rid_new->setDbValue($row['rid_new']);
        $this->process_->setDbValue($row['process_@']);
        $this->amount->setDbValue($row['amount']);
        $this->incentive->setDbValue($row['incentive']);
        $this->final_amount->setDbValue($row['final_amount']);
        $this->description->setDbValue($row['description']);
        $this->remarks->setDbValue($row['remarks']);
        $this->payment->setDbValue($row['payment']);
        $this->pp_id->setDbValue($row['pp_id']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "ProcessActionMaterialPaymentList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // location

        // process

        // emp_id

        // rid
        $this->rid->CellCssStyle = "white-space: nowrap;";

        // quantity

        // process_from

        // process_to

        // process_method

        // ply

        // rid_new

        // process_@

        // amount

        // incentive

        // final_amount

        // description

        // remarks

        // payment

        // pp_id

        // datetime

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // location
        $curVal = strval($this->location->CurrentValue);
        if ($curVal != "") {
            $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
            if ($this->location->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                    $this->location->ViewValue = $this->location->displayValue($arwrk);
                } else {
                    $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                }
            }
        } else {
            $this->location->ViewValue = null;
        }

        // process
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                    $this->process->ViewValue = $this->process->displayValue($arwrk);
                } else {
                    $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                }
            }
        } else {
            $this->process->ViewValue = null;
        }

        // emp_id
        $this->emp_id->ViewValue = $this->emp_id->CurrentValue;
        $curVal = strval($this->emp_id->CurrentValue);
        if ($curVal != "") {
            $this->emp_id->ViewValue = $this->emp_id->lookupCacheOption($curVal);
            if ($this->emp_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->emp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->emp_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->emp_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->emp_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->emp_id->Lookup->renderViewRow($rswrk[0]);
                    $this->emp_id->ViewValue = $this->emp_id->displayValue($arwrk);
                } else {
                    $this->emp_id->ViewValue = FormatNumber($this->emp_id->CurrentValue, $this->emp_id->formatPattern());
                }
            }
        } else {
            $this->emp_id->ViewValue = null;
        }

        // rid
        if ($this->rid->VirtualValue != "") {
            $this->rid->ViewValue = $this->rid->VirtualValue;
        } else {
            $this->rid->ViewValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = FormatNumber($this->rid->CurrentValue, $this->rid->formatPattern());
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }
        }

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

        // process_from
        $curVal = strval($this->process_from->CurrentValue);
        if ($curVal != "") {
            $this->process_from->ViewValue = $this->process_from->lookupCacheOption($curVal);
            if ($this->process_from->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process_from->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process_from->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->process_from->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process_from->Lookup->renderViewRow($rswrk[0]);
                    $this->process_from->ViewValue = $this->process_from->displayValue($arwrk);
                } else {
                    $this->process_from->ViewValue = FormatNumber($this->process_from->CurrentValue, $this->process_from->formatPattern());
                }
            }
        } else {
            $this->process_from->ViewValue = null;
        }

        // process_to
        $curVal = strval($this->process_to->CurrentValue);
        if ($curVal != "") {
            $this->process_to->ViewValue = $this->process_to->lookupCacheOption($curVal);
            if ($this->process_to->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->process_to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process_to->Lookup->renderViewRow($rswrk[0]);
                    $this->process_to->ViewValue = $this->process_to->displayValue($arwrk);
                } else {
                    $this->process_to->ViewValue = FormatNumber($this->process_to->CurrentValue, $this->process_to->formatPattern());
                }
            }
        } else {
            $this->process_to->ViewValue = null;
        }

        // process_method
        if (strval($this->process_method->CurrentValue) != "") {
            $this->process_method->ViewValue = $this->process_method->optionCaption($this->process_method->CurrentValue);
        } else {
            $this->process_method->ViewValue = null;
        }

        // ply
        $this->ply->ViewValue = $this->ply->CurrentValue;
        $this->ply->ViewValue = FormatNumber($this->ply->ViewValue, $this->ply->formatPattern());

        // rid_new
        $curVal = strval($this->rid_new->CurrentValue);
        if ($curVal != "") {
            $this->rid_new->ViewValue = $this->rid_new->lookupCacheOption($curVal);
            if ($this->rid_new->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid_new->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid_new->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->rid_new->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid_new->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid_new->Lookup->renderViewRow($rswrk[0]);
                    $this->rid_new->ViewValue = $this->rid_new->displayValue($arwrk);
                } else {
                    $this->rid_new->ViewValue = FormatNumber($this->rid_new->CurrentValue, $this->rid_new->formatPattern());
                }
            }
        } else {
            $this->rid_new->ViewValue = null;
        }

        // process_@
        $this->process_->ViewValue = $this->process_->CurrentValue;
        $this->process_->ViewValue = FormatNumber($this->process_->ViewValue, $this->process_->formatPattern());

        // amount
        $this->amount->ViewValue = $this->amount->CurrentValue;
        $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

        // incentive
        $this->incentive->ViewValue = $this->incentive->CurrentValue;
        $this->incentive->ViewValue = FormatNumber($this->incentive->ViewValue, $this->incentive->formatPattern());

        // final_amount
        $this->final_amount->ViewValue = $this->final_amount->CurrentValue;
        $this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, $this->final_amount->formatPattern());

        // description
        $this->description->ViewValue = $this->description->CurrentValue;

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // payment
        $curVal = strval($this->payment->CurrentValue);
        if ($curVal != "") {
            $this->payment->ViewValue = $this->payment->lookupCacheOption($curVal);
            if ($this->payment->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->payment->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->payment->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $sqlWrk = $this->payment->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->payment->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->payment->Lookup->renderViewRow($row);
                        $this->payment->ViewValue->add($this->payment->displayValue($arwrk));
                    }
                } else {
                    $this->payment->ViewValue = FormatNumber($this->payment->CurrentValue, $this->payment->formatPattern());
                }
            }
        } else {
            $this->payment->ViewValue = null;
        }

        // pp_id
        $this->pp_id->ViewValue = $this->pp_id->CurrentValue;
        $this->pp_id->ViewValue = FormatNumber($this->pp_id->ViewValue, $this->pp_id->formatPattern());

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // location
        $this->location->HrefValue = "";
        $this->location->TooltipValue = "";

        // process
        if (!EmptyValue($this->process->CurrentValue)) {
            $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
            $this->process->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
            }
        } else {
            $this->process->HrefValue = "";
        }
        $this->process->TooltipValue = "";

        // emp_id
        $this->emp_id->HrefValue = "";
        $this->emp_id->TooltipValue = "";

        // rid
        $this->rid->HrefValue = "";
        $this->rid->TooltipValue = "";

        // quantity
        $this->quantity->HrefValue = "";
        $this->quantity->TooltipValue = "";

        // process_from
        $this->process_from->HrefValue = "";
        $this->process_from->TooltipValue = "";

        // process_to
        $this->process_to->HrefValue = "";
        $this->process_to->TooltipValue = "";

        // process_method
        $this->process_method->HrefValue = "";
        $this->process_method->TooltipValue = "";

        // ply
        $this->ply->HrefValue = "";
        $this->ply->TooltipValue = "";

        // rid_new
        $this->rid_new->HrefValue = "";
        $this->rid_new->TooltipValue = "";

        // process_@
        $this->process_->HrefValue = "";
        $this->process_->TooltipValue = "";

        // amount
        $this->amount->HrefValue = "";
        $this->amount->TooltipValue = "";

        // incentive
        $this->incentive->HrefValue = "";
        $this->incentive->TooltipValue = "";

        // final_amount
        $this->final_amount->HrefValue = "";
        $this->final_amount->TooltipValue = "";

        // description
        $this->description->HrefValue = "";
        $this->description->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // payment
        $this->payment->HrefValue = "";
        $this->payment->TooltipValue = "";

        // pp_id
        $this->pp_id->HrefValue = "";
        $this->pp_id->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // location
        $this->location->setupEditAttributes();
        $this->location->PlaceHolder = RemoveHtml($this->location->caption());

        // process
        $this->process->setupEditAttributes();
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->EditValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                    $this->process->EditValue = $this->process->displayValue($arwrk);
                } else {
                    $this->process->EditValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                }
            }
        } else {
            $this->process->EditValue = null;
        }

        // emp_id
        $this->emp_id->setupEditAttributes();
        $this->emp_id->EditValue = $this->emp_id->CurrentValue;
        $this->emp_id->PlaceHolder = RemoveHtml($this->emp_id->caption());

        // rid
        $this->rid->setupEditAttributes();
        if ($this->rid->VirtualValue != "") {
            $this->rid->EditValue = $this->rid->VirtualValue;
        } else {
            $this->rid->EditValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->EditValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->EditValue = FormatNumber($this->rid->CurrentValue, $this->rid->formatPattern());
                    }
                }
            } else {
                $this->rid->EditValue = null;
            }
        }

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
        if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
        }

        // process_from
        $this->process_from->setupEditAttributes();
        $this->process_from->PlaceHolder = RemoveHtml($this->process_from->caption());

        // process_to
        $this->process_to->setupEditAttributes();
        $this->process_to->PlaceHolder = RemoveHtml($this->process_to->caption());

        // process_method
        $this->process_method->setupEditAttributes();
        $this->process_method->EditValue = $this->process_method->options(true);
        $this->process_method->PlaceHolder = RemoveHtml($this->process_method->caption());

        // ply
        $this->ply->setupEditAttributes();
        $this->ply->EditValue = $this->ply->CurrentValue;
        $this->ply->EditValue = FormatNumber($this->ply->EditValue, $this->ply->formatPattern());

        // rid_new
        $this->rid_new->setupEditAttributes();
        $curVal = strval($this->rid_new->CurrentValue);
        if ($curVal != "") {
            $this->rid_new->EditValue = $this->rid_new->lookupCacheOption($curVal);
            if ($this->rid_new->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid_new->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid_new->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->rid_new->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid_new->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid_new->Lookup->renderViewRow($rswrk[0]);
                    $this->rid_new->EditValue = $this->rid_new->displayValue($arwrk);
                } else {
                    $this->rid_new->EditValue = FormatNumber($this->rid_new->CurrentValue, $this->rid_new->formatPattern());
                }
            }
        } else {
            $this->rid_new->EditValue = null;
        }

        // process_@
        $this->process_->setupEditAttributes();
        $this->process_->EditValue = $this->process_->CurrentValue;
        $this->process_->PlaceHolder = RemoveHtml($this->process_->caption());
        if (strval($this->process_->EditValue) != "" && is_numeric($this->process_->EditValue)) {
            $this->process_->EditValue = FormatNumber($this->process_->EditValue, null);
        }

        // amount
        $this->amount->setupEditAttributes();
        $this->amount->EditValue = $this->amount->CurrentValue;
        $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
        if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
            $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
        }

        // incentive
        $this->incentive->setupEditAttributes();
        $this->incentive->EditValue = $this->incentive->CurrentValue;
        $this->incentive->PlaceHolder = RemoveHtml($this->incentive->caption());
        if (strval($this->incentive->EditValue) != "" && is_numeric($this->incentive->EditValue)) {
            $this->incentive->EditValue = FormatNumber($this->incentive->EditValue, null);
        }

        // final_amount
        $this->final_amount->setupEditAttributes();
        $this->final_amount->EditValue = $this->final_amount->CurrentValue;
        $this->final_amount->PlaceHolder = RemoveHtml($this->final_amount->caption());
        if (strval($this->final_amount->EditValue) != "" && is_numeric($this->final_amount->EditValue)) {
            $this->final_amount->EditValue = FormatNumber($this->final_amount->EditValue, null);
        }

        // description
        $this->description->setupEditAttributes();
        if (!$this->description->Raw) {
            $this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
        }
        $this->description->EditValue = $this->description->CurrentValue;
        $this->description->PlaceHolder = RemoveHtml($this->description->caption());

        // remarks
        $this->remarks->setupEditAttributes();
        if (!$this->remarks->Raw) {
            $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
        }
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // payment
        $this->payment->PlaceHolder = RemoveHtml($this->payment->caption());

        // pp_id
        $this->pp_id->setupEditAttributes();
        $this->pp_id->EditValue = $this->pp_id->CurrentValue;
        $this->pp_id->PlaceHolder = RemoveHtml($this->pp_id->caption());
        if (strval($this->pp_id->EditValue) != "" && is_numeric($this->pp_id->EditValue)) {
            $this->pp_id->EditValue = FormatNumber($this->pp_id->EditValue, null);
        }

        // datetime
        $this->datetime->setupEditAttributes();
        $this->datetime->EditValue = FormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->amount->CurrentValue)) {
                $this->amount->Total += $this->amount->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->incentive->CurrentValue)) {
                $this->incentive->Total += $this->incentive->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->final_amount->CurrentValue)) {
                $this->final_amount->Total += $this->final_amount->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->amount->CurrentValue = $this->amount->Total;
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());
            $this->amount->HrefValue = ""; // Clear href value
            $this->incentive->CurrentValue = $this->incentive->Total;
            $this->incentive->ViewValue = $this->incentive->CurrentValue;
            $this->incentive->ViewValue = FormatNumber($this->incentive->ViewValue, $this->incentive->formatPattern());
            $this->incentive->HrefValue = ""; // Clear href value
            $this->final_amount->CurrentValue = $this->final_amount->Total;
            $this->final_amount->ViewValue = $this->final_amount->CurrentValue;
            $this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, $this->final_amount->formatPattern());
            $this->final_amount->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->emp_id);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->process_from);
                    $doc->exportCaption($this->process_to);
                    $doc->exportCaption($this->process_method);
                    $doc->exportCaption($this->ply);
                    $doc->exportCaption($this->rid_new);
                    $doc->exportCaption($this->process_);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->incentive);
                    $doc->exportCaption($this->final_amount);
                    $doc->exportCaption($this->description);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->payment);
                    $doc->exportCaption($this->pp_id);
                    $doc->exportCaption($this->datetime);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->emp_id);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->process_from);
                    $doc->exportCaption($this->process_to);
                    $doc->exportCaption($this->process_method);
                    $doc->exportCaption($this->ply);
                    $doc->exportCaption($this->rid_new);
                    $doc->exportCaption($this->process_);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->incentive);
                    $doc->exportCaption($this->final_amount);
                    $doc->exportCaption($this->description);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->payment);
                    $doc->exportCaption($this->pp_id);
                    $doc->exportCaption($this->datetime);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->location);
                        $doc->exportField($this->process);
                        $doc->exportField($this->emp_id);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->process_from);
                        $doc->exportField($this->process_to);
                        $doc->exportField($this->process_method);
                        $doc->exportField($this->ply);
                        $doc->exportField($this->rid_new);
                        $doc->exportField($this->process_);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->incentive);
                        $doc->exportField($this->final_amount);
                        $doc->exportField($this->description);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->payment);
                        $doc->exportField($this->pp_id);
                        $doc->exportField($this->datetime);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->location);
                        $doc->exportField($this->process);
                        $doc->exportField($this->emp_id);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->process_from);
                        $doc->exportField($this->process_to);
                        $doc->exportField($this->process_method);
                        $doc->exportField($this->ply);
                        $doc->exportField($this->rid_new);
                        $doc->exportField($this->process_);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->incentive);
                        $doc->exportField($this->final_amount);
                        $doc->exportField($this->description);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->payment);
                        $doc->exportField($this->pp_id);
                        $doc->exportField($this->datetime);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->id, '');
                $doc->exportAggregate($this->location, '');
                $doc->exportAggregate($this->process, '');
                $doc->exportAggregate($this->emp_id, '');
                $doc->exportAggregate($this->rid, '');
                $doc->exportAggregate($this->quantity, '');
                $doc->exportAggregate($this->process_from, '');
                $doc->exportAggregate($this->process_to, '');
                $doc->exportAggregate($this->process_method, '');
                $doc->exportAggregate($this->ply, '');
                $doc->exportAggregate($this->rid_new, '');
                $doc->exportAggregate($this->process_, '');
                $doc->exportAggregate($this->amount, 'TOTAL');
                $doc->exportAggregate($this->incentive, 'TOTAL');
                $doc->exportAggregate($this->final_amount, 'TOTAL');
                $doc->exportAggregate($this->description, '');
                $doc->exportAggregate($this->remarks, '');
                $doc->exportAggregate($this->payment, '');
                $doc->exportAggregate($this->pp_id, '');
                $doc->exportAggregate($this->datetime, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUserIdentifier(), $typ, 'process_action_material_payment');
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'process_action_material_payment', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DataType::DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'process_action_material_payment', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'process_action_material_payment', $fldname, $key, $oldvalue);
            }
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
