<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProcessActionMaterialOldSearch extends ProcessActionMaterialOld
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProcessActionMaterialOldSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "processactionmaterialoldsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->site->setVisibility();
        $this->process->setVisibility();
        $this->poid->setVisibility();
        $this->jc_no->setVisibility();
        $this->emp_name->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->rid_2->Visible = false;
        $this->quantity->setVisibility();
        $this->packets->setVisibility();
        $this->lot_no->setVisibility();
        $this->packing->setVisibility();
        $this->godown->setVisibility();
        $this->company_id->Visible = false;
        $this->sub_process->setVisibility();
        $this->process_method->setVisibility();
        $this->ply->setVisibility();
        $this->rid_new->setVisibility();
        $this->remark->setVisibility();
        $this->payment->setVisibility();
        $this->dated->setVisibility();
        $this->opeartor->setVisibility();
        $this->datetime->setVisibility();
        $this->rid_new_lot_no->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'process_action_material_old';
        $this->TableName = 'process_action_material_old';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (process_action_material_old)
        if (!isset($GLOBALS["process_action_material_old"]) || $GLOBALS["process_action_material_old"]::class == PROJECT_NAMESPACE . "process_action_material_old") {
            $GLOBALS["process_action_material_old"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_action_material_old');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "processactionmaterialoldview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->site);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->jc_no);
        $this->setupLookupOptions($this->emp_name);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->rid_2);
        $this->setupLookupOptions($this->packing);
        $this->setupLookupOptions($this->godown);
        $this->setupLookupOptions($this->sub_process);
        $this->setupLookupOptions($this->process_method);
        $this->setupLookupOptions($this->rid_new);
        $this->setupLookupOptions($this->payment);
        $this->setupLookupOptions($this->opeartor);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "processactionmaterialoldlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->site); // site
        $this->buildSearchUrl($srchUrl, $this->process); // process
        $this->buildSearchUrl($srchUrl, $this->poid); // poid
        $this->buildSearchUrl($srchUrl, $this->jc_no); // jc_no
        $this->buildSearchUrl($srchUrl, $this->emp_name); // emp_name
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
        $this->buildSearchUrl($srchUrl, $this->product); // product
        $this->buildSearchUrl($srchUrl, $this->rid); // rid
        $this->buildSearchUrl($srchUrl, $this->quantity); // quantity
        $this->buildSearchUrl($srchUrl, $this->packets); // packets
        $this->buildSearchUrl($srchUrl, $this->lot_no); // lot_no
        $this->buildSearchUrl($srchUrl, $this->packing); // packing
        $this->buildSearchUrl($srchUrl, $this->godown); // godown
        $this->buildSearchUrl($srchUrl, $this->sub_process); // sub_process
        $this->buildSearchUrl($srchUrl, $this->process_method); // process_method
        $this->buildSearchUrl($srchUrl, $this->ply); // ply
        $this->buildSearchUrl($srchUrl, $this->rid_new); // rid_new
        $this->buildSearchUrl($srchUrl, $this->remark); // remark
        $this->buildSearchUrl($srchUrl, $this->payment); // payment
        $this->buildSearchUrl($srchUrl, $this->dated); // dated
        $this->buildSearchUrl($srchUrl, $this->opeartor); // opeartor
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->rid_new_lot_no); // rid_new_lot_no
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // site
        if ($this->site->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // process
        if ($this->process->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // poid
        if ($this->poid->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // jc_no
        if ($this->jc_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // emp_name
        if ($this->emp_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_grp
        if ($this->s_grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product
        if ($this->product->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // rid
        if ($this->rid->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packets
        if ($this->packets->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // lot_no
        if ($this->lot_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packing
        if ($this->packing->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // godown
        if ($this->godown->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sub_process
        if ($this->sub_process->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // process_method
        if ($this->process_method->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ply
        if ($this->ply->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // rid_new
        if ($this->rid_new->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remark
        if ($this->remark->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // payment
        if ($this->payment->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->payment->AdvancedSearch->SearchValue)) {
            $this->payment->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->payment->AdvancedSearch->SearchValue);
        }
        if (is_array($this->payment->AdvancedSearch->SearchValue2)) {
            $this->payment->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->payment->AdvancedSearch->SearchValue2);
        }

        // dated
        if ($this->dated->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // opeartor
        if ($this->opeartor->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // rid_new_lot_no
        if ($this->rid_new_lot_no->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // site
        $this->site->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // poid
        $this->poid->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // emp_name
        $this->emp_name->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // rid_2
        $this->rid_2->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // packets
        $this->packets->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // packing
        $this->packing->RowCssClass = "row";

        // godown
        $this->godown->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // sub_process
        $this->sub_process->RowCssClass = "row";

        // process_method
        $this->process_method->RowCssClass = "row";

        // ply
        $this->ply->RowCssClass = "row";

        // rid_new
        $this->rid_new->RowCssClass = "row";

        // remark
        $this->remark->RowCssClass = "row";

        // payment
        $this->payment->RowCssClass = "row";

        // dated
        $this->dated->RowCssClass = "row";

        // opeartor
        $this->opeartor->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // rid_new_lot_no
        $this->rid_new_lot_no->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // site
            $curVal = strval($this->site->CurrentValue);
            if ($curVal != "") {
                $this->site->ViewValue = $this->site->lookupCacheOption($curVal);
                if ($this->site->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->site->getSelectFilter($this); // PHP
                    $sqlWrk = $this->site->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->site->Lookup->renderViewRow($rswrk[0]);
                        $this->site->ViewValue = $this->site->displayValue($arwrk);
                    } else {
                        $this->site->ViewValue = FormatNumber($this->site->CurrentValue, $this->site->formatPattern());
                    }
                }
            } else {
                $this->site->ViewValue = null;
            }

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // poid
            $this->poid->ViewValue = $this->poid->CurrentValue;

            // jc_no
            $curVal = strval($this->jc_no->CurrentValue);
            if ($curVal != "") {
                $this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
                if ($this->jc_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->jc_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->jc_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->jc_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->jc_no->Lookup->renderViewRow($rswrk[0]);
                        $this->jc_no->ViewValue = $this->jc_no->displayValue($arwrk);
                    } else {
                        $this->jc_no->ViewValue = FormatNumber($this->jc_no->CurrentValue, $this->jc_no->formatPattern());
                    }
                }
            } else {
                $this->jc_no->ViewValue = null;
            }

            // emp_name
            $curVal = strval($this->emp_name->CurrentValue);
            if ($curVal != "") {
                $this->emp_name->ViewValue = $this->emp_name->lookupCacheOption($curVal);
                if ($this->emp_name->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->emp_name->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->emp_name->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->emp_name->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->emp_name->Lookup->renderViewRow($rswrk[0]);
                        $this->emp_name->ViewValue = $this->emp_name->displayValue($arwrk);
                    } else {
                        $this->emp_name->ViewValue = $this->emp_name->CurrentValue;
                    }
                }
            } else {
                $this->emp_name->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = FormatNumber($this->product->CurrentValue, $this->product->formatPattern());
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            if ($this->rid->VirtualValue != "") {
                $this->rid->ViewValue = $this->rid->VirtualValue;
            } else {
                $this->rid->ViewValue = $this->rid->CurrentValue;
                $curVal = strval($this->rid->CurrentValue);
                if ($curVal != "") {
                    $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                    if ($this->rid->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                            $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                        } else {
                            $this->rid->ViewValue = $this->rid->CurrentValue;
                        }
                    }
                } else {
                    $this->rid->ViewValue = null;
                }
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // packets
            $this->packets->ViewValue = $this->packets->CurrentValue;
            $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

            // lot_no
            $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

            // packing
            $this->packing->ViewValue = $this->packing->CurrentValue;
            $curVal = strval($this->packing->CurrentValue);
            if ($curVal != "") {
                $this->packing->ViewValue = $this->packing->lookupCacheOption($curVal);
                if ($this->packing->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing->Lookup->renderViewRow($rswrk[0]);
                        $this->packing->ViewValue = $this->packing->displayValue($arwrk);
                    } else {
                        $this->packing->ViewValue = $this->packing->CurrentValue;
                    }
                }
            } else {
                $this->packing->ViewValue = null;
            }

            // godown
            $this->godown->ViewValue = $this->godown->CurrentValue;
            $curVal = strval($this->godown->CurrentValue);
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                        $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                    } else {
                        $this->godown->ViewValue = FormatNumber($this->godown->CurrentValue, $this->godown->formatPattern());
                    }
                }
            } else {
                $this->godown->ViewValue = null;
            }

            // sub_process
            $curVal = strval($this->sub_process->CurrentValue);
            if ($curVal != "") {
                $this->sub_process->ViewValue = $this->sub_process->lookupCacheOption($curVal);
                if ($this->sub_process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->sub_process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->sub_process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->sub_process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->sub_process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sub_process->Lookup->renderViewRow($rswrk[0]);
                        $this->sub_process->ViewValue = $this->sub_process->displayValue($arwrk);
                    } else {
                        $this->sub_process->ViewValue = FormatNumber($this->sub_process->CurrentValue, $this->sub_process->formatPattern());
                    }
                }
            } else {
                $this->sub_process->ViewValue = null;
            }

            // process_method
            if (strval($this->process_method->CurrentValue) != "") {
                $this->process_method->ViewValue = $this->process_method->optionCaption($this->process_method->CurrentValue);
            } else {
                $this->process_method->ViewValue = null;
            }

            // ply
            $this->ply->ViewValue = $this->ply->CurrentValue;
            $this->ply->ViewValue = FormatNumber($this->ply->ViewValue, $this->ply->formatPattern());

            // rid_new
            $curVal = strval($this->rid_new->CurrentValue);
            if ($curVal != "") {
                $this->rid_new->ViewValue = $this->rid_new->lookupCacheOption($curVal);
                if ($this->rid_new->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid_new->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid_new->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid_new->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid_new->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid_new->Lookup->renderViewRow($rswrk[0]);
                        $this->rid_new->ViewValue = $this->rid_new->displayValue($arwrk);
                    } else {
                        $this->rid_new->ViewValue = FormatNumber($this->rid_new->CurrentValue, $this->rid_new->formatPattern());
                    }
                }
            } else {
                $this->rid_new->ViewValue = null;
            }

            // remark
            $this->remark->ViewValue = $this->remark->CurrentValue;

            // payment
            $curVal = strval($this->payment->CurrentValue);
            if ($curVal != "") {
                $this->payment->ViewValue = $this->payment->lookupCacheOption($curVal);
                if ($this->payment->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->payment->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->payment->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->payment->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->payment->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->payment->Lookup->renderViewRow($row);
                            $this->payment->ViewValue->add($this->payment->displayValue($arwrk));
                        }
                    } else {
                        $this->payment->ViewValue = $this->payment->CurrentValue;
                    }
                }
            } else {
                $this->payment->ViewValue = null;
            }

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // opeartor
            $this->opeartor->ViewValue = $this->opeartor->CurrentValue;
            $curVal = strval($this->opeartor->CurrentValue);
            if ($curVal != "") {
                $this->opeartor->ViewValue = $this->opeartor->lookupCacheOption($curVal);
                if ($this->opeartor->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->opeartor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->opeartor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->opeartor->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->opeartor->Lookup->renderViewRow($rswrk[0]);
                        $this->opeartor->ViewValue = $this->opeartor->displayValue($arwrk);
                    } else {
                        $this->opeartor->ViewValue = FormatNumber($this->opeartor->CurrentValue, $this->opeartor->formatPattern());
                    }
                }
            } else {
                $this->opeartor->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // rid_new_lot_no
            $this->rid_new_lot_no->ViewValue = $this->rid_new_lot_no->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // site
            $this->site->HrefValue = "";
            $this->site->TooltipValue = "";

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }
            $this->process->TooltipValue = "";

            // poid
            $this->poid->HrefValue = "";
            $this->poid->TooltipValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";
            $this->jc_no->TooltipValue = "";

            // emp_name
            $this->emp_name->HrefValue = "";
            $this->emp_name->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // product
            $this->product->HrefValue = "";
            $this->product->TooltipValue = "";

            // rid
            $this->rid->HrefValue = "";
            $this->rid->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // packets
            $this->packets->HrefValue = "";
            $this->packets->TooltipValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";
            $this->lot_no->TooltipValue = "";

            // packing
            $this->packing->HrefValue = "";
            $this->packing->TooltipValue = "";

            // godown
            $this->godown->HrefValue = "";
            $this->godown->TooltipValue = "";

            // sub_process
            $this->sub_process->HrefValue = "";
            $this->sub_process->TooltipValue = "";

            // process_method
            $this->process_method->HrefValue = "";
            $this->process_method->TooltipValue = "";

            // ply
            $this->ply->HrefValue = "";
            $this->ply->TooltipValue = "";

            // rid_new
            $this->rid_new->HrefValue = "";
            $this->rid_new->TooltipValue = "";

            // remark
            $this->remark->HrefValue = "";
            $this->remark->TooltipValue = "";

            // payment
            $this->payment->HrefValue = "";
            $this->payment->TooltipValue = "";

            // dated
            $this->dated->HrefValue = "";
            $this->dated->TooltipValue = "";

            // opeartor
            $this->opeartor->HrefValue = "";
            $this->opeartor->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // rid_new_lot_no
            $this->rid_new_lot_no->HrefValue = "";
            $this->rid_new_lot_no->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // site
            $this->site->setupEditAttributes();
            $curVal = trim(strval($this->site->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->site->AdvancedSearch->ViewValue = $this->site->lookupCacheOption($curVal);
            } else {
                $this->site->AdvancedSearch->ViewValue = $this->site->Lookup !== null && is_array($this->site->lookupOptions()) && count($this->site->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->site->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->site->EditValue = array_values($this->site->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->site->AdvancedSearch->SearchValue, $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->site->getSelectFilter($this); // PHP
                $sqlWrk = $this->site->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->site->EditValue = $arwrk;
            }
            $this->site->PlaceHolder = RemoveHtml($this->site->caption());

            // process
            $this->process->setupEditAttributes();
            $curVal = trim(strval($this->process->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->process->AdvancedSearch->ViewValue = $this->process->lookupCacheOption($curVal);
            } else {
                $this->process->AdvancedSearch->ViewValue = $this->process->Lookup !== null && is_array($this->process->lookupOptions()) && count($this->process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->process->EditValue = array_values($this->process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->process->AdvancedSearch->SearchValue, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process->EditValue = $arwrk;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // poid
            $this->poid->setupEditAttributes();
            $this->poid->EditCustomAttributes = $this->poid->getEditCustomAttributes(); // PHP
            if (!$this->poid->Raw) {
                $this->poid->AdvancedSearch->SearchValue = HtmlDecode($this->poid->AdvancedSearch->SearchValue);
            }
            $this->poid->EditValue = HtmlEncode($this->poid->AdvancedSearch->SearchValue);
            $this->poid->PlaceHolder = RemoveHtml($this->poid->caption());

            // jc_no
            $this->jc_no->setupEditAttributes();
            $curVal = trim(strval($this->jc_no->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->jc_no->AdvancedSearch->ViewValue = $this->jc_no->lookupCacheOption($curVal);
            } else {
                $this->jc_no->AdvancedSearch->ViewValue = $this->jc_no->Lookup !== null && is_array($this->jc_no->lookupOptions()) && count($this->jc_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->jc_no->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->jc_no->EditValue = array_values($this->jc_no->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->jc_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->jc_no->AdvancedSearch->SearchValue, $this->jc_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->jc_no->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->jc_no->Lookup->renderViewRow($row);
                }
                $this->jc_no->EditValue = $arwrk;
            }
            $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

            // emp_name
            $this->emp_name->setupEditAttributes();
            $curVal = trim(strval($this->emp_name->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->emp_name->AdvancedSearch->ViewValue = $this->emp_name->lookupCacheOption($curVal);
            } else {
                $this->emp_name->AdvancedSearch->ViewValue = $this->emp_name->Lookup !== null && is_array($this->emp_name->lookupOptions()) && count($this->emp_name->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->emp_name->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->emp_name->EditValue = array_values($this->emp_name->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->emp_name->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->emp_name->AdvancedSearch->SearchValue, $this->emp_name->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->emp_name->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->emp_name->Lookup->renderViewRow($row);
                }
                $this->emp_name->EditValue = $arwrk;
            }
            $this->emp_name->PlaceHolder = RemoveHtml($this->emp_name->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->AdvancedSearch->SearchValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->product->AdvancedSearch->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->AdvancedSearch->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->AdvancedSearch->SearchValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid
            $this->rid->setupEditAttributes();
            $this->rid->EditValue = $this->rid->AdvancedSearch->SearchValue;
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->AdvancedSearch->SearchValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

            // packets
            $this->packets->setupEditAttributes();
            $this->packets->EditValue = $this->packets->AdvancedSearch->SearchValue;
            $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

            // lot_no
            $this->lot_no->setupEditAttributes();
            $this->lot_no->EditCustomAttributes = $this->lot_no->getEditCustomAttributes(); // PHP
            if (!$this->lot_no->Raw) {
                $this->lot_no->AdvancedSearch->SearchValue = HtmlDecode($this->lot_no->AdvancedSearch->SearchValue);
            }
            $this->lot_no->EditValue = HtmlEncode($this->lot_no->AdvancedSearch->SearchValue);
            $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

            // packing
            $this->packing->setupEditAttributes();
            $this->packing->EditValue = $this->packing->AdvancedSearch->SearchValue;
            $curVal = strval($this->packing->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->packing->EditValue = $this->packing->lookupCacheOption($curVal);
                if ($this->packing->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing->Lookup->renderViewRow($rswrk[0]);
                        $this->packing->EditValue = $this->packing->displayValue($arwrk);
                    } else {
                        $this->packing->EditValue = HtmlEncode($this->packing->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->packing->EditValue = null;
            }
            $this->packing->PlaceHolder = RemoveHtml($this->packing->caption());

            // godown
            $this->godown->setupEditAttributes();
            $this->godown->EditCustomAttributes = $this->godown->getEditCustomAttributes(); // PHP
            $this->godown->EditValue = $this->godown->AdvancedSearch->SearchValue;
            $curVal = strval($this->godown->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->godown->EditValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                        $this->godown->EditValue = $this->godown->displayValue($arwrk);
                    } else {
                        $this->godown->EditValue = HtmlEncode(FormatNumber($this->godown->AdvancedSearch->SearchValue, $this->godown->formatPattern()));
                    }
                }
            } else {
                $this->godown->EditValue = null;
            }
            $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

            // sub_process
            $this->sub_process->setupEditAttributes();
            $curVal = trim(strval($this->sub_process->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->sub_process->AdvancedSearch->ViewValue = $this->sub_process->lookupCacheOption($curVal);
            } else {
                $this->sub_process->AdvancedSearch->ViewValue = $this->sub_process->Lookup !== null && is_array($this->sub_process->lookupOptions()) && count($this->sub_process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->sub_process->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->sub_process->EditValue = array_values($this->sub_process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->sub_process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->sub_process->AdvancedSearch->SearchValue, $this->sub_process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->sub_process->getSelectFilter($this); // PHP
                $sqlWrk = $this->sub_process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->sub_process->EditValue = $arwrk;
            }
            $this->sub_process->PlaceHolder = RemoveHtml($this->sub_process->caption());

            // process_method
            $this->process_method->setupEditAttributes();
            $this->process_method->EditValue = $this->process_method->options(true);
            $this->process_method->PlaceHolder = RemoveHtml($this->process_method->caption());

            // ply
            $this->ply->setupEditAttributes();
            $this->ply->EditValue = $this->ply->AdvancedSearch->SearchValue;
            $this->ply->PlaceHolder = RemoveHtml($this->ply->caption());

            // rid_new
            $this->rid_new->setupEditAttributes();
            $curVal = trim(strval($this->rid_new->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->rid_new->AdvancedSearch->ViewValue = $this->rid_new->lookupCacheOption($curVal);
            } else {
                $this->rid_new->AdvancedSearch->ViewValue = $this->rid_new->Lookup !== null && is_array($this->rid_new->lookupOptions()) && count($this->rid_new->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid_new->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->rid_new->EditValue = array_values($this->rid_new->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid_new->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid_new->AdvancedSearch->SearchValue, $this->rid_new->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->rid_new->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid_new->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->rid_new->EditValue = $arwrk;
            }
            $this->rid_new->PlaceHolder = RemoveHtml($this->rid_new->caption());

            // remark
            $this->remark->setupEditAttributes();
            if (!$this->remark->Raw) {
                $this->remark->AdvancedSearch->SearchValue = HtmlDecode($this->remark->AdvancedSearch->SearchValue);
            }
            $this->remark->EditValue = HtmlEncode($this->remark->AdvancedSearch->SearchValue);
            $this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

            // payment
            $curVal = trim(strval($this->payment->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->payment->AdvancedSearch->ViewValue = $this->payment->lookupCacheOption($curVal);
            } else {
                $this->payment->AdvancedSearch->ViewValue = $this->payment->Lookup !== null && is_array($this->payment->lookupOptions()) && count($this->payment->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->payment->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->payment->EditValue = array_values($this->payment->lookupOptions());
                if ($this->payment->AdvancedSearch->ViewValue == "") {
                    $this->payment->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->payment->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->payment->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->payment->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->payment->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->payment->Lookup->renderViewRow($row);
                        $this->payment->AdvancedSearch->ViewValue->add($this->payment->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->payment->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->payment->EditValue = $arwrk;
            }
            $this->payment->PlaceHolder = RemoveHtml($this->payment->caption());
            $curVal = trim(strval($this->payment->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->payment->AdvancedSearch->ViewValue2 = $this->payment->lookupCacheOption($curVal);
            } else {
                $this->payment->AdvancedSearch->ViewValue2 = $this->payment->Lookup !== null && is_array($this->payment->lookupOptions()) && count($this->payment->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->payment->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->payment->EditValue2 = array_values($this->payment->lookupOptions());
                if ($this->payment->AdvancedSearch->ViewValue2 == "") {
                    $this->payment->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->payment->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->payment->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->payment->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->payment->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->payment->Lookup->renderViewRow($row);
                        $this->payment->AdvancedSearch->ViewValue2->add($this->payment->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->payment->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->payment->EditValue2 = $arwrk;
            }
            $this->payment->PlaceHolder = RemoveHtml($this->payment->caption());

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dated->AdvancedSearch->SearchValue, $this->dated->formatPattern()), $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

            // opeartor
            $this->opeartor->setupEditAttributes();
            $this->opeartor->EditValue = $this->opeartor->AdvancedSearch->SearchValue;
            $curVal = strval($this->opeartor->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->opeartor->EditValue = $this->opeartor->lookupCacheOption($curVal);
                if ($this->opeartor->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->opeartor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->opeartor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->opeartor->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->opeartor->Lookup->renderViewRow($rswrk[0]);
                        $this->opeartor->EditValue = $this->opeartor->displayValue($arwrk);
                    } else {
                        $this->opeartor->EditValue = HtmlEncode(FormatNumber($this->opeartor->AdvancedSearch->SearchValue, $this->opeartor->formatPattern()));
                    }
                }
            } else {
                $this->opeartor->EditValue = null;
            }
            $this->opeartor->PlaceHolder = RemoveHtml($this->opeartor->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // rid_new_lot_no
            $this->rid_new_lot_no->setupEditAttributes();
            if (!$this->rid_new_lot_no->Raw) {
                $this->rid_new_lot_no->AdvancedSearch->SearchValue = HtmlDecode($this->rid_new_lot_no->AdvancedSearch->SearchValue);
            }
            $this->rid_new_lot_no->EditValue = HtmlEncode($this->rid_new_lot_no->AdvancedSearch->SearchValue);
            $this->rid_new_lot_no->PlaceHolder = RemoveHtml($this->rid_new_lot_no->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckNumber($this->quantity->AdvancedSearch->SearchValue)) {
            $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
        }
        if (!CheckNumber($this->packets->AdvancedSearch->SearchValue)) {
            $this->packets->addErrorMessage($this->packets->getErrorMessage(false));
        }
        if (!CheckInteger($this->packing->AdvancedSearch->SearchValue)) {
            $this->packing->addErrorMessage($this->packing->getErrorMessage(false));
        }
        if (!CheckInteger($this->godown->AdvancedSearch->SearchValue)) {
            $this->godown->addErrorMessage($this->godown->getErrorMessage(false));
        }
        if (!CheckInteger($this->ply->AdvancedSearch->SearchValue)) {
            $this->ply->addErrorMessage($this->ply->getErrorMessage(false));
        }
        if (!CheckDate($this->dated->AdvancedSearch->SearchValue, $this->dated->formatPattern())) {
            $this->dated->addErrorMessage($this->dated->getErrorMessage(false));
        }
        if (!CheckInteger($this->opeartor->AdvancedSearch->SearchValue)) {
            $this->opeartor->addErrorMessage($this->opeartor->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->site->AdvancedSearch->load();
        $this->process->AdvancedSearch->load();
        $this->poid->AdvancedSearch->load();
        $this->jc_no->AdvancedSearch->load();
        $this->emp_name->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->rid->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->packets->AdvancedSearch->load();
        $this->lot_no->AdvancedSearch->load();
        $this->packing->AdvancedSearch->load();
        $this->godown->AdvancedSearch->load();
        $this->sub_process->AdvancedSearch->load();
        $this->process_method->AdvancedSearch->load();
        $this->ply->AdvancedSearch->load();
        $this->rid_new->AdvancedSearch->load();
        $this->remark->AdvancedSearch->load();
        $this->payment->AdvancedSearch->load();
        $this->dated->AdvancedSearch->load();
        $this->opeartor->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->rid_new_lot_no->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("processactionmaterialoldlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_site":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_jc_no":
                    break;
                case "x_emp_name":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    break;
                case "x_rid_2":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_godown":
                    break;
                case "x_sub_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_method":
                    break;
                case "x_rid_new":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_payment":
                    break;
                case "x_opeartor":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
