<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for process_action_material_old
 */
class ProcessActionMaterialOld extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $site;
    public $process;
    public $poid;
    public $jc_no;
    public $emp_name;
    public $grp;
    public $s_grp;
    public $product;
    public $rid;
    public $rid_2;
    public $quantity;
    public $packets;
    public $lot_no;
    public $packing;
    public $godown;
    public $company_id;
    public $sub_process;
    public $process_method;
    public $ply;
    public $rid_new;
    public $remark;
    public $payment;
    public $dated;
    public $opeartor;
    public $datetime;
    public $rid_new_lot_no;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "process_action_material_old";
        $this->TableName = 'process_action_material_old';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "process_action_material_old";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // site
        $this->site = new DbField(
            $this, // Table
            'x_site', // Variable name
            'site', // Name
            '`site`', // Expression
            '`site`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`site`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->site->addMethod("getSelectFilter", fn() => (User_Site() == 0) ? "`status` = 1 and `id` > 0 && `id` != 10" : "`status` = 1 and `id` > 0 && `id` != 10 and FIND_IN_SET(`id`,". User_Site() .")");
        $this->site->addMethod("getDefault", fn() => ((isset($_COOKIE["Location"]))? $_COOKIE["Location"]:''));
        $this->site->InputTextType = "text";
        $this->site->Raw = true;
        $this->site->Nullable = false; // NOT NULL field
        $this->site->Required = true; // Required field
        $this->site->setSelectMultiple(false); // Select one
        $this->site->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->site->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->site->Lookup = new Lookup($this->site, 'godown_table', false, 'id', ["name","code","",""], '', '', [], ["x_emp_name","x_rid_2"], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->site) . "',COALESCE(`code`,''))");
        $this->site->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->site->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['site'] = &$this->site;

        // process
        $this->process = new DbField(
            $this, // Table
            'x_process', // Variable name
            'process', // Name
            '`process`', // Expression
            '`process`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process->addMethod("getSelectFilter", fn() => "`status` = 1 and `type_cat` = 101");
        $this->process->addMethod("getDefault", fn() => ((isset($_COOKIE["PROC"]))? $_COOKIE["PROC"]:''));
        $this->process->addMethod("getLinkPrefix", fn() => "processactionlist?x_process=");
        $this->process->InputTextType = "text";
        $this->process->Raw = true;
        $this->process->Nullable = false; // NOT NULL field
        $this->process->Required = true; // Required field
        $this->process->setSelectMultiple(false); // Select one
        $this->process->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->process->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->process->Lookup = new Lookup($this->process, 'sub_process_type', true, 'id', ["name","","",""], '', '', [], ["x_jc_no","x_emp_name"], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['process'] = &$this->process;

        // poid
        $this->poid = new DbField(
            $this, // Table
            'x_poid', // Variable name
            'poid', // Name
            '`poid`', // Expression
            '`poid`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`poid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->poid->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->poid->addMethod("getDefault", fn() => 0);
        $this->poid->InputTextType = "text";
        $this->poid->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['poid'] = &$this->poid;

        // jc_no
        $this->jc_no = new DbField(
            $this, // Table
            'x_jc_no', // Variable name
            'jc_no', // Name
            '`jc_no`', // Expression
            '`jc_no`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->jc_no->InputTextType = "text";
        $this->jc_no->Raw = true;
        $this->jc_no->Nullable = false; // NOT NULL field
        $this->jc_no->setSelectMultiple(false); // Select one
        $this->jc_no->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->jc_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->jc_no->Lookup = new Lookup($this->jc_no, 'job_card', false, 'id', ["jc_no","product_code","",""], '', '', ["x_process"], [], ["pro_unit"], ["x_pro_unit"], ["grp","s_grp","product","packing_type"], ["x_grp","x_s_grp","x_product","x_packing"], false, '`item` ASC', '', "CONCAT(COALESCE(`jc_no`, ''),'" . ValueSeparator(1, $this->jc_no) . "',COALESCE(`product_code`,''))");
        $this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_no->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['jc_no'] = &$this->jc_no;

        // emp_name
        $this->emp_name = new DbField(
            $this, // Table
            'x_emp_name', // Variable name
            'emp_name', // Name
            '`emp_name`', // Expression
            '`emp_name`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`emp_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->emp_name->InputTextType = "text";
        $this->emp_name->Nullable = false; // NOT NULL field
        $this->emp_name->Required = true; // Required field
        $this->emp_name->setSelectMultiple(false); // Select one
        $this->emp_name->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->emp_name->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->emp_name->Lookup = new Lookup($this->emp_name, 'production_employee_view_pw', true, 'id', ["id","user_name","",""], '', '', ["x_process","x_site"], [], ["process","site"], ["x_process","x_site"], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->emp_name) . "',COALESCE(`user_name`,''))");
        $this->emp_name->SearchOperators = ["=", "<>"];
        $this->Fields['emp_name'] = &$this->emp_name;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getSelectFilter", fn() => "`status`=1 and `type`=2");
        $this->grp->addMethod("getDefault", fn() => (isset($_GET['GRP'])) ? $_GET['GRP'] :((isset($_COOKIE['GRP'])) ? $_COOKIE['GRP'] : 2));
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Required = true; // Required field
        $this->grp->Sortable = false; // Allow sort
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'grp', false, 'id', ["grp","","",""], '', '', [], ["x_s_grp"], [], [], [], [], true, '`grp` ASC', '', "`grp`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['grp'] = &$this->grp;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->s_grp->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->s_grp->addMethod("getDefault", fn() => (isset($_GET['SGRP']))  ? $_GET['SGRP'] : ((isset($_COOKIE['SGRP']))  ? $_COOKIE['SGRP'] : ''));
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->Required = true; // Required field
        $this->s_grp->Sortable = false; // Allow sort
        $this->s_grp->setSelectMultiple(false); // Select one
        $this->s_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->s_grp->Lookup = new Lookup($this->s_grp, 'product_group', false, 'id', ["product_group","","",""], '', '', ["x_grp"], ["x_product"], ["grp"], ["x_grp"], [], [], true, '`product_group` ASC', '', "`product_group`");
        $this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->s_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->product->addMethod("getDefault", fn() => (isset($_GET['PR']))  ? $_GET['PR'] : ((isset($_COOKIE['PR']))  ? $_COOKIE['PR'] : ''));
        $this->product->InputTextType = "text";
        $this->product->Raw = true;
        $this->product->Required = true; // Required field
        $this->product->Sortable = false; // Allow sort
        $this->product->setSelectMultiple(false); // Select one
        $this->product->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product->Lookup = new Lookup($this->product, 'product', false, 'id', ["product","","",""], '', '', ["x_s_grp"], ["x_rid_2"], ["s_grp"], ["x_s_grp[]"], [], [], true, '`product` ASC', '', "`product`");
        $this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['product'] = &$this->product;

        // rid
        $this->rid = new DbField(
            $this, // Table
            'x_rid', // Variable name
            'rid', // Name
            '`rid`', // Expression
            '`rid`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__rid', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rid->InputTextType = "text";
        $this->rid->Raw = true;
        $this->rid->Nullable = false; // NOT NULL field
        $this->rid->Required = true; // Required field
        $this->rid->Lookup = new Lookup($this->rid, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], true, '`product_code` ASC', '', "`product_code`");
        $this->rid->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['rid'] = &$this->rid;

        // rid_2
        $this->rid_2 = new DbField(
            $this, // Table
            'x_rid_2', // Variable name
            'rid_2', // Name
            '`rid_2`', // Expression
            '`rid_2`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid_2`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->rid_2->addMethod("getSelectFilter", fn() => (isset($_GET['RID1'])) ? ("`rid` = ". $_GET['RID1'] ." and `Balance` > 0") :  ("`Balance` > 0"));
        $this->rid_2->InputTextType = "text";
        $this->rid_2->Sortable = false; // Allow sort
        $this->rid_2->setSelectMultiple(false); // Select one
        $this->rid_2->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->rid_2->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->rid_2->Lookup = new Lookup($this->rid_2, 'stock_lcgp', false, 'id', ["product_code","packing_type_n","lot_no","Balance"], '', '', ["x_product","x_site","x_packing"], [], ["product","godown","packing_type"], ["x_product","x_godown","x_packing_type"], ["rid","godown","lot_no"], ["x_rid","x_godown","x_lot_no"], false, '`product_code` ASC', '', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->rid_2) . "',COALESCE(`packing_type_n`,''),'" . ValueSeparator(2, $this->rid_2) . "',COALESCE(`lot_no`,''),'" . ValueSeparator(3, $this->rid_2) . "',COALESCE(`Balance`,''))");
        $this->rid_2->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['rid_2'] = &$this->rid_2;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->Nullable = false; // NOT NULL field
        $this->quantity->Required = true; // Required field
        $this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['quantity'] = &$this->quantity;

        // packets
        $this->packets = new DbField(
            $this, // Table
            'x_packets', // Variable name
            'packets', // Name
            '`packets`', // Expression
            '`packets`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packets`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packets->InputTextType = "text";
        $this->packets->Raw = true;
        $this->packets->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->packets->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packets'] = &$this->packets;

        // lot_no
        $this->lot_no = new DbField(
            $this, // Table
            'x_lot_no', // Variable name
            'lot_no', // Name
            '`lot_no`', // Expression
            '`lot_no`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lot_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lot_no->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->lot_no->InputTextType = "text";
        $this->lot_no->Nullable = false; // NOT NULL field
        $this->lot_no->Required = true; // Required field
        $this->lot_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['lot_no'] = &$this->lot_no;

        // packing
        $this->packing = new DbField(
            $this, // Table
            'x_packing', // Variable name
            'packing', // Name
            '`packing`', // Expression
            '`packing`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packing->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->packing->addMethod("getDefault", fn() => (isset($_GET['PK']))  ? $_GET['PK'] : ((isset($_COOKIE['PK']))  ? $_COOKIE['PK'] : ''));
        $this->packing->InputTextType = "text";
        $this->packing->Raw = true;
        $this->packing->Nullable = false; // NOT NULL field
        $this->packing->Required = true; // Required field
        $this->packing->Lookup = new Lookup($this->packing, 'packing_type_table', true, 'id', ["code","packing","",""], '', '', [], ["x_rid_2"], [], [], [], [], true, '`packing` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->packing) . "',COALESCE(`packing`,''))");
        $this->packing->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packing->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['packing'] = &$this->packing;

        // godown
        $this->godown = new DbField(
            $this, // Table
            'x_godown', // Variable name
            'godown', // Name
            '`godown`', // Expression
            '`godown`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`godown`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->godown->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->godown->InputTextType = "text";
        $this->godown->Raw = true;
        $this->godown->Nullable = false; // NOT NULL field
        $this->godown->Required = true; // Required field
        $this->godown->Sortable = false; // Allow sort
        $this->godown->Lookup = new Lookup($this->godown, 'godown', false, 'id', ["name","code","",""], '', '', [], [], [], [], [], [], true, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->godown) . "',COALESCE(`code`,''))");
        $this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->godown->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['godown'] = &$this->godown;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->company_id->InputTextType = "text";
        $this->company_id->Raw = true;
        $this->company_id->Sortable = false; // Allow sort
        $this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->company_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['company_id'] = &$this->company_id;

        // sub_process
        $this->sub_process = new DbField(
            $this, // Table
            'x_sub_process', // Variable name
            'sub_process', // Name
            '`sub_process`', // Expression
            '`sub_process`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sub_process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->sub_process->addMethod("getSelectFilter", fn() => " `status` = 1");
        $this->sub_process->addMethod("getDefault", fn() => pamot());
        $this->sub_process->InputTextType = "text";
        $this->sub_process->Raw = true;
        $this->sub_process->Nullable = false; // NOT NULL field
        $this->sub_process->Required = true; // Required field
        $this->sub_process->setSelectMultiple(false); // Select one
        $this->sub_process->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->sub_process->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->sub_process->Lookup = new Lookup($this->sub_process, 'packing_type_table', false, 'id', ["packing","code","",""], '', '', [], [], [], [], [], [], false, '`packing` ASC', '', "CONCAT(COALESCE(`packing`, ''),'" . ValueSeparator(1, $this->sub_process) . "',COALESCE(`code`,''))");
        $this->sub_process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->sub_process->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['sub_process'] = &$this->sub_process;

        // process_method
        $this->process_method = new DbField(
            $this, // Table
            'x_process_method', // Variable name
            'process_method', // Name
            '`process_method`', // Expression
            '`process_method`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_method`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process_method->InputTextType = "text";
        $this->process_method->Raw = true;
        $this->process_method->Nullable = false; // NOT NULL field
        $this->process_method->Required = true; // Required field
        $this->process_method->setSelectMultiple(false); // Select one
        $this->process_method->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->process_method->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->process_method->Lookup = new Lookup($this->process_method, 'process_action_material_old', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->process_method->OptionCount = 2;
        $this->process_method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process_method->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['process_method'] = &$this->process_method;

        // ply
        $this->ply = new DbField(
            $this, // Table
            'x_ply', // Variable name
            'ply', // Name
            '`ply`', // Expression
            '`ply`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ply`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ply->InputTextType = "text";
        $this->ply->Raw = true;
        $this->ply->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ply->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ply'] = &$this->ply;

        // rid_new
        $this->rid_new = new DbField(
            $this, // Table
            'x_rid_new', // Variable name
            'rid_new', // Name
            '`rid_new`', // Expression
            '`rid_new`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid_new`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->rid_new->addMethod("getSelectFilter", fn() => "`status`=1 and `product` = 51");
        $this->rid_new->InputTextType = "text";
        $this->rid_new->Raw = true;
        $this->rid_new->setSelectMultiple(false); // Select one
        $this->rid_new->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->rid_new->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->rid_new->Lookup = new Lookup($this->rid_new, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->rid_new->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->rid_new->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['rid_new'] = &$this->rid_new;

        // remark
        $this->remark = new DbField(
            $this, // Table
            'x_remark', // Variable name
            'remark', // Name
            '`remark`', // Expression
            '`remark`', // Basic search expression
            200, // Type
            225, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remark`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->remark->InputTextType = "text";
        $this->remark->Sortable = false; // Allow sort
        $this->remark->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remark'] = &$this->remark;

        // payment
        $this->payment = new DbField(
            $this, // Table
            'x_payment', // Variable name
            'payment', // Name
            '`payment`', // Expression
            '`payment`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->payment->InputTextType = "number";
        $this->payment->Required = true; // Required field
        $this->payment->Lookup = new Lookup($this->payment, 'payment_period', false, 'id', ["payment_description","","",""], '', '', [], [], [], [], [], [], false, '`payment_description` ASC', '', "`payment_description`");
        $this->payment->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->payment->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['payment'] = &$this->payment;

        // dated
        $this->dated = new DbField(
            $this, // Table
            'x_dated', // Variable name
            'dated', // Name
            '`dated`', // Expression
            CastDateFieldForLike("`dated`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`dated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->dated->addMethod("getDefault", fn() => CurrentDate());
        $this->dated->InputTextType = "text";
        $this->dated->Raw = true;
        $this->dated->Nullable = false; // NOT NULL field
        $this->dated->Required = true; // Required field
        $this->dated->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->dated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['dated'] = &$this->dated;

        // opeartor
        $this->opeartor = new DbField(
            $this, // Table
            'x_opeartor', // Variable name
            'opeartor', // Name
            '`opeartor`', // Expression
            '`opeartor`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`opeartor`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->opeartor->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->opeartor->InputTextType = "text";
        $this->opeartor->Raw = true;
        $this->opeartor->Nullable = false; // NOT NULL field
        $this->opeartor->Lookup = new Lookup($this->opeartor, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->opeartor->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->opeartor->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['opeartor'] = &$this->opeartor;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // rid_new_lot_no
        $this->rid_new_lot_no = new DbField(
            $this, // Table
            'x_rid_new_lot_no', // Variable name
            'rid_new_lot_no', // Name
            '`rid_new_lot_no`', // Expression
            '`rid_new_lot_no`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid_new_lot_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rid_new_lot_no->InputTextType = "text";
        $this->rid_new_lot_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['rid_new_lot_no'] = &$this->rid_new_lot_no;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            if ($ctrl) {
                $orderByList = $this->getSessionOrderByList();
                $arOrderBy = !empty($orderByList) ? explode(", ", $orderByList) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderByList = implode(", ", $arOrderBy);
                $this->setSessionOrderByList($orderByList); // Save to Session
            } else {
                $this->setSessionOrderByList($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "process_action_material_old";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ", (SELECT `product_code` FROM ref TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.id = process_action_material_old.rid LIMIT 1) AS EV__rid FROM process_action_material_old)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = (User_Site() == 0)? "" : "FIND_IN_SET(`site`, '" . User_Site() . "')";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if ($this->BasicSearch->getKeyword() != "") {
            return true;
        }
        if (
            $this->rid->AdvancedSearch->SearchValue != "" ||
            $this->rid->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->rid->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->rid->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->site->DbValue = $row['site'];
        $this->process->DbValue = $row['process'];
        $this->poid->DbValue = $row['poid'];
        $this->jc_no->DbValue = $row['jc_no'];
        $this->emp_name->DbValue = $row['emp_name'];
        $this->grp->DbValue = $row['grp'];
        $this->s_grp->DbValue = $row['s_grp'];
        $this->product->DbValue = $row['product'];
        $this->rid->DbValue = $row['rid'];
        $this->rid_2->DbValue = $row['rid_2'];
        $this->quantity->DbValue = $row['quantity'];
        $this->packets->DbValue = $row['packets'];
        $this->lot_no->DbValue = $row['lot_no'];
        $this->packing->DbValue = $row['packing'];
        $this->godown->DbValue = $row['godown'];
        $this->company_id->DbValue = $row['company_id'];
        $this->sub_process->DbValue = $row['sub_process'];
        $this->process_method->DbValue = $row['process_method'];
        $this->ply->DbValue = $row['ply'];
        $this->rid_new->DbValue = $row['rid_new'];
        $this->remark->DbValue = $row['remark'];
        $this->payment->DbValue = $row['payment'];
        $this->dated->DbValue = $row['dated'];
        $this->opeartor->DbValue = $row['opeartor'];
        $this->datetime->DbValue = $row['datetime'];
        $this->rid_new_lot_no->DbValue = $row['rid_new_lot_no'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("processactionmaterialoldlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "processactionmaterialoldview" => $Language->phrase("View"),
            "processactionmaterialoldedit" => $Language->phrase("Edit"),
            "processactionmaterialoldadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "processactionmaterialoldlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "ProcessActionMaterialOldView",
            Config("API_ADD_ACTION") => "ProcessActionMaterialOldAdd",
            Config("API_EDIT_ACTION") => "ProcessActionMaterialOldEdit",
            Config("API_DELETE_ACTION") => "ProcessActionMaterialOldDelete",
            Config("API_LIST_ACTION") => "ProcessActionMaterialOldList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "processactionmaterialoldlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("processactionmaterialoldview", $parm);
        } else {
            $url = $this->keyUrl("processactionmaterialoldview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "processactionmaterialoldadd?" . $parm;
        } else {
            $url = "processactionmaterialoldadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("processactionmaterialoldedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("processactionmaterialoldlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("processactionmaterialoldadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("processactionmaterialoldlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("processactionmaterialolddelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->site->setDbValue($row['site']);
        $this->process->setDbValue($row['process']);
        $this->poid->setDbValue($row['poid']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->emp_name->setDbValue($row['emp_name']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->rid_2->setDbValue($row['rid_2']);
        $this->quantity->setDbValue($row['quantity']);
        $this->packets->setDbValue($row['packets']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->packing->setDbValue($row['packing']);
        $this->godown->setDbValue($row['godown']);
        $this->company_id->setDbValue($row['company_id']);
        $this->sub_process->setDbValue($row['sub_process']);
        $this->process_method->setDbValue($row['process_method']);
        $this->ply->setDbValue($row['ply']);
        $this->rid_new->setDbValue($row['rid_new']);
        $this->remark->setDbValue($row['remark']);
        $this->payment->setDbValue($row['payment']);
        $this->dated->setDbValue($row['dated']);
        $this->opeartor->setDbValue($row['opeartor']);
        $this->datetime->setDbValue($row['datetime']);
        $this->rid_new_lot_no->setDbValue($row['rid_new_lot_no']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "ProcessActionMaterialOldList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // site

        // process

        // poid
        $this->poid->CellCssStyle = "white-space: nowrap;";

        // jc_no

        // emp_name

        // grp
        $this->grp->CellCssStyle = "white-space: nowrap;";

        // s_grp
        $this->s_grp->CellCssStyle = "white-space: nowrap;";

        // product
        $this->product->CellCssStyle = "white-space: nowrap;";

        // rid

        // rid_2
        $this->rid_2->CellCssStyle = "white-space: nowrap;";

        // quantity

        // packets
        $this->packets->CellCssStyle = "white-space: nowrap;";

        // lot_no
        $this->lot_no->CellCssStyle = "white-space: nowrap;";

        // packing
        $this->packing->CellCssStyle = "white-space: nowrap;";

        // godown
        $this->godown->CellCssStyle = "white-space: nowrap;";

        // company_id
        $this->company_id->CellCssStyle = "white-space: nowrap;";

        // sub_process
        $this->sub_process->CellCssStyle = "white-space: nowrap;";

        // process_method

        // ply

        // rid_new

        // remark
        $this->remark->CellCssStyle = "white-space: nowrap;";

        // payment
        $this->payment->CellCssStyle = "white-space: nowrap;";

        // dated

        // opeartor

        // datetime

        // rid_new_lot_no

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // site
        $curVal = strval($this->site->CurrentValue);
        if ($curVal != "") {
            $this->site->ViewValue = $this->site->lookupCacheOption($curVal);
            if ($this->site->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->site->getSelectFilter($this); // PHP
                $sqlWrk = $this->site->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->site->Lookup->renderViewRow($rswrk[0]);
                    $this->site->ViewValue = $this->site->displayValue($arwrk);
                } else {
                    $this->site->ViewValue = FormatNumber($this->site->CurrentValue, $this->site->formatPattern());
                }
            }
        } else {
            $this->site->ViewValue = null;
        }

        // process
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                    $this->process->ViewValue = $this->process->displayValue($arwrk);
                } else {
                    $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                }
            }
        } else {
            $this->process->ViewValue = null;
        }

        // poid
        $this->poid->ViewValue = $this->poid->CurrentValue;

        // jc_no
        $curVal = strval($this->jc_no->CurrentValue);
        if ($curVal != "") {
            $this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
            if ($this->jc_no->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->jc_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->jc_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->jc_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->jc_no->Lookup->renderViewRow($rswrk[0]);
                    $this->jc_no->ViewValue = $this->jc_no->displayValue($arwrk);
                } else {
                    $this->jc_no->ViewValue = FormatNumber($this->jc_no->CurrentValue, $this->jc_no->formatPattern());
                }
            }
        } else {
            $this->jc_no->ViewValue = null;
        }

        // emp_name
        $curVal = strval($this->emp_name->CurrentValue);
        if ($curVal != "") {
            $this->emp_name->ViewValue = $this->emp_name->lookupCacheOption($curVal);
            if ($this->emp_name->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->emp_name->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->emp_name->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->emp_name->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->emp_name->Lookup->renderViewRow($rswrk[0]);
                    $this->emp_name->ViewValue = $this->emp_name->displayValue($arwrk);
                } else {
                    $this->emp_name->ViewValue = $this->emp_name->CurrentValue;
                }
            }
        } else {
            $this->emp_name->ViewValue = null;
        }

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // s_grp
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                }
            }
        } else {
            $this->s_grp->ViewValue = null;
        }

        // product
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = FormatNumber($this->product->CurrentValue, $this->product->formatPattern());
                }
            }
        } else {
            $this->product->ViewValue = null;
        }

        // rid
        if ($this->rid->VirtualValue != "") {
            $this->rid->ViewValue = $this->rid->VirtualValue;
        } else {
            $this->rid->ViewValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }
        }

        // rid_2
        $curVal = strval($this->rid_2->CurrentValue);
        if ($curVal != "") {
            $this->rid_2->ViewValue = $this->rid_2->lookupCacheOption($curVal);
            if ($this->rid_2->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid_2->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid_2->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->rid_2->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid_2->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid_2->Lookup->renderViewRow($rswrk[0]);
                    $this->rid_2->ViewValue = $this->rid_2->displayValue($arwrk);
                } else {
                    $this->rid_2->ViewValue = $this->rid_2->CurrentValue;
                }
            }
        } else {
            $this->rid_2->ViewValue = null;
        }

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

        // packets
        $this->packets->ViewValue = $this->packets->CurrentValue;
        $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

        // lot_no
        $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

        // packing
        $this->packing->ViewValue = $this->packing->CurrentValue;
        $curVal = strval($this->packing->CurrentValue);
        if ($curVal != "") {
            $this->packing->ViewValue = $this->packing->lookupCacheOption($curVal);
            if ($this->packing->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->packing->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->packing->Lookup->renderViewRow($rswrk[0]);
                    $this->packing->ViewValue = $this->packing->displayValue($arwrk);
                } else {
                    $this->packing->ViewValue = $this->packing->CurrentValue;
                }
            }
        } else {
            $this->packing->ViewValue = null;
        }

        // godown
        $this->godown->ViewValue = $this->godown->CurrentValue;
        $curVal = strval($this->godown->CurrentValue);
        if ($curVal != "") {
            $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
            if ($this->godown->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                    $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                } else {
                    $this->godown->ViewValue = FormatNumber($this->godown->CurrentValue, $this->godown->formatPattern());
                }
            }
        } else {
            $this->godown->ViewValue = null;
        }

        // company_id
        $this->company_id->ViewValue = $this->company_id->CurrentValue;
        $this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, $this->company_id->formatPattern());

        // sub_process
        $curVal = strval($this->sub_process->CurrentValue);
        if ($curVal != "") {
            $this->sub_process->ViewValue = $this->sub_process->lookupCacheOption($curVal);
            if ($this->sub_process->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->sub_process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->sub_process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->sub_process->getSelectFilter($this); // PHP
                $sqlWrk = $this->sub_process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->sub_process->Lookup->renderViewRow($rswrk[0]);
                    $this->sub_process->ViewValue = $this->sub_process->displayValue($arwrk);
                } else {
                    $this->sub_process->ViewValue = FormatNumber($this->sub_process->CurrentValue, $this->sub_process->formatPattern());
                }
            }
        } else {
            $this->sub_process->ViewValue = null;
        }

        // process_method
        if (strval($this->process_method->CurrentValue) != "") {
            $this->process_method->ViewValue = $this->process_method->optionCaption($this->process_method->CurrentValue);
        } else {
            $this->process_method->ViewValue = null;
        }

        // ply
        $this->ply->ViewValue = $this->ply->CurrentValue;
        $this->ply->ViewValue = FormatNumber($this->ply->ViewValue, $this->ply->formatPattern());

        // rid_new
        $curVal = strval($this->rid_new->CurrentValue);
        if ($curVal != "") {
            $this->rid_new->ViewValue = $this->rid_new->lookupCacheOption($curVal);
            if ($this->rid_new->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid_new->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid_new->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->rid_new->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid_new->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid_new->Lookup->renderViewRow($rswrk[0]);
                    $this->rid_new->ViewValue = $this->rid_new->displayValue($arwrk);
                } else {
                    $this->rid_new->ViewValue = FormatNumber($this->rid_new->CurrentValue, $this->rid_new->formatPattern());
                }
            }
        } else {
            $this->rid_new->ViewValue = null;
        }

        // remark
        $this->remark->ViewValue = $this->remark->CurrentValue;

        // payment
        $curVal = strval($this->payment->CurrentValue);
        if ($curVal != "") {
            $this->payment->ViewValue = $this->payment->lookupCacheOption($curVal);
            if ($this->payment->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->payment->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->payment->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $sqlWrk = $this->payment->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->payment->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->payment->Lookup->renderViewRow($row);
                        $this->payment->ViewValue->add($this->payment->displayValue($arwrk));
                    }
                } else {
                    $this->payment->ViewValue = $this->payment->CurrentValue;
                }
            }
        } else {
            $this->payment->ViewValue = null;
        }

        // dated
        $this->dated->ViewValue = $this->dated->CurrentValue;
        $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

        // opeartor
        $this->opeartor->ViewValue = $this->opeartor->CurrentValue;
        $curVal = strval($this->opeartor->CurrentValue);
        if ($curVal != "") {
            $this->opeartor->ViewValue = $this->opeartor->lookupCacheOption($curVal);
            if ($this->opeartor->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->opeartor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->opeartor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->opeartor->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->opeartor->Lookup->renderViewRow($rswrk[0]);
                    $this->opeartor->ViewValue = $this->opeartor->displayValue($arwrk);
                } else {
                    $this->opeartor->ViewValue = FormatNumber($this->opeartor->CurrentValue, $this->opeartor->formatPattern());
                }
            }
        } else {
            $this->opeartor->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // rid_new_lot_no
        $this->rid_new_lot_no->ViewValue = $this->rid_new_lot_no->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // site
        $this->site->HrefValue = "";
        $this->site->TooltipValue = "";

        // process
        if (!EmptyValue($this->process->CurrentValue)) {
            $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
            $this->process->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
            }
        } else {
            $this->process->HrefValue = "";
        }
        $this->process->TooltipValue = "";

        // poid
        $this->poid->HrefValue = "";
        $this->poid->TooltipValue = "";

        // jc_no
        $this->jc_no->HrefValue = "";
        $this->jc_no->TooltipValue = "";

        // emp_name
        $this->emp_name->HrefValue = "";
        $this->emp_name->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // s_grp
        $this->s_grp->HrefValue = "";
        $this->s_grp->TooltipValue = "";

        // product
        $this->product->HrefValue = "";
        $this->product->TooltipValue = "";

        // rid
        $this->rid->HrefValue = "";
        $this->rid->TooltipValue = "";

        // rid_2
        $this->rid_2->HrefValue = "";
        $this->rid_2->TooltipValue = "";

        // quantity
        $this->quantity->HrefValue = "";
        $this->quantity->TooltipValue = "";

        // packets
        $this->packets->HrefValue = "";
        $this->packets->TooltipValue = "";

        // lot_no
        $this->lot_no->HrefValue = "";
        $this->lot_no->TooltipValue = "";

        // packing
        $this->packing->HrefValue = "";
        $this->packing->TooltipValue = "";

        // godown
        $this->godown->HrefValue = "";
        $this->godown->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // sub_process
        $this->sub_process->HrefValue = "";
        $this->sub_process->TooltipValue = "";

        // process_method
        $this->process_method->HrefValue = "";
        $this->process_method->TooltipValue = "";

        // ply
        $this->ply->HrefValue = "";
        $this->ply->TooltipValue = "";

        // rid_new
        $this->rid_new->HrefValue = "";
        $this->rid_new->TooltipValue = "";

        // remark
        $this->remark->HrefValue = "";
        $this->remark->TooltipValue = "";

        // payment
        $this->payment->HrefValue = "";
        $this->payment->TooltipValue = "";

        // dated
        $this->dated->HrefValue = "";
        $this->dated->TooltipValue = "";

        // opeartor
        $this->opeartor->HrefValue = "";
        $this->opeartor->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // rid_new_lot_no
        $this->rid_new_lot_no->HrefValue = "";
        $this->rid_new_lot_no->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // site
        $this->site->setupEditAttributes();
        $curVal = strval($this->site->CurrentValue);
        if ($curVal != "") {
            $this->site->EditValue = $this->site->lookupCacheOption($curVal);
            if ($this->site->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->site->getSelectFilter($this); // PHP
                $sqlWrk = $this->site->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->site->Lookup->renderViewRow($rswrk[0]);
                    $this->site->EditValue = $this->site->displayValue($arwrk);
                } else {
                    $this->site->EditValue = FormatNumber($this->site->CurrentValue, $this->site->formatPattern());
                }
            }
        } else {
            $this->site->EditValue = null;
        }

        // process
        $this->process->setupEditAttributes();
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->EditValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                    $this->process->EditValue = $this->process->displayValue($arwrk);
                } else {
                    $this->process->EditValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                }
            }
        } else {
            $this->process->EditValue = null;
        }

        // poid
        $this->poid->setupEditAttributes();
        $this->poid->EditCustomAttributes = $this->poid->getEditCustomAttributes(); // PHP
        if (!$this->poid->Raw) {
            $this->poid->CurrentValue = HtmlDecode($this->poid->CurrentValue);
        }
        $this->poid->EditValue = $this->poid->CurrentValue;
        $this->poid->PlaceHolder = RemoveHtml($this->poid->caption());

        // jc_no
        $this->jc_no->setupEditAttributes();
        $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

        // emp_name
        $this->emp_name->setupEditAttributes();
        $this->emp_name->PlaceHolder = RemoveHtml($this->emp_name->caption());

        // grp
        $this->grp->setupEditAttributes();
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->EditValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->EditValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                }
            }
        } else {
            $this->grp->EditValue = null;
        }

        // s_grp
        $this->s_grp->setupEditAttributes();
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->EditValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                }
            }
        } else {
            $this->s_grp->EditValue = null;
        }

        // product
        $this->product->setupEditAttributes();
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->EditValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->EditValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->EditValue = FormatNumber($this->product->CurrentValue, $this->product->formatPattern());
                }
            }
        } else {
            $this->product->EditValue = null;
        }

        // rid
        $this->rid->setupEditAttributes();
        $this->rid->EditValue = $this->rid->CurrentValue;
        $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

        // rid_2
        $this->rid_2->setupEditAttributes();
        $this->rid_2->PlaceHolder = RemoveHtml($this->rid_2->caption());

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
        if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
        }

        // packets
        $this->packets->setupEditAttributes();
        $this->packets->EditValue = $this->packets->CurrentValue;
        $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
        if (strval($this->packets->EditValue) != "" && is_numeric($this->packets->EditValue)) {
            $this->packets->EditValue = FormatNumber($this->packets->EditValue, null);
        }

        // lot_no
        $this->lot_no->setupEditAttributes();
        $this->lot_no->EditCustomAttributes = $this->lot_no->getEditCustomAttributes(); // PHP
        $this->lot_no->EditValue = $this->lot_no->CurrentValue;

        // packing
        $this->packing->setupEditAttributes();
        $this->packing->EditValue = $this->packing->CurrentValue;
        $this->packing->PlaceHolder = RemoveHtml($this->packing->caption());

        // godown
        $this->godown->setupEditAttributes();
        $this->godown->EditCustomAttributes = $this->godown->getEditCustomAttributes(); // PHP
        $this->godown->EditValue = $this->godown->CurrentValue;
        $curVal = strval($this->godown->CurrentValue);
        if ($curVal != "") {
            $this->godown->EditValue = $this->godown->lookupCacheOption($curVal);
            if ($this->godown->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                    $this->godown->EditValue = $this->godown->displayValue($arwrk);
                } else {
                    $this->godown->EditValue = FormatNumber($this->godown->CurrentValue, $this->godown->formatPattern());
                }
            }
        } else {
            $this->godown->EditValue = null;
        }

        // company_id
        $this->company_id->setupEditAttributes();
        $this->company_id->EditValue = $this->company_id->CurrentValue;
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());
        if (strval($this->company_id->EditValue) != "" && is_numeric($this->company_id->EditValue)) {
            $this->company_id->EditValue = FormatNumber($this->company_id->EditValue, null);
        }

        // sub_process
        $this->sub_process->setupEditAttributes();
        $this->sub_process->PlaceHolder = RemoveHtml($this->sub_process->caption());

        // process_method
        $this->process_method->setupEditAttributes();
        $this->process_method->EditValue = $this->process_method->options(true);
        $this->process_method->PlaceHolder = RemoveHtml($this->process_method->caption());

        // ply
        $this->ply->setupEditAttributes();
        $this->ply->EditValue = $this->ply->CurrentValue;
        $this->ply->EditValue = FormatNumber($this->ply->EditValue, $this->ply->formatPattern());

        // rid_new
        $this->rid_new->setupEditAttributes();
        $curVal = strval($this->rid_new->CurrentValue);
        if ($curVal != "") {
            $this->rid_new->EditValue = $this->rid_new->lookupCacheOption($curVal);
            if ($this->rid_new->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid_new->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid_new->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->rid_new->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid_new->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid_new->Lookup->renderViewRow($rswrk[0]);
                    $this->rid_new->EditValue = $this->rid_new->displayValue($arwrk);
                } else {
                    $this->rid_new->EditValue = FormatNumber($this->rid_new->CurrentValue, $this->rid_new->formatPattern());
                }
            }
        } else {
            $this->rid_new->EditValue = null;
        }

        // remark
        $this->remark->setupEditAttributes();
        if (!$this->remark->Raw) {
            $this->remark->CurrentValue = HtmlDecode($this->remark->CurrentValue);
        }
        $this->remark->EditValue = $this->remark->CurrentValue;
        $this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

        // payment
        $this->payment->PlaceHolder = RemoveHtml($this->payment->caption());

        // dated
        $this->dated->setupEditAttributes();
        $this->dated->EditValue = $this->dated->CurrentValue;
        $this->dated->EditValue = FormatDateTime($this->dated->EditValue, $this->dated->formatPattern());

        // opeartor

        // datetime

        // rid_new_lot_no
        $this->rid_new_lot_no->setupEditAttributes();
        if (!$this->rid_new_lot_no->Raw) {
            $this->rid_new_lot_no->CurrentValue = HtmlDecode($this->rid_new_lot_no->CurrentValue);
        }
        $this->rid_new_lot_no->EditValue = $this->rid_new_lot_no->CurrentValue;
        $this->rid_new_lot_no->PlaceHolder = RemoveHtml($this->rid_new_lot_no->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->quantity->CurrentValue)) {
                $this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->quantity->CurrentValue = $this->quantity->Total;
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());
            $this->quantity->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->site);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->poid);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->emp_name);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->packets);
                    $doc->exportCaption($this->lot_no);
                    $doc->exportCaption($this->packing);
                    $doc->exportCaption($this->godown);
                    $doc->exportCaption($this->sub_process);
                    $doc->exportCaption($this->process_method);
                    $doc->exportCaption($this->ply);
                    $doc->exportCaption($this->rid_new);
                    $doc->exportCaption($this->remark);
                    $doc->exportCaption($this->payment);
                    $doc->exportCaption($this->dated);
                    $doc->exportCaption($this->opeartor);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->rid_new_lot_no);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->site);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->sub_process);
                    $doc->exportCaption($this->rid_new_lot_no);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->site);
                        $doc->exportField($this->process);
                        $doc->exportField($this->poid);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->emp_name);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->packets);
                        $doc->exportField($this->lot_no);
                        $doc->exportField($this->packing);
                        $doc->exportField($this->godown);
                        $doc->exportField($this->sub_process);
                        $doc->exportField($this->process_method);
                        $doc->exportField($this->ply);
                        $doc->exportField($this->rid_new);
                        $doc->exportField($this->remark);
                        $doc->exportField($this->payment);
                        $doc->exportField($this->dated);
                        $doc->exportField($this->opeartor);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->rid_new_lot_no);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->site);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->sub_process);
                        $doc->exportField($this->rid_new_lot_no);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->id, '');
                $doc->exportAggregate($this->site, '');
                $doc->exportAggregate($this->rid, '');
                $doc->exportAggregate($this->quantity, 'TOTAL');
                $doc->exportAggregate($this->sub_process, '');
                $doc->exportAggregate($this->rid_new_lot_no, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
