<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProcessActionMaterialAdd extends ProcessActionMaterial
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProcessActionMaterialAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "processactionmaterialadd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->site->setVisibility();
        $this->process->setVisibility();
        $this->sub_process->setVisibility();
        $this->emp_name->setVisibility();
        $this->jc_no->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid_1->setVisibility();
        $this->packing->setVisibility();
        $this->rid_2->setVisibility();
        $this->rid->setVisibility();
        $this->godown->setVisibility();
        $this->avg_quantity->setVisibility();
        $this->lot_no->setVisibility();
        $this->avialable_qty->setVisibility();
        $this->ply->setVisibility();
        $this->rid_new->setVisibility();
        $this->rid_new_lot_no->setVisibility();
        $this->poid_new->setVisibility();
        $this->poid_1->setVisibility();
        $this->poid->setVisibility();
        $this->quantity->setVisibility();
        $this->packets->setVisibility();
        $this->process_method->setVisibility();
        $this->payment->Visible = false;
        $this->remark->setVisibility();
        $this->dated->setVisibility();
        $this->opeartor->setVisibility();
        $this->datetime->setVisibility();
        $this->company_id->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'process_action_material';
        $this->TableName = 'process_action_material';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (process_action_material)
        if (!isset($GLOBALS["process_action_material"]) || $GLOBALS["process_action_material"]::class == PROJECT_NAMESPACE . "process_action_material") {
            $GLOBALS["process_action_material"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_action_material');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "processactionmaterialview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->site);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->sub_process);
        $this->setupLookupOptions($this->emp_name);
        $this->setupLookupOptions($this->jc_no);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid_1);
        $this->setupLookupOptions($this->packing);
        $this->setupLookupOptions($this->rid_2);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->godown);
        $this->setupLookupOptions($this->rid_new);
        $this->setupLookupOptions($this->poid_1);
        $this->setupLookupOptions($this->process_method);
        $this->setupLookupOptions($this->payment);
        $this->setupLookupOptions($this->opeartor);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("processactionmateriallist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getAddUrl();
                    if (GetPageName($returnUrl) == "processactionmateriallist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "processactionmaterialview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "processactionmateriallist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "processactionmateriallist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->site->DefaultValue = $this->site->getDefault(); // PHP
        $this->site->OldValue = $this->site->DefaultValue;
        $this->process->DefaultValue = $this->process->getDefault(); // PHP
        $this->process->OldValue = $this->process->DefaultValue;
        $this->sub_process->DefaultValue = $this->sub_process->getDefault(); // PHP
        $this->sub_process->OldValue = $this->sub_process->DefaultValue;
        $this->grp->DefaultValue = $this->grp->getDefault(); // PHP
        $this->grp->OldValue = $this->grp->DefaultValue;
        $this->s_grp->DefaultValue = $this->s_grp->getDefault(); // PHP
        $this->s_grp->OldValue = $this->s_grp->DefaultValue;
        $this->product->DefaultValue = $this->product->getDefault(); // PHP
        $this->product->OldValue = $this->product->DefaultValue;
        $this->packing->DefaultValue = $this->packing->getDefault(); // PHP
        $this->packing->OldValue = $this->packing->DefaultValue;
        $this->poid->DefaultValue = $this->poid->getDefault(); // PHP
        $this->poid->OldValue = $this->poid->DefaultValue;
        $this->dated->DefaultValue = $this->dated->getDefault(); // PHP
        $this->dated->OldValue = $this->dated->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'site' first before field var 'x_site'
        $val = $CurrentForm->hasValue("site") ? $CurrentForm->getValue("site") : $CurrentForm->getValue("x_site");
        if (!$this->site->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->site->Visible = false; // Disable update for API request
            } else {
                $this->site->setFormValue($val);
            }
        }

        // Check field name 'process' first before field var 'x_process'
        $val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
        if (!$this->process->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->process->Visible = false; // Disable update for API request
            } else {
                $this->process->setFormValue($val);
            }
        }

        // Check field name 'sub_process' first before field var 'x_sub_process'
        $val = $CurrentForm->hasValue("sub_process") ? $CurrentForm->getValue("sub_process") : $CurrentForm->getValue("x_sub_process");
        if (!$this->sub_process->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sub_process->Visible = false; // Disable update for API request
            } else {
                $this->sub_process->setFormValue($val);
            }
        }

        // Check field name 'emp_name' first before field var 'x_emp_name'
        $val = $CurrentForm->hasValue("emp_name") ? $CurrentForm->getValue("emp_name") : $CurrentForm->getValue("x_emp_name");
        if (!$this->emp_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->emp_name->Visible = false; // Disable update for API request
            } else {
                $this->emp_name->setFormValue($val);
            }
        }

        // Check field name 'jc_no' first before field var 'x_jc_no'
        $val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
        if (!$this->jc_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_no->Visible = false; // Disable update for API request
            } else {
                $this->jc_no->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }

        // Check field name 'rid_1' first before field var 'x_rid_1'
        $val = $CurrentForm->hasValue("rid_1") ? $CurrentForm->getValue("rid_1") : $CurrentForm->getValue("x_rid_1");
        if (!$this->rid_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid_1->Visible = false; // Disable update for API request
            } else {
                $this->rid_1->setFormValue($val);
            }
        }

        // Check field name 'packing' first before field var 'x_packing'
        $val = $CurrentForm->hasValue("packing") ? $CurrentForm->getValue("packing") : $CurrentForm->getValue("x_packing");
        if (!$this->packing->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing->Visible = false; // Disable update for API request
            } else {
                $this->packing->setFormValue($val);
            }
        }

        // Check field name 'rid_2' first before field var 'x_rid_2'
        $val = $CurrentForm->hasValue("rid_2") ? $CurrentForm->getValue("rid_2") : $CurrentForm->getValue("x_rid_2");
        if (!$this->rid_2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid_2->Visible = false; // Disable update for API request
            } else {
                $this->rid_2->setFormValue($val);
            }
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val);
            }
        }

        // Check field name 'godown' first before field var 'x_godown'
        $val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
        if (!$this->godown->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->godown->Visible = false; // Disable update for API request
            } else {
                $this->godown->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'avg_quantity' first before field var 'x_avg_quantity'
        $val = $CurrentForm->hasValue("avg_quantity") ? $CurrentForm->getValue("avg_quantity") : $CurrentForm->getValue("x_avg_quantity");
        if (!$this->avg_quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->avg_quantity->Visible = false; // Disable update for API request
            } else {
                $this->avg_quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'lot_no' first before field var 'x_lot_no'
        $val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
        if (!$this->lot_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lot_no->Visible = false; // Disable update for API request
            } else {
                $this->lot_no->setFormValue($val);
            }
        }

        // Check field name 'avialable_qty' first before field var 'x_avialable_qty'
        $val = $CurrentForm->hasValue("avialable_qty") ? $CurrentForm->getValue("avialable_qty") : $CurrentForm->getValue("x_avialable_qty");
        if (!$this->avialable_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->avialable_qty->Visible = false; // Disable update for API request
            } else {
                $this->avialable_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ply' first before field var 'x_ply'
        $val = $CurrentForm->hasValue("ply") ? $CurrentForm->getValue("ply") : $CurrentForm->getValue("x_ply");
        if (!$this->ply->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ply->Visible = false; // Disable update for API request
            } else {
                $this->ply->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'rid_new' first before field var 'x_rid_new'
        $val = $CurrentForm->hasValue("rid_new") ? $CurrentForm->getValue("rid_new") : $CurrentForm->getValue("x_rid_new");
        if (!$this->rid_new->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid_new->Visible = false; // Disable update for API request
            } else {
                $this->rid_new->setFormValue($val);
            }
        }

        // Check field name 'rid_new_lot_no' first before field var 'x_rid_new_lot_no'
        $val = $CurrentForm->hasValue("rid_new_lot_no") ? $CurrentForm->getValue("rid_new_lot_no") : $CurrentForm->getValue("x_rid_new_lot_no");
        if (!$this->rid_new_lot_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid_new_lot_no->Visible = false; // Disable update for API request
            } else {
                $this->rid_new_lot_no->setFormValue($val);
            }
        }

        // Check field name 'poid_new' first before field var 'x_poid_new'
        $val = $CurrentForm->hasValue("poid_new") ? $CurrentForm->getValue("poid_new") : $CurrentForm->getValue("x_poid_new");
        if (!$this->poid_new->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->poid_new->Visible = false; // Disable update for API request
            } else {
                $this->poid_new->setFormValue($val);
            }
        }

        // Check field name 'poid_1' first before field var 'x_poid_1'
        $val = $CurrentForm->hasValue("poid_1") ? $CurrentForm->getValue("poid_1") : $CurrentForm->getValue("x_poid_1");
        if (!$this->poid_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->poid_1->Visible = false; // Disable update for API request
            } else {
                $this->poid_1->setFormValue($val);
            }
        }

        // Check field name 'poid' first before field var 'x_poid'
        $val = $CurrentForm->hasValue("poid") ? $CurrentForm->getValue("poid") : $CurrentForm->getValue("x_poid");
        if (!$this->poid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->poid->Visible = false; // Disable update for API request
            } else {
                $this->poid->setFormValue($val);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'packets' first before field var 'x_packets'
        $val = $CurrentForm->hasValue("packets") ? $CurrentForm->getValue("packets") : $CurrentForm->getValue("x_packets");
        if (!$this->packets->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packets->Visible = false; // Disable update for API request
            } else {
                $this->packets->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'process_method' first before field var 'x_process_method'
        $val = $CurrentForm->hasValue("process_method") ? $CurrentForm->getValue("process_method") : $CurrentForm->getValue("x_process_method");
        if (!$this->process_method->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->process_method->Visible = false; // Disable update for API request
            } else {
                $this->process_method->setFormValue($val);
            }
        }

        // Check field name 'remark' first before field var 'x_remark'
        $val = $CurrentForm->hasValue("remark") ? $CurrentForm->getValue("remark") : $CurrentForm->getValue("x_remark");
        if (!$this->remark->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remark->Visible = false; // Disable update for API request
            } else {
                $this->remark->setFormValue($val);
            }
        }

        // Check field name 'dated' first before field var 'x_dated'
        $val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
        if (!$this->dated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dated->Visible = false; // Disable update for API request
            } else {
                $this->dated->setFormValue($val, true, $validate);
            }
            $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        }

        // Check field name 'opeartor' first before field var 'x_opeartor'
        $val = $CurrentForm->hasValue("opeartor") ? $CurrentForm->getValue("opeartor") : $CurrentForm->getValue("x_opeartor");
        if (!$this->opeartor->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->opeartor->Visible = false; // Disable update for API request
            } else {
                $this->opeartor->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->site->CurrentValue = $this->site->FormValue;
        $this->process->CurrentValue = $this->process->FormValue;
        $this->sub_process->CurrentValue = $this->sub_process->FormValue;
        $this->emp_name->CurrentValue = $this->emp_name->FormValue;
        $this->jc_no->CurrentValue = $this->jc_no->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->rid_1->CurrentValue = $this->rid_1->FormValue;
        $this->packing->CurrentValue = $this->packing->FormValue;
        $this->rid_2->CurrentValue = $this->rid_2->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->godown->CurrentValue = $this->godown->FormValue;
        $this->avg_quantity->CurrentValue = $this->avg_quantity->FormValue;
        $this->lot_no->CurrentValue = $this->lot_no->FormValue;
        $this->avialable_qty->CurrentValue = $this->avialable_qty->FormValue;
        $this->ply->CurrentValue = $this->ply->FormValue;
        $this->rid_new->CurrentValue = $this->rid_new->FormValue;
        $this->rid_new_lot_no->CurrentValue = $this->rid_new_lot_no->FormValue;
        $this->poid_new->CurrentValue = $this->poid_new->FormValue;
        $this->poid_1->CurrentValue = $this->poid_1->FormValue;
        $this->poid->CurrentValue = $this->poid->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->packets->CurrentValue = $this->packets->FormValue;
        $this->process_method->CurrentValue = $this->process_method->FormValue;
        $this->remark->CurrentValue = $this->remark->FormValue;
        $this->dated->CurrentValue = $this->dated->FormValue;
        $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        $this->opeartor->CurrentValue = $this->opeartor->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->site->setDbValue($row['site']);
        $this->process->setDbValue($row['process']);
        $this->sub_process->setDbValue($row['sub_process']);
        $this->emp_name->setDbValue($row['emp_name']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid_1->setDbValue($row['rid_1']);
        $this->packing->setDbValue($row['packing']);
        $this->rid_2->setDbValue($row['rid_2']);
        $this->rid->setDbValue($row['rid']);
        if (array_key_exists('EV__rid', $row)) {
            $this->rid->VirtualValue = $row['EV__rid']; // Set up virtual field value
        } else {
            $this->rid->VirtualValue = ""; // Clear value
        }
        $this->godown->setDbValue($row['godown']);
        $this->avg_quantity->setDbValue($row['avg_quantity']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->avialable_qty->setDbValue($row['avialable_qty']);
        $this->ply->setDbValue($row['ply']);
        $this->rid_new->setDbValue($row['rid_new']);
        $this->rid_new_lot_no->setDbValue($row['rid_new_lot_no']);
        $this->poid_new->setDbValue($row['poid_new']);
        $this->poid_1->setDbValue($row['poid_1']);
        $this->poid->setDbValue($row['poid']);
        $this->quantity->setDbValue($row['quantity']);
        $this->packets->setDbValue($row['packets']);
        $this->process_method->setDbValue($row['process_method']);
        $this->payment->setDbValue($row['payment']);
        $this->remark->setDbValue($row['remark']);
        $this->dated->setDbValue($row['dated']);
        $this->opeartor->setDbValue($row['opeartor']);
        $this->datetime->setDbValue($row['datetime']);
        $this->company_id->setDbValue($row['company_id']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['site'] = $this->site->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['sub_process'] = $this->sub_process->DefaultValue;
        $row['emp_name'] = $this->emp_name->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid_1'] = $this->rid_1->DefaultValue;
        $row['packing'] = $this->packing->DefaultValue;
        $row['rid_2'] = $this->rid_2->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['godown'] = $this->godown->DefaultValue;
        $row['avg_quantity'] = $this->avg_quantity->DefaultValue;
        $row['lot_no'] = $this->lot_no->DefaultValue;
        $row['avialable_qty'] = $this->avialable_qty->DefaultValue;
        $row['ply'] = $this->ply->DefaultValue;
        $row['rid_new'] = $this->rid_new->DefaultValue;
        $row['rid_new_lot_no'] = $this->rid_new_lot_no->DefaultValue;
        $row['poid_new'] = $this->poid_new->DefaultValue;
        $row['poid_1'] = $this->poid_1->DefaultValue;
        $row['poid'] = $this->poid->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['packets'] = $this->packets->DefaultValue;
        $row['process_method'] = $this->process_method->DefaultValue;
        $row['payment'] = $this->payment->DefaultValue;
        $row['remark'] = $this->remark->DefaultValue;
        $row['dated'] = $this->dated->DefaultValue;
        $row['opeartor'] = $this->opeartor->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // site
        $this->site->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // sub_process
        $this->sub_process->RowCssClass = "row";

        // emp_name
        $this->emp_name->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid_1
        $this->rid_1->RowCssClass = "row";

        // packing
        $this->packing->RowCssClass = "row";

        // rid_2
        $this->rid_2->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // godown
        $this->godown->RowCssClass = "row";

        // avg_quantity
        $this->avg_quantity->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // avialable_qty
        $this->avialable_qty->RowCssClass = "row";

        // ply
        $this->ply->RowCssClass = "row";

        // rid_new
        $this->rid_new->RowCssClass = "row";

        // rid_new_lot_no
        $this->rid_new_lot_no->RowCssClass = "row";

        // poid_new
        $this->poid_new->RowCssClass = "row";

        // poid_1
        $this->poid_1->RowCssClass = "row";

        // poid
        $this->poid->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // packets
        $this->packets->RowCssClass = "row";

        // process_method
        $this->process_method->RowCssClass = "row";

        // payment
        $this->payment->RowCssClass = "row";

        // remark
        $this->remark->RowCssClass = "row";

        // dated
        $this->dated->RowCssClass = "row";

        // opeartor
        $this->opeartor->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // site
            $curVal = strval($this->site->CurrentValue);
            if ($curVal != "") {
                $this->site->ViewValue = $this->site->lookupCacheOption($curVal);
                if ($this->site->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->site->getSelectFilter($this); // PHP
                    $sqlWrk = $this->site->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->site->Lookup->renderViewRow($rswrk[0]);
                        $this->site->ViewValue = $this->site->displayValue($arwrk);
                    } else {
                        $this->site->ViewValue = FormatNumber($this->site->CurrentValue, $this->site->formatPattern());
                    }
                }
            } else {
                $this->site->ViewValue = null;
            }

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // sub_process
            $curVal = strval($this->sub_process->CurrentValue);
            if ($curVal != "") {
                $this->sub_process->ViewValue = $this->sub_process->lookupCacheOption($curVal);
                if ($this->sub_process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->sub_process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->sub_process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->sub_process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->sub_process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sub_process->Lookup->renderViewRow($rswrk[0]);
                        $this->sub_process->ViewValue = $this->sub_process->displayValue($arwrk);
                    } else {
                        $this->sub_process->ViewValue = FormatNumber($this->sub_process->CurrentValue, $this->sub_process->formatPattern());
                    }
                }
            } else {
                $this->sub_process->ViewValue = null;
            }

            // emp_name
            $curVal = strval($this->emp_name->CurrentValue);
            if ($curVal != "") {
                $this->emp_name->ViewValue = $this->emp_name->lookupCacheOption($curVal);
                if ($this->emp_name->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->emp_name->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->emp_name->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->emp_name->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->emp_name->Lookup->renderViewRow($rswrk[0]);
                        $this->emp_name->ViewValue = $this->emp_name->displayValue($arwrk);
                    } else {
                        $this->emp_name->ViewValue = $this->emp_name->CurrentValue;
                    }
                }
            } else {
                $this->emp_name->ViewValue = null;
            }

            // jc_no
            $curVal = strval($this->jc_no->CurrentValue);
            if ($curVal != "") {
                $this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
                if ($this->jc_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->jc_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->jc_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->jc_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->jc_no->Lookup->renderViewRow($rswrk[0]);
                        $this->jc_no->ViewValue = $this->jc_no->displayValue($arwrk);
                    } else {
                        $this->jc_no->ViewValue = FormatNumber($this->jc_no->CurrentValue, $this->jc_no->formatPattern());
                    }
                }
            } else {
                $this->jc_no->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = FormatNumber($this->product->CurrentValue, $this->product->formatPattern());
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid_1
            $curVal = strval($this->rid_1->CurrentValue);
            if ($curVal != "") {
                $this->rid_1->ViewValue = $this->rid_1->lookupCacheOption($curVal);
                if ($this->rid_1->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid_1->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid_1->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid_1->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid_1->Lookup->renderViewRow($rswrk[0]);
                        $this->rid_1->ViewValue = $this->rid_1->displayValue($arwrk);
                    } else {
                        $this->rid_1->ViewValue = $this->rid_1->CurrentValue;
                    }
                }
            } else {
                $this->rid_1->ViewValue = null;
            }

            // packing
            $curVal = strval($this->packing->CurrentValue);
            if ($curVal != "") {
                $this->packing->ViewValue = $this->packing->lookupCacheOption($curVal);
                if ($this->packing->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing->Lookup->renderViewRow($rswrk[0]);
                        $this->packing->ViewValue = $this->packing->displayValue($arwrk);
                    } else {
                        $this->packing->ViewValue = $this->packing->CurrentValue;
                    }
                }
            } else {
                $this->packing->ViewValue = null;
            }

            // rid_2
            $curVal = strval($this->rid_2->CurrentValue);
            if ($curVal != "") {
                $this->rid_2->ViewValue = $this->rid_2->lookupCacheOption($curVal);
                if ($this->rid_2->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid_2->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid_2->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid_2->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid_2->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid_2->Lookup->renderViewRow($rswrk[0]);
                        $this->rid_2->ViewValue = $this->rid_2->displayValue($arwrk);
                    } else {
                        $this->rid_2->ViewValue = $this->rid_2->CurrentValue;
                    }
                }
            } else {
                $this->rid_2->ViewValue = null;
            }

            // rid
            if ($this->rid->VirtualValue != "") {
                $this->rid->ViewValue = $this->rid->VirtualValue;
            } else {
                $this->rid->ViewValue = $this->rid->CurrentValue;
                $curVal = strval($this->rid->CurrentValue);
                if ($curVal != "") {
                    $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                    if ($this->rid->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                            $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                        } else {
                            $this->rid->ViewValue = $this->rid->CurrentValue;
                        }
                    }
                } else {
                    $this->rid->ViewValue = null;
                }
            }

            // godown
            $this->godown->ViewValue = $this->godown->CurrentValue;
            $curVal = strval($this->godown->CurrentValue);
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                        $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                    } else {
                        $this->godown->ViewValue = FormatNumber($this->godown->CurrentValue, $this->godown->formatPattern());
                    }
                }
            } else {
                $this->godown->ViewValue = null;
            }

            // avg_quantity
            $this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
            $this->avg_quantity->ViewValue = FormatNumber($this->avg_quantity->ViewValue, $this->avg_quantity->formatPattern());

            // lot_no
            $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

            // avialable_qty
            $this->avialable_qty->ViewValue = $this->avialable_qty->CurrentValue;
            $this->avialable_qty->ViewValue = FormatNumber($this->avialable_qty->ViewValue, $this->avialable_qty->formatPattern());

            // ply
            $this->ply->ViewValue = $this->ply->CurrentValue;
            $this->ply->ViewValue = FormatNumber($this->ply->ViewValue, $this->ply->formatPattern());

            // rid_new
            $curVal = strval($this->rid_new->CurrentValue);
            if ($curVal != "") {
                $this->rid_new->ViewValue = $this->rid_new->lookupCacheOption($curVal);
                if ($this->rid_new->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid_new->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid_new->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid_new->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid_new->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid_new->Lookup->renderViewRow($rswrk[0]);
                        $this->rid_new->ViewValue = $this->rid_new->displayValue($arwrk);
                    } else {
                        $this->rid_new->ViewValue = FormatNumber($this->rid_new->CurrentValue, $this->rid_new->formatPattern());
                    }
                }
            } else {
                $this->rid_new->ViewValue = null;
            }

            // rid_new_lot_no
            $this->rid_new_lot_no->ViewValue = $this->rid_new_lot_no->CurrentValue;

            // poid_new
            $this->poid_new->ViewValue = $this->poid_new->CurrentValue;

            // poid_1
            $curVal = strval($this->poid_1->CurrentValue);
            if ($curVal != "") {
                $this->poid_1->ViewValue = $this->poid_1->lookupCacheOption($curVal);
                if ($this->poid_1->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->poid_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->poid_1->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->poid_1->getSelectFilter($this); // PHP
                    $sqlWrk = $this->poid_1->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->poid_1->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->poid_1->Lookup->renderViewRow($row);
                            $this->poid_1->ViewValue->add($this->poid_1->displayValue($arwrk));
                        }
                    } else {
                        $this->poid_1->ViewValue = $this->poid_1->CurrentValue;
                    }
                }
            } else {
                $this->poid_1->ViewValue = null;
            }

            // poid
            $this->poid->ViewValue = $this->poid->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // packets
            $this->packets->ViewValue = $this->packets->CurrentValue;
            $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

            // process_method
            if (strval($this->process_method->CurrentValue) != "") {
                $this->process_method->ViewValue = $this->process_method->optionCaption($this->process_method->CurrentValue);
            } else {
                $this->process_method->ViewValue = null;
            }

            // remark
            $this->remark->ViewValue = $this->remark->CurrentValue;

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // opeartor
            $this->opeartor->ViewValue = $this->opeartor->CurrentValue;
            $curVal = strval($this->opeartor->CurrentValue);
            if ($curVal != "") {
                $this->opeartor->ViewValue = $this->opeartor->lookupCacheOption($curVal);
                if ($this->opeartor->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->opeartor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->opeartor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->opeartor->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->opeartor->Lookup->renderViewRow($rswrk[0]);
                        $this->opeartor->ViewValue = $this->opeartor->displayValue($arwrk);
                    } else {
                        $this->opeartor->ViewValue = FormatNumber($this->opeartor->CurrentValue, $this->opeartor->formatPattern());
                    }
                }
            } else {
                $this->opeartor->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // site
            $this->site->HrefValue = "";
            $this->site->TooltipValue = "";

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }
            $this->process->TooltipValue = "";

            // sub_process
            $this->sub_process->HrefValue = "";

            // emp_name
            $this->emp_name->HrefValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // product
            $this->product->HrefValue = "";
            $this->product->TooltipValue = "";

            // rid_1
            $this->rid_1->HrefValue = "";

            // packing
            $this->packing->HrefValue = "";

            // rid_2
            $this->rid_2->HrefValue = "";

            // rid
            $this->rid->HrefValue = "";

            // godown
            $this->godown->HrefValue = "";
            $this->godown->TooltipValue = "";

            // avg_quantity
            $this->avg_quantity->HrefValue = "";
            $this->avg_quantity->TooltipValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";
            $this->lot_no->TooltipValue = "";

            // avialable_qty
            $this->avialable_qty->HrefValue = "";

            // ply
            $this->ply->HrefValue = "";
            $this->ply->TooltipValue = "";

            // rid_new
            $this->rid_new->HrefValue = "";
            $this->rid_new->TooltipValue = "";

            // rid_new_lot_no
            $this->rid_new_lot_no->HrefValue = "";

            // poid_new
            $this->poid_new->HrefValue = "";

            // poid_1
            $this->poid_1->HrefValue = "";

            // poid
            $this->poid->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // packets
            $this->packets->HrefValue = "";

            // process_method
            $this->process_method->HrefValue = "";

            // remark
            $this->remark->HrefValue = "";

            // dated
            $this->dated->HrefValue = "";
            $this->dated->TooltipValue = "";

            // opeartor
            $this->opeartor->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // site
            $this->site->setupEditAttributes();
            $curVal = trim(strval($this->site->CurrentValue));
            if ($curVal != "") {
                $this->site->ViewValue = $this->site->lookupCacheOption($curVal);
            } else {
                $this->site->ViewValue = $this->site->Lookup !== null && is_array($this->site->lookupOptions()) && count($this->site->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->site->ViewValue !== null) { // Load from cache
                $this->site->EditValue = array_values($this->site->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->site->CurrentValue, $this->site->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->site->getSelectFilter($this); // PHP
                $sqlWrk = $this->site->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->site->EditValue = $arwrk;
            }
            $this->site->PlaceHolder = RemoveHtml($this->site->caption());

            // process
            $this->process->setupEditAttributes();
            $curVal = trim(strval($this->process->CurrentValue));
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            } else {
                $this->process->ViewValue = $this->process->Lookup !== null && is_array($this->process->lookupOptions()) && count($this->process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process->ViewValue !== null) { // Load from cache
                $this->process->EditValue = array_values($this->process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->process->CurrentValue, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process->EditValue = $arwrk;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // sub_process
            $this->sub_process->setupEditAttributes();
            $curVal = trim(strval($this->sub_process->CurrentValue));
            if ($curVal != "") {
                $this->sub_process->ViewValue = $this->sub_process->lookupCacheOption($curVal);
            } else {
                $this->sub_process->ViewValue = $this->sub_process->Lookup !== null && is_array($this->sub_process->lookupOptions()) && count($this->sub_process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->sub_process->ViewValue !== null) { // Load from cache
                $this->sub_process->EditValue = array_values($this->sub_process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->sub_process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->sub_process->CurrentValue, $this->sub_process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->sub_process->getSelectFilter($this); // PHP
                $sqlWrk = $this->sub_process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->sub_process->EditValue = $arwrk;
            }
            $this->sub_process->PlaceHolder = RemoveHtml($this->sub_process->caption());

            // emp_name
            $this->emp_name->setupEditAttributes();
            $curVal = trim(strval($this->emp_name->CurrentValue));
            if ($curVal != "") {
                $this->emp_name->ViewValue = $this->emp_name->lookupCacheOption($curVal);
            } else {
                $this->emp_name->ViewValue = $this->emp_name->Lookup !== null && is_array($this->emp_name->lookupOptions()) && count($this->emp_name->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->emp_name->ViewValue !== null) { // Load from cache
                $this->emp_name->EditValue = array_values($this->emp_name->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->emp_name->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->emp_name->CurrentValue, $this->emp_name->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->emp_name->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->emp_name->Lookup->renderViewRow($row);
                }
                $this->emp_name->EditValue = $arwrk;
            }
            $this->emp_name->PlaceHolder = RemoveHtml($this->emp_name->caption());

            // jc_no
            $this->jc_no->setupEditAttributes();
            $curVal = trim(strval($this->jc_no->CurrentValue));
            if ($curVal != "") {
                $this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
            } else {
                $this->jc_no->ViewValue = $this->jc_no->Lookup !== null && is_array($this->jc_no->lookupOptions()) && count($this->jc_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->jc_no->ViewValue !== null) { // Load from cache
                $this->jc_no->EditValue = array_values($this->jc_no->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->jc_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->jc_no->CurrentValue, $this->jc_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->jc_no->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->jc_no->Lookup->renderViewRow($row);
                }
                $this->jc_no->EditValue = $arwrk;
            }
            $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
                if ($this->s_grp->ViewValue == "") {
                    $this->s_grp->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
                if ($this->product->ViewValue == "") {
                    $this->product->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid_1
            $curVal = trim(strval($this->rid_1->CurrentValue));
            if ($curVal != "") {
                $this->rid_1->ViewValue = $this->rid_1->lookupCacheOption($curVal);
            } else {
                $this->rid_1->ViewValue = $this->rid_1->Lookup !== null && is_array($this->rid_1->lookupOptions()) && count($this->rid_1->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid_1->ViewValue !== null) { // Load from cache
                $this->rid_1->EditValue = array_values($this->rid_1->lookupOptions());
                if ($this->rid_1->ViewValue == "") {
                    $this->rid_1->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid_1->CurrentValue, $this->rid_1->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->rid_1->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid_1->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid_1->Lookup->renderViewRow($rswrk[0]);
                    $this->rid_1->ViewValue = $this->rid_1->displayValue($arwrk);
                } else {
                    $this->rid_1->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->rid_1->Lookup->renderViewRow($row);
                }
                $this->rid_1->EditValue = $arwrk;
            }
            $this->rid_1->PlaceHolder = RemoveHtml($this->rid_1->caption());

            // packing
            $this->packing->setupEditAttributes();
            $curVal = trim(strval($this->packing->CurrentValue));
            if ($curVal != "") {
                $this->packing->ViewValue = $this->packing->lookupCacheOption($curVal);
            } else {
                $this->packing->ViewValue = $this->packing->Lookup !== null && is_array($this->packing->lookupOptions()) && count($this->packing->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing->ViewValue !== null) { // Load from cache
                $this->packing->EditValue = array_values($this->packing->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing->CurrentValue, $this->packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing->EditValue = $arwrk;
            }
            $this->packing->PlaceHolder = RemoveHtml($this->packing->caption());

            // rid_2
            $curVal = trim(strval($this->rid_2->CurrentValue));
            if ($curVal != "") {
                $this->rid_2->ViewValue = $this->rid_2->lookupCacheOption($curVal);
            } else {
                $this->rid_2->ViewValue = $this->rid_2->Lookup !== null && is_array($this->rid_2->lookupOptions()) && count($this->rid_2->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid_2->ViewValue !== null) { // Load from cache
                $this->rid_2->EditValue = array_values($this->rid_2->lookupOptions());
                if ($this->rid_2->ViewValue == "") {
                    $this->rid_2->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid_2->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid_2->CurrentValue, $this->rid_2->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->rid_2->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid_2->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid_2->Lookup->renderViewRow($rswrk[0]);
                    $this->rid_2->ViewValue = $this->rid_2->displayValue($arwrk);
                } else {
                    $this->rid_2->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->rid_2->Lookup->renderViewRow($row);
                }
                $this->rid_2->EditValue = $arwrk;
            }
            $this->rid_2->PlaceHolder = RemoveHtml($this->rid_2->caption());

            // rid
            $this->rid->setupEditAttributes();
            $this->rid->EditValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->EditValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
                    }
                }
            } else {
                $this->rid->EditValue = null;
            }
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // godown
            $this->godown->setupEditAttributes();
            $this->godown->EditCustomAttributes = $this->godown->getEditCustomAttributes(); // PHP
            $this->godown->EditValue = $this->godown->CurrentValue;
            $curVal = strval($this->godown->CurrentValue);
            if ($curVal != "") {
                $this->godown->EditValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                        $this->godown->EditValue = $this->godown->displayValue($arwrk);
                    } else {
                        $this->godown->EditValue = HtmlEncode(FormatNumber($this->godown->CurrentValue, $this->godown->formatPattern()));
                    }
                }
            } else {
                $this->godown->EditValue = null;
            }
            $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

            // avg_quantity
            $this->avg_quantity->setupEditAttributes();
            $this->avg_quantity->EditCustomAttributes = $this->avg_quantity->getEditCustomAttributes(); // PHP
            $this->avg_quantity->EditValue = $this->avg_quantity->CurrentValue;
            $this->avg_quantity->PlaceHolder = RemoveHtml($this->avg_quantity->caption());
            if (strval($this->avg_quantity->EditValue) != "" && is_numeric($this->avg_quantity->EditValue)) {
                $this->avg_quantity->EditValue = FormatNumber($this->avg_quantity->EditValue, null);
            }

            // lot_no
            $this->lot_no->setupEditAttributes();
            $this->lot_no->EditCustomAttributes = $this->lot_no->getEditCustomAttributes(); // PHP
            if (!$this->lot_no->Raw) {
                $this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
            }
            $this->lot_no->EditValue = HtmlEncode($this->lot_no->CurrentValue);
            $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

            // avialable_qty
            $this->avialable_qty->setupEditAttributes();
            $this->avialable_qty->EditCustomAttributes = $this->avialable_qty->getEditCustomAttributes(); // PHP
            $this->avialable_qty->EditValue = $this->avialable_qty->CurrentValue;
            $this->avialable_qty->PlaceHolder = RemoveHtml($this->avialable_qty->caption());
            if (strval($this->avialable_qty->EditValue) != "" && is_numeric($this->avialable_qty->EditValue)) {
                $this->avialable_qty->EditValue = FormatNumber($this->avialable_qty->EditValue, null);
            }

            // ply
            $this->ply->setupEditAttributes();
            $this->ply->EditValue = $this->ply->CurrentValue;
            $this->ply->PlaceHolder = RemoveHtml($this->ply->caption());
            if (strval($this->ply->EditValue) != "" && is_numeric($this->ply->EditValue)) {
                $this->ply->EditValue = FormatNumber($this->ply->EditValue, null);
            }

            // rid_new
            $this->rid_new->setupEditAttributes();
            $curVal = trim(strval($this->rid_new->CurrentValue));
            if ($curVal != "") {
                $this->rid_new->ViewValue = $this->rid_new->lookupCacheOption($curVal);
            } else {
                $this->rid_new->ViewValue = $this->rid_new->Lookup !== null && is_array($this->rid_new->lookupOptions()) && count($this->rid_new->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid_new->ViewValue !== null) { // Load from cache
                $this->rid_new->EditValue = array_values($this->rid_new->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid_new->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid_new->CurrentValue, $this->rid_new->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->rid_new->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid_new->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->rid_new->EditValue = $arwrk;
            }
            $this->rid_new->PlaceHolder = RemoveHtml($this->rid_new->caption());

            // rid_new_lot_no
            $this->rid_new_lot_no->setupEditAttributes();
            if (!$this->rid_new_lot_no->Raw) {
                $this->rid_new_lot_no->CurrentValue = HtmlDecode($this->rid_new_lot_no->CurrentValue);
            }
            $this->rid_new_lot_no->EditValue = HtmlEncode($this->rid_new_lot_no->CurrentValue);
            $this->rid_new_lot_no->PlaceHolder = RemoveHtml($this->rid_new_lot_no->caption());

            // poid_new
            $this->poid_new->setupEditAttributes();
            if (!$this->poid_new->Raw) {
                $this->poid_new->CurrentValue = HtmlDecode($this->poid_new->CurrentValue);
            }
            $this->poid_new->EditValue = HtmlEncode($this->poid_new->CurrentValue);
            $this->poid_new->PlaceHolder = RemoveHtml($this->poid_new->caption());

            // poid_1
            $curVal = trim(strval($this->poid_1->CurrentValue));
            if ($curVal != "") {
                $this->poid_1->ViewValue = $this->poid_1->lookupCacheOption($curVal);
            } else {
                $this->poid_1->ViewValue = $this->poid_1->Lookup !== null && is_array($this->poid_1->lookupOptions()) && count($this->poid_1->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->poid_1->ViewValue !== null) { // Load from cache
                $this->poid_1->EditValue = array_values($this->poid_1->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->poid_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->poid_1->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->poid_1->getSelectFilter($this); // PHP
                $sqlWrk = $this->poid_1->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->poid_1->Lookup->renderViewRow($row);
                }
                $this->poid_1->EditValue = $arwrk;
            }
            $this->poid_1->PlaceHolder = RemoveHtml($this->poid_1->caption());

            // poid
            $this->poid->setupEditAttributes();
            $this->poid->EditCustomAttributes = $this->poid->getEditCustomAttributes(); // PHP
            if (!$this->poid->Raw) {
                $this->poid->CurrentValue = HtmlDecode($this->poid->CurrentValue);
            }
            $this->poid->EditValue = HtmlEncode($this->poid->CurrentValue);
            $this->poid->PlaceHolder = RemoveHtml($this->poid->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // packets
            $this->packets->setupEditAttributes();
            $this->packets->EditValue = $this->packets->CurrentValue;
            $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
            if (strval($this->packets->EditValue) != "" && is_numeric($this->packets->EditValue)) {
                $this->packets->EditValue = FormatNumber($this->packets->EditValue, null);
            }

            // process_method
            $this->process_method->setupEditAttributes();
            $this->process_method->EditValue = $this->process_method->options(true);
            $this->process_method->PlaceHolder = RemoveHtml($this->process_method->caption());

            // remark
            $this->remark->setupEditAttributes();
            if (!$this->remark->Raw) {
                $this->remark->CurrentValue = HtmlDecode($this->remark->CurrentValue);
            }
            $this->remark->EditValue = HtmlEncode($this->remark->CurrentValue);
            $this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

            // opeartor

            // datetime

            // Add refer script

            // site
            $this->site->HrefValue = "";

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }

            // sub_process
            $this->sub_process->HrefValue = "";

            // emp_name
            $this->emp_name->HrefValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // product
            $this->product->HrefValue = "";

            // rid_1
            $this->rid_1->HrefValue = "";

            // packing
            $this->packing->HrefValue = "";

            // rid_2
            $this->rid_2->HrefValue = "";

            // rid
            $this->rid->HrefValue = "";

            // godown
            $this->godown->HrefValue = "";

            // avg_quantity
            $this->avg_quantity->HrefValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";

            // avialable_qty
            $this->avialable_qty->HrefValue = "";

            // ply
            $this->ply->HrefValue = "";

            // rid_new
            $this->rid_new->HrefValue = "";

            // rid_new_lot_no
            $this->rid_new_lot_no->HrefValue = "";

            // poid_new
            $this->poid_new->HrefValue = "";

            // poid_1
            $this->poid_1->HrefValue = "";

            // poid
            $this->poid->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // packets
            $this->packets->HrefValue = "";

            // process_method
            $this->process_method->HrefValue = "";

            // remark
            $this->remark->HrefValue = "";

            // dated
            $this->dated->HrefValue = "";

            // opeartor
            $this->opeartor->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->site->Visible && $this->site->Required) {
                if (!$this->site->IsDetailKey && EmptyValue($this->site->FormValue)) {
                    $this->site->addErrorMessage(str_replace("%s", $this->site->caption(), $this->site->RequiredErrorMessage));
                }
            }
            if ($this->process->Visible && $this->process->Required) {
                if (!$this->process->IsDetailKey && EmptyValue($this->process->FormValue)) {
                    $this->process->addErrorMessage(str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
                }
            }
            if ($this->sub_process->Visible && $this->sub_process->Required) {
                if (!$this->sub_process->IsDetailKey && EmptyValue($this->sub_process->FormValue)) {
                    $this->sub_process->addErrorMessage(str_replace("%s", $this->sub_process->caption(), $this->sub_process->RequiredErrorMessage));
                }
            }
            if ($this->emp_name->Visible && $this->emp_name->Required) {
                if (!$this->emp_name->IsDetailKey && EmptyValue($this->emp_name->FormValue)) {
                    $this->emp_name->addErrorMessage(str_replace("%s", $this->emp_name->caption(), $this->emp_name->RequiredErrorMessage));
                }
            }
            if ($this->jc_no->Visible && $this->jc_no->Required) {
                if (!$this->jc_no->IsDetailKey && EmptyValue($this->jc_no->FormValue)) {
                    $this->jc_no->addErrorMessage(str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->rid_1->Visible && $this->rid_1->Required) {
                if (!$this->rid_1->IsDetailKey && EmptyValue($this->rid_1->FormValue)) {
                    $this->rid_1->addErrorMessage(str_replace("%s", $this->rid_1->caption(), $this->rid_1->RequiredErrorMessage));
                }
            }
            if ($this->packing->Visible && $this->packing->Required) {
                if (!$this->packing->IsDetailKey && EmptyValue($this->packing->FormValue)) {
                    $this->packing->addErrorMessage(str_replace("%s", $this->packing->caption(), $this->packing->RequiredErrorMessage));
                }
            }
            if ($this->rid_2->Visible && $this->rid_2->Required) {
                if (!$this->rid_2->IsDetailKey && EmptyValue($this->rid_2->FormValue)) {
                    $this->rid_2->addErrorMessage(str_replace("%s", $this->rid_2->caption(), $this->rid_2->RequiredErrorMessage));
                }
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if (!$this->rid->IsDetailKey && EmptyValue($this->rid->FormValue)) {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if ($this->godown->Visible && $this->godown->Required) {
                if (!$this->godown->IsDetailKey && EmptyValue($this->godown->FormValue)) {
                    $this->godown->addErrorMessage(str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->godown->FormValue)) {
                $this->godown->addErrorMessage($this->godown->getErrorMessage(false));
            }
            if ($this->avg_quantity->Visible && $this->avg_quantity->Required) {
                if (!$this->avg_quantity->IsDetailKey && EmptyValue($this->avg_quantity->FormValue)) {
                    $this->avg_quantity->addErrorMessage(str_replace("%s", $this->avg_quantity->caption(), $this->avg_quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->avg_quantity->FormValue)) {
                $this->avg_quantity->addErrorMessage($this->avg_quantity->getErrorMessage(false));
            }
            if ($this->lot_no->Visible && $this->lot_no->Required) {
                if (!$this->lot_no->IsDetailKey && EmptyValue($this->lot_no->FormValue)) {
                    $this->lot_no->addErrorMessage(str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
                }
            }
            if ($this->avialable_qty->Visible && $this->avialable_qty->Required) {
                if (!$this->avialable_qty->IsDetailKey && EmptyValue($this->avialable_qty->FormValue)) {
                    $this->avialable_qty->addErrorMessage(str_replace("%s", $this->avialable_qty->caption(), $this->avialable_qty->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->avialable_qty->FormValue)) {
                $this->avialable_qty->addErrorMessage($this->avialable_qty->getErrorMessage(false));
            }
            if ($this->ply->Visible && $this->ply->Required) {
                if (!$this->ply->IsDetailKey && EmptyValue($this->ply->FormValue)) {
                    $this->ply->addErrorMessage(str_replace("%s", $this->ply->caption(), $this->ply->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->ply->FormValue)) {
                $this->ply->addErrorMessage($this->ply->getErrorMessage(false));
            }
            if ($this->rid_new->Visible && $this->rid_new->Required) {
                if (!$this->rid_new->IsDetailKey && EmptyValue($this->rid_new->FormValue)) {
                    $this->rid_new->addErrorMessage(str_replace("%s", $this->rid_new->caption(), $this->rid_new->RequiredErrorMessage));
                }
            }
            if ($this->rid_new_lot_no->Visible && $this->rid_new_lot_no->Required) {
                if (!$this->rid_new_lot_no->IsDetailKey && EmptyValue($this->rid_new_lot_no->FormValue)) {
                    $this->rid_new_lot_no->addErrorMessage(str_replace("%s", $this->rid_new_lot_no->caption(), $this->rid_new_lot_no->RequiredErrorMessage));
                }
            }
            if ($this->poid_new->Visible && $this->poid_new->Required) {
                if (!$this->poid_new->IsDetailKey && EmptyValue($this->poid_new->FormValue)) {
                    $this->poid_new->addErrorMessage(str_replace("%s", $this->poid_new->caption(), $this->poid_new->RequiredErrorMessage));
                }
            }
            if ($this->poid_1->Visible && $this->poid_1->Required) {
                if ($this->poid_1->FormValue == "") {
                    $this->poid_1->addErrorMessage(str_replace("%s", $this->poid_1->caption(), $this->poid_1->RequiredErrorMessage));
                }
            }
            if ($this->poid->Visible && $this->poid->Required) {
                if (!$this->poid->IsDetailKey && EmptyValue($this->poid->FormValue)) {
                    $this->poid->addErrorMessage(str_replace("%s", $this->poid->caption(), $this->poid->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity->FormValue)) {
                $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
            }
            if ($this->packets->Visible && $this->packets->Required) {
                if (!$this->packets->IsDetailKey && EmptyValue($this->packets->FormValue)) {
                    $this->packets->addErrorMessage(str_replace("%s", $this->packets->caption(), $this->packets->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->packets->FormValue)) {
                $this->packets->addErrorMessage($this->packets->getErrorMessage(false));
            }
            if ($this->process_method->Visible && $this->process_method->Required) {
                if (!$this->process_method->IsDetailKey && EmptyValue($this->process_method->FormValue)) {
                    $this->process_method->addErrorMessage(str_replace("%s", $this->process_method->caption(), $this->process_method->RequiredErrorMessage));
                }
            }
            if ($this->remark->Visible && $this->remark->Required) {
                if (!$this->remark->IsDetailKey && EmptyValue($this->remark->FormValue)) {
                    $this->remark->addErrorMessage(str_replace("%s", $this->remark->caption(), $this->remark->RequiredErrorMessage));
                }
            }
            if ($this->dated->Visible && $this->dated->Required) {
                if (!$this->dated->IsDetailKey && EmptyValue($this->dated->FormValue)) {
                    $this->dated->addErrorMessage(str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dated->FormValue, $this->dated->formatPattern())) {
                $this->dated->addErrorMessage($this->dated->getErrorMessage(false));
            }
            if ($this->opeartor->Visible && $this->opeartor->Required) {
                if (!$this->opeartor->IsDetailKey && EmptyValue($this->opeartor->FormValue)) {
                    $this->opeartor->addErrorMessage(str_replace("%s", $this->opeartor->caption(), $this->opeartor->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // site
        $this->site->setDbValueDef($rsnew, $this->site->CurrentValue, false);

        // process
        $this->process->setDbValueDef($rsnew, $this->process->CurrentValue, false);

        // sub_process
        $this->sub_process->setDbValueDef($rsnew, $this->sub_process->CurrentValue, false);

        // emp_name
        $this->emp_name->setDbValueDef($rsnew, $this->emp_name->CurrentValue, false);

        // jc_no
        $this->jc_no->setDbValueDef($rsnew, $this->jc_no->CurrentValue, strval($this->jc_no->CurrentValue) == "");

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, false);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, false);

        // rid_1
        $this->rid_1->setDbValueDef($rsnew, $this->rid_1->CurrentValue, false);

        // packing
        $this->packing->setDbValueDef($rsnew, $this->packing->CurrentValue, false);

        // rid_2
        $this->rid_2->setDbValueDef($rsnew, $this->rid_2->CurrentValue, false);

        // rid
        $this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, false);

        // godown
        $this->godown->setDbValueDef($rsnew, $this->godown->CurrentValue, false);

        // avg_quantity
        $this->avg_quantity->setDbValueDef($rsnew, $this->avg_quantity->CurrentValue, false);

        // lot_no
        $this->lot_no->setDbValueDef($rsnew, $this->lot_no->CurrentValue, false);

        // avialable_qty
        $this->avialable_qty->setDbValueDef($rsnew, $this->avialable_qty->CurrentValue, false);

        // ply
        $this->ply->setDbValueDef($rsnew, $this->ply->CurrentValue, strval($this->ply->CurrentValue) == "");

        // rid_new
        $this->rid_new->setDbValueDef($rsnew, $this->rid_new->CurrentValue, false);

        // rid_new_lot_no
        $this->rid_new_lot_no->setDbValueDef($rsnew, $this->rid_new_lot_no->CurrentValue, false);

        // poid_new
        $this->poid_new->setDbValueDef($rsnew, $this->poid_new->CurrentValue, false);

        // poid_1
        $this->poid_1->setDbValueDef($rsnew, $this->poid_1->CurrentValue, false);

        // poid
        $this->poid->setDbValueDef($rsnew, $this->poid->CurrentValue, false);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, false);

        // packets
        $this->packets->setDbValueDef($rsnew, $this->packets->CurrentValue, false);

        // process_method
        $this->process_method->setDbValueDef($rsnew, $this->process_method->CurrentValue, false);

        // remark
        $this->remark->setDbValueDef($rsnew, $this->remark->CurrentValue, false);

        // dated
        $this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()), false);

        // opeartor
        $this->opeartor->CurrentValue = $this->opeartor->getAutoUpdateValue(); // PHP
        $this->opeartor->setDbValueDef($rsnew, $this->opeartor->CurrentValue, false);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['site'])) { // site
            $this->site->setFormValue($row['site']);
        }
        if (isset($row['process'])) { // process
            $this->process->setFormValue($row['process']);
        }
        if (isset($row['sub_process'])) { // sub_process
            $this->sub_process->setFormValue($row['sub_process']);
        }
        if (isset($row['emp_name'])) { // emp_name
            $this->emp_name->setFormValue($row['emp_name']);
        }
        if (isset($row['jc_no'])) { // jc_no
            $this->jc_no->setFormValue($row['jc_no']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->setFormValue($row['s_grp']);
        }
        if (isset($row['product'])) { // product
            $this->product->setFormValue($row['product']);
        }
        if (isset($row['rid_1'])) { // rid_1
            $this->rid_1->setFormValue($row['rid_1']);
        }
        if (isset($row['packing'])) { // packing
            $this->packing->setFormValue($row['packing']);
        }
        if (isset($row['rid_2'])) { // rid_2
            $this->rid_2->setFormValue($row['rid_2']);
        }
        if (isset($row['rid'])) { // rid
            $this->rid->setFormValue($row['rid']);
        }
        if (isset($row['godown'])) { // godown
            $this->godown->setFormValue($row['godown']);
        }
        if (isset($row['avg_quantity'])) { // avg_quantity
            $this->avg_quantity->setFormValue($row['avg_quantity']);
        }
        if (isset($row['lot_no'])) { // lot_no
            $this->lot_no->setFormValue($row['lot_no']);
        }
        if (isset($row['avialable_qty'])) { // avialable_qty
            $this->avialable_qty->setFormValue($row['avialable_qty']);
        }
        if (isset($row['ply'])) { // ply
            $this->ply->setFormValue($row['ply']);
        }
        if (isset($row['rid_new'])) { // rid_new
            $this->rid_new->setFormValue($row['rid_new']);
        }
        if (isset($row['rid_new_lot_no'])) { // rid_new_lot_no
            $this->rid_new_lot_no->setFormValue($row['rid_new_lot_no']);
        }
        if (isset($row['poid_new'])) { // poid_new
            $this->poid_new->setFormValue($row['poid_new']);
        }
        if (isset($row['poid_1'])) { // poid_1
            $this->poid_1->setFormValue($row['poid_1']);
        }
        if (isset($row['poid'])) { // poid
            $this->poid->setFormValue($row['poid']);
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->setFormValue($row['quantity']);
        }
        if (isset($row['packets'])) { // packets
            $this->packets->setFormValue($row['packets']);
        }
        if (isset($row['process_method'])) { // process_method
            $this->process_method->setFormValue($row['process_method']);
        }
        if (isset($row['remark'])) { // remark
            $this->remark->setFormValue($row['remark']);
        }
        if (isset($row['dated'])) { // dated
            $this->dated->setFormValue($row['dated']);
        }
        if (isset($row['opeartor'])) { // opeartor
            $this->opeartor->setFormValue($row['opeartor']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("processactionmateriallist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_site":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_sub_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_emp_name":
                    break;
                case "x_jc_no":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid_1":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid_2":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    break;
                case "x_godown":
                    break;
                case "x_rid_new":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_poid_1":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_method":
                    break;
                case "x_payment":
                    break;
                case "x_opeartor":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type) {
    	if ($type == 'success') {
    		//$msg = "your success message";
    	} elseif ($type == 'failure') {
    		//$msg = "your failure message";
    	} elseif ($type == 'warning') {
    		//$msg = "your warning message";
    	} else {
    		$CUID = CurrentUserID();
    		$row = ExecuteScalar("SELECT IFNULL((Select `id` from `process_action_material` where `opeartor` = $CUID order by id desc LIMIT 1),0)");
    		$msg = 'Last Insert ID: ' . $row;
    	}
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'process_action_material');
    	$this->rid->ReadOnly = True;	
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
