<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProcessActionAdd extends ProcessAction
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProcessActionAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "processactionadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->process->setVisibility();
        $this->confirm_process->setVisibility();
        $this->process_other->setVisibility();
        $this->location->setVisibility();
        $this->godown->setVisibility();
        $this->code->setVisibility();
        $this->code_last->setVisibility();
        $this->employee_1->setVisibility();
        $this->employee_2->setVisibility();
        $this->employee_3->setVisibility();
        $this->employee_id->setVisibility();
        $this->qty->setVisibility();
        $this->roll_no->setVisibility();
        $this->size_w->setVisibility();
        $this->size_l->setVisibility();
        $this->size_h->setVisibility();
        $this->size_actual->setVisibility();
        $this->weight_actual->setVisibility();
        $this->lines_in_30cm->setVisibility();
        $this->d_01->setVisibility();
        $this->d_02->setVisibility();
        $this->d_03->setVisibility();
        $this->d_04->setVisibility();
        $this->d_05->setVisibility();
        $this->d_06->setVisibility();
        $this->d_07->setVisibility();
        $this->d_08->setVisibility();
        $this->d_09->setVisibility();
        $this->d_10->setVisibility();
        $this->valuation->setVisibility();
        $this->deduction->setVisibility();
        $this->remark->setVisibility();
        $this->upload->setVisibility();
        $this->uid->Visible = false;
        $this->payment->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'process_action';
        $this->TableName = 'process_action';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (process_action)
        if (!isset($GLOBALS["process_action"]) || $GLOBALS["process_action"]::class == PROJECT_NAMESPACE . "process_action") {
            $GLOBALS["process_action"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_action');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "processactionview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
                $this->upload->UploadPath = $this->upload->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->confirm_process);
        $this->setupLookupOptions($this->process_other);
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->godown);
        $this->setupLookupOptions($this->employee_1);
        $this->setupLookupOptions($this->employee_2);
        $this->setupLookupOptions($this->employee_3);
        $this->setupLookupOptions($this->employee_id);
        $this->setupLookupOptions($this->valuation);
        $this->setupLookupOptions($this->payment);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("processactionlist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getAddUrl();
                    if (GetPageName($returnUrl) == "processactionlist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "processactionview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "processactionlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "processactionlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->upload->Upload->Index = $CurrentForm->Index;
        $this->upload->Upload->uploadFile();
        $this->upload->CurrentValue = $this->upload->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->process->DefaultValue = $this->process->getDefault(); // PHP
        $this->process->OldValue = $this->process->DefaultValue;
        $this->confirm_process->DefaultValue = $this->confirm_process->getDefault(); // PHP
        $this->confirm_process->OldValue = $this->confirm_process->DefaultValue;
        $this->process_other->DefaultValue = $this->process_other->getDefault(); // PHP
        $this->process_other->OldValue = $this->process_other->DefaultValue;
        $this->location->DefaultValue = $this->location->getDefault(); // PHP
        $this->location->OldValue = $this->location->DefaultValue;
        $this->employee_1->DefaultValue = $this->employee_1->getDefault(); // PHP
        $this->employee_1->OldValue = $this->employee_1->DefaultValue;
        $this->employee_2->DefaultValue = $this->employee_2->getDefault(); // PHP
        $this->employee_2->OldValue = $this->employee_2->DefaultValue;
        $this->employee_3->DefaultValue = $this->employee_3->getDefault(); // PHP
        $this->employee_3->OldValue = $this->employee_3->DefaultValue;
        $this->qty->DefaultValue = $this->qty->getDefault(); // PHP
        $this->qty->OldValue = $this->qty->DefaultValue;
        $this->roll_no->DefaultValue = $this->roll_no->getDefault(); // PHP
        $this->roll_no->OldValue = $this->roll_no->DefaultValue;
        $this->valuation->DefaultValue = $this->valuation->getDefault(); // PHP
        $this->valuation->OldValue = $this->valuation->DefaultValue;
        $this->deduction->DefaultValue = $this->deduction->getDefault(); // PHP
        $this->deduction->OldValue = $this->deduction->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'process' first before field var 'x_process'
        $val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
        if (!$this->process->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->process->Visible = false; // Disable update for API request
            } else {
                $this->process->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'confirm_process' first before field var 'x_confirm_process'
        $val = $CurrentForm->hasValue("confirm_process") ? $CurrentForm->getValue("confirm_process") : $CurrentForm->getValue("x_confirm_process");
        if (!$this->confirm_process->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->confirm_process->Visible = false; // Disable update for API request
            } else {
                $this->confirm_process->setFormValue($val);
            }
        }

        // Check field name 'process_other' first before field var 'x_process_other'
        $val = $CurrentForm->hasValue("process_other") ? $CurrentForm->getValue("process_other") : $CurrentForm->getValue("x_process_other");
        if (!$this->process_other->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->process_other->Visible = false; // Disable update for API request
            } else {
                $this->process_other->setFormValue($val);
            }
        }

        // Check field name 'location' first before field var 'x_location'
        $val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
        if (!$this->location->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->location->Visible = false; // Disable update for API request
            } else {
                $this->location->setFormValue($val);
            }
        }

        // Check field name 'godown' first before field var 'x_godown'
        $val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
        if (!$this->godown->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->godown->Visible = false; // Disable update for API request
            } else {
                $this->godown->setFormValue($val);
            }
        }

        // Check field name 'code' first before field var 'x_code'
        $val = $CurrentForm->hasValue("code") ? $CurrentForm->getValue("code") : $CurrentForm->getValue("x_code");
        if (!$this->code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->code->Visible = false; // Disable update for API request
            } else {
                $this->code->setFormValue($val);
            }
        }

        // Check field name 'code_last' first before field var 'x_code_last'
        $val = $CurrentForm->hasValue("code_last") ? $CurrentForm->getValue("code_last") : $CurrentForm->getValue("x_code_last");
        if (!$this->code_last->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->code_last->Visible = false; // Disable update for API request
            } else {
                $this->code_last->setFormValue($val);
            }
        }

        // Check field name 'employee_1' first before field var 'x_employee_1'
        $val = $CurrentForm->hasValue("employee_1") ? $CurrentForm->getValue("employee_1") : $CurrentForm->getValue("x_employee_1");
        if (!$this->employee_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employee_1->Visible = false; // Disable update for API request
            } else {
                $this->employee_1->setFormValue($val);
            }
        }

        // Check field name 'employee_2' first before field var 'x_employee_2'
        $val = $CurrentForm->hasValue("employee_2") ? $CurrentForm->getValue("employee_2") : $CurrentForm->getValue("x_employee_2");
        if (!$this->employee_2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employee_2->Visible = false; // Disable update for API request
            } else {
                $this->employee_2->setFormValue($val);
            }
        }

        // Check field name 'employee_3' first before field var 'x_employee_3'
        $val = $CurrentForm->hasValue("employee_3") ? $CurrentForm->getValue("employee_3") : $CurrentForm->getValue("x_employee_3");
        if (!$this->employee_3->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employee_3->Visible = false; // Disable update for API request
            } else {
                $this->employee_3->setFormValue($val);
            }
        }

        // Check field name 'employee_id' first before field var 'x_employee_id'
        $val = $CurrentForm->hasValue("employee_id") ? $CurrentForm->getValue("employee_id") : $CurrentForm->getValue("x_employee_id");
        if (!$this->employee_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employee_id->Visible = false; // Disable update for API request
            } else {
                $this->employee_id->setFormValue($val);
            }
        }

        // Check field name 'qty' first before field var 'x_qty'
        $val = $CurrentForm->hasValue("qty") ? $CurrentForm->getValue("qty") : $CurrentForm->getValue("x_qty");
        if (!$this->qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty->Visible = false; // Disable update for API request
            } else {
                $this->qty->setFormValue($val);
            }
        }

        // Check field name 'roll_no' first before field var 'x_roll_no'
        $val = $CurrentForm->hasValue("roll_no") ? $CurrentForm->getValue("roll_no") : $CurrentForm->getValue("x_roll_no");
        if (!$this->roll_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->roll_no->Visible = false; // Disable update for API request
            } else {
                $this->roll_no->setFormValue($val);
            }
        }

        // Check field name 'size_w' first before field var 'x_size_w'
        $val = $CurrentForm->hasValue("size_w") ? $CurrentForm->getValue("size_w") : $CurrentForm->getValue("x_size_w");
        if (!$this->size_w->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->size_w->Visible = false; // Disable update for API request
            } else {
                $this->size_w->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'size_l' first before field var 'x_size_l'
        $val = $CurrentForm->hasValue("size_l") ? $CurrentForm->getValue("size_l") : $CurrentForm->getValue("x_size_l");
        if (!$this->size_l->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->size_l->Visible = false; // Disable update for API request
            } else {
                $this->size_l->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'size_h' first before field var 'x_size_h'
        $val = $CurrentForm->hasValue("size_h") ? $CurrentForm->getValue("size_h") : $CurrentForm->getValue("x_size_h");
        if (!$this->size_h->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->size_h->Visible = false; // Disable update for API request
            } else {
                $this->size_h->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'size_actual' first before field var 'x_size_actual'
        $val = $CurrentForm->hasValue("size_actual") ? $CurrentForm->getValue("size_actual") : $CurrentForm->getValue("x_size_actual");
        if (!$this->size_actual->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->size_actual->Visible = false; // Disable update for API request
            } else {
                $this->size_actual->setFormValue($val);
            }
        }

        // Check field name 'weight_actual' first before field var 'x_weight_actual'
        $val = $CurrentForm->hasValue("weight_actual") ? $CurrentForm->getValue("weight_actual") : $CurrentForm->getValue("x_weight_actual");
        if (!$this->weight_actual->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->weight_actual->Visible = false; // Disable update for API request
            } else {
                $this->weight_actual->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'lines_in_30cm' first before field var 'x_lines_in_30cm'
        $val = $CurrentForm->hasValue("lines_in_30cm") ? $CurrentForm->getValue("lines_in_30cm") : $CurrentForm->getValue("x_lines_in_30cm");
        if (!$this->lines_in_30cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lines_in_30cm->Visible = false; // Disable update for API request
            } else {
                $this->lines_in_30cm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'd_01' first before field var 'x_d_01'
        $val = $CurrentForm->hasValue("d_01") ? $CurrentForm->getValue("d_01") : $CurrentForm->getValue("x_d_01");
        if (!$this->d_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_01->Visible = false; // Disable update for API request
            } else {
                $this->d_01->setFormValue($val);
            }
        }

        // Check field name 'd_02' first before field var 'x_d_02'
        $val = $CurrentForm->hasValue("d_02") ? $CurrentForm->getValue("d_02") : $CurrentForm->getValue("x_d_02");
        if (!$this->d_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_02->Visible = false; // Disable update for API request
            } else {
                $this->d_02->setFormValue($val);
            }
        }

        // Check field name 'd_03' first before field var 'x_d_03'
        $val = $CurrentForm->hasValue("d_03") ? $CurrentForm->getValue("d_03") : $CurrentForm->getValue("x_d_03");
        if (!$this->d_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_03->Visible = false; // Disable update for API request
            } else {
                $this->d_03->setFormValue($val);
            }
        }

        // Check field name 'd_04' first before field var 'x_d_04'
        $val = $CurrentForm->hasValue("d_04") ? $CurrentForm->getValue("d_04") : $CurrentForm->getValue("x_d_04");
        if (!$this->d_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_04->Visible = false; // Disable update for API request
            } else {
                $this->d_04->setFormValue($val);
            }
        }

        // Check field name 'd_05' first before field var 'x_d_05'
        $val = $CurrentForm->hasValue("d_05") ? $CurrentForm->getValue("d_05") : $CurrentForm->getValue("x_d_05");
        if (!$this->d_05->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_05->Visible = false; // Disable update for API request
            } else {
                $this->d_05->setFormValue($val);
            }
        }

        // Check field name 'd_06' first before field var 'x_d_06'
        $val = $CurrentForm->hasValue("d_06") ? $CurrentForm->getValue("d_06") : $CurrentForm->getValue("x_d_06");
        if (!$this->d_06->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_06->Visible = false; // Disable update for API request
            } else {
                $this->d_06->setFormValue($val);
            }
        }

        // Check field name 'd_07' first before field var 'x_d_07'
        $val = $CurrentForm->hasValue("d_07") ? $CurrentForm->getValue("d_07") : $CurrentForm->getValue("x_d_07");
        if (!$this->d_07->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_07->Visible = false; // Disable update for API request
            } else {
                $this->d_07->setFormValue($val);
            }
        }

        // Check field name 'd_08' first before field var 'x_d_08'
        $val = $CurrentForm->hasValue("d_08") ? $CurrentForm->getValue("d_08") : $CurrentForm->getValue("x_d_08");
        if (!$this->d_08->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_08->Visible = false; // Disable update for API request
            } else {
                $this->d_08->setFormValue($val);
            }
        }

        // Check field name 'd_09' first before field var 'x_d_09'
        $val = $CurrentForm->hasValue("d_09") ? $CurrentForm->getValue("d_09") : $CurrentForm->getValue("x_d_09");
        if (!$this->d_09->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_09->Visible = false; // Disable update for API request
            } else {
                $this->d_09->setFormValue($val);
            }
        }

        // Check field name 'd_10' first before field var 'x_d_10'
        $val = $CurrentForm->hasValue("d_10") ? $CurrentForm->getValue("d_10") : $CurrentForm->getValue("x_d_10");
        if (!$this->d_10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_10->Visible = false; // Disable update for API request
            } else {
                $this->d_10->setFormValue($val);
            }
        }

        // Check field name 'valuation' first before field var 'x_valuation'
        $val = $CurrentForm->hasValue("valuation") ? $CurrentForm->getValue("valuation") : $CurrentForm->getValue("x_valuation");
        if (!$this->valuation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->valuation->Visible = false; // Disable update for API request
            } else {
                $this->valuation->setFormValue($val);
            }
        }

        // Check field name 'deduction' first before field var 'x_deduction'
        $val = $CurrentForm->hasValue("deduction") ? $CurrentForm->getValue("deduction") : $CurrentForm->getValue("x_deduction");
        if (!$this->deduction->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->deduction->Visible = false; // Disable update for API request
            } else {
                $this->deduction->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'remark' first before field var 'x_remark'
        $val = $CurrentForm->hasValue("remark") ? $CurrentForm->getValue("remark") : $CurrentForm->getValue("x_remark");
        if (!$this->remark->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remark->Visible = false; // Disable update for API request
            } else {
                $this->remark->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		$this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
		$this->upload->UploadPath = $this->upload->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->process->CurrentValue = $this->process->FormValue;
        $this->confirm_process->CurrentValue = $this->confirm_process->FormValue;
        $this->process_other->CurrentValue = $this->process_other->FormValue;
        $this->location->CurrentValue = $this->location->FormValue;
        $this->godown->CurrentValue = $this->godown->FormValue;
        $this->code->CurrentValue = $this->code->FormValue;
        $this->code_last->CurrentValue = $this->code_last->FormValue;
        $this->employee_1->CurrentValue = $this->employee_1->FormValue;
        $this->employee_2->CurrentValue = $this->employee_2->FormValue;
        $this->employee_3->CurrentValue = $this->employee_3->FormValue;
        $this->employee_id->CurrentValue = $this->employee_id->FormValue;
        $this->qty->CurrentValue = $this->qty->FormValue;
        $this->roll_no->CurrentValue = $this->roll_no->FormValue;
        $this->size_w->CurrentValue = $this->size_w->FormValue;
        $this->size_l->CurrentValue = $this->size_l->FormValue;
        $this->size_h->CurrentValue = $this->size_h->FormValue;
        $this->size_actual->CurrentValue = $this->size_actual->FormValue;
        $this->weight_actual->CurrentValue = $this->weight_actual->FormValue;
        $this->lines_in_30cm->CurrentValue = $this->lines_in_30cm->FormValue;
        $this->d_01->CurrentValue = $this->d_01->FormValue;
        $this->d_02->CurrentValue = $this->d_02->FormValue;
        $this->d_03->CurrentValue = $this->d_03->FormValue;
        $this->d_04->CurrentValue = $this->d_04->FormValue;
        $this->d_05->CurrentValue = $this->d_05->FormValue;
        $this->d_06->CurrentValue = $this->d_06->FormValue;
        $this->d_07->CurrentValue = $this->d_07->FormValue;
        $this->d_08->CurrentValue = $this->d_08->FormValue;
        $this->d_09->CurrentValue = $this->d_09->FormValue;
        $this->d_10->CurrentValue = $this->d_10->FormValue;
        $this->valuation->CurrentValue = $this->valuation->FormValue;
        $this->deduction->CurrentValue = $this->deduction->FormValue;
        $this->remark->CurrentValue = $this->remark->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->process->setDbValue($row['process']);
        $this->confirm_process->setDbValue($row['confirm_process']);
        $this->process_other->setDbValue($row['process_other']);
        $this->location->setDbValue($row['location']);
        $this->godown->setDbValue($row['godown']);
        $this->code->setDbValue($row['code']);
        $this->code_last->setDbValue($row['code_last']);
        $this->employee_1->setDbValue($row['employee_1']);
        $this->employee_2->setDbValue($row['employee_2']);
        $this->employee_3->setDbValue($row['employee_3']);
        $this->employee_id->setDbValue($row['employee_id']);
        $this->qty->setDbValue($row['qty']);
        $this->roll_no->setDbValue($row['roll_no']);
        $this->size_w->setDbValue($row['size_w']);
        $this->size_l->setDbValue($row['size_l']);
        $this->size_h->setDbValue($row['size_h']);
        $this->size_actual->setDbValue($row['size_actual']);
        $this->weight_actual->setDbValue($row['weight_actual']);
        $this->lines_in_30cm->setDbValue($row['lines_in_30cm']);
        $this->d_01->setDbValue($row['d_01']);
        $this->d_02->setDbValue($row['d_02']);
        $this->d_03->setDbValue($row['d_03']);
        $this->d_04->setDbValue($row['d_04']);
        $this->d_05->setDbValue($row['d_05']);
        $this->d_06->setDbValue($row['d_06']);
        $this->d_07->setDbValue($row['d_07']);
        $this->d_08->setDbValue($row['d_08']);
        $this->d_09->setDbValue($row['d_09']);
        $this->d_10->setDbValue($row['d_10']);
        $this->valuation->setDbValue($row['valuation']);
        $this->deduction->setDbValue($row['deduction']);
        $this->remark->setDbValue($row['remark']);
        $this->upload->Upload->DbValue = $row['upload'];
        $this->upload->setDbValue($this->upload->Upload->DbValue);
        $this->uid->setDbValue($row['uid']);
        $this->payment->setDbValue($row['payment']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['confirm_process'] = $this->confirm_process->DefaultValue;
        $row['process_other'] = $this->process_other->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['godown'] = $this->godown->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['code_last'] = $this->code_last->DefaultValue;
        $row['employee_1'] = $this->employee_1->DefaultValue;
        $row['employee_2'] = $this->employee_2->DefaultValue;
        $row['employee_3'] = $this->employee_3->DefaultValue;
        $row['employee_id'] = $this->employee_id->DefaultValue;
        $row['qty'] = $this->qty->DefaultValue;
        $row['roll_no'] = $this->roll_no->DefaultValue;
        $row['size_w'] = $this->size_w->DefaultValue;
        $row['size_l'] = $this->size_l->DefaultValue;
        $row['size_h'] = $this->size_h->DefaultValue;
        $row['size_actual'] = $this->size_actual->DefaultValue;
        $row['weight_actual'] = $this->weight_actual->DefaultValue;
        $row['lines_in_30cm'] = $this->lines_in_30cm->DefaultValue;
        $row['d_01'] = $this->d_01->DefaultValue;
        $row['d_02'] = $this->d_02->DefaultValue;
        $row['d_03'] = $this->d_03->DefaultValue;
        $row['d_04'] = $this->d_04->DefaultValue;
        $row['d_05'] = $this->d_05->DefaultValue;
        $row['d_06'] = $this->d_06->DefaultValue;
        $row['d_07'] = $this->d_07->DefaultValue;
        $row['d_08'] = $this->d_08->DefaultValue;
        $row['d_09'] = $this->d_09->DefaultValue;
        $row['d_10'] = $this->d_10->DefaultValue;
        $row['valuation'] = $this->valuation->DefaultValue;
        $row['deduction'] = $this->deduction->DefaultValue;
        $row['remark'] = $this->remark->DefaultValue;
        $row['upload'] = $this->upload->DefaultValue;
        $row['uid'] = $this->uid->DefaultValue;
        $row['payment'] = $this->payment->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // confirm_process
        $this->confirm_process->RowCssClass = "row";

        // process_other
        $this->process_other->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // godown
        $this->godown->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // code_last
        $this->code_last->RowCssClass = "row";

        // employee_1
        $this->employee_1->RowCssClass = "row";

        // employee_2
        $this->employee_2->RowCssClass = "row";

        // employee_3
        $this->employee_3->RowCssClass = "row";

        // employee_id
        $this->employee_id->RowCssClass = "row";

        // qty
        $this->qty->RowCssClass = "row";

        // roll_no
        $this->roll_no->RowCssClass = "row";

        // size_w
        $this->size_w->RowCssClass = "row";

        // size_l
        $this->size_l->RowCssClass = "row";

        // size_h
        $this->size_h->RowCssClass = "row";

        // size_actual
        $this->size_actual->RowCssClass = "row";

        // weight_actual
        $this->weight_actual->RowCssClass = "row";

        // lines_in_30cm
        $this->lines_in_30cm->RowCssClass = "row";

        // d_01
        $this->d_01->RowCssClass = "row";

        // d_02
        $this->d_02->RowCssClass = "row";

        // d_03
        $this->d_03->RowCssClass = "row";

        // d_04
        $this->d_04->RowCssClass = "row";

        // d_05
        $this->d_05->RowCssClass = "row";

        // d_06
        $this->d_06->RowCssClass = "row";

        // d_07
        $this->d_07->RowCssClass = "row";

        // d_08
        $this->d_08->RowCssClass = "row";

        // d_09
        $this->d_09->RowCssClass = "row";

        // d_10
        $this->d_10->RowCssClass = "row";

        // valuation
        $this->valuation->RowCssClass = "row";

        // deduction
        $this->deduction->RowCssClass = "row";

        // remark
        $this->remark->RowCssClass = "row";

        // upload
        $this->upload->RowCssClass = "row";

        // uid
        $this->uid->RowCssClass = "row";

        // payment
        $this->payment->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // process
            $this->process->ViewValue = $this->process->CurrentValue;
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // confirm_process
            $curVal = strval($this->confirm_process->CurrentValue);
            if ($curVal != "") {
                $this->confirm_process->ViewValue = $this->confirm_process->lookupCacheOption($curVal);
                if ($this->confirm_process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->confirm_process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->confirm_process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->confirm_process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->confirm_process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->confirm_process->Lookup->renderViewRow($rswrk[0]);
                        $this->confirm_process->ViewValue = $this->confirm_process->displayValue($arwrk);
                    } else {
                        $this->confirm_process->ViewValue = $this->confirm_process->CurrentValue;
                    }
                }
            } else {
                $this->confirm_process->ViewValue = null;
            }

            // process_other
            $curVal = strval($this->process_other->CurrentValue);
            if ($curVal != "") {
                $this->process_other->ViewValue = $this->process_other->lookupCacheOption($curVal);
                if ($this->process_other->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_other->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_other->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->process_other->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process_other->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process_other->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process_other->Lookup->renderViewRow($row);
                            $this->process_other->ViewValue->add($this->process_other->displayValue($arwrk));
                        }
                    } else {
                        $this->process_other->ViewValue = $this->process_other->CurrentValue;
                    }
                }
            } else {
                $this->process_other->ViewValue = null;
            }

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                        $this->location->ViewValue = $this->location->displayValue($arwrk);
                    } else {
                        $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // godown
            $curVal = strval($this->godown->CurrentValue);
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                        $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                    } else {
                        $this->godown->ViewValue = FormatNumber($this->godown->CurrentValue, $this->godown->formatPattern());
                    }
                }
            } else {
                $this->godown->ViewValue = null;
            }

            // code
            $this->code->ViewValue = $this->code->CurrentValue;
            if ($this->code->ViewValue != null) {
                $this->code->ViewValue = str_replace(["\r\n", "\n", "\r"], "<br>", $this->code->ViewValue);
            }

            // code_last
            $this->code_last->ViewValue = $this->code_last->CurrentValue;

            // employee_1
            $curVal = strval($this->employee_1->CurrentValue);
            if ($curVal != "") {
                $this->employee_1->ViewValue = $this->employee_1->lookupCacheOption($curVal);
                if ($this->employee_1->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->employee_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_1->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->employee_1->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->employee_1->Lookup->renderViewRow($rswrk[0]);
                        $this->employee_1->ViewValue = $this->employee_1->displayValue($arwrk);
                    } else {
                        $this->employee_1->ViewValue = FormatNumber($this->employee_1->CurrentValue, $this->employee_1->formatPattern());
                    }
                }
            } else {
                $this->employee_1->ViewValue = null;
            }

            // employee_2
            $curVal = strval($this->employee_2->CurrentValue);
            if ($curVal != "") {
                $this->employee_2->ViewValue = $this->employee_2->lookupCacheOption($curVal);
                if ($this->employee_2->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->employee_2->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_2->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->employee_2->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->employee_2->Lookup->renderViewRow($rswrk[0]);
                        $this->employee_2->ViewValue = $this->employee_2->displayValue($arwrk);
                    } else {
                        $this->employee_2->ViewValue = FormatNumber($this->employee_2->CurrentValue, $this->employee_2->formatPattern());
                    }
                }
            } else {
                $this->employee_2->ViewValue = null;
            }

            // employee_3
            $curVal = strval($this->employee_3->CurrentValue);
            if ($curVal != "") {
                $this->employee_3->ViewValue = $this->employee_3->lookupCacheOption($curVal);
                if ($this->employee_3->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->employee_3->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_3->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->employee_3->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->employee_3->Lookup->renderViewRow($rswrk[0]);
                        $this->employee_3->ViewValue = $this->employee_3->displayValue($arwrk);
                    } else {
                        $this->employee_3->ViewValue = FormatNumber($this->employee_3->CurrentValue, $this->employee_3->formatPattern());
                    }
                }
            } else {
                $this->employee_3->ViewValue = null;
            }

            // employee_id
            $curVal = strval($this->employee_id->CurrentValue);
            if ($curVal != "") {
                $this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
                if ($this->employee_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->employee_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->employee_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->employee_id->Lookup->renderViewRow($row);
                            $this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
                        }
                    } else {
                        $this->employee_id->ViewValue = $this->employee_id->CurrentValue;
                    }
                }
            } else {
                $this->employee_id->ViewValue = null;
            }

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // roll_no
            $this->roll_no->ViewValue = $this->roll_no->CurrentValue;
            $this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, $this->roll_no->formatPattern());

            // size_w
            $this->size_w->ViewValue = $this->size_w->CurrentValue;
            $this->size_w->ViewValue = FormatNumber($this->size_w->ViewValue, $this->size_w->formatPattern());

            // size_l
            $this->size_l->ViewValue = $this->size_l->CurrentValue;
            $this->size_l->ViewValue = FormatNumber($this->size_l->ViewValue, $this->size_l->formatPattern());

            // size_h
            $this->size_h->ViewValue = $this->size_h->CurrentValue;
            $this->size_h->ViewValue = FormatNumber($this->size_h->ViewValue, $this->size_h->formatPattern());

            // size_actual
            $this->size_actual->ViewValue = $this->size_actual->CurrentValue;

            // weight_actual
            $this->weight_actual->ViewValue = $this->weight_actual->CurrentValue;
            $this->weight_actual->ViewValue = FormatNumber($this->weight_actual->ViewValue, $this->weight_actual->formatPattern());

            // lines_in_30cm
            $this->lines_in_30cm->ViewValue = $this->lines_in_30cm->CurrentValue;

            // d_01
            $this->d_01->ViewValue = $this->d_01->CurrentValue;

            // d_02
            $this->d_02->ViewValue = $this->d_02->CurrentValue;

            // d_03
            $this->d_03->ViewValue = $this->d_03->CurrentValue;

            // d_04
            $this->d_04->ViewValue = $this->d_04->CurrentValue;

            // d_05
            $this->d_05->ViewValue = $this->d_05->CurrentValue;

            // d_06
            $this->d_06->ViewValue = $this->d_06->CurrentValue;

            // d_07
            $this->d_07->ViewValue = $this->d_07->CurrentValue;

            // d_08
            $this->d_08->ViewValue = $this->d_08->CurrentValue;

            // d_09
            $this->d_09->ViewValue = $this->d_09->CurrentValue;

            // d_10
            $this->d_10->ViewValue = $this->d_10->CurrentValue;

            // valuation
            if (strval($this->valuation->CurrentValue) != "") {
                $this->valuation->ViewValue = $this->valuation->optionCaption($this->valuation->CurrentValue);
            } else {
                $this->valuation->ViewValue = null;
            }

            // deduction
            $this->deduction->ViewValue = $this->deduction->CurrentValue;
            $this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, $this->deduction->formatPattern());

            // remark
            $this->remark->ViewValue = $this->remark->CurrentValue;

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->ImageWidth = 0;
                $this->upload->ImageHeight = 50;
                $this->upload->ImageAlt = $this->upload->alt();
                $this->upload->ImageCssClass = "ew-image";
                $this->upload->ViewValue = $this->upload->Upload->DbValue;
            } else {
                $this->upload->ViewValue = "";
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }
            $this->process->TooltipValue = "";

            // confirm_process
            $this->confirm_process->HrefValue = "";
            $this->confirm_process->TooltipValue = "";

            // process_other
            $this->process_other->HrefValue = "";
            $this->process_other->TooltipValue = "";

            // location
            $this->location->HrefValue = "";
            $this->location->TooltipValue = "";

            // godown
            $this->godown->HrefValue = "";

            // code
            if (!EmptyValue($this->code->CurrentValue)) {
                $this->code->HrefValue = $this->code->getLinkPrefix() . $this->code->CurrentValue; // Add prefix/suffix
                $this->code->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->code->HrefValue = FullUrl($this->code->HrefValue, "href");
                }
            } else {
                $this->code->HrefValue = "";
            }
            $this->code->TooltipValue = "";

            // code_last
            $this->code_last->HrefValue = "";
            $this->code_last->TooltipValue = "";

            // employee_1
            if (!EmptyValue($this->employee_1->CurrentValue)) {
                $this->employee_1->HrefValue = $this->employee_1->getLinkPrefix() . $this->employee_1->CurrentValue; // Add prefix/suffix
                $this->employee_1->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->employee_1->HrefValue = FullUrl($this->employee_1->HrefValue, "href");
                }
            } else {
                $this->employee_1->HrefValue = "";
            }

            // employee_2
            $this->employee_2->HrefValue = "";

            // employee_3
            $this->employee_3->HrefValue = "";

            // employee_id
            $this->employee_id->HrefValue = "";

            // qty
            $this->qty->HrefValue = "";

            // roll_no
            $this->roll_no->HrefValue = "";

            // size_w
            $this->size_w->HrefValue = "";

            // size_l
            $this->size_l->HrefValue = "";

            // size_h
            $this->size_h->HrefValue = "";

            // size_actual
            $this->size_actual->HrefValue = "";

            // weight_actual
            $this->weight_actual->HrefValue = "";

            // lines_in_30cm
            $this->lines_in_30cm->HrefValue = "";

            // d_01
            $this->d_01->HrefValue = "";

            // d_02
            $this->d_02->HrefValue = "";

            // d_03
            $this->d_03->HrefValue = "";

            // d_04
            $this->d_04->HrefValue = "";

            // d_05
            $this->d_05->HrefValue = "";

            // d_06
            $this->d_06->HrefValue = "";

            // d_07
            $this->d_07->HrefValue = "";

            // d_08
            $this->d_08->HrefValue = "";

            // d_09
            $this->d_09->HrefValue = "";

            // d_10
            $this->d_10->HrefValue = "";

            // valuation
            $this->valuation->HrefValue = "";

            // deduction
            $this->deduction->HrefValue = "";

            // remark
            $this->remark->HrefValue = "";

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->HrefValue = GetFileUploadUrl($this->upload, $this->upload->htmlDecode($this->upload->Upload->DbValue)); // Add prefix/suffix
                $this->upload->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
                }
            } else {
                $this->upload->HrefValue = "";
            }
            $this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // process
            $this->process->setupEditAttributes();
            $this->process->EditCustomAttributes = $this->process->getEditCustomAttributes(); // PHP
            $this->process->EditValue = $this->process->CurrentValue;
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->EditValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->EditValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->EditValue = HtmlEncode(FormatNumber($this->process->CurrentValue, $this->process->formatPattern()));
                    }
                }
            } else {
                $this->process->EditValue = null;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // confirm_process
            $this->confirm_process->setupEditAttributes();
            $curVal = trim(strval($this->confirm_process->CurrentValue));
            if ($curVal != "") {
                $this->confirm_process->ViewValue = $this->confirm_process->lookupCacheOption($curVal);
            } else {
                $this->confirm_process->ViewValue = $this->confirm_process->Lookup !== null && is_array($this->confirm_process->lookupOptions()) && count($this->confirm_process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->confirm_process->ViewValue !== null) { // Load from cache
                $this->confirm_process->EditValue = array_values($this->confirm_process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->confirm_process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->confirm_process->CurrentValue, $this->confirm_process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->confirm_process->getSelectFilter($this); // PHP
                $sqlWrk = $this->confirm_process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->confirm_process->EditValue = $arwrk;
            }
            $this->confirm_process->PlaceHolder = RemoveHtml($this->confirm_process->caption());

            // process_other
            $curVal = trim(strval($this->process_other->CurrentValue));
            if ($curVal != "") {
                $this->process_other->ViewValue = $this->process_other->lookupCacheOption($curVal);
            } else {
                $this->process_other->ViewValue = $this->process_other->Lookup !== null && is_array($this->process_other->lookupOptions()) && count($this->process_other->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process_other->ViewValue !== null) { // Load from cache
                $this->process_other->EditValue = array_values($this->process_other->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process_other->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process_other->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->process_other->getSelectFilter($this); // PHP
                $sqlWrk = $this->process_other->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process_other->EditValue = $arwrk;
            }
            $this->process_other->PlaceHolder = RemoveHtml($this->process_other->caption());

            // location
            $this->location->setupEditAttributes();
            $curVal = trim(strval($this->location->CurrentValue));
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->location->CurrentValue, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // godown
            $this->godown->setupEditAttributes();
            $curVal = trim(strval($this->godown->CurrentValue));
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
            } else {
                $this->godown->ViewValue = $this->godown->Lookup !== null && is_array($this->godown->lookupOptions()) && count($this->godown->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->godown->ViewValue !== null) { // Load from cache
                $this->godown->EditValue = array_values($this->godown->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->godown->CurrentValue, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->godown->EditValue = $arwrk;
            }
            $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

            // code
            $this->code->setupEditAttributes();
            $this->code->EditCustomAttributes = $this->code->getEditCustomAttributes(); // PHP
            $this->code->EditValue = HtmlEncode($this->code->CurrentValue);
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());

            // code_last
            $this->code_last->setupEditAttributes();
            $this->code_last->EditValue = HtmlEncode($this->code_last->CurrentValue);
            $this->code_last->PlaceHolder = RemoveHtml($this->code_last->caption());

            // employee_1
            $this->employee_1->setupEditAttributes();
            $curVal = trim(strval($this->employee_1->CurrentValue));
            if ($curVal != "") {
                $this->employee_1->ViewValue = $this->employee_1->lookupCacheOption($curVal);
            } else {
                $this->employee_1->ViewValue = $this->employee_1->Lookup !== null && is_array($this->employee_1->lookupOptions()) && count($this->employee_1->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->employee_1->ViewValue !== null) { // Load from cache
                $this->employee_1->EditValue = array_values($this->employee_1->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->employee_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->employee_1->CurrentValue, $this->employee_1->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->employee_1->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->employee_1->Lookup->renderViewRow($row);
                }
                $this->employee_1->EditValue = $arwrk;
            }
            $this->employee_1->PlaceHolder = RemoveHtml($this->employee_1->caption());

            // employee_2
            $this->employee_2->setupEditAttributes();
            $curVal = trim(strval($this->employee_2->CurrentValue));
            if ($curVal != "") {
                $this->employee_2->ViewValue = $this->employee_2->lookupCacheOption($curVal);
            } else {
                $this->employee_2->ViewValue = $this->employee_2->Lookup !== null && is_array($this->employee_2->lookupOptions()) && count($this->employee_2->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->employee_2->ViewValue !== null) { // Load from cache
                $this->employee_2->EditValue = array_values($this->employee_2->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->employee_2->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->employee_2->CurrentValue, $this->employee_2->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->employee_2->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->employee_2->Lookup->renderViewRow($row);
                }
                $this->employee_2->EditValue = $arwrk;
            }
            $this->employee_2->PlaceHolder = RemoveHtml($this->employee_2->caption());

            // employee_3
            $this->employee_3->setupEditAttributes();
            $curVal = trim(strval($this->employee_3->CurrentValue));
            if ($curVal != "") {
                $this->employee_3->ViewValue = $this->employee_3->lookupCacheOption($curVal);
            } else {
                $this->employee_3->ViewValue = $this->employee_3->Lookup !== null && is_array($this->employee_3->lookupOptions()) && count($this->employee_3->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->employee_3->ViewValue !== null) { // Load from cache
                $this->employee_3->EditValue = array_values($this->employee_3->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->employee_3->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->employee_3->CurrentValue, $this->employee_3->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->employee_3->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->employee_3->Lookup->renderViewRow($row);
                }
                $this->employee_3->EditValue = $arwrk;
            }
            $this->employee_3->PlaceHolder = RemoveHtml($this->employee_3->caption());

            // employee_id
            $curVal = trim(strval($this->employee_id->CurrentValue));
            if ($curVal != "") {
                $this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
            } else {
                $this->employee_id->ViewValue = $this->employee_id->Lookup !== null && is_array($this->employee_id->lookupOptions()) && count($this->employee_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->employee_id->ViewValue !== null) { // Load from cache
                $this->employee_id->EditValue = array_values($this->employee_id->lookupOptions());
                if ($this->employee_id->ViewValue == "") {
                    $this->employee_id->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->employee_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->employee_id->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->employee_id->Lookup->renderViewRow($row);
                        $this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->employee_id->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->employee_id->Lookup->renderViewRow($row);
                }
                $this->employee_id->EditValue = $arwrk;
            }
            $this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());

            // qty
            $this->qty->setupEditAttributes();
            $this->qty->EditValue = $this->qty->CurrentValue;
            $this->qty->PlaceHolder = RemoveHtml($this->qty->caption());
            if (strval($this->qty->EditValue) != "" && is_numeric($this->qty->EditValue)) {
                $this->qty->EditValue = FormatNumber($this->qty->EditValue, null);
            }

            // roll_no
            $this->roll_no->setupEditAttributes();
            $this->roll_no->EditValue = $this->roll_no->CurrentValue;
            $this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());
            if (strval($this->roll_no->EditValue) != "" && is_numeric($this->roll_no->EditValue)) {
                $this->roll_no->EditValue = FormatNumber($this->roll_no->EditValue, null);
            }

            // size_w
            $this->size_w->setupEditAttributes();
            $this->size_w->EditValue = $this->size_w->CurrentValue;
            $this->size_w->PlaceHolder = RemoveHtml($this->size_w->caption());
            if (strval($this->size_w->EditValue) != "" && is_numeric($this->size_w->EditValue)) {
                $this->size_w->EditValue = FormatNumber($this->size_w->EditValue, null);
            }

            // size_l
            $this->size_l->setupEditAttributes();
            $this->size_l->EditValue = $this->size_l->CurrentValue;
            $this->size_l->PlaceHolder = RemoveHtml($this->size_l->caption());
            if (strval($this->size_l->EditValue) != "" && is_numeric($this->size_l->EditValue)) {
                $this->size_l->EditValue = FormatNumber($this->size_l->EditValue, null);
            }

            // size_h
            $this->size_h->setupEditAttributes();
            $this->size_h->EditValue = $this->size_h->CurrentValue;
            $this->size_h->PlaceHolder = RemoveHtml($this->size_h->caption());
            if (strval($this->size_h->EditValue) != "" && is_numeric($this->size_h->EditValue)) {
                $this->size_h->EditValue = FormatNumber($this->size_h->EditValue, null);
            }

            // size_actual
            $this->size_actual->setupEditAttributes();
            if (!$this->size_actual->Raw) {
                $this->size_actual->CurrentValue = HtmlDecode($this->size_actual->CurrentValue);
            }
            $this->size_actual->EditValue = HtmlEncode($this->size_actual->CurrentValue);
            $this->size_actual->PlaceHolder = RemoveHtml($this->size_actual->caption());

            // weight_actual
            $this->weight_actual->setupEditAttributes();
            $this->weight_actual->EditValue = $this->weight_actual->CurrentValue;
            $this->weight_actual->PlaceHolder = RemoveHtml($this->weight_actual->caption());
            if (strval($this->weight_actual->EditValue) != "" && is_numeric($this->weight_actual->EditValue)) {
                $this->weight_actual->EditValue = FormatNumber($this->weight_actual->EditValue, null);
            }

            // lines_in_30cm
            $this->lines_in_30cm->setupEditAttributes();
            if (!$this->lines_in_30cm->Raw) {
                $this->lines_in_30cm->CurrentValue = HtmlDecode($this->lines_in_30cm->CurrentValue);
            }
            $this->lines_in_30cm->EditValue = HtmlEncode($this->lines_in_30cm->CurrentValue);
            $this->lines_in_30cm->PlaceHolder = RemoveHtml($this->lines_in_30cm->caption());

            // d_01
            $this->d_01->setupEditAttributes();
            if (!$this->d_01->Raw) {
                $this->d_01->CurrentValue = HtmlDecode($this->d_01->CurrentValue);
            }
            $this->d_01->EditValue = HtmlEncode($this->d_01->CurrentValue);
            $this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());

            // d_02
            $this->d_02->setupEditAttributes();
            if (!$this->d_02->Raw) {
                $this->d_02->CurrentValue = HtmlDecode($this->d_02->CurrentValue);
            }
            $this->d_02->EditValue = HtmlEncode($this->d_02->CurrentValue);
            $this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());

            // d_03
            $this->d_03->setupEditAttributes();
            if (!$this->d_03->Raw) {
                $this->d_03->CurrentValue = HtmlDecode($this->d_03->CurrentValue);
            }
            $this->d_03->EditValue = HtmlEncode($this->d_03->CurrentValue);
            $this->d_03->PlaceHolder = RemoveHtml($this->d_03->caption());

            // d_04
            $this->d_04->setupEditAttributes();
            if (!$this->d_04->Raw) {
                $this->d_04->CurrentValue = HtmlDecode($this->d_04->CurrentValue);
            }
            $this->d_04->EditValue = HtmlEncode($this->d_04->CurrentValue);
            $this->d_04->PlaceHolder = RemoveHtml($this->d_04->caption());

            // d_05
            $this->d_05->setupEditAttributes();
            if (!$this->d_05->Raw) {
                $this->d_05->CurrentValue = HtmlDecode($this->d_05->CurrentValue);
            }
            $this->d_05->EditValue = HtmlEncode($this->d_05->CurrentValue);
            $this->d_05->PlaceHolder = RemoveHtml($this->d_05->caption());

            // d_06
            $this->d_06->setupEditAttributes();
            if (!$this->d_06->Raw) {
                $this->d_06->CurrentValue = HtmlDecode($this->d_06->CurrentValue);
            }
            $this->d_06->EditValue = HtmlEncode($this->d_06->CurrentValue);
            $this->d_06->PlaceHolder = RemoveHtml($this->d_06->caption());

            // d_07
            $this->d_07->setupEditAttributes();
            if (!$this->d_07->Raw) {
                $this->d_07->CurrentValue = HtmlDecode($this->d_07->CurrentValue);
            }
            $this->d_07->EditValue = HtmlEncode($this->d_07->CurrentValue);
            $this->d_07->PlaceHolder = RemoveHtml($this->d_07->caption());

            // d_08
            $this->d_08->setupEditAttributes();
            if (!$this->d_08->Raw) {
                $this->d_08->CurrentValue = HtmlDecode($this->d_08->CurrentValue);
            }
            $this->d_08->EditValue = HtmlEncode($this->d_08->CurrentValue);
            $this->d_08->PlaceHolder = RemoveHtml($this->d_08->caption());

            // d_09
            $this->d_09->setupEditAttributes();
            if (!$this->d_09->Raw) {
                $this->d_09->CurrentValue = HtmlDecode($this->d_09->CurrentValue);
            }
            $this->d_09->EditValue = HtmlEncode($this->d_09->CurrentValue);
            $this->d_09->PlaceHolder = RemoveHtml($this->d_09->caption());

            // d_10
            $this->d_10->setupEditAttributes();
            if (!$this->d_10->Raw) {
                $this->d_10->CurrentValue = HtmlDecode($this->d_10->CurrentValue);
            }
            $this->d_10->EditValue = HtmlEncode($this->d_10->CurrentValue);
            $this->d_10->PlaceHolder = RemoveHtml($this->d_10->caption());

            // valuation
            $this->valuation->setupEditAttributes();
            $this->valuation->EditValue = $this->valuation->options(true);
            $this->valuation->PlaceHolder = RemoveHtml($this->valuation->caption());

            // deduction
            $this->deduction->setupEditAttributes();
            $this->deduction->EditValue = $this->deduction->CurrentValue;
            $this->deduction->PlaceHolder = RemoveHtml($this->deduction->caption());
            if (strval($this->deduction->EditValue) != "" && is_numeric($this->deduction->EditValue)) {
                $this->deduction->EditValue = FormatNumber($this->deduction->EditValue, null);
            }

            // remark
            $this->remark->setupEditAttributes();
            if (!$this->remark->Raw) {
                $this->remark->CurrentValue = HtmlDecode($this->remark->CurrentValue);
            }
            $this->remark->EditValue = HtmlEncode($this->remark->CurrentValue);
            $this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

            // upload
            $this->upload->setupEditAttributes();
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->ImageWidth = 0;
                $this->upload->ImageHeight = 50;
                $this->upload->ImageAlt = $this->upload->alt();
                $this->upload->ImageCssClass = "ew-image";
                $this->upload->EditValue = $this->upload->Upload->DbValue;
            } else {
                $this->upload->EditValue = "";
            }
            if (!EmptyValue($this->upload->CurrentValue)) {
                $this->upload->Upload->FileName = $this->upload->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->upload->Upload->DbValue = null;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->upload);
            }

            // operator

            // datetime

            // Add refer script

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }

            // confirm_process
            $this->confirm_process->HrefValue = "";

            // process_other
            $this->process_other->HrefValue = "";

            // location
            $this->location->HrefValue = "";

            // godown
            $this->godown->HrefValue = "";

            // code
            if (!EmptyValue($this->code->CurrentValue)) {
                $this->code->HrefValue = $this->code->getLinkPrefix() . $this->code->CurrentValue; // Add prefix/suffix
                $this->code->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->code->HrefValue = FullUrl($this->code->HrefValue, "href");
                }
            } else {
                $this->code->HrefValue = "";
            }

            // code_last
            $this->code_last->HrefValue = "";

            // employee_1
            if (!EmptyValue($this->employee_1->CurrentValue)) {
                $this->employee_1->HrefValue = $this->employee_1->getLinkPrefix() . $this->employee_1->CurrentValue; // Add prefix/suffix
                $this->employee_1->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->employee_1->HrefValue = FullUrl($this->employee_1->HrefValue, "href");
                }
            } else {
                $this->employee_1->HrefValue = "";
            }

            // employee_2
            $this->employee_2->HrefValue = "";

            // employee_3
            $this->employee_3->HrefValue = "";

            // employee_id
            $this->employee_id->HrefValue = "";

            // qty
            $this->qty->HrefValue = "";

            // roll_no
            $this->roll_no->HrefValue = "";

            // size_w
            $this->size_w->HrefValue = "";

            // size_l
            $this->size_l->HrefValue = "";

            // size_h
            $this->size_h->HrefValue = "";

            // size_actual
            $this->size_actual->HrefValue = "";

            // weight_actual
            $this->weight_actual->HrefValue = "";

            // lines_in_30cm
            $this->lines_in_30cm->HrefValue = "";

            // d_01
            $this->d_01->HrefValue = "";

            // d_02
            $this->d_02->HrefValue = "";

            // d_03
            $this->d_03->HrefValue = "";

            // d_04
            $this->d_04->HrefValue = "";

            // d_05
            $this->d_05->HrefValue = "";

            // d_06
            $this->d_06->HrefValue = "";

            // d_07
            $this->d_07->HrefValue = "";

            // d_08
            $this->d_08->HrefValue = "";

            // d_09
            $this->d_09->HrefValue = "";

            // d_10
            $this->d_10->HrefValue = "";

            // valuation
            $this->valuation->HrefValue = "";

            // deduction
            $this->deduction->HrefValue = "";

            // remark
            $this->remark->HrefValue = "";

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->HrefValue = GetFileUploadUrl($this->upload, $this->upload->htmlDecode($this->upload->Upload->DbValue)); // Add prefix/suffix
                $this->upload->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
                }
            } else {
                $this->upload->HrefValue = "";
            }
            $this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->process->Visible && $this->process->Required) {
                if (!$this->process->IsDetailKey && EmptyValue($this->process->FormValue)) {
                    $this->process->addErrorMessage(str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->process->FormValue)) {
                $this->process->addErrorMessage($this->process->getErrorMessage(false));
            }
            if ($this->confirm_process->Visible && $this->confirm_process->Required) {
                if (!$this->confirm_process->IsDetailKey && EmptyValue($this->confirm_process->FormValue)) {
                    $this->confirm_process->addErrorMessage(str_replace("%s", $this->confirm_process->caption(), $this->confirm_process->RequiredErrorMessage));
                }
            }
            if ($this->process_other->Visible && $this->process_other->Required) {
                if ($this->process_other->FormValue == "") {
                    $this->process_other->addErrorMessage(str_replace("%s", $this->process_other->caption(), $this->process_other->RequiredErrorMessage));
                }
            }
            if ($this->location->Visible && $this->location->Required) {
                if (!$this->location->IsDetailKey && EmptyValue($this->location->FormValue)) {
                    $this->location->addErrorMessage(str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
                }
            }
            if ($this->godown->Visible && $this->godown->Required) {
                if (!$this->godown->IsDetailKey && EmptyValue($this->godown->FormValue)) {
                    $this->godown->addErrorMessage(str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
                }
            }
            if ($this->code->Visible && $this->code->Required) {
                if (!$this->code->IsDetailKey && EmptyValue($this->code->FormValue)) {
                    $this->code->addErrorMessage(str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
                }
            }
            if ($this->code_last->Visible && $this->code_last->Required) {
                if (!$this->code_last->IsDetailKey && EmptyValue($this->code_last->FormValue)) {
                    $this->code_last->addErrorMessage(str_replace("%s", $this->code_last->caption(), $this->code_last->RequiredErrorMessage));
                }
            }
            if ($this->employee_1->Visible && $this->employee_1->Required) {
                if (!$this->employee_1->IsDetailKey && EmptyValue($this->employee_1->FormValue)) {
                    $this->employee_1->addErrorMessage(str_replace("%s", $this->employee_1->caption(), $this->employee_1->RequiredErrorMessage));
                }
            }
            if ($this->employee_2->Visible && $this->employee_2->Required) {
                if (!$this->employee_2->IsDetailKey && EmptyValue($this->employee_2->FormValue)) {
                    $this->employee_2->addErrorMessage(str_replace("%s", $this->employee_2->caption(), $this->employee_2->RequiredErrorMessage));
                }
            }
            if ($this->employee_3->Visible && $this->employee_3->Required) {
                if (!$this->employee_3->IsDetailKey && EmptyValue($this->employee_3->FormValue)) {
                    $this->employee_3->addErrorMessage(str_replace("%s", $this->employee_3->caption(), $this->employee_3->RequiredErrorMessage));
                }
            }
            if ($this->employee_id->Visible && $this->employee_id->Required) {
                if ($this->employee_id->FormValue == "") {
                    $this->employee_id->addErrorMessage(str_replace("%s", $this->employee_id->caption(), $this->employee_id->RequiredErrorMessage));
                }
            }
            if ($this->qty->Visible && $this->qty->Required) {
                if (!$this->qty->IsDetailKey && EmptyValue($this->qty->FormValue)) {
                    $this->qty->addErrorMessage(str_replace("%s", $this->qty->caption(), $this->qty->RequiredErrorMessage));
                }
            }
            if ($this->roll_no->Visible && $this->roll_no->Required) {
                if (!$this->roll_no->IsDetailKey && EmptyValue($this->roll_no->FormValue)) {
                    $this->roll_no->addErrorMessage(str_replace("%s", $this->roll_no->caption(), $this->roll_no->RequiredErrorMessage));
                }
            }
            if ($this->size_w->Visible && $this->size_w->Required) {
                if (!$this->size_w->IsDetailKey && EmptyValue($this->size_w->FormValue)) {
                    $this->size_w->addErrorMessage(str_replace("%s", $this->size_w->caption(), $this->size_w->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->size_w->FormValue)) {
                $this->size_w->addErrorMessage($this->size_w->getErrorMessage(false));
            }
            if ($this->size_l->Visible && $this->size_l->Required) {
                if (!$this->size_l->IsDetailKey && EmptyValue($this->size_l->FormValue)) {
                    $this->size_l->addErrorMessage(str_replace("%s", $this->size_l->caption(), $this->size_l->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->size_l->FormValue)) {
                $this->size_l->addErrorMessage($this->size_l->getErrorMessage(false));
            }
            if ($this->size_h->Visible && $this->size_h->Required) {
                if (!$this->size_h->IsDetailKey && EmptyValue($this->size_h->FormValue)) {
                    $this->size_h->addErrorMessage(str_replace("%s", $this->size_h->caption(), $this->size_h->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->size_h->FormValue)) {
                $this->size_h->addErrorMessage($this->size_h->getErrorMessage(false));
            }
            if ($this->size_actual->Visible && $this->size_actual->Required) {
                if (!$this->size_actual->IsDetailKey && EmptyValue($this->size_actual->FormValue)) {
                    $this->size_actual->addErrorMessage(str_replace("%s", $this->size_actual->caption(), $this->size_actual->RequiredErrorMessage));
                }
            }
            if ($this->weight_actual->Visible && $this->weight_actual->Required) {
                if (!$this->weight_actual->IsDetailKey && EmptyValue($this->weight_actual->FormValue)) {
                    $this->weight_actual->addErrorMessage(str_replace("%s", $this->weight_actual->caption(), $this->weight_actual->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->weight_actual->FormValue)) {
                $this->weight_actual->addErrorMessage($this->weight_actual->getErrorMessage(false));
            }
            if ($this->lines_in_30cm->Visible && $this->lines_in_30cm->Required) {
                if (!$this->lines_in_30cm->IsDetailKey && EmptyValue($this->lines_in_30cm->FormValue)) {
                    $this->lines_in_30cm->addErrorMessage(str_replace("%s", $this->lines_in_30cm->caption(), $this->lines_in_30cm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->lines_in_30cm->FormValue)) {
                $this->lines_in_30cm->addErrorMessage($this->lines_in_30cm->getErrorMessage(false));
            }
            if ($this->d_01->Visible && $this->d_01->Required) {
                if (!$this->d_01->IsDetailKey && EmptyValue($this->d_01->FormValue)) {
                    $this->d_01->addErrorMessage(str_replace("%s", $this->d_01->caption(), $this->d_01->RequiredErrorMessage));
                }
            }
            if ($this->d_02->Visible && $this->d_02->Required) {
                if (!$this->d_02->IsDetailKey && EmptyValue($this->d_02->FormValue)) {
                    $this->d_02->addErrorMessage(str_replace("%s", $this->d_02->caption(), $this->d_02->RequiredErrorMessage));
                }
            }
            if ($this->d_03->Visible && $this->d_03->Required) {
                if (!$this->d_03->IsDetailKey && EmptyValue($this->d_03->FormValue)) {
                    $this->d_03->addErrorMessage(str_replace("%s", $this->d_03->caption(), $this->d_03->RequiredErrorMessage));
                }
            }
            if ($this->d_04->Visible && $this->d_04->Required) {
                if (!$this->d_04->IsDetailKey && EmptyValue($this->d_04->FormValue)) {
                    $this->d_04->addErrorMessage(str_replace("%s", $this->d_04->caption(), $this->d_04->RequiredErrorMessage));
                }
            }
            if ($this->d_05->Visible && $this->d_05->Required) {
                if (!$this->d_05->IsDetailKey && EmptyValue($this->d_05->FormValue)) {
                    $this->d_05->addErrorMessage(str_replace("%s", $this->d_05->caption(), $this->d_05->RequiredErrorMessage));
                }
            }
            if ($this->d_06->Visible && $this->d_06->Required) {
                if (!$this->d_06->IsDetailKey && EmptyValue($this->d_06->FormValue)) {
                    $this->d_06->addErrorMessage(str_replace("%s", $this->d_06->caption(), $this->d_06->RequiredErrorMessage));
                }
            }
            if ($this->d_07->Visible && $this->d_07->Required) {
                if (!$this->d_07->IsDetailKey && EmptyValue($this->d_07->FormValue)) {
                    $this->d_07->addErrorMessage(str_replace("%s", $this->d_07->caption(), $this->d_07->RequiredErrorMessage));
                }
            }
            if ($this->d_08->Visible && $this->d_08->Required) {
                if (!$this->d_08->IsDetailKey && EmptyValue($this->d_08->FormValue)) {
                    $this->d_08->addErrorMessage(str_replace("%s", $this->d_08->caption(), $this->d_08->RequiredErrorMessage));
                }
            }
            if ($this->d_09->Visible && $this->d_09->Required) {
                if (!$this->d_09->IsDetailKey && EmptyValue($this->d_09->FormValue)) {
                    $this->d_09->addErrorMessage(str_replace("%s", $this->d_09->caption(), $this->d_09->RequiredErrorMessage));
                }
            }
            if ($this->d_10->Visible && $this->d_10->Required) {
                if (!$this->d_10->IsDetailKey && EmptyValue($this->d_10->FormValue)) {
                    $this->d_10->addErrorMessage(str_replace("%s", $this->d_10->caption(), $this->d_10->RequiredErrorMessage));
                }
            }
            if ($this->valuation->Visible && $this->valuation->Required) {
                if (!$this->valuation->IsDetailKey && EmptyValue($this->valuation->FormValue)) {
                    $this->valuation->addErrorMessage(str_replace("%s", $this->valuation->caption(), $this->valuation->RequiredErrorMessage));
                }
            }
            if ($this->deduction->Visible && $this->deduction->Required) {
                if (!$this->deduction->IsDetailKey && EmptyValue($this->deduction->FormValue)) {
                    $this->deduction->addErrorMessage(str_replace("%s", $this->deduction->caption(), $this->deduction->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->deduction->FormValue)) {
                $this->deduction->addErrorMessage($this->deduction->getErrorMessage(false));
            }
            if ($this->remark->Visible && $this->remark->Required) {
                if (!$this->remark->IsDetailKey && EmptyValue($this->remark->FormValue)) {
                    $this->remark->addErrorMessage(str_replace("%s", $this->remark->caption(), $this->remark->RequiredErrorMessage));
                }
            }
            if ($this->upload->Visible && $this->upload->Required) {
                if ($this->upload->Upload->FileName == "" && !$this->upload->Upload->KeepFile) {
                    $this->upload->addErrorMessage(str_replace("%s", $this->upload->caption(), $this->upload->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();
        if ($this->upload->Visible && !$this->upload->Upload->KeepFile) {
            $this->upload->UploadPath = $this->upload->getUploadPath();
            if (!EmptyValue($this->upload->Upload->FileName)) {
                $this->upload->Upload->DbValue = null;
                FixUploadFileNames($this->upload);
                $this->upload->setDbValueDef($rsnew, $this->upload->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
        $this->upload->UploadPath = $this->upload->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->upload->Visible && !$this->upload->Upload->KeepFile) {
                    $this->upload->Upload->DbValue = null;
                    if (!SaveUploadFiles($this->upload, $rsnew['upload'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // process
        $this->process->setDbValueDef($rsnew, $this->process->CurrentValue, false);

        // confirm_process
        $this->confirm_process->setDbValueDef($rsnew, $this->confirm_process->CurrentValue, false);

        // process_other
        $this->process_other->setDbValueDef($rsnew, $this->process_other->CurrentValue, false);

        // location
        $this->location->setDbValueDef($rsnew, $this->location->CurrentValue, false);

        // godown
        $this->godown->setDbValueDef($rsnew, $this->godown->CurrentValue, false);

        // code
        $this->code->setDbValueDef($rsnew, $this->code->CurrentValue, false);

        // code_last
        $this->code_last->setDbValueDef($rsnew, $this->code_last->CurrentValue, false);

        // employee_1
        $this->employee_1->setDbValueDef($rsnew, $this->employee_1->CurrentValue, false);

        // employee_2
        $this->employee_2->setDbValueDef($rsnew, $this->employee_2->CurrentValue, false);

        // employee_3
        $this->employee_3->setDbValueDef($rsnew, $this->employee_3->CurrentValue, false);

        // employee_id
        $this->employee_id->setDbValueDef($rsnew, $this->employee_id->CurrentValue, false);

        // qty
        $this->qty->setDbValueDef($rsnew, $this->qty->CurrentValue, false);

        // roll_no
        $this->roll_no->setDbValueDef($rsnew, $this->roll_no->CurrentValue, false);

        // size_w
        $this->size_w->setDbValueDef($rsnew, $this->size_w->CurrentValue, false);

        // size_l
        $this->size_l->setDbValueDef($rsnew, $this->size_l->CurrentValue, false);

        // size_h
        $this->size_h->setDbValueDef($rsnew, $this->size_h->CurrentValue, false);

        // size_actual
        $this->size_actual->setDbValueDef($rsnew, $this->size_actual->CurrentValue, false);

        // weight_actual
        $this->weight_actual->setDbValueDef($rsnew, $this->weight_actual->CurrentValue, false);

        // lines_in_30cm
        $this->lines_in_30cm->setDbValueDef($rsnew, $this->lines_in_30cm->CurrentValue, false);

        // d_01
        $this->d_01->setDbValueDef($rsnew, $this->d_01->CurrentValue, false);

        // d_02
        $this->d_02->setDbValueDef($rsnew, $this->d_02->CurrentValue, false);

        // d_03
        $this->d_03->setDbValueDef($rsnew, $this->d_03->CurrentValue, false);

        // d_04
        $this->d_04->setDbValueDef($rsnew, $this->d_04->CurrentValue, false);

        // d_05
        $this->d_05->setDbValueDef($rsnew, $this->d_05->CurrentValue, false);

        // d_06
        $this->d_06->setDbValueDef($rsnew, $this->d_06->CurrentValue, false);

        // d_07
        $this->d_07->setDbValueDef($rsnew, $this->d_07->CurrentValue, false);

        // d_08
        $this->d_08->setDbValueDef($rsnew, $this->d_08->CurrentValue, false);

        // d_09
        $this->d_09->setDbValueDef($rsnew, $this->d_09->CurrentValue, false);

        // d_10
        $this->d_10->setDbValueDef($rsnew, $this->d_10->CurrentValue, false);

        // valuation
        $this->valuation->setDbValueDef($rsnew, $this->valuation->CurrentValue, false);

        // deduction
        $this->deduction->setDbValueDef($rsnew, $this->deduction->CurrentValue, strval($this->deduction->CurrentValue) == "");

        // remark
        $this->remark->setDbValueDef($rsnew, $this->remark->CurrentValue, false);

        // upload
        if ($this->upload->Visible && !$this->upload->Upload->KeepFile) {
            if ($this->upload->Upload->FileName == "") {
                $rsnew['upload'] = null;
            } else {
                FixUploadTempFileNames($this->upload);
                $rsnew['upload'] = $this->upload->Upload->FileName;
            }
            $this->upload->ImageWidth = 640; // Resize width
            $this->upload->ImageHeight = 640; // Resize height
        }

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['process'])) { // process
            $this->process->setFormValue($row['process']);
        }
        if (isset($row['confirm_process'])) { // confirm_process
            $this->confirm_process->setFormValue($row['confirm_process']);
        }
        if (isset($row['process_other'])) { // process_other
            $this->process_other->setFormValue($row['process_other']);
        }
        if (isset($row['location'])) { // location
            $this->location->setFormValue($row['location']);
        }
        if (isset($row['godown'])) { // godown
            $this->godown->setFormValue($row['godown']);
        }
        if (isset($row['code'])) { // code
            $this->code->setFormValue($row['code']);
        }
        if (isset($row['code_last'])) { // code_last
            $this->code_last->setFormValue($row['code_last']);
        }
        if (isset($row['employee_1'])) { // employee_1
            $this->employee_1->setFormValue($row['employee_1']);
        }
        if (isset($row['employee_2'])) { // employee_2
            $this->employee_2->setFormValue($row['employee_2']);
        }
        if (isset($row['employee_3'])) { // employee_3
            $this->employee_3->setFormValue($row['employee_3']);
        }
        if (isset($row['employee_id'])) { // employee_id
            $this->employee_id->setFormValue($row['employee_id']);
        }
        if (isset($row['qty'])) { // qty
            $this->qty->setFormValue($row['qty']);
        }
        if (isset($row['roll_no'])) { // roll_no
            $this->roll_no->setFormValue($row['roll_no']);
        }
        if (isset($row['size_w'])) { // size_w
            $this->size_w->setFormValue($row['size_w']);
        }
        if (isset($row['size_l'])) { // size_l
            $this->size_l->setFormValue($row['size_l']);
        }
        if (isset($row['size_h'])) { // size_h
            $this->size_h->setFormValue($row['size_h']);
        }
        if (isset($row['size_actual'])) { // size_actual
            $this->size_actual->setFormValue($row['size_actual']);
        }
        if (isset($row['weight_actual'])) { // weight_actual
            $this->weight_actual->setFormValue($row['weight_actual']);
        }
        if (isset($row['lines_in_30cm'])) { // lines_in_30cm
            $this->lines_in_30cm->setFormValue($row['lines_in_30cm']);
        }
        if (isset($row['d_01'])) { // d_01
            $this->d_01->setFormValue($row['d_01']);
        }
        if (isset($row['d_02'])) { // d_02
            $this->d_02->setFormValue($row['d_02']);
        }
        if (isset($row['d_03'])) { // d_03
            $this->d_03->setFormValue($row['d_03']);
        }
        if (isset($row['d_04'])) { // d_04
            $this->d_04->setFormValue($row['d_04']);
        }
        if (isset($row['d_05'])) { // d_05
            $this->d_05->setFormValue($row['d_05']);
        }
        if (isset($row['d_06'])) { // d_06
            $this->d_06->setFormValue($row['d_06']);
        }
        if (isset($row['d_07'])) { // d_07
            $this->d_07->setFormValue($row['d_07']);
        }
        if (isset($row['d_08'])) { // d_08
            $this->d_08->setFormValue($row['d_08']);
        }
        if (isset($row['d_09'])) { // d_09
            $this->d_09->setFormValue($row['d_09']);
        }
        if (isset($row['d_10'])) { // d_10
            $this->d_10->setFormValue($row['d_10']);
        }
        if (isset($row['valuation'])) { // valuation
            $this->valuation->setFormValue($row['valuation']);
        }
        if (isset($row['deduction'])) { // deduction
            $this->deduction->setFormValue($row['deduction']);
        }
        if (isset($row['remark'])) { // remark
            $this->remark->setFormValue($row['remark']);
        }
        if (isset($row['upload'])) { // upload
            $this->upload->setFormValue($row['upload']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("processactionlist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_confirm_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process_other":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_godown":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_employee_1":
                    break;
                case "x_employee_2":
                    break;
                case "x_employee_3":
                    break;
                case "x_employee_id":
                    break;
                case "x_valuation":
                    break;
                case "x_payment":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad() {
    	//echo "Page Load";
        (isset($_COOKIE["Location"])) ? "" : $_COOKIE["Location"] = User_Site(); 
    	(isset($_COOKIE["prid"])) ? $prid = $_COOKIE["prid"] : $prid = 0; 
    	if ($prid > 0)
    	{
    		$this->process->ReadOnly = True;
    		$this->confirm_process->ReadOnly = True;
    	}
    		else
    	{
    		$_SESSION[SESSION_SUCCESS_MESSAGE] = 'Please Click on Prcess from DashBoard to Add';
    		header('Location: processactionlist');
    		exit;
    	}
    }

    // Page Unload event
    public function pageUnload() {
    	//echo "Page Unload";
    setcookie("Code_s", '');
    setcookie("Code_e", '');
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'process_action');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError) 
    	{
    	// Return error message in CustomError
    	extract($_POST,EXTR_OVERWRITE);
    	$_SESSION[SESSION_WARNING_MESSAGE] = '';
    if ($x_code != $x_code_last)
    	$_SESSION[SESSION_WARNING_MESSAGE].= 'Code and Code End are Different<br>';
    if ($x_process != $x_confirm_process)
    	$_SESSION[SESSION_WARNING_MESSAGE].= 'Process and Confirm Process are Different<br>';
    if (($x_process == null) || ($x_process == ''))
    	$_SESSION[SESSION_WARNING_MESSAGE].= 'Process Not Selected<br>';
    	$emp = ExecuteScalar("SELECT `m_employee` FROM `sub_process_type` where `sub_process_type`.`id` = $x_process");
    	if  ($emp == '0' && ($x_employee_1 == null))
    	{
    	$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Employee ID<br>";
    	}
    	if  ($emp == '1' && ($x_employee_1 == null) || ($x_employee_2 == null) || ($x_employee_3 == null))
    	{
    	$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select All Employee IDs or No Employee<br>";
    	}
    	if  ($emp == '2' && ($x_employee_id == null))
    	{
    	$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Multiple Employee IDs<br>";
    	}
        if  ( ($x_process == '19') && ($x_qty == null))
    	{
    	$_SESSION[SESSION_WARNING_MESSAGE].= "Please Enter Quantity. (NULL not permitted)<br>";
    	}
        if  ( ($x_process == '19') && ($x_qty == null))
    	{
    	$_SESSION[SESSION_WARNING_MESSAGE].= "Please Enter Quantity. (NULL not permitted)<br>";
    	}
        if  ( ($x_location == '1') && ($x_godown == null))
    	{
    	$_SESSION[SESSION_WARNING_MESSAGE].= "Please Enter Location (IN). (NULL not permitted)<br>";
    	}
    if ($_SESSION[SESSION_WARNING_MESSAGE] == '')
    	{return TRUE;}
    	else
    	{return false;}
    }	
}
