<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PpVerifyCompiledSearch extends PpVerifyCompiled
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PpVerifyCompiledSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "ppverifycompiledsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->pid->setVisibility();
        $this->location->setVisibility();
        $this->product_type->setVisibility();
        $this->shape->setVisibility();
        $this->plan_type->setVisibility();
        $this->gcode->setVisibility();
        $this->design_id->setVisibility();
        $this->process->setVisibility();
        $this->yes_no->setVisibility();
        $this->fix->setVisibility();
        $this->unit->setVisibility();
        $this->_unit->setVisibility();
        $this->_40->setVisibility();
        $this->extra_plan->setVisibility();
        $this->custom_size->setVisibility();
        $this->custom_size_below_st->setVisibility();
        $this->method->setVisibility();
        $this->category->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'pp_verify_compiled';
        $this->TableName = 'pp_verify_compiled';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (pp_verify_compiled)
        if (!isset($GLOBALS["pp_verify_compiled"]) || $GLOBALS["pp_verify_compiled"]::class == PROJECT_NAMESPACE . "pp_verify_compiled") {
            $GLOBALS["pp_verify_compiled"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'pp_verify_compiled');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "ppverifycompiledview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAddOrEdit()) {
            $this->pid->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->location->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->product_type->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->shape->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->plan_type->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->gcode->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->design_id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->process->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->yes_no->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->fix->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->unit->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->_unit->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->_40->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->extra_plan->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->custom_size->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->custom_size_below_st->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->method->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->category->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->plan_type);
        $this->setupLookupOptions($this->design_id);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->yes_no);
        $this->setupLookupOptions($this->fix);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->extra_plan);
        $this->setupLookupOptions($this->method);
        $this->setupLookupOptions($this->category);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "ppverifycompiledlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->pid); // pid
        $this->buildSearchUrl($srchUrl, $this->location); // location
        $this->buildSearchUrl($srchUrl, $this->product_type); // product_type
        $this->buildSearchUrl($srchUrl, $this->shape); // shape
        $this->buildSearchUrl($srchUrl, $this->plan_type); // plan_type
        $this->buildSearchUrl($srchUrl, $this->gcode); // gcode
        $this->buildSearchUrl($srchUrl, $this->design_id); // design_id
        $this->buildSearchUrl($srchUrl, $this->process); // process
        $this->buildSearchUrl($srchUrl, $this->yes_no); // yes_no
        $this->buildSearchUrl($srchUrl, $this->fix); // fix
        $this->buildSearchUrl($srchUrl, $this->unit); // unit
        $this->buildSearchUrl($srchUrl, $this->_unit); // @unit
        $this->buildSearchUrl($srchUrl, $this->_40); // @
        $this->buildSearchUrl($srchUrl, $this->extra_plan); // extra_plan
        $this->buildSearchUrl($srchUrl, $this->custom_size); // custom_size
        $this->buildSearchUrl($srchUrl, $this->custom_size_below_st); // custom_size_below_st
        $this->buildSearchUrl($srchUrl, $this->method); // method
        $this->buildSearchUrl($srchUrl, $this->category); // category
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pid
        if ($this->pid->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // location
        if ($this->location->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->location->AdvancedSearch->SearchValue)) {
            $this->location->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->location->AdvancedSearch->SearchValue);
        }
        if (is_array($this->location->AdvancedSearch->SearchValue2)) {
            $this->location->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->location->AdvancedSearch->SearchValue2);
        }

        // product_type
        if ($this->product_type->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->product_type->AdvancedSearch->SearchValue)) {
            $this->product_type->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->product_type->AdvancedSearch->SearchValue);
        }
        if (is_array($this->product_type->AdvancedSearch->SearchValue2)) {
            $this->product_type->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->product_type->AdvancedSearch->SearchValue2);
        }

        // shape
        if ($this->shape->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->shape->AdvancedSearch->SearchValue)) {
            $this->shape->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->shape->AdvancedSearch->SearchValue);
        }
        if (is_array($this->shape->AdvancedSearch->SearchValue2)) {
            $this->shape->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->shape->AdvancedSearch->SearchValue2);
        }

        // plan_type
        if ($this->plan_type->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->plan_type->AdvancedSearch->SearchValue)) {
            $this->plan_type->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->plan_type->AdvancedSearch->SearchValue);
        }
        if (is_array($this->plan_type->AdvancedSearch->SearchValue2)) {
            $this->plan_type->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->plan_type->AdvancedSearch->SearchValue2);
        }

        // gcode
        if ($this->gcode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // design_id
        if ($this->design_id->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->design_id->AdvancedSearch->SearchValue)) {
            $this->design_id->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->design_id->AdvancedSearch->SearchValue);
        }
        if (is_array($this->design_id->AdvancedSearch->SearchValue2)) {
            $this->design_id->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->design_id->AdvancedSearch->SearchValue2);
        }

        // process
        if ($this->process->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // yes_no
        if ($this->yes_no->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->yes_no->AdvancedSearch->SearchValue)) {
            $this->yes_no->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->yes_no->AdvancedSearch->SearchValue);
        }
        if (is_array($this->yes_no->AdvancedSearch->SearchValue2)) {
            $this->yes_no->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->yes_no->AdvancedSearch->SearchValue2);
        }

        // fix
        if ($this->fix->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->fix->AdvancedSearch->SearchValue)) {
            $this->fix->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->fix->AdvancedSearch->SearchValue);
        }
        if (is_array($this->fix->AdvancedSearch->SearchValue2)) {
            $this->fix->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->fix->AdvancedSearch->SearchValue2);
        }

        // unit
        if ($this->unit->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->unit->AdvancedSearch->SearchValue)) {
            $this->unit->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->unit->AdvancedSearch->SearchValue);
        }
        if (is_array($this->unit->AdvancedSearch->SearchValue2)) {
            $this->unit->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->unit->AdvancedSearch->SearchValue2);
        }

        // @unit
        if ($this->_unit->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // @
        if ($this->_40->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // extra_plan
        if ($this->extra_plan->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->extra_plan->AdvancedSearch->SearchValue)) {
            $this->extra_plan->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->extra_plan->AdvancedSearch->SearchValue);
        }
        if (is_array($this->extra_plan->AdvancedSearch->SearchValue2)) {
            $this->extra_plan->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->extra_plan->AdvancedSearch->SearchValue2);
        }

        // custom_size
        if ($this->custom_size->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // custom_size_below_st
        if ($this->custom_size_below_st->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // method
        if ($this->method->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->method->AdvancedSearch->SearchValue)) {
            $this->method->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->method->AdvancedSearch->SearchValue);
        }
        if (is_array($this->method->AdvancedSearch->SearchValue2)) {
            $this->method->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->method->AdvancedSearch->SearchValue2);
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->category->AdvancedSearch->SearchValue)) {
            $this->category->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->category->AdvancedSearch->SearchValue);
        }
        if (is_array($this->category->AdvancedSearch->SearchValue2)) {
            $this->category->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->category->AdvancedSearch->SearchValue2);
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // pid
        $this->pid->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // plan_type
        $this->plan_type->RowCssClass = "row";

        // gcode
        $this->gcode->RowCssClass = "row";

        // design_id
        $this->design_id->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // yes_no
        $this->yes_no->RowCssClass = "row";

        // fix
        $this->fix->RowCssClass = "row";

        // unit
        $this->unit->RowCssClass = "row";

        // @unit
        $this->_unit->RowCssClass = "row";

        // @
        $this->_40->RowCssClass = "row";

        // extra_plan
        $this->extra_plan->RowCssClass = "row";

        // custom_size
        $this->custom_size->RowCssClass = "row";

        // custom_size_below_st
        $this->custom_size_below_st->RowCssClass = "row";

        // method
        $this->method->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // pid
            $this->pid->ViewValue = $this->pid->CurrentValue;

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->location->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->location->Lookup->renderViewRow($row);
                            $this->location->ViewValue->add($this->location->displayValue($arwrk));
                        }
                    } else {
                        $this->location->ViewValue = $this->location->CurrentValue;
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->product_type->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->product_type->Lookup->renderViewRow($row);
                            $this->product_type->ViewValue->add($this->product_type->displayValue($arwrk));
                        }
                    } else {
                        $this->product_type->ViewValue = $this->product_type->CurrentValue;
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->shape->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->shape->Lookup->renderViewRow($row);
                            $this->shape->ViewValue->add($this->shape->displayValue($arwrk));
                        }
                    } else {
                        $this->shape->ViewValue = $this->shape->CurrentValue;
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // plan_type
            if (strval($this->plan_type->CurrentValue) != "") {
                $this->plan_type->ViewValue = new OptionValues();
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), strval($this->plan_type->CurrentValue));
                $cnt = count($arwrk);
                for ($ari = 0; $ari < $cnt; $ari++)
                    $this->plan_type->ViewValue->add($this->plan_type->optionCaption(trim($arwrk[$ari])));
            } else {
                $this->plan_type->ViewValue = null;
            }

            // gcode
            $this->gcode->ViewValue = $this->gcode->CurrentValue;

            // design_id
            if ($this->design_id->VirtualValue != "") {
                $this->design_id->ViewValue = $this->design_id->VirtualValue;
            } else {
                $curVal = strval($this->design_id->CurrentValue);
                if ($curVal != "") {
                    $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
                    if ($this->design_id->ViewValue === null) { // Lookup from database
                        $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                        $filterWrk = "";
                        foreach ($arwrk as $wrk) {
                            AddFilter($filterWrk, SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                        }
                        $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $this->design_id->ViewValue = new OptionValues();
                            foreach ($rswrk as $row) {
                                $arwrk = $this->design_id->Lookup->renderViewRow($row);
                                $this->design_id->ViewValue->add($this->design_id->displayValue($arwrk));
                            }
                        } else {
                            $this->design_id->ViewValue = $this->design_id->CurrentValue;
                        }
                    }
                } else {
                    $this->design_id->ViewValue = null;
                }
            }

            // process
            $this->process->ViewValue = $this->process->CurrentValue;
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // yes_no
            if (strval($this->yes_no->CurrentValue) != "") {
                $this->yes_no->ViewValue = new OptionValues();
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), strval($this->yes_no->CurrentValue));
                $cnt = count($arwrk);
                for ($ari = 0; $ari < $cnt; $ari++)
                    $this->yes_no->ViewValue->add($this->yes_no->optionCaption(trim($arwrk[$ari])));
            } else {
                $this->yes_no->ViewValue = null;
            }

            // fix
            if (strval($this->fix->CurrentValue) != "") {
                $this->fix->ViewValue = new OptionValues();
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), strval($this->fix->CurrentValue));
                $cnt = count($arwrk);
                for ($ari = 0; $ari < $cnt; $ari++)
                    $this->fix->ViewValue->add($this->fix->optionCaption(trim($arwrk[$ari])));
            } else {
                $this->fix->ViewValue = null;
            }

            // unit
            if (strval($this->unit->CurrentValue) != "") {
                $this->unit->ViewValue = new OptionValues();
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), strval($this->unit->CurrentValue));
                $cnt = count($arwrk);
                for ($ari = 0; $ari < $cnt; $ari++)
                    $this->unit->ViewValue->add($this->unit->optionCaption(trim($arwrk[$ari])));
            } else {
                $this->unit->ViewValue = null;
            }

            // @unit
            $this->_unit->ViewValue = $this->_unit->CurrentValue;

            // @
            $this->_40->ViewValue = $this->_40->CurrentValue;

            // extra_plan
            if (strval($this->extra_plan->CurrentValue) != "") {
                $this->extra_plan->ViewValue = new OptionValues();
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), strval($this->extra_plan->CurrentValue));
                $cnt = count($arwrk);
                for ($ari = 0; $ari < $cnt; $ari++)
                    $this->extra_plan->ViewValue->add($this->extra_plan->optionCaption(trim($arwrk[$ari])));
            } else {
                $this->extra_plan->ViewValue = null;
            }

            // custom_size
            $this->custom_size->ViewValue = $this->custom_size->CurrentValue;

            // custom_size_below_st
            $this->custom_size_below_st->ViewValue = $this->custom_size_below_st->CurrentValue;

            // method
            $curVal = strval($this->method->CurrentValue);
            if ($curVal != "") {
                $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
                if ($this->method->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->method->getSelectFilter($this); // PHP
                    $sqlWrk = $this->method->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->method->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->method->Lookup->renderViewRow($row);
                            $this->method->ViewValue->add($this->method->displayValue($arwrk));
                        }
                    } else {
                        $this->method->ViewValue = $this->method->CurrentValue;
                    }
                }
            } else {
                $this->method->ViewValue = null;
            }

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->category->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->category->Lookup->renderViewRow($row);
                            $this->category->ViewValue->add($this->category->displayValue($arwrk));
                        }
                    } else {
                        $this->category->ViewValue = $this->category->CurrentValue;
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // pid
            if (!EmptyValue($this->pid->CurrentValue)) {
                $this->pid->HrefValue = $this->pid->getLinkPrefix() . $this->pid->CurrentValue; // Add prefix/suffix
                $this->pid->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->pid->HrefValue = FullUrl($this->pid->HrefValue, "href");
                }
            } else {
                $this->pid->HrefValue = "";
            }
            $this->pid->TooltipValue = "";

            // location
            if (!EmptyValue($this->location->CurrentValue)) {
                $this->location->HrefValue = $this->location->getLinkPrefix() . $this->location->CurrentValue; // Add prefix/suffix
                $this->location->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->location->HrefValue = FullUrl($this->location->HrefValue, "href");
                }
            } else {
                $this->location->HrefValue = "";
            }
            $this->location->TooltipValue = "";

            // product_type
            $this->product_type->HrefValue = "";
            $this->product_type->TooltipValue = "";

            // shape
            $this->shape->HrefValue = "";
            $this->shape->TooltipValue = "";

            // plan_type
            if (!EmptyValue($this->plan_type->CurrentValue)) {
                $this->plan_type->HrefValue = $this->plan_type->getLinkPrefix() . $this->plan_type->CurrentValue; // Add prefix/suffix
                $this->plan_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->plan_type->HrefValue = FullUrl($this->plan_type->HrefValue, "href");
                }
            } else {
                $this->plan_type->HrefValue = "";
            }
            $this->plan_type->TooltipValue = "";

            // gcode
            if (!EmptyValue($this->gcode->CurrentValue)) {
                $this->gcode->HrefValue = $this->gcode->getLinkPrefix() . $this->gcode->CurrentValue; // Add prefix/suffix
                $this->gcode->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->gcode->HrefValue = FullUrl($this->gcode->HrefValue, "href");
                }
            } else {
                $this->gcode->HrefValue = "";
            }
            $this->gcode->TooltipValue = "";

            // design_id
            $this->design_id->HrefValue = "";
            $this->design_id->TooltipValue = "";

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }
            $this->process->TooltipValue = "";

            // yes_no
            $this->yes_no->HrefValue = "";
            $this->yes_no->TooltipValue = "";

            // fix
            $this->fix->HrefValue = "";
            $this->fix->TooltipValue = "";

            // unit
            $this->unit->HrefValue = "";
            $this->unit->TooltipValue = "";

            // @unit
            $this->_unit->HrefValue = "";
            $this->_unit->TooltipValue = "";

            // @
            $this->_40->HrefValue = "";
            $this->_40->TooltipValue = "";

            // extra_plan
            $this->extra_plan->HrefValue = "";
            $this->extra_plan->TooltipValue = "";

            // custom_size
            $this->custom_size->HrefValue = "";
            $this->custom_size->TooltipValue = "";

            // custom_size_below_st
            $this->custom_size_below_st->HrefValue = "";
            $this->custom_size_below_st->TooltipValue = "";

            // method
            $this->method->HrefValue = "";
            $this->method->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // pid
            $this->pid->setupEditAttributes();
            if (!$this->pid->Raw) {
                $this->pid->AdvancedSearch->SearchValue = HtmlDecode($this->pid->AdvancedSearch->SearchValue);
            }
            $this->pid->EditValue = HtmlEncode($this->pid->AdvancedSearch->SearchValue);
            $this->pid->PlaceHolder = RemoveHtml($this->pid->caption());

            // location
            $this->location->setupEditAttributes();
            $curVal = trim(strval($this->location->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->location->AdvancedSearch->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->AdvancedSearch->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // product_type
            $this->product_type->setupEditAttributes();
            $curVal = trim(strval($this->product_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->product_type->AdvancedSearch->ViewValue = $this->product_type->lookupCacheOption($curVal);
            } else {
                $this->product_type->AdvancedSearch->ViewValue = $this->product_type->Lookup !== null && is_array($this->product_type->lookupOptions()) && count($this->product_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->product_type->EditValue = array_values($this->product_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product_type->EditValue = $arwrk;
            }
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());
            $this->product_type->setupEditAttributes();
            $curVal = trim(strval($this->product_type->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->product_type->AdvancedSearch->ViewValue2 = $this->product_type->lookupCacheOption($curVal);
            } else {
                $this->product_type->AdvancedSearch->ViewValue2 = $this->product_type->Lookup !== null && is_array($this->product_type->lookupOptions()) && count($this->product_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_type->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->product_type->EditValue2 = array_values($this->product_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product_type->EditValue2 = $arwrk;
            }
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

            // shape
            $this->shape->setupEditAttributes();
            $curVal = trim(strval($this->shape->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->shape->AdvancedSearch->ViewValue = $this->shape->lookupCacheOption($curVal);
            } else {
                $this->shape->AdvancedSearch->ViewValue = $this->shape->Lookup !== null && is_array($this->shape->lookupOptions()) && count($this->shape->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->shape->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->shape->EditValue = array_values($this->shape->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                $sqlWrk = $this->shape->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->shape->EditValue = $arwrk;
            }
            $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

            // plan_type
            $this->plan_type->setupEditAttributes();
            $this->plan_type->EditValue = $this->plan_type->options(false);
            $this->plan_type->PlaceHolder = RemoveHtml($this->plan_type->caption());

            // gcode
            $this->gcode->setupEditAttributes();
            if (!$this->gcode->Raw) {
                $this->gcode->AdvancedSearch->SearchValue = HtmlDecode($this->gcode->AdvancedSearch->SearchValue);
            }
            $this->gcode->EditValue = HtmlEncode($this->gcode->AdvancedSearch->SearchValue);
            $this->gcode->PlaceHolder = RemoveHtml($this->gcode->caption());

            // design_id
            $this->design_id->setupEditAttributes();
            if (!$this->design_id->Raw) {
                $this->design_id->AdvancedSearch->SearchValue = HtmlDecode($this->design_id->AdvancedSearch->SearchValue);
            }
            $this->design_id->EditValue = HtmlEncode($this->design_id->AdvancedSearch->SearchValue);
            $this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

            // process
            $this->process->setupEditAttributes();
            if (!$this->process->Raw) {
                $this->process->AdvancedSearch->SearchValue = HtmlDecode($this->process->AdvancedSearch->SearchValue);
            }
            $this->process->EditValue = HtmlEncode($this->process->AdvancedSearch->SearchValue);
            $curVal = strval($this->process->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->process->EditValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->EditValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->EditValue = HtmlEncode($this->process->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->process->EditValue = null;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // yes_no
            $this->yes_no->setupEditAttributes();
            $this->yes_no->EditValue = $this->yes_no->options(false);
            $this->yes_no->PlaceHolder = RemoveHtml($this->yes_no->caption());

            // fix
            $this->fix->setupEditAttributes();
            $this->fix->EditValue = $this->fix->options(false);
            $this->fix->PlaceHolder = RemoveHtml($this->fix->caption());

            // unit
            $this->unit->setupEditAttributes();
            $this->unit->EditValue = $this->unit->options(false);
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

            // @unit
            $this->_unit->setupEditAttributes();
            if (!$this->_unit->Raw) {
                $this->_unit->AdvancedSearch->SearchValue = HtmlDecode($this->_unit->AdvancedSearch->SearchValue);
            }
            $this->_unit->EditValue = HtmlEncode($this->_unit->AdvancedSearch->SearchValue);
            $this->_unit->PlaceHolder = RemoveHtml($this->_unit->caption());

            // @
            $this->_40->setupEditAttributes();
            if (!$this->_40->Raw) {
                $this->_40->AdvancedSearch->SearchValue = HtmlDecode($this->_40->AdvancedSearch->SearchValue);
            }
            $this->_40->EditValue = HtmlEncode($this->_40->AdvancedSearch->SearchValue);
            $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

            // extra_plan
            $this->extra_plan->setupEditAttributes();
            $this->extra_plan->EditValue = $this->extra_plan->options(false);
            $this->extra_plan->PlaceHolder = RemoveHtml($this->extra_plan->caption());

            // custom_size
            $this->custom_size->setupEditAttributes();
            if (!$this->custom_size->Raw) {
                $this->custom_size->AdvancedSearch->SearchValue = HtmlDecode($this->custom_size->AdvancedSearch->SearchValue);
            }
            $this->custom_size->EditValue = HtmlEncode($this->custom_size->AdvancedSearch->SearchValue);
            $this->custom_size->PlaceHolder = RemoveHtml($this->custom_size->caption());

            // custom_size_below_st
            $this->custom_size_below_st->setupEditAttributes();
            if (!$this->custom_size_below_st->Raw) {
                $this->custom_size_below_st->AdvancedSearch->SearchValue = HtmlDecode($this->custom_size_below_st->AdvancedSearch->SearchValue);
            }
            $this->custom_size_below_st->EditValue = HtmlEncode($this->custom_size_below_st->AdvancedSearch->SearchValue);
            $this->custom_size_below_st->PlaceHolder = RemoveHtml($this->custom_size_below_st->caption());

            // method
            $this->method->setupEditAttributes();
            $curVal = trim(strval($this->method->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->method->AdvancedSearch->ViewValue = $this->method->lookupCacheOption($curVal);
            } else {
                $this->method->AdvancedSearch->ViewValue = $this->method->Lookup !== null && is_array($this->method->lookupOptions()) && count($this->method->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->method->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->method->EditValue = array_values($this->method->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->method->getSelectFilter($this); // PHP
                $sqlWrk = $this->method->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->method->EditValue = $arwrk;
            }
            $this->method->PlaceHolder = RemoveHtml($this->method->caption());

            // category
            $this->category->setupEditAttributes();
            $curVal = trim(strval($this->category->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->category->AdvancedSearch->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->AdvancedSearch->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->pid->AdvancedSearch->SearchValue)) {
            $this->pid->addErrorMessage($this->pid->getErrorMessage(false));
        }
        if (!CheckInteger($this->process->AdvancedSearch->SearchValue)) {
            $this->process->addErrorMessage($this->process->getErrorMessage(false));
        }
        if (!CheckNumber($this->_unit->AdvancedSearch->SearchValue)) {
            $this->_unit->addErrorMessage($this->_unit->getErrorMessage(false));
        }
        if (!CheckNumber($this->_40->AdvancedSearch->SearchValue)) {
            $this->_40->addErrorMessage($this->_40->getErrorMessage(false));
        }
        if (!CheckNumber($this->custom_size->AdvancedSearch->SearchValue)) {
            $this->custom_size->addErrorMessage($this->custom_size->getErrorMessage(false));
        }
        if (!CheckNumber($this->custom_size_below_st->AdvancedSearch->SearchValue)) {
            $this->custom_size_below_st->addErrorMessage($this->custom_size_below_st->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->pid->AdvancedSearch->load();
        $this->location->AdvancedSearch->load();
        $this->product_type->AdvancedSearch->load();
        $this->shape->AdvancedSearch->load();
        $this->plan_type->AdvancedSearch->load();
        $this->gcode->AdvancedSearch->load();
        $this->design_id->AdvancedSearch->load();
        $this->process->AdvancedSearch->load();
        $this->yes_no->AdvancedSearch->load();
        $this->fix->AdvancedSearch->load();
        $this->unit->AdvancedSearch->load();
        $this->_unit->AdvancedSearch->load();
        $this->_40->AdvancedSearch->load();
        $this->extra_plan->AdvancedSearch->load();
        $this->custom_size->AdvancedSearch->load();
        $this->custom_size_below_st->AdvancedSearch->load();
        $this->method->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ppverifycompiledlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_plan_type":
                    break;
                case "x_design_id":
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_yes_no":
                    break;
                case "x_fix":
                    break;
                case "x_unit":
                    break;
                case "x_extra_plan":
                    break;
                case "x_method":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
