<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for pp_verify
 */
class PpVerify extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $pid;
    public $location;
    public $product_type;
    public $shape;
    public $plan_type;
    public $design_id;
    public $process;
    public $yes_no;
    public $fix;
    public $unit;
    public $_unit;
    public $_40;
    public $extra_plan;
    public $custom_size;
    public $custom_size_below_st;
    public $method;
    public $category;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "pp_verify";
        $this->TableName = 'pp_verify';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "pp_verify";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // pid
        $this->pid = new DbField(
            $this, // Table
            'x_pid', // Variable name
            'pid', // Name
            '`pid`', // Expression
            '`pid`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pid->addMethod("getLinkPrefix", fn() => "paymentplanlist?id=");
        $this->pid->InputTextType = "text";
        $this->pid->Raw = true;
        $this->pid->Nullable = false; // NOT NULL field
        $this->pid->Required = true; // Required field
        $this->pid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['pid'] = &$this->pid;

        // location
        $this->location = new DbField(
            $this, // Table
            'x_location', // Variable name
            'location', // Name
            '`location`', // Expression
            '`location`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`location`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->location->addMethod("getSelectFilter", fn() => "`status`=1 and `id` > 0");
        $this->location->addMethod("getLinkPrefix", fn() => "paymentplanlist?x_location=");
        $this->location->InputTextType = "text";
        $this->location->Nullable = false; // NOT NULL field
        $this->location->Required = true; // Required field
        $this->location->setSelectMultiple(false); // Select one
        $this->location->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->location->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->location->Lookup = new Lookup($this->location, 'godown_table', false, 'id', ["code","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`code`");
        $this->location->SearchOperators = ["=", "<>"];
        $this->Fields['location'] = &$this->location;

        // product_type
        $this->product_type = new DbField(
            $this, // Table
            'x_product_type', // Variable name
            'product_type', // Name
            '`product_type`', // Expression
            '`product_type`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->product_type->addMethod("getSelectFilter", fn() => "`status`=1 and `id` !=9");
        $this->product_type->InputTextType = "text";
        $this->product_type->Nullable = false; // NOT NULL field
        $this->product_type->Required = true; // Required field
        $this->product_type->Lookup = new Lookup($this->product_type, 'product_type', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`item`");
        $this->product_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product_type->SearchOperators = ["=", "<>"];
        $this->Fields['product_type'] = &$this->product_type;

        // shape
        $this->shape = new DbField(
            $this, // Table
            'x_shape', // Variable name
            'shape', // Name
            '`shape`', // Expression
            '`shape`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shape`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->shape->addMethod("getSelectFilter", fn() => "`status`=1 and id < 100");
        $this->shape->InputTextType = "text";
        $this->shape->Nullable = false; // NOT NULL field
        $this->shape->Required = true; // Required field
        $this->shape->Lookup = new Lookup($this->shape, 'shape', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->shape->SearchOperators = ["=", "<>"];
        $this->Fields['shape'] = &$this->shape;

        // plan_type
        $this->plan_type = new DbField(
            $this, // Table
            'x_plan_type', // Variable name
            'plan_type', // Name
            '`plan_type`', // Expression
            '`plan_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`plan_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->plan_type->addMethod("getDefault", fn() => 1);
        $this->plan_type->addMethod("getLinkPrefix", fn() => "paymentplanlist?x_plan_type=");
        $this->plan_type->InputTextType = "text";
        $this->plan_type->Raw = true;
        $this->plan_type->Nullable = false; // NOT NULL field
        $this->plan_type->Required = true; // Required field
        $this->plan_type->setSelectMultiple(false); // Select one
        $this->plan_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->plan_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->plan_type->Lookup = new Lookup($this->plan_type, 'pp_verify', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->plan_type->OptionCount = 2;
        $this->plan_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->plan_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['plan_type'] = &$this->plan_type;

        // design_id
        $this->design_id = new DbField(
            $this, // Table
            'x_design_id', // Variable name
            'design_id', // Name
            '`design_id`', // Expression
            '`design_id`', // Basic search expression
            200, // Type
            196, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__design_id', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->design_id->addMethod("getDefault", fn() => (isset($_GET['RID']))  ? $_GET['RID'] : '');
        $this->design_id->addMethod("getLinkPrefix", fn() => "paymentplanlist?x_ref=");
        $this->design_id->InputTextType = "text";
        $this->design_id->Lookup = new Lookup($this->design_id, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->design_id->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['design_id'] = &$this->design_id;

        // process
        $this->process = new DbField(
            $this, // Table
            'x_process', // Variable name
            'process', // Name
            '`process`', // Expression
            '`process`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->process->addMethod("getSelectFilter", fn() => "`type`=1 and `status`=1");
        $this->process->addMethod("getLinkPrefix", fn() => "paymentplanlist?x_process=");
        $this->process->InputTextType = "text";
        $this->process->Required = true; // Required field
        $this->process->Lookup = new Lookup($this->process, 'sub_process_type_view2', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['process'] = &$this->process;

        // yes_no
        $this->yes_no = new DbField(
            $this, // Table
            'x_yes_no', // Variable name
            'yes_no', // Name
            '`yes_no`', // Expression
            '`yes_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`yes_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->yes_no->InputTextType = "text";
        $this->yes_no->Raw = true;
        $this->yes_no->Nullable = false; // NOT NULL field
        $this->yes_no->Required = true; // Required field
        $this->yes_no->setSelectMultiple(false); // Select one
        $this->yes_no->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->yes_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->yes_no->Lookup = new Lookup($this->yes_no, 'pp_verify', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->yes_no->OptionCount = 2;
        $this->yes_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->yes_no->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['yes_no'] = &$this->yes_no;

        // fix
        $this->fix = new DbField(
            $this, // Table
            'x_fix', // Variable name
            'fix', // Name
            '`fix`', // Expression
            '`fix`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`fix`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->fix->addMethod("getDefault", fn() => 1);
        $this->fix->InputTextType = "text";
        $this->fix->Raw = true;
        $this->fix->Nullable = false; // NOT NULL field
        $this->fix->Required = true; // Required field
        $this->fix->setSelectMultiple(false); // Select one
        $this->fix->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->fix->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->fix->Lookup = new Lookup($this->fix, 'pp_verify', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->fix->OptionCount = 2;
        $this->fix->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->fix->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['fix'] = &$this->fix;

        // unit
        $this->unit = new DbField(
            $this, // Table
            'x_unit', // Variable name
            'unit', // Name
            '`unit`', // Expression
            '`unit`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`unit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->unit->addMethod("getDefault", fn() => 5);
        $this->unit->InputTextType = "text";
        $this->unit->Raw = true;
        $this->unit->setSelectMultiple(false); // Select one
        $this->unit->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->unit->Lookup = new Lookup($this->unit, 'pp_verify', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->unit->OptionCount = 5;
        $this->unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->unit->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['unit'] = &$this->unit;

        // @unit
        $this->_unit = new DbField(
            $this, // Table
            'x__unit', // Variable name
            '@unit', // Name
            '`@unit`', // Expression
            '`@unit`', // Basic search expression
            4, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`@unit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_unit->addMethod("getDefault", fn() => 0);
        $this->_unit->InputTextType = "text";
        $this->_unit->Raw = true;
        $this->_unit->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_unit->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['@unit'] = &$this->_unit;

        // @
        $this->_40 = new DbField(
            $this, // Table
            'x__40', // Variable name
            '@', // Name
            '`@`', // Expression
            '`@`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`@`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_40->addMethod("getDefault", fn() => 0);
        $this->_40->InputTextType = "text";
        $this->_40->Raw = true;
        $this->_40->Nullable = false; // NOT NULL field
        $this->_40->Required = true; // Required field
        $this->_40->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_40->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['@'] = &$this->_40;

        // extra_plan
        $this->extra_plan = new DbField(
            $this, // Table
            'x_extra_plan', // Variable name
            'extra_plan', // Name
            '`extra_plan`', // Expression
            '`extra_plan`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`extra_plan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->extra_plan->InputTextType = "text";
        $this->extra_plan->Raw = true;
        $this->extra_plan->Nullable = false; // NOT NULL field
        $this->extra_plan->Required = true; // Required field
        $this->extra_plan->setSelectMultiple(false); // Select one
        $this->extra_plan->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->extra_plan->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->extra_plan->Lookup = new Lookup($this->extra_plan, 'pp_verify', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->extra_plan->OptionCount = 4;
        $this->extra_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->extra_plan->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['extra_plan'] = &$this->extra_plan;

        // custom_size
        $this->custom_size = new DbField(
            $this, // Table
            'x_custom_size', // Variable name
            'custom_size', // Name
            '`custom_size`', // Expression
            '`custom_size`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`custom_size`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->custom_size->addMethod("getDefault", fn() => 0);
        $this->custom_size->InputTextType = "text";
        $this->custom_size->Raw = true;
        $this->custom_size->Nullable = false; // NOT NULL field
        $this->custom_size->Required = true; // Required field
        $this->custom_size->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->custom_size->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['custom_size'] = &$this->custom_size;

        // custom_size_below_st
        $this->custom_size_below_st = new DbField(
            $this, // Table
            'x_custom_size_below_st', // Variable name
            'custom_size_below_st', // Name
            '`custom_size_below_st`', // Expression
            '`custom_size_below_st`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`custom_size_below_st`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->custom_size_below_st->InputTextType = "text";
        $this->custom_size_below_st->Raw = true;
        $this->custom_size_below_st->Nullable = false; // NOT NULL field
        $this->custom_size_below_st->Required = true; // Required field
        $this->custom_size_below_st->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->custom_size_below_st->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['custom_size_below_st'] = &$this->custom_size_below_st;

        // method
        $this->method = new DbField(
            $this, // Table
            'x_method', // Variable name
            'method', // Name
            '`method`', // Expression
            '`method`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`method`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->method->addMethod("getSelectFilter", fn() => "`grp`=11");
        $this->method->InputTextType = "text";
        $this->method->Raw = true;
        $this->method->Nullable = false; // NOT NULL field
        $this->method->Required = true; // Required field
        $this->method->setSelectMultiple(false); // Select one
        $this->method->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->method->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->method->Lookup = new Lookup($this->method, 'method', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->method->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['method'] = &$this->method;

        // category
        $this->category = new DbField(
            $this, // Table
            'x_category', // Variable name
            'category', // Name
            '`category`', // Expression
            '`category`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->category->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->category->InputTextType = "text";
        $this->category->Raw = true;
        $this->category->Nullable = false; // NOT NULL field
        $this->category->Required = true; // Required field
        $this->category->setSelectMultiple(false); // Select one
        $this->category->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->category->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->category->Lookup = new Lookup($this->category, 'product_category', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->category->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['category'] = &$this->category;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            if ($ctrl) {
                $orderByList = $this->getSessionOrderByList();
                $arOrderBy = !empty($orderByList) ? explode(", ", $orderByList) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderByList = implode(", ", $arOrderBy);
                $this->setSessionOrderByList($orderByList); // Save to Session
            } else {
                $this->setSessionOrderByList($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "pp_verify";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ", (SELECT `product_code` FROM ref TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.id = pp_verify.design_id LIMIT 1) AS EV__design_id FROM pp_verify)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if ($this->BasicSearch->getKeyword() != "") {
            return true;
        }
        if (
            $this->design_id->AdvancedSearch->SearchValue != "" ||
            $this->design_id->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->design_id->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->design_id->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->pid->DbValue = $row['pid'];
        $this->location->DbValue = $row['location'];
        $this->product_type->DbValue = $row['product_type'];
        $this->shape->DbValue = $row['shape'];
        $this->plan_type->DbValue = $row['plan_type'];
        $this->design_id->DbValue = $row['design_id'];
        $this->process->DbValue = $row['process'];
        $this->yes_no->DbValue = $row['yes_no'];
        $this->fix->DbValue = $row['fix'];
        $this->unit->DbValue = $row['unit'];
        $this->_unit->DbValue = $row['@unit'];
        $this->_40->DbValue = $row['@'];
        $this->extra_plan->DbValue = $row['extra_plan'];
        $this->custom_size->DbValue = $row['custom_size'];
        $this->custom_size_below_st->DbValue = $row['custom_size_below_st'];
        $this->method->DbValue = $row['method'];
        $this->category->DbValue = $row['category'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("ppverifylist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "ppverifyview" => $Language->phrase("View"),
            "ppverifyedit" => $Language->phrase("Edit"),
            "ppverifyadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "ppverifylist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "PpVerifyView",
            Config("API_ADD_ACTION") => "PpVerifyAdd",
            Config("API_EDIT_ACTION") => "PpVerifyEdit",
            Config("API_DELETE_ACTION") => "PpVerifyDelete",
            Config("API_LIST_ACTION") => "PpVerifyList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "ppverifylist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("ppverifyview", $parm);
        } else {
            $url = $this->keyUrl("ppverifyview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "ppverifyadd?" . $parm;
        } else {
            $url = "ppverifyadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("ppverifyedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("ppverifylist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("ppverifyadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("ppverifylist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("ppverifydelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->pid->setDbValue($row['pid']);
        $this->location->setDbValue($row['location']);
        $this->product_type->setDbValue($row['product_type']);
        $this->shape->setDbValue($row['shape']);
        $this->plan_type->setDbValue($row['plan_type']);
        $this->design_id->setDbValue($row['design_id']);
        $this->process->setDbValue($row['process']);
        $this->yes_no->setDbValue($row['yes_no']);
        $this->fix->setDbValue($row['fix']);
        $this->unit->setDbValue($row['unit']);
        $this->_unit->setDbValue($row['@unit']);
        $this->_40->setDbValue($row['@']);
        $this->extra_plan->setDbValue($row['extra_plan']);
        $this->custom_size->setDbValue($row['custom_size']);
        $this->custom_size_below_st->setDbValue($row['custom_size_below_st']);
        $this->method->setDbValue($row['method']);
        $this->category->setDbValue($row['category']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "PpVerifyList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // pid

        // location

        // product_type

        // shape

        // plan_type

        // design_id

        // process

        // yes_no

        // fix

        // unit

        // @unit

        // @

        // extra_plan

        // custom_size

        // custom_size_below_st

        // method

        // category

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // pid
        $this->pid->ViewValue = $this->pid->CurrentValue;
        $this->pid->ViewValue = FormatNumber($this->pid->ViewValue, $this->pid->formatPattern());

        // location
        $curVal = strval($this->location->CurrentValue);
        if ($curVal != "") {
            $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
            if ($this->location->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                    $this->location->ViewValue = $this->location->displayValue($arwrk);
                } else {
                    $this->location->ViewValue = $this->location->CurrentValue;
                }
            }
        } else {
            $this->location->ViewValue = null;
        }

        // product_type
        $curVal = strval($this->product_type->CurrentValue);
        if ($curVal != "") {
            $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
            if ($this->product_type->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->product_type->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->product_type->Lookup->renderViewRow($row);
                        $this->product_type->ViewValue->add($this->product_type->displayValue($arwrk));
                    }
                } else {
                    $this->product_type->ViewValue = $this->product_type->CurrentValue;
                }
            }
        } else {
            $this->product_type->ViewValue = null;
        }

        // shape
        $curVal = strval($this->shape->CurrentValue);
        if ($curVal != "") {
            $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
            if ($this->shape->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->shape->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->shape->Lookup->renderViewRow($row);
                        $this->shape->ViewValue->add($this->shape->displayValue($arwrk));
                    }
                } else {
                    $this->shape->ViewValue = $this->shape->CurrentValue;
                }
            }
        } else {
            $this->shape->ViewValue = null;
        }

        // plan_type
        if (strval($this->plan_type->CurrentValue) != "") {
            $this->plan_type->ViewValue = $this->plan_type->optionCaption($this->plan_type->CurrentValue);
        } else {
            $this->plan_type->ViewValue = null;
        }

        // design_id
        if ($this->design_id->VirtualValue != "") {
            $this->design_id->ViewValue = $this->design_id->VirtualValue;
        } else {
            $this->design_id->ViewValue = $this->design_id->CurrentValue;
            $curVal = strval($this->design_id->CurrentValue);
            if ($curVal != "") {
                $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
                if ($this->design_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                        $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                    } else {
                        $this->design_id->ViewValue = $this->design_id->CurrentValue;
                    }
                }
            } else {
                $this->design_id->ViewValue = null;
            }
        }

        // process
        $this->process->ViewValue = $this->process->CurrentValue;
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                    $this->process->ViewValue = $this->process->displayValue($arwrk);
                } else {
                    $this->process->ViewValue = $this->process->CurrentValue;
                }
            }
        } else {
            $this->process->ViewValue = null;
        }

        // yes_no
        if (strval($this->yes_no->CurrentValue) != "") {
            $this->yes_no->ViewValue = $this->yes_no->optionCaption($this->yes_no->CurrentValue);
        } else {
            $this->yes_no->ViewValue = null;
        }

        // fix
        if (strval($this->fix->CurrentValue) != "") {
            $this->fix->ViewValue = $this->fix->optionCaption($this->fix->CurrentValue);
        } else {
            $this->fix->ViewValue = null;
        }

        // unit
        if (strval($this->unit->CurrentValue) != "") {
            $this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
        } else {
            $this->unit->ViewValue = null;
        }

        // @unit
        $this->_unit->ViewValue = $this->_unit->CurrentValue;
        $this->_unit->ViewValue = FormatNumber($this->_unit->ViewValue, $this->_unit->formatPattern());

        // @
        $this->_40->ViewValue = $this->_40->CurrentValue;
        $this->_40->ViewValue = FormatNumber($this->_40->ViewValue, $this->_40->formatPattern());

        // extra_plan
        if (strval($this->extra_plan->CurrentValue) != "") {
            $this->extra_plan->ViewValue = $this->extra_plan->optionCaption($this->extra_plan->CurrentValue);
        } else {
            $this->extra_plan->ViewValue = null;
        }

        // custom_size
        $this->custom_size->ViewValue = $this->custom_size->CurrentValue;
        $this->custom_size->ViewValue = FormatNumber($this->custom_size->ViewValue, $this->custom_size->formatPattern());

        // custom_size_below_st
        $this->custom_size_below_st->ViewValue = $this->custom_size_below_st->CurrentValue;
        $this->custom_size_below_st->ViewValue = FormatNumber($this->custom_size_below_st->ViewValue, $this->custom_size_below_st->formatPattern());

        // method
        $curVal = strval($this->method->CurrentValue);
        if ($curVal != "") {
            $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
            if ($this->method->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->method->getSelectFilter($this); // PHP
                $sqlWrk = $this->method->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->method->Lookup->renderViewRow($rswrk[0]);
                    $this->method->ViewValue = $this->method->displayValue($arwrk);
                } else {
                    $this->method->ViewValue = $this->method->CurrentValue;
                }
            }
        } else {
            $this->method->ViewValue = null;
        }

        // category
        $curVal = strval($this->category->CurrentValue);
        if ($curVal != "") {
            $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            if ($this->category->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                    $this->category->ViewValue = $this->category->displayValue($arwrk);
                } else {
                    $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                }
            }
        } else {
            $this->category->ViewValue = null;
        }

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // pid
        if (!EmptyValue($this->pid->CurrentValue)) {
            $this->pid->HrefValue = $this->pid->getLinkPrefix() . $this->pid->CurrentValue; // Add prefix/suffix
            $this->pid->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->pid->HrefValue = FullUrl($this->pid->HrefValue, "href");
            }
        } else {
            $this->pid->HrefValue = "";
        }
        $this->pid->TooltipValue = "";

        // location
        if (!EmptyValue($this->location->CurrentValue)) {
            $this->location->HrefValue = $this->location->getLinkPrefix() . $this->location->CurrentValue; // Add prefix/suffix
            $this->location->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->location->HrefValue = FullUrl($this->location->HrefValue, "href");
            }
        } else {
            $this->location->HrefValue = "";
        }
        $this->location->TooltipValue = "";

        // product_type
        $this->product_type->HrefValue = "";
        $this->product_type->TooltipValue = "";

        // shape
        $this->shape->HrefValue = "";
        $this->shape->TooltipValue = "";

        // plan_type
        if (!EmptyValue($this->plan_type->CurrentValue)) {
            $this->plan_type->HrefValue = $this->plan_type->getLinkPrefix() . $this->plan_type->CurrentValue; // Add prefix/suffix
            $this->plan_type->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->plan_type->HrefValue = FullUrl($this->plan_type->HrefValue, "href");
            }
        } else {
            $this->plan_type->HrefValue = "";
        }
        $this->plan_type->TooltipValue = "";

        // design_id
        $this->design_id->HrefValue = "";
        $this->design_id->TooltipValue = "";

        // process
        if (!EmptyValue($this->process->CurrentValue)) {
            $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
            $this->process->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
            }
        } else {
            $this->process->HrefValue = "";
        }
        $this->process->TooltipValue = "";

        // yes_no
        $this->yes_no->HrefValue = "";
        $this->yes_no->TooltipValue = "";

        // fix
        $this->fix->HrefValue = "";
        $this->fix->TooltipValue = "";

        // unit
        $this->unit->HrefValue = "";
        $this->unit->TooltipValue = "";

        // @unit
        $this->_unit->HrefValue = "";
        $this->_unit->TooltipValue = "";

        // @
        $this->_40->HrefValue = "";
        $this->_40->TooltipValue = "";

        // extra_plan
        $this->extra_plan->HrefValue = "";
        $this->extra_plan->TooltipValue = "";

        // custom_size
        $this->custom_size->HrefValue = "";
        $this->custom_size->TooltipValue = "";

        // custom_size_below_st
        $this->custom_size_below_st->HrefValue = "";
        $this->custom_size_below_st->TooltipValue = "";

        // method
        $this->method->HrefValue = "";
        $this->method->TooltipValue = "";

        // category
        $this->category->HrefValue = "";
        $this->category->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // pid
        $this->pid->setupEditAttributes();
        $this->pid->EditValue = $this->pid->CurrentValue;
        $this->pid->PlaceHolder = RemoveHtml($this->pid->caption());
        if (strval($this->pid->EditValue) != "" && is_numeric($this->pid->EditValue)) {
            $this->pid->EditValue = FormatNumber($this->pid->EditValue, null);
        }

        // location
        $this->location->setupEditAttributes();
        $this->location->PlaceHolder = RemoveHtml($this->location->caption());

        // product_type
        $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

        // shape
        $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

        // plan_type
        $this->plan_type->setupEditAttributes();
        $this->plan_type->EditValue = $this->plan_type->options(true);
        $this->plan_type->PlaceHolder = RemoveHtml($this->plan_type->caption());

        // design_id
        $this->design_id->setupEditAttributes();
        if (!$this->design_id->Raw) {
            $this->design_id->CurrentValue = HtmlDecode($this->design_id->CurrentValue);
        }
        $this->design_id->EditValue = $this->design_id->CurrentValue;
        $this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

        // process
        $this->process->setupEditAttributes();
        if (!$this->process->Raw) {
            $this->process->CurrentValue = HtmlDecode($this->process->CurrentValue);
        }
        $this->process->EditValue = $this->process->CurrentValue;
        $this->process->PlaceHolder = RemoveHtml($this->process->caption());

        // yes_no
        $this->yes_no->setupEditAttributes();
        $this->yes_no->EditValue = $this->yes_no->options(true);
        $this->yes_no->PlaceHolder = RemoveHtml($this->yes_no->caption());

        // fix
        $this->fix->setupEditAttributes();
        $this->fix->EditValue = $this->fix->options(true);
        $this->fix->PlaceHolder = RemoveHtml($this->fix->caption());

        // unit
        $this->unit->setupEditAttributes();
        $this->unit->EditValue = $this->unit->options(true);
        $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

        // @unit
        $this->_unit->setupEditAttributes();
        $this->_unit->EditValue = $this->_unit->CurrentValue;
        $this->_unit->PlaceHolder = RemoveHtml($this->_unit->caption());
        if (strval($this->_unit->EditValue) != "" && is_numeric($this->_unit->EditValue)) {
            $this->_unit->EditValue = FormatNumber($this->_unit->EditValue, null);
        }

        // @
        $this->_40->setupEditAttributes();
        $this->_40->EditValue = $this->_40->CurrentValue;
        $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
        if (strval($this->_40->EditValue) != "" && is_numeric($this->_40->EditValue)) {
            $this->_40->EditValue = FormatNumber($this->_40->EditValue, null);
        }

        // extra_plan
        $this->extra_plan->setupEditAttributes();
        $this->extra_plan->EditValue = $this->extra_plan->options(true);
        $this->extra_plan->PlaceHolder = RemoveHtml($this->extra_plan->caption());

        // custom_size
        $this->custom_size->setupEditAttributes();
        $this->custom_size->EditValue = $this->custom_size->CurrentValue;
        $this->custom_size->PlaceHolder = RemoveHtml($this->custom_size->caption());
        if (strval($this->custom_size->EditValue) != "" && is_numeric($this->custom_size->EditValue)) {
            $this->custom_size->EditValue = FormatNumber($this->custom_size->EditValue, null);
        }

        // custom_size_below_st
        $this->custom_size_below_st->setupEditAttributes();
        $this->custom_size_below_st->EditValue = $this->custom_size_below_st->CurrentValue;
        $this->custom_size_below_st->PlaceHolder = RemoveHtml($this->custom_size_below_st->caption());
        if (strval($this->custom_size_below_st->EditValue) != "" && is_numeric($this->custom_size_below_st->EditValue)) {
            $this->custom_size_below_st->EditValue = FormatNumber($this->custom_size_below_st->EditValue, null);
        }

        // method
        $this->method->setupEditAttributes();
        $this->method->PlaceHolder = RemoveHtml($this->method->caption());

        // category
        $this->category->setupEditAttributes();
        $this->category->PlaceHolder = RemoveHtml($this->category->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->pid);
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->product_type);
                    $doc->exportCaption($this->shape);
                    $doc->exportCaption($this->plan_type);
                    $doc->exportCaption($this->design_id);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->yes_no);
                    $doc->exportCaption($this->fix);
                    $doc->exportCaption($this->unit);
                    $doc->exportCaption($this->_unit);
                    $doc->exportCaption($this->_40);
                    $doc->exportCaption($this->extra_plan);
                    $doc->exportCaption($this->custom_size);
                    $doc->exportCaption($this->custom_size_below_st);
                    $doc->exportCaption($this->method);
                    $doc->exportCaption($this->category);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->pid);
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->product_type);
                    $doc->exportCaption($this->shape);
                    $doc->exportCaption($this->plan_type);
                    $doc->exportCaption($this->design_id);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->yes_no);
                    $doc->exportCaption($this->fix);
                    $doc->exportCaption($this->unit);
                    $doc->exportCaption($this->_unit);
                    $doc->exportCaption($this->_40);
                    $doc->exportCaption($this->extra_plan);
                    $doc->exportCaption($this->custom_size);
                    $doc->exportCaption($this->custom_size_below_st);
                    $doc->exportCaption($this->method);
                    $doc->exportCaption($this->category);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->pid);
                        $doc->exportField($this->location);
                        $doc->exportField($this->product_type);
                        $doc->exportField($this->shape);
                        $doc->exportField($this->plan_type);
                        $doc->exportField($this->design_id);
                        $doc->exportField($this->process);
                        $doc->exportField($this->yes_no);
                        $doc->exportField($this->fix);
                        $doc->exportField($this->unit);
                        $doc->exportField($this->_unit);
                        $doc->exportField($this->_40);
                        $doc->exportField($this->extra_plan);
                        $doc->exportField($this->custom_size);
                        $doc->exportField($this->custom_size_below_st);
                        $doc->exportField($this->method);
                        $doc->exportField($this->category);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->pid);
                        $doc->exportField($this->location);
                        $doc->exportField($this->product_type);
                        $doc->exportField($this->shape);
                        $doc->exportField($this->plan_type);
                        $doc->exportField($this->design_id);
                        $doc->exportField($this->process);
                        $doc->exportField($this->yes_no);
                        $doc->exportField($this->fix);
                        $doc->exportField($this->unit);
                        $doc->exportField($this->_unit);
                        $doc->exportField($this->_40);
                        $doc->exportField($this->extra_plan);
                        $doc->exportField($this->custom_size);
                        $doc->exportField($this->custom_size_below_st);
                        $doc->exportField($this->method);
                        $doc->exportField($this->category);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
