<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PortalVersionAdd extends PortalVersion
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PortalVersionAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "portalversionadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->datetime->setVisibility();
        $this->version->setVisibility();
        $this->php_code->setVisibility();
        $this->portal_d_php_code->Visible = false;
        $this->portal_d_apc_query->Visible = false;
        $this->portal_d_mysql_query->Visible = false;
        $this->portal_d_sp_query->Visible = false;
        $this->portal_d_url_link->Visible = false;
        $this->portal_c_php_code->Visible = false;
        $this->mysql_query->setVisibility();
        $this->portal_c_mysql_query->Visible = false;
        $this->sp_query->setVisibility();
        $this->portal_c_sp_query->Visible = false;
        $this->apc_query->setVisibility();
        $this->portal_c_apc_query->Visible = false;
        $this->url_link->setVisibility();
        $this->u_type->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'portal_version';
        $this->TableName = 'portal_version';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (portal_version)
        if (!isset($GLOBALS["portal_version"]) || $GLOBALS["portal_version"]::class == PROJECT_NAMESPACE . "portal_version") {
            $GLOBALS["portal_version"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'portal_version');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "portalversionview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->portal_c_php_code);
        $this->setupLookupOptions($this->portal_c_mysql_query);
        $this->setupLookupOptions($this->portal_c_sp_query);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("portalversionlist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "portalversionlist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "portalversionview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "portalversionlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "portalversionlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->datetime->DefaultValue = $this->datetime->getDefault(); // PHP
        $this->datetime->OldValue = $this->datetime->DefaultValue;
        $this->php_code->DefaultValue = $this->php_code->getDefault(); // PHP
        $this->php_code->OldValue = $this->php_code->DefaultValue;
        $this->u_type->DefaultValue = $this->u_type->getDefault(); // PHP
        $this->u_type->OldValue = $this->u_type->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val, true, $validate);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'version' first before field var 'x_version'
        $val = $CurrentForm->hasValue("version") ? $CurrentForm->getValue("version") : $CurrentForm->getValue("x_version");
        if (!$this->version->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->version->Visible = false; // Disable update for API request
            } else {
                $this->version->setFormValue($val);
            }
        }

        // Check field name 'php_code' first before field var 'x_php_code'
        $val = $CurrentForm->hasValue("php_code") ? $CurrentForm->getValue("php_code") : $CurrentForm->getValue("x_php_code");
        if (!$this->php_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->php_code->Visible = false; // Disable update for API request
            } else {
                $this->php_code->setFormValue($val);
            }
        }

        // Check field name 'mysql_query' first before field var 'x_mysql_query'
        $val = $CurrentForm->hasValue("mysql_query") ? $CurrentForm->getValue("mysql_query") : $CurrentForm->getValue("x_mysql_query");
        if (!$this->mysql_query->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mysql_query->Visible = false; // Disable update for API request
            } else {
                $this->mysql_query->setFormValue($val);
            }
        }

        // Check field name 'sp_query' first before field var 'x_sp_query'
        $val = $CurrentForm->hasValue("sp_query") ? $CurrentForm->getValue("sp_query") : $CurrentForm->getValue("x_sp_query");
        if (!$this->sp_query->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sp_query->Visible = false; // Disable update for API request
            } else {
                $this->sp_query->setFormValue($val);
            }
        }

        // Check field name 'apc_query' first before field var 'x_apc_query'
        $val = $CurrentForm->hasValue("apc_query") ? $CurrentForm->getValue("apc_query") : $CurrentForm->getValue("x_apc_query");
        if (!$this->apc_query->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->apc_query->Visible = false; // Disable update for API request
            } else {
                $this->apc_query->setFormValue($val);
            }
        }

        // Check field name 'url_link' first before field var 'x_url_link'
        $val = $CurrentForm->hasValue("url_link") ? $CurrentForm->getValue("url_link") : $CurrentForm->getValue("x_url_link");
        if (!$this->url_link->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->url_link->Visible = false; // Disable update for API request
            } else {
                $this->url_link->setFormValue($val);
            }
        }

        // Check field name 'u_type' first before field var 'x_u_type'
        $val = $CurrentForm->hasValue("u_type") ? $CurrentForm->getValue("u_type") : $CurrentForm->getValue("x_u_type");
        if (!$this->u_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->u_type->Visible = false; // Disable update for API request
            } else {
                $this->u_type->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->version->CurrentValue = $this->version->FormValue;
        $this->php_code->CurrentValue = $this->php_code->FormValue;
        $this->mysql_query->CurrentValue = $this->mysql_query->FormValue;
        $this->sp_query->CurrentValue = $this->sp_query->FormValue;
        $this->apc_query->CurrentValue = $this->apc_query->FormValue;
        $this->url_link->CurrentValue = $this->url_link->FormValue;
        $this->u_type->CurrentValue = $this->u_type->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->datetime->setDbValue($row['datetime']);
        $this->version->setDbValue($row['version']);
        $this->php_code->setDbValue($row['php_code']);
        $this->portal_d_php_code->setDbValue($row['portal_d_php_code']);
        $this->portal_d_apc_query->setDbValue($row['portal_d_apc_query']);
        $this->portal_d_mysql_query->setDbValue($row['portal_d_mysql_query']);
        $this->portal_d_sp_query->setDbValue($row['portal_d_sp_query']);
        $this->portal_d_url_link->setDbValue($row['portal_d_url_link']);
        $this->portal_c_php_code->setDbValue($row['portal_c_php_code']);
        $this->mysql_query->setDbValue($row['mysql_query']);
        $this->portal_c_mysql_query->setDbValue($row['portal_c_mysql_query']);
        $this->sp_query->setDbValue($row['sp_query']);
        $this->portal_c_sp_query->setDbValue($row['portal_c_sp_query']);
        $this->apc_query->setDbValue($row['apc_query']);
        $this->portal_c_apc_query->setDbValue($row['portal_c_apc_query']);
        $this->url_link->setDbValue($row['url_link']);
        $this->u_type->setDbValue($row['u_type']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['version'] = $this->version->DefaultValue;
        $row['php_code'] = $this->php_code->DefaultValue;
        $row['portal_d_php_code'] = $this->portal_d_php_code->DefaultValue;
        $row['portal_d_apc_query'] = $this->portal_d_apc_query->DefaultValue;
        $row['portal_d_mysql_query'] = $this->portal_d_mysql_query->DefaultValue;
        $row['portal_d_sp_query'] = $this->portal_d_sp_query->DefaultValue;
        $row['portal_d_url_link'] = $this->portal_d_url_link->DefaultValue;
        $row['portal_c_php_code'] = $this->portal_c_php_code->DefaultValue;
        $row['mysql_query'] = $this->mysql_query->DefaultValue;
        $row['portal_c_mysql_query'] = $this->portal_c_mysql_query->DefaultValue;
        $row['sp_query'] = $this->sp_query->DefaultValue;
        $row['portal_c_sp_query'] = $this->portal_c_sp_query->DefaultValue;
        $row['apc_query'] = $this->apc_query->DefaultValue;
        $row['portal_c_apc_query'] = $this->portal_c_apc_query->DefaultValue;
        $row['url_link'] = $this->url_link->DefaultValue;
        $row['u_type'] = $this->u_type->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // version
        $this->version->RowCssClass = "row";

        // php_code
        $this->php_code->RowCssClass = "row";

        // portal_d_php_code
        $this->portal_d_php_code->RowCssClass = "row";

        // portal_d_apc_query
        $this->portal_d_apc_query->RowCssClass = "row";

        // portal_d_mysql_query
        $this->portal_d_mysql_query->RowCssClass = "row";

        // portal_d_sp_query
        $this->portal_d_sp_query->RowCssClass = "row";

        // portal_d_url_link
        $this->portal_d_url_link->RowCssClass = "row";

        // portal_c_php_code
        $this->portal_c_php_code->RowCssClass = "row";

        // mysql_query
        $this->mysql_query->RowCssClass = "row";

        // portal_c_mysql_query
        $this->portal_c_mysql_query->RowCssClass = "row";

        // sp_query
        $this->sp_query->RowCssClass = "row";

        // portal_c_sp_query
        $this->portal_c_sp_query->RowCssClass = "row";

        // apc_query
        $this->apc_query->RowCssClass = "row";

        // portal_c_apc_query
        $this->portal_c_apc_query->RowCssClass = "row";

        // url_link
        $this->url_link->RowCssClass = "row";

        // u_type
        $this->u_type->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // version
            $this->version->ViewValue = $this->version->CurrentValue;

            // php_code
            $this->php_code->ViewValue = $this->php_code->CurrentValue;

            // mysql_query
            $this->mysql_query->ViewValue = $this->mysql_query->CurrentValue;

            // sp_query
            $this->sp_query->ViewValue = $this->sp_query->CurrentValue;

            // apc_query
            $this->apc_query->ViewValue = $this->apc_query->CurrentValue;

            // url_link
            $this->url_link->ViewValue = $this->url_link->CurrentValue;

            // u_type
            $this->u_type->ViewValue = $this->u_type->CurrentValue;
            $this->u_type->ViewValue = FormatNumber($this->u_type->ViewValue, $this->u_type->formatPattern());

            // datetime
            $this->datetime->HrefValue = "";

            // version
            $this->version->HrefValue = "";

            // php_code
            $this->php_code->HrefValue = "";
            $this->php_code->TooltipValue = "";

            // mysql_query
            $this->mysql_query->HrefValue = "";
            $this->mysql_query->TooltipValue = "";

            // sp_query
            $this->sp_query->HrefValue = "";
            $this->sp_query->TooltipValue = "";

            // apc_query
            $this->apc_query->HrefValue = "";

            // url_link
            $this->url_link->HrefValue = "";

            // u_type
            $this->u_type->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // version
            $this->version->setupEditAttributes();
            if (!$this->version->Raw) {
                $this->version->CurrentValue = HtmlDecode($this->version->CurrentValue);
            }
            $this->version->EditValue = HtmlEncode($this->version->CurrentValue);
            $this->version->PlaceHolder = RemoveHtml($this->version->caption());

            // php_code
            $this->php_code->setupEditAttributes();
            if (!$this->php_code->Raw) {
                $this->php_code->CurrentValue = HtmlDecode($this->php_code->CurrentValue);
            }
            $this->php_code->EditValue = HtmlEncode($this->php_code->CurrentValue);
            $this->php_code->PlaceHolder = RemoveHtml($this->php_code->caption());

            // mysql_query
            $this->mysql_query->setupEditAttributes();
            $this->mysql_query->EditValue = HtmlEncode($this->mysql_query->CurrentValue);
            $this->mysql_query->PlaceHolder = RemoveHtml($this->mysql_query->caption());

            // sp_query
            $this->sp_query->setupEditAttributes();
            $this->sp_query->EditValue = HtmlEncode($this->sp_query->CurrentValue);
            $this->sp_query->PlaceHolder = RemoveHtml($this->sp_query->caption());

            // apc_query
            $this->apc_query->setupEditAttributes();
            $this->apc_query->EditValue = HtmlEncode($this->apc_query->CurrentValue);
            $this->apc_query->PlaceHolder = RemoveHtml($this->apc_query->caption());

            // url_link
            $this->url_link->setupEditAttributes();
            if (!$this->url_link->Raw) {
                $this->url_link->CurrentValue = HtmlDecode($this->url_link->CurrentValue);
            }
            $this->url_link->EditValue = HtmlEncode($this->url_link->CurrentValue);
            $this->url_link->PlaceHolder = RemoveHtml($this->url_link->caption());

            // u_type
            $this->u_type->setupEditAttributes();
            $this->u_type->EditValue = $this->u_type->CurrentValue;
            $this->u_type->PlaceHolder = RemoveHtml($this->u_type->caption());
            if (strval($this->u_type->EditValue) != "" && is_numeric($this->u_type->EditValue)) {
                $this->u_type->EditValue = FormatNumber($this->u_type->EditValue, null);
            }

            // Add refer script

            // datetime
            $this->datetime->HrefValue = "";

            // version
            $this->version->HrefValue = "";

            // php_code
            $this->php_code->HrefValue = "";

            // mysql_query
            $this->mysql_query->HrefValue = "";

            // sp_query
            $this->sp_query->HrefValue = "";

            // apc_query
            $this->apc_query->HrefValue = "";

            // url_link
            $this->url_link->HrefValue = "";

            // u_type
            $this->u_type->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->datetime->FormValue, $this->datetime->formatPattern())) {
                $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
            }
            if ($this->version->Visible && $this->version->Required) {
                if (!$this->version->IsDetailKey && EmptyValue($this->version->FormValue)) {
                    $this->version->addErrorMessage(str_replace("%s", $this->version->caption(), $this->version->RequiredErrorMessage));
                }
            }
            if ($this->php_code->Visible && $this->php_code->Required) {
                if (!$this->php_code->IsDetailKey && EmptyValue($this->php_code->FormValue)) {
                    $this->php_code->addErrorMessage(str_replace("%s", $this->php_code->caption(), $this->php_code->RequiredErrorMessage));
                }
            }
            if ($this->mysql_query->Visible && $this->mysql_query->Required) {
                if (!$this->mysql_query->IsDetailKey && EmptyValue($this->mysql_query->FormValue)) {
                    $this->mysql_query->addErrorMessage(str_replace("%s", $this->mysql_query->caption(), $this->mysql_query->RequiredErrorMessage));
                }
            }
            if ($this->sp_query->Visible && $this->sp_query->Required) {
                if (!$this->sp_query->IsDetailKey && EmptyValue($this->sp_query->FormValue)) {
                    $this->sp_query->addErrorMessage(str_replace("%s", $this->sp_query->caption(), $this->sp_query->RequiredErrorMessage));
                }
            }
            if ($this->apc_query->Visible && $this->apc_query->Required) {
                if (!$this->apc_query->IsDetailKey && EmptyValue($this->apc_query->FormValue)) {
                    $this->apc_query->addErrorMessage(str_replace("%s", $this->apc_query->caption(), $this->apc_query->RequiredErrorMessage));
                }
            }
            if ($this->url_link->Visible && $this->url_link->Required) {
                if (!$this->url_link->IsDetailKey && EmptyValue($this->url_link->FormValue)) {
                    $this->url_link->addErrorMessage(str_replace("%s", $this->url_link->caption(), $this->url_link->RequiredErrorMessage));
                }
            }
            if ($this->u_type->Visible && $this->u_type->Required) {
                if (!$this->u_type->IsDetailKey && EmptyValue($this->u_type->FormValue)) {
                    $this->u_type->addErrorMessage(str_replace("%s", $this->u_type->caption(), $this->u_type->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->u_type->FormValue)) {
                $this->u_type->addErrorMessage($this->u_type->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->version->CurrentValue != "") { // Check field with unique index
            $filter = "(`version` = '" . AdjustSql($this->version->CurrentValue, $this->Dbid) . "')";
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $idxErrMsg = str_replace("%f", $this->version->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->version->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // datetime
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // version
        $this->version->setDbValueDef($rsnew, $this->version->CurrentValue, false);

        // php_code
        $this->php_code->setDbValueDef($rsnew, $this->php_code->CurrentValue, false);

        // mysql_query
        $this->mysql_query->setDbValueDef($rsnew, $this->mysql_query->CurrentValue, false);

        // sp_query
        $this->sp_query->setDbValueDef($rsnew, $this->sp_query->CurrentValue, false);

        // apc_query
        $this->apc_query->setDbValueDef($rsnew, $this->apc_query->CurrentValue, false);

        // url_link
        $this->url_link->setDbValueDef($rsnew, $this->url_link->CurrentValue, false);

        // u_type
        $this->u_type->setDbValueDef($rsnew, $this->u_type->CurrentValue, strval($this->u_type->CurrentValue) == "");
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['version'])) { // version
            $this->version->setFormValue($row['version']);
        }
        if (isset($row['php_code'])) { // php_code
            $this->php_code->setFormValue($row['php_code']);
        }
        if (isset($row['mysql_query'])) { // mysql_query
            $this->mysql_query->setFormValue($row['mysql_query']);
        }
        if (isset($row['sp_query'])) { // sp_query
            $this->sp_query->setFormValue($row['sp_query']);
        }
        if (isset($row['apc_query'])) { // apc_query
            $this->apc_query->setFormValue($row['apc_query']);
        }
        if (isset($row['url_link'])) { // url_link
            $this->url_link->setFormValue($row['url_link']);
        }
        if (isset($row['u_type'])) { // u_type
            $this->u_type->setFormValue($row['u_type']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("portalversionlist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "tabs";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_portal_c_php_code":
                    break;
                case "x_portal_c_mysql_query":
                    break;
                case "x_portal_c_sp_query":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
        ExecuteStatement("SET @@group_concat_max_len = 100000;");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	$this->php_code->ReadOnly = True;
    	$URL = $_SERVER["HTTP_HOST"];
    	IF ($URL != 'fibre.intsys.in')
    	{
    	$_SESSION[SESSION_SUCCESS_MESSAGE] = 'Not Authorized to View Portal Version';
    	header('location:db2');
    	}	
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
