<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PortalSetupEdit extends PortalSetup
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PortalSetupEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "portalsetupedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->url->setVisibility();
        $this->admin_url->setVisibility();
        $this->mail_code->setVisibility();
        $this->footer_line->setVisibility();
        $this->portal_category->setVisibility();
        $this->mcu->setVisibility();
        $this->fcm_server_key->setVisibility();
        $this->app_version->setVisibility();
        $this->pd_byepass->setVisibility();
        $this->operator->setVisibility();
        $this->google_map_api->setVisibility();
        $this->material_payment_type->setVisibility();
        $this->material_payment_varient->setVisibility();
        $this->footer_line_be->setVisibility();
        $this->allow_reg->setVisibility();
        $this->login_remember->setVisibility();
        $this->gp_p_check->setVisibility();
        $this->fe_version->setVisibility();
        $this->admin_version->setVisibility();
        $this->_dashboard->setVisibility();
        $this->developer_upi_id->setVisibility();
        $this->developer_company->setVisibility();
        $this->default_page->setVisibility();
        $this->bom_edit->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'portal_setup';
        $this->TableName = 'portal_setup';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (portal_setup)
        if (!isset($GLOBALS["portal_setup"]) || $GLOBALS["portal_setup"]::class == PROJECT_NAMESPACE . "portal_setup") {
            $GLOBALS["portal_setup"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'portal_setup');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "portalsetupview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->portal_category);
        $this->setupLookupOptions($this->pd_byepass);
        $this->setupLookupOptions($this->_dashboard);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("portalsetuplist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "portalsetuplist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "portalsetuplist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "portalsetuplist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'url' first before field var 'x_url'
        $val = $CurrentForm->hasValue("url") ? $CurrentForm->getValue("url") : $CurrentForm->getValue("x_url");
        if (!$this->url->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->url->Visible = false; // Disable update for API request
            } else {
                $this->url->setFormValue($val);
            }
        }

        // Check field name 'admin_url' first before field var 'x_admin_url'
        $val = $CurrentForm->hasValue("admin_url") ? $CurrentForm->getValue("admin_url") : $CurrentForm->getValue("x_admin_url");
        if (!$this->admin_url->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->admin_url->Visible = false; // Disable update for API request
            } else {
                $this->admin_url->setFormValue($val);
            }
        }

        // Check field name 'mail_code' first before field var 'x_mail_code'
        $val = $CurrentForm->hasValue("mail_code") ? $CurrentForm->getValue("mail_code") : $CurrentForm->getValue("x_mail_code");
        if (!$this->mail_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mail_code->Visible = false; // Disable update for API request
            } else {
                $this->mail_code->setFormValue($val);
            }
        }

        // Check field name 'footer_line' first before field var 'x_footer_line'
        $val = $CurrentForm->hasValue("footer_line") ? $CurrentForm->getValue("footer_line") : $CurrentForm->getValue("x_footer_line");
        if (!$this->footer_line->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->footer_line->Visible = false; // Disable update for API request
            } else {
                $this->footer_line->setFormValue($val);
            }
        }

        // Check field name 'portal_category' first before field var 'x_portal_category'
        $val = $CurrentForm->hasValue("portal_category") ? $CurrentForm->getValue("portal_category") : $CurrentForm->getValue("x_portal_category");
        if (!$this->portal_category->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->portal_category->Visible = false; // Disable update for API request
            } else {
                $this->portal_category->setFormValue($val);
            }
        }

        // Check field name 'mcu' first before field var 'x_mcu'
        $val = $CurrentForm->hasValue("mcu") ? $CurrentForm->getValue("mcu") : $CurrentForm->getValue("x_mcu");
        if (!$this->mcu->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mcu->Visible = false; // Disable update for API request
            } else {
                $this->mcu->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'fcm_server_key' first before field var 'x_fcm_server_key'
        $val = $CurrentForm->hasValue("fcm_server_key") ? $CurrentForm->getValue("fcm_server_key") : $CurrentForm->getValue("x_fcm_server_key");
        if (!$this->fcm_server_key->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->fcm_server_key->Visible = false; // Disable update for API request
            } else {
                $this->fcm_server_key->setFormValue($val);
            }
        }

        // Check field name 'app_version' first before field var 'x_app_version'
        $val = $CurrentForm->hasValue("app_version") ? $CurrentForm->getValue("app_version") : $CurrentForm->getValue("x_app_version");
        if (!$this->app_version->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->app_version->Visible = false; // Disable update for API request
            } else {
                $this->app_version->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pd_byepass' first before field var 'x_pd_byepass'
        $val = $CurrentForm->hasValue("pd_byepass") ? $CurrentForm->getValue("pd_byepass") : $CurrentForm->getValue("x_pd_byepass");
        if (!$this->pd_byepass->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pd_byepass->Visible = false; // Disable update for API request
            } else {
                $this->pd_byepass->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'google_map_api' first before field var 'x_google_map_api'
        $val = $CurrentForm->hasValue("google_map_api") ? $CurrentForm->getValue("google_map_api") : $CurrentForm->getValue("x_google_map_api");
        if (!$this->google_map_api->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->google_map_api->Visible = false; // Disable update for API request
            } else {
                $this->google_map_api->setFormValue($val);
            }
        }

        // Check field name 'material_payment_type' first before field var 'x_material_payment_type'
        $val = $CurrentForm->hasValue("material_payment_type") ? $CurrentForm->getValue("material_payment_type") : $CurrentForm->getValue("x_material_payment_type");
        if (!$this->material_payment_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->material_payment_type->Visible = false; // Disable update for API request
            } else {
                $this->material_payment_type->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'material_payment_varient' first before field var 'x_material_payment_varient'
        $val = $CurrentForm->hasValue("material_payment_varient") ? $CurrentForm->getValue("material_payment_varient") : $CurrentForm->getValue("x_material_payment_varient");
        if (!$this->material_payment_varient->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->material_payment_varient->Visible = false; // Disable update for API request
            } else {
                $this->material_payment_varient->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'footer_line_be' first before field var 'x_footer_line_be'
        $val = $CurrentForm->hasValue("footer_line_be") ? $CurrentForm->getValue("footer_line_be") : $CurrentForm->getValue("x_footer_line_be");
        if (!$this->footer_line_be->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->footer_line_be->Visible = false; // Disable update for API request
            } else {
                $this->footer_line_be->setFormValue($val);
            }
        }

        // Check field name 'allow_reg' first before field var 'x_allow_reg'
        $val = $CurrentForm->hasValue("allow_reg") ? $CurrentForm->getValue("allow_reg") : $CurrentForm->getValue("x_allow_reg");
        if (!$this->allow_reg->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->allow_reg->Visible = false; // Disable update for API request
            } else {
                $this->allow_reg->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'login_remember' first before field var 'x_login_remember'
        $val = $CurrentForm->hasValue("login_remember") ? $CurrentForm->getValue("login_remember") : $CurrentForm->getValue("x_login_remember");
        if (!$this->login_remember->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->login_remember->Visible = false; // Disable update for API request
            } else {
                $this->login_remember->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'gp_p_check' first before field var 'x_gp_p_check'
        $val = $CurrentForm->hasValue("gp_p_check") ? $CurrentForm->getValue("gp_p_check") : $CurrentForm->getValue("x_gp_p_check");
        if (!$this->gp_p_check->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gp_p_check->Visible = false; // Disable update for API request
            } else {
                $this->gp_p_check->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'fe_version' first before field var 'x_fe_version'
        $val = $CurrentForm->hasValue("fe_version") ? $CurrentForm->getValue("fe_version") : $CurrentForm->getValue("x_fe_version");
        if (!$this->fe_version->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->fe_version->Visible = false; // Disable update for API request
            } else {
                $this->fe_version->setFormValue($val);
            }
        }

        // Check field name 'admin_version' first before field var 'x_admin_version'
        $val = $CurrentForm->hasValue("admin_version") ? $CurrentForm->getValue("admin_version") : $CurrentForm->getValue("x_admin_version");
        if (!$this->admin_version->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->admin_version->Visible = false; // Disable update for API request
            } else {
                $this->admin_version->setFormValue($val);
            }
        }

        // Check field name 'dashboard' first before field var 'x__dashboard'
        $val = $CurrentForm->hasValue("dashboard") ? $CurrentForm->getValue("dashboard") : $CurrentForm->getValue("x__dashboard");
        if (!$this->_dashboard->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_dashboard->Visible = false; // Disable update for API request
            } else {
                $this->_dashboard->setFormValue($val);
            }
        }

        // Check field name 'developer_upi_id' first before field var 'x_developer_upi_id'
        $val = $CurrentForm->hasValue("developer_upi_id") ? $CurrentForm->getValue("developer_upi_id") : $CurrentForm->getValue("x_developer_upi_id");
        if (!$this->developer_upi_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->developer_upi_id->Visible = false; // Disable update for API request
            } else {
                $this->developer_upi_id->setFormValue($val);
            }
        }

        // Check field name 'developer_company' first before field var 'x_developer_company'
        $val = $CurrentForm->hasValue("developer_company") ? $CurrentForm->getValue("developer_company") : $CurrentForm->getValue("x_developer_company");
        if (!$this->developer_company->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->developer_company->Visible = false; // Disable update for API request
            } else {
                $this->developer_company->setFormValue($val);
            }
        }

        // Check field name 'default_page' first before field var 'x_default_page'
        $val = $CurrentForm->hasValue("default_page") ? $CurrentForm->getValue("default_page") : $CurrentForm->getValue("x_default_page");
        if (!$this->default_page->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->default_page->Visible = false; // Disable update for API request
            } else {
                $this->default_page->setFormValue($val);
            }
        }

        // Check field name 'bom_edit' first before field var 'x_bom_edit'
        $val = $CurrentForm->hasValue("bom_edit") ? $CurrentForm->getValue("bom_edit") : $CurrentForm->getValue("x_bom_edit");
        if (!$this->bom_edit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bom_edit->Visible = false; // Disable update for API request
            } else {
                $this->bom_edit->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->url->CurrentValue = $this->url->FormValue;
        $this->admin_url->CurrentValue = $this->admin_url->FormValue;
        $this->mail_code->CurrentValue = $this->mail_code->FormValue;
        $this->footer_line->CurrentValue = $this->footer_line->FormValue;
        $this->portal_category->CurrentValue = $this->portal_category->FormValue;
        $this->mcu->CurrentValue = $this->mcu->FormValue;
        $this->fcm_server_key->CurrentValue = $this->fcm_server_key->FormValue;
        $this->app_version->CurrentValue = $this->app_version->FormValue;
        $this->pd_byepass->CurrentValue = $this->pd_byepass->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->google_map_api->CurrentValue = $this->google_map_api->FormValue;
        $this->material_payment_type->CurrentValue = $this->material_payment_type->FormValue;
        $this->material_payment_varient->CurrentValue = $this->material_payment_varient->FormValue;
        $this->footer_line_be->CurrentValue = $this->footer_line_be->FormValue;
        $this->allow_reg->CurrentValue = $this->allow_reg->FormValue;
        $this->login_remember->CurrentValue = $this->login_remember->FormValue;
        $this->gp_p_check->CurrentValue = $this->gp_p_check->FormValue;
        $this->fe_version->CurrentValue = $this->fe_version->FormValue;
        $this->admin_version->CurrentValue = $this->admin_version->FormValue;
        $this->_dashboard->CurrentValue = $this->_dashboard->FormValue;
        $this->developer_upi_id->CurrentValue = $this->developer_upi_id->FormValue;
        $this->developer_company->CurrentValue = $this->developer_company->FormValue;
        $this->default_page->CurrentValue = $this->default_page->FormValue;
        $this->bom_edit->CurrentValue = $this->bom_edit->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->url->setDbValue($row['url']);
        $this->admin_url->setDbValue($row['admin_url']);
        $this->mail_code->setDbValue($row['mail_code']);
        $this->footer_line->setDbValue($row['footer_line']);
        $this->portal_category->setDbValue($row['portal_category']);
        $this->mcu->setDbValue($row['mcu']);
        $this->fcm_server_key->setDbValue($row['fcm_server_key']);
        $this->app_version->setDbValue($row['app_version']);
        $this->pd_byepass->setDbValue($row['pd_byepass']);
        $this->operator->setDbValue($row['operator']);
        $this->google_map_api->setDbValue($row['google_map_api']);
        $this->material_payment_type->setDbValue($row['material_payment_type']);
        $this->material_payment_varient->setDbValue($row['material_payment_varient']);
        $this->footer_line_be->setDbValue($row['footer_line_be']);
        $this->allow_reg->setDbValue($row['allow_reg']);
        $this->login_remember->setDbValue($row['login_remember']);
        $this->gp_p_check->setDbValue($row['gp_p_check']);
        $this->fe_version->setDbValue($row['fe_version']);
        $this->admin_version->setDbValue($row['admin_version']);
        $this->_dashboard->setDbValue($row['dashboard']);
        $this->developer_upi_id->setDbValue($row['developer_upi_id']);
        $this->developer_company->setDbValue($row['developer_company']);
        $this->default_page->setDbValue($row['default_page']);
        $this->bom_edit->setDbValue($row['bom_edit']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['url'] = $this->url->DefaultValue;
        $row['admin_url'] = $this->admin_url->DefaultValue;
        $row['mail_code'] = $this->mail_code->DefaultValue;
        $row['footer_line'] = $this->footer_line->DefaultValue;
        $row['portal_category'] = $this->portal_category->DefaultValue;
        $row['mcu'] = $this->mcu->DefaultValue;
        $row['fcm_server_key'] = $this->fcm_server_key->DefaultValue;
        $row['app_version'] = $this->app_version->DefaultValue;
        $row['pd_byepass'] = $this->pd_byepass->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['google_map_api'] = $this->google_map_api->DefaultValue;
        $row['material_payment_type'] = $this->material_payment_type->DefaultValue;
        $row['material_payment_varient'] = $this->material_payment_varient->DefaultValue;
        $row['footer_line_be'] = $this->footer_line_be->DefaultValue;
        $row['allow_reg'] = $this->allow_reg->DefaultValue;
        $row['login_remember'] = $this->login_remember->DefaultValue;
        $row['gp_p_check'] = $this->gp_p_check->DefaultValue;
        $row['fe_version'] = $this->fe_version->DefaultValue;
        $row['admin_version'] = $this->admin_version->DefaultValue;
        $row['dashboard'] = $this->_dashboard->DefaultValue;
        $row['developer_upi_id'] = $this->developer_upi_id->DefaultValue;
        $row['developer_company'] = $this->developer_company->DefaultValue;
        $row['default_page'] = $this->default_page->DefaultValue;
        $row['bom_edit'] = $this->bom_edit->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // url
        $this->url->RowCssClass = "row";

        // admin_url
        $this->admin_url->RowCssClass = "row";

        // mail_code
        $this->mail_code->RowCssClass = "row";

        // footer_line
        $this->footer_line->RowCssClass = "row";

        // portal_category
        $this->portal_category->RowCssClass = "row";

        // mcu
        $this->mcu->RowCssClass = "row";

        // fcm_server_key
        $this->fcm_server_key->RowCssClass = "row";

        // app_version
        $this->app_version->RowCssClass = "row";

        // pd_byepass
        $this->pd_byepass->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // google_map_api
        $this->google_map_api->RowCssClass = "row";

        // material_payment_type
        $this->material_payment_type->RowCssClass = "row";

        // material_payment_varient
        $this->material_payment_varient->RowCssClass = "row";

        // footer_line_be
        $this->footer_line_be->RowCssClass = "row";

        // allow_reg
        $this->allow_reg->RowCssClass = "row";

        // login_remember
        $this->login_remember->RowCssClass = "row";

        // gp_p_check
        $this->gp_p_check->RowCssClass = "row";

        // fe_version
        $this->fe_version->RowCssClass = "row";

        // admin_version
        $this->admin_version->RowCssClass = "row";

        // dashboard
        $this->_dashboard->RowCssClass = "row";

        // developer_upi_id
        $this->developer_upi_id->RowCssClass = "row";

        // developer_company
        $this->developer_company->RowCssClass = "row";

        // default_page
        $this->default_page->RowCssClass = "row";

        // bom_edit
        $this->bom_edit->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // url
            $this->url->ViewValue = $this->url->CurrentValue;

            // admin_url
            $this->admin_url->ViewValue = $this->admin_url->CurrentValue;

            // mail_code
            $this->mail_code->ViewValue = $this->mail_code->CurrentValue;

            // footer_line
            $this->footer_line->ViewValue = $this->footer_line->CurrentValue;

            // portal_category
            $curVal = strval($this->portal_category->CurrentValue);
            if ($curVal != "") {
                $this->portal_category->ViewValue = $this->portal_category->lookupCacheOption($curVal);
                if ($this->portal_category->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->portal_category->Lookup->getTable()->Fields["category"]->searchExpression(), "=", trim($wrk), $this->portal_category->Lookup->getTable()->Fields["category"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->portal_category->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->portal_category->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->portal_category->Lookup->renderViewRow($row);
                            $this->portal_category->ViewValue->add($this->portal_category->displayValue($arwrk));
                        }
                    } else {
                        $this->portal_category->ViewValue = $this->portal_category->CurrentValue;
                    }
                }
            } else {
                $this->portal_category->ViewValue = null;
            }

            // mcu
            $this->mcu->ViewValue = $this->mcu->CurrentValue;
            $this->mcu->ViewValue = FormatNumber($this->mcu->ViewValue, $this->mcu->formatPattern());

            // fcm_server_key
            $this->fcm_server_key->ViewValue = $this->fcm_server_key->CurrentValue;

            // app_version
            $this->app_version->ViewValue = $this->app_version->CurrentValue;
            $this->app_version->ViewValue = FormatNumber($this->app_version->ViewValue, $this->app_version->formatPattern());

            // pd_byepass
            if (strval($this->pd_byepass->CurrentValue) != "") {
                $this->pd_byepass->ViewValue = $this->pd_byepass->optionCaption($this->pd_byepass->CurrentValue);
            } else {
                $this->pd_byepass->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // google_map_api
            $this->google_map_api->ViewValue = $this->google_map_api->CurrentValue;

            // material_payment_type
            $this->material_payment_type->ViewValue = $this->material_payment_type->CurrentValue;
            $this->material_payment_type->ViewValue = FormatNumber($this->material_payment_type->ViewValue, $this->material_payment_type->formatPattern());

            // material_payment_varient
            $this->material_payment_varient->ViewValue = $this->material_payment_varient->CurrentValue;
            $this->material_payment_varient->ViewValue = FormatNumber($this->material_payment_varient->ViewValue, $this->material_payment_varient->formatPattern());

            // footer_line_be
            $this->footer_line_be->ViewValue = $this->footer_line_be->CurrentValue;

            // allow_reg
            $this->allow_reg->ViewValue = $this->allow_reg->CurrentValue;
            $this->allow_reg->ViewValue = FormatNumber($this->allow_reg->ViewValue, $this->allow_reg->formatPattern());

            // login_remember
            $this->login_remember->ViewValue = $this->login_remember->CurrentValue;
            $this->login_remember->ViewValue = FormatNumber($this->login_remember->ViewValue, $this->login_remember->formatPattern());

            // gp_p_check
            $this->gp_p_check->ViewValue = $this->gp_p_check->CurrentValue;
            $this->gp_p_check->ViewValue = FormatNumber($this->gp_p_check->ViewValue, $this->gp_p_check->formatPattern());

            // fe_version
            $this->fe_version->ViewValue = $this->fe_version->CurrentValue;

            // admin_version
            $this->admin_version->ViewValue = $this->admin_version->CurrentValue;

            // dashboard
            if (strval($this->_dashboard->CurrentValue) != "") {
                $this->_dashboard->ViewValue = $this->_dashboard->optionCaption($this->_dashboard->CurrentValue);
            } else {
                $this->_dashboard->ViewValue = null;
            }

            // developer_upi_id
            $this->developer_upi_id->ViewValue = $this->developer_upi_id->CurrentValue;

            // developer_company
            $this->developer_company->ViewValue = $this->developer_company->CurrentValue;

            // default_page
            $this->default_page->ViewValue = $this->default_page->CurrentValue;

            // bom_edit
            $this->bom_edit->ViewValue = $this->bom_edit->CurrentValue;

            // id
            $this->id->HrefValue = "";

            // url
            $this->url->HrefValue = "";

            // admin_url
            $this->admin_url->HrefValue = "";

            // mail_code
            $this->mail_code->HrefValue = "";

            // footer_line
            $this->footer_line->HrefValue = "";

            // portal_category
            $this->portal_category->HrefValue = "";

            // mcu
            $this->mcu->HrefValue = "";

            // fcm_server_key
            $this->fcm_server_key->HrefValue = "";

            // app_version
            $this->app_version->HrefValue = "";

            // pd_byepass
            $this->pd_byepass->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // google_map_api
            $this->google_map_api->HrefValue = "";

            // material_payment_type
            $this->material_payment_type->HrefValue = "";

            // material_payment_varient
            $this->material_payment_varient->HrefValue = "";

            // footer_line_be
            $this->footer_line_be->HrefValue = "";

            // allow_reg
            $this->allow_reg->HrefValue = "";

            // login_remember
            $this->login_remember->HrefValue = "";

            // gp_p_check
            $this->gp_p_check->HrefValue = "";

            // fe_version
            $this->fe_version->HrefValue = "";

            // admin_version
            $this->admin_version->HrefValue = "";

            // dashboard
            $this->_dashboard->HrefValue = "";

            // developer_upi_id
            $this->developer_upi_id->HrefValue = "";

            // developer_company
            $this->developer_company->HrefValue = "";

            // default_page
            $this->default_page->HrefValue = "";

            // bom_edit
            $this->bom_edit->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // url
            $this->url->setupEditAttributes();
            if (!$this->url->Raw) {
                $this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
            }
            $this->url->EditValue = HtmlEncode($this->url->CurrentValue);
            $this->url->PlaceHolder = RemoveHtml($this->url->caption());

            // admin_url
            $this->admin_url->setupEditAttributes();
            if (!$this->admin_url->Raw) {
                $this->admin_url->CurrentValue = HtmlDecode($this->admin_url->CurrentValue);
            }
            $this->admin_url->EditValue = HtmlEncode($this->admin_url->CurrentValue);
            $this->admin_url->PlaceHolder = RemoveHtml($this->admin_url->caption());

            // mail_code
            $this->mail_code->setupEditAttributes();
            $this->mail_code->EditValue = HtmlEncode($this->mail_code->CurrentValue);
            $this->mail_code->PlaceHolder = RemoveHtml($this->mail_code->caption());

            // footer_line
            $this->footer_line->setupEditAttributes();
            $this->footer_line->EditValue = HtmlEncode($this->footer_line->CurrentValue);
            $this->footer_line->PlaceHolder = RemoveHtml($this->footer_line->caption());

            // portal_category
            $curVal = trim(strval($this->portal_category->CurrentValue));
            if ($curVal != "") {
                $this->portal_category->ViewValue = $this->portal_category->lookupCacheOption($curVal);
            } else {
                $this->portal_category->ViewValue = $this->portal_category->Lookup !== null && is_array($this->portal_category->lookupOptions()) && count($this->portal_category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->portal_category->ViewValue !== null) { // Load from cache
                $this->portal_category->EditValue = array_values($this->portal_category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->portal_category->Lookup->getTable()->Fields["category"]->searchExpression(), "=", trim($wrk), $this->portal_category->Lookup->getTable()->Fields["category"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->portal_category->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->portal_category->EditValue = $arwrk;
            }
            $this->portal_category->PlaceHolder = RemoveHtml($this->portal_category->caption());

            // mcu
            $this->mcu->setupEditAttributes();
            $this->mcu->EditValue = $this->mcu->CurrentValue;
            $this->mcu->PlaceHolder = RemoveHtml($this->mcu->caption());
            if (strval($this->mcu->EditValue) != "" && is_numeric($this->mcu->EditValue)) {
                $this->mcu->EditValue = FormatNumber($this->mcu->EditValue, null);
            }

            // fcm_server_key
            $this->fcm_server_key->setupEditAttributes();
            if (!$this->fcm_server_key->Raw) {
                $this->fcm_server_key->CurrentValue = HtmlDecode($this->fcm_server_key->CurrentValue);
            }
            $this->fcm_server_key->EditValue = HtmlEncode($this->fcm_server_key->CurrentValue);
            $this->fcm_server_key->PlaceHolder = RemoveHtml($this->fcm_server_key->caption());

            // app_version
            $this->app_version->setupEditAttributes();
            $this->app_version->EditValue = $this->app_version->CurrentValue;
            $this->app_version->PlaceHolder = RemoveHtml($this->app_version->caption());
            if (strval($this->app_version->EditValue) != "" && is_numeric($this->app_version->EditValue)) {
                $this->app_version->EditValue = FormatNumber($this->app_version->EditValue, null);
            }

            // pd_byepass
            $this->pd_byepass->setupEditAttributes();
            $this->pd_byepass->EditValue = $this->pd_byepass->options(true);
            $this->pd_byepass->PlaceHolder = RemoveHtml($this->pd_byepass->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->CurrentValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());
            if (strval($this->operator->EditValue) != "" && is_numeric($this->operator->EditValue)) {
                $this->operator->EditValue = FormatNumber($this->operator->EditValue, null);
            }

            // google_map_api
            $this->google_map_api->setupEditAttributes();
            if (!$this->google_map_api->Raw) {
                $this->google_map_api->CurrentValue = HtmlDecode($this->google_map_api->CurrentValue);
            }
            $this->google_map_api->EditValue = HtmlEncode($this->google_map_api->CurrentValue);
            $this->google_map_api->PlaceHolder = RemoveHtml($this->google_map_api->caption());

            // material_payment_type
            $this->material_payment_type->setupEditAttributes();
            $this->material_payment_type->EditValue = $this->material_payment_type->CurrentValue;
            $this->material_payment_type->PlaceHolder = RemoveHtml($this->material_payment_type->caption());
            if (strval($this->material_payment_type->EditValue) != "" && is_numeric($this->material_payment_type->EditValue)) {
                $this->material_payment_type->EditValue = FormatNumber($this->material_payment_type->EditValue, null);
            }

            // material_payment_varient
            $this->material_payment_varient->setupEditAttributes();
            $this->material_payment_varient->EditValue = $this->material_payment_varient->CurrentValue;
            $this->material_payment_varient->PlaceHolder = RemoveHtml($this->material_payment_varient->caption());
            if (strval($this->material_payment_varient->EditValue) != "" && is_numeric($this->material_payment_varient->EditValue)) {
                $this->material_payment_varient->EditValue = FormatNumber($this->material_payment_varient->EditValue, null);
            }

            // footer_line_be
            $this->footer_line_be->setupEditAttributes();
            if (!$this->footer_line_be->Raw) {
                $this->footer_line_be->CurrentValue = HtmlDecode($this->footer_line_be->CurrentValue);
            }
            $this->footer_line_be->EditValue = HtmlEncode($this->footer_line_be->CurrentValue);
            $this->footer_line_be->PlaceHolder = RemoveHtml($this->footer_line_be->caption());

            // allow_reg
            $this->allow_reg->setupEditAttributes();
            $this->allow_reg->EditValue = $this->allow_reg->CurrentValue;
            $this->allow_reg->PlaceHolder = RemoveHtml($this->allow_reg->caption());
            if (strval($this->allow_reg->EditValue) != "" && is_numeric($this->allow_reg->EditValue)) {
                $this->allow_reg->EditValue = FormatNumber($this->allow_reg->EditValue, null);
            }

            // login_remember
            $this->login_remember->setupEditAttributes();
            $this->login_remember->EditValue = $this->login_remember->CurrentValue;
            $this->login_remember->PlaceHolder = RemoveHtml($this->login_remember->caption());
            if (strval($this->login_remember->EditValue) != "" && is_numeric($this->login_remember->EditValue)) {
                $this->login_remember->EditValue = FormatNumber($this->login_remember->EditValue, null);
            }

            // gp_p_check
            $this->gp_p_check->setupEditAttributes();
            $this->gp_p_check->EditValue = $this->gp_p_check->CurrentValue;
            $this->gp_p_check->PlaceHolder = RemoveHtml($this->gp_p_check->caption());
            if (strval($this->gp_p_check->EditValue) != "" && is_numeric($this->gp_p_check->EditValue)) {
                $this->gp_p_check->EditValue = FormatNumber($this->gp_p_check->EditValue, null);
            }

            // fe_version
            $this->fe_version->setupEditAttributes();
            if (!$this->fe_version->Raw) {
                $this->fe_version->CurrentValue = HtmlDecode($this->fe_version->CurrentValue);
            }
            $this->fe_version->EditValue = HtmlEncode($this->fe_version->CurrentValue);
            $this->fe_version->PlaceHolder = RemoveHtml($this->fe_version->caption());

            // admin_version
            $this->admin_version->setupEditAttributes();
            if (!$this->admin_version->Raw) {
                $this->admin_version->CurrentValue = HtmlDecode($this->admin_version->CurrentValue);
            }
            $this->admin_version->EditValue = HtmlEncode($this->admin_version->CurrentValue);
            $this->admin_version->PlaceHolder = RemoveHtml($this->admin_version->caption());

            // dashboard
            $this->_dashboard->setupEditAttributes();
            $this->_dashboard->EditValue = $this->_dashboard->options(true);
            $this->_dashboard->PlaceHolder = RemoveHtml($this->_dashboard->caption());

            // developer_upi_id
            $this->developer_upi_id->setupEditAttributes();
            if (!$this->developer_upi_id->Raw) {
                $this->developer_upi_id->CurrentValue = HtmlDecode($this->developer_upi_id->CurrentValue);
            }
            $this->developer_upi_id->EditValue = HtmlEncode($this->developer_upi_id->CurrentValue);
            $this->developer_upi_id->PlaceHolder = RemoveHtml($this->developer_upi_id->caption());

            // developer_company
            $this->developer_company->setupEditAttributes();
            if (!$this->developer_company->Raw) {
                $this->developer_company->CurrentValue = HtmlDecode($this->developer_company->CurrentValue);
            }
            $this->developer_company->EditValue = HtmlEncode($this->developer_company->CurrentValue);
            $this->developer_company->PlaceHolder = RemoveHtml($this->developer_company->caption());

            // default_page
            $this->default_page->setupEditAttributes();
            if (!$this->default_page->Raw) {
                $this->default_page->CurrentValue = HtmlDecode($this->default_page->CurrentValue);
            }
            $this->default_page->EditValue = HtmlEncode($this->default_page->CurrentValue);
            $this->default_page->PlaceHolder = RemoveHtml($this->default_page->caption());

            // bom_edit
            $this->bom_edit->setupEditAttributes();
            if (!$this->bom_edit->Raw) {
                $this->bom_edit->CurrentValue = HtmlDecode($this->bom_edit->CurrentValue);
            }
            $this->bom_edit->EditValue = HtmlEncode($this->bom_edit->CurrentValue);
            $this->bom_edit->PlaceHolder = RemoveHtml($this->bom_edit->caption());

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // url
            $this->url->HrefValue = "";

            // admin_url
            $this->admin_url->HrefValue = "";

            // mail_code
            $this->mail_code->HrefValue = "";

            // footer_line
            $this->footer_line->HrefValue = "";

            // portal_category
            $this->portal_category->HrefValue = "";

            // mcu
            $this->mcu->HrefValue = "";

            // fcm_server_key
            $this->fcm_server_key->HrefValue = "";

            // app_version
            $this->app_version->HrefValue = "";

            // pd_byepass
            $this->pd_byepass->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // google_map_api
            $this->google_map_api->HrefValue = "";

            // material_payment_type
            $this->material_payment_type->HrefValue = "";

            // material_payment_varient
            $this->material_payment_varient->HrefValue = "";

            // footer_line_be
            $this->footer_line_be->HrefValue = "";

            // allow_reg
            $this->allow_reg->HrefValue = "";

            // login_remember
            $this->login_remember->HrefValue = "";

            // gp_p_check
            $this->gp_p_check->HrefValue = "";

            // fe_version
            $this->fe_version->HrefValue = "";

            // admin_version
            $this->admin_version->HrefValue = "";

            // dashboard
            $this->_dashboard->HrefValue = "";

            // developer_upi_id
            $this->developer_upi_id->HrefValue = "";

            // developer_company
            $this->developer_company->HrefValue = "";

            // default_page
            $this->default_page->HrefValue = "";

            // bom_edit
            $this->bom_edit->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->url->Visible && $this->url->Required) {
                if (!$this->url->IsDetailKey && EmptyValue($this->url->FormValue)) {
                    $this->url->addErrorMessage(str_replace("%s", $this->url->caption(), $this->url->RequiredErrorMessage));
                }
            }
            if ($this->admin_url->Visible && $this->admin_url->Required) {
                if (!$this->admin_url->IsDetailKey && EmptyValue($this->admin_url->FormValue)) {
                    $this->admin_url->addErrorMessage(str_replace("%s", $this->admin_url->caption(), $this->admin_url->RequiredErrorMessage));
                }
            }
            if ($this->mail_code->Visible && $this->mail_code->Required) {
                if (!$this->mail_code->IsDetailKey && EmptyValue($this->mail_code->FormValue)) {
                    $this->mail_code->addErrorMessage(str_replace("%s", $this->mail_code->caption(), $this->mail_code->RequiredErrorMessage));
                }
            }
            if ($this->footer_line->Visible && $this->footer_line->Required) {
                if (!$this->footer_line->IsDetailKey && EmptyValue($this->footer_line->FormValue)) {
                    $this->footer_line->addErrorMessage(str_replace("%s", $this->footer_line->caption(), $this->footer_line->RequiredErrorMessage));
                }
            }
            if ($this->portal_category->Visible && $this->portal_category->Required) {
                if ($this->portal_category->FormValue == "") {
                    $this->portal_category->addErrorMessage(str_replace("%s", $this->portal_category->caption(), $this->portal_category->RequiredErrorMessage));
                }
            }
            if ($this->mcu->Visible && $this->mcu->Required) {
                if (!$this->mcu->IsDetailKey && EmptyValue($this->mcu->FormValue)) {
                    $this->mcu->addErrorMessage(str_replace("%s", $this->mcu->caption(), $this->mcu->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->mcu->FormValue)) {
                $this->mcu->addErrorMessage($this->mcu->getErrorMessage(false));
            }
            if ($this->fcm_server_key->Visible && $this->fcm_server_key->Required) {
                if (!$this->fcm_server_key->IsDetailKey && EmptyValue($this->fcm_server_key->FormValue)) {
                    $this->fcm_server_key->addErrorMessage(str_replace("%s", $this->fcm_server_key->caption(), $this->fcm_server_key->RequiredErrorMessage));
                }
            }
            if ($this->app_version->Visible && $this->app_version->Required) {
                if (!$this->app_version->IsDetailKey && EmptyValue($this->app_version->FormValue)) {
                    $this->app_version->addErrorMessage(str_replace("%s", $this->app_version->caption(), $this->app_version->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->app_version->FormValue)) {
                $this->app_version->addErrorMessage($this->app_version->getErrorMessage(false));
            }
            if ($this->pd_byepass->Visible && $this->pd_byepass->Required) {
                if (!$this->pd_byepass->IsDetailKey && EmptyValue($this->pd_byepass->FormValue)) {
                    $this->pd_byepass->addErrorMessage(str_replace("%s", $this->pd_byepass->caption(), $this->pd_byepass->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->operator->FormValue)) {
                $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
            }
            if ($this->google_map_api->Visible && $this->google_map_api->Required) {
                if (!$this->google_map_api->IsDetailKey && EmptyValue($this->google_map_api->FormValue)) {
                    $this->google_map_api->addErrorMessage(str_replace("%s", $this->google_map_api->caption(), $this->google_map_api->RequiredErrorMessage));
                }
            }
            if ($this->material_payment_type->Visible && $this->material_payment_type->Required) {
                if (!$this->material_payment_type->IsDetailKey && EmptyValue($this->material_payment_type->FormValue)) {
                    $this->material_payment_type->addErrorMessage(str_replace("%s", $this->material_payment_type->caption(), $this->material_payment_type->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->material_payment_type->FormValue)) {
                $this->material_payment_type->addErrorMessage($this->material_payment_type->getErrorMessage(false));
            }
            if ($this->material_payment_varient->Visible && $this->material_payment_varient->Required) {
                if (!$this->material_payment_varient->IsDetailKey && EmptyValue($this->material_payment_varient->FormValue)) {
                    $this->material_payment_varient->addErrorMessage(str_replace("%s", $this->material_payment_varient->caption(), $this->material_payment_varient->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->material_payment_varient->FormValue)) {
                $this->material_payment_varient->addErrorMessage($this->material_payment_varient->getErrorMessage(false));
            }
            if ($this->footer_line_be->Visible && $this->footer_line_be->Required) {
                if (!$this->footer_line_be->IsDetailKey && EmptyValue($this->footer_line_be->FormValue)) {
                    $this->footer_line_be->addErrorMessage(str_replace("%s", $this->footer_line_be->caption(), $this->footer_line_be->RequiredErrorMessage));
                }
            }
            if ($this->allow_reg->Visible && $this->allow_reg->Required) {
                if (!$this->allow_reg->IsDetailKey && EmptyValue($this->allow_reg->FormValue)) {
                    $this->allow_reg->addErrorMessage(str_replace("%s", $this->allow_reg->caption(), $this->allow_reg->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->allow_reg->FormValue)) {
                $this->allow_reg->addErrorMessage($this->allow_reg->getErrorMessage(false));
            }
            if ($this->login_remember->Visible && $this->login_remember->Required) {
                if (!$this->login_remember->IsDetailKey && EmptyValue($this->login_remember->FormValue)) {
                    $this->login_remember->addErrorMessage(str_replace("%s", $this->login_remember->caption(), $this->login_remember->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->login_remember->FormValue)) {
                $this->login_remember->addErrorMessage($this->login_remember->getErrorMessage(false));
            }
            if ($this->gp_p_check->Visible && $this->gp_p_check->Required) {
                if (!$this->gp_p_check->IsDetailKey && EmptyValue($this->gp_p_check->FormValue)) {
                    $this->gp_p_check->addErrorMessage(str_replace("%s", $this->gp_p_check->caption(), $this->gp_p_check->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->gp_p_check->FormValue)) {
                $this->gp_p_check->addErrorMessage($this->gp_p_check->getErrorMessage(false));
            }
            if ($this->fe_version->Visible && $this->fe_version->Required) {
                if (!$this->fe_version->IsDetailKey && EmptyValue($this->fe_version->FormValue)) {
                    $this->fe_version->addErrorMessage(str_replace("%s", $this->fe_version->caption(), $this->fe_version->RequiredErrorMessage));
                }
            }
            if ($this->admin_version->Visible && $this->admin_version->Required) {
                if (!$this->admin_version->IsDetailKey && EmptyValue($this->admin_version->FormValue)) {
                    $this->admin_version->addErrorMessage(str_replace("%s", $this->admin_version->caption(), $this->admin_version->RequiredErrorMessage));
                }
            }
            if ($this->_dashboard->Visible && $this->_dashboard->Required) {
                if (!$this->_dashboard->IsDetailKey && EmptyValue($this->_dashboard->FormValue)) {
                    $this->_dashboard->addErrorMessage(str_replace("%s", $this->_dashboard->caption(), $this->_dashboard->RequiredErrorMessage));
                }
            }
            if ($this->developer_upi_id->Visible && $this->developer_upi_id->Required) {
                if (!$this->developer_upi_id->IsDetailKey && EmptyValue($this->developer_upi_id->FormValue)) {
                    $this->developer_upi_id->addErrorMessage(str_replace("%s", $this->developer_upi_id->caption(), $this->developer_upi_id->RequiredErrorMessage));
                }
            }
            if ($this->developer_company->Visible && $this->developer_company->Required) {
                if (!$this->developer_company->IsDetailKey && EmptyValue($this->developer_company->FormValue)) {
                    $this->developer_company->addErrorMessage(str_replace("%s", $this->developer_company->caption(), $this->developer_company->RequiredErrorMessage));
                }
            }
            if ($this->default_page->Visible && $this->default_page->Required) {
                if (!$this->default_page->IsDetailKey && EmptyValue($this->default_page->FormValue)) {
                    $this->default_page->addErrorMessage(str_replace("%s", $this->default_page->caption(), $this->default_page->RequiredErrorMessage));
                }
            }
            if ($this->bom_edit->Visible && $this->bom_edit->Required) {
                if (!$this->bom_edit->IsDetailKey && EmptyValue($this->bom_edit->FormValue)) {
                    $this->bom_edit->addErrorMessage(str_replace("%s", $this->bom_edit->caption(), $this->bom_edit->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // url
        $this->url->setDbValueDef($rsnew, $this->url->CurrentValue, $this->url->ReadOnly);

        // admin_url
        $this->admin_url->setDbValueDef($rsnew, $this->admin_url->CurrentValue, $this->admin_url->ReadOnly);

        // mail_code
        $this->mail_code->setDbValueDef($rsnew, $this->mail_code->CurrentValue, $this->mail_code->ReadOnly);

        // footer_line
        $this->footer_line->setDbValueDef($rsnew, $this->footer_line->CurrentValue, $this->footer_line->ReadOnly);

        // portal_category
        $this->portal_category->setDbValueDef($rsnew, $this->portal_category->CurrentValue, $this->portal_category->ReadOnly);

        // mcu
        $this->mcu->setDbValueDef($rsnew, $this->mcu->CurrentValue, $this->mcu->ReadOnly);

        // fcm_server_key
        $this->fcm_server_key->setDbValueDef($rsnew, $this->fcm_server_key->CurrentValue, $this->fcm_server_key->ReadOnly);

        // app_version
        $this->app_version->setDbValueDef($rsnew, $this->app_version->CurrentValue, $this->app_version->ReadOnly);

        // pd_byepass
        $this->pd_byepass->setDbValueDef($rsnew, $this->pd_byepass->CurrentValue, $this->pd_byepass->ReadOnly);

        // operator
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // google_map_api
        $this->google_map_api->setDbValueDef($rsnew, $this->google_map_api->CurrentValue, $this->google_map_api->ReadOnly);

        // material_payment_type
        $this->material_payment_type->setDbValueDef($rsnew, $this->material_payment_type->CurrentValue, $this->material_payment_type->ReadOnly);

        // material_payment_varient
        $this->material_payment_varient->setDbValueDef($rsnew, $this->material_payment_varient->CurrentValue, $this->material_payment_varient->ReadOnly);

        // footer_line_be
        $this->footer_line_be->setDbValueDef($rsnew, $this->footer_line_be->CurrentValue, $this->footer_line_be->ReadOnly);

        // allow_reg
        $this->allow_reg->setDbValueDef($rsnew, $this->allow_reg->CurrentValue, $this->allow_reg->ReadOnly);

        // login_remember
        $this->login_remember->setDbValueDef($rsnew, $this->login_remember->CurrentValue, $this->login_remember->ReadOnly);

        // gp_p_check
        $this->gp_p_check->setDbValueDef($rsnew, $this->gp_p_check->CurrentValue, $this->gp_p_check->ReadOnly);

        // fe_version
        $this->fe_version->setDbValueDef($rsnew, $this->fe_version->CurrentValue, $this->fe_version->ReadOnly);

        // admin_version
        $this->admin_version->setDbValueDef($rsnew, $this->admin_version->CurrentValue, $this->admin_version->ReadOnly);

        // dashboard
        $this->_dashboard->setDbValueDef($rsnew, $this->_dashboard->CurrentValue, $this->_dashboard->ReadOnly);

        // developer_upi_id
        $this->developer_upi_id->setDbValueDef($rsnew, $this->developer_upi_id->CurrentValue, $this->developer_upi_id->ReadOnly);

        // developer_company
        $this->developer_company->setDbValueDef($rsnew, $this->developer_company->CurrentValue, $this->developer_company->ReadOnly);

        // default_page
        $this->default_page->setDbValueDef($rsnew, $this->default_page->CurrentValue, $this->default_page->ReadOnly);

        // bom_edit
        $this->bom_edit->setDbValueDef($rsnew, $this->bom_edit->CurrentValue, $this->bom_edit->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['url'])) { // url
            $this->url->CurrentValue = $row['url'];
        }
        if (isset($row['admin_url'])) { // admin_url
            $this->admin_url->CurrentValue = $row['admin_url'];
        }
        if (isset($row['mail_code'])) { // mail_code
            $this->mail_code->CurrentValue = $row['mail_code'];
        }
        if (isset($row['footer_line'])) { // footer_line
            $this->footer_line->CurrentValue = $row['footer_line'];
        }
        if (isset($row['portal_category'])) { // portal_category
            $this->portal_category->CurrentValue = $row['portal_category'];
        }
        if (isset($row['mcu'])) { // mcu
            $this->mcu->CurrentValue = $row['mcu'];
        }
        if (isset($row['fcm_server_key'])) { // fcm_server_key
            $this->fcm_server_key->CurrentValue = $row['fcm_server_key'];
        }
        if (isset($row['app_version'])) { // app_version
            $this->app_version->CurrentValue = $row['app_version'];
        }
        if (isset($row['pd_byepass'])) { // pd_byepass
            $this->pd_byepass->CurrentValue = $row['pd_byepass'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['google_map_api'])) { // google_map_api
            $this->google_map_api->CurrentValue = $row['google_map_api'];
        }
        if (isset($row['material_payment_type'])) { // material_payment_type
            $this->material_payment_type->CurrentValue = $row['material_payment_type'];
        }
        if (isset($row['material_payment_varient'])) { // material_payment_varient
            $this->material_payment_varient->CurrentValue = $row['material_payment_varient'];
        }
        if (isset($row['footer_line_be'])) { // footer_line_be
            $this->footer_line_be->CurrentValue = $row['footer_line_be'];
        }
        if (isset($row['allow_reg'])) { // allow_reg
            $this->allow_reg->CurrentValue = $row['allow_reg'];
        }
        if (isset($row['login_remember'])) { // login_remember
            $this->login_remember->CurrentValue = $row['login_remember'];
        }
        if (isset($row['gp_p_check'])) { // gp_p_check
            $this->gp_p_check->CurrentValue = $row['gp_p_check'];
        }
        if (isset($row['fe_version'])) { // fe_version
            $this->fe_version->CurrentValue = $row['fe_version'];
        }
        if (isset($row['admin_version'])) { // admin_version
            $this->admin_version->CurrentValue = $row['admin_version'];
        }
        if (isset($row['dashboard'])) { // dashboard
            $this->_dashboard->CurrentValue = $row['dashboard'];
        }
        if (isset($row['developer_upi_id'])) { // developer_upi_id
            $this->developer_upi_id->CurrentValue = $row['developer_upi_id'];
        }
        if (isset($row['developer_company'])) { // developer_company
            $this->developer_company->CurrentValue = $row['developer_company'];
        }
        if (isset($row['default_page'])) { // default_page
            $this->default_page->CurrentValue = $row['default_page'];
        }
        if (isset($row['bom_edit'])) { // bom_edit
            $this->bom_edit->CurrentValue = $row['bom_edit'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("portalsetuplist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_portal_category":
                    break;
                case "x_pd_byepass":
                    break;
                case "x__dashboard":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
