<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for portal_setup
 */
class PortalSetup extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $url;
    public $admin_url;
    public $mail_code;
    public $footer_line;
    public $portal_category;
    public $mcu;
    public $fcm_server_key;
    public $app_version;
    public $pd_byepass;
    public $operator;
    public $google_map_api;
    public $material_payment_type;
    public $material_payment_varient;
    public $footer_line_be;
    public $allow_reg;
    public $login_remember;
    public $gp_p_check;
    public $fe_version;
    public $admin_version;
    public $_dashboard;
    public $developer_upi_id;
    public $developer_company;
    public $default_page;
    public $bom_edit;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "portal_setup";
        $this->TableName = 'portal_setup';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "portal_setup";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // url
        $this->url = new DbField(
            $this, // Table
            'x_url', // Variable name
            'url', // Name
            '`url`', // Expression
            '`url`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`url`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->url->InputTextType = "text";
        $this->url->Nullable = false; // NOT NULL field
        $this->url->Required = true; // Required field
        $this->url->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['url'] = &$this->url;

        // admin_url
        $this->admin_url = new DbField(
            $this, // Table
            'x_admin_url', // Variable name
            'admin_url', // Name
            '`admin_url`', // Expression
            '`admin_url`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`admin_url`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->admin_url->InputTextType = "text";
        $this->admin_url->Nullable = false; // NOT NULL field
        $this->admin_url->Required = true; // Required field
        $this->admin_url->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['admin_url'] = &$this->admin_url;

        // mail_code
        $this->mail_code = new DbField(
            $this, // Table
            'x_mail_code', // Variable name
            'mail_code', // Name
            '`mail_code`', // Expression
            '`mail_code`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`mail_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->mail_code->InputTextType = "text";
        $this->mail_code->Nullable = false; // NOT NULL field
        $this->mail_code->Required = true; // Required field
        $this->mail_code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['mail_code'] = &$this->mail_code;

        // footer_line
        $this->footer_line = new DbField(
            $this, // Table
            'x_footer_line', // Variable name
            'footer_line', // Name
            '`footer_line`', // Expression
            '`footer_line`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`footer_line`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->footer_line->InputTextType = "text";
        $this->footer_line->Nullable = false; // NOT NULL field
        $this->footer_line->Required = true; // Required field
        $this->footer_line->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['footer_line'] = &$this->footer_line;

        // portal_category
        $this->portal_category = new DbField(
            $this, // Table
            'x_portal_category', // Variable name
            'portal_category', // Name
            '`portal_category`', // Expression
            '`portal_category`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`portal_category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->portal_category->InputTextType = "text";
        $this->portal_category->Lookup = new Lookup($this->portal_category, 'int_portal_list', true, 'category', ["category","","",""], '', '', [], [], [], [], [], [], false, '`category` ASC', '', "`category`");
        $this->portal_category->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['portal_category'] = &$this->portal_category;

        // mcu
        $this->mcu = new DbField(
            $this, // Table
            'x_mcu', // Variable name
            'mcu', // Name
            '`mcu`', // Expression
            '`mcu`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`mcu`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->mcu->addMethod("getDefault", fn() => 0);
        $this->mcu->InputTextType = "text";
        $this->mcu->Raw = true;
        $this->mcu->Nullable = false; // NOT NULL field
        $this->mcu->Required = true; // Required field
        $this->mcu->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->mcu->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['mcu'] = &$this->mcu;

        // fcm_server_key
        $this->fcm_server_key = new DbField(
            $this, // Table
            'x_fcm_server_key', // Variable name
            'fcm_server_key', // Name
            '`fcm_server_key`', // Expression
            '`fcm_server_key`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`fcm_server_key`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->fcm_server_key->InputTextType = "text";
        $this->fcm_server_key->Nullable = false; // NOT NULL field
        $this->fcm_server_key->Required = true; // Required field
        $this->fcm_server_key->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['fcm_server_key'] = &$this->fcm_server_key;

        // app_version
        $this->app_version = new DbField(
            $this, // Table
            'x_app_version', // Variable name
            'app_version', // Name
            '`app_version`', // Expression
            '`app_version`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`app_version`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->app_version->InputTextType = "text";
        $this->app_version->Raw = true;
        $this->app_version->Nullable = false; // NOT NULL field
        $this->app_version->Required = true; // Required field
        $this->app_version->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->app_version->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['app_version'] = &$this->app_version;

        // pd_byepass
        $this->pd_byepass = new DbField(
            $this, // Table
            'x_pd_byepass', // Variable name
            'pd_byepass', // Name
            '`pd_byepass`', // Expression
            '`pd_byepass`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pd_byepass`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->pd_byepass->InputTextType = "text";
        $this->pd_byepass->Raw = true;
        $this->pd_byepass->Nullable = false; // NOT NULL field
        $this->pd_byepass->Required = true; // Required field
        $this->pd_byepass->setSelectMultiple(false); // Select one
        $this->pd_byepass->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->pd_byepass->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->pd_byepass->Lookup = new Lookup($this->pd_byepass, 'portal_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->pd_byepass->OptionCount = 3;
        $this->pd_byepass->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pd_byepass->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['pd_byepass'] = &$this->pd_byepass;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // google_map_api
        $this->google_map_api = new DbField(
            $this, // Table
            'x_google_map_api', // Variable name
            'google_map_api', // Name
            '`google_map_api`', // Expression
            '`google_map_api`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`google_map_api`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->google_map_api->InputTextType = "text";
        $this->google_map_api->Nullable = false; // NOT NULL field
        $this->google_map_api->Required = true; // Required field
        $this->google_map_api->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['google_map_api'] = &$this->google_map_api;

        // material_payment_type
        $this->material_payment_type = new DbField(
            $this, // Table
            'x_material_payment_type', // Variable name
            'material_payment_type', // Name
            '`material_payment_type`', // Expression
            '`material_payment_type`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`material_payment_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->material_payment_type->InputTextType = "text";
        $this->material_payment_type->Raw = true;
        $this->material_payment_type->Nullable = false; // NOT NULL field
        $this->material_payment_type->Required = true; // Required field
        $this->material_payment_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->material_payment_type->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['material_payment_type'] = &$this->material_payment_type;

        // material_payment_varient
        $this->material_payment_varient = new DbField(
            $this, // Table
            'x_material_payment_varient', // Variable name
            'material_payment_varient', // Name
            '`material_payment_varient`', // Expression
            '`material_payment_varient`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`material_payment_varient`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->material_payment_varient->InputTextType = "text";
        $this->material_payment_varient->Raw = true;
        $this->material_payment_varient->Nullable = false; // NOT NULL field
        $this->material_payment_varient->Required = true; // Required field
        $this->material_payment_varient->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->material_payment_varient->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['material_payment_varient'] = &$this->material_payment_varient;

        // footer_line_be
        $this->footer_line_be = new DbField(
            $this, // Table
            'x_footer_line_be', // Variable name
            'footer_line_be', // Name
            '`footer_line_be`', // Expression
            '`footer_line_be`', // Basic search expression
            200, // Type
            144, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`footer_line_be`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->footer_line_be->InputTextType = "text";
        $this->footer_line_be->Nullable = false; // NOT NULL field
        $this->footer_line_be->Required = true; // Required field
        $this->footer_line_be->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['footer_line_be'] = &$this->footer_line_be;

        // allow_reg
        $this->allow_reg = new DbField(
            $this, // Table
            'x_allow_reg', // Variable name
            'allow_reg', // Name
            '`allow_reg`', // Expression
            '`allow_reg`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`allow_reg`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->allow_reg->addMethod("getDefault", fn() => 0);
        $this->allow_reg->InputTextType = "text";
        $this->allow_reg->Raw = true;
        $this->allow_reg->Nullable = false; // NOT NULL field
        $this->allow_reg->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->allow_reg->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['allow_reg'] = &$this->allow_reg;

        // login_remember
        $this->login_remember = new DbField(
            $this, // Table
            'x_login_remember', // Variable name
            'login_remember', // Name
            '`login_remember`', // Expression
            '`login_remember`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`login_remember`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->login_remember->addMethod("getDefault", fn() => 0);
        $this->login_remember->InputTextType = "text";
        $this->login_remember->Raw = true;
        $this->login_remember->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->login_remember->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['login_remember'] = &$this->login_remember;

        // gp_p_check
        $this->gp_p_check = new DbField(
            $this, // Table
            'x_gp_p_check', // Variable name
            'gp_p_check', // Name
            '`gp_p_check`', // Expression
            '`gp_p_check`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gp_p_check`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->gp_p_check->addMethod("getDefault", fn() => 0);
        $this->gp_p_check->InputTextType = "text";
        $this->gp_p_check->Raw = true;
        $this->gp_p_check->Nullable = false; // NOT NULL field
        $this->gp_p_check->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->gp_p_check->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['gp_p_check'] = &$this->gp_p_check;

        // fe_version
        $this->fe_version = new DbField(
            $this, // Table
            'x_fe_version', // Variable name
            'fe_version', // Name
            '`fe_version`', // Expression
            '`fe_version`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`fe_version`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->fe_version->InputTextType = "text";
        $this->fe_version->Nullable = false; // NOT NULL field
        $this->fe_version->Required = true; // Required field
        $this->fe_version->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['fe_version'] = &$this->fe_version;

        // admin_version
        $this->admin_version = new DbField(
            $this, // Table
            'x_admin_version', // Variable name
            'admin_version', // Name
            '`admin_version`', // Expression
            '`admin_version`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`admin_version`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->admin_version->InputTextType = "text";
        $this->admin_version->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['admin_version'] = &$this->admin_version;

        // dashboard
        $this->_dashboard = new DbField(
            $this, // Table
            'x__dashboard', // Variable name
            'dashboard', // Name
            '`dashboard`', // Expression
            '`dashboard`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`dashboard`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->_dashboard->addMethod("getDefault", fn() => 1);
        $this->_dashboard->InputTextType = "text";
        $this->_dashboard->Raw = true;
        $this->_dashboard->Nullable = false; // NOT NULL field
        $this->_dashboard->setSelectMultiple(false); // Select one
        $this->_dashboard->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->_dashboard->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->_dashboard->Lookup = new Lookup($this->_dashboard, 'portal_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->_dashboard->OptionCount = 2;
        $this->_dashboard->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_dashboard->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['dashboard'] = &$this->_dashboard;

        // developer_upi_id
        $this->developer_upi_id = new DbField(
            $this, // Table
            'x_developer_upi_id', // Variable name
            'developer_upi_id', // Name
            '`developer_upi_id`', // Expression
            '`developer_upi_id`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`developer_upi_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->developer_upi_id->InputTextType = "text";
        $this->developer_upi_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['developer_upi_id'] = &$this->developer_upi_id;

        // developer_company
        $this->developer_company = new DbField(
            $this, // Table
            'x_developer_company', // Variable name
            'developer_company', // Name
            '`developer_company`', // Expression
            '`developer_company`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`developer_company`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->developer_company->InputTextType = "text";
        $this->developer_company->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['developer_company'] = &$this->developer_company;

        // default_page
        $this->default_page = new DbField(
            $this, // Table
            'x_default_page', // Variable name
            'default_page', // Name
            '`default_page`', // Expression
            '`default_page`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`default_page`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->default_page->addMethod("getDefault", fn() => "db2");
        $this->default_page->InputTextType = "text";
        $this->default_page->Nullable = false; // NOT NULL field
        $this->default_page->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['default_page'] = &$this->default_page;

        // bom_edit
        $this->bom_edit = new DbField(
            $this, // Table
            'x_bom_edit', // Variable name
            'bom_edit', // Name
            '`bom_edit`', // Expression
            '`bom_edit`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bom_edit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->bom_edit->InputTextType = "text";
        $this->bom_edit->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['bom_edit'] = &$this->bom_edit;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "portal_setup";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "`operator` = " . CurrentUserID()." AND `operator`=-1";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->url->DbValue = $row['url'];
        $this->admin_url->DbValue = $row['admin_url'];
        $this->mail_code->DbValue = $row['mail_code'];
        $this->footer_line->DbValue = $row['footer_line'];
        $this->portal_category->DbValue = $row['portal_category'];
        $this->mcu->DbValue = $row['mcu'];
        $this->fcm_server_key->DbValue = $row['fcm_server_key'];
        $this->app_version->DbValue = $row['app_version'];
        $this->pd_byepass->DbValue = $row['pd_byepass'];
        $this->operator->DbValue = $row['operator'];
        $this->google_map_api->DbValue = $row['google_map_api'];
        $this->material_payment_type->DbValue = $row['material_payment_type'];
        $this->material_payment_varient->DbValue = $row['material_payment_varient'];
        $this->footer_line_be->DbValue = $row['footer_line_be'];
        $this->allow_reg->DbValue = $row['allow_reg'];
        $this->login_remember->DbValue = $row['login_remember'];
        $this->gp_p_check->DbValue = $row['gp_p_check'];
        $this->fe_version->DbValue = $row['fe_version'];
        $this->admin_version->DbValue = $row['admin_version'];
        $this->_dashboard->DbValue = $row['dashboard'];
        $this->developer_upi_id->DbValue = $row['developer_upi_id'];
        $this->developer_company->DbValue = $row['developer_company'];
        $this->default_page->DbValue = $row['default_page'];
        $this->bom_edit->DbValue = $row['bom_edit'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("portalsetuplist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "portalsetupview" => $Language->phrase("View"),
            "portalsetupedit" => $Language->phrase("Edit"),
            "portalsetupadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "portalsetuplist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "PortalSetupView",
            Config("API_ADD_ACTION") => "PortalSetupAdd",
            Config("API_EDIT_ACTION") => "PortalSetupEdit",
            Config("API_DELETE_ACTION") => "PortalSetupDelete",
            Config("API_LIST_ACTION") => "PortalSetupList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "portalsetuplist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("portalsetupview", $parm);
        } else {
            $url = $this->keyUrl("portalsetupview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "portalsetupadd?" . $parm;
        } else {
            $url = "portalsetupadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("portalsetupedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("portalsetuplist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("portalsetupadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("portalsetuplist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("portalsetupdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->url->setDbValue($row['url']);
        $this->admin_url->setDbValue($row['admin_url']);
        $this->mail_code->setDbValue($row['mail_code']);
        $this->footer_line->setDbValue($row['footer_line']);
        $this->portal_category->setDbValue($row['portal_category']);
        $this->mcu->setDbValue($row['mcu']);
        $this->fcm_server_key->setDbValue($row['fcm_server_key']);
        $this->app_version->setDbValue($row['app_version']);
        $this->pd_byepass->setDbValue($row['pd_byepass']);
        $this->operator->setDbValue($row['operator']);
        $this->google_map_api->setDbValue($row['google_map_api']);
        $this->material_payment_type->setDbValue($row['material_payment_type']);
        $this->material_payment_varient->setDbValue($row['material_payment_varient']);
        $this->footer_line_be->setDbValue($row['footer_line_be']);
        $this->allow_reg->setDbValue($row['allow_reg']);
        $this->login_remember->setDbValue($row['login_remember']);
        $this->gp_p_check->setDbValue($row['gp_p_check']);
        $this->fe_version->setDbValue($row['fe_version']);
        $this->admin_version->setDbValue($row['admin_version']);
        $this->_dashboard->setDbValue($row['dashboard']);
        $this->developer_upi_id->setDbValue($row['developer_upi_id']);
        $this->developer_company->setDbValue($row['developer_company']);
        $this->default_page->setDbValue($row['default_page']);
        $this->bom_edit->setDbValue($row['bom_edit']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "PortalSetupList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // url

        // admin_url

        // mail_code

        // footer_line

        // portal_category

        // mcu

        // fcm_server_key

        // app_version

        // pd_byepass

        // operator

        // google_map_api

        // material_payment_type

        // material_payment_varient

        // footer_line_be

        // allow_reg

        // login_remember

        // gp_p_check

        // fe_version

        // admin_version

        // dashboard

        // developer_upi_id

        // developer_company

        // default_page

        // bom_edit

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // url
        $this->url->ViewValue = $this->url->CurrentValue;

        // admin_url
        $this->admin_url->ViewValue = $this->admin_url->CurrentValue;

        // mail_code
        $this->mail_code->ViewValue = $this->mail_code->CurrentValue;

        // footer_line
        $this->footer_line->ViewValue = $this->footer_line->CurrentValue;

        // portal_category
        $curVal = strval($this->portal_category->CurrentValue);
        if ($curVal != "") {
            $this->portal_category->ViewValue = $this->portal_category->lookupCacheOption($curVal);
            if ($this->portal_category->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->portal_category->Lookup->getTable()->Fields["category"]->searchExpression(), "=", trim($wrk), $this->portal_category->Lookup->getTable()->Fields["category"]->searchDataType(), ""), "OR");
                }
                $sqlWrk = $this->portal_category->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->portal_category->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->portal_category->Lookup->renderViewRow($row);
                        $this->portal_category->ViewValue->add($this->portal_category->displayValue($arwrk));
                    }
                } else {
                    $this->portal_category->ViewValue = $this->portal_category->CurrentValue;
                }
            }
        } else {
            $this->portal_category->ViewValue = null;
        }

        // mcu
        $this->mcu->ViewValue = $this->mcu->CurrentValue;
        $this->mcu->ViewValue = FormatNumber($this->mcu->ViewValue, $this->mcu->formatPattern());

        // fcm_server_key
        $this->fcm_server_key->ViewValue = $this->fcm_server_key->CurrentValue;

        // app_version
        $this->app_version->ViewValue = $this->app_version->CurrentValue;
        $this->app_version->ViewValue = FormatNumber($this->app_version->ViewValue, $this->app_version->formatPattern());

        // pd_byepass
        if (strval($this->pd_byepass->CurrentValue) != "") {
            $this->pd_byepass->ViewValue = $this->pd_byepass->optionCaption($this->pd_byepass->CurrentValue);
        } else {
            $this->pd_byepass->ViewValue = null;
        }

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;
        $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

        // google_map_api
        $this->google_map_api->ViewValue = $this->google_map_api->CurrentValue;

        // material_payment_type
        $this->material_payment_type->ViewValue = $this->material_payment_type->CurrentValue;
        $this->material_payment_type->ViewValue = FormatNumber($this->material_payment_type->ViewValue, $this->material_payment_type->formatPattern());

        // material_payment_varient
        $this->material_payment_varient->ViewValue = $this->material_payment_varient->CurrentValue;
        $this->material_payment_varient->ViewValue = FormatNumber($this->material_payment_varient->ViewValue, $this->material_payment_varient->formatPattern());

        // footer_line_be
        $this->footer_line_be->ViewValue = $this->footer_line_be->CurrentValue;

        // allow_reg
        $this->allow_reg->ViewValue = $this->allow_reg->CurrentValue;
        $this->allow_reg->ViewValue = FormatNumber($this->allow_reg->ViewValue, $this->allow_reg->formatPattern());

        // login_remember
        $this->login_remember->ViewValue = $this->login_remember->CurrentValue;
        $this->login_remember->ViewValue = FormatNumber($this->login_remember->ViewValue, $this->login_remember->formatPattern());

        // gp_p_check
        $this->gp_p_check->ViewValue = $this->gp_p_check->CurrentValue;
        $this->gp_p_check->ViewValue = FormatNumber($this->gp_p_check->ViewValue, $this->gp_p_check->formatPattern());

        // fe_version
        $this->fe_version->ViewValue = $this->fe_version->CurrentValue;

        // admin_version
        $this->admin_version->ViewValue = $this->admin_version->CurrentValue;

        // dashboard
        if (strval($this->_dashboard->CurrentValue) != "") {
            $this->_dashboard->ViewValue = $this->_dashboard->optionCaption($this->_dashboard->CurrentValue);
        } else {
            $this->_dashboard->ViewValue = null;
        }

        // developer_upi_id
        $this->developer_upi_id->ViewValue = $this->developer_upi_id->CurrentValue;

        // developer_company
        $this->developer_company->ViewValue = $this->developer_company->CurrentValue;

        // default_page
        $this->default_page->ViewValue = $this->default_page->CurrentValue;

        // bom_edit
        $this->bom_edit->ViewValue = $this->bom_edit->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // url
        $this->url->HrefValue = "";
        $this->url->TooltipValue = "";

        // admin_url
        $this->admin_url->HrefValue = "";
        $this->admin_url->TooltipValue = "";

        // mail_code
        $this->mail_code->HrefValue = "";
        $this->mail_code->TooltipValue = "";

        // footer_line
        $this->footer_line->HrefValue = "";
        $this->footer_line->TooltipValue = "";

        // portal_category
        $this->portal_category->HrefValue = "";
        $this->portal_category->TooltipValue = "";

        // mcu
        $this->mcu->HrefValue = "";
        $this->mcu->TooltipValue = "";

        // fcm_server_key
        $this->fcm_server_key->HrefValue = "";
        $this->fcm_server_key->TooltipValue = "";

        // app_version
        $this->app_version->HrefValue = "";
        $this->app_version->TooltipValue = "";

        // pd_byepass
        $this->pd_byepass->HrefValue = "";
        $this->pd_byepass->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // google_map_api
        $this->google_map_api->HrefValue = "";
        $this->google_map_api->TooltipValue = "";

        // material_payment_type
        $this->material_payment_type->HrefValue = "";
        $this->material_payment_type->TooltipValue = "";

        // material_payment_varient
        $this->material_payment_varient->HrefValue = "";
        $this->material_payment_varient->TooltipValue = "";

        // footer_line_be
        $this->footer_line_be->HrefValue = "";
        $this->footer_line_be->TooltipValue = "";

        // allow_reg
        $this->allow_reg->HrefValue = "";
        $this->allow_reg->TooltipValue = "";

        // login_remember
        $this->login_remember->HrefValue = "";
        $this->login_remember->TooltipValue = "";

        // gp_p_check
        $this->gp_p_check->HrefValue = "";
        $this->gp_p_check->TooltipValue = "";

        // fe_version
        $this->fe_version->HrefValue = "";
        $this->fe_version->TooltipValue = "";

        // admin_version
        $this->admin_version->HrefValue = "";
        $this->admin_version->TooltipValue = "";

        // dashboard
        $this->_dashboard->HrefValue = "";
        $this->_dashboard->TooltipValue = "";

        // developer_upi_id
        $this->developer_upi_id->HrefValue = "";
        $this->developer_upi_id->TooltipValue = "";

        // developer_company
        $this->developer_company->HrefValue = "";
        $this->developer_company->TooltipValue = "";

        // default_page
        $this->default_page->HrefValue = "";
        $this->default_page->TooltipValue = "";

        // bom_edit
        $this->bom_edit->HrefValue = "";
        $this->bom_edit->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // url
        $this->url->setupEditAttributes();
        if (!$this->url->Raw) {
            $this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
        }
        $this->url->EditValue = $this->url->CurrentValue;
        $this->url->PlaceHolder = RemoveHtml($this->url->caption());

        // admin_url
        $this->admin_url->setupEditAttributes();
        if (!$this->admin_url->Raw) {
            $this->admin_url->CurrentValue = HtmlDecode($this->admin_url->CurrentValue);
        }
        $this->admin_url->EditValue = $this->admin_url->CurrentValue;
        $this->admin_url->PlaceHolder = RemoveHtml($this->admin_url->caption());

        // mail_code
        $this->mail_code->setupEditAttributes();
        $this->mail_code->EditValue = $this->mail_code->CurrentValue;
        $this->mail_code->PlaceHolder = RemoveHtml($this->mail_code->caption());

        // footer_line
        $this->footer_line->setupEditAttributes();
        $this->footer_line->EditValue = $this->footer_line->CurrentValue;
        $this->footer_line->PlaceHolder = RemoveHtml($this->footer_line->caption());

        // portal_category
        $this->portal_category->PlaceHolder = RemoveHtml($this->portal_category->caption());

        // mcu
        $this->mcu->setupEditAttributes();
        $this->mcu->EditValue = $this->mcu->CurrentValue;
        $this->mcu->PlaceHolder = RemoveHtml($this->mcu->caption());
        if (strval($this->mcu->EditValue) != "" && is_numeric($this->mcu->EditValue)) {
            $this->mcu->EditValue = FormatNumber($this->mcu->EditValue, null);
        }

        // fcm_server_key
        $this->fcm_server_key->setupEditAttributes();
        if (!$this->fcm_server_key->Raw) {
            $this->fcm_server_key->CurrentValue = HtmlDecode($this->fcm_server_key->CurrentValue);
        }
        $this->fcm_server_key->EditValue = $this->fcm_server_key->CurrentValue;
        $this->fcm_server_key->PlaceHolder = RemoveHtml($this->fcm_server_key->caption());

        // app_version
        $this->app_version->setupEditAttributes();
        $this->app_version->EditValue = $this->app_version->CurrentValue;
        $this->app_version->PlaceHolder = RemoveHtml($this->app_version->caption());
        if (strval($this->app_version->EditValue) != "" && is_numeric($this->app_version->EditValue)) {
            $this->app_version->EditValue = FormatNumber($this->app_version->EditValue, null);
        }

        // pd_byepass
        $this->pd_byepass->setupEditAttributes();
        $this->pd_byepass->EditValue = $this->pd_byepass->options(true);
        $this->pd_byepass->PlaceHolder = RemoveHtml($this->pd_byepass->caption());

        // operator
        $this->operator->setupEditAttributes();
        $this->operator->EditValue = $this->operator->CurrentValue;
        $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());
        if (strval($this->operator->EditValue) != "" && is_numeric($this->operator->EditValue)) {
            $this->operator->EditValue = FormatNumber($this->operator->EditValue, null);
        }

        // google_map_api
        $this->google_map_api->setupEditAttributes();
        if (!$this->google_map_api->Raw) {
            $this->google_map_api->CurrentValue = HtmlDecode($this->google_map_api->CurrentValue);
        }
        $this->google_map_api->EditValue = $this->google_map_api->CurrentValue;
        $this->google_map_api->PlaceHolder = RemoveHtml($this->google_map_api->caption());

        // material_payment_type
        $this->material_payment_type->setupEditAttributes();
        $this->material_payment_type->EditValue = $this->material_payment_type->CurrentValue;
        $this->material_payment_type->PlaceHolder = RemoveHtml($this->material_payment_type->caption());
        if (strval($this->material_payment_type->EditValue) != "" && is_numeric($this->material_payment_type->EditValue)) {
            $this->material_payment_type->EditValue = FormatNumber($this->material_payment_type->EditValue, null);
        }

        // material_payment_varient
        $this->material_payment_varient->setupEditAttributes();
        $this->material_payment_varient->EditValue = $this->material_payment_varient->CurrentValue;
        $this->material_payment_varient->PlaceHolder = RemoveHtml($this->material_payment_varient->caption());
        if (strval($this->material_payment_varient->EditValue) != "" && is_numeric($this->material_payment_varient->EditValue)) {
            $this->material_payment_varient->EditValue = FormatNumber($this->material_payment_varient->EditValue, null);
        }

        // footer_line_be
        $this->footer_line_be->setupEditAttributes();
        if (!$this->footer_line_be->Raw) {
            $this->footer_line_be->CurrentValue = HtmlDecode($this->footer_line_be->CurrentValue);
        }
        $this->footer_line_be->EditValue = $this->footer_line_be->CurrentValue;
        $this->footer_line_be->PlaceHolder = RemoveHtml($this->footer_line_be->caption());

        // allow_reg
        $this->allow_reg->setupEditAttributes();
        $this->allow_reg->EditValue = $this->allow_reg->CurrentValue;
        $this->allow_reg->PlaceHolder = RemoveHtml($this->allow_reg->caption());
        if (strval($this->allow_reg->EditValue) != "" && is_numeric($this->allow_reg->EditValue)) {
            $this->allow_reg->EditValue = FormatNumber($this->allow_reg->EditValue, null);
        }

        // login_remember
        $this->login_remember->setupEditAttributes();
        $this->login_remember->EditValue = $this->login_remember->CurrentValue;
        $this->login_remember->PlaceHolder = RemoveHtml($this->login_remember->caption());
        if (strval($this->login_remember->EditValue) != "" && is_numeric($this->login_remember->EditValue)) {
            $this->login_remember->EditValue = FormatNumber($this->login_remember->EditValue, null);
        }

        // gp_p_check
        $this->gp_p_check->setupEditAttributes();
        $this->gp_p_check->EditValue = $this->gp_p_check->CurrentValue;
        $this->gp_p_check->PlaceHolder = RemoveHtml($this->gp_p_check->caption());
        if (strval($this->gp_p_check->EditValue) != "" && is_numeric($this->gp_p_check->EditValue)) {
            $this->gp_p_check->EditValue = FormatNumber($this->gp_p_check->EditValue, null);
        }

        // fe_version
        $this->fe_version->setupEditAttributes();
        if (!$this->fe_version->Raw) {
            $this->fe_version->CurrentValue = HtmlDecode($this->fe_version->CurrentValue);
        }
        $this->fe_version->EditValue = $this->fe_version->CurrentValue;
        $this->fe_version->PlaceHolder = RemoveHtml($this->fe_version->caption());

        // admin_version
        $this->admin_version->setupEditAttributes();
        if (!$this->admin_version->Raw) {
            $this->admin_version->CurrentValue = HtmlDecode($this->admin_version->CurrentValue);
        }
        $this->admin_version->EditValue = $this->admin_version->CurrentValue;
        $this->admin_version->PlaceHolder = RemoveHtml($this->admin_version->caption());

        // dashboard
        $this->_dashboard->setupEditAttributes();
        $this->_dashboard->EditValue = $this->_dashboard->options(true);
        $this->_dashboard->PlaceHolder = RemoveHtml($this->_dashboard->caption());

        // developer_upi_id
        $this->developer_upi_id->setupEditAttributes();
        if (!$this->developer_upi_id->Raw) {
            $this->developer_upi_id->CurrentValue = HtmlDecode($this->developer_upi_id->CurrentValue);
        }
        $this->developer_upi_id->EditValue = $this->developer_upi_id->CurrentValue;
        $this->developer_upi_id->PlaceHolder = RemoveHtml($this->developer_upi_id->caption());

        // developer_company
        $this->developer_company->setupEditAttributes();
        if (!$this->developer_company->Raw) {
            $this->developer_company->CurrentValue = HtmlDecode($this->developer_company->CurrentValue);
        }
        $this->developer_company->EditValue = $this->developer_company->CurrentValue;
        $this->developer_company->PlaceHolder = RemoveHtml($this->developer_company->caption());

        // default_page
        $this->default_page->setupEditAttributes();
        if (!$this->default_page->Raw) {
            $this->default_page->CurrentValue = HtmlDecode($this->default_page->CurrentValue);
        }
        $this->default_page->EditValue = $this->default_page->CurrentValue;
        $this->default_page->PlaceHolder = RemoveHtml($this->default_page->caption());

        // bom_edit
        $this->bom_edit->setupEditAttributes();
        if (!$this->bom_edit->Raw) {
            $this->bom_edit->CurrentValue = HtmlDecode($this->bom_edit->CurrentValue);
        }
        $this->bom_edit->EditValue = $this->bom_edit->CurrentValue;
        $this->bom_edit->PlaceHolder = RemoveHtml($this->bom_edit->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->url);
                    $doc->exportCaption($this->admin_url);
                    $doc->exportCaption($this->mail_code);
                    $doc->exportCaption($this->footer_line);
                    $doc->exportCaption($this->portal_category);
                    $doc->exportCaption($this->mcu);
                    $doc->exportCaption($this->fcm_server_key);
                    $doc->exportCaption($this->app_version);
                    $doc->exportCaption($this->pd_byepass);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->google_map_api);
                    $doc->exportCaption($this->material_payment_type);
                    $doc->exportCaption($this->material_payment_varient);
                    $doc->exportCaption($this->footer_line_be);
                    $doc->exportCaption($this->allow_reg);
                    $doc->exportCaption($this->login_remember);
                    $doc->exportCaption($this->gp_p_check);
                    $doc->exportCaption($this->fe_version);
                    $doc->exportCaption($this->admin_version);
                    $doc->exportCaption($this->_dashboard);
                    $doc->exportCaption($this->developer_upi_id);
                    $doc->exportCaption($this->developer_company);
                    $doc->exportCaption($this->default_page);
                    $doc->exportCaption($this->bom_edit);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->url);
                    $doc->exportCaption($this->admin_url);
                    $doc->exportCaption($this->portal_category);
                    $doc->exportCaption($this->mcu);
                    $doc->exportCaption($this->fcm_server_key);
                    $doc->exportCaption($this->app_version);
                    $doc->exportCaption($this->pd_byepass);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->google_map_api);
                    $doc->exportCaption($this->material_payment_type);
                    $doc->exportCaption($this->material_payment_varient);
                    $doc->exportCaption($this->footer_line_be);
                    $doc->exportCaption($this->allow_reg);
                    $doc->exportCaption($this->login_remember);
                    $doc->exportCaption($this->gp_p_check);
                    $doc->exportCaption($this->fe_version);
                    $doc->exportCaption($this->admin_version);
                    $doc->exportCaption($this->_dashboard);
                    $doc->exportCaption($this->developer_upi_id);
                    $doc->exportCaption($this->developer_company);
                    $doc->exportCaption($this->default_page);
                    $doc->exportCaption($this->bom_edit);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->url);
                        $doc->exportField($this->admin_url);
                        $doc->exportField($this->mail_code);
                        $doc->exportField($this->footer_line);
                        $doc->exportField($this->portal_category);
                        $doc->exportField($this->mcu);
                        $doc->exportField($this->fcm_server_key);
                        $doc->exportField($this->app_version);
                        $doc->exportField($this->pd_byepass);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->google_map_api);
                        $doc->exportField($this->material_payment_type);
                        $doc->exportField($this->material_payment_varient);
                        $doc->exportField($this->footer_line_be);
                        $doc->exportField($this->allow_reg);
                        $doc->exportField($this->login_remember);
                        $doc->exportField($this->gp_p_check);
                        $doc->exportField($this->fe_version);
                        $doc->exportField($this->admin_version);
                        $doc->exportField($this->_dashboard);
                        $doc->exportField($this->developer_upi_id);
                        $doc->exportField($this->developer_company);
                        $doc->exportField($this->default_page);
                        $doc->exportField($this->bom_edit);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->url);
                        $doc->exportField($this->admin_url);
                        $doc->exportField($this->portal_category);
                        $doc->exportField($this->mcu);
                        $doc->exportField($this->fcm_server_key);
                        $doc->exportField($this->app_version);
                        $doc->exportField($this->pd_byepass);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->google_map_api);
                        $doc->exportField($this->material_payment_type);
                        $doc->exportField($this->material_payment_varient);
                        $doc->exportField($this->footer_line_be);
                        $doc->exportField($this->allow_reg);
                        $doc->exportField($this->login_remember);
                        $doc->exportField($this->gp_p_check);
                        $doc->exportField($this->fe_version);
                        $doc->exportField($this->admin_version);
                        $doc->exportField($this->_dashboard);
                        $doc->exportField($this->developer_upi_id);
                        $doc->exportField($this->developer_company);
                        $doc->exportField($this->default_page);
                        $doc->exportField($this->bom_edit);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
