<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PortalInfoEdit extends PortalInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PortalInfoEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "portalinfoedit";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->logo->setVisibility();
        $this->mobile_logo->setVisibility();
        $this->fav_icon->Visible = false;
        $this->name->setVisibility();
        $this->address->setVisibility();
        $this->_email->setVisibility();
        $this->mobile->setVisibility();
        $this->gst->setVisibility();
        $this->other->setVisibility();
        $this->admin_mobile->setVisibility();
        $this->header->setVisibility();
        $this->footer->setVisibility();
        $this->tag_line->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->r_text->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'portal_info';
        $this->TableName = 'portal_info';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (portal_info)
        if (!isset($GLOBALS["portal_info"]) || $GLOBALS["portal_info"]::class == PROJECT_NAMESPACE . "portal_info") {
            $GLOBALS["portal_info"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'portal_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "portalinfoview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->logo->OldUploadPath = $this->logo->getUploadPath(); // PHP
                $this->logo->UploadPath = $this->logo->OldUploadPath;
                $this->mobile_logo->OldUploadPath = $this->mobile_logo->getUploadPath(); // PHP
                $this->mobile_logo->UploadPath = $this->mobile_logo->OldUploadPath;
                $this->fav_icon->OldUploadPath = $this->fav_icon->getUploadPath(); // PHP
                $this->fav_icon->UploadPath = $this->fav_icon->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("portalinfolist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = 'autoprogramme?apcid=c3daba8ba04565423e12eb8cb6237b46';
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "portalinfolist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "portalinfolist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->logo->Upload->Index = $CurrentForm->Index;
        $this->logo->Upload->uploadFile();
        $this->logo->CurrentValue = $this->logo->Upload->FileName;
        $this->mobile_logo->Upload->Index = $CurrentForm->Index;
        $this->mobile_logo->Upload->uploadFile();
        $this->mobile_logo->CurrentValue = $this->mobile_logo->Upload->FileName;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'name' first before field var 'x_name'
        $val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
        if (!$this->name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->name->Visible = false; // Disable update for API request
            } else {
                $this->name->setFormValue($val);
            }
        }

        // Check field name 'address' first before field var 'x_address'
        $val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
        if (!$this->address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->address->Visible = false; // Disable update for API request
            } else {
                $this->address->setFormValue($val);
            }
        }

        // Check field name 'email' first before field var 'x__email'
        $val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
        if (!$this->_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_email->Visible = false; // Disable update for API request
            } else {
                $this->_email->setFormValue($val);
            }
        }

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile->Visible = false; // Disable update for API request
            } else {
                $this->mobile->setFormValue($val);
            }
        }

        // Check field name 'gst' first before field var 'x_gst'
        $val = $CurrentForm->hasValue("gst") ? $CurrentForm->getValue("gst") : $CurrentForm->getValue("x_gst");
        if (!$this->gst->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gst->Visible = false; // Disable update for API request
            } else {
                $this->gst->setFormValue($val);
            }
        }

        // Check field name 'other' first before field var 'x_other'
        $val = $CurrentForm->hasValue("other") ? $CurrentForm->getValue("other") : $CurrentForm->getValue("x_other");
        if (!$this->other->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->other->Visible = false; // Disable update for API request
            } else {
                $this->other->setFormValue($val);
            }
        }

        // Check field name 'admin_mobile' first before field var 'x_admin_mobile'
        $val = $CurrentForm->hasValue("admin_mobile") ? $CurrentForm->getValue("admin_mobile") : $CurrentForm->getValue("x_admin_mobile");
        if (!$this->admin_mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->admin_mobile->Visible = false; // Disable update for API request
            } else {
                $this->admin_mobile->setFormValue($val);
            }
        }

        // Check field name 'header' first before field var 'x_header'
        $val = $CurrentForm->hasValue("header") ? $CurrentForm->getValue("header") : $CurrentForm->getValue("x_header");
        if (!$this->header->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->header->Visible = false; // Disable update for API request
            } else {
                $this->header->setFormValue($val);
            }
        }

        // Check field name 'footer' first before field var 'x_footer'
        $val = $CurrentForm->hasValue("footer") ? $CurrentForm->getValue("footer") : $CurrentForm->getValue("x_footer");
        if (!$this->footer->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->footer->Visible = false; // Disable update for API request
            } else {
                $this->footer->setFormValue($val);
            }
        }

        // Check field name 'tag_line' first before field var 'x_tag_line'
        $val = $CurrentForm->hasValue("tag_line") ? $CurrentForm->getValue("tag_line") : $CurrentForm->getValue("x_tag_line");
        if (!$this->tag_line->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->tag_line->Visible = false; // Disable update for API request
            } else {
                $this->tag_line->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
		$this->logo->OldUploadPath = $this->logo->getUploadPath(); // PHP
		$this->logo->UploadPath = $this->logo->OldUploadPath;
		$this->mobile_logo->OldUploadPath = $this->mobile_logo->getUploadPath(); // PHP
		$this->mobile_logo->UploadPath = $this->mobile_logo->OldUploadPath;
		$this->fav_icon->OldUploadPath = $this->fav_icon->getUploadPath(); // PHP
		$this->fav_icon->UploadPath = $this->fav_icon->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->name->CurrentValue = $this->name->FormValue;
        $this->address->CurrentValue = $this->address->FormValue;
        $this->_email->CurrentValue = $this->_email->FormValue;
        $this->mobile->CurrentValue = $this->mobile->FormValue;
        $this->gst->CurrentValue = $this->gst->FormValue;
        $this->other->CurrentValue = $this->other->FormValue;
        $this->admin_mobile->CurrentValue = $this->admin_mobile->FormValue;
        $this->header->CurrentValue = $this->header->FormValue;
        $this->footer->CurrentValue = $this->footer->FormValue;
        $this->tag_line->CurrentValue = $this->tag_line->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->logo->Upload->DbValue = $row['logo'];
        $this->logo->setDbValue($this->logo->Upload->DbValue);
        $this->mobile_logo->Upload->DbValue = $row['mobile_logo'];
        $this->mobile_logo->setDbValue($this->mobile_logo->Upload->DbValue);
        $this->fav_icon->Upload->DbValue = $row['fav_icon'];
        $this->fav_icon->setDbValue($this->fav_icon->Upload->DbValue);
        $this->name->setDbValue($row['name']);
        $this->address->setDbValue($row['address']);
        $this->_email->setDbValue($row['email']);
        $this->mobile->setDbValue($row['mobile']);
        $this->gst->setDbValue($row['gst']);
        $this->other->setDbValue($row['other']);
        $this->admin_mobile->setDbValue($row['admin_mobile']);
        $this->header->setDbValue($row['header']);
        $this->footer->setDbValue($row['footer']);
        $this->tag_line->setDbValue($row['tag_line']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->r_text->setDbValue($row['r_text']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['logo'] = $this->logo->DefaultValue;
        $row['mobile_logo'] = $this->mobile_logo->DefaultValue;
        $row['fav_icon'] = $this->fav_icon->DefaultValue;
        $row['name'] = $this->name->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['gst'] = $this->gst->DefaultValue;
        $row['other'] = $this->other->DefaultValue;
        $row['admin_mobile'] = $this->admin_mobile->DefaultValue;
        $row['header'] = $this->header->DefaultValue;
        $row['footer'] = $this->footer->DefaultValue;
        $row['tag_line'] = $this->tag_line->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['r_text'] = $this->r_text->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // logo
        $this->logo->RowCssClass = "row";

        // mobile_logo
        $this->mobile_logo->RowCssClass = "row";

        // fav_icon
        $this->fav_icon->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // gst
        $this->gst->RowCssClass = "row";

        // other
        $this->other->RowCssClass = "row";

        // admin_mobile
        $this->admin_mobile->RowCssClass = "row";

        // header
        $this->header->RowCssClass = "row";

        // footer
        $this->footer->RowCssClass = "row";

        // tag_line
        $this->tag_line->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // r_text
        $this->r_text->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // logo
            $this->logo->UploadPath = $this->logo->getUploadPath(); // PHP
            if (!EmptyValue($this->logo->Upload->DbValue)) {
                $this->logo->ViewValue = $this->logo->Upload->DbValue;
            } else {
                $this->logo->ViewValue = "";
            }

            // mobile_logo
            $this->mobile_logo->UploadPath = $this->mobile_logo->getUploadPath(); // PHP
            if (!EmptyValue($this->mobile_logo->Upload->DbValue)) {
                $this->mobile_logo->ViewValue = $this->mobile_logo->Upload->DbValue;
            } else {
                $this->mobile_logo->ViewValue = "";
            }

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;

            // gst
            $this->gst->ViewValue = $this->gst->CurrentValue;

            // other
            $this->other->ViewValue = $this->other->CurrentValue;

            // admin_mobile
            $this->admin_mobile->ViewValue = $this->admin_mobile->CurrentValue;

            // header
            $this->header->ViewValue = $this->header->CurrentValue;

            // footer
            $this->footer->ViewValue = $this->footer->CurrentValue;

            // tag_line
            $this->tag_line->ViewValue = $this->tag_line->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // logo
            $this->logo->HrefValue = "";
            $this->logo->ExportHrefValue = $this->logo->UploadPath . $this->logo->Upload->DbValue;

            // mobile_logo
            $this->mobile_logo->HrefValue = "";
            $this->mobile_logo->ExportHrefValue = $this->mobile_logo->UploadPath . $this->mobile_logo->Upload->DbValue;

            // name
            $this->name->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // gst
            $this->gst->HrefValue = "";

            // other
            $this->other->HrefValue = "";

            // admin_mobile
            $this->admin_mobile->HrefValue = "";

            // header
            $this->header->HrefValue = "";

            // footer
            $this->footer->HrefValue = "";

            // tag_line
            $this->tag_line->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // logo
            $this->logo->setupEditAttributes();
            $this->logo->UploadPath = $this->logo->getUploadPath(); // PHP
            if (!EmptyValue($this->logo->Upload->DbValue)) {
                $this->logo->EditValue = $this->logo->Upload->DbValue;
            } else {
                $this->logo->EditValue = "";
            }
            if (!EmptyValue($this->logo->CurrentValue)) {
                $this->logo->Upload->FileName = $this->logo->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->logo);
            }

            // mobile_logo
            $this->mobile_logo->setupEditAttributes();
            $this->mobile_logo->UploadPath = $this->mobile_logo->getUploadPath(); // PHP
            if (!EmptyValue($this->mobile_logo->Upload->DbValue)) {
                $this->mobile_logo->EditValue = $this->mobile_logo->Upload->DbValue;
            } else {
                $this->mobile_logo->EditValue = "";
            }
            if (!EmptyValue($this->mobile_logo->CurrentValue)) {
                $this->mobile_logo->Upload->FileName = $this->mobile_logo->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->mobile_logo);
            }

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->CurrentValue);
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // address
            $this->address->setupEditAttributes();
            $this->address->EditValue = HtmlEncode($this->address->CurrentValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            if (!$this->mobile->Raw) {
                $this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
            }
            $this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // gst
            $this->gst->setupEditAttributes();
            if (!$this->gst->Raw) {
                $this->gst->CurrentValue = HtmlDecode($this->gst->CurrentValue);
            }
            $this->gst->EditValue = HtmlEncode($this->gst->CurrentValue);
            $this->gst->PlaceHolder = RemoveHtml($this->gst->caption());

            // other
            $this->other->setupEditAttributes();
            if (!$this->other->Raw) {
                $this->other->CurrentValue = HtmlDecode($this->other->CurrentValue);
            }
            $this->other->EditValue = HtmlEncode($this->other->CurrentValue);
            $this->other->PlaceHolder = RemoveHtml($this->other->caption());

            // admin_mobile
            $this->admin_mobile->setupEditAttributes();
            if (!$this->admin_mobile->Raw) {
                $this->admin_mobile->CurrentValue = HtmlDecode($this->admin_mobile->CurrentValue);
            }
            $this->admin_mobile->EditValue = HtmlEncode($this->admin_mobile->CurrentValue);
            $this->admin_mobile->PlaceHolder = RemoveHtml($this->admin_mobile->caption());

            // header
            $this->header->setupEditAttributes();
            $this->header->EditValue = HtmlEncode($this->header->CurrentValue);
            $this->header->PlaceHolder = RemoveHtml($this->header->caption());

            // footer
            $this->footer->setupEditAttributes();
            $this->footer->EditValue = HtmlEncode($this->footer->CurrentValue);
            $this->footer->PlaceHolder = RemoveHtml($this->footer->caption());

            // tag_line
            $this->tag_line->setupEditAttributes();
            if (!$this->tag_line->Raw) {
                $this->tag_line->CurrentValue = HtmlDecode($this->tag_line->CurrentValue);
            }
            $this->tag_line->EditValue = HtmlEncode($this->tag_line->CurrentValue);
            $this->tag_line->PlaceHolder = RemoveHtml($this->tag_line->caption());

            // operator

            // datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // logo
            $this->logo->HrefValue = "";
            $this->logo->ExportHrefValue = $this->logo->UploadPath . $this->logo->Upload->DbValue;

            // mobile_logo
            $this->mobile_logo->HrefValue = "";
            $this->mobile_logo->ExportHrefValue = $this->mobile_logo->UploadPath . $this->mobile_logo->Upload->DbValue;

            // name
            $this->name->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // gst
            $this->gst->HrefValue = "";

            // other
            $this->other->HrefValue = "";

            // admin_mobile
            $this->admin_mobile->HrefValue = "";

            // header
            $this->header->HrefValue = "";

            // footer
            $this->footer->HrefValue = "";

            // tag_line
            $this->tag_line->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->logo->Visible && $this->logo->Required) {
                if ($this->logo->Upload->FileName == "" && !$this->logo->Upload->KeepFile) {
                    $this->logo->addErrorMessage(str_replace("%s", $this->logo->caption(), $this->logo->RequiredErrorMessage));
                }
            }
            if ($this->mobile_logo->Visible && $this->mobile_logo->Required) {
                if ($this->mobile_logo->Upload->FileName == "" && !$this->mobile_logo->Upload->KeepFile) {
                    $this->mobile_logo->addErrorMessage(str_replace("%s", $this->mobile_logo->caption(), $this->mobile_logo->RequiredErrorMessage));
                }
            }
            if ($this->name->Visible && $this->name->Required) {
                if (!$this->name->IsDetailKey && EmptyValue($this->name->FormValue)) {
                    $this->name->addErrorMessage(str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
                }
            }
            if ($this->address->Visible && $this->address->Required) {
                if (!$this->address->IsDetailKey && EmptyValue($this->address->FormValue)) {
                    $this->address->addErrorMessage(str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
                }
            }
            if ($this->_email->Visible && $this->_email->Required) {
                if (!$this->_email->IsDetailKey && EmptyValue($this->_email->FormValue)) {
                    $this->_email->addErrorMessage(str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
                }
            }
            if ($this->mobile->Visible && $this->mobile->Required) {
                if (!$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if ($this->gst->Visible && $this->gst->Required) {
                if (!$this->gst->IsDetailKey && EmptyValue($this->gst->FormValue)) {
                    $this->gst->addErrorMessage(str_replace("%s", $this->gst->caption(), $this->gst->RequiredErrorMessage));
                }
            }
            if ($this->other->Visible && $this->other->Required) {
                if (!$this->other->IsDetailKey && EmptyValue($this->other->FormValue)) {
                    $this->other->addErrorMessage(str_replace("%s", $this->other->caption(), $this->other->RequiredErrorMessage));
                }
            }
            if ($this->admin_mobile->Visible && $this->admin_mobile->Required) {
                if (!$this->admin_mobile->IsDetailKey && EmptyValue($this->admin_mobile->FormValue)) {
                    $this->admin_mobile->addErrorMessage(str_replace("%s", $this->admin_mobile->caption(), $this->admin_mobile->RequiredErrorMessage));
                }
            }
            if ($this->header->Visible && $this->header->Required) {
                if (!$this->header->IsDetailKey && EmptyValue($this->header->FormValue)) {
                    $this->header->addErrorMessage(str_replace("%s", $this->header->caption(), $this->header->RequiredErrorMessage));
                }
            }
            if ($this->footer->Visible && $this->footer->Required) {
                if (!$this->footer->IsDetailKey && EmptyValue($this->footer->FormValue)) {
                    $this->footer->addErrorMessage(str_replace("%s", $this->footer->caption(), $this->footer->RequiredErrorMessage));
                }
            }
            if ($this->tag_line->Visible && $this->tag_line->Required) {
                if (!$this->tag_line->IsDetailKey && EmptyValue($this->tag_line->FormValue)) {
                    $this->tag_line->addErrorMessage(str_replace("%s", $this->tag_line->caption(), $this->tag_line->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->logo->Visible && !$this->logo->Upload->KeepFile) {
            $this->logo->UploadPath = $this->logo->getUploadPath();
            if (!EmptyValue($this->logo->Upload->FileName)) {
                FixUploadFileNames($this->logo);
                $this->logo->setDbValueDef($rsnew, $this->logo->Upload->FileName, $this->logo->ReadOnly);
            }
        }
        if ($this->mobile_logo->Visible && !$this->mobile_logo->Upload->KeepFile) {
            $this->mobile_logo->UploadPath = $this->mobile_logo->getUploadPath();
            if (!EmptyValue($this->mobile_logo->Upload->FileName)) {
                FixUploadFileNames($this->mobile_logo);
                $this->mobile_logo->setDbValueDef($rsnew, $this->mobile_logo->Upload->FileName, $this->mobile_logo->ReadOnly);
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
                if ($this->logo->Visible && !$this->logo->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->logo, $rsnew['logo'], false)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
                if ($this->mobile_logo->Visible && !$this->mobile_logo->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->mobile_logo, $rsnew['mobile_logo'], false)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->logo->OldUploadPath = $this->logo->getUploadPath(); // PHP
        $this->logo->UploadPath = $this->logo->OldUploadPath;
        $this->mobile_logo->OldUploadPath = $this->mobile_logo->getUploadPath(); // PHP
        $this->mobile_logo->UploadPath = $this->mobile_logo->OldUploadPath;
        $this->fav_icon->OldUploadPath = $this->fav_icon->getUploadPath(); // PHP
        $this->fav_icon->UploadPath = $this->fav_icon->OldUploadPath;
        $rsnew = [];

        // logo
        if ($this->logo->Visible && !$this->logo->ReadOnly && !$this->logo->Upload->KeepFile) {
            if ($this->logo->Upload->FileName == "") {
                $rsnew['logo'] = null;
            } else {
                FixUploadTempFileNames($this->logo);
                $rsnew['logo'] = $this->logo->Upload->FileName;
            }
        }

        // mobile_logo
        if ($this->mobile_logo->Visible && !$this->mobile_logo->ReadOnly && !$this->mobile_logo->Upload->KeepFile) {
            if ($this->mobile_logo->Upload->FileName == "") {
                $rsnew['mobile_logo'] = null;
            } else {
                FixUploadTempFileNames($this->mobile_logo);
                $rsnew['mobile_logo'] = $this->mobile_logo->Upload->FileName;
            }
        }

        // name
        $this->name->setDbValueDef($rsnew, $this->name->CurrentValue, $this->name->ReadOnly);

        // address
        $this->address->setDbValueDef($rsnew, $this->address->CurrentValue, $this->address->ReadOnly);

        // email
        $this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, $this->_email->ReadOnly);

        // mobile
        $this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, $this->mobile->ReadOnly);

        // gst
        $this->gst->setDbValueDef($rsnew, $this->gst->CurrentValue, $this->gst->ReadOnly);

        // other
        $this->other->setDbValueDef($rsnew, $this->other->CurrentValue, $this->other->ReadOnly);

        // admin_mobile
        $this->admin_mobile->setDbValueDef($rsnew, $this->admin_mobile->CurrentValue, $this->admin_mobile->ReadOnly);

        // header
        $this->header->setDbValueDef($rsnew, $this->header->CurrentValue, $this->header->ReadOnly);

        // footer
        $this->footer->setDbValueDef($rsnew, $this->footer->CurrentValue, $this->footer->ReadOnly);

        // tag_line
        $this->tag_line->setDbValueDef($rsnew, $this->tag_line->CurrentValue, $this->tag_line->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['logo'])) { // logo
            $this->logo->CurrentValue = $row['logo'];
        }
        if (isset($row['mobile_logo'])) { // mobile_logo
            $this->mobile_logo->CurrentValue = $row['mobile_logo'];
        }
        if (isset($row['name'])) { // name
            $this->name->CurrentValue = $row['name'];
        }
        if (isset($row['address'])) { // address
            $this->address->CurrentValue = $row['address'];
        }
        if (isset($row['email'])) { // email
            $this->_email->CurrentValue = $row['email'];
        }
        if (isset($row['mobile'])) { // mobile
            $this->mobile->CurrentValue = $row['mobile'];
        }
        if (isset($row['gst'])) { // gst
            $this->gst->CurrentValue = $row['gst'];
        }
        if (isset($row['other'])) { // other
            $this->other->CurrentValue = $row['other'];
        }
        if (isset($row['admin_mobile'])) { // admin_mobile
            $this->admin_mobile->CurrentValue = $row['admin_mobile'];
        }
        if (isset($row['header'])) { // header
            $this->header->CurrentValue = $row['header'];
        }
        if (isset($row['footer'])) { // footer
            $this->footer->CurrentValue = $row['footer'];
        }
        if (isset($row['tag_line'])) { // tag_line
            $this->tag_line->CurrentValue = $row['tag_line'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("portalinfolist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload() {
    //echo "Page Unload";
    unlink('manifest.json');
    $name =ExecuteScalar("SELECT `name` FROM `portal_info` order by `id` Asc limit 1");
    $arr = Array (
    			"icons" => Array (
    				Array (
    				"src" => ".p_uploads/pi/icons/android-icon-36x36.png",
    				"sizes" => "36x36",
    				"type" => "image/png",
    				"density" => "0.75"			 	
    				),
    				Array (
    				"src" => ".p_uploads/pi/icons/android-icon-48x48.png",
    				"sizes" => "48x48",
    				"type" => "image/png",
    				"density" => "1.0"			 	
    				),
    				Array (
    				"src" => ".p_uploads/pi/icons/android-icon-72x72.png",
    				"sizes" => "72x72",
    				"type" => "image/png",
    				"density" => "1.5"			 	
    				),
    				Array (
    				"src" => ".p_uploads/pi/icons/android-icon-96x96.png",
    				"sizes" => "96x96",
    				"type" => "image/png",
    				"density" => "2.0"			 	
    				),
    				Array (
    				"src" => ".p_uploads/pi/icons/android-icon-144x144.png",
    				"sizes" => "144x144",
    				"type" => "image/png",
    				"density" => "3.0"			 	
    				),
    				Array (
    				"src" => ".p_uploads/pi/icons/android-icon-192x192.png",
    				"sizes" => "192x192",
    				"type" => "image/png",
    				"density" => "4.0"			 	
    				)
    			),
    		"name" => $name,
    		"short_name" => $name,
    		"start_url" => "db2",
    		"background_color" => "purple",
    		"description" => "Integer Systems. All rights reserved. Helpline +91 9829221171",
    		"display" => "standalone"	
    	);
    	$json = json_encode(($arr), JSON_PRETTY_PRINT);
    	$file = fopen('manifest.json','w+') or die("File not found");
    	fwrite($file, $json);
    	fclose($file);
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
