<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PoSetupDelete extends PoSetup
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PoSetupDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "posetupdelete";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->gst_included->setVisibility();
        $this->po_b_transfer->setVisibility();
        $this->po_b_sample_auto_auth->setVisibility();
        $this->po_s_sample_auto_auth->setVisibility();
        $this->po_cbm->setVisibility();
        $this->po_buyer_uid->setVisibility();
        $this->po_gst->setVisibility();
        $this->po_sqm->setVisibility();
        $this->po_prod_price->setVisibility();
        $this->po_size->setVisibility();
        $this->po_bom->setVisibility();
        $this->po_process->setVisibility();
        $this->po_buyer_code_prod->setVisibility();
        $this->mr_live_datetime->setVisibility();
        $this->po_b_unauthorize->setVisibility();
        $this->cart_b_password->setVisibility();
        $this->cart_s_password->setVisibility();
        $this->jc_po_yesno->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'po_setup';
        $this->TableName = 'po_setup';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (po_setup)
        if (!isset($GLOBALS["po_setup"]) || $GLOBALS["po_setup"]::class == PROJECT_NAMESPACE . "po_setup") {
            $GLOBALS["po_setup"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_setup');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->gst_included);
        $this->setupLookupOptions($this->po_b_transfer);
        $this->setupLookupOptions($this->po_b_sample_auto_auth);
        $this->setupLookupOptions($this->po_s_sample_auto_auth);
        $this->setupLookupOptions($this->po_cbm);
        $this->setupLookupOptions($this->po_buyer_uid);
        $this->setupLookupOptions($this->po_gst);
        $this->setupLookupOptions($this->po_sqm);
        $this->setupLookupOptions($this->po_prod_price);
        $this->setupLookupOptions($this->po_b_unauthorize);
        $this->setupLookupOptions($this->jc_po_yesno);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("posetuplist"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson(["success" => false, "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            $this->Recordset = $this->loadRecordset();
            if ($this->TotalRecords <= 0) { // No record found, exit
                $this->Recordset?->free();
                $this->terminate("posetuplist"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->gst_included->setDbValue($row['gst_included']);
        $this->po_b_transfer->setDbValue($row['po_b_transfer']);
        $this->po_b_sample_auto_auth->setDbValue($row['po_b_sample_auto_auth']);
        $this->po_s_sample_auto_auth->setDbValue($row['po_s_sample_auto_auth']);
        $this->po_cbm->setDbValue($row['po_cbm']);
        $this->po_buyer_uid->setDbValue($row['po_buyer_uid']);
        $this->po_gst->setDbValue($row['po_gst']);
        $this->po_sqm->setDbValue($row['po_sqm']);
        $this->po_prod_price->setDbValue($row['po_prod_price']);
        $this->po_size->setDbValue($row['po_size']);
        $this->po_bom->setDbValue($row['po_bom']);
        $this->po_process->setDbValue($row['po_process']);
        $this->po_buyer_code_prod->setDbValue($row['po_buyer_code_prod']);
        $this->mr_live_datetime->setDbValue($row['mr_live_datetime']);
        $this->po_b_unauthorize->setDbValue($row['po_b_unauthorize']);
        $this->cart_b_password->setDbValue($row['cart_b_password']);
        $this->cart_s_password->setDbValue($row['cart_s_password']);
        $this->jc_po_yesno->setDbValue($row['jc_po_yesno']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['gst_included'] = $this->gst_included->DefaultValue;
        $row['po_b_transfer'] = $this->po_b_transfer->DefaultValue;
        $row['po_b_sample_auto_auth'] = $this->po_b_sample_auto_auth->DefaultValue;
        $row['po_s_sample_auto_auth'] = $this->po_s_sample_auto_auth->DefaultValue;
        $row['po_cbm'] = $this->po_cbm->DefaultValue;
        $row['po_buyer_uid'] = $this->po_buyer_uid->DefaultValue;
        $row['po_gst'] = $this->po_gst->DefaultValue;
        $row['po_sqm'] = $this->po_sqm->DefaultValue;
        $row['po_prod_price'] = $this->po_prod_price->DefaultValue;
        $row['po_size'] = $this->po_size->DefaultValue;
        $row['po_bom'] = $this->po_bom->DefaultValue;
        $row['po_process'] = $this->po_process->DefaultValue;
        $row['po_buyer_code_prod'] = $this->po_buyer_code_prod->DefaultValue;
        $row['mr_live_datetime'] = $this->mr_live_datetime->DefaultValue;
        $row['po_b_unauthorize'] = $this->po_b_unauthorize->DefaultValue;
        $row['cart_b_password'] = $this->cart_b_password->DefaultValue;
        $row['cart_s_password'] = $this->cart_s_password->DefaultValue;
        $row['jc_po_yesno'] = $this->jc_po_yesno->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // gst_included

        // po_b_transfer

        // po_b_sample_auto_auth

        // po_s_sample_auto_auth

        // po_cbm

        // po_buyer_uid

        // po_gst

        // po_sqm

        // po_prod_price

        // po_size

        // po_bom

        // po_process

        // po_buyer_code_prod

        // mr_live_datetime

        // po_b_unauthorize

        // cart_b_password

        // cart_s_password

        // jc_po_yesno

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // gst_included
            if (strval($this->gst_included->CurrentValue) != "") {
                $this->gst_included->ViewValue = $this->gst_included->optionCaption($this->gst_included->CurrentValue);
            } else {
                $this->gst_included->ViewValue = null;
            }

            // po_b_transfer
            if (strval($this->po_b_transfer->CurrentValue) != "") {
                $this->po_b_transfer->ViewValue = $this->po_b_transfer->optionCaption($this->po_b_transfer->CurrentValue);
            } else {
                $this->po_b_transfer->ViewValue = null;
            }

            // po_b_sample_auto_auth
            if (strval($this->po_b_sample_auto_auth->CurrentValue) != "") {
                $this->po_b_sample_auto_auth->ViewValue = $this->po_b_sample_auto_auth->optionCaption($this->po_b_sample_auto_auth->CurrentValue);
            } else {
                $this->po_b_sample_auto_auth->ViewValue = null;
            }

            // po_s_sample_auto_auth
            if (strval($this->po_s_sample_auto_auth->CurrentValue) != "") {
                $this->po_s_sample_auto_auth->ViewValue = $this->po_s_sample_auto_auth->optionCaption($this->po_s_sample_auto_auth->CurrentValue);
            } else {
                $this->po_s_sample_auto_auth->ViewValue = null;
            }

            // po_cbm
            if (strval($this->po_cbm->CurrentValue) != "") {
                $this->po_cbm->ViewValue = $this->po_cbm->optionCaption($this->po_cbm->CurrentValue);
            } else {
                $this->po_cbm->ViewValue = null;
            }

            // po_buyer_uid
            if (strval($this->po_buyer_uid->CurrentValue) != "") {
                $this->po_buyer_uid->ViewValue = $this->po_buyer_uid->optionCaption($this->po_buyer_uid->CurrentValue);
            } else {
                $this->po_buyer_uid->ViewValue = null;
            }

            // po_gst
            if (strval($this->po_gst->CurrentValue) != "") {
                $this->po_gst->ViewValue = $this->po_gst->optionCaption($this->po_gst->CurrentValue);
            } else {
                $this->po_gst->ViewValue = null;
            }

            // po_sqm
            if (strval($this->po_sqm->CurrentValue) != "") {
                $this->po_sqm->ViewValue = $this->po_sqm->optionCaption($this->po_sqm->CurrentValue);
            } else {
                $this->po_sqm->ViewValue = null;
            }

            // po_prod_price
            if (strval($this->po_prod_price->CurrentValue) != "") {
                $this->po_prod_price->ViewValue = $this->po_prod_price->optionCaption($this->po_prod_price->CurrentValue);
            } else {
                $this->po_prod_price->ViewValue = null;
            }

            // po_size
            $this->po_size->ViewValue = $this->po_size->CurrentValue;
            $this->po_size->ViewValue = FormatNumber($this->po_size->ViewValue, $this->po_size->formatPattern());

            // po_bom
            $this->po_bom->ViewValue = $this->po_bom->CurrentValue;
            $this->po_bom->ViewValue = FormatNumber($this->po_bom->ViewValue, $this->po_bom->formatPattern());

            // po_process
            $this->po_process->ViewValue = $this->po_process->CurrentValue;
            $this->po_process->ViewValue = FormatNumber($this->po_process->ViewValue, $this->po_process->formatPattern());

            // po_buyer_code_prod
            $this->po_buyer_code_prod->ViewValue = $this->po_buyer_code_prod->CurrentValue;
            $this->po_buyer_code_prod->ViewValue = FormatNumber($this->po_buyer_code_prod->ViewValue, $this->po_buyer_code_prod->formatPattern());

            // mr_live_datetime
            $this->mr_live_datetime->ViewValue = $this->mr_live_datetime->CurrentValue;
            $this->mr_live_datetime->ViewValue = FormatDateTime($this->mr_live_datetime->ViewValue, $this->mr_live_datetime->formatPattern());

            // po_b_unauthorize
            $curVal = strval($this->po_b_unauthorize->CurrentValue);
            if ($curVal != "") {
                $this->po_b_unauthorize->ViewValue = $this->po_b_unauthorize->lookupCacheOption($curVal);
                if ($this->po_b_unauthorize->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->po_b_unauthorize->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->po_b_unauthorize->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->po_b_unauthorize->getSelectFilter($this); // PHP
                    $sqlWrk = $this->po_b_unauthorize->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->po_b_unauthorize->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->po_b_unauthorize->Lookup->renderViewRow($row);
                            $this->po_b_unauthorize->ViewValue->add($this->po_b_unauthorize->displayValue($arwrk));
                        }
                    } else {
                        $this->po_b_unauthorize->ViewValue = $this->po_b_unauthorize->CurrentValue;
                    }
                }
            } else {
                $this->po_b_unauthorize->ViewValue = null;
            }

            // cart_b_password
            $this->cart_b_password->ViewValue = $this->cart_b_password->CurrentValue;

            // cart_s_password
            $this->cart_s_password->ViewValue = $this->cart_s_password->CurrentValue;

            // jc_po_yesno
            $this->jc_po_yesno->ViewValue = $this->jc_po_yesno->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // gst_included
            $this->gst_included->HrefValue = "";
            $this->gst_included->TooltipValue = "";

            // po_b_transfer
            $this->po_b_transfer->HrefValue = "";
            $this->po_b_transfer->TooltipValue = "";

            // po_b_sample_auto_auth
            $this->po_b_sample_auto_auth->HrefValue = "";
            $this->po_b_sample_auto_auth->TooltipValue = "";

            // po_s_sample_auto_auth
            $this->po_s_sample_auto_auth->HrefValue = "";
            $this->po_s_sample_auto_auth->TooltipValue = "";

            // po_cbm
            $this->po_cbm->HrefValue = "";
            $this->po_cbm->TooltipValue = "";

            // po_buyer_uid
            $this->po_buyer_uid->HrefValue = "";
            $this->po_buyer_uid->TooltipValue = "";

            // po_gst
            $this->po_gst->HrefValue = "";
            $this->po_gst->TooltipValue = "";

            // po_sqm
            $this->po_sqm->HrefValue = "";
            $this->po_sqm->TooltipValue = "";

            // po_prod_price
            $this->po_prod_price->HrefValue = "";
            $this->po_prod_price->TooltipValue = "";

            // po_size
            $this->po_size->HrefValue = "";
            $this->po_size->TooltipValue = "";

            // po_bom
            $this->po_bom->HrefValue = "";
            $this->po_bom->TooltipValue = "";

            // po_process
            $this->po_process->HrefValue = "";
            $this->po_process->TooltipValue = "";

            // po_buyer_code_prod
            $this->po_buyer_code_prod->HrefValue = "";
            $this->po_buyer_code_prod->TooltipValue = "";

            // mr_live_datetime
            $this->mr_live_datetime->HrefValue = "";
            $this->mr_live_datetime->TooltipValue = "";

            // po_b_unauthorize
            $this->po_b_unauthorize->HrefValue = "";
            $this->po_b_unauthorize->TooltipValue = "";

            // cart_b_password
            $this->cart_b_password->HrefValue = "";
            $this->cart_b_password->TooltipValue = "";

            // cart_s_password
            $this->cart_s_password->HrefValue = "";
            $this->cart_s_password->TooltipValue = "";

            // jc_po_yesno
            $this->jc_po_yesno->HrefValue = "";
            $this->jc_po_yesno->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Param("key_m") === null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("posetuplist"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_gst_included":
                    break;
                case "x_po_b_transfer":
                    break;
                case "x_po_b_sample_auto_auth":
                    break;
                case "x_po_s_sample_auto_auth":
                    break;
                case "x_po_cbm":
                    break;
                case "x_po_buyer_uid":
                    break;
                case "x_po_gst":
                    break;
                case "x_po_sqm":
                    break;
                case "x_po_prod_price":
                    break;
                case "x_po_b_unauthorize":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_jc_po_yesno":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
