<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for po_setup
 */
class PoSetup extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $gst_included;
    public $po_b_transfer;
    public $po_b_sample_auto_auth;
    public $po_s_sample_auto_auth;
    public $po_cbm;
    public $po_buyer_uid;
    public $po_gst;
    public $po_sqm;
    public $po_prod_price;
    public $po_size;
    public $po_bom;
    public $po_process;
    public $po_buyer_code_prod;
    public $mr_live_datetime;
    public $po_b_unauthorize;
    public $cart_b_password;
    public $cart_s_password;
    public $jc_po_yesno;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "po_setup";
        $this->TableName = 'po_setup';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "po_setup";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->Required = true; // Required field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // gst_included
        $this->gst_included = new DbField(
            $this, // Table
            'x_gst_included', // Variable name
            'gst_included', // Name
            '`gst_included`', // Expression
            '`gst_included`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gst_included`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->gst_included->addMethod("getDefault", fn() => 0);
        $this->gst_included->InputTextType = "text";
        $this->gst_included->Raw = true;
        $this->gst_included->Nullable = false; // NOT NULL field
        $this->gst_included->Required = true; // Required field
        $this->gst_included->setSelectMultiple(false); // Select one
        $this->gst_included->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->gst_included->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->gst_included->Lookup = new Lookup($this->gst_included, 'po_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->gst_included->OptionCount = 2;
        $this->gst_included->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->gst_included->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['gst_included'] = &$this->gst_included;

        // po_b_transfer
        $this->po_b_transfer = new DbField(
            $this, // Table
            'x_po_b_transfer', // Variable name
            'po_b_transfer', // Name
            '`po_b_transfer`', // Expression
            '`po_b_transfer`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_b_transfer`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->po_b_transfer->InputTextType = "text";
        $this->po_b_transfer->Raw = true;
        $this->po_b_transfer->Nullable = false; // NOT NULL field
        $this->po_b_transfer->setSelectMultiple(false); // Select one
        $this->po_b_transfer->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->po_b_transfer->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->po_b_transfer->Lookup = new Lookup($this->po_b_transfer, 'po_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->po_b_transfer->OptionCount = 2;
        $this->po_b_transfer->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_b_transfer->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['po_b_transfer'] = &$this->po_b_transfer;

        // po_b_sample_auto_auth
        $this->po_b_sample_auto_auth = new DbField(
            $this, // Table
            'x_po_b_sample_auto_auth', // Variable name
            'po_b_sample_auto_auth', // Name
            '`po_b_sample_auto_auth`', // Expression
            '`po_b_sample_auto_auth`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_b_sample_auto_auth`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->po_b_sample_auto_auth->addMethod("getDefault", fn() => 0);
        $this->po_b_sample_auto_auth->InputTextType = "text";
        $this->po_b_sample_auto_auth->Raw = true;
        $this->po_b_sample_auto_auth->Nullable = false; // NOT NULL field
        $this->po_b_sample_auto_auth->setSelectMultiple(false); // Select one
        $this->po_b_sample_auto_auth->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->po_b_sample_auto_auth->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->po_b_sample_auto_auth->Lookup = new Lookup($this->po_b_sample_auto_auth, 'po_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->po_b_sample_auto_auth->OptionCount = 2;
        $this->po_b_sample_auto_auth->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_b_sample_auto_auth->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['po_b_sample_auto_auth'] = &$this->po_b_sample_auto_auth;

        // po_s_sample_auto_auth
        $this->po_s_sample_auto_auth = new DbField(
            $this, // Table
            'x_po_s_sample_auto_auth', // Variable name
            'po_s_sample_auto_auth', // Name
            '`po_s_sample_auto_auth`', // Expression
            '`po_s_sample_auto_auth`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_s_sample_auto_auth`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->po_s_sample_auto_auth->addMethod("getDefault", fn() => 0);
        $this->po_s_sample_auto_auth->InputTextType = "text";
        $this->po_s_sample_auto_auth->Raw = true;
        $this->po_s_sample_auto_auth->Nullable = false; // NOT NULL field
        $this->po_s_sample_auto_auth->setSelectMultiple(false); // Select one
        $this->po_s_sample_auto_auth->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->po_s_sample_auto_auth->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->po_s_sample_auto_auth->Lookup = new Lookup($this->po_s_sample_auto_auth, 'po_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->po_s_sample_auto_auth->OptionCount = 2;
        $this->po_s_sample_auto_auth->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_s_sample_auto_auth->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['po_s_sample_auto_auth'] = &$this->po_s_sample_auto_auth;

        // po_cbm
        $this->po_cbm = new DbField(
            $this, // Table
            'x_po_cbm', // Variable name
            'po_cbm', // Name
            '`po_cbm`', // Expression
            '`po_cbm`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_cbm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->po_cbm->addMethod("getDefault", fn() => 0);
        $this->po_cbm->InputTextType = "text";
        $this->po_cbm->Raw = true;
        $this->po_cbm->Nullable = false; // NOT NULL field
        $this->po_cbm->Required = true; // Required field
        $this->po_cbm->setSelectMultiple(false); // Select one
        $this->po_cbm->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->po_cbm->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->po_cbm->Lookup = new Lookup($this->po_cbm, 'po_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->po_cbm->OptionCount = 2;
        $this->po_cbm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_cbm->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['po_cbm'] = &$this->po_cbm;

        // po_buyer_uid
        $this->po_buyer_uid = new DbField(
            $this, // Table
            'x_po_buyer_uid', // Variable name
            'po_buyer_uid', // Name
            '`po_buyer_uid`', // Expression
            '`po_buyer_uid`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_buyer_uid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->po_buyer_uid->addMethod("getDefault", fn() => 1);
        $this->po_buyer_uid->InputTextType = "text";
        $this->po_buyer_uid->Raw = true;
        $this->po_buyer_uid->Nullable = false; // NOT NULL field
        $this->po_buyer_uid->Required = true; // Required field
        $this->po_buyer_uid->setSelectMultiple(false); // Select one
        $this->po_buyer_uid->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->po_buyer_uid->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->po_buyer_uid->Lookup = new Lookup($this->po_buyer_uid, 'po_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->po_buyer_uid->OptionCount = 2;
        $this->po_buyer_uid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_buyer_uid->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['po_buyer_uid'] = &$this->po_buyer_uid;

        // po_gst
        $this->po_gst = new DbField(
            $this, // Table
            'x_po_gst', // Variable name
            'po_gst', // Name
            '`po_gst`', // Expression
            '`po_gst`', // Basic search expression
            16, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_gst`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->po_gst->addMethod("getDefault", fn() => 1);
        $this->po_gst->InputTextType = "text";
        $this->po_gst->Raw = true;
        $this->po_gst->Nullable = false; // NOT NULL field
        $this->po_gst->Required = true; // Required field
        $this->po_gst->setSelectMultiple(false); // Select one
        $this->po_gst->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->po_gst->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->po_gst->Lookup = new Lookup($this->po_gst, 'po_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->po_gst->OptionCount = 2;
        $this->po_gst->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_gst->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['po_gst'] = &$this->po_gst;

        // po_sqm
        $this->po_sqm = new DbField(
            $this, // Table
            'x_po_sqm', // Variable name
            'po_sqm', // Name
            '`po_sqm`', // Expression
            '`po_sqm`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->po_sqm->InputTextType = "text";
        $this->po_sqm->Raw = true;
        $this->po_sqm->Nullable = false; // NOT NULL field
        $this->po_sqm->Required = true; // Required field
        $this->po_sqm->setSelectMultiple(false); // Select one
        $this->po_sqm->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->po_sqm->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->po_sqm->Lookup = new Lookup($this->po_sqm, 'po_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->po_sqm->OptionCount = 2;
        $this->po_sqm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_sqm->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['po_sqm'] = &$this->po_sqm;

        // po_prod_price
        $this->po_prod_price = new DbField(
            $this, // Table
            'x_po_prod_price', // Variable name
            'po_prod_price', // Name
            '`po_prod_price`', // Expression
            '`po_prod_price`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_prod_price`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->po_prod_price->InputTextType = "text";
        $this->po_prod_price->Raw = true;
        $this->po_prod_price->Nullable = false; // NOT NULL field
        $this->po_prod_price->Required = true; // Required field
        $this->po_prod_price->setSelectMultiple(false); // Select one
        $this->po_prod_price->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->po_prod_price->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->po_prod_price->Lookup = new Lookup($this->po_prod_price, 'po_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->po_prod_price->OptionCount = 2;
        $this->po_prod_price->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_prod_price->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['po_prod_price'] = &$this->po_prod_price;

        // po_size
        $this->po_size = new DbField(
            $this, // Table
            'x_po_size', // Variable name
            'po_size', // Name
            '`po_size`', // Expression
            '`po_size`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_size`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_size->addMethod("getDefault", fn() => 0);
        $this->po_size->InputTextType = "text";
        $this->po_size->Raw = true;
        $this->po_size->Nullable = false; // NOT NULL field
        $this->po_size->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_size->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['po_size'] = &$this->po_size;

        // po_bom
        $this->po_bom = new DbField(
            $this, // Table
            'x_po_bom', // Variable name
            'po_bom', // Name
            '`po_bom`', // Expression
            '`po_bom`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_bom`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_bom->InputTextType = "text";
        $this->po_bom->Raw = true;
        $this->po_bom->Nullable = false; // NOT NULL field
        $this->po_bom->Required = true; // Required field
        $this->po_bom->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_bom->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['po_bom'] = &$this->po_bom;

        // po_process
        $this->po_process = new DbField(
            $this, // Table
            'x_po_process', // Variable name
            'po_process', // Name
            '`po_process`', // Expression
            '`po_process`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_process->InputTextType = "text";
        $this->po_process->Raw = true;
        $this->po_process->Nullable = false; // NOT NULL field
        $this->po_process->Required = true; // Required field
        $this->po_process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_process->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['po_process'] = &$this->po_process;

        // po_buyer_code_prod
        $this->po_buyer_code_prod = new DbField(
            $this, // Table
            'x_po_buyer_code_prod', // Variable name
            'po_buyer_code_prod', // Name
            '`po_buyer_code_prod`', // Expression
            '`po_buyer_code_prod`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_buyer_code_prod`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_buyer_code_prod->addMethod("getDefault", fn() => 0);
        $this->po_buyer_code_prod->InputTextType = "text";
        $this->po_buyer_code_prod->Raw = true;
        $this->po_buyer_code_prod->Nullable = false; // NOT NULL field
        $this->po_buyer_code_prod->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_buyer_code_prod->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['po_buyer_code_prod'] = &$this->po_buyer_code_prod;

        // mr_live_datetime
        $this->mr_live_datetime = new DbField(
            $this, // Table
            'x_mr_live_datetime', // Variable name
            'mr_live_datetime', // Name
            '`mr_live_datetime`', // Expression
            CastDateFieldForLike("`mr_live_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`mr_live_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->mr_live_datetime->InputTextType = "text";
        $this->mr_live_datetime->Raw = true;
        $this->mr_live_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->mr_live_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['mr_live_datetime'] = &$this->mr_live_datetime;

        // po_b_unauthorize
        $this->po_b_unauthorize = new DbField(
            $this, // Table
            'x_po_b_unauthorize', // Variable name
            'po_b_unauthorize', // Name
            '`po_b_unauthorize`', // Expression
            '`po_b_unauthorize`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_b_unauthorize`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->po_b_unauthorize->addMethod("getSelectFilter", fn() => "`activated`=1");
        $this->po_b_unauthorize->InputTextType = "text";
        $this->po_b_unauthorize->setSelectMultiple(true); // Select multiple
        $this->po_b_unauthorize->Lookup = new Lookup($this->po_b_unauthorize, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->po_b_unauthorize->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['po_b_unauthorize'] = &$this->po_b_unauthorize;

        // cart_b_password
        $this->cart_b_password = new DbField(
            $this, // Table
            'x_cart_b_password', // Variable name
            'cart_b_password', // Name
            '`cart_b_password`', // Expression
            '`cart_b_password`', // Basic search expression
            200, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cart_b_password`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cart_b_password->InputTextType = "text";
        $this->cart_b_password->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['cart_b_password'] = &$this->cart_b_password;

        // cart_s_password
        $this->cart_s_password = new DbField(
            $this, // Table
            'x_cart_s_password', // Variable name
            'cart_s_password', // Name
            '`cart_s_password`', // Expression
            '`cart_s_password`', // Basic search expression
            200, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cart_s_password`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cart_s_password->InputTextType = "text";
        $this->cart_s_password->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['cart_s_password'] = &$this->cart_s_password;

        // jc_po_yesno
        $this->jc_po_yesno = new DbField(
            $this, // Table
            'x_jc_po_yesno', // Variable name
            'jc_po_yesno', // Name
            '`jc_po_yesno`', // Expression
            '`jc_po_yesno`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_po_yesno`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_po_yesno->addMethod("getDefault", fn() => 0);
        $this->jc_po_yesno->InputTextType = "text";
        $this->jc_po_yesno->Raw = true;
        $this->jc_po_yesno->Nullable = false; // NOT NULL field
        $this->jc_po_yesno->Lookup = new Lookup($this->jc_po_yesno, 'po_setup', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->jc_po_yesno->OptionCount = 2;
        $this->jc_po_yesno->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_po_yesno->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['jc_po_yesno'] = &$this->jc_po_yesno;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "po_setup";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->gst_included->DbValue = $row['gst_included'];
        $this->po_b_transfer->DbValue = $row['po_b_transfer'];
        $this->po_b_sample_auto_auth->DbValue = $row['po_b_sample_auto_auth'];
        $this->po_s_sample_auto_auth->DbValue = $row['po_s_sample_auto_auth'];
        $this->po_cbm->DbValue = $row['po_cbm'];
        $this->po_buyer_uid->DbValue = $row['po_buyer_uid'];
        $this->po_gst->DbValue = $row['po_gst'];
        $this->po_sqm->DbValue = $row['po_sqm'];
        $this->po_prod_price->DbValue = $row['po_prod_price'];
        $this->po_size->DbValue = $row['po_size'];
        $this->po_bom->DbValue = $row['po_bom'];
        $this->po_process->DbValue = $row['po_process'];
        $this->po_buyer_code_prod->DbValue = $row['po_buyer_code_prod'];
        $this->mr_live_datetime->DbValue = $row['mr_live_datetime'];
        $this->po_b_unauthorize->DbValue = $row['po_b_unauthorize'];
        $this->cart_b_password->DbValue = $row['cart_b_password'];
        $this->cart_s_password->DbValue = $row['cart_s_password'];
        $this->jc_po_yesno->DbValue = $row['jc_po_yesno'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("posetuplist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "posetupview" => $Language->phrase("View"),
            "posetupedit" => $Language->phrase("Edit"),
            "posetupadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "posetuplist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "PoSetupView",
            Config("API_ADD_ACTION") => "PoSetupAdd",
            Config("API_EDIT_ACTION") => "PoSetupEdit",
            Config("API_DELETE_ACTION") => "PoSetupDelete",
            Config("API_LIST_ACTION") => "PoSetupList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "posetuplist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("posetupview", $parm);
        } else {
            $url = $this->keyUrl("posetupview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "posetupadd?" . $parm;
        } else {
            $url = "posetupadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("posetupedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("posetuplist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("posetupadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("posetuplist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("posetupdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->gst_included->setDbValue($row['gst_included']);
        $this->po_b_transfer->setDbValue($row['po_b_transfer']);
        $this->po_b_sample_auto_auth->setDbValue($row['po_b_sample_auto_auth']);
        $this->po_s_sample_auto_auth->setDbValue($row['po_s_sample_auto_auth']);
        $this->po_cbm->setDbValue($row['po_cbm']);
        $this->po_buyer_uid->setDbValue($row['po_buyer_uid']);
        $this->po_gst->setDbValue($row['po_gst']);
        $this->po_sqm->setDbValue($row['po_sqm']);
        $this->po_prod_price->setDbValue($row['po_prod_price']);
        $this->po_size->setDbValue($row['po_size']);
        $this->po_bom->setDbValue($row['po_bom']);
        $this->po_process->setDbValue($row['po_process']);
        $this->po_buyer_code_prod->setDbValue($row['po_buyer_code_prod']);
        $this->mr_live_datetime->setDbValue($row['mr_live_datetime']);
        $this->po_b_unauthorize->setDbValue($row['po_b_unauthorize']);
        $this->cart_b_password->setDbValue($row['cart_b_password']);
        $this->cart_s_password->setDbValue($row['cart_s_password']);
        $this->jc_po_yesno->setDbValue($row['jc_po_yesno']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "PoSetupList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // gst_included

        // po_b_transfer

        // po_b_sample_auto_auth

        // po_s_sample_auto_auth

        // po_cbm

        // po_buyer_uid

        // po_gst

        // po_sqm

        // po_prod_price

        // po_size

        // po_bom

        // po_process

        // po_buyer_code_prod

        // mr_live_datetime

        // po_b_unauthorize

        // cart_b_password

        // cart_s_password

        // jc_po_yesno

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

        // gst_included
        if (strval($this->gst_included->CurrentValue) != "") {
            $this->gst_included->ViewValue = $this->gst_included->optionCaption($this->gst_included->CurrentValue);
        } else {
            $this->gst_included->ViewValue = null;
        }

        // po_b_transfer
        if (strval($this->po_b_transfer->CurrentValue) != "") {
            $this->po_b_transfer->ViewValue = $this->po_b_transfer->optionCaption($this->po_b_transfer->CurrentValue);
        } else {
            $this->po_b_transfer->ViewValue = null;
        }

        // po_b_sample_auto_auth
        if (strval($this->po_b_sample_auto_auth->CurrentValue) != "") {
            $this->po_b_sample_auto_auth->ViewValue = $this->po_b_sample_auto_auth->optionCaption($this->po_b_sample_auto_auth->CurrentValue);
        } else {
            $this->po_b_sample_auto_auth->ViewValue = null;
        }

        // po_s_sample_auto_auth
        if (strval($this->po_s_sample_auto_auth->CurrentValue) != "") {
            $this->po_s_sample_auto_auth->ViewValue = $this->po_s_sample_auto_auth->optionCaption($this->po_s_sample_auto_auth->CurrentValue);
        } else {
            $this->po_s_sample_auto_auth->ViewValue = null;
        }

        // po_cbm
        if (strval($this->po_cbm->CurrentValue) != "") {
            $this->po_cbm->ViewValue = $this->po_cbm->optionCaption($this->po_cbm->CurrentValue);
        } else {
            $this->po_cbm->ViewValue = null;
        }

        // po_buyer_uid
        if (strval($this->po_buyer_uid->CurrentValue) != "") {
            $this->po_buyer_uid->ViewValue = $this->po_buyer_uid->optionCaption($this->po_buyer_uid->CurrentValue);
        } else {
            $this->po_buyer_uid->ViewValue = null;
        }

        // po_gst
        if (strval($this->po_gst->CurrentValue) != "") {
            $this->po_gst->ViewValue = $this->po_gst->optionCaption($this->po_gst->CurrentValue);
        } else {
            $this->po_gst->ViewValue = null;
        }

        // po_sqm
        if (strval($this->po_sqm->CurrentValue) != "") {
            $this->po_sqm->ViewValue = $this->po_sqm->optionCaption($this->po_sqm->CurrentValue);
        } else {
            $this->po_sqm->ViewValue = null;
        }

        // po_prod_price
        if (strval($this->po_prod_price->CurrentValue) != "") {
            $this->po_prod_price->ViewValue = $this->po_prod_price->optionCaption($this->po_prod_price->CurrentValue);
        } else {
            $this->po_prod_price->ViewValue = null;
        }

        // po_size
        $this->po_size->ViewValue = $this->po_size->CurrentValue;
        $this->po_size->ViewValue = FormatNumber($this->po_size->ViewValue, $this->po_size->formatPattern());

        // po_bom
        $this->po_bom->ViewValue = $this->po_bom->CurrentValue;
        $this->po_bom->ViewValue = FormatNumber($this->po_bom->ViewValue, $this->po_bom->formatPattern());

        // po_process
        $this->po_process->ViewValue = $this->po_process->CurrentValue;
        $this->po_process->ViewValue = FormatNumber($this->po_process->ViewValue, $this->po_process->formatPattern());

        // po_buyer_code_prod
        $this->po_buyer_code_prod->ViewValue = $this->po_buyer_code_prod->CurrentValue;
        $this->po_buyer_code_prod->ViewValue = FormatNumber($this->po_buyer_code_prod->ViewValue, $this->po_buyer_code_prod->formatPattern());

        // mr_live_datetime
        $this->mr_live_datetime->ViewValue = $this->mr_live_datetime->CurrentValue;
        $this->mr_live_datetime->ViewValue = FormatDateTime($this->mr_live_datetime->ViewValue, $this->mr_live_datetime->formatPattern());

        // po_b_unauthorize
        $curVal = strval($this->po_b_unauthorize->CurrentValue);
        if ($curVal != "") {
            $this->po_b_unauthorize->ViewValue = $this->po_b_unauthorize->lookupCacheOption($curVal);
            if ($this->po_b_unauthorize->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->po_b_unauthorize->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->po_b_unauthorize->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->po_b_unauthorize->getSelectFilter($this); // PHP
                $sqlWrk = $this->po_b_unauthorize->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->po_b_unauthorize->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->po_b_unauthorize->Lookup->renderViewRow($row);
                        $this->po_b_unauthorize->ViewValue->add($this->po_b_unauthorize->displayValue($arwrk));
                    }
                } else {
                    $this->po_b_unauthorize->ViewValue = $this->po_b_unauthorize->CurrentValue;
                }
            }
        } else {
            $this->po_b_unauthorize->ViewValue = null;
        }

        // cart_b_password
        $this->cart_b_password->ViewValue = $this->cart_b_password->CurrentValue;

        // cart_s_password
        $this->cart_s_password->ViewValue = $this->cart_s_password->CurrentValue;

        // jc_po_yesno
        $this->jc_po_yesno->ViewValue = $this->jc_po_yesno->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // gst_included
        $this->gst_included->HrefValue = "";
        $this->gst_included->TooltipValue = "";

        // po_b_transfer
        $this->po_b_transfer->HrefValue = "";
        $this->po_b_transfer->TooltipValue = "";

        // po_b_sample_auto_auth
        $this->po_b_sample_auto_auth->HrefValue = "";
        $this->po_b_sample_auto_auth->TooltipValue = "";

        // po_s_sample_auto_auth
        $this->po_s_sample_auto_auth->HrefValue = "";
        $this->po_s_sample_auto_auth->TooltipValue = "";

        // po_cbm
        $this->po_cbm->HrefValue = "";
        $this->po_cbm->TooltipValue = "";

        // po_buyer_uid
        $this->po_buyer_uid->HrefValue = "";
        $this->po_buyer_uid->TooltipValue = "";

        // po_gst
        $this->po_gst->HrefValue = "";
        $this->po_gst->TooltipValue = "";

        // po_sqm
        $this->po_sqm->HrefValue = "";
        $this->po_sqm->TooltipValue = "";

        // po_prod_price
        $this->po_prod_price->HrefValue = "";
        $this->po_prod_price->TooltipValue = "";

        // po_size
        $this->po_size->HrefValue = "";
        $this->po_size->TooltipValue = "";

        // po_bom
        $this->po_bom->HrefValue = "";
        $this->po_bom->TooltipValue = "";

        // po_process
        $this->po_process->HrefValue = "";
        $this->po_process->TooltipValue = "";

        // po_buyer_code_prod
        $this->po_buyer_code_prod->HrefValue = "";
        $this->po_buyer_code_prod->TooltipValue = "";

        // mr_live_datetime
        $this->mr_live_datetime->HrefValue = "";
        $this->mr_live_datetime->TooltipValue = "";

        // po_b_unauthorize
        $this->po_b_unauthorize->HrefValue = "";
        $this->po_b_unauthorize->TooltipValue = "";

        // cart_b_password
        $this->cart_b_password->HrefValue = "";
        $this->cart_b_password->TooltipValue = "";

        // cart_s_password
        $this->cart_s_password->HrefValue = "";
        $this->cart_s_password->TooltipValue = "";

        // jc_po_yesno
        $this->jc_po_yesno->HrefValue = "";
        $this->jc_po_yesno->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->PlaceHolder = RemoveHtml($this->id->caption());

        // gst_included
        $this->gst_included->setupEditAttributes();
        $this->gst_included->EditValue = $this->gst_included->options(true);
        $this->gst_included->PlaceHolder = RemoveHtml($this->gst_included->caption());

        // po_b_transfer
        $this->po_b_transfer->setupEditAttributes();
        $this->po_b_transfer->EditValue = $this->po_b_transfer->options(true);
        $this->po_b_transfer->PlaceHolder = RemoveHtml($this->po_b_transfer->caption());

        // po_b_sample_auto_auth
        $this->po_b_sample_auto_auth->setupEditAttributes();
        $this->po_b_sample_auto_auth->EditValue = $this->po_b_sample_auto_auth->options(true);
        $this->po_b_sample_auto_auth->PlaceHolder = RemoveHtml($this->po_b_sample_auto_auth->caption());

        // po_s_sample_auto_auth
        $this->po_s_sample_auto_auth->setupEditAttributes();
        $this->po_s_sample_auto_auth->EditValue = $this->po_s_sample_auto_auth->options(true);
        $this->po_s_sample_auto_auth->PlaceHolder = RemoveHtml($this->po_s_sample_auto_auth->caption());

        // po_cbm
        $this->po_cbm->setupEditAttributes();
        $this->po_cbm->EditValue = $this->po_cbm->options(true);
        $this->po_cbm->PlaceHolder = RemoveHtml($this->po_cbm->caption());

        // po_buyer_uid
        $this->po_buyer_uid->setupEditAttributes();
        $this->po_buyer_uid->EditValue = $this->po_buyer_uid->options(true);
        $this->po_buyer_uid->PlaceHolder = RemoveHtml($this->po_buyer_uid->caption());

        // po_gst
        $this->po_gst->setupEditAttributes();
        $this->po_gst->EditValue = $this->po_gst->options(true);
        $this->po_gst->PlaceHolder = RemoveHtml($this->po_gst->caption());

        // po_sqm
        $this->po_sqm->setupEditAttributes();
        $this->po_sqm->EditValue = $this->po_sqm->options(true);
        $this->po_sqm->PlaceHolder = RemoveHtml($this->po_sqm->caption());

        // po_prod_price
        $this->po_prod_price->setupEditAttributes();
        $this->po_prod_price->EditValue = $this->po_prod_price->options(true);
        $this->po_prod_price->PlaceHolder = RemoveHtml($this->po_prod_price->caption());

        // po_size
        $this->po_size->setupEditAttributes();
        $this->po_size->EditValue = $this->po_size->CurrentValue;
        $this->po_size->PlaceHolder = RemoveHtml($this->po_size->caption());
        if (strval($this->po_size->EditValue) != "" && is_numeric($this->po_size->EditValue)) {
            $this->po_size->EditValue = FormatNumber($this->po_size->EditValue, null);
        }

        // po_bom
        $this->po_bom->setupEditAttributes();
        $this->po_bom->EditValue = $this->po_bom->CurrentValue;
        $this->po_bom->PlaceHolder = RemoveHtml($this->po_bom->caption());
        if (strval($this->po_bom->EditValue) != "" && is_numeric($this->po_bom->EditValue)) {
            $this->po_bom->EditValue = FormatNumber($this->po_bom->EditValue, null);
        }

        // po_process
        $this->po_process->setupEditAttributes();
        $this->po_process->EditValue = $this->po_process->CurrentValue;
        $this->po_process->PlaceHolder = RemoveHtml($this->po_process->caption());
        if (strval($this->po_process->EditValue) != "" && is_numeric($this->po_process->EditValue)) {
            $this->po_process->EditValue = FormatNumber($this->po_process->EditValue, null);
        }

        // po_buyer_code_prod
        $this->po_buyer_code_prod->setupEditAttributes();
        $this->po_buyer_code_prod->EditValue = $this->po_buyer_code_prod->CurrentValue;
        $this->po_buyer_code_prod->PlaceHolder = RemoveHtml($this->po_buyer_code_prod->caption());
        if (strval($this->po_buyer_code_prod->EditValue) != "" && is_numeric($this->po_buyer_code_prod->EditValue)) {
            $this->po_buyer_code_prod->EditValue = FormatNumber($this->po_buyer_code_prod->EditValue, null);
        }

        // mr_live_datetime
        $this->mr_live_datetime->setupEditAttributes();
        $this->mr_live_datetime->EditValue = FormatDateTime($this->mr_live_datetime->CurrentValue, $this->mr_live_datetime->formatPattern());
        $this->mr_live_datetime->PlaceHolder = RemoveHtml($this->mr_live_datetime->caption());

        // po_b_unauthorize
        $this->po_b_unauthorize->setupEditAttributes();
        $this->po_b_unauthorize->PlaceHolder = RemoveHtml($this->po_b_unauthorize->caption());

        // cart_b_password
        $this->cart_b_password->setupEditAttributes();
        if (!$this->cart_b_password->Raw) {
            $this->cart_b_password->CurrentValue = HtmlDecode($this->cart_b_password->CurrentValue);
        }
        $this->cart_b_password->EditValue = $this->cart_b_password->CurrentValue;
        $this->cart_b_password->PlaceHolder = RemoveHtml($this->cart_b_password->caption());

        // cart_s_password
        $this->cart_s_password->setupEditAttributes();
        if (!$this->cart_s_password->Raw) {
            $this->cart_s_password->CurrentValue = HtmlDecode($this->cart_s_password->CurrentValue);
        }
        $this->cart_s_password->EditValue = $this->cart_s_password->CurrentValue;
        $this->cart_s_password->PlaceHolder = RemoveHtml($this->cart_s_password->caption());

        // jc_po_yesno
        $this->jc_po_yesno->setupEditAttributes();
        $this->jc_po_yesno->EditValue = $this->jc_po_yesno->CurrentValue;
        $this->jc_po_yesno->PlaceHolder = RemoveHtml($this->jc_po_yesno->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->gst_included);
                    $doc->exportCaption($this->po_b_transfer);
                    $doc->exportCaption($this->po_b_sample_auto_auth);
                    $doc->exportCaption($this->po_s_sample_auto_auth);
                    $doc->exportCaption($this->po_cbm);
                    $doc->exportCaption($this->po_buyer_uid);
                    $doc->exportCaption($this->po_gst);
                    $doc->exportCaption($this->po_sqm);
                    $doc->exportCaption($this->po_prod_price);
                    $doc->exportCaption($this->po_size);
                    $doc->exportCaption($this->po_bom);
                    $doc->exportCaption($this->po_process);
                    $doc->exportCaption($this->po_buyer_code_prod);
                    $doc->exportCaption($this->mr_live_datetime);
                    $doc->exportCaption($this->po_b_unauthorize);
                    $doc->exportCaption($this->cart_b_password);
                    $doc->exportCaption($this->cart_s_password);
                    $doc->exportCaption($this->jc_po_yesno);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->gst_included);
                    $doc->exportCaption($this->po_b_transfer);
                    $doc->exportCaption($this->po_b_sample_auto_auth);
                    $doc->exportCaption($this->po_s_sample_auto_auth);
                    $doc->exportCaption($this->po_cbm);
                    $doc->exportCaption($this->po_buyer_uid);
                    $doc->exportCaption($this->po_gst);
                    $doc->exportCaption($this->po_sqm);
                    $doc->exportCaption($this->po_prod_price);
                    $doc->exportCaption($this->po_size);
                    $doc->exportCaption($this->po_bom);
                    $doc->exportCaption($this->po_process);
                    $doc->exportCaption($this->po_buyer_code_prod);
                    $doc->exportCaption($this->mr_live_datetime);
                    $doc->exportCaption($this->po_b_unauthorize);
                    $doc->exportCaption($this->cart_b_password);
                    $doc->exportCaption($this->cart_s_password);
                    $doc->exportCaption($this->jc_po_yesno);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->gst_included);
                        $doc->exportField($this->po_b_transfer);
                        $doc->exportField($this->po_b_sample_auto_auth);
                        $doc->exportField($this->po_s_sample_auto_auth);
                        $doc->exportField($this->po_cbm);
                        $doc->exportField($this->po_buyer_uid);
                        $doc->exportField($this->po_gst);
                        $doc->exportField($this->po_sqm);
                        $doc->exportField($this->po_prod_price);
                        $doc->exportField($this->po_size);
                        $doc->exportField($this->po_bom);
                        $doc->exportField($this->po_process);
                        $doc->exportField($this->po_buyer_code_prod);
                        $doc->exportField($this->mr_live_datetime);
                        $doc->exportField($this->po_b_unauthorize);
                        $doc->exportField($this->cart_b_password);
                        $doc->exportField($this->cart_s_password);
                        $doc->exportField($this->jc_po_yesno);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->gst_included);
                        $doc->exportField($this->po_b_transfer);
                        $doc->exportField($this->po_b_sample_auto_auth);
                        $doc->exportField($this->po_s_sample_auto_auth);
                        $doc->exportField($this->po_cbm);
                        $doc->exportField($this->po_buyer_uid);
                        $doc->exportField($this->po_gst);
                        $doc->exportField($this->po_sqm);
                        $doc->exportField($this->po_prod_price);
                        $doc->exportField($this->po_size);
                        $doc->exportField($this->po_bom);
                        $doc->exportField($this->po_process);
                        $doc->exportField($this->po_buyer_code_prod);
                        $doc->exportField($this->mr_live_datetime);
                        $doc->exportField($this->po_b_unauthorize);
                        $doc->exportField($this->cart_b_password);
                        $doc->exportField($this->cart_s_password);
                        $doc->exportField($this->jc_po_yesno);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
