<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PoSearch extends Po
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PoSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "posearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->order_type->setVisibility();
        $this->buyer_id->setVisibility();
        $this->buyer_order_no->setVisibility();
        $this->buyer_order_date->setVisibility();
        $this->cart_id->setVisibility();
        $this->buyer_product_ref->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->despatch_date->Visible = false;
        $this->despatch_week->setVisibility();
        $this->fob_date->Visible = false;
        $this->part_dispatch->Visible = false;
        $this->payment_terms->setVisibility();
        $this->transport_terms->setVisibility();
        $this->buyer_shipping_id->setVisibility();
        $this->description_04->Visible = false;
        $this->description_03->setVisibility();
        $this->description_01->Visible = false;
        $this->description_02->Visible = false;
        $this->description_07->setVisibility();
        $this->description_20->setVisibility();
        $this->description_17->setVisibility();
        $this->description_18->setVisibility();
        $this->description_19->setVisibility();
        $this->quantity->setVisibility();
        $this->price->setVisibility();
        $this->currency->setVisibility();
        $this->amount->setVisibility();
        $this->cbm->setVisibility();
        $this->buyer_size->setVisibility();
        $this->description_05->setVisibility();
        $this->description_06->setVisibility();
        $this->description_08->setVisibility();
        $this->remarks->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->a_operator->setVisibility();
        $this->a_datetime->setVisibility();
        $this->jc_no->Visible = false;
        $this->buyer_instruction->setVisibility();
        $this->d_09_head->setVisibility();
        $this->description_09->setVisibility();
        $this->d_10_head->setVisibility();
        $this->description_10->setVisibility();
        $this->d_11_head->setVisibility();
        $this->description_11->setVisibility();
        $this->d_12_head->setVisibility();
        $this->description_12->setVisibility();
        $this->po->Visible = false;
        $this->production_site->Visible = false;
        $this->c_total->Visible = false;
        $this->production_plan->Visible = false;
        $this->lot_no->Visible = false;
        $this->product_gcode->Visible = false;
        $this->batch_no->Visible = false;
        $this->uploads->Visible = false;
        $this->d_01_head->Visible = false;
        $this->d_02_head->Visible = false;
        $this->d_03_head->Visible = false;
        $this->d_04_head->Visible = false;
        $this->d_05_head->Visible = false;
        $this->d_06_head->Visible = false;
        $this->d_07_head->Visible = false;
        $this->d_08_head->Visible = false;
        $this->sample->Visible = false;
        $this->balance_quantity->Visible = false;
        $this->_action->setVisibility();
        $this->url->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'po';
        $this->TableName = 'po';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (po)
        if (!isset($GLOBALS["po"]) || $GLOBALS["po"]::class == PROJECT_NAMESPACE . "po") {
            $GLOBALS["po"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'po');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "poview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->order_type);
        $this->setupLookupOptions($this->buyer_id);
        $this->setupLookupOptions($this->cart_id);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->part_dispatch);
        $this->setupLookupOptions($this->payment_terms);
        $this->setupLookupOptions($this->description_04);
        $this->setupLookupOptions($this->description_03);
        $this->setupLookupOptions($this->description_20);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->description_05);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->a_operator);
        $this->setupLookupOptions($this->d_09_head);
        $this->setupLookupOptions($this->d_10_head);
        $this->setupLookupOptions($this->d_11_head);
        $this->setupLookupOptions($this->d_12_head);
        $this->setupLookupOptions($this->production_site);
        $this->setupLookupOptions($this->production_plan);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "polist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->order_type); // order_type
        $this->buildSearchUrl($srchUrl, $this->buyer_id); // buyer_id
        $this->buildSearchUrl($srchUrl, $this->buyer_order_no); // buyer_order_no
        $this->buildSearchUrl($srchUrl, $this->buyer_order_date); // buyer_order_date
        $this->buildSearchUrl($srchUrl, $this->cart_id); // cart_id
        $this->buildSearchUrl($srchUrl, $this->buyer_product_ref); // buyer_product_ref
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
        $this->buildSearchUrl($srchUrl, $this->product); // product
        $this->buildSearchUrl($srchUrl, $this->rid); // rid
        $this->buildSearchUrl($srchUrl, $this->despatch_week); // despatch_week
        $this->buildSearchUrl($srchUrl, $this->payment_terms); // payment_terms
        $this->buildSearchUrl($srchUrl, $this->transport_terms); // transport_terms
        $this->buildSearchUrl($srchUrl, $this->buyer_shipping_id); // buyer_shipping _id
        $this->buildSearchUrl($srchUrl, $this->description_03); // description_03
        $this->buildSearchUrl($srchUrl, $this->description_07); // description_07
        $this->buildSearchUrl($srchUrl, $this->description_20); // description_20
        $this->buildSearchUrl($srchUrl, $this->description_17); // description_17
        $this->buildSearchUrl($srchUrl, $this->description_18); // description_18
        $this->buildSearchUrl($srchUrl, $this->description_19); // description_19
        $this->buildSearchUrl($srchUrl, $this->quantity); // quantity
        $this->buildSearchUrl($srchUrl, $this->price); // price
        $this->buildSearchUrl($srchUrl, $this->currency); // currency
        $this->buildSearchUrl($srchUrl, $this->amount); // amount
        $this->buildSearchUrl($srchUrl, $this->cbm); // cbm
        $this->buildSearchUrl($srchUrl, $this->buyer_size); // buyer_size
        $this->buildSearchUrl($srchUrl, $this->description_05); // description_05
        $this->buildSearchUrl($srchUrl, $this->description_06); // description_06
        $this->buildSearchUrl($srchUrl, $this->description_08); // description_08
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->a_operator); // a_operator
        $this->buildSearchUrl($srchUrl, $this->a_datetime); // a_datetime
        $this->buildSearchUrl($srchUrl, $this->buyer_instruction); // buyer_instruction
        $this->buildSearchUrl($srchUrl, $this->d_09_head); // d_09_head
        $this->buildSearchUrl($srchUrl, $this->description_09); // description_09
        $this->buildSearchUrl($srchUrl, $this->d_10_head); // d_10_head
        $this->buildSearchUrl($srchUrl, $this->description_10); // description_10
        $this->buildSearchUrl($srchUrl, $this->d_11_head); // d_11_head
        $this->buildSearchUrl($srchUrl, $this->description_11); // description_11
        $this->buildSearchUrl($srchUrl, $this->d_12_head); // d_12_head
        $this->buildSearchUrl($srchUrl, $this->description_12); // description_12
        $this->buildSearchUrl($srchUrl, $this->_action); // action
        $this->buildSearchUrl($srchUrl, $this->url); // url
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // order_type
        if ($this->order_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_id
        if ($this->buyer_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_order_no
        if ($this->buyer_order_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_order_date
        if ($this->buyer_order_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cart_id
        if ($this->cart_id->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->cart_id->AdvancedSearch->SearchValue)) {
            $this->cart_id->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->cart_id->AdvancedSearch->SearchValue);
        }
        if (is_array($this->cart_id->AdvancedSearch->SearchValue2)) {
            $this->cart_id->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->cart_id->AdvancedSearch->SearchValue2);
        }

        // buyer_product_ref
        if ($this->buyer_product_ref->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_grp
        if ($this->s_grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product
        if ($this->product->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // rid
        if ($this->rid->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // despatch_week
        if ($this->despatch_week->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // payment_terms
        if ($this->payment_terms->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // transport_terms
        if ($this->transport_terms->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_shipping _id
        if ($this->buyer_shipping_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_03
        if ($this->description_03->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_07
        if ($this->description_07->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_20
        if ($this->description_20->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_17
        if ($this->description_17->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_18
        if ($this->description_18->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_19
        if ($this->description_19->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // price
        if ($this->price->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // currency
        if ($this->currency->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // amount
        if ($this->amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cbm
        if ($this->cbm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_size
        if ($this->buyer_size->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_05
        if ($this->description_05->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_06
        if ($this->description_06->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_08
        if ($this->description_08->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // a_operator
        if ($this->a_operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // a_datetime
        if ($this->a_datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_instruction
        if ($this->buyer_instruction->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_09_head
        if ($this->d_09_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_09
        if ($this->description_09->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_10_head
        if ($this->d_10_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_10
        if ($this->description_10->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_11_head
        if ($this->d_11_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_11
        if ($this->description_11->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_12_head
        if ($this->d_12_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_12
        if ($this->description_12->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // action
        if ($this->_action->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // url
        if ($this->url->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // order_type
        $this->order_type->RowCssClass = "row";

        // buyer_id
        $this->buyer_id->RowCssClass = "row";

        // buyer_order_no
        $this->buyer_order_no->RowCssClass = "row";

        // buyer_order_date
        $this->buyer_order_date->RowCssClass = "row";

        // cart_id
        $this->cart_id->RowCssClass = "row";

        // buyer_product_ref
        $this->buyer_product_ref->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // despatch_date
        $this->despatch_date->RowCssClass = "row";

        // despatch_week
        $this->despatch_week->RowCssClass = "row";

        // fob_date
        $this->fob_date->RowCssClass = "row";

        // part_dispatch
        $this->part_dispatch->RowCssClass = "row";

        // payment_terms
        $this->payment_terms->RowCssClass = "row";

        // transport_terms
        $this->transport_terms->RowCssClass = "row";

        // buyer_shipping _id
        $this->buyer_shipping_id->RowCssClass = "row";

        // description_04
        $this->description_04->RowCssClass = "row";

        // description_03
        $this->description_03->RowCssClass = "row";

        // description_01
        $this->description_01->RowCssClass = "row";

        // description_02
        $this->description_02->RowCssClass = "row";

        // description_07
        $this->description_07->RowCssClass = "row";

        // description_20
        $this->description_20->RowCssClass = "row";

        // description_17
        $this->description_17->RowCssClass = "row";

        // description_18
        $this->description_18->RowCssClass = "row";

        // description_19
        $this->description_19->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // price
        $this->price->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // buyer_size
        $this->buyer_size->RowCssClass = "row";

        // description_05
        $this->description_05->RowCssClass = "row";

        // description_06
        $this->description_06->RowCssClass = "row";

        // description_08
        $this->description_08->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // a_datetime
        $this->a_datetime->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // buyer_instruction
        $this->buyer_instruction->RowCssClass = "row";

        // d_09_head
        $this->d_09_head->RowCssClass = "row";

        // description_09
        $this->description_09->RowCssClass = "row";

        // d_10_head
        $this->d_10_head->RowCssClass = "row";

        // description_10
        $this->description_10->RowCssClass = "row";

        // d_11_head
        $this->d_11_head->RowCssClass = "row";

        // description_11
        $this->description_11->RowCssClass = "row";

        // d_12_head
        $this->d_12_head->RowCssClass = "row";

        // description_12
        $this->description_12->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // production_site
        $this->production_site->RowCssClass = "row";

        // c_total
        $this->c_total->RowCssClass = "row";

        // production_plan
        $this->production_plan->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // product_gcode
        $this->product_gcode->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // d_01_head
        $this->d_01_head->RowCssClass = "row";

        // d_02_head
        $this->d_02_head->RowCssClass = "row";

        // d_03_head
        $this->d_03_head->RowCssClass = "row";

        // d_04_head
        $this->d_04_head->RowCssClass = "row";

        // d_05_head
        $this->d_05_head->RowCssClass = "row";

        // d_06_head
        $this->d_06_head->RowCssClass = "row";

        // d_07_head
        $this->d_07_head->RowCssClass = "row";

        // d_08_head
        $this->d_08_head->RowCssClass = "row";

        // sample
        $this->sample->RowCssClass = "row";

        // balance_quantity
        $this->balance_quantity->RowCssClass = "row";

        // action
        $this->_action->RowCssClass = "row";

        // url
        $this->url->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // order_type
            if (strval($this->order_type->CurrentValue) != "") {
                $this->order_type->ViewValue = $this->order_type->optionCaption($this->order_type->CurrentValue);
            } else {
                $this->order_type->ViewValue = null;
            }

            // buyer_id
            $curVal = strval($this->buyer_id->CurrentValue);
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
                if ($this->buyer_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                    } else {
                        $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
                    }
                }
            } else {
                $this->buyer_id->ViewValue = null;
            }

            // buyer_order_no
            $this->buyer_order_no->ViewValue = $this->buyer_order_no->CurrentValue;

            // buyer_order_date
            $this->buyer_order_date->ViewValue = $this->buyer_order_date->CurrentValue;
            $this->buyer_order_date->ViewValue = FormatDateTime($this->buyer_order_date->ViewValue, $this->buyer_order_date->formatPattern());

            // cart_id
            $curVal = strval($this->cart_id->CurrentValue);
            if ($curVal != "") {
                $this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
                if ($this->cart_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->cart_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->cart_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->cart_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->cart_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->cart_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->cart_id->Lookup->renderViewRow($row);
                            $this->cart_id->ViewValue->add($this->cart_id->displayValue($arwrk));
                        }
                    } else {
                        $this->cart_id->ViewValue = $this->cart_id->CurrentValue;
                    }
                }
            } else {
                $this->cart_id->ViewValue = null;
            }

            // buyer_product_ref
            $this->buyer_product_ref->ViewValue = $this->buyer_product_ref->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // payment_terms
            $curVal = strval($this->payment_terms->CurrentValue);
            if ($curVal != "") {
                $this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
                if ($this->payment_terms->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                    $sqlWrk = $this->payment_terms->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment_terms->Lookup->renderViewRow($rswrk[0]);
                        $this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
                    } else {
                        $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
                    }
                }
            } else {
                $this->payment_terms->ViewValue = null;
            }

            // transport_terms
            $this->transport_terms->ViewValue = $this->transport_terms->CurrentValue;

            // buyer_shipping _id
            $this->buyer_shipping_id->ViewValue = $this->buyer_shipping_id->CurrentValue;
            $this->buyer_shipping_id->ViewValue = FormatNumber($this->buyer_shipping_id->ViewValue, $this->buyer_shipping_id->formatPattern());

            // description_04
            $this->description_04->ViewValue = $this->description_04->CurrentValue;

            // description_03
            if (strval($this->description_03->CurrentValue) != "") {
                $this->description_03->ViewValue = $this->description_03->optionCaption($this->description_03->CurrentValue);
            } else {
                $this->description_03->ViewValue = null;
            }

            // description_07
            $this->description_07->ViewValue = $this->description_07->CurrentValue;

            // description_20
            if (strval($this->description_20->CurrentValue) != "") {
                $this->description_20->ViewValue = $this->description_20->optionCaption($this->description_20->CurrentValue);
            } else {
                $this->description_20->ViewValue = null;
            }

            // description_17
            $this->description_17->ViewValue = $this->description_17->CurrentValue;
            $this->description_17->ViewValue = FormatNumber($this->description_17->ViewValue, $this->description_17->formatPattern());

            // description_18
            $this->description_18->ViewValue = $this->description_18->CurrentValue;
            $this->description_18->ViewValue = FormatNumber($this->description_18->ViewValue, $this->description_18->formatPattern());

            // description_19
            $this->description_19->ViewValue = $this->description_19->CurrentValue;
            $this->description_19->ViewValue = FormatNumber($this->description_19->ViewValue, $this->description_19->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // buyer_size
            $this->buyer_size->ViewValue = $this->buyer_size->CurrentValue;

            // description_05
            $curVal = strval($this->description_05->CurrentValue);
            if ($curVal != "") {
                $this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
                if ($this->description_05->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->description_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->description_05->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->description_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->description_05->Lookup->renderViewRow($rswrk[0]);
                        $this->description_05->ViewValue = $this->description_05->displayValue($arwrk);
                    } else {
                        $this->description_05->ViewValue = $this->description_05->CurrentValue;
                    }
                }
            } else {
                $this->description_05->ViewValue = null;
            }

            // description_06
            $this->description_06->ViewValue = $this->description_06->CurrentValue;

            // description_08
            $this->description_08->ViewValue = $this->description_08->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // a_operator
            $curVal = strval($this->a_operator->CurrentValue);
            if ($curVal != "") {
                $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
                if ($this->a_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                    } else {
                        $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
                    }
                }
            } else {
                $this->a_operator->ViewValue = null;
            }

            // a_datetime
            $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
            $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

            // buyer_instruction
            $this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;

            // d_09_head
            $curVal = strval($this->d_09_head->CurrentValue);
            if ($curVal != "") {
                $this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
                if ($this->d_09_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_09_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_09_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_09_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_09_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_09_head->ViewValue = $this->d_09_head->displayValue($arwrk);
                    } else {
                        $this->d_09_head->ViewValue = $this->d_09_head->CurrentValue;
                    }
                }
            } else {
                $this->d_09_head->ViewValue = null;
            }

            // description_09
            $this->description_09->ViewValue = $this->description_09->CurrentValue;

            // d_10_head
            $curVal = strval($this->d_10_head->CurrentValue);
            if ($curVal != "") {
                $this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
                if ($this->d_10_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_10_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_10_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_10_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_10_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_10_head->ViewValue = $this->d_10_head->displayValue($arwrk);
                    } else {
                        $this->d_10_head->ViewValue = $this->d_10_head->CurrentValue;
                    }
                }
            } else {
                $this->d_10_head->ViewValue = null;
            }

            // description_10
            $this->description_10->ViewValue = $this->description_10->CurrentValue;

            // d_11_head
            $curVal = strval($this->d_11_head->CurrentValue);
            if ($curVal != "") {
                $this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
                if ($this->d_11_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_11_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_11_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_11_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_11_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_11_head->ViewValue = $this->d_11_head->displayValue($arwrk);
                    } else {
                        $this->d_11_head->ViewValue = $this->d_11_head->CurrentValue;
                    }
                }
            } else {
                $this->d_11_head->ViewValue = null;
            }

            // description_11
            $this->description_11->ViewValue = $this->description_11->CurrentValue;

            // d_12_head
            $curVal = strval($this->d_12_head->CurrentValue);
            if ($curVal != "") {
                $this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
                if ($this->d_12_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_12_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_12_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_12_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_12_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_12_head->ViewValue = $this->d_12_head->displayValue($arwrk);
                    } else {
                        $this->d_12_head->ViewValue = $this->d_12_head->CurrentValue;
                    }
                }
            } else {
                $this->d_12_head->ViewValue = null;
            }

            // description_12
            $this->description_12->ViewValue = $this->description_12->CurrentValue;

            // action
            $this->_action->ViewValue = $this->_action->CurrentValue;
            $this->_action->CssClass = "fw-bold";
            $this->_action->ViewCustomAttributes = $this->_action->getViewCustomAttributes(); // PHP

            // url
            $this->url->ViewValue = $this->url->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // order_type
            $this->order_type->HrefValue = "";
            $this->order_type->TooltipValue = "";

            // buyer_id
            $this->buyer_id->HrefValue = "";
            $this->buyer_id->TooltipValue = "";

            // buyer_order_no
            $this->buyer_order_no->HrefValue = "";
            $this->buyer_order_no->TooltipValue = "";

            // buyer_order_date
            $this->buyer_order_date->HrefValue = "";
            $this->buyer_order_date->TooltipValue = "";

            // cart_id
            $this->cart_id->HrefValue = "";
            $this->cart_id->TooltipValue = "";

            // buyer_product_ref
            $this->buyer_product_ref->HrefValue = "";
            $this->buyer_product_ref->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }
            $this->s_grp->TooltipValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }
            $this->product->TooltipValue = "";

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }
            $this->rid->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";
            $this->despatch_week->TooltipValue = "";

            // payment_terms
            $this->payment_terms->HrefValue = "";
            $this->payment_terms->TooltipValue = "";

            // transport_terms
            $this->transport_terms->HrefValue = "";
            $this->transport_terms->TooltipValue = "";

            // buyer_shipping _id
            $this->buyer_shipping_id->HrefValue = "";
            $this->buyer_shipping_id->TooltipValue = "";

            // description_03
            $this->description_03->HrefValue = "";
            $this->description_03->TooltipValue = "";

            // description_07
            $this->description_07->HrefValue = "";
            $this->description_07->TooltipValue = "";

            // description_20
            $this->description_20->HrefValue = "";
            $this->description_20->TooltipValue = "";

            // description_17
            $this->description_17->HrefValue = "";
            $this->description_17->TooltipValue = "";

            // description_18
            $this->description_18->HrefValue = "";
            $this->description_18->TooltipValue = "";

            // description_19
            $this->description_19->HrefValue = "";
            $this->description_19->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // price
            $this->price->HrefValue = "";
            $this->price->TooltipValue = "";

            // currency
            $this->currency->HrefValue = "";
            $this->currency->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";

            // buyer_size
            $this->buyer_size->HrefValue = "";
            $this->buyer_size->TooltipValue = "";

            // description_05
            $this->description_05->HrefValue = "";
            $this->description_05->TooltipValue = "";

            // description_06
            $this->description_06->HrefValue = "";
            $this->description_06->TooltipValue = "";

            // description_08
            $this->description_08->HrefValue = "";
            $this->description_08->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // a_operator
            $this->a_operator->HrefValue = "";
            $this->a_operator->TooltipValue = "";

            // a_datetime
            $this->a_datetime->HrefValue = "";
            $this->a_datetime->TooltipValue = "";

            // buyer_instruction
            $this->buyer_instruction->HrefValue = "";
            $this->buyer_instruction->TooltipValue = "";

            // d_09_head
            $this->d_09_head->HrefValue = "";
            $this->d_09_head->TooltipValue = "";

            // description_09
            $this->description_09->HrefValue = "";
            $this->description_09->TooltipValue = "";

            // d_10_head
            $this->d_10_head->HrefValue = "";
            $this->d_10_head->TooltipValue = "";

            // description_10
            $this->description_10->HrefValue = "";
            $this->description_10->TooltipValue = "";

            // d_11_head
            $this->d_11_head->HrefValue = "";
            $this->d_11_head->TooltipValue = "";

            // description_11
            $this->description_11->HrefValue = "";
            $this->description_11->TooltipValue = "";

            // d_12_head
            $this->d_12_head->HrefValue = "";
            $this->d_12_head->TooltipValue = "";

            // description_12
            $this->description_12->HrefValue = "";
            $this->description_12->TooltipValue = "";

            // action
            if (!EmptyValue($this->url->CurrentValue)) {
                $this->_action->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
                $this->_action->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->_action->HrefValue = FullUrl($this->_action->HrefValue, "href");
                }
            } else {
                $this->_action->HrefValue = "";
            }
            $this->_action->TooltipValue = "";

            // url
            $this->url->HrefValue = "";
            $this->url->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // order_type
            $this->order_type->EditValue = $this->order_type->options(false);
            $this->order_type->PlaceHolder = RemoveHtml($this->order_type->caption());

            // buyer_id
            $this->buyer_id->setupEditAttributes();
            $curVal = trim(strval($this->buyer_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->buyer_id->AdvancedSearch->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
            } else {
                $this->buyer_id->AdvancedSearch->ViewValue = $this->buyer_id->Lookup !== null && is_array($this->buyer_id->lookupOptions()) && count($this->buyer_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyer_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->buyer_id->EditValue = array_values($this->buyer_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->buyer_id->AdvancedSearch->SearchValue, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->buyer_id->EditValue = $arwrk;
            }
            $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

            // buyer_order_no
            $this->buyer_order_no->setupEditAttributes();
            if (!$this->buyer_order_no->Raw) {
                $this->buyer_order_no->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_order_no->AdvancedSearch->SearchValue);
            }
            $this->buyer_order_no->EditValue = HtmlEncode($this->buyer_order_no->AdvancedSearch->SearchValue);
            $this->buyer_order_no->PlaceHolder = RemoveHtml($this->buyer_order_no->caption());

            // buyer_order_date
            $this->buyer_order_date->setupEditAttributes();
            $this->buyer_order_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->buyer_order_date->AdvancedSearch->SearchValue, $this->buyer_order_date->formatPattern()), $this->buyer_order_date->formatPattern()));
            $this->buyer_order_date->PlaceHolder = RemoveHtml($this->buyer_order_date->caption());

            // cart_id
            $curVal = trim(strval($this->cart_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->cart_id->AdvancedSearch->ViewValue = $this->cart_id->lookupCacheOption($curVal);
            } else {
                $this->cart_id->AdvancedSearch->ViewValue = $this->cart_id->Lookup !== null && is_array($this->cart_id->lookupOptions()) && count($this->cart_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->cart_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->cart_id->EditValue = array_values($this->cart_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->cart_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->cart_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->cart_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->cart_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->cart_id->Lookup->renderViewRow($row);
                }
                $this->cart_id->EditValue = $arwrk;
            }
            $this->cart_id->PlaceHolder = RemoveHtml($this->cart_id->caption());

            // buyer_product_ref
            $this->buyer_product_ref->setupEditAttributes();
            if (!$this->buyer_product_ref->Raw) {
                $this->buyer_product_ref->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_product_ref->AdvancedSearch->SearchValue);
            }
            $this->buyer_product_ref->EditValue = HtmlEncode($this->buyer_product_ref->AdvancedSearch->SearchValue);
            $this->buyer_product_ref->PlaceHolder = RemoveHtml($this->buyer_product_ref->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->AdvancedSearch->SearchValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->product->AdvancedSearch->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->AdvancedSearch->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->AdvancedSearch->SearchValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid
            $curVal = trim(strval($this->rid->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->rid->AdvancedSearch->ViewValue = $this->rid->lookupCacheOption($curVal);
            } else {
                $this->rid->AdvancedSearch->ViewValue = $this->rid->Lookup !== null && is_array($this->rid->lookupOptions()) && count($this->rid->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->rid->EditValue = array_values($this->rid->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid->AdvancedSearch->SearchValue, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->rid->EditValue = $arwrk;
            }
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // despatch_week
            $this->despatch_week->setupEditAttributes();
            $curVal = trim(strval($this->despatch_week->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            } else {
                $this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->Lookup !== null && is_array($this->despatch_week->lookupOptions()) && count($this->despatch_week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->despatch_week->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->despatch_week->EditValue = array_values($this->despatch_week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->despatch_week->AdvancedSearch->SearchValue, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->despatch_week->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->despatch_week->EditValue = $arwrk;
            }
            $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

            // payment_terms
            $this->payment_terms->setupEditAttributes();
            $curVal = trim(strval($this->payment_terms->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->payment_terms->AdvancedSearch->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
            } else {
                $this->payment_terms->AdvancedSearch->ViewValue = $this->payment_terms->Lookup !== null && is_array($this->payment_terms->lookupOptions()) && count($this->payment_terms->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->payment_terms->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->payment_terms->EditValue = array_values($this->payment_terms->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->payment_terms->AdvancedSearch->SearchValue, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                $sqlWrk = $this->payment_terms->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->payment_terms->EditValue = $arwrk;
            }
            $this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

            // transport_terms
            $this->transport_terms->setupEditAttributes();
            if (!$this->transport_terms->Raw) {
                $this->transport_terms->AdvancedSearch->SearchValue = HtmlDecode($this->transport_terms->AdvancedSearch->SearchValue);
            }
            $this->transport_terms->EditValue = HtmlEncode($this->transport_terms->AdvancedSearch->SearchValue);
            $this->transport_terms->PlaceHolder = RemoveHtml($this->transport_terms->caption());

            // buyer_shipping _id
            $this->buyer_shipping_id->setupEditAttributes();
            $this->buyer_shipping_id->EditValue = $this->buyer_shipping_id->AdvancedSearch->SearchValue;
            $this->buyer_shipping_id->PlaceHolder = RemoveHtml($this->buyer_shipping_id->caption());

            // description_03
            $this->description_03->setupEditAttributes();
            $this->description_03->EditValue = $this->description_03->options(true);
            $this->description_03->PlaceHolder = RemoveHtml($this->description_03->caption());

            // description_07
            $this->description_07->setupEditAttributes();
            $this->description_07->EditValue = $this->description_07->AdvancedSearch->SearchValue;
            $this->description_07->PlaceHolder = RemoveHtml($this->description_07->caption());

            // description_20
            $this->description_20->setupEditAttributes();
            $this->description_20->EditValue = $this->description_20->options(true);
            $this->description_20->PlaceHolder = RemoveHtml($this->description_20->caption());

            // description_17
            $this->description_17->setupEditAttributes();
            $this->description_17->EditCustomAttributes = $this->description_17->getEditCustomAttributes(); // PHP
            $this->description_17->EditValue = $this->description_17->AdvancedSearch->SearchValue;
            $this->description_17->PlaceHolder = RemoveHtml($this->description_17->caption());

            // description_18
            $this->description_18->setupEditAttributes();
            $this->description_18->EditCustomAttributes = $this->description_18->getEditCustomAttributes(); // PHP
            $this->description_18->EditValue = $this->description_18->AdvancedSearch->SearchValue;
            $this->description_18->PlaceHolder = RemoveHtml($this->description_18->caption());

            // description_19
            $this->description_19->setupEditAttributes();
            $this->description_19->EditCustomAttributes = $this->description_19->getEditCustomAttributes(); // PHP
            $this->description_19->EditValue = $this->description_19->AdvancedSearch->SearchValue;
            $this->description_19->PlaceHolder = RemoveHtml($this->description_19->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->AdvancedSearch->SearchValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

            // price
            $this->price->setupEditAttributes();
            $this->price->EditCustomAttributes = $this->price->getEditCustomAttributes(); // PHP
            $this->price->EditValue = $this->price->AdvancedSearch->SearchValue;
            $this->price->PlaceHolder = RemoveHtml($this->price->caption());

            // currency
            $this->currency->setupEditAttributes();
            $this->currency->EditCustomAttributes = $this->currency->getEditCustomAttributes(); // PHP
            $curVal = trim(strval($this->currency->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->currency->AdvancedSearch->ViewValue = $this->currency->lookupCacheOption($curVal);
            } else {
                $this->currency->AdvancedSearch->ViewValue = $this->currency->Lookup !== null && is_array($this->currency->lookupOptions()) && count($this->currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->currency->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->currency->EditValue = array_values($this->currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->currency->AdvancedSearch->SearchValue, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->currency->EditValue = $arwrk;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditCustomAttributes = $this->amount->getEditCustomAttributes(); // PHP
            $this->amount->EditValue = $this->amount->AdvancedSearch->SearchValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

            // cbm
            $this->cbm->setupEditAttributes();
            $this->cbm->EditCustomAttributes = $this->cbm->getEditCustomAttributes(); // PHP
            $this->cbm->EditValue = $this->cbm->AdvancedSearch->SearchValue;
            $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

            // buyer_size
            $this->buyer_size->setupEditAttributes();
            if (!$this->buyer_size->Raw) {
                $this->buyer_size->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_size->AdvancedSearch->SearchValue);
            }
            $this->buyer_size->EditValue = HtmlEncode($this->buyer_size->AdvancedSearch->SearchValue);
            $this->buyer_size->PlaceHolder = RemoveHtml($this->buyer_size->caption());

            // description_05
            $this->description_05->setupEditAttributes();
            $curVal = trim(strval($this->description_05->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->description_05->AdvancedSearch->ViewValue = $this->description_05->lookupCacheOption($curVal);
            } else {
                $this->description_05->AdvancedSearch->ViewValue = $this->description_05->Lookup !== null && is_array($this->description_05->lookupOptions()) && count($this->description_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_05->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->description_05->EditValue = array_values($this->description_05->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->description_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->description_05->AdvancedSearch->SearchValue, $this->description_05->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->description_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->description_05->EditValue = $arwrk;
            }
            $this->description_05->PlaceHolder = RemoveHtml($this->description_05->caption());

            // description_06
            $this->description_06->setupEditAttributes();
            $this->description_06->EditValue = $this->description_06->AdvancedSearch->SearchValue;
            $this->description_06->PlaceHolder = RemoveHtml($this->description_06->caption());

            // description_08
            $this->description_08->setupEditAttributes();
            $this->description_08->EditValue = $this->description_08->AdvancedSearch->SearchValue;
            $this->description_08->PlaceHolder = RemoveHtml($this->description_08->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // a_operator
            $this->a_operator->setupEditAttributes();
            $curVal = trim(strval($this->a_operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->a_operator->AdvancedSearch->ViewValue = $this->a_operator->lookupCacheOption($curVal);
            } else {
                $this->a_operator->AdvancedSearch->ViewValue = $this->a_operator->Lookup !== null && is_array($this->a_operator->lookupOptions()) && count($this->a_operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->a_operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->a_operator->EditValue = array_values($this->a_operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->a_operator->AdvancedSearch->SearchValue, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->a_operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->a_operator->EditValue = $arwrk;
            }
            $this->a_operator->PlaceHolder = RemoveHtml($this->a_operator->caption());

            // a_datetime
            $this->a_datetime->setupEditAttributes();
            $this->a_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->a_datetime->AdvancedSearch->SearchValue, $this->a_datetime->formatPattern()), $this->a_datetime->formatPattern()));
            $this->a_datetime->PlaceHolder = RemoveHtml($this->a_datetime->caption());

            // buyer_instruction
            $this->buyer_instruction->setupEditAttributes();
            $this->buyer_instruction->EditValue = HtmlEncode($this->buyer_instruction->AdvancedSearch->SearchValue);
            $this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

            // d_09_head
            $this->d_09_head->setupEditAttributes();
            $curVal = trim(strval($this->d_09_head->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->d_09_head->AdvancedSearch->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
            } else {
                $this->d_09_head->AdvancedSearch->ViewValue = $this->d_09_head->Lookup !== null && is_array($this->d_09_head->lookupOptions()) && count($this->d_09_head->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->d_09_head->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->d_09_head->EditValue = array_values($this->d_09_head->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->d_09_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->d_09_head->AdvancedSearch->SearchValue, $this->d_09_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->d_09_head->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->d_09_head->EditValue = $arwrk;
            }
            $this->d_09_head->PlaceHolder = RemoveHtml($this->d_09_head->caption());

            // description_09
            $this->description_09->setupEditAttributes();
            if (!$this->description_09->Raw) {
                $this->description_09->AdvancedSearch->SearchValue = HtmlDecode($this->description_09->AdvancedSearch->SearchValue);
            }
            $this->description_09->EditValue = HtmlEncode($this->description_09->AdvancedSearch->SearchValue);
            $this->description_09->PlaceHolder = RemoveHtml($this->description_09->caption());

            // d_10_head
            $this->d_10_head->setupEditAttributes();
            $curVal = trim(strval($this->d_10_head->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->d_10_head->AdvancedSearch->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
            } else {
                $this->d_10_head->AdvancedSearch->ViewValue = $this->d_10_head->Lookup !== null && is_array($this->d_10_head->lookupOptions()) && count($this->d_10_head->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->d_10_head->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->d_10_head->EditValue = array_values($this->d_10_head->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->d_10_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->d_10_head->AdvancedSearch->SearchValue, $this->d_10_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->d_10_head->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->d_10_head->EditValue = $arwrk;
            }
            $this->d_10_head->PlaceHolder = RemoveHtml($this->d_10_head->caption());

            // description_10
            $this->description_10->setupEditAttributes();
            if (!$this->description_10->Raw) {
                $this->description_10->AdvancedSearch->SearchValue = HtmlDecode($this->description_10->AdvancedSearch->SearchValue);
            }
            $this->description_10->EditValue = HtmlEncode($this->description_10->AdvancedSearch->SearchValue);
            $this->description_10->PlaceHolder = RemoveHtml($this->description_10->caption());

            // d_11_head
            $this->d_11_head->setupEditAttributes();
            $curVal = trim(strval($this->d_11_head->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->d_11_head->AdvancedSearch->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
            } else {
                $this->d_11_head->AdvancedSearch->ViewValue = $this->d_11_head->Lookup !== null && is_array($this->d_11_head->lookupOptions()) && count($this->d_11_head->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->d_11_head->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->d_11_head->EditValue = array_values($this->d_11_head->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->d_11_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->d_11_head->AdvancedSearch->SearchValue, $this->d_11_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->d_11_head->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->d_11_head->EditValue = $arwrk;
            }
            $this->d_11_head->PlaceHolder = RemoveHtml($this->d_11_head->caption());

            // description_11
            $this->description_11->setupEditAttributes();
            if (!$this->description_11->Raw) {
                $this->description_11->AdvancedSearch->SearchValue = HtmlDecode($this->description_11->AdvancedSearch->SearchValue);
            }
            $this->description_11->EditValue = HtmlEncode($this->description_11->AdvancedSearch->SearchValue);
            $this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

            // d_12_head
            $this->d_12_head->setupEditAttributes();
            $curVal = trim(strval($this->d_12_head->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->d_12_head->AdvancedSearch->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
            } else {
                $this->d_12_head->AdvancedSearch->ViewValue = $this->d_12_head->Lookup !== null && is_array($this->d_12_head->lookupOptions()) && count($this->d_12_head->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->d_12_head->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->d_12_head->EditValue = array_values($this->d_12_head->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->d_12_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->d_12_head->AdvancedSearch->SearchValue, $this->d_12_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->d_12_head->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->d_12_head->EditValue = $arwrk;
            }
            $this->d_12_head->PlaceHolder = RemoveHtml($this->d_12_head->caption());

            // description_12
            $this->description_12->setupEditAttributes();
            if (!$this->description_12->Raw) {
                $this->description_12->AdvancedSearch->SearchValue = HtmlDecode($this->description_12->AdvancedSearch->SearchValue);
            }
            $this->description_12->EditValue = HtmlEncode($this->description_12->AdvancedSearch->SearchValue);
            $this->description_12->PlaceHolder = RemoveHtml($this->description_12->caption());

            // action
            $this->_action->setupEditAttributes();
            if (!$this->_action->Raw) {
                $this->_action->AdvancedSearch->SearchValue = HtmlDecode($this->_action->AdvancedSearch->SearchValue);
            }
            $this->_action->EditValue = HtmlEncode($this->_action->AdvancedSearch->SearchValue);
            $this->_action->PlaceHolder = RemoveHtml($this->_action->caption());

            // url
            $this->url->setupEditAttributes();
            if (!$this->url->Raw) {
                $this->url->AdvancedSearch->SearchValue = HtmlDecode($this->url->AdvancedSearch->SearchValue);
            }
            $this->url->EditValue = HtmlEncode($this->url->AdvancedSearch->SearchValue);
            $this->url->PlaceHolder = RemoveHtml($this->url->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckDate($this->buyer_order_date->AdvancedSearch->SearchValue, $this->buyer_order_date->formatPattern())) {
            $this->buyer_order_date->addErrorMessage($this->buyer_order_date->getErrorMessage(false));
        }
        if (!CheckInteger($this->buyer_shipping_id->AdvancedSearch->SearchValue)) {
            $this->buyer_shipping_id->addErrorMessage($this->buyer_shipping_id->getErrorMessage(false));
        }
        if (!CheckNumber($this->description_07->AdvancedSearch->SearchValue)) {
            $this->description_07->addErrorMessage($this->description_07->getErrorMessage(false));
        }
        if (!CheckNumber($this->description_17->AdvancedSearch->SearchValue)) {
            $this->description_17->addErrorMessage($this->description_17->getErrorMessage(false));
        }
        if (!CheckNumber($this->description_18->AdvancedSearch->SearchValue)) {
            $this->description_18->addErrorMessage($this->description_18->getErrorMessage(false));
        }
        if (!CheckNumber($this->description_19->AdvancedSearch->SearchValue)) {
            $this->description_19->addErrorMessage($this->description_19->getErrorMessage(false));
        }
        if (!CheckNumber($this->amount->AdvancedSearch->SearchValue)) {
            $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->cbm->AdvancedSearch->SearchValue)) {
            $this->cbm->addErrorMessage($this->cbm->getErrorMessage(false));
        }
        if (!CheckNumber($this->description_08->AdvancedSearch->SearchValue)) {
            $this->description_08->addErrorMessage($this->description_08->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->order_type->AdvancedSearch->load();
        $this->buyer_id->AdvancedSearch->load();
        $this->buyer_order_no->AdvancedSearch->load();
        $this->buyer_order_date->AdvancedSearch->load();
        $this->cart_id->AdvancedSearch->load();
        $this->buyer_product_ref->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->rid->AdvancedSearch->load();
        $this->despatch_week->AdvancedSearch->load();
        $this->payment_terms->AdvancedSearch->load();
        $this->transport_terms->AdvancedSearch->load();
        $this->buyer_shipping_id->AdvancedSearch->load();
        $this->description_03->AdvancedSearch->load();
        $this->description_07->AdvancedSearch->load();
        $this->description_20->AdvancedSearch->load();
        $this->description_17->AdvancedSearch->load();
        $this->description_18->AdvancedSearch->load();
        $this->description_19->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->price->AdvancedSearch->load();
        $this->currency->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->buyer_size->AdvancedSearch->load();
        $this->description_05->AdvancedSearch->load();
        $this->description_06->AdvancedSearch->load();
        $this->description_08->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->a_operator->AdvancedSearch->load();
        $this->a_datetime->AdvancedSearch->load();
        $this->buyer_instruction->AdvancedSearch->load();
        $this->d_09_head->AdvancedSearch->load();
        $this->description_09->AdvancedSearch->load();
        $this->d_10_head->AdvancedSearch->load();
        $this->description_10->AdvancedSearch->load();
        $this->d_11_head->AdvancedSearch->load();
        $this->description_11->AdvancedSearch->load();
        $this->d_12_head->AdvancedSearch->load();
        $this->description_12->AdvancedSearch->load();
        $this->_action->AdvancedSearch->load();
        $this->url->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("polist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_order_type":
                    break;
                case "x_buyer_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_cart_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_despatch_week":
                    break;
                case "x_part_dispatch":
                    break;
                case "x_payment_terms":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_04":
                    break;
                case "x_description_03":
                    break;
                case "x_description_20":
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_a_operator":
                    break;
                case "x_d_09_head":
                    break;
                case "x_d_10_head":
                    break;
                case "x_d_11_head":
                    break;
                case "x_d_12_head":
                    break;
                case "x_production_site":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_production_plan":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'po');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
