<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PoSSearch extends PoS
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PoSSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "possearch";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->po->setVisibility();
        $this->company_id->setVisibility();
        $this->partner_id->setVisibility();
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->location->Visible = false;
        $this->copy->setVisibility();
        $this->cart_id->setVisibility();
        $this->quantity->setVisibility();
        $this->sqm->setVisibility();
        $this->amount->setVisibility();
        $this->cbm->setVisibility();
        $this->gst->setVisibility();
        $this->partner_order_no->Visible = false;
        $this->partner_order_date->Visible = false;
        $this->despatch_date->Visible = false;
        $this->despatch_week->setVisibility();
        $this->fob_date->Visible = false;
        $this->part_dispatch->Visible = false;
        $this->payment_terms->setVisibility();
        $this->transport_type->setVisibility();
        $this->partner_shipping_id->setVisibility();
        $this->description_04->Visible = false;
        $this->description_03->Visible = false;
        $this->description_20->Visible = false;
        $this->description_01->Visible = false;
        $this->description_02->Visible = false;
        $this->description_07->Visible = false;
        $this->description_17->Visible = false;
        $this->description_18->Visible = false;
        $this->description_19->Visible = false;
        $this->description_05->Visible = false;
        $this->description_06->Visible = false;
        $this->description_08->Visible = false;
        $this->remarks->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->a_operator->setVisibility();
        $this->a_datetime->setVisibility();
        $this->jc_no->Visible = false;
        $this->buyer_instruction->setVisibility();
        $this->d_09_head->setVisibility();
        $this->description_09->setVisibility();
        $this->d_10_head->setVisibility();
        $this->description_10->setVisibility();
        $this->d_11_head->setVisibility();
        $this->description_11->setVisibility();
        $this->d_12_head->setVisibility();
        $this->description_12->setVisibility();
        $this->production_site->Visible = false;
        $this->__request->Visible = false;
        $this->production_plan->Visible = false;
        $this->uploads->Visible = false;
        $this->balance_quantity->Visible = false;
        $this->e_mail->Visible = false;
        $this->billing_address_id->Visible = false;
        $this->shipping_address_id->Visible = false;
        $this->status->Visible = false;
        $this->app_operator->Visible = false;
        $this->app_datetime->Visible = false;
        $this->reports_to->Visible = false;
        $this->c_operator->Visible = false;
        $this->c_datetime->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'po_s';
        $this->TableName = 'po_s';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (po_s)
        if (!isset($GLOBALS["po_s"]) || $GLOBALS["po_s"]::class == PROJECT_NAMESPACE . "po_s") {
            $GLOBALS["po_s"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_s');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "posview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
                $this->uploads->UploadPath = $this->uploads->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->copy);
        $this->setupLookupOptions($this->cart_id);
        $this->setupLookupOptions($this->gst);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->part_dispatch);
        $this->setupLookupOptions($this->payment_terms);
        $this->setupLookupOptions($this->transport_type);
        $this->setupLookupOptions($this->partner_shipping_id);
        $this->setupLookupOptions($this->description_04);
        $this->setupLookupOptions($this->description_03);
        $this->setupLookupOptions($this->description_20);
        $this->setupLookupOptions($this->description_05);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->a_operator);
        $this->setupLookupOptions($this->d_09_head);
        $this->setupLookupOptions($this->d_10_head);
        $this->setupLookupOptions($this->d_11_head);
        $this->setupLookupOptions($this->d_12_head);
        $this->setupLookupOptions($this->production_site);
        $this->setupLookupOptions($this->production_plan);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "poslist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->po); // po
        $this->buildSearchUrl($srchUrl, $this->company_id); // company_id
        $this->buildSearchUrl($srchUrl, $this->partner_id); // partner_id
        $this->buildSearchUrl($srchUrl, $this->copy); // copy
        $this->buildSearchUrl($srchUrl, $this->cart_id); // cart_id
        $this->buildSearchUrl($srchUrl, $this->quantity); // quantity
        $this->buildSearchUrl($srchUrl, $this->sqm); // sqm
        $this->buildSearchUrl($srchUrl, $this->amount); // amount
        $this->buildSearchUrl($srchUrl, $this->cbm); // cbm
        $this->buildSearchUrl($srchUrl, $this->gst); // gst
        $this->buildSearchUrl($srchUrl, $this->despatch_week); // despatch_week
        $this->buildSearchUrl($srchUrl, $this->payment_terms); // payment_terms
        $this->buildSearchUrl($srchUrl, $this->transport_type); // transport_type
        $this->buildSearchUrl($srchUrl, $this->partner_shipping_id); // partner_shipping_id
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->a_operator); // a_operator
        $this->buildSearchUrl($srchUrl, $this->a_datetime); // a_datetime
        $this->buildSearchUrl($srchUrl, $this->buyer_instruction); // buyer_instruction
        $this->buildSearchUrl($srchUrl, $this->d_09_head); // d_09_head
        $this->buildSearchUrl($srchUrl, $this->description_09); // description_09
        $this->buildSearchUrl($srchUrl, $this->d_10_head); // d_10_head
        $this->buildSearchUrl($srchUrl, $this->description_10); // description_10
        $this->buildSearchUrl($srchUrl, $this->d_11_head); // d_11_head
        $this->buildSearchUrl($srchUrl, $this->description_11); // description_11
        $this->buildSearchUrl($srchUrl, $this->d_12_head); // d_12_head
        $this->buildSearchUrl($srchUrl, $this->description_12); // description_12
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po
        if ($this->po->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // company_id
        if ($this->company_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // partner_id
        if ($this->partner_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // copy
        if ($this->copy->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cart_id
        if ($this->cart_id->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->cart_id->AdvancedSearch->SearchValue)) {
            $this->cart_id->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->cart_id->AdvancedSearch->SearchValue);
        }
        if (is_array($this->cart_id->AdvancedSearch->SearchValue2)) {
            $this->cart_id->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->cart_id->AdvancedSearch->SearchValue2);
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sqm
        if ($this->sqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // amount
        if ($this->amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cbm
        if ($this->cbm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // gst
        if ($this->gst->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // despatch_week
        if ($this->despatch_week->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // payment_terms
        if ($this->payment_terms->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // transport_type
        if ($this->transport_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // partner_shipping_id
        if ($this->partner_shipping_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // a_operator
        if ($this->a_operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // a_datetime
        if ($this->a_datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_instruction
        if ($this->buyer_instruction->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_09_head
        if ($this->d_09_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_09
        if ($this->description_09->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_10_head
        if ($this->d_10_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_10
        if ($this->description_10->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_11_head
        if ($this->d_11_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_11
        if ($this->description_11->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_12_head
        if ($this->d_12_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_12
        if ($this->description_12->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // partner_id
        $this->partner_id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // copy
        $this->copy->RowCssClass = "row";

        // cart_id
        $this->cart_id->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // gst
        $this->gst->RowCssClass = "row";

        // partner_order_no
        $this->partner_order_no->RowCssClass = "row";

        // partner_order_date
        $this->partner_order_date->RowCssClass = "row";

        // despatch_date
        $this->despatch_date->RowCssClass = "row";

        // despatch_week
        $this->despatch_week->RowCssClass = "row";

        // fob_date
        $this->fob_date->RowCssClass = "row";

        // part_dispatch
        $this->part_dispatch->RowCssClass = "row";

        // payment_terms
        $this->payment_terms->RowCssClass = "row";

        // transport_type
        $this->transport_type->RowCssClass = "row";

        // partner_shipping_id
        $this->partner_shipping_id->RowCssClass = "row";

        // description_04
        $this->description_04->RowCssClass = "row";

        // description_03
        $this->description_03->RowCssClass = "row";

        // description_20
        $this->description_20->RowCssClass = "row";

        // description_01
        $this->description_01->RowCssClass = "row";

        // description_02
        $this->description_02->RowCssClass = "row";

        // description_07
        $this->description_07->RowCssClass = "row";

        // description_17
        $this->description_17->RowCssClass = "row";

        // description_18
        $this->description_18->RowCssClass = "row";

        // description_19
        $this->description_19->RowCssClass = "row";

        // description_05
        $this->description_05->RowCssClass = "row";

        // description_06
        $this->description_06->RowCssClass = "row";

        // description_08
        $this->description_08->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // a_datetime
        $this->a_datetime->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // buyer_instruction
        $this->buyer_instruction->RowCssClass = "row";

        // d_09_head
        $this->d_09_head->RowCssClass = "row";

        // description_09
        $this->description_09->RowCssClass = "row";

        // d_10_head
        $this->d_10_head->RowCssClass = "row";

        // description_10
        $this->description_10->RowCssClass = "row";

        // d_11_head
        $this->d_11_head->RowCssClass = "row";

        // description_11
        $this->description_11->RowCssClass = "row";

        // d_12_head
        $this->d_12_head->RowCssClass = "row";

        // description_12
        $this->description_12->RowCssClass = "row";

        // production_site
        $this->production_site->RowCssClass = "row";

        // request
        $this->__request->RowCssClass = "row";

        // production_plan
        $this->production_plan->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // balance_quantity
        $this->balance_quantity->RowCssClass = "row";

        // e_mail
        $this->e_mail->RowCssClass = "row";

        // billing_address_id
        $this->billing_address_id->RowCssClass = "row";

        // shipping_address_id
        $this->shipping_address_id->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // app_operator
        $this->app_operator->RowCssClass = "row";

        // app_datetime
        $this->app_datetime->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // c_operator
        $this->c_operator->RowCssClass = "row";

        // c_datetime
        $this->c_datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // po
            $this->po->ViewValue = $this->po->CurrentValue;

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // copy
            $curVal = strval($this->copy->CurrentValue);
            if ($curVal != "") {
                $this->copy->ViewValue = $this->copy->lookupCacheOption($curVal);
                if ($this->copy->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->copy->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->copy->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->copy->getSelectFilter($this); // PHP
                    $sqlWrk = $this->copy->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->copy->Lookup->renderViewRow($rswrk[0]);
                        $this->copy->ViewValue = $this->copy->displayValue($arwrk);
                    } else {
                        $this->copy->ViewValue = FormatNumber($this->copy->CurrentValue, $this->copy->formatPattern());
                    }
                }
            } else {
                $this->copy->ViewValue = null;
            }

            // cart_id
            $curVal = strval($this->cart_id->CurrentValue);
            if ($curVal != "") {
                $this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
                if ($this->cart_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->cart_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->cart_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->cart_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->cart_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->cart_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->cart_id->Lookup->renderViewRow($row);
                            $this->cart_id->ViewValue->add($this->cart_id->displayValue($arwrk));
                        }
                    } else {
                        $this->cart_id->ViewValue = $this->cart_id->CurrentValue;
                    }
                }
            } else {
                $this->cart_id->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // gst
            $curVal = strval($this->gst->CurrentValue);
            if ($curVal != "") {
                $this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
                if ($this->gst->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->gst->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->gst->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->gst->getSelectFilter($this); // PHP
                    $sqlWrk = $this->gst->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->gst->Lookup->renderViewRow($rswrk[0]);
                        $this->gst->ViewValue = $this->gst->displayValue($arwrk);
                    } else {
                        $this->gst->ViewValue = FormatNumber($this->gst->CurrentValue, $this->gst->formatPattern());
                    }
                }
            } else {
                $this->gst->ViewValue = null;
            }

            // partner_order_no
            $this->partner_order_no->ViewValue = $this->partner_order_no->CurrentValue;

            // partner_order_date
            $this->partner_order_date->ViewValue = $this->partner_order_date->CurrentValue;
            $this->partner_order_date->ViewValue = FormatDateTime($this->partner_order_date->ViewValue, $this->partner_order_date->formatPattern());

            // despatch_date
            $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->despatch_week->getSelectFilter($this); // PHP
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // fob_date
            $this->fob_date->ViewValue = $this->fob_date->CurrentValue;
            $this->fob_date->ViewValue = FormatDateTime($this->fob_date->ViewValue, $this->fob_date->formatPattern());

            // part_dispatch
            if (strval($this->part_dispatch->CurrentValue) != "") {
                $this->part_dispatch->ViewValue = $this->part_dispatch->optionCaption($this->part_dispatch->CurrentValue);
            } else {
                $this->part_dispatch->ViewValue = null;
            }

            // payment_terms
            $curVal = strval($this->payment_terms->CurrentValue);
            if ($curVal != "") {
                $this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
                if ($this->payment_terms->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                    $sqlWrk = $this->payment_terms->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment_terms->Lookup->renderViewRow($rswrk[0]);
                        $this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
                    } else {
                        $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
                    }
                }
            } else {
                $this->payment_terms->ViewValue = null;
            }

            // transport_type
            $curVal = strval($this->transport_type->CurrentValue);
            if ($curVal != "") {
                $this->transport_type->ViewValue = $this->transport_type->lookupCacheOption($curVal);
                if ($this->transport_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->transport_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->transport_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->transport_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->transport_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->transport_type->Lookup->renderViewRow($rswrk[0]);
                        $this->transport_type->ViewValue = $this->transport_type->displayValue($arwrk);
                    } else {
                        $this->transport_type->ViewValue = $this->transport_type->CurrentValue;
                    }
                }
            } else {
                $this->transport_type->ViewValue = null;
            }

            // partner_shipping_id
            $curVal = strval($this->partner_shipping_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_shipping_id->ViewValue = $this->partner_shipping_id->lookupCacheOption($curVal);
                if ($this->partner_shipping_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_shipping_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_shipping_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_shipping_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_shipping_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_shipping_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_shipping_id->ViewValue = $this->partner_shipping_id->displayValue($arwrk);
                    } else {
                        $this->partner_shipping_id->ViewValue = FormatNumber($this->partner_shipping_id->CurrentValue, $this->partner_shipping_id->formatPattern());
                    }
                }
            } else {
                $this->partner_shipping_id->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // a_operator
            $curVal = strval($this->a_operator->CurrentValue);
            if ($curVal != "") {
                $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
                if ($this->a_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                    } else {
                        $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
                    }
                }
            } else {
                $this->a_operator->ViewValue = null;
            }

            // a_datetime
            $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
            $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

            // buyer_instruction
            $this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;

            // d_09_head
            $curVal = strval($this->d_09_head->CurrentValue);
            if ($curVal != "") {
                $this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
                if ($this->d_09_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_09_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_09_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_09_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_09_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_09_head->ViewValue = $this->d_09_head->displayValue($arwrk);
                    } else {
                        $this->d_09_head->ViewValue = $this->d_09_head->CurrentValue;
                    }
                }
            } else {
                $this->d_09_head->ViewValue = null;
            }

            // description_09
            $this->description_09->ViewValue = $this->description_09->CurrentValue;

            // d_10_head
            $curVal = strval($this->d_10_head->CurrentValue);
            if ($curVal != "") {
                $this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
                if ($this->d_10_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_10_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_10_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_10_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_10_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_10_head->ViewValue = $this->d_10_head->displayValue($arwrk);
                    } else {
                        $this->d_10_head->ViewValue = $this->d_10_head->CurrentValue;
                    }
                }
            } else {
                $this->d_10_head->ViewValue = null;
            }

            // description_10
            $this->description_10->ViewValue = $this->description_10->CurrentValue;

            // d_11_head
            $curVal = strval($this->d_11_head->CurrentValue);
            if ($curVal != "") {
                $this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
                if ($this->d_11_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_11_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_11_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_11_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_11_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_11_head->ViewValue = $this->d_11_head->displayValue($arwrk);
                    } else {
                        $this->d_11_head->ViewValue = $this->d_11_head->CurrentValue;
                    }
                }
            } else {
                $this->d_11_head->ViewValue = null;
            }

            // description_11
            $this->description_11->ViewValue = $this->description_11->CurrentValue;

            // d_12_head
            $curVal = strval($this->d_12_head->CurrentValue);
            if ($curVal != "") {
                $this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
                if ($this->d_12_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_12_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_12_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_12_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_12_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_12_head->ViewValue = $this->d_12_head->displayValue($arwrk);
                    } else {
                        $this->d_12_head->ViewValue = $this->d_12_head->CurrentValue;
                    }
                }
            } else {
                $this->d_12_head->ViewValue = null;
            }

            // description_12
            $this->description_12->ViewValue = $this->description_12->CurrentValue;

            // production_plan
            if (strval($this->production_plan->CurrentValue) != "") {
                $this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
            } else {
                $this->production_plan->ViewValue = null;
            }

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // po
            if (!EmptyValue($this->po->CurrentValue)) {
                $this->po->HrefValue = $this->po->getLinkPrefix() . $this->po->CurrentValue; // Add prefix/suffix
                $this->po->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
                }
            } else {
                $this->po->HrefValue = "";
            }
            $this->po->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // partner_id
            if (!EmptyValue($this->partner_id->CurrentValue)) {
                $this->partner_id->HrefValue = $this->partner_id->getLinkPrefix() . $this->partner_id->CurrentValue; // Add prefix/suffix
                $this->partner_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
                }
            } else {
                $this->partner_id->HrefValue = "";
            }
            $this->partner_id->TooltipValue = "";

            // copy
            $this->copy->HrefValue = "";
            $this->copy->TooltipValue = "";

            // cart_id
            $this->cart_id->HrefValue = "";
            $this->cart_id->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";

            // gst
            $this->gst->HrefValue = "";
            $this->gst->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";
            $this->despatch_week->TooltipValue = "";

            // payment_terms
            if (!EmptyValue($this->payment_terms->CurrentValue)) {
                $this->payment_terms->HrefValue = $this->payment_terms->getLinkPrefix() . $this->payment_terms->CurrentValue; // Add prefix/suffix
                $this->payment_terms->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->payment_terms->HrefValue = FullUrl($this->payment_terms->HrefValue, "href");
                }
            } else {
                $this->payment_terms->HrefValue = "";
            }
            $this->payment_terms->TooltipValue = "";

            // transport_type
            if (!EmptyValue($this->transport_type->CurrentValue)) {
                $this->transport_type->HrefValue = $this->transport_type->getLinkPrefix() . $this->transport_type->CurrentValue; // Add prefix/suffix
                $this->transport_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->transport_type->HrefValue = FullUrl($this->transport_type->HrefValue, "href");
                }
            } else {
                $this->transport_type->HrefValue = "";
            }
            $this->transport_type->TooltipValue = "";

            // partner_shipping_id
            $this->partner_shipping_id->HrefValue = "";
            $this->partner_shipping_id->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // a_operator
            $this->a_operator->HrefValue = "";
            $this->a_operator->TooltipValue = "";

            // a_datetime
            $this->a_datetime->HrefValue = "";
            $this->a_datetime->TooltipValue = "";

            // buyer_instruction
            $this->buyer_instruction->HrefValue = "";
            $this->buyer_instruction->TooltipValue = "";

            // d_09_head
            $this->d_09_head->HrefValue = "";
            $this->d_09_head->TooltipValue = "";

            // description_09
            $this->description_09->HrefValue = "";
            $this->description_09->TooltipValue = "";

            // d_10_head
            $this->d_10_head->HrefValue = "";
            $this->d_10_head->TooltipValue = "";

            // description_10
            $this->description_10->HrefValue = "";
            $this->description_10->TooltipValue = "";

            // d_11_head
            $this->d_11_head->HrefValue = "";
            $this->d_11_head->TooltipValue = "";

            // description_11
            $this->description_11->HrefValue = "";
            $this->description_11->TooltipValue = "";

            // d_12_head
            $this->d_12_head->HrefValue = "";
            $this->d_12_head->TooltipValue = "";

            // description_12
            $this->description_12->HrefValue = "";
            $this->description_12->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->AdvancedSearch->SearchValue;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = trim(strval($this->company_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->company_id->AdvancedSearch->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->AdvancedSearch->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->AdvancedSearch->SearchValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // partner_id
            $this->partner_id->setupEditAttributes();
            $this->partner_id->EditValue = $this->partner_id->AdvancedSearch->SearchValue;
            $curVal = strval($this->partner_id->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->EditValue = HtmlEncode($this->partner_id->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->partner_id->EditValue = null;
            }
            $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

            // copy
            $this->copy->setupEditAttributes();
            $curVal = trim(strval($this->copy->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->copy->AdvancedSearch->ViewValue = $this->copy->lookupCacheOption($curVal);
            } else {
                $this->copy->AdvancedSearch->ViewValue = $this->copy->Lookup !== null && is_array($this->copy->lookupOptions()) && count($this->copy->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->copy->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->copy->EditValue = array_values($this->copy->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->copy->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->copy->AdvancedSearch->SearchValue, $this->copy->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->copy->getSelectFilter($this); // PHP
                $sqlWrk = $this->copy->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->copy->EditValue = $arwrk;
            }
            $this->copy->PlaceHolder = RemoveHtml($this->copy->caption());

            // cart_id
            $curVal = trim(strval($this->cart_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->cart_id->AdvancedSearch->ViewValue = $this->cart_id->lookupCacheOption($curVal);
            } else {
                $this->cart_id->AdvancedSearch->ViewValue = $this->cart_id->Lookup !== null && is_array($this->cart_id->lookupOptions()) && count($this->cart_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->cart_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->cart_id->EditValue = array_values($this->cart_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->cart_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->cart_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->cart_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->cart_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->cart_id->Lookup->renderViewRow($row);
                }
                $this->cart_id->EditValue = $arwrk;
            }
            $this->cart_id->PlaceHolder = RemoveHtml($this->cart_id->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->AdvancedSearch->SearchValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditCustomAttributes = $this->sqm->getEditCustomAttributes(); // PHP
            $this->sqm->EditValue = $this->sqm->AdvancedSearch->SearchValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditCustomAttributes = $this->amount->getEditCustomAttributes(); // PHP
            if (!$this->amount->Raw) {
                $this->amount->AdvancedSearch->SearchValue = HtmlDecode($this->amount->AdvancedSearch->SearchValue);
            }
            $this->amount->EditValue = HtmlEncode($this->amount->AdvancedSearch->SearchValue);
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

            // cbm
            $this->cbm->setupEditAttributes();
            $this->cbm->EditCustomAttributes = $this->cbm->getEditCustomAttributes(); // PHP
            $this->cbm->EditValue = $this->cbm->AdvancedSearch->SearchValue;
            $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

            // gst
            $this->gst->setupEditAttributes();
            $curVal = trim(strval($this->gst->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->gst->AdvancedSearch->ViewValue = $this->gst->lookupCacheOption($curVal);
            } else {
                $this->gst->AdvancedSearch->ViewValue = $this->gst->Lookup !== null && is_array($this->gst->lookupOptions()) && count($this->gst->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->gst->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->gst->EditValue = array_values($this->gst->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->gst->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->gst->AdvancedSearch->SearchValue, $this->gst->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->gst->getSelectFilter($this); // PHP
                $sqlWrk = $this->gst->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->gst->Lookup->renderViewRow($row);
                }
                $this->gst->EditValue = $arwrk;
            }
            $this->gst->PlaceHolder = RemoveHtml($this->gst->caption());

            // despatch_week
            $this->despatch_week->setupEditAttributes();
            $curVal = trim(strval($this->despatch_week->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            } else {
                $this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->Lookup !== null && is_array($this->despatch_week->lookupOptions()) && count($this->despatch_week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->despatch_week->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->despatch_week->EditValue = array_values($this->despatch_week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->despatch_week->AdvancedSearch->SearchValue, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->despatch_week->getSelectFilter($this); // PHP
                $sqlWrk = $this->despatch_week->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->despatch_week->EditValue = $arwrk;
            }
            $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

            // payment_terms
            $this->payment_terms->setupEditAttributes();
            $curVal = trim(strval($this->payment_terms->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->payment_terms->AdvancedSearch->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
            } else {
                $this->payment_terms->AdvancedSearch->ViewValue = $this->payment_terms->Lookup !== null && is_array($this->payment_terms->lookupOptions()) && count($this->payment_terms->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->payment_terms->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->payment_terms->EditValue = array_values($this->payment_terms->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->payment_terms->AdvancedSearch->SearchValue, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                $sqlWrk = $this->payment_terms->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->payment_terms->EditValue = $arwrk;
            }
            $this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

            // transport_type
            $this->transport_type->setupEditAttributes();
            $curVal = trim(strval($this->transport_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->transport_type->AdvancedSearch->ViewValue = $this->transport_type->lookupCacheOption($curVal);
            } else {
                $this->transport_type->AdvancedSearch->ViewValue = $this->transport_type->Lookup !== null && is_array($this->transport_type->lookupOptions()) && count($this->transport_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->transport_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->transport_type->EditValue = array_values($this->transport_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->transport_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->transport_type->AdvancedSearch->SearchValue, $this->transport_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->transport_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->transport_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->transport_type->EditValue = $arwrk;
            }
            $this->transport_type->PlaceHolder = RemoveHtml($this->transport_type->caption());

            // partner_shipping_id
            $this->partner_shipping_id->setupEditAttributes();
            $curVal = trim(strval($this->partner_shipping_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->partner_shipping_id->AdvancedSearch->ViewValue = $this->partner_shipping_id->lookupCacheOption($curVal);
            } else {
                $this->partner_shipping_id->AdvancedSearch->ViewValue = $this->partner_shipping_id->Lookup !== null && is_array($this->partner_shipping_id->lookupOptions()) && count($this->partner_shipping_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->partner_shipping_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->partner_shipping_id->EditValue = array_values($this->partner_shipping_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->partner_shipping_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->partner_shipping_id->AdvancedSearch->SearchValue, $this->partner_shipping_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->partner_shipping_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->partner_shipping_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->partner_shipping_id->EditValue = $arwrk;
            }
            $this->partner_shipping_id->PlaceHolder = RemoveHtml($this->partner_shipping_id->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // a_operator
            $this->a_operator->setupEditAttributes();
            $curVal = trim(strval($this->a_operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->a_operator->AdvancedSearch->ViewValue = $this->a_operator->lookupCacheOption($curVal);
            } else {
                $this->a_operator->AdvancedSearch->ViewValue = $this->a_operator->Lookup !== null && is_array($this->a_operator->lookupOptions()) && count($this->a_operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->a_operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->a_operator->EditValue = array_values($this->a_operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->a_operator->AdvancedSearch->SearchValue, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->a_operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->a_operator->EditValue = $arwrk;
            }
            $this->a_operator->PlaceHolder = RemoveHtml($this->a_operator->caption());

            // a_datetime
            $this->a_datetime->setupEditAttributes();
            $this->a_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->a_datetime->AdvancedSearch->SearchValue, $this->a_datetime->formatPattern()), $this->a_datetime->formatPattern()));
            $this->a_datetime->PlaceHolder = RemoveHtml($this->a_datetime->caption());

            // buyer_instruction
            $this->buyer_instruction->setupEditAttributes();
            $this->buyer_instruction->EditValue = HtmlEncode($this->buyer_instruction->AdvancedSearch->SearchValue);
            $this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

            // d_09_head
            $this->d_09_head->setupEditAttributes();
            $curVal = trim(strval($this->d_09_head->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->d_09_head->AdvancedSearch->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
            } else {
                $this->d_09_head->AdvancedSearch->ViewValue = $this->d_09_head->Lookup !== null && is_array($this->d_09_head->lookupOptions()) && count($this->d_09_head->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->d_09_head->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->d_09_head->EditValue = array_values($this->d_09_head->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->d_09_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->d_09_head->AdvancedSearch->SearchValue, $this->d_09_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->d_09_head->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->d_09_head->EditValue = $arwrk;
            }
            $this->d_09_head->PlaceHolder = RemoveHtml($this->d_09_head->caption());

            // description_09
            $this->description_09->setupEditAttributes();
            if (!$this->description_09->Raw) {
                $this->description_09->AdvancedSearch->SearchValue = HtmlDecode($this->description_09->AdvancedSearch->SearchValue);
            }
            $this->description_09->EditValue = HtmlEncode($this->description_09->AdvancedSearch->SearchValue);
            $this->description_09->PlaceHolder = RemoveHtml($this->description_09->caption());

            // d_10_head
            $this->d_10_head->setupEditAttributes();
            $curVal = trim(strval($this->d_10_head->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->d_10_head->AdvancedSearch->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
            } else {
                $this->d_10_head->AdvancedSearch->ViewValue = $this->d_10_head->Lookup !== null && is_array($this->d_10_head->lookupOptions()) && count($this->d_10_head->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->d_10_head->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->d_10_head->EditValue = array_values($this->d_10_head->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->d_10_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->d_10_head->AdvancedSearch->SearchValue, $this->d_10_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->d_10_head->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->d_10_head->EditValue = $arwrk;
            }
            $this->d_10_head->PlaceHolder = RemoveHtml($this->d_10_head->caption());

            // description_10
            $this->description_10->setupEditAttributes();
            if (!$this->description_10->Raw) {
                $this->description_10->AdvancedSearch->SearchValue = HtmlDecode($this->description_10->AdvancedSearch->SearchValue);
            }
            $this->description_10->EditValue = HtmlEncode($this->description_10->AdvancedSearch->SearchValue);
            $this->description_10->PlaceHolder = RemoveHtml($this->description_10->caption());

            // d_11_head
            $this->d_11_head->setupEditAttributes();
            $curVal = trim(strval($this->d_11_head->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->d_11_head->AdvancedSearch->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
            } else {
                $this->d_11_head->AdvancedSearch->ViewValue = $this->d_11_head->Lookup !== null && is_array($this->d_11_head->lookupOptions()) && count($this->d_11_head->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->d_11_head->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->d_11_head->EditValue = array_values($this->d_11_head->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->d_11_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->d_11_head->AdvancedSearch->SearchValue, $this->d_11_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->d_11_head->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->d_11_head->EditValue = $arwrk;
            }
            $this->d_11_head->PlaceHolder = RemoveHtml($this->d_11_head->caption());

            // description_11
            $this->description_11->setupEditAttributes();
            if (!$this->description_11->Raw) {
                $this->description_11->AdvancedSearch->SearchValue = HtmlDecode($this->description_11->AdvancedSearch->SearchValue);
            }
            $this->description_11->EditValue = HtmlEncode($this->description_11->AdvancedSearch->SearchValue);
            $this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

            // d_12_head
            $this->d_12_head->setupEditAttributes();
            $curVal = trim(strval($this->d_12_head->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->d_12_head->AdvancedSearch->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
            } else {
                $this->d_12_head->AdvancedSearch->ViewValue = $this->d_12_head->Lookup !== null && is_array($this->d_12_head->lookupOptions()) && count($this->d_12_head->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->d_12_head->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->d_12_head->EditValue = array_values($this->d_12_head->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->d_12_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->d_12_head->AdvancedSearch->SearchValue, $this->d_12_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->d_12_head->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->d_12_head->EditValue = $arwrk;
            }
            $this->d_12_head->PlaceHolder = RemoveHtml($this->d_12_head->caption());

            // description_12
            $this->description_12->setupEditAttributes();
            if (!$this->description_12->Raw) {
                $this->description_12->AdvancedSearch->SearchValue = HtmlDecode($this->description_12->AdvancedSearch->SearchValue);
            }
            $this->description_12->EditValue = HtmlEncode($this->description_12->AdvancedSearch->SearchValue);
            $this->description_12->PlaceHolder = RemoveHtml($this->description_12->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->partner_id->AdvancedSearch->SearchValue)) {
            $this->partner_id->addErrorMessage($this->partner_id->getErrorMessage(false));
        }
        if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
            $this->sqm->addErrorMessage($this->sqm->getErrorMessage(false));
        }
        if (!CheckNumber($this->cbm->AdvancedSearch->SearchValue)) {
            $this->cbm->addErrorMessage($this->cbm->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->po->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->partner_id->AdvancedSearch->load();
        $this->copy->AdvancedSearch->load();
        $this->cart_id->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->gst->AdvancedSearch->load();
        $this->despatch_week->AdvancedSearch->load();
        $this->payment_terms->AdvancedSearch->load();
        $this->transport_type->AdvancedSearch->load();
        $this->partner_shipping_id->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->a_operator->AdvancedSearch->load();
        $this->a_datetime->AdvancedSearch->load();
        $this->buyer_instruction->AdvancedSearch->load();
        $this->d_09_head->AdvancedSearch->load();
        $this->description_09->AdvancedSearch->load();
        $this->d_10_head->AdvancedSearch->load();
        $this->description_10->AdvancedSearch->load();
        $this->d_11_head->AdvancedSearch->load();
        $this->description_11->AdvancedSearch->load();
        $this->d_12_head->AdvancedSearch->load();
        $this->description_12->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("poslist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_copy":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_cart_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_gst":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_despatch_week":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_part_dispatch":
                    break;
                case "x_payment_terms":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_transport_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_shipping_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_04":
                    break;
                case "x_description_03":
                    break;
                case "x_description_20":
                    break;
                case "x_description_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_a_operator":
                    break;
                case "x_d_09_head":
                    break;
                case "x_d_10_head":
                    break;
                case "x_d_11_head":
                    break;
                case "x_d_12_head":
                    break;
                case "x_production_site":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_production_plan":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'po_s');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
