<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PoSPendingSearch extends PoSPending
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PoSPendingSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "pospendingsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->cart_id->setVisibility();
        $this->po_id->setVisibility();
        $this->company_id->setVisibility();
        $this->partner_id->setVisibility();
        $this->partner_order_no->setVisibility();
        $this->remarks->setVisibility();
        $this->p_remarks->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->ref->setVisibility();
        $this->product_code->setVisibility();
        $this->order_quantity->setVisibility();
        $this->purchase->Visible = false;
        $this->pending_qty->setVisibility();
        $this->order_date->setVisibility();
        $this->despatch_date->setVisibility();
        $this->avg_quantity->setVisibility();
        $this->packing_type->setVisibility();
        $this->status->setVisibility();
        $this->p_id->Visible = false;
        $this->partner_name->Visible = false;
        $this->p_qty->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'po_s_pending';
        $this->TableName = 'po_s_pending';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (po_s_pending)
        if (!isset($GLOBALS["po_s_pending"]) || $GLOBALS["po_s_pending"]::class == PROJECT_NAMESPACE . "po_s_pending") {
            $GLOBALS["po_s_pending"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_s_pending');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "pospendingview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['cart_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAddOrEdit()) {
            $this->purchase->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->pending_qty->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->po_id);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->ref);
        $this->setupLookupOptions($this->packing_type);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "pospendinglist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->cart_id); // cart_id
        $this->buildSearchUrl($srchUrl, $this->po_id); // po_id
        $this->buildSearchUrl($srchUrl, $this->company_id); // company_id
        $this->buildSearchUrl($srchUrl, $this->partner_id); // partner_id
        $this->buildSearchUrl($srchUrl, $this->partner_order_no); // partner_order_no
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->p_remarks); // p_remarks
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
        $this->buildSearchUrl($srchUrl, $this->product); // product
        $this->buildSearchUrl($srchUrl, $this->ref); // ref
        $this->buildSearchUrl($srchUrl, $this->product_code); // product_code
        $this->buildSearchUrl($srchUrl, $this->order_quantity); // order_quantity
        $this->buildSearchUrl($srchUrl, $this->pending_qty); // pending_qty
        $this->buildSearchUrl($srchUrl, $this->order_date); // order_date
        $this->buildSearchUrl($srchUrl, $this->despatch_date); // despatch_date
        $this->buildSearchUrl($srchUrl, $this->avg_quantity); // avg_quantity
        $this->buildSearchUrl($srchUrl, $this->packing_type); // packing_type
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->p_qty); // p_qty
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // cart_id
        if ($this->cart_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po_id
        if ($this->po_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // company_id
        if ($this->company_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // partner_id
        if ($this->partner_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // partner_order_no
        if ($this->partner_order_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p_remarks
        if ($this->p_remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_grp
        if ($this->s_grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product
        if ($this->product->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ref
        if ($this->ref->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product_code
        if ($this->product_code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // order_quantity
        if ($this->order_quantity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pending_qty
        if ($this->pending_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // order_date
        if ($this->order_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // despatch_date
        if ($this->despatch_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // avg_quantity
        if ($this->avg_quantity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packing_type
        if ($this->packing_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p_qty
        if ($this->p_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // cart_id
        $this->cart_id->RowCssClass = "row";

        // po_id
        $this->po_id->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // partner_id
        $this->partner_id->RowCssClass = "row";

        // partner_order_no
        $this->partner_order_no->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // p_remarks
        $this->p_remarks->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // ref
        $this->ref->RowCssClass = "row";

        // product_code
        $this->product_code->RowCssClass = "row";

        // order_quantity
        $this->order_quantity->RowCssClass = "row";

        // purchase
        $this->purchase->RowCssClass = "row";

        // pending_qty
        $this->pending_qty->RowCssClass = "row";

        // order_date
        $this->order_date->RowCssClass = "row";

        // despatch_date
        $this->despatch_date->RowCssClass = "row";

        // avg_quantity
        $this->avg_quantity->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // p_id
        $this->p_id->RowCssClass = "row";

        // partner_name
        $this->partner_name->RowCssClass = "row";

        // p_qty
        $this->p_qty->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // cart_id
            $this->cart_id->ViewValue = $this->cart_id->CurrentValue;
            $this->cart_id->ViewValue = FormatNumber($this->cart_id->ViewValue, $this->cart_id->formatPattern());

            // po_id
            $curVal = strval($this->po_id->CurrentValue);
            if ($curVal != "") {
                $this->po_id->ViewValue = $this->po_id->lookupCacheOption($curVal);
                if ($this->po_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_id->Lookup->renderViewRow($rswrk[0]);
                        $this->po_id->ViewValue = $this->po_id->displayValue($arwrk);
                    } else {
                        $this->po_id->ViewValue = FormatNumber($this->po_id->CurrentValue, $this->po_id->formatPattern());
                    }
                }
            } else {
                $this->po_id->ViewValue = null;
            }

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // partner_id
            if ($this->partner_id->VirtualValue != "") {
                $this->partner_id->ViewValue = $this->partner_id->VirtualValue;
            } else {
                $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                $curVal = strval($this->partner_id->CurrentValue);
                if ($curVal != "") {
                    $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                    if ($this->partner_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                            $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                        } else {
                            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                        }
                    }
                } else {
                    $this->partner_id->ViewValue = null;
                }
            }

            // partner_order_no
            $this->partner_order_no->ViewValue = $this->partner_order_no->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // p_remarks
            $this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;
            $this->p_remarks->ViewCustomAttributes = $this->p_remarks->getViewCustomAttributes(); // PHP

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = FormatNumber($this->product->CurrentValue, $this->product->formatPattern());
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;
            $curVal = strval($this->ref->CurrentValue);
            if ($curVal != "") {
                $this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
                if ($this->ref->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ref->Lookup->renderViewRow($rswrk[0]);
                        $this->ref->ViewValue = $this->ref->displayValue($arwrk);
                    } else {
                        $this->ref->ViewValue = FormatNumber($this->ref->CurrentValue, $this->ref->formatPattern());
                    }
                }
            } else {
                $this->ref->ViewValue = null;
            }

            // product_code
            $this->product_code->ViewValue = $this->product_code->CurrentValue;

            // order_quantity
            $this->order_quantity->ViewValue = $this->order_quantity->CurrentValue;
            $this->order_quantity->ViewValue = FormatNumber($this->order_quantity->ViewValue, $this->order_quantity->formatPattern());

            // pending_qty
            $this->pending_qty->ViewValue = $this->pending_qty->CurrentValue;
            $this->pending_qty->ViewValue = FormatNumber($this->pending_qty->ViewValue, $this->pending_qty->formatPattern());

            // order_date
            $this->order_date->ViewValue = $this->order_date->CurrentValue;
            $this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, $this->order_date->formatPattern());

            // despatch_date
            $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

            // avg_quantity
            $this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
            $this->avg_quantity->ViewValue = FormatNumber($this->avg_quantity->ViewValue, $this->avg_quantity->formatPattern());

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // status
            $this->status->ViewValue = $this->status->CurrentValue;
            $this->status->ViewValue = FormatNumber($this->status->ViewValue, $this->status->formatPattern());

            // p_qty
            $this->p_qty->ViewValue = $this->p_qty->CurrentValue;
            $this->p_qty->ViewValue = FormatNumber($this->p_qty->ViewValue, $this->p_qty->formatPattern());

            // cart_id
            $this->cart_id->HrefValue = "";
            $this->cart_id->TooltipValue = "";

            // po_id
            $this->po_id->HrefValue = "";
            $this->po_id->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";
            $this->partner_id->TooltipValue = "";

            // partner_order_no
            $this->partner_order_no->HrefValue = "";
            $this->partner_order_no->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // p_remarks
            $this->p_remarks->HrefValue = "";
            $this->p_remarks->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // product
            $this->product->HrefValue = "";
            $this->product->TooltipValue = "";

            // ref
            $this->ref->HrefValue = "";
            $this->ref->TooltipValue = "";

            // product_code
            $this->product_code->HrefValue = "";
            $this->product_code->TooltipValue = "";

            // order_quantity
            $this->order_quantity->HrefValue = "";
            $this->order_quantity->TooltipValue = "";

            // pending_qty
            $this->pending_qty->HrefValue = "";
            $this->pending_qty->TooltipValue = "";

            // order_date
            $this->order_date->HrefValue = "";
            $this->order_date->TooltipValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";
            $this->despatch_date->TooltipValue = "";

            // avg_quantity
            $this->avg_quantity->HrefValue = "";
            $this->avg_quantity->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // p_qty
            $this->p_qty->HrefValue = "";
            $this->p_qty->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // cart_id
            $this->cart_id->setupEditAttributes();
            $this->cart_id->EditValue = $this->cart_id->AdvancedSearch->SearchValue;
            $this->cart_id->PlaceHolder = RemoveHtml($this->cart_id->caption());

            // po_id
            $this->po_id->setupEditAttributes();
            $curVal = trim(strval($this->po_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->po_id->AdvancedSearch->ViewValue = $this->po_id->lookupCacheOption($curVal);
            } else {
                $this->po_id->AdvancedSearch->ViewValue = $this->po_id->Lookup !== null && is_array($this->po_id->lookupOptions()) && count($this->po_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->po_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->po_id->EditValue = array_values($this->po_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->po_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->po_id->AdvancedSearch->SearchValue, $this->po_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->po_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->po_id->EditValue = $arwrk;
            }
            $this->po_id->PlaceHolder = RemoveHtml($this->po_id->caption());
            $this->po_id->setupEditAttributes();
            $curVal = trim(strval($this->po_id->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->po_id->AdvancedSearch->ViewValue2 = $this->po_id->lookupCacheOption($curVal);
            } else {
                $this->po_id->AdvancedSearch->ViewValue2 = $this->po_id->Lookup !== null && is_array($this->po_id->lookupOptions()) && count($this->po_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->po_id->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->po_id->EditValue2 = array_values($this->po_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->po_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->po_id->AdvancedSearch->SearchValue2, $this->po_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->po_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->po_id->EditValue2 = $arwrk;
            }
            $this->po_id->PlaceHolder = RemoveHtml($this->po_id->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = trim(strval($this->company_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->company_id->AdvancedSearch->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->AdvancedSearch->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->AdvancedSearch->SearchValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // partner_id
            $this->partner_id->setupEditAttributes();
            $this->partner_id->EditValue = $this->partner_id->AdvancedSearch->SearchValue;
            $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

            // partner_order_no
            $this->partner_order_no->setupEditAttributes();
            if (!$this->partner_order_no->Raw) {
                $this->partner_order_no->AdvancedSearch->SearchValue = HtmlDecode($this->partner_order_no->AdvancedSearch->SearchValue);
            }
            $this->partner_order_no->EditValue = HtmlEncode($this->partner_order_no->AdvancedSearch->SearchValue);
            $this->partner_order_no->PlaceHolder = RemoveHtml($this->partner_order_no->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // p_remarks
            $this->p_remarks->setupEditAttributes();
            $this->p_remarks->EditValue = HtmlEncode($this->p_remarks->AdvancedSearch->SearchValue);
            $this->p_remarks->PlaceHolder = RemoveHtml($this->p_remarks->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->AdvancedSearch->SearchValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->product->AdvancedSearch->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->AdvancedSearch->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->AdvancedSearch->SearchValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // ref
            $this->ref->setupEditAttributes();
            $this->ref->EditValue = $this->ref->AdvancedSearch->SearchValue;
            $curVal = strval($this->ref->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->ref->EditValue = $this->ref->lookupCacheOption($curVal);
                if ($this->ref->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ref->Lookup->renderViewRow($rswrk[0]);
                        $this->ref->EditValue = $this->ref->displayValue($arwrk);
                    } else {
                        $this->ref->EditValue = HtmlEncode(FormatNumber($this->ref->AdvancedSearch->SearchValue, $this->ref->formatPattern()));
                    }
                }
            } else {
                $this->ref->EditValue = null;
            }
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

            // product_code
            $this->product_code->setupEditAttributes();
            if (!$this->product_code->Raw) {
                $this->product_code->AdvancedSearch->SearchValue = HtmlDecode($this->product_code->AdvancedSearch->SearchValue);
            }
            $this->product_code->EditValue = HtmlEncode($this->product_code->AdvancedSearch->SearchValue);
            $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

            // order_quantity
            $this->order_quantity->setupEditAttributes();
            $this->order_quantity->EditValue = $this->order_quantity->AdvancedSearch->SearchValue;
            $this->order_quantity->PlaceHolder = RemoveHtml($this->order_quantity->caption());

            // pending_qty
            $this->pending_qty->setupEditAttributes();
            $this->pending_qty->EditValue = $this->pending_qty->AdvancedSearch->SearchValue;
            $this->pending_qty->PlaceHolder = RemoveHtml($this->pending_qty->caption());
            $this->pending_qty->setupEditAttributes();
            $this->pending_qty->EditValue2 = $this->pending_qty->AdvancedSearch->SearchValue2;
            $this->pending_qty->PlaceHolder = RemoveHtml($this->pending_qty->caption());

            // order_date
            $this->order_date->setupEditAttributes();
            $this->order_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->order_date->AdvancedSearch->SearchValue, $this->order_date->formatPattern()), $this->order_date->formatPattern()));
            $this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

            // despatch_date
            $this->despatch_date->setupEditAttributes();
            $this->despatch_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->despatch_date->AdvancedSearch->SearchValue, $this->despatch_date->formatPattern()), $this->despatch_date->formatPattern()));
            $this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

            // avg_quantity
            $this->avg_quantity->setupEditAttributes();
            $this->avg_quantity->EditValue = $this->avg_quantity->AdvancedSearch->SearchValue;
            $this->avg_quantity->PlaceHolder = RemoveHtml($this->avg_quantity->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->AdvancedSearch->SearchValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->AdvancedSearch->SearchValue;
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // p_qty
            $this->p_qty->setupEditAttributes();
            $this->p_qty->EditValue = $this->p_qty->AdvancedSearch->SearchValue;
            $this->p_qty->PlaceHolder = RemoveHtml($this->p_qty->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->cart_id->AdvancedSearch->SearchValue)) {
            $this->cart_id->addErrorMessage($this->cart_id->getErrorMessage(false));
        }
        if (!CheckNumber($this->order_quantity->AdvancedSearch->SearchValue)) {
            $this->order_quantity->addErrorMessage($this->order_quantity->getErrorMessage(false));
        }
        if (!CheckNumber($this->pending_qty->AdvancedSearch->SearchValue)) {
            $this->pending_qty->addErrorMessage($this->pending_qty->getErrorMessage(false));
        }
        if (!CheckNumber($this->pending_qty->AdvancedSearch->SearchValue2)) {
            $this->pending_qty->addErrorMessage($this->pending_qty->getErrorMessage(false));
        }
        if (!CheckDate($this->order_date->AdvancedSearch->SearchValue, $this->order_date->formatPattern())) {
            $this->order_date->addErrorMessage($this->order_date->getErrorMessage(false));
        }
        if (!CheckDate($this->despatch_date->AdvancedSearch->SearchValue, $this->despatch_date->formatPattern())) {
            $this->despatch_date->addErrorMessage($this->despatch_date->getErrorMessage(false));
        }
        if (!CheckInteger($this->avg_quantity->AdvancedSearch->SearchValue)) {
            $this->avg_quantity->addErrorMessage($this->avg_quantity->getErrorMessage(false));
        }
        if (!CheckInteger($this->status->AdvancedSearch->SearchValue)) {
            $this->status->addErrorMessage($this->status->getErrorMessage(false));
        }
        if (!CheckNumber($this->p_qty->AdvancedSearch->SearchValue)) {
            $this->p_qty->addErrorMessage($this->p_qty->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->cart_id->AdvancedSearch->load();
        $this->po_id->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->partner_id->AdvancedSearch->load();
        $this->partner_order_no->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->p_remarks->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->ref->AdvancedSearch->load();
        $this->product_code->AdvancedSearch->load();
        $this->order_quantity->AdvancedSearch->load();
        $this->pending_qty->AdvancedSearch->load();
        $this->order_date->AdvancedSearch->load();
        $this->despatch_date->AdvancedSearch->load();
        $this->avg_quantity->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->p_qty->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("pospendinglist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_po_id":
                    break;
                case "x_company_id":
                    break;
                case "x_partner_id":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    break;
                case "x_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
