<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PoSDelete extends PoS
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PoSDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "posdelete";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->po->setVisibility();
        $this->company_id->setVisibility();
        $this->partner_id->setVisibility();
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->location->Visible = false;
        $this->copy->setVisibility();
        $this->cart_id->Visible = false;
        $this->quantity->setVisibility();
        $this->sqm->setVisibility();
        $this->amount->setVisibility();
        $this->cbm->setVisibility();
        $this->gst->setVisibility();
        $this->partner_order_no->Visible = false;
        $this->partner_order_date->Visible = false;
        $this->despatch_date->setVisibility();
        $this->despatch_week->setVisibility();
        $this->fob_date->setVisibility();
        $this->part_dispatch->Visible = false;
        $this->payment_terms->setVisibility();
        $this->transport_type->setVisibility();
        $this->partner_shipping_id->setVisibility();
        $this->description_04->Visible = false;
        $this->description_03->Visible = false;
        $this->description_20->Visible = false;
        $this->description_01->Visible = false;
        $this->description_02->Visible = false;
        $this->description_07->Visible = false;
        $this->description_17->Visible = false;
        $this->description_18->Visible = false;
        $this->description_19->Visible = false;
        $this->description_05->Visible = false;
        $this->description_06->Visible = false;
        $this->description_08->Visible = false;
        $this->remarks->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->a_operator->setVisibility();
        $this->a_datetime->setVisibility();
        $this->jc_no->Visible = false;
        $this->buyer_instruction->Visible = false;
        $this->d_09_head->Visible = false;
        $this->description_09->Visible = false;
        $this->d_10_head->Visible = false;
        $this->description_10->Visible = false;
        $this->d_11_head->Visible = false;
        $this->description_11->Visible = false;
        $this->d_12_head->Visible = false;
        $this->description_12->Visible = false;
        $this->production_site->Visible = false;
        $this->__request->Visible = false;
        $this->production_plan->Visible = false;
        $this->uploads->Visible = false;
        $this->balance_quantity->Visible = false;
        $this->e_mail->Visible = false;
        $this->billing_address_id->Visible = false;
        $this->shipping_address_id->Visible = false;
        $this->status->Visible = false;
        $this->app_operator->Visible = false;
        $this->app_datetime->Visible = false;
        $this->reports_to->Visible = false;
        $this->c_operator->Visible = false;
        $this->c_datetime->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'po_s';
        $this->TableName = 'po_s';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (po_s)
        if (!isset($GLOBALS["po_s"]) || $GLOBALS["po_s"]::class == PROJECT_NAMESPACE . "po_s") {
            $GLOBALS["po_s"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_s');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
                $this->uploads->UploadPath = $this->uploads->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->copy);
        $this->setupLookupOptions($this->cart_id);
        $this->setupLookupOptions($this->gst);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->part_dispatch);
        $this->setupLookupOptions($this->payment_terms);
        $this->setupLookupOptions($this->transport_type);
        $this->setupLookupOptions($this->partner_shipping_id);
        $this->setupLookupOptions($this->description_04);
        $this->setupLookupOptions($this->description_03);
        $this->setupLookupOptions($this->description_20);
        $this->setupLookupOptions($this->description_05);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->a_operator);
        $this->setupLookupOptions($this->d_09_head);
        $this->setupLookupOptions($this->d_10_head);
        $this->setupLookupOptions($this->d_11_head);
        $this->setupLookupOptions($this->d_12_head);
        $this->setupLookupOptions($this->production_site);
        $this->setupLookupOptions($this->production_plan);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("poslist"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson(["success" => false, "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            $this->Recordset = $this->loadRecordset();
            if ($this->TotalRecords <= 0) { // No record found, exit
                $this->Recordset?->free();
                $this->terminate("poslist"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->po->setDbValue($row['po']);
        $this->company_id->setDbValue($row['company_id']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->location->setDbValue($row['location']);
        $this->copy->setDbValue($row['copy']);
        $this->cart_id->setDbValue($row['cart_id']);
        $this->quantity->setDbValue($row['quantity']);
        $this->sqm->setDbValue($row['sqm']);
        $this->amount->setDbValue($row['amount']);
        $this->cbm->setDbValue($row['cbm']);
        $this->gst->setDbValue($row['gst']);
        $this->partner_order_no->setDbValue($row['partner_order_no']);
        $this->partner_order_date->setDbValue($row['partner_order_date']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->fob_date->setDbValue($row['fob_date']);
        $this->part_dispatch->setDbValue($row['part_dispatch']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->transport_type->setDbValue($row['transport_type']);
        $this->partner_shipping_id->setDbValue($row['partner_shipping_id']);
        $this->description_04->setDbValue($row['description_04']);
        $this->description_03->setDbValue($row['description_03']);
        $this->description_20->setDbValue($row['description_20']);
        $this->description_01->setDbValue($row['description_01']);
        $this->description_02->setDbValue($row['description_02']);
        $this->description_07->setDbValue($row['description_07']);
        $this->description_17->setDbValue($row['description_17']);
        $this->description_18->setDbValue($row['description_18']);
        $this->description_19->setDbValue($row['description_19']);
        $this->description_05->setDbValue($row['description_05']);
        $this->description_06->setDbValue($row['description_06']);
        $this->description_08->setDbValue($row['description_08']);
        $this->remarks->setDbValue($row['remarks']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->buyer_instruction->setDbValue($row['buyer_instruction']);
        $this->d_09_head->setDbValue($row['d_09_head']);
        $this->description_09->setDbValue($row['description_09']);
        $this->d_10_head->setDbValue($row['d_10_head']);
        $this->description_10->setDbValue($row['description_10']);
        $this->d_11_head->setDbValue($row['d_11_head']);
        $this->description_11->setDbValue($row['description_11']);
        $this->d_12_head->setDbValue($row['d_12_head']);
        $this->description_12->setDbValue($row['description_12']);
        $this->production_site->setDbValue($row['production_site']);
        $this->__request->setDbValue($row['request']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->uploads->setDbValue($this->uploads->Upload->DbValue);
        $this->balance_quantity->setDbValue($row['balance_quantity']);
        $this->e_mail->setDbValue($row['e_mail']);
        $this->billing_address_id->setDbValue($row['billing_address_id']);
        $this->shipping_address_id->setDbValue($row['shipping_address_id']);
        $this->status->setDbValue($row['status']);
        $this->app_operator->setDbValue($row['app_operator']);
        $this->app_datetime->setDbValue($row['app_datetime']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->c_operator->setDbValue($row['c_operator']);
        $this->c_datetime->setDbValue($row['c_datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['copy'] = $this->copy->DefaultValue;
        $row['cart_id'] = $this->cart_id->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['gst'] = $this->gst->DefaultValue;
        $row['partner_order_no'] = $this->partner_order_no->DefaultValue;
        $row['partner_order_date'] = $this->partner_order_date->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['despatch_week'] = $this->despatch_week->DefaultValue;
        $row['fob_date'] = $this->fob_date->DefaultValue;
        $row['part_dispatch'] = $this->part_dispatch->DefaultValue;
        $row['payment_terms'] = $this->payment_terms->DefaultValue;
        $row['transport_type'] = $this->transport_type->DefaultValue;
        $row['partner_shipping_id'] = $this->partner_shipping_id->DefaultValue;
        $row['description_04'] = $this->description_04->DefaultValue;
        $row['description_03'] = $this->description_03->DefaultValue;
        $row['description_20'] = $this->description_20->DefaultValue;
        $row['description_01'] = $this->description_01->DefaultValue;
        $row['description_02'] = $this->description_02->DefaultValue;
        $row['description_07'] = $this->description_07->DefaultValue;
        $row['description_17'] = $this->description_17->DefaultValue;
        $row['description_18'] = $this->description_18->DefaultValue;
        $row['description_19'] = $this->description_19->DefaultValue;
        $row['description_05'] = $this->description_05->DefaultValue;
        $row['description_06'] = $this->description_06->DefaultValue;
        $row['description_08'] = $this->description_08->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['a_datetime'] = $this->a_datetime->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['buyer_instruction'] = $this->buyer_instruction->DefaultValue;
        $row['d_09_head'] = $this->d_09_head->DefaultValue;
        $row['description_09'] = $this->description_09->DefaultValue;
        $row['d_10_head'] = $this->d_10_head->DefaultValue;
        $row['description_10'] = $this->description_10->DefaultValue;
        $row['d_11_head'] = $this->d_11_head->DefaultValue;
        $row['description_11'] = $this->description_11->DefaultValue;
        $row['d_12_head'] = $this->d_12_head->DefaultValue;
        $row['description_12'] = $this->description_12->DefaultValue;
        $row['production_site'] = $this->production_site->DefaultValue;
        $row['request'] = $this->__request->DefaultValue;
        $row['production_plan'] = $this->production_plan->DefaultValue;
        $row['uploads'] = $this->uploads->DefaultValue;
        $row['balance_quantity'] = $this->balance_quantity->DefaultValue;
        $row['e_mail'] = $this->e_mail->DefaultValue;
        $row['billing_address_id'] = $this->billing_address_id->DefaultValue;
        $row['shipping_address_id'] = $this->shipping_address_id->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['app_operator'] = $this->app_operator->DefaultValue;
        $row['app_datetime'] = $this->app_datetime->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['c_operator'] = $this->c_operator->DefaultValue;
        $row['c_datetime'] = $this->c_datetime->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // po

        // company_id

        // partner_id

        // grp
        $this->grp->CellCssStyle = "white-space: nowrap;";

        // s_grp
        $this->s_grp->CellCssStyle = "white-space: nowrap;";

        // location
        $this->location->CellCssStyle = "white-space: nowrap;";

        // copy

        // cart_id

        // quantity

        // sqm

        // amount

        // cbm

        // gst

        // partner_order_no
        $this->partner_order_no->CellCssStyle = "white-space: nowrap;";

        // partner_order_date
        $this->partner_order_date->CellCssStyle = "white-space: nowrap;";

        // despatch_date

        // despatch_week

        // fob_date

        // part_dispatch

        // payment_terms

        // transport_type

        // partner_shipping_id

        // description_04
        $this->description_04->CellCssStyle = "white-space: nowrap;";

        // description_03
        $this->description_03->CellCssStyle = "white-space: nowrap;";

        // description_20
        $this->description_20->CellCssStyle = "white-space: nowrap;";

        // description_01
        $this->description_01->CellCssStyle = "white-space: nowrap;";

        // description_02
        $this->description_02->CellCssStyle = "white-space: nowrap;";

        // description_07
        $this->description_07->CellCssStyle = "white-space: nowrap;";

        // description_17
        $this->description_17->CellCssStyle = "white-space: nowrap;";

        // description_18
        $this->description_18->CellCssStyle = "white-space: nowrap;";

        // description_19
        $this->description_19->CellCssStyle = "white-space: nowrap;";

        // description_05
        $this->description_05->CellCssStyle = "white-space: nowrap;";

        // description_06
        $this->description_06->CellCssStyle = "white-space: nowrap;";

        // description_08
        $this->description_08->CellCssStyle = "white-space: nowrap;";

        // remarks

        // operator

        // datetime

        // a_operator

        // a_datetime

        // jc_no
        $this->jc_no->CellCssStyle = "white-space: nowrap;";

        // buyer_instruction

        // d_09_head

        // description_09

        // d_10_head

        // description_10

        // d_11_head

        // description_11

        // d_12_head

        // description_12

        // production_site
        $this->production_site->CellCssStyle = "white-space: nowrap;";

        // request
        $this->__request->CellCssStyle = "white-space: nowrap;";

        // production_plan

        // uploads
        $this->uploads->CellCssStyle = "white-space: nowrap;";

        // balance_quantity
        $this->balance_quantity->CellCssStyle = "white-space: nowrap;";

        // e_mail
        $this->e_mail->CellCssStyle = "white-space: nowrap;";

        // billing_address_id
        $this->billing_address_id->CellCssStyle = "white-space: nowrap;";

        // shipping_address_id
        $this->shipping_address_id->CellCssStyle = "white-space: nowrap;";

        // status
        $this->status->CellCssStyle = "white-space: nowrap;";

        // app_operator
        $this->app_operator->CellCssStyle = "white-space: nowrap;";

        // app_datetime
        $this->app_datetime->CellCssStyle = "white-space: nowrap;";

        // reports_to
        $this->reports_to->CellCssStyle = "white-space: nowrap;";

        // c_operator
        $this->c_operator->CellCssStyle = "white-space: nowrap;";

        // c_datetime
        $this->c_datetime->CellCssStyle = "white-space: nowrap;";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // po
            $this->po->ViewValue = $this->po->CurrentValue;

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // copy
            $curVal = strval($this->copy->CurrentValue);
            if ($curVal != "") {
                $this->copy->ViewValue = $this->copy->lookupCacheOption($curVal);
                if ($this->copy->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->copy->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->copy->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->copy->getSelectFilter($this); // PHP
                    $sqlWrk = $this->copy->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->copy->Lookup->renderViewRow($rswrk[0]);
                        $this->copy->ViewValue = $this->copy->displayValue($arwrk);
                    } else {
                        $this->copy->ViewValue = FormatNumber($this->copy->CurrentValue, $this->copy->formatPattern());
                    }
                }
            } else {
                $this->copy->ViewValue = null;
            }

            // cart_id
            $curVal = strval($this->cart_id->CurrentValue);
            if ($curVal != "") {
                $this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
                if ($this->cart_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->cart_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->cart_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->cart_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->cart_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->cart_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->cart_id->Lookup->renderViewRow($row);
                            $this->cart_id->ViewValue->add($this->cart_id->displayValue($arwrk));
                        }
                    } else {
                        $this->cart_id->ViewValue = $this->cart_id->CurrentValue;
                    }
                }
            } else {
                $this->cart_id->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // gst
            $curVal = strval($this->gst->CurrentValue);
            if ($curVal != "") {
                $this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
                if ($this->gst->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->gst->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->gst->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->gst->getSelectFilter($this); // PHP
                    $sqlWrk = $this->gst->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->gst->Lookup->renderViewRow($rswrk[0]);
                        $this->gst->ViewValue = $this->gst->displayValue($arwrk);
                    } else {
                        $this->gst->ViewValue = FormatNumber($this->gst->CurrentValue, $this->gst->formatPattern());
                    }
                }
            } else {
                $this->gst->ViewValue = null;
            }

            // partner_order_no
            $this->partner_order_no->ViewValue = $this->partner_order_no->CurrentValue;

            // partner_order_date
            $this->partner_order_date->ViewValue = $this->partner_order_date->CurrentValue;
            $this->partner_order_date->ViewValue = FormatDateTime($this->partner_order_date->ViewValue, $this->partner_order_date->formatPattern());

            // despatch_date
            $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->despatch_week->getSelectFilter($this); // PHP
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // fob_date
            $this->fob_date->ViewValue = $this->fob_date->CurrentValue;
            $this->fob_date->ViewValue = FormatDateTime($this->fob_date->ViewValue, $this->fob_date->formatPattern());

            // part_dispatch
            if (strval($this->part_dispatch->CurrentValue) != "") {
                $this->part_dispatch->ViewValue = $this->part_dispatch->optionCaption($this->part_dispatch->CurrentValue);
            } else {
                $this->part_dispatch->ViewValue = null;
            }

            // payment_terms
            $curVal = strval($this->payment_terms->CurrentValue);
            if ($curVal != "") {
                $this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
                if ($this->payment_terms->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                    $sqlWrk = $this->payment_terms->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment_terms->Lookup->renderViewRow($rswrk[0]);
                        $this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
                    } else {
                        $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
                    }
                }
            } else {
                $this->payment_terms->ViewValue = null;
            }

            // transport_type
            $curVal = strval($this->transport_type->CurrentValue);
            if ($curVal != "") {
                $this->transport_type->ViewValue = $this->transport_type->lookupCacheOption($curVal);
                if ($this->transport_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->transport_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->transport_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->transport_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->transport_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->transport_type->Lookup->renderViewRow($rswrk[0]);
                        $this->transport_type->ViewValue = $this->transport_type->displayValue($arwrk);
                    } else {
                        $this->transport_type->ViewValue = $this->transport_type->CurrentValue;
                    }
                }
            } else {
                $this->transport_type->ViewValue = null;
            }

            // partner_shipping_id
            $curVal = strval($this->partner_shipping_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_shipping_id->ViewValue = $this->partner_shipping_id->lookupCacheOption($curVal);
                if ($this->partner_shipping_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_shipping_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_shipping_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_shipping_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_shipping_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_shipping_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_shipping_id->ViewValue = $this->partner_shipping_id->displayValue($arwrk);
                    } else {
                        $this->partner_shipping_id->ViewValue = FormatNumber($this->partner_shipping_id->CurrentValue, $this->partner_shipping_id->formatPattern());
                    }
                }
            } else {
                $this->partner_shipping_id->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // a_operator
            $curVal = strval($this->a_operator->CurrentValue);
            if ($curVal != "") {
                $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
                if ($this->a_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                    } else {
                        $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
                    }
                }
            } else {
                $this->a_operator->ViewValue = null;
            }

            // a_datetime
            $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
            $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

            // buyer_instruction
            $this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;

            // d_09_head
            $curVal = strval($this->d_09_head->CurrentValue);
            if ($curVal != "") {
                $this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
                if ($this->d_09_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_09_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_09_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_09_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_09_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_09_head->ViewValue = $this->d_09_head->displayValue($arwrk);
                    } else {
                        $this->d_09_head->ViewValue = $this->d_09_head->CurrentValue;
                    }
                }
            } else {
                $this->d_09_head->ViewValue = null;
            }

            // description_09
            $this->description_09->ViewValue = $this->description_09->CurrentValue;

            // d_10_head
            $curVal = strval($this->d_10_head->CurrentValue);
            if ($curVal != "") {
                $this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
                if ($this->d_10_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_10_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_10_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_10_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_10_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_10_head->ViewValue = $this->d_10_head->displayValue($arwrk);
                    } else {
                        $this->d_10_head->ViewValue = $this->d_10_head->CurrentValue;
                    }
                }
            } else {
                $this->d_10_head->ViewValue = null;
            }

            // description_10
            $this->description_10->ViewValue = $this->description_10->CurrentValue;

            // d_11_head
            $curVal = strval($this->d_11_head->CurrentValue);
            if ($curVal != "") {
                $this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
                if ($this->d_11_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_11_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_11_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_11_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_11_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_11_head->ViewValue = $this->d_11_head->displayValue($arwrk);
                    } else {
                        $this->d_11_head->ViewValue = $this->d_11_head->CurrentValue;
                    }
                }
            } else {
                $this->d_11_head->ViewValue = null;
            }

            // description_11
            $this->description_11->ViewValue = $this->description_11->CurrentValue;

            // d_12_head
            $curVal = strval($this->d_12_head->CurrentValue);
            if ($curVal != "") {
                $this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
                if ($this->d_12_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_12_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_12_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_12_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_12_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_12_head->ViewValue = $this->d_12_head->displayValue($arwrk);
                    } else {
                        $this->d_12_head->ViewValue = $this->d_12_head->CurrentValue;
                    }
                }
            } else {
                $this->d_12_head->ViewValue = null;
            }

            // description_12
            $this->description_12->ViewValue = $this->description_12->CurrentValue;

            // production_plan
            if (strval($this->production_plan->CurrentValue) != "") {
                $this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
            } else {
                $this->production_plan->ViewValue = null;
            }

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // po
            if (!EmptyValue($this->po->CurrentValue)) {
                $this->po->HrefValue = $this->po->getLinkPrefix() . $this->po->CurrentValue; // Add prefix/suffix
                $this->po->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
                }
            } else {
                $this->po->HrefValue = "";
            }
            $this->po->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // partner_id
            if (!EmptyValue($this->partner_id->CurrentValue)) {
                $this->partner_id->HrefValue = $this->partner_id->getLinkPrefix() . $this->partner_id->CurrentValue; // Add prefix/suffix
                $this->partner_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
                }
            } else {
                $this->partner_id->HrefValue = "";
            }
            $this->partner_id->TooltipValue = "";

            // copy
            $this->copy->HrefValue = "";
            $this->copy->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";

            // gst
            $this->gst->HrefValue = "";
            $this->gst->TooltipValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";
            $this->despatch_date->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";
            $this->despatch_week->TooltipValue = "";

            // fob_date
            $this->fob_date->HrefValue = "";
            $this->fob_date->TooltipValue = "";

            // payment_terms
            if (!EmptyValue($this->payment_terms->CurrentValue)) {
                $this->payment_terms->HrefValue = $this->payment_terms->getLinkPrefix() . $this->payment_terms->CurrentValue; // Add prefix/suffix
                $this->payment_terms->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->payment_terms->HrefValue = FullUrl($this->payment_terms->HrefValue, "href");
                }
            } else {
                $this->payment_terms->HrefValue = "";
            }
            $this->payment_terms->TooltipValue = "";

            // transport_type
            if (!EmptyValue($this->transport_type->CurrentValue)) {
                $this->transport_type->HrefValue = $this->transport_type->getLinkPrefix() . $this->transport_type->CurrentValue; // Add prefix/suffix
                $this->transport_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->transport_type->HrefValue = FullUrl($this->transport_type->HrefValue, "href");
                }
            } else {
                $this->transport_type->HrefValue = "";
            }
            $this->transport_type->TooltipValue = "";

            // partner_shipping_id
            $this->partner_shipping_id->HrefValue = "";
            $this->partner_shipping_id->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // a_operator
            $this->a_operator->HrefValue = "";
            $this->a_operator->TooltipValue = "";

            // a_datetime
            $this->a_datetime->HrefValue = "";
            $this->a_datetime->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }
        if ($this->AuditTrailOnDelete) {
            $this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
            if ($this->AuditTrailOnDelete) {
                $this->writeAuditTrailDummy($Language->phrase("BatchDeleteSuccess")); // Batch delete success
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
            if ($this->AuditTrailOnDelete) {
                $this->writeAuditTrailDummy($Language->phrase("BatchDeleteRollback")); // Batch delete rollback
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Param("key_m") === null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("poslist"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_copy":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_cart_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_gst":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_despatch_week":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_part_dispatch":
                    break;
                case "x_payment_terms":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_transport_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_shipping_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_04":
                    break;
                case "x_description_03":
                    break;
                case "x_description_20":
                    break;
                case "x_description_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_a_operator":
                    break;
                case "x_d_09_head":
                    break;
                case "x_d_10_head":
                    break;
                case "x_d_11_head":
                    break;
                case "x_d_12_head":
                    break;
                case "x_production_site":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_production_plan":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'po_s');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
