<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PoOverallCrossSearch extends PoOverallCross
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PoOverallCrossSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "pooverallcrosssearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->Buyer->setVisibility();
        $this->Month->setVisibility();
        $this->SQM_CY->setVisibility();
        $this->Amount_CY->setVisibility();
        $this->SQM_PY->setVisibility();
        $this->Amount_PY->setVisibility();
        $this->SQM_BPY->setVisibility();
        $this->Amount_BPY->setVisibility();
        $this->SQM_BBPY->setVisibility();
        $this->Amount_BBPY->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'po_overall_cross';
        $this->TableName = 'po_overall_cross';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (po_overall_cross)
        if (!isset($GLOBALS["po_overall_cross"]) || $GLOBALS["po_overall_cross"]::class == PROJECT_NAMESPACE . "po_overall_cross") {
            $GLOBALS["po_overall_cross"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_overall_cross');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "pooverallcrossview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAddOrEdit()) {
            $this->Buyer->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->Month->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->SQM_CY->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->Amount_CY->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->SQM_PY->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->Amount_PY->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->SQM_BPY->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->Amount_BPY->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->SQM_BBPY->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->Amount_BBPY->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->Buyer);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "pooverallcrosslist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->Buyer); // Buyer
        $this->buildSearchUrl($srchUrl, $this->Month); // Month
        $this->buildSearchUrl($srchUrl, $this->SQM_CY); // SQM_CY
        $this->buildSearchUrl($srchUrl, $this->Amount_CY); // Amount_CY
        $this->buildSearchUrl($srchUrl, $this->SQM_PY); // SQM_PY
        $this->buildSearchUrl($srchUrl, $this->Amount_PY); // Amount_PY
        $this->buildSearchUrl($srchUrl, $this->SQM_BPY); // SQM_BPY
        $this->buildSearchUrl($srchUrl, $this->Amount_BPY); // Amount_BPY
        $this->buildSearchUrl($srchUrl, $this->SQM_BBPY); // SQM_BBPY
        $this->buildSearchUrl($srchUrl, $this->Amount_BBPY); // Amount_BBPY
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Buyer
        if ($this->Buyer->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Month
        if ($this->Month->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // SQM_CY
        if ($this->SQM_CY->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Amount_CY
        if ($this->Amount_CY->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // SQM_PY
        if ($this->SQM_PY->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Amount_PY
        if ($this->Amount_PY->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // SQM_BPY
        if ($this->SQM_BPY->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Amount_BPY
        if ($this->Amount_BPY->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // SQM_BBPY
        if ($this->SQM_BBPY->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Amount_BBPY
        if ($this->Amount_BBPY->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // Buyer
        $this->Buyer->RowCssClass = "row";

        // Month
        $this->Month->RowCssClass = "row";

        // SQM_CY
        $this->SQM_CY->RowCssClass = "row";

        // Amount_CY
        $this->Amount_CY->RowCssClass = "row";

        // SQM_PY
        $this->SQM_PY->RowCssClass = "row";

        // Amount_PY
        $this->Amount_PY->RowCssClass = "row";

        // SQM_BPY
        $this->SQM_BPY->RowCssClass = "row";

        // Amount_BPY
        $this->Amount_BPY->RowCssClass = "row";

        // SQM_BBPY
        $this->SQM_BBPY->RowCssClass = "row";

        // Amount_BBPY
        $this->Amount_BBPY->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // Buyer
            $curVal = strval($this->Buyer->CurrentValue);
            if ($curVal != "") {
                $this->Buyer->ViewValue = $this->Buyer->lookupCacheOption($curVal);
                if ($this->Buyer->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->Buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->Buyer->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Buyer->Lookup->renderViewRow($rswrk[0]);
                        $this->Buyer->ViewValue = $this->Buyer->displayValue($arwrk);
                    } else {
                        $this->Buyer->ViewValue = FormatNumber($this->Buyer->CurrentValue, $this->Buyer->formatPattern());
                    }
                }
            } else {
                $this->Buyer->ViewValue = null;
            }

            // Month
            $this->Month->ViewValue = $this->Month->CurrentValue;

            // SQM_CY
            $this->SQM_CY->ViewValue = $this->SQM_CY->CurrentValue;
            $this->SQM_CY->ViewValue = FormatNumber($this->SQM_CY->ViewValue, $this->SQM_CY->formatPattern());

            // Amount_CY
            $this->Amount_CY->ViewValue = $this->Amount_CY->CurrentValue;

            // SQM_PY
            $this->SQM_PY->ViewValue = $this->SQM_PY->CurrentValue;
            $this->SQM_PY->ViewValue = FormatNumber($this->SQM_PY->ViewValue, $this->SQM_PY->formatPattern());

            // Amount_PY
            $this->Amount_PY->ViewValue = $this->Amount_PY->CurrentValue;

            // SQM_BPY
            $this->SQM_BPY->ViewValue = $this->SQM_BPY->CurrentValue;
            $this->SQM_BPY->ViewValue = FormatNumber($this->SQM_BPY->ViewValue, $this->SQM_BPY->formatPattern());

            // Amount_BPY
            $this->Amount_BPY->ViewValue = $this->Amount_BPY->CurrentValue;

            // SQM_BBPY
            $this->SQM_BBPY->ViewValue = $this->SQM_BBPY->CurrentValue;
            $this->SQM_BBPY->ViewValue = FormatNumber($this->SQM_BBPY->ViewValue, $this->SQM_BBPY->formatPattern());

            // Amount_BBPY
            $this->Amount_BBPY->ViewValue = $this->Amount_BBPY->CurrentValue;

            // Buyer
            $this->Buyer->HrefValue = "";
            $this->Buyer->TooltipValue = "";

            // Month
            $this->Month->HrefValue = "";
            $this->Month->TooltipValue = "";

            // SQM_CY
            $this->SQM_CY->HrefValue = "";
            $this->SQM_CY->TooltipValue = "";

            // Amount_CY
            $this->Amount_CY->HrefValue = "";
            $this->Amount_CY->TooltipValue = "";

            // SQM_PY
            $this->SQM_PY->HrefValue = "";
            $this->SQM_PY->TooltipValue = "";

            // Amount_PY
            $this->Amount_PY->HrefValue = "";
            $this->Amount_PY->TooltipValue = "";

            // SQM_BPY
            $this->SQM_BPY->HrefValue = "";
            $this->SQM_BPY->TooltipValue = "";

            // Amount_BPY
            $this->Amount_BPY->HrefValue = "";
            $this->Amount_BPY->TooltipValue = "";

            // SQM_BBPY
            $this->SQM_BBPY->HrefValue = "";
            $this->SQM_BBPY->TooltipValue = "";

            // Amount_BBPY
            $this->Amount_BBPY->HrefValue = "";
            $this->Amount_BBPY->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // Buyer
            $this->Buyer->setupEditAttributes();
            $curVal = trim(strval($this->Buyer->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Buyer->AdvancedSearch->ViewValue = $this->Buyer->lookupCacheOption($curVal);
            } else {
                $this->Buyer->AdvancedSearch->ViewValue = $this->Buyer->Lookup !== null && is_array($this->Buyer->lookupOptions()) && count($this->Buyer->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Buyer->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Buyer->EditValue = array_values($this->Buyer->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->Buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->Buyer->AdvancedSearch->SearchValue, $this->Buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->Buyer->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Buyer->EditValue = $arwrk;
            }
            $this->Buyer->PlaceHolder = RemoveHtml($this->Buyer->caption());

            // Month
            $this->Month->setupEditAttributes();
            if (!$this->Month->Raw) {
                $this->Month->AdvancedSearch->SearchValue = HtmlDecode($this->Month->AdvancedSearch->SearchValue);
            }
            $this->Month->EditValue = HtmlEncode($this->Month->AdvancedSearch->SearchValue);
            $this->Month->PlaceHolder = RemoveHtml($this->Month->caption());

            // SQM_CY
            $this->SQM_CY->setupEditAttributes();
            $this->SQM_CY->EditValue = $this->SQM_CY->AdvancedSearch->SearchValue;
            $this->SQM_CY->PlaceHolder = RemoveHtml($this->SQM_CY->caption());

            // Amount_CY
            $this->Amount_CY->setupEditAttributes();
            if (!$this->Amount_CY->Raw) {
                $this->Amount_CY->AdvancedSearch->SearchValue = HtmlDecode($this->Amount_CY->AdvancedSearch->SearchValue);
            }
            $this->Amount_CY->EditValue = HtmlEncode($this->Amount_CY->AdvancedSearch->SearchValue);
            $this->Amount_CY->PlaceHolder = RemoveHtml($this->Amount_CY->caption());

            // SQM_PY
            $this->SQM_PY->setupEditAttributes();
            $this->SQM_PY->EditValue = $this->SQM_PY->AdvancedSearch->SearchValue;
            $this->SQM_PY->PlaceHolder = RemoveHtml($this->SQM_PY->caption());

            // Amount_PY
            $this->Amount_PY->setupEditAttributes();
            if (!$this->Amount_PY->Raw) {
                $this->Amount_PY->AdvancedSearch->SearchValue = HtmlDecode($this->Amount_PY->AdvancedSearch->SearchValue);
            }
            $this->Amount_PY->EditValue = HtmlEncode($this->Amount_PY->AdvancedSearch->SearchValue);
            $this->Amount_PY->PlaceHolder = RemoveHtml($this->Amount_PY->caption());

            // SQM_BPY
            $this->SQM_BPY->setupEditAttributes();
            $this->SQM_BPY->EditValue = $this->SQM_BPY->AdvancedSearch->SearchValue;
            $this->SQM_BPY->PlaceHolder = RemoveHtml($this->SQM_BPY->caption());

            // Amount_BPY
            $this->Amount_BPY->setupEditAttributes();
            if (!$this->Amount_BPY->Raw) {
                $this->Amount_BPY->AdvancedSearch->SearchValue = HtmlDecode($this->Amount_BPY->AdvancedSearch->SearchValue);
            }
            $this->Amount_BPY->EditValue = HtmlEncode($this->Amount_BPY->AdvancedSearch->SearchValue);
            $this->Amount_BPY->PlaceHolder = RemoveHtml($this->Amount_BPY->caption());

            // SQM_BBPY
            $this->SQM_BBPY->setupEditAttributes();
            $this->SQM_BBPY->EditValue = $this->SQM_BBPY->AdvancedSearch->SearchValue;
            $this->SQM_BBPY->PlaceHolder = RemoveHtml($this->SQM_BBPY->caption());

            // Amount_BBPY
            $this->Amount_BBPY->setupEditAttributes();
            if (!$this->Amount_BBPY->Raw) {
                $this->Amount_BBPY->AdvancedSearch->SearchValue = HtmlDecode($this->Amount_BBPY->AdvancedSearch->SearchValue);
            }
            $this->Amount_BBPY->EditValue = HtmlEncode($this->Amount_BBPY->AdvancedSearch->SearchValue);
            $this->Amount_BBPY->PlaceHolder = RemoveHtml($this->Amount_BBPY->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckNumber($this->SQM_CY->AdvancedSearch->SearchValue)) {
            $this->SQM_CY->addErrorMessage($this->SQM_CY->getErrorMessage(false));
        }
        if (!CheckNumber($this->SQM_PY->AdvancedSearch->SearchValue)) {
            $this->SQM_PY->addErrorMessage($this->SQM_PY->getErrorMessage(false));
        }
        if (!CheckNumber($this->SQM_BPY->AdvancedSearch->SearchValue)) {
            $this->SQM_BPY->addErrorMessage($this->SQM_BPY->getErrorMessage(false));
        }
        if (!CheckNumber($this->SQM_BBPY->AdvancedSearch->SearchValue)) {
            $this->SQM_BBPY->addErrorMessage($this->SQM_BBPY->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->Buyer->AdvancedSearch->load();
        $this->Month->AdvancedSearch->load();
        $this->SQM_CY->AdvancedSearch->load();
        $this->Amount_CY->AdvancedSearch->load();
        $this->SQM_PY->AdvancedSearch->load();
        $this->Amount_PY->AdvancedSearch->load();
        $this->SQM_BPY->AdvancedSearch->load();
        $this->Amount_BPY->AdvancedSearch->load();
        $this->SQM_BBPY->AdvancedSearch->load();
        $this->Amount_BBPY->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("pooverallcrosslist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_Buyer":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
