<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PoList extends Po
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PoList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fpolist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "polist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->order_type->setVisibility();
        $this->buyer_id->setVisibility();
        $this->buyer_order_no->Visible = false;
        $this->buyer_order_date->Visible = false;
        $this->cart_id->Visible = false;
        $this->buyer_product_ref->Visible = false;
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->despatch_date->setVisibility();
        $this->despatch_week->setVisibility();
        $this->fob_date->setVisibility();
        $this->part_dispatch->Visible = false;
        $this->payment_terms->setVisibility();
        $this->transport_terms->setVisibility();
        $this->buyer_shipping_id->setVisibility();
        $this->description_04->setVisibility();
        $this->description_03->setVisibility();
        $this->description_01->Visible = false;
        $this->description_02->Visible = false;
        $this->description_07->Visible = false;
        $this->description_20->setVisibility();
        $this->description_17->setVisibility();
        $this->description_18->setVisibility();
        $this->description_19->setVisibility();
        $this->quantity->setVisibility();
        $this->price->setVisibility();
        $this->currency->Visible = false;
        $this->amount->setVisibility();
        $this->cbm->setVisibility();
        $this->buyer_size->setVisibility();
        $this->description_05->Visible = false;
        $this->description_06->Visible = false;
        $this->description_08->Visible = false;
        $this->remarks->Visible = false;
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->a_operator->setVisibility();
        $this->a_datetime->setVisibility();
        $this->jc_no->Visible = false;
        $this->buyer_instruction->Visible = false;
        $this->d_09_head->Visible = false;
        $this->description_09->Visible = false;
        $this->d_10_head->Visible = false;
        $this->description_10->Visible = false;
        $this->d_11_head->Visible = false;
        $this->description_11->Visible = false;
        $this->d_12_head->Visible = false;
        $this->description_12->Visible = false;
        $this->po->Visible = false;
        $this->production_site->Visible = false;
        $this->c_total->Visible = false;
        $this->production_plan->Visible = false;
        $this->lot_no->Visible = false;
        $this->product_gcode->Visible = false;
        $this->batch_no->Visible = false;
        $this->uploads->Visible = false;
        $this->d_01_head->Visible = false;
        $this->d_02_head->Visible = false;
        $this->d_03_head->Visible = false;
        $this->d_04_head->Visible = false;
        $this->d_05_head->Visible = false;
        $this->d_06_head->Visible = false;
        $this->d_07_head->Visible = false;
        $this->d_08_head->Visible = false;
        $this->sample->Visible = false;
        $this->balance_quantity->Visible = false;
        $this->_action->setVisibility();
        $this->url->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'po';
        $this->TableName = 'po';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (po)
        if (!isset($GLOBALS["po"]) || $GLOBALS["po"]::class == PROJECT_NAMESPACE . "po") {
            $GLOBALS["po"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "poadd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "podelete";
        $this->MultiUpdateUrl = "poupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'po');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "poview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->a_operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->a_datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->order_type);
        $this->setupLookupOptions($this->buyer_id);
        $this->setupLookupOptions($this->cart_id);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->part_dispatch);
        $this->setupLookupOptions($this->payment_terms);
        $this->setupLookupOptions($this->description_04);
        $this->setupLookupOptions($this->description_03);
        $this->setupLookupOptions($this->description_20);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->description_05);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->a_operator);
        $this->setupLookupOptions($this->d_09_head);
        $this->setupLookupOptions($this->d_10_head);
        $this->setupLookupOptions($this->d_11_head);
        $this->setupLookupOptions($this->d_12_head);
        $this->setupLookupOptions($this->production_site);
        $this->setupLookupOptions($this->production_plan);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fpogrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fposrch");
        }
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->order_type->AdvancedSearch->toJson(), ","); // Field order_type
        $filterList = Concat($filterList, $this->buyer_id->AdvancedSearch->toJson(), ","); // Field buyer_id
        $filterList = Concat($filterList, $this->buyer_order_no->AdvancedSearch->toJson(), ","); // Field buyer_order_no
        $filterList = Concat($filterList, $this->buyer_order_date->AdvancedSearch->toJson(), ","); // Field buyer_order_date
        $filterList = Concat($filterList, $this->cart_id->AdvancedSearch->toJson(), ","); // Field cart_id
        $filterList = Concat($filterList, $this->buyer_product_ref->AdvancedSearch->toJson(), ","); // Field buyer_product_ref
        $filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
        $filterList = Concat($filterList, $this->s_grp->AdvancedSearch->toJson(), ","); // Field s_grp
        $filterList = Concat($filterList, $this->product->AdvancedSearch->toJson(), ","); // Field product
        $filterList = Concat($filterList, $this->rid->AdvancedSearch->toJson(), ","); // Field rid
        $filterList = Concat($filterList, $this->despatch_week->AdvancedSearch->toJson(), ","); // Field despatch_week
        $filterList = Concat($filterList, $this->payment_terms->AdvancedSearch->toJson(), ","); // Field payment_terms
        $filterList = Concat($filterList, $this->transport_terms->AdvancedSearch->toJson(), ","); // Field transport_terms
        $filterList = Concat($filterList, $this->buyer_shipping_id->AdvancedSearch->toJson(), ","); // Field buyer_shipping _id
        $filterList = Concat($filterList, $this->description_03->AdvancedSearch->toJson(), ","); // Field description_03
        $filterList = Concat($filterList, $this->description_07->AdvancedSearch->toJson(), ","); // Field description_07
        $filterList = Concat($filterList, $this->description_20->AdvancedSearch->toJson(), ","); // Field description_20
        $filterList = Concat($filterList, $this->description_17->AdvancedSearch->toJson(), ","); // Field description_17
        $filterList = Concat($filterList, $this->description_18->AdvancedSearch->toJson(), ","); // Field description_18
        $filterList = Concat($filterList, $this->description_19->AdvancedSearch->toJson(), ","); // Field description_19
        $filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
        $filterList = Concat($filterList, $this->price->AdvancedSearch->toJson(), ","); // Field price
        $filterList = Concat($filterList, $this->currency->AdvancedSearch->toJson(), ","); // Field currency
        $filterList = Concat($filterList, $this->amount->AdvancedSearch->toJson(), ","); // Field amount
        $filterList = Concat($filterList, $this->cbm->AdvancedSearch->toJson(), ","); // Field cbm
        $filterList = Concat($filterList, $this->buyer_size->AdvancedSearch->toJson(), ","); // Field buyer_size
        $filterList = Concat($filterList, $this->description_05->AdvancedSearch->toJson(), ","); // Field description_05
        $filterList = Concat($filterList, $this->description_06->AdvancedSearch->toJson(), ","); // Field description_06
        $filterList = Concat($filterList, $this->description_08->AdvancedSearch->toJson(), ","); // Field description_08
        $filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
        $filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
        $filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
        $filterList = Concat($filterList, $this->a_operator->AdvancedSearch->toJson(), ","); // Field a_operator
        $filterList = Concat($filterList, $this->a_datetime->AdvancedSearch->toJson(), ","); // Field a_datetime
        $filterList = Concat($filterList, $this->buyer_instruction->AdvancedSearch->toJson(), ","); // Field buyer_instruction
        $filterList = Concat($filterList, $this->d_09_head->AdvancedSearch->toJson(), ","); // Field d_09_head
        $filterList = Concat($filterList, $this->description_09->AdvancedSearch->toJson(), ","); // Field description_09
        $filterList = Concat($filterList, $this->d_10_head->AdvancedSearch->toJson(), ","); // Field d_10_head
        $filterList = Concat($filterList, $this->description_10->AdvancedSearch->toJson(), ","); // Field description_10
        $filterList = Concat($filterList, $this->d_11_head->AdvancedSearch->toJson(), ","); // Field d_11_head
        $filterList = Concat($filterList, $this->description_11->AdvancedSearch->toJson(), ","); // Field description_11
        $filterList = Concat($filterList, $this->d_12_head->AdvancedSearch->toJson(), ","); // Field d_12_head
        $filterList = Concat($filterList, $this->description_12->AdvancedSearch->toJson(), ","); // Field description_12
        $filterList = Concat($filterList, $this->_action->AdvancedSearch->toJson(), ","); // Field action
        $filterList = Concat($filterList, $this->url->AdvancedSearch->toJson(), ","); // Field url
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fposrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field order_type
        $this->order_type->AdvancedSearch->SearchValue = @$filter["x_order_type"];
        $this->order_type->AdvancedSearch->SearchOperator = @$filter["z_order_type"];
        $this->order_type->AdvancedSearch->SearchCondition = @$filter["v_order_type"];
        $this->order_type->AdvancedSearch->SearchValue2 = @$filter["y_order_type"];
        $this->order_type->AdvancedSearch->SearchOperator2 = @$filter["w_order_type"];
        $this->order_type->AdvancedSearch->save();

        // Field buyer_id
        $this->buyer_id->AdvancedSearch->SearchValue = @$filter["x_buyer_id"];
        $this->buyer_id->AdvancedSearch->SearchOperator = @$filter["z_buyer_id"];
        $this->buyer_id->AdvancedSearch->SearchCondition = @$filter["v_buyer_id"];
        $this->buyer_id->AdvancedSearch->SearchValue2 = @$filter["y_buyer_id"];
        $this->buyer_id->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_id"];
        $this->buyer_id->AdvancedSearch->save();

        // Field buyer_order_no
        $this->buyer_order_no->AdvancedSearch->SearchValue = @$filter["x_buyer_order_no"];
        $this->buyer_order_no->AdvancedSearch->SearchOperator = @$filter["z_buyer_order_no"];
        $this->buyer_order_no->AdvancedSearch->SearchCondition = @$filter["v_buyer_order_no"];
        $this->buyer_order_no->AdvancedSearch->SearchValue2 = @$filter["y_buyer_order_no"];
        $this->buyer_order_no->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_order_no"];
        $this->buyer_order_no->AdvancedSearch->save();

        // Field buyer_order_date
        $this->buyer_order_date->AdvancedSearch->SearchValue = @$filter["x_buyer_order_date"];
        $this->buyer_order_date->AdvancedSearch->SearchOperator = @$filter["z_buyer_order_date"];
        $this->buyer_order_date->AdvancedSearch->SearchCondition = @$filter["v_buyer_order_date"];
        $this->buyer_order_date->AdvancedSearch->SearchValue2 = @$filter["y_buyer_order_date"];
        $this->buyer_order_date->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_order_date"];
        $this->buyer_order_date->AdvancedSearch->save();

        // Field cart_id
        $this->cart_id->AdvancedSearch->SearchValue = @$filter["x_cart_id"];
        $this->cart_id->AdvancedSearch->SearchOperator = @$filter["z_cart_id"];
        $this->cart_id->AdvancedSearch->SearchCondition = @$filter["v_cart_id"];
        $this->cart_id->AdvancedSearch->SearchValue2 = @$filter["y_cart_id"];
        $this->cart_id->AdvancedSearch->SearchOperator2 = @$filter["w_cart_id"];
        $this->cart_id->AdvancedSearch->save();

        // Field buyer_product_ref
        $this->buyer_product_ref->AdvancedSearch->SearchValue = @$filter["x_buyer_product_ref"];
        $this->buyer_product_ref->AdvancedSearch->SearchOperator = @$filter["z_buyer_product_ref"];
        $this->buyer_product_ref->AdvancedSearch->SearchCondition = @$filter["v_buyer_product_ref"];
        $this->buyer_product_ref->AdvancedSearch->SearchValue2 = @$filter["y_buyer_product_ref"];
        $this->buyer_product_ref->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_product_ref"];
        $this->buyer_product_ref->AdvancedSearch->save();

        // Field grp
        $this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
        $this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
        $this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
        $this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
        $this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
        $this->grp->AdvancedSearch->save();

        // Field s_grp
        $this->s_grp->AdvancedSearch->SearchValue = @$filter["x_s_grp"];
        $this->s_grp->AdvancedSearch->SearchOperator = @$filter["z_s_grp"];
        $this->s_grp->AdvancedSearch->SearchCondition = @$filter["v_s_grp"];
        $this->s_grp->AdvancedSearch->SearchValue2 = @$filter["y_s_grp"];
        $this->s_grp->AdvancedSearch->SearchOperator2 = @$filter["w_s_grp"];
        $this->s_grp->AdvancedSearch->save();

        // Field product
        $this->product->AdvancedSearch->SearchValue = @$filter["x_product"];
        $this->product->AdvancedSearch->SearchOperator = @$filter["z_product"];
        $this->product->AdvancedSearch->SearchCondition = @$filter["v_product"];
        $this->product->AdvancedSearch->SearchValue2 = @$filter["y_product"];
        $this->product->AdvancedSearch->SearchOperator2 = @$filter["w_product"];
        $this->product->AdvancedSearch->save();

        // Field rid
        $this->rid->AdvancedSearch->SearchValue = @$filter["x_rid"];
        $this->rid->AdvancedSearch->SearchOperator = @$filter["z_rid"];
        $this->rid->AdvancedSearch->SearchCondition = @$filter["v_rid"];
        $this->rid->AdvancedSearch->SearchValue2 = @$filter["y_rid"];
        $this->rid->AdvancedSearch->SearchOperator2 = @$filter["w_rid"];
        $this->rid->AdvancedSearch->save();

        // Field despatch_week
        $this->despatch_week->AdvancedSearch->SearchValue = @$filter["x_despatch_week"];
        $this->despatch_week->AdvancedSearch->SearchOperator = @$filter["z_despatch_week"];
        $this->despatch_week->AdvancedSearch->SearchCondition = @$filter["v_despatch_week"];
        $this->despatch_week->AdvancedSearch->SearchValue2 = @$filter["y_despatch_week"];
        $this->despatch_week->AdvancedSearch->SearchOperator2 = @$filter["w_despatch_week"];
        $this->despatch_week->AdvancedSearch->save();

        // Field payment_terms
        $this->payment_terms->AdvancedSearch->SearchValue = @$filter["x_payment_terms"];
        $this->payment_terms->AdvancedSearch->SearchOperator = @$filter["z_payment_terms"];
        $this->payment_terms->AdvancedSearch->SearchCondition = @$filter["v_payment_terms"];
        $this->payment_terms->AdvancedSearch->SearchValue2 = @$filter["y_payment_terms"];
        $this->payment_terms->AdvancedSearch->SearchOperator2 = @$filter["w_payment_terms"];
        $this->payment_terms->AdvancedSearch->save();

        // Field transport_terms
        $this->transport_terms->AdvancedSearch->SearchValue = @$filter["x_transport_terms"];
        $this->transport_terms->AdvancedSearch->SearchOperator = @$filter["z_transport_terms"];
        $this->transport_terms->AdvancedSearch->SearchCondition = @$filter["v_transport_terms"];
        $this->transport_terms->AdvancedSearch->SearchValue2 = @$filter["y_transport_terms"];
        $this->transport_terms->AdvancedSearch->SearchOperator2 = @$filter["w_transport_terms"];
        $this->transport_terms->AdvancedSearch->save();

        // Field buyer_shipping _id
        $this->buyer_shipping_id->AdvancedSearch->SearchValue = @$filter["x_buyer_shipping_id"];
        $this->buyer_shipping_id->AdvancedSearch->SearchOperator = @$filter["z_buyer_shipping_id"];
        $this->buyer_shipping_id->AdvancedSearch->SearchCondition = @$filter["v_buyer_shipping_id"];
        $this->buyer_shipping_id->AdvancedSearch->SearchValue2 = @$filter["y_buyer_shipping_id"];
        $this->buyer_shipping_id->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_shipping_id"];
        $this->buyer_shipping_id->AdvancedSearch->save();

        // Field description_03
        $this->description_03->AdvancedSearch->SearchValue = @$filter["x_description_03"];
        $this->description_03->AdvancedSearch->SearchOperator = @$filter["z_description_03"];
        $this->description_03->AdvancedSearch->SearchCondition = @$filter["v_description_03"];
        $this->description_03->AdvancedSearch->SearchValue2 = @$filter["y_description_03"];
        $this->description_03->AdvancedSearch->SearchOperator2 = @$filter["w_description_03"];
        $this->description_03->AdvancedSearch->save();

        // Field description_07
        $this->description_07->AdvancedSearch->SearchValue = @$filter["x_description_07"];
        $this->description_07->AdvancedSearch->SearchOperator = @$filter["z_description_07"];
        $this->description_07->AdvancedSearch->SearchCondition = @$filter["v_description_07"];
        $this->description_07->AdvancedSearch->SearchValue2 = @$filter["y_description_07"];
        $this->description_07->AdvancedSearch->SearchOperator2 = @$filter["w_description_07"];
        $this->description_07->AdvancedSearch->save();

        // Field description_20
        $this->description_20->AdvancedSearch->SearchValue = @$filter["x_description_20"];
        $this->description_20->AdvancedSearch->SearchOperator = @$filter["z_description_20"];
        $this->description_20->AdvancedSearch->SearchCondition = @$filter["v_description_20"];
        $this->description_20->AdvancedSearch->SearchValue2 = @$filter["y_description_20"];
        $this->description_20->AdvancedSearch->SearchOperator2 = @$filter["w_description_20"];
        $this->description_20->AdvancedSearch->save();

        // Field description_17
        $this->description_17->AdvancedSearch->SearchValue = @$filter["x_description_17"];
        $this->description_17->AdvancedSearch->SearchOperator = @$filter["z_description_17"];
        $this->description_17->AdvancedSearch->SearchCondition = @$filter["v_description_17"];
        $this->description_17->AdvancedSearch->SearchValue2 = @$filter["y_description_17"];
        $this->description_17->AdvancedSearch->SearchOperator2 = @$filter["w_description_17"];
        $this->description_17->AdvancedSearch->save();

        // Field description_18
        $this->description_18->AdvancedSearch->SearchValue = @$filter["x_description_18"];
        $this->description_18->AdvancedSearch->SearchOperator = @$filter["z_description_18"];
        $this->description_18->AdvancedSearch->SearchCondition = @$filter["v_description_18"];
        $this->description_18->AdvancedSearch->SearchValue2 = @$filter["y_description_18"];
        $this->description_18->AdvancedSearch->SearchOperator2 = @$filter["w_description_18"];
        $this->description_18->AdvancedSearch->save();

        // Field description_19
        $this->description_19->AdvancedSearch->SearchValue = @$filter["x_description_19"];
        $this->description_19->AdvancedSearch->SearchOperator = @$filter["z_description_19"];
        $this->description_19->AdvancedSearch->SearchCondition = @$filter["v_description_19"];
        $this->description_19->AdvancedSearch->SearchValue2 = @$filter["y_description_19"];
        $this->description_19->AdvancedSearch->SearchOperator2 = @$filter["w_description_19"];
        $this->description_19->AdvancedSearch->save();

        // Field quantity
        $this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
        $this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
        $this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
        $this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
        $this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
        $this->quantity->AdvancedSearch->save();

        // Field price
        $this->price->AdvancedSearch->SearchValue = @$filter["x_price"];
        $this->price->AdvancedSearch->SearchOperator = @$filter["z_price"];
        $this->price->AdvancedSearch->SearchCondition = @$filter["v_price"];
        $this->price->AdvancedSearch->SearchValue2 = @$filter["y_price"];
        $this->price->AdvancedSearch->SearchOperator2 = @$filter["w_price"];
        $this->price->AdvancedSearch->save();

        // Field currency
        $this->currency->AdvancedSearch->SearchValue = @$filter["x_currency"];
        $this->currency->AdvancedSearch->SearchOperator = @$filter["z_currency"];
        $this->currency->AdvancedSearch->SearchCondition = @$filter["v_currency"];
        $this->currency->AdvancedSearch->SearchValue2 = @$filter["y_currency"];
        $this->currency->AdvancedSearch->SearchOperator2 = @$filter["w_currency"];
        $this->currency->AdvancedSearch->save();

        // Field amount
        $this->amount->AdvancedSearch->SearchValue = @$filter["x_amount"];
        $this->amount->AdvancedSearch->SearchOperator = @$filter["z_amount"];
        $this->amount->AdvancedSearch->SearchCondition = @$filter["v_amount"];
        $this->amount->AdvancedSearch->SearchValue2 = @$filter["y_amount"];
        $this->amount->AdvancedSearch->SearchOperator2 = @$filter["w_amount"];
        $this->amount->AdvancedSearch->save();

        // Field cbm
        $this->cbm->AdvancedSearch->SearchValue = @$filter["x_cbm"];
        $this->cbm->AdvancedSearch->SearchOperator = @$filter["z_cbm"];
        $this->cbm->AdvancedSearch->SearchCondition = @$filter["v_cbm"];
        $this->cbm->AdvancedSearch->SearchValue2 = @$filter["y_cbm"];
        $this->cbm->AdvancedSearch->SearchOperator2 = @$filter["w_cbm"];
        $this->cbm->AdvancedSearch->save();

        // Field buyer_size
        $this->buyer_size->AdvancedSearch->SearchValue = @$filter["x_buyer_size"];
        $this->buyer_size->AdvancedSearch->SearchOperator = @$filter["z_buyer_size"];
        $this->buyer_size->AdvancedSearch->SearchCondition = @$filter["v_buyer_size"];
        $this->buyer_size->AdvancedSearch->SearchValue2 = @$filter["y_buyer_size"];
        $this->buyer_size->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_size"];
        $this->buyer_size->AdvancedSearch->save();

        // Field description_05
        $this->description_05->AdvancedSearch->SearchValue = @$filter["x_description_05"];
        $this->description_05->AdvancedSearch->SearchOperator = @$filter["z_description_05"];
        $this->description_05->AdvancedSearch->SearchCondition = @$filter["v_description_05"];
        $this->description_05->AdvancedSearch->SearchValue2 = @$filter["y_description_05"];
        $this->description_05->AdvancedSearch->SearchOperator2 = @$filter["w_description_05"];
        $this->description_05->AdvancedSearch->save();

        // Field description_06
        $this->description_06->AdvancedSearch->SearchValue = @$filter["x_description_06"];
        $this->description_06->AdvancedSearch->SearchOperator = @$filter["z_description_06"];
        $this->description_06->AdvancedSearch->SearchCondition = @$filter["v_description_06"];
        $this->description_06->AdvancedSearch->SearchValue2 = @$filter["y_description_06"];
        $this->description_06->AdvancedSearch->SearchOperator2 = @$filter["w_description_06"];
        $this->description_06->AdvancedSearch->save();

        // Field description_08
        $this->description_08->AdvancedSearch->SearchValue = @$filter["x_description_08"];
        $this->description_08->AdvancedSearch->SearchOperator = @$filter["z_description_08"];
        $this->description_08->AdvancedSearch->SearchCondition = @$filter["v_description_08"];
        $this->description_08->AdvancedSearch->SearchValue2 = @$filter["y_description_08"];
        $this->description_08->AdvancedSearch->SearchOperator2 = @$filter["w_description_08"];
        $this->description_08->AdvancedSearch->save();

        // Field remarks
        $this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
        $this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
        $this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
        $this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
        $this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
        $this->remarks->AdvancedSearch->save();

        // Field operator
        $this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
        $this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
        $this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
        $this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
        $this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
        $this->operator->AdvancedSearch->save();

        // Field datetime
        $this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
        $this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
        $this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
        $this->datetime->AdvancedSearch->save();

        // Field a_operator
        $this->a_operator->AdvancedSearch->SearchValue = @$filter["x_a_operator"];
        $this->a_operator->AdvancedSearch->SearchOperator = @$filter["z_a_operator"];
        $this->a_operator->AdvancedSearch->SearchCondition = @$filter["v_a_operator"];
        $this->a_operator->AdvancedSearch->SearchValue2 = @$filter["y_a_operator"];
        $this->a_operator->AdvancedSearch->SearchOperator2 = @$filter["w_a_operator"];
        $this->a_operator->AdvancedSearch->save();

        // Field a_datetime
        $this->a_datetime->AdvancedSearch->SearchValue = @$filter["x_a_datetime"];
        $this->a_datetime->AdvancedSearch->SearchOperator = @$filter["z_a_datetime"];
        $this->a_datetime->AdvancedSearch->SearchCondition = @$filter["v_a_datetime"];
        $this->a_datetime->AdvancedSearch->SearchValue2 = @$filter["y_a_datetime"];
        $this->a_datetime->AdvancedSearch->SearchOperator2 = @$filter["w_a_datetime"];
        $this->a_datetime->AdvancedSearch->save();

        // Field buyer_instruction
        $this->buyer_instruction->AdvancedSearch->SearchValue = @$filter["x_buyer_instruction"];
        $this->buyer_instruction->AdvancedSearch->SearchOperator = @$filter["z_buyer_instruction"];
        $this->buyer_instruction->AdvancedSearch->SearchCondition = @$filter["v_buyer_instruction"];
        $this->buyer_instruction->AdvancedSearch->SearchValue2 = @$filter["y_buyer_instruction"];
        $this->buyer_instruction->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_instruction"];
        $this->buyer_instruction->AdvancedSearch->save();

        // Field d_09_head
        $this->d_09_head->AdvancedSearch->SearchValue = @$filter["x_d_09_head"];
        $this->d_09_head->AdvancedSearch->SearchOperator = @$filter["z_d_09_head"];
        $this->d_09_head->AdvancedSearch->SearchCondition = @$filter["v_d_09_head"];
        $this->d_09_head->AdvancedSearch->SearchValue2 = @$filter["y_d_09_head"];
        $this->d_09_head->AdvancedSearch->SearchOperator2 = @$filter["w_d_09_head"];
        $this->d_09_head->AdvancedSearch->save();

        // Field description_09
        $this->description_09->AdvancedSearch->SearchValue = @$filter["x_description_09"];
        $this->description_09->AdvancedSearch->SearchOperator = @$filter["z_description_09"];
        $this->description_09->AdvancedSearch->SearchCondition = @$filter["v_description_09"];
        $this->description_09->AdvancedSearch->SearchValue2 = @$filter["y_description_09"];
        $this->description_09->AdvancedSearch->SearchOperator2 = @$filter["w_description_09"];
        $this->description_09->AdvancedSearch->save();

        // Field d_10_head
        $this->d_10_head->AdvancedSearch->SearchValue = @$filter["x_d_10_head"];
        $this->d_10_head->AdvancedSearch->SearchOperator = @$filter["z_d_10_head"];
        $this->d_10_head->AdvancedSearch->SearchCondition = @$filter["v_d_10_head"];
        $this->d_10_head->AdvancedSearch->SearchValue2 = @$filter["y_d_10_head"];
        $this->d_10_head->AdvancedSearch->SearchOperator2 = @$filter["w_d_10_head"];
        $this->d_10_head->AdvancedSearch->save();

        // Field description_10
        $this->description_10->AdvancedSearch->SearchValue = @$filter["x_description_10"];
        $this->description_10->AdvancedSearch->SearchOperator = @$filter["z_description_10"];
        $this->description_10->AdvancedSearch->SearchCondition = @$filter["v_description_10"];
        $this->description_10->AdvancedSearch->SearchValue2 = @$filter["y_description_10"];
        $this->description_10->AdvancedSearch->SearchOperator2 = @$filter["w_description_10"];
        $this->description_10->AdvancedSearch->save();

        // Field d_11_head
        $this->d_11_head->AdvancedSearch->SearchValue = @$filter["x_d_11_head"];
        $this->d_11_head->AdvancedSearch->SearchOperator = @$filter["z_d_11_head"];
        $this->d_11_head->AdvancedSearch->SearchCondition = @$filter["v_d_11_head"];
        $this->d_11_head->AdvancedSearch->SearchValue2 = @$filter["y_d_11_head"];
        $this->d_11_head->AdvancedSearch->SearchOperator2 = @$filter["w_d_11_head"];
        $this->d_11_head->AdvancedSearch->save();

        // Field description_11
        $this->description_11->AdvancedSearch->SearchValue = @$filter["x_description_11"];
        $this->description_11->AdvancedSearch->SearchOperator = @$filter["z_description_11"];
        $this->description_11->AdvancedSearch->SearchCondition = @$filter["v_description_11"];
        $this->description_11->AdvancedSearch->SearchValue2 = @$filter["y_description_11"];
        $this->description_11->AdvancedSearch->SearchOperator2 = @$filter["w_description_11"];
        $this->description_11->AdvancedSearch->save();

        // Field d_12_head
        $this->d_12_head->AdvancedSearch->SearchValue = @$filter["x_d_12_head"];
        $this->d_12_head->AdvancedSearch->SearchOperator = @$filter["z_d_12_head"];
        $this->d_12_head->AdvancedSearch->SearchCondition = @$filter["v_d_12_head"];
        $this->d_12_head->AdvancedSearch->SearchValue2 = @$filter["y_d_12_head"];
        $this->d_12_head->AdvancedSearch->SearchOperator2 = @$filter["w_d_12_head"];
        $this->d_12_head->AdvancedSearch->save();

        // Field description_12
        $this->description_12->AdvancedSearch->SearchValue = @$filter["x_description_12"];
        $this->description_12->AdvancedSearch->SearchOperator = @$filter["z_description_12"];
        $this->description_12->AdvancedSearch->SearchCondition = @$filter["v_description_12"];
        $this->description_12->AdvancedSearch->SearchValue2 = @$filter["y_description_12"];
        $this->description_12->AdvancedSearch->SearchOperator2 = @$filter["w_description_12"];
        $this->description_12->AdvancedSearch->save();

        // Field action
        $this->_action->AdvancedSearch->SearchValue = @$filter["x__action"];
        $this->_action->AdvancedSearch->SearchOperator = @$filter["z__action"];
        $this->_action->AdvancedSearch->SearchCondition = @$filter["v__action"];
        $this->_action->AdvancedSearch->SearchValue2 = @$filter["y__action"];
        $this->_action->AdvancedSearch->SearchOperator2 = @$filter["w__action"];
        $this->_action->AdvancedSearch->save();

        // Field url
        $this->url->AdvancedSearch->SearchValue = @$filter["x_url"];
        $this->url->AdvancedSearch->SearchOperator = @$filter["z_url"];
        $this->url->AdvancedSearch->SearchCondition = @$filter["v_url"];
        $this->url->AdvancedSearch->SearchValue2 = @$filter["y_url"];
        $this->url->AdvancedSearch->SearchOperator2 = @$filter["w_url"];
        $this->url->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->order_type, $default, false); // order_type
        $this->buildSearchSql($where, $this->buyer_id, $default, false); // buyer_id
        $this->buildSearchSql($where, $this->buyer_order_no, $default, false); // buyer_order_no
        $this->buildSearchSql($where, $this->buyer_order_date, $default, false); // buyer_order_date
        $this->buildSearchSql($where, $this->cart_id, $default, true); // cart_id
        $this->buildSearchSql($where, $this->buyer_product_ref, $default, false); // buyer_product_ref
        $this->buildSearchSql($where, $this->grp, $default, false); // grp
        $this->buildSearchSql($where, $this->s_grp, $default, false); // s_grp
        $this->buildSearchSql($where, $this->product, $default, false); // product
        $this->buildSearchSql($where, $this->rid, $default, false); // rid
        $this->buildSearchSql($where, $this->despatch_week, $default, false); // despatch_week
        $this->buildSearchSql($where, $this->payment_terms, $default, false); // payment_terms
        $this->buildSearchSql($where, $this->transport_terms, $default, false); // transport_terms
        $this->buildSearchSql($where, $this->buyer_shipping_id, $default, false); // buyer_shipping _id
        $this->buildSearchSql($where, $this->description_03, $default, false); // description_03
        $this->buildSearchSql($where, $this->description_07, $default, false); // description_07
        $this->buildSearchSql($where, $this->description_20, $default, false); // description_20
        $this->buildSearchSql($where, $this->description_17, $default, false); // description_17
        $this->buildSearchSql($where, $this->description_18, $default, false); // description_18
        $this->buildSearchSql($where, $this->description_19, $default, false); // description_19
        $this->buildSearchSql($where, $this->quantity, $default, false); // quantity
        $this->buildSearchSql($where, $this->price, $default, false); // price
        $this->buildSearchSql($where, $this->currency, $default, false); // currency
        $this->buildSearchSql($where, $this->amount, $default, false); // amount
        $this->buildSearchSql($where, $this->cbm, $default, false); // cbm
        $this->buildSearchSql($where, $this->buyer_size, $default, false); // buyer_size
        $this->buildSearchSql($where, $this->description_05, $default, false); // description_05
        $this->buildSearchSql($where, $this->description_06, $default, false); // description_06
        $this->buildSearchSql($where, $this->description_08, $default, false); // description_08
        $this->buildSearchSql($where, $this->remarks, $default, false); // remarks
        $this->buildSearchSql($where, $this->operator, $default, false); // operator
        $this->buildSearchSql($where, $this->datetime, $default, false); // datetime
        $this->buildSearchSql($where, $this->a_operator, $default, false); // a_operator
        $this->buildSearchSql($where, $this->a_datetime, $default, false); // a_datetime
        $this->buildSearchSql($where, $this->buyer_instruction, $default, false); // buyer_instruction
        $this->buildSearchSql($where, $this->d_09_head, $default, false); // d_09_head
        $this->buildSearchSql($where, $this->description_09, $default, false); // description_09
        $this->buildSearchSql($where, $this->d_10_head, $default, false); // d_10_head
        $this->buildSearchSql($where, $this->description_10, $default, false); // description_10
        $this->buildSearchSql($where, $this->d_11_head, $default, false); // d_11_head
        $this->buildSearchSql($where, $this->description_11, $default, false); // description_11
        $this->buildSearchSql($where, $this->d_12_head, $default, false); // d_12_head
        $this->buildSearchSql($where, $this->description_12, $default, false); // description_12
        $this->buildSearchSql($where, $this->_action, $default, false); // action
        $this->buildSearchSql($where, $this->url, $default, false); // url

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->id->AdvancedSearch->save(); // id
            $this->order_type->AdvancedSearch->save(); // order_type
            $this->buyer_id->AdvancedSearch->save(); // buyer_id
            $this->buyer_order_no->AdvancedSearch->save(); // buyer_order_no
            $this->buyer_order_date->AdvancedSearch->save(); // buyer_order_date
            $this->cart_id->AdvancedSearch->save(); // cart_id
            $this->buyer_product_ref->AdvancedSearch->save(); // buyer_product_ref
            $this->grp->AdvancedSearch->save(); // grp
            $this->s_grp->AdvancedSearch->save(); // s_grp
            $this->product->AdvancedSearch->save(); // product
            $this->rid->AdvancedSearch->save(); // rid
            $this->despatch_week->AdvancedSearch->save(); // despatch_week
            $this->payment_terms->AdvancedSearch->save(); // payment_terms
            $this->transport_terms->AdvancedSearch->save(); // transport_terms
            $this->buyer_shipping_id->AdvancedSearch->save(); // buyer_shipping _id
            $this->description_03->AdvancedSearch->save(); // description_03
            $this->description_07->AdvancedSearch->save(); // description_07
            $this->description_20->AdvancedSearch->save(); // description_20
            $this->description_17->AdvancedSearch->save(); // description_17
            $this->description_18->AdvancedSearch->save(); // description_18
            $this->description_19->AdvancedSearch->save(); // description_19
            $this->quantity->AdvancedSearch->save(); // quantity
            $this->price->AdvancedSearch->save(); // price
            $this->currency->AdvancedSearch->save(); // currency
            $this->amount->AdvancedSearch->save(); // amount
            $this->cbm->AdvancedSearch->save(); // cbm
            $this->buyer_size->AdvancedSearch->save(); // buyer_size
            $this->description_05->AdvancedSearch->save(); // description_05
            $this->description_06->AdvancedSearch->save(); // description_06
            $this->description_08->AdvancedSearch->save(); // description_08
            $this->remarks->AdvancedSearch->save(); // remarks
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->a_operator->AdvancedSearch->save(); // a_operator
            $this->a_datetime->AdvancedSearch->save(); // a_datetime
            $this->buyer_instruction->AdvancedSearch->save(); // buyer_instruction
            $this->d_09_head->AdvancedSearch->save(); // d_09_head
            $this->description_09->AdvancedSearch->save(); // description_09
            $this->d_10_head->AdvancedSearch->save(); // d_10_head
            $this->description_10->AdvancedSearch->save(); // description_10
            $this->d_11_head->AdvancedSearch->save(); // d_11_head
            $this->description_11->AdvancedSearch->save(); // description_11
            $this->d_12_head->AdvancedSearch->save(); // d_12_head
            $this->description_12->AdvancedSearch->save(); // description_12
            $this->_action->AdvancedSearch->save(); // action
            $this->url->AdvancedSearch->save(); // url

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->id->AdvancedSearch->save(); // id
            $this->order_type->AdvancedSearch->save(); // order_type
            $this->buyer_id->AdvancedSearch->save(); // buyer_id
            $this->buyer_order_no->AdvancedSearch->save(); // buyer_order_no
            $this->buyer_order_date->AdvancedSearch->save(); // buyer_order_date
            $this->cart_id->AdvancedSearch->save(); // cart_id
            $this->buyer_product_ref->AdvancedSearch->save(); // buyer_product_ref
            $this->grp->AdvancedSearch->save(); // grp
            $this->s_grp->AdvancedSearch->save(); // s_grp
            $this->product->AdvancedSearch->save(); // product
            $this->rid->AdvancedSearch->save(); // rid
            $this->despatch_week->AdvancedSearch->save(); // despatch_week
            $this->payment_terms->AdvancedSearch->save(); // payment_terms
            $this->transport_terms->AdvancedSearch->save(); // transport_terms
            $this->buyer_shipping_id->AdvancedSearch->save(); // buyer_shipping _id
            $this->description_03->AdvancedSearch->save(); // description_03
            $this->description_07->AdvancedSearch->save(); // description_07
            $this->description_20->AdvancedSearch->save(); // description_20
            $this->description_17->AdvancedSearch->save(); // description_17
            $this->description_18->AdvancedSearch->save(); // description_18
            $this->description_19->AdvancedSearch->save(); // description_19
            $this->quantity->AdvancedSearch->save(); // quantity
            $this->price->AdvancedSearch->save(); // price
            $this->currency->AdvancedSearch->save(); // currency
            $this->amount->AdvancedSearch->save(); // amount
            $this->cbm->AdvancedSearch->save(); // cbm
            $this->buyer_size->AdvancedSearch->save(); // buyer_size
            $this->description_05->AdvancedSearch->save(); // description_05
            $this->description_06->AdvancedSearch->save(); // description_06
            $this->description_08->AdvancedSearch->save(); // description_08
            $this->remarks->AdvancedSearch->save(); // remarks
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->a_operator->AdvancedSearch->save(); // a_operator
            $this->a_datetime->AdvancedSearch->save(); // a_datetime
            $this->buyer_instruction->AdvancedSearch->save(); // buyer_instruction
            $this->d_09_head->AdvancedSearch->save(); // d_09_head
            $this->description_09->AdvancedSearch->save(); // description_09
            $this->d_10_head->AdvancedSearch->save(); // d_10_head
            $this->description_10->AdvancedSearch->save(); // description_10
            $this->d_11_head->AdvancedSearch->save(); // d_11_head
            $this->description_11->AdvancedSearch->save(); // description_11
            $this->d_12_head->AdvancedSearch->save(); // d_12_head
            $this->description_12->AdvancedSearch->save(); // description_12
            $this->_action->AdvancedSearch->save(); // action
            $this->url->AdvancedSearch->save(); // url
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field id
        $filter = $this->queryBuilderWhere("id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field order_type
        $filter = $this->queryBuilderWhere("order_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->order_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->order_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_id
        $filter = $this->queryBuilderWhere("buyer_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field grp
        $filter = $this->queryBuilderWhere("grp");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->grp, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->grp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field s_grp
        $filter = $this->queryBuilderWhere("s_grp");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->s_grp, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->s_grp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field product
        $filter = $this->queryBuilderWhere("product");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->product, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->product->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field rid
        $filter = $this->queryBuilderWhere("rid");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->rid, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->rid->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field despatch_week
        $filter = $this->queryBuilderWhere("despatch_week");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->despatch_week, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->despatch_week->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field payment_terms
        $filter = $this->queryBuilderWhere("payment_terms");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->payment_terms, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->payment_terms->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field transport_terms
        $filter = $this->queryBuilderWhere("transport_terms");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->transport_terms, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->transport_terms->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_shipping _id
        $filter = $this->queryBuilderWhere("buyer_shipping _id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_shipping_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_shipping_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field description_03
        $filter = $this->queryBuilderWhere("description_03");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->description_03, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->description_03->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field description_20
        $filter = $this->queryBuilderWhere("description_20");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->description_20, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->description_20->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field description_17
        $filter = $this->queryBuilderWhere("description_17");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->description_17, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->description_17->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field description_18
        $filter = $this->queryBuilderWhere("description_18");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->description_18, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->description_18->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field description_19
        $filter = $this->queryBuilderWhere("description_19");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->description_19, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->description_19->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field quantity
        $filter = $this->queryBuilderWhere("quantity");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->quantity, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->quantity->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field price
        $filter = $this->queryBuilderWhere("price");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->price, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->price->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field amount
        $filter = $this->queryBuilderWhere("amount");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->amount, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->amount->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field cbm
        $filter = $this->queryBuilderWhere("cbm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->cbm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->cbm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_size
        $filter = $this->queryBuilderWhere("buyer_size");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_size, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_size->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field a_operator
        $filter = $this->queryBuilderWhere("a_operator");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->a_operator, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->a_operator->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field a_datetime
        $filter = $this->queryBuilderWhere("a_datetime");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->a_datetime, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->a_datetime->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field action
        $filter = $this->queryBuilderWhere("action");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_action, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_action->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->buyer_order_no;
        $searchFlds[] = &$this->cart_id;
        $searchFlds[] = &$this->buyer_product_ref;
        $searchFlds[] = &$this->part_dispatch;
        $searchFlds[] = &$this->payment_terms;
        $searchFlds[] = &$this->transport_terms;
        $searchFlds[] = &$this->description_04;
        $searchFlds[] = &$this->description_07;
        $searchFlds[] = &$this->buyer_size;
        $searchFlds[] = &$this->description_05;
        $searchFlds[] = &$this->description_06;
        $searchFlds[] = &$this->description_08;
        $searchFlds[] = &$this->remarks;
        $searchFlds[] = &$this->buyer_instruction;
        $searchFlds[] = &$this->description_09;
        $searchFlds[] = &$this->description_10;
        $searchFlds[] = &$this->description_11;
        $searchFlds[] = &$this->description_12;
        $searchFlds[] = &$this->_action;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->order_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_order_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_order_date->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cart_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_product_ref->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->s_grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->product->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->rid->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->despatch_week->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->payment_terms->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->transport_terms->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_shipping_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description_03->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description_07->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description_20->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description_17->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description_18->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description_19->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->quantity->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->price->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->currency->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->amount->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cbm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_size->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description_05->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description_06->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description_08->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->remarks->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->a_operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->a_datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_instruction->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->d_09_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description_09->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->d_10_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description_10->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->d_11_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description_11->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->d_12_head->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description_12->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_action->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->url->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->id->AdvancedSearch->unsetSession();
        $this->order_type->AdvancedSearch->unsetSession();
        $this->buyer_id->AdvancedSearch->unsetSession();
        $this->buyer_order_no->AdvancedSearch->unsetSession();
        $this->buyer_order_date->AdvancedSearch->unsetSession();
        $this->cart_id->AdvancedSearch->unsetSession();
        $this->buyer_product_ref->AdvancedSearch->unsetSession();
        $this->grp->AdvancedSearch->unsetSession();
        $this->s_grp->AdvancedSearch->unsetSession();
        $this->product->AdvancedSearch->unsetSession();
        $this->rid->AdvancedSearch->unsetSession();
        $this->despatch_week->AdvancedSearch->unsetSession();
        $this->payment_terms->AdvancedSearch->unsetSession();
        $this->transport_terms->AdvancedSearch->unsetSession();
        $this->buyer_shipping_id->AdvancedSearch->unsetSession();
        $this->description_03->AdvancedSearch->unsetSession();
        $this->description_07->AdvancedSearch->unsetSession();
        $this->description_20->AdvancedSearch->unsetSession();
        $this->description_17->AdvancedSearch->unsetSession();
        $this->description_18->AdvancedSearch->unsetSession();
        $this->description_19->AdvancedSearch->unsetSession();
        $this->quantity->AdvancedSearch->unsetSession();
        $this->price->AdvancedSearch->unsetSession();
        $this->currency->AdvancedSearch->unsetSession();
        $this->amount->AdvancedSearch->unsetSession();
        $this->cbm->AdvancedSearch->unsetSession();
        $this->buyer_size->AdvancedSearch->unsetSession();
        $this->description_05->AdvancedSearch->unsetSession();
        $this->description_06->AdvancedSearch->unsetSession();
        $this->description_08->AdvancedSearch->unsetSession();
        $this->remarks->AdvancedSearch->unsetSession();
        $this->operator->AdvancedSearch->unsetSession();
        $this->datetime->AdvancedSearch->unsetSession();
        $this->a_operator->AdvancedSearch->unsetSession();
        $this->a_datetime->AdvancedSearch->unsetSession();
        $this->buyer_instruction->AdvancedSearch->unsetSession();
        $this->d_09_head->AdvancedSearch->unsetSession();
        $this->description_09->AdvancedSearch->unsetSession();
        $this->d_10_head->AdvancedSearch->unsetSession();
        $this->description_10->AdvancedSearch->unsetSession();
        $this->d_11_head->AdvancedSearch->unsetSession();
        $this->description_11->AdvancedSearch->unsetSession();
        $this->d_12_head->AdvancedSearch->unsetSession();
        $this->description_12->AdvancedSearch->unsetSession();
        $this->_action->AdvancedSearch->unsetSession();
        $this->url->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->id->AdvancedSearch->load();
        $this->order_type->AdvancedSearch->load();
        $this->buyer_id->AdvancedSearch->load();
        $this->buyer_order_no->AdvancedSearch->load();
        $this->buyer_order_date->AdvancedSearch->load();
        $this->cart_id->AdvancedSearch->load();
        $this->buyer_product_ref->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->rid->AdvancedSearch->load();
        $this->despatch_week->AdvancedSearch->load();
        $this->payment_terms->AdvancedSearch->load();
        $this->transport_terms->AdvancedSearch->load();
        $this->buyer_shipping_id->AdvancedSearch->load();
        $this->description_03->AdvancedSearch->load();
        $this->description_07->AdvancedSearch->load();
        $this->description_20->AdvancedSearch->load();
        $this->description_17->AdvancedSearch->load();
        $this->description_18->AdvancedSearch->load();
        $this->description_19->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->price->AdvancedSearch->load();
        $this->currency->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->buyer_size->AdvancedSearch->load();
        $this->description_05->AdvancedSearch->load();
        $this->description_06->AdvancedSearch->load();
        $this->description_08->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->a_operator->AdvancedSearch->load();
        $this->a_datetime->AdvancedSearch->load();
        $this->buyer_instruction->AdvancedSearch->load();
        $this->d_09_head->AdvancedSearch->load();
        $this->description_09->AdvancedSearch->load();
        $this->d_10_head->AdvancedSearch->load();
        $this->description_10->AdvancedSearch->load();
        $this->d_11_head->AdvancedSearch->load();
        $this->description_11->AdvancedSearch->load();
        $this->d_12_head->AdvancedSearch->load();
        $this->description_12->AdvancedSearch->load();
        $this->_action->AdvancedSearch->load();
        $this->url->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = ""; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for Ctrl pressed
        $ctrl = Get("ctrl") !== null;

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id, $ctrl); // id
            $this->updateSort($this->order_type, $ctrl); // order_type
            $this->updateSort($this->buyer_id, $ctrl); // buyer_id
            $this->updateSort($this->grp, $ctrl); // grp
            $this->updateSort($this->s_grp, $ctrl); // s_grp
            $this->updateSort($this->product, $ctrl); // product
            $this->updateSort($this->rid, $ctrl); // rid
            $this->updateSort($this->despatch_date, $ctrl); // despatch_date
            $this->updateSort($this->despatch_week, $ctrl); // despatch_week
            $this->updateSort($this->fob_date, $ctrl); // fob_date
            $this->updateSort($this->payment_terms, $ctrl); // payment_terms
            $this->updateSort($this->transport_terms, $ctrl); // transport_terms
            $this->updateSort($this->buyer_shipping_id, $ctrl); // buyer_shipping _id
            $this->updateSort($this->description_04, $ctrl); // description_04
            $this->updateSort($this->description_03, $ctrl); // description_03
            $this->updateSort($this->description_20, $ctrl); // description_20
            $this->updateSort($this->description_17, $ctrl); // description_17
            $this->updateSort($this->description_18, $ctrl); // description_18
            $this->updateSort($this->description_19, $ctrl); // description_19
            $this->updateSort($this->quantity, $ctrl); // quantity
            $this->updateSort($this->price, $ctrl); // price
            $this->updateSort($this->amount, $ctrl); // amount
            $this->updateSort($this->cbm, $ctrl); // cbm
            $this->updateSort($this->buyer_size, $ctrl); // buyer_size
            $this->updateSort($this->a_operator, $ctrl); // a_operator
            $this->updateSort($this->a_datetime, $ctrl); // a_datetime
            $this->updateSort($this->_action, $ctrl); // action
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->id->setSort("");
                $this->order_type->setSort("");
                $this->buyer_id->setSort("");
                $this->buyer_order_no->setSort("");
                $this->buyer_order_date->setSort("");
                $this->cart_id->setSort("");
                $this->buyer_product_ref->setSort("");
                $this->grp->setSort("");
                $this->s_grp->setSort("");
                $this->product->setSort("");
                $this->rid->setSort("");
                $this->despatch_date->setSort("");
                $this->despatch_week->setSort("");
                $this->fob_date->setSort("");
                $this->part_dispatch->setSort("");
                $this->payment_terms->setSort("");
                $this->transport_terms->setSort("");
                $this->buyer_shipping_id->setSort("");
                $this->description_04->setSort("");
                $this->description_03->setSort("");
                $this->description_01->setSort("");
                $this->description_02->setSort("");
                $this->description_07->setSort("");
                $this->description_20->setSort("");
                $this->description_17->setSort("");
                $this->description_18->setSort("");
                $this->description_19->setSort("");
                $this->quantity->setSort("");
                $this->price->setSort("");
                $this->currency->setSort("");
                $this->amount->setSort("");
                $this->cbm->setSort("");
                $this->buyer_size->setSort("");
                $this->description_05->setSort("");
                $this->description_06->setSort("");
                $this->description_08->setSort("");
                $this->remarks->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
                $this->a_operator->setSort("");
                $this->a_datetime->setSort("");
                $this->jc_no->setSort("");
                $this->buyer_instruction->setSort("");
                $this->d_09_head->setSort("");
                $this->description_09->setSort("");
                $this->d_10_head->setSort("");
                $this->description_10->setSort("");
                $this->d_11_head->setSort("");
                $this->description_11->setSort("");
                $this->d_12_head->setSort("");
                $this->description_12->setSort("");
                $this->po->setSort("");
                $this->production_site->setSort("");
                $this->c_total->setSort("");
                $this->production_plan->setSort("");
                $this->lot_no->setSort("");
                $this->product_gcode->setSort("");
                $this->batch_no->setSort("");
                $this->uploads->setSort("");
                $this->d_01_head->setSort("");
                $this->d_02_head->setSort("");
                $this->d_03_head->setSort("");
                $this->d_04_head->setSort("");
                $this->d_05_head->setSort("");
                $this->d_06_head->setSort("");
                $this->d_07_head->setSort("");
                $this->d_08_head->setSort("");
                $this->sample->setSort("");
                $this->balance_quantity->setSort("");
                $this->_action->setSort("");
                $this->url->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"po\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fpolist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fpolist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"po\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "order_type");
            $this->createColumnOption($option, "buyer_id");
            $this->createColumnOption($option, "grp");
            $this->createColumnOption($option, "s_grp");
            $this->createColumnOption($option, "product");
            $this->createColumnOption($option, "rid");
            $this->createColumnOption($option, "despatch_date");
            $this->createColumnOption($option, "despatch_week");
            $this->createColumnOption($option, "fob_date");
            $this->createColumnOption($option, "payment_terms");
            $this->createColumnOption($option, "transport_terms");
            $this->createColumnOption($option, "buyer_shipping _id");
            $this->createColumnOption($option, "description_04");
            $this->createColumnOption($option, "description_03");
            $this->createColumnOption($option, "description_20");
            $this->createColumnOption($option, "description_17");
            $this->createColumnOption($option, "description_18");
            $this->createColumnOption($option, "description_19");
            $this->createColumnOption($option, "quantity");
            $this->createColumnOption($option, "price");
            $this->createColumnOption($option, "amount");
            $this->createColumnOption($option, "cbm");
            $this->createColumnOption($option, "buyer_size");
            $this->createColumnOption($option, "a_operator");
            $this->createColumnOption($option, "a_datetime");
            $this->createColumnOption($option, "action");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fposrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fposrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fpolist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_po", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_po",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // order_type
        if ($this->order_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->order_type->AdvancedSearch->SearchValue != "" || $this->order_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_id
        if ($this->buyer_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_id->AdvancedSearch->SearchValue != "" || $this->buyer_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_order_no
        if ($this->buyer_order_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_order_no->AdvancedSearch->SearchValue != "" || $this->buyer_order_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_order_date
        if ($this->buyer_order_date->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_order_date->AdvancedSearch->SearchValue != "" || $this->buyer_order_date->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cart_id
        if ($this->cart_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cart_id->AdvancedSearch->SearchValue != "" || $this->cart_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->cart_id->AdvancedSearch->SearchValue)) {
            $this->cart_id->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->cart_id->AdvancedSearch->SearchValue);
        }
        if (is_array($this->cart_id->AdvancedSearch->SearchValue2)) {
            $this->cart_id->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->cart_id->AdvancedSearch->SearchValue2);
        }

        // buyer_product_ref
        if ($this->buyer_product_ref->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_product_ref->AdvancedSearch->SearchValue != "" || $this->buyer_product_ref->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->grp->AdvancedSearch->SearchValue != "" || $this->grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // s_grp
        if ($this->s_grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->s_grp->AdvancedSearch->SearchValue != "" || $this->s_grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // product
        if ($this->product->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->product->AdvancedSearch->SearchValue != "" || $this->product->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // rid
        if ($this->rid->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->rid->AdvancedSearch->SearchValue != "" || $this->rid->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // despatch_week
        if ($this->despatch_week->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->despatch_week->AdvancedSearch->SearchValue != "" || $this->despatch_week->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // payment_terms
        if ($this->payment_terms->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->payment_terms->AdvancedSearch->SearchValue != "" || $this->payment_terms->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // transport_terms
        if ($this->transport_terms->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->transport_terms->AdvancedSearch->SearchValue != "" || $this->transport_terms->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_shipping _id
        if ($this->buyer_shipping_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_shipping_id->AdvancedSearch->SearchValue != "" || $this->buyer_shipping_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description_03
        if ($this->description_03->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description_03->AdvancedSearch->SearchValue != "" || $this->description_03->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description_07
        if ($this->description_07->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description_07->AdvancedSearch->SearchValue != "" || $this->description_07->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description_20
        if ($this->description_20->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description_20->AdvancedSearch->SearchValue != "" || $this->description_20->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description_17
        if ($this->description_17->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description_17->AdvancedSearch->SearchValue != "" || $this->description_17->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description_18
        if ($this->description_18->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description_18->AdvancedSearch->SearchValue != "" || $this->description_18->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description_19
        if ($this->description_19->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description_19->AdvancedSearch->SearchValue != "" || $this->description_19->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->quantity->AdvancedSearch->SearchValue != "" || $this->quantity->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // price
        if ($this->price->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->price->AdvancedSearch->SearchValue != "" || $this->price->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // currency
        if ($this->currency->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->currency->AdvancedSearch->SearchValue != "" || $this->currency->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // amount
        if ($this->amount->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->amount->AdvancedSearch->SearchValue != "" || $this->amount->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cbm
        if ($this->cbm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cbm->AdvancedSearch->SearchValue != "" || $this->cbm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_size
        if ($this->buyer_size->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_size->AdvancedSearch->SearchValue != "" || $this->buyer_size->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description_05
        if ($this->description_05->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description_05->AdvancedSearch->SearchValue != "" || $this->description_05->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description_06
        if ($this->description_06->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description_06->AdvancedSearch->SearchValue != "" || $this->description_06->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description_08
        if ($this->description_08->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description_08->AdvancedSearch->SearchValue != "" || $this->description_08->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->remarks->AdvancedSearch->SearchValue != "" || $this->remarks->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator->AdvancedSearch->SearchValue != "" || $this->operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime->AdvancedSearch->SearchValue != "" || $this->datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // a_operator
        if ($this->a_operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->a_operator->AdvancedSearch->SearchValue != "" || $this->a_operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // a_datetime
        if ($this->a_datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->a_datetime->AdvancedSearch->SearchValue != "" || $this->a_datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_instruction
        if ($this->buyer_instruction->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_instruction->AdvancedSearch->SearchValue != "" || $this->buyer_instruction->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // d_09_head
        if ($this->d_09_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->d_09_head->AdvancedSearch->SearchValue != "" || $this->d_09_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description_09
        if ($this->description_09->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description_09->AdvancedSearch->SearchValue != "" || $this->description_09->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // d_10_head
        if ($this->d_10_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->d_10_head->AdvancedSearch->SearchValue != "" || $this->d_10_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description_10
        if ($this->description_10->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description_10->AdvancedSearch->SearchValue != "" || $this->description_10->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // d_11_head
        if ($this->d_11_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->d_11_head->AdvancedSearch->SearchValue != "" || $this->d_11_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description_11
        if ($this->description_11->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description_11->AdvancedSearch->SearchValue != "" || $this->description_11->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // d_12_head
        if ($this->d_12_head->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->d_12_head->AdvancedSearch->SearchValue != "" || $this->d_12_head->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description_12
        if ($this->description_12->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description_12->AdvancedSearch->SearchValue != "" || $this->description_12->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // action
        if ($this->_action->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_action->AdvancedSearch->SearchValue != "" || $this->_action->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // url
        if ($this->url->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->url->AdvancedSearch->SearchValue != "" || $this->url->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->order_type->setDbValue($row['order_type']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->buyer_order_no->setDbValue($row['buyer_order_no']);
        $this->buyer_order_date->setDbValue($row['buyer_order_date']);
        $this->cart_id->setDbValue($row['cart_id']);
        $this->buyer_product_ref->setDbValue($row['buyer_product_ref']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->fob_date->setDbValue($row['fob_date']);
        $this->part_dispatch->setDbValue($row['part_dispatch']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->transport_terms->setDbValue($row['transport_terms']);
        $this->buyer_shipping_id->setDbValue($row['buyer_shipping _id']);
        $this->description_04->setDbValue($row['description_04']);
        $this->description_03->setDbValue($row['description_03']);
        $this->description_01->setDbValue($row['description_01']);
        $this->description_02->setDbValue($row['description_02']);
        $this->description_07->setDbValue($row['description_07']);
        $this->description_20->setDbValue($row['description_20']);
        $this->description_17->setDbValue($row['description_17']);
        $this->description_18->setDbValue($row['description_18']);
        $this->description_19->setDbValue($row['description_19']);
        $this->quantity->setDbValue($row['quantity']);
        $this->price->setDbValue($row['price']);
        $this->currency->setDbValue($row['currency']);
        $this->amount->setDbValue($row['amount']);
        $this->cbm->setDbValue($row['cbm']);
        $this->buyer_size->setDbValue($row['buyer_size']);
        $this->description_05->setDbValue($row['description_05']);
        $this->description_06->setDbValue($row['description_06']);
        $this->description_08->setDbValue($row['description_08']);
        $this->remarks->setDbValue($row['remarks']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->buyer_instruction->setDbValue($row['buyer_instruction']);
        $this->d_09_head->setDbValue($row['d_09_head']);
        $this->description_09->setDbValue($row['description_09']);
        $this->d_10_head->setDbValue($row['d_10_head']);
        $this->description_10->setDbValue($row['description_10']);
        $this->d_11_head->setDbValue($row['d_11_head']);
        $this->description_11->setDbValue($row['description_11']);
        $this->d_12_head->setDbValue($row['d_12_head']);
        $this->description_12->setDbValue($row['description_12']);
        $this->po->setDbValue($row['po']);
        $this->production_site->setDbValue($row['production_site']);
        $this->c_total->setDbValue($row['c_total']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->product_gcode->setDbValue($row['product_gcode']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->uploads->setDbValue($row['uploads']);
        $this->d_01_head->setDbValue($row['d_01_head']);
        $this->d_02_head->setDbValue($row['d_02_head']);
        $this->d_03_head->setDbValue($row['d_03_head']);
        $this->d_04_head->setDbValue($row['d_04_head']);
        $this->d_05_head->setDbValue($row['d_05_head']);
        $this->d_06_head->setDbValue($row['d_06_head']);
        $this->d_07_head->setDbValue($row['d_07_head']);
        $this->d_08_head->setDbValue($row['d_08_head']);
        $this->sample->setDbValue($row['sample']);
        $this->balance_quantity->setDbValue($row['balance_quantity']);
        $this->_action->setDbValue($row['action']);
        $this->url->setDbValue($row['url']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['order_type'] = $this->order_type->DefaultValue;
        $row['buyer_id'] = $this->buyer_id->DefaultValue;
        $row['buyer_order_no'] = $this->buyer_order_no->DefaultValue;
        $row['buyer_order_date'] = $this->buyer_order_date->DefaultValue;
        $row['cart_id'] = $this->cart_id->DefaultValue;
        $row['buyer_product_ref'] = $this->buyer_product_ref->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['despatch_week'] = $this->despatch_week->DefaultValue;
        $row['fob_date'] = $this->fob_date->DefaultValue;
        $row['part_dispatch'] = $this->part_dispatch->DefaultValue;
        $row['payment_terms'] = $this->payment_terms->DefaultValue;
        $row['transport_terms'] = $this->transport_terms->DefaultValue;
        $row['buyer_shipping _id'] = $this->buyer_shipping_id->DefaultValue;
        $row['description_04'] = $this->description_04->DefaultValue;
        $row['description_03'] = $this->description_03->DefaultValue;
        $row['description_01'] = $this->description_01->DefaultValue;
        $row['description_02'] = $this->description_02->DefaultValue;
        $row['description_07'] = $this->description_07->DefaultValue;
        $row['description_20'] = $this->description_20->DefaultValue;
        $row['description_17'] = $this->description_17->DefaultValue;
        $row['description_18'] = $this->description_18->DefaultValue;
        $row['description_19'] = $this->description_19->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['buyer_size'] = $this->buyer_size->DefaultValue;
        $row['description_05'] = $this->description_05->DefaultValue;
        $row['description_06'] = $this->description_06->DefaultValue;
        $row['description_08'] = $this->description_08->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['a_datetime'] = $this->a_datetime->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['buyer_instruction'] = $this->buyer_instruction->DefaultValue;
        $row['d_09_head'] = $this->d_09_head->DefaultValue;
        $row['description_09'] = $this->description_09->DefaultValue;
        $row['d_10_head'] = $this->d_10_head->DefaultValue;
        $row['description_10'] = $this->description_10->DefaultValue;
        $row['d_11_head'] = $this->d_11_head->DefaultValue;
        $row['description_11'] = $this->description_11->DefaultValue;
        $row['d_12_head'] = $this->d_12_head->DefaultValue;
        $row['description_12'] = $this->description_12->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['production_site'] = $this->production_site->DefaultValue;
        $row['c_total'] = $this->c_total->DefaultValue;
        $row['production_plan'] = $this->production_plan->DefaultValue;
        $row['lot_no'] = $this->lot_no->DefaultValue;
        $row['product_gcode'] = $this->product_gcode->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['uploads'] = $this->uploads->DefaultValue;
        $row['d_01_head'] = $this->d_01_head->DefaultValue;
        $row['d_02_head'] = $this->d_02_head->DefaultValue;
        $row['d_03_head'] = $this->d_03_head->DefaultValue;
        $row['d_04_head'] = $this->d_04_head->DefaultValue;
        $row['d_05_head'] = $this->d_05_head->DefaultValue;
        $row['d_06_head'] = $this->d_06_head->DefaultValue;
        $row['d_07_head'] = $this->d_07_head->DefaultValue;
        $row['d_08_head'] = $this->d_08_head->DefaultValue;
        $row['sample'] = $this->sample->DefaultValue;
        $row['balance_quantity'] = $this->balance_quantity->DefaultValue;
        $row['action'] = $this->_action->DefaultValue;
        $row['url'] = $this->url->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // order_type

        // buyer_id

        // buyer_order_no

        // buyer_order_date

        // cart_id

        // buyer_product_ref

        // grp

        // s_grp

        // product

        // rid

        // despatch_date

        // despatch_week

        // fob_date

        // part_dispatch

        // payment_terms

        // transport_terms

        // buyer_shipping _id

        // description_04

        // description_03

        // description_01
        $this->description_01->CellCssStyle = "white-space: nowrap;";

        // description_02
        $this->description_02->CellCssStyle = "white-space: nowrap;";

        // description_07

        // description_20

        // description_17

        // description_18

        // description_19

        // quantity

        // price

        // currency
        $this->currency->CellCssStyle = "white-space: nowrap;";

        // amount

        // cbm

        // buyer_size

        // description_05

        // description_06

        // description_08

        // remarks

        // operator

        // datetime

        // a_operator

        // a_datetime

        // jc_no
        $this->jc_no->CellCssStyle = "white-space: nowrap;";

        // buyer_instruction

        // d_09_head

        // description_09

        // d_10_head

        // description_10

        // d_11_head

        // description_11

        // d_12_head

        // description_12

        // po
        $this->po->CellCssStyle = "white-space: nowrap;";

        // production_site
        $this->production_site->CellCssStyle = "white-space: nowrap;";

        // c_total
        $this->c_total->CellCssStyle = "white-space: nowrap;";

        // production_plan
        $this->production_plan->CellCssStyle = "white-space: nowrap;";

        // lot_no
        $this->lot_no->CellCssStyle = "white-space: nowrap;";

        // product_gcode
        $this->product_gcode->CellCssStyle = "white-space: nowrap;";

        // batch_no
        $this->batch_no->CellCssStyle = "white-space: nowrap;";

        // uploads
        $this->uploads->CellCssStyle = "white-space: nowrap;";

        // d_01_head
        $this->d_01_head->CellCssStyle = "white-space: nowrap;";

        // d_02_head
        $this->d_02_head->CellCssStyle = "white-space: nowrap;";

        // d_03_head
        $this->d_03_head->CellCssStyle = "white-space: nowrap;";

        // d_04_head
        $this->d_04_head->CellCssStyle = "white-space: nowrap;";

        // d_05_head
        $this->d_05_head->CellCssStyle = "white-space: nowrap;";

        // d_06_head
        $this->d_06_head->CellCssStyle = "white-space: nowrap;";

        // d_07_head
        $this->d_07_head->CellCssStyle = "white-space: nowrap;";

        // d_08_head
        $this->d_08_head->CellCssStyle = "white-space: nowrap;";

        // sample
        $this->sample->CellCssStyle = "white-space: nowrap;";

        // balance_quantity
        $this->balance_quantity->CellCssStyle = "white-space: nowrap;";

        // action

        // url
        $this->url->CellCssStyle = "white-space: nowrap;";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // order_type
            if (strval($this->order_type->CurrentValue) != "") {
                $this->order_type->ViewValue = $this->order_type->optionCaption($this->order_type->CurrentValue);
            } else {
                $this->order_type->ViewValue = null;
            }

            // buyer_id
            $curVal = strval($this->buyer_id->CurrentValue);
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
                if ($this->buyer_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                    } else {
                        $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
                    }
                }
            } else {
                $this->buyer_id->ViewValue = null;
            }

            // buyer_order_no
            $this->buyer_order_no->ViewValue = $this->buyer_order_no->CurrentValue;

            // buyer_order_date
            $this->buyer_order_date->ViewValue = $this->buyer_order_date->CurrentValue;
            $this->buyer_order_date->ViewValue = FormatDateTime($this->buyer_order_date->ViewValue, $this->buyer_order_date->formatPattern());

            // buyer_product_ref
            $this->buyer_product_ref->ViewValue = $this->buyer_product_ref->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // despatch_date
            $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // fob_date
            $this->fob_date->ViewValue = $this->fob_date->CurrentValue;
            $this->fob_date->ViewValue = FormatDateTime($this->fob_date->ViewValue, $this->fob_date->formatPattern());

            // payment_terms
            $curVal = strval($this->payment_terms->CurrentValue);
            if ($curVal != "") {
                $this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
                if ($this->payment_terms->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                    $sqlWrk = $this->payment_terms->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment_terms->Lookup->renderViewRow($rswrk[0]);
                        $this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
                    } else {
                        $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
                    }
                }
            } else {
                $this->payment_terms->ViewValue = null;
            }

            // transport_terms
            $this->transport_terms->ViewValue = $this->transport_terms->CurrentValue;

            // buyer_shipping _id
            $this->buyer_shipping_id->ViewValue = $this->buyer_shipping_id->CurrentValue;
            $this->buyer_shipping_id->ViewValue = FormatNumber($this->buyer_shipping_id->ViewValue, $this->buyer_shipping_id->formatPattern());

            // description_04
            $this->description_04->ViewValue = $this->description_04->CurrentValue;

            // description_03
            if (strval($this->description_03->CurrentValue) != "") {
                $this->description_03->ViewValue = $this->description_03->optionCaption($this->description_03->CurrentValue);
            } else {
                $this->description_03->ViewValue = null;
            }

            // description_07
            $this->description_07->ViewValue = $this->description_07->CurrentValue;

            // description_20
            if (strval($this->description_20->CurrentValue) != "") {
                $this->description_20->ViewValue = $this->description_20->optionCaption($this->description_20->CurrentValue);
            } else {
                $this->description_20->ViewValue = null;
            }

            // description_17
            $this->description_17->ViewValue = $this->description_17->CurrentValue;
            $this->description_17->ViewValue = FormatNumber($this->description_17->ViewValue, $this->description_17->formatPattern());

            // description_18
            $this->description_18->ViewValue = $this->description_18->CurrentValue;
            $this->description_18->ViewValue = FormatNumber($this->description_18->ViewValue, $this->description_18->formatPattern());

            // description_19
            $this->description_19->ViewValue = $this->description_19->CurrentValue;
            $this->description_19->ViewValue = FormatNumber($this->description_19->ViewValue, $this->description_19->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // buyer_size
            $this->buyer_size->ViewValue = $this->buyer_size->CurrentValue;

            // description_05
            $curVal = strval($this->description_05->CurrentValue);
            if ($curVal != "") {
                $this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
                if ($this->description_05->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->description_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->description_05->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->description_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->description_05->Lookup->renderViewRow($rswrk[0]);
                        $this->description_05->ViewValue = $this->description_05->displayValue($arwrk);
                    } else {
                        $this->description_05->ViewValue = $this->description_05->CurrentValue;
                    }
                }
            } else {
                $this->description_05->ViewValue = null;
            }

            // description_06
            $this->description_06->ViewValue = $this->description_06->CurrentValue;

            // description_08
            $this->description_08->ViewValue = $this->description_08->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // a_operator
            $curVal = strval($this->a_operator->CurrentValue);
            if ($curVal != "") {
                $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
                if ($this->a_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                    } else {
                        $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
                    }
                }
            } else {
                $this->a_operator->ViewValue = null;
            }

            // a_datetime
            $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
            $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

            // d_09_head
            $curVal = strval($this->d_09_head->CurrentValue);
            if ($curVal != "") {
                $this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
                if ($this->d_09_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_09_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_09_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_09_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_09_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_09_head->ViewValue = $this->d_09_head->displayValue($arwrk);
                    } else {
                        $this->d_09_head->ViewValue = $this->d_09_head->CurrentValue;
                    }
                }
            } else {
                $this->d_09_head->ViewValue = null;
            }

            // description_09
            $this->description_09->ViewValue = $this->description_09->CurrentValue;

            // d_10_head
            $curVal = strval($this->d_10_head->CurrentValue);
            if ($curVal != "") {
                $this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
                if ($this->d_10_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_10_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_10_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_10_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_10_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_10_head->ViewValue = $this->d_10_head->displayValue($arwrk);
                    } else {
                        $this->d_10_head->ViewValue = $this->d_10_head->CurrentValue;
                    }
                }
            } else {
                $this->d_10_head->ViewValue = null;
            }

            // description_10
            $this->description_10->ViewValue = $this->description_10->CurrentValue;

            // d_11_head
            $curVal = strval($this->d_11_head->CurrentValue);
            if ($curVal != "") {
                $this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
                if ($this->d_11_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_11_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_11_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_11_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_11_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_11_head->ViewValue = $this->d_11_head->displayValue($arwrk);
                    } else {
                        $this->d_11_head->ViewValue = $this->d_11_head->CurrentValue;
                    }
                }
            } else {
                $this->d_11_head->ViewValue = null;
            }

            // description_11
            $this->description_11->ViewValue = $this->description_11->CurrentValue;

            // d_12_head
            $curVal = strval($this->d_12_head->CurrentValue);
            if ($curVal != "") {
                $this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
                if ($this->d_12_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_12_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_12_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_12_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_12_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_12_head->ViewValue = $this->d_12_head->displayValue($arwrk);
                    } else {
                        $this->d_12_head->ViewValue = $this->d_12_head->CurrentValue;
                    }
                }
            } else {
                $this->d_12_head->ViewValue = null;
            }

            // description_12
            $this->description_12->ViewValue = $this->description_12->CurrentValue;

            // action
            $this->_action->ViewValue = $this->_action->CurrentValue;
            $this->_action->CssClass = "fw-bold";
            $this->_action->ViewCustomAttributes = $this->_action->getViewCustomAttributes(); // PHP

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->id->ViewValue = $this->highlightValue($this->id);
            }

            // order_type
            $this->order_type->HrefValue = "";
            $this->order_type->TooltipValue = "";

            // buyer_id
            $this->buyer_id->HrefValue = "";
            $this->buyer_id->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }
            $this->s_grp->TooltipValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }
            $this->product->TooltipValue = "";

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }
            $this->rid->TooltipValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";
            $this->despatch_date->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";
            $this->despatch_week->TooltipValue = "";

            // fob_date
            $this->fob_date->HrefValue = "";
            $this->fob_date->TooltipValue = "";

            // payment_terms
            $this->payment_terms->HrefValue = "";
            $this->payment_terms->TooltipValue = "";

            // transport_terms
            $this->transport_terms->HrefValue = "";
            $this->transport_terms->TooltipValue = "";
            if (!$this->isExport()) {
                $this->transport_terms->ViewValue = $this->highlightValue($this->transport_terms);
            }

            // buyer_shipping _id
            $this->buyer_shipping_id->HrefValue = "";
            $this->buyer_shipping_id->TooltipValue = "";

            // description_04
            $this->description_04->HrefValue = "";
            $this->description_04->TooltipValue = "";
            if (!$this->isExport()) {
                $this->description_04->ViewValue = $this->highlightValue($this->description_04);
            }

            // description_03
            $this->description_03->HrefValue = "";
            $this->description_03->TooltipValue = "";

            // description_20
            $this->description_20->HrefValue = "";
            $this->description_20->TooltipValue = "";

            // description_17
            $this->description_17->HrefValue = "";
            $this->description_17->TooltipValue = "";

            // description_18
            $this->description_18->HrefValue = "";
            $this->description_18->TooltipValue = "";

            // description_19
            $this->description_19->HrefValue = "";
            $this->description_19->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // price
            $this->price->HrefValue = "";
            $this->price->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";

            // buyer_size
            $this->buyer_size->HrefValue = "";
            $this->buyer_size->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_size->ViewValue = $this->highlightValue($this->buyer_size);
            }

            // a_operator
            $this->a_operator->HrefValue = "";
            $this->a_operator->TooltipValue = "";

            // a_datetime
            $this->a_datetime->HrefValue = "";
            $this->a_datetime->TooltipValue = "";
            if (!$this->isExport()) {
                $this->a_datetime->ViewValue = $this->highlightValue($this->a_datetime);
            }

            // action
            if (!EmptyValue($this->url->CurrentValue)) {
                $this->_action->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
                $this->_action->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->_action->HrefValue = FullUrl($this->_action->HrefValue, "href");
                }
            } else {
                $this->_action->HrefValue = "";
            }
            $this->_action->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_action->ViewValue = $this->highlightValue($this->_action);
            }
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->order_type->AdvancedSearch->load();
        $this->buyer_id->AdvancedSearch->load();
        $this->buyer_order_no->AdvancedSearch->load();
        $this->buyer_order_date->AdvancedSearch->load();
        $this->cart_id->AdvancedSearch->load();
        $this->buyer_product_ref->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->rid->AdvancedSearch->load();
        $this->despatch_week->AdvancedSearch->load();
        $this->payment_terms->AdvancedSearch->load();
        $this->transport_terms->AdvancedSearch->load();
        $this->buyer_shipping_id->AdvancedSearch->load();
        $this->description_03->AdvancedSearch->load();
        $this->description_07->AdvancedSearch->load();
        $this->description_20->AdvancedSearch->load();
        $this->description_17->AdvancedSearch->load();
        $this->description_18->AdvancedSearch->load();
        $this->description_19->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->price->AdvancedSearch->load();
        $this->currency->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->buyer_size->AdvancedSearch->load();
        $this->description_05->AdvancedSearch->load();
        $this->description_06->AdvancedSearch->load();
        $this->description_08->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->a_operator->AdvancedSearch->load();
        $this->a_datetime->AdvancedSearch->load();
        $this->buyer_instruction->AdvancedSearch->load();
        $this->d_09_head->AdvancedSearch->load();
        $this->description_09->AdvancedSearch->load();
        $this->d_10_head->AdvancedSearch->load();
        $this->description_10->AdvancedSearch->load();
        $this->d_11_head->AdvancedSearch->load();
        $this->description_11->AdvancedSearch->load();
        $this->d_12_head->AdvancedSearch->load();
        $this->description_12->AdvancedSearch->load();
        $this->_action->AdvancedSearch->load();
        $this->url->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fpolist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fpolist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fpolist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fpolist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = false;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"po\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"posearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"posearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"fposrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_order_type":
                    break;
                case "x_buyer_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_cart_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_despatch_week":
                    break;
                case "x_part_dispatch":
                    break;
                case "x_payment_terms":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_04":
                    break;
                case "x_description_03":
                    break;
                case "x_description_20":
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_a_operator":
                    break;
                case "x_d_09_head":
                    break;
                case "x_d_10_head":
                    break;
                case "x_d_11_head":
                    break;
                case "x_d_12_head":
                    break;
                case "x_production_site":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_production_plan":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'po');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
